/* This file is autogenerated */

#include <schroedinger/schrotables.h>

const float schro_tables_wavelet_noise_curve[SCHRO_N_WAVELETS][8][128] = {
{
  { /* wavelet type 0, n_levels 1, high */
    0.000574, 0.000419, 0.000419, 0.000421,
    0.000426, 0.000435, 0.000451, 0.000475,
    0.000516, 0.000575, 0.000658, 0.000771,
    0.000920, 0.001114, 0.001357, 0.001665,
    0.002044, 0.002493, 0.003035, 0.003683,
    0.004481, 0.005355, 0.006493, 0.007623,
    0.009025, 0.010581, 0.012401, 0.014401,
    0.016705, 0.019196, 0.022019, 0.025064,
    0.028258, 0.031925, 0.035914, 0.040316,
    0.044941, 0.049618, 0.054841, 0.060577,
    0.066367, 0.072405, 0.079775, 0.086156,
    0.092870, 0.101068, 0.108124, 0.115877,
    0.123644, 0.131757, 0.140603, 0.147980,
    0.157224, 0.165461, 0.173690, 0.183054,
    0.190249, 0.198556, 0.207624, 0.213571,
    0.222516, 0.229930, 0.235654, 0.243279,
    0.249072, 0.255464, 0.260016, 0.266553,
    0.271044, 0.273611, 0.279935, 0.281699,
    0.284500, 0.288692, 0.289452, 0.291363,
    0.293102, 0.292624, 0.295046, 0.294121,
    0.294116, 0.294416, 0.293891, 0.294561,
    0.291195, 0.291388, 0.291374, 0.286807,
    0.285627, 0.284520, 0.281745, 0.280172,
    0.279749, 0.277635, 0.274919, 0.272721,
    0.270717, 0.270279, 0.268429, 0.266318,
    0.265018, 0.262580, 0.261398, 0.259272,
    0.258818, 0.257296, 0.259137, 0.254028,
    0.254421, 0.253685, 0.252507, 0.252336,
    0.252607, 0.252498, 0.252334, 0.251203,
    0.249662, 0.250503, 0.251116, 0.249652,
    0.251298, 0.248460, 0.249173, 0.250587,
    0.250904, 0.250140, 0.250497, 0.250168,
  },
  { /* wavelet type 0, n_levels 1, low */
    1.004448, 1.000726, 1.002665, 1.004558,
    0.997625, 0.999695, 1.001262, 0.996124,
    0.997137, 1.001106, 0.995252, 0.998148,
    1.001019, 0.996769, 0.989950, 0.995967,
    0.993213, 0.987558, 0.985659, 0.985117,
    0.978179, 0.977213, 0.975829, 0.962191,
    0.961872, 0.955232, 0.945845, 0.936059,
    0.923234, 0.922730, 0.912311, 0.902993,
    0.883404, 0.871201, 0.859177, 0.843540,
    0.827795, 0.823553, 0.802672, 0.779115,
    0.765036, 0.745169, 0.724668, 0.701950,
    0.680772, 0.665643, 0.640761, 0.622840,
    0.596463, 0.577257, 0.557431, 0.526557,
    0.505256, 0.483729, 0.460862, 0.437582,
    0.415923, 0.393477, 0.372857, 0.351255,
    0.328408, 0.309830, 0.288798, 0.268526,
    0.251480, 0.232190, 0.215726, 0.199810,
    0.183158, 0.168605, 0.154595, 0.140661,
    0.127996, 0.115835, 0.104843, 0.094533,
    0.084488, 0.075411, 0.068213, 0.060274,
    0.053025, 0.047041, 0.041109, 0.036138,
    0.031199, 0.027120, 0.023554, 0.020286,
    0.017422, 0.014810, 0.012719, 0.010877,
    0.009105, 0.007713, 0.006512, 0.005504,
    0.004656, 0.003987, 0.003387, 0.002911,
    0.002509, 0.002199, 0.001957, 0.001758,
    0.001601, 0.001482, 0.001393, 0.001321,
    0.001271, 0.001232, 0.001204, 0.001183,
    0.001169, 0.001158, 0.001149, 0.001142,
    0.001137, 0.001134, 0.001131, 0.001128,
    0.001125, 0.001123, 0.001121, 0.001120,
    0.001118, 0.001118, 0.001116, 0.001116,
  },
  { /* wavelet type 0, n_levels 2, high */
    0.001447, 0.001391, 0.001406, 0.001445,
    0.001532, 0.001700, 0.001995, 0.002478,
    0.003212, 0.004283, 0.005773, 0.007752,
    0.010441, 0.013876, 0.018011, 0.023395,
    0.029730, 0.037372, 0.045950, 0.055953,
    0.066733, 0.079239, 0.091822, 0.106319,
    0.120048, 0.134904, 0.149964, 0.164300,
    0.178121, 0.190569, 0.202406, 0.213374,
    0.220041, 0.228592, 0.232339, 0.235167,
    0.236624, 0.235861, 0.233326, 0.228882,
    0.223333, 0.218317, 0.210102, 0.203424,
    0.194391, 0.186817, 0.178133, 0.170034,
    0.161069, 0.153052, 0.144110, 0.138255,
    0.130621, 0.123527, 0.117043, 0.111198,
    0.104986, 0.098840, 0.092840, 0.087323,
    0.082078, 0.076961, 0.072267, 0.067311,
    0.062436, 0.058263, 0.054071, 0.049800,
    0.045939, 0.042282, 0.038837, 0.035659,
    0.032663, 0.029811, 0.026983, 0.024457,
    0.022180, 0.020099, 0.017917, 0.016222,
    0.014524, 0.013030, 0.011555, 0.010237,
    0.008977, 0.007895, 0.006834, 0.005926,
    0.005042, 0.004290, 0.003618, 0.003014,
    0.002488, 0.002030, 0.001655, 0.001333,
    0.001062, 0.000863, 0.000689, 0.000564,
    0.000462, 0.000393, 0.000341, 0.000304,
    0.000281, 0.000266, 0.000257, 0.000252,
    0.000250, 0.000249, 0.000249, 0.000249,
    0.000250, 0.000250, 0.000250, 0.000250,
    0.000250, 0.000250, 0.000250, 0.000249,
    0.000249, 0.000249, 0.000248, 0.000248,
    0.000248, 0.000248, 0.000247, 0.000247,
  },
  { /* wavelet type 0, n_levels 2, low */
    1.001893, 0.999051, 0.998821, 1.007029,
    1.006653, 0.999623, 0.996682, 0.996392,
    0.996448, 0.988962, 0.974877, 0.967721,
    0.955771, 0.945287, 0.928679, 0.904876,
    0.879051, 0.846235, 0.822928, 0.782494,
    0.748462, 0.704467, 0.660423, 0.616836,
    0.572762, 0.524966, 0.473811, 0.430626,
    0.383517, 0.339814, 0.298198, 0.258827,
    0.221713, 0.188340, 0.157398, 0.130029,
    0.105990, 0.085944, 0.067626, 0.053570,
    0.041413, 0.031404, 0.023601, 0.017589,
    0.012943, 0.009457, 0.006929, 0.005118,
    0.003852, 0.003015, 0.002436, 0.002074,
    0.001830, 0.001665, 0.001559, 0.001478,
    0.001417, 0.001364, 0.001318, 0.001275,
    0.001237, 0.001200, 0.001166, 0.001134,
    0.001105, 0.001075, 0.001047, 0.001020,
    0.000995, 0.000969, 0.000944, 0.000920,
    0.000897, 0.000878, 0.000863, 0.000852,
    0.000850, 0.000856, 0.000875, 0.000903,
    0.000951, 0.001004, 0.001076, 0.001154,
    0.001244, 0.001337, 0.001434, 0.001521,
    0.001598, 0.001671, 0.001711, 0.001744,
    0.001757, 0.001745, 0.001705, 0.001657,
    0.001581, 0.001507, 0.001409, 0.001317,
    0.001218, 0.001123, 0.001028, 0.000952,
    0.000873, 0.000808, 0.000754, 0.000707,
    0.000668, 0.000639, 0.000615, 0.000599,
    0.000586, 0.000576, 0.000569, 0.000565,
    0.000562, 0.000559, 0.000557, 0.000556,
    0.000555, 0.000554, 0.000553, 0.000552,
    0.000552, 0.000551, 0.000551, 0.000551,
  },
  { /* wavelet type 0, n_levels 3, high */
    0.003793, 0.003811, 0.004007, 0.004595,
    0.005957, 0.008773, 0.013662, 0.021718,
    0.033850, 0.050062, 0.070986, 0.095612,
    0.122996, 0.151819, 0.179582, 0.203027,
    0.218738, 0.230520, 0.232962, 0.227166,
    0.216517, 0.203716, 0.187287, 0.170777,
    0.154159, 0.137296, 0.122232, 0.108442,
    0.095729, 0.084718, 0.074264, 0.064541,
    0.055514, 0.047276, 0.039703, 0.033155,
    0.027198, 0.022338, 0.018065, 0.014484,
    0.011507, 0.008933, 0.006798, 0.005084,
    0.003670, 0.002630, 0.001818, 0.001243,
    0.000858, 0.000623, 0.000485, 0.000410,
    0.000369, 0.000349, 0.000335, 0.000325,
    0.000315, 0.000305, 0.000295, 0.000286,
    0.000278, 0.000270, 0.000262, 0.000255,
    0.000248, 0.000241, 0.000235, 0.000229,
    0.000223, 0.000217, 0.000211, 0.000205,
    0.000199, 0.000192, 0.000186, 0.000180,
    0.000176, 0.000176, 0.000180, 0.000191,
    0.000207, 0.000230, 0.000258, 0.000288,
    0.000319, 0.000347, 0.000376, 0.000396,
    0.000413, 0.000421, 0.000428, 0.000432,
    0.000429, 0.000425, 0.000418, 0.000405,
    0.000390, 0.000372, 0.000350, 0.000329,
    0.000306, 0.000286, 0.000263, 0.000243,
    0.000225, 0.000206, 0.000190, 0.000173,
    0.000160, 0.000149, 0.000140, 0.000134,
    0.000129, 0.000127, 0.000125, 0.000125,
    0.000125, 0.000125, 0.000126, 0.000126,
    0.000126, 0.000126, 0.000126, 0.000126,
    0.000125, 0.000125, 0.000125, 0.000125,
  },
  { /* wavelet type 0, n_levels 3, low */
    1.020641, 1.016982, 1.008008, 1.007444,
    0.996722, 0.981720, 0.959496, 0.925598,
    0.875309, 0.810711, 0.739097, 0.652825,
    0.564447, 0.470468, 0.378801, 0.292208,
    0.216692, 0.154084, 0.104708, 0.067808,
    0.041481, 0.024427, 0.014224, 0.008398,
    0.005386, 0.003933, 0.003215, 0.002818,
    0.002555, 0.002350, 0.002177, 0.002029,
    0.001901, 0.001783, 0.001673, 0.001570,
    0.001474, 0.001393, 0.001340, 0.001323,
    0.001353, 0.001422, 0.001518, 0.001621,
    0.001698, 0.001722, 0.001695, 0.001604,
    0.001468, 0.001314, 0.001158, 0.001024,
    0.000907, 0.000823, 0.000763, 0.000722,
    0.000690, 0.000667, 0.000647, 0.000627,
    0.000609, 0.000592, 0.000576, 0.000560,
    0.000546, 0.000532, 0.000518, 0.000505,
    0.000493, 0.000481, 0.000470, 0.000460,
    0.000453, 0.000448, 0.000447, 0.000449,
    0.000453, 0.000458, 0.000462, 0.000462,
    0.000457, 0.000447, 0.000432, 0.000416,
    0.000397, 0.000380, 0.000366, 0.000355,
    0.000346, 0.000341, 0.000336, 0.000332,
    0.000329, 0.000325, 0.000321, 0.000318,
    0.000315, 0.000311, 0.000308, 0.000305,
    0.000302, 0.000299, 0.000296, 0.000294,
    0.000293, 0.000293, 0.000293, 0.000294,
    0.000295, 0.000295, 0.000295, 0.000294,
    0.000291, 0.000288, 0.000284, 0.000281,
    0.000278, 0.000275, 0.000273, 0.000272,
    0.000271, 0.000270, 0.000270, 0.000269,
    0.000269, 0.000269, 0.000269, 0.000268,
  },
  { /* wavelet type 0, n_levels 4, high */
    0.008764, 0.009186, 0.011754, 0.020465,
    0.041601, 0.079371, 0.131313, 0.183543,
    0.221221, 0.230188, 0.214049, 0.183486,
    0.149616, 0.118430, 0.093592, 0.072012,
    0.054162, 0.039140, 0.027281, 0.018252,
    0.011730, 0.007074, 0.003974, 0.002126,
    0.001200, 0.000828, 0.000694, 0.000630,
    0.000579, 0.000534, 0.000494, 0.000461,
    0.000431, 0.000404, 0.000379, 0.000355,
    0.000330, 0.000307, 0.000290, 0.000287,
    0.000305, 0.000338, 0.000374, 0.000396,
    0.000405, 0.000400, 0.000392, 0.000376,
    0.000354, 0.000327, 0.000294, 0.000262,
    0.000231, 0.000202, 0.000180, 0.000163,
    0.000154, 0.000149, 0.000146, 0.000142,
    0.000138, 0.000134, 0.000131, 0.000127,
    0.000124, 0.000121, 0.000117, 0.000114,
    0.000111, 0.000108, 0.000105, 0.000102,
    0.000101, 0.000101, 0.000103, 0.000104,
    0.000105, 0.000105, 0.000106, 0.000106,
    0.000106, 0.000106, 0.000104, 0.000101,
    0.000096, 0.000090, 0.000085, 0.000079,
    0.000076, 0.000075, 0.000075, 0.000074,
    0.000074, 0.000073, 0.000072, 0.000072,
    0.000071, 0.000070, 0.000070, 0.000069,
    0.000068, 0.000067, 0.000066, 0.000065,
    0.000065, 0.000066, 0.000067, 0.000068,
    0.000068, 0.000068, 0.000068, 0.000067,
    0.000067, 0.000066, 0.000065, 0.000065,
    0.000064, 0.000063, 0.000062, 0.000061,
    0.000061, 0.000061, 0.000061, 0.000061,
    0.000061, 0.000061, 0.000061, 0.000061,
  },
  { /* wavelet type 0, n_levels 4, low */
    1.035418, 1.031749, 1.012051, 0.961042,
    0.876021, 0.732428, 0.555374, 0.372193,
    0.212609, 0.105257, 0.043942, 0.017672,
    0.008821, 0.006169, 0.005013, 0.004241,
    0.003679, 0.003221, 0.002819, 0.002530,
    0.002444, 0.002532, 0.002625, 0.002509,
    0.002180, 0.001808, 0.001509, 0.001333,
    0.001225, 0.001141, 0.001064, 0.000994,
    0.000932, 0.000876, 0.000824, 0.000777,
    0.000740, 0.000717, 0.000705, 0.000690,
    0.000661, 0.000619, 0.000573, 0.000537,
    0.000512, 0.000492, 0.000473, 0.000455,
    0.000438, 0.000422, 0.000406, 0.000391,
    0.000380, 0.000371, 0.000363, 0.000353,
    0.000341, 0.000328, 0.000317, 0.000307,
    0.000298, 0.000290, 0.000283, 0.000275,
    0.000268, 0.000262, 0.000255, 0.000250,
    0.000244, 0.000239, 0.000236, 0.000232,
    0.000227, 0.000222, 0.000217, 0.000211,
    0.000207, 0.000203, 0.000200, 0.000196,
    0.000193, 0.000190, 0.000187, 0.000184,
    0.000181, 0.000180, 0.000179, 0.000178,
    0.000175, 0.000172, 0.000169, 0.000166,
    0.000164, 0.000162, 0.000160, 0.000159,
    0.000157, 0.000155, 0.000154, 0.000152,
    0.000151, 0.000150, 0.000150, 0.000149,
    0.000149, 0.000147, 0.000145, 0.000143,
    0.000142, 0.000141, 0.000140, 0.000139,
    0.000138, 0.000138, 0.000137, 0.000137,
    0.000136, 0.000136, 0.000136, 0.000135,
    0.000135, 0.000134, 0.000134, 0.000133,
    0.000133, 0.000133, 0.000134, 0.000134,
}
},
{
  { /* wavelet type 1, n_levels 1, high */
    0.000436, 0.000436, 0.000437, 0.000441,
    0.000449, 0.000468, 0.000503, 0.000559,
    0.000642, 0.000766, 0.000932, 0.001161,
    0.001446, 0.001823, 0.002269, 0.002846,
    0.003516, 0.004292, 0.005261, 0.006412,
    0.007639, 0.009076, 0.010735, 0.012511,
    0.014617, 0.016812, 0.019346, 0.022078,
    0.025018, 0.028496, 0.031863, 0.035487,
    0.039462, 0.043745, 0.048274, 0.053340,
    0.058415, 0.063506, 0.069269, 0.074478,
    0.080595, 0.087381, 0.093712, 0.100245,
    0.106767, 0.113683, 0.121222, 0.127783,
    0.135198, 0.142288, 0.150019, 0.156654,
    0.164757, 0.171756, 0.180691, 0.187522,
    0.194217, 0.202280, 0.209472, 0.215981,
    0.223948, 0.229313, 0.236326, 0.241707,
    0.249848, 0.253802, 0.260744, 0.265853,
    0.272683, 0.276531, 0.281947, 0.286375,
    0.289426, 0.294463, 0.298893, 0.299559,
    0.303185, 0.304621, 0.308804, 0.310140,
    0.312180, 0.313316, 0.316020, 0.315577,
    0.315951, 0.317152, 0.317445, 0.317197,
    0.314360, 0.313506, 0.314557, 0.312664,
    0.312166, 0.311014, 0.307406, 0.305633,
    0.303324, 0.301527, 0.300332, 0.299937,
    0.294573, 0.293133, 0.290537, 0.287548,
    0.286472, 0.282192, 0.281093, 0.278446,
    0.276405, 0.275905, 0.271564, 0.267965,
    0.267308, 0.265822, 0.263068, 0.263001,
    0.259892, 0.259583, 0.257155, 0.256021,
    0.255532, 0.253292, 0.253230, 0.251006,
    0.250201, 0.249281, 0.250246, 0.248938,
  },
  { /* wavelet type 1, n_levels 1, low */
    0.995262, 0.994154, 1.002928, 0.995186,
    0.993834, 0.994970, 0.985555, 0.984629,
    0.982005, 0.971136, 0.974649, 0.963639,
    0.964280, 0.954998, 0.943275, 0.936966,
    0.925054, 0.916754, 0.913524, 0.897272,
    0.884590, 0.874011, 0.861950, 0.857532,
    0.837396, 0.826188, 0.810356, 0.797604,
    0.786250, 0.773149, 0.758934, 0.744998,
    0.724812, 0.715524, 0.704575, 0.681223,
    0.668739, 0.654488, 0.641121, 0.621646,
    0.604644, 0.589114, 0.572185, 0.558090,
    0.541690, 0.526878, 0.511662, 0.493433,
    0.480556, 0.460607, 0.446115, 0.433038,
    0.413941, 0.403200, 0.388269, 0.372898,
    0.358450, 0.342462, 0.329809, 0.317664,
    0.302990, 0.289209, 0.275405, 0.263029,
    0.250685, 0.238475, 0.226526, 0.215635,
    0.204835, 0.194531, 0.183283, 0.172275,
    0.163241, 0.153614, 0.144680, 0.135825,
    0.125944, 0.118965, 0.110548, 0.102849,
    0.096674, 0.089289, 0.083103, 0.076768,
    0.070687, 0.065251, 0.059818, 0.054975,
    0.050240, 0.045978, 0.042055, 0.038060,
    0.034417, 0.030913, 0.028162, 0.025093,
    0.022272, 0.020014, 0.017763, 0.015702,
    0.013843, 0.012145, 0.010643, 0.009285,
    0.008060, 0.007045, 0.006011, 0.005189,
    0.004448, 0.003831, 0.003294, 0.002808,
    0.002422, 0.002096, 0.001828, 0.001610,
    0.001445, 0.001300, 0.001198, 0.001121,
    0.001063, 0.001030, 0.001003, 0.000989,
    0.000979, 0.000975, 0.000974, 0.000974,
  },
  { /* wavelet type 1, n_levels 2, high */
    0.001534, 0.001446, 0.001469, 0.001536,
    0.001694, 0.002010, 0.002544, 0.003401,
    0.004642, 0.006369, 0.008720, 0.011605,
    0.015314, 0.019813, 0.025085, 0.031233,
    0.038092, 0.045815, 0.054060, 0.063679,
    0.073105, 0.082858, 0.093519, 0.103871,
    0.114795, 0.124883, 0.135448, 0.145124,
    0.153607, 0.161386, 0.169626, 0.177544,
    0.182484, 0.187840, 0.189954, 0.191461,
    0.193449, 0.194397, 0.193470, 0.190968,
    0.188711, 0.184699, 0.180825, 0.175237,
    0.170310, 0.165399, 0.157385, 0.151777,
    0.145089, 0.138440, 0.132050, 0.124940,
    0.118442, 0.112117, 0.106724, 0.101025,
    0.095454, 0.090724, 0.085319, 0.081635,
    0.076623, 0.072938, 0.069723, 0.065927,
    0.062968, 0.059842, 0.057472, 0.054620,
    0.052058, 0.050294, 0.047740, 0.046038,
    0.043839, 0.042040, 0.040173, 0.038140,
    0.036445, 0.034660, 0.033071, 0.031233,
    0.029460, 0.027682, 0.025776, 0.024276,
    0.022400, 0.020586, 0.018928, 0.017225,
    0.015648, 0.014037, 0.012584, 0.011176,
    0.009792, 0.008521, 0.007408, 0.006409,
    0.005434, 0.004600, 0.003813, 0.003131,
    0.002573, 0.002098, 0.001682, 0.001337,
    0.001058, 0.000833, 0.000659, 0.000521,
    0.000417, 0.000347, 0.000291, 0.000255,
    0.000231, 0.000216, 0.000208, 0.000204,
    0.000203, 0.000204, 0.000205, 0.000207,
    0.000208, 0.000210, 0.000211, 0.000212,
    0.000212, 0.000213, 0.000213, 0.000213,
  },
  { /* wavelet type 1, n_levels 2, low */
    1.001972, 0.997948, 0.996925, 0.986740,
    0.974428, 0.966613, 0.952118, 0.937876,
    0.910814, 0.891195, 0.858519, 0.836561,
    0.801940, 0.776527, 0.742965, 0.709935,
    0.674141, 0.642087, 0.609899, 0.572361,
    0.538353, 0.501257, 0.469828, 0.433498,
    0.403339, 0.370496, 0.340615, 0.308256,
    0.280637, 0.254238, 0.228808, 0.204940,
    0.183052, 0.161821, 0.142812, 0.124876,
    0.108637, 0.093849, 0.081400, 0.069396,
    0.059016, 0.049250, 0.041442, 0.034050,
    0.028093, 0.022843, 0.018447, 0.014686,
    0.011636, 0.009184, 0.007180, 0.005638,
    0.004373, 0.003452, 0.002757, 0.002237,
    0.001867, 0.001602, 0.001418, 0.001293,
    0.001201, 0.001132, 0.001076, 0.001025,
    0.001000, 0.000929, 0.000886, 0.000850,
    0.000824, 0.000815, 0.000826, 0.000863,
    0.000931, 0.001032, 0.001165, 0.001346,
    0.001548, 0.001800, 0.002076, 0.002382,
    0.002717, 0.003067, 0.003450, 0.003808,
    0.004178, 0.004511, 0.004877, 0.005152,
    0.005482, 0.005714, 0.005932, 0.006037,
    0.006161, 0.006224, 0.006223, 0.006188,
    0.006093, 0.005945, 0.005754, 0.005520,
    0.005255, 0.004951, 0.004680, 0.004344,
    0.004014, 0.003630, 0.003320, 0.002959,
    0.002651, 0.002343, 0.002056, 0.001781,
    0.001546, 0.001334, 0.001148, 0.000996,
    0.000860, 0.000757, 0.000673, 0.000608,
    0.000562, 0.000528, 0.000507, 0.000496,
    0.000490, 0.000487, 0.000488, 0.000488,
  },
  { /* wavelet type 1, n_levels 3, high */
    0.003975, 0.003839, 0.004136, 0.005102,
    0.007347, 0.011561, 0.018188, 0.027809,
    0.040483, 0.056237, 0.074307, 0.092732,
    0.112695, 0.130562, 0.147723, 0.160448,
    0.169013, 0.175194, 0.176226, 0.172178,
    0.166346, 0.156379, 0.146025, 0.133113,
    0.119647, 0.107275, 0.095509, 0.084296,
    0.074348, 0.065604, 0.057903, 0.051351,
    0.045509, 0.040806, 0.036656, 0.032926,
    0.029552, 0.026401, 0.023494, 0.020635,
    0.017933, 0.015464, 0.012980, 0.010664,
    0.008595, 0.006707, 0.005145, 0.003803,
    0.002728, 0.001934, 0.001347, 0.000928,
    0.000659, 0.000491, 0.000389, 0.000335,
    0.000305, 0.000288, 0.000277, 0.000267,
    0.000257, 0.000246, 0.000236, 0.000225,
    0.000227, 0.000204, 0.000194, 0.000184,
    0.000173, 0.000163, 0.000153, 0.000144,
    0.000137, 0.000137, 0.000148, 0.000171,
    0.000215, 0.000281, 0.000373, 0.000488,
    0.000622, 0.000776, 0.000938, 0.001091,
    0.001245, 0.001370, 0.001489, 0.001569,
    0.001614, 0.001648, 0.001660, 0.001655,
    0.001635, 0.001609, 0.001576, 0.001550,
    0.001517, 0.001498, 0.001476, 0.001454,
    0.001427, 0.001392, 0.001343, 0.001282,
    0.001208, 0.001127, 0.001021, 0.000903,
    0.000784, 0.000659, 0.000544, 0.000434,
    0.000338, 0.000261, 0.000200, 0.000155,
    0.000126, 0.000108, 0.000099, 0.000096,
    0.000097, 0.000099, 0.000101, 0.000103,
    0.000105, 0.000106, 0.000107, 0.000107,
  },
  { /* wavelet type 1, n_levels 3, low */
    1.008485, 1.001015, 0.988907, 0.953240,
    0.918525, 0.862883, 0.803254, 0.735199,
    0.666078, 0.595311, 0.523902, 0.453963,
    0.386172, 0.321167, 0.264377, 0.214185,
    0.168342, 0.131130, 0.098438, 0.072750,
    0.052656, 0.036906, 0.025358, 0.016875,
    0.011187, 0.007430, 0.005092, 0.003684,
    0.002874, 0.002406, 0.002096, 0.001860,
    0.001662, 0.001472, 0.001332, 0.001259,
    0.001278, 0.001400, 0.001622, 0.001921,
    0.002285, 0.002681, 0.003045, 0.003370,
    0.003599, 0.003705, 0.003725, 0.003633,
    0.003420, 0.003157, 0.002798, 0.002441,
    0.002084, 0.001734, 0.001435, 0.001167,
    0.000965, 0.000812, 0.000706, 0.000634,
    0.000587, 0.000556, 0.000531, 0.000508,
    0.000497, 0.000461, 0.000440, 0.000426,
    0.000423, 0.000435, 0.000464, 0.000509,
    0.000570, 0.000644, 0.000721, 0.000796,
    0.000861, 0.000906, 0.000936, 0.000945,
    0.000924, 0.000889, 0.000826, 0.000757,
    0.000682, 0.000602, 0.000531, 0.000462,
    0.000408, 0.000366, 0.000337, 0.000317,
    0.000305, 0.000299, 0.000293, 0.000289,
    0.000284, 0.000278, 0.000272, 0.000267,
    0.000267, 0.000272, 0.000285, 0.000305,
    0.000334, 0.000371, 0.000412, 0.000454,
    0.000494, 0.000526, 0.000551, 0.000566,
    0.000566, 0.000557, 0.000531, 0.000499,
    0.000462, 0.000419, 0.000378, 0.000338,
    0.000304, 0.000278, 0.000261, 0.000249,
    0.000243, 0.000241, 0.000241, 0.000242,
  },
  { /* wavelet type 1, n_levels 4, high */
    0.008796, 0.009147, 0.012854, 0.024419,
    0.046960, 0.080068, 0.117157, 0.148576,
    0.167127, 0.171143, 0.159458, 0.138175,
    0.112200, 0.088756, 0.068717, 0.053253,
    0.042056, 0.033584, 0.027058, 0.021359,
    0.016092, 0.011519, 0.007540, 0.004556,
    0.002555, 0.001445, 0.000899, 0.000673,
    0.000573, 0.000512, 0.000460, 0.000411,
    0.000370, 0.000324, 0.000287, 0.000253,
    0.000227, 0.000224, 0.000266, 0.000368,
    0.000522, 0.000700, 0.000857, 0.000954,
    0.000985, 0.000973, 0.000929, 0.000883,
    0.000846, 0.000810, 0.000773, 0.000715,
    0.000625, 0.000515, 0.000393, 0.000282,
    0.000200, 0.000152, 0.000130, 0.000124,
    0.000122, 0.000120, 0.000117, 0.000112,
    0.000113, 0.000102, 0.000096, 0.000090,
    0.000083, 0.000079, 0.000081, 0.000095,
    0.000121, 0.000156, 0.000191, 0.000218,
    0.000232, 0.000237, 0.000234, 0.000230,
    0.000227, 0.000225, 0.000222, 0.000215,
    0.000197, 0.000171, 0.000139, 0.000107,
    0.000082, 0.000068, 0.000062, 0.000062,
    0.000063, 0.000064, 0.000064, 0.000064,
    0.000063, 0.000061, 0.000059, 0.000057,
    0.000054, 0.000051, 0.000051, 0.000057,
    0.000069, 0.000086, 0.000107, 0.000124,
    0.000135, 0.000140, 0.000140, 0.000139,
    0.000139, 0.000139, 0.000139, 0.000137,
    0.000129, 0.000116, 0.000097, 0.000078,
    0.000061, 0.000052, 0.000048, 0.000048,
    0.000050, 0.000052, 0.000053, 0.000054,
  },
  { /* wavelet type 1, n_levels 4, low */
    1.032875, 1.001943, 0.929350, 0.807950,
    0.667854, 0.522924, 0.380002, 0.258343,
    0.163485, 0.095501, 0.051653, 0.026499,
    0.013361, 0.007673, 0.005308, 0.004100,
    0.003218, 0.002564, 0.002314, 0.002541,
    0.003103, 0.003703, 0.004055, 0.003998,
    0.003573, 0.002925, 0.002258, 0.001726,
    0.001353, 0.001150, 0.001031, 0.000935,
    0.000840, 0.000746, 0.000696, 0.000708,
    0.000777, 0.000868, 0.000938, 0.000950,
    0.000898, 0.000798, 0.000684, 0.000586,
    0.000513, 0.000473, 0.000447, 0.000424,
    0.000396, 0.000369, 0.000351, 0.000352,
    0.000374, 0.000405, 0.000432, 0.000441,
    0.000427, 0.000394, 0.000353, 0.000317,
    0.000289, 0.000274, 0.000265, 0.000256,
    0.000251, 0.000233, 0.000225, 0.000225,
    0.000235, 0.000251, 0.000267, 0.000274,
    0.000269, 0.000254, 0.000233, 0.000213,
    0.000198, 0.000190, 0.000185, 0.000182,
    0.000177, 0.000171, 0.000166, 0.000167,
    0.000173, 0.000184, 0.000194, 0.000201,
    0.000200, 0.000191, 0.000178, 0.000165,
    0.000155, 0.000149, 0.000147, 0.000146,
    0.000144, 0.000140, 0.000138, 0.000138,
    0.000143, 0.000151, 0.000160, 0.000166,
    0.000167, 0.000161, 0.000152, 0.000142,
    0.000134, 0.000130, 0.000128, 0.000128,
    0.000127, 0.000126, 0.000124, 0.000125,
    0.000129, 0.000136, 0.000145, 0.000151,
    0.000153, 0.000150, 0.000143, 0.000134,
    0.000127, 0.000123, 0.000122, 0.000122,
}
},
{
  { /* wavelet type 2, n_levels 1, high */
    0.000561, 0.000562, 0.000561, 0.000561,
    0.000562, 0.000562, 0.000563, 0.000563,
    0.000565, 0.000567, 0.000567, 0.000569,
    0.000573, 0.000578, 0.000585, 0.000597,
    0.000615, 0.000641, 0.000680, 0.000736,
    0.000812, 0.000915, 0.001061, 0.001246,
    0.001498, 0.001818, 0.002234, 0.002729,
    0.003391, 0.004182, 0.005146, 0.006326,
    0.007663, 0.009344, 0.011273, 0.013695,
    0.016217, 0.019236, 0.022656, 0.026451,
    0.030721, 0.035602, 0.040860, 0.046699,
    0.053082, 0.060196, 0.067473, 0.075808,
    0.084266, 0.092825, 0.102040, 0.112564,
    0.122427, 0.132867, 0.143857, 0.155135,
    0.166447, 0.177508, 0.187794, 0.199046,
    0.210583, 0.219753, 0.230184, 0.240630,
    0.250572, 0.258886, 0.266745, 0.274133,
    0.282990, 0.288458, 0.293882, 0.300137,
    0.304783, 0.308088, 0.310269, 0.312213,
    0.313947, 0.316133, 0.314696, 0.315036,
    0.315885, 0.315457, 0.312571, 0.311660,
    0.308824, 0.306106, 0.303763, 0.301718,
    0.298510, 0.295824, 0.294076, 0.290911,
    0.287936, 0.286691, 0.281258, 0.278796,
    0.275645, 0.274286, 0.271949, 0.270387,
    0.267057, 0.264899, 0.263392, 0.261633,
    0.259267, 0.258291, 0.257249, 0.254848,
    0.255581, 0.254286, 0.252156, 0.252590,
    0.252560, 0.250656, 0.251795, 0.250857,
    0.251076, 0.251000, 0.248883, 0.251230,
    0.250490, 0.250402, 0.250581, 0.250464,
    0.249601, 0.250429, 0.250348, 0.249897,
  },
  { /* wavelet type 2, n_levels 1, low */
    0.998247, 1.001062, 1.007452, 1.002119,
    1.007055, 1.002418, 0.999518, 0.998298,
    0.999299, 1.001393, 0.995800, 0.997422,
    0.994546, 1.003670, 0.993961, 0.994274,
    0.993388, 0.994388, 0.985668, 0.983039,
    0.986950, 0.976515, 0.964193, 0.962724,
    0.958130, 0.950121, 0.947644, 0.938316,
    0.929199, 0.916153, 0.906296, 0.901639,
    0.882407, 0.874681, 0.855184, 0.844421,
    0.832220, 0.811134, 0.800614, 0.780476,
    0.763361, 0.744424, 0.724489, 0.705977,
    0.682888, 0.663364, 0.642770, 0.618046,
    0.596513, 0.577290, 0.554348, 0.529626,
    0.507167, 0.482058, 0.458859, 0.439497,
    0.415634, 0.394682, 0.370984, 0.350999,
    0.329211, 0.308480, 0.289255, 0.269721,
    0.251719, 0.232946, 0.216037, 0.198971,
    0.183240, 0.168705, 0.153891, 0.140913,
    0.127975, 0.116211, 0.104440, 0.094128,
    0.084956, 0.075866, 0.067924, 0.060208,
    0.053044, 0.046753, 0.041233, 0.036035,
    0.031265, 0.027296, 0.023481, 0.020330,
    0.017408, 0.014867, 0.012686, 0.010709,
    0.009120, 0.007687, 0.006486, 0.005518,
    0.004649, 0.003967, 0.003371, 0.002879,
    0.002503, 0.002190, 0.001948, 0.001748,
    0.001601, 0.001477, 0.001384, 0.001315,
    0.001267, 0.001228, 0.001197, 0.001177,
    0.001160, 0.001151, 0.001143, 0.001136,
    0.001132, 0.001128, 0.001124, 0.001121,
    0.001120, 0.001117, 0.001115, 0.001114,
    0.001113, 0.001111, 0.001111, 0.001110,
  },
  { /* wavelet type 2, n_levels 2, high */
    0.001835, 0.001835, 0.001835, 0.001839,
    0.001843, 0.001852, 0.001864, 0.001889,
    0.001935, 0.002017, 0.002184, 0.002462,
    0.002958, 0.003726, 0.004972, 0.006797,
    0.009396, 0.013062, 0.017982, 0.024358,
    0.032236, 0.042278, 0.053890, 0.067062,
    0.082882, 0.099811, 0.118017, 0.136576,
    0.154668, 0.174368, 0.192497, 0.208135,
    0.222051, 0.233718, 0.243613, 0.248829,
    0.250131, 0.252369, 0.250472, 0.245895,
    0.239520, 0.230720, 0.223358, 0.214710,
    0.202921, 0.193786, 0.183606, 0.173839,
    0.164313, 0.155519, 0.147043, 0.138716,
    0.130685, 0.123455, 0.116748, 0.110767,
    0.104765, 0.098520, 0.092783, 0.087717,
    0.082726, 0.077195, 0.072145, 0.067100,
    0.062474, 0.058099, 0.053955, 0.049966,
    0.046305, 0.042430, 0.038767, 0.035568,
    0.032603, 0.029676, 0.026911, 0.024440,
    0.022222, 0.020206, 0.018305, 0.016527,
    0.014875, 0.013375, 0.011967, 0.010691,
    0.009415, 0.008380, 0.007283, 0.006291,
    0.005429, 0.004618, 0.003897, 0.003232,
    0.002645, 0.002152, 0.001730, 0.001376,
    0.001085, 0.000855, 0.000680, 0.000542,
    0.000443, 0.000376, 0.000330, 0.000300,
    0.000281, 0.000272, 0.000267, 0.000265,
    0.000264, 0.000265, 0.000266, 0.000266,
    0.000267, 0.000267, 0.000267, 0.000267,
    0.000267, 0.000266, 0.000266, 0.000265,
    0.000265, 0.000264, 0.000264, 0.000264,
    0.000264, 0.000263, 0.000263, 0.000263,
  },
  { /* wavelet type 2, n_levels 2, low */
    1.010288, 1.001214, 1.006176, 1.005860,
    1.004706, 1.009355, 1.001355, 1.000806,
    0.993479, 0.990500, 0.979894, 0.967318,
    0.957782, 0.936170, 0.922604, 0.907470,
    0.879640, 0.854123, 0.815306, 0.785721,
    0.744194, 0.706898, 0.661054, 0.617808,
    0.573470, 0.523966, 0.477577, 0.431328,
    0.382891, 0.341675, 0.296242, 0.257919,
    0.221873, 0.187738, 0.156381, 0.130401,
    0.105876, 0.085866, 0.068296, 0.053433,
    0.041416, 0.031541, 0.023654, 0.017542,
    0.012901, 0.009520, 0.006928, 0.005157,
    0.003884, 0.003022, 0.002450, 0.002081,
    0.001834, 0.001680, 0.001570, 0.001489,
    0.001427, 0.001374, 0.001328, 0.001285,
    0.001245, 0.001209, 0.001175, 0.001143,
    0.001113, 0.001083, 0.001056, 0.001028,
    0.001002, 0.000976, 0.000951, 0.000927,
    0.000905, 0.000885, 0.000869, 0.000858,
    0.000856, 0.000860, 0.000879, 0.000912,
    0.000951, 0.001011, 0.001081, 0.001163,
    0.001250, 0.001343, 0.001435, 0.001525,
    0.001610, 0.001673, 0.001724, 0.001753,
    0.001762, 0.001759, 0.001713, 0.001655,
    0.001587, 0.001507, 0.001416, 0.001324,
    0.001223, 0.001126, 0.001038, 0.000954,
    0.000879, 0.000814, 0.000757, 0.000709,
    0.000673, 0.000644, 0.000621, 0.000603,
    0.000589, 0.000580, 0.000573, 0.000569,
    0.000566, 0.000564, 0.000562, 0.000560,
    0.000559, 0.000558, 0.000557, 0.000557,
    0.000556, 0.000555, 0.000555, 0.000555,
  },
  { /* wavelet type 2, n_levels 3, high */
    0.004840, 0.004842, 0.004861, 0.004907,
    0.005028, 0.005370, 0.006292, 0.008584,
    0.013321, 0.022225, 0.036914, 0.058634,
    0.087544, 0.122079, 0.157934, 0.192593,
    0.221132, 0.239365, 0.247235, 0.244775,
    0.232735, 0.215127, 0.194821, 0.174848,
    0.154906, 0.138232, 0.122250, 0.108390,
    0.096603, 0.085412, 0.074401, 0.064572,
    0.056091, 0.047317, 0.039892, 0.033346,
    0.027461, 0.022256, 0.018094, 0.014661,
    0.011656, 0.009240, 0.007157, 0.005427,
    0.003982, 0.002841, 0.001934, 0.001305,
    0.000879, 0.000631, 0.000488, 0.000419,
    0.000384, 0.000367, 0.000355, 0.000345,
    0.000334, 0.000324, 0.000313, 0.000303,
    0.000294, 0.000286, 0.000277, 0.000270,
    0.000263, 0.000256, 0.000249, 0.000242,
    0.000236, 0.000230, 0.000223, 0.000217,
    0.000210, 0.000203, 0.000196, 0.000190,
    0.000184, 0.000182, 0.000186, 0.000197,
    0.000216, 0.000242, 0.000275, 0.000310,
    0.000344, 0.000372, 0.000394, 0.000412,
    0.000422, 0.000433, 0.000436, 0.000439,
    0.000440, 0.000437, 0.000425, 0.000412,
    0.000400, 0.000379, 0.000359, 0.000338,
    0.000315, 0.000292, 0.000271, 0.000253,
    0.000234, 0.000218, 0.000201, 0.000186,
    0.000172, 0.000159, 0.000149, 0.000141,
    0.000136, 0.000133, 0.000132, 0.000132,
    0.000132, 0.000132, 0.000133, 0.000133,
    0.000133, 0.000133, 0.000133, 0.000132,
    0.000132, 0.000132, 0.000132, 0.000132,
  },
  { /* wavelet type 2, n_levels 3, low */
    1.011167, 1.010938, 1.011138, 1.002786,
    0.999767, 0.986612, 0.958557, 0.921467,
    0.878774, 0.814297, 0.733877, 0.658595,
    0.564007, 0.471374, 0.380793, 0.292060,
    0.219567, 0.154087, 0.105213, 0.067694,
    0.041648, 0.024698, 0.014219, 0.008461,
    0.005433, 0.003940, 0.003221, 0.002827,
    0.002566, 0.002360, 0.002186, 0.002038,
    0.001908, 0.001789, 0.001679, 0.001575,
    0.001479, 0.001398, 0.001344, 0.001327,
    0.001357, 0.001423, 0.001517, 0.001623,
    0.001700, 0.001733, 0.001707, 0.001602,
    0.001482, 0.001315, 0.001164, 0.001025,
    0.000913, 0.000828, 0.000767, 0.000724,
    0.000694, 0.000669, 0.000649, 0.000630,
    0.000611, 0.000594, 0.000578, 0.000562,
    0.000548, 0.000534, 0.000520, 0.000507,
    0.000495, 0.000482, 0.000471, 0.000461,
    0.000454, 0.000449, 0.000448, 0.000450,
    0.000455, 0.000460, 0.000464, 0.000462,
    0.000460, 0.000448, 0.000435, 0.000417,
    0.000399, 0.000381, 0.000367, 0.000356,
    0.000348, 0.000342, 0.000338, 0.000334,
    0.000330, 0.000326, 0.000323, 0.000319,
    0.000316, 0.000313, 0.000309, 0.000306,
    0.000303, 0.000300, 0.000297, 0.000295,
    0.000294, 0.000293, 0.000294, 0.000295,
    0.000296, 0.000296, 0.000296, 0.000294,
    0.000292, 0.000289, 0.000286, 0.000282,
    0.000279, 0.000276, 0.000274, 0.000273,
    0.000272, 0.000271, 0.000271, 0.000270,
    0.000270, 0.000270, 0.000270, 0.000269,
  },
  { /* wavelet type 2, n_levels 4, high */
    0.010996, 0.011043, 0.011358, 0.013197,
    0.021390, 0.046593, 0.096959, 0.163983,
    0.221685, 0.243305, 0.227860, 0.190883,
    0.151444, 0.119743, 0.094010, 0.072668,
    0.054687, 0.039477, 0.027339, 0.018470,
    0.012005, 0.007505, 0.004271, 0.002263,
    0.001238, 0.000852, 0.000724, 0.000661,
    0.000607, 0.000559, 0.000518, 0.000482,
    0.000451, 0.000423, 0.000397, 0.000371,
    0.000346, 0.000321, 0.000301, 0.000295,
    0.000316, 0.000354, 0.000393, 0.000411,
    0.000415, 0.000412, 0.000405, 0.000386,
    0.000363, 0.000335, 0.000302, 0.000271,
    0.000241, 0.000214, 0.000189, 0.000171,
    0.000161, 0.000156, 0.000152, 0.000148,
    0.000144, 0.000140, 0.000136, 0.000133,
    0.000129, 0.000126, 0.000123, 0.000119,
    0.000116, 0.000113, 0.000110, 0.000107,
    0.000105, 0.000106, 0.000107, 0.000108,
    0.000109, 0.000109, 0.000110, 0.000110,
    0.000110, 0.000109, 0.000108, 0.000105,
    0.000100, 0.000095, 0.000089, 0.000083,
    0.000079, 0.000078, 0.000078, 0.000078,
    0.000077, 0.000076, 0.000076, 0.000075,
    0.000074, 0.000073, 0.000073, 0.000072,
    0.000071, 0.000070, 0.000069, 0.000068,
    0.000068, 0.000069, 0.000070, 0.000071,
    0.000071, 0.000071, 0.000070, 0.000070,
    0.000069, 0.000069, 0.000068, 0.000067,
    0.000067, 0.000066, 0.000065, 0.000064,
    0.000064, 0.000063, 0.000063, 0.000063,
    0.000063, 0.000063, 0.000063, 0.000063,
  },
  { /* wavelet type 2, n_levels 4, low */
    1.036081, 1.029923, 1.015325, 0.962159,
    0.874939, 0.731578, 0.554597, 0.372400,
    0.213549, 0.104950, 0.044006, 0.017580,
    0.008769, 0.006095, 0.004949, 0.004186,
    0.003631, 0.003179, 0.002782, 0.002496,
    0.002409, 0.002505, 0.002589, 0.002487,
    0.002162, 0.001783, 0.001493, 0.001317,
    0.001210, 0.001126, 0.001050, 0.000981,
    0.000919, 0.000864, 0.000813, 0.000766,
    0.000730, 0.000708, 0.000695, 0.000682,
    0.000653, 0.000610, 0.000566, 0.000530,
    0.000506, 0.000486, 0.000467, 0.000449,
    0.000432, 0.000416, 0.000400, 0.000386,
    0.000374, 0.000366, 0.000358, 0.000349,
    0.000337, 0.000324, 0.000312, 0.000303,
    0.000294, 0.000286, 0.000279, 0.000272,
    0.000265, 0.000258, 0.000252, 0.000246,
    0.000241, 0.000236, 0.000232, 0.000229,
    0.000225, 0.000219, 0.000214, 0.000208,
    0.000204, 0.000201, 0.000197, 0.000194,
    0.000191, 0.000187, 0.000184, 0.000181,
    0.000179, 0.000177, 0.000177, 0.000175,
    0.000173, 0.000170, 0.000166, 0.000164,
    0.000162, 0.000160, 0.000158, 0.000156,
    0.000155, 0.000153, 0.000152, 0.000150,
    0.000149, 0.000148, 0.000148, 0.000147,
    0.000147, 0.000145, 0.000143, 0.000141,
    0.000140, 0.000139, 0.000138, 0.000137,
    0.000137, 0.000136, 0.000135, 0.000135,
    0.000134, 0.000134, 0.000134, 0.000133,
    0.000133, 0.000132, 0.000132, 0.000131,
    0.000132, 0.000132, 0.000132, 0.000132,
}
},
{
  { /* wavelet type 3, n_levels 1, high */
    0.001613, 0.000088, 0.000312, 0.000689,
    0.001215, 0.001903, 0.002727, 0.003699,
    0.004800, 0.006081, 0.007526, 0.009057,
    0.010801, 0.012595, 0.014665, 0.016769,
    0.019126, 0.021469, 0.024068, 0.026637,
    0.029447, 0.032438, 0.035563, 0.038561,
    0.041903, 0.045459, 0.049417, 0.053037,
    0.056806, 0.061031, 0.064846, 0.068868,
    0.073366, 0.077172, 0.082130, 0.086967,
    0.091962, 0.096284, 0.101275, 0.106151,
    0.111350, 0.116435, 0.121988, 0.126992,
    0.132215, 0.137587, 0.143304, 0.147925,
    0.154865, 0.159534, 0.165659, 0.171422,
    0.177282, 0.185150, 0.189916, 0.195206,
    0.199383, 0.207949, 0.213255, 0.220775,
    0.226060, 0.232767, 0.239263, 0.243221,
    0.248700, 0.255462, 0.263936, 0.269726,
    0.275170, 0.282371, 0.286570, 0.293714,
    0.296038, 0.304754, 0.311824, 0.319825,
    0.322283, 0.328114, 0.333975, 0.338933,
    0.346871, 0.349469, 0.357356, 0.362351,
    0.368006, 0.373807, 0.380083, 0.384367,
    0.389708, 0.394310, 0.399691, 0.404162,
    0.411060, 0.414510, 0.417962, 0.419948,
    0.427537, 0.430580, 0.435739, 0.441681,
    0.443652, 0.448019, 0.452681, 0.452884,
    0.455249, 0.458336, 0.464270, 0.466756,
    0.469174, 0.472120, 0.477034, 0.478733,
    0.483077, 0.483396, 0.486574, 0.486023,
    0.490236, 0.490430, 0.493830, 0.493708,
    0.493644, 0.497236, 0.498995, 0.501093,
    0.498420, 0.498491, 0.497468, 0.500190,
  },
  { /* wavelet type 3, n_levels 1, low */
    2.001747, 1.995591, 1.990535, 2.003239,
    1.993379, 1.997798, 1.987905, 1.983315,
    1.985552, 1.969733, 1.970910, 1.954133,
    1.957132, 1.958694, 1.943602, 1.921348,
    1.924774, 1.906994, 1.910033, 1.887825,
    1.892721, 1.867104, 1.863846, 1.858332,
    1.823802, 1.816805, 1.801056, 1.798876,
    1.775451, 1.759501, 1.749132, 1.727799,
    1.715353, 1.686054, 1.664825, 1.646941,
    1.631376, 1.608763, 1.599052, 1.576455,
    1.563328, 1.530854, 1.511170, 1.494819,
    1.476502, 1.454744, 1.426441, 1.401164,
    1.386215, 1.352633, 1.340058, 1.312349,
    1.286299, 1.268025, 1.245463, 1.214609,
    1.197205, 1.176184, 1.144992, 1.121591,
    1.095304, 1.078922, 1.052275, 1.020213,
    0.999804, 0.971338, 0.953839, 0.931059,
    0.899754, 0.876948, 0.851976, 0.832736,
    0.806334, 0.778021, 0.758532, 0.734047,
    0.707523, 0.685622, 0.664682, 0.636687,
    0.618893, 0.593033, 0.571998, 0.552337,
    0.530437, 0.507754, 0.484956, 0.463747,
    0.446646, 0.424366, 0.405150, 0.383227,
    0.364932, 0.345520, 0.327118, 0.309819,
    0.294308, 0.276321, 0.260266, 0.243108,
    0.227302, 0.212900, 0.196558, 0.182337,
    0.167825, 0.156280, 0.142740, 0.129706,
    0.118756, 0.106471, 0.096315, 0.085467,
    0.076156, 0.066604, 0.058518, 0.050709,
    0.043064, 0.036046, 0.029982, 0.024224,
    0.019261, 0.014708, 0.010817, 0.007541,
    0.004811, 0.002718, 0.001200, 0.000301,
  },
  { /* wavelet type 3, n_levels 2, high */
    0.001626, 0.000627, 0.002436, 0.005414,
    0.009600, 0.014944, 0.021431, 0.029180,
    0.037532, 0.047445, 0.057884, 0.069955,
    0.082587, 0.095482, 0.110032, 0.124637,
    0.140438, 0.157648, 0.173871, 0.191717,
    0.208424, 0.226694, 0.245251, 0.264613,
    0.281939, 0.302875, 0.322220, 0.338047,
    0.358015, 0.374856, 0.392117, 0.411892,
    0.422452, 0.445203, 0.458309, 0.473938,
    0.489985, 0.501283, 0.518384, 0.529397,
    0.536327, 0.549020, 0.556372, 0.563829,
    0.570313, 0.579336, 0.582671, 0.588878,
    0.588130, 0.589225, 0.591651, 0.589475,
    0.591542, 0.588980, 0.581796, 0.580281,
    0.572138, 0.571236, 0.560902, 0.552337,
    0.543311, 0.532282, 0.524528, 0.512192,
    0.498527, 0.487655, 0.475461, 0.459334,
    0.446311, 0.431860, 0.417361, 0.404434,
    0.385343, 0.371701, 0.354335, 0.340954,
    0.325375, 0.307965, 0.293464, 0.277349,
    0.262578, 0.249238, 0.233649, 0.219962,
    0.204886, 0.191519, 0.178548, 0.166317,
    0.153230, 0.142508, 0.131342, 0.119412,
    0.109608, 0.099430, 0.090052, 0.081808,
    0.072481, 0.065872, 0.058346, 0.051793,
    0.045835, 0.040008, 0.035165, 0.030397,
    0.025944, 0.022253, 0.018782, 0.015748,
    0.013077, 0.010813, 0.008768, 0.007065,
    0.005557, 0.004321, 0.003313, 0.002472,
    0.001817, 0.001290, 0.000881, 0.000583,
    0.000364, 0.000216, 0.000117, 0.000056,
    0.000023, 0.000007, 0.000001, 0.000000,
  },
  { /* wavelet type 3, n_levels 2, low */
    4.018015, 4.004651, 4.002912, 3.962997,
    3.945035, 3.934522, 3.879685, 3.837979,
    3.803062, 3.760686, 3.703711, 3.631829,
    3.585704, 3.499915, 3.433670, 3.349924,
    3.274991, 3.201063, 3.097869, 3.031924,
    2.933240, 2.824423, 2.724634, 2.629738,
    2.540180, 2.432355, 2.324094, 2.214624,
    2.104537, 2.030086, 1.924348, 1.803836,
    1.705314, 1.602183, 1.517777, 1.421132,
    1.306617, 1.218221, 1.131248, 1.045986,
    0.963251, 0.877403, 0.797777, 0.723581,
    0.655224, 0.588195, 0.519576, 0.461733,
    0.403835, 0.350675, 0.302692, 0.257384,
    0.217551, 0.179410, 0.146622, 0.117015,
    0.090786, 0.068156, 0.049213, 0.033717,
    0.021061, 0.011591, 0.005070, 0.001236,
    0.000000, 0.001177, 0.004596, 0.010002,
    0.017301, 0.026362, 0.036619, 0.048254,
    0.061146, 0.074954, 0.089298, 0.103859,
    0.119663, 0.134467, 0.150138, 0.165064,
    0.180297, 0.195425, 0.208348, 0.223326,
    0.235391, 0.245783, 0.256018, 0.265795,
    0.275203, 0.281569, 0.286623, 0.290196,
    0.292285, 0.298146, 0.298225, 0.294407,
    0.292586, 0.288481, 0.286338, 0.280494,
    0.269433, 0.262104, 0.253639, 0.244114,
    0.233745, 0.221153, 0.208662, 0.196210,
    0.184042, 0.170997, 0.156213, 0.143464,
    0.129579, 0.116125, 0.103381, 0.090610,
    0.078898, 0.066993, 0.056342, 0.046250,
    0.036892, 0.028462, 0.021110, 0.014851,
    0.009521, 0.005376, 0.002412, 0.000603,
  },
  { /* wavelet type 3, n_levels 3, high */
    0.001651, 0.004839, 0.019159, 0.042823,
    0.075211, 0.116780, 0.164060, 0.217711,
    0.277220, 0.344538, 0.412597, 0.481487,
    0.555375, 0.624522, 0.695875, 0.760309,
    0.821210, 0.880039, 0.934032, 0.975784,
    1.015988, 1.040211, 1.064579, 1.078235,
    1.073536, 1.071854, 1.065353, 1.053615,
    1.018323, 0.985914, 0.944265, 0.898629,
    0.854727, 0.798170, 0.744763, 0.690175,
    0.632233, 0.579573, 0.518558, 0.460930,
    0.407091, 0.359749, 0.311710, 0.266489,
    0.226950, 0.189303, 0.156656, 0.126940,
    0.101262, 0.079590, 0.061344, 0.045927,
    0.033696, 0.023785, 0.016334, 0.010720,
    0.006618, 0.003866, 0.002081, 0.001001,
    0.000402, 0.000125, 0.000024, 0.000001,
    0.000000, 0.000001, 0.000022, 0.000108,
    0.000330, 0.000782, 0.001548, 0.002737,
    0.004457, 0.006867, 0.009948, 0.013769,
    0.018534, 0.023994, 0.030427, 0.037463,
    0.045210, 0.053727, 0.062819, 0.071874,
    0.081532, 0.090520, 0.100032, 0.108980,
    0.116307, 0.124078, 0.131387, 0.138062,
    0.141428, 0.144795, 0.146337, 0.146667,
    0.146648, 0.143715, 0.140504, 0.136222,
    0.130371, 0.124697, 0.116267, 0.107573,
    0.098786, 0.090676, 0.081529, 0.072262,
    0.063747, 0.055033, 0.047100, 0.039441,
    0.032492, 0.026356, 0.020951, 0.016168,
    0.012220, 0.008882, 0.006277, 0.004237,
    0.002689, 0.001614, 0.000893, 0.000441,
    0.000182, 0.000058, 0.000012, 0.000001,
  },
  { /* wavelet type 3, n_levels 3, low */
    8.062731, 7.919124, 7.910108, 7.763633,
    7.600093, 7.413601, 7.171674, 6.821633,
    6.488860, 6.150393, 5.761420, 5.374051,
    4.937562, 4.542007, 4.103923, 3.710333,
    3.277144, 2.897987, 2.498665, 2.146962,
    1.800576, 1.498459, 1.213614, 0.963228,
    0.739817, 0.550560, 0.394439, 0.263420,
    0.161226, 0.086642, 0.036781, 0.008649,
    0.000000, 0.007682, 0.029010, 0.060652,
    0.100098, 0.144902, 0.191992, 0.236757,
    0.280543, 0.321378, 0.355348, 0.383886,
    0.402210, 0.416512, 0.419077, 0.418017,
    0.404100, 0.388404, 0.361778, 0.334019,
    0.299571, 0.265475, 0.228082, 0.191371,
    0.154901, 0.121141, 0.090971, 0.063531,
    0.040573, 0.022706, 0.010020, 0.002445,
    0.000000, 0.002328, 0.009082, 0.019594,
    0.033330, 0.049673, 0.067690, 0.085768,
    0.104328, 0.122583, 0.138910, 0.153681,
    0.164777, 0.174504, 0.179445, 0.182822,
    0.180416, 0.176923, 0.168049, 0.158141,
    0.144495, 0.130397, 0.114036, 0.097356,
    0.080152, 0.063733, 0.048645, 0.034517,
    0.022392, 0.012725, 0.005700, 0.001412,
    0.000000, 0.001383, 0.005473, 0.011971,
    0.020641, 0.031176, 0.043047, 0.055255,
    0.068077, 0.081005, 0.092943, 0.104096,
    0.112975, 0.121086, 0.125998, 0.129881,
    0.129664, 0.128619, 0.123561, 0.117589,
    0.108644, 0.099130, 0.087645, 0.075640,
    0.062946, 0.050588, 0.039022, 0.027982,
    0.018342, 0.010532, 0.004767, 0.001193,
  },
  { /* wavelet type 3, n_levels 4, high */
    0.001701, 0.038326, 0.151509, 0.328045,
    0.557922, 0.819717, 1.097042, 1.372419,
    1.612052, 1.833130, 1.987515, 2.084868,
    2.119055, 2.079199, 1.992807, 1.825678,
    1.648329, 1.425962, 1.213317, 0.982817,
    0.772754, 0.581328, 0.418660, 0.287091,
    0.183796, 0.110765, 0.060337, 0.029126,
    0.011836, 0.003661, 0.000704, 0.000042,
    0.000000, 0.000037, 0.000556, 0.002563,
    0.007348, 0.016022, 0.029369, 0.047632,
    0.069696, 0.095787, 0.122584, 0.148929,
    0.172617, 0.190667, 0.203498, 0.205686,
    0.203253, 0.191115, 0.175674, 0.152904,
    0.128567, 0.102991, 0.078681, 0.057038,
    0.038483, 0.024372, 0.013916, 0.007025,
    0.002978, 0.000959, 0.000192, 0.000012,
    0.000000, 0.000011, 0.000174, 0.000828,
    0.002447, 0.005492, 0.010354, 0.017255,
    0.025919, 0.036536, 0.047920, 0.059621,
    0.070718, 0.079883, 0.087136, 0.089958,
    0.090745, 0.087055, 0.081602, 0.072392,
    0.062013, 0.050588, 0.039339, 0.029017,
    0.019912, 0.012822, 0.007441, 0.003817,
    0.001644, 0.000538, 0.000109, 0.000007,
    0.000000, 0.000007, 0.000105, 0.000506,
    0.001515, 0.003447, 0.006585, 0.011117,
    0.016913, 0.024143, 0.032062, 0.040384,
    0.048485, 0.055430, 0.061183, 0.063908,
    0.065218, 0.063287, 0.059999, 0.053829,
    0.046627, 0.038458, 0.030235, 0.022544,
    0.015638, 0.010178, 0.005969, 0.003094,
    0.001347, 0.000445, 0.000091, 0.000006,
  },
  { /* wavelet type 3, n_levels 4, low */
    15.997478, 15.829120, 15.252260, 14.260300,
    13.000626, 11.467471, 9.811182, 8.160368,
    6.487478, 4.944460, 3.543399, 2.380766,
    1.453833, 0.765554, 0.314288, 0.071148,
    0.000000, 0.055571, 0.191354, 0.361870,
    0.530168, 0.663834, 0.746399, 0.774364,
    0.739659, 0.658607, 0.539610, 0.407462,
    0.275791, 0.159145, 0.070921, 0.017289,
    0.000000, 0.015356, 0.055937, 0.111407,
    0.171227, 0.224137, 0.262654, 0.283221,
    0.280483, 0.258364, 0.218547, 0.170066,
    0.118428, 0.070203, 0.032094, 0.008016,
    0.000000, 0.007448, 0.027706, 0.056299,
    0.088207, 0.117608, 0.140275, 0.153848,
    0.154868, 0.144915, 0.124452, 0.098270,
    0.069404, 0.041707, 0.019320, 0.004887,
    0.000000, 0.004653, 0.017513, 0.035991,
    0.057013, 0.076835, 0.092603, 0.102599,
    0.104306, 0.098548, 0.085433, 0.068082,
    0.048518, 0.029413, 0.013742, 0.003506,
    0.000000, 0.003393, 0.012870, 0.026655,
    0.042546, 0.057767, 0.070135, 0.078267,
    0.080135, 0.076240, 0.066548, 0.053392,
    0.038303, 0.023373, 0.010991, 0.002822,
    0.000000, 0.002765, 0.010553, 0.021989,
    0.035308, 0.048224, 0.058890, 0.066099,
    0.068063, 0.065122, 0.057162, 0.046116,
    0.033265, 0.020409, 0.009649, 0.002491,
    0.000000, 0.002466, 0.009463, 0.019820,
    0.031990, 0.043916, 0.053903, 0.060809,
    0.062932, 0.060515, 0.053385, 0.043283,
    0.031376, 0.019346, 0.009192, 0.002384,
}
},
{
  { /* wavelet type 4, n_levels 1, high */
    0.000806, 0.000044, 0.000157, 0.000344,
    0.000605, 0.000948, 0.001363, 0.001849,
    0.002402, 0.003043, 0.003740, 0.004527,
    0.005413, 0.006310, 0.007315, 0.008423,
    0.009456, 0.010693, 0.011977, 0.013368,
    0.014767, 0.016283, 0.017858, 0.019306,
    0.020972, 0.022784, 0.024566, 0.026600,
    0.028375, 0.030490, 0.032368, 0.034446,
    0.036572, 0.038925, 0.040903, 0.043407,
    0.045830, 0.048068, 0.050588, 0.053093,
    0.055521, 0.058075, 0.061047, 0.063490,
    0.066130, 0.069032, 0.071475, 0.074429,
    0.076889, 0.080075, 0.082817, 0.085841,
    0.088356, 0.091847, 0.094616, 0.097464,
    0.100731, 0.104032, 0.106621, 0.109481,
    0.112014, 0.115317, 0.118830, 0.121650,
    0.124587, 0.127765, 0.131093, 0.133630,
    0.136355, 0.140019, 0.143289, 0.146936,
    0.149566, 0.152153, 0.155356, 0.158651,
    0.160638, 0.164307, 0.166967, 0.170101,
    0.172208, 0.175857, 0.178232, 0.181807,
    0.184072, 0.186892, 0.190212, 0.191705,
    0.194306, 0.197201, 0.199644, 0.201755,
    0.204843, 0.206893, 0.208151, 0.211797,
    0.213108, 0.215356, 0.217492, 0.220634,
    0.221599, 0.224692, 0.225051, 0.226977,
    0.227831, 0.229490, 0.233103, 0.234267,
    0.235265, 0.236923, 0.237405, 0.238430,
    0.238886, 0.242801, 0.242743, 0.243495,
    0.245685, 0.245128, 0.245378, 0.246861,
    0.247081, 0.248477, 0.249379, 0.249594,
    0.248151, 0.248618, 0.250805, 0.249091,
  },
  { /* wavelet type 4, n_levels 1, low */
    0.998443, 1.003652, 1.001016, 0.996621,
    0.998828, 0.993762, 0.997257, 0.992822,
    0.991092, 0.987433, 0.980029, 0.982836,
    0.978727, 0.978081, 0.968536, 0.963377,
    0.960105, 0.959063, 0.947386, 0.943162,
    0.941407, 0.929917, 0.930037, 0.924322,
    0.915625, 0.907764, 0.901489, 0.892129,
    0.884073, 0.880877, 0.873240, 0.861576,
    0.855335, 0.846330, 0.834843, 0.826742,
    0.818542, 0.807717, 0.798169, 0.786959,
    0.776066, 0.767654, 0.756424, 0.746448,
    0.737922, 0.723057, 0.710895, 0.700637,
    0.693083, 0.681083, 0.673115, 0.657189,
    0.645556, 0.632993, 0.621641, 0.608030,
    0.598387, 0.583181, 0.572912, 0.561271,
    0.548830, 0.533831, 0.523898, 0.511375,
    0.495517, 0.486877, 0.474889, 0.460671,
    0.450845, 0.438846, 0.426298, 0.412890,
    0.403022, 0.389476, 0.378602, 0.366433,
    0.355085, 0.343341, 0.333872, 0.320587,
    0.309435, 0.296540, 0.285067, 0.274530,
    0.265101, 0.253551, 0.242747, 0.232548,
    0.221724, 0.211842, 0.202231, 0.192408,
    0.183104, 0.173446, 0.164037, 0.155516,
    0.146752, 0.137789, 0.129936, 0.121710,
    0.113183, 0.105585, 0.098384, 0.091104,
    0.084255, 0.077733, 0.071226, 0.064600,
    0.059067, 0.053193, 0.047773, 0.042983,
    0.037988, 0.033395, 0.029161, 0.025322,
    0.021535, 0.018129, 0.014909, 0.012144,
    0.009614, 0.007363, 0.005426, 0.003751,
    0.002411, 0.001352, 0.000603, 0.000151,
  },
  { /* wavelet type 4, n_levels 2, high */
    0.000406, 0.000156, 0.000608, 0.001352,
    0.002382, 0.003753, 0.005365, 0.007274,
    0.009401, 0.011870, 0.014560, 0.017462,
    0.020590, 0.023972, 0.027501, 0.031189,
    0.035352, 0.039172, 0.043349, 0.047921,
    0.052240, 0.056774, 0.061767, 0.066188,
    0.070735, 0.075501, 0.079693, 0.084660,
    0.088838, 0.093560, 0.098305, 0.102309,
    0.106784, 0.110591, 0.114905, 0.118288,
    0.121579, 0.125551, 0.128198, 0.131956,
    0.134560, 0.137328, 0.140119, 0.141223,
    0.142957, 0.144798, 0.145271, 0.146339,
    0.148068, 0.147441, 0.147879, 0.147969,
    0.147492, 0.147020, 0.146355, 0.145176,
    0.143266, 0.142354, 0.140413, 0.138734,
    0.134765, 0.132960, 0.130878, 0.127363,
    0.124154, 0.121261, 0.118635, 0.114738,
    0.110705, 0.108473, 0.104480, 0.100786,
    0.096492, 0.092993, 0.089135, 0.085108,
    0.081128, 0.077305, 0.073349, 0.069401,
    0.066107, 0.061937, 0.058253, 0.054977,
    0.051358, 0.047970, 0.044966, 0.041601,
    0.038444, 0.035521, 0.032482, 0.029908,
    0.027197, 0.024816, 0.022578, 0.020322,
    0.018321, 0.016362, 0.014628, 0.012927,
    0.011373, 0.010020, 0.008697, 0.007577,
    0.006509, 0.005566, 0.004730, 0.003944,
    0.003278, 0.002703, 0.002186, 0.001756,
    0.001399, 0.001081, 0.000828, 0.000621,
    0.000453, 0.000322, 0.000221, 0.000146,
    0.000091, 0.000054, 0.000029, 0.000014,
    0.000006, 0.000002, 0.000000, 0.000000,
  },
  { /* wavelet type 4, n_levels 2, low */
    1.008294, 1.002310, 0.997248, 0.991985,
    0.992559, 0.980531, 0.975146, 0.967305,
    0.951669, 0.938959, 0.925192, 0.907394,
    0.895205, 0.876136, 0.862898, 0.843806,
    0.820765, 0.797374, 0.776325, 0.752514,
    0.730463, 0.710677, 0.680844, 0.656741,
    0.633669, 0.607166, 0.580508, 0.558010,
    0.531283, 0.505201, 0.479443, 0.452633,
    0.427063, 0.402033, 0.378148, 0.353659,
    0.329851, 0.306950, 0.282561, 0.261099,
    0.240291, 0.219119, 0.199352, 0.182066,
    0.163170, 0.145988, 0.130206, 0.115016,
    0.101207, 0.088331, 0.076068, 0.064431,
    0.054314, 0.044825, 0.036626, 0.029216,
    0.022718, 0.017178, 0.012369, 0.008403,
    0.005299, 0.002901, 0.001263, 0.000309,
    0.000000, 0.000295, 0.001145, 0.002504,
    0.004353, 0.006570, 0.009204, 0.012162,
    0.015301, 0.018714, 0.022307, 0.025949,
    0.029875, 0.033661, 0.037730, 0.041578,
    0.045185, 0.048680, 0.052212, 0.055429,
    0.058619, 0.061844, 0.063975, 0.066379,
    0.068652, 0.070285, 0.071592, 0.073119,
    0.073786, 0.074196, 0.074301, 0.073875,
    0.073272, 0.072388, 0.071340, 0.069803,
    0.068018, 0.066041, 0.063354, 0.060936,
    0.058310, 0.055230, 0.052141, 0.049370,
    0.045832, 0.042441, 0.039147, 0.035736,
    0.032474, 0.029251, 0.025980, 0.022682,
    0.019698, 0.016738, 0.014074, 0.011548,
    0.009232, 0.007173, 0.005306, 0.003701,
    0.002395, 0.001346, 0.000601, 0.000151,
  },
  { /* wavelet type 4, n_levels 3, high */
    0.000206, 0.000609, 0.002400, 0.005357,
    0.009446, 0.014436, 0.020443, 0.027222,
    0.034732, 0.043065, 0.051297, 0.060400,
    0.069125, 0.077943, 0.086178, 0.094584,
    0.102993, 0.109472, 0.115677, 0.121772,
    0.126459, 0.130479, 0.132374, 0.134774,
    0.134500, 0.134011, 0.132738, 0.130232,
    0.127949, 0.123339, 0.118312, 0.112898,
    0.107753, 0.100277, 0.093315, 0.086341,
    0.079438, 0.071638, 0.064610, 0.057629,
    0.051003, 0.044967, 0.038759, 0.033427,
    0.028248, 0.023624, 0.019401, 0.015791,
    0.012700, 0.009901, 0.007597, 0.005732,
    0.004194, 0.002984, 0.002031, 0.001340,
    0.000829, 0.000483, 0.000259, 0.000124,
    0.000050, 0.000016, 0.000003, 0.000000,
    0.000000, 0.000000, 0.000003, 0.000014,
    0.000041, 0.000097, 0.000193, 0.000342,
    0.000558, 0.000858, 0.001237, 0.001727,
    0.002307, 0.002995, 0.003768, 0.004661,
    0.005670, 0.006683, 0.007780, 0.008969,
    0.010148, 0.011354, 0.012438, 0.013622,
    0.014572, 0.015513, 0.016370, 0.017065,
    0.017770, 0.018114, 0.018335, 0.018426,
    0.018487, 0.018055, 0.017604, 0.017042,
    0.016381, 0.015413, 0.014486, 0.013450,
    0.012377, 0.011334, 0.010138, 0.009064,
    0.007934, 0.006868, 0.005833, 0.004906,
    0.004075, 0.003279, 0.002595, 0.002018,
    0.001521, 0.001114, 0.000780, 0.000530,
    0.000337, 0.000202, 0.000111, 0.000054,
    0.000023, 0.000007, 0.000001, 0.000000,
  },
  { /* wavelet type 4, n_levels 3, low */
    1.006367, 1.001665, 0.982750, 0.975829,
    0.947261, 0.924336, 0.894690, 0.851131,
    0.813173, 0.768413, 0.717653, 0.670502,
    0.623827, 0.566936, 0.516041, 0.459400,
    0.412065, 0.358818, 0.314191, 0.267985,
    0.227490, 0.186957, 0.151170, 0.120343,
    0.092713, 0.068693, 0.049208, 0.032843,
    0.020095, 0.010890, 0.004570, 0.001094,
    0.000000, 0.000972, 0.003604, 0.007624,
    0.012476, 0.018067, 0.023952, 0.029540,
    0.035157, 0.040152, 0.044263, 0.047896,
    0.050816, 0.051989, 0.052696, 0.051757,
    0.050811, 0.048091, 0.045491, 0.041692,
    0.037849, 0.033122, 0.028410, 0.023909,
    0.019412, 0.015115, 0.011349, 0.007921,
    0.005057, 0.002854, 0.001245, 0.000309,
    0.000000, 0.000294, 0.001128, 0.002463,
    0.004154, 0.006193, 0.008445, 0.010701,
    0.013074, 0.015315, 0.017303, 0.019174,
    0.020818, 0.021782, 0.022564, 0.022636,
    0.022685, 0.021906, 0.021131, 0.019739,
    0.018256, 0.016269, 0.014205, 0.012163,
    0.010044, 0.007952, 0.006069, 0.004304,
    0.002791, 0.001599, 0.000708, 0.000179,
    0.000000, 0.000175, 0.000680, 0.001505,
    0.002573, 0.003887, 0.005370, 0.006894,
    0.008531, 0.010120, 0.011577, 0.012988,
    0.014274, 0.015114, 0.015843, 0.016081,
    0.016304, 0.015925, 0.015537, 0.014678,
    0.013726, 0.012368, 0.010917, 0.009450,
    0.007888, 0.006312, 0.004868, 0.003489,
    0.002286, 0.001324, 0.000592, 0.000151,
  },
  { /* wavelet type 4, n_levels 4, high */
    0.000106, 0.002394, 0.009428, 0.020609,
    0.034888, 0.051182, 0.068768, 0.085619,
    0.101361, 0.114355, 0.124600, 0.130174,
    0.132523, 0.130647, 0.124022, 0.114072,
    0.103390, 0.089097, 0.075511, 0.061755,
    0.048327, 0.036297, 0.026246, 0.017909,
    0.011557, 0.006910, 0.003782, 0.001819,
    0.000740, 0.000230, 0.000044, 0.000003,
    0.000000, 0.000002, 0.000035, 0.000161,
    0.000460, 0.001000, 0.001841, 0.002972,
    0.004382, 0.005975, 0.007685, 0.009299,
    0.010795, 0.011981, 0.012665, 0.012852,
    0.012749, 0.011941, 0.010933, 0.009608,
    0.008040, 0.006431, 0.004933, 0.003558,
    0.002420, 0.001520, 0.000872, 0.000439,
    0.000186, 0.000060, 0.000012, 0.000001,
    0.000000, 0.000001, 0.000011, 0.000052,
    0.000153, 0.000343, 0.000649, 0.001076,
    0.001630, 0.002279, 0.003004, 0.003723,
    0.004423, 0.005019, 0.005423, 0.005621,
    0.005692, 0.005439, 0.005078, 0.004549,
    0.003878, 0.003159, 0.002466, 0.001810,
    0.001252, 0.000800, 0.000466, 0.000238,
    0.000103, 0.000034, 0.000007, 0.000000,
    0.000000, 0.000000, 0.000007, 0.000032,
    0.000095, 0.000215, 0.000413, 0.000694,
    0.001063, 0.001506, 0.002010, 0.002521,
    0.003032, 0.003483, 0.003808, 0.003993,
    0.004091, 0.003954, 0.003734, 0.003382,
    0.002916, 0.002401, 0.001895, 0.001406,
    0.000983, 0.000635, 0.000374, 0.000193,
    0.000084, 0.000028, 0.000006, 0.000000,
  },
  { /* wavelet type 4, n_levels 4, low */
    1.002702, 0.989281, 0.954609, 0.891052,
    0.812346, 0.720936, 0.614692, 0.512573,
    0.406052, 0.310574, 0.222002, 0.149674,
    0.090843, 0.047835, 0.019671, 0.004447,
    0.000000, 0.003473, 0.011976, 0.022611,
    0.033128, 0.041734, 0.046764, 0.048640,
    0.046295, 0.041369, 0.033808, 0.025616,
    0.017233, 0.009944, 0.004439, 0.001081,
    0.000000, 0.000960, 0.003501, 0.006961,
    0.010699, 0.014091, 0.016456, 0.017790,
    0.017555, 0.016228, 0.013692, 0.010692,
    0.007400, 0.004387, 0.002009, 0.000501,
    0.000000, 0.000465, 0.001734, 0.003518,
    0.005512, 0.007394, 0.008789, 0.009664,
    0.009693, 0.009102, 0.007797, 0.006178,
    0.004337, 0.002606, 0.001209, 0.000305,
    0.000000, 0.000291, 0.001096, 0.002249,
    0.003562, 0.004830, 0.005802, 0.006445,
    0.006529, 0.006190, 0.005353, 0.004280,
    0.003032, 0.001838, 0.000860, 0.000219,
    0.000000, 0.000212, 0.000805, 0.001666,
    0.002658, 0.003632, 0.004394, 0.004916,
    0.005016, 0.004789, 0.004169, 0.003357,
    0.002393, 0.001460, 0.000688, 0.000176,
    0.000000, 0.000173, 0.000660, 0.001374,
    0.002206, 0.003032, 0.003690, 0.004152,
    0.004260, 0.004090, 0.003581, 0.002899,
    0.002079, 0.001275, 0.000604, 0.000156,
    0.000000, 0.000154, 0.000592, 0.001238,
    0.001999, 0.002761, 0.003377, 0.003820,
    0.003939, 0.003801, 0.003345, 0.002721,
    0.001961, 0.001209, 0.000575, 0.000149,
}
},
{
  { /* wavelet type 5, n_levels 1, high */
    0.002595, 0.002597, 0.002600, 0.002606,
    0.002619, 0.002635, 0.002663, 0.002695,
    0.002729, 0.002776, 0.002818, 0.002862,
    0.002887, 0.002915, 0.002926, 0.002918,
    0.002888, 0.002872, 0.002837, 0.002804,
    0.002786, 0.002783, 0.002801, 0.002838,
    0.002895, 0.002968, 0.003054, 0.003136,
    0.003203, 0.003260, 0.003300, 0.003314,
    0.003315, 0.003315, 0.003324, 0.003357,
    0.003425, 0.003533, 0.003682, 0.003870,
    0.004069, 0.004247, 0.004381, 0.004432,
    0.004405, 0.004284, 0.004147, 0.004088,
    0.004303, 0.005064, 0.006741, 0.009859,
    0.014935, 0.022710, 0.033938, 0.049836,
    0.070242, 0.096776, 0.131264, 0.171956,
    0.221314, 0.278327, 0.343740, 0.421060,
    0.504085, 0.595385, 0.687968, 0.792338,
    0.902305, 1.011408, 1.125901, 1.228590,
    1.337175, 1.449565, 1.539085, 1.631291,
    1.712787, 1.791943, 1.855993, 1.923277,
    1.973381, 2.004378, 2.023211, 2.046509,
    2.069794, 2.068362, 2.068938, 2.072374,
    2.053384, 2.034586, 2.027720, 2.029951,
    1.998720, 1.991417, 1.985641, 1.976770,
    1.973506, 1.969570, 1.956708, 1.955048,
    1.955800, 1.960471, 1.967690, 1.977747,
    1.983530, 1.989884, 1.996222, 1.999750,
    2.009197, 2.020285, 2.030327, 2.029737,
    2.040368, 2.051355, 2.050382, 2.041016,
    2.052132, 2.042117, 2.036588, 2.040382,
    2.023273, 2.036546, 2.018233, 2.013358,
    2.015954, 2.009561, 2.000925, 2.012375,
  },
  { /* wavelet type 5, n_levels 1, low */
    0.500354, 0.500909, 0.502459, 0.497063,
    0.500583, 0.496434, 0.496028, 0.495888,
    0.490318, 0.491619, 0.491063, 0.490099,
    0.490859, 0.493032, 0.490001, 0.487984,
    0.491228, 0.493291, 0.492319, 0.495210,
    0.496340, 0.498262, 0.501362, 0.502826,
    0.503675, 0.507398, 0.507418, 0.510305,
    0.510615, 0.509443, 0.511850, 0.513170,
    0.507748, 0.505713, 0.503861, 0.500335,
    0.498501, 0.495215, 0.492960, 0.487586,
    0.484018, 0.485884, 0.478905, 0.481812,
    0.483078, 0.488015, 0.492269, 0.496882,
    0.505814, 0.516459, 0.534585, 0.545753,
    0.563953, 0.576369, 0.591982, 0.602367,
    0.615686, 0.621857, 0.624499, 0.620840,
    0.610190, 0.591889, 0.569175, 0.535250,
    0.497930, 0.452891, 0.406175, 0.354118,
    0.303100, 0.253124, 0.205284, 0.161135,
    0.122698, 0.089177, 0.062598, 0.041364,
    0.025731, 0.014741, 0.007905, 0.004215,
    0.002820, 0.002940, 0.003893, 0.005181,
    0.006340, 0.007290, 0.007809, 0.007909,
    0.007608, 0.007093, 0.006344, 0.005509,
    0.004699, 0.003966, 0.003325, 0.002814,
    0.002425, 0.002163, 0.001993, 0.001891,
    0.001839, 0.001817, 0.001805, 0.001794,
    0.001783, 0.001759, 0.001727, 0.001695,
    0.001657, 0.001628, 0.001597, 0.001573,
    0.001554, 0.001539, 0.001528, 0.001519,
    0.001510, 0.001501, 0.001491, 0.001478,
    0.001466, 0.001456, 0.001445, 0.001435,
    0.001428, 0.001422, 0.001418, 0.001416,
  },
  { /* wavelet type 5, n_levels 2, high */
    0.004724, 0.004723, 0.004726, 0.004738,
    0.004761, 0.004788, 0.004808, 0.004826,
    0.004813, 0.004793, 0.004793, 0.004834,
    0.004920, 0.005043, 0.005168, 0.005274,
    0.005356, 0.005431, 0.005546, 0.005745,
    0.005988, 0.006238, 0.006358, 0.006398,
    0.006751, 0.008371, 0.012944, 0.023116,
    0.042056, 0.072905, 0.119245, 0.180859,
    0.258314, 0.352147, 0.456199, 0.560656,
    0.663925, 0.756761, 0.832879, 0.896570,
    0.946287, 0.969998, 0.987442, 0.997235,
    0.990770, 0.986439, 0.993097, 0.988018,
    1.004891, 1.017268, 1.037004, 1.077121,
    1.109456, 1.151329, 1.194006, 1.229384,
    1.262612, 1.268666, 1.273590, 1.262940,
    1.238807, 1.200836, 1.149052, 1.082965,
    0.997877, 0.916663, 0.821101, 0.719983,
    0.617317, 0.516508, 0.420541, 0.331392,
    0.253885, 0.184304, 0.127961, 0.084162,
    0.052190, 0.030423, 0.016588, 0.009174,
    0.006291, 0.006402, 0.008246, 0.010775,
    0.013324, 0.015224, 0.016219, 0.016218,
    0.015411, 0.013828, 0.011923, 0.009953,
    0.008215, 0.006837, 0.005793, 0.005105,
    0.004677, 0.004419, 0.004257, 0.004135,
    0.004037, 0.003950, 0.003874, 0.003805,
    0.003745, 0.003689, 0.003635, 0.003584,
    0.003539, 0.003493, 0.003454, 0.003414,
    0.003376, 0.003344, 0.003308, 0.003277,
    0.003250, 0.003220, 0.003194, 0.003167,
    0.003145, 0.003125, 0.003106, 0.003091,
    0.003078, 0.003068, 0.003062, 0.003058,
  },
  { /* wavelet type 5, n_levels 2, low */
    0.251971, 0.250260, 0.249298, 0.247372,
    0.247843, 0.244483, 0.244701, 0.243708,
    0.243555, 0.242427, 0.244513, 0.245713,
    0.247803, 0.248979, 0.250168, 0.250186,
    0.249932, 0.247870, 0.245530, 0.243274,
    0.241421, 0.243278, 0.242929, 0.248587,
    0.255961, 0.270254, 0.284892, 0.300515,
    0.312424, 0.315756, 0.307577, 0.284339,
    0.250465, 0.202281, 0.152001, 0.103334,
    0.062567, 0.032693, 0.014340, 0.005353,
    0.002518, 0.002749, 0.003775, 0.004380,
    0.004302, 0.003714, 0.002957, 0.002302,
    0.001867, 0.001634, 0.001544, 0.001520,
    0.001507, 0.001480, 0.001448, 0.001413,
    0.001387, 0.001369, 0.001353, 0.001337,
    0.001316, 0.001296, 0.001279, 0.001267,
    0.001257, 0.001248, 0.001237, 0.001225,
    0.001210, 0.001189, 0.001163, 0.001135,
    0.001106, 0.001081, 0.001052, 0.001025,
    0.000995, 0.000963, 0.000929, 0.000895,
    0.000859, 0.000824, 0.000795, 0.000777,
    0.000764, 0.000757, 0.000737, 0.000710,
    0.000686, 0.000682, 0.000712, 0.000766,
    0.000825, 0.000847, 0.000821, 0.000750,
    0.000661, 0.000587, 0.000541, 0.000527,
    0.000533, 0.000548, 0.000560, 0.000566,
    0.000561, 0.000552, 0.000537, 0.000523,
    0.000507, 0.000492, 0.000481, 0.000473,
    0.000467, 0.000464, 0.000463, 0.000463,
    0.000464, 0.000466, 0.000465, 0.000464,
    0.000463, 0.000460, 0.000459, 0.000458,
    0.000456, 0.000455, 0.000454, 0.000454,
  },
  { /* wavelet type 5, n_levels 3, high */
    0.005316, 0.005299, 0.005271, 0.005249,
    0.005234, 0.005263, 0.005396, 0.005604,
    0.005797, 0.005997, 0.006307, 0.006654,
    0.007279, 0.011096, 0.026114, 0.063420,
    0.130629, 0.222171, 0.324015, 0.406984,
    0.462533, 0.489195, 0.488459, 0.496384,
    0.500828, 0.527589, 0.567456, 0.609271,
    0.635695, 0.643378, 0.625581, 0.575561,
    0.503679, 0.410659, 0.311061, 0.212871,
    0.129572, 0.068456, 0.030192, 0.011707,
    0.005811, 0.006026, 0.007952, 0.009179,
    0.008772, 0.007235, 0.005567, 0.004435,
    0.003884, 0.003645, 0.003519, 0.003428,
    0.003359, 0.003305, 0.003257, 0.003215,
    0.003171, 0.003131, 0.003094, 0.003057,
    0.003022, 0.002989, 0.002958, 0.002929,
    0.002902, 0.002873, 0.002843, 0.002809,
    0.002767, 0.002722, 0.002670, 0.002611,
    0.002549, 0.002483, 0.002413, 0.002338,
    0.002263, 0.002184, 0.002103, 0.002021,
    0.001934, 0.001847, 0.001771, 0.001721,
    0.001691, 0.001673, 0.001636, 0.001578,
    0.001522, 0.001504, 0.001555, 0.001648,
    0.001742, 0.001779, 0.001704, 0.001558,
    0.001389, 0.001237, 0.001155, 0.001136,
    0.001160, 0.001196, 0.001221, 0.001231,
    0.001219, 0.001203, 0.001171, 0.001136,
    0.001095, 0.001057, 0.001027, 0.001009,
    0.001001, 0.000995, 0.000995, 0.000993,
    0.000988, 0.000988, 0.000985, 0.000983,
    0.000982, 0.000980, 0.000979, 0.000979,
    0.000977, 0.000977, 0.000977, 0.000976,
  },
  { /* wavelet type 5, n_levels 3, low */
    0.127119, 0.125727, 0.125124, 0.123451,
    0.121938, 0.123443, 0.123742, 0.124335,
    0.123178, 0.121895, 0.119121, 0.120075,
    0.125597, 0.137693, 0.149887, 0.147217,
    0.119203, 0.074049, 0.031952, 0.008626,
    0.002261, 0.002418, 0.002619, 0.002002,
    0.001448, 0.001254, 0.001209, 0.001171,
    0.001131, 0.001098, 0.001069, 0.001046,
    0.001036, 0.001024, 0.001001, 0.000961,
    0.000916, 0.000871, 0.000820, 0.000763,
    0.000701, 0.000642, 0.000605, 0.000575,
    0.000542, 0.000534, 0.000549, 0.000519,
    0.000435, 0.000383, 0.000387, 0.000407,
    0.000410, 0.000395, 0.000376, 0.000359,
    0.000348, 0.000343, 0.000340, 0.000337,
    0.000332, 0.000327, 0.000323, 0.000319,
    0.000317, 0.000314, 0.000310, 0.000306,
    0.000299, 0.000291, 0.000282, 0.000273,
    0.000266, 0.000261, 0.000257, 0.000253,
    0.000249, 0.000243, 0.000236, 0.000227,
    0.000221, 0.000217, 0.000214, 0.000208,
    0.000201, 0.000195, 0.000190, 0.000186,
    0.000180, 0.000175, 0.000170, 0.000166,
    0.000163, 0.000160, 0.000158, 0.000157,
    0.000156, 0.000156, 0.000156, 0.000155,
    0.000155, 0.000155, 0.000155, 0.000154,
    0.000154, 0.000153, 0.000152, 0.000149,
    0.000148, 0.000150, 0.000151, 0.000151,
    0.000148, 0.000144, 0.000141, 0.000140,
    0.000141, 0.000142, 0.000144, 0.000144,
    0.000145, 0.000145, 0.000145, 0.000145,
    0.000144, 0.000144, 0.000143, 0.000143,
  },
  { /* wavelet type 5, n_levels 4, high */
    0.005679, 0.005582, 0.005504, 0.005700,
    0.006092, 0.006551, 0.007645, 0.018500,
    0.067314, 0.155150, 0.218829, 0.237691,
    0.244399, 0.274728, 0.303556, 0.298851,
    0.241435, 0.152208, 0.066759, 0.018836,
    0.005229, 0.005133, 0.005319, 0.003909,
    0.003075, 0.002818, 0.002691, 0.002609,
    0.002541, 0.002482, 0.002431, 0.002397,
    0.002367, 0.002331, 0.002276, 0.002199,
    0.002108, 0.001997, 0.001878, 0.001742,
    0.001598, 0.001453, 0.001356, 0.001301,
    0.001232, 0.001203, 0.001205, 0.001103,
    0.000919, 0.000822, 0.000848, 0.000904,
    0.000911, 0.000887, 0.000839, 0.000795,
    0.000769, 0.000757, 0.000749, 0.000740,
    0.000734, 0.000729, 0.000721, 0.000717,
    0.000710, 0.000703, 0.000693, 0.000681,
    0.000666, 0.000649, 0.000631, 0.000614,
    0.000597, 0.000582, 0.000572, 0.000565,
    0.000555, 0.000541, 0.000521, 0.000500,
    0.000484, 0.000475, 0.000465, 0.000452,
    0.000433, 0.000419, 0.000408, 0.000396,
    0.000382, 0.000370, 0.000358, 0.000348,
    0.000339, 0.000333, 0.000330, 0.000327,
    0.000326, 0.000325, 0.000326, 0.000325,
    0.000326, 0.000326, 0.000325, 0.000323,
    0.000323, 0.000321, 0.000318, 0.000313,
    0.000310, 0.000311, 0.000315, 0.000316,
    0.000308, 0.000298, 0.000291, 0.000288,
    0.000290, 0.000293, 0.000297, 0.000300,
    0.000301, 0.000301, 0.000300, 0.000299,
    0.000298, 0.000299, 0.000298, 0.000298,
  },
  { /* wavelet type 5, n_levels 4, low */
    0.064230, 0.063741, 0.062202, 0.062262,
    0.061834, 0.059815, 0.062436, 0.070680,
    0.055026, 0.016703, 0.002116, 0.001753,
    0.001222, 0.001044, 0.000983, 0.000926,
    0.000905, 0.000877, 0.000805, 0.000723,
    0.000617, 0.000523, 0.000469, 0.000418,
    0.000323, 0.000314, 0.000325, 0.000302,
    0.000283, 0.000272, 0.000262, 0.000255,
    0.000252, 0.000249, 0.000239, 0.000225,
    0.000213, 0.000205, 0.000198, 0.000187,
    0.000174, 0.000167, 0.000156, 0.000147,
    0.000138, 0.000129, 0.000120, 0.000114,
    0.000110, 0.000108, 0.000108, 0.000108,
    0.000108, 0.000106, 0.000104, 0.000106,
    0.000105, 0.000098, 0.000097, 0.000098,
    0.000098, 0.000098, 0.000097, 0.000096,
    0.000096, 0.000096, 0.000094, 0.000093,
    0.000091, 0.000089, 0.000086, 0.000083,
    0.000084, 0.000085, 0.000083, 0.000082,
    0.000082, 0.000081, 0.000080, 0.000079,
    0.000078, 0.000077, 0.000076, 0.000075,
    0.000074, 0.000073, 0.000071, 0.000069,
    0.000068, 0.000066, 0.000064, 0.000063,
    0.000062, 0.000061, 0.000060, 0.000059,
    0.000058, 0.000058, 0.000057, 0.000057,
    0.000056, 0.000056, 0.000055, 0.000055,
    0.000055, 0.000054, 0.000053, 0.000053,
    0.000052, 0.000052, 0.000052, 0.000051,
    0.000051, 0.000051, 0.000050, 0.000050,
    0.000049, 0.000049, 0.000050, 0.000048,
    0.000045, 0.000046, 0.000049, 0.000050,
    0.000050, 0.000050, 0.000050, 0.000049,
}
},
{
  { /* wavelet type 6, n_levels 1, high */
    0.000553, 0.000553, 0.000553, 0.000554,
    0.000555, 0.000556, 0.000556, 0.000559,
    0.000560, 0.000563, 0.000567, 0.000574,
    0.000577, 0.000585, 0.000599, 0.000615,
    0.000639, 0.000678, 0.000732, 0.000802,
    0.000901, 0.001036, 0.001223, 0.001461,
    0.001764, 0.002170, 0.002661, 0.003271,
    0.004042, 0.004948, 0.006063, 0.007372,
    0.009020, 0.010781, 0.012997, 0.015435,
    0.018304, 0.021575, 0.025056, 0.029086,
    0.033609, 0.038726, 0.043839, 0.050262,
    0.056332, 0.063320, 0.070861, 0.078569,
    0.086427, 0.095468, 0.104300, 0.113921,
    0.124308, 0.134063, 0.144866, 0.155015,
    0.165599, 0.176705, 0.186427, 0.197338,
    0.208489, 0.218967, 0.228904, 0.239244,
    0.248845, 0.258137, 0.266732, 0.275631,
    0.283669, 0.290663, 0.297066, 0.305498,
    0.310578, 0.316542, 0.322205, 0.325464,
    0.330328, 0.331969, 0.334549, 0.337917,
    0.338548, 0.341795, 0.343868, 0.344149,
    0.343675, 0.346947, 0.343372, 0.346632,
    0.344465, 0.344107, 0.343252, 0.345289,
    0.343921, 0.343094, 0.343357, 0.341426,
    0.343992, 0.340985, 0.341927, 0.342292,
    0.344353, 0.342378, 0.344376, 0.345798,
    0.345556, 0.349152, 0.350143, 0.350198,
    0.350241, 0.352611, 0.354583, 0.358081,
    0.357902, 0.361298, 0.362604, 0.363269,
    0.365196, 0.368424, 0.369967, 0.371294,
    0.372755, 0.374818, 0.375376, 0.373707,
    0.376777, 0.377480, 0.376646, 0.379415,
  },
  { /* wavelet type 6, n_levels 1, low */
    0.668716, 0.657824, 0.662184, 0.661322,
    0.668182, 0.666077, 0.666719, 0.668314,
    0.671077, 0.678355, 0.683653, 0.684401,
    0.693741, 0.688476, 0.693567, 0.697310,
    0.700140, 0.705483, 0.707220, 0.705467,
    0.708888, 0.718672, 0.717257, 0.722719,
    0.721522, 0.722120, 0.721899, 0.725325,
    0.723239, 0.723033, 0.723836, 0.719420,
    0.716061, 0.713778, 0.701703, 0.697912,
    0.690726, 0.683464, 0.675482, 0.663488,
    0.660308, 0.645283, 0.633768, 0.620846,
    0.606675, 0.589822, 0.580432, 0.561179,
    0.545094, 0.531155, 0.509650, 0.492453,
    0.474675, 0.457072, 0.437225, 0.417769,
    0.398047, 0.378271, 0.360856, 0.339683,
    0.323416, 0.305768, 0.284644, 0.268699,
    0.252998, 0.234178, 0.216414, 0.202476,
    0.186719, 0.170521, 0.157700, 0.143721,
    0.131317, 0.119797, 0.108696, 0.098462,
    0.088443, 0.079228, 0.070657, 0.063427,
    0.055863, 0.049324, 0.043637, 0.037822,
    0.033139, 0.028913, 0.024924, 0.021477,
    0.018521, 0.015671, 0.013410, 0.011338,
    0.009571, 0.008067, 0.006744, 0.005724,
    0.004798, 0.004025, 0.003396, 0.002864,
    0.002446, 0.002107, 0.001818, 0.001607,
    0.001427, 0.001300, 0.001196, 0.001121,
    0.001060, 0.001017, 0.000989, 0.000964,
    0.000945, 0.000931, 0.000920, 0.000913,
    0.000906, 0.000901, 0.000896, 0.000893,
    0.000889, 0.000886, 0.000884, 0.000881,
    0.000879, 0.000878, 0.000877, 0.000875,
  },
  { /* wavelet type 6, n_levels 2, high */
    0.001160, 0.001161, 0.001165, 0.001176,
    0.001187, 0.001202, 0.001228, 0.001257,
    0.001307, 0.001394, 0.001528, 0.001777,
    0.002186, 0.002857, 0.003847, 0.005353,
    0.007532, 0.010449, 0.014324, 0.019436,
    0.025712, 0.033390, 0.042432, 0.053082,
    0.064653, 0.078095, 0.092164, 0.107014,
    0.121219, 0.136319, 0.152052, 0.164709,
    0.178060, 0.188816, 0.200815, 0.207068,
    0.213054, 0.219036, 0.221653, 0.222229,
    0.220569, 0.219622, 0.215936, 0.212054,
    0.207775, 0.203158, 0.196456, 0.191748,
    0.186735, 0.180068, 0.173804, 0.170405,
    0.164473, 0.160353, 0.154484, 0.148543,
    0.143136, 0.136726, 0.133123, 0.125521,
    0.120579, 0.114964, 0.108060, 0.101638,
    0.094768, 0.088688, 0.082226, 0.076309,
    0.069795, 0.063304, 0.058534, 0.052283,
    0.047595, 0.042927, 0.038680, 0.034834,
    0.030952, 0.027692, 0.024451, 0.021800,
    0.019497, 0.017199, 0.015086, 0.013341,
    0.011636, 0.010120, 0.008749, 0.007529,
    0.006374, 0.005420, 0.004524, 0.003742,
    0.003030, 0.002454, 0.001970, 0.001555,
    0.001222, 0.000963, 0.000763, 0.000608,
    0.000496, 0.000419, 0.000366, 0.000331,
    0.000309, 0.000296, 0.000289, 0.000285,
    0.000283, 0.000281, 0.000280, 0.000278,
    0.000276, 0.000274, 0.000273, 0.000271,
    0.000269, 0.000268, 0.000266, 0.000264,
    0.000263, 0.000262, 0.000262, 0.000261,
    0.000261, 0.000260, 0.000260, 0.000260,
  },
  { /* wavelet type 6, n_levels 2, low */
    0.438173, 0.441967, 0.444218, 0.446307,
    0.449549, 0.452663, 0.458776, 0.468048,
    0.472998, 0.477636, 0.484404, 0.490281,
    0.494331, 0.496326, 0.498736, 0.500035,
    0.499817, 0.492739, 0.485010, 0.476884,
    0.465039, 0.451514, 0.431323, 0.412652,
    0.391014, 0.366654, 0.340269, 0.312326,
    0.285939, 0.258881, 0.230278, 0.205259,
    0.178655, 0.154410, 0.130322, 0.109870,
    0.090837, 0.074022, 0.059747, 0.047476,
    0.037103, 0.028529, 0.021566, 0.016202,
    0.011887, 0.008666, 0.006303, 0.004587,
    0.003381, 0.002520, 0.001961, 0.001592,
    0.001347, 0.001190, 0.001077, 0.001000,
    0.000941, 0.000892, 0.000852, 0.000813,
    0.000779, 0.000748, 0.000719, 0.000692,
    0.000667, 0.000644, 0.000622, 0.000601,
    0.000580, 0.000562, 0.000543, 0.000526,
    0.000510, 0.000497, 0.000487, 0.000485,
    0.000489, 0.000503, 0.000529, 0.000571,
    0.000626, 0.000695, 0.000777, 0.000873,
    0.000981, 0.001095, 0.001200, 0.001311,
    0.001404, 0.001480, 0.001533, 0.001570,
    0.001583, 0.001570, 0.001533, 0.001475,
    0.001399, 0.001304, 0.001202, 0.001094,
    0.000987, 0.000885, 0.000785, 0.000701,
    0.000624, 0.000559, 0.000502, 0.000458,
    0.000420, 0.000392, 0.000373, 0.000357,
    0.000347, 0.000339, 0.000333, 0.000330,
    0.000328, 0.000326, 0.000325, 0.000324,
    0.000323, 0.000322, 0.000321, 0.000321,
    0.000321, 0.000320, 0.000320, 0.000320,
  },
  { /* wavelet type 6, n_levels 3, high */
    0.001988, 0.001997, 0.002036, 0.002097,
    0.002218, 0.002468, 0.003061, 0.004364,
    0.006967, 0.011892, 0.019790, 0.031476,
    0.046788, 0.064749, 0.085888, 0.106252,
    0.125212, 0.139851, 0.150423, 0.154181,
    0.156118, 0.153832, 0.147810, 0.140871,
    0.132081, 0.124855, 0.117665, 0.109499,
    0.102609, 0.094382, 0.085571, 0.076882,
    0.067359, 0.058055, 0.048713, 0.040547,
    0.033088, 0.026472, 0.021245, 0.016716,
    0.013054, 0.010188, 0.007775, 0.005815,
    0.004228, 0.002982, 0.002077, 0.001404,
    0.000957, 0.000672, 0.000513, 0.000426,
    0.000380, 0.000354, 0.000335, 0.000318,
    0.000302, 0.000287, 0.000272, 0.000259,
    0.000247, 0.000236, 0.000227, 0.000218,
    0.000210, 0.000202, 0.000194, 0.000187,
    0.000180, 0.000173, 0.000167, 0.000161,
    0.000154, 0.000148, 0.000142, 0.000136,
    0.000131, 0.000130, 0.000134, 0.000145,
    0.000167, 0.000198, 0.000235, 0.000277,
    0.000323, 0.000365, 0.000403, 0.000440,
    0.000467, 0.000497, 0.000523, 0.000539,
    0.000557, 0.000560, 0.000555, 0.000539,
    0.000512, 0.000477, 0.000435, 0.000393,
    0.000351, 0.000309, 0.000275, 0.000242,
    0.000214, 0.000191, 0.000169, 0.000152,
    0.000137, 0.000125, 0.000115, 0.000108,
    0.000104, 0.000101, 0.000100, 0.000099,
    0.000099, 0.000099, 0.000099, 0.000099,
    0.000099, 0.000099, 0.000099, 0.000099,
    0.000098, 0.000098, 0.000098, 0.000098,
  },
  { /* wavelet type 6, n_levels 3, low */
    0.292207, 0.295189, 0.298285, 0.307129,
    0.312898, 0.323471, 0.329078, 0.334797,
    0.333940, 0.326526, 0.313487, 0.291816,
    0.264399, 0.231758, 0.195198, 0.158539,
    0.123168, 0.090757, 0.063646, 0.042459,
    0.026897, 0.016212, 0.009362, 0.005393,
    0.003282, 0.002196, 0.001661, 0.001380,
    0.001205, 0.001074, 0.000966, 0.000878,
    0.000803, 0.000737, 0.000677, 0.000623,
    0.000574, 0.000538, 0.000521, 0.000534,
    0.000590, 0.000682, 0.000806, 0.000926,
    0.001032, 0.001094, 0.001089, 0.001035,
    0.000930, 0.000798, 0.000664, 0.000549,
    0.000457, 0.000390, 0.000343, 0.000314,
    0.000295, 0.000281, 0.000270, 0.000261,
    0.000252, 0.000243, 0.000235, 0.000228,
    0.000221, 0.000215, 0.000208, 0.000202,
    0.000197, 0.000191, 0.000186, 0.000181,
    0.000179, 0.000178, 0.000181, 0.000187,
    0.000196, 0.000207, 0.000216, 0.000224,
    0.000226, 0.000222, 0.000211, 0.000198,
    0.000184, 0.000170, 0.000157, 0.000148,
    0.000143, 0.000139, 0.000136, 0.000135,
    0.000133, 0.000132, 0.000130, 0.000128,
    0.000127, 0.000126, 0.000124, 0.000123,
    0.000121, 0.000120, 0.000119, 0.000118,
    0.000118, 0.000119, 0.000120, 0.000122,
    0.000124, 0.000125, 0.000125, 0.000125,
    0.000123, 0.000121, 0.000118, 0.000116,
    0.000114, 0.000113, 0.000112, 0.000111,
    0.000111, 0.000111, 0.000111, 0.000110,
    0.000110, 0.000110, 0.000110, 0.000110,
  },
  { /* wavelet type 6, n_levels 4, high */
    0.003000, 0.003067, 0.003329, 0.004195,
    0.007348, 0.016306, 0.034512, 0.059346,
    0.084620, 0.099726, 0.103963, 0.097953,
    0.088967, 0.079405, 0.069780, 0.058453,
    0.046357, 0.033897, 0.023497, 0.015372,
    0.009746, 0.005957, 0.003420, 0.001838,
    0.001010, 0.000656, 0.000520, 0.000453,
    0.000399, 0.000353, 0.000315, 0.000284,
    0.000259, 0.000237, 0.000216, 0.000197,
    0.000180, 0.000163, 0.000150, 0.000147,
    0.000166, 0.000204, 0.000254, 0.000294,
    0.000329, 0.000356, 0.000372, 0.000367,
    0.000338, 0.000289, 0.000242, 0.000199,
    0.000164, 0.000138, 0.000117, 0.000102,
    0.000094, 0.000089, 0.000086, 0.000083,
    0.000080, 0.000077, 0.000074, 0.000072,
    0.000069, 0.000067, 0.000065, 0.000063,
    0.000061, 0.000059, 0.000057, 0.000055,
    0.000054, 0.000054, 0.000056, 0.000058,
    0.000061, 0.000065, 0.000070, 0.000075,
    0.000077, 0.000076, 0.000072, 0.000068,
    0.000063, 0.000057, 0.000051, 0.000046,
    0.000043, 0.000042, 0.000042, 0.000042,
    0.000041, 0.000041, 0.000040, 0.000040,
    0.000039, 0.000039, 0.000039, 0.000038,
    0.000038, 0.000037, 0.000037, 0.000036,
    0.000036, 0.000037, 0.000038, 0.000039,
    0.000039, 0.000040, 0.000040, 0.000040,
    0.000040, 0.000039, 0.000038, 0.000037,
    0.000036, 0.000036, 0.000035, 0.000035,
    0.000035, 0.000035, 0.000035, 0.000035,
    0.000035, 0.000035, 0.000035, 0.000035,
  },
  { /* wavelet type 6, n_levels 4, low */
    0.197961, 0.201233, 0.211686, 0.219771,
    0.223845, 0.206688, 0.173137, 0.126964,
    0.080694, 0.042246, 0.018833, 0.007556,
    0.003440, 0.002116, 0.001581, 0.001257,
    0.001034, 0.000865, 0.000728, 0.000644,
    0.000674, 0.000818, 0.000966, 0.000984,
    0.000850, 0.000646, 0.000490, 0.000403,
    0.000358, 0.000327, 0.000300, 0.000276,
    0.000257, 0.000239, 0.000223, 0.000208,
    0.000197, 0.000194, 0.000201, 0.000209,
    0.000209, 0.000194, 0.000173, 0.000156,
    0.000146, 0.000139, 0.000133, 0.000126,
    0.000121, 0.000116, 0.000111, 0.000106,
    0.000104, 0.000103, 0.000103, 0.000101,
    0.000097, 0.000092, 0.000088, 0.000085,
    0.000082, 0.000080, 0.000078, 0.000075,
    0.000073, 0.000071, 0.000069, 0.000067,
    0.000066, 0.000064, 0.000063, 0.000063,
    0.000062, 0.000061, 0.000059, 0.000057,
    0.000056, 0.000055, 0.000054, 0.000053,
    0.000052, 0.000051, 0.000050, 0.000049,
    0.000048, 0.000049, 0.000050, 0.000050,
    0.000050, 0.000048, 0.000046, 0.000045,
    0.000044, 0.000044, 0.000043, 0.000043,
    0.000043, 0.000042, 0.000042, 0.000041,
    0.000041, 0.000041, 0.000041, 0.000041,
    0.000041, 0.000041, 0.000040, 0.000039,
    0.000039, 0.000039, 0.000039, 0.000039,
    0.000038, 0.000038, 0.000038, 0.000038,
    0.000038, 0.000038, 0.000038, 0.000038,
    0.000038, 0.000038, 0.000038, 0.000038,
    0.000038, 0.000038, 0.000038, 0.000038,
}
}
};

const double schro_tables_wavelet_gain[SCHRO_N_WAVELETS][2] = {
  { 1.33924, 3.31833 },
  { 1.42877, 3.03795 },
  { 1.30392, 3.31785 },
  { 0.992823, 4.03191 },
  { 0.991972, 4.02965 },
  { 3.71281, 1.13154 },
  { 1.564, 2.62481 },
};

#if 0
const int schro_tables_lowdelay_quants[SCHRO_N_WAVELETS][4][9] = {
  { /* wavelet 0 */
    {  5,  3, 0 },
    {  8,  6,  3,  3, 0 },
    { 11,  8,  6,  6,  3,  3, 0 },
    { 14, 11,  9,  8,  6,  6,  3,  3, 0 },
  },
  { /* wavelet 1 */
    {  4,  2, 0 },
    {  7,  5,  2,  2, 0 },
    {  9,  7,  5,  5,  2,  2, 0 },
    { 12,  9,  7,  7,  5,  5,  2,  2, 0 },
  },
  { /* wavelet 2 */
    {  5,  3, 0 },
    {  8,  6,  3,  3, 0 },
    { 11,  9,  6,  6,  3,  3, 0 },
    { 14, 11,  9,  9,  6,  6,  3,  3, 0 },
  },
  { /* wavelet 3 */
    {  8,  4, 0 },
    { 16, 12,  8,  4, 0 },
    { 24, 20, 16, 12,  8,  4, 0 },
    { 32, 28, 24, 20, 16, 12,  8,  4, 0 },
  },
  { /* wavelet 4 */
    {  8,  4, 0 },
    { 12,  8,  4,  4, 0 },
    { 16, 12,  8,  8,  4,  4, 0 },
    { 20, 16, 12, 12,  8,  8,  4,  4, 0 },
  },
  { /* wavelet 5 */
    {  0,  3, 7 },
    {  0,  3,  7,  3, 6 },
    {  0,  3,  7,  3,  6,  2, 5 },
    {  0,  3,  7,  3,  6,  2,  5,  1, 5 },
  },
  { /* wavelet 6 */
    {  3,  1, 0 },
    {  5,  3,  2,  1, 0 },
    {  6,  5,  3,  3,  2,  1, 0 },
    {  8,  6,  5,  5,  3,  3,  2,  1, 0 },
  },
};
#endif

