#ifndef SCREEM_APPLICATION_H
#define SCREEM_APPLICATION_H

#include <config.h>

#include <glib-object.h>

#include <gconf/gconf-client.h>

#include <gtksourceview/gtksourcelanguagesmanager.h>

#include "screem-site.h"
#include "screem-helper.h"
#include "screem-editor.h"

#include "screem-dtd-db.h"

#define SCREEM_TYPE_APPLICATION            (screem_application_get_type ())
#define SCREEM_APPLICATION(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_APPLICATION, ScreemApplication))
#define SCREEM_APPLICATION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_APPLICATION, ScreemApplicationClass))
#define SCREEM_IS_APPLICATION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_APPLICATION))

#ifndef SCREEM_WINDOW_DEFINED
#define SCREEM_WINDOW_DEFINED
typedef struct ScreemWindow ScreemWindow;
#endif

#ifndef SCREEM_PLUGIN
#define SCREEM_PLUGIN
typedef struct ScreemPlugin ScreemPlugin;
#endif

typedef struct ScreemApplicationPrivate ScreemApplicationPrivate;

typedef struct {
	GObject parent;
	
	ScreemApplicationPrivate *priv;
	
	GList *plugins;

	GList *helpers;

	GList *macros;

	const gchar **start_files;

	gboolean offline;
	gint offline_notify;

	GtkSourceLanguagesManager *lm;
	
	/* UI stuff */
	GtkWidget *hint;

	GConfClient *client;
} ScreemApplication;

typedef struct {
	GObjectClass parent_class;

} ScreemApplicationClass;

GType screem_application_get_type( void );
ScreemApplication *screem_application_new( void );
void screem_application_startup( ScreemApplication *app,
				 const gchar *session,
				 const gchar **files );
void screem_application_close( ScreemApplication *app );

GList *screem_application_get_window_list( ScreemApplication *app );
void screem_application_close_all_windows( ScreemApplication *app );

ScreemWindow *screem_application_create_window( ScreemApplication *app );

GList *screem_application_get_loaded_sites( ScreemApplication *app );
void screem_application_add_site( ScreemApplication *app, ScreemSite *site );
ScreemSite *screem_application_get_site( ScreemApplication *app,
					 const gchar *uri );
ScreemSite *screem_application_get_site_by_name( ScreemApplication *app,
						 const gchar *name );
ScreemSite *screem_application_get_default_site( ScreemApplication *app );
void screem_application_close_site( ScreemApplication *app, ScreemSite *site );
void screem_application_close_all_sites( ScreemApplication *app );
gboolean screem_application_save_sites( ScreemApplication *app );

void screem_dtd_fill_combo( ScreemApplication *application, GtkWidget *combo );
void screem_dtd_fill_list( ScreemApplication *application, GtkListStore *store );

void screem_application_register_plugin( ScreemApplication *application, 
					 ScreemPlugin *plugin );

GtkSourceLanguagesManager* screem_application_load_syntax_tables();

void screem_application_add_helper( ScreemApplication *application,
				    ScreemHelper *helper );
void screem_application_remove_helper( ScreemApplication *application,
				       ScreemHelper *helper );


void screem_application_add_macro( ScreemApplication *application,
				   ScreemEditorMacro *macro );
void screem_application_remove_macro( ScreemApplication *application,
				      ScreemEditorMacro *macro );

ScreemDTDDB *screem_application_get_dtd_db( ScreemApplication *application );

#endif
