#ifndef SCREEM_LINK_VIEW_HTML_H
#define SCREEM_LINK_VIEW_HTML_H

#include <glib-object.h>

#include "screem-page.h"

#include "screem-linkview-util.h"
#include "screem-link-view-image.h"

#define SCREEM_TYPE_LINK_VIEW_HTML (screem_link_view_html_get_type())
#define SCREEM_LINK_VIEW_HTML(obj) (G_TYPE_CHECK_INSTANCE_CAST( (obj), SCREEM_TYPE_LINK_VIEW_HTML, ScreemLinkViewHtml ) )
#define SCREEM_IS_LINK_VIEW_HTML(obj) (G_TYPE_CHECK_INSTANCE_TYPE( (obj), SCREEM_TYPE_LINK_VIEW_HTML ) )

typedef struct ScreemLinkViewHtml ScreemLinkViewHtml;

struct ScreemLinkViewHtml{
	GObject parent;

	ScreemPage *page;

	gchar* name;		  /* Realtive Filename from the base node */
	gchar* filename;          /* Full File Name */
	gchar* remoteAddr; 	  /* If it is a link than then fill in this
				     field */
	gboolean exists; 	  /* Is it dead or not? */
	double filesize; 	  /* Filesize in bytes */

	ScreemLinkViewImage* images;	 /* LL of images */
	SyncStatus uploadStatus;	 /* What the upload status is */
	gboolean excluded;		 /* is the page marked for upload?*/
	double drawnX;		   	 /* Where the node is located on the
					    linkview */
	double drawnY;
	GnomeCanvasItem *label;
	GnomeCanvasItem *icon;

	gpointer  handle;
	RemoteStatus status;
};

typedef struct {
	GObjectClass parent_class;
} ScreemLinkViewHtmlClass;

GType screem_link_view_html_get_type( void );
ScreemLinkViewHtml *screem_link_view_html_new( ScreemLinkView *view,
					       ScreemPage *page,
					       const gchar *pathname );

void screem_link_view_html_build_icon( ScreemLinkViewHtml *html,
				       gdouble x, gdouble y,
				       gdouble angle,
				       gdouble *width,
				       GnomeCanvasGroup *root );

#endif
