/*  Screem:  screem-debug-console.c
 *
 *  debug console for screem
 *
 *  Copyright (C) 2004 David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */
#include <config.h>

#include <glib/gi18n.h>
#include <gtk/gtk.h>

#include <libgnomevfs/gnome-vfs.h>

#include "screem-application.h"

enum {
	DEBUG_NAME,
	DEBUG_PATH,
	DEBUG_ADDR,
	DEBUG_PAGE,
	DEBUG_ROWS
};

void screem_debug_console( ScreemApplication *app )
{
	GtkWidget *dialog;
	ScreemSite *site;
	GList *list;

	GtkTreeModel *model;
	GtkTreeIter pit;
	GtkTreeIter it;
	const gchar *name;
	const gchar *path;
	gchar *addr;

	GList *plist;
	GList *tmp;
	ScreemPage *page;

	GtkWidget *view;
	GtkWidget *sw;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;

	gint ret;
	GtkTreeSelection *sel;
	ScreemDTD *dtd;
	gchar *data;

	
	dialog = gtk_dialog_new ();
	gtk_dialog_add_button( GTK_DIALOG( dialog ),
			GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE );
	gtk_dialog_add_button( GTK_DIALOG( dialog ),
			"Dump page DTD", 0 );

	gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
	gtk_window_set_title (GTK_WINDOW (dialog), _("Debug Console - Screem"));

	model = GTK_TREE_MODEL( gtk_tree_store_new( DEBUG_ROWS,
				G_TYPE_STRING, G_TYPE_STRING,
				G_TYPE_STRING, G_TYPE_POINTER ) );
	
	list = screem_application_get_loaded_sites( app );
	for( ; list; list = list->next ) {
		site = SCREEM_SITE( list->data );

		name = screem_site_get_name( site );
		path = screem_site_get_pathname( site );
		addr = g_strdup_printf( "%p", (gpointer)site );

		gtk_tree_store_append( GTK_TREE_STORE( model ),
				&pit, NULL );
		gtk_tree_store_set( GTK_TREE_STORE( model ), &pit,
				DEBUG_NAME, name,
				DEBUG_PATH, path,
				DEBUG_ADDR, addr,
				-1 );
		g_free( addr );

		/* FIXME: use screem_site_foreach_page()*/
		tmp = plist = screem_site_get_pages( site, TRUE, TRUE );
		while( plist ) {
			page = SCREEM_PAGE( plist->data );
			gtk_tree_store_append( GTK_TREE_STORE( model ),
					&it, &pit );
			path = screem_page_get_pathname( page );
			addr = g_strdup_printf( "%p", (gpointer)page );
			gtk_tree_store_set( GTK_TREE_STORE( model ),
					&it,
					DEBUG_PATH, path,
					DEBUG_ADDR, addr,
					DEBUG_PAGE, page,
					-1 );
			g_free( addr );
			plist = plist->next;
		}
		g_list_free( tmp );

	}

	view = gtk_tree_view_new();
	sel = gtk_tree_view_get_selection( GTK_TREE_VIEW( view ) );
	
	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new();
	gtk_tree_view_column_pack_start( column, renderer, TRUE );
	gtk_tree_view_append_column( GTK_TREE_VIEW( view ), column );
	gtk_tree_view_column_set_attributes( column, renderer,
					     "text", 
					     DEBUG_NAME,
					     NULL );
	gtk_tree_view_column_set_title( column, "Name" );
	
	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new();
	gtk_tree_view_column_pack_start( column, renderer, TRUE );
	gtk_tree_view_append_column( GTK_TREE_VIEW( view ), column );
	gtk_tree_view_column_set_attributes( column, renderer,
					     "text", 
					     DEBUG_PATH,
					     NULL );
	gtk_tree_view_column_set_title( column, "Path" );

	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new();
	gtk_tree_view_column_pack_start( column, renderer, TRUE );
	gtk_tree_view_append_column( GTK_TREE_VIEW( view ), column );
	gtk_tree_view_column_set_attributes( column, renderer,
					     "text", 
					     DEBUG_ADDR,
					     NULL );
	gtk_tree_view_column_set_title( column, "Address" );
	
	gtk_tree_view_set_model( GTK_TREE_VIEW( view ), 
			GTK_TREE_MODEL( model ) );
	g_object_unref( model );

	sw = gtk_scrolled_window_new( NULL, NULL );
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( sw ),
					GTK_POLICY_AUTOMATIC, 
					GTK_POLICY_AUTOMATIC );
	gtk_scrolled_window_set_shadow_type( GTK_SCROLLED_WINDOW( sw ),
						GTK_SHADOW_IN );
	gtk_container_add( GTK_CONTAINER( sw ), view );


	gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dialog )->vbox ), 
			sw );

	gtk_window_set_default_size( GTK_WINDOW( dialog ),
			640, 480 );
	
	gtk_widget_show_all( dialog );
	
	do {
		ret = gtk_dialog_run( GTK_DIALOG( dialog ) );
		switch( ret ) {
			case 0:
				if( gtk_tree_selection_get_selected( sel, &model, &it ) ) {
					gtk_tree_model_get( GTK_TREE_MODEL( model ), &it,
							DEBUG_PAGE, &page, -1 );
					if( page ) {
						dtd = screem_page_get_dtd( page );
						data = screem_dtd_dump( dtd );
						g_print( "%s", data );
						g_free( data );
					}
				}
				break;
			default:
				break;
		}
	} while( ret >= 0 );
	
	gtk_widget_destroy( dialog );
}

