#ifndef SCREEM_HINT_H
#define SCREEM_HINT_H

#include <gtk/gtkwindow.h>

#define SCREEM_TYPE_HINT  (screem_hint_get_type())
#define SCREEM_HINT(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ), SCREEM_TYPE_HINT, \
                                                ScreemHint ) )
#define SCREEM_HINT_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST( ( klass ), \
                                                             SCREEM_TYPE_HINT, \
                                                             ScreemHintClass ) )
#define SCREEM_IS_HINT(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), SCREEM_TYPE_HINT ) )

typedef struct {
	GtkWindow parent;

	GtkWidget *label;

	gboolean show_hint;
	gint show_notify;

	gchar *hint_file;

	gint hint_count;
	gint last_hint;

	gchar **hint_text;
} ScreemHint;

typedef struct {
	GtkWindowClass parent_class;

} ScreemHintClass;

GType screem_hint_get_type( void );
ScreemHint *screem_hint_new( void );

gboolean screem_hint_next_hint( GtkWidget *widget );
gboolean screem_hint_prev_hint( GtkWidget *widget );
gboolean screem_hint_hide_hint( GtkWidget *widget );
gboolean screem_hint_hide_on_startup( GtkWidget *widget );


#endif
