/* DataSourceTypes.c generated by valac 0.34.7, the Vala compiler
 * generated from DataSourceTypes.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/**/
/* Media sources*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <time.h>
#include <gee.h>


#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
typedef struct _ThumbnailSourcePrivate ThumbnailSourcePrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
typedef struct _MediaSourcePrivate MediaSourcePrivate;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_BACKING_FILE_STATE (backing_file_state_get_type ())
#define BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_FILE_STATE, BackingFileState))
#define BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_FILE_STATE, BackingFileStateClass))
#define IS_BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_FILE_STATE))
#define IS_BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_FILE_STATE))
#define BACKING_FILE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_FILE_STATE, BackingFileStateClass))

typedef struct _BackingFileState BackingFileState;
typedef struct _BackingFileStateClass BackingFileStateClass;

#define TYPE_RATING (rating_get_type ())

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
typedef struct _Scaling Scaling;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;
typedef struct _PhotoSourcePrivate PhotoSourcePrivate;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;
typedef struct _VideoSourcePrivate VideoSourcePrivate;

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;
typedef struct _EventSourcePrivate EventSourcePrivate;

#define TYPE_CONTAINER_SOURCE (container_source_get_type ())
#define CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE, ContainerSource))
#define IS_CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE))
#define CONTAINER_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONTAINER_SOURCE, ContainerSourceIface))

typedef struct _ContainerSource ContainerSource;
typedef struct _ContainerSourceIface ContainerSourceIface;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _ThumbnailSource {
	DataSource parent_instance;
	ThumbnailSourcePrivate * priv;
};

struct _ThumbnailSourceClass {
	DataSourceClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailSource* self);
	GdkPixbuf* (*get_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	GdkPixbuf* (*create_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	gchar* (*get_representative_id) (ThumbnailSource* self);
	PhotoFileFormat (*get_preferred_thumbnail_format) (ThumbnailSource* self);
	void (*thumbnail_altered) (ThumbnailSource* self);
};

typedef void (*DataSourceContactSubscriber) (DataView* view, void* user_data);
struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

struct _EventID {
	gint64 id;
};

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

struct _Dimensions {
	gint width;
	gint height;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _ImportID {
	gint64 id;
};

struct _MediaSource {
	ThumbnailSource parent_instance;
	MediaSourcePrivate * priv;
};

struct _MediaSourceClass {
	ThumbnailSourceClass parent_class;
	void (*notify_master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
	gboolean (*set_event_id) (MediaSource* self, EventID* id);
	gchar* (*get_basename) (MediaSource* self);
	GFile* (*get_file) (MediaSource* self);
	GFile* (*get_master_file) (MediaSource* self);
	guint64 (*get_master_filesize) (MediaSource* self);
	guint64 (*get_filesize) (MediaSource* self);
	time_t (*get_timestamp) (MediaSource* self);
	BackingFileState** (*get_backing_files_state) (MediaSource* self, int* result_length1);
	gchar* (*get_title) (MediaSource* self);
	gchar* (*get_comment) (MediaSource* self);
	void (*set_title) (MediaSource* self, const gchar* title);
	gboolean (*set_comment) (MediaSource* self, const gchar* comment);
	Rating (*get_rating) (MediaSource* self);
	void (*set_rating) (MediaSource* self, Rating rating);
	void (*increase_rating) (MediaSource* self);
	void (*decrease_rating) (MediaSource* self);
	void (*get_dimensions) (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
	GdkPixbuf* (*get_preview_pixbuf) (MediaSource* self, Scaling* scaling, GError** error);
	gboolean (*is_trashed) (MediaSource* self);
	void (*trash) (MediaSource* self);
	void (*untrash) (MediaSource* self);
	gboolean (*is_offline) (MediaSource* self);
	void (*mark_offline) (MediaSource* self);
	void (*mark_online) (MediaSource* self);
	gchar* (*get_master_md5) (MediaSource* self);
	void (*get_event_id) (MediaSource* self, EventID* result);
	time_t (*get_exposure_time) (MediaSource* self);
	void (*get_import_id) (MediaSource* self, ImportID* result);
	void (*master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
};

struct _PhotoSource {
	MediaSource parent_instance;
	PhotoSourcePrivate * priv;
};

struct _PhotoSourceClass {
	MediaSourceClass parent_class;
	PhotoMetadata* (*get_metadata) (PhotoSource* self);
	GdkPixbuf* (*get_pixbuf) (PhotoSource* self, Scaling* scaling, GError** error);
};

struct _VideoSource {
	MediaSource parent_instance;
	VideoSourcePrivate * priv;
};

struct _VideoSourceClass {
	MediaSourceClass parent_class;
};

struct _EventSource {
	ThumbnailSource parent_instance;
	EventSourcePrivate * priv;
};

struct _EventSourceClass {
	ThumbnailSourceClass parent_class;
	time_t (*get_start_time) (EventSource* self);
	time_t (*get_end_time) (EventSource* self);
	guint64 (*get_total_filesize) (EventSource* self);
	gint (*get_media_count) (EventSource* self);
	GeeCollection* (*get_media) (EventSource* self);
	gchar* (*get_comment) (EventSource* self);
	gboolean (*set_comment) (EventSource* self, const gchar* comment);
};

struct _ContainerSourceIface {
	GTypeInterface parent_iface;
	gboolean (*has_links) (ContainerSource* self);
	SourceBacklink* (*get_backlink) (ContainerSource* self);
	void (*break_link) (ContainerSource* self, DataSource* source);
	void (*break_link_many) (ContainerSource* self, GeeCollection* sources);
	void (*establish_link) (ContainerSource* self, DataSource* source);
	void (*establish_link_many) (ContainerSource* self, GeeCollection* sources);
};


static gpointer thumbnail_source_parent_class = NULL;
static gpointer photo_source_parent_class = NULL;
static gpointer video_source_parent_class = NULL;
static gpointer event_source_parent_class = NULL;

GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer source_holding_tank_ref (gpointer instance);
void source_holding_tank_unref (gpointer instance);
GParamSpec* param_spec_source_holding_tank (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_holding_tank (GValue* value, gpointer v_object);
void value_take_source_holding_tank (GValue* value, gpointer v_object);
gpointer value_get_source_holding_tank (const GValue* value);
GType source_holding_tank_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
gpointer source_snapshot_ref (gpointer instance);
void source_snapshot_unref (gpointer instance);
GParamSpec* param_spec_source_snapshot (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_snapshot (GValue* value, gpointer v_object);
void value_take_source_snapshot (GValue* value, gpointer v_object);
gpointer value_get_source_snapshot (const GValue* value);
GType source_snapshot_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
enum  {
	THUMBNAIL_SOURCE_DUMMY_PROPERTY
};
ThumbnailSource* thumbnail_source_construct (GType object_type, gint64 object_id);
DataSource* data_source_construct (GType object_type, gint64 object_id);
void thumbnail_source_notify_thumbnail_altered (ThumbnailSource* self);
static void thumbnail_source_real_notify_thumbnail_altered (ThumbnailSource* self);
GType data_view_get_type (void) G_GNUC_CONST;
void data_source_contact_subscribers (DataSource* self, DataSourceContactSubscriber contact_subscriber, void* contact_subscriber_target);
static void thumbnail_source_subscriber_thumbnail_altered (ThumbnailSource* self, DataView* view);
static void _thumbnail_source_subscriber_thumbnail_altered_data_source_contact_subscriber (DataView* view, gpointer self);
GType thumbnail_view_get_type (void) G_GNUC_CONST;
void thumbnail_view_notify_thumbnail_altered (ThumbnailView* self);
GdkPixbuf* thumbnail_source_get_thumbnail (ThumbnailSource* self, gint scale, GError** error);
static GdkPixbuf* thumbnail_source_real_get_thumbnail (ThumbnailSource* self, gint scale, GError** error);
GdkPixbuf* thumbnail_source_create_thumbnail (ThumbnailSource* self, gint scale, GError** error);
static GdkPixbuf* thumbnail_source_real_create_thumbnail (ThumbnailSource* self, gint scale, GError** error);
gchar* thumbnail_source_get_representative_id (ThumbnailSource* self);
static gchar* thumbnail_source_real_get_representative_id (ThumbnailSource* self);
gchar* data_source_get_source_id (DataSource* self);
PhotoFileFormat thumbnail_source_get_preferred_thumbnail_format (ThumbnailSource* self);
static PhotoFileFormat thumbnail_source_real_get_preferred_thumbnail_format (ThumbnailSource* self);
static void thumbnail_source_real_thumbnail_altered (ThumbnailSource* self);
GType indexable_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType event_id_get_type (void) G_GNUC_CONST;
EventID* event_id_dup (const EventID* self);
void event_id_free (EventID* self);
gpointer backing_file_state_ref (gpointer instance);
void backing_file_state_unref (gpointer instance);
GParamSpec* param_spec_backing_file_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_backing_file_state (GValue* value, gpointer v_object);
void value_take_backing_file_state (GValue* value, gpointer v_object);
gpointer value_get_backing_file_state (const GValue* value);
GType backing_file_state_get_type (void) G_GNUC_CONST;
GType rating_get_type (void) G_GNUC_CONST;
GType photo_exception_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
GType import_id_get_type (void) G_GNUC_CONST;
ImportID* import_id_dup (const ImportID* self);
void import_id_free (ImportID* self);
GType photo_source_get_type (void) G_GNUC_CONST;
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
enum  {
	PHOTO_SOURCE_DUMMY_PROPERTY
};
PhotoSource* photo_source_construct (GType object_type, gint64 object_id);
MediaSource* media_source_construct (GType object_type, gint64 object_id);
PhotoMetadata* photo_source_get_metadata (PhotoSource* self);
static PhotoMetadata* photo_source_real_get_metadata (PhotoSource* self);
GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self, Scaling* scaling, GError** error);
static GdkPixbuf* photo_source_real_get_pixbuf (PhotoSource* self, Scaling* scaling, GError** error);
GType video_source_get_type (void) G_GNUC_CONST;
enum  {
	VIDEO_SOURCE_DUMMY_PROPERTY
};
VideoSource* video_source_construct (GType object_type);
#define DATA_OBJECT_INVALID_OBJECT_ID ((gint64) -1)
GType event_source_get_type (void) G_GNUC_CONST;
enum  {
	EVENT_SOURCE_DUMMY_PROPERTY
};
EventSource* event_source_construct (GType object_type, gint64 object_id);
time_t event_source_get_start_time (EventSource* self);
static time_t event_source_real_get_start_time (EventSource* self);
time_t event_source_get_end_time (EventSource* self);
static time_t event_source_real_get_end_time (EventSource* self);
guint64 event_source_get_total_filesize (EventSource* self);
static guint64 event_source_real_get_total_filesize (EventSource* self);
gint event_source_get_media_count (EventSource* self);
static gint event_source_real_get_media_count (EventSource* self);
GeeCollection* event_source_get_media (EventSource* self);
static GeeCollection* event_source_real_get_media (EventSource* self);
gchar* event_source_get_comment (EventSource* self);
static gchar* event_source_real_get_comment (EventSource* self);
gboolean event_source_set_comment (EventSource* self, const gchar* comment);
static gboolean event_source_real_set_comment (EventSource* self, const gchar* comment);
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_backlink (GValue* value, gpointer v_object);
void value_take_source_backlink (GValue* value, gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
GType container_source_get_type (void) G_GNUC_CONST;
gboolean container_source_has_links (ContainerSource* self);
SourceBacklink* container_source_get_backlink (ContainerSource* self);
void container_source_break_link (ContainerSource* self, DataSource* source);
void container_source_break_link_many (ContainerSource* self, GeeCollection* sources);
void container_source_establish_link (ContainerSource* self, DataSource* source);
void container_source_establish_link_many (ContainerSource* self, GeeCollection* sources);


ThumbnailSource* thumbnail_source_construct (GType object_type, gint64 object_id) {
	ThumbnailSource * self = NULL;
	gint64 _tmp0_ = 0LL;
#line 16 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	_tmp0_ = object_id;
#line 16 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	self = (ThumbnailSource*) data_source_construct (object_type, _tmp0_);
#line 15 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return self;
#line 604 "DataSourceTypes.c"
}


static void _thumbnail_source_subscriber_thumbnail_altered_data_source_contact_subscriber (DataView* view, gpointer self) {
#line 24 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	thumbnail_source_subscriber_thumbnail_altered ((ThumbnailSource*) self, view);
#line 611 "DataSourceTypes.c"
}


static void thumbnail_source_real_notify_thumbnail_altered (ThumbnailSource* self) {
#line 21 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_signal_emit_by_name (self, "thumbnail-altered");
#line 24 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	data_source_contact_subscribers (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource), _thumbnail_source_subscriber_thumbnail_altered_data_source_contact_subscriber, self);
#line 620 "DataSourceTypes.c"
}


void thumbnail_source_notify_thumbnail_altered (ThumbnailSource* self) {
#line 19 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (self));
#line 19 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	THUMBNAIL_SOURCE_GET_CLASS (self)->notify_thumbnail_altered (self);
#line 629 "DataSourceTypes.c"
}


static void thumbnail_source_subscriber_thumbnail_altered (ThumbnailSource* self, DataView* view) {
	DataView* _tmp0_ = NULL;
#line 27 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (self));
#line 27 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_if_fail (IS_DATA_VIEW (view));
#line 28 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	_tmp0_ = view;
#line 28 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	thumbnail_view_notify_thumbnail_altered (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_THUMBNAIL_VIEW, ThumbnailView));
#line 643 "DataSourceTypes.c"
}


static GdkPixbuf* thumbnail_source_real_get_thumbnail (ThumbnailSource* self, gint scale, GError** error) {
#line 31 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_critical ("Type `%s' does not implement abstract method `thumbnail_source_get_thumbnail'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 31 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return NULL;
#line 652 "DataSourceTypes.c"
}


GdkPixbuf* thumbnail_source_get_thumbnail (ThumbnailSource* self, gint scale, GError** error) {
#line 31 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (self), NULL);
#line 31 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return THUMBNAIL_SOURCE_GET_CLASS (self)->get_thumbnail (self, scale, error);
#line 661 "DataSourceTypes.c"
}


static GdkPixbuf* thumbnail_source_real_create_thumbnail (ThumbnailSource* self, gint scale, GError** error) {
#line 35 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_critical ("Type `%s' does not implement abstract method `thumbnail_source_create_thumbnail'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 35 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return NULL;
#line 670 "DataSourceTypes.c"
}


GdkPixbuf* thumbnail_source_create_thumbnail (ThumbnailSource* self, gint scale, GError** error) {
#line 35 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (self), NULL);
#line 35 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return THUMBNAIL_SOURCE_GET_CLASS (self)->create_thumbnail (self, scale, error);
#line 679 "DataSourceTypes.c"
}


static gchar* thumbnail_source_real_get_representative_id (ThumbnailSource* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 47 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	_tmp0_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource));
#line 47 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	result = _tmp0_;
#line 47 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return result;
#line 692 "DataSourceTypes.c"
}


gchar* thumbnail_source_get_representative_id (ThumbnailSource* self) {
#line 46 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (self), NULL);
#line 46 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return THUMBNAIL_SOURCE_GET_CLASS (self)->get_representative_id (self);
#line 701 "DataSourceTypes.c"
}


static PhotoFileFormat thumbnail_source_real_get_preferred_thumbnail_format (ThumbnailSource* self) {
#line 50 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_critical ("Type `%s' does not implement abstract method `thumbnail_source_get_preferred_thumbnail_format'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 50 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return 0;
#line 710 "DataSourceTypes.c"
}


PhotoFileFormat thumbnail_source_get_preferred_thumbnail_format (ThumbnailSource* self) {
#line 50 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (self), 0);
#line 50 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return THUMBNAIL_SOURCE_GET_CLASS (self)->get_preferred_thumbnail_format (self);
#line 719 "DataSourceTypes.c"
}


static void thumbnail_source_real_thumbnail_altered (ThumbnailSource* self) {
}


static void thumbnail_source_class_init (ThumbnailSourceClass * klass) {
#line 11 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	thumbnail_source_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	((ThumbnailSourceClass *) klass)->notify_thumbnail_altered = (void (*)(ThumbnailSource*)) thumbnail_source_real_notify_thumbnail_altered;
#line 11 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	((ThumbnailSourceClass *) klass)->get_thumbnail = (GdkPixbuf* (*)(ThumbnailSource*, gint, GError**)) thumbnail_source_real_get_thumbnail;
#line 11 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	((ThumbnailSourceClass *) klass)->create_thumbnail = (GdkPixbuf* (*)(ThumbnailSource*, gint, GError**)) thumbnail_source_real_create_thumbnail;
#line 11 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	((ThumbnailSourceClass *) klass)->get_representative_id = (gchar* (*)(ThumbnailSource*)) thumbnail_source_real_get_representative_id;
#line 11 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	((ThumbnailSourceClass *) klass)->get_preferred_thumbnail_format = (PhotoFileFormat (*)(ThumbnailSource*)) thumbnail_source_real_get_preferred_thumbnail_format;
#line 11 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	((ThumbnailSourceClass *) klass)->thumbnail_altered = thumbnail_source_real_thumbnail_altered;
#line 11 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_signal_new ("thumbnail_altered", TYPE_THUMBNAIL_SOURCE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ThumbnailSourceClass, thumbnail_altered), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 744 "DataSourceTypes.c"
}


static void thumbnail_source_instance_init (ThumbnailSource * self) {
}


GType thumbnail_source_get_type (void) {
	static volatile gsize thumbnail_source_type_id__volatile = 0;
	if (g_once_init_enter (&thumbnail_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ThumbnailSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThumbnailSource), 0, (GInstanceInitFunc) thumbnail_source_instance_init, NULL };
		GType thumbnail_source_type_id;
		thumbnail_source_type_id = g_type_register_static (TYPE_DATA_SOURCE, "ThumbnailSource", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&thumbnail_source_type_id__volatile, thumbnail_source_type_id);
	}
	return thumbnail_source_type_id__volatile;
}


PhotoSource* photo_source_construct (GType object_type, gint64 object_id) {
	PhotoSource * self = NULL;
	gint64 _tmp0_ = 0LL;
#line 55 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	_tmp0_ = object_id;
#line 55 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	self = (PhotoSource*) media_source_construct (object_type, _tmp0_);
#line 54 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return self;
#line 773 "DataSourceTypes.c"
}


static PhotoMetadata* photo_source_real_get_metadata (PhotoSource* self) {
#line 58 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_source_get_metadata'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 58 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return NULL;
#line 782 "DataSourceTypes.c"
}


PhotoMetadata* photo_source_get_metadata (PhotoSource* self) {
#line 58 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_val_if_fail (IS_PHOTO_SOURCE (self), NULL);
#line 58 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return PHOTO_SOURCE_GET_CLASS (self)->get_metadata (self);
#line 791 "DataSourceTypes.c"
}


static GdkPixbuf* photo_source_real_get_pixbuf (PhotoSource* self, Scaling* scaling, GError** error) {
#line 60 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_source_get_pixbuf'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 60 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return NULL;
#line 800 "DataSourceTypes.c"
}


GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self, Scaling* scaling, GError** error) {
#line 60 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_val_if_fail (IS_PHOTO_SOURCE (self), NULL);
#line 60 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return PHOTO_SOURCE_GET_CLASS (self)->get_pixbuf (self, scaling, error);
#line 809 "DataSourceTypes.c"
}


static void photo_source_class_init (PhotoSourceClass * klass) {
#line 53 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	photo_source_parent_class = g_type_class_peek_parent (klass);
#line 53 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	((PhotoSourceClass *) klass)->get_metadata = (PhotoMetadata* (*)(PhotoSource*)) photo_source_real_get_metadata;
#line 53 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	((PhotoSourceClass *) klass)->get_pixbuf = (GdkPixbuf* (*)(PhotoSource*, Scaling*, GError**)) photo_source_real_get_pixbuf;
#line 820 "DataSourceTypes.c"
}


static void photo_source_instance_init (PhotoSource * self) {
}


GType photo_source_get_type (void) {
	static volatile gsize photo_source_type_id__volatile = 0;
	if (g_once_init_enter (&photo_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoSource), 0, (GInstanceInitFunc) photo_source_instance_init, NULL };
		GType photo_source_type_id;
		photo_source_type_id = g_type_register_static (TYPE_MEDIA_SOURCE, "PhotoSource", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&photo_source_type_id__volatile, photo_source_type_id);
	}
	return photo_source_type_id__volatile;
}


VideoSource* video_source_construct (GType object_type) {
	VideoSource * self = NULL;
#line 63 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	self = (VideoSource*) media_source_construct (object_type, DATA_OBJECT_INVALID_OBJECT_ID);
#line 63 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return self;
#line 846 "DataSourceTypes.c"
}


static void video_source_class_init (VideoSourceClass * klass) {
#line 63 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	video_source_parent_class = g_type_class_peek_parent (klass);
#line 853 "DataSourceTypes.c"
}


static void video_source_instance_init (VideoSource * self) {
}


GType video_source_get_type (void) {
	static volatile gsize video_source_type_id__volatile = 0;
	if (g_once_init_enter (&video_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VideoSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoSource), 0, (GInstanceInitFunc) video_source_instance_init, NULL };
		GType video_source_type_id;
		video_source_type_id = g_type_register_static (TYPE_MEDIA_SOURCE, "VideoSource", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&video_source_type_id__volatile, video_source_type_id);
	}
	return video_source_type_id__volatile;
}


EventSource* event_source_construct (GType object_type, gint64 object_id) {
	EventSource * self = NULL;
	gint64 _tmp0_ = 0LL;
#line 72 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	_tmp0_ = object_id;
#line 72 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	self = (EventSource*) thumbnail_source_construct (object_type, _tmp0_);
#line 71 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return self;
#line 882 "DataSourceTypes.c"
}


static time_t event_source_real_get_start_time (EventSource* self) {
	time_t _tmp0_ = 0;
#line 75 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_critical ("Type `%s' does not implement abstract method `event_source_get_start_time'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 75 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return _tmp0_;
#line 892 "DataSourceTypes.c"
}


time_t event_source_get_start_time (EventSource* self) {
#line 75 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_val_if_fail (IS_EVENT_SOURCE (self), 0);
#line 75 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return EVENT_SOURCE_GET_CLASS (self)->get_start_time (self);
#line 901 "DataSourceTypes.c"
}


static time_t event_source_real_get_end_time (EventSource* self) {
	time_t _tmp0_ = 0;
#line 77 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_critical ("Type `%s' does not implement abstract method `event_source_get_end_time'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 77 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return _tmp0_;
#line 911 "DataSourceTypes.c"
}


time_t event_source_get_end_time (EventSource* self) {
#line 77 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_val_if_fail (IS_EVENT_SOURCE (self), 0);
#line 77 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return EVENT_SOURCE_GET_CLASS (self)->get_end_time (self);
#line 920 "DataSourceTypes.c"
}


static guint64 event_source_real_get_total_filesize (EventSource* self) {
	guint64 _tmp0_ = 0ULL;
#line 79 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_critical ("Type `%s' does not implement abstract method `event_source_get_total_filesize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 79 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return _tmp0_;
#line 930 "DataSourceTypes.c"
}


guint64 event_source_get_total_filesize (EventSource* self) {
#line 79 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_val_if_fail (IS_EVENT_SOURCE (self), 0ULL);
#line 79 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return EVENT_SOURCE_GET_CLASS (self)->get_total_filesize (self);
#line 939 "DataSourceTypes.c"
}


static gint event_source_real_get_media_count (EventSource* self) {
	gint _tmp0_ = 0;
#line 81 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_critical ("Type `%s' does not implement abstract method `event_source_get_media_count'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 81 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return _tmp0_;
#line 949 "DataSourceTypes.c"
}


gint event_source_get_media_count (EventSource* self) {
#line 81 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_val_if_fail (IS_EVENT_SOURCE (self), 0);
#line 81 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return EVENT_SOURCE_GET_CLASS (self)->get_media_count (self);
#line 958 "DataSourceTypes.c"
}


static GeeCollection* event_source_real_get_media (EventSource* self) {
#line 83 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_critical ("Type `%s' does not implement abstract method `event_source_get_media'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 83 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return NULL;
#line 967 "DataSourceTypes.c"
}


GeeCollection* event_source_get_media (EventSource* self) {
#line 83 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_val_if_fail (IS_EVENT_SOURCE (self), NULL);
#line 83 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return EVENT_SOURCE_GET_CLASS (self)->get_media (self);
#line 976 "DataSourceTypes.c"
}


static gchar* event_source_real_get_comment (EventSource* self) {
#line 85 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_critical ("Type `%s' does not implement abstract method `event_source_get_comment'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 85 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return NULL;
#line 985 "DataSourceTypes.c"
}


gchar* event_source_get_comment (EventSource* self) {
#line 85 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_val_if_fail (IS_EVENT_SOURCE (self), NULL);
#line 85 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return EVENT_SOURCE_GET_CLASS (self)->get_comment (self);
#line 994 "DataSourceTypes.c"
}


static gboolean event_source_real_set_comment (EventSource* self, const gchar* comment) {
	gboolean _tmp0_ = FALSE;
#line 87 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_critical ("Type `%s' does not implement abstract method `event_source_set_comment'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 87 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return _tmp0_;
#line 1004 "DataSourceTypes.c"
}


gboolean event_source_set_comment (EventSource* self, const gchar* comment) {
#line 87 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_val_if_fail (IS_EVENT_SOURCE (self), FALSE);
#line 87 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return EVENT_SOURCE_GET_CLASS (self)->set_comment (self, comment);
#line 1013 "DataSourceTypes.c"
}


static void event_source_class_init (EventSourceClass * klass) {
#line 70 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	event_source_parent_class = g_type_class_peek_parent (klass);
#line 70 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	((EventSourceClass *) klass)->get_start_time = (time_t (*)(EventSource*)) event_source_real_get_start_time;
#line 70 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	((EventSourceClass *) klass)->get_end_time = (time_t (*)(EventSource*)) event_source_real_get_end_time;
#line 70 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	((EventSourceClass *) klass)->get_total_filesize = (guint64 (*)(EventSource*)) event_source_real_get_total_filesize;
#line 70 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	((EventSourceClass *) klass)->get_media_count = (gint (*)(EventSource*)) event_source_real_get_media_count;
#line 70 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	((EventSourceClass *) klass)->get_media = (GeeCollection* (*)(EventSource*)) event_source_real_get_media;
#line 70 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	((EventSourceClass *) klass)->get_comment = (gchar* (*)(EventSource*)) event_source_real_get_comment;
#line 70 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	((EventSourceClass *) klass)->set_comment = (gboolean (*)(EventSource*, const gchar*)) event_source_real_set_comment;
#line 1034 "DataSourceTypes.c"
}


static void event_source_instance_init (EventSource * self) {
}


GType event_source_get_type (void) {
	static volatile gsize event_source_type_id__volatile = 0;
	if (g_once_init_enter (&event_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EventSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventSource), 0, (GInstanceInitFunc) event_source_instance_init, NULL };
		GType event_source_type_id;
		event_source_type_id = g_type_register_static (TYPE_THUMBNAIL_SOURCE, "EventSource", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&event_source_type_id__volatile, event_source_type_id);
	}
	return event_source_type_id__volatile;
}


gboolean container_source_has_links (ContainerSource* self) {
#line 95 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_val_if_fail (IS_CONTAINER_SOURCE (self), FALSE);
#line 95 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return CONTAINER_SOURCE_GET_INTERFACE (self)->has_links (self);
#line 1059 "DataSourceTypes.c"
}


SourceBacklink* container_source_get_backlink (ContainerSource* self) {
#line 97 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_val_if_fail (IS_CONTAINER_SOURCE (self), NULL);
#line 97 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	return CONTAINER_SOURCE_GET_INTERFACE (self)->get_backlink (self);
#line 1068 "DataSourceTypes.c"
}


void container_source_break_link (ContainerSource* self, DataSource* source) {
#line 99 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (self));
#line 99 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	CONTAINER_SOURCE_GET_INTERFACE (self)->break_link (self, source);
#line 1077 "DataSourceTypes.c"
}


void container_source_break_link_many (ContainerSource* self, GeeCollection* sources) {
#line 101 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (self));
#line 101 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	CONTAINER_SOURCE_GET_INTERFACE (self)->break_link_many (self, sources);
#line 1086 "DataSourceTypes.c"
}


void container_source_establish_link (ContainerSource* self, DataSource* source) {
#line 103 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (self));
#line 103 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	CONTAINER_SOURCE_GET_INTERFACE (self)->establish_link (self, source);
#line 1095 "DataSourceTypes.c"
}


void container_source_establish_link_many (ContainerSource* self, GeeCollection* sources) {
#line 105 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (self));
#line 105 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	CONTAINER_SOURCE_GET_INTERFACE (self)->establish_link_many (self, sources);
#line 1104 "DataSourceTypes.c"
}


static void container_source_base_init (ContainerSourceIface * iface) {
#line 94 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	static gboolean initialized = FALSE;
#line 94 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
	if (!initialized) {
#line 94 "/home/jens/Source/shotwell/src/core/DataSourceTypes.vala"
		initialized = TRUE;
#line 1115 "DataSourceTypes.c"
	}
}


GType container_source_get_type (void) {
	static volatile gsize container_source_type_id__volatile = 0;
	if (g_once_init_enter (&container_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContainerSourceIface), (GBaseInitFunc) container_source_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType container_source_type_id;
		container_source_type_id = g_type_register_static (G_TYPE_INTERFACE, "ContainerSource", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (container_source_type_id, TYPE_DATA_SOURCE);
		g_once_init_leave (&container_source_type_id__volatile, container_source_type_id);
	}
	return container_source_type_id__volatile;
}



