/* scanner.c generated by valac 0.20.1, the Vala compiler
 * generated from scanner.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* TODO: Could indicate the start of the next page immediately after the last page is received (i.e. before the sane_cancel()) */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include "sane/sane.h"
#include <glib/gi18n-lib.h>
#include "sane/saneopts.h"
#include <gobject/gvaluecollector.h>


#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecScanDevice ParamSpecScanDevice;

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
typedef struct _ParamSpecScanPageInfo ParamSpecScanPageInfo;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanLinePrivate ScanLinePrivate;
typedef struct _ParamSpecScanLine ParamSpecScanLine;

#define TYPE_SCAN_MODE (scan_mode_get_type ())

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
typedef struct _ParamSpecScanOptions ParamSpecScanOptions;

#define TYPE_SCAN_JOB (scan_job_get_type ())
#define SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_JOB, ScanJob))
#define SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_JOB, ScanJobClass))
#define IS_SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_JOB))
#define IS_SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_JOB))
#define SCAN_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_JOB, ScanJobClass))

typedef struct _ScanJob ScanJob;
typedef struct _ScanJobClass ScanJobClass;
typedef struct _ScanJobPrivate ScanJobPrivate;
typedef struct _ParamSpecScanJob ParamSpecScanJob;

#define TYPE_REQUEST (request_get_type ())
#define REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST, Request))
#define REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST, RequestClass))
#define IS_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST))
#define IS_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST))
#define REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST, RequestClass))

typedef struct _Request Request;
typedef struct _RequestClass RequestClass;
typedef struct _RequestPrivate RequestPrivate;
typedef struct _ParamSpecRequest ParamSpecRequest;

#define TYPE_REQUEST_REDETECT (request_redetect_get_type ())
#define REQUEST_REDETECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_REDETECT, RequestRedetect))
#define REQUEST_REDETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_REDETECT, RequestRedetectClass))
#define IS_REQUEST_REDETECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_REDETECT))
#define IS_REQUEST_REDETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_REDETECT))
#define REQUEST_REDETECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_REDETECT, RequestRedetectClass))

typedef struct _RequestRedetect RequestRedetect;
typedef struct _RequestRedetectClass RequestRedetectClass;
typedef struct _RequestRedetectPrivate RequestRedetectPrivate;

#define TYPE_REQUEST_CANCEL (request_cancel_get_type ())
#define REQUEST_CANCEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_CANCEL, RequestCancel))
#define REQUEST_CANCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_CANCEL, RequestCancelClass))
#define IS_REQUEST_CANCEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_CANCEL))
#define IS_REQUEST_CANCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_CANCEL))
#define REQUEST_CANCEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_CANCEL, RequestCancelClass))

typedef struct _RequestCancel RequestCancel;
typedef struct _RequestCancelClass RequestCancelClass;
typedef struct _RequestCancelPrivate RequestCancelPrivate;

#define TYPE_REQUEST_START_SCAN (request_start_scan_get_type ())
#define REQUEST_START_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_START_SCAN, RequestStartScan))
#define REQUEST_START_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_START_SCAN, RequestStartScanClass))
#define IS_REQUEST_START_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_START_SCAN))
#define IS_REQUEST_START_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_START_SCAN))
#define REQUEST_START_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_START_SCAN, RequestStartScanClass))

typedef struct _RequestStartScan RequestStartScan;
typedef struct _RequestStartScanClass RequestStartScanClass;
typedef struct _RequestStartScanPrivate RequestStartScanPrivate;
#define _scan_job_unref0(var) ((var == NULL) ? NULL : (var = (scan_job_unref (var), NULL)))

#define TYPE_REQUEST_QUIT (request_quit_get_type ())
#define REQUEST_QUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_QUIT, RequestQuit))
#define REQUEST_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_QUIT, RequestQuitClass))
#define IS_REQUEST_QUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_QUIT))
#define IS_REQUEST_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_QUIT))
#define REQUEST_QUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_QUIT, RequestQuitClass))

typedef struct _RequestQuit RequestQuit;
typedef struct _RequestQuitClass RequestQuitClass;
typedef struct _RequestQuitPrivate RequestQuitPrivate;

#define TYPE_CREDENTIALS (credentials_get_type ())
#define CREDENTIALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CREDENTIALS, Credentials))
#define CREDENTIALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CREDENTIALS, CredentialsClass))
#define IS_CREDENTIALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CREDENTIALS))
#define IS_CREDENTIALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CREDENTIALS))
#define CREDENTIALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CREDENTIALS, CredentialsClass))

typedef struct _Credentials Credentials;
typedef struct _CredentialsClass CredentialsClass;
typedef struct _CredentialsPrivate CredentialsPrivate;
typedef struct _ParamSpecCredentials ParamSpecCredentials;

#define TYPE_SCAN_STATE (scan_state_get_type ())

#define TYPE_NOTIFY (notify_get_type ())
#define NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY, Notify))
#define NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY, NotifyClass))
#define IS_NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY))
#define IS_NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY))
#define NOTIFY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY, NotifyClass))

typedef struct _Notify Notify;
typedef struct _NotifyClass NotifyClass;
typedef struct _NotifyPrivate NotifyPrivate;

#define TYPE_SCANNER (scanner_get_type ())
#define SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCANNER, Scanner))
#define SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCANNER, ScannerClass))
#define IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCANNER))
#define IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCANNER))
#define SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCANNER, ScannerClass))

typedef struct _Scanner Scanner;
typedef struct _ScannerClass ScannerClass;
typedef struct _ParamSpecNotify ParamSpecNotify;

#define TYPE_NOTIFY_SCANNING_CHANGED (notify_scanning_changed_get_type ())
#define NOTIFY_SCANNING_CHANGED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChanged))
#define NOTIFY_SCANNING_CHANGED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChangedClass))
#define IS_NOTIFY_SCANNING_CHANGED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_SCANNING_CHANGED))
#define IS_NOTIFY_SCANNING_CHANGED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_SCANNING_CHANGED))
#define NOTIFY_SCANNING_CHANGED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChangedClass))

typedef struct _NotifyScanningChanged NotifyScanningChanged;
typedef struct _NotifyScanningChangedClass NotifyScanningChangedClass;
typedef struct _NotifyScanningChangedPrivate NotifyScanningChangedPrivate;

#define TYPE_NOTIFY_UPDATE_DEVICES (notify_update_devices_get_type ())
#define NOTIFY_UPDATE_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevices))
#define NOTIFY_UPDATE_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesClass))
#define IS_NOTIFY_UPDATE_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_UPDATE_DEVICES))
#define IS_NOTIFY_UPDATE_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_UPDATE_DEVICES))
#define NOTIFY_UPDATE_DEVICES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesClass))

typedef struct _NotifyUpdateDevices NotifyUpdateDevices;
typedef struct _NotifyUpdateDevicesClass NotifyUpdateDevicesClass;
typedef struct _NotifyUpdateDevicesPrivate NotifyUpdateDevicesPrivate;
#define __g_list_free__scan_device_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_device_unref0_ (var), NULL)))

#define TYPE_NOTIFY_REQUEST_AUTHORIZATION (notify_request_authorization_get_type ())
#define NOTIFY_REQUEST_AUTHORIZATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorization))
#define NOTIFY_REQUEST_AUTHORIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationClass))
#define IS_NOTIFY_REQUEST_AUTHORIZATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION))
#define IS_NOTIFY_REQUEST_AUTHORIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_REQUEST_AUTHORIZATION))
#define NOTIFY_REQUEST_AUTHORIZATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationClass))

typedef struct _NotifyRequestAuthorization NotifyRequestAuthorization;
typedef struct _NotifyRequestAuthorizationClass NotifyRequestAuthorizationClass;
typedef struct _NotifyRequestAuthorizationPrivate NotifyRequestAuthorizationPrivate;

#define TYPE_NOTIFY_SCAN_FAILED (notify_scan_failed_get_type ())
#define NOTIFY_SCAN_FAILED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailed))
#define NOTIFY_SCAN_FAILED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedClass))
#define IS_NOTIFY_SCAN_FAILED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_SCAN_FAILED))
#define IS_NOTIFY_SCAN_FAILED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_SCAN_FAILED))
#define NOTIFY_SCAN_FAILED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedClass))

typedef struct _NotifyScanFailed NotifyScanFailed;
typedef struct _NotifyScanFailedClass NotifyScanFailedClass;
typedef struct _NotifyScanFailedPrivate NotifyScanFailedPrivate;

#define TYPE_NOTIFY_DOCUMENT_DONE (notify_document_done_get_type ())
#define NOTIFY_DOCUMENT_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDone))
#define NOTIFY_DOCUMENT_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDoneClass))
#define IS_NOTIFY_DOCUMENT_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_DOCUMENT_DONE))
#define IS_NOTIFY_DOCUMENT_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_DOCUMENT_DONE))
#define NOTIFY_DOCUMENT_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDoneClass))

typedef struct _NotifyDocumentDone NotifyDocumentDone;
typedef struct _NotifyDocumentDoneClass NotifyDocumentDoneClass;
typedef struct _NotifyDocumentDonePrivate NotifyDocumentDonePrivate;

#define TYPE_NOTIFY_EXPECT_PAGE (notify_expect_page_get_type ())
#define NOTIFY_EXPECT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPage))
#define NOTIFY_EXPECT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPageClass))
#define IS_NOTIFY_EXPECT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_EXPECT_PAGE))
#define IS_NOTIFY_EXPECT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_EXPECT_PAGE))
#define NOTIFY_EXPECT_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPageClass))

typedef struct _NotifyExpectPage NotifyExpectPage;
typedef struct _NotifyExpectPageClass NotifyExpectPageClass;
typedef struct _NotifyExpectPagePrivate NotifyExpectPagePrivate;

#define TYPE_NOTIFY_GOT_PAGE_INFO (notify_got_page_info_get_type ())
#define NOTIFY_GOT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfo))
#define NOTIFY_GOT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoClass))
#define IS_NOTIFY_GOT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_GOT_PAGE_INFO))
#define IS_NOTIFY_GOT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_GOT_PAGE_INFO))
#define NOTIFY_GOT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoClass))

typedef struct _NotifyGotPageInfo NotifyGotPageInfo;
typedef struct _NotifyGotPageInfoClass NotifyGotPageInfoClass;
typedef struct _NotifyGotPageInfoPrivate NotifyGotPageInfoPrivate;
#define _scan_page_info_unref0(var) ((var == NULL) ? NULL : (var = (scan_page_info_unref (var), NULL)))
typedef struct _ScannerPrivate ScannerPrivate;

#define TYPE_NOTIFY_PAGE_DONE (notify_page_done_get_type ())
#define NOTIFY_PAGE_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_PAGE_DONE, NotifyPageDone))
#define NOTIFY_PAGE_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_PAGE_DONE, NotifyPageDoneClass))
#define IS_NOTIFY_PAGE_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_PAGE_DONE))
#define IS_NOTIFY_PAGE_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_PAGE_DONE))
#define NOTIFY_PAGE_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_PAGE_DONE, NotifyPageDoneClass))

typedef struct _NotifyPageDone NotifyPageDone;
typedef struct _NotifyPageDoneClass NotifyPageDoneClass;
typedef struct _NotifyPageDonePrivate NotifyPageDonePrivate;

#define TYPE_NOTIFY_GOT_LINE (notify_got_line_get_type ())
#define NOTIFY_GOT_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_GOT_LINE, NotifyGotLine))
#define NOTIFY_GOT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_GOT_LINE, NotifyGotLineClass))
#define IS_NOTIFY_GOT_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_GOT_LINE))
#define IS_NOTIFY_GOT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_GOT_LINE))
#define NOTIFY_GOT_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_GOT_LINE, NotifyGotLineClass))

typedef struct _NotifyGotLine NotifyGotLine;
typedef struct _NotifyGotLineClass NotifyGotLineClass;
typedef struct _NotifyGotLinePrivate NotifyGotLinePrivate;
#define _scan_line_unref0(var) ((var == NULL) ? NULL : (var = (scan_line_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define __g_list_free__scan_job_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_job_unref0_ (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _scanner_unref0(var) ((var == NULL) ? NULL : (var = (scanner_unref (var), NULL)))
#define _notify_unref0(var) ((var == NULL) ? NULL : (var = (notify_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _credentials_unref0(var) ((var == NULL) ? NULL : (var = (credentials_unref (var), NULL)))
#define _request_unref0(var) ((var == NULL) ? NULL : (var = (request_unref (var), NULL)))
typedef struct _ParamSpecScanner ParamSpecScanner;

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

struct _ParamSpecScanDevice {
	GParamSpec parent_instance;
};

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

struct _ParamSpecScanPageInfo {
	GParamSpec parent_instance;
};

struct _ScanLine {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanLinePrivate * priv;
	gint number;
	gint n_lines;
	gint width;
	gint depth;
	gint channel;
	guchar* data;
	gint data_length1;
	gint data_length;
};

struct _ScanLineClass {
	GTypeClass parent_class;
	void (*finalize) (ScanLine *self);
};

struct _ParamSpecScanLine {
	GParamSpec parent_instance;
};

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecScanOptions {
	GParamSpec parent_instance;
};

struct _ScanJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanJobPrivate * priv;
	gint id;
	gchar* device;
	gdouble dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint page_width;
	gint page_height;
	gint brightness;
	gint contrast;
};

struct _ScanJobClass {
	GTypeClass parent_class;
	void (*finalize) (ScanJob *self);
};

struct _ParamSpecScanJob {
	GParamSpec parent_instance;
};

struct _Request {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RequestPrivate * priv;
};

struct _RequestClass {
	GTypeClass parent_class;
	void (*finalize) (Request *self);
};

struct _ParamSpecRequest {
	GParamSpec parent_instance;
};

struct _RequestRedetect {
	Request parent_instance;
	RequestRedetectPrivate * priv;
};

struct _RequestRedetectClass {
	RequestClass parent_class;
};

struct _RequestCancel {
	Request parent_instance;
	RequestCancelPrivate * priv;
};

struct _RequestCancelClass {
	RequestClass parent_class;
};

struct _RequestStartScan {
	Request parent_instance;
	RequestStartScanPrivate * priv;
	ScanJob* job;
};

struct _RequestStartScanClass {
	RequestClass parent_class;
};

struct _RequestQuit {
	Request parent_instance;
	RequestQuitPrivate * priv;
};

struct _RequestQuitClass {
	RequestClass parent_class;
};

struct _Credentials {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CredentialsPrivate * priv;
	gchar* username;
	gchar* password;
};

struct _CredentialsClass {
	GTypeClass parent_class;
	void (*finalize) (Credentials *self);
};

struct _ParamSpecCredentials {
	GParamSpec parent_instance;
};

typedef enum  {
	SCAN_STATE_IDLE = 0,
	SCAN_STATE_REDETECT,
	SCAN_STATE_OPEN,
	SCAN_STATE_GET_OPTION,
	SCAN_STATE_START,
	SCAN_STATE_GET_PARAMETERS,
	SCAN_STATE_READ
} ScanState;

struct _Notify {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NotifyPrivate * priv;
};

struct _NotifyClass {
	GTypeClass parent_class;
	void (*finalize) (Notify *self);
	void (*run) (Notify* self, Scanner* scanner);
};

struct _ParamSpecNotify {
	GParamSpec parent_instance;
};

struct _NotifyScanningChanged {
	Notify parent_instance;
	NotifyScanningChangedPrivate * priv;
};

struct _NotifyScanningChangedClass {
	NotifyClass parent_class;
};

struct _NotifyUpdateDevices {
	Notify parent_instance;
	NotifyUpdateDevicesPrivate * priv;
};

struct _NotifyUpdateDevicesClass {
	NotifyClass parent_class;
};

struct _NotifyUpdateDevicesPrivate {
	GList* devices;
};

struct _NotifyRequestAuthorization {
	Notify parent_instance;
	NotifyRequestAuthorizationPrivate * priv;
};

struct _NotifyRequestAuthorizationClass {
	NotifyClass parent_class;
};

struct _NotifyRequestAuthorizationPrivate {
	gchar* resource;
};

struct _NotifyScanFailed {
	Notify parent_instance;
	NotifyScanFailedPrivate * priv;
};

struct _NotifyScanFailedClass {
	NotifyClass parent_class;
};

struct _NotifyScanFailedPrivate {
	gint error_code;
	gchar* error_string;
};

struct _NotifyDocumentDone {
	Notify parent_instance;
	NotifyDocumentDonePrivate * priv;
};

struct _NotifyDocumentDoneClass {
	NotifyClass parent_class;
};

struct _NotifyExpectPage {
	Notify parent_instance;
	NotifyExpectPagePrivate * priv;
};

struct _NotifyExpectPageClass {
	NotifyClass parent_class;
};

struct _NotifyGotPageInfo {
	Notify parent_instance;
	NotifyGotPageInfoPrivate * priv;
};

struct _NotifyGotPageInfoClass {
	NotifyClass parent_class;
};

struct _NotifyGotPageInfoPrivate {
	gint job_id;
	ScanPageInfo* info;
};

struct _Scanner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScannerPrivate * priv;
	gint first_job_id;
	gint job_id;
};

struct _ScannerClass {
	GTypeClass parent_class;
	void (*finalize) (Scanner *self);
};

struct _NotifyPageDone {
	Notify parent_instance;
	NotifyPageDonePrivate * priv;
};

struct _NotifyPageDoneClass {
	NotifyClass parent_class;
};

struct _NotifyPageDonePrivate {
	gint job_id;
};

struct _NotifyGotLine {
	Notify parent_instance;
	NotifyGotLinePrivate * priv;
};

struct _NotifyGotLineClass {
	NotifyClass parent_class;
};

struct _NotifyGotLinePrivate {
	gint job_id;
	ScanLine* line;
};

struct _ScannerPrivate {
	GThread* thread;
	GAsyncQueue* request_queue;
	GAsyncQueue* notify_queue;
	GAsyncQueue* authorize_queue;
	gchar* default_device;
	ScanState state;
	gboolean need_redetect;
	GList* job_queue;
	SANE_Handle handle;
	gboolean have_handle;
	gchar* current_device;
	SANE_Parameters parameters;
	SANE_Int option_index;
	GHashTable* options;
	guchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gint n_used;
	gint line_count;
	gint pass_number;
	gint page_number;
	gint notified_page;
	gboolean scanning;
};

struct _ParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer scan_device_parent_class = NULL;
static gpointer scan_page_info_parent_class = NULL;
static gpointer scan_line_parent_class = NULL;
static gpointer scan_options_parent_class = NULL;
static gpointer scan_job_parent_class = NULL;
static gpointer request_parent_class = NULL;
static gpointer request_redetect_parent_class = NULL;
static gpointer request_cancel_parent_class = NULL;
static gpointer request_start_scan_parent_class = NULL;
static gpointer request_quit_parent_class = NULL;
static gpointer credentials_parent_class = NULL;
static gpointer notify_parent_class = NULL;
static gpointer notify_scanning_changed_parent_class = NULL;
static gpointer notify_update_devices_parent_class = NULL;
static gpointer notify_request_authorization_parent_class = NULL;
static gpointer notify_scan_failed_parent_class = NULL;
static gpointer notify_document_done_parent_class = NULL;
static gpointer notify_expect_page_parent_class = NULL;
static gpointer notify_got_page_info_parent_class = NULL;
static gpointer notify_page_done_parent_class = NULL;
static gpointer notify_got_line_parent_class = NULL;
static gpointer scanner_parent_class = NULL;
static Scanner* scanner_scanner_object;
static Scanner* scanner_scanner_object = NULL;

gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_DEVICE_DUMMY_PROPERTY
};
ScanDevice* scan_device_new (void);
ScanDevice* scan_device_construct (GType object_type);
static void scan_device_finalize (ScanDevice* obj);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_PAGE_INFO_DUMMY_PROPERTY
};
ScanPageInfo* scan_page_info_new (void);
ScanPageInfo* scan_page_info_construct (GType object_type);
static void scan_page_info_finalize (ScanPageInfo* obj);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_line (GValue* value, gpointer v_object);
void value_take_scan_line (GValue* value, gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_LINE_DUMMY_PROPERTY
};
ScanLine* scan_line_new (void);
ScanLine* scan_line_construct (GType object_type);
static void scan_line_finalize (ScanLine* obj);
GType scan_mode_get_type (void) G_GNUC_CONST;
GType scan_type_get_type (void) G_GNUC_CONST;
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_OPTIONS_DUMMY_PROPERTY
};
ScanOptions* scan_options_new (void);
ScanOptions* scan_options_construct (GType object_type);
static void scan_options_finalize (ScanOptions* obj);
gpointer scan_job_ref (gpointer instance);
void scan_job_unref (gpointer instance);
GParamSpec* param_spec_scan_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_job (GValue* value, gpointer v_object);
void value_take_scan_job (GValue* value, gpointer v_object);
gpointer value_get_scan_job (const GValue* value);
GType scan_job_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_JOB_DUMMY_PROPERTY
};
ScanJob* scan_job_new (void);
ScanJob* scan_job_construct (GType object_type);
static void scan_job_finalize (ScanJob* obj);
gpointer request_ref (gpointer instance);
void request_unref (gpointer instance);
GParamSpec* param_spec_request (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_request (GValue* value, gpointer v_object);
void value_take_request (GValue* value, gpointer v_object);
gpointer value_get_request (const GValue* value);
GType request_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_DUMMY_PROPERTY
};
Request* request_new (void);
Request* request_construct (GType object_type);
static void request_finalize (Request* obj);
GType request_redetect_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_REDETECT_DUMMY_PROPERTY
};
RequestRedetect* request_redetect_new (void);
RequestRedetect* request_redetect_construct (GType object_type);
GType request_cancel_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_CANCEL_DUMMY_PROPERTY
};
RequestCancel* request_cancel_new (void);
RequestCancel* request_cancel_construct (GType object_type);
GType request_start_scan_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_START_SCAN_DUMMY_PROPERTY
};
RequestStartScan* request_start_scan_new (void);
RequestStartScan* request_start_scan_construct (GType object_type);
static void request_start_scan_finalize (Request* obj);
GType request_quit_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_QUIT_DUMMY_PROPERTY
};
RequestQuit* request_quit_new (void);
RequestQuit* request_quit_construct (GType object_type);
gpointer credentials_ref (gpointer instance);
void credentials_unref (gpointer instance);
GParamSpec* param_spec_credentials (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_credentials (GValue* value, gpointer v_object);
void value_take_credentials (GValue* value, gpointer v_object);
gpointer value_get_credentials (const GValue* value);
GType credentials_get_type (void) G_GNUC_CONST;
enum  {
	CREDENTIALS_DUMMY_PROPERTY
};
Credentials* credentials_new (void);
Credentials* credentials_construct (GType object_type);
static void credentials_finalize (Credentials* obj);
GType scan_state_get_type (void) G_GNUC_CONST;
gpointer notify_ref (gpointer instance);
void notify_unref (gpointer instance);
GParamSpec* param_spec_notify (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_notify (GValue* value, gpointer v_object);
void value_take_notify (GValue* value, gpointer v_object);
gpointer value_get_notify (const GValue* value);
GType notify_get_type (void) G_GNUC_CONST;
gpointer scanner_ref (gpointer instance);
void scanner_unref (gpointer instance);
GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scanner (GValue* value, gpointer v_object);
void value_take_scanner (GValue* value, gpointer v_object);
gpointer value_get_scanner (const GValue* value);
GType scanner_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_DUMMY_PROPERTY
};
void notify_run (Notify* self, Scanner* scanner);
static void notify_real_run (Notify* self, Scanner* scanner);
Notify* notify_new (void);
Notify* notify_construct (GType object_type);
static void notify_finalize (Notify* obj);
GType notify_scanning_changed_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_SCANNING_CHANGED_DUMMY_PROPERTY
};
static void notify_scanning_changed_real_run (Notify* base, Scanner* scanner);
NotifyScanningChanged* notify_scanning_changed_new (void);
NotifyScanningChanged* notify_scanning_changed_construct (GType object_type);
GType notify_update_devices_get_type (void) G_GNUC_CONST;
#define NOTIFY_UPDATE_DEVICES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesPrivate))
enum  {
	NOTIFY_UPDATE_DEVICES_DUMMY_PROPERTY
};
static void _scan_device_unref0_ (gpointer var);
static void _g_list_free__scan_device_unref0_ (GList* self);
NotifyUpdateDevices* notify_update_devices_new (GList* devices);
NotifyUpdateDevices* notify_update_devices_construct (GType object_type, GList* devices);
static void notify_update_devices_real_run (Notify* base, Scanner* scanner);
static void notify_update_devices_finalize (Notify* obj);
GType notify_request_authorization_get_type (void) G_GNUC_CONST;
#define NOTIFY_REQUEST_AUTHORIZATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationPrivate))
enum  {
	NOTIFY_REQUEST_AUTHORIZATION_DUMMY_PROPERTY
};
NotifyRequestAuthorization* notify_request_authorization_new (const gchar* resource);
NotifyRequestAuthorization* notify_request_authorization_construct (GType object_type, const gchar* resource);
static void notify_request_authorization_real_run (Notify* base, Scanner* scanner);
static void notify_request_authorization_finalize (Notify* obj);
GType notify_scan_failed_get_type (void) G_GNUC_CONST;
#define NOTIFY_SCAN_FAILED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedPrivate))
enum  {
	NOTIFY_SCAN_FAILED_DUMMY_PROPERTY
};
NotifyScanFailed* notify_scan_failed_new (gint error_code, const gchar* error_string);
NotifyScanFailed* notify_scan_failed_construct (GType object_type, gint error_code, const gchar* error_string);
static void notify_scan_failed_real_run (Notify* base, Scanner* scanner);
static void notify_scan_failed_finalize (Notify* obj);
GType notify_document_done_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_DOCUMENT_DONE_DUMMY_PROPERTY
};
static void notify_document_done_real_run (Notify* base, Scanner* scanner);
NotifyDocumentDone* notify_document_done_new (void);
NotifyDocumentDone* notify_document_done_construct (GType object_type);
GType notify_expect_page_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_EXPECT_PAGE_DUMMY_PROPERTY
};
static void notify_expect_page_real_run (Notify* base, Scanner* scanner);
NotifyExpectPage* notify_expect_page_new (void);
NotifyExpectPage* notify_expect_page_construct (GType object_type);
GType notify_got_page_info_get_type (void) G_GNUC_CONST;
#define NOTIFY_GOT_PAGE_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoPrivate))
enum  {
	NOTIFY_GOT_PAGE_INFO_DUMMY_PROPERTY
};
NotifyGotPageInfo* notify_got_page_info_new (gint job_id, ScanPageInfo* info);
NotifyGotPageInfo* notify_got_page_info_construct (GType object_type, gint job_id, ScanPageInfo* info);
static void notify_got_page_info_real_run (Notify* base, Scanner* scanner);
static void notify_got_page_info_finalize (Notify* obj);
GType notify_page_done_get_type (void) G_GNUC_CONST;
#define NOTIFY_PAGE_DONE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_PAGE_DONE, NotifyPageDonePrivate))
enum  {
	NOTIFY_PAGE_DONE_DUMMY_PROPERTY
};
NotifyPageDone* notify_page_done_new (gint job_id);
NotifyPageDone* notify_page_done_construct (GType object_type, gint job_id);
static void notify_page_done_real_run (Notify* base, Scanner* scanner);
static void notify_page_done_finalize (Notify* obj);
GType notify_got_line_get_type (void) G_GNUC_CONST;
#define NOTIFY_GOT_LINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_GOT_LINE, NotifyGotLinePrivate))
enum  {
	NOTIFY_GOT_LINE_DUMMY_PROPERTY
};
NotifyGotLine* notify_got_line_new (gint job_id, ScanLine* line);
NotifyGotLine* notify_got_line_construct (GType object_type, gint job_id, ScanLine* line);
static void notify_got_line_real_run (Notify* base, Scanner* scanner);
static void notify_got_line_finalize (Notify* obj);
#define SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SCANNER, ScannerPrivate))
enum  {
	SCANNER_DUMMY_PROPERTY
};
static void _scan_job_unref0_ (gpointer var);
static void _g_list_free__scan_job_unref0_ (GList* self);
static Scanner* scanner_new (void);
static Scanner* scanner_construct (GType object_type);
static void _request_unref0_ (gpointer var);
static void _notify_unref0_ (gpointer var);
static void _credentials_unref0_ (gpointer var);
Scanner* scanner_get_instance (void);
static gboolean scanner_notify_idle_cb (Scanner* self);
static void scanner_notify (Scanner* self, Notify* notification);
static gboolean _scanner_notify_idle_cb_gsource_func (gpointer self);
static void scanner_set_scanning (Scanner* self, gboolean is_scanning);
static gint scanner_get_device_weight (const gchar* device);
static gint scanner_compare_devices (ScanDevice* device1, ScanDevice* device2);
static void scanner_do_redetect (Scanner* self);
static gint _scanner_compare_devices_gcompare_func (gconstpointer a, gconstpointer b);
static gint scanner_scale_int (Scanner* self, gint source_min, gint source_max, SANE_Option_Descriptor* option, gint value);
static gboolean scanner_set_default_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index);
static void scanner_set_bool_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gboolean value, gboolean* _result_);
static void scanner_set_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gint value, gint* _result_);
static void scanner_set_fixed_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_);
static void scanner_set_fixed_or_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_);
static void scanner_set_option_to_max (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index);
static gboolean scanner_set_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, const gchar* value, gchar** _result_);
static gboolean scanner_set_constrained_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gchar** values, int values_length1, gchar** _result_);
static void scanner_log_option (Scanner* self, SANE_Int index, SANE_Option_Descriptor* option);
static void scanner_authorization_cb (const gchar* resource, gchar* username, int username_length1, gchar* password, int password_length1);
void scanner_authorize (Scanner* self, const gchar* username, const gchar* password);
static void scanner_close_device (Scanner* self);
static void scanner_fail_scan (Scanner* self, gint error_code, const gchar* error_string);
static gboolean scanner_handle_requests (Scanner* self);
static void scanner_do_open (Scanner* self);
static void _g_free0_ (gpointer var);
static void scanner_do_get_option (Scanner* self);
static SANE_Option_Descriptor* scanner_get_option_by_name (Scanner* self, SANE_Handle handle, const gchar* name, gint* index);
static gdouble scanner_convert_page_size (Scanner* self, SANE_Option_Descriptor* option, gdouble size, gdouble dpi);
static void scanner_do_complete_document (Scanner* self);
static void scanner_do_start (Scanner* self);
static void scanner_do_get_parameters (Scanner* self);
static void scanner_do_complete_page (Scanner* self);
static void scanner_do_read (Scanner* self);
static void* scanner_scan_thread (Scanner* self);
static void _scanner_authorization_cb_sane_authcallback (const gchar* resource, gchar* username, gchar* password);
void scanner_redetect (Scanner* self);
void scanner_start (Scanner* self);
static gpointer _scanner_scan_thread_gthread_func (gpointer self);
gboolean scanner_is_scanning (Scanner* self);
static gchar* scanner_get_scan_mode_string (Scanner* self, ScanMode mode);
static gchar* scanner_get_scan_type_string (Scanner* self, ScanType type);
void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options);
void scanner_cancel (Scanner* self);
void scanner_free (Scanner* self);
static void g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__SCAN_LINE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void scanner_finalize (Scanner* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ScanDevice* scan_device_construct (GType object_type) {
	ScanDevice* self = NULL;
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (ScanDevice*) g_type_create_instance (object_type);
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 985 "scanner.c"
}


ScanDevice* scan_device_new (void) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return scan_device_construct (TYPE_SCAN_DEVICE);
#line 992 "scanner.c"
}


static void value_scan_device_init (GValue* value) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 999 "scanner.c"
}


static void value_scan_device_free_value (GValue* value) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_device_unref (value->data[0].v_pointer);
#line 1008 "scanner.c"
	}
}


static void value_scan_device_copy_value (const GValue* src_value, GValue* dest_value) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_device_ref (src_value->data[0].v_pointer);
#line 1018 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1022 "scanner.c"
	}
}


static gpointer value_scan_device_peek_pointer (const GValue* value) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1030 "scanner.c"
}


static gchar* value_scan_device_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1037 "scanner.c"
		ScanDevice* object;
		object = collect_values[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1044 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1048 "scanner.c"
		}
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = scan_device_ref (object);
#line 1052 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1056 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 1060 "scanner.c"
}


static gchar* value_scan_device_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanDevice** object_p;
	object_p = collect_values[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!object_p) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1071 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = NULL;
#line 1077 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1081 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = scan_device_ref (value->data[0].v_pointer);
#line 1085 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 1089 "scanner.c"
}


GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanDevice* spec;
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_DEVICE), NULL);
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1103 "scanner.c"
}


gpointer value_get_scan_device (const GValue* value) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE), NULL);
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1112 "scanner.c"
}


void value_set_scan_device (GValue* value, gpointer v_object) {
	ScanDevice* old;
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_device_ref (value->data[0].v_pointer);
#line 1132 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1136 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_device_unref (old);
#line 1142 "scanner.c"
	}
}


void value_take_scan_device (GValue* value, gpointer v_object) {
	ScanDevice* old;
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1161 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1165 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_device_unref (old);
#line 1171 "scanner.c"
	}
}


static void scan_device_class_init (ScanDeviceClass * klass) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scan_device_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	SCAN_DEVICE_CLASS (klass)->finalize = scan_device_finalize;
#line 1181 "scanner.c"
}


static void scan_device_instance_init (ScanDevice * self) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->ref_count = 1;
#line 1188 "scanner.c"
}


static void scan_device_finalize (ScanDevice* obj) {
	ScanDevice * self;
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_DEVICE, ScanDevice);
#line 16 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (self->name);
#line 17 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (self->label);
#line 1200 "scanner.c"
}


GType scan_device_get_type (void) {
	static volatile gsize scan_device_type_id__volatile = 0;
	if (g_once_init_enter (&scan_device_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_device_init, value_scan_device_free_value, value_scan_device_copy_value, value_scan_device_peek_pointer, "p", value_scan_device_collect_value, "p", value_scan_device_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanDevice), 0, (GInstanceInitFunc) scan_device_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_device_type_id;
		scan_device_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanDevice", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_device_type_id__volatile, scan_device_type_id);
	}
	return scan_device_type_id__volatile;
}


gpointer scan_device_ref (gpointer instance) {
	ScanDevice* self;
	self = instance;
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return instance;
#line 1225 "scanner.c"
}


void scan_device_unref (gpointer instance) {
	ScanDevice* self;
	self = instance;
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		SCAN_DEVICE_GET_CLASS (self)->finalize (self);
#line 14 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1238 "scanner.c"
	}
}


ScanPageInfo* scan_page_info_construct (GType object_type) {
	ScanPageInfo* self = NULL;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (ScanPageInfo*) g_type_create_instance (object_type);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 1249 "scanner.c"
}


ScanPageInfo* scan_page_info_new (void) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return scan_page_info_construct (TYPE_SCAN_PAGE_INFO);
#line 1256 "scanner.c"
}


static void value_scan_page_info_init (GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 1263 "scanner.c"
}


static void value_scan_page_info_free_value (GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_page_info_unref (value->data[0].v_pointer);
#line 1272 "scanner.c"
	}
}


static void value_scan_page_info_copy_value (const GValue* src_value, GValue* dest_value) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_page_info_ref (src_value->data[0].v_pointer);
#line 1282 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1286 "scanner.c"
	}
}


static gpointer value_scan_page_info_peek_pointer (const GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1294 "scanner.c"
}


static gchar* value_scan_page_info_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1301 "scanner.c"
		ScanPageInfo* object;
		object = collect_values[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1308 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1312 "scanner.c"
		}
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = scan_page_info_ref (object);
#line 1316 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1320 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 1324 "scanner.c"
}


static gchar* value_scan_page_info_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanPageInfo** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!object_p) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1335 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = NULL;
#line 1341 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1345 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = scan_page_info_ref (value->data[0].v_pointer);
#line 1349 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 1353 "scanner.c"
}


GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanPageInfo* spec;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_PAGE_INFO), NULL);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1367 "scanner.c"
}


gpointer value_get_scan_page_info (const GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO), NULL);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1376 "scanner.c"
}


void value_set_scan_page_info (GValue* value, gpointer v_object) {
	ScanPageInfo* old;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_page_info_ref (value->data[0].v_pointer);
#line 1396 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1400 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_page_info_unref (old);
#line 1406 "scanner.c"
	}
}


void value_take_scan_page_info (GValue* value, gpointer v_object) {
	ScanPageInfo* old;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1425 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1429 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_page_info_unref (old);
#line 1435 "scanner.c"
	}
}


static void scan_page_info_class_init (ScanPageInfoClass * klass) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scan_page_info_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	SCAN_PAGE_INFO_CLASS (klass)->finalize = scan_page_info_finalize;
#line 1445 "scanner.c"
}


static void scan_page_info_instance_init (ScanPageInfo * self) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->ref_count = 1;
#line 1452 "scanner.c"
}


static void scan_page_info_finalize (ScanPageInfo* obj) {
	ScanPageInfo * self;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_PAGE_INFO, ScanPageInfo);
#line 36 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (self->device);
#line 1462 "scanner.c"
}


GType scan_page_info_get_type (void) {
	static volatile gsize scan_page_info_type_id__volatile = 0;
	if (g_once_init_enter (&scan_page_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_page_info_init, value_scan_page_info_free_value, value_scan_page_info_copy_value, value_scan_page_info_peek_pointer, "p", value_scan_page_info_collect_value, "p", value_scan_page_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanPageInfo), 0, (GInstanceInitFunc) scan_page_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_page_info_type_id;
		scan_page_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanPageInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_page_info_type_id__volatile, scan_page_info_type_id);
	}
	return scan_page_info_type_id__volatile;
}


gpointer scan_page_info_ref (gpointer instance) {
	ScanPageInfo* self;
	self = instance;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return instance;
#line 1487 "scanner.c"
}


void scan_page_info_unref (gpointer instance) {
	ScanPageInfo* self;
	self = instance;
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		SCAN_PAGE_INFO_GET_CLASS (self)->finalize (self);
#line 20 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1500 "scanner.c"
	}
}


ScanLine* scan_line_construct (GType object_type) {
	ScanLine* self = NULL;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (ScanLine*) g_type_create_instance (object_type);
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 1511 "scanner.c"
}


ScanLine* scan_line_new (void) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return scan_line_construct (TYPE_SCAN_LINE);
#line 1518 "scanner.c"
}


static void value_scan_line_init (GValue* value) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 1525 "scanner.c"
}


static void value_scan_line_free_value (GValue* value) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_line_unref (value->data[0].v_pointer);
#line 1534 "scanner.c"
	}
}


static void value_scan_line_copy_value (const GValue* src_value, GValue* dest_value) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_line_ref (src_value->data[0].v_pointer);
#line 1544 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1548 "scanner.c"
	}
}


static gpointer value_scan_line_peek_pointer (const GValue* value) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1556 "scanner.c"
}


static gchar* value_scan_line_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1563 "scanner.c"
		ScanLine* object;
		object = collect_values[0].v_pointer;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1570 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1574 "scanner.c"
		}
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = scan_line_ref (object);
#line 1578 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1582 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 1586 "scanner.c"
}


static gchar* value_scan_line_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanLine** object_p;
	object_p = collect_values[0].v_pointer;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!object_p) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1597 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = NULL;
#line 1603 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1607 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = scan_line_ref (value->data[0].v_pointer);
#line 1611 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 1615 "scanner.c"
}


GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanLine* spec;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_LINE), NULL);
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1629 "scanner.c"
}


gpointer value_get_scan_line (const GValue* value) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE), NULL);
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1638 "scanner.c"
}


void value_set_scan_line (GValue* value, gpointer v_object) {
	ScanLine* old;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE));
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_LINE));
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_line_ref (value->data[0].v_pointer);
#line 1658 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1662 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_line_unref (old);
#line 1668 "scanner.c"
	}
}


void value_take_scan_line (GValue* value, gpointer v_object) {
	ScanLine* old;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE));
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_LINE));
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1687 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1691 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_line_unref (old);
#line 1697 "scanner.c"
	}
}


static void scan_line_class_init (ScanLineClass * klass) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scan_line_parent_class = g_type_class_peek_parent (klass);
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	SCAN_LINE_CLASS (klass)->finalize = scan_line_finalize;
#line 1707 "scanner.c"
}


static void scan_line_instance_init (ScanLine * self) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->ref_count = 1;
#line 1714 "scanner.c"
}


static void scan_line_finalize (ScanLine* obj) {
	ScanLine * self;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_LINE, ScanLine);
#line 55 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->data = (g_free (self->data), NULL);
#line 1724 "scanner.c"
}


GType scan_line_get_type (void) {
	static volatile gsize scan_line_type_id__volatile = 0;
	if (g_once_init_enter (&scan_line_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_line_init, value_scan_line_free_value, value_scan_line_copy_value, value_scan_line_peek_pointer, "p", value_scan_line_collect_value, "p", value_scan_line_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanLine), 0, (GInstanceInitFunc) scan_line_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_line_type_id;
		scan_line_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanLine", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_line_type_id__volatile, scan_line_type_id);
	}
	return scan_line_type_id__volatile;
}


gpointer scan_line_ref (gpointer instance) {
	ScanLine* self;
	self = instance;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return instance;
#line 1749 "scanner.c"
}


void scan_line_unref (gpointer instance) {
	ScanLine* self;
	self = instance;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		SCAN_LINE_GET_CLASS (self)->finalize (self);
#line 39 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1762 "scanner.c"
	}
}


GType scan_mode_get_type (void) {
	static volatile gsize scan_mode_type_id__volatile = 0;
	if (g_once_init_enter (&scan_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_MODE_DEFAULT, "SCAN_MODE_DEFAULT", "default"}, {SCAN_MODE_COLOR, "SCAN_MODE_COLOR", "color"}, {SCAN_MODE_GRAY, "SCAN_MODE_GRAY", "gray"}, {SCAN_MODE_LINEART, "SCAN_MODE_LINEART", "lineart"}, {0, NULL, NULL}};
		GType scan_mode_type_id;
		scan_mode_type_id = g_enum_register_static ("ScanMode", values);
		g_once_init_leave (&scan_mode_type_id__volatile, scan_mode_type_id);
	}
	return scan_mode_type_id__volatile;
}


GType scan_type_get_type (void) {
	static volatile gsize scan_type_type_id__volatile = 0;
	if (g_once_init_enter (&scan_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_TYPE_SINGLE, "SCAN_TYPE_SINGLE", "single"}, {SCAN_TYPE_ADF_FRONT, "SCAN_TYPE_ADF_FRONT", "adf-front"}, {SCAN_TYPE_ADF_BACK, "SCAN_TYPE_ADF_BACK", "adf-back"}, {SCAN_TYPE_ADF_BOTH, "SCAN_TYPE_ADF_BOTH", "adf-both"}, {0, NULL, NULL}};
		GType scan_type_type_id;
		scan_type_type_id = g_enum_register_static ("ScanType", values);
		g_once_init_leave (&scan_type_type_id__volatile, scan_type_type_id);
	}
	return scan_type_type_id__volatile;
}


ScanOptions* scan_options_construct (GType object_type) {
	ScanOptions* self = NULL;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (ScanOptions*) g_type_create_instance (object_type);
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 1797 "scanner.c"
}


ScanOptions* scan_options_new (void) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return scan_options_construct (TYPE_SCAN_OPTIONS);
#line 1804 "scanner.c"
}


static void value_scan_options_init (GValue* value) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 1811 "scanner.c"
}


static void value_scan_options_free_value (GValue* value) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_options_unref (value->data[0].v_pointer);
#line 1820 "scanner.c"
	}
}


static void value_scan_options_copy_value (const GValue* src_value, GValue* dest_value) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_options_ref (src_value->data[0].v_pointer);
#line 1830 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1834 "scanner.c"
	}
}


static gpointer value_scan_options_peek_pointer (const GValue* value) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1842 "scanner.c"
}


static gchar* value_scan_options_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1849 "scanner.c"
		ScanOptions* object;
		object = collect_values[0].v_pointer;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1856 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1860 "scanner.c"
		}
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = scan_options_ref (object);
#line 1864 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1868 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 1872 "scanner.c"
}


static gchar* value_scan_options_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanOptions** object_p;
	object_p = collect_values[0].v_pointer;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!object_p) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1883 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = NULL;
#line 1889 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1893 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = scan_options_ref (value->data[0].v_pointer);
#line 1897 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 1901 "scanner.c"
}


GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanOptions* spec;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_OPTIONS), NULL);
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1915 "scanner.c"
}


gpointer value_get_scan_options (const GValue* value) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS), NULL);
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1924 "scanner.c"
}


void value_set_scan_options (GValue* value, gpointer v_object) {
	ScanOptions* old;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_options_ref (value->data[0].v_pointer);
#line 1944 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1948 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_options_unref (old);
#line 1954 "scanner.c"
	}
}


void value_take_scan_options (GValue* value, gpointer v_object) {
	ScanOptions* old;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1973 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1977 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_options_unref (old);
#line 1983 "scanner.c"
	}
}


static void scan_options_class_init (ScanOptionsClass * klass) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scan_options_parent_class = g_type_class_peek_parent (klass);
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	SCAN_OPTIONS_CLASS (klass)->finalize = scan_options_finalize;
#line 1993 "scanner.c"
}


static void scan_options_instance_init (ScanOptions * self) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->ref_count = 1;
#line 2000 "scanner.c"
}


static void scan_options_finalize (ScanOptions* obj) {
	ScanOptions * self;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_OPTIONS, ScanOptions);
#line 2008 "scanner.c"
}


GType scan_options_get_type (void) {
	static volatile gsize scan_options_type_id__volatile = 0;
	if (g_once_init_enter (&scan_options_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_options_init, value_scan_options_free_value, value_scan_options_copy_value, value_scan_options_peek_pointer, "p", value_scan_options_collect_value, "p", value_scan_options_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanOptionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_options_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanOptions), 0, (GInstanceInitFunc) scan_options_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_options_type_id;
		scan_options_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanOptions", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_options_type_id__volatile, scan_options_type_id);
	}
	return scan_options_type_id__volatile;
}


gpointer scan_options_ref (gpointer instance) {
	ScanOptions* self;
	self = instance;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return instance;
#line 2033 "scanner.c"
}


void scan_options_unref (gpointer instance) {
	ScanOptions* self;
	self = instance;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		SCAN_OPTIONS_GET_CLASS (self)->finalize (self);
#line 75 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2046 "scanner.c"
	}
}


ScanJob* scan_job_construct (GType object_type) {
	ScanJob* self = NULL;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (ScanJob*) g_type_create_instance (object_type);
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 2057 "scanner.c"
}


ScanJob* scan_job_new (void) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return scan_job_construct (TYPE_SCAN_JOB);
#line 2064 "scanner.c"
}


static void value_scan_job_init (GValue* value) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 2071 "scanner.c"
}


static void value_scan_job_free_value (GValue* value) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_job_unref (value->data[0].v_pointer);
#line 2080 "scanner.c"
	}
}


static void value_scan_job_copy_value (const GValue* src_value, GValue* dest_value) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_job_ref (src_value->data[0].v_pointer);
#line 2090 "scanner.c"
	} else {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2094 "scanner.c"
	}
}


static gpointer value_scan_job_peek_pointer (const GValue* value) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2102 "scanner.c"
}


static gchar* value_scan_job_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 2109 "scanner.c"
		ScanJob* object;
		object = collect_values[0].v_pointer;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2116 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2120 "scanner.c"
		}
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = scan_job_ref (object);
#line 2124 "scanner.c"
	} else {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2128 "scanner.c"
	}
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 2132 "scanner.c"
}


static gchar* value_scan_job_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanJob** object_p;
	object_p = collect_values[0].v_pointer;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!object_p) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2143 "scanner.c"
	}
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = NULL;
#line 2149 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 2153 "scanner.c"
	} else {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = scan_job_ref (value->data[0].v_pointer);
#line 2157 "scanner.c"
	}
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 2161 "scanner.c"
}


GParamSpec* param_spec_scan_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanJob* spec;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_JOB), NULL);
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 2175 "scanner.c"
}


gpointer value_get_scan_job (const GValue* value) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB), NULL);
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2184 "scanner.c"
}


void value_set_scan_job (GValue* value, gpointer v_object) {
	ScanJob* old;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB));
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_JOB));
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_job_ref (value->data[0].v_pointer);
#line 2204 "scanner.c"
	} else {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2208 "scanner.c"
	}
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_job_unref (old);
#line 2214 "scanner.c"
	}
}


void value_take_scan_job (GValue* value, gpointer v_object) {
	ScanJob* old;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB));
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_JOB));
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 2233 "scanner.c"
	} else {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2237 "scanner.c"
	}
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scan_job_unref (old);
#line 2243 "scanner.c"
	}
}


static void scan_job_class_init (ScanJobClass * klass) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scan_job_parent_class = g_type_class_peek_parent (klass);
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	SCAN_JOB_CLASS (klass)->finalize = scan_job_finalize;
#line 2253 "scanner.c"
}


static void scan_job_instance_init (ScanJob * self) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->ref_count = 1;
#line 2260 "scanner.c"
}


static void scan_job_finalize (ScanJob* obj) {
	ScanJob * self;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_JOB, ScanJob);
#line 90 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (self->device);
#line 2270 "scanner.c"
}


GType scan_job_get_type (void) {
	static volatile gsize scan_job_type_id__volatile = 0;
	if (g_once_init_enter (&scan_job_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_job_init, value_scan_job_free_value, value_scan_job_copy_value, value_scan_job_peek_pointer, "p", value_scan_job_collect_value, "p", value_scan_job_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanJob), 0, (GInstanceInitFunc) scan_job_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_job_type_id;
		scan_job_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanJob", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_job_type_id__volatile, scan_job_type_id);
	}
	return scan_job_type_id__volatile;
}


gpointer scan_job_ref (gpointer instance) {
	ScanJob* self;
	self = instance;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return instance;
#line 2295 "scanner.c"
}


void scan_job_unref (gpointer instance) {
	ScanJob* self;
	self = instance;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		SCAN_JOB_GET_CLASS (self)->finalize (self);
#line 87 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2308 "scanner.c"
	}
}


Request* request_construct (GType object_type) {
	Request* self = NULL;
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (Request*) g_type_create_instance (object_type);
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 2319 "scanner.c"
}


Request* request_new (void) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return request_construct (TYPE_REQUEST);
#line 2326 "scanner.c"
}


static void value_request_init (GValue* value) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 2333 "scanner.c"
}


static void value_request_free_value (GValue* value) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		request_unref (value->data[0].v_pointer);
#line 2342 "scanner.c"
	}
}


static void value_request_copy_value (const GValue* src_value, GValue* dest_value) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = request_ref (src_value->data[0].v_pointer);
#line 2352 "scanner.c"
	} else {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2356 "scanner.c"
	}
}


static gpointer value_request_peek_pointer (const GValue* value) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2364 "scanner.c"
}


static gchar* value_request_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 2371 "scanner.c"
		Request* object;
		object = collect_values[0].v_pointer;
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2378 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2382 "scanner.c"
		}
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = request_ref (object);
#line 2386 "scanner.c"
	} else {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2390 "scanner.c"
	}
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 2394 "scanner.c"
}


static gchar* value_request_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Request** object_p;
	object_p = collect_values[0].v_pointer;
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!object_p) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2405 "scanner.c"
	}
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = NULL;
#line 2411 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 2415 "scanner.c"
	} else {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = request_ref (value->data[0].v_pointer);
#line 2419 "scanner.c"
	}
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 2423 "scanner.c"
}


GParamSpec* param_spec_request (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecRequest* spec;
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_REQUEST), NULL);
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 2437 "scanner.c"
}


gpointer value_get_request (const GValue* value) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST), NULL);
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2446 "scanner.c"
}


void value_set_request (GValue* value, gpointer v_object) {
	Request* old;
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST));
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REQUEST));
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		request_ref (value->data[0].v_pointer);
#line 2466 "scanner.c"
	} else {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2470 "scanner.c"
	}
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		request_unref (old);
#line 2476 "scanner.c"
	}
}


void value_take_request (GValue* value, gpointer v_object) {
	Request* old;
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST));
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REQUEST));
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 2495 "scanner.c"
	} else {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2499 "scanner.c"
	}
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		request_unref (old);
#line 2505 "scanner.c"
	}
}


static void request_class_init (RequestClass * klass) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	request_parent_class = g_type_class_peek_parent (klass);
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	REQUEST_CLASS (klass)->finalize = request_finalize;
#line 2515 "scanner.c"
}


static void request_instance_init (Request * self) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->ref_count = 1;
#line 2522 "scanner.c"
}


static void request_finalize (Request* obj) {
	Request * self;
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REQUEST, Request);
#line 2530 "scanner.c"
}


GType request_get_type (void) {
	static volatile gsize request_type_id__volatile = 0;
	if (g_once_init_enter (&request_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_request_init, value_request_free_value, value_request_copy_value, value_request_peek_pointer, "p", value_request_collect_value, "p", value_request_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Request), 0, (GInstanceInitFunc) request_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType request_type_id;
		request_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Request", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&request_type_id__volatile, request_type_id);
	}
	return request_type_id__volatile;
}


gpointer request_ref (gpointer instance) {
	Request* self;
	self = instance;
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return instance;
#line 2555 "scanner.c"
}


void request_unref (gpointer instance) {
	Request* self;
	self = instance;
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		REQUEST_GET_CLASS (self)->finalize (self);
#line 101 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2568 "scanner.c"
	}
}


RequestRedetect* request_redetect_construct (GType object_type) {
	RequestRedetect* self = NULL;
#line 103 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (RequestRedetect*) request_construct (object_type);
#line 103 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 2579 "scanner.c"
}


RequestRedetect* request_redetect_new (void) {
#line 103 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return request_redetect_construct (TYPE_REQUEST_REDETECT);
#line 2586 "scanner.c"
}


static void request_redetect_class_init (RequestRedetectClass * klass) {
#line 103 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	request_redetect_parent_class = g_type_class_peek_parent (klass);
#line 2593 "scanner.c"
}


static void request_redetect_instance_init (RequestRedetect * self) {
}


GType request_redetect_get_type (void) {
	static volatile gsize request_redetect_type_id__volatile = 0;
	if (g_once_init_enter (&request_redetect_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestRedetectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_redetect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestRedetect), 0, (GInstanceInitFunc) request_redetect_instance_init, NULL };
		GType request_redetect_type_id;
		request_redetect_type_id = g_type_register_static (TYPE_REQUEST, "RequestRedetect", &g_define_type_info, 0);
		g_once_init_leave (&request_redetect_type_id__volatile, request_redetect_type_id);
	}
	return request_redetect_type_id__volatile;
}


RequestCancel* request_cancel_construct (GType object_type) {
	RequestCancel* self = NULL;
#line 105 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (RequestCancel*) request_construct (object_type);
#line 105 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 2619 "scanner.c"
}


RequestCancel* request_cancel_new (void) {
#line 105 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return request_cancel_construct (TYPE_REQUEST_CANCEL);
#line 2626 "scanner.c"
}


static void request_cancel_class_init (RequestCancelClass * klass) {
#line 105 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	request_cancel_parent_class = g_type_class_peek_parent (klass);
#line 2633 "scanner.c"
}


static void request_cancel_instance_init (RequestCancel * self) {
}


GType request_cancel_get_type (void) {
	static volatile gsize request_cancel_type_id__volatile = 0;
	if (g_once_init_enter (&request_cancel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestCancelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_cancel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestCancel), 0, (GInstanceInitFunc) request_cancel_instance_init, NULL };
		GType request_cancel_type_id;
		request_cancel_type_id = g_type_register_static (TYPE_REQUEST, "RequestCancel", &g_define_type_info, 0);
		g_once_init_leave (&request_cancel_type_id__volatile, request_cancel_type_id);
	}
	return request_cancel_type_id__volatile;
}


RequestStartScan* request_start_scan_construct (GType object_type) {
	RequestStartScan* self = NULL;
#line 107 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (RequestStartScan*) request_construct (object_type);
#line 107 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 2659 "scanner.c"
}


RequestStartScan* request_start_scan_new (void) {
#line 107 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return request_start_scan_construct (TYPE_REQUEST_START_SCAN);
#line 2666 "scanner.c"
}


static void request_start_scan_class_init (RequestStartScanClass * klass) {
#line 107 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	request_start_scan_parent_class = g_type_class_peek_parent (klass);
#line 107 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	REQUEST_CLASS (klass)->finalize = request_start_scan_finalize;
#line 2675 "scanner.c"
}


static void request_start_scan_instance_init (RequestStartScan * self) {
}


static void request_start_scan_finalize (Request* obj) {
	RequestStartScan * self;
#line 107 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REQUEST_START_SCAN, RequestStartScan);
#line 109 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_scan_job_unref0 (self->job);
#line 107 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	REQUEST_CLASS (request_start_scan_parent_class)->finalize (obj);
#line 2691 "scanner.c"
}


GType request_start_scan_get_type (void) {
	static volatile gsize request_start_scan_type_id__volatile = 0;
	if (g_once_init_enter (&request_start_scan_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestStartScanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_start_scan_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestStartScan), 0, (GInstanceInitFunc) request_start_scan_instance_init, NULL };
		GType request_start_scan_type_id;
		request_start_scan_type_id = g_type_register_static (TYPE_REQUEST, "RequestStartScan", &g_define_type_info, 0);
		g_once_init_leave (&request_start_scan_type_id__volatile, request_start_scan_type_id);
	}
	return request_start_scan_type_id__volatile;
}


RequestQuit* request_quit_construct (GType object_type) {
	RequestQuit* self = NULL;
#line 112 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (RequestQuit*) request_construct (object_type);
#line 112 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 2713 "scanner.c"
}


RequestQuit* request_quit_new (void) {
#line 112 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return request_quit_construct (TYPE_REQUEST_QUIT);
#line 2720 "scanner.c"
}


static void request_quit_class_init (RequestQuitClass * klass) {
#line 112 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	request_quit_parent_class = g_type_class_peek_parent (klass);
#line 2727 "scanner.c"
}


static void request_quit_instance_init (RequestQuit * self) {
}


GType request_quit_get_type (void) {
	static volatile gsize request_quit_type_id__volatile = 0;
	if (g_once_init_enter (&request_quit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestQuitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_quit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestQuit), 0, (GInstanceInitFunc) request_quit_instance_init, NULL };
		GType request_quit_type_id;
		request_quit_type_id = g_type_register_static (TYPE_REQUEST, "RequestQuit", &g_define_type_info, 0);
		g_once_init_leave (&request_quit_type_id__volatile, request_quit_type_id);
	}
	return request_quit_type_id__volatile;
}


Credentials* credentials_construct (GType object_type) {
	Credentials* self = NULL;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (Credentials*) g_type_create_instance (object_type);
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 2753 "scanner.c"
}


Credentials* credentials_new (void) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return credentials_construct (TYPE_CREDENTIALS);
#line 2760 "scanner.c"
}


static void value_credentials_init (GValue* value) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 2767 "scanner.c"
}


static void value_credentials_free_value (GValue* value) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		credentials_unref (value->data[0].v_pointer);
#line 2776 "scanner.c"
	}
}


static void value_credentials_copy_value (const GValue* src_value, GValue* dest_value) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = credentials_ref (src_value->data[0].v_pointer);
#line 2786 "scanner.c"
	} else {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2790 "scanner.c"
	}
}


static gpointer value_credentials_peek_pointer (const GValue* value) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2798 "scanner.c"
}


static gchar* value_credentials_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 2805 "scanner.c"
		Credentials* object;
		object = collect_values[0].v_pointer;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2812 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2816 "scanner.c"
		}
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = credentials_ref (object);
#line 2820 "scanner.c"
	} else {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2824 "scanner.c"
	}
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 2828 "scanner.c"
}


static gchar* value_credentials_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Credentials** object_p;
	object_p = collect_values[0].v_pointer;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!object_p) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2839 "scanner.c"
	}
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = NULL;
#line 2845 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 2849 "scanner.c"
	} else {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = credentials_ref (value->data[0].v_pointer);
#line 2853 "scanner.c"
	}
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 2857 "scanner.c"
}


GParamSpec* param_spec_credentials (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecCredentials* spec;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CREDENTIALS), NULL);
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 2871 "scanner.c"
}


gpointer value_get_credentials (const GValue* value) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS), NULL);
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2880 "scanner.c"
}


void value_set_credentials (GValue* value, gpointer v_object) {
	Credentials* old;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS));
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CREDENTIALS));
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		credentials_ref (value->data[0].v_pointer);
#line 2900 "scanner.c"
	} else {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2904 "scanner.c"
	}
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		credentials_unref (old);
#line 2910 "scanner.c"
	}
}


void value_take_credentials (GValue* value, gpointer v_object) {
	Credentials* old;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS));
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CREDENTIALS));
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 2929 "scanner.c"
	} else {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2933 "scanner.c"
	}
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		credentials_unref (old);
#line 2939 "scanner.c"
	}
}


static void credentials_class_init (CredentialsClass * klass) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	credentials_parent_class = g_type_class_peek_parent (klass);
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	CREDENTIALS_CLASS (klass)->finalize = credentials_finalize;
#line 2949 "scanner.c"
}


static void credentials_instance_init (Credentials * self) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->ref_count = 1;
#line 2956 "scanner.c"
}


static void credentials_finalize (Credentials* obj) {
	Credentials * self;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CREDENTIALS, Credentials);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (self->username);
#line 117 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (self->password);
#line 2968 "scanner.c"
}


GType credentials_get_type (void) {
	static volatile gsize credentials_type_id__volatile = 0;
	if (g_once_init_enter (&credentials_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_credentials_init, value_credentials_free_value, value_credentials_copy_value, value_credentials_peek_pointer, "p", value_credentials_collect_value, "p", value_credentials_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CredentialsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) credentials_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Credentials), 0, (GInstanceInitFunc) credentials_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType credentials_type_id;
		credentials_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Credentials", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&credentials_type_id__volatile, credentials_type_id);
	}
	return credentials_type_id__volatile;
}


gpointer credentials_ref (gpointer instance) {
	Credentials* self;
	self = instance;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return instance;
#line 2993 "scanner.c"
}


void credentials_unref (gpointer instance) {
	Credentials* self;
	self = instance;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		CREDENTIALS_GET_CLASS (self)->finalize (self);
#line 114 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3006 "scanner.c"
	}
}


GType scan_state_get_type (void) {
	static volatile gsize scan_state_type_id__volatile = 0;
	if (g_once_init_enter (&scan_state_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_STATE_IDLE, "SCAN_STATE_IDLE", "idle"}, {SCAN_STATE_REDETECT, "SCAN_STATE_REDETECT", "redetect"}, {SCAN_STATE_OPEN, "SCAN_STATE_OPEN", "open"}, {SCAN_STATE_GET_OPTION, "SCAN_STATE_GET_OPTION", "get-option"}, {SCAN_STATE_START, "SCAN_STATE_START", "start"}, {SCAN_STATE_GET_PARAMETERS, "SCAN_STATE_GET_PARAMETERS", "get-parameters"}, {SCAN_STATE_READ, "SCAN_STATE_READ", "read"}, {0, NULL, NULL}};
		GType scan_state_type_id;
		scan_state_type_id = g_enum_register_static ("ScanState", values);
		g_once_init_leave (&scan_state_type_id__volatile, scan_state_type_id);
	}
	return scan_state_type_id__volatile;
}


static void notify_real_run (Notify* self, Scanner* scanner) {
#line 133 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 3026 "scanner.c"
}


void notify_run (Notify* self, Scanner* scanner) {
#line 133 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 133 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_GET_CLASS (self)->run (self, scanner);
#line 3035 "scanner.c"
}


Notify* notify_construct (GType object_type) {
	Notify* self = NULL;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (Notify*) g_type_create_instance (object_type);
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 3045 "scanner.c"
}


Notify* notify_new (void) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return notify_construct (TYPE_NOTIFY);
#line 3052 "scanner.c"
}


static void value_notify_init (GValue* value) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 3059 "scanner.c"
}


static void value_notify_free_value (GValue* value) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		notify_unref (value->data[0].v_pointer);
#line 3068 "scanner.c"
	}
}


static void value_notify_copy_value (const GValue* src_value, GValue* dest_value) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = notify_ref (src_value->data[0].v_pointer);
#line 3078 "scanner.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3082 "scanner.c"
	}
}


static gpointer value_notify_peek_pointer (const GValue* value) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 3090 "scanner.c"
}


static gchar* value_notify_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 3097 "scanner.c"
		Notify* object;
		object = collect_values[0].v_pointer;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3104 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3108 "scanner.c"
		}
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = notify_ref (object);
#line 3112 "scanner.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3116 "scanner.c"
	}
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 3120 "scanner.c"
}


static gchar* value_notify_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Notify** object_p;
	object_p = collect_values[0].v_pointer;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!object_p) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3131 "scanner.c"
	}
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = NULL;
#line 3137 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 3141 "scanner.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = notify_ref (value->data[0].v_pointer);
#line 3145 "scanner.c"
	}
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 3149 "scanner.c"
}


GParamSpec* param_spec_notify (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecNotify* spec;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_NOTIFY), NULL);
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 3163 "scanner.c"
}


gpointer value_get_notify (const GValue* value) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY), NULL);
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 3172 "scanner.c"
}


void value_set_notify (GValue* value, gpointer v_object) {
	Notify* old;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY));
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFY));
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		notify_ref (value->data[0].v_pointer);
#line 3192 "scanner.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3196 "scanner.c"
	}
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		notify_unref (old);
#line 3202 "scanner.c"
	}
}


void value_take_notify (GValue* value, gpointer v_object) {
	Notify* old;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY));
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFY));
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 3221 "scanner.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3225 "scanner.c"
	}
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		notify_unref (old);
#line 3231 "scanner.c"
	}
}


static void notify_class_init (NotifyClass * klass) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	notify_parent_class = g_type_class_peek_parent (klass);
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_finalize;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_real_run;
#line 3243 "scanner.c"
}


static void notify_instance_init (Notify * self) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->ref_count = 1;
#line 3250 "scanner.c"
}


static void notify_finalize (Notify* obj) {
	Notify * self;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY, Notify);
#line 3258 "scanner.c"
}


GType notify_get_type (void) {
	static volatile gsize notify_type_id__volatile = 0;
	if (g_once_init_enter (&notify_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_notify_init, value_notify_free_value, value_notify_copy_value, value_notify_peek_pointer, "p", value_notify_collect_value, "p", value_notify_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (NotifyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Notify), 0, (GInstanceInitFunc) notify_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType notify_type_id;
		notify_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Notify", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&notify_type_id__volatile, notify_type_id);
	}
	return notify_type_id__volatile;
}


gpointer notify_ref (gpointer instance) {
	Notify* self;
	self = instance;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return instance;
#line 3283 "scanner.c"
}


void notify_unref (gpointer instance) {
	Notify* self;
	self = instance;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		NOTIFY_GET_CLASS (self)->finalize (self);
#line 131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3296 "scanner.c"
	}
}


static void notify_scanning_changed_real_run (Notify* base, Scanner* scanner) {
	NotifyScanningChanged * self;
	Scanner* _tmp0_;
#line 138 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyScanningChanged*) base;
#line 138 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 138 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = scanner;
#line 138 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "scanning-changed");
#line 3312 "scanner.c"
}


NotifyScanningChanged* notify_scanning_changed_construct (GType object_type) {
	NotifyScanningChanged* self = NULL;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyScanningChanged*) notify_construct (object_type);
#line 136 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 3322 "scanner.c"
}


NotifyScanningChanged* notify_scanning_changed_new (void) {
#line 136 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return notify_scanning_changed_construct (TYPE_NOTIFY_SCANNING_CHANGED);
#line 3329 "scanner.c"
}


static void notify_scanning_changed_class_init (NotifyScanningChangedClass * klass) {
#line 136 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	notify_scanning_changed_parent_class = g_type_class_peek_parent (klass);
#line 136 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_scanning_changed_real_run;
#line 3338 "scanner.c"
}


static void notify_scanning_changed_instance_init (NotifyScanningChanged * self) {
}


GType notify_scanning_changed_get_type (void) {
	static volatile gsize notify_scanning_changed_type_id__volatile = 0;
	if (g_once_init_enter (&notify_scanning_changed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyScanningChangedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_scanning_changed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyScanningChanged), 0, (GInstanceInitFunc) notify_scanning_changed_instance_init, NULL };
		GType notify_scanning_changed_type_id;
		notify_scanning_changed_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyScanningChanged", &g_define_type_info, 0);
		g_once_init_leave (&notify_scanning_changed_type_id__volatile, notify_scanning_changed_type_id);
	}
	return notify_scanning_changed_type_id__volatile;
}


static void _scan_device_unref0_ (gpointer var) {
#line 144 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	(var == NULL) ? NULL : (var = (scan_device_unref (var), NULL));
#line 3361 "scanner.c"
}


static void _g_list_free__scan_device_unref0_ (GList* self) {
#line 144 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_list_foreach (self, (GFunc) _scan_device_unref0_, NULL);
#line 144 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_list_free (self);
#line 3370 "scanner.c"
}


NotifyUpdateDevices* notify_update_devices_construct (GType object_type, GList* devices) {
	NotifyUpdateDevices* self = NULL;
	GList* _tmp0_;
#line 143 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyUpdateDevices*) notify_construct (object_type);
#line 143 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = devices;
#line 143 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	devices = NULL;
#line 143 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	__g_list_free__scan_device_unref0_0 (self->priv->devices);
#line 143 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->devices = _tmp0_;
#line 143 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	__g_list_free__scan_device_unref0_0 (devices);
#line 143 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 3391 "scanner.c"
}


NotifyUpdateDevices* notify_update_devices_new (GList* devices) {
#line 143 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return notify_update_devices_construct (TYPE_NOTIFY_UPDATE_DEVICES, devices);
#line 3398 "scanner.c"
}


static void notify_update_devices_real_run (Notify* base, Scanner* scanner) {
	NotifyUpdateDevices * self;
	Scanner* _tmp0_;
	GList* _tmp1_;
#line 145 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyUpdateDevices*) base;
#line 145 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 145 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = scanner;
#line 145 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = self->priv->devices;
#line 145 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "update-devices", _tmp1_);
#line 3416 "scanner.c"
}


static void notify_update_devices_class_init (NotifyUpdateDevicesClass * klass) {
#line 141 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	notify_update_devices_parent_class = g_type_class_peek_parent (klass);
#line 141 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_update_devices_finalize;
#line 141 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyUpdateDevicesPrivate));
#line 141 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_update_devices_real_run;
#line 3429 "scanner.c"
}


static void notify_update_devices_instance_init (NotifyUpdateDevices * self) {
#line 141 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv = NOTIFY_UPDATE_DEVICES_GET_PRIVATE (self);
#line 3436 "scanner.c"
}


static void notify_update_devices_finalize (Notify* obj) {
	NotifyUpdateDevices * self;
#line 141 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevices);
#line 144 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	__g_list_free__scan_device_unref0_0 (self->priv->devices);
#line 141 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (notify_update_devices_parent_class)->finalize (obj);
#line 3448 "scanner.c"
}


GType notify_update_devices_get_type (void) {
	static volatile gsize notify_update_devices_type_id__volatile = 0;
	if (g_once_init_enter (&notify_update_devices_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyUpdateDevicesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_update_devices_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyUpdateDevices), 0, (GInstanceInitFunc) notify_update_devices_instance_init, NULL };
		GType notify_update_devices_type_id;
		notify_update_devices_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyUpdateDevices", &g_define_type_info, 0);
		g_once_init_leave (&notify_update_devices_type_id__volatile, notify_update_devices_type_id);
	}
	return notify_update_devices_type_id__volatile;
}


NotifyRequestAuthorization* notify_request_authorization_construct (GType object_type, const gchar* resource) {
	NotifyRequestAuthorization* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 150 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (resource != NULL, NULL);
#line 150 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyRequestAuthorization*) notify_construct (object_type);
#line 150 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = resource;
#line 150 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 150 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (self->priv->resource);
#line 150 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->resource = _tmp1_;
#line 150 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 3482 "scanner.c"
}


NotifyRequestAuthorization* notify_request_authorization_new (const gchar* resource) {
#line 150 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return notify_request_authorization_construct (TYPE_NOTIFY_REQUEST_AUTHORIZATION, resource);
#line 3489 "scanner.c"
}


static void notify_request_authorization_real_run (Notify* base, Scanner* scanner) {
	NotifyRequestAuthorization * self;
	Scanner* _tmp0_;
	const gchar* _tmp1_;
#line 152 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyRequestAuthorization*) base;
#line 152 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 152 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = scanner;
#line 152 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = self->priv->resource;
#line 152 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "request-authorization", _tmp1_);
#line 3507 "scanner.c"
}


static void notify_request_authorization_class_init (NotifyRequestAuthorizationClass * klass) {
#line 148 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	notify_request_authorization_parent_class = g_type_class_peek_parent (klass);
#line 148 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_request_authorization_finalize;
#line 148 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyRequestAuthorizationPrivate));
#line 148 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_request_authorization_real_run;
#line 3520 "scanner.c"
}


static void notify_request_authorization_instance_init (NotifyRequestAuthorization * self) {
#line 148 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv = NOTIFY_REQUEST_AUTHORIZATION_GET_PRIVATE (self);
#line 3527 "scanner.c"
}


static void notify_request_authorization_finalize (Notify* obj) {
	NotifyRequestAuthorization * self;
#line 148 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorization);
#line 151 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (self->priv->resource);
#line 148 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (notify_request_authorization_parent_class)->finalize (obj);
#line 3539 "scanner.c"
}


GType notify_request_authorization_get_type (void) {
	static volatile gsize notify_request_authorization_type_id__volatile = 0;
	if (g_once_init_enter (&notify_request_authorization_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyRequestAuthorizationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_request_authorization_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyRequestAuthorization), 0, (GInstanceInitFunc) notify_request_authorization_instance_init, NULL };
		GType notify_request_authorization_type_id;
		notify_request_authorization_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyRequestAuthorization", &g_define_type_info, 0);
		g_once_init_leave (&notify_request_authorization_type_id__volatile, notify_request_authorization_type_id);
	}
	return notify_request_authorization_type_id__volatile;
}


NotifyScanFailed* notify_scan_failed_construct (GType object_type, gint error_code, const gchar* error_string) {
	NotifyScanFailed* self = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 157 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (error_string != NULL, NULL);
#line 157 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyScanFailed*) notify_construct (object_type);
#line 157 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = error_code;
#line 157 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->error_code = _tmp0_;
#line 157 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = error_string;
#line 157 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 157 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (self->priv->error_string);
#line 157 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->error_string = _tmp2_;
#line 157 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 3578 "scanner.c"
}


NotifyScanFailed* notify_scan_failed_new (gint error_code, const gchar* error_string) {
#line 157 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return notify_scan_failed_construct (TYPE_NOTIFY_SCAN_FAILED, error_code, error_string);
#line 3585 "scanner.c"
}


static void notify_scan_failed_real_run (Notify* base, Scanner* scanner) {
	NotifyScanFailed * self;
	Scanner* _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyScanFailed*) base;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 160 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = scanner;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = self->priv->error_code;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = self->priv->error_string;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "scan-failed", _tmp1_, _tmp2_);
#line 3606 "scanner.c"
}


static void notify_scan_failed_class_init (NotifyScanFailedClass * klass) {
#line 155 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	notify_scan_failed_parent_class = g_type_class_peek_parent (klass);
#line 155 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_scan_failed_finalize;
#line 155 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyScanFailedPrivate));
#line 155 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_scan_failed_real_run;
#line 3619 "scanner.c"
}


static void notify_scan_failed_instance_init (NotifyScanFailed * self) {
#line 155 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv = NOTIFY_SCAN_FAILED_GET_PRIVATE (self);
#line 3626 "scanner.c"
}


static void notify_scan_failed_finalize (Notify* obj) {
	NotifyScanFailed * self;
#line 155 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailed);
#line 159 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (self->priv->error_string);
#line 155 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (notify_scan_failed_parent_class)->finalize (obj);
#line 3638 "scanner.c"
}


GType notify_scan_failed_get_type (void) {
	static volatile gsize notify_scan_failed_type_id__volatile = 0;
	if (g_once_init_enter (&notify_scan_failed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyScanFailedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_scan_failed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyScanFailed), 0, (GInstanceInitFunc) notify_scan_failed_instance_init, NULL };
		GType notify_scan_failed_type_id;
		notify_scan_failed_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyScanFailed", &g_define_type_info, 0);
		g_once_init_leave (&notify_scan_failed_type_id__volatile, notify_scan_failed_type_id);
	}
	return notify_scan_failed_type_id__volatile;
}


static void notify_document_done_real_run (Notify* base, Scanner* scanner) {
	NotifyDocumentDone * self;
	Scanner* _tmp0_;
#line 165 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyDocumentDone*) base;
#line 165 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 165 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = scanner;
#line 165 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "document-done");
#line 3665 "scanner.c"
}


NotifyDocumentDone* notify_document_done_construct (GType object_type) {
	NotifyDocumentDone* self = NULL;
#line 163 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyDocumentDone*) notify_construct (object_type);
#line 163 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 3675 "scanner.c"
}


NotifyDocumentDone* notify_document_done_new (void) {
#line 163 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return notify_document_done_construct (TYPE_NOTIFY_DOCUMENT_DONE);
#line 3682 "scanner.c"
}


static void notify_document_done_class_init (NotifyDocumentDoneClass * klass) {
#line 163 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	notify_document_done_parent_class = g_type_class_peek_parent (klass);
#line 163 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_document_done_real_run;
#line 3691 "scanner.c"
}


static void notify_document_done_instance_init (NotifyDocumentDone * self) {
}


GType notify_document_done_get_type (void) {
	static volatile gsize notify_document_done_type_id__volatile = 0;
	if (g_once_init_enter (&notify_document_done_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyDocumentDoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_document_done_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyDocumentDone), 0, (GInstanceInitFunc) notify_document_done_instance_init, NULL };
		GType notify_document_done_type_id;
		notify_document_done_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyDocumentDone", &g_define_type_info, 0);
		g_once_init_leave (&notify_document_done_type_id__volatile, notify_document_done_type_id);
	}
	return notify_document_done_type_id__volatile;
}


static void notify_expect_page_real_run (Notify* base, Scanner* scanner) {
	NotifyExpectPage * self;
	Scanner* _tmp0_;
#line 170 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyExpectPage*) base;
#line 170 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 170 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = scanner;
#line 170 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "expect-page");
#line 3722 "scanner.c"
}


NotifyExpectPage* notify_expect_page_construct (GType object_type) {
	NotifyExpectPage* self = NULL;
#line 168 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyExpectPage*) notify_construct (object_type);
#line 168 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 3732 "scanner.c"
}


NotifyExpectPage* notify_expect_page_new (void) {
#line 168 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return notify_expect_page_construct (TYPE_NOTIFY_EXPECT_PAGE);
#line 3739 "scanner.c"
}


static void notify_expect_page_class_init (NotifyExpectPageClass * klass) {
#line 168 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	notify_expect_page_parent_class = g_type_class_peek_parent (klass);
#line 168 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_expect_page_real_run;
#line 3748 "scanner.c"
}


static void notify_expect_page_instance_init (NotifyExpectPage * self) {
}


GType notify_expect_page_get_type (void) {
	static volatile gsize notify_expect_page_type_id__volatile = 0;
	if (g_once_init_enter (&notify_expect_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyExpectPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_expect_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyExpectPage), 0, (GInstanceInitFunc) notify_expect_page_instance_init, NULL };
		GType notify_expect_page_type_id;
		notify_expect_page_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyExpectPage", &g_define_type_info, 0);
		g_once_init_leave (&notify_expect_page_type_id__volatile, notify_expect_page_type_id);
	}
	return notify_expect_page_type_id__volatile;
}


static gpointer _scan_page_info_ref0 (gpointer self) {
#line 175 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self ? scan_page_info_ref (self) : NULL;
#line 3771 "scanner.c"
}


NotifyGotPageInfo* notify_got_page_info_construct (GType object_type, gint job_id, ScanPageInfo* info) {
	NotifyGotPageInfo* self = NULL;
	gint _tmp0_;
	ScanPageInfo* _tmp1_;
	ScanPageInfo* _tmp2_;
#line 175 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 175 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyGotPageInfo*) notify_construct (object_type);
#line 175 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = job_id;
#line 175 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->job_id = _tmp0_;
#line 175 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = info;
#line 175 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = _scan_page_info_ref0 (_tmp1_);
#line 175 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_scan_page_info_unref0 (self->priv->info);
#line 175 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->info = _tmp2_;
#line 175 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 3798 "scanner.c"
}


NotifyGotPageInfo* notify_got_page_info_new (gint job_id, ScanPageInfo* info) {
#line 175 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return notify_got_page_info_construct (TYPE_NOTIFY_GOT_PAGE_INFO, job_id, info);
#line 3805 "scanner.c"
}


static void notify_got_page_info_real_run (Notify* base, Scanner* scanner) {
	NotifyGotPageInfo * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	Scanner* _tmp2_;
	gint _tmp3_;
	gboolean _tmp7_;
#line 178 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyGotPageInfo*) base;
#line 178 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 180 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = self->priv->job_id;
#line 180 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = scanner;
#line 180 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = _tmp2_->first_job_id;
#line 180 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp1_ >= _tmp3_) {
#line 3828 "scanner.c"
		gint _tmp4_;
		Scanner* _tmp5_;
		gint _tmp6_;
#line 180 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp4_ = self->priv->job_id;
#line 180 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp5_ = scanner;
#line 180 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp6_ = _tmp5_->job_id;
#line 180 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp0_ = _tmp4_ < _tmp6_;
#line 3840 "scanner.c"
	} else {
#line 180 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp0_ = FALSE;
#line 3844 "scanner.c"
	}
#line 180 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp7_ = _tmp0_;
#line 180 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp7_) {
#line 3850 "scanner.c"
		Scanner* _tmp8_;
		ScanPageInfo* _tmp9_;
#line 181 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp8_ = scanner;
#line 181 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp9_ = self->priv->info;
#line 181 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_signal_emit_by_name (_tmp8_, "got-page-info", _tmp9_);
#line 3859 "scanner.c"
	}
}


static void notify_got_page_info_class_init (NotifyGotPageInfoClass * klass) {
#line 173 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	notify_got_page_info_parent_class = g_type_class_peek_parent (klass);
#line 173 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_got_page_info_finalize;
#line 173 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyGotPageInfoPrivate));
#line 173 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_got_page_info_real_run;
#line 3873 "scanner.c"
}


static void notify_got_page_info_instance_init (NotifyGotPageInfo * self) {
#line 173 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv = NOTIFY_GOT_PAGE_INFO_GET_PRIVATE (self);
#line 3880 "scanner.c"
}


static void notify_got_page_info_finalize (Notify* obj) {
	NotifyGotPageInfo * self;
#line 173 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfo);
#line 177 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_scan_page_info_unref0 (self->priv->info);
#line 173 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (notify_got_page_info_parent_class)->finalize (obj);
#line 3892 "scanner.c"
}


GType notify_got_page_info_get_type (void) {
	static volatile gsize notify_got_page_info_type_id__volatile = 0;
	if (g_once_init_enter (&notify_got_page_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyGotPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_got_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyGotPageInfo), 0, (GInstanceInitFunc) notify_got_page_info_instance_init, NULL };
		GType notify_got_page_info_type_id;
		notify_got_page_info_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyGotPageInfo", &g_define_type_info, 0);
		g_once_init_leave (&notify_got_page_info_type_id__volatile, notify_got_page_info_type_id);
	}
	return notify_got_page_info_type_id__volatile;
}


NotifyPageDone* notify_page_done_construct (GType object_type, gint job_id) {
	NotifyPageDone* self = NULL;
	gint _tmp0_;
#line 187 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyPageDone*) notify_construct (object_type);
#line 187 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = job_id;
#line 187 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->job_id = _tmp0_;
#line 187 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 3919 "scanner.c"
}


NotifyPageDone* notify_page_done_new (gint job_id) {
#line 187 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return notify_page_done_construct (TYPE_NOTIFY_PAGE_DONE, job_id);
#line 3926 "scanner.c"
}


static void notify_page_done_real_run (Notify* base, Scanner* scanner) {
	NotifyPageDone * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	Scanner* _tmp2_;
	gint _tmp3_;
	gboolean _tmp7_;
#line 189 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyPageDone*) base;
#line 189 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 191 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = self->priv->job_id;
#line 191 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = scanner;
#line 191 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = _tmp2_->first_job_id;
#line 191 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp1_ >= _tmp3_) {
#line 3949 "scanner.c"
		gint _tmp4_;
		Scanner* _tmp5_;
		gint _tmp6_;
#line 191 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp4_ = self->priv->job_id;
#line 191 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp5_ = scanner;
#line 191 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp6_ = _tmp5_->job_id;
#line 191 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp0_ = _tmp4_ < _tmp6_;
#line 3961 "scanner.c"
	} else {
#line 191 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp0_ = FALSE;
#line 3965 "scanner.c"
	}
#line 191 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp7_ = _tmp0_;
#line 191 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp7_) {
#line 3971 "scanner.c"
		Scanner* _tmp8_;
#line 192 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp8_ = scanner;
#line 192 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_signal_emit_by_name (_tmp8_, "page-done");
#line 3977 "scanner.c"
	}
}


static void notify_page_done_class_init (NotifyPageDoneClass * klass) {
#line 185 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	notify_page_done_parent_class = g_type_class_peek_parent (klass);
#line 185 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_page_done_finalize;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyPageDonePrivate));
#line 185 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_page_done_real_run;
#line 3991 "scanner.c"
}


static void notify_page_done_instance_init (NotifyPageDone * self) {
#line 185 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv = NOTIFY_PAGE_DONE_GET_PRIVATE (self);
#line 3998 "scanner.c"
}


static void notify_page_done_finalize (Notify* obj) {
	NotifyPageDone * self;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_PAGE_DONE, NotifyPageDone);
#line 185 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (notify_page_done_parent_class)->finalize (obj);
#line 4008 "scanner.c"
}


GType notify_page_done_get_type (void) {
	static volatile gsize notify_page_done_type_id__volatile = 0;
	if (g_once_init_enter (&notify_page_done_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyPageDoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_page_done_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyPageDone), 0, (GInstanceInitFunc) notify_page_done_instance_init, NULL };
		GType notify_page_done_type_id;
		notify_page_done_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyPageDone", &g_define_type_info, 0);
		g_once_init_leave (&notify_page_done_type_id__volatile, notify_page_done_type_id);
	}
	return notify_page_done_type_id__volatile;
}


static gpointer _scan_line_ref0 (gpointer self) {
#line 198 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self ? scan_line_ref (self) : NULL;
#line 4027 "scanner.c"
}


NotifyGotLine* notify_got_line_construct (GType object_type, gint job_id, ScanLine* line) {
	NotifyGotLine* self = NULL;
	gint _tmp0_;
	ScanLine* _tmp1_;
	ScanLine* _tmp2_;
#line 198 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (line != NULL, NULL);
#line 198 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyGotLine*) notify_construct (object_type);
#line 198 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = job_id;
#line 198 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->job_id = _tmp0_;
#line 198 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = line;
#line 198 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = _scan_line_ref0 (_tmp1_);
#line 198 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_scan_line_unref0 (self->priv->line);
#line 198 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->line = _tmp2_;
#line 198 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 4054 "scanner.c"
}


NotifyGotLine* notify_got_line_new (gint job_id, ScanLine* line) {
#line 198 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return notify_got_line_construct (TYPE_NOTIFY_GOT_LINE, job_id, line);
#line 4061 "scanner.c"
}


static void notify_got_line_real_run (Notify* base, Scanner* scanner) {
	NotifyGotLine * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	Scanner* _tmp2_;
	gint _tmp3_;
	gboolean _tmp7_;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (NotifyGotLine*) base;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 203 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = self->priv->job_id;
#line 203 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = scanner;
#line 203 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = _tmp2_->first_job_id;
#line 203 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp1_ >= _tmp3_) {
#line 4084 "scanner.c"
		gint _tmp4_;
		Scanner* _tmp5_;
		gint _tmp6_;
#line 203 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp4_ = self->priv->job_id;
#line 203 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp5_ = scanner;
#line 203 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp6_ = _tmp5_->job_id;
#line 203 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp0_ = _tmp4_ < _tmp6_;
#line 4096 "scanner.c"
	} else {
#line 203 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp0_ = FALSE;
#line 4100 "scanner.c"
	}
#line 203 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp7_ = _tmp0_;
#line 203 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp7_) {
#line 4106 "scanner.c"
		Scanner* _tmp8_;
		ScanLine* _tmp9_;
#line 204 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp8_ = scanner;
#line 204 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp9_ = self->priv->line;
#line 204 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_signal_emit_by_name (_tmp8_, "got-line", _tmp9_);
#line 4115 "scanner.c"
	}
}


static void notify_got_line_class_init (NotifyGotLineClass * klass) {
#line 196 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	notify_got_line_parent_class = g_type_class_peek_parent (klass);
#line 196 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (klass)->finalize = notify_got_line_finalize;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyGotLinePrivate));
#line 196 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (klass)->run = notify_got_line_real_run;
#line 4129 "scanner.c"
}


static void notify_got_line_instance_init (NotifyGotLine * self) {
#line 196 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv = NOTIFY_GOT_LINE_GET_PRIVATE (self);
#line 4136 "scanner.c"
}


static void notify_got_line_finalize (Notify* obj) {
	NotifyGotLine * self;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_GOT_LINE, NotifyGotLine);
#line 200 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_scan_line_unref0 (self->priv->line);
#line 196 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	NOTIFY_CLASS (notify_got_line_parent_class)->finalize (obj);
#line 4148 "scanner.c"
}


GType notify_got_line_get_type (void) {
	static volatile gsize notify_got_line_type_id__volatile = 0;
	if (g_once_init_enter (&notify_got_line_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyGotLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_got_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyGotLine), 0, (GInstanceInitFunc) notify_got_line_instance_init, NULL };
		GType notify_got_line_type_id;
		notify_got_line_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyGotLine", &g_define_type_info, 0);
		g_once_init_leave (&notify_got_line_type_id__volatile, notify_got_line_type_id);
	}
	return notify_got_line_type_id__volatile;
}


static void _scan_job_unref0_ (gpointer var) {
#line 234 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	(var == NULL) ? NULL : (var = (scan_job_unref (var), NULL));
#line 4167 "scanner.c"
}


static void _g_list_free__scan_job_unref0_ (GList* self) {
#line 234 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_list_foreach (self, (GFunc) _scan_job_unref0_, NULL);
#line 234 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_list_free (self);
#line 4176 "scanner.c"
}


static void _request_unref0_ (gpointer var) {
#line 273 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	(var == NULL) ? NULL : (var = (request_unref (var), NULL));
#line 4183 "scanner.c"
}


static void _notify_unref0_ (gpointer var) {
#line 274 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	(var == NULL) ? NULL : (var = (notify_unref (var), NULL));
#line 4190 "scanner.c"
}


static void _credentials_unref0_ (gpointer var) {
#line 275 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	(var == NULL) ? NULL : (var = (credentials_unref (var), NULL));
#line 4197 "scanner.c"
}


static Scanner* scanner_construct (GType object_type) {
	Scanner* self = NULL;
	GAsyncQueue* _tmp0_;
	GAsyncQueue* _tmp1_;
	GAsyncQueue* _tmp2_;
#line 271 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = (Scanner*) g_type_create_instance (object_type);
#line 273 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = g_async_queue_new_full (_request_unref0_);
#line 273 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->request_queue);
#line 273 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->request_queue = _tmp0_;
#line 274 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = g_async_queue_new_full (_notify_unref0_);
#line 274 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->notify_queue);
#line 274 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->notify_queue = _tmp1_;
#line 275 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = g_async_queue_new_full (_credentials_unref0_);
#line 275 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->authorize_queue);
#line 275 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->authorize_queue = _tmp2_;
#line 271 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self;
#line 4228 "scanner.c"
}


static Scanner* scanner_new (void) {
#line 271 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return scanner_construct (TYPE_SCANNER);
#line 4235 "scanner.c"
}


static gpointer _scanner_ref0 (gpointer self) {
#line 282 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self ? scanner_ref (self) : NULL;
#line 4242 "scanner.c"
}


Scanner* scanner_get_instance (void) {
	Scanner* result = NULL;
	Scanner* _tmp0_;
	Scanner* _tmp2_;
	Scanner* _tmp3_;
#line 280 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = scanner_scanner_object;
#line 280 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp0_ == NULL) {
#line 4255 "scanner.c"
		Scanner* _tmp1_;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp1_ = scanner_new ();
#line 281 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_scanner_unref0 (scanner_scanner_object);
#line 281 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scanner_scanner_object = _tmp1_;
#line 4263 "scanner.c"
	}
#line 282 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = scanner_scanner_object;
#line 282 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = _scanner_ref0 (_tmp2_);
#line 282 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	result = _tmp3_;
#line 282 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return result;
#line 4273 "scanner.c"
}


static gboolean scanner_notify_idle_cb (Scanner* self) {
	gboolean result = FALSE;
	GAsyncQueue* _tmp0_;
	gpointer _tmp1_ = NULL;
	Notify* notification;
#line 285 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 287 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = self->priv->notify_queue;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = g_async_queue_pop (_tmp0_);
#line 287 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	notification = (Notify*) _tmp1_;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	notify_run (notification, self);
#line 289 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	result = FALSE;
#line 289 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_notify_unref0 (notification);
#line 289 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return result;
#line 4298 "scanner.c"
}


static gpointer _notify_ref0 (gpointer self) {
#line 294 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self ? notify_ref (self) : NULL;
#line 4305 "scanner.c"
}


static gboolean _scanner_notify_idle_cb_gsource_func (gpointer self) {
	gboolean result;
	result = scanner_notify_idle_cb (self);
#line 295 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return result;
#line 4314 "scanner.c"
}


static void scanner_notify (Scanner* self, Notify* notification) {
	GAsyncQueue* _tmp0_;
	Notify* _tmp1_;
	Notify* _tmp2_;
#line 292 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 292 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (notification != NULL);
#line 294 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = self->priv->notify_queue;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = notification;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = _notify_ref0 (_tmp1_);
#line 294 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_async_queue_push (_tmp0_, _tmp2_);
#line 295 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _scanner_notify_idle_cb_gsource_func, scanner_ref (self), scanner_unref);
#line 4336 "scanner.c"
}


static void scanner_set_scanning (Scanner* self, gboolean is_scanning) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp9_;
#line 298 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = self->priv->scanning;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp2_) {
#line 4352 "scanner.c"
		gboolean _tmp3_;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp3_ = is_scanning;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp1_ = !_tmp3_;
#line 4358 "scanner.c"
	} else {
#line 300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp1_ = FALSE;
#line 4362 "scanner.c"
	}
#line 300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = _tmp1_;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp4_) {
#line 300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp0_ = TRUE;
#line 4370 "scanner.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		gboolean _tmp8_;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp6_ = self->priv->scanning;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (!_tmp6_) {
#line 4379 "scanner.c"
			gboolean _tmp7_;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp7_ = is_scanning;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp5_ = _tmp7_;
#line 4385 "scanner.c"
		} else {
#line 300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp5_ = FALSE;
#line 4389 "scanner.c"
		}
#line 300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp8_ = _tmp5_;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp0_ = _tmp8_;
#line 4395 "scanner.c"
	}
#line 300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp9_ = _tmp0_;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp9_) {
#line 4401 "scanner.c"
		gboolean _tmp10_;
		NotifyScanningChanged* _tmp11_;
		NotifyScanningChanged* _tmp12_;
#line 302 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp10_ = is_scanning;
#line 302 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->scanning = _tmp10_;
#line 303 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp11_ = notify_scanning_changed_new ();
#line 303 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp12_ = _tmp11_;
#line 303 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp12_);
#line 303 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_notify_unref0 (_tmp12_);
#line 4417 "scanner.c"
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
#line 1238 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1238 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1239 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1239 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1239 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1239 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 4438 "scanner.c"
}


static gint scanner_get_device_weight (const gchar* device) {
	gint result = 0;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
#line 307 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (device != NULL, 0);
#line 312 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = device;
#line 312 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = g_str_has_prefix (_tmp0_, "vfl:");
#line 312 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp1_) {
#line 313 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		result = 2;
#line 313 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return result;
#line 4460 "scanner.c"
	}
#line 316 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = device;
#line 316 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = string_contains (_tmp2_, "usb");
#line 316 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp3_) {
#line 317 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		result = 0;
#line 317 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return result;
#line 4472 "scanner.c"
	}
#line 319 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	result = 1;
#line 319 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return result;
#line 4478 "scanner.c"
}


static gint scanner_compare_devices (ScanDevice* device1, ScanDevice* device2) {
	gint result = 0;
	ScanDevice* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	gint weight1;
	ScanDevice* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	gint weight2;
	gint _tmp6_;
	gint _tmp7_;
	GCompareFunc _tmp10_;
	ScanDevice* _tmp11_;
	const gchar* _tmp12_;
	ScanDevice* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_ = 0;
#line 322 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (device1 != NULL, 0);
#line 322 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (device2 != NULL, 0);
#line 326 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = device1;
#line 326 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = _tmp0_->name;
#line 326 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = scanner_get_device_weight (_tmp1_);
#line 326 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	weight1 = _tmp2_;
#line 327 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = device2;
#line 327 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = _tmp3_->name;
#line 327 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = scanner_get_device_weight (_tmp4_);
#line 327 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	weight2 = _tmp5_;
#line 328 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp6_ = weight1;
#line 328 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp7_ = weight2;
#line 328 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp6_ != _tmp7_) {
#line 4526 "scanner.c"
		gint _tmp8_;
		gint _tmp9_;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp8_ = weight1;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp9_ = weight2;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		result = _tmp8_ - _tmp9_;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return result;
#line 4537 "scanner.c"
	}
#line 331 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp10_ = g_strcmp0;
#line 331 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp11_ = device1;
#line 331 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp12_ = _tmp11_->label;
#line 331 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp13_ = device2;
#line 331 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp14_ = _tmp13_->label;
#line 331 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp15_ = _tmp10_ (_tmp12_, _tmp14_);
#line 331 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	result = _tmp15_;
#line 331 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return result;
#line 4555 "scanner.c"
}


static gchar* sane_status_to_string (SANE_Status status) {
	gchar* result = NULL;
	SANE_Status _tmp0_;
#line 54 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
	_tmp0_ = status;
#line 54 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
	switch (_tmp0_) {
#line 54 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
		case SANE_STATUS_GOOD:
#line 4568 "scanner.c"
		{
			gchar* _tmp1_;
#line 57 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp1_ = g_strdup ("SANE_STATUS_GOOD");
#line 57 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp1_;
#line 57 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 4577 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
		case SANE_STATUS_UNSUPPORTED:
#line 4581 "scanner.c"
		{
			gchar* _tmp2_;
#line 59 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp2_ = g_strdup ("SANE_STATUS_UNSUPPORTED");
#line 59 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp2_;
#line 59 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 4590 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
		case SANE_STATUS_CANCELLED:
#line 4594 "scanner.c"
		{
			gchar* _tmp3_;
#line 61 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp3_ = g_strdup ("SANE_STATUS_CANCELLED");
#line 61 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp3_;
#line 61 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 4603 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
		case SANE_STATUS_DEVICE_BUSY:
#line 4607 "scanner.c"
		{
			gchar* _tmp4_;
#line 63 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp4_ = g_strdup ("SANE_STATUS_DEVICE_BUSY");
#line 63 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp4_;
#line 63 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 4616 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
		case SANE_STATUS_INVAL:
#line 4620 "scanner.c"
		{
			gchar* _tmp5_;
#line 65 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp5_ = g_strdup ("SANE_STATUS_INVAL");
#line 65 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp5_;
#line 65 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 4629 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
		case SANE_STATUS_EOF:
#line 4633 "scanner.c"
		{
			gchar* _tmp6_;
#line 67 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp6_ = g_strdup ("SANE_STATUS_EOF");
#line 67 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp6_;
#line 67 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 4642 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
		case SANE_STATUS_JAMMED:
#line 4646 "scanner.c"
		{
			gchar* _tmp7_;
#line 69 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp7_ = g_strdup ("SANE_STATUS_JAMMED");
#line 69 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp7_;
#line 69 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 4655 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
		case SANE_STATUS_NO_DOCS:
#line 4659 "scanner.c"
		{
			gchar* _tmp8_;
#line 71 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp8_ = g_strdup ("SANE_STATUS_NO_DOCS");
#line 71 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp8_;
#line 71 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 4668 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
		case SANE_STATUS_COVER_OPEN:
#line 4672 "scanner.c"
		{
			gchar* _tmp9_;
#line 73 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp9_ = g_strdup ("SANE_STATUS_COVER_OPEN");
#line 73 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp9_;
#line 73 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 4681 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
		case SANE_STATUS_IO_ERROR:
#line 4685 "scanner.c"
		{
			gchar* _tmp10_;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp10_ = g_strdup ("SANE_STATUS_IO_ERROR");
#line 75 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp10_;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 4694 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
		case SANE_STATUS_NO_MEM:
#line 4698 "scanner.c"
		{
			gchar* _tmp11_;
#line 77 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp11_ = g_strdup ("SANE_STATUS_NO_MEM");
#line 77 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp11_;
#line 77 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 4707 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
		case SANE_STATUS_ACCESS_DENIED:
#line 4711 "scanner.c"
		{
			gchar* _tmp12_;
#line 79 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp12_ = g_strdup ("SANE_STATUS_ACCESS_DENIED");
#line 79 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp12_;
#line 79 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 4720 "scanner.c"
		}
		default:
		{
			SANE_Status _tmp13_;
			gchar* _tmp14_ = NULL;
#line 81 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp13_ = status;
#line 81 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp14_ = g_strdup_printf ("SANE_STATUS(%d)", (gint) _tmp13_);
#line 81 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp14_;
#line 81 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 4734 "scanner.c"
		}
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1242 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1242 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1242 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 4749 "scanner.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4779 "scanner.c"
				goto __catch14_g_regex_error;
			}
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			return NULL;
#line 4788 "scanner.c"
		}
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = regex;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = replacement;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4804 "scanner.c"
				goto __catch14_g_regex_error;
			}
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			return NULL;
#line 4815 "scanner.c"
		}
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = _tmp8_;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 4823 "scanner.c"
	}
	goto __finally14;
	__catch14_g_regex_error:
	{
		GError* e = NULL;
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1247 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 4837 "scanner.c"
	}
	__finally14:
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return NULL;
#line 4848 "scanner.c"
	}
}


static gpointer _scan_device_ref0 (gpointer self) {
#line 365 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self ? scan_device_ref (self) : NULL;
#line 4856 "scanner.c"
}


static gint _scanner_compare_devices_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = scanner_compare_devices (a, b);
#line 369 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return result;
#line 4865 "scanner.c"
}


static void scanner_do_redetect (Scanner* self) {
	SANE_Device** device_list;
	gint device_list_length1;
	gint _device_list_size_;
	SANE_Device** _tmp0_ = NULL;
	SANE_Status _tmp1_ = 0;
	SANE_Status status;
	SANE_Status _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	SANE_Status _tmp5_;
	GList* devices;
	GList* _tmp57_;
	GList* _tmp64_;
	NotifyUpdateDevices* _tmp65_;
	NotifyUpdateDevices* _tmp66_;
#line 334 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 336 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	device_list = NULL;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	device_list_length1 = 0;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_device_list_size_ = device_list_length1;
#line 337 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = sane_get_devices (&_tmp0_, FALSE);
#line 337 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	device_list = _tmp0_;
#line 337 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	device_list_length1 = -1;
#line 337 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_device_list_size_ = device_list_length1;
#line 337 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	status = _tmp1_;
#line 338 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = status;
#line 338 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = sane_status_to_string (_tmp2_);
#line 338 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = _tmp3_;
#line 338 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:338: sane_get_devices () -> %s", _tmp4_);
#line 338 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp4_);
#line 339 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = status;
#line 339 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp5_ != SANE_STATUS_GOOD) {
#line 4917 "scanner.c"
		SANE_Status _tmp6_;
		const gchar* _tmp7_ = NULL;
#line 341 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp6_ = status;
#line 341 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp7_ = sane_strstatus (_tmp6_);
#line 341 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_warning ("scanner.vala:341: Unable to get SANE devices: %s", _tmp7_);
#line 342 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->need_redetect = FALSE;
#line 343 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->state = SCAN_STATE_IDLE;
#line 344 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return;
#line 4932 "scanner.c"
	}
#line 347 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	devices = NULL;
#line 4936 "scanner.c"
	{
		gint i;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		i = 0;
#line 4941 "scanner.c"
		{
			gboolean _tmp8_;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp8_ = TRUE;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			while (TRUE) {
#line 4948 "scanner.c"
				gboolean _tmp9_;
				SANE_Device** _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				SANE_Device* _tmp13_;
				SANE_Device** _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				SANE_Device* _tmp16_;
				const gchar* _tmp17_;
				SANE_Device** _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				SANE_Device* _tmp20_;
				const gchar* _tmp21_;
				SANE_Device** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				SANE_Device* _tmp24_;
				const gchar* _tmp25_;
				SANE_Device** _tmp26_;
				gint _tmp26__length1;
				gint _tmp27_;
				SANE_Device* _tmp28_;
				const gchar* _tmp29_;
				ScanDevice* _tmp30_;
				ScanDevice* scan_device;
				ScanDevice* _tmp31_;
				SANE_Device** _tmp32_;
				gint _tmp32__length1;
				gint _tmp33_;
				SANE_Device* _tmp34_;
				const gchar* _tmp35_;
				gchar* _tmp36_;
				SANE_Device** _tmp37_;
				gint _tmp37__length1;
				gint _tmp38_;
				SANE_Device* _tmp39_;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* vendor;
				const gchar* _tmp42_;
				ScanDevice* _tmp44_;
				const gchar* _tmp45_;
				SANE_Device** _tmp46_;
				gint _tmp46__length1;
				gint _tmp47_;
				SANE_Device* _tmp48_;
				const gchar* _tmp49_;
				gchar* _tmp50_ = NULL;
				ScanDevice* _tmp51_;
				const gchar* _tmp52_;
				gchar* _tmp53_ = NULL;
				gchar* _tmp54_;
				ScanDevice* _tmp55_;
				ScanDevice* _tmp56_;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp9_ = _tmp8_;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				if (!_tmp9_) {
#line 5009 "scanner.c"
					gint _tmp10_;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp10_ = i;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					i = _tmp10_ + 1;
#line 5015 "scanner.c"
				}
#line 348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp8_ = FALSE;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp11_ = device_list;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp11__length1 = device_list_length1;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp12_ = i;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp13_ = _tmp11_[_tmp12_];
#line 348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				if (!(_tmp13_ != NULL)) {
#line 348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					break;
#line 5031 "scanner.c"
				}
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp14_ = device_list;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp14__length1 = device_list_length1;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp15_ = i;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp16_ = _tmp14_[_tmp15_];
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp17_ = _tmp16_->name;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp18_ = device_list;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp18__length1 = device_list_length1;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp19_ = i;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp20_ = _tmp18_[_tmp19_];
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp21_ = _tmp20_->vendor;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp22_ = device_list;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp22__length1 = device_list_length1;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp23_ = i;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp24_ = _tmp22_[_tmp23_];
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp25_ = _tmp24_->model;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp26_ = device_list;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp26__length1 = device_list_length1;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp27_ = i;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp28_ = _tmp26_[_tmp27_];
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp29_ = _tmp28_->type;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				g_debug ("scanner.vala:350: Device: name=\"%s\" vendor=\"%s\" model=\"%s\" type=" \
"\"%s\"", _tmp17_, _tmp21_, _tmp25_, _tmp29_);
#line 353 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp30_ = scan_device_new ();
#line 353 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scan_device = _tmp30_;
#line 354 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp31_ = scan_device;
#line 354 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp32_ = device_list;
#line 354 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp32__length1 = device_list_length1;
#line 354 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp33_ = i;
#line 354 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp34_ = _tmp32_[_tmp33_];
#line 354 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp35_ = _tmp34_->name;
#line 354 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp36_ = g_strdup (_tmp35_);
#line 354 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_g_free0 (_tmp31_->name);
#line 354 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp31_->name = _tmp36_;
#line 357 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp37_ = device_list;
#line 357 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp37__length1 = device_list_length1;
#line 357 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp38_ = i;
#line 357 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp39_ = _tmp37_[_tmp38_];
#line 357 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp40_ = _tmp39_->vendor;
#line 357 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp41_ = g_strdup (_tmp40_);
#line 357 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				vendor = _tmp41_;
#line 358 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp42_ = vendor;
#line 358 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				if (g_strcmp0 (_tmp42_, "Hewlett-Packard") == 0) {
#line 5115 "scanner.c"
					gchar* _tmp43_;
#line 359 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp43_ = g_strdup ("HP");
#line 359 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_g_free0 (vendor);
#line 359 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					vendor = _tmp43_;
#line 5123 "scanner.c"
				}
#line 361 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp44_ = scan_device;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp45_ = vendor;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp46_ = device_list;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp46__length1 = device_list_length1;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp47_ = i;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp48_ = _tmp46_[_tmp47_];
#line 361 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp49_ = _tmp48_->model;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp50_ = g_strdup_printf ("%s %s", _tmp45_, _tmp49_);
#line 361 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_g_free0 (_tmp44_->label);
#line 361 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp44_->label = _tmp50_;
#line 363 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp51_ = scan_device;
#line 363 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp52_ = _tmp51_->label;
#line 363 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp53_ = string_replace (_tmp52_, "_", " ");
#line 363 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp54_ = _tmp53_;
#line 363 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_g_free0 (_tmp54_);
#line 365 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp55_ = scan_device;
#line 365 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp56_ = _scan_device_ref0 (_tmp55_);
#line 365 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				devices = g_list_append (devices, _tmp56_);
#line 348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_g_free0 (vendor);
#line 348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_scan_device_unref0 (scan_device);
#line 5165 "scanner.c"
			}
		}
	}
#line 369 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	devices = g_list_sort (devices, _scanner_compare_devices_gcompare_func);
#line 371 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->need_redetect = FALSE;
#line 372 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 374 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp57_ = devices;
#line 374 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp57_ != NULL) {
#line 5179 "scanner.c"
		GList* _tmp58_;
		gconstpointer _tmp59_ = NULL;
		ScanDevice* _tmp60_;
		ScanDevice* device;
		ScanDevice* _tmp61_;
		const gchar* _tmp62_;
		gchar* _tmp63_;
#line 376 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp58_ = devices;
#line 376 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp59_ = g_list_nth_data (_tmp58_, (guint) 0);
#line 376 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp60_ = _scan_device_ref0 ((ScanDevice*) _tmp59_);
#line 376 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		device = _tmp60_;
#line 377 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp61_ = device;
#line 377 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp62_ = _tmp61_->name;
#line 377 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp63_ = g_strdup (_tmp62_);
#line 377 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_g_free0 (self->priv->default_device);
#line 377 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->default_device = _tmp63_;
#line 374 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_scan_device_unref0 (device);
#line 5207 "scanner.c"
	} else {
#line 380 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_g_free0 (self->priv->default_device);
#line 380 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->default_device = NULL;
#line 5213 "scanner.c"
	}
#line 382 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp64_ = devices;
#line 382 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	devices = NULL;
#line 382 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp65_ = notify_update_devices_new (_tmp64_);
#line 382 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp66_ = _tmp65_;
#line 382 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp66_);
#line 382 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_notify_unref0 (_tmp66_);
#line 334 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	__g_list_free__scan_device_unref0_0 (devices);
#line 5229 "scanner.c"
}


static gint scanner_scale_int (Scanner* self, gint source_min, gint source_max, SANE_Option_Descriptor* option, gint value) {
	gint result = 0;
	gint _tmp0_;
	gint v;
	SANE_Option_Descriptor* _tmp1_;
	SANE_Value_Type _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_ = FALSE;
	SANE_Option_Descriptor* _tmp5_;
	SANE_Constraint_Type _tmp6_;
	gboolean _tmp13_;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 385 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (option != NULL, 0);
#line 387 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = value;
#line 387 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	v = _tmp0_;
#line 389 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = option;
#line 389 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = _tmp1_->type;
#line 389 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = value;
#line 389 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (_tmp2_ == SANE_TYPE_INT, _tmp3_);
#line 391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = option;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp6_ = _tmp5_->constraint_type;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp6_ == SANE_CONSTRAINT_RANGE) {
#line 5266 "scanner.c"
		SANE_Option_Descriptor* _tmp7_;
		SANE_Range* _tmp8_;
		SANE_Word _tmp9_;
		SANE_Option_Descriptor* _tmp10_;
		SANE_Range* _tmp11_;
		SANE_Word _tmp12_;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp7_ = option;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp8_ = _tmp7_->constraint.range;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp9_ = _tmp8_->max;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp10_ = option;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp11_ = _tmp10_->constraint.range;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp12_ = _tmp11_->min;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp4_ = _tmp9_ != _tmp12_;
#line 5287 "scanner.c"
	} else {
#line 391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp4_ = FALSE;
#line 5291 "scanner.c"
	}
#line 391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp13_ = _tmp4_;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp13_) {
#line 5297 "scanner.c"
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		SANE_Option_Descriptor* _tmp17_;
		SANE_Range* _tmp18_;
		SANE_Word _tmp19_;
		SANE_Option_Descriptor* _tmp20_;
		SANE_Range* _tmp21_;
		SANE_Word _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		SANE_Option_Descriptor* _tmp27_;
		SANE_Range* _tmp28_;
		SANE_Word _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		SANE_Option_Descriptor* _tmp34_;
		SANE_Range* _tmp35_;
		SANE_Word _tmp36_;
		SANE_Option_Descriptor* _tmp37_;
		SANE_Range* _tmp38_;
		SANE_Word _tmp39_;
#line 393 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp14_ = v;
#line 393 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp15_ = source_min;
#line 393 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		v = _tmp14_ - _tmp15_;
#line 394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp16_ = v;
#line 394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp17_ = option;
#line 394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp18_ = _tmp17_->constraint.range;
#line 394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp19_ = _tmp18_->max;
#line 394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp20_ = option;
#line 394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp21_ = _tmp20_->constraint.range;
#line 394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp22_ = _tmp21_->min;
#line 394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		v = _tmp16_ * ((gint) (_tmp19_ - _tmp22_));
#line 395 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp23_ = v;
#line 395 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp24_ = source_max;
#line 395 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp25_ = source_min;
#line 395 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		v = _tmp23_ / (_tmp24_ - _tmp25_);
#line 396 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp26_ = v;
#line 396 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp27_ = option;
#line 396 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp28_ = _tmp27_->constraint.range;
#line 396 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp29_ = _tmp28_->min;
#line 396 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		v = _tmp26_ + ((gint) _tmp29_);
#line 397 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp30_ = value;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp31_ = source_min;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp32_ = source_max;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp33_ = v;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp34_ = option;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp35_ = _tmp34_->constraint.range;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp36_ = _tmp35_->min;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp37_ = option;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp38_ = _tmp37_->constraint.range;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp39_ = _tmp38_->max;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_debug ("scanner.vala:397: scale_int: scaling %d [min: %d, max: %d] to %d [min:" \
" %d, max: %d]", _tmp30_, _tmp31_, _tmp32_, _tmp33_, (gint) _tmp36_, (gint) _tmp39_);
#line 5386 "scanner.c"
	}
#line 401 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	result = v;
#line 401 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return result;
#line 5392 "scanner.c"
}


static gboolean scanner_set_default_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index) {
	gboolean result = FALSE;
	SANE_Option_Descriptor* _tmp0_;
	SANE_Int _tmp1_;
	SANE_Handle _tmp2_;
	SANE_Int _tmp3_;
	SANE_Status _tmp4_ = 0;
	SANE_Status status;
	SANE_Int _tmp5_;
	SANE_Status _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	SANE_Status _tmp9_;
	SANE_Status _tmp14_;
#line 404 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 404 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (option != NULL, FALSE);
#line 407 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = option;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = _tmp0_->cap;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if ((_tmp1_ & SANE_CAP_AUTOMATIC) == ((SANE_Int) 0)) {
#line 408 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		result = FALSE;
#line 408 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return result;
#line 5424 "scanner.c"
	}
#line 410 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = handle;
#line 410 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = option_index;
#line 410 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = sane_control_option (_tmp2_, _tmp3_, SANE_ACTION_SET_AUTO, NULL, NULL);
#line 410 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	status = _tmp4_;
#line 411 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = option_index;
#line 411 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp6_ = status;
#line 411 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp7_ = sane_status_to_string (_tmp6_);
#line 411 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp8_ = _tmp7_;
#line 411 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:411: sane_control_option (%d, SANE_ACTION_SET_AUTO) -> %s", (gint) _tmp5_, _tmp8_);
#line 411 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp8_);
#line 412 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp9_ = status;
#line 412 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp9_ != SANE_STATUS_GOOD) {
#line 5450 "scanner.c"
		SANE_Option_Descriptor* _tmp10_;
		const gchar* _tmp11_;
		SANE_Status _tmp12_;
		const gchar* _tmp13_ = NULL;
#line 413 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp10_ = option;
#line 413 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp11_ = _tmp10_->name;
#line 413 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp12_ = status;
#line 413 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp13_ = sane_strstatus (_tmp12_);
#line 413 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_warning ("scanner.vala:413: Error setting default option %s: %s", _tmp11_, _tmp13_);
#line 5465 "scanner.c"
	}
#line 415 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp14_ = status;
#line 415 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	result = _tmp14_ == SANE_STATUS_GOOD;
#line 415 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return result;
#line 5473 "scanner.c"
}


static void scanner_set_bool_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gboolean value, gboolean* _result_) {
	gboolean _vala_result = FALSE;
	SANE_Option_Descriptor* _tmp0_;
	SANE_Value_Type _tmp1_;
	gboolean _tmp2_;
	SANE_Bool v;
	SANE_Handle _tmp3_;
	SANE_Int _tmp4_;
	SANE_Status _tmp5_ = 0;
	SANE_Status status;
	SANE_Bool _tmp6_;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_;
	SANE_Int _tmp11_;
	const gchar* _tmp12_;
	SANE_Status _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	const gchar* _tmp16_;
#line 418 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 418 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 420 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = option;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = _tmp0_->type;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (_tmp1_ == SANE_TYPE_BOOL);
#line 422 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = value;
#line 422 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	v = (SANE_Bool) _tmp2_;
#line 423 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = handle;
#line 423 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = option_index;
#line 423 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = sane_control_option (_tmp3_, _tmp4_, SANE_ACTION_SET_VALUE, &v, NULL);
#line 423 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	status = _tmp5_;
#line 424 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp6_ = v;
#line 424 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_vala_result = (gboolean) _tmp6_;
#line 425 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp8_ = value;
#line 425 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp8_) {
#line 425 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp7_ = "SANE_TRUE";
#line 5530 "scanner.c"
	} else {
#line 425 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp7_ = "SANE_FALSE";
#line 5534 "scanner.c"
	}
#line 425 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp10_ = _vala_result;
#line 425 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp10_) {
#line 425 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp9_ = "SANE_TRUE";
#line 5542 "scanner.c"
	} else {
#line 425 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp9_ = "SANE_FALSE";
#line 5546 "scanner.c"
	}
#line 425 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp11_ = option_index;
#line 425 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp12_ = _tmp7_;
#line 425 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp13_ = status;
#line 425 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp14_ = sane_status_to_string (_tmp13_);
#line 425 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp15_ = _tmp14_;
#line 425 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp16_ = _tmp9_;
#line 425 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:425: sane_control_option (%d, SANE_ACTION_SET_VALUE, %s) " \
"-> (%s, %s)", (gint) _tmp11_, _tmp12_, _tmp15_, _tmp16_);
#line 425 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp15_);
#line 418 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_result_) {
#line 418 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*_result_ = _vala_result;
#line 5568 "scanner.c"
	}
}


static void scanner_set_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gint value, gint* _result_) {
	gint _vala_result = 0;
	SANE_Option_Descriptor* _tmp0_;
	SANE_Value_Type _tmp1_;
	gint _tmp2_;
	SANE_Int v;
	SANE_Option_Descriptor* _tmp3_;
	SANE_Constraint_Type _tmp4_;
	SANE_Handle _tmp49_;
	SANE_Int _tmp50_;
	SANE_Status _tmp51_ = 0;
	SANE_Status status;
	SANE_Int _tmp52_;
	gint _tmp53_;
	gchar* _tmp54_ = NULL;
	gchar* _tmp55_;
	SANE_Int _tmp56_;
	SANE_Int _tmp57_;
#line 428 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 428 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 430 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = option;
#line 430 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = _tmp0_->type;
#line 430 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (_tmp1_ == SANE_TYPE_INT);
#line 432 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = value;
#line 432 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	v = (SANE_Int) _tmp2_;
#line 433 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = option;
#line 433 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = _tmp3_->constraint_type;
#line 433 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp4_ == SANE_CONSTRAINT_RANGE) {
#line 5611 "scanner.c"
		SANE_Option_Descriptor* _tmp5_;
		SANE_Range* _tmp6_;
		SANE_Word _tmp7_;
		SANE_Int _tmp12_;
		SANE_Option_Descriptor* _tmp13_;
		SANE_Range* _tmp14_;
		SANE_Word _tmp15_;
		SANE_Int _tmp19_;
		SANE_Option_Descriptor* _tmp20_;
		SANE_Range* _tmp21_;
		SANE_Word _tmp22_;
#line 435 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp5_ = option;
#line 435 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp6_ = _tmp5_->constraint.range;
#line 435 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp7_ = _tmp6_->quant;
#line 435 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp7_ != ((SANE_Word) 0)) {
#line 5631 "scanner.c"
			SANE_Int _tmp8_;
			SANE_Option_Descriptor* _tmp9_;
			SANE_Range* _tmp10_;
			SANE_Word _tmp11_;
#line 436 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp8_ = v;
#line 436 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp9_ = option;
#line 436 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp10_ = _tmp9_->constraint.range;
#line 436 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp11_ = _tmp10_->quant;
#line 436 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			v = _tmp8_ * _tmp11_;
#line 5646 "scanner.c"
		}
#line 437 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp12_ = v;
#line 437 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp13_ = option;
#line 437 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp14_ = _tmp13_->constraint.range;
#line 437 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp15_ = _tmp14_->min;
#line 437 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp12_ < ((SANE_Int) _tmp15_)) {
#line 5658 "scanner.c"
			SANE_Option_Descriptor* _tmp16_;
			SANE_Range* _tmp17_;
			SANE_Word _tmp18_;
#line 438 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp16_ = option;
#line 438 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp17_ = _tmp16_->constraint.range;
#line 438 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp18_ = _tmp17_->min;
#line 438 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			v = (SANE_Int) _tmp18_;
#line 5670 "scanner.c"
		}
#line 439 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp19_ = v;
#line 439 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp20_ = option;
#line 439 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp21_ = _tmp20_->constraint.range;
#line 439 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp22_ = _tmp21_->max;
#line 439 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp19_ > ((SANE_Int) _tmp22_)) {
#line 5682 "scanner.c"
			SANE_Option_Descriptor* _tmp23_;
			SANE_Range* _tmp24_;
			SANE_Word _tmp25_;
#line 440 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp23_ = option;
#line 440 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp24_ = _tmp23_->constraint.range;
#line 440 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp25_ = _tmp24_->max;
#line 440 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			v = (SANE_Int) _tmp25_;
#line 5694 "scanner.c"
		}
	} else {
		SANE_Option_Descriptor* _tmp26_;
		SANE_Constraint_Type _tmp27_;
#line 442 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp26_ = option;
#line 442 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp27_ = _tmp26_->constraint_type;
#line 442 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp27_ == SANE_CONSTRAINT_WORD_LIST) {
#line 5705 "scanner.c"
			gint _tmp28_;
			gint distance;
			gint nearest;
			gint _tmp48_;
#line 444 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp28_ = G_MAXINT;
#line 444 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			distance = _tmp28_;
#line 444 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			nearest = 0;
#line 5716 "scanner.c"
			{
				gint i;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				i = 0;
#line 5721 "scanner.c"
				{
					gboolean _tmp29_;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp29_ = TRUE;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					while (TRUE) {
#line 5728 "scanner.c"
						gboolean _tmp30_;
						gint _tmp32_;
						SANE_Option_Descriptor* _tmp33_;
						SANE_Word* _tmp34_;
						gint _tmp34__length1;
						SANE_Word _tmp35_;
						SANE_Option_Descriptor* _tmp36_;
						SANE_Word* _tmp37_;
						gint _tmp37__length1;
						gint _tmp38_;
						SANE_Word _tmp39_;
						gint x;
						gint _tmp40_;
						SANE_Int _tmp41_;
						gint d;
						gint _tmp42_;
						gint _tmp43_ = 0;
						gint _tmp44_;
						gint _tmp45_;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp30_ = _tmp29_;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (!_tmp30_) {
#line 5752 "scanner.c"
							gint _tmp31_;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp31_ = i;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							i = _tmp31_ + 1;
#line 5758 "scanner.c"
						}
#line 447 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp29_ = FALSE;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp32_ = i;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp33_ = option;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp34_ = _tmp33_->constraint.word_list;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp34__length1 = -1;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp35_ = _tmp34_[0];
#line 447 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (!(((SANE_Word) _tmp32_) < _tmp35_)) {
#line 447 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							break;
#line 5776 "scanner.c"
						}
#line 449 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp36_ = option;
#line 449 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp37_ = _tmp36_->constraint.word_list;
#line 449 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp37__length1 = -1;
#line 449 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp38_ = i;
#line 449 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp39_ = _tmp37_[_tmp38_ + 1];
#line 449 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						x = (gint) _tmp39_;
#line 450 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp40_ = x;
#line 450 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp41_ = v;
#line 450 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						d = (gint) (_tmp40_ - _tmp41_);
#line 451 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp42_ = d;
#line 451 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp43_ = abs (_tmp42_);
#line 451 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						d = _tmp43_;
#line 452 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp44_ = d;
#line 452 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp45_ = distance;
#line 452 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (_tmp44_ < _tmp45_) {
#line 5808 "scanner.c"
							gint _tmp46_;
							gint _tmp47_;
#line 454 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp46_ = d;
#line 454 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							distance = _tmp46_;
#line 455 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp47_ = x;
#line 455 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							nearest = _tmp47_;
#line 5819 "scanner.c"
						}
					}
				}
			}
#line 458 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp48_ = nearest;
#line 458 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			v = (SANE_Int) _tmp48_;
#line 5828 "scanner.c"
		}
	}
#line 461 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp49_ = handle;
#line 461 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp50_ = option_index;
#line 461 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp51_ = sane_control_option (_tmp49_, _tmp50_, SANE_ACTION_SET_VALUE, &v, NULL);
#line 461 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	status = _tmp51_;
#line 462 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp52_ = option_index;
#line 462 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp53_ = value;
#line 462 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp54_ = sane_status_to_string (status);
#line 462 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp55_ = _tmp54_;
#line 462 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp56_ = v;
#line 462 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:462: sane_control_option (%d, SANE_ACTION_SET_VALUE, %d) " \
"-> (%s, %d)", (gint) _tmp52_, _tmp53_, _tmp55_, (gint) _tmp56_);
#line 462 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp55_);
#line 463 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp57_ = v;
#line 463 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_vala_result = (gint) _tmp57_;
#line 428 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_result_) {
#line 428 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*_result_ = _vala_result;
#line 5861 "scanner.c"
	}
}


static void scanner_set_fixed_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_) {
	gdouble _vala_result = 0.0;
	gdouble _tmp0_;
	gdouble v;
	SANE_Fixed v_fixed = {0};
	SANE_Option_Descriptor* _tmp1_;
	SANE_Value_Type _tmp2_;
	SANE_Option_Descriptor* _tmp3_;
	SANE_Constraint_Type _tmp4_;
	gdouble _tmp43_;
	SANE_Fixed _tmp44_ = {0};
	SANE_Handle _tmp45_;
	SANE_Int _tmp46_;
	SANE_Status _tmp47_ = 0;
	SANE_Status status;
	SANE_Int _tmp48_;
	gdouble _tmp49_;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_;
	gdouble _tmp52_ = 0.0;
	gdouble _tmp53_ = 0.0;
#line 466 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 466 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 468 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = value;
#line 468 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	v = _tmp0_;
#line 471 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = option;
#line 471 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = _tmp1_->type;
#line 471 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (_tmp2_ == SANE_TYPE_FIXED);
#line 473 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = option;
#line 473 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = _tmp3_->constraint_type;
#line 473 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp4_ == SANE_CONSTRAINT_RANGE) {
#line 5907 "scanner.c"
		SANE_Option_Descriptor* _tmp5_;
		SANE_Range* _tmp6_;
		SANE_Word _tmp7_;
		gdouble _tmp8_ = 0.0;
		gdouble min;
		SANE_Option_Descriptor* _tmp9_;
		SANE_Range* _tmp10_;
		SANE_Word _tmp11_;
		gdouble _tmp12_ = 0.0;
		gdouble max;
		gdouble _tmp13_;
		gdouble _tmp14_;
		gdouble _tmp16_;
		gdouble _tmp17_;
#line 475 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp5_ = option;
#line 475 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp6_ = _tmp5_->constraint.range;
#line 475 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp7_ = _tmp6_->min;
#line 475 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp8_ = SANE_UNFIX ((SANE_Fixed) _tmp7_);
#line 475 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		min = _tmp8_;
#line 476 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp9_ = option;
#line 476 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp10_ = _tmp9_->constraint.range;
#line 476 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp11_ = _tmp10_->max;
#line 476 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp12_ = SANE_UNFIX ((SANE_Fixed) _tmp11_);
#line 476 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		max = _tmp12_;
#line 478 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp13_ = v;
#line 478 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp14_ = min;
#line 478 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp13_ < _tmp14_) {
#line 5948 "scanner.c"
			gdouble _tmp15_;
#line 479 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp15_ = min;
#line 479 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			v = _tmp15_;
#line 5954 "scanner.c"
		}
#line 480 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp16_ = v;
#line 480 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp17_ = max;
#line 480 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp16_ > _tmp17_) {
#line 5962 "scanner.c"
			gdouble _tmp18_;
#line 481 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp18_ = max;
#line 481 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			v = _tmp18_;
#line 5968 "scanner.c"
		}
	} else {
		SANE_Option_Descriptor* _tmp19_;
		SANE_Constraint_Type _tmp20_;
#line 483 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp19_ = option;
#line 483 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp20_ = _tmp19_->constraint_type;
#line 483 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp20_ == SANE_CONSTRAINT_WORD_LIST) {
#line 5979 "scanner.c"
			gdouble _tmp21_;
			gdouble distance;
			gdouble nearest;
			gdouble _tmp42_;
#line 485 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp21_ = DBL_MAX;
#line 485 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			distance = _tmp21_;
#line 485 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			nearest = 0.0;
#line 5990 "scanner.c"
			{
				gint i;
#line 488 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				i = 0;
#line 5995 "scanner.c"
				{
					gboolean _tmp22_;
#line 488 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp22_ = TRUE;
#line 488 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					while (TRUE) {
#line 6002 "scanner.c"
						gboolean _tmp23_;
						gint _tmp25_;
						SANE_Option_Descriptor* _tmp26_;
						SANE_Word* _tmp27_;
						gint _tmp27__length1;
						SANE_Word _tmp28_;
						SANE_Option_Descriptor* _tmp29_;
						SANE_Word* _tmp30_;
						gint _tmp30__length1;
						gint _tmp31_;
						SANE_Word _tmp32_;
						gdouble _tmp33_ = 0.0;
						gdouble x;
						gdouble _tmp34_;
						gdouble _tmp35_;
						gdouble _tmp36_ = 0.0;
						gdouble _tmp37_;
#line 488 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp23_ = _tmp22_;
#line 488 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (!_tmp23_) {
#line 6024 "scanner.c"
							gint _tmp24_;
#line 488 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp24_ = i;
#line 488 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							i = _tmp24_ + 1;
#line 6030 "scanner.c"
						}
#line 488 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp22_ = FALSE;
#line 488 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp25_ = i;
#line 488 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp26_ = option;
#line 488 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp27_ = _tmp26_->constraint.word_list;
#line 488 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp27__length1 = -1;
#line 488 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp28_ = _tmp27_[0];
#line 488 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (!(((SANE_Word) _tmp25_) < _tmp28_)) {
#line 488 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							break;
#line 6048 "scanner.c"
						}
#line 490 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp29_ = option;
#line 490 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp30_ = _tmp29_->constraint.word_list;
#line 490 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp30__length1 = -1;
#line 490 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp31_ = i;
#line 490 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp32_ = _tmp30_[_tmp31_ + 1];
#line 490 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp33_ = SANE_UNFIX ((SANE_Fixed) _tmp32_);
#line 490 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						x = _tmp33_;
#line 491 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp34_ = x;
#line 491 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp35_ = v;
#line 491 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp36_ = fabs (_tmp34_ - _tmp35_);
#line 491 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp37_ = distance;
#line 491 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (_tmp36_ < _tmp37_) {
#line 6074 "scanner.c"
							gdouble _tmp38_;
							gdouble _tmp39_;
							gdouble _tmp40_ = 0.0;
							gdouble _tmp41_;
#line 493 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp38_ = x;
#line 493 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp39_ = v;
#line 493 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp40_ = fabs (_tmp38_ - _tmp39_);
#line 493 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							distance = _tmp40_;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp41_ = x;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							nearest = _tmp41_;
#line 6091 "scanner.c"
						}
					}
				}
			}
#line 497 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp42_ = nearest;
#line 497 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			v = _tmp42_;
#line 6100 "scanner.c"
		}
	}
#line 500 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp43_ = v;
#line 500 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp44_ = SANE_FIX (_tmp43_);
#line 500 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	v_fixed = _tmp44_;
#line 501 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp45_ = handle;
#line 501 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp46_ = option_index;
#line 501 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp47_ = sane_control_option (_tmp45_, _tmp46_, SANE_ACTION_SET_VALUE, &v_fixed, NULL);
#line 501 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	status = _tmp47_;
#line 502 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp48_ = option_index;
#line 502 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp49_ = value;
#line 502 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp50_ = sane_status_to_string (status);
#line 502 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp51_ = _tmp50_;
#line 502 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp52_ = SANE_UNFIX (v_fixed);
#line 502 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:502: sane_control_option (%d, SANE_ACTION_SET_VALUE, %f) " \
"-> (%s, %f)", (gint) _tmp48_, _tmp49_, _tmp51_, _tmp52_);
#line 502 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp51_);
#line 504 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp53_ = SANE_UNFIX (v_fixed);
#line 504 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_vala_result = _tmp53_;
#line 466 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_result_) {
#line 466 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*_result_ = _vala_result;
#line 6139 "scanner.c"
	}
}


static void scanner_set_fixed_or_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_) {
	gdouble _vala_result = 0.0;
	SANE_Option_Descriptor* _tmp0_;
	SANE_Value_Type _tmp1_;
#line 507 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 507 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 509 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = option;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = _tmp0_->type;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp1_ == SANE_TYPE_FIXED) {
#line 6158 "scanner.c"
		SANE_Handle _tmp2_;
		SANE_Option_Descriptor* _tmp3_;
		SANE_Int _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_ = 0.0;
#line 510 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp2_ = handle;
#line 510 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp3_ = option;
#line 510 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp4_ = option_index;
#line 510 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp5_ = value;
#line 510 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scanner_set_fixed_option (self, _tmp2_, _tmp3_, _tmp4_, _tmp5_, &_tmp6_);
#line 510 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_vala_result = _tmp6_;
#line 6176 "scanner.c"
	} else {
		SANE_Option_Descriptor* _tmp7_;
		SANE_Value_Type _tmp8_;
#line 511 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp7_ = option;
#line 511 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp8_ = _tmp7_->type;
#line 511 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp8_ == SANE_TYPE_INT) {
#line 6186 "scanner.c"
			gint r = 0;
			SANE_Handle _tmp9_;
			SANE_Option_Descriptor* _tmp10_;
			SANE_Int _tmp11_;
			gdouble _tmp12_;
			gdouble _tmp13_ = 0.0;
			gint _tmp14_ = 0;
			gint _tmp15_;
#line 514 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp9_ = handle;
#line 514 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp10_ = option;
#line 514 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp11_ = option_index;
#line 514 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp12_ = value;
#line 514 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp13_ = round (_tmp12_);
#line 514 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			scanner_set_int_option (self, _tmp9_, _tmp10_, _tmp11_, (gint) _tmp13_, &_tmp14_);
#line 514 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			r = _tmp14_;
#line 515 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp15_ = r;
#line 515 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_vala_result = (gdouble) _tmp15_;
#line 6213 "scanner.c"
		} else {
#line 519 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_vala_result = 0.0;
#line 520 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			g_warning ("scanner.vala:520: Unable to set unsupported option type");
#line 6219 "scanner.c"
		}
	}
#line 507 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_result_) {
#line 507 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*_result_ = _vala_result;
#line 6226 "scanner.c"
	}
}


static void scanner_set_option_to_max (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index) {
	SANE_Option_Descriptor* _tmp0_;
	SANE_Constraint_Type _tmp1_;
	SANE_Handle _tmp2_;
	SANE_Int _tmp3_;
	SANE_Option_Descriptor* _tmp4_;
	SANE_Range* _tmp5_;
	SANE_Status _tmp6_ = 0;
	SANE_Status status;
	SANE_Int _tmp7_;
	SANE_Status _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
#line 524 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 524 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 526 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = option;
#line 526 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = _tmp0_->constraint_type;
#line 526 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp1_ != SANE_CONSTRAINT_RANGE) {
#line 527 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return;
#line 6256 "scanner.c"
	}
#line 529 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = handle;
#line 529 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = option_index;
#line 529 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = option;
#line 529 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = _tmp4_->constraint.range;
#line 529 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp6_ = sane_control_option (_tmp2_, _tmp3_, SANE_ACTION_SET_VALUE, &_tmp5_->max, NULL);
#line 529 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	status = _tmp6_;
#line 530 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp7_ = option_index;
#line 530 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp8_ = status;
#line 530 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp9_ = sane_status_to_string (_tmp8_);
#line 530 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp10_ = _tmp9_;
#line 530 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:530: sane_control_option (%d, SANE_ACTION_SET_VALUE, opti" \
"on.range.max) -> (%s)", (gint) _tmp7_, _tmp10_);
#line 530 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp10_);
#line 6282 "scanner.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
#line 965 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 966 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 966 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 966 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 966 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 6300 "scanner.c"
}


static gboolean scanner_set_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, const gchar* value, gchar** _result_) {
	gchar* _vala_result = NULL;
	gboolean result = FALSE;
	gchar* _tmp0_;
	SANE_Option_Descriptor* _tmp1_;
	SANE_Value_Type _tmp2_;
	SANE_Option_Descriptor* _tmp3_;
	SANE_Int _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* s;
	gint s_length1;
	gint _s_size_;
	gint i;
	gchar* _tmp23_;
	gint _tmp23__length1;
	gint _tmp24_;
	gchar _tmp25_;
	SANE_Handle _tmp26_;
	SANE_Int _tmp27_;
	gchar* _tmp28_;
	gint _tmp28__length1;
	SANE_Status _tmp29_ = 0;
	SANE_Status status;
	gchar* _tmp30_;
	gint _tmp30__length1;
	gchar* _tmp31_;
	SANE_Int _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_;
	const gchar* _tmp36_;
#line 533 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 533 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (option != NULL, FALSE);
#line 533 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (value != NULL, FALSE);
#line 535 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = g_strdup ("");
#line 535 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_vala_result);
#line 535 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_vala_result = _tmp0_;
#line 537 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = option;
#line 537 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = _tmp1_->type;
#line 537 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (_tmp2_ == SANE_TYPE_STRING, FALSE);
#line 539 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = option;
#line 539 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = _tmp3_->size;
#line 539 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = g_new0 (gchar, _tmp4_);
#line 539 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	s = _tmp5_;
#line 539 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	s_length1 = _tmp4_;
#line 539 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_s_size_ = s_length1;
#line 540 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	i = 0;
#line 6367 "scanner.c"
	{
		gboolean _tmp6_;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp6_ = TRUE;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		while (TRUE) {
#line 6374 "scanner.c"
			gboolean _tmp7_;
			gboolean _tmp9_ = FALSE;
			gint _tmp10_;
			SANE_Option_Descriptor* _tmp11_;
			SANE_Int _tmp12_;
			gboolean _tmp16_;
			gchar* _tmp17_;
			gint _tmp17__length1;
			gint _tmp18_;
			const gchar* _tmp19_;
			gint _tmp20_;
			gchar _tmp21_ = '\0';
			gchar _tmp22_;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp7_ = _tmp6_;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (!_tmp7_) {
#line 6392 "scanner.c"
				gint _tmp8_;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp8_ = i;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				i = _tmp8_ + 1;
#line 6398 "scanner.c"
			}
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp6_ = FALSE;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp10_ = i;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp11_ = option;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp12_ = _tmp11_->size;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (((SANE_Int) _tmp10_) < (_tmp12_ - 1)) {
#line 6410 "scanner.c"
				const gchar* _tmp13_;
				gint _tmp14_;
				gchar _tmp15_ = '\0';
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp13_ = value;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp14_ = i;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp9_ = _tmp15_ != '\0';
#line 6422 "scanner.c"
			} else {
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp9_ = FALSE;
#line 6426 "scanner.c"
			}
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp16_ = _tmp9_;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (!_tmp16_) {
#line 541 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				break;
#line 6434 "scanner.c"
			}
#line 542 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp17_ = s;
#line 542 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp17__length1 = s_length1;
#line 542 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp18_ = i;
#line 542 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp19_ = value;
#line 542 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp20_ = i;
#line 542 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp21_ = string_get (_tmp19_, (glong) _tmp20_);
#line 542 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp17_[_tmp18_] = _tmp21_;
#line 542 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp22_ = _tmp17_[_tmp18_];
#line 6452 "scanner.c"
		}
	}
#line 543 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp23_ = s;
#line 543 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp23__length1 = s_length1;
#line 543 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp24_ = i;
#line 543 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp23_[_tmp24_] = '\0';
#line 543 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp25_ = _tmp23_[_tmp24_];
#line 544 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp26_ = handle;
#line 544 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp27_ = option_index;
#line 544 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp28_ = s;
#line 544 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp28__length1 = s_length1;
#line 544 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp29_ = sane_control_option (_tmp26_, _tmp27_, SANE_ACTION_SET_VALUE, _tmp28_, NULL);
#line 544 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	status = _tmp29_;
#line 545 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp30_ = s;
#line 545 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp30__length1 = s_length1;
#line 545 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp31_ = g_strdup ((const gchar*) _tmp30_);
#line 545 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_vala_result);
#line 545 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_vala_result = _tmp31_;
#line 546 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp32_ = option_index;
#line 546 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp33_ = value;
#line 546 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp34_ = sane_status_to_string (status);
#line 546 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp35_ = _tmp34_;
#line 546 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp36_ = _vala_result;
#line 546 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:546: sane_control_option (%d, SANE_ACTION_SET_VALUE, \"%s" \
"\") -> (%s, \"%s\")", (gint) _tmp32_, _tmp33_, _tmp35_, _tmp36_);
#line 546 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp35_);
#line 548 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	result = status == SANE_STATUS_GOOD;
#line 548 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	s = (g_free (s), NULL);
#line 548 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_result_) {
#line 548 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*_result_ = _vala_result;
#line 6509 "scanner.c"
	} else {
#line 548 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_g_free0 (_vala_result);
#line 6513 "scanner.c"
	}
#line 548 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return result;
#line 6517 "scanner.c"
}


static gboolean scanner_set_constrained_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gchar** values, int values_length1, gchar** _result_) {
	gchar* _vala_result = NULL;
	gboolean result = FALSE;
	SANE_Option_Descriptor* _tmp0_;
	SANE_Value_Type _tmp1_;
	SANE_Option_Descriptor* _tmp2_;
	SANE_Constraint_Type _tmp3_;
	gchar* _tmp36_;
#line 551 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 551 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (option != NULL, FALSE);
#line 553 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = option;
#line 553 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = _tmp0_->type;
#line 553 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (_tmp1_ == SANE_TYPE_STRING, FALSE);
#line 554 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = option;
#line 554 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = _tmp2_->constraint_type;
#line 554 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (_tmp3_ == SANE_CONSTRAINT_STRING_LIST, FALSE);
#line 6545 "scanner.c"
	{
		gint i;
#line 556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		i = 0;
#line 6550 "scanner.c"
		{
			gboolean _tmp4_;
#line 556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp4_ = TRUE;
#line 556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			while (TRUE) {
#line 6557 "scanner.c"
				gboolean _tmp5_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				const gchar* _tmp9_;
				gint j;
				SANE_Option_Descriptor* _tmp24_;
				gchar** _tmp25_;
				gint _tmp25__length1;
				gint _tmp26_;
				const gchar* _tmp27_;
#line 556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp5_ = _tmp4_;
#line 556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				if (!_tmp5_) {
#line 6573 "scanner.c"
					gint _tmp6_;
#line 556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp6_ = i;
#line 556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					i = _tmp6_ + 1;
#line 6579 "scanner.c"
				}
#line 556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp4_ = FALSE;
#line 556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp7_ = values;
#line 556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp7__length1 = values_length1;
#line 556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp8_ = i;
#line 556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp9_ = _tmp7_[_tmp8_];
#line 556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				if (!(_tmp9_ != NULL)) {
#line 556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					break;
#line 6595 "scanner.c"
				}
#line 558 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				j = 0;
#line 6599 "scanner.c"
				{
					gboolean _tmp10_;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp10_ = TRUE;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					while (TRUE) {
#line 6606 "scanner.c"
						gboolean _tmp11_;
						SANE_Option_Descriptor* _tmp13_;
						gchar** _tmp14_;
						gint _tmp14__length1;
						gint _tmp15_;
						const gchar* _tmp16_;
						gchar** _tmp17_;
						gint _tmp17__length1;
						gint _tmp18_;
						const gchar* _tmp19_;
						SANE_Option_Descriptor* _tmp20_;
						gchar** _tmp21_;
						gint _tmp21__length1;
						gint _tmp22_;
						const gchar* _tmp23_;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp11_ = _tmp10_;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (!_tmp11_) {
#line 6626 "scanner.c"
							gint _tmp12_;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp12_ = j;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							j = _tmp12_ + 1;
#line 6632 "scanner.c"
						}
#line 559 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp10_ = FALSE;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp13_ = option;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp14_ = _tmp13_->constraint.string_list;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp14__length1 = -1;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp15_ = j;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp16_ = _tmp14_[_tmp15_];
#line 559 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (!(_tmp16_ != NULL)) {
#line 559 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							break;
#line 6650 "scanner.c"
						}
#line 561 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp17_ = values;
#line 561 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp17__length1 = values_length1;
#line 561 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp18_ = i;
#line 561 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp19_ = _tmp17_[_tmp18_];
#line 561 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp20_ = option;
#line 561 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp21_ = _tmp20_->constraint.string_list;
#line 561 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp21__length1 = -1;
#line 561 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp22_ = j;
#line 561 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp23_ = _tmp21_[_tmp22_];
#line 561 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (g_strcmp0 (_tmp19_, _tmp23_) == 0) {
#line 562 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							break;
#line 6674 "scanner.c"
						}
					}
				}
#line 565 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp24_ = option;
#line 565 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp25_ = _tmp24_->constraint.string_list;
#line 565 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp25__length1 = -1;
#line 565 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp26_ = j;
#line 565 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp27_ = _tmp25_[_tmp26_];
#line 565 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				if (_tmp27_ != NULL) {
#line 6690 "scanner.c"
					SANE_Handle _tmp28_;
					SANE_Option_Descriptor* _tmp29_;
					SANE_Int _tmp30_;
					gchar** _tmp31_;
					gint _tmp31__length1;
					gint _tmp32_;
					const gchar* _tmp33_;
					gchar* _tmp34_ = NULL;
					gboolean _tmp35_ = FALSE;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp28_ = handle;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp29_ = option;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp30_ = option_index;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp31_ = values;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp31__length1 = values_length1;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp32_ = i;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp33_ = _tmp31_[_tmp32_];
#line 566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp35_ = scanner_set_string_option (self, _tmp28_, _tmp29_, _tmp30_, _tmp33_, &_tmp34_);
#line 566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_g_free0 (_vala_result);
#line 566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_vala_result = _tmp34_;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					result = _tmp35_;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					if (_result_) {
#line 566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						*_result_ = _vala_result;
#line 6726 "scanner.c"
					} else {
#line 566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_g_free0 (_vala_result);
#line 6730 "scanner.c"
					}
#line 566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					return result;
#line 6734 "scanner.c"
				}
			}
		}
	}
#line 569 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp36_ = g_strdup ("");
#line 569 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_vala_result);
#line 569 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_vala_result = _tmp36_;
#line 570 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	result = FALSE;
#line 570 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_result_) {
#line 570 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*_result_ = _vala_result;
#line 6751 "scanner.c"
	} else {
#line 570 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_g_free0 (_vala_result);
#line 6755 "scanner.c"
	}
#line 570 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return result;
#line 6759 "scanner.c"
}


static void scanner_log_option (Scanner* self, SANE_Int index, SANE_Option_Descriptor* option) {
	SANE_Int _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* s;
	SANE_Option_Descriptor* _tmp2_;
	const gchar* _tmp3_;
	SANE_Option_Descriptor* _tmp10_;
	const gchar* _tmp11_;
	SANE_Option_Descriptor* _tmp18_;
	SANE_Value_Type _tmp19_;
	const gchar* _tmp38_;
	SANE_Option_Descriptor* _tmp39_;
	SANE_Int _tmp40_;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_;
	gchar* _tmp43_;
	SANE_Option_Descriptor* _tmp44_;
	SANE_Unit _tmp45_;
	SANE_Option_Descriptor* _tmp64_;
	SANE_Constraint_Type _tmp65_;
	SANE_Option_Descriptor* _tmp151_;
	SANE_Int _tmp152_;
	SANE_Int cap;
	SANE_Int _tmp153_;
	const gchar* _tmp214_;
	SANE_Option_Descriptor* _tmp215_;
	const gchar* _tmp216_;
#line 573 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 573 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 575 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = index;
#line 575 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = g_strdup_printf ("Option %d:", (gint) _tmp0_);
#line 575 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	s = _tmp1_;
#line 577 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = option;
#line 577 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = _tmp2_->name;
#line 577 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (g_strcmp0 (_tmp3_, "") != 0) {
#line 6806 "scanner.c"
		const gchar* _tmp4_;
		SANE_Option_Descriptor* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
#line 578 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp4_ = s;
#line 578 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp5_ = option;
#line 578 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp6_ = _tmp5_->name;
#line 578 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp7_ = g_strdup_printf (" name='%s'", _tmp6_);
#line 578 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp8_ = _tmp7_;
#line 578 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp9_ = g_strconcat (_tmp4_, _tmp8_, NULL);
#line 578 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_g_free0 (s);
#line 578 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		s = _tmp9_;
#line 578 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_g_free0 (_tmp8_);
#line 6831 "scanner.c"
	}
#line 580 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp10_ = option;
#line 580 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp11_ = _tmp10_->title;
#line 580 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (g_strcmp0 (_tmp11_, "") != 0) {
#line 6839 "scanner.c"
		const gchar* _tmp12_;
		SANE_Option_Descriptor* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar* _tmp17_;
#line 581 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp12_ = s;
#line 581 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp13_ = option;
#line 581 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp14_ = _tmp13_->title;
#line 581 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp15_ = g_strdup_printf (" title='%s'", _tmp14_);
#line 581 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp16_ = _tmp15_;
#line 581 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp17_ = g_strconcat (_tmp12_, _tmp16_, NULL);
#line 581 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_g_free0 (s);
#line 581 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		s = _tmp17_;
#line 581 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_g_free0 (_tmp16_);
#line 6864 "scanner.c"
	}
#line 583 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp18_ = option;
#line 583 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp19_ = _tmp18_->type;
#line 583 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	switch (_tmp19_) {
#line 583 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SANE_TYPE_BOOL:
#line 6874 "scanner.c"
		{
			const gchar* _tmp20_;
			gchar* _tmp21_;
#line 586 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp20_ = s;
#line 586 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp21_ = g_strconcat (_tmp20_, " type=bool", NULL);
#line 586 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 586 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp21_;
#line 587 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 6888 "scanner.c"
		}
#line 583 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SANE_TYPE_INT:
#line 6892 "scanner.c"
		{
			const gchar* _tmp22_;
			gchar* _tmp23_;
#line 589 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp22_ = s;
#line 589 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp23_ = g_strconcat (_tmp22_, " type=int", NULL);
#line 589 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 589 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp23_;
#line 590 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 6906 "scanner.c"
		}
#line 583 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SANE_TYPE_FIXED:
#line 6910 "scanner.c"
		{
			const gchar* _tmp24_;
			gchar* _tmp25_;
#line 592 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp24_ = s;
#line 592 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp25_ = g_strconcat (_tmp24_, " type=fixed", NULL);
#line 592 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 592 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp25_;
#line 593 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 6924 "scanner.c"
		}
#line 583 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SANE_TYPE_STRING:
#line 6928 "scanner.c"
		{
			const gchar* _tmp26_;
			gchar* _tmp27_;
#line 595 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp26_ = s;
#line 595 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp27_ = g_strconcat (_tmp26_, " type=string", NULL);
#line 595 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 595 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp27_;
#line 596 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 6942 "scanner.c"
		}
#line 583 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SANE_TYPE_BUTTON:
#line 6946 "scanner.c"
		{
			const gchar* _tmp28_;
			gchar* _tmp29_;
#line 598 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp28_ = s;
#line 598 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp29_ = g_strconcat (_tmp28_, " type=button", NULL);
#line 598 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 598 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp29_;
#line 599 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 6960 "scanner.c"
		}
#line 583 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SANE_TYPE_GROUP:
#line 6964 "scanner.c"
		{
			const gchar* _tmp30_;
			gchar* _tmp31_;
#line 601 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp30_ = s;
#line 601 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp31_ = g_strconcat (_tmp30_, " type=group", NULL);
#line 601 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 601 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp31_;
#line 602 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 6978 "scanner.c"
		}
		default:
		{
			const gchar* _tmp32_;
			SANE_Option_Descriptor* _tmp33_;
			SANE_Value_Type _tmp34_;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			gchar* _tmp37_;
#line 604 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp32_ = s;
#line 604 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp33_ = option;
#line 604 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp34_ = _tmp33_->type;
#line 604 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp35_ = g_strdup_printf (" type=%d", (gint) _tmp34_);
#line 604 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp36_ = _tmp35_;
#line 604 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp37_ = g_strconcat (_tmp32_, _tmp36_, NULL);
#line 604 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 604 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp37_;
#line 604 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (_tmp36_);
#line 605 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 7008 "scanner.c"
		}
	}
#line 608 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp38_ = s;
#line 608 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp39_ = option;
#line 608 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp40_ = _tmp39_->size;
#line 608 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp41_ = g_strdup_printf (" size=%d", (gint) _tmp40_);
#line 608 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp42_ = _tmp41_;
#line 608 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp43_ = g_strconcat (_tmp38_, _tmp42_, NULL);
#line 608 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (s);
#line 608 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	s = _tmp43_;
#line 608 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp42_);
#line 610 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp44_ = option;
#line 610 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp45_ = _tmp44_->unit;
#line 610 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	switch (_tmp45_) {
#line 610 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SANE_UNIT_NONE:
#line 7037 "scanner.c"
		{
#line 613 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 7041 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SANE_UNIT_PIXEL:
#line 7045 "scanner.c"
		{
			const gchar* _tmp46_;
			gchar* _tmp47_;
#line 615 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp46_ = s;
#line 615 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp47_ = g_strconcat (_tmp46_, " unit=pixels", NULL);
#line 615 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 615 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp47_;
#line 616 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 7059 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SANE_UNIT_BIT:
#line 7063 "scanner.c"
		{
			const gchar* _tmp48_;
			gchar* _tmp49_;
#line 618 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp48_ = s;
#line 618 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp49_ = g_strconcat (_tmp48_, " unit=bits", NULL);
#line 618 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 618 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp49_;
#line 619 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 7077 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SANE_UNIT_MM:
#line 7081 "scanner.c"
		{
			const gchar* _tmp50_;
			gchar* _tmp51_;
#line 621 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp50_ = s;
#line 621 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp51_ = g_strconcat (_tmp50_, " unit=mm", NULL);
#line 621 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 621 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp51_;
#line 622 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 7095 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SANE_UNIT_DPI:
#line 7099 "scanner.c"
		{
			const gchar* _tmp52_;
			gchar* _tmp53_;
#line 624 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp52_ = s;
#line 624 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp53_ = g_strconcat (_tmp52_, " unit=dpi", NULL);
#line 624 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 624 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp53_;
#line 625 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 7113 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SANE_UNIT_PERCENT:
#line 7117 "scanner.c"
		{
			const gchar* _tmp54_;
			gchar* _tmp55_;
#line 627 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp54_ = s;
#line 627 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp55_ = g_strconcat (_tmp54_, " unit=percent", NULL);
#line 627 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 627 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp55_;
#line 628 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 7131 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SANE_UNIT_MICROSECOND:
#line 7135 "scanner.c"
		{
			const gchar* _tmp56_;
			gchar* _tmp57_;
#line 630 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp56_ = s;
#line 630 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp57_ = g_strconcat (_tmp56_, " unit=microseconds", NULL);
#line 630 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 630 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp57_;
#line 631 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 7149 "scanner.c"
		}
		default:
		{
			const gchar* _tmp58_;
			SANE_Option_Descriptor* _tmp59_;
			SANE_Unit _tmp60_;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_;
			gchar* _tmp63_;
#line 633 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp58_ = s;
#line 633 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp59_ = option;
#line 633 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp60_ = _tmp59_->unit;
#line 633 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp61_ = g_strdup_printf (" unit=%d", (gint) _tmp60_);
#line 633 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp62_ = _tmp61_;
#line 633 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp63_ = g_strconcat (_tmp58_, _tmp62_, NULL);
#line 633 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 633 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp63_;
#line 633 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (_tmp62_);
#line 634 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 7179 "scanner.c"
		}
	}
#line 637 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp64_ = option;
#line 637 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp65_ = _tmp64_->constraint_type;
#line 637 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	switch (_tmp65_) {
#line 637 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SANE_CONSTRAINT_RANGE:
#line 7190 "scanner.c"
		{
			SANE_Option_Descriptor* _tmp66_;
			SANE_Value_Type _tmp67_;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp66_ = option;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp67_ = _tmp66_->type;
#line 640 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (_tmp67_ == SANE_TYPE_FIXED) {
#line 7200 "scanner.c"
				const gchar* _tmp68_;
				SANE_Option_Descriptor* _tmp69_;
				SANE_Range* _tmp70_;
				SANE_Word _tmp71_;
				gdouble _tmp72_ = 0.0;
				SANE_Option_Descriptor* _tmp73_;
				SANE_Range* _tmp74_;
				SANE_Word _tmp75_;
				gdouble _tmp76_ = 0.0;
				SANE_Option_Descriptor* _tmp77_;
				SANE_Range* _tmp78_;
				SANE_Word _tmp79_;
				gchar* _tmp80_ = NULL;
				gchar* _tmp81_;
				gchar* _tmp82_;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp68_ = s;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp69_ = option;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp70_ = _tmp69_->constraint.range;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp71_ = _tmp70_->min;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp72_ = SANE_UNFIX ((SANE_Fixed) _tmp71_);
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp73_ = option;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp74_ = _tmp73_->constraint.range;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp75_ = _tmp74_->max;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp76_ = SANE_UNFIX ((SANE_Fixed) _tmp75_);
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp77_ = option;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp78_ = _tmp77_->constraint.range;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp79_ = _tmp78_->quant;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp80_ = g_strdup_printf (" min=%f, max=%f, quant=%d", _tmp72_, _tmp76_, (gint) _tmp79_);
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp81_ = _tmp80_;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp82_ = g_strconcat (_tmp68_, _tmp81_, NULL);
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_g_free0 (s);
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				s = _tmp82_;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_g_free0 (_tmp81_);
#line 7252 "scanner.c"
			} else {
				const gchar* _tmp83_;
				SANE_Option_Descriptor* _tmp84_;
				SANE_Range* _tmp85_;
				SANE_Word _tmp86_;
				SANE_Option_Descriptor* _tmp87_;
				SANE_Range* _tmp88_;
				SANE_Word _tmp89_;
				SANE_Option_Descriptor* _tmp90_;
				SANE_Range* _tmp91_;
				SANE_Word _tmp92_;
				gchar* _tmp93_ = NULL;
				gchar* _tmp94_;
				gchar* _tmp95_;
#line 643 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp83_ = s;
#line 643 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp84_ = option;
#line 643 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp85_ = _tmp84_->constraint.range;
#line 643 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp86_ = _tmp85_->min;
#line 643 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp87_ = option;
#line 643 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp88_ = _tmp87_->constraint.range;
#line 643 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp89_ = _tmp88_->max;
#line 643 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp90_ = option;
#line 643 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp91_ = _tmp90_->constraint.range;
#line 643 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp92_ = _tmp91_->quant;
#line 643 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp93_ = g_strdup_printf (" min=%d, max=%d, quant=%d", (gint) _tmp86_, (gint) _tmp89_, (gint) _tmp92_);
#line 643 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp94_ = _tmp93_;
#line 643 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp95_ = g_strconcat (_tmp83_, _tmp94_, NULL);
#line 643 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_g_free0 (s);
#line 643 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				s = _tmp95_;
#line 643 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_g_free0 (_tmp94_);
#line 7299 "scanner.c"
			}
#line 644 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 7303 "scanner.c"
		}
#line 637 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SANE_CONSTRAINT_WORD_LIST:
#line 7307 "scanner.c"
		{
			const gchar* _tmp96_;
			gchar* _tmp97_;
			const gchar* _tmp127_;
			gchar* _tmp128_;
#line 646 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp96_ = s;
#line 646 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp97_ = g_strconcat (_tmp96_, " values=[", NULL);
#line 646 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 646 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp97_;
#line 7321 "scanner.c"
			{
				gint i;
#line 647 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				i = 0;
#line 7326 "scanner.c"
				{
					gboolean _tmp98_;
#line 647 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp98_ = TRUE;
#line 647 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					while (TRUE) {
#line 7333 "scanner.c"
						gboolean _tmp99_;
						gint _tmp101_;
						SANE_Option_Descriptor* _tmp102_;
						SANE_Word* _tmp103_;
						gint _tmp103__length1;
						SANE_Word _tmp104_;
						gint _tmp105_;
						SANE_Option_Descriptor* _tmp108_;
						SANE_Value_Type _tmp109_;
#line 647 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp99_ = _tmp98_;
#line 647 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (!_tmp99_) {
#line 7347 "scanner.c"
							gint _tmp100_;
#line 647 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp100_ = i;
#line 647 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							i = _tmp100_ + 1;
#line 7353 "scanner.c"
						}
#line 647 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp98_ = FALSE;
#line 647 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp101_ = i;
#line 647 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp102_ = option;
#line 647 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp103_ = _tmp102_->constraint.word_list;
#line 647 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp103__length1 = -1;
#line 647 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp104_ = _tmp103_[0];
#line 647 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (!(((SANE_Word) _tmp101_) < _tmp104_)) {
#line 647 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							break;
#line 7371 "scanner.c"
						}
#line 649 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp105_ = i;
#line 649 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (_tmp105_ != 0) {
#line 7377 "scanner.c"
							const gchar* _tmp106_;
							gchar* _tmp107_;
#line 650 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp106_ = s;
#line 650 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp107_ = g_strconcat (_tmp106_, ", ", NULL);
#line 650 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_g_free0 (s);
#line 650 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							s = _tmp107_;
#line 7388 "scanner.c"
						}
#line 651 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp108_ = option;
#line 651 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp109_ = _tmp108_->type;
#line 651 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (_tmp109_ == SANE_TYPE_INT) {
#line 7396 "scanner.c"
							const gchar* _tmp110_;
							SANE_Option_Descriptor* _tmp111_;
							SANE_Word* _tmp112_;
							gint _tmp112__length1;
							gint _tmp113_;
							SANE_Word _tmp114_;
							gchar* _tmp115_ = NULL;
							gchar* _tmp116_;
							gchar* _tmp117_;
#line 652 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp110_ = s;
#line 652 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp111_ = option;
#line 652 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp112_ = _tmp111_->constraint.word_list;
#line 652 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp112__length1 = -1;
#line 652 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp113_ = i;
#line 652 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp114_ = _tmp112_[_tmp113_ + 1];
#line 652 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp115_ = g_strdup_printf ("%d", (gint) _tmp114_);
#line 652 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp116_ = _tmp115_;
#line 652 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp117_ = g_strconcat (_tmp110_, _tmp116_, NULL);
#line 652 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_g_free0 (s);
#line 652 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							s = _tmp117_;
#line 652 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_g_free0 (_tmp116_);
#line 7430 "scanner.c"
						} else {
							const gchar* _tmp118_;
							SANE_Option_Descriptor* _tmp119_;
							SANE_Word* _tmp120_;
							gint _tmp120__length1;
							gint _tmp121_;
							SANE_Word _tmp122_;
							gdouble _tmp123_ = 0.0;
							gchar* _tmp124_ = NULL;
							gchar* _tmp125_;
							gchar* _tmp126_;
#line 654 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp118_ = s;
#line 654 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp119_ = option;
#line 654 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp120_ = _tmp119_->constraint.word_list;
#line 654 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp120__length1 = -1;
#line 654 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp121_ = i;
#line 654 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp122_ = _tmp120_[_tmp121_ + 1];
#line 654 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp123_ = SANE_UNFIX ((SANE_Fixed) _tmp122_);
#line 654 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp124_ = g_strdup_printf ("%f", _tmp123_);
#line 654 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp125_ = _tmp124_;
#line 654 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp126_ = g_strconcat (_tmp118_, _tmp125_, NULL);
#line 654 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_g_free0 (s);
#line 654 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							s = _tmp126_;
#line 654 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_g_free0 (_tmp125_);
#line 7468 "scanner.c"
						}
					}
				}
			}
#line 656 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp127_ = s;
#line 656 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp128_ = g_strconcat (_tmp127_, "]", NULL);
#line 656 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 656 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp128_;
#line 657 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 7483 "scanner.c"
		}
#line 637 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SANE_CONSTRAINT_STRING_LIST:
#line 7487 "scanner.c"
		{
			const gchar* _tmp129_;
			gchar* _tmp130_;
			const gchar* _tmp149_;
			gchar* _tmp150_;
#line 659 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp129_ = s;
#line 659 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp130_ = g_strconcat (_tmp129_, " values=[", NULL);
#line 659 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 659 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp130_;
#line 7501 "scanner.c"
			{
				gint i;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				i = 0;
#line 7506 "scanner.c"
				{
					gboolean _tmp131_;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp131_ = TRUE;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					while (TRUE) {
#line 7513 "scanner.c"
						gboolean _tmp132_;
						SANE_Option_Descriptor* _tmp134_;
						gchar** _tmp135_;
						gint _tmp135__length1;
						gint _tmp136_;
						const gchar* _tmp137_;
						gint _tmp138_;
						const gchar* _tmp141_;
						SANE_Option_Descriptor* _tmp142_;
						gchar** _tmp143_;
						gint _tmp143__length1;
						gint _tmp144_;
						const gchar* _tmp145_;
						gchar* _tmp146_ = NULL;
						gchar* _tmp147_;
						gchar* _tmp148_;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp132_ = _tmp131_;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (!_tmp132_) {
#line 7534 "scanner.c"
							gint _tmp133_;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp133_ = i;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							i = _tmp133_ + 1;
#line 7540 "scanner.c"
						}
#line 660 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp131_ = FALSE;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp134_ = option;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp135_ = _tmp134_->constraint.string_list;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp135__length1 = -1;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp136_ = i;
#line 660 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp137_ = _tmp135_[_tmp136_];
#line 660 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (!(_tmp137_ != NULL)) {
#line 660 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							break;
#line 7558 "scanner.c"
						}
#line 662 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp138_ = i;
#line 662 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (_tmp138_ != 0) {
#line 7564 "scanner.c"
							const gchar* _tmp139_;
							gchar* _tmp140_;
#line 663 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp139_ = s;
#line 663 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp140_ = g_strconcat (_tmp139_, ", ", NULL);
#line 663 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_g_free0 (s);
#line 663 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							s = _tmp140_;
#line 7575 "scanner.c"
						}
#line 664 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp141_ = s;
#line 664 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp142_ = option;
#line 664 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp143_ = _tmp142_->constraint.string_list;
#line 664 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp143__length1 = -1;
#line 664 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp144_ = i;
#line 664 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp145_ = _tmp143_[_tmp144_];
#line 664 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp146_ = g_strdup_printf ("\"%s\"", _tmp145_);
#line 664 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp147_ = _tmp146_;
#line 664 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp148_ = g_strconcat (_tmp141_, _tmp147_, NULL);
#line 664 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_g_free0 (s);
#line 664 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						s = _tmp148_;
#line 664 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_g_free0 (_tmp147_);
#line 7601 "scanner.c"
					}
				}
			}
#line 666 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp149_ = s;
#line 666 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp150_ = g_strconcat (_tmp149_, "]", NULL);
#line 666 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 666 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp150_;
#line 667 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 7615 "scanner.c"
		}
		default:
		{
#line 669 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 7621 "scanner.c"
		}
	}
#line 672 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp151_ = option;
#line 672 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp152_ = _tmp151_->cap;
#line 672 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	cap = _tmp152_;
#line 673 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp153_ = cap;
#line 673 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp153_ != ((SANE_Int) 0)) {
#line 7634 "scanner.c"
		const gchar* _tmp154_;
		gchar* _tmp155_;
		SANE_Int _tmp156_;
		SANE_Int _tmp163_;
		SANE_Int _tmp170_;
		SANE_Int _tmp177_;
		SANE_Int _tmp184_;
		SANE_Int _tmp191_;
		SANE_Int _tmp198_;
		SANE_Int _tmp205_;
#line 675 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp154_ = s;
#line 675 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp155_ = g_strconcat (_tmp154_, " cap=", NULL);
#line 675 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_g_free0 (s);
#line 675 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		s = _tmp155_;
#line 676 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp156_ = cap;
#line 676 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if ((_tmp156_ & SANE_CAP_SOFT_SELECT) != ((SANE_Int) 0)) {
#line 7657 "scanner.c"
			const gchar* _tmp157_;
			const gchar* _tmp160_;
			gchar* _tmp161_;
			SANE_Int _tmp162_;
#line 678 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp157_ = s;
#line 678 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (g_strcmp0 (_tmp157_, "") != 0) {
#line 7666 "scanner.c"
				const gchar* _tmp158_;
				gchar* _tmp159_;
#line 679 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp158_ = s;
#line 679 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp159_ = g_strconcat (_tmp158_, ",", NULL);
#line 679 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_g_free0 (s);
#line 679 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				s = _tmp159_;
#line 7677 "scanner.c"
			}
#line 680 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp160_ = s;
#line 680 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp161_ = g_strconcat (_tmp160_, "soft-select", NULL);
#line 680 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 680 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp161_;
#line 681 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp162_ = cap;
#line 681 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			cap = _tmp162_ & (~SANE_CAP_SOFT_SELECT);
#line 7691 "scanner.c"
		}
#line 683 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp163_ = cap;
#line 683 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if ((_tmp163_ & SANE_CAP_HARD_SELECT) != ((SANE_Int) 0)) {
#line 7697 "scanner.c"
			const gchar* _tmp164_;
			const gchar* _tmp167_;
			gchar* _tmp168_;
			SANE_Int _tmp169_;
#line 685 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp164_ = s;
#line 685 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (g_strcmp0 (_tmp164_, "") != 0) {
#line 7706 "scanner.c"
				const gchar* _tmp165_;
				gchar* _tmp166_;
#line 686 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp165_ = s;
#line 686 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp166_ = g_strconcat (_tmp165_, ",", NULL);
#line 686 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_g_free0 (s);
#line 686 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				s = _tmp166_;
#line 7717 "scanner.c"
			}
#line 687 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp167_ = s;
#line 687 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp168_ = g_strconcat (_tmp167_, "hard-select", NULL);
#line 687 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 687 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp168_;
#line 688 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp169_ = cap;
#line 688 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			cap = _tmp169_ & (~SANE_CAP_HARD_SELECT);
#line 7731 "scanner.c"
		}
#line 690 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp170_ = cap;
#line 690 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if ((_tmp170_ & SANE_CAP_SOFT_DETECT) != ((SANE_Int) 0)) {
#line 7737 "scanner.c"
			const gchar* _tmp171_;
			const gchar* _tmp174_;
			gchar* _tmp175_;
			SANE_Int _tmp176_;
#line 692 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp171_ = s;
#line 692 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (g_strcmp0 (_tmp171_, "") != 0) {
#line 7746 "scanner.c"
				const gchar* _tmp172_;
				gchar* _tmp173_;
#line 693 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp172_ = s;
#line 693 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp173_ = g_strconcat (_tmp172_, ",", NULL);
#line 693 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_g_free0 (s);
#line 693 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				s = _tmp173_;
#line 7757 "scanner.c"
			}
#line 694 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp174_ = s;
#line 694 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp175_ = g_strconcat (_tmp174_, "soft-detect", NULL);
#line 694 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 694 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp175_;
#line 695 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp176_ = cap;
#line 695 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			cap = _tmp176_ & (~SANE_CAP_SOFT_DETECT);
#line 7771 "scanner.c"
		}
#line 697 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp177_ = cap;
#line 697 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if ((_tmp177_ & SANE_CAP_EMULATED) != ((SANE_Int) 0)) {
#line 7777 "scanner.c"
			const gchar* _tmp178_;
			const gchar* _tmp181_;
			gchar* _tmp182_;
			SANE_Int _tmp183_;
#line 699 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp178_ = s;
#line 699 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (g_strcmp0 (_tmp178_, "") != 0) {
#line 7786 "scanner.c"
				const gchar* _tmp179_;
				gchar* _tmp180_;
#line 700 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp179_ = s;
#line 700 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp180_ = g_strconcat (_tmp179_, ",", NULL);
#line 700 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_g_free0 (s);
#line 700 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				s = _tmp180_;
#line 7797 "scanner.c"
			}
#line 701 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp181_ = s;
#line 701 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp182_ = g_strconcat (_tmp181_, "emulated", NULL);
#line 701 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 701 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp182_;
#line 702 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp183_ = cap;
#line 702 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			cap = _tmp183_ & (~SANE_CAP_EMULATED);
#line 7811 "scanner.c"
		}
#line 704 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp184_ = cap;
#line 704 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if ((_tmp184_ & SANE_CAP_AUTOMATIC) != ((SANE_Int) 0)) {
#line 7817 "scanner.c"
			const gchar* _tmp185_;
			const gchar* _tmp188_;
			gchar* _tmp189_;
			SANE_Int _tmp190_;
#line 706 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp185_ = s;
#line 706 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (g_strcmp0 (_tmp185_, "") != 0) {
#line 7826 "scanner.c"
				const gchar* _tmp186_;
				gchar* _tmp187_;
#line 707 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp186_ = s;
#line 707 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp187_ = g_strconcat (_tmp186_, ",", NULL);
#line 707 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_g_free0 (s);
#line 707 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				s = _tmp187_;
#line 7837 "scanner.c"
			}
#line 708 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp188_ = s;
#line 708 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp189_ = g_strconcat (_tmp188_, "automatic", NULL);
#line 708 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 708 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp189_;
#line 709 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp190_ = cap;
#line 709 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			cap = _tmp190_ & (~SANE_CAP_AUTOMATIC);
#line 7851 "scanner.c"
		}
#line 711 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp191_ = cap;
#line 711 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if ((_tmp191_ & SANE_CAP_INACTIVE) != ((SANE_Int) 0)) {
#line 7857 "scanner.c"
			const gchar* _tmp192_;
			const gchar* _tmp195_;
			gchar* _tmp196_;
			SANE_Int _tmp197_;
#line 713 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp192_ = s;
#line 713 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (g_strcmp0 (_tmp192_, "") != 0) {
#line 7866 "scanner.c"
				const gchar* _tmp193_;
				gchar* _tmp194_;
#line 714 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp193_ = s;
#line 714 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp194_ = g_strconcat (_tmp193_, ",", NULL);
#line 714 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_g_free0 (s);
#line 714 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				s = _tmp194_;
#line 7877 "scanner.c"
			}
#line 715 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp195_ = s;
#line 715 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp196_ = g_strconcat (_tmp195_, "inactive", NULL);
#line 715 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 715 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp196_;
#line 716 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp197_ = cap;
#line 716 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			cap = _tmp197_ & (~SANE_CAP_INACTIVE);
#line 7891 "scanner.c"
		}
#line 718 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp198_ = cap;
#line 718 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if ((_tmp198_ & SANE_CAP_ADVANCED) != ((SANE_Int) 0)) {
#line 7897 "scanner.c"
			const gchar* _tmp199_;
			const gchar* _tmp202_;
			gchar* _tmp203_;
			SANE_Int _tmp204_;
#line 720 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp199_ = s;
#line 720 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (g_strcmp0 (_tmp199_, "") != 0) {
#line 7906 "scanner.c"
				const gchar* _tmp200_;
				gchar* _tmp201_;
#line 721 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp200_ = s;
#line 721 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp201_ = g_strconcat (_tmp200_, ",", NULL);
#line 721 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_g_free0 (s);
#line 721 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				s = _tmp201_;
#line 7917 "scanner.c"
			}
#line 722 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp202_ = s;
#line 722 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp203_ = g_strconcat (_tmp202_, "advanced", NULL);
#line 722 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 722 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp203_;
#line 723 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp204_ = cap;
#line 723 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			cap = _tmp204_ & (~SANE_CAP_ADVANCED);
#line 7931 "scanner.c"
		}
#line 726 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp205_ = cap;
#line 726 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp205_ != ((SANE_Int) 0)) {
#line 7937 "scanner.c"
			const gchar* _tmp206_;
			const gchar* _tmp209_;
			SANE_Int _tmp210_;
			gchar* _tmp211_ = NULL;
			gchar* _tmp212_;
			gchar* _tmp213_;
#line 728 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp206_ = s;
#line 728 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (g_strcmp0 (_tmp206_, "") != 0) {
#line 7948 "scanner.c"
				const gchar* _tmp207_;
				gchar* _tmp208_;
#line 729 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp207_ = s;
#line 729 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp208_ = g_strconcat (_tmp207_, ",", NULL);
#line 729 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_g_free0 (s);
#line 729 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				s = _tmp208_;
#line 7959 "scanner.c"
			}
#line 730 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp209_ = s;
#line 730 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp210_ = cap;
#line 730 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp211_ = g_strdup_printf ("%x", (guint) ((gint) _tmp210_));
#line 730 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp212_ = _tmp211_;
#line 730 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp213_ = g_strconcat (_tmp209_, _tmp212_, NULL);
#line 730 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (s);
#line 730 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			s = _tmp213_;
#line 730 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_g_free0 (_tmp212_);
#line 7977 "scanner.c"
		}
	}
#line 734 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp214_ = s;
#line 734 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:734: %s", _tmp214_);
#line 736 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp215_ = option;
#line 736 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp216_ = _tmp215_->desc;
#line 736 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp216_ != NULL) {
#line 7990 "scanner.c"
		SANE_Option_Descriptor* _tmp217_;
		const gchar* _tmp218_;
#line 737 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp217_ = option;
#line 737 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp218_ = _tmp217_->desc;
#line 737 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_debug ("scanner.vala:737:   Description: %s", _tmp218_);
#line 7999 "scanner.c"
	}
#line 573 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (s);
#line 8003 "scanner.c"
}


static void scanner_authorization_cb (const gchar* resource, gchar* username, int username_length1, gchar* password, int password_length1) {
	Scanner* _tmp0_;
	const gchar* _tmp1_;
	NotifyRequestAuthorization* _tmp2_;
	NotifyRequestAuthorization* _tmp3_;
	Scanner* _tmp4_;
	GAsyncQueue* _tmp5_;
	gpointer _tmp6_ = NULL;
	Credentials* credentials;
#line 740 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (resource != NULL);
#line 742 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = scanner_scanner_object;
#line 742 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = resource;
#line 742 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = notify_request_authorization_new (_tmp1_);
#line 742 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = _tmp2_;
#line 742 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scanner_notify (_tmp0_, (Notify*) _tmp3_);
#line 742 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_notify_unref0 (_tmp3_);
#line 744 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = scanner_scanner_object;
#line 744 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = _tmp4_->priv->authorize_queue;
#line 744 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp6_ = g_async_queue_pop (_tmp5_);
#line 744 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	credentials = (Credentials*) _tmp6_;
#line 8038 "scanner.c"
	{
		gint i;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		i = 0;
#line 8043 "scanner.c"
		{
			gboolean _tmp7_;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp7_ = TRUE;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			while (TRUE) {
#line 8050 "scanner.c"
				gboolean _tmp8_;
				gboolean _tmp10_ = FALSE;
				Credentials* _tmp11_;
				const gchar* _tmp12_;
				gint _tmp13_;
				gchar _tmp14_ = '\0';
				gboolean _tmp17_;
				gchar* _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				Credentials* _tmp20_;
				const gchar* _tmp21_;
				gint _tmp22_;
				gchar _tmp23_ = '\0';
				gchar _tmp24_;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp8_ = _tmp7_;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				if (!_tmp8_) {
#line 8070 "scanner.c"
					gint _tmp9_;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp9_ = i;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					i = _tmp9_ + 1;
#line 8076 "scanner.c"
				}
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp7_ = FALSE;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp11_ = credentials;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp12_ = _tmp11_->username;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp13_ = i;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				if (_tmp14_ != '\0') {
#line 8090 "scanner.c"
					gint _tmp15_;
					gint _tmp16_;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp15_ = i;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp16_ = SANE_MAX_USERNAME_LEN;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp10_ = _tmp15_ < _tmp16_;
#line 8099 "scanner.c"
				} else {
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp10_ = FALSE;
#line 8103 "scanner.c"
				}
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp17_ = _tmp10_;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				if (!_tmp17_) {
#line 745 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					break;
#line 8111 "scanner.c"
				}
#line 746 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp18_ = username;
#line 746 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp18__length1 = username_length1;
#line 746 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp19_ = i;
#line 746 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp20_ = credentials;
#line 746 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp21_ = _tmp20_->username;
#line 746 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp22_ = i;
#line 746 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp23_ = string_get (_tmp21_, (glong) _tmp22_);
#line 746 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp18_[_tmp19_] = _tmp23_;
#line 746 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp24_ = _tmp18_[_tmp19_];
#line 8131 "scanner.c"
			}
		}
	}
	{
		gint i;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		i = 0;
#line 8139 "scanner.c"
		{
			gboolean _tmp25_;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp25_ = TRUE;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			while (TRUE) {
#line 8146 "scanner.c"
				gboolean _tmp26_;
				gboolean _tmp28_ = FALSE;
				Credentials* _tmp29_;
				const gchar* _tmp30_;
				gint _tmp31_;
				gchar _tmp32_ = '\0';
				gboolean _tmp35_;
				gchar* _tmp36_;
				gint _tmp36__length1;
				gint _tmp37_;
				Credentials* _tmp38_;
				const gchar* _tmp39_;
				gint _tmp40_;
				gchar _tmp41_ = '\0';
				gchar _tmp42_;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp26_ = _tmp25_;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				if (!_tmp26_) {
#line 8166 "scanner.c"
					gint _tmp27_;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp27_ = i;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					i = _tmp27_ + 1;
#line 8172 "scanner.c"
				}
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp25_ = FALSE;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp29_ = credentials;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp30_ = _tmp29_->password;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp31_ = i;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp32_ = string_get (_tmp30_, (glong) _tmp31_);
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				if (_tmp32_ != '\0') {
#line 8186 "scanner.c"
					gint _tmp33_;
					gint _tmp34_;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp33_ = i;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp34_ = SANE_MAX_USERNAME_LEN;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp28_ = _tmp33_ < _tmp34_;
#line 8195 "scanner.c"
				} else {
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp28_ = FALSE;
#line 8199 "scanner.c"
				}
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp35_ = _tmp28_;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				if (!_tmp35_) {
#line 747 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					break;
#line 8207 "scanner.c"
				}
#line 748 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp36_ = password;
#line 748 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp36__length1 = password_length1;
#line 748 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp37_ = i;
#line 748 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp38_ = credentials;
#line 748 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp39_ = _tmp38_->password;
#line 748 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp40_ = i;
#line 748 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp41_ = string_get (_tmp39_, (glong) _tmp40_);
#line 748 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp36_[_tmp37_] = _tmp41_;
#line 748 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp42_ = _tmp36_[_tmp37_];
#line 8227 "scanner.c"
			}
		}
	}
#line 740 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_credentials_unref0 (credentials);
#line 8233 "scanner.c"
}


static gpointer _credentials_ref0 (gpointer self) {
#line 756 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self ? credentials_ref (self) : NULL;
#line 8240 "scanner.c"
}


void scanner_authorize (Scanner* self, const gchar* username, const gchar* password) {
	Credentials* _tmp0_;
	Credentials* credentials;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GAsyncQueue* _tmp5_;
	Credentials* _tmp6_;
#line 751 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 751 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (username != NULL);
#line 751 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (password != NULL);
#line 753 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = credentials_new ();
#line 753 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	credentials = _tmp0_;
#line 754 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = username;
#line 754 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 754 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (credentials->username);
#line 754 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	credentials->username = _tmp2_;
#line 755 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = password;
#line 755 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 755 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (credentials->password);
#line 755 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	credentials->password = _tmp4_;
#line 756 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = self->priv->authorize_queue;
#line 756 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp6_ = _credentials_ref0 (credentials);
#line 756 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_async_queue_push (_tmp5_, _tmp6_);
#line 751 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_credentials_unref0 (credentials);
#line 8287 "scanner.c"
}


static void scanner_close_device (Scanner* self) {
	gboolean _tmp0_;
#line 759 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 761 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = self->priv->have_handle;
#line 761 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp0_) {
#line 8299 "scanner.c"
		SANE_Handle _tmp1_;
		SANE_Handle _tmp2_;
#line 763 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp1_ = self->priv->handle;
#line 763 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		sane_cancel (_tmp1_);
#line 764 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_debug ("scanner.vala:764: sane_cancel ()");
#line 766 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp2_ = self->priv->handle;
#line 766 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		sane_close (_tmp2_);
#line 767 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_debug ("scanner.vala:767: sane_close ()");
#line 768 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->have_handle = FALSE;
#line 769 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_g_hash_table_unref0 (self->priv->options);
#line 769 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->options = NULL;
#line 8320 "scanner.c"
	}
#line 772 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 772 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->buffer = NULL;
#line 772 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->buffer_length1 = 0;
#line 772 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 773 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	__g_list_free__scan_job_unref0_0 (self->priv->job_queue);
#line 773 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->job_queue = NULL;
#line 775 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scanner_set_scanning (self, FALSE);
#line 8336 "scanner.c"
}


static void scanner_fail_scan (Scanner* self, gint error_code, const gchar* error_string) {
	gint _tmp0_;
	const gchar* _tmp1_;
	NotifyScanFailed* _tmp2_;
	NotifyScanFailed* _tmp3_;
#line 778 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 778 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (error_string != NULL);
#line 780 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scanner_close_device (self);
#line 781 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 782 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = error_code;
#line 782 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = error_string;
#line 782 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = notify_scan_failed_new (_tmp0_, _tmp1_);
#line 782 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = _tmp2_;
#line 782 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp3_);
#line 782 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_notify_unref0 (_tmp3_);
#line 8365 "scanner.c"
}


static gpointer _request_ref0 (gpointer self) {
#line 807 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self ? request_ref (self) : NULL;
#line 8372 "scanner.c"
}


static gpointer _scan_job_ref0 (gpointer self) {
#line 808 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return self ? scan_job_ref (self) : NULL;
#line 8379 "scanner.c"
}


static gboolean scanner_handle_requests (Scanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ScanState _tmp1_;
	gboolean _tmp3_;
	gint request_count;
#line 785 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 788 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = self->priv->state;
#line 788 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp1_ == SCAN_STATE_IDLE) {
#line 8395 "scanner.c"
		gboolean _tmp2_;
#line 788 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp2_ = self->priv->need_redetect;
#line 788 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp0_ = _tmp2_;
#line 8401 "scanner.c"
	} else {
#line 788 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp0_ = FALSE;
#line 8405 "scanner.c"
	}
#line 788 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = _tmp0_;
#line 788 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp3_) {
#line 789 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->state = SCAN_STATE_REDETECT;
#line 8413 "scanner.c"
	}
#line 792 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	request_count = 0;
#line 793 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	while (TRUE) {
#line 8419 "scanner.c"
		Request* request = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ScanState _tmp6_;
		gboolean _tmp8_;
		gboolean _tmp11_;
		gint _tmp14_;
		Request* _tmp15_;
#line 796 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp6_ = self->priv->state;
#line 796 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp6_ == SCAN_STATE_IDLE) {
#line 8432 "scanner.c"
			gint _tmp7_;
#line 796 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp7_ = request_count;
#line 796 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp5_ = _tmp7_ == 0;
#line 8438 "scanner.c"
		} else {
#line 796 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp5_ = FALSE;
#line 8442 "scanner.c"
		}
#line 796 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp8_ = _tmp5_;
#line 796 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp8_) {
#line 796 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp4_ = TRUE;
#line 8450 "scanner.c"
		} else {
			GAsyncQueue* _tmp9_;
			gint _tmp10_ = 0;
#line 797 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp9_ = self->priv->request_queue;
#line 797 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp10_ = g_async_queue_length (_tmp9_);
#line 797 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp4_ = _tmp10_ > 0;
#line 8460 "scanner.c"
		}
#line 796 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp11_ = _tmp4_;
#line 796 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp11_) {
#line 8466 "scanner.c"
			GAsyncQueue* _tmp12_;
			gpointer _tmp13_ = NULL;
#line 798 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp12_ = self->priv->request_queue;
#line 798 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp13_ = g_async_queue_pop (_tmp12_);
#line 798 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_request_unref0 (request);
#line 798 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			request = (Request*) _tmp13_;
#line 8477 "scanner.c"
		} else {
#line 800 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			result = TRUE;
#line 800 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_request_unref0 (request);
#line 800 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return result;
#line 8485 "scanner.c"
		}
#line 802 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_debug ("scanner.vala:802: Processing request");
#line 803 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp14_ = request_count;
#line 803 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		request_count = _tmp14_ + 1;
#line 805 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp15_ = request;
#line 805 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, TYPE_REQUEST_START_SCAN)) {
#line 8497 "scanner.c"
			Request* _tmp16_;
			RequestStartScan* _tmp17_;
			RequestStartScan* r;
			RequestStartScan* _tmp18_;
			ScanJob* _tmp19_;
			ScanJob* _tmp20_;
#line 807 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp16_ = request;
#line 807 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp17_ = _request_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_REQUEST_START_SCAN, RequestStartScan));
#line 807 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			r = _tmp17_;
#line 808 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp18_ = r;
#line 808 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp19_ = _tmp18_->job;
#line 808 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp20_ = _scan_job_ref0 (_tmp19_);
#line 808 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			self->priv->job_queue = g_list_append (self->priv->job_queue, _tmp20_);
#line 805 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_request_unref0 (r);
#line 8520 "scanner.c"
		} else {
			Request* _tmp21_;
#line 810 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp21_ = request;
#line 810 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, TYPE_REQUEST_CANCEL)) {
#line 812 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_fail_scan (self, (gint) SANE_STATUS_CANCELLED, "Scan cancelled - do not report this error");
#line 8529 "scanner.c"
			} else {
				Request* _tmp22_;
#line 814 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp22_ = request;
#line 814 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, TYPE_REQUEST_QUIT)) {
#line 816 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					scanner_close_device (self);
#line 817 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					result = FALSE;
#line 817 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_request_unref0 (request);
#line 817 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					return result;
#line 8544 "scanner.c"
				}
			}
		}
#line 793 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_request_unref0 (request);
#line 8550 "scanner.c"
	}
}


static void _g_free0_ (gpointer var) {
#line 861 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	var = (g_free (var), NULL);
#line 8558 "scanner.c"
}


static void scanner_do_open (Scanner* self) {
	GList* _tmp0_;
	gconstpointer _tmp1_;
	ScanJob* _tmp2_;
	ScanJob* job;
	gboolean _tmp3_ = FALSE;
	ScanJob* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp7_;
	ScanJob* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp14_;
	GHashFunc _tmp19_;
	GEqualFunc _tmp20_;
	GHashTable* _tmp21_;
	ScanJob* _tmp22_;
	const gchar* _tmp23_;
	SANE_Handle _tmp24_ = {0};
	SANE_Status _tmp25_ = 0;
	SANE_Status status;
	ScanJob* _tmp26_;
	const gchar* _tmp27_;
	SANE_Status _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	SANE_Status _tmp31_;
	ScanJob* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
#line 822 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 824 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 824 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 824 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 824 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	job = _tmp2_;
#line 826 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->line_count = 0;
#line 827 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->pass_number = 0;
#line 828 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->page_number = 0;
#line 829 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->notified_page = -1;
#line 830 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->option_index = (SANE_Int) 0;
#line 832 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = job;
#line 832 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = _tmp4_->device;
#line 832 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp5_ == NULL) {
#line 8617 "scanner.c"
		const gchar* _tmp6_;
#line 832 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp6_ = self->priv->default_device;
#line 832 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp3_ = _tmp6_ != NULL;
#line 8623 "scanner.c"
	} else {
#line 832 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp3_ = FALSE;
#line 8627 "scanner.c"
	}
#line 832 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp7_ = _tmp3_;
#line 832 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp7_) {
#line 8633 "scanner.c"
		ScanJob* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
#line 833 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp8_ = job;
#line 833 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp9_ = self->priv->default_device;
#line 833 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp10_ = g_strdup (_tmp9_);
#line 833 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_g_free0 (_tmp8_->device);
#line 833 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp8_->device = _tmp10_;
#line 8647 "scanner.c"
	}
#line 835 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp11_ = job;
#line 835 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp12_ = _tmp11_->device;
#line 835 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp12_ == NULL) {
#line 8655 "scanner.c"
		const gchar* _tmp13_ = NULL;
#line 837 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_warning ("scanner.vala:837: No scan device available");
#line 838 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp13_ = _ ("No scanners available.  Please connect a scanner.");
#line 838 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scanner_fail_scan (self, 0, _tmp13_);
#line 841 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_scan_job_unref0 (job);
#line 841 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return;
#line 8667 "scanner.c"
	}
#line 845 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp14_ = self->priv->have_handle;
#line 845 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp14_) {
#line 8673 "scanner.c"
		const gchar* _tmp15_;
		ScanJob* _tmp16_;
		const gchar* _tmp17_;
		SANE_Handle _tmp18_;
#line 847 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp15_ = self->priv->current_device;
#line 847 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp16_ = job;
#line 847 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp17_ = _tmp16_->device;
#line 847 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (g_strcmp0 (_tmp15_, _tmp17_) == 0) {
#line 849 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			self->priv->state = SCAN_STATE_GET_OPTION;
#line 850 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_scan_job_unref0 (job);
#line 850 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return;
#line 8692 "scanner.c"
		}
#line 853 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp18_ = self->priv->handle;
#line 853 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		sane_close (_tmp18_);
#line 854 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_debug ("scanner.vala:854: sane_close ()");
#line 855 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->have_handle = FALSE;
#line 8702 "scanner.c"
	}
#line 858 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (self->priv->current_device);
#line 858 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->current_device = NULL;
#line 860 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->have_handle = FALSE;
#line 861 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp19_ = g_str_hash;
#line 861 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp20_ = g_str_equal;
#line 861 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp21_ = g_hash_table_new_full (_tmp19_, _tmp20_, _g_free0_, NULL);
#line 861 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_hash_table_unref0 (self->priv->options);
#line 861 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->options = _tmp21_;
#line 862 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp22_ = job;
#line 862 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp23_ = _tmp22_->device;
#line 862 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp25_ = sane_open (_tmp23_, &_tmp24_);
#line 862 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->handle = _tmp24_;
#line 862 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	status = _tmp25_;
#line 863 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp26_ = job;
#line 863 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp27_ = _tmp26_->device;
#line 863 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp28_ = status;
#line 863 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp29_ = sane_status_to_string (_tmp28_);
#line 863 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp30_ = _tmp29_;
#line 863 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:863: sane_open (\"%s\") -> %s", _tmp27_, _tmp30_);
#line 863 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp30_);
#line 865 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp31_ = status;
#line 865 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp31_ != SANE_STATUS_GOOD) {
#line 8748 "scanner.c"
		SANE_Status _tmp32_;
		const gchar* _tmp33_ = NULL;
		SANE_Status _tmp34_;
		const gchar* _tmp35_ = NULL;
#line 867 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp32_ = status;
#line 867 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp33_ = sane_strstatus (_tmp32_);
#line 867 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_warning ("scanner.vala:867: Unable to get open device: %s", _tmp33_);
#line 868 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp34_ = status;
#line 868 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp35_ = _ ("Unable to connect to scanner");
#line 868 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scanner_fail_scan (self, (gint) _tmp34_, _tmp35_);
#line 871 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_scan_job_unref0 (job);
#line 871 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return;
#line 8769 "scanner.c"
	}
#line 873 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->have_handle = TRUE;
#line 875 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp36_ = job;
#line 875 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp37_ = _tmp36_->device;
#line 875 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp38_ = g_strdup (_tmp37_);
#line 875 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (self->priv->current_device);
#line 875 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->current_device = _tmp38_;
#line 876 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->state = SCAN_STATE_GET_OPTION;
#line 822 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_scan_job_unref0 (job);
#line 8787 "scanner.c"
}


static void scanner_do_get_option (Scanner* self) {
	GList* _tmp0_;
	gconstpointer _tmp1_;
	ScanJob* _tmp2_;
	ScanJob* job;
	SANE_Handle _tmp3_;
	SANE_Int _tmp4_;
	SANE_Option_Descriptor* _tmp5_ = NULL;
	SANE_Option_Descriptor* option;
	SANE_Int _tmp6_;
	SANE_Int _tmp7_;
	SANE_Int index;
	SANE_Int _tmp8_;
	SANE_Option_Descriptor* _tmp9_;
	SANE_Int _tmp355_;
	SANE_Option_Descriptor* _tmp356_;
	SANE_Option_Descriptor* _tmp357_;
	SANE_Value_Type _tmp358_;
	SANE_Option_Descriptor* _tmp359_;
	SANE_Int _tmp360_;
	SANE_Option_Descriptor* _tmp361_;
	const gchar* _tmp362_;
	GHashTable* _tmp363_;
	SANE_Option_Descriptor* _tmp364_;
	const gchar* _tmp365_;
	gchar* _tmp366_;
	SANE_Int _tmp367_;
#line 879 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 881 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 881 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 881 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 881 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	job = _tmp2_;
#line 883 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = self->priv->handle;
#line 883 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = self->priv->option_index;
#line 883 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = sane_get_option_descriptor (_tmp3_, _tmp4_);
#line 883 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	option = _tmp5_;
#line 884 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp6_ = self->priv->option_index;
#line 884 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:884: sane_get_option_descriptor (%d)", (gint) _tmp6_);
#line 885 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp7_ = self->priv->option_index;
#line 885 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	index = _tmp7_;
#line 886 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp8_ = self->priv->option_index;
#line 886 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->option_index = _tmp8_ + 1;
#line 889 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp9_ = option;
#line 889 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp9_ == NULL) {
#line 8852 "scanner.c"
		SANE_Handle _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_ = 0;
		SANE_Option_Descriptor* _tmp13_ = NULL;
		SANE_Option_Descriptor* _tmp14_;
		SANE_Option_Descriptor* _tmp18_;
		SANE_Handle _tmp93_;
		const gchar* _tmp94_;
		gint _tmp95_ = 0;
		SANE_Option_Descriptor* _tmp96_ = NULL;
		SANE_Option_Descriptor* _tmp97_;
		SANE_Handle _tmp153_;
		gint _tmp154_ = 0;
		SANE_Option_Descriptor* _tmp155_ = NULL;
		SANE_Option_Descriptor* _tmp156_;
		SANE_Handle _tmp164_;
		gint _tmp165_ = 0;
		SANE_Option_Descriptor* _tmp166_ = NULL;
		SANE_Option_Descriptor* _tmp167_;
		SANE_Handle _tmp175_;
		gint _tmp176_ = 0;
		SANE_Option_Descriptor* _tmp177_ = NULL;
		SANE_Option_Descriptor* _tmp178_;
		SANE_Handle _tmp191_;
		const gchar* _tmp192_;
		gint _tmp193_ = 0;
		SANE_Option_Descriptor* _tmp194_ = NULL;
		SANE_Option_Descriptor* _tmp195_;
		SANE_Handle _tmp215_;
		const gchar* _tmp216_;
		gint _tmp217_ = 0;
		SANE_Option_Descriptor* _tmp218_ = NULL;
		SANE_Option_Descriptor* _tmp219_;
		SANE_Handle _tmp234_;
		const gchar* _tmp235_;
		gint _tmp236_ = 0;
		SANE_Option_Descriptor* _tmp237_ = NULL;
		SANE_Option_Descriptor* _tmp238_;
		SANE_Handle _tmp253_;
		const gchar* _tmp254_;
		gint _tmp255_ = 0;
		SANE_Option_Descriptor* _tmp256_ = NULL;
		gboolean _tmp257_ = FALSE;
		SANE_Option_Descriptor* _tmp258_;
		gboolean _tmp261_;
		SANE_Handle _tmp271_;
		const gchar* _tmp272_;
		gint _tmp273_ = 0;
		SANE_Option_Descriptor* _tmp274_ = NULL;
		gboolean _tmp275_ = FALSE;
		SANE_Option_Descriptor* _tmp276_;
		gboolean _tmp279_;
		SANE_Handle _tmp289_;
		const gchar* _tmp290_;
		gint _tmp291_ = 0;
		SANE_Option_Descriptor* _tmp292_ = NULL;
		SANE_Option_Descriptor* _tmp293_;
		SANE_Handle _tmp304_;
		const gchar* _tmp305_;
		gint _tmp306_ = 0;
		SANE_Option_Descriptor* _tmp307_ = NULL;
		SANE_Option_Descriptor* _tmp308_;
		const gchar* _tmp319_;
#line 892 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp10_ = self->priv->handle;
#line 892 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp11_ = SANE_NAME_SCAN_SOURCE;
#line 892 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp13_ = scanner_get_option_by_name (self, _tmp10_, _tmp11_, &_tmp12_);
#line 892 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		index = (SANE_Int) _tmp12_;
#line 892 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		option = _tmp13_;
#line 893 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp14_ = option;
#line 893 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp14_ == NULL) {
#line 8930 "scanner.c"
			SANE_Handle _tmp15_;
			gint _tmp16_ = 0;
			SANE_Option_Descriptor* _tmp17_ = NULL;
#line 895 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			g_debug ("scanner.vala:895: SCAN_SOURCE not available, trying alternative \"doc-" \
"source\"");
#line 896 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp15_ = self->priv->handle;
#line 896 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp17_ = scanner_get_option_by_name (self, _tmp15_, "doc-source", &_tmp16_);
#line 896 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			index = (SANE_Int) _tmp16_;
#line 896 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			option = _tmp17_;
#line 8944 "scanner.c"
		}
#line 898 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp18_ = option;
#line 898 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp18_ != NULL) {
#line 8950 "scanner.c"
			gchar* _tmp19_;
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			gchar* _tmp22_;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			const gchar* _tmp27_ = NULL;
			gchar* _tmp28_;
			gchar** _tmp29_ = NULL;
			gchar** flatbed_sources;
			gint flatbed_sources_length1;
			gint _flatbed_sources_size_;
			gchar* _tmp30_;
			const gchar* _tmp31_ = NULL;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar** _tmp37_ = NULL;
			gchar** adf_sources;
			gint adf_sources_length1;
			gint _adf_sources_size_;
			gchar* _tmp38_;
			const gchar* _tmp39_ = NULL;
			gchar* _tmp40_;
			gchar** _tmp41_ = NULL;
			gchar** adf_front_sources;
			gint adf_front_sources_length1;
			gint _adf_front_sources_size_;
			gchar* _tmp42_;
			const gchar* _tmp43_ = NULL;
			gchar* _tmp44_;
			gchar** _tmp45_ = NULL;
			gchar** adf_back_sources;
			gint adf_back_sources_length1;
			gint _adf_back_sources_size_;
			gchar* _tmp46_;
			const gchar* _tmp47_ = NULL;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar** _tmp51_ = NULL;
			gchar** adf_duplex_sources;
			gint adf_duplex_sources_length1;
			gint _adf_duplex_sources_size_;
			ScanJob* _tmp52_;
			ScanType _tmp53_;
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp19_ = g_strdup ("Auto");
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp20_ = SANE_I18N ("Auto");
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp21_ = g_strdup (_tmp20_);
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp22_ = g_strdup ("Flatbed");
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp23_ = SANE_I18N ("Flatbed");
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp24_ = g_strdup (_tmp23_);
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp25_ = g_strdup ("FlatBed");
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp26_ = g_strdup ("Normal");
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp27_ = SANE_I18N ("Normal");
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp28_ = g_strdup (_tmp27_);
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp29_ = g_new0 (gchar*, 7 + 1);
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp29_[0] = _tmp19_;
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp29_[1] = _tmp21_;
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp29_[2] = _tmp22_;
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp29_[3] = _tmp24_;
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp29_[4] = _tmp25_;
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp29_[5] = _tmp26_;
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp29_[6] = _tmp28_;
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			flatbed_sources = _tmp29_;
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			flatbed_sources_length1 = 7;
#line 900 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_flatbed_sources_size_ = flatbed_sources_length1;
#line 911 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp30_ = g_strdup ("Automatic Document Feeder");
#line 911 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp31_ = SANE_I18N ("Automatic Document Feeder");
#line 911 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp32_ = g_strdup (_tmp31_);
#line 911 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp33_ = g_strdup ("ADF");
#line 911 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp34_ = g_strdup ("Automatic Document Feeder(left aligned)");
#line 911 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp35_ = g_strdup ("Automatic Document Feeder(centrally aligned)");
#line 911 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp36_ = g_strdup ("ADF Simplex");
#line 911 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp37_ = g_new0 (gchar*, 6 + 1);
#line 911 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp37_[0] = _tmp30_;
#line 911 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp37_[1] = _tmp32_;
#line 911 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp37_[2] = _tmp33_;
#line 911 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp37_[3] = _tmp34_;
#line 911 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp37_[4] = _tmp35_;
#line 911 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp37_[5] = _tmp36_;
#line 911 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			adf_sources = _tmp37_;
#line 911 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			adf_sources_length1 = 6;
#line 911 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_adf_sources_size_ = adf_sources_length1;
#line 921 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp38_ = g_strdup ("ADF Front");
#line 921 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp39_ = SANE_I18N ("ADF Front");
#line 921 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp40_ = g_strdup (_tmp39_);
#line 921 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp41_ = g_new0 (gchar*, 2 + 1);
#line 921 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp41_[0] = _tmp38_;
#line 921 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp41_[1] = _tmp40_;
#line 921 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			adf_front_sources = _tmp41_;
#line 921 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			adf_front_sources_length1 = 2;
#line 921 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_adf_front_sources_size_ = adf_front_sources_length1;
#line 927 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp42_ = g_strdup ("ADF Back");
#line 927 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp43_ = SANE_I18N ("ADF Back");
#line 927 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp44_ = g_strdup (_tmp43_);
#line 927 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp45_ = g_new0 (gchar*, 2 + 1);
#line 927 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp45_[0] = _tmp42_;
#line 927 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp45_[1] = _tmp44_;
#line 927 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			adf_back_sources = _tmp45_;
#line 927 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			adf_back_sources_length1 = 2;
#line 927 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_adf_back_sources_size_ = adf_back_sources_length1;
#line 933 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp46_ = g_strdup ("ADF Duplex");
#line 933 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp47_ = SANE_I18N ("ADF Duplex");
#line 933 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp48_ = g_strdup (_tmp47_);
#line 933 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp49_ = g_strdup ("ADF Duplex - Long-Edge Binding");
#line 933 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp50_ = g_strdup ("ADF Duplex - Short-Edge Binding");
#line 933 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp51_ = g_new0 (gchar*, 4 + 1);
#line 933 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp51_[0] = _tmp46_;
#line 933 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp51_[1] = _tmp48_;
#line 933 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp51_[2] = _tmp49_;
#line 933 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp51_[3] = _tmp50_;
#line 933 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			adf_duplex_sources = _tmp51_;
#line 933 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			adf_duplex_sources_length1 = 4;
#line 933 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_adf_duplex_sources_size_ = adf_duplex_sources_length1;
#line 941 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp52_ = job;
#line 941 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp53_ = _tmp52_->type;
#line 941 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			switch (_tmp53_) {
#line 941 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				case SCAN_TYPE_SINGLE:
#line 9147 "scanner.c"
				{
					SANE_Handle _tmp54_;
					SANE_Option_Descriptor* _tmp55_;
					SANE_Int _tmp56_;
					gboolean _tmp57_ = FALSE;
#line 944 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp54_ = self->priv->handle;
#line 944 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp55_ = option;
#line 944 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp56_ = index;
#line 944 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp57_ = scanner_set_default_option (self, _tmp54_, _tmp55_, _tmp56_);
#line 944 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					if (!_tmp57_) {
#line 9163 "scanner.c"
						SANE_Handle _tmp58_;
						SANE_Option_Descriptor* _tmp59_;
						SANE_Int _tmp60_;
						gchar** _tmp61_;
						gint _tmp61__length1;
						gboolean _tmp62_ = FALSE;
#line 945 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp58_ = self->priv->handle;
#line 945 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp59_ = option;
#line 945 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp60_ = index;
#line 945 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp61_ = flatbed_sources;
#line 945 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp61__length1 = flatbed_sources_length1;
#line 945 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp62_ = scanner_set_constrained_string_option (self, _tmp58_, _tmp59_, _tmp60_, _tmp61_, _tmp61__length1, NULL);
#line 945 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (!_tmp62_) {
#line 946 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							g_warning ("scanner.vala:946: Unable to set single page source, please file a bug");
#line 9186 "scanner.c"
						}
					}
#line 947 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					break;
#line 9191 "scanner.c"
				}
#line 941 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				case SCAN_TYPE_ADF_FRONT:
#line 9195 "scanner.c"
				{
					SANE_Handle _tmp63_;
					SANE_Option_Descriptor* _tmp64_;
					SANE_Int _tmp65_;
					gchar** _tmp66_;
					gint _tmp66__length1;
					gboolean _tmp67_ = FALSE;
#line 949 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp63_ = self->priv->handle;
#line 949 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp64_ = option;
#line 949 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp65_ = index;
#line 949 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp66_ = adf_front_sources;
#line 949 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp66__length1 = adf_front_sources_length1;
#line 949 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp67_ = scanner_set_constrained_string_option (self, _tmp63_, _tmp64_, _tmp65_, _tmp66_, _tmp66__length1, NULL);
#line 949 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					if (!_tmp67_) {
#line 9217 "scanner.c"
						SANE_Handle _tmp68_;
						SANE_Option_Descriptor* _tmp69_;
						SANE_Int _tmp70_;
						gchar** _tmp71_;
						gint _tmp71__length1;
						gboolean _tmp72_ = FALSE;
#line 950 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp68_ = self->priv->handle;
#line 950 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp69_ = option;
#line 950 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp70_ = index;
#line 950 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp71_ = adf_sources;
#line 950 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp71__length1 = adf_sources_length1;
#line 950 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp72_ = scanner_set_constrained_string_option (self, _tmp68_, _tmp69_, _tmp70_, _tmp71_, _tmp71__length1, NULL);
#line 950 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (!_tmp72_) {
#line 951 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							g_warning ("scanner.vala:951: Unable to set front ADF source, please file a bug");
#line 9240 "scanner.c"
						}
					}
#line 952 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					break;
#line 9245 "scanner.c"
				}
#line 941 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				case SCAN_TYPE_ADF_BACK:
#line 9249 "scanner.c"
				{
					SANE_Handle _tmp73_;
					SANE_Option_Descriptor* _tmp74_;
					SANE_Int _tmp75_;
					gchar** _tmp76_;
					gint _tmp76__length1;
					gboolean _tmp77_ = FALSE;
#line 954 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp73_ = self->priv->handle;
#line 954 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp74_ = option;
#line 954 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp75_ = index;
#line 954 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp76_ = adf_back_sources;
#line 954 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp76__length1 = adf_back_sources_length1;
#line 954 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp77_ = scanner_set_constrained_string_option (self, _tmp73_, _tmp74_, _tmp75_, _tmp76_, _tmp76__length1, NULL);
#line 954 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					if (!_tmp77_) {
#line 9271 "scanner.c"
						SANE_Handle _tmp78_;
						SANE_Option_Descriptor* _tmp79_;
						SANE_Int _tmp80_;
						gchar** _tmp81_;
						gint _tmp81__length1;
						gboolean _tmp82_ = FALSE;
#line 955 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp78_ = self->priv->handle;
#line 955 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp79_ = option;
#line 955 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp80_ = index;
#line 955 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp81_ = adf_sources;
#line 955 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp81__length1 = adf_sources_length1;
#line 955 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp82_ = scanner_set_constrained_string_option (self, _tmp78_, _tmp79_, _tmp80_, _tmp81_, _tmp81__length1, NULL);
#line 955 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (!_tmp82_) {
#line 956 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							g_warning ("scanner.vala:956: Unable to set back ADF source, please file a bug");
#line 9294 "scanner.c"
						}
					}
#line 957 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					break;
#line 9299 "scanner.c"
				}
#line 941 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				case SCAN_TYPE_ADF_BOTH:
#line 9303 "scanner.c"
				{
					SANE_Handle _tmp83_;
					SANE_Option_Descriptor* _tmp84_;
					SANE_Int _tmp85_;
					gchar** _tmp86_;
					gint _tmp86__length1;
					gboolean _tmp87_ = FALSE;
#line 959 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp83_ = self->priv->handle;
#line 959 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp84_ = option;
#line 959 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp85_ = index;
#line 959 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp86_ = adf_duplex_sources;
#line 959 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp86__length1 = adf_duplex_sources_length1;
#line 959 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp87_ = scanner_set_constrained_string_option (self, _tmp83_, _tmp84_, _tmp85_, _tmp86_, _tmp86__length1, NULL);
#line 959 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					if (!_tmp87_) {
#line 9325 "scanner.c"
						SANE_Handle _tmp88_;
						SANE_Option_Descriptor* _tmp89_;
						SANE_Int _tmp90_;
						gchar** _tmp91_;
						gint _tmp91__length1;
						gboolean _tmp92_ = FALSE;
#line 960 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp88_ = self->priv->handle;
#line 960 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp89_ = option;
#line 960 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp90_ = index;
#line 960 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp91_ = adf_sources;
#line 960 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp91__length1 = adf_sources_length1;
#line 960 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp92_ = scanner_set_constrained_string_option (self, _tmp88_, _tmp89_, _tmp90_, _tmp91_, _tmp91__length1, NULL);
#line 960 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (!_tmp92_) {
#line 961 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							g_warning ("scanner.vala:961: Unable to set duplex ADF source, please file a bug");
#line 9348 "scanner.c"
						}
					}
#line 962 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					break;
#line 9353 "scanner.c"
				}
				default:
#line 941 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				break;
#line 9358 "scanner.c"
			}
#line 898 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			adf_duplex_sources = (_vala_array_free (adf_duplex_sources, adf_duplex_sources_length1, (GDestroyNotify) g_free), NULL);
#line 898 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			adf_back_sources = (_vala_array_free (adf_back_sources, adf_back_sources_length1, (GDestroyNotify) g_free), NULL);
#line 898 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			adf_front_sources = (_vala_array_free (adf_front_sources, adf_front_sources_length1, (GDestroyNotify) g_free), NULL);
#line 898 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			adf_sources = (_vala_array_free (adf_sources, adf_sources_length1, (GDestroyNotify) g_free), NULL);
#line 898 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			flatbed_sources = (_vala_array_free (flatbed_sources, flatbed_sources_length1, (GDestroyNotify) g_free), NULL);
#line 9370 "scanner.c"
		}
#line 967 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp93_ = self->priv->handle;
#line 967 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp94_ = SANE_NAME_SCAN_MODE;
#line 967 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp96_ = scanner_get_option_by_name (self, _tmp93_, _tmp94_, &_tmp95_);
#line 967 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		index = (SANE_Int) _tmp95_;
#line 967 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		option = _tmp96_;
#line 968 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp97_ = option;
#line 968 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp97_ != NULL) {
#line 9386 "scanner.c"
			const gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			gchar** _tmp103_ = NULL;
			gchar** color_scan_modes;
			gint color_scan_modes_length1;
			gint _color_scan_modes_size_;
			const gchar* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			const gchar* _tmp108_ = NULL;
			gchar* _tmp109_;
			gchar* _tmp110_;
			gchar* _tmp111_;
			gchar** _tmp112_ = NULL;
			gchar** gray_scan_modes;
			gint gray_scan_modes_length1;
			gint _gray_scan_modes_size_;
			const gchar* _tmp113_;
			gchar* _tmp114_;
			gchar* _tmp115_;
			gchar* _tmp116_;
			const gchar* _tmp117_ = NULL;
			gchar* _tmp118_;
			gchar* _tmp119_;
			const gchar* _tmp120_ = NULL;
			gchar* _tmp121_;
			gchar* _tmp122_;
			const gchar* _tmp123_ = NULL;
			gchar* _tmp124_;
			gchar* _tmp125_;
			const gchar* _tmp126_;
			gchar* _tmp127_;
			gchar* _tmp128_;
			gchar* _tmp129_;
			const gchar* _tmp130_ = NULL;
			gchar* _tmp131_;
			gchar* _tmp132_;
			gchar* _tmp133_;
			gchar* _tmp134_;
			gchar** _tmp135_ = NULL;
			gchar** lineart_scan_modes;
			gint lineart_scan_modes_length1;
			gint _lineart_scan_modes_size_;
			ScanJob* _tmp136_;
			ScanMode _tmp137_;
#line 971 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp98_ = SANE_VALUE_SCAN_MODE_COLOR;
#line 971 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp99_ = g_strdup (_tmp98_);
#line 971 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp100_ = g_strdup ("Color");
#line 971 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp101_ = g_strdup ("24bit Color");
#line 971 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp102_ = g_strdup ("Color - 16 Million Colors");
#line 971 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp103_ = g_new0 (gchar*, 4 + 1);
#line 971 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp103_[0] = _tmp99_;
#line 971 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp103_[1] = _tmp100_;
#line 971 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp103_[2] = _tmp101_;
#line 971 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp103_[3] = _tmp102_;
#line 971 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			color_scan_modes = _tmp103_;
#line 971 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			color_scan_modes_length1 = 4;
#line 971 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_color_scan_modes_size_ = color_scan_modes_length1;
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp104_ = SANE_VALUE_SCAN_MODE_GRAY;
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp105_ = g_strdup (_tmp104_);
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp106_ = g_strdup ("Gray");
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp107_ = g_strdup ("Grayscale");
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp108_ = SANE_I18N ("Grayscale");
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp109_ = g_strdup (_tmp108_);
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp110_ = g_strdup ("True Gray");
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp111_ = g_strdup ("Grayscale - 256 Levels");
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp112_ = g_new0 (gchar*, 6 + 1);
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp112_[0] = _tmp105_;
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp112_[1] = _tmp106_;
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp112_[2] = _tmp107_;
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp112_[3] = _tmp109_;
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp112_[4] = _tmp110_;
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp112_[5] = _tmp111_;
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			gray_scan_modes = _tmp112_;
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			gray_scan_modes_length1 = 6;
#line 978 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_gray_scan_modes_size_ = gray_scan_modes_length1;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp113_ = SANE_VALUE_SCAN_MODE_LINEART;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp114_ = g_strdup (_tmp113_);
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp115_ = g_strdup ("Lineart");
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp116_ = g_strdup ("LineArt");
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp117_ = SANE_I18N ("LineArt");
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp118_ = g_strdup (_tmp117_);
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp119_ = g_strdup ("Black & White");
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp120_ = SANE_I18N ("Black & White");
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp121_ = g_strdup (_tmp120_);
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp122_ = g_strdup ("Binary");
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp123_ = SANE_I18N ("Binary");
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp124_ = g_strdup (_tmp123_);
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp125_ = g_strdup ("Thresholded");
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp126_ = SANE_VALUE_SCAN_MODE_GRAY;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp127_ = g_strdup (_tmp126_);
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp128_ = g_strdup ("Gray");
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp129_ = g_strdup ("Grayscale");
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp130_ = SANE_I18N ("Grayscale");
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp131_ = g_strdup (_tmp130_);
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp132_ = g_strdup ("True Gray");
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp133_ = g_strdup ("Black and White - Line Art");
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp134_ = g_strdup ("Black and White - Halftone");
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp135_ = g_new0 (gchar*, 16 + 1);
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp135_[0] = _tmp114_;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp135_[1] = _tmp115_;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp135_[2] = _tmp116_;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp135_[3] = _tmp118_;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp135_[4] = _tmp119_;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp135_[5] = _tmp121_;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp135_[6] = _tmp122_;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp135_[7] = _tmp124_;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp135_[8] = _tmp125_;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp135_[9] = _tmp127_;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp135_[10] = _tmp128_;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp135_[11] = _tmp129_;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp135_[12] = _tmp131_;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp135_[13] = _tmp132_;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp135_[14] = _tmp133_;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp135_[15] = _tmp134_;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			lineart_scan_modes = _tmp135_;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			lineart_scan_modes_length1 = 16;
#line 987 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_lineart_scan_modes_size_ = lineart_scan_modes_length1;
#line 1007 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp136_ = job;
#line 1007 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp137_ = _tmp136_->scan_mode;
#line 1007 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			switch (_tmp137_) {
#line 1007 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				case SCAN_MODE_COLOR:
#line 9590 "scanner.c"
				{
					SANE_Handle _tmp138_;
					SANE_Option_Descriptor* _tmp139_;
					SANE_Int _tmp140_;
					gchar** _tmp141_;
					gint _tmp141__length1;
					gboolean _tmp142_ = FALSE;
#line 1010 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp138_ = self->priv->handle;
#line 1010 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp139_ = option;
#line 1010 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp140_ = index;
#line 1010 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp141_ = color_scan_modes;
#line 1010 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp141__length1 = color_scan_modes_length1;
#line 1010 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp142_ = scanner_set_constrained_string_option (self, _tmp138_, _tmp139_, _tmp140_, _tmp141_, _tmp141__length1, NULL);
#line 1010 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					if (!_tmp142_) {
#line 1011 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						g_warning ("scanner.vala:1011: Unable to set Color mode, please file a bug");
#line 9614 "scanner.c"
					}
#line 1012 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					break;
#line 9618 "scanner.c"
				}
#line 1007 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				case SCAN_MODE_GRAY:
#line 9622 "scanner.c"
				{
					SANE_Handle _tmp143_;
					SANE_Option_Descriptor* _tmp144_;
					SANE_Int _tmp145_;
					gchar** _tmp146_;
					gint _tmp146__length1;
					gboolean _tmp147_ = FALSE;
#line 1014 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp143_ = self->priv->handle;
#line 1014 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp144_ = option;
#line 1014 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp145_ = index;
#line 1014 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp146_ = gray_scan_modes;
#line 1014 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp146__length1 = gray_scan_modes_length1;
#line 1014 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp147_ = scanner_set_constrained_string_option (self, _tmp143_, _tmp144_, _tmp145_, _tmp146_, _tmp146__length1, NULL);
#line 1014 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					if (!_tmp147_) {
#line 1015 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						g_warning ("scanner.vala:1015: Unable to set Gray mode, please file a bug");
#line 9646 "scanner.c"
					}
#line 1016 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					break;
#line 9650 "scanner.c"
				}
#line 1007 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				case SCAN_MODE_LINEART:
#line 9654 "scanner.c"
				{
					SANE_Handle _tmp148_;
					SANE_Option_Descriptor* _tmp149_;
					SANE_Int _tmp150_;
					gchar** _tmp151_;
					gint _tmp151__length1;
					gboolean _tmp152_ = FALSE;
#line 1018 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp148_ = self->priv->handle;
#line 1018 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp149_ = option;
#line 1018 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp150_ = index;
#line 1018 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp151_ = lineart_scan_modes;
#line 1018 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp151__length1 = lineart_scan_modes_length1;
#line 1018 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp152_ = scanner_set_constrained_string_option (self, _tmp148_, _tmp149_, _tmp150_, _tmp151_, _tmp151__length1, NULL);
#line 1018 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					if (!_tmp152_) {
#line 1019 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						g_warning ("scanner.vala:1019: Unable to set Lineart mode, please file a bug");
#line 9678 "scanner.c"
					}
#line 1020 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					break;
#line 9682 "scanner.c"
				}
				default:
				{
#line 1022 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					break;
#line 9688 "scanner.c"
				}
			}
#line 968 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			lineart_scan_modes = (_vala_array_free (lineart_scan_modes, lineart_scan_modes_length1, (GDestroyNotify) g_free), NULL);
#line 968 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			gray_scan_modes = (_vala_array_free (gray_scan_modes, gray_scan_modes_length1, (GDestroyNotify) g_free), NULL);
#line 968 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			color_scan_modes = (_vala_array_free (color_scan_modes, color_scan_modes_length1, (GDestroyNotify) g_free), NULL);
#line 9697 "scanner.c"
		}
#line 1027 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp153_ = self->priv->handle;
#line 1027 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp155_ = scanner_get_option_by_name (self, _tmp153_, "duplex", &_tmp154_);
#line 1027 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		index = (SANE_Int) _tmp154_;
#line 1027 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		option = _tmp155_;
#line 1028 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp156_ = option;
#line 1028 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp156_ != NULL) {
#line 9711 "scanner.c"
			SANE_Option_Descriptor* _tmp157_;
			SANE_Value_Type _tmp158_;
#line 1030 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp157_ = option;
#line 1030 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp158_ = _tmp157_->type;
#line 1030 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (_tmp158_ == SANE_TYPE_BOOL) {
#line 9720 "scanner.c"
				SANE_Handle _tmp159_;
				SANE_Option_Descriptor* _tmp160_;
				SANE_Int _tmp161_;
				ScanJob* _tmp162_;
				ScanType _tmp163_;
#line 1031 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp159_ = self->priv->handle;
#line 1031 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp160_ = option;
#line 1031 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp161_ = index;
#line 1031 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp162_ = job;
#line 1031 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp163_ = _tmp162_->type;
#line 1031 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_set_bool_option (self, _tmp159_, _tmp160_, _tmp161_, _tmp163_ == SCAN_TYPE_ADF_BOTH, NULL);
#line 9738 "scanner.c"
			}
		}
#line 1035 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp164_ = self->priv->handle;
#line 1035 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp166_ = scanner_get_option_by_name (self, _tmp164_, "batch-scan", &_tmp165_);
#line 1035 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		index = (SANE_Int) _tmp165_;
#line 1035 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		option = _tmp166_;
#line 1036 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp167_ = option;
#line 1036 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp167_ != NULL) {
#line 9753 "scanner.c"
			SANE_Option_Descriptor* _tmp168_;
			SANE_Value_Type _tmp169_;
#line 1038 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp168_ = option;
#line 1038 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp169_ = _tmp168_->type;
#line 1038 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (_tmp169_ == SANE_TYPE_BOOL) {
#line 9762 "scanner.c"
				SANE_Handle _tmp170_;
				SANE_Option_Descriptor* _tmp171_;
				SANE_Int _tmp172_;
				ScanJob* _tmp173_;
				ScanType _tmp174_;
#line 1039 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp170_ = self->priv->handle;
#line 1039 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp171_ = option;
#line 1039 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp172_ = index;
#line 1039 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp173_ = job;
#line 1039 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp174_ = _tmp173_->type;
#line 1039 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_set_bool_option (self, _tmp170_, _tmp171_, _tmp172_, _tmp174_ != SCAN_TYPE_SINGLE, NULL);
#line 9780 "scanner.c"
			}
		}
#line 1043 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp175_ = self->priv->handle;
#line 1043 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp177_ = scanner_get_option_by_name (self, _tmp175_, "compression", &_tmp176_);
#line 1043 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		index = (SANE_Int) _tmp176_;
#line 1043 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		option = _tmp177_;
#line 1044 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp178_ = option;
#line 1044 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp178_ != NULL) {
#line 9795 "scanner.c"
			const gchar* _tmp179_ = NULL;
			gchar* _tmp180_;
			const gchar* _tmp181_ = NULL;
			gchar* _tmp182_;
			gchar* _tmp183_;
			gchar* _tmp184_;
			gchar** _tmp185_ = NULL;
			gchar** disable_compression_names;
			gint disable_compression_names_length1;
			gint _disable_compression_names_size_;
			SANE_Handle _tmp186_;
			SANE_Option_Descriptor* _tmp187_;
			SANE_Int _tmp188_;
			gchar** _tmp189_;
			gint _tmp189__length1;
			gboolean _tmp190_ = FALSE;
#line 1046 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp179_ = SANE_I18N ("None");
#line 1046 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp180_ = g_strdup (_tmp179_);
#line 1046 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp181_ = SANE_I18N ("none");
#line 1046 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp182_ = g_strdup (_tmp181_);
#line 1046 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp183_ = g_strdup ("None");
#line 1046 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp184_ = g_strdup ("none");
#line 1046 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp185_ = g_new0 (gchar*, 4 + 1);
#line 1046 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp185_[0] = _tmp180_;
#line 1046 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp185_[1] = _tmp182_;
#line 1046 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp185_[2] = _tmp183_;
#line 1046 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp185_[3] = _tmp184_;
#line 1046 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			disable_compression_names = _tmp185_;
#line 1046 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			disable_compression_names_length1 = 4;
#line 1046 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_disable_compression_names_size_ = disable_compression_names_length1;
#line 1054 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp186_ = self->priv->handle;
#line 1054 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp187_ = option;
#line 1054 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp188_ = index;
#line 1054 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp189_ = disable_compression_names;
#line 1054 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp189__length1 = disable_compression_names_length1;
#line 1054 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp190_ = scanner_set_constrained_string_option (self, _tmp186_, _tmp187_, _tmp188_, _tmp189_, _tmp189__length1, NULL);
#line 1054 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (!_tmp190_) {
#line 1055 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				g_warning ("scanner.vala:1055: Unable to disable compression, please file a bug");
#line 9856 "scanner.c"
			}
#line 1044 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			disable_compression_names = (_vala_array_free (disable_compression_names, disable_compression_names_length1, (GDestroyNotify) g_free), NULL);
#line 9860 "scanner.c"
		}
#line 1059 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp191_ = self->priv->handle;
#line 1059 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp192_ = SANE_NAME_SCAN_RESOLUTION;
#line 1059 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp194_ = scanner_get_option_by_name (self, _tmp191_, _tmp192_, &_tmp193_);
#line 1059 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		index = (SANE_Int) _tmp193_;
#line 1059 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		option = _tmp194_;
#line 1060 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp195_ = option;
#line 1060 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp195_ != NULL) {
#line 9876 "scanner.c"
			SANE_Handle _tmp196_;
			SANE_Option_Descriptor* _tmp197_;
			SANE_Int _tmp198_;
			ScanJob* _tmp199_;
			gdouble _tmp200_;
			ScanJob* _tmp201_;
			gdouble _tmp202_ = 0.0;
			SANE_Handle _tmp203_;
			const gchar* _tmp204_;
			gint _tmp205_ = 0;
			SANE_Option_Descriptor* _tmp206_ = NULL;
			SANE_Option_Descriptor* _tmp207_;
#line 1062 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp196_ = self->priv->handle;
#line 1062 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp197_ = option;
#line 1062 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp198_ = index;
#line 1062 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp199_ = job;
#line 1062 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp200_ = _tmp199_->dpi;
#line 1062 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp201_ = job;
#line 1062 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			scanner_set_fixed_or_int_option (self, _tmp196_, _tmp197_, _tmp198_, _tmp200_, &_tmp202_);
#line 1062 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp201_->dpi = _tmp202_;
#line 1063 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp203_ = self->priv->handle;
#line 1063 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp204_ = SANE_NAME_BIT_DEPTH;
#line 1063 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp206_ = scanner_get_option_by_name (self, _tmp203_, _tmp204_, &_tmp205_);
#line 1063 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			index = (SANE_Int) _tmp205_;
#line 1063 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			option = _tmp206_;
#line 1064 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp207_ = option;
#line 1064 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (_tmp207_ != NULL) {
#line 9919 "scanner.c"
				ScanJob* _tmp208_;
				gint _tmp209_;
#line 1066 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp208_ = job;
#line 1066 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp209_ = _tmp208_->depth;
#line 1066 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				if (_tmp209_ > 0) {
#line 9928 "scanner.c"
					SANE_Handle _tmp210_;
					SANE_Option_Descriptor* _tmp211_;
					SANE_Int _tmp212_;
					ScanJob* _tmp213_;
					gint _tmp214_;
#line 1067 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp210_ = self->priv->handle;
#line 1067 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp211_ = option;
#line 1067 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp212_ = index;
#line 1067 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp213_ = job;
#line 1067 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp214_ = _tmp213_->depth;
#line 1067 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					scanner_set_int_option (self, _tmp210_, _tmp211_, _tmp212_, _tmp214_, NULL);
#line 9946 "scanner.c"
				}
			}
		}
#line 1072 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp215_ = self->priv->handle;
#line 1072 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp216_ = SANE_NAME_SCAN_BR_X;
#line 1072 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp218_ = scanner_get_option_by_name (self, _tmp215_, _tmp216_, &_tmp217_);
#line 1072 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		index = (SANE_Int) _tmp217_;
#line 1072 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		option = _tmp218_;
#line 1073 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp219_ = option;
#line 1073 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp219_ != NULL) {
#line 9964 "scanner.c"
			ScanJob* _tmp220_;
			gint _tmp221_;
#line 1075 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp220_ = job;
#line 1075 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp221_ = _tmp220_->page_width;
#line 1075 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (_tmp221_ > 0) {
#line 9973 "scanner.c"
				SANE_Handle _tmp222_;
				SANE_Option_Descriptor* _tmp223_;
				SANE_Int _tmp224_;
				SANE_Option_Descriptor* _tmp225_;
				ScanJob* _tmp226_;
				gint _tmp227_;
				ScanJob* _tmp228_;
				gdouble _tmp229_;
				gdouble _tmp230_ = 0.0;
#line 1076 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp222_ = self->priv->handle;
#line 1076 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp223_ = option;
#line 1076 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp224_ = index;
#line 1076 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp225_ = option;
#line 1076 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp226_ = job;
#line 1076 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp227_ = _tmp226_->page_width;
#line 1076 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp228_ = job;
#line 1076 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp229_ = _tmp228_->dpi;
#line 1076 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp230_ = scanner_convert_page_size (self, _tmp225_, (gdouble) _tmp227_, _tmp229_);
#line 1076 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_set_fixed_or_int_option (self, _tmp222_, _tmp223_, _tmp224_, _tmp230_, NULL);
#line 10003 "scanner.c"
			} else {
				SANE_Handle _tmp231_;
				SANE_Option_Descriptor* _tmp232_;
				SANE_Int _tmp233_;
#line 1078 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp231_ = self->priv->handle;
#line 1078 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp232_ = option;
#line 1078 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp233_ = index;
#line 1078 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_set_option_to_max (self, _tmp231_, _tmp232_, _tmp233_);
#line 10016 "scanner.c"
			}
		}
#line 1080 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp234_ = self->priv->handle;
#line 1080 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp235_ = SANE_NAME_SCAN_BR_Y;
#line 1080 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp237_ = scanner_get_option_by_name (self, _tmp234_, _tmp235_, &_tmp236_);
#line 1080 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		index = (SANE_Int) _tmp236_;
#line 1080 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		option = _tmp237_;
#line 1081 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp238_ = option;
#line 1081 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp238_ != NULL) {
#line 10033 "scanner.c"
			ScanJob* _tmp239_;
			gint _tmp240_;
#line 1083 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp239_ = job;
#line 1083 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp240_ = _tmp239_->page_height;
#line 1083 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (_tmp240_ > 0) {
#line 10042 "scanner.c"
				SANE_Handle _tmp241_;
				SANE_Option_Descriptor* _tmp242_;
				SANE_Int _tmp243_;
				SANE_Option_Descriptor* _tmp244_;
				ScanJob* _tmp245_;
				gint _tmp246_;
				ScanJob* _tmp247_;
				gdouble _tmp248_;
				gdouble _tmp249_ = 0.0;
#line 1084 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp241_ = self->priv->handle;
#line 1084 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp242_ = option;
#line 1084 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp243_ = index;
#line 1084 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp244_ = option;
#line 1084 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp245_ = job;
#line 1084 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp246_ = _tmp245_->page_height;
#line 1084 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp247_ = job;
#line 1084 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp248_ = _tmp247_->dpi;
#line 1084 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp249_ = scanner_convert_page_size (self, _tmp244_, (gdouble) _tmp246_, _tmp248_);
#line 1084 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_set_fixed_or_int_option (self, _tmp241_, _tmp242_, _tmp243_, _tmp249_, NULL);
#line 10072 "scanner.c"
			} else {
				SANE_Handle _tmp250_;
				SANE_Option_Descriptor* _tmp251_;
				SANE_Int _tmp252_;
#line 1086 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp250_ = self->priv->handle;
#line 1086 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp251_ = option;
#line 1086 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp252_ = index;
#line 1086 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_set_option_to_max (self, _tmp250_, _tmp251_, _tmp252_);
#line 10085 "scanner.c"
			}
		}
#line 1090 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp253_ = self->priv->handle;
#line 1090 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp254_ = SANE_NAME_PAGE_WIDTH;
#line 1090 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp256_ = scanner_get_option_by_name (self, _tmp253_, _tmp254_, &_tmp255_);
#line 1090 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		index = (SANE_Int) _tmp255_;
#line 1090 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		option = _tmp256_;
#line 1091 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp258_ = option;
#line 1091 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp258_ != NULL) {
#line 10102 "scanner.c"
			ScanJob* _tmp259_;
			gint _tmp260_;
#line 1091 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp259_ = job;
#line 1091 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp260_ = _tmp259_->page_width;
#line 1091 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp257_ = ((gdouble) _tmp260_) > 0.0;
#line 10111 "scanner.c"
		} else {
#line 1091 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp257_ = FALSE;
#line 10115 "scanner.c"
		}
#line 1091 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp261_ = _tmp257_;
#line 1091 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp261_) {
#line 10121 "scanner.c"
			SANE_Handle _tmp262_;
			SANE_Option_Descriptor* _tmp263_;
			SANE_Int _tmp264_;
			SANE_Option_Descriptor* _tmp265_;
			ScanJob* _tmp266_;
			gint _tmp267_;
			ScanJob* _tmp268_;
			gdouble _tmp269_;
			gdouble _tmp270_ = 0.0;
#line 1092 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp262_ = self->priv->handle;
#line 1092 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp263_ = option;
#line 1092 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp264_ = index;
#line 1092 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp265_ = option;
#line 1092 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp266_ = job;
#line 1092 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp267_ = _tmp266_->page_width;
#line 1092 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp268_ = job;
#line 1092 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp269_ = _tmp268_->dpi;
#line 1092 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp270_ = scanner_convert_page_size (self, _tmp265_, (gdouble) _tmp267_, _tmp269_);
#line 1092 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			scanner_set_fixed_or_int_option (self, _tmp262_, _tmp263_, _tmp264_, _tmp270_, NULL);
#line 10151 "scanner.c"
		}
#line 1093 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp271_ = self->priv->handle;
#line 1093 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp272_ = SANE_NAME_PAGE_HEIGHT;
#line 1093 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp274_ = scanner_get_option_by_name (self, _tmp271_, _tmp272_, &_tmp273_);
#line 1093 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		index = (SANE_Int) _tmp273_;
#line 1093 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		option = _tmp274_;
#line 1094 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp276_ = option;
#line 1094 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp276_ != NULL) {
#line 10167 "scanner.c"
			ScanJob* _tmp277_;
			gint _tmp278_;
#line 1094 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp277_ = job;
#line 1094 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp278_ = _tmp277_->page_height;
#line 1094 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp275_ = ((gdouble) _tmp278_) > 0.0;
#line 10176 "scanner.c"
		} else {
#line 1094 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp275_ = FALSE;
#line 10180 "scanner.c"
		}
#line 1094 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp279_ = _tmp275_;
#line 1094 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp279_) {
#line 10186 "scanner.c"
			SANE_Handle _tmp280_;
			SANE_Option_Descriptor* _tmp281_;
			SANE_Int _tmp282_;
			SANE_Option_Descriptor* _tmp283_;
			ScanJob* _tmp284_;
			gint _tmp285_;
			ScanJob* _tmp286_;
			gdouble _tmp287_;
			gdouble _tmp288_ = 0.0;
#line 1095 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp280_ = self->priv->handle;
#line 1095 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp281_ = option;
#line 1095 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp282_ = index;
#line 1095 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp283_ = option;
#line 1095 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp284_ = job;
#line 1095 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp285_ = _tmp284_->page_height;
#line 1095 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp286_ = job;
#line 1095 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp287_ = _tmp286_->dpi;
#line 1095 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp288_ = scanner_convert_page_size (self, _tmp283_, (gdouble) _tmp285_, _tmp287_);
#line 1095 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			scanner_set_fixed_or_int_option (self, _tmp280_, _tmp281_, _tmp282_, _tmp288_, NULL);
#line 10216 "scanner.c"
		}
#line 1097 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp289_ = self->priv->handle;
#line 1097 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp290_ = SANE_NAME_BRIGHTNESS;
#line 1097 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp292_ = scanner_get_option_by_name (self, _tmp289_, _tmp290_, &_tmp291_);
#line 1097 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		index = (SANE_Int) _tmp291_;
#line 1097 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		option = _tmp292_;
#line 1098 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp293_ = option;
#line 1098 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp293_ != NULL) {
#line 10232 "scanner.c"
			ScanJob* _tmp294_;
			gint _tmp295_;
#line 1100 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp294_ = job;
#line 1100 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp295_ = _tmp294_->brightness;
#line 1100 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (_tmp295_ != 0) {
#line 10241 "scanner.c"
				SANE_Option_Descriptor* _tmp296_;
				ScanJob* _tmp297_;
				gint _tmp298_;
				gint _tmp299_ = 0;
				gint brightness;
				SANE_Handle _tmp300_;
				SANE_Option_Descriptor* _tmp301_;
				SANE_Int _tmp302_;
				gint _tmp303_;
#line 1102 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp296_ = option;
#line 1102 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp297_ = job;
#line 1102 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp298_ = _tmp297_->brightness;
#line 1102 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp299_ = scanner_scale_int (self, -100, 100, _tmp296_, _tmp298_);
#line 1102 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				brightness = _tmp299_;
#line 1103 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp300_ = self->priv->handle;
#line 1103 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp301_ = option;
#line 1103 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp302_ = index;
#line 1103 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp303_ = brightness;
#line 1103 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_set_int_option (self, _tmp300_, _tmp301_, _tmp302_, _tmp303_, NULL);
#line 10271 "scanner.c"
			}
		}
#line 1106 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp304_ = self->priv->handle;
#line 1106 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp305_ = SANE_NAME_CONTRAST;
#line 1106 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp307_ = scanner_get_option_by_name (self, _tmp304_, _tmp305_, &_tmp306_);
#line 1106 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		index = (SANE_Int) _tmp306_;
#line 1106 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		option = _tmp307_;
#line 1107 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp308_ = option;
#line 1107 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp308_ != NULL) {
#line 10288 "scanner.c"
			ScanJob* _tmp309_;
			gint _tmp310_;
#line 1109 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp309_ = job;
#line 1109 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp310_ = _tmp309_->contrast;
#line 1109 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (_tmp310_ != 0) {
#line 10297 "scanner.c"
				SANE_Option_Descriptor* _tmp311_;
				ScanJob* _tmp312_;
				gint _tmp313_;
				gint _tmp314_ = 0;
				gint contrast;
				SANE_Handle _tmp315_;
				SANE_Option_Descriptor* _tmp316_;
				SANE_Int _tmp317_;
				gint _tmp318_;
#line 1111 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp311_ = option;
#line 1111 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp312_ = job;
#line 1111 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp313_ = _tmp312_->contrast;
#line 1111 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp314_ = scanner_scale_int (self, -100, 100, _tmp311_, _tmp313_);
#line 1111 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				contrast = _tmp314_;
#line 1112 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp315_ = self->priv->handle;
#line 1112 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp316_ = option;
#line 1112 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp317_ = index;
#line 1112 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp318_ = contrast;
#line 1112 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_set_int_option (self, _tmp315_, _tmp316_, _tmp317_, _tmp318_, NULL);
#line 10327 "scanner.c"
			}
		}
#line 1117 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp319_ = self->priv->current_device;
#line 1117 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (g_strcmp0 (_tmp319_, "test") == 0) {
#line 10334 "scanner.c"
			SANE_Handle _tmp320_;
			gint _tmp321_ = 0;
			SANE_Option_Descriptor* _tmp322_ = NULL;
			SANE_Option_Descriptor* _tmp323_;
			SANE_Handle _tmp327_;
			gint _tmp328_ = 0;
			SANE_Option_Descriptor* _tmp329_ = NULL;
			SANE_Option_Descriptor* _tmp330_;
			SANE_Handle _tmp334_;
			gint _tmp335_ = 0;
			SANE_Option_Descriptor* _tmp336_ = NULL;
			SANE_Option_Descriptor* _tmp337_;
			SANE_Handle _tmp341_;
			gint _tmp342_ = 0;
			SANE_Option_Descriptor* _tmp343_ = NULL;
			SANE_Option_Descriptor* _tmp344_;
			SANE_Handle _tmp348_;
			gint _tmp349_ = 0;
			SANE_Option_Descriptor* _tmp350_ = NULL;
			SANE_Option_Descriptor* _tmp351_;
#line 1119 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp320_ = self->priv->handle;
#line 1119 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp322_ = scanner_get_option_by_name (self, _tmp320_, "hand-scanner", &_tmp321_);
#line 1119 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			index = (SANE_Int) _tmp321_;
#line 1119 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			option = _tmp322_;
#line 1120 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp323_ = option;
#line 1120 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (_tmp323_ != NULL) {
#line 10367 "scanner.c"
				SANE_Handle _tmp324_;
				SANE_Option_Descriptor* _tmp325_;
				SANE_Int _tmp326_;
#line 1121 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp324_ = self->priv->handle;
#line 1121 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp325_ = option;
#line 1121 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp326_ = index;
#line 1121 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_set_bool_option (self, _tmp324_, _tmp325_, _tmp326_, FALSE, NULL);
#line 10379 "scanner.c"
			}
#line 1122 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp327_ = self->priv->handle;
#line 1122 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp329_ = scanner_get_option_by_name (self, _tmp327_, "three-pass", &_tmp328_);
#line 1122 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			index = (SANE_Int) _tmp328_;
#line 1122 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			option = _tmp329_;
#line 1123 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp330_ = option;
#line 1123 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (_tmp330_ != NULL) {
#line 10393 "scanner.c"
				SANE_Handle _tmp331_;
				SANE_Option_Descriptor* _tmp332_;
				SANE_Int _tmp333_;
#line 1124 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp331_ = self->priv->handle;
#line 1124 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp332_ = option;
#line 1124 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp333_ = index;
#line 1124 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_set_bool_option (self, _tmp331_, _tmp332_, _tmp333_, FALSE, NULL);
#line 10405 "scanner.c"
			}
#line 1125 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp334_ = self->priv->handle;
#line 1125 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp336_ = scanner_get_option_by_name (self, _tmp334_, "test-picture", &_tmp335_);
#line 1125 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			index = (SANE_Int) _tmp335_;
#line 1125 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			option = _tmp336_;
#line 1126 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp337_ = option;
#line 1126 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (_tmp337_ != NULL) {
#line 10419 "scanner.c"
				SANE_Handle _tmp338_;
				SANE_Option_Descriptor* _tmp339_;
				SANE_Int _tmp340_;
#line 1127 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp338_ = self->priv->handle;
#line 1127 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp339_ = option;
#line 1127 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp340_ = index;
#line 1127 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_set_string_option (self, _tmp338_, _tmp339_, _tmp340_, "Color pattern", NULL);
#line 10431 "scanner.c"
			}
#line 1128 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp341_ = self->priv->handle;
#line 1128 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp343_ = scanner_get_option_by_name (self, _tmp341_, "read-delay", &_tmp342_);
#line 1128 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			index = (SANE_Int) _tmp342_;
#line 1128 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			option = _tmp343_;
#line 1129 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp344_ = option;
#line 1129 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (_tmp344_ != NULL) {
#line 10445 "scanner.c"
				SANE_Handle _tmp345_;
				SANE_Option_Descriptor* _tmp346_;
				SANE_Int _tmp347_;
#line 1130 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp345_ = self->priv->handle;
#line 1130 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp346_ = option;
#line 1130 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp347_ = index;
#line 1130 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_set_bool_option (self, _tmp345_, _tmp346_, _tmp347_, TRUE, NULL);
#line 10457 "scanner.c"
			}
#line 1131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp348_ = self->priv->handle;
#line 1131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp350_ = scanner_get_option_by_name (self, _tmp348_, "read-delay-duration", &_tmp349_);
#line 1131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			index = (SANE_Int) _tmp349_;
#line 1131 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			option = _tmp350_;
#line 1132 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp351_ = option;
#line 1132 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			if (_tmp351_ != NULL) {
#line 10471 "scanner.c"
				SANE_Handle _tmp352_;
				SANE_Option_Descriptor* _tmp353_;
				SANE_Int _tmp354_;
#line 1133 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp352_ = self->priv->handle;
#line 1133 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp353_ = option;
#line 1133 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp354_ = index;
#line 1133 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_set_int_option (self, _tmp352_, _tmp353_, _tmp354_, 200000, NULL);
#line 10483 "scanner.c"
			}
		}
#line 1136 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->state = SCAN_STATE_START;
#line 1137 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1137 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return;
#line 10492 "scanner.c"
	}
#line 1140 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp355_ = index;
#line 1140 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp356_ = option;
#line 1140 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scanner_log_option (self, _tmp355_, _tmp356_);
#line 1143 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp357_ = option;
#line 1143 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp358_ = _tmp357_->type;
#line 1143 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp358_ == SANE_TYPE_GROUP) {
#line 1144 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1144 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return;
#line 10510 "scanner.c"
	}
#line 1147 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp359_ = option;
#line 1147 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp360_ = _tmp359_->cap;
#line 1147 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if ((_tmp360_ & SANE_CAP_INACTIVE) != ((SANE_Int) 0)) {
#line 1148 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1148 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return;
#line 10522 "scanner.c"
	}
#line 1151 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp361_ = option;
#line 1151 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp362_ = _tmp361_->name;
#line 1151 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp362_ == NULL) {
#line 1152 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1152 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return;
#line 10534 "scanner.c"
	}
#line 1154 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp363_ = self->priv->options;
#line 1154 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp364_ = option;
#line 1154 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp365_ = _tmp364_->name;
#line 1154 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp366_ = g_strdup (_tmp365_);
#line 1154 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp367_ = index;
#line 1154 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_hash_table_insert (_tmp363_, _tmp366_, (gpointer) ((gintptr) ((gint) _tmp367_)));
#line 879 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_scan_job_unref0 (job);
#line 10550 "scanner.c"
}


static gdouble scanner_convert_page_size (Scanner* self, SANE_Option_Descriptor* option, gdouble size, gdouble dpi) {
	gdouble result = 0.0;
	SANE_Option_Descriptor* _tmp0_;
	SANE_Unit _tmp1_;
#line 1157 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 1157 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (option != NULL, 0.0);
#line 1159 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = option;
#line 1159 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = _tmp0_->unit;
#line 1159 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp1_ == SANE_UNIT_PIXEL) {
#line 10568 "scanner.c"
		gdouble _tmp2_;
		gdouble _tmp3_;
#line 1160 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp2_ = dpi;
#line 1160 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp3_ = size;
#line 1160 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		result = (_tmp2_ * _tmp3_) / 254.0;
#line 1160 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return result;
#line 10579 "scanner.c"
	} else {
		SANE_Option_Descriptor* _tmp4_;
		SANE_Unit _tmp5_;
#line 1161 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp4_ = option;
#line 1161 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp5_ = _tmp4_->unit;
#line 1161 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp5_ == SANE_UNIT_MM) {
#line 10589 "scanner.c"
			gdouble _tmp6_;
#line 1162 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp6_ = size;
#line 1162 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			result = _tmp6_ / 10.0;
#line 1162 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return result;
#line 10597 "scanner.c"
		} else {
#line 1165 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			g_warning ("scanner.vala:1165: Unable to set unsupported unit type");
#line 1166 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			result = (gdouble) 0.0f;
#line 1166 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return result;
#line 10605 "scanner.c"
		}
	}
}


static SANE_Option_Descriptor* scanner_get_option_by_name (Scanner* self, SANE_Handle handle, const gchar* name, gint* index) {
	gint _vala_index = 0;
	SANE_Option_Descriptor* result = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	gint _tmp3_;
	SANE_Handle _tmp4_;
	gint _tmp5_;
	SANE_Option_Descriptor* _tmp6_ = NULL;
#line 1170 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1170 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 1172 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = self->priv->options;
#line 1172 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = name;
#line 1172 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 1172 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_vala_index = (gint) ((gintptr) _tmp2_);
#line 1173 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = _vala_index;
#line 1173 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp3_ == 0) {
#line 1174 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		result = NULL;
#line 1174 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (index) {
#line 1174 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			*index = _vala_index;
#line 10643 "scanner.c"
		}
#line 1174 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return result;
#line 10647 "scanner.c"
	}
#line 1176 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = handle;
#line 1176 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = _vala_index;
#line 1176 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp6_ = sane_get_option_descriptor (_tmp4_, (SANE_Int) _tmp5_);
#line 1176 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	result = _tmp6_;
#line 1176 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (index) {
#line 1176 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*index = _vala_index;
#line 10661 "scanner.c"
	}
#line 1176 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return result;
#line 10665 "scanner.c"
}


static void scanner_do_complete_document (Scanner* self) {
	SANE_Handle _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	NotifyDocumentDone* _tmp3_;
	NotifyDocumentDone* _tmp4_;
#line 1179 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1181 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = self->priv->handle;
#line 1181 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	sane_cancel (_tmp0_);
#line 1182 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:1182: sane_cancel ()");
#line 1184 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = self->priv->job_queue;
#line 1184 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->job_queue = g_list_remove_link (self->priv->job_queue, _tmp1_);
#line 1186 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 1189 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = self->priv->job_queue;
#line 1189 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp2_ != NULL) {
#line 1191 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->state = SCAN_STATE_OPEN;
#line 1192 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return;
#line 10697 "scanner.c"
	}
#line 1198 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = notify_document_done_new ();
#line 1198 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = _tmp3_;
#line 1198 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp4_);
#line 1198 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_notify_unref0 (_tmp4_);
#line 1199 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scanner_set_scanning (self, FALSE);
#line 10709 "scanner.c"
}


static void scanner_do_start (Scanner* self) {
	SANE_Status status = 0;
	NotifyExpectPage* _tmp0_;
	NotifyExpectPage* _tmp1_;
	SANE_Handle _tmp2_;
	SANE_Status _tmp3_ = 0;
	gint _tmp4_;
	gint _tmp5_;
	SANE_Status _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	SANE_Status _tmp9_;
#line 1202 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1206 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = notify_expect_page_new ();
#line 1206 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = _tmp0_;
#line 1206 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp1_);
#line 1206 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_notify_unref0 (_tmp1_);
#line 1208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = self->priv->handle;
#line 1208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = sane_start (_tmp2_);
#line 1208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	status = _tmp3_;
#line 1209 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = self->priv->page_number;
#line 1209 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = self->priv->pass_number;
#line 1209 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp6_ = status;
#line 1209 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp7_ = sane_status_to_string (_tmp6_);
#line 1209 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp8_ = _tmp7_;
#line 1209 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:1209: sane_start (page=%d, pass=%d) -> %s", _tmp4_, _tmp5_, _tmp8_);
#line 1209 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp8_);
#line 1210 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp9_ = status;
#line 1210 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp9_ == SANE_STATUS_GOOD) {
#line 1211 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->state = SCAN_STATE_GET_PARAMETERS;
#line 10761 "scanner.c"
	} else {
		SANE_Status _tmp10_;
#line 1212 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp10_ = status;
#line 1212 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp10_ == SANE_STATUS_NO_DOCS) {
#line 1213 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			scanner_do_complete_document (self);
#line 10770 "scanner.c"
		} else {
			SANE_Status _tmp11_;
			const gchar* _tmp12_ = NULL;
			SANE_Status _tmp13_;
			const gchar* _tmp14_ = NULL;
#line 1216 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp11_ = status;
#line 1216 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp12_ = sane_strstatus (_tmp11_);
#line 1216 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			g_warning ("scanner.vala:1216: Unable to start device: %s", _tmp12_);
#line 1217 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp13_ = status;
#line 1217 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp14_ = _ ("Unable to start scan");
#line 1217 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			scanner_fail_scan (self, (gint) _tmp13_, _tmp14_);
#line 10788 "scanner.c"
		}
	}
}


static gchar* sane_frame_to_string (SANE_Frame frame) {
	gchar* result = NULL;
	SANE_Frame _tmp0_;
#line 103 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
	_tmp0_ = frame;
#line 103 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
	switch (_tmp0_) {
#line 103 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
		case SANE_FRAME_GRAY:
#line 10803 "scanner.c"
		{
			gchar* _tmp1_;
#line 106 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp1_ = g_strdup ("SANE_FRAME_GRAY");
#line 106 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp1_;
#line 106 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 10812 "scanner.c"
		}
#line 103 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
		case SANE_FRAME_RGB:
#line 10816 "scanner.c"
		{
			gchar* _tmp2_;
#line 108 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp2_ = g_strdup ("SANE_FRAME_RGB");
#line 108 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp2_;
#line 108 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 10825 "scanner.c"
		}
#line 103 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
		case SANE_FRAME_RED:
#line 10829 "scanner.c"
		{
			gchar* _tmp3_;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp3_ = g_strdup ("SANE_FRAME_RED");
#line 110 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp3_;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 10838 "scanner.c"
		}
#line 103 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
		case SANE_FRAME_GREEN:
#line 10842 "scanner.c"
		{
			gchar* _tmp4_;
#line 112 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp4_ = g_strdup ("SANE_FRAME_GREEN");
#line 112 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp4_;
#line 112 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 10851 "scanner.c"
		}
#line 103 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
		case SANE_FRAME_BLUE:
#line 10855 "scanner.c"
		{
			gchar* _tmp5_;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp5_ = g_strdup ("SANE_FRAME_BLUE");
#line 114 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp5_;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 10864 "scanner.c"
		}
		default:
		{
			SANE_Frame _tmp6_;
			gchar* _tmp7_ = NULL;
#line 116 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp6_ = frame;
#line 116 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			_tmp7_ = g_strdup_printf ("SANE_FRAME(%d)", (gint) _tmp6_);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			result = _tmp7_;
#line 116 "/home/bob/bzr/simple-scan/3.10/src/sane.vapi"
			return result;
#line 10878 "scanner.c"
		}
	}
}


static void scanner_do_get_parameters (Scanner* self) {
	SANE_Handle _tmp0_;
	SANE_Parameters _tmp1_ = {0};
	SANE_Status _tmp2_ = 0;
	SANE_Status status;
	SANE_Status _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	SANE_Status _tmp6_;
	GList* _tmp11_;
	gconstpointer _tmp12_;
	ScanJob* _tmp13_;
	ScanJob* job;
	const gchar* _tmp14_ = NULL;
	SANE_Parameters _tmp15_;
	gboolean _tmp16_;
	SANE_Parameters _tmp17_;
	SANE_Frame _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	SANE_Parameters _tmp22_;
	gint _tmp23_;
	SANE_Parameters _tmp24_;
	gint _tmp25_;
	SANE_Parameters _tmp26_;
	gint _tmp27_;
	SANE_Parameters _tmp28_;
	gint _tmp29_;
	ScanPageInfo* _tmp30_;
	ScanPageInfo* info;
	ScanPageInfo* _tmp31_;
	SANE_Parameters _tmp32_;
	gint _tmp33_;
	ScanPageInfo* _tmp34_;
	SANE_Parameters _tmp35_;
	gint _tmp36_;
	ScanPageInfo* _tmp37_;
	SANE_Parameters _tmp38_;
	gint _tmp39_;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp42_ = FALSE;
	SANE_Parameters _tmp43_;
	gint _tmp44_;
	gboolean _tmp47_;
	gboolean _tmp50_;
	gboolean _tmp53_;
	gint _tmp57_ = 0;
	SANE_Parameters _tmp58_;
	SANE_Frame _tmp59_;
	ScanPageInfo* _tmp60_;
	gint _tmp61_;
	ScanPageInfo* _tmp62_;
	ScanJob* _tmp63_;
	gdouble _tmp64_;
	ScanPageInfo* _tmp65_;
	const gchar* _tmp66_;
	gchar* _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	SANE_Parameters _tmp76_;
	gint _tmp77_;
	gint buffer_size;
	gint _tmp78_;
	guchar* _tmp79_ = NULL;
#line 1223 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1225 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = self->priv->handle;
#line 1225 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = sane_get_parameters (_tmp0_, &_tmp1_);
#line 1225 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->parameters = _tmp1_;
#line 1225 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	status = _tmp2_;
#line 1226 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = status;
#line 1226 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = sane_status_to_string (_tmp3_);
#line 1226 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = _tmp4_;
#line 1226 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:1226: sane_get_parameters () -> %s", _tmp5_);
#line 1226 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp5_);
#line 1227 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp6_ = status;
#line 1227 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp6_ != SANE_STATUS_GOOD) {
#line 10974 "scanner.c"
		SANE_Status _tmp7_;
		const gchar* _tmp8_ = NULL;
		SANE_Status _tmp9_;
		const gchar* _tmp10_ = NULL;
#line 1229 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp7_ = status;
#line 1229 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp8_ = sane_strstatus (_tmp7_);
#line 1229 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_warning ("scanner.vala:1229: Unable to get device parameters: %s", _tmp8_);
#line 1230 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp9_ = status;
#line 1230 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp10_ = _ ("Error communicating with scanner");
#line 1230 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scanner_fail_scan (self, (gint) _tmp9_, _tmp10_);
#line 1233 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return;
#line 10993 "scanner.c"
	}
#line 1236 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp11_ = self->priv->job_queue;
#line 1236 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp12_ = _tmp11_->data;
#line 1236 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp13_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp12_, TYPE_SCAN_JOB, ScanJob));
#line 1236 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	job = _tmp13_;
#line 1240 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp15_ = self->priv->parameters;
#line 1240 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp16_ = _tmp15_.last_frame;
#line 1240 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp16_) {
#line 1240 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp14_ = "SANE_TRUE";
#line 11011 "scanner.c"
	} else {
#line 1240 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp14_ = "SANE_FALSE";
#line 11015 "scanner.c"
	}
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp17_ = self->priv->parameters;
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp18_ = _tmp17_.format;
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp19_ = sane_frame_to_string (_tmp18_);
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp20_ = _tmp19_;
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp21_ = _tmp14_;
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp22_ = self->priv->parameters;
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp23_ = _tmp22_.bytes_per_line;
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp24_ = self->priv->parameters;
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp25_ = _tmp24_.pixels_per_line;
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp26_ = self->priv->parameters;
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp27_ = _tmp26_.lines;
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp28_ = self->priv->parameters;
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp29_ = _tmp28_.depth;
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:1238: Parameters: format=%s last_frame=%s bytes_per_line=" \
"%d pixels_per_line=%d lines=%d depth=%d", _tmp20_, _tmp21_, _tmp23_, _tmp25_, _tmp27_, _tmp29_);
#line 1238 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp20_);
#line 1246 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp30_ = scan_page_info_new ();
#line 1246 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	info = _tmp30_;
#line 1247 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp31_ = info;
#line 1247 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp32_ = self->priv->parameters;
#line 1247 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp33_ = _tmp32_.pixels_per_line;
#line 1247 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp31_->width = _tmp33_;
#line 1248 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp34_ = info;
#line 1248 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp35_ = self->priv->parameters;
#line 1248 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp36_ = _tmp35_.lines;
#line 1248 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp34_->height = _tmp36_;
#line 1249 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp37_ = info;
#line 1249 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp38_ = self->priv->parameters;
#line 1249 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp39_ = _tmp38_.depth;
#line 1249 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp37_->depth = _tmp39_;
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp43_ = self->priv->parameters;
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp44_ = _tmp43_.depth;
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp44_ == 8) {
#line 11081 "scanner.c"
		SANE_Parameters _tmp45_;
		SANE_Frame _tmp46_;
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp45_ = self->priv->parameters;
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp46_ = _tmp45_.format;
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp42_ = _tmp46_ == SANE_FRAME_GRAY;
#line 11090 "scanner.c"
	} else {
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp42_ = FALSE;
#line 11094 "scanner.c"
	}
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp47_ = _tmp42_;
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp47_) {
#line 11100 "scanner.c"
		ScanJob* _tmp48_;
		gint _tmp49_;
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp48_ = job;
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp49_ = _tmp48_->depth;
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp41_ = _tmp49_ == 2;
#line 11109 "scanner.c"
	} else {
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp41_ = FALSE;
#line 11113 "scanner.c"
	}
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp50_ = _tmp41_;
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp50_) {
#line 11119 "scanner.c"
		ScanJob* _tmp51_;
		ScanMode _tmp52_;
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp51_ = job;
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp52_ = _tmp51_->scan_mode;
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp40_ = _tmp52_ == SCAN_MODE_GRAY;
#line 11128 "scanner.c"
	} else {
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp40_ = FALSE;
#line 11132 "scanner.c"
	}
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp53_ = _tmp40_;
#line 1252 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp53_) {
#line 11138 "scanner.c"
		ScanPageInfo* _tmp54_;
		ScanJob* _tmp55_;
		gint _tmp56_;
#line 1253 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp54_ = info;
#line 1253 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp55_ = job;
#line 1253 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp56_ = _tmp55_->depth;
#line 1253 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp54_->depth = _tmp56_;
#line 11150 "scanner.c"
	}
#line 1254 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp58_ = self->priv->parameters;
#line 1254 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp59_ = _tmp58_.format;
#line 1254 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp59_ == SANE_FRAME_GRAY) {
#line 1254 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp57_ = 1;
#line 11160 "scanner.c"
	} else {
#line 1254 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp57_ = 3;
#line 11164 "scanner.c"
	}
#line 1254 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp60_ = info;
#line 1254 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp61_ = _tmp57_;
#line 1254 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp60_->n_channels = _tmp61_;
#line 1255 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp62_ = info;
#line 1255 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp63_ = job;
#line 1255 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp64_ = _tmp63_->dpi;
#line 1255 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp62_->dpi = _tmp64_;
#line 1256 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp65_ = info;
#line 1256 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp66_ = self->priv->current_device;
#line 1256 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp67_ = g_strdup (_tmp66_);
#line 1256 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp65_->device);
#line 1256 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp65_->device = _tmp67_;
#line 1258 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp68_ = self->priv->page_number;
#line 1258 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp69_ = self->priv->notified_page;
#line 1258 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp68_ != _tmp69_) {
#line 11196 "scanner.c"
		ScanJob* _tmp70_;
		gint _tmp71_;
		ScanPageInfo* _tmp72_;
		NotifyGotPageInfo* _tmp73_;
		NotifyGotPageInfo* _tmp74_;
		gint _tmp75_;
#line 1260 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp70_ = job;
#line 1260 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp71_ = _tmp70_->id;
#line 1260 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp72_ = info;
#line 1260 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp73_ = notify_got_page_info_new (_tmp71_, _tmp72_);
#line 1260 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp74_ = _tmp73_;
#line 1260 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp74_);
#line 1260 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_notify_unref0 (_tmp74_);
#line 1261 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp75_ = self->priv->page_number;
#line 1261 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->notified_page = _tmp75_;
#line 11221 "scanner.c"
	}
#line 1265 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp76_ = self->priv->parameters;
#line 1265 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp77_ = _tmp76_.bytes_per_line;
#line 1265 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	buffer_size = _tmp77_ + 1;
#line 1266 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp78_ = buffer_size;
#line 1266 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp79_ = g_new0 (guchar, _tmp78_);
#line 1266 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 1266 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->buffer = _tmp79_;
#line 1266 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->buffer_length1 = _tmp78_;
#line 1266 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 1267 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->n_used = 0;
#line 1268 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->line_count = 0;
#line 1269 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->pass_number = 0;
#line 1270 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->state = SCAN_STATE_READ;
#line 1223 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_scan_page_info_unref0 (info);
#line 1223 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_scan_job_unref0 (job);
#line 11253 "scanner.c"
}


static void scanner_do_complete_page (Scanner* self) {
	GList* _tmp0_;
	gconstpointer _tmp1_;
	ScanJob* _tmp2_;
	ScanJob* job;
	ScanJob* _tmp3_;
	gint _tmp4_;
	NotifyPageDone* _tmp5_;
	NotifyPageDone* _tmp6_;
	SANE_Parameters _tmp7_;
	gboolean _tmp8_;
	ScanJob* _tmp10_;
	ScanType _tmp11_;
#line 1273 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1275 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 1275 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 1275 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 1275 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	job = _tmp2_;
#line 1277 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = job;
#line 1277 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = _tmp3_->id;
#line 1277 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = notify_page_done_new (_tmp4_);
#line 1277 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp6_ = _tmp5_;
#line 1277 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp6_);
#line 1277 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_notify_unref0 (_tmp6_);
#line 1280 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp7_ = self->priv->parameters;
#line 1280 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp8_ = _tmp7_.last_frame;
#line 1280 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!_tmp8_) {
#line 11298 "scanner.c"
		gint _tmp9_;
#line 1282 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp9_ = self->priv->pass_number;
#line 1282 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->pass_number = _tmp9_ + 1;
#line 1283 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->state = SCAN_STATE_START;
#line 1284 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1284 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return;
#line 11310 "scanner.c"
	}
#line 1288 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp10_ = job;
#line 1288 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp11_ = _tmp10_->type;
#line 1288 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp11_ != SCAN_TYPE_SINGLE) {
#line 11318 "scanner.c"
		gint _tmp12_;
		ScanJob* _tmp13_;
		gint _tmp14_;
		NotifyPageDone* _tmp15_;
		NotifyPageDone* _tmp16_;
#line 1290 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp12_ = self->priv->page_number;
#line 1290 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->page_number = _tmp12_ + 1;
#line 1291 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->pass_number = 0;
#line 1292 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp13_ = job;
#line 1292 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp14_ = _tmp13_->id;
#line 1292 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp15_ = notify_page_done_new (_tmp14_);
#line 1292 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp16_ = _tmp15_;
#line 1292 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp16_);
#line 1292 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_notify_unref0 (_tmp16_);
#line 1293 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->state = SCAN_STATE_START;
#line 1294 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1294 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return;
#line 11348 "scanner.c"
	}
#line 1297 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scanner_do_complete_document (self);
#line 1273 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_scan_job_unref0 (job);
#line 11354 "scanner.c"
}


static void scanner_do_read (Scanner* self) {
	GList* _tmp0_;
	gconstpointer _tmp1_;
	ScanJob* _tmp2_;
	ScanJob* job;
	guchar* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gint n_to_read;
	SANE_Int n_read = {0};
	guchar* _tmp5_;
	gint _tmp5__length1;
	guchar* b;
	SANE_Handle _tmp6_;
	guchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	SANE_Int _tmp10_ = {0};
	SANE_Status _tmp11_ = 0;
	SANE_Status status;
	gint _tmp12_;
	SANE_Status _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	SANE_Int _tmp16_;
	SANE_Status _tmp17_;
	SANE_Status _tmp30_;
	gboolean full_read;
	gboolean _tmp35_ = FALSE;
	gint _tmp36_;
	gboolean _tmp39_;
	gint _tmp40_;
	SANE_Int _tmp41_;
	gint _tmp42_;
	SANE_Parameters _tmp43_;
	gint _tmp44_;
#line 1300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1302 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 1302 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 1302 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 1302 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	job = _tmp2_;
#line 1305 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = self->priv->buffer;
#line 1305 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3__length1 = self->priv->buffer_length1;
#line 1305 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = self->priv->n_used;
#line 1305 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	n_to_read = _tmp3__length1 - _tmp4_;
#line 1308 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = self->priv->buffer;
#line 1308 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5__length1 = self->priv->buffer_length1;
#line 1308 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	b = (guchar*) _tmp5_;
#line 1309 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp6_ = self->priv->handle;
#line 1309 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp7_ = b;
#line 1309 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp8_ = self->priv->n_used;
#line 1309 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp9_ = n_to_read;
#line 1309 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp11_ = sane_read (_tmp6_, (guint8*) (_tmp7_ + _tmp8_), (SANE_Int) _tmp9_, &_tmp10_);
#line 1309 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	n_read = _tmp10_;
#line 1309 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	status = _tmp11_;
#line 1310 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp12_ = n_to_read;
#line 1310 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp13_ = status;
#line 1310 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp14_ = sane_status_to_string (_tmp13_);
#line 1310 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp15_ = _tmp14_;
#line 1310 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp16_ = n_read;
#line 1310 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:1310: sane_read (%d) -> (%s, %d)", _tmp12_, _tmp15_, (gint) _tmp16_);
#line 1310 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp15_);
#line 1313 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp17_ = status;
#line 1313 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp17_ == SANE_STATUS_EOF) {
#line 11450 "scanner.c"
		gboolean _tmp18_ = FALSE;
		SANE_Parameters _tmp19_;
		gint _tmp20_;
		gboolean _tmp24_;
		gint _tmp28_;
#line 1315 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp19_ = self->priv->parameters;
#line 1315 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp20_ = _tmp19_.lines;
#line 1315 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp20_ > 0) {
#line 11462 "scanner.c"
			gint _tmp21_;
			SANE_Parameters _tmp22_;
			gint _tmp23_;
#line 1315 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp21_ = self->priv->line_count;
#line 1315 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp22_ = self->priv->parameters;
#line 1315 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp23_ = _tmp22_.lines;
#line 1315 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp18_ = _tmp21_ != _tmp23_;
#line 11474 "scanner.c"
		} else {
#line 1315 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp18_ = FALSE;
#line 11478 "scanner.c"
		}
#line 1315 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp24_ = _tmp18_;
#line 1315 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp24_) {
#line 11484 "scanner.c"
			gint _tmp25_;
			SANE_Parameters _tmp26_;
			gint _tmp27_;
#line 1316 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp25_ = self->priv->line_count;
#line 1316 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp26_ = self->priv->parameters;
#line 1316 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp27_ = _tmp26_.lines;
#line 1316 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			g_warning ("scanner.vala:1316: Scan completed with %d lines, expected %d lines", _tmp25_, _tmp27_);
#line 11496 "scanner.c"
		}
#line 1317 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp28_ = self->priv->n_used;
#line 1317 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp28_ > 0) {
#line 11502 "scanner.c"
			gint _tmp29_;
#line 1318 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp29_ = self->priv->n_used;
#line 1318 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			g_warning ("scanner.vala:1318: Scan complete with %d bytes of unused data", _tmp29_);
#line 11508 "scanner.c"
		}
#line 1319 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scanner_do_complete_page (self);
#line 1320 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1320 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return;
#line 11516 "scanner.c"
	}
#line 1324 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp30_ = status;
#line 1324 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp30_ != SANE_STATUS_GOOD) {
#line 11522 "scanner.c"
		SANE_Status _tmp31_;
		const gchar* _tmp32_ = NULL;
		SANE_Status _tmp33_;
		const gchar* _tmp34_ = NULL;
#line 1326 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp31_ = status;
#line 1326 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp32_ = sane_strstatus (_tmp31_);
#line 1326 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_warning ("scanner.vala:1326: Unable to read frame from device: %s", _tmp32_);
#line 1327 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp33_ = status;
#line 1327 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp34_ = _ ("Error communicating with scanner");
#line 1327 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scanner_fail_scan (self, (gint) _tmp33_, _tmp34_);
#line 1330 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1330 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return;
#line 11543 "scanner.c"
	}
#line 1333 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	full_read = FALSE;
#line 1334 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp36_ = self->priv->n_used;
#line 1334 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp36_ == 0) {
#line 11551 "scanner.c"
		SANE_Int _tmp37_;
		guchar* _tmp38_;
		gint _tmp38__length1;
#line 1334 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp37_ = n_read;
#line 1334 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp38_ = self->priv->buffer;
#line 1334 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp38__length1 = self->priv->buffer_length1;
#line 1334 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp35_ = _tmp37_ == ((SANE_Int) _tmp38__length1);
#line 11563 "scanner.c"
	} else {
#line 1334 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp35_ = FALSE;
#line 11567 "scanner.c"
	}
#line 1334 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp39_ = _tmp35_;
#line 1334 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp39_) {
#line 1335 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		full_read = TRUE;
#line 11575 "scanner.c"
	}
#line 1336 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp40_ = self->priv->n_used;
#line 1336 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp41_ = n_read;
#line 1336 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->n_used = _tmp40_ + ((gint) _tmp41_);
#line 1339 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp42_ = self->priv->n_used;
#line 1339 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp43_ = self->priv->parameters;
#line 1339 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp44_ = _tmp43_.bytes_per_line;
#line 1339 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp42_ >= _tmp44_) {
#line 11591 "scanner.c"
		ScanLine* _tmp45_;
		ScanLine* line;
		SANE_Parameters _tmp46_;
		SANE_Frame _tmp47_;
		ScanLine* _tmp53_;
		SANE_Parameters _tmp54_;
		gint _tmp55_;
		ScanLine* _tmp56_;
		SANE_Parameters _tmp57_;
		gint _tmp58_;
		ScanLine* _tmp59_;
		guchar* _tmp60_;
		gint _tmp60__length1;
		ScanLine* _tmp61_;
		SANE_Parameters _tmp62_;
		gint _tmp63_;
		ScanLine* _tmp64_;
		gint _tmp65_;
		ScanLine* _tmp66_;
		gint _tmp67_;
		ScanLine* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		ScanLine* _tmp71_;
		gint _tmp72_;
		guchar* _tmp73_;
		gint _tmp73__length1;
		gint buffer_size;
		gboolean _tmp74_;
		gint _tmp78_;
		guchar* _tmp79_ = NULL;
		gint _tmp80_;
		ScanLine* _tmp81_;
		gint _tmp82_;
		ScanLine* _tmp83_;
		gint _tmp84_;
		gint n_remaining;
		gboolean _tmp102_ = FALSE;
		gboolean _tmp103_ = FALSE;
		gboolean _tmp104_ = FALSE;
		SANE_Parameters _tmp105_;
		gint _tmp106_;
		gboolean _tmp109_;
		gboolean _tmp112_;
		gboolean _tmp115_;
		ScanJob* _tmp160_;
		gint _tmp161_;
		ScanLine* _tmp162_;
		NotifyGotLine* _tmp163_;
		NotifyGotLine* _tmp164_;
#line 1341 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp45_ = scan_line_new ();
#line 1341 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		line = _tmp45_;
#line 1342 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp46_ = self->priv->parameters;
#line 1342 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp47_ = _tmp46_.format;
#line 1342 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		switch (_tmp47_) {
#line 1342 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			case SANE_FRAME_GRAY:
#line 11654 "scanner.c"
			{
				ScanLine* _tmp48_;
#line 1345 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp48_ = line;
#line 1345 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp48_->channel = 0;
#line 1346 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				break;
#line 11663 "scanner.c"
			}
#line 1342 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			case SANE_FRAME_RGB:
#line 11667 "scanner.c"
			{
				ScanLine* _tmp49_;
#line 1348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp49_ = line;
#line 1348 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp49_->channel = -1;
#line 1349 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				break;
#line 11676 "scanner.c"
			}
#line 1342 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			case SANE_FRAME_RED:
#line 11680 "scanner.c"
			{
				ScanLine* _tmp50_;
#line 1351 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp50_ = line;
#line 1351 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp50_->channel = 0;
#line 1352 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				break;
#line 11689 "scanner.c"
			}
#line 1342 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			case SANE_FRAME_GREEN:
#line 11693 "scanner.c"
			{
				ScanLine* _tmp51_;
#line 1354 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp51_ = line;
#line 1354 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp51_->channel = 1;
#line 1355 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				break;
#line 11702 "scanner.c"
			}
#line 1342 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			case SANE_FRAME_BLUE:
#line 11706 "scanner.c"
			{
				ScanLine* _tmp52_;
#line 1357 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp52_ = line;
#line 1357 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp52_->channel = 2;
#line 1358 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				break;
#line 11715 "scanner.c"
			}
			default:
#line 1342 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 11720 "scanner.c"
		}
#line 1360 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp53_ = line;
#line 1360 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp54_ = self->priv->parameters;
#line 1360 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp55_ = _tmp54_.pixels_per_line;
#line 1360 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp53_->width = _tmp55_;
#line 1361 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp56_ = line;
#line 1361 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp57_ = self->priv->parameters;
#line 1361 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp58_ = _tmp57_.depth;
#line 1361 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp56_->depth = _tmp58_;
#line 1362 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp59_ = line;
#line 1362 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp60_ = self->priv->buffer;
#line 1362 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp60__length1 = self->priv->buffer_length1;
#line 1362 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->buffer = NULL;
#line 1362 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp59_->data = (g_free (_tmp59_->data), NULL);
#line 1362 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp59_->data = _tmp60_;
#line 1362 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp59_->data_length1 = _tmp60__length1;
#line 1363 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp61_ = line;
#line 1363 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp62_ = self->priv->parameters;
#line 1363 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp63_ = _tmp62_.bytes_per_line;
#line 1363 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp61_->data_length = _tmp63_;
#line 1364 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp64_ = line;
#line 1364 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp65_ = self->priv->line_count;
#line 1364 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp64_->number = _tmp65_;
#line 1365 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp66_ = line;
#line 1365 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp67_ = self->priv->n_used;
#line 1365 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp68_ = line;
#line 1365 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp69_ = _tmp68_->data_length;
#line 1365 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp66_->n_lines = _tmp67_ / _tmp69_;
#line 1367 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp70_ = self->priv->line_count;
#line 1367 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp71_ = line;
#line 1367 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp72_ = _tmp71_->n_lines;
#line 1367 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->line_count = _tmp70_ + _tmp72_;
#line 1370 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp73_ = self->priv->buffer;
#line 1370 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp73__length1 = self->priv->buffer_length1;
#line 1370 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		buffer_size = _tmp73__length1;
#line 1371 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp74_ = full_read;
#line 1371 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp74_) {
#line 11794 "scanner.c"
			gint _tmp75_;
			SANE_Parameters _tmp76_;
			gint _tmp77_;
#line 1372 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp75_ = buffer_size;
#line 1372 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp76_ = self->priv->parameters;
#line 1372 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp77_ = _tmp76_.bytes_per_line;
#line 1372 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			buffer_size = _tmp75_ + _tmp77_;
#line 11806 "scanner.c"
		}
#line 1374 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp78_ = buffer_size;
#line 1374 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp79_ = g_new0 (guchar, _tmp78_);
#line 1374 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 1374 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->buffer = _tmp79_;
#line 1374 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->buffer_length1 = _tmp78_;
#line 1374 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 1375 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp80_ = self->priv->n_used;
#line 1375 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp81_ = line;
#line 1375 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp82_ = _tmp81_->n_lines;
#line 1375 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp83_ = line;
#line 1375 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp84_ = _tmp83_->data_length;
#line 1375 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		n_remaining = _tmp80_ - (_tmp82_ * _tmp84_);
#line 1376 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->n_used = 0;
#line 11834 "scanner.c"
		{
			gint i;
#line 1377 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			i = 0;
#line 11839 "scanner.c"
			{
				gboolean _tmp85_;
#line 1377 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp85_ = TRUE;
#line 1377 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				while (TRUE) {
#line 11846 "scanner.c"
					gboolean _tmp86_;
					gint _tmp88_;
					gint _tmp89_;
					guchar* _tmp90_;
					gint _tmp90__length1;
					gint _tmp91_;
					ScanLine* _tmp92_;
					guchar* _tmp93_;
					gint _tmp93__length1;
					gint _tmp94_;
					ScanLine* _tmp95_;
					gint _tmp96_;
					ScanLine* _tmp97_;
					gint _tmp98_;
					guchar _tmp99_;
					guchar _tmp100_;
					gint _tmp101_;
#line 1377 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp86_ = _tmp85_;
#line 1377 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					if (!_tmp86_) {
#line 11868 "scanner.c"
						gint _tmp87_;
#line 1377 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp87_ = i;
#line 1377 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						i = _tmp87_ + 1;
#line 11874 "scanner.c"
					}
#line 1377 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp85_ = FALSE;
#line 1377 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp88_ = i;
#line 1377 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp89_ = n_remaining;
#line 1377 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					if (!(_tmp88_ < _tmp89_)) {
#line 1377 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						break;
#line 11886 "scanner.c"
					}
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp90_ = self->priv->buffer;
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp90__length1 = self->priv->buffer_length1;
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp91_ = i;
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp92_ = line;
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp93_ = _tmp92_->data;
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp93__length1 = _tmp92_->data_length1;
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp94_ = i;
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp95_ = line;
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp96_ = _tmp95_->n_lines;
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp97_ = line;
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp98_ = _tmp97_->data_length;
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp99_ = _tmp93_[_tmp94_ + (_tmp96_ * _tmp98_)];
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp90_[_tmp91_] = _tmp99_;
#line 1379 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp100_ = _tmp90_[_tmp91_];
#line 1380 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp101_ = self->priv->n_used;
#line 1380 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					self->priv->n_used = _tmp101_ + 1;
#line 11920 "scanner.c"
				}
			}
		}
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp105_ = self->priv->parameters;
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp106_ = _tmp105_.depth;
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp106_ == 8) {
#line 11930 "scanner.c"
			SANE_Parameters _tmp107_;
			SANE_Frame _tmp108_;
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp107_ = self->priv->parameters;
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp108_ = _tmp107_.format;
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp104_ = _tmp108_ == SANE_FRAME_GRAY;
#line 11939 "scanner.c"
		} else {
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp104_ = FALSE;
#line 11943 "scanner.c"
		}
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp109_ = _tmp104_;
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp109_) {
#line 11949 "scanner.c"
			ScanJob* _tmp110_;
			gint _tmp111_;
#line 1386 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp110_ = job;
#line 1386 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp111_ = _tmp110_->depth;
#line 1386 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp103_ = _tmp111_ == 2;
#line 11958 "scanner.c"
		} else {
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp103_ = FALSE;
#line 11962 "scanner.c"
		}
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp112_ = _tmp103_;
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp112_) {
#line 11968 "scanner.c"
			ScanJob* _tmp113_;
			ScanMode _tmp114_;
#line 1386 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp113_ = job;
#line 1386 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp114_ = _tmp113_->scan_mode;
#line 1386 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp102_ = _tmp114_ == SCAN_MODE_GRAY;
#line 11977 "scanner.c"
		} else {
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp102_ = FALSE;
#line 11981 "scanner.c"
		}
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp115_ = _tmp102_;
#line 1385 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_tmp115_) {
#line 11987 "scanner.c"
			guchar block;
			gint write_offset;
			gint block_shift;
			ScanLine* _tmp157_;
			ScanLine* _tmp158_;
			gint _tmp159_;
#line 1388 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			block = (guchar) 0;
#line 1389 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			write_offset = 0;
#line 1390 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			block_shift = 6;
#line 12000 "scanner.c"
			{
				gint i;
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				i = 0;
#line 12005 "scanner.c"
				{
					gboolean _tmp116_;
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					_tmp116_ = TRUE;
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					while (TRUE) {
#line 12012 "scanner.c"
						gboolean _tmp117_;
						gint _tmp119_;
						ScanLine* _tmp120_;
						gint _tmp121_;
						gint _tmp122_;
						ScanLine* _tmp123_;
						gint _tmp124_;
						gint offset;
						gint _tmp150_;
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp117_ = _tmp116_;
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (!_tmp117_) {
#line 12026 "scanner.c"
							gint _tmp118_;
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp118_ = i;
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							i = _tmp118_ + 1;
#line 12032 "scanner.c"
						}
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp116_ = FALSE;
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp119_ = i;
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp120_ = line;
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp121_ = _tmp120_->n_lines;
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (!(_tmp119_ < _tmp121_)) {
#line 1391 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							break;
#line 12046 "scanner.c"
						}
#line 1393 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp122_ = i;
#line 1393 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp123_ = line;
#line 1393 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp124_ = _tmp123_->data_length;
#line 1393 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						offset = _tmp122_ * _tmp124_;
#line 12056 "scanner.c"
						{
							gint x;
#line 1394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							x = 0;
#line 12061 "scanner.c"
							{
								gboolean _tmp125_;
#line 1394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
								_tmp125_ = TRUE;
#line 1394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
								while (TRUE) {
#line 12068 "scanner.c"
									gboolean _tmp126_;
									gint _tmp128_;
									ScanLine* _tmp129_;
									gint _tmp130_;
									ScanLine* _tmp131_;
									guchar* _tmp132_;
									gint _tmp132__length1;
									gint _tmp133_;
									gint _tmp134_;
									guchar _tmp135_;
									guchar p;
									guchar sample = '\0';
									guchar _tmp136_;
									guchar _tmp139_;
									guchar _tmp140_;
									gint _tmp141_;
									gint _tmp142_;
#line 1394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									_tmp126_ = _tmp125_;
#line 1394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									if (!_tmp126_) {
#line 12090 "scanner.c"
										gint _tmp127_;
#line 1394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										_tmp127_ = x;
#line 1394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										x = _tmp127_ + 1;
#line 12096 "scanner.c"
									}
#line 1394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									_tmp125_ = FALSE;
#line 1394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									_tmp128_ = x;
#line 1394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									_tmp129_ = line;
#line 1394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									_tmp130_ = _tmp129_->width;
#line 1394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									if (!(_tmp128_ < _tmp130_)) {
#line 1394 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										break;
#line 12110 "scanner.c"
									}
#line 1396 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									_tmp131_ = line;
#line 1396 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									_tmp132_ = _tmp131_->data;
#line 1396 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									_tmp132__length1 = _tmp131_->data_length1;
#line 1396 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									_tmp133_ = offset;
#line 1396 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									_tmp134_ = x;
#line 1396 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									_tmp135_ = _tmp132_[_tmp133_ + _tmp134_];
#line 1396 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									p = _tmp135_;
#line 1399 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									_tmp136_ = p;
#line 1399 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									if (((gint) _tmp136_) >= 192) {
#line 1400 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										sample = (guchar) 3;
#line 12132 "scanner.c"
									} else {
										guchar _tmp137_;
#line 1401 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										_tmp137_ = p;
#line 1401 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										if (((gint) _tmp137_) >= 128) {
#line 1402 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
											sample = (guchar) 2;
#line 12141 "scanner.c"
										} else {
											guchar _tmp138_;
#line 1403 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
											_tmp138_ = p;
#line 1403 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
											if (((gint) _tmp138_) >= 64) {
#line 1404 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
												sample = (guchar) 1;
#line 12150 "scanner.c"
											} else {
#line 1406 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
												sample = (guchar) 0;
#line 12154 "scanner.c"
											}
										}
									}
#line 1408 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									_tmp139_ = block;
#line 1408 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									_tmp140_ = sample;
#line 1408 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									_tmp141_ = block_shift;
#line 1408 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									block = _tmp139_ | (_tmp140_ << _tmp141_);
#line 1409 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									_tmp142_ = block_shift;
#line 1409 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
									if (_tmp142_ == 0) {
#line 12170 "scanner.c"
										ScanLine* _tmp143_;
										guchar* _tmp144_;
										gint _tmp144__length1;
										gint _tmp145_;
										guchar _tmp146_;
										guchar _tmp147_;
										gint _tmp148_;
#line 1411 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										_tmp143_ = line;
#line 1411 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										_tmp144_ = _tmp143_->data;
#line 1411 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										_tmp144__length1 = _tmp143_->data_length1;
#line 1411 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										_tmp145_ = write_offset;
#line 1411 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										_tmp146_ = block;
#line 1411 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										_tmp144_[_tmp145_] = _tmp146_;
#line 1411 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										_tmp147_ = _tmp144_[_tmp145_];
#line 1412 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										_tmp148_ = write_offset;
#line 1412 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										write_offset = _tmp148_ + 1;
#line 1413 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										block = (guchar) 0;
#line 1414 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										block_shift = 6;
#line 12200 "scanner.c"
									} else {
										gint _tmp149_;
#line 1417 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										_tmp149_ = block_shift;
#line 1417 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
										block_shift = _tmp149_ - 2;
#line 12207 "scanner.c"
									}
								}
							}
						}
#line 1421 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						_tmp150_ = block_shift;
#line 1421 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
						if (_tmp150_ != 6) {
#line 12216 "scanner.c"
							ScanLine* _tmp151_;
							guchar* _tmp152_;
							gint _tmp152__length1;
							gint _tmp153_;
							guchar _tmp154_;
							guchar _tmp155_;
							gint _tmp156_;
#line 1423 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp151_ = line;
#line 1423 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp152_ = _tmp151_->data;
#line 1423 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp152__length1 = _tmp151_->data_length1;
#line 1423 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp153_ = write_offset;
#line 1423 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp154_ = block;
#line 1423 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp152_[_tmp153_] = _tmp154_;
#line 1423 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp155_ = _tmp152_[_tmp153_];
#line 1424 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							_tmp156_ = write_offset;
#line 1424 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							write_offset = _tmp156_ + 1;
#line 1425 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							block = (guchar) 0;
#line 1426 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
							block_shift = 6;
#line 12246 "scanner.c"
						}
					}
				}
			}
#line 1430 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp157_ = line;
#line 1430 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp158_ = line;
#line 1430 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp159_ = _tmp158_->width;
#line 1430 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp157_->data_length = ((_tmp159_ * 2) + 7) / 8;
#line 12259 "scanner.c"
		}
#line 1433 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp160_ = job;
#line 1433 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp161_ = _tmp160_->id;
#line 1433 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp162_ = line;
#line 1433 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp163_ = notify_got_line_new (_tmp161_, _tmp162_);
#line 1433 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp164_ = _tmp163_;
#line 1433 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp164_);
#line 1433 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_notify_unref0 (_tmp164_);
#line 1339 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_scan_line_unref0 (line);
#line 12277 "scanner.c"
	}
#line 1300 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_scan_job_unref0 (job);
#line 12281 "scanner.c"
}


static void _scanner_authorization_cb_sane_authcallback (const gchar* resource, gchar* username, gchar* password) {
#line 1442 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scanner_authorization_cb (resource, username, -1, password, -1);
#line 12288 "scanner.c"
}


static void* scanner_scan_thread (Scanner* self) {
	void* result = NULL;
	SANE_Int version_code = {0};
	SANE_Int _tmp0_ = {0};
	SANE_Status _tmp1_ = 0;
	SANE_Status status;
	SANE_Status _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	SANE_Status _tmp5_;
	SANE_Int _tmp8_;
	gint _tmp9_ = 0;
	SANE_Int _tmp10_;
	gint _tmp11_ = 0;
	SANE_Int _tmp12_;
	gint _tmp13_ = 0;
#line 1437 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1439 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 1442 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = sane_init (&_tmp0_, _scanner_authorization_cb_sane_authcallback);
#line 1442 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	version_code = _tmp0_;
#line 1442 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	status = _tmp1_;
#line 1443 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = status;
#line 1443 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = sane_status_to_string (_tmp2_);
#line 1443 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = _tmp3_;
#line 1443 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:1443: sane_init () -> %s", _tmp4_);
#line 1443 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp4_);
#line 1444 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = status;
#line 1444 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp5_ != SANE_STATUS_GOOD) {
#line 12332 "scanner.c"
		SANE_Status _tmp6_;
		const gchar* _tmp7_ = NULL;
#line 1446 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp6_ = status;
#line 1446 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp7_ = sane_strstatus (_tmp6_);
#line 1446 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_warning ("scanner.vala:1446: Unable to initialize SANE backend: %s", _tmp7_);
#line 1447 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		result = NULL;
#line 1447 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return result;
#line 12345 "scanner.c"
	}
#line 1449 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp8_ = version_code;
#line 1449 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp9_ = SANE_VERSION_MAJOR (_tmp8_);
#line 1449 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp10_ = version_code;
#line 1449 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp11_ = SANE_VERSION_MINOR (_tmp10_);
#line 1449 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp12_ = version_code;
#line 1449 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp13_ = SANE_VERSION_BUILD (_tmp12_);
#line 1449 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:1449: SANE version %d.%d.%d", _tmp9_, _tmp11_, _tmp13_);
#line 1455 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scanner_redetect (self);
#line 1457 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	while (TRUE) {
#line 12365 "scanner.c"
		gboolean _tmp14_ = FALSE;
		ScanState _tmp15_;
#line 1457 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp14_ = scanner_handle_requests (self);
#line 1457 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (!_tmp14_) {
#line 1457 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 12374 "scanner.c"
		}
#line 1459 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp15_ = self->priv->state;
#line 1459 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		switch (_tmp15_) {
#line 1459 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			case SCAN_STATE_IDLE:
#line 12382 "scanner.c"
			{
				GList* _tmp16_;
#line 1462 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				_tmp16_ = self->priv->job_queue;
#line 1462 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				if (_tmp16_ != NULL) {
#line 1464 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					scanner_set_scanning (self, TRUE);
#line 1465 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
					self->priv->state = SCAN_STATE_OPEN;
#line 12393 "scanner.c"
				}
#line 1467 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				break;
#line 12397 "scanner.c"
			}
#line 1459 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			case SCAN_STATE_REDETECT:
#line 12401 "scanner.c"
			{
#line 1469 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_do_redetect (self);
#line 1470 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				break;
#line 12407 "scanner.c"
			}
#line 1459 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			case SCAN_STATE_OPEN:
#line 12411 "scanner.c"
			{
#line 1472 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_do_open (self);
#line 1473 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				break;
#line 12417 "scanner.c"
			}
#line 1459 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			case SCAN_STATE_GET_OPTION:
#line 12421 "scanner.c"
			{
#line 1475 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_do_get_option (self);
#line 1476 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				break;
#line 12427 "scanner.c"
			}
#line 1459 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			case SCAN_STATE_START:
#line 12431 "scanner.c"
			{
#line 1478 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_do_start (self);
#line 1479 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				break;
#line 12437 "scanner.c"
			}
#line 1459 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			case SCAN_STATE_GET_PARAMETERS:
#line 12441 "scanner.c"
			{
#line 1481 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_do_get_parameters (self);
#line 1482 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				break;
#line 12447 "scanner.c"
			}
#line 1459 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			case SCAN_STATE_READ:
#line 12451 "scanner.c"
			{
#line 1484 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				scanner_do_read (self);
#line 1485 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
				break;
#line 12457 "scanner.c"
			}
			default:
#line 1459 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			break;
#line 12462 "scanner.c"
		}
	}
#line 1489 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	result = NULL;
#line 1489 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return result;
#line 12469 "scanner.c"
}


static gpointer _scanner_scan_thread_gthread_func (gpointer self) {
	gpointer result;
	result = scanner_scan_thread (self);
#line 1496 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scanner_unref (self);
#line 1496 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return result;
#line 12480 "scanner.c"
}


void scanner_start (Scanner* self) {
	GError * _inner_error_ = NULL;
#line 1492 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 12488 "scanner.c"
	{
		GThread* _tmp0_;
		GThread* _tmp1_;
#line 1496 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp0_ = g_thread_try_new ("scan-thread", _scanner_scan_thread_gthread_func, scanner_ref (self), &_inner_error_);
#line 1496 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp1_ = _tmp0_;
#line 1496 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (_inner_error_ != NULL) {
#line 12498 "scanner.c"
			goto __catch15_g_error;
		}
#line 1496 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_g_thread_unref0 (self->priv->thread);
#line 1496 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->thread = _tmp1_;
#line 12505 "scanner.c"
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 1494 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		e = _inner_error_;
#line 1494 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_inner_error_ = NULL;
#line 1500 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp2_ = e;
#line 1500 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp3_ = _tmp2_->message;
#line 1500 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_critical ("scanner.vala:1500: Unable to create thread: %s", _tmp3_);
#line 1494 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_g_error_free0 (e);
#line 12525 "scanner.c"
	}
	__finally15:
#line 1494 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_inner_error_ != NULL) {
#line 1494 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1494 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_clear_error (&_inner_error_);
#line 1494 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return;
#line 12536 "scanner.c"
	}
}


void scanner_redetect (Scanner* self) {
	gboolean _tmp0_;
	GAsyncQueue* _tmp1_;
	RequestRedetect* _tmp2_;
#line 1504 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1506 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = self->priv->need_redetect;
#line 1506 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp0_) {
#line 1507 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return;
#line 12553 "scanner.c"
	}
#line 1508 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->need_redetect = TRUE;
#line 1510 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:1510: Requesting redetection of scan devices");
#line 1512 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = self->priv->request_queue;
#line 1512 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = request_redetect_new ();
#line 1512 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_async_queue_push (_tmp1_, (Request*) _tmp2_);
#line 12565 "scanner.c"
}


gboolean scanner_is_scanning (Scanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 1515 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1517 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = self->priv->scanning;
#line 1517 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	result = _tmp0_;
#line 1517 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return result;
#line 12580 "scanner.c"
}


static gchar* scanner_get_scan_mode_string (Scanner* self, ScanMode mode) {
	gchar* result = NULL;
	ScanMode _tmp0_;
#line 1520 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1522 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = mode;
#line 1522 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	switch (_tmp0_) {
#line 1522 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SCAN_MODE_DEFAULT:
#line 12595 "scanner.c"
		{
			gchar* _tmp1_;
#line 1525 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp1_ = g_strdup ("ScanMode.DEFAULT");
#line 1525 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			result = _tmp1_;
#line 1525 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return result;
#line 12604 "scanner.c"
		}
#line 1522 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SCAN_MODE_COLOR:
#line 12608 "scanner.c"
		{
			gchar* _tmp2_;
#line 1527 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp2_ = g_strdup ("ScanMode.COLOR");
#line 1527 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			result = _tmp2_;
#line 1527 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return result;
#line 12617 "scanner.c"
		}
#line 1522 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SCAN_MODE_GRAY:
#line 12621 "scanner.c"
		{
			gchar* _tmp3_;
#line 1529 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp3_ = g_strdup ("ScanMode.GRAY");
#line 1529 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			result = _tmp3_;
#line 1529 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return result;
#line 12630 "scanner.c"
		}
#line 1522 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SCAN_MODE_LINEART:
#line 12634 "scanner.c"
		{
			gchar* _tmp4_;
#line 1531 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp4_ = g_strdup ("ScanMode.LINEART");
#line 1531 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			result = _tmp4_;
#line 1531 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return result;
#line 12643 "scanner.c"
		}
		default:
		{
			ScanMode _tmp5_;
			gchar* _tmp6_ = NULL;
#line 1533 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp5_ = mode;
#line 1533 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp6_ = g_strdup_printf ("%d", (gint) _tmp5_);
#line 1533 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			result = _tmp6_;
#line 1533 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return result;
#line 12657 "scanner.c"
		}
	}
}


static gchar* scanner_get_scan_type_string (Scanner* self, ScanType type) {
	gchar* result = NULL;
	ScanType _tmp0_;
#line 1537 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1539 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = type;
#line 1539 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	switch (_tmp0_) {
#line 1539 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SCAN_TYPE_SINGLE:
#line 12674 "scanner.c"
		{
			gchar* _tmp1_;
#line 1542 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp1_ = g_strdup ("ScanType.SINGLE");
#line 1542 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			result = _tmp1_;
#line 1542 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return result;
#line 12683 "scanner.c"
		}
#line 1539 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SCAN_TYPE_ADF_FRONT:
#line 12687 "scanner.c"
		{
			gchar* _tmp2_;
#line 1544 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp2_ = g_strdup ("ScanType.ADF_FRONT");
#line 1544 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			result = _tmp2_;
#line 1544 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return result;
#line 12696 "scanner.c"
		}
#line 1539 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SCAN_TYPE_ADF_BACK:
#line 12700 "scanner.c"
		{
			gchar* _tmp3_;
#line 1546 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp3_ = g_strdup ("ScanType.ADF_BACK");
#line 1546 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			result = _tmp3_;
#line 1546 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return result;
#line 12709 "scanner.c"
		}
#line 1539 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		case SCAN_TYPE_ADF_BOTH:
#line 12713 "scanner.c"
		{
			gchar* _tmp4_;
#line 1548 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp4_ = g_strdup ("ScanType.ADF_BOTH");
#line 1548 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			result = _tmp4_;
#line 1548 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return result;
#line 12722 "scanner.c"
		}
		default:
		{
			ScanType _tmp5_;
			gchar* _tmp6_ = NULL;
#line 1550 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp5_ = type;
#line 1550 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			_tmp6_ = g_strdup_printf ("%d", (gint) _tmp5_);
#line 1550 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			result = _tmp6_;
#line 1550 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return result;
#line 12736 "scanner.c"
		}
	}
}


void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	ScanOptions* _tmp4_;
	gint _tmp5_;
	ScanOptions* _tmp6_;
	ScanMode _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	ScanOptions* _tmp10_;
	gint _tmp11_;
	ScanOptions* _tmp12_;
	ScanType _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	ScanOptions* _tmp16_;
	gint _tmp17_;
	ScanOptions* _tmp18_;
	gint _tmp19_;
	ScanOptions* _tmp20_;
	gint _tmp21_;
	ScanOptions* _tmp22_;
	gint _tmp23_;
	RequestStartScan* _tmp24_;
	RequestStartScan* request;
	ScanJob* _tmp25_;
	ScanJob* _tmp26_;
	gint _tmp27_;
	ScanJob* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	ScanJob* _tmp31_;
	ScanOptions* _tmp32_;
	gint _tmp33_;
	ScanJob* _tmp34_;
	ScanOptions* _tmp35_;
	ScanMode _tmp36_;
	ScanJob* _tmp37_;
	ScanOptions* _tmp38_;
	gint _tmp39_;
	ScanJob* _tmp40_;
	ScanOptions* _tmp41_;
	ScanType _tmp42_;
	ScanJob* _tmp43_;
	ScanOptions* _tmp44_;
	gint _tmp45_;
	ScanJob* _tmp46_;
	ScanOptions* _tmp47_;
	gint _tmp48_;
	ScanJob* _tmp49_;
	ScanOptions* _tmp50_;
	gint _tmp51_;
	ScanJob* _tmp52_;
	ScanOptions* _tmp53_;
	gint _tmp54_;
	GAsyncQueue* _tmp55_;
	Request* _tmp56_;
#line 1554 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1554 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (options != NULL);
#line 1557 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = device;
#line 1557 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp1_ != NULL) {
#line 12808 "scanner.c"
		const gchar* _tmp2_;
#line 1557 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp2_ = device;
#line 1557 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp0_ = _tmp2_;
#line 12814 "scanner.c"
	} else {
#line 1557 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp0_ = "(null)";
#line 12818 "scanner.c"
	}
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp3_ = _tmp0_;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp4_ = options;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp5_ = _tmp4_->dpi;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp6_ = options;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp7_ = _tmp6_->scan_mode;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp8_ = scanner_get_scan_mode_string (self, _tmp7_);
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp9_ = _tmp8_;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp10_ = options;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp11_ = _tmp10_->depth;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp12_ = options;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp13_ = _tmp12_->type;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp14_ = scanner_get_scan_type_string (self, _tmp13_);
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp15_ = _tmp14_;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp16_ = options;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp17_ = _tmp16_->paper_width;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp18_ = options;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp19_ = _tmp18_->paper_height;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp20_ = options;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp21_ = _tmp20_->brightness;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp22_ = options;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp23_ = _tmp22_->contrast;
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:1556: Scanner.scan (\"%s\", dpi=%d, scan_mode=%s, depth=%" \
"d, type=%s, paper_width=%d, paper_height=%d, brightness=%d, contrast=%" \
"d)", _tmp3_, _tmp5_, _tmp9_, _tmp11_, _tmp15_, _tmp17_, _tmp19_, _tmp21_, _tmp23_);
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp15_);
#line 1556 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp9_);
#line 1560 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp24_ = request_start_scan_new ();
#line 1560 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	request = _tmp24_;
#line 1561 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp25_ = scan_job_new ();
#line 1561 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_scan_job_unref0 (request->job);
#line 1561 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	request->job = _tmp25_;
#line 1562 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp26_ = request->job;
#line 1562 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp27_ = self->job_id;
#line 1562 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->job_id = _tmp27_ + 1;
#line 1562 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp26_->id = _tmp27_;
#line 1563 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp28_ = request->job;
#line 1563 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp29_ = device;
#line 1563 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp30_ = g_strdup (_tmp29_);
#line 1563 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (_tmp28_->device);
#line 1563 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp28_->device = _tmp30_;
#line 1564 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp31_ = request->job;
#line 1564 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp32_ = options;
#line 1564 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp33_ = _tmp32_->dpi;
#line 1564 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp31_->dpi = (gdouble) _tmp33_;
#line 1565 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp34_ = request->job;
#line 1565 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp35_ = options;
#line 1565 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp36_ = _tmp35_->scan_mode;
#line 1565 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp34_->scan_mode = _tmp36_;
#line 1566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp37_ = request->job;
#line 1566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp38_ = options;
#line 1566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp39_ = _tmp38_->depth;
#line 1566 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp37_->depth = _tmp39_;
#line 1567 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp40_ = request->job;
#line 1567 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp41_ = options;
#line 1567 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp42_ = _tmp41_->type;
#line 1567 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp40_->type = _tmp42_;
#line 1568 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp43_ = request->job;
#line 1568 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp44_ = options;
#line 1568 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp45_ = _tmp44_->paper_width;
#line 1568 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp43_->page_width = _tmp45_;
#line 1569 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp46_ = request->job;
#line 1569 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp47_ = options;
#line 1569 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp48_ = _tmp47_->paper_height;
#line 1569 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp46_->page_height = _tmp48_;
#line 1570 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp49_ = request->job;
#line 1570 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp50_ = options;
#line 1570 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp51_ = _tmp50_->brightness;
#line 1570 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp49_->brightness = _tmp51_;
#line 1571 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp52_ = request->job;
#line 1571 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp53_ = options;
#line 1571 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp54_ = _tmp53_->contrast;
#line 1571 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp52_->contrast = _tmp54_;
#line 1572 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp55_ = self->priv->request_queue;
#line 1572 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp56_ = _request_ref0 ((Request*) request);
#line 1572 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_async_queue_push (_tmp55_, _tmp56_);
#line 1554 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_request_unref0 (request);
#line 12968 "scanner.c"
}


void scanner_cancel (Scanner* self) {
	gint _tmp0_;
	GAsyncQueue* _tmp1_;
	RequestCancel* _tmp2_;
#line 1575 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1577 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = self->job_id;
#line 1577 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->first_job_id = _tmp0_;
#line 1578 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = self->priv->request_queue;
#line 1578 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = request_cancel_new ();
#line 1578 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_async_queue_push (_tmp1_, (Request*) _tmp2_);
#line 12988 "scanner.c"
}


void scanner_free (Scanner* self) {
	GAsyncQueue* _tmp0_;
	RequestQuit* _tmp1_;
	GThread* _tmp2_;
#line 1581 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1583 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:1583: Stopping scan thread");
#line 1585 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp0_ = self->priv->request_queue;
#line 1585 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp1_ = request_quit_new ();
#line 1585 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_async_queue_push (_tmp0_, (Request*) _tmp1_);
#line 1587 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_tmp2_ = self->priv->thread;
#line 1587 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (_tmp2_ != NULL) {
#line 13010 "scanner.c"
		GThread* _tmp3_;
#line 1589 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_tmp3_ = self->priv->thread;
#line 1589 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_thread_join (_tmp3_);
#line 1590 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		_g_thread_unref0 (self->priv->thread);
#line 1590 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		self->priv->thread = NULL;
#line 13020 "scanner.c"
	}
#line 1593 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	sane_exit ();
#line 1594 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_debug ("scanner.vala:1594: sane_exit ()");
#line 13026 "scanner.c"
}


static void g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__SCAN_PAGE_INFO) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__SCAN_PAGE_INFO callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (n_param_values == 2);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		data1 = closure->data;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		data2 = param_values->data[0].v_pointer;
#line 13045 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		data1 = param_values->data[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		data2 = closure->data;
#line 13051 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	callback = (GMarshalFunc_VOID__SCAN_PAGE_INFO) (marshal_data ? marshal_data : cc->callback);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	callback (data1, value_get_scan_page_info (param_values + 1), data2);
#line 13057 "scanner.c"
}


static void g_cclosure_user_marshal_VOID__SCAN_LINE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__SCAN_LINE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__SCAN_LINE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (n_param_values == 2);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		data1 = closure->data;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		data2 = param_values->data[0].v_pointer;
#line 13076 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		data1 = param_values->data[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		data2 = closure->data;
#line 13082 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	callback = (GMarshalFunc_VOID__SCAN_LINE) (marshal_data ? marshal_data : cc->callback);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	callback (data1, value_get_scan_line (param_values + 1), data2);
#line 13088 "scanner.c"
}


static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_STRING) (gpointer data1, gint arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (n_param_values == 3);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		data1 = closure->data;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		data2 = param_values->data[0].v_pointer;
#line 13107 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		data1 = param_values->data[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		data2 = closure->data;
#line 13113 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	callback = (GMarshalFunc_VOID__INT_STRING) (marshal_data ? marshal_data : cc->callback);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_string (param_values + 2), data2);
#line 13119 "scanner.c"
}


static void value_scanner_init (GValue* value) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 13126 "scanner.c"
}


static void value_scanner_free_value (GValue* value) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scanner_unref (value->data[0].v_pointer);
#line 13135 "scanner.c"
	}
}


static void value_scanner_copy_value (const GValue* src_value, GValue* dest_value) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = scanner_ref (src_value->data[0].v_pointer);
#line 13145 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 13149 "scanner.c"
	}
}


static gpointer value_scanner_peek_pointer (const GValue* value) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 13157 "scanner.c"
}


static gchar* value_scanner_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 13164 "scanner.c"
		Scanner* object;
		object = collect_values[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 13171 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 13175 "scanner.c"
		}
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = scanner_ref (object);
#line 13179 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 13183 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 13187 "scanner.c"
}


static gchar* value_scanner_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Scanner** object_p;
	object_p = collect_values[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!object_p) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 13198 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = NULL;
#line 13204 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 13208 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		*object_p = scanner_ref (value->data[0].v_pointer);
#line 13212 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return NULL;
#line 13216 "scanner.c"
}


GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanner* spec;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCANNER), NULL);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 13230 "scanner.c"
}


gpointer value_get_scanner (const GValue* value) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER), NULL);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return value->data[0].v_pointer;
#line 13239 "scanner.c"
}


void value_set_scanner (GValue* value, gpointer v_object) {
	Scanner* old;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER));
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCANNER));
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scanner_ref (value->data[0].v_pointer);
#line 13259 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 13263 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scanner_unref (old);
#line 13269 "scanner.c"
	}
}


void value_take_scanner (GValue* value, gpointer v_object) {
	Scanner* old;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER));
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (v_object) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCANNER));
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 13288 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 13292 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (old) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		scanner_unref (old);
#line 13298 "scanner.c"
	}
}


static void scanner_class_init (ScannerClass * klass) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	scanner_parent_class = g_type_class_peek_parent (klass);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	SCANNER_CLASS (klass)->finalize = scanner_finalize;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (ScannerPrivate));
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_signal_new ("update_devices", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_signal_new ("request_authorization", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_signal_new ("expect_page", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_signal_new ("got_page_info", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO, G_TYPE_NONE, 1, TYPE_SCAN_PAGE_INFO);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_signal_new ("got_line", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__SCAN_LINE, G_TYPE_NONE, 1, TYPE_SCAN_LINE);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_signal_new ("scan_failed", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_STRING, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_STRING);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_signal_new ("page_done", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_signal_new ("document_done", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_signal_new ("scanning_changed", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13328 "scanner.c"
}


static void scanner_instance_init (Scanner * self) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv = SCANNER_GET_PRIVATE (self);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->ref_count = 1;
#line 13337 "scanner.c"
}


static void scanner_finalize (Scanner* obj) {
	Scanner * self;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCANNER, Scanner);
#line 214 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_thread_unref0 (self->priv->thread);
#line 217 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->request_queue);
#line 220 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->notify_queue);
#line 223 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->authorize_queue);
#line 229 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (self->priv->default_device);
#line 234 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	__g_list_free__scan_job_unref0_0 (self->priv->job_queue);
#line 239 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_free0 (self->priv->current_device);
#line 247 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	_g_hash_table_unref0 (self->priv->options);
#line 250 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 13363 "scanner.c"
}


GType scanner_get_type (void) {
	static volatile gsize scanner_type_id__volatile = 0;
	if (g_once_init_enter (&scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scanner_init, value_scanner_free_value, value_scanner_copy_value, value_scanner_peek_pointer, "p", value_scanner_collect_value, "p", value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Scanner), 0, (GInstanceInitFunc) scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scanner_type_id;
		scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Scanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scanner_type_id__volatile, scanner_type_id);
	}
	return scanner_type_id__volatile;
}


gpointer scanner_ref (gpointer instance) {
	Scanner* self;
	self = instance;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	return instance;
#line 13388 "scanner.c"
}


void scanner_unref (gpointer instance) {
	Scanner* self;
	self = instance;
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		SCANNER_GET_CLASS (self)->finalize (self);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 13401 "scanner.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



