/* This file is part of the SpeedCrunch project
   Copyright (C) 2004 Ariya Hidayat <ariya@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "insertfunctiondlg.h"
#include "functions.h"
#include "settings.h"

#include <qdialog.h>
#include <qlayout.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qtimer.h>

class InsertFunctionDlg::Private
{
public:
  QListView* functionList;
  QPushButton* insertButton;
  QPushButton* cancelButton;
};

InsertFunctionDlg::InsertFunctionDlg( QWidget* parent, const char* name ): 
QDialog( parent, name )
{
  d = new Private;
  
  QGridLayout* layout = new QGridLayout( this, 2, 3, 6, 6 );

  d->functionList = new QListView( this );
  d->functionList->addColumn( tr("Name") );
  d->functionList->addColumn( tr("Description") );
  d->functionList->setResizeMode( QListView::LastColumn );
  d->functionList->setAllColumnsShowFocus( true );
    
  d->insertButton = new QPushButton( tr("&Insert"), this );
  d->cancelButton = new QPushButton( tr("Cancel"), this );

  layout->addMultiCellWidget( d->functionList, 0, 0, 1, 3 );  
  layout->addItem( new QSpacerItem( 20, 20, QSizePolicy::Expanding ), 1, 1 );  
  layout->addWidget( d->insertButton, 1, 2 );
  layout->addWidget( d->cancelButton, 1, 3 );
  
  d->insertButton->setDefault( true );
  
  connect( d->insertButton, SIGNAL( clicked() ), this, SLOT( accept() ) );
  connect( d->cancelButton, SIGNAL( clicked() ), this, SLOT( reject() ) );
  connect( d->functionList, SIGNAL( returnPressed( QListViewItem* ) ), this, SLOT( accept() ) );
  connect( d->functionList, SIGNAL( doubleClicked( QListViewItem*, const QPoint&, int ) ), 
    this, SLOT( accept() ) );
    
  QStringList functionNames = FunctionRepository::self()->functionNames();
  for( unsigned i = 0; i < functionNames.count(); i++ )
  {
    Function* f = FunctionRepository::self()->function( functionNames[i] );
    if( f ) new QListViewItem( d->functionList, f->name(), f->description() );
  }
  
  d->functionList->setFocus();
  setCaption( tr("Insert Function") );
  
  QTimer::singleShot( 0, this, SLOT( initUI() ) );  
}

InsertFunctionDlg::~InsertFunctionDlg()
{
  delete d;
}

QString InsertFunctionDlg::functionName() const
{
  QListViewItem* item = d->functionList->selectedItem();
  return item ? item->text(0).lower() : QString::null;
}

void InsertFunctionDlg::initUI()
{
  adjustSize();
}
