AVAHIFILE=/etc/avahi/services/squid-deb-proxy.service

concat_file_from_dir() {
      # the .d directory
      DIR="$1"
      # the target file
      FILE="$2"
      # (optional) additional file append to $FILE
      ADDITIONAL_FILE_TO_CAT="$3"
      cat > $FILE <<EOF 
# WARNING: this file is auto-generated from the files in
#          $DIR
#          on squid-deb-proxy (re)start, do NOT edit here
EOF
      if [ -n "$ADDITIONAL_FILE_TO_CAT" ]; then
          cat "$ADDITIONAL_FILE_TO_CAT" >> "$FILE"
      fi

      for f in "$DIR"/*; do
          cat "$f" >> "$FILE"
      done
}

pre_start() {
  if [ -x /usr/sbin/squid ]; then
      SQUID=/usr/sbin/squid
  elif  [ -x /usr/sbin/squid3 ]; then
      SQUID=/usr/sbin/squid3
  else
      echo "No squid binary found"
      exit 1
  fi

  # ensure all cache dirs are there
  install -d -o proxy -g proxy -m 750 /var/cache/squid-deb-proxy/
  install -d -o proxy -g proxy -m 750 /var/log/squid-deb-proxy/
  if [ ! -d /var/cache/squid-deb-proxy/00 ]; then
   $SQUID -z -f /etc/squid-deb-proxy/squid-deb-proxy.conf
  fi

  # generate pkg blacklist acl file
  PKG_BLACKLIST_DIR=/etc/squid-deb-proxy/pkg-blacklist.d
  PKG_BLACKLIST=/etc/squid-deb-proxy/autogenerated/pkg-blacklist-regexp.acl
  concat_file_from_dir "$PKG_BLACKLIST_DIR" "$PKG_BLACKLIST"
  # postprocess for regexp format
  sed -i -r '/^#/d;/^$/d;s#(.*)#\/\1_.*\.deb$#g' $PKG_BLACKLIST
  # if the file is empty remove it
  if [ ! -s $PKG_BLACKLIST ]; then
    rm $PKG_BLACKLIST
  fi

  # generate mirror file
  MIRROR_DESTDOMAIN_DIR=/etc/squid-deb-proxy/mirror-dstdomain.acl.d
  MIRROR_DESTDOMAIN=/etc/squid-deb-proxy/autogenerated/mirror-dstdomain.acl
  concat_file_from_dir "$MIRROR_DESTDOMAIN_DIR" "$MIRROR_DESTDOMAIN" "/etc/squid-deb-proxy/mirror-dstdomain.acl"

  # generate the allowed-networks file
  ALLOWED_NETWORKS_DIR=/etc/squid-deb-proxy/allowed-networks-src.acl.d
  ALLOWED_NETWORKS=/etc/squid-deb-proxy/autogenerated/allowed-networks-src.acl
  concat_file_from_dir "$ALLOWED_NETWORKS_DIR" "$ALLOWED_NETWORKS" "/etc/squid-deb-proxy/allowed-networks-src.acl"
}

post_start() {
  # create avahi service
  PORT=$(grep http_port /etc/squid-deb-proxy/squid-deb-proxy.conf|cut -d' ' -f2)
  if [ -n "$PORT" ] && [ -d /etc/avahi/services/ ]; then
   cat > $AVAHIFILE << EOF
<?xml version="1.0" standalone='no'?>
<!DOCTYPE service-group SYSTEM "avahi-service.dtd">
<service-group>
	<name replace-wildcards="yes">Squid deb proxy on %h</name>
	<service protocol="ipv6">
		<type>_apt_proxy._tcp</type>
		<port>$PORT</port>
	</service>
	<service protocol="ipv4">
		<type>_apt_proxy._tcp</type>
		<port>$PORT</port>
	</service>
</service-group>
EOF
  # ensure proper permissions
  chmod 0644 $AVAHIFILE
  fi
}

post_stop() {
  if [ -f $AVAHIFILE ]
  then
  	rm $AVAHIFILE
  fi
}

# from the squid3 debian init script
find_cache_dir () {
        w="     " # space tab
        res=`sed -ne '
                s/^'$1'['"$w"']\+[^'"$w"']\+['"$w"']\+\([^'"$w"']\+\).*$/\1/p;
                t end;
                d;
                :end q' < $CONFIG`
        [ -n "$res" ] || res=$2
        echo "$res"
}

