/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ID = 258,
     HBLOCK = 259,
     POUND = 260,
     STRING = 261,
     INCLUDE = 262,
     IMPORT = 263,
     INSERT = 264,
     CHARCONST = 265,
     NUM_INT = 266,
     NUM_FLOAT = 267,
     NUM_UNSIGNED = 268,
     NUM_LONG = 269,
     NUM_ULONG = 270,
     NUM_LONGLONG = 271,
     NUM_ULONGLONG = 272,
     TYPEDEF = 273,
     TYPE_INT = 274,
     TYPE_UNSIGNED = 275,
     TYPE_SHORT = 276,
     TYPE_LONG = 277,
     TYPE_FLOAT = 278,
     TYPE_DOUBLE = 279,
     TYPE_CHAR = 280,
     TYPE_WCHAR = 281,
     TYPE_VOID = 282,
     TYPE_SIGNED = 283,
     TYPE_BOOL = 284,
     TYPE_COMPLEX = 285,
     TYPE_TYPEDEF = 286,
     TYPE_RAW = 287,
     LPAREN = 288,
     RPAREN = 289,
     COMMA = 290,
     SEMI = 291,
     EXTERN = 292,
     INIT = 293,
     LBRACE = 294,
     RBRACE = 295,
     PERIOD = 296,
     CONST_QUAL = 297,
     VOLATILE = 298,
     REGISTER = 299,
     STRUCT = 300,
     UNION = 301,
     EQUAL = 302,
     SIZEOF = 303,
     MODULE = 304,
     LBRACKET = 305,
     RBRACKET = 306,
     ILLEGAL = 307,
     CONSTANT = 308,
     NAME = 309,
     RENAME = 310,
     NAMEWARN = 311,
     EXTEND = 312,
     PRAGMA = 313,
     FEATURE = 314,
     VARARGS = 315,
     ENUM = 316,
     CLASS = 317,
     TYPENAME = 318,
     PRIVATE = 319,
     PUBLIC = 320,
     PROTECTED = 321,
     COLON = 322,
     STATIC = 323,
     VIRTUAL = 324,
     FRIEND = 325,
     THROW = 326,
     CATCH = 327,
     USING = 328,
     NAMESPACE = 329,
     NATIVE = 330,
     INLINE = 331,
     TYPEMAP = 332,
     EXCEPT = 333,
     ECHO = 334,
     APPLY = 335,
     CLEAR = 336,
     SWIGTEMPLATE = 337,
     FRAGMENT = 338,
     WARN = 339,
     LESSTHAN = 340,
     GREATERTHAN = 341,
     MODULO = 342,
     DELETE_KW = 343,
     TYPES = 344,
     PARMS = 345,
     NONID = 346,
     DSTAR = 347,
     DCNOT = 348,
     TEMPLATE = 349,
     OPERATOR = 350,
     COPERATOR = 351,
     PARSETYPE = 352,
     PARSEPARM = 353,
     CAST = 354,
     LOR = 355,
     LAND = 356,
     OR = 357,
     XOR = 358,
     AND = 359,
     RSHIFT = 360,
     LSHIFT = 361,
     MINUS = 362,
     PLUS = 363,
     SLASH = 364,
     STAR = 365,
     LNOT = 366,
     NOT = 367,
     UMINUS = 368,
     DCOLON = 369
   };
#endif
#define ID 258
#define HBLOCK 259
#define POUND 260
#define STRING 261
#define INCLUDE 262
#define IMPORT 263
#define INSERT 264
#define CHARCONST 265
#define NUM_INT 266
#define NUM_FLOAT 267
#define NUM_UNSIGNED 268
#define NUM_LONG 269
#define NUM_ULONG 270
#define NUM_LONGLONG 271
#define NUM_ULONGLONG 272
#define TYPEDEF 273
#define TYPE_INT 274
#define TYPE_UNSIGNED 275
#define TYPE_SHORT 276
#define TYPE_LONG 277
#define TYPE_FLOAT 278
#define TYPE_DOUBLE 279
#define TYPE_CHAR 280
#define TYPE_WCHAR 281
#define TYPE_VOID 282
#define TYPE_SIGNED 283
#define TYPE_BOOL 284
#define TYPE_COMPLEX 285
#define TYPE_TYPEDEF 286
#define TYPE_RAW 287
#define LPAREN 288
#define RPAREN 289
#define COMMA 290
#define SEMI 291
#define EXTERN 292
#define INIT 293
#define LBRACE 294
#define RBRACE 295
#define PERIOD 296
#define CONST_QUAL 297
#define VOLATILE 298
#define REGISTER 299
#define STRUCT 300
#define UNION 301
#define EQUAL 302
#define SIZEOF 303
#define MODULE 304
#define LBRACKET 305
#define RBRACKET 306
#define ILLEGAL 307
#define CONSTANT 308
#define NAME 309
#define RENAME 310
#define NAMEWARN 311
#define EXTEND 312
#define PRAGMA 313
#define FEATURE 314
#define VARARGS 315
#define ENUM 316
#define CLASS 317
#define TYPENAME 318
#define PRIVATE 319
#define PUBLIC 320
#define PROTECTED 321
#define COLON 322
#define STATIC 323
#define VIRTUAL 324
#define FRIEND 325
#define THROW 326
#define CATCH 327
#define USING 328
#define NAMESPACE 329
#define NATIVE 330
#define INLINE 331
#define TYPEMAP 332
#define EXCEPT 333
#define ECHO 334
#define APPLY 335
#define CLEAR 336
#define SWIGTEMPLATE 337
#define FRAGMENT 338
#define WARN 339
#define LESSTHAN 340
#define GREATERTHAN 341
#define MODULO 342
#define DELETE_KW 343
#define TYPES 344
#define PARMS 345
#define NONID 346
#define DSTAR 347
#define DCNOT 348
#define TEMPLATE 349
#define OPERATOR 350
#define COPERATOR 351
#define PARSETYPE 352
#define PARSEPARM 353
#define CAST 354
#define LOR 355
#define LAND 356
#define OR 357
#define XOR 358
#define AND 359
#define RSHIFT 360
#define LSHIFT 361
#define MINUS 362
#define PLUS 363
#define SLASH 364
#define STAR 365
#define LNOT 366
#define NOT 367
#define UMINUS 368
#define DCOLON 369




/* Copy the first part of user declarations.  */
#line 1 "parser.y"

/* -----------------------------------------------------------------------------
 * parser.y
 *
 *     YACC parser for SWIG.   The grammar is a somewhat broken subset of C/C++.
 *     This file is a bit of a mess and probably needs to be rewritten at
 *     some point.  Beware.
 *
 * Author(s) : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (C) 1998-2001.  The University of Chicago
 * Copyright (C) 1995-1998.  The University of Utah and The Regents of the
 *                           University of California.
 *
 * See the file LICENSE for information on usage and redistribution.
 * ----------------------------------------------------------------------------- */

#define yylex yylex

char cvsroot_parser_y[] = "$Header: /cvsroot/swig/SWIG/Source/CParse/parser.y,v 1.124 2005/10/13 09:24:35 marcelomatus Exp $";

#include "swig.h"
#include "cparse.h"
#include "preprocessor.h"
#include <ctype.h>

/* We do this for portability */
#undef alloca
#define alloca malloc

/* -----------------------------------------------------------------------------
 *                               Externals
 * ----------------------------------------------------------------------------- */

int  yyparse();

/* NEW Variables */

static Node    *top = 0;      /* Top of the generated parse tree */
static int      unnamed = 0;  /* Unnamed datatype counter */
static Hash    *extendhash = 0;     /* Hash table of added methods */
static Hash    *classes = 0;        /* Hash table of classes */
static Symtab  *prev_symtab = 0;
static Node    *current_class = 0;
       String  *ModuleName = 0;
static Node    *module_node = 0;
static String  *Classprefix = 0;  
static String  *Namespaceprefix = 0;
static int      inclass = 0;
static char    *last_cpptype = 0;
static int      inherit_list = 0;
static Parm    *template_parameters = 0;
static int      extendmode   = 0;
static int      dirprot_mode  = 0;
static int      compact_default_args = 0;
static int      template_reduce = 0;
static int      cparse_externc = 0;

/* -----------------------------------------------------------------------------
 *                            Assist Functions
 * ----------------------------------------------------------------------------- */

#define SWIG_WARN_NODE_BEGIN(Node) \
 { \
  String *wrnfilter = Node ? Getattr(Node,"feature:warnfilter") : 0; \
  if (wrnfilter) Swig_warnfilter(wrnfilter,1) 

#define SWIG_WARN_NODE_END(Node) \
  if (wrnfilter) Swig_warnfilter(wrnfilter,0); \
 }

 
/* Called by the parser (yyparse) when an error is found.*/
static void yyerror (const char *e) {
  (void)e;
}

static Node *new_node(const String_or_char *tag) {
  Node *n = NewHash();
  set_nodeType(n,tag);
  Setfile(n,cparse_file);
  Setline(n,cparse_line);
  return n;
}

/* Copies a node.  Does not copy tree links or symbol table data (except for
   sym:name) */

static Node *copy_node(Node *n) {
  Node *nn;
  String *key;
  Iterator k;
  nn = NewHash();
  Setfile(nn,Getfile(n));
  Setline(nn,Getline(n));
  for (k = First(n); k.key; k = Next(k)) {
    key = k.key;
    if ((Strcmp(key,"nextSibling") == 0) ||
	(Strcmp(key,"previousSibling") == 0) ||
	(Strcmp(key,"parentNode") == 0) ||
	(Strcmp(key,"lastChild") == 0)) {
      continue;
    }
    if (Strncmp(key,"csym:",5) == 0) continue;
    /* We do copy sym:name.  For templates */
    if ((Strcmp(key,"sym:name") == 0) || 
	(Strcmp(key,"sym:weak") == 0) ||
	(Strcmp(key,"sym:typename") == 0)) {
      Setattr(nn,key, Copy(k.item));
      continue;
    }
    if (Strcmp(key,"sym:symtab") == 0) {
      Setattr(nn,"sym:needs_symtab", "1");
    }
    /* We don't copy any other symbol table attributes */
    if (Strncmp(key,"sym:",4) == 0) {
      continue;
    }
    /* If children.  We copy them recursively using this function */
    if (Strcmp(key,"firstChild") == 0) {
      /* Copy children */
      Node *cn = k.item;
      while (cn) {
	appendChild(nn,copy_node(cn));
	cn = nextSibling(cn);
      }
      continue;
    }
    /* We don't copy the symbol table.  But we drop an attribute 
       requires_symtab so that functions know it needs to be built */

    if (Strcmp(key,"symtab") == 0) {
      /* Node defined a symbol table. */
      Setattr(nn,"requires_symtab","1");
      continue;
    }
    /* Can't copy nodes */
    if (Strcmp(key,"node") == 0) {
      continue;
    }
    if ((Strcmp(key,"parms") == 0) || (Strcmp(key,"pattern") == 0) || (Strcmp(key,"throws") == 0)
	|| (Strcmp(key,"kwargs") == 0)) {
      ParmList *pl = CopyParmList(k.item);
      Setattr(nn,key,pl);
      Delete(pl);
      continue;
    }
    /* Looks okay.  Just copy the data using Copy */
    Setattr(nn, key, Copy(k.item));
  }
  return nn;
}

/* -----------------------------------------------------------------------------
 *                              Variables
 * ----------------------------------------------------------------------------- */

static char  *typemap_lang = 0;    /* Current language setting */

static int cplus_mode  = 0;
static String  *class_rename = 0;

/* C++ modes */

#define  CPLUS_PUBLIC    1
#define  CPLUS_PRIVATE   2
#define  CPLUS_PROTECTED 3

/* include types */
static int   import_mode = 0;

void SWIG_typemap_lang(const char *tm_lang) {
  typemap_lang = Swig_copy_string(tm_lang);
}

void SWIG_cparse_set_compact_default_args(int defargs) {
  compact_default_args = defargs;
}

void SWIG_cparse_template_reduce(int treduce) {
  template_reduce = treduce;
}

/* -----------------------------------------------------------------------------
 *                           Assist functions
 * ----------------------------------------------------------------------------- */

/* Perform type-promotion for binary operators */
static int promote(int t1, int t2) {
  return t1 > t2 ? t1 : t2;
}

static String *yyrename = 0;

/* Forward renaming operator */
static Hash   *rename_hash = 0;
static Hash   *namewarn_hash = 0;
static Hash   *features_hash = 0;

Hash *Swig_cparse_features() {
  if (!features_hash) features_hash = NewHash();
  return features_hash;
}

static String *feature_identifier_fix(String *s) {
  if (SwigType_istemplate(s)) {
    String *tp, *ts, *ta, *tq;
    tp = SwigType_templateprefix(s);
    ts = SwigType_templatesuffix(s);
    ta = SwigType_templateargs(s);
    tq = Swig_symbol_type_qualify(ta,0);
    Append(tp,tq);
    Append(tp,ts);
    Delete(ts);
    Delete(ta);
    Delete(tq);
    return tp;
  } else {
    return NewString(s);
  }
}

static void single_rename_add(const char *name, SwigType *decl, const char *newname) {
  String *nname;
  if (!rename_hash) rename_hash = NewHash();
  if (Namespaceprefix) {
    nname = NewStringf("%s::%s",Namespaceprefix, name);
  } else {
    nname = NewString(name);
  }
  Swig_name_object_set(rename_hash,nname,decl,NewString(newname));
  Delete(nname);
}

/* Add a new rename. Works much like new_feature including default argument handling. */
static void rename_add(const char *name, SwigType *decl, const char *newname, ParmList *declaratorparms) {

  ParmList *declparms = declaratorparms;

  /* Add the name */
  single_rename_add(name, decl, newname);

  /* Add extra names if there are default parameters in the parameter list */
  if (decl) {
    int constqualifier = SwigType_isconst(decl);
    while (declparms) {
      if (ParmList_has_defaultargs(declparms)) {

        /* Create a parameter list for the new rename by copying all
           but the last (defaulted) parameter */
        ParmList* newparms = ParmList_copy_all_except_last_parm(declparms);

        /* Create new declaration - with the last parameter removed */
        SwigType *newdecl = Copy(decl);
        Delete(SwigType_pop_function(newdecl)); /* remove the old parameter list from newdecl */
        SwigType_add_function(newdecl,newparms);
        if (constqualifier)
          SwigType_add_qualifier(newdecl,"const");

        single_rename_add(name, newdecl, newname);
        declparms = newparms;
        Delete(newdecl);
      } else {
        declparms = 0;
      }
    }
  }
}

static void namewarn_add(const char *name, SwigType *decl, const char *warning) {
  String *nname;
  if (!namewarn_hash) namewarn_hash = NewHash();
  if (Namespaceprefix) {
    nname = NewStringf("%s::%s",Namespaceprefix, name);
  } else {
    nname = NewString(name);
  }

  Swig_name_object_set(namewarn_hash,nname,decl,NewString(warning));
  Delete(nname);
}

static void rename_inherit(String *base, String *derived) {
  /*  Printf(stdout,"base = '%s', derived = '%s'\n", base, derived); */
  Swig_name_object_inherit(rename_hash,base,derived);
  Swig_name_object_inherit(namewarn_hash,base,derived);
  Swig_name_object_inherit(features_hash,base,derived);
}

/* Generate the symbol table name for an object */
/* This is a bit of a mess. Need to clean up */
static String *add_oldname = 0;

static String *make_name(String *name,SwigType *decl) {
  String *rn = 0;
  String *origname = name;
  int     destructor = 0;

  if (name && (*(Char(name)) == '~')) {
    destructor = 1;
  }
  if (yyrename) {
    String *s = yyrename;
    yyrename = 0;
    if (destructor) {
      Insert(s,0,"~");
    }
    return s;
  }

  if (!name) return 0;
  /* Check to see if the name is in the hash */
  if (!rename_hash) {
    if (add_oldname) return Copy(add_oldname);
    return origname;
  }
  rn = Swig_name_object_get(rename_hash, Namespaceprefix, name, decl);
  if (!rn) {
    if (add_oldname) return Copy(add_oldname);
    return name;
  }
  if (destructor) {
    if (Strcmp(rn,"$ignore") != 0) {
      String *s = NewStringf("~%s", rn);
      return s;
    }
  }
  return Copy(rn);
}

/* Generate an unnamed identifier */
static String *make_unnamed() {
  unnamed++;
  return NewStringf("$unnamed%d$",unnamed);
}

/* Return the node name when it requires to emit a name warning */
static String *name_warning(Node *n,String *name,SwigType *decl) {
  /* Return in the obvious cases */
  if (!namewarn_hash || !name || !need_name_warning(n)) {
    return 0;
  } else {
    String *access = Getattr(n,"access");	
    int is_public = !access || (Strcmp(access,"public") == 0);
    if (!is_public && !need_protected(n,dirprot_mode)) {
      return 0;
    }
  }
  
  /* Check to see if the name is in the hash */
  return Swig_name_object_get(namewarn_hash,Namespaceprefix,name,decl);
}

/* Return if the node is a friend declaration */
static int is_friend(Node *n) {
 return Cmp(Getattr(n,"storage"),"friend") == 0;
}


/* Add declaration list to symbol table */
static int  add_only_one = 0;

static void add_symbols(Node *n) {
  String *decl;
  String *wrn = 0;
  if (inclass && n) {
    cparse_normalize_void(n);
  }
  while (n) {
    String *symname;
    /* for friends, we need to pop the scope once */
    int isfriend = is_friend(n);
    Symtab *class_scope = isfriend ? Swig_symbol_popscope() : 0;

    if (!isfriend && inclass && (cplus_mode != CPLUS_PUBLIC)) {
      int only_csymbol = 1;
      if (cplus_mode == CPLUS_PROTECTED) {
	Setattr(n,"access", "protected");
	only_csymbol = !need_protected(n, dirprot_mode);
      } else {
	/* private are needed only when they are pure virtuals */
	Setattr(n,"access", "private");
	if ((Cmp(Getattr(n,"storage"),"virtual") == 0) 
	    && (Cmp(Getattr(n,"value"),"0") == 0)) {
	  only_csymbol = !need_protected(n, dirprot_mode);
	}    
      }
      if (only_csymbol) {
	/* Only add to C symbol table and continue */
	Swig_symbol_add(0, n); 
	if (add_only_one) break;
	n = nextSibling(n);
	continue;
      }
    }
    if (Getattr(n,"sym:name")) {
      n = nextSibling(n);
      continue;
    }
    decl = Getattr(n,"decl");
    if (!SwigType_isfunction(decl)) {
      String *makename = Getattr(n,"parser:makename");
      if (makename) {
        Delattr(n,"parser:makename"); /* temporary information, don't leave it hanging around */
      } else {
        makename = Getattr(n,"name");
      }
      
      symname = make_name(makename,0);
      if (!symname) {
	symname = Getattr(n,"unnamed");
      }
      if (symname) {
	wrn = name_warning(n,symname,0);
	Swig_features_get(features_hash, Namespaceprefix, Getattr(n,"name"), 0, n);
      }
    } else {
      SwigType *fdecl = Copy(decl);
      SwigType *fun = SwigType_pop_function(fdecl);

      /* for friends, we need to disable the class prefix */
      String* class_prefix = isfriend ? Namespaceprefix : 0;
      if (isfriend) Namespaceprefix = 0;

      symname = make_name(Getattr(n,"name"),fun);
      wrn = name_warning(n,symname,fun);
      
      Swig_features_get(features_hash,Namespaceprefix,Getattr(n,"name"),fun,n);
      Delete(fdecl);
      Delete(fun);
      
      /* restore the class prefix if needed */
      if (isfriend) Namespaceprefix = class_prefix;
    }
    if (!symname) {
      n = nextSibling(n);
      continue;
    }
    if (strncmp(Char(symname),"$ignore",7) == 0) {
      char *c = Char(symname)+7;
      SetFlag(n,"feature:ignore");
      if (strlen(c)) {
	SWIG_WARN_NODE_BEGIN(n);
	Swig_warning(0,Getfile(n), Getline(n), "%s\n",c+1);
	SWIG_WARN_NODE_END(n);
      }
      Swig_symbol_add(0, n);
    } else {
      Node *c;
      if ((wrn) && (Len(wrn))) {
	String *metaname = symname;
	if (!Getmeta(metaname,"already_warned")) {
	  SWIG_WARN_NODE_BEGIN(n);
	  Swig_warning(0,Getfile(n),Getline(n), "%s\n", wrn);
	  SWIG_WARN_NODE_END(n);
	  Setmeta(metaname,"already_warned","1");
	}
      }
      c = Swig_symbol_add(symname,n);

      if (c != n) {
        /* symbol conflict attempting to add in the new symbol */
        if (Getattr(n,"sym:weak")) {
          Setattr(n,"sym:name",symname);
        } else {
          String *e = NewString("");
          String *en = NewString("");
          String *ec = NewString("");
          int redefined = need_redefined_warn(n,c,inclass);
          if (redefined) {
            Printf(en,"Identifier '%s' redefined (ignored)",symname);
            Printf(ec,"previous definition of '%s'",symname);
          } else {
            Printf(en,"Redundant redeclaration of '%s'",symname);
            Printf(ec,"previous declaration of '%s'",symname);
          }
          if (Cmp(symname,Getattr(n,"name"))) {
            Printf(en," (Renamed from '%s')", SwigType_namestr(Getattr(n,"name")));
          }
          Printf(en,",");
          if (Cmp(symname,Getattr(c,"name"))) {
            Printf(ec," (Renamed from '%s')", SwigType_namestr(Getattr(c,"name")));
          }
          Printf(ec,".");
	  SWIG_WARN_NODE_BEGIN(n);
          if (redefined) {
            Swig_warning(WARN_PARSE_REDEFINED,Getfile(n),Getline(n),"%s\n",en);
            Swig_warning(WARN_PARSE_REDEFINED,Getfile(c),Getline(c),"%s\n",ec);
          } else if (!is_friend(n) && !is_friend(c)) {
            Swig_warning(WARN_PARSE_REDUNDANT,Getfile(n),Getline(n),"%s\n",en);
            Swig_warning(WARN_PARSE_REDUNDANT,Getfile(c),Getline(c),"%s\n",ec);
          }
	  SWIG_WARN_NODE_END(n);
          Printf(e,"%s:%d:%s\n%s:%d:%s\n",Getfile(n),Getline(n),en,
                 Getfile(c),Getline(c),ec);
          Setattr(n,"error",e);
          Delete(en);
          Delete(ec);
        }
      }
    }
    /* restore the class scope if needed */
    if (isfriend) Swig_symbol_setscope(class_scope);

    if (add_only_one) return;
    n = nextSibling(n);
  }
}


/* add symbols a parse tree node copy */

static void add_symbols_copy(Node *n) {
  String *name;
  int    emode = 0;

  while (n) {

    if (Strcmp(nodeType(n),"access") == 0) {
      String *kind = Getattr(n,"kind");
      if (Strcmp(kind,"public") == 0) {
	cplus_mode = CPLUS_PUBLIC;
      } else if (Strcmp(kind,"private") == 0) {
	cplus_mode = CPLUS_PRIVATE;
      } else if (Strcmp(kind,"protected") == 0) {
	cplus_mode = CPLUS_PROTECTED;
      }
      n = nextSibling(n);
      continue;
    }

    add_oldname = Getattr(n,"sym:name");
    if ((add_oldname) || (Getattr(n,"sym:needs_symtab"))) {
      if (add_oldname) {
	DohIncref(add_oldname);
	/* If already renamed, we used that name */
	if (Strcmp(add_oldname, Getattr(n,"name")) != 0) {
	  yyrename = add_oldname;
	}
      }
      Delattr(n,"sym:needs_symtab");
      Delattr(n,"sym:name");

      add_only_one = 1;
      add_symbols(n);

      if (Getattr(n,"partialargs")) {
	Swig_symbol_cadd(Getattr(n,"partialargs"),n);
      }
      add_only_one = 0;
      name = Getattr(n,"name");
      if (Getattr(n,"requires_symtab")) {
	Swig_symbol_newscope();
	Swig_symbol_setscopename(name);
	Namespaceprefix = Swig_symbol_qualifiedscopename(0);
      }
      if (Strcmp(nodeType(n),"class") == 0) {
	inclass = 1;
	if (Strcmp(Getattr(n,"kind"),"class") == 0) {
	  cplus_mode = CPLUS_PRIVATE;
	} else {
	  cplus_mode = CPLUS_PUBLIC;
	}
      }
      if (Strcmp(nodeType(n),"extend") == 0) {
	emode = cplus_mode;
	cplus_mode = CPLUS_PUBLIC;
      }
      add_symbols_copy(firstChild(n));
      if (Strcmp(nodeType(n),"extend") == 0) {
	cplus_mode = emode;
      }
      if (Getattr(n,"requires_symtab")) {
	Setattr(n,"symtab", Swig_symbol_popscope());
	Delattr(n,"requires_symtab");
	Namespaceprefix = Swig_symbol_qualifiedscopename(0);
      }
      if (add_oldname) {
	Delete(add_oldname);
      }
      if (Strcmp(nodeType(n),"class") == 0) {
	inclass = 0;
      }
      add_oldname = 0;
    } else {
      if (Strcmp(nodeType(n),"extend") == 0) {
	emode = cplus_mode;
	cplus_mode = CPLUS_PUBLIC;
      }
      add_symbols_copy(firstChild(n));
      if (Strcmp(nodeType(n),"extend") == 0) {
	cplus_mode = emode;
      }
    }
    n = nextSibling(n);
  }
}

/* Extension merge.  This function is used to handle the %extend directive
   when it appears before a class definition.   To handle this, the %extend
   actually needs to take precedence.  Therefore, we will selectively nuke symbols
   from the current symbol table, replacing them with the added methods */

static void merge_extensions(Node *cls, Node *am) {
  Node *n;
  Node *csym;

  n = firstChild(am);
  while (n) {
    String *symname;
    if (Strcmp(nodeType(n),"constructor") == 0) {
      symname = Getattr(n,"sym:name");
      if (symname) {
	if (Strcmp(symname,Getattr(n,"name")) == 0) {
	  /* If the name and the sym:name of a constructor are the same,
             then it hasn't been renamed.  However---the name of the class
             itself might have been renamed so we need to do a consistency
             check here */
	  if (Getattr(cls,"sym:name")) {
	    Setattr(n,"sym:name", Getattr(cls,"sym:name"));
	  }
	}
      } 
    }

    symname = Getattr(n,"sym:name");
    DohIncref(symname);
    if ((symname) && (!Getattr(n,"error"))) {
      /* Remove node from its symbol table */
      Swig_symbol_remove(n);
      csym = Swig_symbol_add(symname,n);
      if (csym != n) {
	/* Conflict with previous definition.  Nuke previous definition */
	String *e = NewString("");
	String *en = NewString("");
	String *ec = NewString("");
	Printf(ec,"Identifier '%s' redefined by %%extend (ignored),",symname);
	Printf(en,"%%extend definition of '%s'.",symname);
	SWIG_WARN_NODE_BEGIN(n);
	Swig_warning(WARN_PARSE_REDEFINED,Getfile(csym),Getline(csym),"%s\n",ec);
	Swig_warning(WARN_PARSE_REDEFINED,Getfile(n),Getline(n),"%s\n",en);
	SWIG_WARN_NODE_END(n);
	Printf(e,"%s:%d:%s\n%s:%d:%s\n",Getfile(csym),Getline(csym),ec, 
	       Getfile(n),Getline(n),en);
	Setattr(csym,"error",e);
	Delete(en);
	Delete(ec);
	Swig_symbol_remove(csym);              /* Remove class definition */
	Swig_symbol_add(symname,n);            /* Insert extend definition */
      }
    }
    n = nextSibling(n);
  }
}

/* Check for unused %extend.  Special case, don't report unused
   extensions for templates */
 
 static void check_extensions() {
   Iterator ki;

   if (!extendhash) return;
   for (ki = First(extendhash); ki.key; ki = Next(ki)) {
     if (!Strstr(ki.key,"<")) {
       SWIG_WARN_NODE_BEGIN(ki.item);
       Swig_warning(WARN_PARSE_EXTEND_UNDEF,Getfile(ki.item), Getline(ki.item), "%%extend defined for an undeclared class %s.\n", ki.key);
       SWIG_WARN_NODE_END(ki.item);
     }
   }
 }

/* Check a set of declarations to see if any are pure-abstract */

 static List *pure_abstract(Node *n) {
   List *abs = 0;
   while (n) {
     if (Cmp(nodeType(n),"cdecl") == 0) {
       String *decl = Getattr(n,"decl");
       if (SwigType_isfunction(decl)) {
	 String *init = Getattr(n,"value");
	 if (Cmp(init,"0") == 0) {
	   if (!abs) {
	     abs = NewList();
	   }
	   Append(abs,n);
	   Setattr(n,"abstract","1");
	 }
       }
     } else if (Cmp(nodeType(n),"destructor") == 0) {
       if (Cmp(Getattr(n,"value"),"0") == 0) {
	 if (!abs) {
	   abs = NewList();
	 }
	 Append(abs,n);
	 Setattr(n,"abstract","1");
       }
     }
     n = nextSibling(n);
   }
   return abs;
 }

 /* Make a classname */

 static String *make_class_name(String *name) {
   String *nname = 0;
   if (Namespaceprefix) {
     nname= NewStringf("%s::%s", Namespaceprefix, name);
   } else {
     nname = NewString(name);
   }
   if (SwigType_istemplate(nname)) {
     String *prefix, *args, *qargs;
     prefix = SwigType_templateprefix(nname);
     args   = SwigType_templateargs(nname);
     qargs  = Swig_symbol_type_qualify(args,0);
     Append(prefix,qargs);
     Delete(nname);
     nname = prefix;
   }
   return nname;
 }

 static List *make_inherit_list(String *clsname, List *names) {
   int i;
   String *derived;
   List *bases = NewList();

   if (Namespaceprefix) derived = NewStringf("%s::%s", Namespaceprefix,clsname);
   else derived = NewString(clsname);

   for (i = 0; i < Len(names); i++) {
     Node *s;
     String *base;
     String *n = Getitem(names,i);
     /* Try to figure out where this symbol is */
     s = Swig_symbol_clookup(n,0);
     if (s) {
       while (s && (Strcmp(nodeType(s),"class") != 0)) {
	 /* Not a class.  Could be a typedef though. */
	 String *storage = Getattr(s,"storage");
	 if (storage && (Strcmp(storage,"typedef") == 0)) {
	   String *nn = Getattr(s,"type");
	   s = Swig_symbol_clookup(nn,Getattr(s,"sym:symtab"));
	 } else {
	   break;
	 }
       }
       if (s && ((Strcmp(nodeType(s),"class") == 0) || (Strcmp(nodeType(s),"template") == 0))) {
	 String *q = Swig_symbol_qualified(s);
	 Append(bases,s);
	 if (q) {
	   base = NewStringf("%s::%s", q, Getattr(s,"name"));
	 } else {
	   base = NewString(Getattr(s,"name"));
	 }
       } else {
	 base = NewString(n);
       }
     } else {
       base = NewString(n);
     }
     if (base) {
       rename_inherit(base,derived);
       Delete(base);
     }
   }
   return bases;
 }

/* If the class name is qualified.  We need to create or lookup namespace entries */

static Symtab *get_global_scope() {
  Symtab *symtab = Swig_symbol_current();
  Node   *pn = parentNode(symtab);
  while (pn) {
    symtab = pn;
    pn = parentNode(symtab);
    if (!pn) break;
  }
  Swig_symbol_setscope(symtab);
  return symtab;
}
 

static Node *nscope = 0;
static Node *nscope_inner = 0;
static String *resolve_node_scope(String *cname) {
  Symtab *gscope = 0;
  nscope = 0;
  nscope_inner = 0;
  if (Swig_scopename_check(cname)) {
    Node   *ns;
    String *prefix = Swig_scopename_prefix(cname);
    String *base = Swig_scopename_last(cname);
    if (prefix && (Strncmp(prefix,"::",2) == 0)) {
      /* Use the global scope */
      String *nprefix = NewString(Char(prefix)+2);
      Delete(prefix);
      prefix= nprefix;
      gscope = get_global_scope();
    }    
    if (!prefix || (Len(prefix) == 0)) {
      /* Use the global scope, but we need to add a 'global' namespace.  */
      if (!gscope) gscope = get_global_scope();
      /* note that this namespace is not the "unnamed" one,
	 and we don't use Setattr(nscope,"name", ""),
	 because the unnamed namespace is private */
      nscope = new_node("namespace");
      Setattr(nscope,"symtab", gscope);;
      nscope_inner = nscope;
      return base;
    }
    /* Try to locate the scope */
    ns = Swig_symbol_clookup(prefix,0);
    if (!ns) {
      Swig_error(cparse_file,cparse_line,"Undefined scope '%s'\n", prefix);
    } else {
      Symtab *nstab = Getattr(ns,"symtab");
      if (!nstab) {
	Swig_error(cparse_file,cparse_line,
		   "'%s' is not defined as a valid scope.\n", prefix);
	ns = 0;
      } else {
	/* Check if the node scope is the current scope */
	String *tname = Swig_symbol_qualifiedscopename(0);
	String *nname = Swig_symbol_qualifiedscopename(nstab);
	if (tname && (Strcmp(tname,nname) == 0)) {
	  ns = 0;
	  cname = base;
	}
	Delete(tname);
	Delete(nname);
      }
      if (ns) {
	/* we will to try to create a new node using the namespaces we
	   can find in the scope name */
	List *scopes;
	String *sname;
	Iterator si;
	String *name = NewString(prefix);
	scopes = NewList();
	while (name) {
	  String *base = Swig_scopename_last(name);
	  String *tprefix = Swig_scopename_prefix(name);
	  Insert(scopes,0,base);
	  Delete(name);
	  name = tprefix;
	}
	for (si = First(scopes); si.item; si = Next(si)) {
	  Node *ns1,*ns2;
	  sname = si.item;
	  ns1 = Swig_symbol_clookup(sname,0);
	  assert(ns1);
	  if (Strcmp(nodeType(ns1),"namespace") == 0) {
	    if (Getattr(ns1,"alias")) {
	      ns1 = Getattr(ns1,"namespace");
	    }
	  } else {
	    /* now this last part is a class */
	    si = Next(si);
	    ns1 = Swig_symbol_clookup(sname,0);
	    /*  or a nested class tree, which is unrolled here */
	    for (; si.item; si = Next(si)) {
	      if (si.item) {
		Printf(sname,"::%s",si.item);
	      }
	    }
	    /* we get the 'inner' class */
	    nscope_inner = Swig_symbol_clookup(sname,0);
	    /* set the scope to the inner class */
	    Swig_symbol_setscope(Getattr(nscope_inner,"symtab"));
	    /* save the last namespace prefix */
	    Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	    /* and return the node name, including the inner class prefix */
	    break;
	  }
	  /* here we just populate the namespace tree as usual */
	  ns2 = new_node("namespace");
	  Setattr(ns2,"name",sname);
	  Setattr(ns2,"symtab", Getattr(ns1,"symtab"));
	  add_symbols(ns2);
	  Swig_symbol_setscope(Getattr(ns1,"symtab"));
	  Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	  if (nscope_inner) {
	    if (Getattr(nscope_inner,"symtab") != Getattr(ns2,"symtab")) {
	      appendChild(nscope_inner,ns2);
	    }
	  }
	  nscope_inner = ns2;
	  if (!nscope) nscope = ns2;
	}
	cname = base;
      }
    }
    Delete(prefix);
  }
  return cname;
}
 




/* Structures for handling code fragments built for nested classes */

typedef struct Nested {
  String   *code;        /* Associated code fragment */
  int      line;         /* line number where it starts */
  char     *name;        /* Name associated with this nested class */
  char     *kind;        /* Kind of class */
  SwigType *type;        /* Datatype associated with the name */
  struct Nested   *next;        /* Next code fragment in list */
} Nested;

/* Some internal variables for saving nested class information */

static Nested      *nested_list = 0;

/* Add a function to the nested list */

static void add_nested(Nested *n) {
  Nested *n1;
  if (!nested_list) nested_list = n;
  else {
    n1 = nested_list;
    while (n1->next) n1 = n1->next;
    n1->next = n;
  }
}

/* Dump all of the nested class declarations to the inline processor
 * However.  We need to do a few name replacements and other munging
 * first.  This function must be called before closing a class! */

static Node *dump_nested(const char *parent) {
  Nested *n,*n1;
  Node *ret = 0;
  n = nested_list;
  if (!parent) {
    nested_list = 0;
    return 0;
  }
  while (n) {
    char temp[256];
    Node *retx;
    /* Token replace the name of the parent class */
    Replace(n->code, "$classname", parent, DOH_REPLACE_ANY);
    /* Fix up the name of the datatype (for building typedefs and other stuff) */
    sprintf(temp,"%s_%s", parent,n->name);

    Append(n->type,parent);
    Append(n->type,"_");
    Append(n->type,n->name);

    /* Add the appropriate declaration to the C++ processor */
    retx = new_node("cdecl");
    Setattr(retx,"name",n->name);
    Setattr(retx,"type",Copy(n->type));
    Setattr(retx,"nested",parent);
    add_symbols(retx);
    if (ret) {
      set_nextSibling(retx,ret);
    }
    ret = retx;

    /* Insert a forward class declaration */
    /* Disabled: [ 597599 ] union in class: incorrect scope 
    retx = new_node("classforward");
    Setattr(retx,"kind",n->kind);
    Setattr(retx,"name",Copy(n->type));
    Setattr(retx,"sym:name", make_name(n->type,0));
    set_nextSibling(retx,ret);
    ret = retx; 
    */

    /* Make all SWIG created typedef structs/unions/classes unnamed else 
       redefinition errors occur - nasty hack alert.*/

    {
      const char* types_array[3] = {"struct", "union", "class"};
      int i;
      for (i=0; i<3; i++) {
	char* code_ptr = Char(n->code);
      while (code_ptr) {
        /* Replace struct name (as in 'struct name {' ) with whitespace
           name will be between struct and { */
	
        code_ptr = strstr(code_ptr, types_array[i]);
        if (code_ptr) {
	  char *open_bracket_pos;
          code_ptr += strlen(types_array[i]);
          open_bracket_pos = strstr(code_ptr, "{");
          if (open_bracket_pos) { 
            /* Make sure we don't have something like struct A a; */
            char* semi_colon_pos = strstr(code_ptr, ";");
            if (!(semi_colon_pos && (semi_colon_pos < open_bracket_pos)))
              while (code_ptr < open_bracket_pos)
                *code_ptr++ = ' ';
          }
        }
      }
      }
    }
    
    {
      /* Remove SWIG directive %constant which may be left in the SWIG created typedefs */
      char* code_ptr = Char(n->code);
      while (code_ptr) {
	code_ptr = strstr(code_ptr, "%constant");
	if (code_ptr) {
	  char* directive_end_pos = strstr(code_ptr, ";");
	  if (directive_end_pos) { 
            while (code_ptr <= directive_end_pos)
              *code_ptr++ = ' ';
	  }
	}
      }
    }
    {
      Node *head;
      head = new_node("insert");
      Setattr(head,"code",NewStringf("\n%s\n",n->code));
      set_nextSibling(head,ret);
      ret = head;
    }
      
    /* Dump the code to the scanner */
    start_inline(Char(n->code),n->line);

    n1 = n->next;
    Delete(n->code);
    free(n);
    n = n1;
  }
  nested_list = 0;
  return ret;
}

Node *Swig_cparse(File *f) {
  scanner_file(f);
  top = 0;
  yyparse();
  return top;
}

static void single_new_feature(const char *featurename, String *val, Hash *featureattribs, char *declaratorid, SwigType *type, ParmList *declaratorparms, String *qualifier) {
  String *fname;
  String *name;
  String *fixname;
  SwigType *t = Copy(type);

  /* Printf(stdout, "single_new_feature: [%s] [%s] [%s] [%s] [%s] [%s]\n", featurename, val, declaratorid, t, ParmList_str_defaultargs(declaratorparms), qualifier); */

  if (!features_hash) features_hash = NewHash();
  fname = NewStringf("feature:%s",featurename);
  if (declaratorid) {
    fixname = feature_identifier_fix(declaratorid);
  } else {
    fixname = NewString("");
  }
  if (Namespaceprefix) {
   name = NewStringf("%s::%s",Namespaceprefix, fixname);
  } else {
   name = fixname;
  }

  if (declaratorparms) Setmeta(val,"parms",declaratorparms);
  if (!Len(t)) t = 0;
  if (t) {
   if (qualifier) SwigType_push(t,qualifier);
   if (SwigType_isfunction(t)) {
     SwigType *decl = SwigType_pop_function(t);
     if (SwigType_ispointer(t)) {
       String *nname = NewStringf("*%s",name);
       Swig_feature_set(features_hash, nname, decl, fname, val, featureattribs);
       Delete(nname);
     } else {
       Swig_feature_set(features_hash, name, decl, fname, val, featureattribs);
     }
     Delete(decl);
   } else if (SwigType_ispointer(t)) {
     String *nname = NewStringf("*%s",name);
     Swig_feature_set(features_hash,nname,0,fname,val, featureattribs);
     Delete(nname);
   }
  } else {
   /* Global feature, that is, feature not associated with any particular symbol */
   Swig_feature_set(features_hash,name,0,fname,val, featureattribs);
  }
  Delete(fname);
  Delete(name);
}

/* Add a new feature to the Hash. Additional features are added if the feature has a parameter list (declaratorparms)
 * and one or more of the parameters have a default argument. An extra feature is added for each defaulted parameter,
 * simulating the equivalent overloaded method. */
static void new_feature(const char *featurename, String *val, Hash *featureattribs, char *declaratorid, SwigType *type, ParmList *declaratorparms, String *qualifier) {

  ParmList *declparms = declaratorparms;

  /* Add the feature */
  single_new_feature(featurename, val, featureattribs, declaratorid, type, declaratorparms, qualifier);

  /* Add extra features if there are default parameters in the parameter list */
  if (type) {
    while (declparms) {
      if (ParmList_has_defaultargs(declparms)) {

        /* Create a parameter list for the new feature by copying all
           but the last (defaulted) parameter */
        ParmList* newparms = ParmList_copy_all_except_last_parm(declparms);

        /* Create new declaration - with the last parameter removed */
        SwigType *newtype = Copy(type);
        Delete(SwigType_pop_function(newtype)); /* remove the old parameter list from newtype */
        SwigType_add_function(newtype,newparms);

        single_new_feature(featurename, Copy(val), featureattribs, declaratorid, newtype, newparms, qualifier);
        declparms = newparms;
      } else {
        declparms = 0;
      }
    }
  }
}

/* check if a function declaration is a plain C object */
static int is_cfunction(Node *n) {
  if (!cparse_cplusplus || cparse_externc) return 1;
  if (Cmp(Getattr(n,"storage"),"externc") == 0) {
    return 1;
  }
  return 0;
}

/* If the Node is a function with parameters, check to see if any of the parameters
 * have default arguments. If so create a new function for each defaulted argument. 
 * The additional functions form a linked list of nodes with the head being the original Node n. */
static void default_arguments(Node *n) {
  Node *function = n;

  if (function) {
    ParmList *varargs = Getattr(function,"feature:varargs");
    if (varargs) {
      /* Handles the %varargs directive by looking for "feature:varargs" and 
       * substituting ... with an alternative set of arguments.  */
      Parm     *p = Getattr(function,"parms");
      Parm     *pp = 0;
      while (p) {
	SwigType *t = Getattr(p,"type");
	if (Strcmp(t,"v(...)") == 0) {
	  if (pp) {
	    set_nextSibling(pp,Copy(varargs));
	  } else {
	    Setattr(function,"parms", Copy(varargs));
	  }
	  break;
	}
	pp = p;
	p = nextSibling(p);
      }
    }

    /* Do not add in functions if kwargs is being used or if user wants old default argument wrapping
      (one wrapped method per function irrespective of number of default arguments) */
    if (compact_default_args 
	|| is_cfunction(function) 
	|| GetFlag(function,"feature:compactdefaultargs") 
	|| GetFlag(function,"feature:kwargs")) {
      ParmList *p = Getattr(function,"parms");
      if (p) 
        Setattr(p,"compactdefargs", "1"); /* mark parameters for special handling */
      function = 0; /* don't add in extra methods */
    }
  }

  while (function) {
    ParmList *parms = Getattr(function,"parms");
    if (ParmList_has_defaultargs(parms)) {

      /* Create a parameter list for the new function by copying all
         but the last (defaulted) parameter */
      ParmList* newparms = ParmList_copy_all_except_last_parm(parms);

      /* Create new function and add to symbol table */
      {
        Node *new_function = new_node(Copy(nodeType(function)));
        SwigType *decl = Copy(Getattr(function,"decl"));
        int constqualifier = SwigType_isconst(decl);

        Delete(SwigType_pop_function(decl)); /* remove the old parameter list from decl */
        SwigType_add_function(decl,newparms);
        if (constqualifier)
          SwigType_add_qualifier(decl,"const");

        Setattr(new_function,"name",Getattr(function,"name"));
        Setattr(new_function,"code",Copy(Getattr(function,"code")));
        Setattr(new_function,"decl", decl);
        Setattr(new_function,"parms",newparms);
        Setattr(new_function,"storage",Copy(Getattr(function,"storage")));
        Setattr(new_function,"type",Copy(Getattr(function,"type")));
        Setattr(new_function,"throw",Copy(Getattr(function,"throw")));

        {
          Node *throws = Getattr(function,"throws");
	  ParmList *pl = CopyParmList(throws);
          if (throws) Setattr(new_function,"throws",pl);
	  Delete(pl);
        }

        /* copy specific attributes for global (or in a namespace) template functions - these are not templated class methods */
        if (Strcmp(nodeType(function),"template") == 0) {
          Node *templatetype = Getattr(function,"templatetype");
          Node *symtypename = Getattr(function,"sym:typename");
          Parm *templateparms = Getattr(function,"templateparms");
          if (templatetype) Setattr(new_function,"templatetype",Copy(templatetype));
          if (symtypename) Setattr(new_function,"sym:typename",Copy(symtypename));
          if (templateparms) Setattr(new_function,"templateparms",CopyParmList(templateparms));
        } else if (Strcmp(nodeType(function),"constructor") == 0) {
          /* only copied for constructors as this is not a user defined feature - it is hard coded in the parser */
          if (GetFlag(function,"feature:new")) SetFlag(new_function,"feature:new");
        }

        add_symbols(new_function);
        /* mark added functions as ones with overloaded parameters and point to the parsed method */
        Setattr(new_function,"defaultargs", n);

        /* Point to the new function, extending the linked list */
        set_nextSibling(function, new_function);

        function = new_function;
      }
    } else {
      function = 0;
    }
  }
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 1242 "parser.y"
typedef union YYSTYPE {
  char  *id;
  List  *bases;
  struct Define {
    String *val;
    String *rawval;
    int     type;
    String *qualifier;
    String *bitfield;
    Parm   *throws;
    String *throw;
  } dtype;
  struct {
    char *type;
    char *filename;
    int   line;
  } loc;
  struct {
    char      *id;
    SwigType  *type;
    String    *defarg;
    ParmList  *parms;
    short      have_parms;
    ParmList  *throws;
    String    *throw;
  } decl;
  Parm         *tparms;
  struct {
    String     *op;
    Hash       *kwargs;
  } tmap;
  struct {
    String     *type;
    String     *us;
  } ptype;
  SwigType     *type;
  String       *str;
  Parm         *p;
  ParmList     *pl;
  int           ivalue;
  Node         *node;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1587 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1599 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  47
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   3301

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  115
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  143
/* YYNRULES -- Number of rules. */
#define YYNRULES  443
/* YYNRULES -- Number of states. */
#define YYNSTATES  857

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   369

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     9,    12,    16,    19,    22,    24,
      26,    28,    30,    32,    34,    36,    39,    41,    43,    45,
      47,    49,    51,    53,    55,    57,    59,    61,    63,    65,
      67,    69,    71,    73,    75,    77,    79,    81,    82,    90,
      96,   100,   106,   112,   116,   119,   122,   128,   131,   137,
     140,   145,   147,   149,   157,   165,   171,   172,   180,   182,
     184,   187,   190,   192,   198,   204,   210,   214,   219,   223,
     231,   240,   246,   250,   252,   254,   258,   260,   265,   273,
     280,   282,   284,   292,   302,   311,   322,   328,   336,   343,
     352,   354,   356,   362,   367,   373,   381,   383,   387,   394,
     401,   410,   412,   415,   419,   421,   424,   428,   435,   441,
     451,   454,   456,   458,   460,   461,   468,   474,   476,   481,
     483,   485,   488,   494,   501,   506,   514,   523,   530,   532,
     534,   536,   538,   540,   542,   543,   553,   554,   563,   565,
     568,   573,   574,   581,   585,   587,   589,   591,   593,   595,
     597,   601,   606,   607,   614,   615,   621,   627,   630,   631,
     638,   640,   641,   645,   647,   649,   651,   653,   655,   657,
     659,   661,   665,   667,   669,   671,   673,   675,   677,   679,
     681,   683,   690,   697,   705,   714,   723,   731,   737,   740,
     743,   746,   747,   755,   756,   763,   764,   773,   775,   777,
     779,   781,   783,   785,   787,   789,   791,   793,   795,   797,
     799,   802,   805,   808,   813,   816,   822,   824,   827,   829,
     831,   833,   835,   837,   839,   842,   844,   848,   850,   853,
     860,   864,   866,   869,   871,   875,   877,   879,   881,   883,
     886,   890,   893,   896,   898,   901,   904,   906,   908,   910,
     912,   915,   919,   921,   924,   928,   933,   939,   944,   946,
     949,   953,   958,   964,   968,   973,   978,   980,   983,   988,
     993,   999,  1003,  1008,  1013,  1015,  1018,  1021,  1025,  1027,
    1030,  1032,  1035,  1039,  1044,  1048,  1053,  1056,  1060,  1064,
    1069,  1073,  1077,  1080,  1083,  1085,  1087,  1090,  1092,  1094,
    1096,  1098,  1101,  1103,  1105,  1107,  1109,  1112,  1115,  1117,
    1120,  1122,  1125,  1127,  1129,  1132,  1134,  1136,  1138,  1140,
    1142,  1144,  1146,  1148,  1150,  1152,  1153,  1156,  1158,  1160,
    1162,  1166,  1168,  1170,  1174,  1176,  1178,  1180,  1182,  1184,
    1190,  1192,  1194,  1198,  1203,  1209,  1215,  1222,  1224,  1226,
    1228,  1230,  1232,  1234,  1236,  1240,  1244,  1248,  1252,  1256,
    1260,  1264,  1268,  1272,  1276,  1280,  1283,  1286,  1289,  1292,
    1295,  1297,  1298,  1302,  1304,  1306,  1310,  1313,  1318,  1320,
    1322,  1324,  1326,  1328,  1330,  1332,  1334,  1336,  1338,  1343,
    1349,  1351,  1355,  1359,  1364,  1369,  1373,  1376,  1378,  1380,
    1384,  1387,  1391,  1393,  1395,  1397,  1399,  1401,  1404,  1409,
    1411,  1415,  1417,  1421,  1425,  1428,  1431,  1434,  1437,  1440,
    1445,  1447,  1451,  1453,  1457,  1461,  1464,  1467,  1470,  1473,
    1475,  1477,  1479,  1481,  1485,  1487,  1491,  1497,  1499,  1503,
    1507,  1513,  1515,  1517
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     116,     0,    -1,   117,    -1,    97,   200,    36,    -1,    97,
       1,    -1,    98,   200,    36,    -1,    98,     1,    -1,   117,
     118,    -1,   257,    -1,   119,    -1,   156,    -1,   164,    -1,
      36,    -1,     1,    -1,   163,    -1,     1,    96,    -1,   120,
      -1,   122,    -1,   123,    -1,   124,    -1,   125,    -1,   126,
      -1,   129,    -1,   130,    -1,   133,    -1,   134,    -1,   135,
      -1,   136,    -1,   137,    -1,   138,    -1,   141,    -1,   143,
      -1,   146,    -1,   148,    -1,   153,    -1,   154,    -1,   155,
      -1,    -1,    57,   254,   247,    39,   121,   178,    40,    -1,
      80,   152,    39,   150,    40,    -1,    81,   150,    36,    -1,
      53,     3,    47,   222,    36,    -1,    53,   216,   208,   205,
      36,    -1,    53,     1,    36,    -1,    79,     4,    -1,    79,
     252,    -1,    78,    33,     3,    34,    39,    -1,    78,    39,
      -1,    78,    33,     3,    34,    36,    -1,    78,    36,    -1,
     252,    39,   200,    40,    -1,   252,    -1,   127,    -1,    83,
      33,   128,    35,   255,    34,     4,    -1,    83,    33,   128,
      35,   255,    34,    39,    -1,    83,    33,   128,    34,    36,
      -1,    -1,   132,   254,   252,    50,   131,   117,    51,    -1,
       7,    -1,     8,    -1,    76,     4,    -1,    76,    39,    -1,
       4,    -1,     9,    33,   245,    34,   252,    -1,     9,    33,
     245,    34,     4,    -1,     9,    33,   245,    34,    39,    -1,
      49,   254,   245,    -1,    54,    33,   245,    34,    -1,    54,
      33,    34,    -1,    75,    33,     3,    34,   196,     3,    36,
      -1,    75,    33,     3,    34,   196,   216,   208,    36,    -1,
      58,   140,     3,    47,   139,    -1,    58,   140,     3,    -1,
     252,    -1,     4,    -1,    33,     3,    34,    -1,   257,    -1,
     142,   208,   245,    36,    -1,   142,    33,   245,    34,   208,
     239,    36,    -1,   142,    33,   245,    34,   252,    36,    -1,
      55,    -1,    56,    -1,    59,    33,   245,    34,   208,   239,
     144,    -1,    59,    33,   245,    35,   256,    34,   208,   239,
      36,    -1,    59,    33,   245,   145,    34,   208,   239,   144,
      -1,    59,    33,   245,    35,   256,   145,    34,   208,   239,
      36,    -1,    59,    33,   245,    34,   144,    -1,    59,    33,
     245,    35,   256,    34,    36,    -1,    59,    33,   245,   145,
      34,   144,    -1,    59,    33,   245,    35,   256,   145,    34,
      36,    -1,   253,    -1,    36,    -1,    90,    33,   197,    34,
      36,    -1,    35,   245,    47,   256,    -1,    35,   245,    47,
     256,   145,    -1,    60,    33,   147,    34,   208,   239,    36,
      -1,   197,    -1,    11,    35,   200,    -1,    77,    33,   149,
      34,   150,   253,    -1,    77,    33,   149,    34,   150,    36,
      -1,    77,    33,   149,    34,   150,    47,   152,    36,    -1,
     255,    -1,   152,   151,    -1,    35,   152,   151,    -1,   257,
      -1,   216,   207,    -1,    33,   197,    34,    -1,    33,   197,
      34,    33,   197,    34,    -1,    89,    33,   197,    34,    36,
      -1,    82,    33,   246,    34,   250,    85,   201,    86,    36,
      -1,    84,   252,    -1,   158,    -1,   162,    -1,   161,    -1,
      -1,    37,   252,    39,   157,   117,    40,    -1,   196,   216,
     208,   160,   159,    -1,    36,    -1,    35,   208,   160,   159,
      -1,    39,    -1,   205,    -1,   214,   205,    -1,    71,    33,
     197,    34,   205,    -1,   214,    71,    33,   197,    34,   205,
      -1,   196,    61,     3,    36,    -1,   196,    61,   224,    39,
     225,    40,    36,    -1,   196,    61,   224,    39,   225,    40,
     208,   159,    -1,   196,   216,    33,   197,    34,   240,    -1,
     165,    -1,   169,    -1,   170,    -1,   174,    -1,   175,    -1,
     185,    -1,    -1,   196,   237,   247,   231,    39,   166,   178,
      40,   168,    -1,    -1,   196,   237,    39,   167,   178,    40,
     208,   159,    -1,    36,    -1,   208,   159,    -1,   196,   237,
     247,    36,    -1,    -1,    94,    85,   173,    86,   171,   172,
      -1,    94,   237,   247,    -1,   158,    -1,   165,    -1,   182,
      -1,   170,    -1,   169,    -1,   198,    -1,    73,   247,    36,
      -1,    73,    74,   247,    36,    -1,    -1,    74,   247,    39,
     176,   117,    40,    -1,    -1,    74,    39,   177,   117,    40,
      -1,    74,     3,    47,   247,    36,    -1,   181,   178,    -1,
      -1,    57,    39,   179,   178,    40,   178,    -1,   257,    -1,
      -1,     1,   180,   178,    -1,   156,    -1,   182,    -1,   183,
      -1,   186,    -1,   192,    -1,   184,    -1,   169,    -1,   187,
      -1,   196,   247,    36,    -1,   174,    -1,   170,    -1,   185,
      -1,   154,    -1,   155,    -1,   195,    -1,   129,    -1,   153,
      -1,    36,    -1,   196,   216,    33,   197,    34,   240,    -1,
     112,   249,    33,   197,    34,   193,    -1,    69,   112,   249,
      33,   197,    34,   194,    -1,   196,    96,   216,   213,    33,
     197,    34,   194,    -1,   196,    96,   216,   104,    33,   197,
      34,   194,    -1,   196,    96,   216,    33,   197,    34,   194,
      -1,    72,    33,   197,    34,    39,    -1,    65,    67,    -1,
      64,    67,    -1,    66,    67,    -1,    -1,   196,   237,     3,
      39,   188,   191,    36,    -1,    -1,   196,   237,    39,   189,
     191,    36,    -1,    -1,   196,   237,   247,    67,   234,    39,
     190,    36,    -1,   208,    -1,   257,    -1,   138,    -1,   124,
      -1,   136,    -1,   141,    -1,   143,    -1,   146,    -1,   134,
      -1,   148,    -1,   122,    -1,   123,    -1,   125,    -1,   239,
      36,    -1,   239,    39,    -1,   239,    36,    -1,   239,    47,
     222,    36,    -1,   239,    39,    -1,   196,   216,    67,   228,
      36,    -1,    37,    -1,    37,   252,    -1,    68,    -1,    18,
      -1,    69,    -1,    70,    -1,   257,    -1,   198,    -1,   200,
     199,    -1,   257,    -1,    35,   200,   199,    -1,   257,    -1,
     217,   206,    -1,    94,    85,   237,    86,   237,   247,    -1,
      41,    41,    41,    -1,   202,    -1,   204,   203,    -1,   257,
      -1,    35,   204,   203,    -1,   257,    -1,   200,    -1,   229,
      -1,     6,    -1,    47,   222,    -1,    47,   104,   208,    -1,
      47,    39,    -1,    67,   228,    -1,   257,    -1,   208,   205,
      -1,   211,   205,    -1,   205,    -1,   208,    -1,   211,    -1,
     257,    -1,   213,   209,    -1,   213,   104,   209,    -1,   210,
      -1,   104,   209,    -1,   247,    92,   209,    -1,   213,   247,
      92,   209,    -1,   213,   247,    92,   104,   209,    -1,   247,
      92,   104,   209,    -1,   247,    -1,   112,   247,    -1,    33,
     247,    34,    -1,    33,   213,   209,    34,    -1,    33,   247,
      92,   209,    34,    -1,   209,    50,    51,    -1,   209,    50,
     228,    51,    -1,   209,    33,   197,    34,    -1,   247,    -1,
     112,   247,    -1,    33,   213,   210,    34,    -1,    33,   104,
     210,    34,    -1,    33,   247,    92,   210,    34,    -1,   210,
      50,    51,    -1,   210,    50,   228,    51,    -1,   210,    33,
     197,    34,    -1,   213,    -1,   213,   212,    -1,   213,   104,
      -1,   213,   104,   212,    -1,   212,    -1,   104,   212,    -1,
     104,    -1,   247,    92,    -1,   213,   247,    92,    -1,   213,
     247,    92,   212,    -1,   212,    50,    51,    -1,   212,    50,
     228,    51,    -1,    50,    51,    -1,    50,   228,    51,    -1,
      33,   211,    34,    -1,   212,    33,   197,    34,    -1,    33,
     197,    34,    -1,   110,   214,   213,    -1,   110,   213,    -1,
     110,   214,    -1,   110,    -1,   215,    -1,   215,   214,    -1,
      42,    -1,    43,    -1,    44,    -1,   217,    -1,   214,   218,
      -1,   218,    -1,   219,    -1,    29,    -1,    27,    -1,    31,
     244,    -1,    61,   247,    -1,    32,    -1,   218,   214,    -1,
     247,    -1,   237,   247,    -1,   220,    -1,   221,    -1,   221,
     220,    -1,    19,    -1,    21,    -1,    22,    -1,    25,    -1,
      26,    -1,    23,    -1,    24,    -1,    28,    -1,    20,    -1,
      30,    -1,    -1,   223,   228,    -1,    10,    -1,     3,    -1,
     257,    -1,   225,    35,   226,    -1,   226,    -1,     3,    -1,
       3,    47,   227,    -1,   257,    -1,   228,    -1,    10,    -1,
     229,    -1,   252,    -1,    48,    33,   216,   206,    34,    -1,
     230,    -1,   216,    -1,    33,   228,    34,    -1,    33,   228,
      34,   228,    -1,    33,   228,   213,    34,   228,    -1,    33,
     228,   104,    34,   228,    -1,    33,   228,   213,   104,    34,
     228,    -1,    11,    -1,    12,    -1,    13,    -1,    14,    -1,
      15,    -1,    16,    -1,    17,    -1,   228,   108,   228,    -1,
     228,   107,   228,    -1,   228,   110,   228,    -1,   228,   109,
     228,    -1,   228,   104,   228,    -1,   228,   102,   228,    -1,
     228,   103,   228,    -1,   228,   106,   228,    -1,   228,   105,
     228,    -1,   228,   101,   228,    -1,   228,   100,   228,    -1,
     107,   228,    -1,   108,   228,    -1,   112,   228,    -1,   111,
     228,    -1,   216,    33,    -1,   232,    -1,    -1,    67,   233,
     234,    -1,   257,    -1,   235,    -1,   234,    35,   235,    -1,
     238,   247,    -1,   238,   236,   238,   247,    -1,    65,    -1,
      64,    -1,    66,    -1,    62,    -1,    45,    -1,    46,    -1,
      63,    -1,    69,    -1,   257,    -1,   214,    -1,    71,    33,
     197,    34,    -1,   214,    71,    33,   197,    34,    -1,   257,
      -1,   239,   241,    36,    -1,   239,   241,    39,    -1,    33,
     197,    34,    36,    -1,    33,   197,    34,    39,    -1,    47,
     222,    36,    -1,    67,   242,    -1,   257,    -1,   243,    -1,
     242,    35,   243,    -1,   247,    33,    -1,    85,   201,    86,
      -1,   257,    -1,     3,    -1,   252,    -1,   245,    -1,   257,
      -1,   249,   248,    -1,    91,   114,   249,   248,    -1,   249,
      -1,    91,   114,   249,    -1,    95,    -1,    91,   114,    95,
      -1,   114,   249,   248,    -1,   114,   249,    -1,   114,    95,
      -1,    93,   249,    -1,     3,   244,    -1,     3,   251,    -1,
      91,   114,     3,   251,    -1,     3,    -1,    91,   114,     3,
      -1,    95,    -1,    91,   114,    95,    -1,   114,     3,   251,
      -1,   114,     3,    -1,   114,    95,    -1,    93,     3,    -1,
     252,     6,    -1,     6,    -1,   252,    -1,    39,    -1,     4,
      -1,    33,   255,    34,    -1,   257,    -1,   245,    47,   256,
      -1,   245,    47,   256,    35,   255,    -1,   245,    -1,   245,
      35,   255,    -1,   245,    47,   127,    -1,   245,    47,   127,
      35,   255,    -1,   252,    -1,   229,    -1,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1388,  1388,  1400,  1403,  1406,  1409,  1414,  1419,  1424,
    1425,  1426,  1427,  1428,  1440,  1456,  1466,  1467,  1468,  1469,
    1470,  1471,  1472,  1473,  1474,  1475,  1476,  1477,  1478,  1479,
    1480,  1481,  1482,  1483,  1484,  1485,  1486,  1493,  1493,  1565,
    1575,  1586,  1605,  1627,  1638,  1647,  1666,  1672,  1678,  1683,
    1694,  1701,  1705,  1710,  1719,  1731,  1744,  1744,  1795,  1796,
    1803,  1823,  1850,  1854,  1864,  1869,  1884,  1918,  1923,  1936,
    1942,  1968,  1974,  1981,  1982,  1985,  1986,  1994,  2005,  2050,
    2061,  2064,  2091,  2096,  2101,  2106,  2113,  2118,  2123,  2128,
    2135,  2136,  2137,  2140,  2145,  2155,  2192,  2193,  2222,  2253,
    2261,  2274,  2296,  2302,  2306,  2309,  2317,  2322,  2334,  2344,
    2584,  2594,  2601,  2602,  2606,  2606,  2637,  2691,  2695,  2715,
    2721,  2727,  2733,  2739,  2752,  2767,  2778,  2847,  2895,  2896,
    2897,  2898,  2899,  2900,  2906,  2906,  3099,  3099,  3194,  3195,
    3207,  3227,  3227,  3457,  3463,  3466,  3469,  3472,  3475,  3480,
    3512,  3519,  3546,  3546,  3573,  3573,  3594,  3621,  3636,  3636,
    3646,  3647,  3647,  3667,  3668,  3683,  3684,  3685,  3686,  3687,
    3688,  3689,  3690,  3691,  3692,  3693,  3694,  3695,  3696,  3697,
    3698,  3707,  3729,  3747,  3782,  3796,  3813,  3831,  3838,  3845,
    3853,  3876,  3876,  3904,  3904,  3934,  3934,  3952,  3953,  3959,
    3962,  3966,  3969,  3970,  3971,  3972,  3973,  3974,  3975,  3976,
    3979,  3984,  3991,  3999,  4007,  4018,  4024,  4025,  4033,  4034,
    4035,  4036,  4037,  4044,  4055,  4063,  4066,  4070,  4074,  4084,
    4089,  4097,  4110,  4118,  4121,  4125,  4129,  4155,  4161,  4169,
    4180,  4201,  4210,  4218,  4228,  4232,  4236,  4243,  4260,  4277,
    4285,  4293,  4302,  4306,  4315,  4326,  4338,  4348,  4361,  4368,
    4376,  4392,  4400,  4411,  4422,  4433,  4452,  4460,  4477,  4485,
    4492,  4503,  4514,  4525,  4544,  4550,  4556,  4563,  4572,  4575,
    4584,  4591,  4598,  4608,  4619,  4630,  4641,  4648,  4655,  4658,
    4675,  4685,  4692,  4698,  4703,  4709,  4713,  4719,  4720,  4721,
    4727,  4733,  4737,  4740,  4743,  4744,  4745,  4746,  4747,  4748,
    4753,  4756,  4761,  4786,  4789,  4843,  4847,  4851,  4855,  4859,
    4863,  4867,  4871,  4875,  4879,  4885,  4885,  4906,  4924,  4925,
    4928,  4941,  4949,  4955,  4968,  4971,  4980,  4991,  4992,  4996,
    5001,  5002,  5021,  5028,  5034,  5041,  5048,  5058,  5059,  5060,
    5061,  5062,  5063,  5064,  5067,  5071,  5075,  5079,  5083,  5087,
    5091,  5095,  5099,  5103,  5107,  5111,  5115,  5119,  5123,  5127,
    5139,  5144,  5144,  5145,  5148,  5159,  5168,  5181,  5194,  5195,
    5196,  5200,  5204,  5208,  5212,  5218,  5219,  5222,  5227,  5232,
    5237,  5244,  5251,  5258,  5266,  5274,  5282,  5283,  5286,  5287,
    5290,  5296,  5302,  5305,  5306,  5309,  5310,  5313,  5318,  5322,
    5325,  5328,  5331,  5336,  5340,  5343,  5350,  5356,  5365,  5370,
    5374,  5377,  5380,  5383,  5388,  5392,  5395,  5398,  5404,  5409,
    5412,  5415,  5419,  5424,  5437,  5441,  5446,  5452,  5456,  5461,
    5465,  5472,  5475,  5480
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ID", "HBLOCK", "POUND", "STRING", 
  "INCLUDE", "IMPORT", "INSERT", "CHARCONST", "NUM_INT", "NUM_FLOAT", 
  "NUM_UNSIGNED", "NUM_LONG", "NUM_ULONG", "NUM_LONGLONG", 
  "NUM_ULONGLONG", "TYPEDEF", "TYPE_INT", "TYPE_UNSIGNED", "TYPE_SHORT", 
  "TYPE_LONG", "TYPE_FLOAT", "TYPE_DOUBLE", "TYPE_CHAR", "TYPE_WCHAR", 
  "TYPE_VOID", "TYPE_SIGNED", "TYPE_BOOL", "TYPE_COMPLEX", "TYPE_TYPEDEF", 
  "TYPE_RAW", "LPAREN", "RPAREN", "COMMA", "SEMI", "EXTERN", "INIT", 
  "LBRACE", "RBRACE", "PERIOD", "CONST_QUAL", "VOLATILE", "REGISTER", 
  "STRUCT", "UNION", "EQUAL", "SIZEOF", "MODULE", "LBRACKET", "RBRACKET", 
  "ILLEGAL", "CONSTANT", "NAME", "RENAME", "NAMEWARN", "EXTEND", "PRAGMA", 
  "FEATURE", "VARARGS", "ENUM", "CLASS", "TYPENAME", "PRIVATE", "PUBLIC", 
  "PROTECTED", "COLON", "STATIC", "VIRTUAL", "FRIEND", "THROW", "CATCH", 
  "USING", "NAMESPACE", "NATIVE", "INLINE", "TYPEMAP", "EXCEPT", "ECHO", 
  "APPLY", "CLEAR", "SWIGTEMPLATE", "FRAGMENT", "WARN", "LESSTHAN", 
  "GREATERTHAN", "MODULO", "DELETE_KW", "TYPES", "PARMS", "NONID", 
  "DSTAR", "DCNOT", "TEMPLATE", "OPERATOR", "COPERATOR", "PARSETYPE", 
  "PARSEPARM", "CAST", "LOR", "LAND", "OR", "XOR", "AND", "RSHIFT", 
  "LSHIFT", "MINUS", "PLUS", "SLASH", "STAR", "LNOT", "NOT", "UMINUS", 
  "DCOLON", "$accept", "program", "interface", "declaration", 
  "swig_directive", "extend_directive", "@1", "apply_directive", 
  "clear_directive", "constant_directive", "echo_directive", 
  "except_directive", "stringtype", "fname", "fragment_directive", 
  "include_directive", "@2", "includetype", "inline_directive", 
  "insert_directive", "module_directive", "name_directive", 
  "native_directive", "pragma_directive", "pragma_arg", "pragma_lang", 
  "rename_directive", "rename_namewarn", "feature_directive", 
  "stringbracesemi", "featattr", "varargs_directive", "varargs_parms", 
  "typemap_directive", "typemap_type", "tm_list", "tm_tail", 
  "typemap_parm", "types_directive", "template_directive", 
  "warn_directive", "c_declaration", "@3", "c_decl", "c_decl_tail", 
  "initializer", "c_enum_forward_decl", "c_enum_decl", 
  "c_constructor_decl", "cpp_declaration", "cpp_class_decl", "@4", "@5", 
  "cpp_opt_declarators", "cpp_forward_class_decl", "cpp_template_decl", 
  "@6", "cpp_temp_possible", "template_parms", "cpp_using_decl", 
  "cpp_namespace_decl", "@7", "@8", "cpp_members", "@9", "@10", 
  "cpp_member", "cpp_constructor_decl", "cpp_destructor_decl", 
  "cpp_conversion_operator", "cpp_catch_decl", "cpp_protection_decl", 
  "cpp_nested", "@11", "@12", "@13", "nested_decl", "cpp_swig_directive", 
  "cpp_end", "cpp_vend", "anonymous_bitfield", "storage_class", "parms", 
  "rawparms", "ptail", "parm", "valparms", "rawvalparms", "valptail", 
  "valparm", "def_args", "parameter_declarator", 
  "typemap_parameter_declarator", "declarator", "notso_direct_declarator", 
  "direct_declarator", "abstract_declarator", 
  "direct_abstract_declarator", "pointer", "type_qualifier", 
  "type_qualifier_raw", "type", "rawtype", "type_right", "primitive_type", 
  "primitive_type_list", "type_specifier", "definetype", "@14", "ename", 
  "enumlist", "edecl", "etype", "expr", "exprnum", "exprcompound", 
  "inherit", "raw_inherit", "@15", "base_list", "base_specifier", 
  "access_specifier", "cpptype", "opt_virtual", "cpp_const", "ctor_end", 
  "ctor_initializer", "mem_initializer_list", "mem_initializer", 
  "template_decl", "idstring", "idstringopt", "idcolon", "idcolontail", 
  "idtemplate", "idcolonnt", "idcolontailnt", "string", "stringbrace", 
  "options", "kwargs", "stringnum", "empty", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   115,   116,   116,   116,   116,   116,   117,   117,   118,
     118,   118,   118,   118,   118,   118,   119,   119,   119,   119,
     119,   119,   119,   119,   119,   119,   119,   119,   119,   119,
     119,   119,   119,   119,   119,   119,   119,   121,   120,   122,
     123,   124,   124,   124,   125,   125,   126,   126,   126,   126,
     127,   128,   128,   129,   129,   129,   131,   130,   132,   132,
     133,   133,   134,   134,   134,   134,   135,   136,   136,   137,
     137,   138,   138,   139,   139,   140,   140,   141,   141,   141,
     142,   142,   143,   143,   143,   143,   143,   143,   143,   143,
     144,   144,   144,   145,   145,   146,   147,   147,   148,   148,
     148,   149,   150,   151,   151,   152,   152,   152,   153,   154,
     155,   156,   156,   156,   157,   156,   158,   159,   159,   159,
     160,   160,   160,   160,   161,   162,   162,   163,   164,   164,
     164,   164,   164,   164,   166,   165,   167,   165,   168,   168,
     169,   171,   170,   170,   172,   172,   172,   172,   172,   173,
     174,   174,   176,   175,   177,   175,   175,   178,   179,   178,
     178,   180,   178,   181,   181,   181,   181,   181,   181,   181,
     181,   181,   181,   181,   181,   181,   181,   181,   181,   181,
     181,   182,   183,   183,   184,   184,   184,   185,   186,   186,
     186,   188,   187,   189,   187,   190,   187,   191,   191,   192,
     192,   192,   192,   192,   192,   192,   192,   192,   192,   192,
     193,   193,   194,   194,   194,   195,   196,   196,   196,   196,
     196,   196,   196,   197,   198,   198,   199,   199,   200,   200,
     200,   201,   202,   202,   203,   203,   204,   204,   204,   205,
     205,   205,   205,   205,   206,   206,   206,   207,   207,   207,
     208,   208,   208,   208,   208,   208,   208,   208,   209,   209,
     209,   209,   209,   209,   209,   209,   210,   210,   210,   210,
     210,   210,   210,   210,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   212,   212,   212,   212,   212,   212,
     212,   213,   213,   213,   213,   214,   214,   215,   215,   215,
     216,   217,   217,   218,   218,   218,   218,   218,   218,   218,
     218,   218,   219,   220,   220,   221,   221,   221,   221,   221,
     221,   221,   221,   221,   221,   223,   222,   222,   224,   224,
     225,   225,   226,   226,   226,   227,   227,   228,   228,   228,
     228,   228,   228,   228,   228,   228,   228,   229,   229,   229,
     229,   229,   229,   229,   230,   230,   230,   230,   230,   230,
     230,   230,   230,   230,   230,   230,   230,   230,   230,   230,
     231,   233,   232,   232,   234,   234,   235,   235,   236,   236,
     236,   237,   237,   237,   237,   238,   238,   239,   239,   239,
     239,   240,   240,   240,   240,   240,   241,   241,   242,   242,
     243,   244,   244,   245,   245,   246,   246,   247,   247,   247,
     247,   247,   247,   248,   248,   248,   248,   249,   250,   250,
     250,   250,   250,   250,   251,   251,   251,   251,   252,   252,
     253,   253,   253,   254,   254,   255,   255,   255,   255,   255,
     255,   256,   256,   257
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     3,     2,     3,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     7,     5,
       3,     5,     5,     3,     2,     2,     5,     2,     5,     2,
       4,     1,     1,     7,     7,     5,     0,     7,     1,     1,
       2,     2,     1,     5,     5,     5,     3,     4,     3,     7,
       8,     5,     3,     1,     1,     3,     1,     4,     7,     6,
       1,     1,     7,     9,     8,    10,     5,     7,     6,     8,
       1,     1,     5,     4,     5,     7,     1,     3,     6,     6,
       8,     1,     2,     3,     1,     2,     3,     6,     5,     9,
       2,     1,     1,     1,     0,     6,     5,     1,     4,     1,
       1,     2,     5,     6,     4,     7,     8,     6,     1,     1,
       1,     1,     1,     1,     0,     9,     0,     8,     1,     2,
       4,     0,     6,     3,     1,     1,     1,     1,     1,     1,
       3,     4,     0,     6,     0,     5,     5,     2,     0,     6,
       1,     0,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     6,     6,     7,     8,     8,     7,     5,     2,     2,
       2,     0,     7,     0,     6,     0,     8,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     2,     4,     2,     5,     1,     2,     1,     1,
       1,     1,     1,     1,     2,     1,     3,     1,     2,     6,
       3,     1,     2,     1,     3,     1,     1,     1,     1,     2,
       3,     2,     2,     1,     2,     2,     1,     1,     1,     1,
       2,     3,     1,     2,     3,     4,     5,     4,     1,     2,
       3,     4,     5,     3,     4,     4,     1,     2,     4,     4,
       5,     3,     4,     4,     1,     2,     2,     3,     1,     2,
       1,     2,     3,     4,     3,     4,     2,     3,     3,     4,
       3,     3,     2,     2,     1,     1,     2,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     2,     2,     1,     2,
       1,     2,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     2,     1,     1,     1,
       3,     1,     1,     3,     1,     1,     1,     1,     1,     5,
       1,     1,     3,     4,     5,     5,     6,     1,     1,     1,
       1,     1,     1,     1,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     2,     2,     2,     2,
       1,     0,     3,     1,     1,     3,     2,     4,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     5,
       1,     3,     3,     4,     4,     3,     2,     1,     1,     3,
       2,     3,     1,     1,     1,     1,     1,     2,     4,     1,
       3,     1,     3,     3,     2,     2,     2,     2,     2,     4,
       1,     3,     1,     3,     3,     2,     2,     2,     2,     1,
       1,     1,     1,     3,     1,     3,     5,     1,     3,     3,
       5,     1,     1,     0
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
     443,     0,     0,     0,     0,     8,     4,   443,   315,   323,
     316,   317,   320,   321,   318,   319,   305,   322,   304,   324,
     443,   308,     0,   297,   298,   299,   382,   383,     0,   381,
     384,     0,     0,   411,     0,     0,   295,   443,   302,   303,
     312,   313,     0,   310,   409,     6,     0,     1,    13,    62,
      58,    59,     0,   219,    12,   216,   443,     0,     0,    80,
      81,   443,   443,     0,     0,   218,   220,   221,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     7,     9,    16,    17,    18,    19,    20,
      21,    22,    23,   443,    24,    25,    26,    27,    28,    29,
      30,     0,    31,    32,    33,    34,    35,    36,    10,   111,
     113,   112,    14,    11,   128,   129,   130,   131,   132,   133,
       0,   222,   443,   417,   402,   306,     0,   307,     0,     0,
       3,   301,   296,   443,   325,     0,     0,   280,   294,     0,
     246,   228,   443,   252,   443,   278,   274,   266,   243,   309,
     314,   311,     0,     0,   407,     5,    15,     0,   429,   217,
       0,     0,   434,     0,   443,     0,   300,     0,     0,     0,
       0,    76,     0,   443,   443,     0,     0,   443,   154,     0,
       0,    60,    61,     0,     0,    49,    47,    44,    45,   443,
       0,   443,     0,   443,   443,     0,   110,   443,   443,     0,
       0,     0,     0,     0,     0,   266,   443,     0,     0,   238,
     347,   348,   349,   350,   351,   352,   353,   236,     0,   231,
     443,   237,   233,   230,   412,   410,     0,   443,   280,     0,
     223,   443,     0,   274,   310,   225,   327,   241,     0,   239,
       0,     0,     0,   286,     0,     0,     0,     0,   341,     0,
     337,   340,   338,   242,   443,     0,   253,   279,   258,   292,
     293,   267,   244,   443,     0,   245,   443,     0,   276,   250,
     275,   258,   281,   416,   415,   414,   403,     0,   404,   428,
     114,   437,     0,    66,    43,   325,     0,   443,    68,     0,
       0,     0,    72,     0,     0,     0,    96,     0,     0,   150,
       0,   443,   152,     0,     0,   101,     0,     0,     0,   105,
     247,   248,   249,    40,     0,   102,   104,   405,     0,   406,
      52,     0,    51,     0,     0,   149,   143,     0,   443,     0,
       0,     0,     0,     0,     0,     0,   258,     0,   443,     0,
     329,   443,   443,   136,   311,   401,     0,   232,   235,   408,
       0,   280,   274,   310,     0,   266,   290,     0,   224,   227,
     288,   276,     0,   266,   281,   240,   326,     0,     0,   365,
     366,   368,   367,   369,   287,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   274,   310,   259,   443,
       0,   291,     0,   271,     0,     0,   284,     0,   251,   277,
     282,     0,   254,   413,     0,   443,     0,     0,   433,     0,
       0,    67,    37,    75,     0,     0,     0,     0,     0,     0,
       0,   151,     0,     0,   443,   443,     0,     0,   106,     0,
     443,     0,     0,     0,     0,     0,   141,    56,     0,     0,
       0,     0,    77,     0,   124,   443,     0,   310,     0,     0,
     120,   443,     0,   140,   371,     0,   370,   373,   443,     0,
       0,   281,   269,   443,   268,   282,     0,   342,     0,   294,
       0,   443,   364,   363,   359,   360,   358,   362,   361,   355,
     354,   357,   356,     0,   258,   260,   281,     0,   263,     0,
     273,   272,   289,   285,     0,   255,   283,   257,    64,    65,
      63,     0,   438,   439,   442,   441,   435,    41,    42,     0,
      74,    71,    73,   432,    91,   431,     0,    86,   443,   430,
      90,     0,   441,     0,     0,    97,   443,   187,   156,   155,
       0,   216,     0,     0,    48,    46,   443,    39,   103,   420,
       0,   422,     0,    55,     0,     0,   108,   443,   443,   443,
       0,     0,   332,     0,   331,   334,   443,   443,     0,   117,
     119,   116,     0,   121,   161,   180,     0,     0,     0,     0,
     220,     0,   207,   208,   200,   209,   178,   205,   201,   199,
     202,   203,   204,   206,   179,   175,   176,   163,   169,   173,
     172,     0,     0,   164,   165,   168,   174,   166,   170,   167,
     177,     0,   222,   443,   134,   234,   229,   226,   270,   343,
       0,   293,     0,     0,     0,   261,     0,   265,   264,   256,
     115,     0,     0,     0,   443,     0,   387,     0,   390,     0,
       0,     0,     0,    88,   443,     0,   153,   217,   443,     0,
      99,     0,    98,     0,     0,     0,   418,     0,   443,     0,
      50,   144,   145,   148,   147,   142,   146,     0,     0,     0,
      79,     0,   443,     0,   443,   325,   443,   127,     0,   443,
     443,     0,   158,   189,   188,   190,     0,     0,     0,   157,
       0,     0,     0,   310,   385,   372,   374,     0,   386,     0,
     345,   344,     0,   339,   262,   440,   436,    38,     0,   443,
       0,    82,   441,    93,    87,   443,     0,     0,    95,    69,
       0,     0,   107,   427,   425,   426,   421,   423,     0,    53,
      54,     0,    57,    78,   336,   333,   335,   330,   125,     0,
       0,     0,     0,     0,   397,   443,     0,     0,   162,     0,
       0,   443,     0,     0,   443,     0,   443,   193,   311,   171,
     443,   379,   378,   380,   443,   376,     0,   346,     0,     0,
     443,    94,     0,    89,   443,    84,    70,   100,   424,   419,
       0,   126,     0,   395,   396,   398,     0,   391,   392,   122,
     118,   443,     0,   443,     0,   137,   443,     0,     0,     0,
       0,   191,   443,   443,   375,     0,     0,    92,   388,     0,
      83,     0,   109,   393,   394,     0,   400,   123,     0,     0,
     443,     0,   443,   443,   443,   215,   443,     0,   197,   198,
       0,   377,   138,   135,     0,   389,    85,   399,   159,   443,
     182,     0,   443,     0,     0,   181,     0,   194,   195,   139,
     183,     0,   210,   211,   186,   443,   443,   192,     0,   212,
     214,   325,   185,   184,   196,     0,   213
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     3,     4,    83,    84,    85,   509,   572,   573,   574,
     575,    90,   320,   321,   576,    92,   548,    93,    94,   577,
      96,   578,    98,   579,   511,   170,   580,   101,   581,   517,
     417,   582,   295,   583,   304,   192,   315,   193,   584,   585,
     586,   587,   405,   109,   561,   449,   110,   111,   112,   113,
     114,   689,   452,   823,   588,   589,   547,   655,   324,   590,
     118,   424,   301,   591,   739,   671,   592,   593,   594,   595,
     596,   597,   598,   816,   792,   848,   817,   599,   830,   840,
     600,   601,   229,   230,   358,   231,   218,   219,   347,   220,
     140,   141,   309,   342,   256,   143,   232,   145,   204,    35,
      36,   248,   166,    38,    39,    40,    41,   239,   240,   339,
     553,   554,   725,   476,   250,   251,   455,   456,   603,   685,
     686,   754,    42,   687,   841,   667,   733,   774,   775,   123,
     281,   318,    43,   154,    44,   542,   646,   252,   520,   161,
     282,   506,   235
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -686
static const short yypact[] =
{
     397,  2631,  2686,    33,  2191,  -686,  -686,   -49,  -686,  -686,
    -686,  -686,  -686,  -686,  -686,  -686,  -686,  -686,  -686,  -686,
     -49,  -686,     1,  -686,  -686,  -686,  -686,  -686,    67,  -686,
    -686,   -64,   -25,  -686,    84,  1206,   630,   808,   630,  -686,
    -686,  1516,    67,  -686,   -17,  -686,   113,  -686,     7,  -686,
    -686,  -686,   126,  -686,  -686,   229,   210,  2740,   237,  -686,
    -686,   210,   272,   277,   300,  -686,  -686,  -686,   312,    77,
     199,   334,   141,   340,   338,   250,  3044,  3044,   381,   388,
     229,   436,   434,  -686,  -686,  -686,  -686,  -686,  -686,  -686,
    -686,  -686,  -686,   210,  -686,  -686,  -686,  -686,  -686,  -686,
    -686,   953,  -686,  -686,  -686,  -686,  -686,  -686,  -686,  -686,
    -686,  -686,  -686,  -686,  -686,  -686,  -686,  -686,  -686,  -686,
    3098,  -686,  2880,  -686,  -686,  -686,   310,  -686,    24,   320,
    -686,   630,  -686,  1983,     2,  1402,  1927,    75,   358,    67,
    -686,  -686,    66,    19,    66,   103,    74,   299,  -686,  -686,
    -686,  -686,   486,   102,  -686,  -686,  -686,   618,  -686,    57,
     618,   618,  -686,   464,   154,   964,  -686,   610,    67,   499,
     503,  -686,   618,  2935,  2990,    67,   476,   236,  -686,   475,
     513,  -686,  -686,   618,   529,  -686,  -686,  -686,   536,  2990,
     518,   225,   523,   528,   618,   229,   536,  2990,  2990,    67,
     229,   324,   687,   618,   285,   484,    76,  1010,   321,  -686,
    -686,  -686,  -686,  -686,  -686,  -686,  -686,  -686,   481,  -686,
     545,  -686,  -686,  -686,  -686,   -17,   496,  2038,   172,   555,
    -686,   562,   568,   207,   512,  -686,  -686,  -686,   964,  -686,
    1927,  1927,   577,  -686,  1927,  1927,  1927,  1927,   590,  1423,
    -686,  -686,   536,  1591,  2038,    67,   184,   103,  -686,  -686,
     535,  -686,  -686,  2990,  1456,  -686,  2990,  1559,    75,   184,
     103,   573,  1033,  -686,  -686,   -17,  -686,   620,   536,  -686,
    -686,   180,   633,  -686,  -686,   673,   204,    66,  -686,   653,
     652,   662,   659,   489,   666,   676,  -686,   679,   681,  -686,
      67,  -686,  -686,   699,   702,  -686,   708,   713,  3044,  -686,
    -686,  -686,  -686,  -686,  3044,  -686,  -686,  -686,   717,  -686,
    -686,   690,   194,   719,   629,  -686,  -686,    32,     5,   814,
     814,   726,   680,    21,   729,   687,   682,  1033,   212,   734,
    -686,  2093,  1028,  -686,   592,  -686,  2880,  -686,  -686,  -686,
     320,   259,  1047,   684,   359,  -686,  -686,  2990,  -686,  -686,
    -686,   259,   377,   694,   814,  -686,  1591,  1177,  3152,  -686,
    -686,  -686,  -686,  -686,  -686,  1927,  1927,  1927,  1927,  1927,
    1927,  1927,  1927,  1927,  1927,  1927,   905,   -26,  -686,  2990,
    1613,  -686,   760,  -686,  1580,   761,  -686,  1737,   184,   103,
     978,   687,   184,  -686,   287,  -686,   618,  1153,  -686,   767,
     771,  -686,  -686,  -686,   351,   820,  1542,   762,  2990,   964,
     776,  -686,   784,  2280,  -686,   316,  3044,   594,   792,   790,
     528,   171,   795,   618,  2990,   803,  -686,  -686,   170,   814,
     687,   -11,  -686,  1044,  -686,   837,   809,   680,   815,   731,
    -686,   414,  1308,  -686,  -686,   812,  -686,  -686,   545,    67,
     694,  -686,  -686,   562,  -686,   259,   471,  1927,  1716,  1770,
      -2,   808,  1608,  1186,  1215,  1112,  1148,   838,   838,   621,
     621,  -686,  -686,   575,   694,  -686,   687,   823,  -686,  2057,
    -686,  -686,  -686,  -686,   687,   184,   103,   184,  -686,  -686,
     536,  2369,  -686,   807,  -686,   194,   819,  -686,  -686,  1308,
    -686,  -686,   536,  -686,  -686,  -686,   829,  -686,   364,   536,
    -686,   816,   149,   706,   820,  -686,   364,  -686,  -686,  -686,
    2458,   229,  3206,   645,  -686,  -686,  2990,  -686,  -686,   211,
     752,  -686,   782,  -686,   835,   833,  -686,   294,  -686,   364,
     271,   687,   834,   206,  -686,  -686,   936,  2990,   964,  -686,
    -686,  -686,   843,  -686,  -686,  -686,   840,   818,   821,   825,
     774,   486,  -686,  -686,  -686,  -686,  -686,  -686,  -686,  -686,
    -686,  -686,  -686,  -686,  -686,  -686,  -686,  -686,  -686,  -686,
    -686,   857,  1308,  -686,  -686,  -686,  -686,  -686,  -686,  -686,
    -686,  2794,   860,   852,  -686,  -686,  -686,  -686,  -686,  1591,
    1927,  1152,  1927,   849,   864,  -686,   643,  -686,  -686,   184,
    -686,   618,   618,   861,  2990,   869,   836,  1017,  -686,  1153,
     510,   618,   870,  -686,   364,   892,  -686,   536,    10,   964,
    -686,  3044,  -686,   872,   926,   114,  -686,   137,  2880,   142,
    -686,  -686,  -686,  -686,  -686,  -686,  -686,  3152,  2547,   895,
    -686,  1873,   837,   667,  2990,   673,   866,  -686,   900,  1028,
    2990,  1308,  -686,  -686,  -686,  -686,   486,   902,   964,  -686,
    3152,   858,   387,   904,  -686,   906,  -686,   375,  -686,  1308,
    1591,  1591,  1927,  -686,  -686,  -686,  -686,  -686,   909,  2990,
     918,  -686,   536,   917,  -686,   364,   832,  1017,  -686,  -686,
     921,   922,  -686,  -686,   211,  -686,   211,  -686,   874,  -686,
    -686,  1013,  -686,  -686,  -686,  -686,  1591,  -686,  -686,   731,
     927,   928,    67,   607,  -686,    66,   731,   929,  -686,  1308,
     932,  2990,   731,   -12,  2093,  1927,   -10,  -686,   163,  -686,
     852,  -686,  -686,  -686,   852,  -686,   931,  1591,   930,   939,
    2990,  -686,   941,  -686,   364,  -686,  -686,  -686,  -686,  -686,
     946,  -686,   614,  -686,   949,  -686,   954,  -686,  -686,  -686,
    -686,    66,   950,  2990,   955,  -686,  2990,   959,   961,   967,
    1085,  -686,   964,   852,  -686,    67,   881,  -686,  -686,   970,
    -686,   972,  -686,  -686,  -686,    67,  -686,  -686,  1308,   976,
     364,   980,  2990,  2990,   936,  -686,   964,   982,  -686,  -686,
     301,  -686,  -686,  -686,   731,  -686,  -686,  -686,  -686,   364,
    -686,   672,   364,   985,   988,  -686,   999,  -686,  -686,  -686,
    -686,   407,  -686,  -686,  -686,   364,   364,  -686,  1001,  -686,
    -686,   673,  -686,  -686,  -686,  1002,  -686
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
    -686,  -686,  -295,  -686,  -686,  -686,  -686,    30,    39,    44,
      49,  -686,   588,  -686,    51,  -686,  -686,  -686,  -686,    54,
    -686,    60,  -686,    61,  -686,  -686,    63,  -686,    64,  -493,
    -505,    69,  -686,    70,  -686,  -303,   582,   -54,    85,    87,
      97,   105,  -686,   494,  -685,   380,  -686,  -686,  -686,  -686,
     504,  -686,  -686,  -686,     6,    36,  -686,  -686,  -686,   110,
    -686,  -686,  -686,  -460,  -686,  -686,  -686,   505,  -686,  -686,
     111,  -686,  -686,  -686,  -686,  -686,   242,  -686,  -686,  -307,
    -686,    -3,   463,   862,   598,    13,   416,  -686,   604,   721,
      -1,   608,  -686,   158,   602,  -203,   -34,   654,    46,   -27,
    -686,   318,    15,   -33,  -686,  1037,  -686,  -266,  -686,  -686,
    -686,   423,  -686,   649,   -94,  -686,  -686,  -686,  -686,   293,
     339,  -686,    18,   344,  -366,   280,  -686,  -686,   295,  1082,
     -73,  -686,    17,  -190,   -81,  -686,  -241,   677,   570,   203,
    -157,  -403,     0
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -444
static const short yytable[] =
{
       5,   120,   131,   144,   121,   429,   423,   124,   485,   132,
     115,   149,   236,   523,    34,    46,    37,    37,   632,   409,
     124,   786,   190,   485,     7,   354,   305,     7,   221,   791,
     362,   633,   612,    47,    86,   349,   122,   148,   279,  -403,
     116,   237,   126,    87,   771,   127,   709,   225,    88,   623,
     128,   780,   263,    89,   147,    91,   162,   785,    95,   151,
     129,   162,   171,   279,    97,    99,   486,   100,   102,   264,
       7,   273,   275,   103,   104,   122,   152,     7,     7,   338,
       7,   551,   437,   146,   277,   403,   176,   179,   283,   105,
     122,   106,   787,   162,   289,   122,   280,   153,   138,   293,
     199,   107,   613,   156,   149,     7,   238,   254,   254,   108,
     501,   260,    31,   134,   117,   119,    33,   714,   205,   224,
     130,   317,   222,   533,   135,   135,   354,   362,   331,   530,
     334,   138,   679,   136,   701,   217,   266,    37,   208,   839,
     716,   262,   148,   265,   148,   181,   719,   226,    37,   155,
     234,   175,   627,   267,   258,   279,   261,   311,    31,   157,
     635,   466,    33,   271,   124,    31,    31,    31,    31,    33,
      33,    33,    33,     7,   539,     7,   158,   124,   268,   233,
     182,   720,   205,   659,   259,   290,   255,   255,    37,    37,
     666,   312,   298,   316,   319,   142,  -404,   274,   761,   453,
     279,   285,   177,   286,    37,   133,   340,     7,   147,   715,
       7,   738,    37,    37,   765,   406,   326,   389,   332,   258,
     348,   336,   135,   127,   205,   344,   703,   407,     7,   756,
     793,   359,   717,   434,   390,   158,   466,   146,   178,   122,
     133,   662,    37,   160,   353,   355,   663,   330,   444,   502,
     363,  -328,   221,   658,   187,   205,   158,   135,   133,   203,
     430,    31,   540,    31,   168,    33,   541,    33,   707,    37,
     167,   387,   388,   352,   202,   135,   544,   279,    37,   782,
     138,    37,   139,   300,   139,   258,   410,   148,     7,   258,
      31,   498,   227,   158,    33,    31,   200,   122,    31,    33,
     386,     5,    33,   332,   644,   169,   391,   660,   329,   135,
     172,   361,    53,   504,   138,   451,    31,   422,   333,   139,
      33,   122,   504,   287,     7,   645,   499,   328,   124,   137,
     158,   531,   330,   173,    53,   138,   750,   139,   124,   762,
     838,   450,   148,   521,   457,   174,   355,   355,   828,   310,
     441,   223,   258,   531,   258,   510,    37,   158,   447,   217,
     343,    37,    65,    66,    67,    26,    27,   180,   459,   460,
     463,   184,    37,   183,   185,   165,    31,   186,     7,   440,
      33,   355,    29,    30,    65,    66,    67,   330,    82,   335,
     746,   272,   263,   462,   191,   191,   365,   255,   801,   731,
      23,    24,    25,   484,    37,     5,    23,    24,    25,   264,
     263,   464,    31,   470,   194,    31,    33,   258,   258,    33,
     120,   195,   532,   121,     5,   121,   747,   264,   329,   115,
     316,   525,   205,    37,   138,   625,   205,   144,   207,   751,
     752,   753,   611,   849,   831,   555,   850,   545,   666,    37,
     563,   148,   602,    86,   851,   205,   355,   258,   348,   116,
     258,   134,    87,   359,   695,   696,    31,    88,   138,   197,
      33,   148,    89,   768,    91,   769,   606,    95,    31,    26,
      27,   136,    33,    97,    99,   562,   100,   102,   147,     7,
     677,   626,   103,   104,     1,     2,    29,    30,   120,   626,
     284,   121,   291,   258,   263,   608,   292,   115,   105,   602,
     106,   258,   299,     7,   302,   259,   303,   146,   628,   198,
     107,   264,   626,   415,   416,   844,   628,   120,   108,   626,
     121,    86,   306,   117,   119,   504,   115,   116,   852,   853,
      87,   205,   279,   286,   657,    88,   704,   121,     5,   628,
      89,    37,    91,   653,   221,    95,   628,   308,   521,   313,
      86,    97,    99,   314,   100,   102,   116,   345,   258,    87,
     103,   104,    37,   518,    88,   205,   337,   526,   131,    89,
     346,    91,   350,   654,    95,   855,   105,   711,   106,   356,
      97,    99,   602,   100,   102,   740,   549,   357,   107,   103,
     104,    31,   360,   688,   364,    33,   108,   626,   389,   615,
     368,   117,   119,   276,   202,   105,   158,   106,   683,   682,
     138,   276,   139,   373,   158,   390,   191,   107,   453,   142,
     534,  -443,   191,   535,   628,   108,   296,   297,   124,    37,
     117,   119,   451,   777,   288,   138,   778,   205,   222,   513,
     803,   158,   307,   804,   404,   120,   205,   391,   121,   454,
     323,   217,   555,    37,   115,   400,   734,   408,   450,   148,
       7,   602,    23,    24,    25,   208,   389,   694,   626,    37,
     205,   640,   634,   236,   515,    37,   471,   411,    86,   602,
       7,   412,   641,   390,   116,   205,   413,    87,   205,   748,
     286,   418,    88,   728,   755,   628,   414,    89,   842,    91,
     419,   843,    95,   420,    37,   436,   669,   421,    97,    99,
     333,   100,   102,   205,   432,   433,   392,   103,   104,   395,
     384,   385,   159,   425,   779,   148,   426,   626,   205,   602,
     630,   631,   427,   105,   191,   106,   124,   428,   269,   776,
     688,   431,   188,   435,   688,   107,    37,   196,    31,    37,
     438,   447,    33,   108,   628,   442,   558,   559,   117,   119,
     560,   202,   439,   445,   443,    37,   461,   138,    31,   139,
     807,   148,    33,   626,   249,   253,   465,   626,   705,   788,
     330,   257,   819,   688,   490,   492,   524,   710,    37,   255,
     270,    37,   626,   507,   446,   626,   269,   508,   602,   205,
     628,     7,   821,   205,   628,   527,   819,     7,   626,   626,
     528,   729,   776,     7,   513,   536,   158,    37,    37,   628,
     537,   543,   628,   205,   278,     7,   742,   278,   278,   546,
     552,   133,   621,   556,   278,   628,   628,   286,   557,   278,
     639,   604,   487,   286,   622,   134,   514,   617,   135,   515,
     278,     7,   624,   629,   764,   286,   647,   648,   763,   649,
     398,   278,   322,   650,   402,   136,   670,   327,   278,   672,
     278,   661,   257,   692,     7,   673,   676,   270,   674,   366,
     367,   744,   675,   369,   370,   371,   372,   678,   693,    31,
    -160,   697,   699,    33,   706,    31,   712,   700,     7,    33,
     516,    31,   137,   394,   286,    33,   397,   822,   138,   681,
     139,   684,   399,    31,   202,   745,   139,    33,   708,   713,
     138,   723,   139,   732,   735,   741,   202,   398,   254,   402,
     749,   750,   138,   758,   139,   382,   383,   384,   385,    31,
     818,   760,   631,    33,   824,   135,     7,   766,   767,   191,
     770,   772,   202,   781,   773,   783,   797,     7,   138,   664,
     139,   796,    31,   798,   818,   721,    33,   800,    23,    24,
      25,     7,   802,   665,   805,   202,   201,   806,   483,   810,
     808,   138,   812,   139,   813,   503,    31,   286,   743,   643,
      33,   814,   495,   497,   825,   257,   270,   625,   826,   361,
     829,   254,   538,     7,   832,   399,     7,   255,   837,   845,
     668,   513,   846,   158,   472,   473,   474,   475,   135,   477,
     478,   479,   480,   481,   482,   847,     7,   854,   856,   489,
     270,   651,   483,   341,    31,   495,   744,     7,    33,   736,
       7,   652,   656,   514,   496,    31,   515,   202,   836,    33,
     325,   607,   605,   138,   718,   139,   333,   458,   202,    31,
      23,    24,    25,    33,   138,   134,   139,   333,   150,   614,
     227,   500,   494,   278,   505,   727,   820,   698,   616,   794,
     255,   512,   519,   522,   835,   136,   619,   135,   795,   448,
     827,    31,   125,   642,    31,    33,     0,   516,    33,     0,
     278,     0,     0,     0,   202,   550,   609,   202,   482,   496,
     138,   815,   139,   138,    31,   139,     0,   730,    33,     0,
       0,     0,     0,   737,     0,    31,     0,   401,    31,    33,
       0,     0,    33,     0,     0,   255,     0,     0,   494,     0,
       0,   361,     0,   616,     0,     7,   255,     0,     0,   158,
       0,     0,   759,     0,   210,   211,   212,   213,   214,   215,
     216,     8,     9,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,   375,   376,   377,   378,   379,
     380,   381,   382,   383,   384,   385,     0,    26,    27,     0,
       0,   519,     0,     0,   784,     0,     0,   789,   637,     7,
     519,   467,     0,    28,    29,    30,   379,   380,   381,   382,
     383,   384,   385,   799,     0,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,     0,
       0,     0,     0,    31,     0,     0,   809,    33,     0,   811,
       0,    26,    27,   380,   381,   382,   383,   384,   385,   690,
       0,   691,   138,     0,     0,     0,     0,    28,    29,    30,
       0,     0,     0,     0,     0,   833,   834,   375,   376,   377,
     378,   468,   380,   381,   382,   383,   384,   469,   377,   378,
     379,   380,   381,   382,   383,   384,   385,    31,   278,   278,
       0,    33,     0,     0,   519,     0,   702,     0,   278,   564,
     726,  -443,    49,     0,     0,     0,     0,    52,   378,   379,
     380,   381,   382,   383,   384,   385,    53,  -443,  -443,  -443,
    -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,
    -443,   757,     0,     0,   565,    55,     0,     0,  -443,     0,
    -443,  -443,  -443,  -443,  -443,     0,     0,     0,     0,     0,
       0,    57,    58,    59,    60,   566,    62,    63,    64,  -443,
    -443,  -443,   567,   568,   569,     0,    65,   570,    67,     0,
      68,    69,     0,     0,   519,    73,     0,    75,    76,    77,
      78,    79,    80,     0,   790,     0,     0,    81,     0,  -443,
       0,     0,    82,  -443,  -443,     7,     0,     0,   158,     0,
       0,     0,     0,   210,   211,   212,   213,   214,   215,   216,
     571,     8,     9,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,   241,     0,     0,     0,     0,
       0,     0,     0,     0,    23,    24,    25,    26,    27,     0,
     242,     0,     0,   243,     0,     0,     0,     0,     0,     7,
       0,     0,   158,    28,    29,    30,     0,   210,   211,   212,
     213,   214,   215,   216,   374,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,   241,
       0,     0,     0,    31,     0,     0,     0,    33,    23,    24,
      25,    26,    27,     0,   242,     0,     0,   393,     0,   244,
     245,     0,     0,   246,   247,     0,     0,    28,    29,    30,
       0,     0,     0,   375,   376,   377,   378,   379,   380,   381,
     382,   383,   384,   385,     0,     8,     9,    10,    11,    12,
      13,    14,    15,     0,    17,   276,    19,    31,   158,     0,
       0,    33,     0,   210,   211,   212,   213,   214,   215,   216,
       0,     0,     7,   244,   245,   158,     0,   246,   247,     0,
     210,   211,   212,   213,   214,   215,   216,     0,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,   241,     0,     0,     0,     0,     0,     0,     0,
       0,    23,    24,    25,    26,    27,     0,   242,     0,     0,
     396,     0,     0,     0,     0,     0,     7,     0,     0,   158,
      28,    29,    30,     0,   210,   211,   212,   213,   214,   215,
     216,   491,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,   241,     0,     0,     0,
      31,     0,     0,     0,    33,    23,    24,    25,    26,    27,
       0,   242,     0,     0,   488,     0,   244,   245,     0,     0,
     246,   247,     0,     0,    28,    29,    30,     0,     0,     0,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   375,   376,   377,   378,   379,   380,   381,   382,   383,
     384,   385,     0,     0,    31,     0,     0,     0,    33,   376,
     377,   378,   379,   380,   381,   382,   383,   384,   385,     7,
     244,   245,   158,     0,   246,   247,     0,   210,   211,   212,
     213,   214,   215,   216,     0,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,   241,
     610,     0,     0,     0,     0,     0,     0,     0,    23,    24,
      25,    26,    27,     0,   242,     0,     0,     0,     0,     0,
       0,     0,     0,     7,     0,     0,   158,    28,    29,    30,
       0,   210,   211,   212,   213,   214,   215,   216,   493,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,   241,     0,     0,     0,    31,     0,     0,
       0,    33,    23,    24,    25,    26,    27,     0,   242,     0,
       0,     0,     0,   244,   245,     0,     0,   246,   247,     0,
       0,    28,    29,    30,     0,     0,     0,   375,   376,   377,
     378,   379,   380,   381,   382,   383,   384,   385,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    31,     0,     0,     0,    33,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     7,   244,   245,   158,
     138,   246,   247,   724,   210,   211,   212,   213,   214,   215,
     216,     0,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,   241,     0,     0,     0,
       0,     0,     0,     0,     0,    23,    24,    25,    26,    27,
       0,   242,     0,     0,     0,     0,     0,     0,     0,     0,
       7,     0,     0,   158,    28,    29,    30,     0,   210,   211,
     212,   213,   214,   215,   216,     0,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
     241,     0,     0,     0,    31,     0,     0,     0,    33,    23,
      24,    25,    26,    27,     0,   242,     0,     0,     0,     0,
     244,   245,     0,     0,   246,   247,     7,     0,    28,    29,
      30,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,   227,     0,    31,     0,
       0,     0,    33,     0,    22,    23,    24,    25,    26,    27,
       0,     0,     0,   135,   244,   245,     0,     0,   246,   247,
       0,     7,     0,     0,    28,    29,    30,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,   227,     0,     0,    31,     0,     0,    32,    33,    22,
      23,    24,    25,    26,    27,     0,     0,   228,   135,     0,
       0,     0,     0,   138,     0,     0,     7,     0,     0,    28,
      29,    30,     0,     0,     0,     0,     0,     0,   618,     0,
       0,     0,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,     0,     0,     0,    31,
       0,     0,    32,    33,    22,    23,    24,    25,    26,    27,
       0,     0,   351,     0,     0,     0,     0,     0,   138,     0,
       0,     0,     0,     0,    28,    29,    30,   375,   376,   377,
     378,   379,   380,   381,   382,   383,   384,   385,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    31,     0,     0,    32,    33,     0,
       0,    -2,    48,     0,  -443,    49,     0,   329,    50,    51,
      52,     0,     0,   138,     0,     0,     0,     0,     0,    53,
    -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,
    -443,  -443,  -443,  -443,     0,     0,     0,    54,    55,     0,
       0,     0,     0,  -443,  -443,  -443,  -443,  -443,     0,     0,
      56,     0,     0,     0,    57,    58,    59,    60,    61,    62,
      63,    64,  -443,  -443,  -443,     0,     0,     0,     0,    65,
      66,    67,     0,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,     0,     0,     0,     0,
      81,    48,  -443,  -443,    49,    82,  -443,    50,    51,    52,
       0,     0,     0,     0,     0,     0,     0,     0,    53,  -443,
    -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,
    -443,  -443,  -443,     0,     0,     0,    54,    55,     0,     0,
     529,     0,  -443,  -443,  -443,  -443,  -443,     0,     0,    56,
       0,     0,     0,    57,    58,    59,    60,    61,    62,    63,
      64,  -443,  -443,  -443,     0,     0,     0,     0,    65,    66,
      67,     0,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,     0,     0,     0,     0,    81,
      48,  -443,  -443,    49,    82,  -443,    50,    51,    52,     0,
       0,     0,     0,     0,     0,     0,     0,    53,  -443,  -443,
    -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,
    -443,  -443,     0,     0,     0,    54,    55,     0,     0,   620,
       0,  -443,  -443,  -443,  -443,  -443,     0,     0,    56,     0,
       0,     0,    57,    58,    59,    60,    61,    62,    63,    64,
    -443,  -443,  -443,     0,     0,     0,     0,    65,    66,    67,
       0,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,     0,     0,     0,     0,    81,    48,
    -443,  -443,    49,    82,  -443,    50,    51,    52,     0,     0,
       0,     0,     0,     0,     0,     0,    53,  -443,  -443,  -443,
    -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,
    -443,     0,     0,     0,    54,    55,     0,     0,   636,     0,
    -443,  -443,  -443,  -443,  -443,     0,     0,    56,     0,     0,
       0,    57,    58,    59,    60,    61,    62,    63,    64,  -443,
    -443,  -443,     0,     0,     0,     0,    65,    66,    67,     0,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,     0,     0,     0,     0,    81,    48,  -443,
    -443,    49,    82,  -443,    50,    51,    52,     0,     0,     0,
       0,     0,     0,     0,     0,    53,  -443,  -443,  -443,  -443,
    -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,  -443,
       0,     0,     0,    54,    55,     0,     0,     0,     0,  -443,
    -443,  -443,  -443,  -443,     0,     0,    56,     0,   722,     0,
      57,    58,    59,    60,    61,    62,    63,    64,  -443,  -443,
    -443,     0,     0,     0,     0,    65,    66,    67,     0,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,     6,     0,     7,     0,    81,     0,  -443,     0,
       0,    82,  -443,     0,     0,     0,     0,     0,     0,     0,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,     0,     0,     0,     0,     0,     0,
       0,     0,    22,    23,    24,    25,    26,    27,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    45,     0,     7,
       0,     0,    28,    29,    30,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,     0,
       0,     0,    31,     0,     0,    32,    33,    22,    23,    24,
      25,    26,    27,     0,     0,     0,     0,     0,     0,     0,
       0,   163,     0,   164,     0,     0,     0,    28,    29,    30,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,     0,     0,     0,     0,    31,     0,     0,
      32,    33,    23,    24,    25,    26,    27,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     7,     0,     0,
       0,    28,    29,    30,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,     0,     0,     0,
       0,    31,     0,     0,     0,    33,    23,    24,    25,    26,
      27,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   206,    29,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     7,     0,    31,   209,     0,     0,    33,
     680,   210,   211,   212,   213,   214,   215,   216,     0,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,     0,     0,     0,     0,     0,     0,     0,
       0,    22,    23,    24,    25,    26,    27,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     7,     0,
       0,    28,    29,    30,     0,     0,   294,     0,     0,     0,
       0,     0,     0,     0,     8,     9,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,     0,     0,
       0,    31,     0,     0,    32,    33,    22,    23,    24,    25,
      26,    27,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     7,     0,     0,    28,    29,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,     0,     0,     0,    31,     0,     0,    32,
      33,    22,    23,    24,    25,    26,    27,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     7,     0,     0,
       0,    28,    29,    30,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,   189,     0,     0,
       0,    31,     0,     0,    32,    33,    23,    24,    25,    26,
      27,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     7,     0,     0,     0,    28,    29,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,     0,     0,     0,     0,    31,     0,     0,     0,    33,
      23,    24,    25,    26,    27,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     7,     0,     0,     0,   206,
      29,    30,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     8,     9,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,     0,     0,     0,     0,    31,
       0,     0,     0,    33,    23,    24,    25,    26,    27,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   638,
       0,     0,     0,    28,    29,    30,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,     0,
       0,     0,     0,    31,     0,     0,     0,    33,    23,    24,
      25,    26,    27,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    28,    29,    30,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    31,     0,     0,
       0,    33
};

static const short yycheck[] =
{
       0,     4,    35,    37,     4,   308,   301,     7,    34,    36,
       4,    38,    10,   416,     1,     2,     1,     2,   523,   285,
      20,    33,    76,    34,     3,   228,   183,     3,   122,    39,
     233,   524,    34,     0,     4,   225,    85,    37,     6,    34,
       4,    39,    41,     4,   729,    28,    36,   128,     4,   509,
     114,   736,    33,     4,    37,     4,    56,   742,     4,    42,
      85,    61,    62,     6,     4,     4,    92,     4,     4,    50,
       3,   152,   153,     4,     4,    85,    93,     3,     3,     3,
       3,    92,    50,    37,   157,   275,    69,    70,   161,     4,
      85,     4,   104,    93,   167,    85,    39,   114,   110,   172,
      82,     4,   104,    96,   131,     3,   104,    33,    33,     4,
     405,   138,    91,    47,     4,     4,    95,     3,   101,    95,
      36,   194,   122,   426,    50,    50,   329,   330,   201,   424,
     203,   110,   592,    67,   627,   122,    33,   122,   120,   824,
       3,   142,   142,   144,   144,     4,     4,   129,   133,    36,
     133,    74,   518,    50,   137,     6,   139,   191,    91,    33,
     526,   364,    95,   146,   164,    91,    91,    91,    91,    95,
      95,    95,    95,     3,     3,     3,     6,   177,   104,   133,
      39,    39,   165,   549,   138,   168,   112,   112,   173,   174,
     556,   191,   175,   193,   194,    37,    47,    95,   703,    36,
       6,    47,     3,    33,   189,    33,   206,     3,   191,    95,
       3,   671,   197,   198,   707,    35,   199,    33,   201,   202,
     220,   204,    50,   206,   207,   208,   629,    47,     3,   689,
      67,   231,    95,    39,    50,     6,   439,   191,    39,    85,
      33,    35,   227,    33,   227,   228,    40,   201,    36,   406,
     233,    39,   346,   548,     4,   238,     6,    50,    33,   101,
     314,    91,    91,    91,    61,    95,    95,    95,   634,   254,
      33,   254,   255,   227,   104,    50,   433,     6,   263,   739,
     110,   266,   112,    47,   112,   268,   287,   287,     3,   272,
      91,     4,    33,     6,    95,    91,    93,    85,    91,    95,
     254,   301,    95,   286,    93,    33,   260,    36,   104,    50,
      33,   104,    18,   407,   110,   342,    91,   300,    33,   112,
      95,    85,   416,   165,     3,   114,    39,     3,   328,   104,
       6,    37,   286,    33,    18,   110,    35,   112,   338,   705,
      39,   342,   342,   416,   344,    33,   329,   330,   808,   191,
     333,    41,   335,    37,   337,     4,   341,     6,   341,   346,
      39,   346,    68,    69,    70,    45,    46,    33,   350,   352,
     357,    33,   357,    33,    36,    57,    91,    39,     3,   333,
      95,   364,    62,    63,    68,    69,    70,   341,    94,   104,
       3,    92,    33,    34,    76,    77,   238,   112,   764,   665,
      42,    43,    44,   386,   389,   405,    42,    43,    44,    50,
      33,    34,    91,   367,    33,    91,    95,   400,   401,    95,
     423,    33,   425,   423,   424,   425,    39,    50,   104,   423,
     430,   418,   415,   418,   110,    71,   419,   471,   120,    64,
      65,    66,   469,    36,   810,   445,    39,   434,   814,   434,
     451,   451,   452,   423,    47,   438,   439,   440,   458,   423,
     443,    47,   423,   463,   621,   622,    91,   423,   110,    33,
      95,   471,   423,   714,   423,   716,   459,   423,    91,    45,
      46,    67,    95,   423,   423,    71,   423,   423,   471,     3,
     571,   518,   423,   423,    97,    98,    62,    63,   501,   526,
      36,   501,     3,   486,    33,    34,     3,   501,   423,   509,
     423,   494,    36,     3,    39,   469,     3,   471,   518,    85,
     423,    50,   549,    34,    35,   832,   526,   530,   423,   556,
     530,   501,     3,   423,   423,   629,   530,   501,   845,   846,
     501,   524,     6,    33,   547,   501,    36,   547,   548,   549,
     501,   536,   501,   547,   648,   501,   556,    39,   631,    36,
     530,   501,   501,    35,   501,   501,   530,    86,   551,   530,
     501,   501,   557,   415,   530,   558,    92,   419,   611,   530,
      35,   530,    86,   547,   530,   851,   501,   641,   501,    34,
     530,   530,   592,   530,   530,   676,   438,    35,   501,   530,
     530,    91,    34,   603,    92,    95,   501,   634,    33,    34,
      33,   501,   501,     3,   104,   530,     6,   530,   601,   601,
     110,     3,   112,    33,     6,    50,   308,   530,    36,   471,
      36,    39,   314,    39,   634,   530,   173,   174,   638,   624,
     530,   530,   669,    36,    34,   110,    39,   630,   648,     4,
      36,     6,   189,    39,    34,   658,   639,   611,   658,    67,
     197,   648,   662,   648,   658,    92,   666,    34,   669,   669,
       3,   671,    42,    43,    44,   657,    33,    34,   705,   664,
     663,    36,   524,    10,    39,   670,   368,    34,   658,   689,
       3,    39,    47,    50,   658,   678,    34,   658,   681,   682,
      33,    35,   658,    36,   687,   705,    47,   658,    36,   658,
      34,    39,   658,    34,   699,    86,   558,    36,   658,   658,
      33,   658,   658,   706,    34,    35,   263,   658,   658,   266,
     109,   110,    55,    34,   735,   735,    34,   764,   721,   739,
      34,    35,    34,   658,   426,   658,   746,    34,   146,   732,
     750,    34,    75,    34,   754,   658,   741,    80,    91,   744,
      34,   744,    95,   658,   764,    36,    35,    36,   658,   658,
      39,   104,    92,    39,    92,   760,    92,   110,    91,   112,
     781,   781,    95,   810,   135,   136,    92,   814,   630,   743,
     744,   137,   792,   793,    34,    34,    34,   639,   783,   112,
     146,   786,   829,    36,   341,   832,   204,    36,   808,   792,
     810,     3,   795,   796,   814,    39,   816,     3,   845,   846,
      36,   663,   805,     3,     4,    33,     6,   812,   813,   829,
      40,    36,   832,   816,   157,     3,   678,   160,   161,    36,
       3,    33,    35,    34,   167,   845,   846,    33,    33,   172,
     532,    39,   389,    33,    35,    47,    36,    34,    50,    39,
     183,     3,    33,    47,   706,    33,   114,    85,    36,    34,
     268,   194,   195,    40,   272,    67,    33,   200,   201,    39,
     203,    47,   228,    34,     3,    67,   112,   233,    67,   240,
     241,    33,    67,   244,   245,   246,   247,    40,    34,    91,
      40,    40,    33,    95,    34,    91,    34,    71,     3,    95,
      90,    91,   104,   264,    33,    95,   267,    36,   110,   601,
     112,    69,   268,    91,   104,    67,   112,    95,    36,     3,
     110,    36,   112,    67,    34,    33,   104,   335,    33,   337,
      36,    35,   110,    34,   112,   107,   108,   109,   110,    91,
     792,    33,    35,    95,   796,    50,     3,    36,    36,   641,
      86,    34,   104,    34,    36,    33,    36,     3,   110,    33,
     112,    40,    91,    34,   816,   657,    95,    36,    42,    43,
      44,     3,    36,    47,    35,   104,    33,    33,   386,    34,
      40,   110,    33,   112,    33,   407,    91,    33,   680,   536,
      95,    34,   400,   401,    34,   351,   352,    71,    36,   104,
      34,    33,   430,     3,    34,   361,     3,   112,    36,    34,
     557,     4,    34,     6,   375,   376,   377,   378,    50,   380,
     381,   382,   383,   384,   385,    36,     3,    36,    36,   390,
     386,   547,   440,    33,    91,   443,    33,     3,    95,   669,
       3,   547,   547,    36,   400,    91,    39,   104,   816,    95,
     198,   463,   458,   110,   648,   112,    33,   346,   104,    91,
      42,    43,    44,    95,   110,    47,   112,    33,    41,   471,
      33,   404,   104,   406,   407,   662,   793,   624,   486,   750,
     112,   414,   415,   416,   814,    67,   494,    50,   754,    71,
     805,    91,    20,   533,    91,    95,    -1,    90,    95,    -1,
     433,    -1,    -1,    -1,   104,   438,   467,   104,   469,   465,
     110,    36,   112,   110,    91,   112,    -1,   664,    95,    -1,
      -1,    -1,    -1,   670,    -1,    91,    -1,   104,    91,    95,
      -1,    -1,    95,    -1,    -1,   112,    -1,    -1,   104,    -1,
      -1,   104,    -1,   551,    -1,     3,   112,    -1,    -1,     6,
      -1,    -1,   699,    -1,    11,    12,    13,    14,    15,    16,
      17,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,    -1,    45,    46,    -1,
      -1,   524,    -1,    -1,   741,    -1,    -1,   744,   531,     3,
     533,    34,    -1,    61,    62,    63,   104,   105,   106,   107,
     108,   109,   110,   760,    -1,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    -1,
      -1,    -1,    -1,    91,    -1,    -1,   783,    95,    -1,   786,
      -1,    45,    46,   105,   106,   107,   108,   109,   110,   610,
      -1,   612,   110,    -1,    -1,    -1,    -1,    61,    62,    63,
      -1,    -1,    -1,    -1,    -1,   812,   813,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   102,   103,
     104,   105,   106,   107,   108,   109,   110,    91,   621,   622,
      -1,    95,    -1,    -1,   627,    -1,   629,    -1,   631,     1,
     661,     3,     4,    -1,    -1,    -1,    -1,     9,   103,   104,
     105,   106,   107,   108,   109,   110,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,   692,    -1,    -1,    36,    37,    -1,    -1,    40,    -1,
      42,    43,    44,    45,    46,    -1,    -1,    -1,    -1,    -1,
      -1,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    -1,    68,    69,    70,    -1,
      72,    73,    -1,    -1,   707,    77,    -1,    79,    80,    81,
      82,    83,    84,    -1,   745,    -1,    -1,    89,    -1,    91,
      -1,    -1,    94,    95,    96,     3,    -1,    -1,     6,    -1,
      -1,    -1,    -1,    11,    12,    13,    14,    15,    16,    17,
     112,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    42,    43,    44,    45,    46,    -1,
      48,    -1,    -1,    51,    -1,    -1,    -1,    -1,    -1,     3,
      -1,    -1,     6,    61,    62,    63,    -1,    11,    12,    13,
      14,    15,    16,    17,    51,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      -1,    -1,    -1,    91,    -1,    -1,    -1,    95,    42,    43,
      44,    45,    46,    -1,    48,    -1,    -1,    51,    -1,   107,
     108,    -1,    -1,   111,   112,    -1,    -1,    61,    62,    63,
      -1,    -1,    -1,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,    -1,    19,    20,    21,    22,    23,
      24,    25,    26,    -1,    28,     3,    30,    91,     6,    -1,
      -1,    95,    -1,    11,    12,    13,    14,    15,    16,    17,
      -1,    -1,     3,   107,   108,     6,    -1,   111,   112,    -1,
      11,    12,    13,    14,    15,    16,    17,    -1,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    42,    43,    44,    45,    46,    -1,    48,    -1,    -1,
      51,    -1,    -1,    -1,    -1,    -1,     3,    -1,    -1,     6,
      61,    62,    63,    -1,    11,    12,    13,    14,    15,    16,
      17,    51,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    -1,    -1,    -1,
      91,    -1,    -1,    -1,    95,    42,    43,    44,    45,    46,
      -1,    48,    -1,    -1,    51,    -1,   107,   108,    -1,    -1,
     111,   112,    -1,    -1,    61,    62,    63,    -1,    -1,    -1,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,    -1,    -1,    91,    -1,    -1,    -1,    95,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,     3,
     107,   108,     6,    -1,   111,   112,    -1,    11,    12,    13,
      14,    15,    16,    17,    -1,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    42,    43,
      44,    45,    46,    -1,    48,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     3,    -1,    -1,     6,    61,    62,    63,
      -1,    11,    12,    13,    14,    15,    16,    17,    51,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    -1,    -1,    91,    -1,    -1,
      -1,    95,    42,    43,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,   111,   112,    -1,
      -1,    61,    62,    63,    -1,    -1,    -1,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    91,    -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     3,   107,   108,     6,
     110,   111,   112,    10,    11,    12,    13,    14,    15,    16,
      17,    -1,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    42,    43,    44,    45,    46,
      -1,    48,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       3,    -1,    -1,     6,    61,    62,    63,    -1,    11,    12,
      13,    14,    15,    16,    17,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    -1,    -1,    -1,    91,    -1,    -1,    -1,    95,    42,
      43,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,   111,   112,     3,    -1,    61,    62,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    -1,    91,    -1,
      -1,    -1,    95,    -1,    41,    42,    43,    44,    45,    46,
      -1,    -1,    -1,    50,   107,   108,    -1,    -1,   111,   112,
      -1,     3,    -1,    -1,    61,    62,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    -1,    -1,    91,    -1,    -1,    94,    95,    41,
      42,    43,    44,    45,    46,    -1,    -1,   104,    50,    -1,
      -1,    -1,    -1,   110,    -1,    -1,     3,    -1,    -1,    61,
      62,    63,    -1,    -1,    -1,    -1,    -1,    -1,    51,    -1,
      -1,    -1,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    -1,    -1,    -1,    91,
      -1,    -1,    94,    95,    41,    42,    43,    44,    45,    46,
      -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,   110,    -1,
      -1,    -1,    -1,    -1,    61,    62,    63,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    91,    -1,    -1,    94,    95,    -1,
      -1,     0,     1,    -1,     3,     4,    -1,   104,     7,     8,
       9,    -1,    -1,   110,    -1,    -1,    -1,    -1,    -1,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    -1,    -1,    -1,    36,    37,    -1,
      -1,    -1,    -1,    42,    43,    44,    45,    46,    -1,    -1,
      49,    -1,    -1,    -1,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    -1,    -1,    -1,    -1,    68,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    -1,    -1,    -1,
      89,     1,    91,     3,     4,    94,    95,     7,     8,     9,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    -1,    -1,    -1,    36,    37,    -1,    -1,
      40,    -1,    42,    43,    44,    45,    46,    -1,    -1,    49,
      -1,    -1,    -1,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    -1,    -1,    -1,    -1,    68,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    -1,    -1,    -1,    89,
       1,    91,     3,     4,    94,    95,     7,     8,     9,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    -1,    -1,    -1,    36,    37,    -1,    -1,    40,
      -1,    42,    43,    44,    45,    46,    -1,    -1,    49,    -1,
      -1,    -1,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    -1,    -1,    -1,    -1,    68,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    -1,    -1,    -1,    89,     1,
      91,     3,     4,    94,    95,     7,     8,     9,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    -1,    -1,    -1,    36,    37,    -1,    -1,    40,    -1,
      42,    43,    44,    45,    46,    -1,    -1,    49,    -1,    -1,
      -1,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    -1,    -1,    -1,    -1,    68,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    -1,    -1,    -1,    89,     1,    91,
       3,     4,    94,    95,     7,     8,     9,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      -1,    -1,    -1,    36,    37,    -1,    -1,    -1,    -1,    42,
      43,    44,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    -1,    -1,    -1,    -1,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,     1,    -1,     3,    -1,    89,    -1,    91,    -1,
      -1,    94,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    41,    42,    43,    44,    45,    46,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,     3,
      -1,    -1,    61,    62,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    -1,
      -1,    -1,    91,    -1,    -1,    94,    95,    41,    42,    43,
      44,    45,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     1,    -1,     3,    -1,    -1,    -1,    61,    62,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    -1,    -1,    -1,    -1,    91,    -1,    -1,
      94,    95,    42,    43,    44,    45,    46,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,    -1,    -1,
      -1,    61,    62,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    -1,    -1,    -1,
      -1,    91,    -1,    -1,    -1,    95,    42,    43,    44,    45,
      46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    61,    62,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     3,    -1,    91,     6,    -1,    -1,    95,
      96,    11,    12,    13,    14,    15,    16,    17,    -1,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    41,    42,    43,    44,    45,    46,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,    -1,
      -1,    61,    62,    63,    -1,    -1,    11,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    -1,    -1,
      -1,    91,    -1,    -1,    94,    95,    41,    42,    43,    44,
      45,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     3,    -1,    -1,    61,    62,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    -1,    -1,    -1,    91,    -1,    -1,    94,
      95,    41,    42,    43,    44,    45,    46,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,    -1,    -1,
      -1,    61,    62,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    -1,    -1,
      -1,    91,    -1,    -1,    94,    95,    42,    43,    44,    45,
      46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     3,    -1,    -1,    -1,    61,    62,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    -1,    -1,    -1,    -1,    91,    -1,    -1,    -1,    95,
      42,    43,    44,    45,    46,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     3,    -1,    -1,    -1,    61,
      62,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    -1,    -1,    -1,    -1,    91,
      -1,    -1,    -1,    95,    42,    43,    44,    45,    46,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,
      -1,    -1,    -1,    61,    62,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    -1,
      -1,    -1,    -1,    91,    -1,    -1,    -1,    95,    42,    43,
      44,    45,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    61,    62,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    -1,    -1,
      -1,    95
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short yystos[] =
{
       0,    97,    98,   116,   117,   257,     1,     3,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    41,    42,    43,    44,    45,    46,    61,    62,
      63,    91,    94,    95,   200,   214,   215,   217,   218,   219,
     220,   221,   237,   247,   249,     1,   200,     0,     1,     4,
       7,     8,     9,    18,    36,    37,    49,    53,    54,    55,
      56,    57,    58,    59,    60,    68,    69,    70,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    89,    94,   118,   119,   120,   122,   123,   124,   125,
     126,   129,   130,   132,   133,   134,   135,   136,   137,   138,
     141,   142,   143,   146,   148,   153,   154,   155,   156,   158,
     161,   162,   163,   164,   165,   169,   170,   174,   175,   185,
     196,   257,    85,   244,   257,   244,    41,   247,   114,    85,
      36,   218,   214,    33,    47,    50,    67,   104,   110,   112,
     205,   206,   208,   210,   211,   212,   213,   247,   257,   214,
     220,   247,    93,   114,   248,    36,    96,    33,     6,   252,
      33,   254,   257,     1,     3,   216,   217,    33,   254,    33,
     140,   257,    33,    33,    33,    74,   247,     3,    39,   247,
      33,     4,    39,    33,    33,    36,    39,     4,   252,    33,
     152,   216,   150,   152,    33,    33,   252,    33,    85,   237,
     254,    33,   104,   208,   213,   247,    61,   216,   237,     6,
      11,    12,    13,    14,    15,    16,    17,   200,   201,   202,
     204,   229,   257,    41,    95,   249,   237,    33,   104,   197,
     198,   200,   211,   213,   247,   257,    10,    39,   104,   222,
     223,    33,    48,    51,   107,   108,   111,   112,   216,   228,
     229,   230,   252,   228,    33,   112,   209,   212,   247,   213,
     214,   247,   205,    33,    50,   205,    33,    50,   104,   209,
     212,   247,    92,   249,    95,   249,     3,   245,   252,     6,
      39,   245,   255,   245,    36,    47,    33,   208,    34,   245,
     247,     3,     3,   245,    11,   147,   197,   197,   247,    36,
      47,   177,    39,     3,   149,   255,     3,   197,    39,   207,
     208,   211,   257,    36,    35,   151,   257,   245,   246,   257,
     127,   128,   252,   197,   173,   198,   247,   252,     3,   104,
     213,   245,   247,    33,   245,   104,   247,    92,     3,   224,
     257,    33,   208,    39,   247,    86,    35,   203,   257,   248,
      86,   104,   213,   247,   210,   247,    34,    35,   199,   257,
      34,   104,   210,   247,    92,   208,   228,   228,    33,   228,
     228,   228,   228,    33,    51,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   213,   247,   247,    33,
      50,   213,   197,    51,   228,   197,    51,   228,   209,   212,
      92,   104,   209,   248,    34,   157,    35,    47,    34,   222,
     205,    34,    39,    34,    47,    34,    35,   145,    35,    34,
      34,    36,   247,   117,   176,    34,    34,    34,    34,   150,
     152,    34,    34,    35,    39,    34,    86,    50,    34,    92,
     213,   247,    36,    92,    36,    39,   197,   247,    71,   160,
     205,   214,   167,    36,    67,   231,   232,   257,   204,   237,
     247,    92,    34,   200,    34,    92,   210,    34,   104,   110,
     213,   216,   228,   228,   228,   228,   228,   228,   228,   228,
     228,   228,   228,   209,   247,    34,    92,   197,    51,   228,
      34,    51,    34,    51,   104,   209,   212,   209,     4,    39,
     252,   117,   255,   127,   229,   252,   256,    36,    36,   121,
       4,   139,   252,     4,    36,    39,    90,   144,   208,   252,
     253,   245,   252,   256,    34,   200,   208,    39,    36,    40,
     117,    37,   196,   150,    36,    39,    33,    40,   151,     3,
      91,    95,   250,    36,   255,   200,    36,   171,   131,   208,
     252,    92,     3,   225,   226,   257,    34,    33,    35,    36,
      39,   159,    71,   205,     1,    36,    57,    64,    65,    66,
      69,   112,   122,   123,   124,   125,   129,   134,   136,   138,
     141,   143,   146,   148,   153,   154,   155,   156,   169,   170,
     174,   178,   181,   182,   183,   184,   185,   186,   187,   192,
     195,   196,   257,   233,    39,   203,   247,   199,    34,   228,
      34,   214,    34,   104,   206,    34,   209,    34,    51,   209,
      40,    35,    35,   178,    33,    71,   214,   239,   257,    47,
      34,    35,   145,   144,   208,   239,    40,   252,     3,   216,
      36,    47,   253,   197,    93,   114,   251,   114,    85,    34,
      40,   158,   165,   169,   170,   172,   182,   196,   117,   239,
      36,    47,    35,    40,    33,    47,   239,   240,   197,   208,
      33,   180,    39,    67,    67,    67,   112,   249,    40,   178,
      96,   216,   237,   247,    69,   234,   235,   238,   257,   166,
     228,   228,    34,    34,    34,   255,   255,    40,   197,    33,
      71,   144,   252,   256,    36,   208,    34,   239,    36,    36,
     208,   152,    34,     3,     3,    95,     3,    95,   201,     4,
      39,   216,    51,    36,    10,   227,   228,   226,    36,   208,
     197,   222,    67,   241,   257,    34,   160,   197,   178,   179,
     249,    33,   208,   216,    33,    67,     3,    39,   247,    36,
      35,    64,    65,    66,   236,   247,   178,   228,    34,   197,
      33,   145,   239,    36,   208,   144,    36,    36,   251,   251,
      86,   159,    34,    36,   242,   243,   247,    36,    39,   205,
     159,    34,   178,    33,   197,   159,    33,   104,   213,   197,
     228,    39,   189,    67,   235,   238,    40,    36,    34,   197,
      36,   239,    36,    36,    39,    35,    33,   205,    40,   197,
      34,   197,    33,    33,    34,    36,   188,   191,   208,   257,
     234,   247,    36,   168,   208,    34,    36,   243,   178,    34,
     193,   239,    34,   197,   197,   240,   191,    36,    39,   159,
     194,   239,    36,    39,   194,    34,    34,    36,   190,    36,
      39,    47,   194,   194,    36,   222,    36
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1388 "parser.y"
    {
		   Setattr(yyvsp[0].node,"classes",classes); 
		   Setattr(yyvsp[0].node,"name",ModuleName);
		   
		   if ((!module_node) && ModuleName) {
		     module_node = new_node("module");
		     Setattr(module_node,"name",ModuleName);
		   }
		   Setattr(yyvsp[0].node,"module",module_node);
		   check_extensions();
	           top = yyvsp[0].node;
               }
    break;

  case 3:
#line 1400 "parser.y"
    {
                 top = Getattr(yyvsp[-1].p,"type");
               }
    break;

  case 4:
#line 1403 "parser.y"
    {
                 top = 0;
               }
    break;

  case 5:
#line 1406 "parser.y"
    {
                 top = yyvsp[-1].p;
               }
    break;

  case 6:
#line 1409 "parser.y"
    {
                 top = 0;
               }
    break;

  case 7:
#line 1414 "parser.y"
    {  
                   /* add declaration to end of linked list (the declaration isn't always a single declaration, sometimes it is a linked list itself) */
                   appendChild(yyvsp[-1].node,yyvsp[0].node);
                   yyval.node = yyvsp[-1].node;
               }
    break;

  case 8:
#line 1419 "parser.y"
    {
                   yyval.node = new_node("top");
               }
    break;

  case 9:
#line 1424 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 10:
#line 1425 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 11:
#line 1426 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 12:
#line 1427 "parser.y"
    { yyval.node = 0; }
    break;

  case 13:
#line 1428 "parser.y"
    {
                  yyval.node = 0;
		  if (!Swig_error_count()) {
		    static int last_error_line = -1;
		    if (last_error_line != cparse_line) {
		      Swig_error(cparse_file, cparse_line,"Syntax error in input(1).\n");
		      last_error_line = cparse_line;
		      skip_decl();
		    }
		  }
               }
    break;

  case 14:
#line 1440 "parser.y"
    { 
                  if (yyval.node) {
   		      add_symbols(yyval.node);
                  }
                  yyval.node = yyvsp[0].node; 
	       }
    break;

  case 15:
#line 1456 "parser.y"
    {
                  yyval.node = 0;
                  skip_decl();
               }
    break;

  case 16:
#line 1466 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 17:
#line 1467 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 18:
#line 1468 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 19:
#line 1469 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 20:
#line 1470 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 21:
#line 1471 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 22:
#line 1472 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 23:
#line 1473 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 24:
#line 1474 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 25:
#line 1475 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 26:
#line 1476 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 27:
#line 1477 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 28:
#line 1478 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 29:
#line 1479 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 30:
#line 1480 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 31:
#line 1481 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 32:
#line 1482 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 33:
#line 1483 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 34:
#line 1484 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 35:
#line 1485 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 36:
#line 1486 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 37:
#line 1493 "parser.y"
    {
               Node *cls;
	       String *clsname;
	       cplus_mode = CPLUS_PUBLIC;
	       if (!classes) classes = NewHash();
	       if (!extendhash) extendhash = NewHash();
	       clsname = make_class_name(yyvsp[-1].str);
	       cls = Getattr(classes,clsname);
	       if (!cls) {
		 /* No previous definition. Create a new scope */
		 Node *am = Getattr(extendhash,clsname);
		 if (!am) {
		   Swig_symbol_newscope();
		   Swig_symbol_setscopename(yyvsp[-1].str);
		   prev_symtab = 0;
		 } else {
		   prev_symtab = Swig_symbol_setscope(Getattr(am,"symtab"));
		 }
		 current_class = 0;
	       } else {
		 /* Previous class definition.  Use its symbol table */
		 prev_symtab = Swig_symbol_setscope(Getattr(cls,"symtab"));
		 current_class = cls;
		 extendmode = 1;
	       }
	       Classprefix = NewString(yyvsp[-1].str);
	       Namespaceprefix= Swig_symbol_qualifiedscopename(0);
	       Delete(clsname);
	     }
    break;

  case 38:
#line 1521 "parser.y"
    {
               String *clsname;
	       extendmode = 0;
               yyval.node = new_node("extend");
	       Setattr(yyval.node,"symtab",Swig_symbol_popscope());
	       if (prev_symtab) {
		 Swig_symbol_setscope(prev_symtab);
	       }
	       Namespaceprefix = Swig_symbol_qualifiedscopename(0);
               clsname = make_class_name(yyvsp[-4].str);
	       Setattr(yyval.node,"name",clsname);

	       /* Mark members as extend */

	       Swig_tag_nodes(yyvsp[-1].node,"feature:extend",(char*) "1");
	       if (current_class) {
		 /* We add the extension to the previously defined class */
		 appendChild(yyval.node,yyvsp[-1].node);
		 appendChild(current_class,yyval.node);
	       } else {
		 /* We store the extensions in the extensions hash */
		 Node *am = Getattr(extendhash,clsname);
		 if (am) {
		   /* Append the members to the previous extend methods */
		   appendChild(am,yyvsp[-1].node);
		 } else {
		   appendChild(yyval.node,yyvsp[-1].node);
		   Setattr(extendhash,clsname,yyval.node);
		 }
	       }
	       current_class = 0;
	       Delete(Classprefix);
	       Delete(clsname);
	       Classprefix = 0;
	       prev_symtab = 0;
	       yyval.node = 0;

	     }
    break;

  case 39:
#line 1565 "parser.y"
    {
                    yyval.node = new_node("apply");
                    Setattr(yyval.node,"pattern",Getattr(yyvsp[-3].p,"pattern"));
		    appendChild(yyval.node,yyvsp[-1].p);
               }
    break;

  case 40:
#line 1575 "parser.y"
    {
		 yyval.node = new_node("clear");
		 appendChild(yyval.node,yyvsp[-1].p);
               }
    break;

  case 41:
#line 1586 "parser.y"
    {
		   if ((yyvsp[-1].dtype.type != T_ERROR) && (yyvsp[-1].dtype.type != T_SYMBOL)) {
		     yyval.node = new_node("constant");
		     Setattr(yyval.node,"name",yyvsp[-3].id);
		     Setattr(yyval.node,"type",NewSwigType(yyvsp[-1].dtype.type));
		     Setattr(yyval.node,"value",yyvsp[-1].dtype.val);
		     if (yyvsp[-1].dtype.rawval) Setattr(yyval.node,"rawval", yyvsp[-1].dtype.rawval);
		     Setattr(yyval.node,"storage","%constant");
		     SetFlag(yyval.node,"feature:immutable");
		     add_symbols(yyval.node);
		   } else {
		     if (yyvsp[-1].dtype.type == T_ERROR) {
		       Swig_warning(WARN_PARSE_UNSUPPORTED_VALUE,cparse_file,cparse_line,"Unsupported constant value (ignored)\n");
		     }
		     yyval.node = 0;
		   }

	       }
    break;

  case 42:
#line 1605 "parser.y"
    {
		 if ((yyvsp[-1].dtype.type != T_ERROR) && (yyvsp[-1].dtype.type != T_SYMBOL)) {
		   SwigType_push(yyvsp[-3].type,yyvsp[-2].decl.type);
		   /* Sneaky callback function trick */
		   if (SwigType_isfunction(yyvsp[-3].type)) {
		     SwigType_add_pointer(yyvsp[-3].type);
		   }
		   yyval.node = new_node("constant");
		   Setattr(yyval.node,"name",yyvsp[-2].decl.id);
		   Setattr(yyval.node,"type",yyvsp[-3].type);
		   Setattr(yyval.node,"value",yyvsp[-1].dtype.val);
		   if (yyvsp[-1].dtype.rawval) Setattr(yyval.node,"rawval", yyvsp[-1].dtype.rawval);
		   Setattr(yyval.node,"storage","%constant");
		   SetFlag(yyval.node,"feature:immutable");
		   add_symbols(yyval.node);
		 } else {
		     if (yyvsp[-1].dtype.type == T_ERROR) {
		       Swig_warning(WARN_PARSE_UNSUPPORTED_VALUE,cparse_file,cparse_line,"Unsupported constant value\n");
		     }
		   yyval.node = 0;
		 }
               }
    break;

  case 43:
#line 1627 "parser.y"
    {
		 Swig_warning(WARN_PARSE_BAD_VALUE,cparse_file,cparse_line,"Bad constant value (ignored).\n");
		 yyval.node = 0;
	       }
    break;

  case 44:
#line 1638 "parser.y"
    {
		 char temp[64];
		 Replace(yyvsp[0].str,"$file",cparse_file, DOH_REPLACE_ANY);
		 sprintf(temp,"%d", cparse_line);
		 Replace(yyvsp[0].str,"$line",temp,DOH_REPLACE_ANY);
		 Printf(stderr,"%s\n", yyvsp[0].str);
		 Delete(yyvsp[0].str);
                 yyval.node = 0;
	       }
    break;

  case 45:
#line 1647 "parser.y"
    {
		 char temp[64];
		 String *s = NewString(yyvsp[0].id);
		 Replace(s,"$file",cparse_file, DOH_REPLACE_ANY);
		 sprintf(temp,"%d", cparse_line);
		 Replace(s,"$line",temp,DOH_REPLACE_ANY);
		 Printf(stderr,"%s\n", s);
		 Delete(s);
                 yyval.node = 0;
               }
    break;

  case 46:
#line 1666 "parser.y"
    {
                    skip_balanced('{','}');
		    yyval.node = 0;
		    Swig_warning(WARN_DEPRECATED_EXCEPT,cparse_file, cparse_line, "%%except is deprecated.  Use %%exception instead.\n");
	       }
    break;

  case 47:
#line 1672 "parser.y"
    {
                    skip_balanced('{','}');
		    yyval.node = 0;
		    Swig_warning(WARN_DEPRECATED_EXCEPT,cparse_file, cparse_line, "%%except is deprecated.  Use %%exception instead.\n");
               }
    break;

  case 48:
#line 1678 "parser.y"
    {
		 yyval.node = 0;
		 Swig_warning(WARN_DEPRECATED_EXCEPT,cparse_file, cparse_line, "%%except is deprecated.  Use %%exception instead.\n");
               }
    break;

  case 49:
#line 1683 "parser.y"
    {
		 yyval.node = 0;
		 Swig_warning(WARN_DEPRECATED_EXCEPT,cparse_file, cparse_line, "%%except is deprecated.  Use %%exception instead.\n");
	       }
    break;

  case 50:
#line 1694 "parser.y"
    {		 
                 yyval.node = NewHash();
                 Setattr(yyval.node,"value",yyvsp[-3].id);
		 Setattr(yyval.node,"type",Getattr(yyvsp[-1].p,"type"));
               }
    break;

  case 51:
#line 1701 "parser.y"
    {
                 yyval.node = NewHash();
                 Setattr(yyval.node,"value",yyvsp[0].id);
              }
    break;

  case 52:
#line 1705 "parser.y"
    {
                yyval.node = yyvsp[0].node;
              }
    break;

  case 53:
#line 1710 "parser.y"
    {
                   Hash *p = yyvsp[-2].node;
		   yyval.node = new_node("fragment");
		   Setattr(yyval.node,"value",Getattr(yyvsp[-4].node,"value"));
		   Setattr(yyval.node,"type",Getattr(yyvsp[-4].node,"type"));
		   Setattr(yyval.node,"section",Getattr(p,"name"));
		   Setattr(yyval.node,"kwargs",nextSibling(p));
		   Setattr(yyval.node,"code",yyvsp[0].str);
                 }
    break;

  case 54:
#line 1719 "parser.y"
    {
		   Hash *p = yyvsp[-2].node;
                   skip_balanced('{','}');
		   yyval.node = new_node("fragment");
		   Setattr(yyval.node,"value",Getattr(yyvsp[-4].node,"value"));
		   Setattr(yyval.node,"type",Getattr(yyvsp[-4].node,"type"));
		   Setattr(yyval.node,"section",Getattr(p,"name"));
		   Setattr(yyval.node,"kwargs",nextSibling(p));
		   Delitem(scanner_ccode,0);
		   Delitem(scanner_ccode,DOH_END);
		   Setattr(yyval.node,"code",Copy(scanner_ccode));
                 }
    break;

  case 55:
#line 1731 "parser.y"
    {
		   yyval.node = new_node("fragment");
		   Setattr(yyval.node,"value",Getattr(yyvsp[-2].node,"value"));
		   Setattr(yyval.node,"type",Getattr(yyvsp[-2].node,"type"));
		   Setattr(yyval.node,"emitonly","1");
		 }
    break;

  case 56:
#line 1744 "parser.y"
    {
                     yyvsp[-3].loc.filename = Swig_copy_string(cparse_file);
		     yyvsp[-3].loc.line = cparse_line;
		     cparse_file = Swig_copy_string(yyvsp[-1].id);
		     cparse_line = 0;
               }
    break;

  case 57:
#line 1749 "parser.y"
    {
                     String *mname = 0;
                     yyval.node = yyvsp[-1].node;
		     cparse_file = yyvsp[-6].loc.filename;
		     cparse_line = yyvsp[-6].loc.line;
		     if (strcmp(yyvsp[-6].loc.type,"include") == 0) set_nodeType(yyval.node,"include");
		     if (strcmp(yyvsp[-6].loc.type,"import") == 0) {
		       mname = yyvsp[-5].node ? Getattr(yyvsp[-5].node,"module") : 0;
		       set_nodeType(yyval.node,"import");
		       if (import_mode) --import_mode;
		     }
		     
		     Setattr(yyval.node,"name",yyvsp[-4].id);
		     /* Search for the module (if any) */
		     {
			 Node *n = firstChild(yyval.node);
			 while (n) {
			     if (Strcmp(nodeType(n),"module") == 0) {
			         if (mname) {
				   Setattr(n,"name", mname);
				   mname = 0;
				 }
				 Setattr(yyval.node,"module",Getattr(n,"name"));
				 break;
			     }
			     n = nextSibling(n);
			 }
			 if (mname) {
			   /* There is no module node in the import
			      node, ie, you imported a .h file
			      directly.  We are forced then to create
			      a new import node with a module node.
			   */			      
			   Node *nint = new_node("import");
			   Node *mnode = new_node("module");
			   Setattr(mnode,"name", mname);
			   appendChild(nint,mnode);
			   appendChild(nint,firstChild(yyval.node));
			   yyval.node = nint;
			   Setattr(yyval.node,"module",mname);
			 }
		     }
		     Setattr(yyval.node,"options",yyvsp[-5].node);
               }
    break;

  case 58:
#line 1795 "parser.y"
    { yyval.loc.type = (char *) "include"; }
    break;

  case 59:
#line 1796 "parser.y"
    { yyval.loc.type = (char *) "import"; ++import_mode;}
    break;

  case 60:
#line 1803 "parser.y"
    {
                 String *cpps;
		 if (Namespaceprefix) {
		   Swig_error(cparse_file, cparse_start_line, "%%inline directive inside a namespace is disallowed.\n");

		   yyval.node = 0;
		 } else {
		   yyval.node = new_node("insert");
		   Setattr(yyval.node,"code",yyvsp[0].str);
		   /* Need to run through the preprocessor */
		   Setline(yyvsp[0].str,cparse_start_line);
		   Setfile(yyvsp[0].str,cparse_file);
		   Seek(yyvsp[0].str,0,SEEK_SET);
		   cpps = Preprocessor_parse(yyvsp[0].str);
		   start_inline(Char(cpps), cparse_start_line);
		   Delete(yyvsp[0].str);
		   Delete(cpps);
		 }
		 
	       }
    break;

  case 61:
#line 1823 "parser.y"
    {
                 String *cpps;
		 skip_balanced('{','}');
		 if (Namespaceprefix) {
		   Swig_error(cparse_file, cparse_start_line, "%%inline directive inside a namespace is disallowed.\n");
		   
		   yyval.node = 0;
		 } else {
                   yyval.node = new_node("insert");
		   Delitem(scanner_ccode,0);
		   Delitem(scanner_ccode,DOH_END);
		   Setattr(yyval.node,"code", Copy(scanner_ccode));
		   cpps=Copy(scanner_ccode);
		   start_inline(Char(cpps), cparse_start_line);
		   Delete(cpps);
		 }
               }
    break;

  case 62:
#line 1850 "parser.y"
    {
                 yyval.node = new_node("insert");
		 Setattr(yyval.node,"code",yyvsp[0].str);
	       }
    break;

  case 63:
#line 1854 "parser.y"
    {
		 String *code = NewString("");
		 yyval.node = new_node("insert");
		 Setattr(yyval.node,"section",yyvsp[-2].id);
		 Setattr(yyval.node,"code",code);
		 if (Swig_insert_file(yyvsp[0].id,code) < 0) {
		   Swig_error(cparse_file, cparse_line, "Couldn't find '%s'.\n", yyvsp[0].id);
		   yyval.node = 0;
		 } 
               }
    break;

  case 64:
#line 1864 "parser.y"
    {
		 yyval.node = new_node("insert");
		 Setattr(yyval.node,"section",yyvsp[-2].id);
		 Setattr(yyval.node,"code",yyvsp[0].str);
               }
    break;

  case 65:
#line 1869 "parser.y"
    {
                 skip_balanced('{','}');
		 yyval.node = new_node("insert");
		 Setattr(yyval.node,"section",yyvsp[-2].id);
		 Delitem(scanner_ccode,0);
		 Delitem(scanner_ccode,DOH_END);
		 Setattr(yyval.node,"code", Copy(scanner_ccode));
	       }
    break;

  case 66:
#line 1884 "parser.y"
    {
                 yyval.node = new_node("module");
		 if (yyvsp[-1].node) {
		   Setattr(yyval.node,"options",yyvsp[-1].node);
		   if (Getattr(yyvsp[-1].node,"directors")) {
		     /*
		       we set dirprot_mode here to 1, just to save the
		       symbols. Later, the language module must decide
		       what to do with them.
		     */
		     dirprot_mode = 1;
		   } 
		   if (Getattr(yyvsp[-1].node,"templatereduce")) {
		     template_reduce = 1;
		   }
		 }
		 if (!ModuleName) ModuleName = NewString(yyvsp[0].id);
		 if (!import_mode) {
		   /* first module included, we apply global
		      ModuleName, which can be modify by -module */
		   Setattr(yyval.node,"name",Copy(ModuleName));
		 } else { 
		   /* import mode, we just pass the idstring */
		   Setattr(yyval.node,"name",yyvsp[0].id);   
		 }		 
		 if (!module_node) module_node = yyval.node;
	       }
    break;

  case 67:
#line 1918 "parser.y"
    {
                 Swig_warning(WARN_DEPRECATED_NAME,cparse_file,cparse_line, "%%name is deprecated.  Use %%rename instead.\n");
                 yyrename = NewString(yyvsp[-1].id);
		 yyval.node = 0;
               }
    break;

  case 68:
#line 1923 "parser.y"
    {
		 Swig_warning(WARN_DEPRECATED_NAME,cparse_file,cparse_line, "%%name is deprecated.  Use %%rename instead.\n");
		 yyval.node = 0;
		 Swig_error(cparse_file,cparse_line,"Missing argument to %%name directive.\n");
	       }
    break;

  case 69:
#line 1936 "parser.y"
    {
                 yyval.node = new_node("native");
		 Setattr(yyval.node,"name",yyvsp[-4].id);
		 Setattr(yyval.node,"wrap:name",yyvsp[-1].id);
	         add_symbols(yyval.node);
	       }
    break;

  case 70:
#line 1942 "parser.y"
    {
		 if (!SwigType_isfunction(yyvsp[-1].decl.type)) {
		   Swig_error(cparse_file,cparse_line,"%%native declaration '%s' is not a function.\n", yyvsp[-1].decl.id);
		   yyval.node = 0;
		 } else {
		     Delete(SwigType_pop_function(yyvsp[-1].decl.type));
		     /* Need check for function here */
		     SwigType_push(yyvsp[-2].type,yyvsp[-1].decl.type);
		     yyval.node = new_node("native");
	             Setattr(yyval.node,"name",yyvsp[-5].id);
		     Setattr(yyval.node,"wrap:name",yyvsp[-1].decl.id);
		     Setattr(yyval.node,"type",yyvsp[-2].type);
		     Setattr(yyval.node,"parms",yyvsp[-1].decl.parms);
		     Setattr(yyval.node,"decl",yyvsp[-1].decl.type);
		 }
	         add_symbols(yyval.node);
	       }
    break;

  case 71:
#line 1968 "parser.y"
    {
                 yyval.node = new_node("pragma");
		 Setattr(yyval.node,"lang",yyvsp[-3].id);
		 Setattr(yyval.node,"name",yyvsp[-2].id);
		 Setattr(yyval.node,"value",yyvsp[0].str);
	       }
    break;

  case 72:
#line 1974 "parser.y"
    {
		yyval.node = new_node("pragma");
		Setattr(yyval.node,"lang",yyvsp[-1].id);
		Setattr(yyval.node,"name",yyvsp[0].id);
	      }
    break;

  case 73:
#line 1981 "parser.y"
    { yyval.str = NewString(yyvsp[0].id); }
    break;

  case 74:
#line 1982 "parser.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 75:
#line 1985 "parser.y"
    { yyval.id = yyvsp[-1].id; }
    break;

  case 76:
#line 1986 "parser.y"
    { yyval.id = (char *) "swig"; }
    break;

  case 77:
#line 1994 "parser.y"
    {
                    SwigType *t = yyvsp[-2].decl.type;
		    if (!Len(t)) t = 0;
		    if (yyvsp[-3].ivalue) {
		      rename_add(yyvsp[-2].decl.id,t,yyvsp[-1].id,yyvsp[-2].decl.parms);
		    } else {
		      namewarn_add(yyvsp[-2].decl.id,t,yyvsp[-1].id);
		    }
		    yyval.node = 0;
		    scanner_clear_rename();
              }
    break;

  case 78:
#line 2005 "parser.y"
    {
		String *fixname;
		SwigType *t = yyvsp[-2].decl.type;
		fixname = feature_identifier_fix(yyvsp[-2].decl.id);
		if (!Len(t)) t = 0;
		/* Special declarator check */
		if (t) {
		  if (yyvsp[-1].dtype.qualifier) SwigType_push(t,yyvsp[-1].dtype.qualifier);
		  if (SwigType_isfunction(t)) {
		    SwigType *decl = SwigType_pop_function(t);
		    if (SwigType_ispointer(t)) {
		      String *nname = NewStringf("*%s",fixname);
		      if (yyvsp[-6].ivalue) {
			rename_add(Char(nname),decl,yyvsp[-4].id,yyvsp[-2].decl.parms);
		      } else {
			namewarn_add(Char(nname),decl,yyvsp[-4].id);
		      }
		      Delete(nname);
		    } else {
		      if (yyvsp[-6].ivalue) {
			rename_add(Char(fixname),decl,yyvsp[-4].id,yyvsp[-2].decl.parms);
		      } else {
			namewarn_add(Char(fixname),decl,yyvsp[-4].id);
		      }
		    }
		    Delete(decl);
		  } else if (SwigType_ispointer(t)) {
		    String *nname = NewStringf("*%s",fixname);
		    if (yyvsp[-6].ivalue) {
		      rename_add(Char(nname),0,yyvsp[-4].id,yyvsp[-2].decl.parms);
		    } else {
		      namewarn_add(Char(nname),0,yyvsp[-4].id);
		    }
		    Delete(nname);
		  }
		} else {
		  if (yyvsp[-6].ivalue) {
		    rename_add(Char(fixname),0,yyvsp[-4].id,yyvsp[-2].decl.parms);
		  } else {
		    namewarn_add(Char(fixname),0,yyvsp[-4].id);
		  }
		}
                yyval.node = 0;
		scanner_clear_rename();
              }
    break;

  case 79:
#line 2050 "parser.y"
    {
		if (yyvsp[-5].ivalue) {
		  rename_add(yyvsp[-1].id,0,yyvsp[-3].id,0);
		} else {
		  namewarn_add(yyvsp[-1].id,0,yyvsp[-3].id);
		}
		yyval.node = 0;
		scanner_clear_rename();
              }
    break;

  case 80:
#line 2061 "parser.y"
    {
		    yyval.ivalue = 1;
                }
    break;

  case 81:
#line 2064 "parser.y"
    {
                    yyval.ivalue = 0;
                }
    break;

  case 82:
#line 2091 "parser.y"
    {
                    String *val = yyvsp[0].str ? NewString(yyvsp[0].str) : NewString("1");
                    new_feature(yyvsp[-4].id, val, 0, yyvsp[-2].decl.id, yyvsp[-2].decl.type, yyvsp[-2].decl.parms, yyvsp[-1].dtype.qualifier);
                    yyval.node = 0;
                  }
    break;

  case 83:
#line 2096 "parser.y"
    {
                    String *val = Len(yyvsp[-4].id) ? NewString(yyvsp[-4].id) : 0;
                    new_feature(yyvsp[-6].id, val, 0, yyvsp[-2].decl.id, yyvsp[-2].decl.type, yyvsp[-2].decl.parms, yyvsp[-1].dtype.qualifier);
                    yyval.node = 0;
                  }
    break;

  case 84:
#line 2101 "parser.y"
    {
                    String *val = yyvsp[0].str ? NewString(yyvsp[0].str) : NewString("1");
                    new_feature(yyvsp[-5].id, val, yyvsp[-4].node, yyvsp[-2].decl.id, yyvsp[-2].decl.type, yyvsp[-2].decl.parms, yyvsp[-1].dtype.qualifier);
                    yyval.node = 0;
                  }
    break;

  case 85:
#line 2106 "parser.y"
    {
                    String *val = Len(yyvsp[-5].id) ? NewString(yyvsp[-5].id) : 0;
                    new_feature(yyvsp[-7].id, val, yyvsp[-4].node, yyvsp[-2].decl.id, yyvsp[-2].decl.type, yyvsp[-2].decl.parms, yyvsp[-1].dtype.qualifier);
                    yyval.node = 0;
                  }
    break;

  case 86:
#line 2113 "parser.y"
    {
                    String *val = yyvsp[0].str ? NewString(yyvsp[0].str) : NewString("1");
                    new_feature(yyvsp[-2].id, val, 0, 0, 0, 0, 0);
                    yyval.node = 0;
                  }
    break;

  case 87:
#line 2118 "parser.y"
    {
                    String *val = Len(yyvsp[-2].id) ? NewString(yyvsp[-2].id) : 0;
                    new_feature(yyvsp[-4].id, val, 0, 0, 0, 0, 0);
                    yyval.node = 0;
                  }
    break;

  case 88:
#line 2123 "parser.y"
    {
                    String *val = yyvsp[0].str ? NewString(yyvsp[0].str) : NewString("1");
                    new_feature(yyvsp[-3].id, val, yyvsp[-2].node, 0, 0, 0, 0);
                    yyval.node = 0;
                  }
    break;

  case 89:
#line 2128 "parser.y"
    {
                    String *val = Len(yyvsp[-3].id) ? NewString(yyvsp[-3].id) : 0;
                    new_feature(yyvsp[-5].id, val, yyvsp[-2].node, 0, 0, 0, 0);
                    yyval.node = 0;
                  }
    break;

  case 90:
#line 2135 "parser.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 91:
#line 2136 "parser.y"
    { yyval.str = 0; }
    break;

  case 92:
#line 2137 "parser.y"
    { yyval.str = yyvsp[-2].pl; }
    break;

  case 93:
#line 2140 "parser.y"
    {
		  yyval.node = NewHash();
		  Setattr(yyval.node,"name",yyvsp[-2].id);
		  Setattr(yyval.node,"value",yyvsp[0].id);
                }
    break;

  case 94:
#line 2145 "parser.y"
    {
		  yyval.node = NewHash();
		  Setattr(yyval.node,"name",yyvsp[-3].id);
		  Setattr(yyval.node,"value",yyvsp[-1].id);
                  set_nextSibling(yyval.node,yyvsp[0].node);
                }
    break;

  case 95:
#line 2155 "parser.y"
    {
                 Parm *val;
		 String *name;
		 SwigType *t;
                 if (!features_hash) features_hash = NewHash();
		 if (Namespaceprefix) name = NewStringf("%s::%s", Namespaceprefix, yyvsp[-2].decl.id);
		 else name = NewString(yyvsp[-2].decl.id);
		 val = yyvsp[-4].pl;
		 if (yyvsp[-2].decl.parms) {
		   Setmeta(val,"parms",yyvsp[-2].decl.parms);
		 }
		 t = yyvsp[-2].decl.type;
		 if (!Len(t)) t = 0;
		 if (t) {
		   if (yyvsp[-1].dtype.qualifier) SwigType_push(t,yyvsp[-1].dtype.qualifier);
		   if (SwigType_isfunction(t)) {
		     SwigType *decl = SwigType_pop_function(t);
		     if (SwigType_ispointer(t)) {
		       String *nname = NewStringf("*%s",name);
		       Swig_feature_set(features_hash, nname, decl, "feature:varargs", val, 0);
		       Delete(nname);
		     } else {
		       Swig_feature_set(features_hash, name, decl, "feature:varargs", val, 0);
		     }
		     Delete(decl);
		   } else if (SwigType_ispointer(t)) {
		     String *nname = NewStringf("*%s",name);
		     Swig_feature_set(features_hash,nname,0,"feature:varargs",val, 0);
		     Delete(nname);
		   }
		 } else {
		   Swig_feature_set(features_hash,name,0,"feature:varargs",val, 0);
		 }
		 Delete(name);
		 yyval.node = 0;
              }
    break;

  case 96:
#line 2192 "parser.y"
    { yyval.pl = yyvsp[0].pl; }
    break;

  case 97:
#line 2193 "parser.y"
    { 
		  int i;
		  int n;
		  Parm *p;
		  n = atoi(Char(yyvsp[-2].dtype.val));
		  if (n <= 0) {
		    Swig_error(cparse_file, cparse_line,"Argument count in %%varargs must be positive.\n");
		    yyval.pl = 0;
		  } else {
		    yyval.pl = Copy(yyvsp[0].p);
		    Setattr(yyval.pl,"name","VARARGS_SENTINEL");
		    for (i = 0; i < n; i++) {
		      p = Copy(yyvsp[0].p);
		      set_nextSibling(p,yyval.pl);
		      yyval.pl = p;
		    }
		  }
                }
    break;

  case 98:
#line 2222 "parser.y"
    {
		   yyval.node = 0;
		   if (yyvsp[-3].tmap.op) {
		     String *code = 0;
		     yyval.node = new_node("typemap");
		     Setattr(yyval.node,"method",yyvsp[-3].tmap.op);
		     if (yyvsp[-3].tmap.kwargs) {
		       Parm *kw = yyvsp[-3].tmap.kwargs;
		       /* check for 'noblock' option, which remove the block braces */
		       while (kw) {
			 String *name = Getattr(kw,"name");
			 if (name && (Cmp(name,"noblock") == 0)) {
			   char *cstr = Char(yyvsp[0].str);
			   size_t len = Len(yyvsp[0].str);
			   if (len && cstr[0] == '{') {
			     --len; ++cstr; 
			     if (len && cstr[len - 1] == '}') { --len; }
			     /* we now remove the extra spaces */
			     while (len && isspace(cstr[0])) { --len; ++cstr; }
			     while (len && isspace(cstr[len - 1])) { --len; }
			     code = NewStringWithSize(cstr, len);
			   }
			 }
			 kw = nextSibling(kw);
		       }
		       Setattr(yyval.node,"kwargs", yyvsp[-3].tmap.kwargs);
		     }
		     Setattr(yyval.node,"code", code ? code : NewString(yyvsp[0].str));
		     appendChild(yyval.node,yyvsp[-1].p);
		   }
	       }
    break;

  case 99:
#line 2253 "parser.y"
    {
		 yyval.node = 0;
		 if (yyvsp[-3].tmap.op) {
		   yyval.node = new_node("typemap");
		   Setattr(yyval.node,"method",yyvsp[-3].tmap.op);
		   appendChild(yyval.node,yyvsp[-1].p);
		 }
	       }
    break;

  case 100:
#line 2261 "parser.y"
    {
		   yyval.node = 0;
		   if (yyvsp[-5].tmap.op) {
		     yyval.node = new_node("typemapcopy");
		     Setattr(yyval.node,"method",yyvsp[-5].tmap.op);
		     Setattr(yyval.node,"pattern", Getattr(yyvsp[-1].p,"pattern"));
		     appendChild(yyval.node,yyvsp[-3].p);
		   }
	       }
    break;

  case 101:
#line 2274 "parser.y"
    {
		 Hash *p;
		 String *name;
		 p = nextSibling(yyvsp[0].node);
		 if (p && (!Getattr(p,"value"))) {
		   /* two argument typemap form */
		   name = Getattr(yyvsp[0].node,"name");
		   if (!name || (Strcmp(name,typemap_lang))) {
		     yyval.tmap.op = 0;
		     yyval.tmap.kwargs = 0;
		   } else {
		     yyval.tmap.op = Getattr(p,"name");
		     yyval.tmap.kwargs = nextSibling(p);
		   }
		 } else {
		   /* one-argument typemap-form */
		   yyval.tmap.op = Getattr(yyvsp[0].node,"name");
		   yyval.tmap.kwargs = p;
		 }
                }
    break;

  case 102:
#line 2296 "parser.y"
    {
                 yyval.p = yyvsp[-1].p;
		 set_nextSibling(yyval.p,yyvsp[0].p);
		}
    break;

  case 103:
#line 2302 "parser.y"
    {
                 yyval.p = yyvsp[-1].p;
		 set_nextSibling(yyval.p,yyvsp[0].p);
                }
    break;

  case 104:
#line 2306 "parser.y"
    { yyval.p = 0;}
    break;

  case 105:
#line 2309 "parser.y"
    {
		  SwigType_push(yyvsp[-1].type,yyvsp[0].decl.type);
		  yyval.p = new_node("typemapitem");
		  Setattr(yyval.p,"pattern",NewParm(yyvsp[-1].type,yyvsp[0].decl.id));
		  Setattr(yyval.p,"parms", yyvsp[0].decl.parms);
		  /*		  $$ = NewParm($1,$2.id);
				  Setattr($$,"parms",$2.parms); */
                }
    break;

  case 106:
#line 2317 "parser.y"
    {
                  yyval.p = new_node("typemapitem");
		  Setattr(yyval.p,"pattern",yyvsp[-1].pl);
		  /*		  Setattr($$,"multitype",$2); */
               }
    break;

  case 107:
#line 2322 "parser.y"
    {
		 yyval.p = new_node("typemapitem");
		 Setattr(yyval.p,"pattern", yyvsp[-4].pl);
		 /*                 Setattr($$,"multitype",$2); */
		 Setattr(yyval.p,"parms",yyvsp[-1].pl);
               }
    break;

  case 108:
#line 2334 "parser.y"
    {
                   yyval.node = new_node("types");
		   Setattr(yyval.node,"parms",yyvsp[-2].pl);
               }
    break;

  case 109:
#line 2344 "parser.y"
    {
                  Parm *p, *tp;
		  Node *n;
		  Node *tnode = 0;
		  Symtab *tscope = 0;
		  int     specialized = 0;
		  
		  yyval.node = 0;

		  tscope = Swig_symbol_current();          /* Get the current scope */

		  /* If the class name is qualified.  We need to create or lookup namespace entries */
		  yyvsp[-4].str = resolve_node_scope(yyvsp[-4].str);

		  /*
		    we use the new namespace entry 'nscope' only to
		    emit the template node. The template parameters are
		    resolved in the current 'tscope'.
		    
		    this is closer to the C++ (typedef) behavior.
		  */
		  n = Swig_cparse_template_locate(yyvsp[-4].str,yyvsp[-2].p,tscope);

		  /* Patch the argument types to respect namespaces */
		  p = yyvsp[-2].p;
		  while (p) {
		    SwigType *value = Getattr(p,"value");
		    if (!value) {
		      SwigType *ty = Getattr(p,"type");
		      if (ty) {
			if (template_reduce) {
			  SwigType *rty = Swig_symbol_typedef_reduce(ty,tscope);
			  ty = Swig_symbol_type_qualify(rty,tscope);
			  Setattr(p,"type",ty);
			  Delete(rty);
			} else {
			  ty = Swig_symbol_type_qualify(ty,tscope);
			  Setattr(p,"type",ty);
			}
		      }
		    } else {
		      value = Swig_symbol_type_qualify(value,tscope);
		      Setattr(p,"value",value);
		    }
		    
		    p = nextSibling(p);
		  }

		  /* Look for the template */
		  {
                    Node *nn = n;
                    Node *linklistend = 0;
                    while (nn) {
                      Node *templnode = 0;
                      if (Strcmp(nodeType(nn),"template") == 0) {
                        int nnisclass = (Strcmp(Getattr(nn,"templatetype"),"class") == 0); /* if not a templated class it is a templated function */
                        Parm *tparms = Getattr(nn,"templateparms");
                        if (!tparms) {
                          specialized = 1;
                        }
                        if (nnisclass && !specialized && ((ParmList_len(yyvsp[-2].p) > ParmList_len(tparms)))) {
                          Swig_error(cparse_file, cparse_line, "Too many template parameters. Maximum of %d.\n", ParmList_len(tparms));
                        } else if (nnisclass && !specialized && ((ParmList_len(yyvsp[-2].p) < ParmList_numrequired(tparms)))) {
                          Swig_error(cparse_file, cparse_line, "Not enough template parameters specified. %d required.\n", ParmList_numrequired(tparms));
                        } else if (!nnisclass && ((ParmList_len(yyvsp[-2].p) != ParmList_len(tparms)))) {
                          /* must be an overloaded templated method - ignore it as it is overloaded with a different number of template parameters */
                          nn = Getattr(nn,"sym:nextSibling"); /* repeat for overloaded templated functions */
                          continue;
                        } else {
                          int  def_supplied = 0;
                          /* Expand the template */
			  Node *templ = Swig_symbol_clookup(yyvsp[-4].str,0);
			  Parm *targs = templ ? Getattr(templ,"templateparms") : 0;

                          ParmList *temparms;
                          if (specialized) temparms = CopyParmList(yyvsp[-2].p);
                          else temparms = CopyParmList(tparms);

                          /* Create typedef's and arguments */
                          p = yyvsp[-2].p;
                          tp = temparms;
                          while (p) {
                            String *value = Getattr(p,"value");
                            if (def_supplied) {
                              Setattr(p,"default","1");
                            }
                            if (value) {
                              Setattr(tp,"value",value);
                            } else {
                              SwigType *ty = Getattr(p,"type");
                              if (ty) {
                                Setattr(tp,"type",ty);
                              }
                              Delattr(tp,"value");
                            }
			    /* fix default arg values */
			    if (targs) {
			      Parm *pi = temparms;
			      Parm *ti = targs;
			      String *tv = Getattr(tp,"value");
			      if (!tv) tv = Getattr(tp,"type");
			      while(pi != tp) {
				String *name = Getattr(ti,"name");
				String *value = Getattr(pi,"value");
				if (!value) value = Getattr(pi,"type");
				Replaceid(tv, name, value);
				pi = nextSibling(pi);
				ti = nextSibling(ti);
			      }
			    }
                            p = nextSibling(p);
                            tp = nextSibling(tp);
                            if (!p && tp) {
                              p = tp;
                              def_supplied = 1;
                            }
                          }

                          templnode = copy_node(nn);
                          /* We need to set the node name based on name used to instantiate */
                          Setattr(templnode,"name",Copy(yyvsp[-4].str));
                          if (!specialized) {
                            Delattr(templnode,"sym:typename");
                          } else {
                            Setattr(templnode,"sym:typename","1");
                          }
                          if (yyvsp[-6].id) {
                            Swig_cparse_template_expand(templnode,yyvsp[-6].id,temparms,tscope);
                            Setattr(templnode,"sym:name",yyvsp[-6].id);
                          } else {
                            static int cnt = 0;
                            String *nname = NewStringf("__dummy_%d__", cnt++);
                            Swig_cparse_template_expand(templnode,nname,temparms,tscope);
                            Setattr(templnode,"sym:name",nname);
                            Setattr(templnode,"feature:onlychildren",
                                    "typemap,typemapitem,typemapcopy,typedef,types,fragment");
                          }
                          Delattr(templnode,"templatetype");
                          Setattr(templnode,"template",nn);
                          tnode = templnode;
                          Setfile(templnode,cparse_file);
                          Setline(templnode,cparse_line);
                          Delete(temparms);
                          
                          add_symbols_copy(templnode);

                          if (Strcmp(nodeType(templnode),"class") == 0) {

                            /* Identify pure abstract methods */
                            Setattr(templnode,"abstract", pure_abstract(firstChild(templnode)));
                            
                            /* Set up inheritance in symbol table */
                            {
                              Symtab  *csyms;
                              List *baselist = Getattr(templnode,"baselist");
                              csyms = Swig_symbol_current();
                              Swig_symbol_setscope(Getattr(templnode,"symtab"));
                              if (baselist) {
                                List *bases = make_inherit_list(Getattr(templnode,"name"),baselist);
                                if (bases) {
                                  Iterator s;
                                  for (s = First(bases); s.item; s = Next(s)) {
                                    Symtab *st = Getattr(s.item,"symtab");
                                    if (st) {
                                      Swig_symbol_inherit(st);
                                    }
                                  }
                                }
                              }
                              Swig_symbol_setscope(csyms);
                            }

                            /* Merge in addmethods for this class */
                            
                            /* !!! This may be broken.  We may have to  add the addmethods at the beginning of
                               the class */
                            
                            if (extendhash) {
                              String *clsname;
                              Node *am;
                              if (Namespaceprefix) {
                                clsname = NewStringf("%s::%s", Namespaceprefix, Getattr(templnode,"name"));
                              } else {
                                clsname = Getattr(templnode,"name");
                              }
                              am = Getattr(extendhash,clsname);
                              if (am) {
                                Symtab *st = Swig_symbol_current();
                                Swig_symbol_setscope(Getattr(templnode,"symtab"));
                                /*			    Printf(stdout,"%s: %s %x %x\n", Getattr(templnode,"name"), clsname, Swig_symbol_current(), Getattr(templnode,"symtab")); */
                                merge_extensions(templnode,am);
                                Swig_symbol_setscope(st);
                                appendChild(templnode,am);
                                Delattr(extendhash,clsname);
                              }
                            }
                            /* Add to classes hash */
                            if (!classes) classes = NewHash();

                            {
                              if (Namespaceprefix) {
                                String *temp = NewStringf("%s::%s", Namespaceprefix, Getattr(templnode,"name"));
                                Setattr(classes,temp,templnode);
                              } else {
                                Setattr(classes,Swig_symbol_qualifiedscopename(templnode),templnode);
                              }
                            }
                          }
                        }

                        /* all the overloaded templated functions are added into a linked list */
                        if (nscope_inner) {
                          /* non-global namespace */
                          if (templnode) {
                            appendChild(nscope_inner,templnode);
                            if (nscope) yyval.node = nscope;
                          }
                        } else {
                          /* global namespace */
                          if (!linklistend) {
                            yyval.node = templnode;
                          } else {
                            set_nextSibling(linklistend,templnode);
                          }
                          linklistend = templnode;
                        }
                      }
                      nn = Getattr(nn,"sym:nextSibling"); /* repeat for overloaded templated functions. If a templated class there will never be a sibling. */
                    }
		  }
   	          Swig_symbol_setscope(tscope);
		  Namespaceprefix = Swig_symbol_qualifiedscopename(0);
                }
    break;

  case 110:
#line 2584 "parser.y"
    {
		  Swig_warning(0,cparse_file, cparse_line,"%s\n", yyvsp[0].id);
		  yyval.node = 0;
               }
    break;

  case 111:
#line 2594 "parser.y"
    {
                    yyval.node = yyvsp[0].node; 
                    if (yyval.node) {
   		      add_symbols(yyval.node);
                      default_arguments(yyval.node);
   	            }
                }
    break;

  case 112:
#line 2601 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 113:
#line 2602 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 114:
#line 2606 "parser.y"
    {
		  if (Strcmp(yyvsp[-1].id,"C") == 0) {
		    cparse_externc = 1;
		  }
		}
    break;

  case 115:
#line 2610 "parser.y"
    {
		  cparse_externc = 0;
		  if (Strcmp(yyvsp[-4].id,"C") == 0) {
		    Node *n = firstChild(yyvsp[-1].node);
		    yyval.node = new_node("extern");
		    Setattr(yyval.node,"name",yyvsp[-4].id);
		    appendChild(yyval.node,n);
		    while (n) {
		      SwigType *decl = Getattr(n,"decl");
		      if (SwigType_isfunction(decl)) {
			Setattr(n,"storage","externc");
		      }
		      n = nextSibling(n);
		    }
		  } else {
		     Swig_warning(WARN_PARSE_UNDEFINED_EXTERN,cparse_file, cparse_line,"Unrecognized extern type \"%s\".\n", yyvsp[-4].id);
		    yyval.node = new_node("extern");
		    Setattr(yyval.node,"name",yyvsp[-4].id);
		    appendChild(yyval.node,firstChild(yyvsp[-1].node));
		  }
                }
    break;

  case 116:
#line 2637 "parser.y"
    {
              yyval.node = new_node("cdecl");
	      if (yyvsp[-1].dtype.qualifier) SwigType_push(yyvsp[-2].decl.type,yyvsp[-1].dtype.qualifier);
	      Setattr(yyval.node,"type",yyvsp[-3].type);
	      Setattr(yyval.node,"storage",yyvsp[-4].id);
	      Setattr(yyval.node,"name",yyvsp[-2].decl.id);
	      Setattr(yyval.node,"decl",yyvsp[-2].decl.type);
	      Setattr(yyval.node,"parms",yyvsp[-2].decl.parms);
	      Setattr(yyval.node,"value",yyvsp[-1].dtype.val);
	      Setattr(yyval.node,"throws",yyvsp[-1].dtype.throws);
	      Setattr(yyval.node,"throw",yyvsp[-1].dtype.throw);
	      if (!yyvsp[0].node) {
		if (Len(scanner_ccode)) {
		  Setattr(yyval.node,"code",Copy(scanner_ccode));
		}
	      } else {
		Node *n = yyvsp[0].node;
		/* Inherit attributes */
		while (n) {
		  Setattr(n,"type",Copy(yyvsp[-3].type));
		  Setattr(n,"storage",yyvsp[-4].id);
		  n = nextSibling(n);
		}
	      }
	      if (yyvsp[-1].dtype.bitfield) {
		Setattr(yyval.node,"bitfield", yyvsp[-1].dtype.bitfield);
	      }

	      /* Look for "::" declarations (ignored) */
	      if (Strstr(yyvsp[-2].decl.id,"::")) {
                /* This is a special case. If the scope name of the declaration exactly
                   matches that of the declaration, then we will allow it. Otherwise, delete. */
                String *p = Swig_scopename_prefix(yyvsp[-2].decl.id);
		if (p && Namespaceprefix) {
		  if (Strcmp(p,Namespaceprefix) == 0) {
		    Setattr(yyval.node,"name",Swig_scopename_last(yyvsp[-2].decl.id));
		    set_nextSibling(yyval.node,yyvsp[0].node);
		  } else {
		    Delete(yyval.node);
		    yyval.node = yyvsp[0].node;
		  }
		  Delete(p);
		} else {
		  Delete(yyval.node);
		  yyval.node = yyvsp[0].node;
		}
	      } else {
		set_nextSibling(yyval.node,yyvsp[0].node);
	      }
           }
    break;

  case 117:
#line 2691 "parser.y"
    { 
                   yyval.node = 0;
                   Clear(scanner_ccode); 
               }
    break;

  case 118:
#line 2695 "parser.y"
    {
		 yyval.node = new_node("cdecl");
		 if (yyvsp[-1].dtype.qualifier) SwigType_push(yyvsp[-2].decl.type,yyvsp[-1].dtype.qualifier);
		 Setattr(yyval.node,"name",yyvsp[-2].decl.id);
		 Setattr(yyval.node,"decl",yyvsp[-2].decl.type);
		 Setattr(yyval.node,"parms",yyvsp[-2].decl.parms);
		 Setattr(yyval.node,"value",yyvsp[-1].dtype.val);
		 Setattr(yyval.node,"throws",yyvsp[-1].dtype.throws);
		 Setattr(yyval.node,"throw",yyvsp[-1].dtype.throw);
		 if (yyvsp[-1].dtype.bitfield) {
		   Setattr(yyval.node,"bitfield", yyvsp[-1].dtype.bitfield);
		 }
		 if (!yyvsp[0].node) {
		   if (Len(scanner_ccode)) {
		     Setattr(yyval.node,"code",Copy(scanner_ccode));
		   }
		 } else {
		   set_nextSibling(yyval.node,yyvsp[0].node);
		 }
	       }
    break;

  case 119:
#line 2715 "parser.y"
    { 
                   skip_balanced('{','}');
                   yyval.node = 0;
               }
    break;

  case 120:
#line 2721 "parser.y"
    { 
                   yyval.dtype = yyvsp[0].dtype; 
                   yyval.dtype.qualifier = 0;
		   yyval.dtype.throws = 0;
		   yyval.dtype.throw = 0;
              }
    break;

  case 121:
#line 2727 "parser.y"
    { 
                   yyval.dtype = yyvsp[0].dtype; 
		   yyval.dtype.qualifier = yyvsp[-1].str;
		   yyval.dtype.throws = 0;
		   yyval.dtype.throw = 0;
	      }
    break;

  case 122:
#line 2733 "parser.y"
    { 
		   yyval.dtype = yyvsp[0].dtype; 
                   yyval.dtype.qualifier = 0;
		   yyval.dtype.throws = yyvsp[-2].pl;
		   yyval.dtype.throw = NewString("1");
              }
    break;

  case 123:
#line 2739 "parser.y"
    { 
                   yyval.dtype = yyvsp[0].dtype; 
                   yyval.dtype.qualifier = yyvsp[-5].str;
		   yyval.dtype.throws = yyvsp[-2].pl;
		   yyval.dtype.throw = NewString("1");
              }
    break;

  case 124:
#line 2752 "parser.y"
    {
		   SwigType *ty = 0;
		   yyval.node = new_node("enumforward");
		   ty = NewStringf("enum %s", yyvsp[-1].id);
		   Setattr(yyval.node,"name",yyvsp[-1].id);
		   Setattr(yyval.node,"type",ty);
		   Setattr(yyval.node,"sym:weak", "1");
		   add_symbols(yyval.node);
	      }
    break;

  case 125:
#line 2767 "parser.y"
    {
		  SwigType *ty = 0;
                  yyval.node = new_node("enum");
		  ty = NewStringf("enum %s", yyvsp[-4].id);
		  Setattr(yyval.node,"name",yyvsp[-4].id);
		  Setattr(yyval.node,"type",ty);
		  appendChild(yyval.node,yyvsp[-2].node);
		  add_symbols(yyval.node);       /* Add to tag space */
		  add_symbols(yyvsp[-2].node);       /* Add enum values to id space */
	       }
    break;

  case 126:
#line 2778 "parser.y"
    {
		 Node *n;
		 SwigType *ty = 0;
		 String   *unnamed = 0;
		 int       unnamedinstance = 0;

		 yyval.node = new_node("enum");
		 if (yyvsp[-5].id) {
		   Setattr(yyval.node,"name",yyvsp[-5].id);
		   ty = NewStringf("enum %s", yyvsp[-5].id);
		 } else if (yyvsp[-1].decl.id) {
		   unnamed = make_unnamed();
		   ty = NewStringf("enum %s", unnamed);
		   Setattr(yyval.node,"unnamed",unnamed);
                   /* name is not set for unnamed enum instances, e.g. enum { foo } Instance; */
		   if (yyvsp[-7].id && Cmp(yyvsp[-7].id,"typedef") == 0) {
		     Setattr(yyval.node,"name",yyvsp[-1].decl.id);
                   } else {
                     unnamedinstance = 1;
                   }
		   Setattr(yyval.node,"storage",yyvsp[-7].id);
		 }
		 if (yyvsp[-1].decl.id && Cmp(yyvsp[-7].id,"typedef") == 0) {
		   Setattr(yyval.node,"tdname",yyvsp[-1].decl.id);
                   Setattr(yyval.node,"allows_typedef","1");
                 }
		 appendChild(yyval.node,yyvsp[-3].node);
		 n = new_node("cdecl");
		 Setattr(n,"type",ty);
		 Setattr(n,"name",yyvsp[-1].decl.id);
		 Setattr(n,"storage",yyvsp[-7].id);
		 Setattr(n,"decl",yyvsp[-1].decl.type);
		 Setattr(n,"parms",yyvsp[-1].decl.parms);
		 Setattr(n,"unnamed",unnamed);

                 if (unnamedinstance) {
		   Setattr(yyval.node,"type",NewString("enum "));
		   Setattr(yyval.node,"unnamedinstance","1");
		   Setattr(n,"unnamedinstance","1");
                 }
		 if (yyvsp[0].node) {
		   Node *p = yyvsp[0].node;
		   set_nextSibling(n,p);
		   while (p) {
		     Setattr(p,"type",Copy(ty));
		     Setattr(p,"unnamed",unnamed);
		     Setattr(p,"storage",yyvsp[-7].id);
		     p = nextSibling(p);
		   }
		 } else {
		   if (Len(scanner_ccode)) {
		     Setattr(n,"code",Copy(scanner_ccode));
		   }
		 }

                 /* Ensure that typedef enum ABC {foo} XYZ; uses XYZ for sym:name, like structs.
                  * Note that class_rename/yyrename are bit of a mess so used this simple approach to change the name. */
                 if (yyvsp[-1].decl.id && yyvsp[-5].id && Cmp(yyvsp[-7].id,"typedef") == 0) {
                   Setattr(yyval.node, "parser:makename", NewString(yyvsp[-1].decl.id));
                 }

		 add_symbols(yyval.node);       /* Add enum to tag space */
		 set_nextSibling(yyval.node,n);

		 add_symbols(yyvsp[-3].node);       /* Add enum values to id space */
	         add_symbols(n);
	       }
    break;

  case 127:
#line 2847 "parser.y"
    {
                   /* This is a sick hack.  If the ctor_end has parameters,
                      and the parms paremeter only has 1 parameter, this
                      could be a declaration of the form:

                         type (id)(parms)

			 Otherwise it's an error. */
                    int err = 0;
                    yyval.node = 0;

		    if ((ParmList_len(yyvsp[-2].pl) == 1) && (!Swig_scopename_check(yyvsp[-4].type))) {
		      SwigType *ty = Getattr(yyvsp[-2].pl,"type");
		      String *name = Getattr(yyvsp[-2].pl,"name");
		      err = 1;
		      if (!name) {
			yyval.node = new_node("cdecl");
			Setattr(yyval.node,"type",yyvsp[-4].type);
			Setattr(yyval.node,"storage",yyvsp[-5].id);
			Setattr(yyval.node,"name",ty);

			if (yyvsp[0].decl.have_parms) {
			  SwigType *decl = NewString("");
			  SwigType_add_function(decl,yyvsp[0].decl.parms);
			  Setattr(yyval.node,"decl",decl);
			  Setattr(yyval.node,"parms",yyvsp[0].decl.parms);
			  if (Len(scanner_ccode)) {
			    Setattr(yyval.node,"code",Copy(scanner_ccode));
			  }
			}
			if (yyvsp[0].decl.defarg) {
			  Setattr(yyval.node,"value",yyvsp[0].decl.defarg);
			}
			Setattr(yyval.node,"throws",yyvsp[0].decl.throws);
			Setattr(yyval.node,"throw",yyvsp[0].decl.throw);
			err = 0;
		      }
		    }
		    if (err) {
		      Swig_error(cparse_file,cparse_line,"Syntax error in input(2).\n");
		    }
                }
    break;

  case 128:
#line 2895 "parser.y"
    {  yyval.node = yyvsp[0].node; }
    break;

  case 129:
#line 2896 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 130:
#line 2897 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 131:
#line 2898 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 132:
#line 2899 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 133:
#line 2900 "parser.y"
    { yyval.node = 0; }
    break;

  case 134:
#line 2906 "parser.y"
    {
                   List *bases = 0;

		   /* preserve the current scope */
		   prev_symtab = Swig_symbol_current();
		  
		   /* If the class name is qualified.  We need to create or lookup namespace/scope entries */
		   yyvsp[-2].str = resolve_node_scope(yyvsp[-2].str);
		   
		   /* support for old nested classes "pseudo" support, such as:

		         %rename(Ala__Ola) Ala::Ola;
			class Ala::Ola {
			public:
			    Ola() {}
		         };

		      this should dissapear with a proper implementation is added.
		   */
		   if (nscope_inner && Strcmp(nodeType(nscope_inner),"namespace") != 0) {
		     if (Namespaceprefix) {
		       String *name = NewStringf("%s::%s", Namespaceprefix, yyvsp[-2].str);		       
		       yyvsp[-2].str = name;
		       Namespaceprefix = 0;
		       nscope_inner = 0;
		     }
		   }

                   class_rename = make_name(yyvsp[-2].str,0);
		   Classprefix = NewString(yyvsp[-2].str);
		   /* Deal with inheritance  */
		   if (yyvsp[-1].bases) {
		     bases = make_inherit_list(yyvsp[-2].str,Getattr(yyvsp[-1].bases,"public"));
		   }
		   if (SwigType_istemplate(yyvsp[-2].str)) {
		     String *fbase, *tbase, *prefix;
		     prefix = SwigType_templateprefix(yyvsp[-2].str);
		     if (Namespaceprefix) {
		       fbase = NewStringf("%s::%s", Namespaceprefix,yyvsp[-2].str);
		       tbase = NewStringf("%s::%s", Namespaceprefix, prefix);
		     } else {
		       fbase = Copy(yyvsp[-2].str);
		       tbase = Copy(prefix);
		     }
		     rename_inherit(tbase,fbase);
		     Delete(fbase);
		     Delete(tbase);
		     Delete(prefix);
		   }
                   if (strcmp(yyvsp[-3].id,"class") == 0) {
		     cplus_mode = CPLUS_PRIVATE;
		   } else {
		     cplus_mode = CPLUS_PUBLIC;
		   }
		   Swig_symbol_newscope();
		   Swig_symbol_setscopename(yyvsp[-2].str);
		   if (bases) {
		     Iterator s;
		     for (s = First(bases); s.item; s = Next(s)) {
		       Symtab *st = Getattr(s.item,"symtab");
		       if (st) {
			 Swig_symbol_inherit(st); 
		       }
		     }
		   }
		   Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		   cparse_start_line = cparse_line;

		   /* If there are active template parameters, we need to make sure they are
                      placed in the class symbol table so we can catch shadows */

		   if (template_parameters) {
		     Parm *tp = template_parameters;
		     while(tp) {
		       Node *tn = new_node("templateparm");
		       Setattr(tn,"name",Getattr(tp,"name"));
		       Swig_symbol_cadd(Copy(Getattr(tp,"name")),tn);
		       tp = nextSibling(tp);
		     }
		   }
		   inclass = 1;
               }
    break;

  case 135:
#line 2987 "parser.y"
    {
		 Node *p;
		 SwigType *ty;
		 Symtab *cscope = prev_symtab;
		 Node *am = 0;
		 inclass = 0;
		 yyval.node = new_node("class");
		 Setline(yyval.node,cparse_start_line);
		 Setattr(yyval.node,"name",yyvsp[-6].str);
		 Setattr(yyval.node,"kind",yyvsp[-7].id);
		 if (yyvsp[-5].bases) {
		   Setattr(yyval.node,"baselist", Getattr(yyvsp[-5].bases,"public"));
		   Setattr(yyval.node,"protectedbaselist", Getattr(yyvsp[-5].bases,"protected"));
		   Setattr(yyval.node,"privatebaselist", Getattr(yyvsp[-5].bases,"private"));
		 }
		 Setattr(yyval.node,"allows_typedef","1");
		 /* Check for pure-abstract class */
		 Setattr(yyval.node,"abstract", pure_abstract(yyvsp[-2].node));
		 
		 /* This bit of code merges in a previously defined %extend directive (if any) */
		 
		 if (extendhash) {
		   String *clsname = Swig_symbol_qualifiedscopename(0);
		   am = Getattr(extendhash,clsname);
		   if (am) {
		     merge_extensions(yyval.node,am);
		     Delattr(extendhash,clsname);
		   }
		   Delete(clsname);
		 }
		 if (!classes) classes = NewHash();
		 Setattr(classes,Swig_symbol_qualifiedscopename(0),yyval.node);

		 appendChild(yyval.node,yyvsp[-2].node);
		 if (am) appendChild(yyval.node,am);

		 p = yyvsp[0].node;
		 if (p) {
		   set_nextSibling(yyval.node,p);
		 }
		 
		 if (cparse_cplusplus && !cparse_externc) {
		   ty = NewString(yyvsp[-6].str);
		 } else {
		   ty = NewStringf("%s %s", yyvsp[-7].id,yyvsp[-6].str);
		 }
		 while (p) {
		   Setattr(p,"storage",yyvsp[-8].id);
		   Setattr(p,"type",ty);
		   p = nextSibling(p);
		 }
		 /* Dump nested classes */
		 {
		   String *name = yyvsp[-6].str;
		   if (yyvsp[0].node) {
		     SwigType *decltype = Getattr(yyvsp[0].node,"decl");
		     if (Cmp(yyvsp[-8].id,"typedef") == 0) {
		       if (!decltype || !Len(decltype)) {
			 name = Getattr(yyvsp[0].node,"name");
			 Setattr(yyval.node,"tdname",Copy(name));

			 /* Use typedef name as class name */
			 if (class_rename && (Strcmp(class_rename,yyvsp[-6].str) == 0)) {
			   class_rename = NewString(name);
			 }
			 if (!Getattr(classes,name)) {
			   Setattr(classes,name,yyval.node);
			 }
			 Setattr(yyval.node,"decl",decltype);
		       }
		     }
		   }
		   appendChild(yyval.node,dump_nested(Char(name)));
		 }

		 if (cplus_mode != CPLUS_PUBLIC) {
		 /* we 'open' the class at the end, to allow %template
		    to add new members */
		   Node *pa = new_node("access");
		   Setattr(pa,"kind","public");
		   cplus_mode = CPLUS_PUBLIC;
		   appendChild(yyval.node,pa);
		 }

		 Setattr(yyval.node,"symtab",Swig_symbol_popscope());

		 Classprefix = 0;
		 if (nscope_inner) {
		   /* this is tricky */
		   /* we add the declaration in the original namespace */
		   appendChild(nscope_inner,yyval.node);
		   Swig_symbol_setscope(Getattr(nscope_inner,"symtab"));
		   Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		   add_symbols(yyval.node);
		   if (nscope) yyval.node = nscope;
		   /* but the variable definition in the current scope */
		   Swig_symbol_setscope(cscope);
		   Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		   add_symbols(yyvsp[0].node);
		 } else {
		   yyrename = NewString(class_rename);
		   Namespaceprefix = Swig_symbol_qualifiedscopename(0);

		   add_symbols(yyval.node);
		   add_symbols(yyvsp[0].node);
		 }
		 Swig_symbol_setscope(cscope);
		 Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	       }
    break;

  case 136:
#line 3099 "parser.y"
    {
	       class_rename = make_name(0,0);
	       if (strcmp(yyvsp[-1].id,"class") == 0) {
		 cplus_mode = CPLUS_PRIVATE;
	       } else {
		 cplus_mode = CPLUS_PUBLIC;
	       }
	       Swig_symbol_newscope();
	       cparse_start_line = cparse_line;
	       inclass = 1;
	       Classprefix = NewString("");
	       Namespaceprefix = Swig_symbol_qualifiedscopename(0);
             }
    break;

  case 137:
#line 3111 "parser.y"
    {
	       String *unnamed;
	       Node *n;
	       Classprefix = 0;
	       inclass = 0;
	       unnamed = make_unnamed();
	       yyval.node = new_node("class");
	       Setline(yyval.node,cparse_start_line);
	       Setattr(yyval.node,"kind",yyvsp[-6].id);
	       Setattr(yyval.node,"storage",yyvsp[-7].id);
	       Setattr(yyval.node,"unnamed",unnamed);
	       Setattr(yyval.node,"allows_typedef","1");

	       /* Check for pure-abstract class */
	       Setattr(yyval.node,"abstract", pure_abstract(yyvsp[-3].node));

	       n = new_node("cdecl");
	       Setattr(n,"name",yyvsp[-1].decl.id);
	       Setattr(n,"unnamed",unnamed);
	       Setattr(n,"type",unnamed);
	       Setattr(n,"decl",yyvsp[-1].decl.type);
	       Setattr(n,"parms",yyvsp[-1].decl.parms);
	       Setattr(n,"storage",yyvsp[-7].id);
	       if (yyvsp[0].node) {
		 Node *p = yyvsp[0].node;
		 set_nextSibling(n,p);
		 while (p) {
		   Setattr(p,"unnamed",unnamed);
		   Setattr(p,"type",Copy(unnamed));
		   Setattr(p,"storage",yyvsp[-7].id);
		   p = nextSibling(p);
		 }
	       }
	       set_nextSibling(yyval.node,n);
	       {
		 /* If a proper typedef name was given, we'll use it to set the scope name */
		 String *name = 0;
		 if (yyvsp[-7].id && (strcmp(yyvsp[-7].id,"typedef") == 0)) {
		   if (!Len(yyvsp[-1].decl.type)) {	
		     name = yyvsp[-1].decl.id;
		     Setattr(yyval.node,"tdname",name);
		     Setattr(yyval.node,"name",name);
		     Swig_symbol_setscopename(name);

		     /* If a proper name given, we use that as the typedef, not unnamed */
		     Clear(unnamed);
		     Append(unnamed, name);
		     
		     n = nextSibling(n);
		     set_nextSibling(yyval.node,n);

		     /* Check for previous extensions */
		     if (extendhash) {
		       String *clsname = Swig_symbol_qualifiedscopename(0);
		       Node *am = Getattr(extendhash,clsname);
		       if (am) {
			 /* Merge the extension into the symbol table */
			 merge_extensions(yyval.node,am);
			 appendChild(yyval.node,am);
			 Delattr(extendhash,clsname);
		       }
		       Delete(clsname);
		     }
		     if (!classes) classes = NewHash();
		     Setattr(classes,Swig_symbol_qualifiedscopename(0),yyval.node);
		   } else {
		     Swig_symbol_setscopename((char*)"<unnamed>");
		   }
		 }
		 appendChild(yyval.node,yyvsp[-3].node);
		 appendChild(yyval.node,dump_nested(Char(name)));
	       }
	       /* Pop the scope */
	       Setattr(yyval.node,"symtab",Swig_symbol_popscope());
	       if (class_rename) {
		 yyrename = NewString(class_rename);
	       }
	       Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	       add_symbols(yyval.node);
	       add_symbols(n);
              }
    break;

  case 138:
#line 3194 "parser.y"
    { yyval.node = 0; }
    break;

  case 139:
#line 3195 "parser.y"
    {
                        yyval.node = new_node("cdecl");
                        Setattr(yyval.node,"name",yyvsp[-1].decl.id);
                        Setattr(yyval.node,"decl",yyvsp[-1].decl.type);
                        Setattr(yyval.node,"parms",yyvsp[-1].decl.parms);
			set_nextSibling(yyval.node,yyvsp[0].node);
                    }
    break;

  case 140:
#line 3207 "parser.y"
    {
              if (yyvsp[-3].id && (Strcmp(yyvsp[-3].id,"friend") == 0)) {
		/* Ignore */
                yyval.node = 0; 
	      } else {
		yyval.node = new_node("classforward");
		Setfile(yyval.node,cparse_file);
		Setline(yyval.node,cparse_line);
		Setattr(yyval.node,"kind",yyvsp[-2].id);
		Setattr(yyval.node,"name",yyvsp[-1].str);
		Setattr(yyval.node,"sym:weak", "1");
		add_symbols(yyval.node);
	      }
             }
    break;

  case 141:
#line 3227 "parser.y"
    { template_parameters = yyvsp[-1].tparms; }
    break;

  case 142:
#line 3227 "parser.y"
    {
		      String *tname = 0;
		      int     error = 0;

		      /* check if we get a namespace node with a class declaration, and retrieve the class */
		      Symtab *cscope = Swig_symbol_current();
		      Symtab *sti = 0;
		      Node *ntop = yyvsp[0].node;
		      Node *ni = ntop;
		      SwigType *ntype = ni ? nodeType(ni) : 0;
		      while (ni && Strcmp(ntype,"namespace") == 0) {
			sti = Getattr(ni,"symtab");
			ni = firstChild(ni);
			ntype = nodeType(ni);
		      }
		      if (sti) {
			Swig_symbol_setscope(sti);
			Namespaceprefix = Swig_symbol_qualifiedscopename(0);
			yyvsp[0].node = ni;
		      }

                      template_parameters = 0;
                      yyval.node = yyvsp[0].node;
		      if (yyval.node) tname = Getattr(yyval.node,"name");
		      
		      /* Check if the class is a template specialization */
		      if ((yyval.node) && (Strstr(tname,"<")) && (Strncmp(tname,"operator ",9) != 0)) {
			/* If a specialization.  Check if defined. */
			Node *tempn = 0;
			{
			  String *tbase = SwigType_templateprefix(tname);
			  tempn = Swig_symbol_clookup_local(tbase,0);
			  if (!tempn || (Strcmp(nodeType(tempn),"template") != 0)) {
			    SWIG_WARN_NODE_BEGIN(tempn);
			    Swig_warning(WARN_PARSE_TEMPLATE_SP_UNDEF, Getfile(yyval.node),Getline(yyval.node),"Specialization of non-template '%s'.\n", tbase);
			    SWIG_WARN_NODE_END(tempn);
			    tempn = 0;
			    error = 1;
			  }
			  Delete(tbase);
			}
			Setattr(yyval.node,"specialization","1");
			Setattr(yyval.node,"templatetype",nodeType(yyval.node));
			set_nodeType(yyval.node,"template");
			/* Template partial specialization */
			if (tempn && (yyvsp[-3].tparms) && (yyvsp[0].node)) {
			  List   *tlist;
			  String *targs = SwigType_templateargs(tname);
			  tlist = SwigType_parmlist(targs);
			  /*			  Printf(stdout,"targs = '%s' %s\n", targs, tlist); */
			  if (!Getattr(yyval.node,"sym:weak")) {
			    Setattr(yyval.node,"sym:typename","1");
			  }
			  
			  if (Len(tlist) != ParmList_len(Getattr(tempn,"templateparms"))) {
			    Swig_error(Getfile(yyval.node),Getline(yyval.node),"Inconsistent argument count in template partial specialization. %d %d\n", Len(tlist), ParmList_len(Getattr(tempn,"templateparms")));
			    
			  } else {

			  /* This code builds the argument list for the partial template
                             specialization.  This is a little hairy, but the idea is as
                             follows:

                             $3 contains a list of arguments supplied for the template.
                             For example template<class T>.

                             tlist is a list of the specialization arguments--which may be
                             different.  For example class<int,T>.

                             tp is a copy of the arguments in the original template definition.
     
                             The patching algorithm walks through the list of supplied
                             arguments ($3), finds the position in the specialization arguments
                             (tlist), and then patches the name in the argument list of the
                             original template.
			  */

			  {
			    String *pn;
			    Parm *p, *p1;
			    int i, nargs;
			    Parm *tp = CopyParmList(Getattr(tempn,"templateparms"));
			    nargs = Len(tlist);
			    p = yyvsp[-3].tparms;
			    while (p) {
			      for (i = 0; i < nargs; i++){
				pn = Getattr(p,"name");
				if (Strcmp(pn,SwigType_base(Getitem(tlist,i))) == 0) {
				  int j;
				  Parm *p1 = tp;
				  for (j = 0; j < i; j++) {
				    p1 = nextSibling(p1);
				  }
				  Setattr(p1,"name",pn);
				  Setattr(p1,"partialarg","1");
				}
			      }
			      p = nextSibling(p);
			    }
			    p1 = tp;
			    i = 0;
			    while (p1) {
			      if (!Getattr(p1,"partialarg")) {
				Delattr(p1,"name");
				Setattr(p1,"type", Getitem(tlist,i));
			      } 
			      i++;
			      p1 = nextSibling(p1);
			    }
			    Setattr(yyval.node,"templateparms",tp);
			    Delete(tp);
			  }
#if 0
			  /* Patch the parameter list */
			  if (tempn) {
			    Parm *p,*p1;
			    ParmList *tp = CopyParmList(Getattr(tempn,"templateparms"));
			    p = yyvsp[-3].tparms;
			    p1 = tp;
			    while (p && p1) {
			      String *pn = Getattr(p,"name");
			      Printf(stdout,"pn = '%s'\n", pn);
			      if (pn) Setattr(p1,"name",pn);
			      else Delattr(p1,"name");
			      pn = Getattr(p,"type");
			      if (pn) Setattr(p1,"type",pn);
			      p = nextSibling(p);
			      p1 = nextSibling(p1);
			    }
			    Setattr(yyval.node,"templateparms",tp);
			    Delete(tp);
			  } else {
			    Setattr(yyval.node,"templateparms",yyvsp[-3].tparms);
			  }
#endif
			  Delattr(yyval.node,"specialization");
			  Setattr(yyval.node,"partialspecialization","1");
			  /* Create a specialized name for matching */
			  {
			    Parm *p = yyvsp[-3].tparms;
			    String *fname = NewString(Getattr(yyval.node,"name"));
			    String *ffname = 0;

			    char   tmp[32];
			    int    i;
			    while (p) {
			      String *n = Getattr(p,"name");
			      if (!n) {
				p = nextSibling(p);
				continue;
			      }
			      for (i = 0; i < Len(tlist); i++) {
				if (Strstr(Getitem(tlist,i),n)) {
				  sprintf(tmp,"$%d",i+1);
				  Replaceid(fname,n,tmp);
				}
			      }
			      p = nextSibling(p);
			    }
			    /* Patch argument names with typedef */
			    {
			      Iterator tt;
			      List *tparms = SwigType_parmlist(fname);
			      ffname = SwigType_templateprefix(fname);
			      Append(ffname,"<(");
			      for (tt = First(tparms); tt.item; ) {
				SwigType *rtt = Swig_symbol_typedef_reduce(tt.item,0);
				SwigType *ttr = Swig_symbol_type_qualify(rtt,0);
				Append(ffname,ttr);
				tt = Next(tt);
				if (tt.item) Putc(',',ffname);
				Delete(rtt);
				Delete(ttr);
			      }
			      Append(ffname,")>");
			    }
			    {
			      String *partials = Getattr(tempn,"partials");
			      if (!partials) {
				partials = NewList();
				Setattr(tempn,"partials",partials);
			      }
			      /*			      Printf(stdout,"partial: fname = '%s', '%s'\n", fname, Swig_symbol_typedef_reduce(fname,0)); */
			      Append(partials,ffname);
			    }
			    Setattr(yyval.node,"partialargs",ffname);
			    Swig_symbol_cadd(ffname,yyval.node);
			  }
			  }
			  Delete(tlist);
			  Delete(targs);
			} else {
			  /* Need to resolve exact specialization name */
			  /* add default args from generic template */
			  String *ty = Swig_symbol_template_deftype(tname,0);
			  String *fname = Swig_symbol_type_qualify(ty,0);
			  Swig_symbol_cadd(fname,yyval.node);
			  Delete(ty);
			  Delete(fname);
			}
		      }  else if (yyval.node) {
			Setattr(yyval.node,"templatetype",nodeType(yyvsp[0].node));
			set_nodeType(yyval.node,"template");
			Setattr(yyval.node,"templateparms", yyvsp[-3].tparms);
			if (!Getattr(yyval.node,"sym:weak")) {
			  Setattr(yyval.node,"sym:typename","1");
			}
			add_symbols(yyval.node);
                        default_arguments(yyval.node);
			/* We also place a fully parameterized version in the symbol table */
			{
			  Parm *p;
			  String *fname = NewStringf("%s<(",Getattr(yyval.node,"name"));
			  p = yyvsp[-3].tparms;
			  while (p) {
			    String *n = Getattr(p,"name");
			    if (!n) n = Getattr(p,"type");
			    Printf(fname,"%s", n);
			    p = nextSibling(p);
			    if (p) Putc(',',fname);
			  }
			  Printf(fname,")>");
			  Swig_symbol_cadd(fname,yyval.node);
			}
		      }
		      yyval.node = ntop;
		      Swig_symbol_setscope(cscope);
		      Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		      if (error) yyval.node = 0;
                  }
    break;

  case 143:
#line 3457 "parser.y"
    {
		  Swig_warning(WARN_PARSE_EXPLICIT_TEMPLATE, cparse_file, cparse_line, "Explicit template instantiation ignored.\n");
                   yyval.node = 0; 
                }
    break;

  case 144:
#line 3463 "parser.y"
    {
		  yyval.node = yyvsp[0].node;
                }
    break;

  case 145:
#line 3466 "parser.y"
    {
                   yyval.node = yyvsp[0].node;
                }
    break;

  case 146:
#line 3469 "parser.y"
    {
                   yyval.node = yyvsp[0].node;
                }
    break;

  case 147:
#line 3472 "parser.y"
    {
		  yyval.node = 0;
                }
    break;

  case 148:
#line 3475 "parser.y"
    {
                  yyval.node = yyvsp[0].node;
                }
    break;

  case 149:
#line 3480 "parser.y"
    {
		   /* Rip out the parameter names */
		  Parm *p = yyvsp[0].pl;
		  yyval.tparms = yyvsp[0].pl;

		  while (p) {
		    String *name = Getattr(p,"name");
		    if (!name) {
		      /* Hmmm. Maybe it's a 'class T' parameter */
		      char *type = Char(Getattr(p,"type"));
		      /* Template template parameter */
		      if (strncmp(type,"template<class> ",16) == 0) {
			type += 16;
		      }
		      if ((strncmp(type,"class ",6) == 0) || (strncmp(type,"typename ", 9) == 0)) {
			char *t = strchr(type,' ');
			Setattr(p,"name", t+1);
		      } else {
			/*
			 Swig_error(cparse_file, cparse_line, "Missing template parameter name\n");
			 $$.rparms = 0;
			 $$.parms = 0;
			 break; */
		      }
		    }
		    p = nextSibling(p);
		  }
                 }
    break;

  case 150:
#line 3512 "parser.y"
    {
                  String *uname = Swig_symbol_type_qualify(yyvsp[-1].str,0);
                  yyval.node = new_node("using");
		  Setattr(yyval.node,"uname",uname);
		  Setattr(yyval.node,"name", Swig_scopename_last(yyvsp[-1].str));
		  add_symbols(yyval.node);
             }
    break;

  case 151:
#line 3519 "parser.y"
    {
	       Node *n = Swig_symbol_clookup(yyvsp[-1].str,0);
	       if (!n) {
		 Swig_error(cparse_file, cparse_line, "Nothing known about namespace '%s'\n", yyvsp[-1].str);
		 yyval.node = 0;
	       } else {

		 while (Strcmp(nodeType(n),"using") == 0) {
		   n = Getattr(n,"node");
		 }
		 if (n) {
		   if (Strcmp(nodeType(n),"namespace") == 0) {
		     yyval.node = new_node("using");
		     Setattr(yyval.node,"node",n);
		     Setattr(yyval.node,"namespace", yyvsp[-1].str);
		     Swig_symbol_inherit(Getattr(n,"symtab"));
		   } else {
		     Swig_error(cparse_file, cparse_line, "'%s' is not a namespace.\n", yyvsp[-1].str);
		     yyval.node = 0;
		   }
		 } else {
		   yyval.node = 0;
		 }
	       }
             }
    break;

  case 152:
#line 3546 "parser.y"
    { 
                Hash *h;
                yyvsp[-2].node = Swig_symbol_current();
		h = Swig_symbol_clookup(yyvsp[-1].str,0);
		if (h && (Strcmp(nodeType(h),"namespace") == 0)) {
		  if (Getattr(h,"alias")) {
		    h = Getattr(h,"namespace");
		    Swig_warning(WARN_PARSE_NAMESPACE_ALIAS, cparse_file, cparse_line, "Namespace alias '%s' not allowed here. Assuming '%s'\n",
				 yyvsp[-1].str, Getattr(h,"name"));
		    yyvsp[-1].str = Getattr(h,"name");
		  }
		  Swig_symbol_setscope(Getattr(h,"symtab"));
		} else {
		  Swig_symbol_newscope();
		  Swig_symbol_setscopename(yyvsp[-1].str);
		}
		Namespaceprefix = Swig_symbol_qualifiedscopename(0);
             }
    break;

  case 153:
#line 3563 "parser.y"
    {
                Node *n = yyvsp[-1].node;
		set_nodeType(n,"namespace");
		Setattr(n,"name",yyvsp[-4].str);
                Setattr(n,"symtab", Swig_symbol_popscope());
		Swig_symbol_setscope(yyvsp[-5].node);
		yyval.node = n;
		Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		add_symbols(yyval.node);
             }
    break;

  case 154:
#line 3573 "parser.y"
    {
	       Hash *h;
	       yyvsp[-1].node = Swig_symbol_current();
	       h = Swig_symbol_clookup((char *)"    ",0);
	       if (h && (Strcmp(nodeType(h),"namespace") == 0)) {
		 Swig_symbol_setscope(Getattr(h,"symtab"));
	       } else {
		 Swig_symbol_newscope();
		 /* we don't use "__unnamed__", but a long 'empty' name */
		 Swig_symbol_setscopename("    ");
	       }
	       Namespaceprefix = 0;
             }
    break;

  case 155:
#line 3585 "parser.y"
    {
	       yyval.node = yyvsp[-1].node;
	       set_nodeType(yyval.node,"namespace");
	       Setattr(yyval.node,"unnamed","1");
	       Setattr(yyval.node,"symtab", Swig_symbol_popscope());
	       Swig_symbol_setscope(yyvsp[-4].node);
	       Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	       add_symbols(yyval.node);
             }
    break;

  case 156:
#line 3594 "parser.y"
    {
	       /* Namespace alias */
	       Node *n;
	       yyval.node = new_node("namespace");
	       Setattr(yyval.node,"name",yyvsp[-3].id);
	       Setattr(yyval.node,"alias",yyvsp[-1].str);
	       n = Swig_symbol_clookup(yyvsp[-1].str,0);
	       if (!n) {
		 Swig_error(cparse_file, cparse_line, "Unknown namespace '%s'\n", yyvsp[-1].str);
		 yyval.node = 0;
	       } else {
		 if (Strcmp(nodeType(n),"namespace") != 0) {
		   Swig_error(cparse_file, cparse_line, "'%s' is not a namespace\n",yyvsp[-1].str);
		   yyval.node = 0;
		 } else {
		   while (Getattr(n,"alias")) {
		     n = Getattr(n,"namespace");
		   }
		   Setattr(yyval.node,"namespace",n);
		   add_symbols(yyval.node);
		   /* Set up a scope alias */
		   Swig_symbol_alias(yyvsp[-3].id,Getattr(n,"symtab"));
		 }
	       }
             }
    break;

  case 157:
#line 3621 "parser.y"
    {
                   yyval.node = yyvsp[-1].node;
                   /* Insert cpp_member (including any siblings) to the front of the cpp_members linked list */
		   if (yyval.node) {
		     Node *p = yyval.node;
		     Node *pp =0;
		     while (p) {
		       pp = p;
		       p = nextSibling(p);
		     }
		     set_nextSibling(pp,yyvsp[0].node);
		   } else {
		     yyval.node = yyvsp[0].node;
		   }
             }
    break;

  case 158:
#line 3636 "parser.y"
    { 
                  if (cplus_mode != CPLUS_PUBLIC) {
		     Swig_error(cparse_file,cparse_line,"%%extend can only be used in a public section\n");
		  }
             }
    break;

  case 159:
#line 3640 "parser.y"
    {
	       yyval.node = new_node("extend");
	       Swig_tag_nodes(yyvsp[-2].node,"feature:extend",(char*) "1");
	       appendChild(yyval.node,yyvsp[-2].node);
	       set_nextSibling(yyval.node,yyvsp[0].node);
	     }
    break;

  case 160:
#line 3646 "parser.y"
    { yyval.node = 0;}
    break;

  case 161:
#line 3647 "parser.y"
    {
	       skip_decl();
		   {
		     static int last_error_line = -1;
		     if (last_error_line != cparse_line) {
		       Swig_error(cparse_file, cparse_line,"Syntax error in input(3).\n");
		       last_error_line = cparse_line;
		     }
		   }
	     }
    break;

  case 162:
#line 3656 "parser.y"
    { 
                yyval.node = yyvsp[0].node;
             }
    break;

  case 163:
#line 3667 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 164:
#line 3668 "parser.y"
    { 
                 yyval.node = yyvsp[0].node; 
		 if (extendmode) {
		   String *symname;
		   symname= make_name(Getattr(yyval.node,"name"), Getattr(yyval.node,"decl"));
		   if (Strcmp(symname,Getattr(yyval.node,"name")) == 0) {
		     /* No renaming operation.  Set name to class name */
		     yyrename = NewString(Getattr(current_class,"sym:name"));
		   } else {
		     yyrename = symname;
		   }
		 }
		 add_symbols(yyval.node);
                 default_arguments(yyval.node);
             }
    break;

  case 165:
#line 3683 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 166:
#line 3684 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 167:
#line 3685 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 168:
#line 3686 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 169:
#line 3687 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 170:
#line 3688 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 171:
#line 3689 "parser.y"
    { yyval.node = 0; }
    break;

  case 172:
#line 3690 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 173:
#line 3691 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 174:
#line 3692 "parser.y"
    { yyval.node = 0; }
    break;

  case 175:
#line 3693 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 176:
#line 3694 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 177:
#line 3695 "parser.y"
    { yyval.node = 0; }
    break;

  case 178:
#line 3696 "parser.y"
    {yyval.node = yyvsp[0].node; }
    break;

  case 179:
#line 3697 "parser.y"
    {yyval.node = yyvsp[0].node; }
    break;

  case 180:
#line 3698 "parser.y"
    { yyval.node = 0; }
    break;

  case 181:
#line 3707 "parser.y"
    {
              if (Classprefix) {
		 SwigType *decl = NewString("");
		 yyval.node = new_node("constructor");
		 Setattr(yyval.node,"name",yyvsp[-4].type);
		 Setattr(yyval.node,"parms",yyvsp[-2].pl);
		 SwigType_add_function(decl,yyvsp[-2].pl);
		 Setattr(yyval.node,"decl",decl);
		 Setattr(yyval.node,"throws",yyvsp[0].decl.throws);
		 Setattr(yyval.node,"throw",yyvsp[0].decl.throw);
		 if (Len(scanner_ccode)) {
		   Setattr(yyval.node,"code",Copy(scanner_ccode));
		 }
		 SetFlag(yyval.node,"feature:new");
	      } else {
		yyval.node = 0;
              }
              }
    break;

  case 182:
#line 3729 "parser.y"
    {
               yyval.node = new_node("destructor");
	       Setattr(yyval.node,"name",NewStringf("~%s",yyvsp[-4].str));
	       if (Len(scanner_ccode)) {
		 Setattr(yyval.node,"code",Copy(scanner_ccode));
	       }
	       {
		 String *decl = NewString("");
		 SwigType_add_function(decl,yyvsp[-2].pl);
		 Setattr(yyval.node,"decl",decl);
	       }
	       Setattr(yyval.node,"throws",yyvsp[0].dtype.throws);
	       Setattr(yyval.node,"throw",yyvsp[0].dtype.throw);
	       add_symbols(yyval.node);
	      }
    break;

  case 183:
#line 3747 "parser.y"
    {
		yyval.node = new_node("destructor");
	       /* Check for template names.  If the class is a template
		  and the constructor is missing the template part, we
		  add it */
	       {
		 char *c = Strstr(Classprefix,"<");
		 if (c) {
		   if (!Strstr(yyvsp[-4].str,"<")) {
		     yyvsp[-4].str = NewStringf("%s%s",yyvsp[-4].str,c);
		   }
		 }
	       }
		Setattr(yyval.node,"storage","virtual");
		Setattr(yyval.node,"name",NewStringf("~%s",yyvsp[-4].str));
		Setattr(yyval.node,"throws",yyvsp[0].dtype.throws);
		Setattr(yyval.node,"throw",yyvsp[0].dtype.throw);
		if (yyvsp[0].dtype.val) {
		  Setattr(yyval.node,"value","0");
		}
		if (Len(scanner_ccode)) {
		  Setattr(yyval.node,"code",Copy(scanner_ccode));
		}
		{
		  String *decl = NewString("");
		  SwigType_add_function(decl,yyvsp[-2].pl);
		  Setattr(yyval.node,"decl",decl);
		}

		add_symbols(yyval.node);
	      }
    break;

  case 184:
#line 3782 "parser.y"
    {
                 yyval.node = new_node("cdecl");
                 Setattr(yyval.node,"type",yyvsp[-5].type);
		 Setattr(yyval.node,"name",yyvsp[-6].str);

		 SwigType_add_function(yyvsp[-4].type,yyvsp[-2].pl);
		 if (yyvsp[0].dtype.qualifier) {
		   SwigType_push(yyvsp[-4].type,yyvsp[0].dtype.qualifier);
		 }
		 Setattr(yyval.node,"decl",yyvsp[-4].type);
		 Setattr(yyval.node,"parms",yyvsp[-2].pl);
		 Setattr(yyval.node,"conversion_operator","1");
		 add_symbols(yyval.node);
              }
    break;

  case 185:
#line 3796 "parser.y"
    {
		 SwigType *decl;
                 yyval.node = new_node("cdecl");
                 Setattr(yyval.node,"type",yyvsp[-5].type);
		 Setattr(yyval.node,"name",yyvsp[-6].str);
		 decl = NewString("");
		 SwigType_add_reference(decl);
		 SwigType_add_function(decl,yyvsp[-2].pl);
		 if (yyvsp[0].dtype.qualifier) {
		   SwigType_push(decl,yyvsp[0].dtype.qualifier);
		 }
		 Setattr(yyval.node,"decl",decl);
		 Setattr(yyval.node,"parms",yyvsp[-2].pl);
		 Setattr(yyval.node,"conversion_operator","1");
		 add_symbols(yyval.node);
	       }
    break;

  case 186:
#line 3813 "parser.y"
    {
		String *t = NewString("");
		yyval.node = new_node("cdecl");
		Setattr(yyval.node,"type",yyvsp[-4].type);
		Setattr(yyval.node,"name",yyvsp[-5].str);
		SwigType_add_function(t,yyvsp[-2].pl);
		if (yyvsp[0].dtype.qualifier) {
		  SwigType_push(t,yyvsp[0].dtype.qualifier);
		}
		Setattr(yyval.node,"decl",t);
		Setattr(yyval.node,"parms",yyvsp[-2].pl);
		Setattr(yyval.node,"conversion_operator","1");
		add_symbols(yyval.node);
              }
    break;

  case 187:
#line 3831 "parser.y"
    {
                 skip_balanced('{','}');
                 yyval.node = 0;
               }
    break;

  case 188:
#line 3838 "parser.y"
    { 
                yyval.node = new_node("access");
		Setattr(yyval.node,"kind","public");
                cplus_mode = CPLUS_PUBLIC;
              }
    break;

  case 189:
#line 3845 "parser.y"
    { 
                yyval.node = new_node("access");
                Setattr(yyval.node,"kind","private");
		cplus_mode = CPLUS_PRIVATE;
	      }
    break;

  case 190:
#line 3853 "parser.y"
    { 
		yyval.node = new_node("access");
		Setattr(yyval.node,"kind","protected");
		cplus_mode = CPLUS_PROTECTED;
	      }
    break;

  case 191:
#line 3876 "parser.y"
    { cparse_start_line = cparse_line; skip_balanced('{','}');
	      }
    break;

  case 192:
#line 3877 "parser.y"
    {
	        yyval.node = 0;
		if (cplus_mode == CPLUS_PUBLIC) {
		  if (yyvsp[-1].decl.id) {
		    if (strcmp(yyvsp[-5].id,"class") == 0) {
		      Swig_warning(WARN_PARSE_NESTED_CLASS, cparse_file, cparse_line, "Nested classes not currently supported (ignored).\n");
		      /* Generate some code for a new class */
		    } else {
		      Nested *n = (Nested *) malloc(sizeof(Nested));
		      n->code = NewString("");
		      Printv(n->code, "typedef ", yyvsp[-5].id, " ",
			     Char(scanner_ccode), " $classname_", yyvsp[-1].decl.id, ";\n", NIL);

		      n->name = Swig_copy_string(yyvsp[-1].decl.id);
		      n->line = cparse_start_line;
		      n->type = NewString("");
		      n->kind = yyvsp[-5].id;
		      SwigType_push(n->type, yyvsp[-1].decl.type);
		      n->next = 0;
		      add_nested(n);
		    }
		  } else {
		    Swig_warning(WARN_PARSE_NESTED_CLASS, cparse_file, cparse_line, "Nested %s not currently supported (ignored).\n", yyvsp[-5].id);
		  }
		}
	      }
    break;

  case 193:
#line 3904 "parser.y"
    { cparse_start_line = cparse_line; skip_balanced('{','}');
              }
    break;

  case 194:
#line 3905 "parser.y"
    {
	        yyval.node = 0;
		if (cplus_mode == CPLUS_PUBLIC) {
		  if (strcmp(yyvsp[-4].id,"class") == 0) {
		    Swig_warning(WARN_PARSE_NESTED_CLASS,cparse_file, cparse_line,"Nested class not currently supported (ignored)\n");
		    /* Generate some code for a new class */
		  } else if (yyvsp[-1].decl.id) {
		    /* Generate some code for a new class */
		    Nested *n = (Nested *) malloc(sizeof(Nested));
		    n->code = NewString("");
		    Printv(n->code, "typedef ", yyvsp[-4].id, " " ,
			    Char(scanner_ccode), " $classname_", yyvsp[-1].decl.id, ";\n",NIL);
		    n->name = Swig_copy_string(yyvsp[-1].decl.id);
		    n->line = cparse_start_line;
		    n->type = NewString("");
		    n->kind = yyvsp[-4].id;
		    SwigType_push(n->type,yyvsp[-1].decl.type);
		    n->next = 0;
		    add_nested(n);
		  } else {
		    Swig_warning(WARN_PARSE_NESTED_CLASS, cparse_file, cparse_line, "Nested %s not currently supported (ignored).\n", yyvsp[-4].id);
		  }
		}
	      }
    break;

  case 195:
#line 3934 "parser.y"
    { cparse_start_line = cparse_line; skip_balanced('{','}');
              }
    break;

  case 196:
#line 3935 "parser.y"
    {
	        yyval.node = 0;
		if (cplus_mode == CPLUS_PUBLIC) {
		  Swig_warning(WARN_PARSE_NESTED_CLASS,cparse_file, cparse_line,"Nested class not currently supported (ignored)\n");
		}
	      }
    break;

  case 197:
#line 3952 "parser.y"
    { yyval.decl = yyvsp[0].decl;}
    break;

  case 198:
#line 3953 "parser.y"
    { yyval.decl.id = 0; }
    break;

  case 199:
#line 3959 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 200:
#line 3962 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 201:
#line 3966 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 202:
#line 3969 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 203:
#line 3970 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 204:
#line 3971 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 205:
#line 3972 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 206:
#line 3973 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 207:
#line 3974 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 208:
#line 3975 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 209:
#line 3976 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 210:
#line 3979 "parser.y"
    {
	            Clear(scanner_ccode);
		    yyval.dtype.throws = yyvsp[-1].dtype.throws;
		    yyval.dtype.throw = yyvsp[-1].dtype.throw;
               }
    break;

  case 211:
#line 3984 "parser.y"
    { 
		    skip_balanced('{','}'); 
		    yyval.dtype.throws = yyvsp[-1].dtype.throws;
		    yyval.dtype.throw = yyvsp[-1].dtype.throw;
	       }
    break;

  case 212:
#line 3991 "parser.y"
    { 
                     Clear(scanner_ccode);
                     yyval.dtype.val = 0;
                     yyval.dtype.qualifier = yyvsp[-1].dtype.qualifier;
                     yyval.dtype.bitfield = 0;
                     yyval.dtype.throws = yyvsp[-1].dtype.throws;
                     yyval.dtype.throw = yyvsp[-1].dtype.throw;
                }
    break;

  case 213:
#line 3999 "parser.y"
    { 
                     Clear(scanner_ccode);
                     yyval.dtype.val = yyvsp[-1].dtype.val;
                     yyval.dtype.qualifier = yyvsp[-3].dtype.qualifier;
                     yyval.dtype.bitfield = 0;
                     yyval.dtype.throws = yyvsp[-3].dtype.throws; 
                     yyval.dtype.throw = yyvsp[-3].dtype.throw; 
               }
    break;

  case 214:
#line 4007 "parser.y"
    { 
                     skip_balanced('{','}');
                     yyval.dtype.val = 0;
                     yyval.dtype.qualifier = yyvsp[-1].dtype.qualifier;
                     yyval.dtype.bitfield = 0;
                     yyval.dtype.throws = yyvsp[-1].dtype.throws; 
                     yyval.dtype.throw = yyvsp[-1].dtype.throw; 
               }
    break;

  case 215:
#line 4018 "parser.y"
    { }
    break;

  case 216:
#line 4024 "parser.y"
    { yyval.id = "extern"; }
    break;

  case 217:
#line 4025 "parser.y"
    { 
                   if (strcmp(yyvsp[0].id,"C") == 0) {
		     yyval.id = "externc";
		   } else {
		     Swig_warning(WARN_PARSE_UNDEFINED_EXTERN,cparse_file, cparse_line,"Unrecognized extern type \"%s\".\n", yyvsp[0].id);
		     yyval.id = 0;
		   }
               }
    break;

  case 218:
#line 4033 "parser.y"
    { yyval.id = "static"; }
    break;

  case 219:
#line 4034 "parser.y"
    { yyval.id = "typedef"; }
    break;

  case 220:
#line 4035 "parser.y"
    { yyval.id = "virtual"; }
    break;

  case 221:
#line 4036 "parser.y"
    { yyval.id = "friend"; }
    break;

  case 222:
#line 4037 "parser.y"
    { yyval.id = 0; }
    break;

  case 223:
#line 4044 "parser.y"
    {
                 Parm *p;
		 yyval.pl = yyvsp[0].pl;
		 p = yyvsp[0].pl;
                 while (p) {
		   Replace(Getattr(p,"type"),"typename ", "", DOH_REPLACE_ANY);
		   p = nextSibling(p);
                 }
               }
    break;

  case 224:
#line 4055 "parser.y"
    {
		  if (1) { 
		    set_nextSibling(yyvsp[-1].p,yyvsp[0].pl);
		    yyval.pl = yyvsp[-1].p;
		  } else {
		    yyval.pl = yyvsp[0].pl;
		  }
		}
    break;

  case 225:
#line 4063 "parser.y"
    { yyval.pl = 0; }
    break;

  case 226:
#line 4066 "parser.y"
    {
                 set_nextSibling(yyvsp[-1].p,yyvsp[0].pl);
		 yyval.pl = yyvsp[-1].p;
                }
    break;

  case 227:
#line 4070 "parser.y"
    { yyval.pl = 0; }
    break;

  case 228:
#line 4074 "parser.y"
    {
                   SwigType_push(yyvsp[-1].type,yyvsp[0].decl.type);
		   yyval.p = NewParm(yyvsp[-1].type,yyvsp[0].decl.id);
		   Setfile(yyval.p,cparse_file);
		   Setline(yyval.p,cparse_line);
		   if (yyvsp[0].decl.defarg) {
		     Setattr(yyval.p,"value",yyvsp[0].decl.defarg);
		   }
		}
    break;

  case 229:
#line 4084 "parser.y"
    {
                  yyval.p = NewParm(NewStringf("template<class> %s %s", yyvsp[-1].id,yyvsp[0].str), 0);
		  Setfile(yyval.p,cparse_file);
		  Setline(yyval.p,cparse_line);
                }
    break;

  case 230:
#line 4089 "parser.y"
    {
		  SwigType *t = NewString("v(...)");
		  yyval.p = NewParm(t, 0);
		  Setfile(yyval.p,cparse_file);
		  Setline(yyval.p,cparse_line);
		}
    break;

  case 231:
#line 4097 "parser.y"
    {
                 Parm *p;
		 yyval.p = yyvsp[0].p;
		 p = yyvsp[0].p;
                 while (p) {
		   if (Getattr(p,"type")) {
		     Replace(Getattr(p,"type"),"typename ", "", DOH_REPLACE_ANY);
		   }
		   p = nextSibling(p);
                 }
               }
    break;

  case 232:
#line 4110 "parser.y"
    {
		  if (1) { 
		    set_nextSibling(yyvsp[-1].p,yyvsp[0].p);
		    yyval.p = yyvsp[-1].p;
		  } else {
		    yyval.p = yyvsp[0].p;
		  }
		}
    break;

  case 233:
#line 4118 "parser.y"
    { yyval.p = 0; }
    break;

  case 234:
#line 4121 "parser.y"
    {
                 set_nextSibling(yyvsp[-1].p,yyvsp[0].p);
		 yyval.p = yyvsp[-1].p;
                }
    break;

  case 235:
#line 4125 "parser.y"
    { yyval.p = 0; }
    break;

  case 236:
#line 4129 "parser.y"
    {
		  yyval.p = yyvsp[0].p;
		  {
		    /* We need to make a possible adjustment for integer parameters. */
		    SwigType *type;
		    Node     *n = 0;

		    while (!n) {
		      type = Getattr(yyvsp[0].p,"type");
		      n = Swig_symbol_clookup(type,0);     /* See if we can find a node that matches the typename */
		      if ((n) && (Strcmp(nodeType(n),"cdecl") == 0)) {
			SwigType *decl = Getattr(n,"decl");
			if (!SwigType_isfunction(decl)) {
			  String *value = Getattr(n,"value");
			  if (value) {
			    Setattr(yyvsp[0].p,"type",Copy(value));
			    n = 0;
			  }
			}
		      } else {
			break;
		      }
		    }
		  }
		  
               }
    break;

  case 237:
#line 4155 "parser.y"
    {
                  yyval.p = NewParm(0,0);
                  Setfile(yyval.p,cparse_file);
		  Setline(yyval.p,cparse_line);
		  Setattr(yyval.p,"value",yyvsp[0].dtype.val);
               }
    break;

  case 238:
#line 4161 "parser.y"
    {
                  yyval.p = NewParm(0,0);
                  Setfile(yyval.p,cparse_file);
		  Setline(yyval.p,cparse_line);
		  Setattr(yyval.p,"value",NewString(yyvsp[0].id));
               }
    break;

  case 239:
#line 4169 "parser.y"
    { 
                  yyval.dtype = yyvsp[0].dtype; 
		  if (yyvsp[0].dtype.type == T_ERROR) {
		    Swig_warning(WARN_PARSE_BAD_DEFAULT,cparse_file, cparse_line, "Can't set default argument (ignored)\n");
		    yyval.dtype.val = 0;
		    yyval.dtype.rawval = 0;
		    yyval.dtype.bitfield = 0;
		    yyval.dtype.throws = 0;
		    yyval.dtype.throw = 0;
		  }
               }
    break;

  case 240:
#line 4180 "parser.y"
    {
		 Node *n = Swig_symbol_clookup(yyvsp[0].decl.id,0);
		 if (n) {
		   String *q = Swig_symbol_qualified(n);
                   if (q) {
                     String *temp = NewStringf("%s::%s", q, Getattr(n,"name"));
                     yyval.dtype.val = NewStringf("&%s", SwigType_str(yyvsp[0].decl.type,temp));
                     Delete(q);
                     Delete(temp);
                   } else {
                     yyval.dtype.val = NewStringf("&%s", SwigType_str(yyvsp[0].decl.type,yyvsp[0].decl.id));
                   }
		 } else {
		   yyval.dtype.val = NewStringf("&%s",SwigType_str(yyvsp[0].decl.type,yyvsp[0].decl.id));
		 }
		 yyval.dtype.rawval = 0;
		 yyval.dtype.type = T_USER;
		 yyval.dtype.bitfield = 0;
		 yyval.dtype.throws = 0;
		 yyval.dtype.throw = 0;
	       }
    break;

  case 241:
#line 4201 "parser.y"
    {
		 skip_balanced('{','}');
		 yyval.dtype.val = 0;
		 yyval.dtype.rawval = 0;
                 yyval.dtype.type = T_INT;
		 yyval.dtype.bitfield = 0;
		 yyval.dtype.throws = 0;
		 yyval.dtype.throw = 0;
	       }
    break;

  case 242:
#line 4210 "parser.y"
    { 
		 yyval.dtype.val = 0;
		 yyval.dtype.rawval = 0;
		 yyval.dtype.type = 0;
		 yyval.dtype.bitfield = yyvsp[0].dtype.val;
		 yyval.dtype.throws = 0;
		 yyval.dtype.throw = 0;
	       }
    break;

  case 243:
#line 4218 "parser.y"
    {
                 yyval.dtype.val = 0;
                 yyval.dtype.rawval = 0;
                 yyval.dtype.type = T_INT;
		 yyval.dtype.bitfield = 0;
		 yyval.dtype.throws = 0;
		 yyval.dtype.throw = 0;
               }
    break;

  case 244:
#line 4228 "parser.y"
    {
                 yyval.decl = yyvsp[-1].decl;
		 yyval.decl.defarg = yyvsp[0].dtype.rawval ? yyvsp[0].dtype.rawval : yyvsp[0].dtype.val;
            }
    break;

  case 245:
#line 4232 "parser.y"
    {
              yyval.decl = yyvsp[-1].decl;
	      yyval.decl.defarg = yyvsp[0].dtype.rawval ? yyvsp[0].dtype.rawval : yyvsp[0].dtype.val;
            }
    break;

  case 246:
#line 4236 "parser.y"
    {
   	      yyval.decl.type = 0;
              yyval.decl.id = 0;
	      yyval.decl.defarg = yyvsp[0].dtype.rawval ? yyvsp[0].dtype.rawval : yyvsp[0].dtype.val;
            }
    break;

  case 247:
#line 4243 "parser.y"
    {
                 yyval.decl = yyvsp[0].decl;
		 if (SwigType_isfunction(yyvsp[0].decl.type)) {
		   Delete(SwigType_pop_function(yyvsp[0].decl.type));
		 } else if (SwigType_isarray(yyvsp[0].decl.type)) {
		   SwigType *ta = SwigType_pop_arrays(yyvsp[0].decl.type);
		   if (SwigType_isfunction(yyvsp[0].decl.type)) {
		     Delete(SwigType_pop_function(yyvsp[0].decl.type));
		   } else {
		     yyval.decl.parms = 0;
		   }
		   SwigType_push(yyvsp[0].decl.type,ta);
		   Delete(ta);
		 } else {
		   yyval.decl.parms = 0;
		 }
            }
    break;

  case 248:
#line 4260 "parser.y"
    {
              yyval.decl = yyvsp[0].decl;
	      if (SwigType_isfunction(yyvsp[0].decl.type)) {
		Delete(SwigType_pop_function(yyvsp[0].decl.type));
	      } else if (SwigType_isarray(yyvsp[0].decl.type)) {
		SwigType *ta = SwigType_pop_arrays(yyvsp[0].decl.type);
		if (SwigType_isfunction(yyvsp[0].decl.type)) {
		  Delete(SwigType_pop_function(yyvsp[0].decl.type));
		} else {
		  yyval.decl.parms = 0;
		}
		SwigType_push(yyvsp[0].decl.type,ta);
		Delete(ta);
	      } else {
		yyval.decl.parms = 0;
	      }
            }
    break;

  case 249:
#line 4277 "parser.y"
    {
   	      yyval.decl.type = 0;
              yyval.decl.id = 0;
	      yyval.decl.parms = 0;
	      }
    break;

  case 250:
#line 4285 "parser.y"
    {
              yyval.decl = yyvsp[0].decl;
	      if (yyval.decl.type) {
		SwigType_push(yyvsp[-1].type,yyval.decl.type);
		Delete(yyval.decl.type);
	      }
	      yyval.decl.type = yyvsp[-1].type;
           }
    break;

  case 251:
#line 4293 "parser.y"
    {
              yyval.decl = yyvsp[0].decl;
	      SwigType_add_reference(yyvsp[-2].type);
              if (yyval.decl.type) {
		SwigType_push(yyvsp[-2].type,yyval.decl.type);
		Delete(yyval.decl.type);
	      }
	      yyval.decl.type = yyvsp[-2].type;
           }
    break;

  case 252:
#line 4302 "parser.y"
    {
              yyval.decl = yyvsp[0].decl;
	      if (!yyval.decl.type) yyval.decl.type = NewString("");
           }
    break;

  case 253:
#line 4306 "parser.y"
    { 
	     yyval.decl = yyvsp[0].decl;
	     yyval.decl.type = NewString("");
	     SwigType_add_reference(yyval.decl.type);
	     if (yyvsp[0].decl.type) {
	       SwigType_push(yyval.decl.type,yyvsp[0].decl.type);
	       Delete(yyvsp[0].decl.type);
	     }
           }
    break;

  case 254:
#line 4315 "parser.y"
    { 
	     SwigType *t = NewString("");

	     yyval.decl = yyvsp[0].decl;
	     SwigType_add_memberpointer(t,yyvsp[-2].str);
	     if (yyval.decl.type) {
	       SwigType_push(t,yyval.decl.type);
	       Delete(yyval.decl.type);
	     }
	     yyval.decl.type = t;
	     }
    break;

  case 255:
#line 4326 "parser.y"
    { 
	     SwigType *t = NewString("");
	     yyval.decl = yyvsp[0].decl;
	     SwigType_add_memberpointer(t,yyvsp[-2].str);
	     SwigType_push(yyvsp[-3].type,t);
	     if (yyval.decl.type) {
	       SwigType_push(yyvsp[-3].type,yyval.decl.type);
	       Delete(yyval.decl.type);
	     }
	     yyval.decl.type = yyvsp[-3].type;
	     Delete(t);
	   }
    break;

  case 256:
#line 4338 "parser.y"
    { 
	     yyval.decl = yyvsp[0].decl;
	     SwigType_add_memberpointer(yyvsp[-4].type,yyvsp[-3].str);
	     SwigType_add_reference(yyvsp[-4].type);
	     if (yyval.decl.type) {
	       SwigType_push(yyvsp[-4].type,yyval.decl.type);
	       Delete(yyval.decl.type);
	     }
	     yyval.decl.type = yyvsp[-4].type;
	   }
    break;

  case 257:
#line 4348 "parser.y"
    { 
	     SwigType *t = NewString("");
	     yyval.decl = yyvsp[0].decl;
	     SwigType_add_memberpointer(t,yyvsp[-3].str);
	     SwigType_add_reference(t);
	     if (yyval.decl.type) {
	       SwigType_push(t,yyval.decl.type);
	       Delete(yyval.decl.type);
	     } 
	     yyval.decl.type = t;
	   }
    break;

  case 258:
#line 4361 "parser.y"
    {
                /* Note: This is non-standard C.  Template declarator is allowed to follow an identifier */
                 yyval.decl.id = Char(yyvsp[0].str);
		 yyval.decl.type = 0;
		 yyval.decl.parms = 0;
		 yyval.decl.have_parms = 0;
                  }
    break;

  case 259:
#line 4368 "parser.y"
    {
                  yyval.decl.id = Char(NewStringf("~%s",yyvsp[0].str));
                  yyval.decl.type = 0;
                  yyval.decl.parms = 0;
                  yyval.decl.have_parms = 0;
                  }
    break;

  case 260:
#line 4376 "parser.y"
    {
                  yyval.decl.id = Char(yyvsp[-1].str);
                  yyval.decl.type = 0;
                  yyval.decl.parms = 0;
                  yyval.decl.have_parms = 0;
                  }
    break;

  case 261:
#line 4392 "parser.y"
    {
		    yyval.decl = yyvsp[-1].decl;
		    if (yyval.decl.type) {
		      SwigType_push(yyvsp[-2].type,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = yyvsp[-2].type;
                  }
    break;

  case 262:
#line 4400 "parser.y"
    {
		    SwigType *t;
		    yyval.decl = yyvsp[-1].decl;
		    t = NewString("");
		    SwigType_add_memberpointer(t,yyvsp[-3].str);
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
		    }
    break;

  case 263:
#line 4411 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-2].decl;
		    t = NewString("");
		    SwigType_add_array(t,(char*)"");
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 264:
#line 4422 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-3].decl;
		    t = NewString("");
		    SwigType_add_array(t,yyvsp[-1].dtype.val);
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 265:
#line 4433 "parser.y"
    {
		    SwigType *t;
                    yyval.decl = yyvsp[-3].decl;
		    t = NewString("");
		    SwigType_add_function(t,yyvsp[-1].pl);
		    if (!yyval.decl.have_parms) {
		      yyval.decl.parms = yyvsp[-1].pl;
		      yyval.decl.have_parms = 1;
		    }
		    if (!yyval.decl.type) {
		      yyval.decl.type = t;
		    } else {
		      SwigType_push(t, yyval.decl.type);
		      Delete(yyval.decl.type);
		      yyval.decl.type = t;
		    }
		  }
    break;

  case 266:
#line 4452 "parser.y"
    {
                /* Note: This is non-standard C.  Template declarator is allowed to follow an identifier */
                 yyval.decl.id = Char(yyvsp[0].str);
		 yyval.decl.type = 0;
		 yyval.decl.parms = 0;
		 yyval.decl.have_parms = 0;
                  }
    break;

  case 267:
#line 4460 "parser.y"
    {
                  yyval.decl.id = Char(NewStringf("~%s",yyvsp[0].str));
                  yyval.decl.type = 0;
                  yyval.decl.parms = 0;
                  yyval.decl.have_parms = 0;
                  }
    break;

  case 268:
#line 4477 "parser.y"
    {
		    yyval.decl = yyvsp[-1].decl;
		    if (yyval.decl.type) {
		      SwigType_push(yyvsp[-2].type,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = yyvsp[-2].type;
                  }
    break;

  case 269:
#line 4485 "parser.y"
    {
                    yyval.decl = yyvsp[-1].decl;
		    if (!yyval.decl.type) {
		      yyval.decl.type = NewString("");
		    }
		    SwigType_add_reference(yyval.decl.type);
                  }
    break;

  case 270:
#line 4492 "parser.y"
    {
		    SwigType *t;
		    yyval.decl = yyvsp[-1].decl;
		    t = NewString("");
		    SwigType_add_memberpointer(t,yyvsp[-3].str);
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
		    }
    break;

  case 271:
#line 4503 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-2].decl;
		    t = NewString("");
		    SwigType_add_array(t,(char*)"");
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 272:
#line 4514 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-3].decl;
		    t = NewString("");
		    SwigType_add_array(t,yyvsp[-1].dtype.val);
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 273:
#line 4525 "parser.y"
    {
		    SwigType *t;
                    yyval.decl = yyvsp[-3].decl;
		    t = NewString("");
		    SwigType_add_function(t,yyvsp[-1].pl);
		    if (!yyval.decl.have_parms) {
		      yyval.decl.parms = yyvsp[-1].pl;
		      yyval.decl.have_parms = 1;
		    }
		    if (!yyval.decl.type) {
		      yyval.decl.type = t;
		    } else {
		      SwigType_push(t, yyval.decl.type);
		      Delete(yyval.decl.type);
		      yyval.decl.type = t;
		    }
		  }
    break;

  case 274:
#line 4544 "parser.y"
    {
		    yyval.decl.type = yyvsp[0].type;
                    yyval.decl.id = 0;
		    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
                  }
    break;

  case 275:
#line 4550 "parser.y"
    { 
                     yyval.decl = yyvsp[0].decl;
                     SwigType_push(yyvsp[-1].type,yyvsp[0].decl.type);
		     yyval.decl.type = yyvsp[-1].type;
		     Delete(yyvsp[0].decl.type);
                  }
    break;

  case 276:
#line 4556 "parser.y"
    {
		    yyval.decl.type = yyvsp[-1].type;
		    SwigType_add_reference(yyval.decl.type);
		    yyval.decl.id = 0;
		    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
		  }
    break;

  case 277:
#line 4563 "parser.y"
    {
		    yyval.decl = yyvsp[0].decl;
		    SwigType_add_reference(yyvsp[-2].type);
		    if (yyval.decl.type) {
		      SwigType_push(yyvsp[-2].type,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = yyvsp[-2].type;
                  }
    break;

  case 278:
#line 4572 "parser.y"
    {
		    yyval.decl = yyvsp[0].decl;
                  }
    break;

  case 279:
#line 4575 "parser.y"
    {
		    yyval.decl = yyvsp[0].decl;
		    yyval.decl.type = NewString("");
		    SwigType_add_reference(yyval.decl.type);
		    if (yyvsp[0].decl.type) {
		      SwigType_push(yyval.decl.type,yyvsp[0].decl.type);
		      Delete(yyvsp[0].decl.type);
		    }
                  }
    break;

  case 280:
#line 4584 "parser.y"
    { 
                    yyval.decl.id = 0;
                    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
                    yyval.decl.type = NewString("");
		    SwigType_add_reference(yyval.decl.type);
                  }
    break;

  case 281:
#line 4591 "parser.y"
    { 
		    yyval.decl.type = NewString("");
                    SwigType_add_memberpointer(yyval.decl.type,yyvsp[-1].str);
                    yyval.decl.id = 0;
                    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
      	          }
    break;

  case 282:
#line 4598 "parser.y"
    { 
		    SwigType *t = NewString("");
                    yyval.decl.type = yyvsp[-2].type;
		    yyval.decl.id = 0;
		    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
		    SwigType_add_memberpointer(t,yyvsp[-1].str);
		    SwigType_push(yyval.decl.type,t);
		    Delete(t);
                  }
    break;

  case 283:
#line 4608 "parser.y"
    { 
		    yyval.decl = yyvsp[0].decl;
		    SwigType_add_memberpointer(yyvsp[-3].type,yyvsp[-2].str);
		    if (yyval.decl.type) {
		      SwigType_push(yyvsp[-3].type,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = yyvsp[-3].type;
                  }
    break;

  case 284:
#line 4619 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-2].decl;
		    t = NewString("");
		    SwigType_add_array(t,(char*)"");
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 285:
#line 4630 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-3].decl;
		    t = NewString("");
		    SwigType_add_array(t,yyvsp[-1].dtype.val);
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 286:
#line 4641 "parser.y"
    { 
		    yyval.decl.type = NewString("");
		    yyval.decl.id = 0;
		    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
		    SwigType_add_array(yyval.decl.type,(char*)"");
                  }
    break;

  case 287:
#line 4648 "parser.y"
    { 
		    yyval.decl.type = NewString("");
		    yyval.decl.id = 0;
		    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
		    SwigType_add_array(yyval.decl.type,yyvsp[-1].dtype.val);
		  }
    break;

  case 288:
#line 4655 "parser.y"
    {
                    yyval.decl = yyvsp[-1].decl;
		  }
    break;

  case 289:
#line 4658 "parser.y"
    {
		    SwigType *t;
                    yyval.decl = yyvsp[-3].decl;
		    t = NewString("");
                    SwigType_add_function(t,yyvsp[-1].pl);
		    if (!yyval.decl.type) {
		      yyval.decl.type = t;
		    } else {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		      yyval.decl.type = t;
		    }
		    if (!yyval.decl.have_parms) {
		      yyval.decl.parms = yyvsp[-1].pl;
		      yyval.decl.have_parms = 1;
		    }
		  }
    break;

  case 290:
#line 4675 "parser.y"
    {
                    yyval.decl.type = NewString("");
                    SwigType_add_function(yyval.decl.type,yyvsp[-1].pl);
		    yyval.decl.parms = yyvsp[-1].pl;
		    yyval.decl.have_parms = 1;
		    yyval.decl.id = 0;
                  }
    break;

  case 291:
#line 4685 "parser.y"
    { 
               yyval.type = NewString("");
               SwigType_add_pointer(yyval.type);
	       SwigType_push(yyval.type,yyvsp[-1].str);
	       SwigType_push(yyval.type,yyvsp[0].type);
	       Delete(yyvsp[0].type);
           }
    break;

  case 292:
#line 4692 "parser.y"
    {
	     yyval.type = NewString("");
	     SwigType_add_pointer(yyval.type);
	     SwigType_push(yyval.type,yyvsp[0].type);
	     Delete(yyvsp[0].type);
	     }
    break;

  case 293:
#line 4698 "parser.y"
    { 
	     	yyval.type = NewString("");	
		SwigType_add_pointer(yyval.type);
	        SwigType_push(yyval.type,yyvsp[0].str);
           }
    break;

  case 294:
#line 4703 "parser.y"
    {
	      yyval.type = NewString("");
	      SwigType_add_pointer(yyval.type);
           }
    break;

  case 295:
#line 4709 "parser.y"
    { 
	          yyval.str = NewString("");
	          if (yyvsp[0].id) SwigType_add_qualifier(yyval.str,yyvsp[0].id);
               }
    break;

  case 296:
#line 4713 "parser.y"
    { 
		  yyval.str = yyvsp[0].str; 
	          if (yyvsp[-1].id) SwigType_add_qualifier(yyval.str,yyvsp[-1].id);
               }
    break;

  case 297:
#line 4719 "parser.y"
    { yyval.id = "const"; }
    break;

  case 298:
#line 4720 "parser.y"
    { yyval.id = "volatile"; }
    break;

  case 299:
#line 4721 "parser.y"
    { yyval.id = 0; }
    break;

  case 300:
#line 4727 "parser.y"
    {
                   yyval.type = yyvsp[0].type;
                   Replace(yyval.type,"typename ","", DOH_REPLACE_ANY);
                }
    break;

  case 301:
#line 4733 "parser.y"
    {
                   yyval.type = yyvsp[0].type;
	           SwigType_push(yyval.type,yyvsp[-1].str);
               }
    break;

  case 302:
#line 4737 "parser.y"
    { yyval.type = yyvsp[0].type; }
    break;

  case 303:
#line 4740 "parser.y"
    { yyval.type = yyvsp[0].type;
                  /* Printf(stdout,"primitive = '%s'\n", $$);*/
                }
    break;

  case 304:
#line 4743 "parser.y"
    { yyval.type = yyvsp[0].type; }
    break;

  case 305:
#line 4744 "parser.y"
    { yyval.type = yyvsp[0].type; }
    break;

  case 306:
#line 4745 "parser.y"
    { yyval.type = NewStringf("%s%s",yyvsp[-1].type,yyvsp[0].id); }
    break;

  case 307:
#line 4746 "parser.y"
    { yyval.type = NewStringf("enum %s", yyvsp[0].str); }
    break;

  case 308:
#line 4747 "parser.y"
    { yyval.type = yyvsp[0].type; }
    break;

  case 309:
#line 4748 "parser.y"
    {
		  yyval.type = yyvsp[-1].type;
	          SwigType_push(yyval.type,yyvsp[0].str);
     	       }
    break;

  case 310:
#line 4753 "parser.y"
    {
		  yyval.type = yyvsp[0].str;
               }
    break;

  case 311:
#line 4756 "parser.y"
    { 
		 yyval.type = NewStringf("%s %s", yyvsp[-1].id, yyvsp[0].str);
               }
    break;

  case 312:
#line 4761 "parser.y"
    {
		 if (!yyvsp[0].ptype.type) yyvsp[0].ptype.type = NewString("int");
		 if (yyvsp[0].ptype.us) {
		   yyval.type = NewStringf("%s %s", yyvsp[0].ptype.us, yyvsp[0].ptype.type);
		   Delete(yyvsp[0].ptype.us);
                   Delete(yyvsp[0].ptype.type);
		 } else {
                   yyval.type = yyvsp[0].ptype.type;
		 }
		 if (Cmp(yyval.type,"signed int") == 0) {
		   Delete(yyval.type);
		   yyval.type = NewString("int");
                 } else if (Cmp(yyval.type,"signed long") == 0) {
		   Delete(yyval.type);
                   yyval.type = NewString("long");
                 } else if (Cmp(yyval.type,"signed short") == 0) {
		   Delete(yyval.type);
		   yyval.type = NewString("short");
		 } else if (Cmp(yyval.type,"signed long long") == 0) {
		   Delete(yyval.type);
		   yyval.type = NewString("long long");
		 }
               }
    break;

  case 313:
#line 4786 "parser.y"
    { 
                 yyval.ptype = yyvsp[0].ptype;
               }
    break;

  case 314:
#line 4789 "parser.y"
    {
                    if (yyvsp[-1].ptype.us && yyvsp[0].ptype.us) {
		      Swig_error(cparse_file, cparse_line, "Extra %s specifier.\n", yyvsp[0].ptype.us);
		    }
                    yyval.ptype = yyvsp[0].ptype;
                    if (yyvsp[-1].ptype.us) yyval.ptype.us = yyvsp[-1].ptype.us;
		    if (yyvsp[-1].ptype.type) {
		      if (!yyvsp[0].ptype.type) yyval.ptype.type = yyvsp[-1].ptype.type;
		      else {
			int err = 0;
			if ((Cmp(yyvsp[-1].ptype.type,"long") == 0)) {
			  if ((Cmp(yyvsp[0].ptype.type,"long") == 0) || (Strncmp(yyvsp[0].ptype.type,"double",6) == 0)) {
			    yyval.ptype.type = NewStringf("long %s", yyvsp[0].ptype.type);
			  } else if (Cmp(yyvsp[0].ptype.type,"int") == 0) {
			    yyval.ptype.type = yyvsp[-1].ptype.type;
			  } else {
			    err = 1;
			  }
			} else if ((Cmp(yyvsp[-1].ptype.type,"short")) == 0) {
			  if (Cmp(yyvsp[0].ptype.type,"int") == 0) {
			    yyval.ptype.type = yyvsp[-1].ptype.type;
			  } else {
			    err = 1;
			  }
			} else if (Cmp(yyvsp[-1].ptype.type,"int") == 0) {
			  yyval.ptype.type = yyvsp[0].ptype.type;
			} else if (Cmp(yyvsp[-1].ptype.type,"double") == 0) {
			  if (Cmp(yyvsp[0].ptype.type,"long") == 0) {
			    yyval.ptype.type = NewString("long double");
			  } else if (Cmp(yyvsp[0].ptype.type,"complex") == 0) {
			    yyval.ptype.type = NewString("double complex");
			  } else {
			    err = 1;
			  }
			} else if (Cmp(yyvsp[-1].ptype.type,"float") == 0) {
			  if (Cmp(yyvsp[0].ptype.type,"complex") == 0) {
			    yyval.ptype.type = NewString("float complex");
			  } else {
			    err = 1;
			  }
			} else if (Cmp(yyvsp[-1].ptype.type,"complex") == 0) {
			  yyval.ptype.type = NewStringf("%s complex", yyvsp[0].ptype.type);
			} else {
			  err = 1;
			}
			if (err) {
			  Swig_error(cparse_file, cparse_line, "Extra %s specifier.\n", yyvsp[-1].ptype.type);
			}
		      }
		    }
               }
    break;

  case 315:
#line 4843 "parser.y"
    { 
		    yyval.ptype.type = NewString("int");
                    yyval.ptype.us = 0;
               }
    break;

  case 316:
#line 4847 "parser.y"
    { 
                    yyval.ptype.type = NewString("short");
                    yyval.ptype.us = 0;
                }
    break;

  case 317:
#line 4851 "parser.y"
    { 
                    yyval.ptype.type = NewString("long");
                    yyval.ptype.us = 0;
                }
    break;

  case 318:
#line 4855 "parser.y"
    { 
                    yyval.ptype.type = NewString("char");
                    yyval.ptype.us = 0;
                }
    break;

  case 319:
#line 4859 "parser.y"
    { 
                    yyval.ptype.type = NewString("wchar_t");
                    yyval.ptype.us = 0;
                }
    break;

  case 320:
#line 4863 "parser.y"
    { 
                    yyval.ptype.type = NewString("float");
                    yyval.ptype.us = 0;
                }
    break;

  case 321:
#line 4867 "parser.y"
    { 
                    yyval.ptype.type = NewString("double");
                    yyval.ptype.us = 0;
                }
    break;

  case 322:
#line 4871 "parser.y"
    { 
                    yyval.ptype.us = NewString("signed");
                    yyval.ptype.type = 0;
                }
    break;

  case 323:
#line 4875 "parser.y"
    { 
                    yyval.ptype.us = NewString("unsigned");
                    yyval.ptype.type = 0;
                }
    break;

  case 324:
#line 4879 "parser.y"
    { 
                    yyval.ptype.type = NewString("complex");
                    yyval.ptype.us = 0;
                }
    break;

  case 325:
#line 4885 "parser.y"
    { /* scanner_check_typedef(); */ }
    break;

  case 326:
#line 4885 "parser.y"
    {
                   yyval.dtype = yyvsp[0].dtype;
		   if (yyval.dtype.type == T_STRING) {
		     yyval.dtype.rawval = NewStringf("\"%(escape)s\"",yyval.dtype.val);
		   } else {
		     yyval.dtype.rawval = 0;
		   }
		   yyval.dtype.bitfield = 0;
		   yyval.dtype.throws = 0;
		   yyval.dtype.throw = 0;
		   scanner_ignore_typedef();
                }
    break;

  case 327:
#line 4906 "parser.y"
    {
                   yyval.dtype.val = NewString(yyvsp[0].str);
		   /*		   $$.rawval = NewStringf("\'%(escape)s\'",$$.val); */
		   /*		   Printf(stdout,"rawval = '%s'\n", $$.rawval); */
		   if (Len(yyval.dtype.val)) {
		     yyval.dtype.rawval = NewStringf("\'%(escape)s\'", yyval.dtype.val);
		   } else {
		     yyval.dtype.rawval = NewString("\'\\0'");
		   }
		   yyval.dtype.type = T_CHAR;
		   yyval.dtype.bitfield = 0;
		   yyval.dtype.throws = 0;
		   yyval.dtype.throw = 0;
		 }
    break;

  case 328:
#line 4924 "parser.y"
    { yyval.id = yyvsp[0].id; }
    break;

  case 329:
#line 4925 "parser.y"
    { yyval.id = (char *) 0;}
    break;

  case 330:
#line 4928 "parser.y"
    { 

                  /* Ignore if there is a trailing comma in the enum list */
                  if (yyvsp[0].node) {
                    Node *leftSibling = Getattr(yyvsp[-2].node,"_last");
                    if (!leftSibling) {
                      leftSibling=yyvsp[-2].node;
                    }
                    set_nextSibling(leftSibling,yyvsp[0].node);
                    Setattr(yyvsp[-2].node,"_last",yyvsp[0].node);
                  }
		  yyval.node = yyvsp[-2].node;
               }
    break;

  case 331:
#line 4941 "parser.y"
    { 
                   yyval.node = yyvsp[0].node; 
                   if (yyvsp[0].node) {
                     Setattr(yyvsp[0].node,"_last",yyvsp[0].node);
                   }
               }
    break;

  case 332:
#line 4949 "parser.y"
    {
		   yyval.node = new_node("enumitem");
		   Setattr(yyval.node,"name",yyvsp[0].id);
		   Setattr(yyval.node,"type",NewSwigType(T_INT));
		   SetFlag(yyval.node,"feature:immutable");
		 }
    break;

  case 333:
#line 4955 "parser.y"
    {
		   yyval.node = new_node("enumitem");
		   Setattr(yyval.node,"name",yyvsp[-2].id);
		   Setattr(yyval.node,"enumvalue", yyvsp[0].dtype.val);
	           if (yyvsp[0].dtype.type == T_CHAR) {
		     Setattr(yyval.node,"value",yyvsp[0].dtype.val);
		     Setattr(yyval.node,"type",NewSwigType(T_CHAR));
		   } else {
		     Setattr(yyval.node,"value",yyvsp[-2].id);
		     Setattr(yyval.node,"type",NewSwigType(T_INT));
		   }
		   SetFlag(yyval.node,"feature:immutable");
                 }
    break;

  case 334:
#line 4968 "parser.y"
    { yyval.node = 0; }
    break;

  case 335:
#line 4971 "parser.y"
    {
                   yyval.dtype = yyvsp[0].dtype;
		   if ((yyval.dtype.type != T_INT) && (yyval.dtype.type != T_UINT) &&
		       (yyval.dtype.type != T_LONG) && (yyval.dtype.type != T_ULONG) &&
		       (yyval.dtype.type != T_SHORT) && (yyval.dtype.type != T_USHORT) &&
		       (yyval.dtype.type != T_SCHAR) && (yyval.dtype.type != T_UCHAR)) {
		     Swig_error(cparse_file,cparse_line,"Type error. Expecting an int\n");
		   }
                }
    break;

  case 336:
#line 4980 "parser.y"
    {
                   yyval.dtype.val  = NewString(yyvsp[0].str);
		   yyval.dtype.type = T_INT;
		 }
    break;

  case 337:
#line 4991 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 338:
#line 4992 "parser.y"
    { 
		    yyval.dtype.val = NewString(yyvsp[0].id); 
                    yyval.dtype.type = T_STRING; 
               }
    break;

  case 339:
#line 4996 "parser.y"
    {
  		  SwigType_push(yyvsp[-2].type,yyvsp[-1].decl.type);
		  yyval.dtype.val = NewStringf("sizeof(%s)",SwigType_str(yyvsp[-2].type,0));
		  yyval.dtype.type = T_INT;
               }
    break;

  case 340:
#line 5001 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 341:
#line 5002 "parser.y"
    {
		 Node *n;
		 yyval.dtype.val = yyvsp[0].type;
		 yyval.dtype.type = T_INT;
		 /* Check if value is in scope */
		 n = Swig_symbol_clookup(yyvsp[0].type,0);
		 if (n) {
                   /* A band-aid for enum values used in expressions. */
                   if (Strcmp(nodeType(n),"enumitem") == 0) {
                     String *q = Swig_symbol_qualified(n);
                     if (q) {
                       yyval.dtype.val = NewStringf("%s::%s", q, Getattr(n,"name"));
                       Delete(q);
                     }
                   }
		 }
               }
    break;

  case 342:
#line 5021 "parser.y"
    {
   	            yyval.dtype.val = NewStringf("(%s)",yyvsp[-1].dtype.val);
		    yyval.dtype.type = yyvsp[-1].dtype.type;
   	       }
    break;

  case 343:
#line 5028 "parser.y"
    {
                 yyval.dtype = yyvsp[0].dtype;
		 if (yyvsp[0].dtype.type != T_STRING) {
		   yyval.dtype.val = NewStringf("(%s) %s", SwigType_str(yyvsp[-2].dtype.val,0), yyvsp[0].dtype.val);
		 }
 	       }
    break;

  case 344:
#line 5034 "parser.y"
    {
                 yyval.dtype = yyvsp[0].dtype;
		 if (yyvsp[0].dtype.type != T_STRING) {
		   SwigType_push(yyvsp[-3].dtype.val,yyvsp[-2].type);
		   yyval.dtype.val = NewStringf("(%s) %s", SwigType_str(yyvsp[-3].dtype.val,0), yyvsp[0].dtype.val);
		 }
 	       }
    break;

  case 345:
#line 5041 "parser.y"
    {
                 yyval.dtype = yyvsp[0].dtype;
		 if (yyvsp[0].dtype.type != T_STRING) {
		   SwigType_add_reference(yyvsp[-3].dtype.val);
		   yyval.dtype.val = NewStringf("(%s) %s", SwigType_str(yyvsp[-3].dtype.val,0), yyvsp[0].dtype.val);
		 }
 	       }
    break;

  case 346:
#line 5048 "parser.y"
    {
                 yyval.dtype = yyvsp[0].dtype;
		 if (yyvsp[0].dtype.type != T_STRING) {
		   SwigType_push(yyvsp[-4].dtype.val,yyvsp[-3].type);
		   SwigType_add_reference(yyvsp[-4].dtype.val);
		   yyval.dtype.val = NewStringf("(%s) %s", SwigType_str(yyvsp[-4].dtype.val,0), yyvsp[0].dtype.val);
		 }
 	       }
    break;

  case 347:
#line 5058 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 348:
#line 5059 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 349:
#line 5060 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 350:
#line 5061 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 351:
#line 5062 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 352:
#line 5063 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 353:
#line 5064 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 354:
#line 5067 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s+%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 355:
#line 5071 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s-%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 356:
#line 5075 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s*%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 357:
#line 5079 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s/%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 358:
#line 5083 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s&%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 359:
#line 5087 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s|%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 360:
#line 5091 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s^%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 361:
#line 5095 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s<<%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 362:
#line 5099 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s>>%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 363:
#line 5103 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s&&%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = T_INT;
	       }
    break;

  case 364:
#line 5107 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s||%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = T_INT;
	       }
    break;

  case 365:
#line 5111 "parser.y"
    {
		 yyval.dtype.val = NewStringf("-%s",yyvsp[0].dtype.val);
		 yyval.dtype.type = yyvsp[0].dtype.type;
	       }
    break;

  case 366:
#line 5115 "parser.y"
    {
                 yyval.dtype.val = NewStringf("+%s",yyvsp[0].dtype.val);
		 yyval.dtype.type = yyvsp[0].dtype.type;
  	       }
    break;

  case 367:
#line 5119 "parser.y"
    {
		 yyval.dtype.val = NewStringf("~%s",yyvsp[0].dtype.val);
		 yyval.dtype.type = yyvsp[0].dtype.type;
	       }
    break;

  case 368:
#line 5123 "parser.y"
    {
                 yyval.dtype.val = NewStringf("!%s",yyvsp[0].dtype.val);
		 yyval.dtype.type = T_INT;
	       }
    break;

  case 369:
#line 5127 "parser.y"
    {
                 skip_balanced('(',')');
		 yyvsp[-1].type = Swig_symbol_type_qualify(yyvsp[-1].type,0);
		 if (SwigType_istemplate(yyvsp[-1].type)) {
		   yyvsp[-1].type = SwigType_namestr(yyvsp[-1].type);
		 }
		 yyval.dtype.val = NewStringf("%s%s",yyvsp[-1].type,scanner_ccode);
		 Clear(scanner_ccode);
		 yyval.dtype.type = T_INT;
               }
    break;

  case 370:
#line 5139 "parser.y"
    {
		 yyval.bases = yyvsp[0].bases;
               }
    break;

  case 371:
#line 5144 "parser.y"
    { inherit_list = 1; }
    break;

  case 372:
#line 5144 "parser.y"
    { yyval.bases = yyvsp[0].bases; inherit_list = 0; }
    break;

  case 373:
#line 5145 "parser.y"
    { yyval.bases = 0; }
    break;

  case 374:
#line 5148 "parser.y"
    {
		   Hash *list = NewHash();
		   Node *base = yyvsp[0].node;
		   Node *name = Getattr(base,"name");
		   Setattr(list,"public",NewList());
		   Setattr(list,"protected",NewList());
		   Setattr(list,"private",NewList());
		   Append(Getattr(list,Getattr(base,"access")),name);
	           yyval.bases = list;
               }
    break;

  case 375:
#line 5159 "parser.y"
    {
		   Hash *list = yyvsp[-2].bases;
		   Node *base = yyvsp[0].node;
		   Node *name = Getattr(base,"name");
		   Append(Getattr(list,Getattr(base,"access")),name);
                   yyval.bases = list;
               }
    break;

  case 376:
#line 5168 "parser.y"
    {
		 yyval.node = NewHash();
		 Setfile(yyval.node,cparse_file);
		 Setline(yyval.node,cparse_line);
		 Setattr(yyval.node,"name",yyvsp[0].str);
                 if (last_cpptype && (Strcmp(last_cpptype,"struct") != 0)) {
		   Setattr(yyval.node,"access","private");
		   Swig_warning(WARN_PARSE_NO_ACCESS,cparse_file,cparse_line,
				"No access specifier given for base class %s (ignored).\n",yyvsp[0].str);
                 } else {
		   Setattr(yyval.node,"access","public");
		 }
               }
    break;

  case 377:
#line 5181 "parser.y"
    {
		 yyval.node = NewHash();
		 Setfile(yyval.node,cparse_file);
		 Setline(yyval.node,cparse_line);
		 Setattr(yyval.node,"name",yyvsp[0].str);
		 Setattr(yyval.node,"access",yyvsp[-2].id);
	         if (Strcmp(yyvsp[-2].id,"public") != 0) {
		   Swig_warning(WARN_PARSE_PRIVATE_INHERIT, cparse_file, 
				cparse_line,"%s inheritance ignored.\n", yyvsp[-2].id);
		 }
               }
    break;

  case 378:
#line 5194 "parser.y"
    { yyval.id = (char*)"public"; }
    break;

  case 379:
#line 5195 "parser.y"
    { yyval.id = (char*)"private"; }
    break;

  case 380:
#line 5196 "parser.y"
    { yyval.id = (char*)"protected"; }
    break;

  case 381:
#line 5200 "parser.y"
    { 
                   yyval.id = (char*)"class"; 
		   if (!inherit_list) last_cpptype = yyval.id;
               }
    break;

  case 382:
#line 5204 "parser.y"
    { 
                   yyval.id = (char*)"struct"; 
		   if (!inherit_list) last_cpptype = yyval.id;
               }
    break;

  case 383:
#line 5208 "parser.y"
    {
                   yyval.id = (char*)"union"; 
		   if (!inherit_list) last_cpptype = yyval.id;
               }
    break;

  case 384:
#line 5212 "parser.y"
    { 
                   yyval.id = (char *)"typename"; 
		   if (!inherit_list) last_cpptype = yyval.id;
               }
    break;

  case 387:
#line 5222 "parser.y"
    {
                    yyval.dtype.qualifier = yyvsp[0].str;
                    yyval.dtype.throws = 0;
                    yyval.dtype.throw = 0;
               }
    break;

  case 388:
#line 5227 "parser.y"
    {
                    yyval.dtype.qualifier = 0;
                    yyval.dtype.throws = yyvsp[-1].pl;
                    yyval.dtype.throw = NewString("1");
               }
    break;

  case 389:
#line 5232 "parser.y"
    {
                    yyval.dtype.qualifier = yyvsp[-4].str;
                    yyval.dtype.throws = yyvsp[-1].pl;
                    yyval.dtype.throw = NewString("1");
               }
    break;

  case 390:
#line 5237 "parser.y"
    { 
                    yyval.dtype.qualifier = 0; 
                    yyval.dtype.throws = 0;
                    yyval.dtype.throw = 0;
               }
    break;

  case 391:
#line 5244 "parser.y"
    { 
                    Clear(scanner_ccode); 
                    yyval.decl.have_parms = 0; 
                    yyval.decl.defarg = 0; 
		    yyval.decl.throws = yyvsp[-2].dtype.throws;
		    yyval.decl.throw = yyvsp[-2].dtype.throw;
               }
    break;

  case 392:
#line 5251 "parser.y"
    { 
                    skip_balanced('{','}'); 
                    yyval.decl.have_parms = 0; 
                    yyval.decl.defarg = 0; 
                    yyval.decl.throws = yyvsp[-2].dtype.throws;
                    yyval.decl.throw = yyvsp[-2].dtype.throw;
               }
    break;

  case 393:
#line 5258 "parser.y"
    { 
                    Clear(scanner_ccode); 
                    yyval.decl.parms = yyvsp[-2].pl; 
                    yyval.decl.have_parms = 1; 
                    yyval.decl.defarg = 0; 
		    yyval.decl.throws = 0;
		    yyval.decl.throw = 0;
               }
    break;

  case 394:
#line 5266 "parser.y"
    {
                    skip_balanced('{','}'); 
                    yyval.decl.parms = yyvsp[-2].pl; 
                    yyval.decl.have_parms = 1; 
                    yyval.decl.defarg = 0; 
                    yyval.decl.throws = 0;
                    yyval.decl.throw = 0;
               }
    break;

  case 395:
#line 5274 "parser.y"
    { 
                    yyval.decl.have_parms = 0; 
                    yyval.decl.defarg = yyvsp[-1].dtype.val; 
                    yyval.decl.throws = 0;
                    yyval.decl.throw = 0;
               }
    break;

  case 400:
#line 5290 "parser.y"
    {
	            skip_balanced('(',')');
                    Clear(scanner_ccode);
            	}
    break;

  case 401:
#line 5296 "parser.y"
    { 
                     String *s = NewString("");
                     SwigType_add_template(s,yyvsp[-1].p);
                     yyval.id = Char(s);
		     scanner_last_id(1);
                 }
    break;

  case 402:
#line 5302 "parser.y"
    { yyval.id = (char*)"";  }
    break;

  case 403:
#line 5305 "parser.y"
    { yyval.id = yyvsp[0].id; }
    break;

  case 404:
#line 5306 "parser.y"
    { yyval.id = yyvsp[0].id; }
    break;

  case 405:
#line 5309 "parser.y"
    { yyval.id = yyvsp[0].id; }
    break;

  case 406:
#line 5310 "parser.y"
    { yyval.id = 0; }
    break;

  case 407:
#line 5313 "parser.y"
    { 
                  yyval.str = 0;
		  if (!yyval.str) yyval.str = NewStringf("%s%s", yyvsp[-1].str,yyvsp[0].str);
      	          Delete(yyvsp[0].str);
               }
    break;

  case 408:
#line 5318 "parser.y"
    { 
		 yyval.str = NewStringf("::%s%s",yyvsp[-1].str,yyvsp[0].str);
                 Delete(yyvsp[0].str);
               }
    break;

  case 409:
#line 5322 "parser.y"
    {
		 yyval.str = NewString(yyvsp[0].str);
   	       }
    break;

  case 410:
#line 5325 "parser.y"
    {
		 yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 411:
#line 5328 "parser.y"
    {
                 yyval.str = NewString(yyvsp[0].str);
	       }
    break;

  case 412:
#line 5331 "parser.y"
    {
                 yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 413:
#line 5336 "parser.y"
    {
                   yyval.str = NewStringf("::%s%s",yyvsp[-1].str,yyvsp[0].str);
		   Delete(yyvsp[0].str);
               }
    break;

  case 414:
#line 5340 "parser.y"
    {
                   yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 415:
#line 5343 "parser.y"
    {
                   yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 416:
#line 5350 "parser.y"
    {
		 yyval.str = NewStringf("::~%s",yyvsp[0].str);
               }
    break;

  case 417:
#line 5356 "parser.y"
    {
                  yyval.str = NewStringf("%s%s",yyvsp[-1].id,yyvsp[0].id);
		  /*		  if (Len($2)) {
		    scanner_last_id(1);
		    } */
              }
    break;

  case 418:
#line 5365 "parser.y"
    { 
                  yyval.str = 0;
		  if (!yyval.str) yyval.str = NewStringf("%s%s", yyvsp[-1].id,yyvsp[0].str);
      	          Delete(yyvsp[0].str);
               }
    break;

  case 419:
#line 5370 "parser.y"
    { 
		 yyval.str = NewStringf("::%s%s",yyvsp[-1].id,yyvsp[0].str);
                 Delete(yyvsp[0].str);
               }
    break;

  case 420:
#line 5374 "parser.y"
    {
		 yyval.str = NewString(yyvsp[0].id);
   	       }
    break;

  case 421:
#line 5377 "parser.y"
    {
		 yyval.str = NewStringf("::%s",yyvsp[0].id);
               }
    break;

  case 422:
#line 5380 "parser.y"
    {
                 yyval.str = NewString(yyvsp[0].str);
	       }
    break;

  case 423:
#line 5383 "parser.y"
    {
                 yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 424:
#line 5388 "parser.y"
    {
                   yyval.str = NewStringf("::%s%s",yyvsp[-1].id,yyvsp[0].str);
		   Delete(yyvsp[0].str);
               }
    break;

  case 425:
#line 5392 "parser.y"
    {
                   yyval.str = NewStringf("::%s",yyvsp[0].id);
               }
    break;

  case 426:
#line 5395 "parser.y"
    {
                   yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 427:
#line 5398 "parser.y"
    {
		 yyval.str = NewStringf("::~%s",yyvsp[0].id);
               }
    break;

  case 428:
#line 5404 "parser.y"
    { 
                   yyval.id = (char *) malloc(strlen(yyvsp[-1].id)+strlen(yyvsp[0].id)+1);
                   strcpy(yyval.id,yyvsp[-1].id);
                   strcat(yyval.id,yyvsp[0].id);
               }
    break;

  case 429:
#line 5409 "parser.y"
    { yyval.id = yyvsp[0].id;}
    break;

  case 430:
#line 5412 "parser.y"
    {
		 yyval.str = NewString(yyvsp[0].id);
               }
    break;

  case 431:
#line 5415 "parser.y"
    {
                  skip_balanced('{','}');
		  yyval.str = NewString(scanner_ccode);
               }
    break;

  case 432:
#line 5419 "parser.y"
    {
		 yyval.str = yyvsp[0].str;
              }
    break;

  case 433:
#line 5424 "parser.y"
    {
                  Hash *n;
                  yyval.node = NewHash();
                  n = yyvsp[-1].node;
                  while(n) {
                     String *name, *value;
                     name = Getattr(n,"name");
                     value = Getattr(n,"value");
		     if (!value) value = (String *) "1";
                     Setattr(yyval.node,name, value);
		     n = nextSibling(n);
		  }
               }
    break;

  case 434:
#line 5437 "parser.y"
    { yyval.node = 0; }
    break;

  case 435:
#line 5441 "parser.y"
    {
		 yyval.node = NewHash();
		 Setattr(yyval.node,"name",yyvsp[-2].id);
		 Setattr(yyval.node,"value",yyvsp[0].id);
               }
    break;

  case 436:
#line 5446 "parser.y"
    {
		 yyval.node = NewHash();
		 Setattr(yyval.node,"name",yyvsp[-4].id);
		 Setattr(yyval.node,"value",yyvsp[-2].id);
		 set_nextSibling(yyval.node,yyvsp[0].node);
               }
    break;

  case 437:
#line 5452 "parser.y"
    {
                 yyval.node = NewHash();
                 Setattr(yyval.node,"name",yyvsp[0].id);
	       }
    break;

  case 438:
#line 5456 "parser.y"
    {
                 yyval.node = NewHash();
                 Setattr(yyval.node,"name",yyvsp[-2].id);
                 set_nextSibling(yyval.node,yyvsp[0].node);
               }
    break;

  case 439:
#line 5461 "parser.y"
    {
                 yyval.node = yyvsp[0].node;
		 Setattr(yyval.node,"name",yyvsp[-2].id);
               }
    break;

  case 440:
#line 5465 "parser.y"
    {
                 yyval.node = yyvsp[-2].node;
		 Setattr(yyval.node,"name",yyvsp[-4].id);
		 set_nextSibling(yyval.node,yyvsp[0].node);
               }
    break;

  case 441:
#line 5472 "parser.y"
    {
		 yyval.id = yyvsp[0].id;
               }
    break;

  case 442:
#line 5475 "parser.y"
    {
                 yyval.id = Char(yyvsp[0].dtype.val);
               }
    break;


    }

/* Line 991 of yacc.c.  */
#line 9061 "y.tab.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab2;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:

  /* Suppress GCC warning that yyerrlab1 is unused when no action
     invokes YYERROR.  */
#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__) \
    && !defined __cplusplus
  __attribute__ ((__unused__))
#endif


  goto yyerrlab2;


/*---------------------------------------------------------------.
| yyerrlab2 -- pop states until the error token can be shifted.  |
`---------------------------------------------------------------*/
yyerrlab2:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 5482 "parser.y"


SwigType *Swig_cparse_type(String *s) {
   String *ns;
   ns = NewStringf("%s;",s);
   Seek(ns,0,SEEK_SET);
   scanner_file(ns);
   top = 0;
   scanner_next_token(PARSETYPE);
   yyparse();
   /*   Printf(stdout,"typeparse: '%s' ---> '%s'\n", s, top); */
   return top;
}


Parm *Swig_cparse_parm(String *s) {
   String *ns;
   ns = NewStringf("%s;",s);
   Seek(ns,0,SEEK_SET);
   scanner_file(ns);
   top = 0;
   scanner_next_token(PARSEPARM);
   yyparse();
   /*   Printf(stdout,"typeparse: '%s' ---> '%s'\n", s, top); */
   return top;
}










