/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ID = 258,
     HBLOCK = 259,
     POUND = 260,
     STRING = 261,
     INCLUDE = 262,
     IMPORT = 263,
     INSERT = 264,
     CHARCONST = 265,
     NUM_INT = 266,
     NUM_FLOAT = 267,
     NUM_UNSIGNED = 268,
     NUM_LONG = 269,
     NUM_ULONG = 270,
     NUM_LONGLONG = 271,
     NUM_ULONGLONG = 272,
     TYPEDEF = 273,
     TYPE_INT = 274,
     TYPE_UNSIGNED = 275,
     TYPE_SHORT = 276,
     TYPE_LONG = 277,
     TYPE_FLOAT = 278,
     TYPE_DOUBLE = 279,
     TYPE_CHAR = 280,
     TYPE_WCHAR = 281,
     TYPE_VOID = 282,
     TYPE_SIGNED = 283,
     TYPE_BOOL = 284,
     TYPE_COMPLEX = 285,
     TYPE_TYPEDEF = 286,
     TYPE_RAW = 287,
     TYPE_NON_ISO_INT8 = 288,
     TYPE_NON_ISO_INT16 = 289,
     TYPE_NON_ISO_INT32 = 290,
     TYPE_NON_ISO_INT64 = 291,
     LPAREN = 292,
     RPAREN = 293,
     COMMA = 294,
     SEMI = 295,
     EXTERN = 296,
     INIT = 297,
     LBRACE = 298,
     RBRACE = 299,
     PERIOD = 300,
     CONST_QUAL = 301,
     VOLATILE = 302,
     REGISTER = 303,
     STRUCT = 304,
     UNION = 305,
     EQUAL = 306,
     SIZEOF = 307,
     MODULE = 308,
     LBRACKET = 309,
     RBRACKET = 310,
     ILLEGAL = 311,
     CONSTANT = 312,
     NAME = 313,
     RENAME = 314,
     NAMEWARN = 315,
     EXTEND = 316,
     PRAGMA = 317,
     FEATURE = 318,
     VARARGS = 319,
     ENUM = 320,
     CLASS = 321,
     TYPENAME = 322,
     PRIVATE = 323,
     PUBLIC = 324,
     PROTECTED = 325,
     COLON = 326,
     STATIC = 327,
     VIRTUAL = 328,
     FRIEND = 329,
     THROW = 330,
     CATCH = 331,
     EXPLICIT = 332,
     USING = 333,
     NAMESPACE = 334,
     NATIVE = 335,
     INLINE = 336,
     TYPEMAP = 337,
     EXCEPT = 338,
     ECHO = 339,
     APPLY = 340,
     CLEAR = 341,
     SWIGTEMPLATE = 342,
     FRAGMENT = 343,
     WARN = 344,
     LESSTHAN = 345,
     GREATERTHAN = 346,
     MODULO = 347,
     DELETE_KW = 348,
     TYPES = 349,
     PARMS = 350,
     NONID = 351,
     DSTAR = 352,
     DCNOT = 353,
     TEMPLATE = 354,
     OPERATOR = 355,
     COPERATOR = 356,
     PARSETYPE = 357,
     PARSEPARM = 358,
     PARSEPARMS = 359,
     CAST = 360,
     LOR = 361,
     LAND = 362,
     OR = 363,
     XOR = 364,
     AND = 365,
     RSHIFT = 366,
     LSHIFT = 367,
     MINUS = 368,
     PLUS = 369,
     SLASH = 370,
     STAR = 371,
     LNOT = 372,
     NOT = 373,
     UMINUS = 374,
     DCOLON = 375
   };
#endif
#define ID 258
#define HBLOCK 259
#define POUND 260
#define STRING 261
#define INCLUDE 262
#define IMPORT 263
#define INSERT 264
#define CHARCONST 265
#define NUM_INT 266
#define NUM_FLOAT 267
#define NUM_UNSIGNED 268
#define NUM_LONG 269
#define NUM_ULONG 270
#define NUM_LONGLONG 271
#define NUM_ULONGLONG 272
#define TYPEDEF 273
#define TYPE_INT 274
#define TYPE_UNSIGNED 275
#define TYPE_SHORT 276
#define TYPE_LONG 277
#define TYPE_FLOAT 278
#define TYPE_DOUBLE 279
#define TYPE_CHAR 280
#define TYPE_WCHAR 281
#define TYPE_VOID 282
#define TYPE_SIGNED 283
#define TYPE_BOOL 284
#define TYPE_COMPLEX 285
#define TYPE_TYPEDEF 286
#define TYPE_RAW 287
#define TYPE_NON_ISO_INT8 288
#define TYPE_NON_ISO_INT16 289
#define TYPE_NON_ISO_INT32 290
#define TYPE_NON_ISO_INT64 291
#define LPAREN 292
#define RPAREN 293
#define COMMA 294
#define SEMI 295
#define EXTERN 296
#define INIT 297
#define LBRACE 298
#define RBRACE 299
#define PERIOD 300
#define CONST_QUAL 301
#define VOLATILE 302
#define REGISTER 303
#define STRUCT 304
#define UNION 305
#define EQUAL 306
#define SIZEOF 307
#define MODULE 308
#define LBRACKET 309
#define RBRACKET 310
#define ILLEGAL 311
#define CONSTANT 312
#define NAME 313
#define RENAME 314
#define NAMEWARN 315
#define EXTEND 316
#define PRAGMA 317
#define FEATURE 318
#define VARARGS 319
#define ENUM 320
#define CLASS 321
#define TYPENAME 322
#define PRIVATE 323
#define PUBLIC 324
#define PROTECTED 325
#define COLON 326
#define STATIC 327
#define VIRTUAL 328
#define FRIEND 329
#define THROW 330
#define CATCH 331
#define EXPLICIT 332
#define USING 333
#define NAMESPACE 334
#define NATIVE 335
#define INLINE 336
#define TYPEMAP 337
#define EXCEPT 338
#define ECHO 339
#define APPLY 340
#define CLEAR 341
#define SWIGTEMPLATE 342
#define FRAGMENT 343
#define WARN 344
#define LESSTHAN 345
#define GREATERTHAN 346
#define MODULO 347
#define DELETE_KW 348
#define TYPES 349
#define PARMS 350
#define NONID 351
#define DSTAR 352
#define DCNOT 353
#define TEMPLATE 354
#define OPERATOR 355
#define COPERATOR 356
#define PARSETYPE 357
#define PARSEPARM 358
#define PARSEPARMS 359
#define CAST 360
#define LOR 361
#define LAND 362
#define OR 363
#define XOR 364
#define AND 365
#define RSHIFT 366
#define LSHIFT 367
#define MINUS 368
#define PLUS 369
#define SLASH 370
#define STAR 371
#define LNOT 372
#define NOT 373
#define UMINUS 374
#define DCOLON 375




/* Copy the first part of user declarations.  */
#line 1 "parser.y"

#if 0
} /* cc-mode */
#endif
/* -----------------------------------------------------------------------------
 * parser.y
 *
 *     YACC parser for SWIG.   The grammar is a somewhat broken subset of C/C++.
 *     This file is a bit of a mess and probably needs to be rewritten at
 *     some point.  Beware.
 *
 * Author(s) : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (C) 1998-2001.  The University of Chicago
 * Copyright (C) 1995-1998.  The University of Utah and The Regents of the
 *                           University of California.
 *
 * See the file LICENSE for information on usage and redistribution.
 * ----------------------------------------------------------------------------- */

#define yylex yylex

char cvsroot_parser_y[] = "$Header: /cvsroot/swig/SWIG/Source/CParse/parser.y,v 1.170 2006/02/10 23:30:06 wsfulton Exp $";

#include "swig.h"
#include "swigkeys.h"
#include "cparse.h"
#include "preprocessor.h"
#include <ctype.h>

/* We do this for portability */
#undef alloca
#define alloca malloc

/* -----------------------------------------------------------------------------
 *                               Externals
 * ----------------------------------------------------------------------------- */

int  yyparse();

/* NEW Variables */

static Node    *top = 0;      /* Top of the generated parse tree */
static int      unnamed = 0;  /* Unnamed datatype counter */
static Hash    *extendhash = 0;     /* Hash table of added methods */
static Hash    *classes = 0;        /* Hash table of classes */
static Symtab  *prev_symtab = 0;
static Node    *current_class = 0;
String  *ModuleName = 0;
static Node    *module_node = 0;
static String  *Classprefix = 0;  
static String  *Namespaceprefix = 0;
static int      inclass = 0;
static char    *last_cpptype = 0;
static int      inherit_list = 0;
static Parm    *template_parameters = 0;
static int      extendmode   = 0;
static int      compact_default_args = 0;
static int      template_reduce = 0;
static int      cparse_externc = 0;

static int      class_level = 0;
static Node    *class_decl[16];

/* -----------------------------------------------------------------------------
 *                            Assist Functions
 * ----------------------------------------------------------------------------- */


 
/* Called by the parser (yyparse) when an error is found.*/
static void yyerror (const char *e) {
  (void)e;
}

static Node *new_node(const String_or_char *tag) {
  Node *n = NewHash();
  set_nodeType(n,tag);
  Setfile(n,cparse_file);
  Setline(n,cparse_line);
  return n;
}

/* Copies a node.  Does not copy tree links or symbol table data (except for
   sym:name) */

static Node *copy_node(Node *n) {
  Node *nn;
  Iterator k;
  nn = NewHash();
  Setfile(nn,Getfile(n));
  Setline(nn,Getline(n));
  for (k = First(n); k.key; k = Next(k)) {
    String *ci;
    String *key = k.key;
    char *ckey = Char(key);
    if ((strcmp(ckey,"nextSibling") == 0) ||
	(strcmp(ckey,"previousSibling") == 0) ||
	(strcmp(ckey,"parentNode") == 0) ||
	(strcmp(ckey,"lastChild") == 0)) {
      continue;
    }
    if (Strncmp(key,"csym:",5) == 0) continue;
    /* We do copy sym:name.  For templates */
    if ((strcmp(ckey,"sym:name") == 0) || 
	(strcmp(ckey,"sym:weak") == 0) ||
	(strcmp(ckey,"sym:typename") == 0)) {
      String *ci = Copy(k.item);
      Setattr(nn,key, ci);
      Delete(ci);
      continue;
    }
    if (strcmp(ckey,"sym:symtab") == 0) {
      Setattr(nn,"sym:needs_symtab", "1");
    }
    /* We don't copy any other symbol table attributes */
    if (strncmp(ckey,"sym:",4) == 0) {
      continue;
    }
    /* If children.  We copy them recursively using this function */
    if (strcmp(ckey,"firstChild") == 0) {
      /* Copy children */
      Node *cn = k.item;
      while (cn) {
	Node *copy = copy_node(cn);
	appendChild(nn,copy);
	Delete(copy);
	cn = nextSibling(cn);
      }
      continue;
    }
    /* We don't copy the symbol table.  But we drop an attribute 
       requires_symtab so that functions know it needs to be built */

    if (strcmp(ckey,"symtab") == 0) {
      /* Node defined a symbol table. */
      Setattr(nn,"requires_symtab","1");
      continue;
    }
    /* Can't copy nodes */
    if (strcmp(ckey,"node") == 0) {
      continue;
    }
    if ((strcmp(ckey,"parms") == 0) || (strcmp(ckey,"pattern") == 0) || (strcmp(ckey,"throws") == 0)
	|| (strcmp(ckey,"kwargs") == 0)) {
      ParmList *pl = CopyParmList(k.item);
      Setattr(nn,key,pl);
      Delete(pl);
      continue;
    }
    /* Looks okay.  Just copy the data using Copy */
    ci = Copy(k.item);
    Setattr(nn, key, ci);
    Delete(ci);
  }
  return nn;
}

/* -----------------------------------------------------------------------------
 *                              Variables
 * ----------------------------------------------------------------------------- */

static char  *typemap_lang = 0;    /* Current language setting */

static int cplus_mode  = 0;
static String  *class_rename = 0;

/* C++ modes */

#define  CPLUS_PUBLIC    1
#define  CPLUS_PRIVATE   2
#define  CPLUS_PROTECTED 3

/* include types */
static int   import_mode = 0;

void SWIG_typemap_lang(const char *tm_lang) {
  typemap_lang = Swig_copy_string(tm_lang);
}

void SWIG_cparse_set_compact_default_args(int defargs) {
  compact_default_args = defargs;
}

int SWIG_cparse_template_reduce(int treduce) {
  template_reduce = treduce;
  return treduce;  
}

/* -----------------------------------------------------------------------------
 *                           Assist functions
 * ----------------------------------------------------------------------------- */

/* Perform type-promotion for binary operators */
static int promote(int t1, int t2) {
  return t1 > t2 ? t1 : t2;
}

static String *yyrename = 0;

/* Forward renaming operator */

static String *resolve_node_scope(String *cname);


Hash *Swig_cparse_features() {
  static Hash   *features_hash = 0;
  if (!features_hash) features_hash = NewHash();
  return features_hash;
}

static String *feature_identifier_fix(String *s) {
  if (SwigType_istemplate(s)) {
    String *tp, *ts, *ta, *tq;
    tp = SwigType_templateprefix(s);
    ts = SwigType_templatesuffix(s);
    ta = SwigType_templateargs(s);
    tq = Swig_symbol_type_qualify(ta,0);
    Append(tp,tq);
    Append(tp,ts);
    Delete(ts);
    Delete(ta);
    Delete(tq);
    return tp;
  } else {
    return NewString(s);
  }
}

/* Generate the symbol table name for an object */
/* This is a bit of a mess. Need to clean up */
static String *add_oldname = 0;



static String *make_name(Node *n, String *name,SwigType *decl) {
  int destructor = name && (*(Char(name)) == '~');

  if (yyrename) {
    String *s = NewString(yyrename);
    Delete(yyrename);
    yyrename = 0;
    if (destructor  && (*(Char(s)) != '~')) {
      Insert(s,0,"~");
    }
    return s;
  }

  if (!name) return 0;
  return Swig_name_make(n,Namespaceprefix,name,decl,add_oldname);
}

/* Generate an unnamed identifier */
static String *make_unnamed() {
  unnamed++;
  return NewStringf("$unnamed%d$",unnamed);
}

/* Return if the node is a friend declaration */
static int is_friend(Node *n) {
  return Cmp(Getattr(n,k_storage),"friend") == 0;
}

static int is_operator(String *name) {
  return Strncmp(name,"operator ", 9) == 0;
}


/* Add declaration list to symbol table */
static int  add_only_one = 0;

static void add_symbols(Node *n) {
  String *decl;
  String *wrn = 0;
  if (inclass && n) {
    cparse_normalize_void(n);
  }
  while (n) {
    String *symname = 0;
    /* for friends, we need to pop the scope once */
    String *old_prefix = 0;
    Symtab *old_scope = 0;
    int isfriend = inclass && is_friend(n);
    int iscdecl = Cmp(nodeType(n),"cdecl") == 0;
    if (extendmode) {
      Setattr(n,"isextension","1");
    }
    
    if (inclass) {
      String *name = Getattr(n, k_name);
      if (isfriend) {
	/* for friends, we need to add the scopename if needed */
	String *prefix = name ? Swig_scopename_prefix(name) : 0;
	old_prefix = Namespaceprefix;
	old_scope = Swig_symbol_popscope();
	Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	if (!prefix) {
	  if (name && Namespaceprefix) {
	    String *nname = NewStringf("%s::%s", Namespaceprefix, name);
	    Setattr(n,k_name,nname);
	    Delete(nname);
	  }
	} else {
	  Symtab *st = Swig_symbol_getscope(prefix);
	  String *ns = st ? Getattr(st,k_name) : prefix;
	  String *base  = Swig_scopename_last(name);
	  String *nname = NewStringf("%s::%s", ns, base);
	  Setattr(n,k_name,nname);
	  Delete(nname);
	  Delete(base);
	  Delete(prefix);
	}
      } else {
	/* for member functions, we need to remove the redundant
	   class scope if provided, as in
	   
	   struct Foo {
	   int Foo::method(int a);
	   };
	   
	*/
	String *prefix = name ? Swig_scopename_prefix(name) : 0;
	if (prefix) {
	  if (Classprefix && (StringEqual(prefix,Classprefix))) {
	    String *base = Swig_scopename_last(name);
	    Setattr(n,k_name,base);
	    Delete(base);
	  }
	  Delete(prefix);
	}

	if (0 && !Getattr(n,k_parentnode) && class_level) set_parentNode(n,class_decl[class_level - 1]);
	Setattr(n,"ismember","1");
      }
    }
    if (!isfriend && inclass) {
      if ((cplus_mode != CPLUS_PUBLIC)) {
	int only_csymbol = 1;
	if (cplus_mode == CPLUS_PROTECTED) {
	  Setattr(n,k_access, "protected");
	  only_csymbol = !Swig_need_protected(n);
	} else {
	  /* private are needed only when they are pure virtuals */
	  Setattr(n,k_access, "private");
	if ((Cmp(Getattr(n,k_storage),"virtual") == 0) 
	    && (Cmp(Getattr(n,k_value),"0") == 0)) {
	  only_csymbol = !Swig_need_protected(n);
	}    
	}
	if (only_csymbol) {
	  /* Only add to C symbol table and continue */
	  Swig_symbol_add(0, n); 
	  if (add_only_one) break;
	  n = nextSibling(n);
	  continue;
	}
      } else {
	  Setattr(n,k_access, "public");
      }
    }
    if (Getattr(n,k_symname)) {
      n = nextSibling(n);
      continue;
    }
    decl = Getattr(n,k_decl);
    if (!SwigType_isfunction(decl)) {
      String *name = Getattr(n,k_name);
      String *makename = Getattr(n,"parser:makename");
      if (iscdecl) {	
	String *storage = Getattr(n, k_storage);
	if (Cmp(storage,"typedef") == 0) {
	  Setattr(n,k_kind,"typedef");
	} else {
	  SwigType *type = Getattr(n,"type");
	  String *value = Getattr(n,k_value);
	  Setattr(n,k_kind,"variable");
	  if (value && Len(value)) {
	    Setattr(n,"hasvalue","1");
	  }
	  if (type) {
	    SwigType *ty;
	    SwigType *tmp = 0;
	    if (decl) {
	      ty = tmp = Copy(type);
	      SwigType_push(ty,decl);
	    } else {
	      ty = type;
	    }
	    if (!SwigType_ismutable(ty)) {
	      SetFlag(n,"hasconsttype");
	      SetFlag(n,"feature:immutable");
	    }
	    if (tmp) Delete(tmp);
	  }
	  if (!type) {
	    Printf(stderr,"notype name %s\n", name);
	  }
	}
      }
      Swig_features_get(Swig_cparse_features(), Namespaceprefix, name, 0, n);
      if (makename) {
	symname = make_name(n, makename,0);
        Delattr(n,"parser:makename"); /* temporary information, don't leave it hanging around */
      } else {
        makename = name;
	symname = make_name(n, makename,0);
      }
      
      if (!symname) {
	symname = Copy(Getattr(n,k_unnamed));
      }
      if (symname) {
	wrn = Swig_name_warning(n, Namespaceprefix, symname,0);
      }
    } else {
      String *name = Getattr(n,k_name);
      SwigType *fdecl = Copy(decl);
      SwigType *fun = SwigType_pop_function(fdecl);
      if (iscdecl) {	
	Setattr(n,k_kind,"function");
      }
      
      Swig_features_get(Swig_cparse_features(),Namespaceprefix,name,fun,n);

      symname = make_name(n, name,fun);
      wrn = Swig_name_warning(n, Namespaceprefix,symname,fun);
      
      Delete(fdecl);
      Delete(fun);
      
    }
    if (!symname) {
      n = nextSibling(n);
      continue;
    }
    if (GetFlag(n,"feature:ignore")) {
      Swig_symbol_add(0, n);
    } else if (strncmp(Char(symname),"$ignore",7) == 0) {
      char *c = Char(symname)+7;
      SetFlag(n,"feature:ignore");
      if (strlen(c)) {
	SWIG_WARN_NODE_BEGIN(n);
	Swig_warning(0,Getfile(n), Getline(n), "%s\n",c+1);
	SWIG_WARN_NODE_END(n);
      }
      Swig_symbol_add(0, n);
    } else {
      Node *c;
      if ((wrn) && (Len(wrn))) {
	String *metaname = symname;
	if (!Getmeta(metaname,"already_warned")) {
	  SWIG_WARN_NODE_BEGIN(n);
	  Swig_warning(0,Getfile(n),Getline(n), "%s\n", wrn);
	  SWIG_WARN_NODE_END(n);
	  Setmeta(metaname,"already_warned","1");
	}
      }
      c = Swig_symbol_add(symname,n);

      if (c != n) {
        /* symbol conflict attempting to add in the new symbol */
        if (Getattr(n,k_symweak)) {
          Setattr(n,k_symname,symname);
        } else {
          String *e = NewStringEmpty();
          String *en = NewStringEmpty();
          String *ec = NewStringEmpty();
          int redefined = Swig_need_redefined_warn(n,c,inclass);
          if (redefined) {
            Printf(en,"Identifier '%s' redefined (ignored)",symname);
            Printf(ec,"previous definition of '%s'",symname);
          } else {
            Printf(en,"Redundant redeclaration of '%s'",symname);
            Printf(ec,"previous declaration of '%s'",symname);
          }
          if (Cmp(symname,Getattr(n,k_name))) {
            Printf(en," (Renamed from '%s')", SwigType_namestr(Getattr(n,k_name)));
          }
          Printf(en,",");
          if (Cmp(symname,Getattr(c,k_name))) {
            Printf(ec," (Renamed from '%s')", SwigType_namestr(Getattr(c,k_name)));
          }
          Printf(ec,".");
	  SWIG_WARN_NODE_BEGIN(n);
          if (redefined) {
            Swig_warning(WARN_PARSE_REDEFINED,Getfile(n),Getline(n),"%s\n",en);
            Swig_warning(WARN_PARSE_REDEFINED,Getfile(c),Getline(c),"%s\n",ec);
          } else if (!is_friend(n) && !is_friend(c)) {
            Swig_warning(WARN_PARSE_REDUNDANT,Getfile(n),Getline(n),"%s\n",en);
            Swig_warning(WARN_PARSE_REDUNDANT,Getfile(c),Getline(c),"%s\n",ec);
          }
	  SWIG_WARN_NODE_END(n);
          Printf(e,"%s:%d:%s\n%s:%d:%s\n",Getfile(n),Getline(n),en,
                 Getfile(c),Getline(c),ec);
          Setattr(n,k_error,e);
	  Delete(e);
          Delete(en);
          Delete(ec);
        }
      }
    }
    /* restore the class scope if needed */
    if (isfriend) {
      Swig_symbol_setscope(old_scope);
      if (old_prefix) {
	Delete(Namespaceprefix);
	Namespaceprefix = old_prefix;
      }
    }
    Delete(symname);

    if (add_only_one) return;
    n = nextSibling(n);
  }
}


/* add symbols a parse tree node copy */

static void add_symbols_copy(Node *n) {
  String *name;
  int    emode = 0;
  while (n) {
    char *cnodeType = Char(nodeType(n));

    if (strcmp(cnodeType,"access") == 0) {
      String *kind = Getattr(n,k_kind);
      if (Strcmp(kind,"public") == 0) {
	cplus_mode = CPLUS_PUBLIC;
      } else if (Strcmp(kind,"private") == 0) {
	cplus_mode = CPLUS_PRIVATE;
      } else if (Strcmp(kind,"protected") == 0) {
	cplus_mode = CPLUS_PROTECTED;
      }
      n = nextSibling(n);
      continue;
    }

    add_oldname = Getattr(n,k_symname);
    if ((add_oldname) || (Getattr(n,"sym:needs_symtab"))) {
      if (add_oldname) {
	DohIncref(add_oldname);
	/*  Disable this, it prevents %rename to work with templates */
	/* If already renamed, we used that name  */
	/*
	if (Strcmp(add_oldname, Getattr(n,k_name)) != 0) {
	  Delete(yyrename);
	  yyrename = Copy(add_oldname);
	}
	*/
      }
      Delattr(n,"sym:needs_symtab");
      Delattr(n,k_symname);

      add_only_one = 1;
      add_symbols(n);

      if (Getattr(n,k_partialargs)) {
	Swig_symbol_cadd(Getattr(n,k_partialargs),n);
      }
      add_only_one = 0;
      name = Getattr(n,k_name);
      if (Getattr(n,"requires_symtab")) {
	Swig_symbol_newscope();
	Swig_symbol_setscopename(name);
	Delete(Namespaceprefix);
	Namespaceprefix = Swig_symbol_qualifiedscopename(0);
      }
      if (strcmp(cnodeType,"class") == 0) {
	inclass = 1;
	current_class = n;
	if (Strcmp(Getattr(n,k_kind),"class") == 0) {
	  cplus_mode = CPLUS_PRIVATE;
	} else {
	  cplus_mode = CPLUS_PUBLIC;
	}
      }
      if (strcmp(cnodeType,"extend") == 0) {
	emode = cplus_mode;
	cplus_mode = CPLUS_PUBLIC;
      }
      add_symbols_copy(firstChild(n));
      if (strcmp(cnodeType,"extend") == 0) {
	cplus_mode = emode;
      }
      if (Getattr(n,"requires_symtab")) {
	Setattr(n,k_symtab, Swig_symbol_popscope());
	Delattr(n,"requires_symtab");
	Delete(Namespaceprefix);
	Namespaceprefix = Swig_symbol_qualifiedscopename(0);
      }
      if (add_oldname) {
	Delete(add_oldname);
	add_oldname = 0;
      }
      if (strcmp(cnodeType,"class") == 0) {
	inclass = 0;
	current_class = 0;
      }
    } else {
      if (strcmp(cnodeType,"extend") == 0) {
	emode = cplus_mode;
	cplus_mode = CPLUS_PUBLIC;
      }
      add_symbols_copy(firstChild(n));
      if (strcmp(cnodeType,"extend") == 0) {
	cplus_mode = emode;
      }
    }
    n = nextSibling(n);
  }
}

/* Extension merge.  This function is used to handle the %extend directive
   when it appears before a class definition.   To handle this, the %extend
   actually needs to take precedence.  Therefore, we will selectively nuke symbols
   from the current symbol table, replacing them with the added methods */

static void merge_extensions(Node *cls, Node *am) {
  Node *n;
  Node *csym;

  n = firstChild(am);
  while (n) {
    String *symname;
    if (Strcmp(nodeType(n),"constructor") == 0) {
      symname = Getattr(n,k_symname);
      if (symname) {
	if (Strcmp(symname,Getattr(n,k_name)) == 0) {
	  /* If the name and the sym:name of a constructor are the same,
             then it hasn't been renamed.  However---the name of the class
             itself might have been renamed so we need to do a consistency
             check here */
	  if (Getattr(cls,k_symname)) {
	    Setattr(n,k_symname, Getattr(cls,k_symname));
	  }
	}
      } 
    }

    symname = Getattr(n,k_symname);
    DohIncref(symname);
    if ((symname) && (!Getattr(n,k_error))) {
      /* Remove node from its symbol table */
      Swig_symbol_remove(n);
      csym = Swig_symbol_add(symname,n);
      if (csym != n) {
	/* Conflict with previous definition.  Nuke previous definition */
	String *e = NewStringEmpty();
	String *en = NewStringEmpty();
	String *ec = NewStringEmpty();
	Printf(ec,"Identifier '%s' redefined by %%extend (ignored),",symname);
	Printf(en,"%%extend definition of '%s'.",symname);
	SWIG_WARN_NODE_BEGIN(n);
	Swig_warning(WARN_PARSE_REDEFINED,Getfile(csym),Getline(csym),"%s\n",ec);
	Swig_warning(WARN_PARSE_REDEFINED,Getfile(n),Getline(n),"%s\n",en);
	SWIG_WARN_NODE_END(n);
	Printf(e,"%s:%d:%s\n%s:%d:%s\n",Getfile(csym),Getline(csym),ec, 
	       Getfile(n),Getline(n),en);
	Setattr(csym,k_error,e);
	Delete(e);
	Delete(en);
	Delete(ec);
	Swig_symbol_remove(csym);              /* Remove class definition */
	Swig_symbol_add(symname,n);            /* Insert extend definition */
      }
    }
    n = nextSibling(n);
  }
}

static void append_previous_extension(Node *cls, Node *am) {
  Node *n, *ne;
  Node *pe = 0;
  Node *ae = 0;

  if (!am) return;
  
  n = firstChild(am);
  while (n) {
    ne = nextSibling(n);
    set_nextSibling(n,0);
    /* typemaps and fragments need to be preppended */
    if (((Cmp(nodeType(n),"typemap") == 0) || (Cmp(nodeType(n),"fragment") == 0)))  {
      if (!pe) pe = new_node("extend");
      appendChild(pe, n);
    } else {
      if (!ae) ae = new_node("extend");
      appendChild(ae, n);
    }    
    n = ne;
  }
  if (pe) preppendChild(cls,pe);
  if (ae) appendChild(cls,ae);
}
 

/* Check for unused %extend.  Special case, don't report unused
   extensions for templates */
 
static void check_extensions() {
  Iterator ki;

  if (!extendhash) return;
  for (ki = First(extendhash); ki.key; ki = Next(ki)) {
    if (!Strstr(ki.key,"<")) {
      SWIG_WARN_NODE_BEGIN(ki.item);
      Swig_warning(WARN_PARSE_EXTEND_UNDEF,Getfile(ki.item), Getline(ki.item), "%%extend defined for an undeclared class %s.\n", ki.key);
      SWIG_WARN_NODE_END(ki.item);
    }
  }
}

/* Check a set of declarations to see if any are pure-abstract */

static List *pure_abstract(Node *n) {
  List *abs = 0;
  while (n) {
    if (Cmp(nodeType(n),"cdecl") == 0) {
      String *decl = Getattr(n,k_decl);
      if (SwigType_isfunction(decl)) {
	String *init = Getattr(n,k_value);
	if (Cmp(init,"0") == 0) {
	  if (!abs) {
	    abs = NewList();
	  }
	  Append(abs,n);
	  Setattr(n,k_abstract,"1");
	}
      }
    } else if (Cmp(nodeType(n),"destructor") == 0) {
      if (Cmp(Getattr(n,k_value),"0") == 0) {
	if (!abs) {
	  abs = NewList();
	}
	Append(abs,n);
	Setattr(n,k_abstract,"1");
      }
    }
    n = nextSibling(n);
  }
  return abs;
}

/* Make a classname */

static String *make_class_name(String *name) {
  String *nname = 0;
  if (Namespaceprefix) {
    nname= NewStringf("%s::%s", Namespaceprefix, name);
  } else {
    nname = NewString(name);
  }
  if (SwigType_istemplate(nname)) {
    String *prefix, *args, *qargs;
    prefix = SwigType_templateprefix(nname);
    args   = SwigType_templateargs(nname);
    qargs  = Swig_symbol_type_qualify(args,0);
    Append(prefix,qargs);
    Delete(nname);
    Delete(args);
    Delete(qargs);
    nname = prefix;
  }
  return nname;
}

static List *make_inherit_list(String *clsname, List *names) {
  int i, ilen;
  String *derived;
  List *bases = NewList();

  if (Namespaceprefix) derived = NewStringf("%s::%s", Namespaceprefix,clsname);
  else derived = NewString(clsname);

  ilen = Len(names);
  for (i = 0; i < ilen; i++) {
    Node *s;
    String *base;
    String *n = Getitem(names,i);
    /* Try to figure out where this symbol is */
    s = Swig_symbol_clookup(n,0);
    if (s) {
      while (s && (Strcmp(nodeType(s),"class") != 0)) {
	/* Not a class.  Could be a typedef though. */
	String *storage = Getattr(s,k_storage);
	if (storage && (Strcmp(storage,"typedef") == 0)) {
	  String *nn = Getattr(s,k_type);
	  s = Swig_symbol_clookup(nn,Getattr(s,k_symsymtab));
	} else {
	  break;
	}
      }
      if (s && ((Strcmp(nodeType(s),"class") == 0) || (Strcmp(nodeType(s),"template") == 0))) {
	String *q = Swig_symbol_qualified(s);
	Append(bases,s);
	if (q) {
	  base = NewStringf("%s::%s", q, Getattr(s,k_name));
	  Delete(q);
	} else {
	  base = NewString(Getattr(s,k_name));
	}
      } else {
	base = NewString(n);
      }
    } else {
      base = NewString(n);
    }
    if (base) {
      Swig_name_inherit(base,derived);
      Delete(base);
    }
  }
  return bases;
}

/* If the class name is qualified.  We need to create or lookup namespace entries */

static Symtab *get_global_scope() {
  Symtab *symtab = Swig_symbol_current();
  Node   *pn = parentNode(symtab);
  while (pn) {
    symtab = pn;
    pn = parentNode(symtab);
    if (!pn) break;
  }
  Swig_symbol_setscope(symtab);
  return symtab;
}
 

static Node *nscope = 0;
static Node *nscope_inner = 0;
static String *resolve_node_scope(String *cname) {
  Symtab *gscope = 0;
  nscope = 0;
  nscope_inner = 0;  
  if (Swig_scopename_check(cname)) {
    Node   *ns;
    String *prefix = Swig_scopename_prefix(cname);
    String *base = Swig_scopename_last(cname);
    if (prefix && (Strncmp(prefix,"::",2) == 0)) {
      /* Use the global scope */
      String *nprefix = NewString(Char(prefix)+2);
      Delete(prefix);
      prefix= nprefix;
      gscope = get_global_scope();
    }    
    if (!prefix || (Len(prefix) == 0)) {
      /* Use the global scope, but we need to add a 'global' namespace.  */
      if (!gscope) gscope = get_global_scope();
      /* note that this namespace is not the k_unnamed one,
	 and we don't use Setattr(nscope,k_name, ""),
	 because the unnamed namespace is private */
      nscope = new_node(k_namespace);
      Setattr(nscope,k_symtab, gscope);;
      nscope_inner = nscope;
      return base;
    }
    /* Try to locate the scope */
    ns = Swig_symbol_clookup(prefix,0);
    if (!ns) {
      Swig_error(cparse_file,cparse_line,"Undefined scope '%s'\n", prefix);
    } else {
      Symtab *nstab = Getattr(ns,k_symtab);
      if (!nstab) {
	Swig_error(cparse_file,cparse_line,
		   "'%s' is not defined as a valid scope.\n", prefix);
	ns = 0;
      } else {
	/* Check if the node scope is the current scope */
	String *tname = Swig_symbol_qualifiedscopename(0);
	String *nname = Swig_symbol_qualifiedscopename(nstab);
	if (tname && (Strcmp(tname,nname) == 0)) {
	  ns = 0;
	  cname = base;
	}
	Delete(tname);
	Delete(nname);
      }
      if (ns) {
	/* we will try to create a new node using the namespaces we
	   can find in the scope name */
	List *scopes;
	String *sname;
	Iterator si;
	String *name = NewString(prefix);
	scopes = NewList();
	while (name) {
	  String *base = Swig_scopename_last(name);
	  String *tprefix = Swig_scopename_prefix(name);
	  Insert(scopes,0,base);
	  Delete(base);
	  Delete(name);
	  name = tprefix;
	}
	for (si = First(scopes); si.item; si = Next(si)) {
	  Node *ns1,*ns2;
	  sname = si.item;
	  ns1 = Swig_symbol_clookup(sname,0);
	  assert(ns1);
	  if (Strcmp(nodeType(ns1),"namespace") == 0) {
	    if (Getattr(ns1,k_alias)) {
	      ns1 = Getattr(ns1,k_namespace);
	    }
	  } else {
	    /* now this last part is a class */
	    si = Next(si);
	    ns1 = Swig_symbol_clookup(sname,0);
	    /*  or a nested class tree, which is unrolled here */
	    for (; si.item; si = Next(si)) {
	      if (si.item) {
		Printf(sname,"::%s",si.item);
	      }
	    }
	    /* we get the 'inner' class */
	    nscope_inner = Swig_symbol_clookup(sname,0);
	    /* set the scope to the inner class */
	    Swig_symbol_setscope(Getattr(nscope_inner,k_symtab));
	    /* save the last namespace prefix */
	    Delete(Namespaceprefix);
	    Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	    /* and return the node name, including the inner class prefix */
	    break;
	  }
	  /* here we just populate the namespace tree as usual */
	  ns2 = new_node("namespace");
	  Setattr(ns2,k_name,sname);
	  Setattr(ns2,k_symtab, Getattr(ns1,k_symtab));
	  add_symbols(ns2);
	  Swig_symbol_setscope(Getattr(ns1,k_symtab));
	  Delete(Namespaceprefix);
	  Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	  if (nscope_inner) {
	    if (Getattr(nscope_inner,k_symtab) != Getattr(ns2,k_symtab)) {
	      appendChild(nscope_inner,ns2);
	      Delete(ns2);
	    }
	  }
	  nscope_inner = ns2;
	  if (!nscope) nscope = ns2;
	}
	cname = base;
	Delete(scopes);
      }
    }
    Delete(prefix);
  }
  return cname;
}
 




/* Structures for handling code fragments built for nested classes */

typedef struct Nested {
  String   *code;        /* Associated code fragment */
  int      line;         /* line number where it starts */
  char     *name;        /* Name associated with this nested class */
  char     *kind;        /* Kind of class */
  int      unnamed;      /* unnamed class */
  SwigType *type;        /* Datatype associated with the name */
  struct Nested   *next;        /* Next code fragment in list */
} Nested;

/* Some internal variables for saving nested class information */

static Nested      *nested_list = 0;

/* Add a function to the nested list */

static void add_nested(Nested *n) {
  Nested *n1;
  if (!nested_list) nested_list = n;
  else {
    n1 = nested_list;
    while (n1->next) n1 = n1->next;
    n1->next = n;
  }
}

/* Dump all of the nested class declarations to the inline processor
 * However.  We need to do a few name replacements and other munging
 * first.  This function must be called before closing a class! */

static Node *dump_nested(const char *parent) {
  Nested *n,*n1;
  Node *ret = 0;
  n = nested_list;
  if (!parent) {
    nested_list = 0;
    return 0;
  }
  while (n) {
    char temp[256];
    Node *retx;
    SwigType *nt;
    /* Token replace the name of the parent class */
    Replace(n->code, "$classname", parent, DOH_REPLACE_ANY);
    /* Fix up the name of the datatype (for building typedefs and other stuff) */
    sprintf(temp,"%s_%s", parent,n->name);

    Append(n->type,parent);
    Append(n->type,"_");
    Append(n->type,n->name);

    /* Add the appropriate declaration to the C++ processor */
    retx = new_node("cdecl");
    Setattr(retx,k_name,n->name);
    nt = Copy(n->type);
    Setattr(retx,k_type,nt);
    Delete(nt);
    Setattr(retx,"nested",parent);
    if (n->unnamed) {
      Setattr(retx,k_unnamed,"1");
    }
    
    add_symbols(retx);
    if (ret) {
      set_nextSibling(retx,ret);
      Delete(ret);
    }
    ret = retx;

    /* Insert a forward class declaration */
    /* Disabled: [ 597599 ] union in class: incorrect scope 
       retx = new_node("classforward");
       Setattr(retx,k_kind,n->kind);
       Setattr(retx,k_name,Copy(n->type));
       Setattr(retx,"sym:name", make_name(n->type,0));
       set_nextSibling(retx,ret);
       ret = retx; 
    */

    /* Make all SWIG created typedef structs/unions/classes unnamed else 
       redefinition errors occur - nasty hack alert.*/

    {
      const char* types_array[3] = {"struct", "union", "class"};
      int i;
      for (i=0; i<3; i++) {
	char* code_ptr = Char(n->code);
	while (code_ptr) {
	  /* Replace struct name (as in 'struct name {' ) with whitespace
	     name will be between struct and { */
	
	  code_ptr = strstr(code_ptr, types_array[i]);
	  if (code_ptr) {
	    char *open_bracket_pos;
	    code_ptr += strlen(types_array[i]);
	    open_bracket_pos = strstr(code_ptr, "{");
	    if (open_bracket_pos) { 
	      /* Make sure we don't have something like struct A a; */
	      char* semi_colon_pos = strstr(code_ptr, ";");
	      if (!(semi_colon_pos && (semi_colon_pos < open_bracket_pos)))
		while (code_ptr < open_bracket_pos)
		  *code_ptr++ = ' ';
	    }
	  }
	}
      }
    }
    
    {
      /* Remove SWIG directive %constant which may be left in the SWIG created typedefs */
      char* code_ptr = Char(n->code);
      while (code_ptr) {
	code_ptr = strstr(code_ptr, "%constant");
	if (code_ptr) {
	  char* directive_end_pos = strstr(code_ptr, ";");
	  if (directive_end_pos) { 
            while (code_ptr <= directive_end_pos)
              *code_ptr++ = ' ';
	  }
	}
      }
    }
    {
      Node *head = new_node("insert");
      String *code = NewStringf("\n%s\n",n->code);
      Setattr(head,k_code, code);
      Delete(code);
      set_nextSibling(head,ret);
      Delete(ret);      
      ret = head;
    }
      
    /* Dump the code to the scanner */
    start_inline(Char(n->code),n->line);

    n1 = n->next;
    Delete(n->code);
    free(n);
    n = n1;
  }
  nested_list = 0;
  return ret;
}

Node *Swig_cparse(File *f) {
  scanner_file(f);
  top = 0;
  yyparse();
  return top;
}

static void single_new_feature(const char *featurename, String *val, Hash *featureattribs, char *declaratorid, SwigType *type, ParmList *declaratorparms, String *qualifier) {
  String *fname;
  String *name;
  String *fixname;
  SwigType *t = Copy(type);

  /* Printf(stdout, "single_new_feature: [%s] [%s] [%s] [%s] [%s] [%s]\n", featurename, val, declaratorid, t, ParmList_str_defaultargs(declaratorparms), qualifier); */

  fname = NewStringf("feature:%s",featurename);
  if (declaratorid) {
    fixname = feature_identifier_fix(declaratorid);
  } else {
    fixname = NewStringEmpty();
  }
  if (Namespaceprefix) {
    name = NewStringf("%s::%s",Namespaceprefix, fixname);
  } else {
    name = fixname;
  }

  if (declaratorparms) Setmeta(val,k_parms,declaratorparms);
  if (!Len(t)) t = 0;
  if (t) {
    if (qualifier) SwigType_push(t,qualifier);
    if (SwigType_isfunction(t)) {
      SwigType *decl = SwigType_pop_function(t);
      if (SwigType_ispointer(t)) {
	String *nname = NewStringf("*%s",name);
	Swig_feature_set(Swig_cparse_features(), nname, decl, fname, val, featureattribs);
	Delete(nname);
      } else {
	Swig_feature_set(Swig_cparse_features(), name, decl, fname, val, featureattribs);
      }
      Delete(decl);
    } else if (SwigType_ispointer(t)) {
      String *nname = NewStringf("*%s",name);
      Swig_feature_set(Swig_cparse_features(),nname,0,fname,val, featureattribs);
      Delete(nname);
    }
  } else {
    /* Global feature, that is, feature not associated with any particular symbol */
    Swig_feature_set(Swig_cparse_features(),name,0,fname,val, featureattribs);
  }
  Delete(fname);
  Delete(name);
}

/* Add a new feature to the Hash. Additional features are added if the feature has a parameter list (declaratorparms)
 * and one or more of the parameters have a default argument. An extra feature is added for each defaulted parameter,
 * simulating the equivalent overloaded method. */
static void new_feature(const char *featurename, String *val, Hash *featureattribs, char *declaratorid, SwigType *type, ParmList *declaratorparms, String *qualifier) {

  ParmList *declparms = declaratorparms;

  /* Add the feature */
  single_new_feature(featurename, val, featureattribs, declaratorid, type, declaratorparms, qualifier);

  /* Add extra features if there are default parameters in the parameter list */
  if (type) {
    while (declparms) {
      if (ParmList_has_defaultargs(declparms)) {

        /* Create a parameter list for the new feature by copying all
           but the last (defaulted) parameter */
        ParmList* newparms = ParmList_copy_all_except_last_parm(declparms);

        /* Create new declaration - with the last parameter removed */
        SwigType *newtype = Copy(type);
        Delete(SwigType_pop_function(newtype)); /* remove the old parameter list from newtype */
        SwigType_add_function(newtype,newparms);

        single_new_feature(featurename, Copy(val), featureattribs, declaratorid, newtype, newparms, qualifier);
        declparms = newparms;
      } else {
        declparms = 0;
      }
    }
  }
}

/* check if a function declaration is a plain C object */
static int is_cfunction(Node *n) {
  if (!cparse_cplusplus || cparse_externc) return 1;
  if (Cmp(Getattr(n,k_storage),"externc") == 0) {
    return 1;
  }
  return 0;
}

/* If the Node is a function with parameters, check to see if any of the parameters
 * have default arguments. If so create a new function for each defaulted argument. 
 * The additional functions form a linked list of nodes with the head being the original Node n. */
static void default_arguments(Node *n) {
  Node *function = n;

  if (function) {
    ParmList *varargs = Getattr(function,"feature:varargs");
    if (varargs) {
      /* Handles the %varargs directive by looking for "feature:varargs" and 
       * substituting ... with an alternative set of arguments.  */
      Parm     *p = Getattr(function,k_parms);
      Parm     *pp = 0;
      while (p) {
	SwigType *t = Getattr(p,k_type);
	if (Strcmp(t,"v(...)") == 0) {
	  if (pp) {
	    ParmList *cv = Copy(varargs);
	    set_nextSibling(pp,cv);
	    Delete(cv);
	  } else {
	    ParmList *cv =  Copy(varargs);
	    Setattr(function,k_parms, cv);
	    Delete(cv);
	  }
	  break;
	}
	pp = p;
	p = nextSibling(p);
      }
    }

    /* Do not add in functions if kwargs is being used or if user wants old default argument wrapping
       (one wrapped method per function irrespective of number of default arguments) */
    if (compact_default_args 
	|| is_cfunction(function) 
	|| GetFlag(function,"feature:compactdefaultargs") 
	|| GetFlag(function,"feature:kwargs")) {
      ParmList *p = Getattr(function,k_parms);
      if (p) 
        Setattr(p,k_compactdefargs, "1"); /* mark parameters for special handling */
      function = 0; /* don't add in extra methods */
    }
  }

  while (function) {
    ParmList *parms = Getattr(function,k_parms);
    if (ParmList_has_defaultargs(parms)) {

      /* Create a parameter list for the new function by copying all
         but the last (defaulted) parameter */
      ParmList* newparms = ParmList_copy_all_except_last_parm(parms);

      /* Create new function and add to symbol table */
      {
	SwigType *ntype = Copy(nodeType(function));
	char *cntype = Char(ntype);
        Node *new_function = new_node(ntype);
        SwigType *decl = Copy(Getattr(function,k_decl));
        int constqualifier = SwigType_isconst(decl);
	String *ccode = Copy(Getattr(function,k_code));
	String *cstorage = Copy(Getattr(function,k_storage));
	SwigType *ctype = Copy(Getattr(function,k_type));
	String *cthrow = Copy(Getattr(function,k_throw));

        Delete(SwigType_pop_function(decl)); /* remove the old parameter list from decl */
        SwigType_add_function(decl,newparms);
        if (constqualifier)
          SwigType_add_qualifier(decl,"const");

        Setattr(new_function,k_name, Getattr(function,k_name));
        Setattr(new_function,k_code, ccode);
        Setattr(new_function,k_decl, decl);
        Setattr(new_function,k_parms, newparms);
        Setattr(new_function,k_storage, cstorage);
        Setattr(new_function,k_type, ctype);
        Setattr(new_function,k_throw, cthrow);

	Delete(ccode);
	Delete(cstorage);
	Delete(ctype);
	Delete(cthrow);
	Delete(decl);

        {
          Node *throws = Getattr(function,k_throws);
	  ParmList *pl = CopyParmList(throws);
          if (throws) Setattr(new_function,k_throws,pl);
	  Delete(pl);
        }

        /* copy specific attributes for global (or in a namespace) template functions - these are not templated class methods */
        if (strcmp(cntype,"template") == 0) {
          Node *templatetype = Getattr(function,k_templatetype);
          Node *symtypename = Getattr(function,k_symtypename);
          Parm *templateparms = Getattr(function,k_templateparms);
          if (templatetype) {
	    Node *tmp = Copy(templatetype);
	    Setattr(new_function,k_templatetype,tmp);
	    Delete(tmp);
	  }
          if (symtypename) {
	    Node *tmp = Copy(symtypename);
	    Setattr(new_function,k_symtypename,tmp);
	    Delete(tmp);
	  }
          if (templateparms) {
	    Parm *tmp = CopyParmList(templateparms);
	    Setattr(new_function,k_templateparms,tmp);
	    Delete(tmp);
	  }
        } else if (strcmp(cntype,"constructor") == 0) {
          /* only copied for constructors as this is not a user defined feature - it is hard coded in the parser */
          if (GetFlag(function,"feature:new")) SetFlag(new_function,"feature:new");
        }

        add_symbols(new_function);
        /* mark added functions as ones with overloaded parameters and point to the parsed method */
        Setattr(new_function,"defaultargs", n);

        /* Point to the new function, extending the linked list */
        set_nextSibling(function, new_function);
	Delete(new_function);
        function = new_function;
	
	Delete(ntype);
      }
    } else {
      function = 0;
    }
  }
}

#if 0
{ /* cc-mode */
#endif


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 1336 "parser.y"
typedef union YYSTYPE {
  char  *id;
  List  *bases;
  struct Define {
    String *val;
    String *rawval;
    int     type;
    String *qualifier;
    String *bitfield;
    Parm   *throws;
    String *throwf;
  } dtype;
  struct {
    char *type;
    char *filename;
    int   line;
  } loc;
  struct {
    char      *id;
    SwigType  *type;
    String    *defarg;
    ParmList  *parms;
    short      have_parms;
    ParmList  *throws;
    String    *throwf;
  } decl;
  Parm         *tparms;
  struct {
    String     *op;
    Hash       *kwargs;
  } tmap;
  struct {
    String     *type;
    String     *us;
  } ptype;
  SwigType     *type;
  String       *str;
  Parm         *p;
  ParmList     *pl;
  int           ivalue;
  Node         *node;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1693 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1705 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  54
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   3636

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  121
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  143
/* YYNRULES -- Number of rules. */
#define YYNRULES  453
/* YYNRULES -- Number of states. */
#define YYNSTATES  876

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   375

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     9,    12,    16,    19,    25,    29,
      32,    34,    36,    38,    40,    42,    44,    46,    49,    51,
      53,    55,    57,    59,    61,    63,    65,    67,    69,    71,
      73,    75,    77,    79,    81,    83,    85,    87,    89,    91,
      92,   100,   106,   110,   116,   122,   126,   129,   132,   138,
     141,   147,   150,   155,   157,   159,   167,   175,   181,   182,
     190,   192,   194,   197,   200,   202,   208,   214,   220,   224,
     229,   233,   241,   250,   256,   260,   262,   264,   268,   270,
     275,   283,   290,   292,   294,   302,   312,   321,   332,   338,
     346,   353,   362,   364,   366,   372,   377,   383,   391,   393,
     397,   404,   411,   420,   422,   425,   429,   431,   434,   438,
     445,   451,   461,   464,   466,   468,   470,   471,   478,   484,
     486,   491,   493,   495,   498,   504,   511,   516,   524,   533,
     540,   542,   544,   546,   548,   550,   552,   553,   563,   564,
     573,   575,   578,   583,   584,   591,   595,   597,   599,   601,
     603,   605,   607,   609,   613,   618,   619,   626,   627,   633,
     639,   642,   643,   650,   652,   653,   657,   659,   661,   663,
     665,   667,   669,   671,   673,   677,   679,   681,   683,   685,
     687,   689,   691,   693,   695,   702,   709,   717,   726,   735,
     743,   749,   752,   755,   758,   759,   767,   768,   775,   776,
     785,   787,   789,   791,   793,   795,   797,   799,   801,   803,
     805,   807,   809,   811,   814,   817,   820,   825,   828,   834,
     836,   839,   841,   843,   845,   847,   849,   851,   853,   856,
     858,   862,   864,   867,   874,   878,   880,   883,   885,   889,
     891,   893,   895,   897,   900,   906,   909,   912,   914,   917,
     920,   922,   924,   926,   928,   931,   935,   937,   940,   944,
     949,   955,   960,   962,   965,   969,   974,   980,   984,   989,
     994,   996,   999,  1004,  1009,  1015,  1019,  1024,  1029,  1031,
    1034,  1037,  1041,  1043,  1046,  1048,  1051,  1055,  1060,  1064,
    1069,  1072,  1076,  1080,  1085,  1089,  1093,  1096,  1099,  1101,
    1103,  1106,  1108,  1110,  1112,  1114,  1117,  1119,  1121,  1123,
    1125,  1128,  1131,  1133,  1136,  1138,  1141,  1143,  1145,  1148,
    1150,  1152,  1154,  1156,  1158,  1160,  1162,  1164,  1166,  1168,
    1170,  1172,  1174,  1176,  1177,  1180,  1182,  1184,  1186,  1190,
    1192,  1194,  1198,  1200,  1202,  1204,  1206,  1208,  1214,  1216,
    1218,  1222,  1227,  1233,  1239,  1246,  1249,  1252,  1254,  1256,
    1258,  1260,  1262,  1264,  1266,  1270,  1274,  1278,  1282,  1286,
    1290,  1294,  1298,  1302,  1306,  1310,  1313,  1316,  1319,  1322,
    1325,  1327,  1328,  1332,  1334,  1336,  1340,  1343,  1348,  1350,
    1352,  1354,  1356,  1358,  1360,  1362,  1364,  1366,  1368,  1373,
    1379,  1381,  1385,  1389,  1394,  1399,  1403,  1406,  1408,  1410,
    1414,  1417,  1421,  1423,  1425,  1427,  1429,  1431,  1434,  1439,
    1441,  1445,  1447,  1451,  1455,  1458,  1461,  1464,  1467,  1470,
    1475,  1477,  1481,  1483,  1487,  1491,  1494,  1497,  1500,  1503,
    1505,  1507,  1509,  1511,  1515,  1517,  1521,  1527,  1529,  1533,
    1537,  1543,  1545,  1547
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     122,     0,    -1,   123,    -1,   102,   206,    40,    -1,   102,
       1,    -1,   103,   206,    40,    -1,   103,     1,    -1,   104,
      37,   203,    38,    40,    -1,   104,     1,    40,    -1,   123,
     124,    -1,   263,    -1,   125,    -1,   162,    -1,   170,    -1,
      40,    -1,     1,    -1,   169,    -1,     1,   101,    -1,   126,
      -1,   128,    -1,   129,    -1,   130,    -1,   131,    -1,   132,
      -1,   135,    -1,   136,    -1,   139,    -1,   140,    -1,   141,
      -1,   142,    -1,   143,    -1,   144,    -1,   147,    -1,   149,
      -1,   152,    -1,   154,    -1,   159,    -1,   160,    -1,   161,
      -1,    -1,    61,   260,   253,    43,   127,   184,    44,    -1,
      85,   158,    43,   156,    44,    -1,    86,   156,    40,    -1,
      57,     3,    51,   228,    40,    -1,    57,   222,   214,   211,
      40,    -1,    57,     1,    40,    -1,    84,     4,    -1,    84,
     258,    -1,    83,    37,     3,    38,    43,    -1,    83,    43,
      -1,    83,    37,     3,    38,    40,    -1,    83,    40,    -1,
     258,    43,   206,    44,    -1,   258,    -1,   133,    -1,    88,
      37,   134,    39,   261,    38,     4,    -1,    88,    37,   134,
      39,   261,    38,    43,    -1,    88,    37,   134,    38,    40,
      -1,    -1,   138,   260,   258,    54,   137,   123,    55,    -1,
       7,    -1,     8,    -1,    81,     4,    -1,    81,    43,    -1,
       4,    -1,     9,    37,   251,    38,   258,    -1,     9,    37,
     251,    38,     4,    -1,     9,    37,   251,    38,    43,    -1,
      53,   260,   251,    -1,    58,    37,   251,    38,    -1,    58,
      37,    38,    -1,    80,    37,     3,    38,   202,     3,    40,
      -1,    80,    37,     3,    38,   202,   222,   214,    40,    -1,
      62,   146,     3,    51,   145,    -1,    62,   146,     3,    -1,
     258,    -1,     4,    -1,    37,     3,    38,    -1,   263,    -1,
     148,   214,   251,    40,    -1,   148,    37,   261,    38,   214,
     245,    40,    -1,   148,    37,   261,    38,   258,    40,    -1,
      59,    -1,    60,    -1,    63,    37,   251,    38,   214,   245,
     150,    -1,    63,    37,   251,    39,   262,    38,   214,   245,
      40,    -1,    63,    37,   251,   151,    38,   214,   245,   150,
      -1,    63,    37,   251,    39,   262,   151,    38,   214,   245,
      40,    -1,    63,    37,   251,    38,   150,    -1,    63,    37,
     251,    39,   262,    38,    40,    -1,    63,    37,   251,   151,
      38,   150,    -1,    63,    37,   251,    39,   262,   151,    38,
      40,    -1,   259,    -1,    40,    -1,    95,    37,   203,    38,
      40,    -1,    39,   251,    51,   262,    -1,    39,   251,    51,
     262,   151,    -1,    64,    37,   153,    38,   214,   245,    40,
      -1,   203,    -1,    11,    39,   206,    -1,    82,    37,   155,
      38,   156,   259,    -1,    82,    37,   155,    38,   156,    40,
      -1,    82,    37,   155,    38,   156,    51,   158,    40,    -1,
     261,    -1,   158,   157,    -1,    39,   158,   157,    -1,   263,
      -1,   222,   213,    -1,    37,   203,    38,    -1,    37,   203,
      38,    37,   203,    38,    -1,    94,    37,   203,    38,    40,
      -1,    87,    37,   252,    38,   256,    90,   207,    91,    40,
      -1,    89,   258,    -1,   164,    -1,   168,    -1,   167,    -1,
      -1,    41,   258,    43,   163,   123,    44,    -1,   202,   222,
     214,   166,   165,    -1,    40,    -1,    39,   214,   166,   165,
      -1,    43,    -1,   211,    -1,   220,   211,    -1,    75,    37,
     203,    38,   211,    -1,   220,    75,    37,   203,    38,   211,
      -1,   202,    65,     3,    40,    -1,   202,    65,   230,    43,
     231,    44,    40,    -1,   202,    65,   230,    43,   231,    44,
     214,   165,    -1,   202,   222,    37,   203,    38,   246,    -1,
     171,    -1,   175,    -1,   176,    -1,   180,    -1,   181,    -1,
     191,    -1,    -1,   202,   243,   253,   237,    43,   172,   184,
      44,   174,    -1,    -1,   202,   243,    43,   173,   184,    44,
     214,   165,    -1,    40,    -1,   214,   165,    -1,   202,   243,
     253,    40,    -1,    -1,    99,    90,   179,    91,   177,   178,
      -1,    99,   243,   253,    -1,   164,    -1,   171,    -1,   188,
      -1,   176,    -1,   175,    -1,   190,    -1,   204,    -1,    78,
     253,    40,    -1,    78,    79,   253,    40,    -1,    -1,    79,
     253,    43,   182,   123,    44,    -1,    -1,    79,    43,   183,
     123,    44,    -1,    79,     3,    51,   253,    40,    -1,   187,
     184,    -1,    -1,    61,    43,   185,   184,    44,   184,    -1,
     263,    -1,    -1,     1,   186,   184,    -1,   162,    -1,   188,
      -1,   189,    -1,   192,    -1,   198,    -1,   190,    -1,   175,
      -1,   193,    -1,   202,   253,    40,    -1,   180,    -1,   176,
      -1,   191,    -1,   160,    -1,   161,    -1,   201,    -1,   135,
      -1,   159,    -1,    40,    -1,   202,   222,    37,   203,    38,
     246,    -1,   118,   255,    37,   203,    38,   199,    -1,    73,
     118,   255,    37,   203,    38,   200,    -1,   202,   101,   222,
     219,    37,   203,    38,   200,    -1,   202,   101,   222,   110,
      37,   203,    38,   200,    -1,   202,   101,   222,    37,   203,
      38,   200,    -1,    76,    37,   203,    38,    43,    -1,    69,
      71,    -1,    68,    71,    -1,    70,    71,    -1,    -1,   202,
     243,     3,    43,   194,   197,    40,    -1,    -1,   202,   243,
      43,   195,   197,    40,    -1,    -1,   202,   243,   253,    71,
     240,    43,   196,    40,    -1,   214,    -1,   263,    -1,   144,
      -1,   130,    -1,   142,    -1,   147,    -1,   149,    -1,   152,
      -1,   140,    -1,   154,    -1,   128,    -1,   129,    -1,   131,
      -1,   245,    40,    -1,   245,    43,    -1,   245,    40,    -1,
     245,    51,   228,    40,    -1,   245,    43,    -1,   202,   222,
      71,   234,    40,    -1,    41,    -1,    41,   258,    -1,    72,
      -1,    18,    -1,    73,    -1,    74,    -1,    77,    -1,   263,
      -1,   204,    -1,   206,   205,    -1,   263,    -1,    39,   206,
     205,    -1,   263,    -1,   223,   212,    -1,    99,    90,   243,
      91,   243,   253,    -1,    45,    45,    45,    -1,   208,    -1,
     210,   209,    -1,   263,    -1,    39,   210,   209,    -1,   263,
      -1,   206,    -1,   235,    -1,     6,    -1,    51,   228,    -1,
      51,   228,    54,   234,    55,    -1,    51,    43,    -1,    71,
     234,    -1,   263,    -1,   214,   211,    -1,   217,   211,    -1,
     211,    -1,   214,    -1,   217,    -1,   263,    -1,   219,   215,
      -1,   219,   110,   215,    -1,   216,    -1,   110,   215,    -1,
     253,    97,   215,    -1,   219,   253,    97,   215,    -1,   219,
     253,    97,   110,   215,    -1,   253,    97,   110,   215,    -1,
     253,    -1,   118,   253,    -1,    37,   253,    38,    -1,    37,
     219,   215,    38,    -1,    37,   253,    97,   215,    38,    -1,
     215,    54,    55,    -1,   215,    54,   234,    55,    -1,   215,
      37,   203,    38,    -1,   253,    -1,   118,   253,    -1,    37,
     219,   216,    38,    -1,    37,   110,   216,    38,    -1,    37,
     253,    97,   216,    38,    -1,   216,    54,    55,    -1,   216,
      54,   234,    55,    -1,   216,    37,   203,    38,    -1,   219,
      -1,   219,   218,    -1,   219,   110,    -1,   219,   110,   218,
      -1,   218,    -1,   110,   218,    -1,   110,    -1,   253,    97,
      -1,   219,   253,    97,    -1,   219,   253,    97,   218,    -1,
     218,    54,    55,    -1,   218,    54,   234,    55,    -1,    54,
      55,    -1,    54,   234,    55,    -1,    37,   217,    38,    -1,
     218,    37,   203,    38,    -1,    37,   203,    38,    -1,   116,
     220,   219,    -1,   116,   219,    -1,   116,   220,    -1,   116,
      -1,   221,    -1,   221,   220,    -1,    46,    -1,    47,    -1,
      48,    -1,   223,    -1,   220,   224,    -1,   224,    -1,   225,
      -1,    29,    -1,    27,    -1,    31,   250,    -1,    65,   253,
      -1,    32,    -1,   224,   220,    -1,   253,    -1,   243,   253,
      -1,   226,    -1,   227,    -1,   227,   226,    -1,    19,    -1,
      21,    -1,    22,    -1,    25,    -1,    26,    -1,    23,    -1,
      24,    -1,    28,    -1,    20,    -1,    30,    -1,    33,    -1,
      34,    -1,    35,    -1,    36,    -1,    -1,   229,   234,    -1,
      10,    -1,     3,    -1,   263,    -1,   231,    39,   232,    -1,
     232,    -1,     3,    -1,     3,    51,   233,    -1,   263,    -1,
     234,    -1,    10,    -1,   235,    -1,   258,    -1,    52,    37,
     222,   212,    38,    -1,   236,    -1,   222,    -1,    37,   234,
      38,    -1,    37,   234,    38,   234,    -1,    37,   234,   219,
      38,   234,    -1,    37,   234,   110,    38,   234,    -1,    37,
     234,   219,   110,    38,   234,    -1,   110,   234,    -1,   116,
     234,    -1,    11,    -1,    12,    -1,    13,    -1,    14,    -1,
      15,    -1,    16,    -1,    17,    -1,   234,   114,   234,    -1,
     234,   113,   234,    -1,   234,   116,   234,    -1,   234,   115,
     234,    -1,   234,   110,   234,    -1,   234,   108,   234,    -1,
     234,   109,   234,    -1,   234,   112,   234,    -1,   234,   111,
     234,    -1,   234,   107,   234,    -1,   234,   106,   234,    -1,
     113,   234,    -1,   114,   234,    -1,   118,   234,    -1,   117,
     234,    -1,   222,    37,    -1,   238,    -1,    -1,    71,   239,
     240,    -1,   263,    -1,   241,    -1,   240,    39,   241,    -1,
     244,   253,    -1,   244,   242,   244,   253,    -1,    69,    -1,
      68,    -1,    70,    -1,    66,    -1,    49,    -1,    50,    -1,
      67,    -1,    73,    -1,   263,    -1,   220,    -1,    75,    37,
     203,    38,    -1,   220,    75,    37,   203,    38,    -1,   263,
      -1,   245,   247,    40,    -1,   245,   247,    43,    -1,    37,
     203,    38,    40,    -1,    37,   203,    38,    43,    -1,    51,
     228,    40,    -1,    71,   248,    -1,   263,    -1,   249,    -1,
     248,    39,   249,    -1,   253,    37,    -1,    90,   207,    91,
      -1,   263,    -1,     3,    -1,   258,    -1,   251,    -1,   263,
      -1,   255,   254,    -1,    96,   120,   255,   254,    -1,   255,
      -1,    96,   120,   255,    -1,   100,    -1,    96,   120,   100,
      -1,   120,   255,   254,    -1,   120,   255,    -1,   120,   100,
      -1,    98,   255,    -1,     3,   250,    -1,     3,   257,    -1,
      96,   120,     3,   257,    -1,     3,    -1,    96,   120,     3,
      -1,   100,    -1,    96,   120,   100,    -1,   120,     3,   257,
      -1,   120,     3,    -1,   120,   100,    -1,    98,     3,    -1,
     258,     6,    -1,     6,    -1,   258,    -1,    43,    -1,     4,
      -1,    37,   261,    38,    -1,   263,    -1,   251,    51,   262,
      -1,   251,    51,   262,    39,   261,    -1,   251,    -1,   251,
      39,   261,    -1,   251,    51,   133,    -1,   251,    51,   133,
      39,   261,    -1,   258,    -1,   235,    -1,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1482,  1482,  1495,  1499,  1502,  1505,  1508,  1511,  1516,
    1521,  1526,  1527,  1528,  1529,  1530,  1537,  1553,  1563,  1564,
    1565,  1566,  1567,  1568,  1569,  1570,  1571,  1572,  1573,  1574,
    1575,  1576,  1577,  1578,  1579,  1580,  1581,  1582,  1583,  1590,
    1590,  1662,  1672,  1683,  1704,  1726,  1737,  1746,  1765,  1771,
    1777,  1782,  1793,  1800,  1804,  1809,  1818,  1833,  1846,  1846,
    1898,  1899,  1906,  1926,  1957,  1961,  1971,  1976,  1994,  2028,
    2034,  2047,  2053,  2079,  2085,  2092,  2093,  2096,  2097,  2105,
    2151,  2197,  2208,  2211,  2238,  2243,  2248,  2253,  2260,  2265,
    2270,  2275,  2282,  2283,  2284,  2287,  2292,  2302,  2338,  2339,
    2369,  2403,  2411,  2424,  2449,  2455,  2459,  2462,  2473,  2478,
    2490,  2500,  2766,  2776,  2783,  2784,  2788,  2788,  2819,  2880,
    2884,  2906,  2912,  2918,  2924,  2930,  2943,  2958,  2968,  3046,
    3098,  3099,  3100,  3101,  3102,  3103,  3109,  3109,  3328,  3328,
    3438,  3439,  3451,  3471,  3471,  3706,  3712,  3715,  3718,  3721,
    3724,  3727,  3732,  3764,  3774,  3801,  3801,  3830,  3830,  3852,
    3879,  3894,  3894,  3904,  3905,  3905,  3922,  3923,  3940,  3941,
    3942,  3943,  3944,  3945,  3946,  3947,  3948,  3949,  3950,  3951,
    3952,  3953,  3954,  3955,  3964,  3989,  4013,  4053,  4067,  4084,
    4102,  4109,  4116,  4124,  4147,  4147,  4176,  4176,  4207,  4207,
    4225,  4226,  4232,  4235,  4239,  4242,  4243,  4244,  4245,  4246,
    4247,  4248,  4249,  4252,  4257,  4264,  4272,  4280,  4291,  4297,
    4298,  4306,  4307,  4308,  4309,  4310,  4311,  4318,  4329,  4337,
    4340,  4344,  4348,  4358,  4363,  4371,  4384,  4392,  4395,  4399,
    4403,  4431,  4437,  4447,  4458,  4472,  4481,  4489,  4499,  4503,
    4507,  4514,  4531,  4548,  4556,  4564,  4573,  4577,  4586,  4597,
    4609,  4619,  4632,  4639,  4647,  4663,  4671,  4682,  4693,  4704,
    4723,  4731,  4748,  4756,  4763,  4774,  4785,  4796,  4815,  4821,
    4827,  4834,  4843,  4846,  4855,  4862,  4869,  4879,  4890,  4901,
    4912,  4919,  4926,  4929,  4946,  4956,  4963,  4969,  4974,  4980,
    4984,  4990,  4991,  4992,  4998,  5004,  5008,  5011,  5014,  5015,
    5016,  5017,  5018,  5019,  5024,  5027,  5032,  5057,  5060,  5114,
    5118,  5122,  5126,  5130,  5134,  5138,  5142,  5146,  5150,  5154,
    5158,  5162,  5166,  5172,  5172,  5193,  5211,  5212,  5215,  5228,
    5236,  5244,  5261,  5264,  5273,  5284,  5285,  5289,  5294,  5295,
    5314,  5321,  5327,  5334,  5341,  5349,  5353,  5359,  5360,  5361,
    5362,  5363,  5364,  5365,  5368,  5372,  5376,  5380,  5384,  5388,
    5392,  5396,  5400,  5404,  5408,  5412,  5416,  5420,  5424,  5428,
    5444,  5449,  5449,  5450,  5453,  5470,  5479,  5492,  5505,  5506,
    5507,  5511,  5515,  5519,  5523,  5529,  5530,  5533,  5538,  5543,
    5548,  5555,  5562,  5569,  5577,  5585,  5593,  5594,  5597,  5598,
    5601,  5607,  5613,  5616,  5617,  5620,  5621,  5624,  5629,  5633,
    5636,  5639,  5642,  5647,  5651,  5654,  5661,  5667,  5676,  5681,
    5685,  5688,  5691,  5694,  5699,  5703,  5706,  5709,  5715,  5720,
    5723,  5726,  5730,  5735,  5748,  5752,  5757,  5763,  5767,  5772,
    5776,  5783,  5786,  5791
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ID", "HBLOCK", "POUND", "STRING", 
  "INCLUDE", "IMPORT", "INSERT", "CHARCONST", "NUM_INT", "NUM_FLOAT", 
  "NUM_UNSIGNED", "NUM_LONG", "NUM_ULONG", "NUM_LONGLONG", 
  "NUM_ULONGLONG", "TYPEDEF", "TYPE_INT", "TYPE_UNSIGNED", "TYPE_SHORT", 
  "TYPE_LONG", "TYPE_FLOAT", "TYPE_DOUBLE", "TYPE_CHAR", "TYPE_WCHAR", 
  "TYPE_VOID", "TYPE_SIGNED", "TYPE_BOOL", "TYPE_COMPLEX", "TYPE_TYPEDEF", 
  "TYPE_RAW", "TYPE_NON_ISO_INT8", "TYPE_NON_ISO_INT16", 
  "TYPE_NON_ISO_INT32", "TYPE_NON_ISO_INT64", "LPAREN", "RPAREN", "COMMA", 
  "SEMI", "EXTERN", "INIT", "LBRACE", "RBRACE", "PERIOD", "CONST_QUAL", 
  "VOLATILE", "REGISTER", "STRUCT", "UNION", "EQUAL", "SIZEOF", "MODULE", 
  "LBRACKET", "RBRACKET", "ILLEGAL", "CONSTANT", "NAME", "RENAME", 
  "NAMEWARN", "EXTEND", "PRAGMA", "FEATURE", "VARARGS", "ENUM", "CLASS", 
  "TYPENAME", "PRIVATE", "PUBLIC", "PROTECTED", "COLON", "STATIC", 
  "VIRTUAL", "FRIEND", "THROW", "CATCH", "EXPLICIT", "USING", "NAMESPACE", 
  "NATIVE", "INLINE", "TYPEMAP", "EXCEPT", "ECHO", "APPLY", "CLEAR", 
  "SWIGTEMPLATE", "FRAGMENT", "WARN", "LESSTHAN", "GREATERTHAN", "MODULO", 
  "DELETE_KW", "TYPES", "PARMS", "NONID", "DSTAR", "DCNOT", "TEMPLATE", 
  "OPERATOR", "COPERATOR", "PARSETYPE", "PARSEPARM", "PARSEPARMS", "CAST", 
  "LOR", "LAND", "OR", "XOR", "AND", "RSHIFT", "LSHIFT", "MINUS", "PLUS", 
  "SLASH", "STAR", "LNOT", "NOT", "UMINUS", "DCOLON", "$accept", 
  "program", "interface", "declaration", "swig_directive", 
  "extend_directive", "@1", "apply_directive", "clear_directive", 
  "constant_directive", "echo_directive", "except_directive", 
  "stringtype", "fname", "fragment_directive", "include_directive", "@2", 
  "includetype", "inline_directive", "insert_directive", 
  "module_directive", "name_directive", "native_directive", 
  "pragma_directive", "pragma_arg", "pragma_lang", "rename_directive", 
  "rename_namewarn", "feature_directive", "stringbracesemi", "featattr", 
  "varargs_directive", "varargs_parms", "typemap_directive", 
  "typemap_type", "tm_list", "tm_tail", "typemap_parm", "types_directive", 
  "template_directive", "warn_directive", "c_declaration", "@3", "c_decl", 
  "c_decl_tail", "initializer", "c_enum_forward_decl", "c_enum_decl", 
  "c_constructor_decl", "cpp_declaration", "cpp_class_decl", "@4", "@5", 
  "cpp_opt_declarators", "cpp_forward_class_decl", "cpp_template_decl", 
  "@6", "cpp_temp_possible", "template_parms", "cpp_using_decl", 
  "cpp_namespace_decl", "@7", "@8", "cpp_members", "@9", "@10", 
  "cpp_member", "cpp_constructor_decl", "cpp_destructor_decl", 
  "cpp_conversion_operator", "cpp_catch_decl", "cpp_protection_decl", 
  "cpp_nested", "@11", "@12", "@13", "nested_decl", "cpp_swig_directive", 
  "cpp_end", "cpp_vend", "anonymous_bitfield", "storage_class", "parms", 
  "rawparms", "ptail", "parm", "valparms", "rawvalparms", "valptail", 
  "valparm", "def_args", "parameter_declarator", 
  "typemap_parameter_declarator", "declarator", "notso_direct_declarator", 
  "direct_declarator", "abstract_declarator", 
  "direct_abstract_declarator", "pointer", "type_qualifier", 
  "type_qualifier_raw", "type", "rawtype", "type_right", "primitive_type", 
  "primitive_type_list", "type_specifier", "definetype", "@14", "ename", 
  "enumlist", "edecl", "etype", "expr", "exprnum", "exprcompound", 
  "inherit", "raw_inherit", "@15", "base_list", "base_specifier", 
  "access_specifier", "cpptype", "opt_virtual", "cpp_const", "ctor_end", 
  "ctor_initializer", "mem_initializer_list", "mem_initializer", 
  "template_decl", "idstring", "idstringopt", "idcolon", "idcolontail", 
  "idtemplate", "idcolonnt", "idcolontailnt", "string", "stringbrace", 
  "options", "kwargs", "stringnum", "empty", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   121,   122,   122,   122,   122,   122,   122,   122,   123,
     123,   124,   124,   124,   124,   124,   124,   124,   125,   125,
     125,   125,   125,   125,   125,   125,   125,   125,   125,   125,
     125,   125,   125,   125,   125,   125,   125,   125,   125,   127,
     126,   128,   129,   130,   130,   130,   131,   131,   132,   132,
     132,   132,   133,   134,   134,   135,   135,   135,   137,   136,
     138,   138,   139,   139,   140,   140,   140,   140,   141,   142,
     142,   143,   143,   144,   144,   145,   145,   146,   146,   147,
     147,   147,   148,   148,   149,   149,   149,   149,   149,   149,
     149,   149,   150,   150,   150,   151,   151,   152,   153,   153,
     154,   154,   154,   155,   156,   157,   157,   158,   158,   158,
     159,   160,   161,   162,   162,   162,   163,   162,   164,   165,
     165,   165,   166,   166,   166,   166,   167,   168,   168,   169,
     170,   170,   170,   170,   170,   170,   172,   171,   173,   171,
     174,   174,   175,   177,   176,   176,   178,   178,   178,   178,
     178,   178,   179,   180,   180,   182,   181,   183,   181,   181,
     184,   185,   184,   184,   186,   184,   187,   187,   187,   187,
     187,   187,   187,   187,   187,   187,   187,   187,   187,   187,
     187,   187,   187,   187,   188,   189,   189,   190,   190,   190,
     191,   192,   192,   192,   194,   193,   195,   193,   196,   193,
     197,   197,   198,   198,   198,   198,   198,   198,   198,   198,
     198,   198,   198,   199,   199,   200,   200,   200,   201,   202,
     202,   202,   202,   202,   202,   202,   202,   203,   204,   204,
     205,   205,   206,   206,   206,   207,   208,   208,   209,   209,
     210,   210,   210,   211,   211,   211,   211,   211,   212,   212,
     212,   213,   213,   213,   214,   214,   214,   214,   214,   214,
     214,   214,   215,   215,   215,   215,   215,   215,   215,   215,
     216,   216,   216,   216,   216,   216,   216,   216,   217,   217,
     217,   217,   217,   217,   217,   217,   217,   217,   218,   218,
     218,   218,   218,   218,   218,   219,   219,   219,   219,   220,
     220,   221,   221,   221,   222,   223,   223,   224,   224,   224,
     224,   224,   224,   224,   224,   224,   225,   226,   226,   227,
     227,   227,   227,   227,   227,   227,   227,   227,   227,   227,
     227,   227,   227,   229,   228,   228,   230,   230,   231,   231,
     232,   232,   232,   233,   233,   234,   234,   234,   234,   234,
     234,   234,   234,   234,   234,   234,   234,   235,   235,   235,
     235,   235,   235,   235,   236,   236,   236,   236,   236,   236,
     236,   236,   236,   236,   236,   236,   236,   236,   236,   236,
     237,   239,   238,   238,   240,   240,   241,   241,   242,   242,
     242,   243,   243,   243,   243,   244,   244,   245,   245,   245,
     245,   246,   246,   246,   246,   246,   247,   247,   248,   248,
     249,   250,   250,   251,   251,   252,   252,   253,   253,   253,
     253,   253,   253,   254,   254,   254,   254,   255,   256,   256,
     256,   256,   256,   256,   257,   257,   257,   257,   258,   258,
     259,   259,   259,   260,   260,   261,   261,   261,   261,   261,
     261,   262,   262,   263
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     3,     2,     3,     2,     5,     3,     2,
       1,     1,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       7,     5,     3,     5,     5,     3,     2,     2,     5,     2,
       5,     2,     4,     1,     1,     7,     7,     5,     0,     7,
       1,     1,     2,     2,     1,     5,     5,     5,     3,     4,
       3,     7,     8,     5,     3,     1,     1,     3,     1,     4,
       7,     6,     1,     1,     7,     9,     8,    10,     5,     7,
       6,     8,     1,     1,     5,     4,     5,     7,     1,     3,
       6,     6,     8,     1,     2,     3,     1,     2,     3,     6,
       5,     9,     2,     1,     1,     1,     0,     6,     5,     1,
       4,     1,     1,     2,     5,     6,     4,     7,     8,     6,
       1,     1,     1,     1,     1,     1,     0,     9,     0,     8,
       1,     2,     4,     0,     6,     3,     1,     1,     1,     1,
       1,     1,     1,     3,     4,     0,     6,     0,     5,     5,
       2,     0,     6,     1,     0,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     6,     6,     7,     8,     8,     7,
       5,     2,     2,     2,     0,     7,     0,     6,     0,     8,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     2,     4,     2,     5,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       3,     1,     2,     6,     3,     1,     2,     1,     3,     1,
       1,     1,     1,     2,     5,     2,     2,     1,     2,     2,
       1,     1,     1,     1,     2,     3,     1,     2,     3,     4,
       5,     4,     1,     2,     3,     4,     5,     3,     4,     4,
       1,     2,     4,     4,     5,     3,     4,     4,     1,     2,
       2,     3,     1,     2,     1,     2,     3,     4,     3,     4,
       2,     3,     3,     4,     3,     3,     2,     2,     1,     1,
       2,     1,     1,     1,     1,     2,     1,     1,     1,     1,
       2,     2,     1,     2,     1,     2,     1,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     2,     1,     1,     1,     3,     1,
       1,     3,     1,     1,     1,     1,     1,     5,     1,     1,
       3,     4,     5,     5,     6,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     2,     2,     2,     2,
       1,     0,     3,     1,     1,     3,     2,     4,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     5,
       1,     3,     3,     4,     4,     3,     2,     1,     1,     3,
       2,     3,     1,     1,     1,     1,     1,     2,     4,     1,
       3,     1,     3,     3,     2,     2,     2,     2,     2,     4,
       1,     3,     1,     3,     3,     2,     2,     2,     2,     1,
       1,     1,     1,     3,     1,     3,     5,     1,     3,     3,
       5,     1,     1,     0
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
     453,     0,     0,     0,     0,     0,    10,     4,   453,   319,
     327,   320,   321,   324,   325,   322,   323,   309,   326,   308,
     328,   453,   312,   329,   330,   331,   332,     0,   301,   302,
     303,   392,   393,     0,   391,   394,     0,     0,   421,     0,
       0,   299,   453,   306,   307,   316,   317,     0,   314,   419,
       6,     0,     0,   453,     1,    15,    64,    60,    61,     0,
     222,    14,   219,   453,     0,     0,    82,    83,   453,   453,
       0,     0,   221,   223,   224,     0,   225,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     9,    11,    18,    19,    20,    21,    22,    23,    24,
      25,   453,    26,    27,    28,    29,    30,    31,    32,     0,
      33,    34,    35,    36,    37,    38,    12,   113,   115,   114,
      16,    13,   130,   131,   132,   133,   134,   135,     0,   226,
     453,   427,   412,   310,     0,   311,     0,     0,     3,   305,
     300,   453,   333,     0,     0,   284,   298,     0,   250,   232,
     453,   256,   453,   282,   278,   270,   247,   313,   318,   315,
       0,     0,   417,     5,     8,     0,   227,   453,   229,    17,
       0,   439,   220,     0,     0,   444,     0,   453,     0,   304,
       0,     0,     0,     0,    78,     0,   453,   453,     0,     0,
     453,   157,     0,     0,    62,    63,     0,     0,    51,    49,
      46,    47,   453,     0,   453,     0,   453,   453,     0,   112,
     453,   453,     0,     0,     0,     0,     0,     0,   270,   453,
       0,     0,   242,   357,   358,   359,   360,   361,   362,   363,
     240,     0,   235,   453,   241,   237,   234,   422,   420,     0,
     453,   284,     0,     0,   278,   314,   335,   245,   243,     0,
       0,     0,   290,     0,     0,     0,     0,     0,     0,   349,
       0,   345,   348,   346,   246,   453,     0,   257,   283,   262,
     296,   297,   271,   248,   453,     0,   249,   453,     0,   280,
     254,   279,   262,   285,   426,   425,   424,     0,     0,   228,
     231,   413,     0,   414,   438,   116,   447,     0,    68,    45,
     333,     0,   453,    70,     0,     0,     0,    74,     0,     0,
       0,    98,     0,     0,   153,     0,   453,   155,     0,     0,
     103,     0,     0,     0,   107,   251,   252,   253,    42,     0,
     104,   106,   415,     0,   416,    54,     0,    53,     0,     0,
     152,   145,     0,   413,     0,     0,     0,     0,     0,     0,
       0,   262,     0,   453,     0,   337,   453,   453,   138,   315,
     411,     0,   236,   239,   418,     0,   284,   278,   314,     0,
     270,   294,   292,   280,     0,   270,   285,     0,   334,     0,
       0,   355,   375,   376,   356,   378,   377,   379,   291,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     278,   314,   263,   453,     0,   295,     0,   275,     0,     0,
     288,     0,   255,   281,   286,     0,   258,   423,     7,   453,
       0,   453,     0,     0,   443,     0,     0,    69,    39,    77,
       0,     0,     0,     0,     0,     0,     0,   154,     0,     0,
     453,   453,     0,     0,   108,     0,   453,     0,     0,     0,
       0,     0,   143,    58,     0,     0,     0,     0,    79,     0,
     126,   453,     0,   314,     0,     0,   122,   453,     0,   142,
     381,     0,   380,   383,   453,     0,     0,   285,   273,   272,
     286,     0,     0,   350,     0,   298,     0,   453,   374,   373,
     369,   370,   368,   372,   371,   365,   364,   367,   366,     0,
     262,   264,   285,     0,   267,     0,   277,   276,   293,   289,
       0,   259,   287,   261,   230,    66,    67,    65,     0,   448,
     449,   452,   451,   445,    43,    44,     0,    76,    73,    75,
     442,    93,   441,     0,    88,   453,   440,    92,     0,   451,
       0,     0,    99,   453,   190,   159,   158,     0,   219,     0,
       0,    50,    48,   453,    41,   105,   430,     0,   432,     0,
      57,     0,     0,   110,   453,   453,   453,     0,     0,   340,
       0,   339,   342,   453,   453,     0,   119,   121,   118,     0,
     123,   164,   183,     0,     0,     0,     0,   223,     0,   210,
     211,   203,   212,   181,   208,   204,   202,   205,   206,   207,
     209,   182,   178,   179,   166,   172,   176,   175,     0,     0,
     167,   168,   171,   177,   169,   173,   170,   180,     0,   226,
     453,   136,   238,   233,   274,   244,   351,     0,   298,   297,
       0,     0,     0,   265,     0,   269,   268,   260,   117,     0,
       0,     0,   453,     0,   397,     0,   400,     0,     0,     0,
       0,    90,   453,     0,   156,   220,   453,     0,   101,     0,
     100,     0,     0,     0,   428,     0,   453,     0,    52,   146,
     147,   150,   149,   144,   148,   151,     0,     0,     0,    81,
       0,   453,     0,   453,   333,   453,   129,     0,   453,   453,
       0,   161,   192,   191,   193,     0,     0,     0,   160,     0,
       0,     0,   314,   395,   382,   384,     0,   396,     0,   353,
     352,     0,   347,   266,   450,   446,    40,     0,   453,     0,
      84,   451,    95,    89,   453,     0,     0,    97,    71,     0,
       0,   109,   437,   435,   436,   431,   433,     0,    55,    56,
       0,    59,    80,   344,   341,   343,   338,   127,     0,     0,
       0,     0,     0,   407,   453,     0,     0,   165,     0,     0,
     453,     0,     0,   453,     0,   453,   196,   315,   174,   453,
     389,   388,   390,   453,   386,     0,   354,     0,     0,   453,
      96,     0,    91,   453,    86,    72,   102,   434,   429,     0,
     128,     0,   405,   406,   408,     0,   401,   402,   124,   120,
     453,     0,   453,     0,   139,   453,     0,     0,     0,     0,
     194,   453,   453,   385,     0,     0,    94,   398,     0,    85,
       0,   111,   403,   404,     0,   410,   125,     0,     0,   453,
       0,   453,   453,   453,   218,   453,     0,   200,   201,     0,
     387,   140,   137,     0,   399,    87,   409,   162,   453,   185,
       0,   453,     0,     0,   184,     0,   197,   198,   141,   186,
       0,   213,   214,   189,   453,   453,   195,     0,   215,   217,
     333,   188,   187,   199,     0,   216
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     4,     5,    91,    92,    93,   526,   589,   590,   591,
     592,    98,   335,   336,   593,   100,   565,   101,   102,   594,
     104,   595,   106,   596,   528,   183,   597,   109,   598,   534,
     433,   599,   310,   600,   319,   205,   330,   206,   601,   602,
     603,   604,   421,   117,   578,   465,   118,   119,   120,   121,
     122,   708,   468,   842,   605,   606,   564,   673,   339,   607,
     126,   440,   316,   608,   758,   690,   609,   610,   611,   612,
     613,   614,   615,   835,   811,   867,   836,   616,   849,   859,
     617,   618,   242,   166,   289,   167,   231,   232,   362,   233,
     148,   149,   324,   357,   267,   151,   243,   153,   217,    40,
      41,   259,   179,    43,    44,    45,    46,   248,   249,   354,
     570,   571,   744,   384,   261,   262,   471,   472,   620,   704,
     705,   773,    47,   706,   860,   686,   752,   793,   794,   131,
     296,   333,    48,   162,    49,   559,   664,   263,   537,   174,
     297,   523,   168
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -524
static const short yypact[] =
{
     566,  1419,  2931,    73,   104,  2466,  -524,  -524,     8,  -524,
    -524,  -524,  -524,  -524,  -524,  -524,  -524,  -524,  -524,  -524,
    -524,     8,  -524,  -524,  -524,  -524,  -524,    62,  -524,  -524,
    -524,  -524,  -524,    88,  -524,  -524,    -5,    68,  -524,   196,
    3536,   627,   825,   627,  -524,  -524,  1731,    88,  -524,   206,
    -524,   237,   260,  3267,  -524,   218,  -524,  -524,  -524,   312,
    -524,  -524,   390,   344,  2986,   368,  -524,  -524,   344,   370,
     386,   388,  -524,  -524,  -524,   406,  -524,    37,   129,   419,
     123,   457,   394,    32,  3322,  3322,   473,   485,   390,   488,
     416,  -524,  -524,  -524,  -524,  -524,  -524,  -524,  -524,  -524,
    -524,   344,  -524,  -524,  -524,  -524,  -524,  -524,  -524,   308,
    -524,  -524,  -524,  -524,  -524,  -524,  -524,  -524,  -524,  -524,
    -524,  -524,  -524,  -524,  -524,  -524,  -524,  -524,  3377,  -524,
    3154,  -524,  -524,  -524,   382,  -524,    34,   454,  -524,   627,
    -524,  2159,   239,  1241,  1994,   283,   293,    88,  -524,  -524,
      19,   328,    19,   375,   684,   431,  -524,  -524,  -524,  -524,
     537,    64,  -524,  -524,  -524,   506,  -524,   510,  -524,  -524,
      43,  -524,    93,    43,    43,  -524,   511,   -17,   947,  -524,
     470,    88,   552,   568,  -524,    43,  3211,  3267,    88,   534,
     172,  -524,   533,   577,  -524,  -524,    43,   582,  -524,  -524,
    -524,   593,  3267,   545,    55,   562,   567,    43,   390,   593,
    3267,  3267,    88,   390,    47,   868,    43,   117,   508,   197,
     970,   146,  -524,  -524,  -524,  -524,  -524,  -524,  -524,  -524,
    -524,   527,  -524,   587,  -524,  -524,  -524,  -524,   206,   542,
    2257,   609,   590,   598,  1019,   546,  -524,  -524,   599,  1994,
    1994,   622,  -524,  1994,  1994,  1994,  1994,  1994,  1994,   628,
    1116,  -524,  -524,   593,  1802,  2257,    88,   435,   375,  -524,
    -524,   548,  -524,  -524,  3267,  1605,  -524,  3267,  1662,   283,
     435,   375,   583,  1058,  -524,  -524,   206,   639,  3267,  -524,
    -524,  -524,   646,   593,  -524,  -524,   259,   651,  -524,  -524,
     687,   114,    19,  -524,   656,   659,   661,   653,   432,   667,
     673,  -524,   676,   677,  -524,    88,  -524,  -524,   685,   688,
    -524,   690,   691,  3322,  -524,  -524,  -524,  -524,  -524,  3322,
    -524,  -524,  -524,   692,  -524,  -524,   462,   238,   694,   629,
    -524,  -524,    46,   278,  1064,  1064,   625,   695,    45,   699,
     868,   638,  1058,   232,   697,  -524,  2313,   852,  -524,   236,
    -524,  3154,  -524,  -524,  -524,   454,   448,   145,   644,   313,
    -524,  -524,  -524,   448,   333,   652,  1064,  1994,  1802,  1271,
    3432,  1359,  -524,  -524,  -524,  -524,  -524,  -524,  -524,  1994,
    1994,  1994,  1994,  1994,  1994,  1994,  1994,  1994,  1994,  1994,
    1056,    22,  -524,  3267,  1771,  -524,   710,  -524,  1625,   715,
    -524,  1791,   435,   375,  1103,   868,   435,  -524,  -524,   510,
     138,  -524,    43,  1133,  -524,   716,   719,  -524,  -524,  -524,
     190,   942,  1307,   724,  3267,   947,   720,  -524,   726,  2560,
    -524,   418,  3322,   285,   727,   681,   567,   205,   728,    43,
    3267,   730,  -524,  -524,  1064,   102,   868,    26,  -524,  1101,
    -524,   768,   734,   625,   739,   591,  -524,   105,  1505,  -524,
    -524,   735,  -524,  -524,   587,    88,   652,  -524,  -524,  -524,
     448,   557,  1957,  1994,  1828,  2103,    16,   825,  1302,  1189,
    1233,  1346,  1359,   682,   682,   443,   443,  -524,  -524,   601,
     652,  -524,   868,   743,  -524,  2121,  -524,  -524,  -524,  -524,
     868,   435,   375,   435,  -524,  -524,  -524,   593,  2654,  -524,
     746,  -524,   238,   748,  -524,  -524,  1505,  -524,  -524,   593,
    -524,  -524,  -524,   745,  -524,   367,   593,  -524,   737,    27,
     558,   942,  -524,   367,  -524,  -524,  -524,  2748,   390,  3487,
     348,  -524,  -524,  3267,  -524,  -524,   214,   671,  -524,   709,
    -524,   765,   762,  -524,   931,  -524,   367,   203,   868,   756,
     372,  -524,  -524,   603,  3267,   947,  -524,  -524,  -524,   777,
    -524,  -524,  -524,   773,   747,   754,   755,   701,   537,  -524,
    -524,  -524,  -524,  -524,  -524,  -524,  -524,  -524,  -524,  -524,
    -524,  -524,  -524,  -524,  -524,  -524,  -524,  -524,   786,  1505,
    -524,  -524,  -524,  -524,  -524,  -524,  -524,  -524,  3041,   788,
     744,  -524,  -524,  -524,  -524,  -524,  1802,  1994,  2103,  2365,
    1994,   804,   805,  -524,   604,  -524,  -524,   435,  -524,    43,
      43,   795,  3267,   807,   770,   252,  -524,  1133,   248,    43,
     812,  -524,   367,   813,  -524,   593,    85,   947,  -524,  3322,
    -524,   814,   851,    78,  -524,    91,  3154,   224,  -524,  -524,
    -524,  -524,  -524,  -524,  -524,  -524,  3097,  2842,   817,  -524,
    1937,   768,   801,  3267,   687,   787,  -524,   821,   852,  3267,
    1505,  -524,  -524,  -524,  -524,   537,   830,   947,  -524,  3432,
     284,   231,   829,  -524,   831,  -524,   184,  -524,  1505,  1802,
    1802,  1994,  -524,  -524,  -524,  -524,  -524,   836,  3267,   838,
    -524,   593,   839,  -524,   367,   878,   252,  -524,  -524,   837,
     844,  -524,  -524,   214,  -524,   214,  -524,   799,  -524,  -524,
    1018,  -524,  -524,  -524,  -524,  1802,  -524,  -524,   591,   848,
     862,    88,   349,  -524,    19,   591,   853,  -524,  1505,   867,
    3267,   591,    52,  2313,  1994,    95,  -524,   220,  -524,   744,
    -524,  -524,  -524,   744,  -524,   863,  1802,   866,   872,  3267,
    -524,   873,  -524,   367,  -524,  -524,  -524,  -524,  -524,   874,
    -524,   415,  -524,   877,  -524,   883,  -524,  -524,  -524,  -524,
      19,   880,  3267,   884,  -524,  3267,   891,   892,   893,  1288,
    -524,   947,   744,  -524,    88,   923,  -524,  -524,   894,  -524,
     890,  -524,  -524,  -524,    88,  -524,  -524,  1505,   898,   367,
     899,  3267,  3267,   603,  -524,   947,   902,  -524,  -524,   183,
    -524,  -524,  -524,   591,  -524,  -524,  -524,  -524,   367,  -524,
     469,   367,   900,   906,  -524,   912,  -524,  -524,  -524,  -524,
     491,  -524,  -524,  -524,   367,   367,  -524,   913,  -524,  -524,
     687,  -524,  -524,  -524,   914,  -524
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
    -524,  -524,  -300,  -524,  -524,  -524,  -524,     9,    14,    15,
      21,  -524,   538,  -524,    30,  -524,  -524,  -524,  -524,    36,
    -524,    39,  -524,    42,  -524,  -524,    54,  -524,    57,  -523,
    -517,    60,  -524,    66,  -524,  -296,   520,   -72,    74,    75,
      80,    90,  -524,   392,  -465,   269,  -524,  -524,  -524,  -524,
     403,  -524,  -524,  -524,    -1,     5,  -524,  -524,  -524,    97,
    -524,  -524,  -524,  -497,  -524,  -524,  -524,   407,  -524,   411,
      98,  -524,  -524,  -524,  -524,  -524,   141,  -524,  -524,  -203,
    -524,     6,    61,   766,   561,     1,   321,  -524,   515,   630,
    -107,   503,  -524,   -25,   -82,  -216,   -35,   -58,   132,   -28,
    -524,   413,    29,   -39,  -524,   949,  -524,  -291,  -524,  -524,
    -524,   316,  -524,   796,   -37,  -524,  -524,  -524,  -524,   188,
     233,  -524,   -51,   241,  -460,   173,  -524,  -524,   185,   989,
    -119,  -524,   668,  -162,  -104,  -524,  -372,   785,   461,   198,
    -190,  -410,     0
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -454
static const short yytable[] =
{
       6,   139,    39,    51,   123,   129,   320,   152,   132,   425,
     124,   128,   203,   140,    94,   157,   439,   150,   651,    95,
      96,   132,   540,   650,   347,   369,    97,   445,   374,   641,
      42,    42,   238,   294,   300,    99,   200,     8,   171,   212,
       8,   103,   156,   273,   105,   276,   291,   107,     8,   171,
     343,   292,   294,   171,   630,   298,   284,   286,     8,   108,
     501,   304,   110,   175,   501,   111,   308,     8,   175,   184,
     142,   112,   280,   130,    52,   645,   364,   221,  -414,   113,
     114,   733,    42,   653,   216,   115,   239,   268,   332,   805,
     144,     8,   141,   234,   735,   116,   281,   349,   130,   294,
     453,   175,   125,   127,    54,     8,   678,   134,   171,   143,
      53,   157,   698,   685,   165,   136,   188,     8,   271,   502,
       8,   518,   720,   568,   417,   728,   631,   194,   369,   374,
     235,   230,   190,    36,   237,   280,   295,    38,   810,   301,
     547,    36,   515,    36,   171,    38,   550,    38,     8,     8,
     156,    36,   156,   302,   348,    38,   142,   344,   137,    42,
     481,   146,   806,   146,   285,   145,   195,   290,   146,   326,
      42,   146,   191,   147,   154,   130,   144,   132,   734,   325,
     579,   516,   240,   268,    36,   130,   281,     8,    38,   358,
     132,   736,   726,   757,   527,   426,   171,   412,    36,   143,
     353,   416,    38,   784,   327,   780,   331,   334,   556,   294,
      36,   775,   215,    36,    38,    42,    42,    38,   146,   355,
     147,   413,   769,   315,   344,    36,   857,   350,   738,    38,
     146,    42,   519,   363,   765,   266,   138,   722,   481,    42,
      42,    36,    36,   679,   294,    38,    38,   311,   312,   246,
     466,     8,   770,   771,   772,   373,   530,   446,   171,   561,
     469,   801,   130,   322,   781,   677,   181,   739,   412,    42,
     416,   338,   460,   244,   766,  -336,   469,   163,   270,  -453,
      36,   450,   247,   790,    38,   301,     8,     8,   723,   419,
     799,   812,   531,    36,    42,   532,   804,    38,   422,   213,
     164,   557,   156,    42,   160,   558,    42,   470,   268,   281,
     423,     8,   662,   538,   475,   413,     6,    42,   499,   169,
     265,   763,   130,   820,   234,   551,   161,    36,   552,   467,
     847,    38,   511,   513,   663,   406,   154,   143,   409,    28,
      29,    30,   281,   132,    36,   214,   345,   533,    38,   170,
     274,   478,   530,   132,   171,   764,   512,   156,   215,   473,
     580,   787,   230,   788,   146,   274,   147,   275,   130,   850,
     274,   479,   367,   685,   499,  -453,  -453,   511,   858,    36,
      36,   173,   275,    38,    38,    42,   521,   275,   658,   796,
      42,   532,   797,   750,   215,   521,   171,   400,  -453,   659,
     146,   266,   147,   405,    36,   180,   535,   182,    38,   146,
     543,   681,   277,    28,    29,    30,   682,   462,   215,   290,
     634,     6,   512,   185,   146,   186,   147,   236,   637,   278,
     566,   197,    42,   345,   198,   542,    60,   199,   123,   129,
       6,   129,   643,   187,   124,   128,   331,   549,    94,   714,
     715,   562,   152,    95,    96,   822,   193,   629,   823,   548,
      97,   572,   150,    42,   503,    31,    32,   156,   619,    99,
     431,   432,   403,   291,   363,   103,   171,   178,   105,    42,
     456,   107,    34,    35,   696,   240,   634,   156,   345,   404,
      72,    73,    74,   108,   196,    76,   110,   204,   204,   111,
     448,   449,   143,    31,    32,   112,   211,   644,   303,   861,
     207,   486,   862,   113,   114,   644,   652,   123,   129,   115,
      34,    35,   208,   124,   128,   210,   619,    94,   283,   116,
     538,   868,    95,    96,   869,   646,   125,   127,   644,    97,
       8,   220,   870,   646,   287,   644,   123,   129,    99,   288,
     688,   299,   124,   128,   103,   306,    94,   105,   398,   399,
     107,    95,    96,   671,   129,     6,   646,   701,    97,   672,
     676,   307,   108,   646,   314,   110,   317,    99,   111,   874,
     318,   466,    42,   103,   112,   321,   105,   730,   323,   107,
     139,   759,   113,   114,   274,   624,   648,   649,   115,   294,
     629,   108,   328,    42,   110,   352,   329,   111,   116,   619,
     521,   275,     8,   112,   661,   125,   127,   270,   360,   154,
     707,   113,   114,   724,   644,   221,   361,   115,   371,   234,
     575,   576,   729,   365,   577,   687,   372,   116,   403,   633,
     683,   403,   713,   376,   125,   127,   141,   798,   863,    28,
      29,    30,   646,   377,   684,   404,   132,   748,   404,   380,
     467,   871,   872,   143,   146,   387,   235,   230,     1,     2,
       3,    42,   761,    28,    29,    30,   123,   129,   643,   418,
     414,   572,   124,   128,   420,   753,    94,     8,   156,   424,
     619,    95,    96,   826,   427,    42,   644,   246,    97,   429,
     783,   135,   428,   717,   430,    36,   434,    99,   619,    38,
     155,   435,    42,   103,   436,   159,   105,   437,    42,   107,
     452,   265,   454,   441,   646,   554,   442,   147,   443,   444,
     447,   108,   451,   455,   110,   459,   204,   111,   143,   458,
     461,   477,   204,   112,   749,   189,   192,    42,   506,   480,
     756,   113,   114,   508,   156,   644,   524,   115,   619,   525,
     270,   405,   541,   544,   553,   132,   545,   116,   560,   707,
     563,   569,   573,   707,   125,   127,   574,   218,   621,   778,
      36,   635,   642,   646,    38,   639,   837,   640,   647,    42,
     843,   665,    42,   487,   279,   396,   397,   398,   399,   666,
     156,   644,   266,   667,     8,   644,   668,   680,    42,   245,
     837,   838,   707,   269,   689,   272,   691,   703,   692,   695,
     644,   803,   282,   644,   808,   693,   694,   619,     8,   646,
     697,    42,  -163,   646,    42,   838,   644,   644,   301,   716,
     818,   747,   711,   712,   718,   719,   218,   172,   646,   305,
     725,   646,   731,   727,   732,   204,   313,   742,   751,   754,
      42,    42,   141,   828,   646,   646,   830,   760,   201,   768,
     769,     8,   155,   209,   777,   779,   142,   785,   649,   143,
     341,     8,   346,   269,   786,   351,   791,   135,   218,   359,
     789,   800,   852,   853,   807,   345,   144,    36,    28,    29,
      30,    38,   792,   142,   802,   348,   816,   815,   368,   370,
     817,   215,   375,   819,   821,   301,   824,   146,   782,   147,
     825,    36,   829,   144,   827,    38,     8,   464,   831,   832,
     845,   833,   844,   401,   402,   145,   848,   851,   864,   260,
     264,   146,   856,   147,   865,     8,   530,   269,   171,    60,
       8,   269,   866,   873,   875,   293,   669,   755,   293,   293,
     301,   520,   657,   841,    36,   293,   555,   670,    38,   346,
     293,   674,   548,     8,    36,   675,   855,   340,    38,   301,
     514,   293,   531,   438,   301,   532,   266,   737,   215,   622,
     632,   474,   293,   337,   146,   158,   147,   746,   342,   293,
     839,   293,   813,    72,    73,    74,   854,   356,    76,   846,
     133,   660,   370,   370,   814,     0,   457,     0,   269,    36,
     269,     8,     8,    38,   463,     0,     0,     0,     0,     0,
      90,   700,     0,   215,     0,   476,     0,   533,    36,   146,
       0,   147,    38,    36,   370,   378,   379,    38,     0,   381,
     382,   383,   215,   385,   386,   763,   141,   215,   146,     8,
     147,     8,     0,   146,     0,   147,    36,     8,   500,     0,
      38,   408,   204,   143,   411,     0,     0,     0,     0,     0,
     215,     0,   269,   269,     0,     0,   146,     0,   147,   740,
       0,     0,     0,   265,     0,   348,     0,     0,     0,   218,
       0,   301,     0,   218,     8,     0,     8,     0,     0,     0,
     143,     0,   762,     0,    36,    36,     0,     0,    38,    38,
       0,     0,   370,   218,   269,     0,     0,   269,   215,   373,
       0,     0,     0,     0,   146,     0,   147,   147,   348,   171,
     265,     0,     0,   623,   223,   224,   225,   226,   227,   228,
     229,     0,    36,     0,    36,   155,    38,   143,    38,     0,
      36,     0,     0,     0,    38,     0,   373,     0,   415,     0,
     269,   388,     0,   482,   266,     0,   266,     0,   269,     0,
       0,     0,   147,     0,     0,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   497,   498,     0,    36,     0,    36,
     505,    38,     0,    38,     0,   517,     0,   293,   522,   218,
       0,   510,     0,   510,     0,   529,   536,   539,     0,   266,
       0,   266,   389,   390,   391,   392,   393,   394,   395,   396,
     397,   398,   399,     0,   293,     0,   269,     0,     0,     0,
     567,     0,     0,   218,     8,     0,     0,   171,     0,     0,
       0,     0,   223,   224,   225,   226,   227,   228,   229,     0,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,   250,   626,
     492,   498,     0,     0,     0,     0,   702,    28,    29,    30,
      31,    32,     0,   251,     0,     0,   252,   391,   392,   393,
     394,   395,   396,   397,   398,   399,    33,    34,    35,   483,
     291,     0,     0,   171,     0,     0,   218,     0,   223,   224,
     225,   226,   227,   228,   229,   218,   536,     0,   834,     0,
       0,     0,     0,   655,     0,   536,     0,    36,     0,     0,
       0,    38,   392,   393,   394,   395,   396,   397,   398,   399,
     218,   253,     0,     0,   254,   255,     0,   256,   257,   258,
       0,     0,     0,     0,     0,   218,     0,     0,   218,   767,
       0,     0,     0,     0,   774,     0,     0,   389,   390,   391,
     392,   484,   394,   395,   396,   397,   398,   485,     0,     0,
       0,     0,     0,   218,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,     0,     0,     0,   218,   390,
     391,   392,   393,   394,   395,   396,   397,   398,   399,   795,
       7,     0,     8,   709,   293,   293,   710,     0,     0,     0,
     536,   463,   721,     0,   293,     0,     0,     0,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,   393,   394,   395,   396,
     397,   398,   399,     0,    27,    28,    29,    30,    31,    32,
     394,   395,   396,   397,   398,   399,   745,     0,     0,   218,
       0,     0,   840,   218,    33,    34,    35,     0,     0,     0,
       0,     0,   795,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   218,     0,     0,   581,   776,  -453,    56,
       0,   536,     0,     0,    59,    36,     0,     0,    37,    38,
       0,     0,     0,    60,  -453,  -453,  -453,  -453,  -453,  -453,
    -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,
    -453,  -453,     0,     0,     0,   582,    62,     0,     0,  -453,
       0,  -453,  -453,  -453,  -453,  -453,     0,     0,     0,     0,
     809,     0,    64,    65,    66,    67,   583,    69,    70,    71,
    -453,  -453,  -453,   584,   585,   586,     0,    72,   587,    74,
       0,    75,    76,    77,     0,     0,     0,    81,     0,    83,
      84,    85,    86,    87,    88,     0,     0,     0,     0,    89,
       0,  -453,     0,     0,    90,  -453,  -453,     0,     8,     0,
       0,   171,     0,     0,     0,     0,   223,   224,   225,   226,
     227,   228,   229,   588,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,   250,     0,     0,     0,     0,     0,     0,     0,
       0,    28,    29,    30,    31,    32,     0,   251,     0,     0,
     407,     0,     0,     0,     0,     8,     0,     0,   171,     0,
      33,    34,    35,   223,   224,   225,   226,   227,   228,   229,
     507,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,   250,
       0,    36,     0,     0,     0,    38,     0,     0,    28,    29,
      30,    31,    32,     0,   251,   253,     0,   410,   254,   255,
       0,   256,   257,   258,     0,     0,     0,    33,    34,    35,
       0,   389,   390,   391,   392,   393,   394,   395,   396,   397,
     398,   399,     0,     0,     0,     0,     0,     0,     0,     0,
       9,    10,    11,    12,    13,    14,    15,    16,    36,    18,
       0,    20,    38,     0,    23,    24,    25,    26,     0,     0,
       0,     0,   253,     0,     8,   254,   255,   171,   256,   257,
     258,     0,   223,   224,   225,   226,   227,   228,   229,     0,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,   250,     0,
       0,     0,     0,     0,     0,     0,     0,    28,    29,    30,
      31,    32,     0,   251,     0,     0,   504,     0,     0,     0,
       0,     8,     0,     0,   171,     0,    33,    34,    35,   223,
     224,   225,   226,   227,   228,   229,   509,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,   250,   627,    36,     0,     0,
       0,    38,     0,     0,    28,    29,    30,    31,    32,     0,
     251,   253,     0,     0,   254,   255,     0,   256,   257,   258,
       0,     0,     0,    33,    34,    35,     0,   389,   390,   391,
     392,   393,   394,   395,   396,   397,   398,   399,   389,   390,
     391,   392,   393,   394,   395,   396,   397,   398,   399,     0,
       0,     0,     0,     0,    36,     0,     0,     0,    38,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   253,     0,
       8,   254,   255,   171,   256,   257,   258,   743,   223,   224,
     225,   226,   227,   228,   229,     0,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,   250,     0,     0,     0,     0,     0,
       0,     0,     0,    28,    29,    30,    31,    32,     0,   251,
       0,     0,     0,     0,     0,     0,     0,     8,     0,     0,
     171,     0,    33,    34,    35,   223,   224,   225,   226,   227,
     228,   229,   625,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,   250,     0,    36,     0,     0,     0,    38,     0,     0,
      28,    29,    30,    31,    32,     0,   251,   253,     0,     0,
     254,   255,     0,   256,   257,   258,     0,     0,     0,    33,
      34,    35,     0,   389,   390,   391,   392,   393,   394,   395,
     396,   397,   398,   399,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      36,     0,     0,     0,    38,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   253,     0,     8,   254,   255,   171,
     256,   257,   258,     0,   223,   224,   225,   226,   227,   228,
     229,     0,     9,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
     250,     0,     0,     0,     0,     0,     0,     0,     0,    28,
      29,    30,    31,    32,     0,   251,     0,     0,     0,     0,
       0,     0,     8,     0,     0,     0,     0,     0,    33,    34,
      35,     0,     0,     0,     0,     0,   636,     0,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,   240,     0,     0,    36,
       0,     0,     0,    38,    27,    28,    29,    30,    31,    32,
       0,     0,     0,   143,     0,     0,   254,   255,     0,   628,
     257,   258,     0,     0,    33,    34,    35,   389,   390,   391,
     392,   393,   394,   395,   396,   397,   398,   399,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    36,     0,     0,    37,    38,
       8,     0,     0,     0,     0,     0,     0,     0,     0,   241,
       0,     0,     0,     0,     0,   146,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,   240,     0,     0,     0,     0,     0,
       0,     0,    27,    28,    29,    30,    31,    32,     0,     0,
       0,   143,     0,     0,     0,     0,     8,     0,     0,     0,
       0,     0,    33,    34,    35,     0,     0,     0,     0,     0,
       0,     0,     9,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
       0,     0,     0,    36,     0,     0,    37,    38,    27,    28,
      29,    30,    31,    32,     0,     0,     0,   366,     8,     0,
       0,     0,     0,   146,     0,     0,     0,     0,    33,    34,
      35,     0,     0,     0,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,     0,     0,     0,     0,     0,     0,     0,    36,
       0,     0,    37,    38,    31,    32,     0,     0,     0,     0,
       0,     0,     0,   344,     0,     0,     0,     0,     0,   146,
      33,    34,    35,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    36,     0,     0,     0,    38,    -2,    55,     0,  -453,
      56,     0,     0,    57,    58,    59,     0,     0,     0,     0,
       0,   146,     0,     0,    60,  -453,  -453,  -453,  -453,  -453,
    -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,
    -453,  -453,  -453,     0,     0,     0,    61,    62,     0,     0,
       0,     0,  -453,  -453,  -453,  -453,  -453,     0,     0,    63,
       0,     0,     0,    64,    65,    66,    67,    68,    69,    70,
      71,  -453,  -453,  -453,     0,     0,     0,     0,    72,    73,
      74,     0,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,     0,     0,     0,     0,
      89,    55,  -453,  -453,    56,    90,  -453,    57,    58,    59,
       0,     0,     0,     0,     0,     0,     0,     0,    60,  -453,
    -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,
    -453,  -453,  -453,  -453,  -453,  -453,  -453,     0,     0,     0,
      61,    62,     0,     0,   546,     0,  -453,  -453,  -453,  -453,
    -453,     0,     0,    63,     0,     0,     0,    64,    65,    66,
      67,    68,    69,    70,    71,  -453,  -453,  -453,     0,     0,
       0,     0,    72,    73,    74,     0,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
       0,     0,     0,     0,    89,    55,  -453,  -453,    56,    90,
    -453,    57,    58,    59,     0,     0,     0,     0,     0,     0,
       0,     0,    60,  -453,  -453,  -453,  -453,  -453,  -453,  -453,
    -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,
    -453,     0,     0,     0,    61,    62,     0,     0,   638,     0,
    -453,  -453,  -453,  -453,  -453,     0,     0,    63,     0,     0,
       0,    64,    65,    66,    67,    68,    69,    70,    71,  -453,
    -453,  -453,     0,     0,     0,     0,    72,    73,    74,     0,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,     0,     0,     0,     0,    89,    55,
    -453,  -453,    56,    90,  -453,    57,    58,    59,     0,     0,
       0,     0,     0,     0,     0,     0,    60,  -453,  -453,  -453,
    -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,
    -453,  -453,  -453,  -453,  -453,     0,     0,     0,    61,    62,
       0,     0,   654,     0,  -453,  -453,  -453,  -453,  -453,     0,
       0,    63,     0,     0,     0,    64,    65,    66,    67,    68,
      69,    70,    71,  -453,  -453,  -453,     0,     0,     0,     0,
      72,    73,    74,     0,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,     0,     0,
       0,     0,    89,    55,  -453,  -453,    56,    90,  -453,    57,
      58,    59,     0,     0,     0,     0,     0,     0,     0,     0,
      60,  -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,
    -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,  -453,     0,
       0,     0,    61,    62,     0,     0,     0,     0,  -453,  -453,
    -453,  -453,  -453,     0,     0,    63,     0,   741,     0,    64,
      65,    66,    67,    68,    69,    70,    71,  -453,  -453,  -453,
       0,     0,     0,     0,    72,    73,    74,     0,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    50,     0,     8,     0,    89,     0,  -453,     0,
       0,    90,  -453,     0,     0,     0,     0,     0,     0,     0,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,     0,     0,
       0,     0,     0,     0,     0,     0,    27,    28,    29,    30,
      31,    32,     0,     0,     0,     0,     0,   176,     0,   177,
       0,     0,     0,     0,     0,     0,    33,    34,    35,     0,
       0,     0,     0,     0,     0,     9,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,     0,     0,     0,     0,    36,     0,     0,
      37,    38,    28,    29,    30,    31,    32,     0,     0,     0,
       0,     0,     0,     0,     8,     0,     0,     0,     0,     0,
       0,    33,    34,    35,     0,     0,     0,     0,     0,     0,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,     0,     0,
       0,     0,    36,     0,     0,     0,    38,    28,    29,    30,
      31,    32,     0,     0,     0,     0,     0,     0,     0,     0,
       8,     0,     0,     0,     0,     0,   219,    34,    35,     0,
       0,     0,     0,     0,     0,     0,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,     0,     0,     0,    36,     0,     0,
       0,    38,   699,    28,    29,    30,    31,    32,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     8,     0,     0,
     222,     0,    33,    34,    35,   223,   224,   225,   226,   227,
     228,   229,     0,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,     0,     0,    36,     0,     0,     0,    38,   699,    27,
      28,    29,    30,    31,    32,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     8,     0,     0,     0,     0,    33,
      34,    35,   309,     0,     0,     0,     0,     0,     0,     0,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,     0,     0,
      36,     0,     0,    37,    38,     0,    27,    28,    29,    30,
      31,    32,     0,     0,     0,     0,     0,     0,     0,     0,
       8,     0,     0,     0,     0,     0,    33,    34,    35,     0,
       0,     0,     0,     0,     0,     0,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,     0,     0,     0,    36,     0,     0,
      37,    38,    27,    28,    29,    30,    31,    32,     0,     0,
       0,     0,     0,     0,     0,     8,     0,     0,     0,     0,
       0,     0,    33,    34,    35,     0,     0,     0,     0,     0,
       0,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,   202,
       0,     0,     0,    36,     0,     0,    37,    38,    28,    29,
      30,    31,    32,     0,     0,     0,     0,     0,     0,     0,
       8,     0,     0,     0,     0,     0,     0,    33,    34,    35,
       0,     0,     0,     0,     0,     0,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,     0,     0,     0,     0,    36,     0,
       0,     0,    38,    28,    29,    30,    31,    32,     0,     0,
       0,     0,     0,     0,     0,     8,     0,     0,     0,     0,
       0,     0,   219,    34,    35,     0,     0,     0,     0,     0,
       0,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,     0,
       0,     0,     0,    36,     0,     0,     0,    38,    28,    29,
      30,    31,    32,     0,     0,     0,     0,     0,     0,     0,
     656,     0,     0,     0,     0,     0,     0,    33,    34,    35,
       0,     0,     0,     0,     0,     0,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,     0,     0,     0,     0,    36,     0,
       0,     0,    38,    28,    29,    30,    31,    32,     0,     8,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    33,    34,    35,     9,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    36,     0,    31,    32,    38,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    33,    34,    35,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    36,     0,     0,     0,    38
};

static const short yycheck[] =
{
       0,    40,     1,     2,     5,     5,   196,    42,     8,   300,
       5,     5,    84,    41,     5,    43,   316,    42,   541,     5,
       5,    21,   432,   540,   214,   241,     5,   323,   244,   526,
       1,     2,   136,     6,    51,     5,     4,     3,     6,    90,
       3,     5,    42,   150,     5,   152,     3,     5,     3,     6,
       3,   170,     6,     6,    38,   174,   160,   161,     3,     5,
      38,   180,     5,    63,    38,     5,   185,     3,    68,    69,
      51,     5,   154,    90,     1,   535,   238,   128,    51,     5,
       5,     3,    53,   543,   109,     5,   137,   145,   207,    37,
      71,     3,    37,   130,     3,     5,   154,   216,    90,     6,
      54,   101,     5,     5,     0,     3,   566,    45,     6,    54,
      37,   139,   609,   573,    53,   120,    79,     3,   146,    97,
       3,   421,   645,    97,   286,    40,   110,     4,   344,   345,
     130,   130,     3,    96,   100,   217,    43,   100,    43,    37,
     440,    96,     4,    96,     6,   100,   442,   100,     3,     3,
     150,    96,   152,   178,    37,   100,    51,   110,    90,   130,
     376,   116,   110,   116,   100,   110,    43,   167,   116,   204,
     141,   116,    43,   118,    42,    90,    71,   177,   100,   204,
      75,    43,    37,   241,    96,    90,   244,     3,   100,    43,
     190,   100,   652,   690,     4,   302,     6,   279,    96,    54,
       3,   283,   100,   726,   204,   722,   206,   207,     3,     6,
      96,   708,   110,    96,   100,   186,   187,   100,   116,   219,
     118,   279,    39,    51,   110,    96,    43,   110,     4,   100,
     116,   202,   422,   233,     3,   118,    40,   647,   454,   210,
     211,    96,    96,    40,     6,   100,   100,   186,   187,    10,
     357,     3,    68,    69,    70,   110,     4,   329,     6,   449,
      40,   758,    90,   202,   724,   565,    68,    43,   350,   240,
     352,   210,    40,   141,    43,    43,    40,    40,   146,    43,
      96,    43,    43,   748,   100,    37,     3,     3,    40,   288,
     755,    71,    40,    96,   265,    43,   761,   100,    39,   101,
      40,    96,   302,   274,    98,   100,   277,    71,   366,   367,
      51,     3,    98,   432,   365,   373,   316,   288,   400,   101,
      37,    37,    90,   783,   361,    40,   120,    96,    43,   357,
     827,   100,   414,   415,   120,   274,   204,    54,   277,    46,
      47,    48,   400,   343,    96,    37,   214,    95,   100,    37,
      37,    38,     4,   353,     6,    71,   414,   357,   110,   359,
     467,   733,   361,   735,   116,    37,   118,    54,    90,   829,
      37,    38,   240,   833,   456,    97,    98,   459,   843,    96,
      96,    37,    54,   100,   100,   356,   423,    54,    40,    40,
     361,    43,    43,   684,   110,   432,     6,   265,   120,    51,
     116,   118,   118,   271,    96,    37,   431,    37,   100,   116,
     435,    39,    37,    46,    47,    48,    44,   356,   110,   419,
     502,   421,   480,    37,   116,    37,   118,    45,   510,    54,
     455,    37,   403,   301,    40,   434,    18,    43,   439,   439,
     440,   441,    75,    37,   439,   439,   446,   441,   439,   639,
     640,   450,   487,   439,   439,    40,    37,   485,    43,    41,
     439,   461,   487,   434,   403,    49,    50,   467,   468,   439,
      38,    39,    37,     3,   474,   439,     6,    64,   439,   450,
     348,   439,    66,    67,   588,    37,   568,   487,   356,    54,
      72,    73,    74,   439,    37,    77,   439,    84,    85,   439,
      38,    39,    54,    49,    50,   439,    90,   535,    38,    40,
      37,   379,    43,   439,   439,   543,   541,   518,   518,   439,
      66,    67,    37,   518,   518,    37,   526,   518,    97,   439,
     649,    40,   518,   518,    43,   535,   439,   439,   566,   518,
       3,   128,    51,   543,    38,   573,   547,   547,   518,    39,
     575,    40,   547,   547,   518,     3,   547,   518,   115,   116,
     518,   547,   547,   564,   564,   565,   566,   618,   547,   564,
     564,     3,   518,   573,    40,   518,    43,   547,   518,   870,
       3,   688,   553,   547,   518,     3,   547,   659,    43,   547,
     629,   695,   518,   518,    37,    38,    38,    39,   518,     6,
     628,   547,    40,   574,   547,    97,    39,   547,   518,   609,
     647,    54,     3,   547,   553,   518,   518,   485,    91,   487,
     620,   547,   547,   648,   652,   676,    39,   547,    38,   666,
      39,    40,   657,    91,    43,   574,    38,   547,    37,    38,
      37,    37,    38,    97,   547,   547,    37,   754,   851,    46,
      47,    48,   652,    54,    51,    54,   656,   682,    54,    37,
     688,   864,   865,    54,   116,    37,   666,   666,   102,   103,
     104,   642,   697,    46,    47,    48,   677,   677,    75,    40,
      97,   681,   677,   677,    38,   685,   677,     3,   688,    38,
     690,   677,   677,   800,    38,   666,   724,    10,   677,    38,
     725,    33,    43,   642,    51,    96,    39,   677,   708,   100,
      42,    38,   683,   677,    38,    47,   677,    40,   689,   677,
      91,    37,    97,    38,   724,    44,    38,   118,    38,    38,
      38,   677,    38,    38,   677,    97,   323,   677,    54,    40,
      43,    97,   329,   677,   683,    77,    78,   718,    38,    97,
     689,   677,   677,    38,   754,   783,    40,   677,   758,    40,
     628,   629,    38,    43,    37,   765,    40,   677,    40,   769,
      40,     3,    38,   773,   677,   677,    37,   109,    43,   718,
      96,    38,    37,   783,   100,    39,   811,    39,    51,   760,
     815,   120,   763,   380,   110,   113,   114,   115,   116,    90,
     800,   829,   118,    38,     3,   833,    44,    51,   779,   141,
     835,   811,   812,   145,    37,   147,    43,    73,    71,   118,
     848,   760,   154,   851,   763,    71,    71,   827,     3,   829,
      44,   802,    44,   833,   805,   835,   864,   865,    37,    44,
     779,    40,    38,    38,    37,    75,   178,    62,   848,   181,
      38,   851,    38,    40,     3,   442,   188,    40,    71,    38,
     831,   832,    37,   802,   864,   865,   805,    37,    83,    40,
      39,     3,   204,    88,    38,    37,    51,    40,    39,    54,
     212,     3,   214,   215,    40,   217,    38,   219,   220,   221,
      91,    38,   831,   832,   762,   763,    71,    96,    46,    47,
      48,   100,    40,    51,    37,    37,    40,    44,   240,   241,
      38,   110,   244,    40,    40,    37,    39,   116,    40,   118,
      37,    96,    38,    71,    44,   100,     3,    75,    37,    37,
      40,    38,    38,   265,   266,   110,    38,    38,    38,   143,
     144,   116,    40,   118,    38,     3,     4,   279,     6,    18,
       3,   283,    40,    40,    40,   170,   564,   688,   173,   174,
      37,   423,   549,    40,    96,   180,   446,   564,   100,   301,
     185,   564,    41,     3,    96,   564,   835,   211,   100,    37,
     419,   196,    40,   315,    37,    43,   118,   666,   110,   474,
     487,   361,   207,   208,   116,    46,   118,   681,   213,   214,
     812,   216,   769,    72,    73,    74,   833,    37,    77,   824,
      21,   550,   344,   345,   773,    -1,   348,    -1,   350,    96,
     352,     3,     3,   100,   356,    -1,    -1,    -1,    -1,    -1,
      99,   618,    -1,   110,    -1,   367,    -1,    95,    96,   116,
      -1,   118,   100,    96,   376,   249,   250,   100,    -1,   253,
     254,   255,   110,   257,   258,    37,    37,   110,   116,     3,
     118,     3,    -1,   116,    -1,   118,    96,     3,   400,    -1,
     100,   275,   659,    54,   278,    -1,    -1,    -1,    -1,    -1,
     110,    -1,   414,   415,    -1,    -1,   116,    -1,   118,   676,
      -1,    -1,    -1,    37,    -1,    37,    -1,    -1,    -1,   431,
      -1,    37,    -1,   435,     3,    -1,     3,    -1,    -1,    -1,
      54,    -1,   699,    -1,    96,    96,    -1,    -1,   100,   100,
      -1,    -1,   454,   455,   456,    -1,    -1,   459,   110,   110,
      -1,    -1,    -1,    -1,   116,    -1,   118,   118,    37,     6,
      37,    -1,    -1,   475,    11,    12,    13,    14,    15,    16,
      17,    -1,    96,    -1,    96,   487,   100,    54,   100,    -1,
      96,    -1,    -1,    -1,   100,    -1,   110,    -1,   110,    -1,
     502,    55,    -1,   377,   118,    -1,   118,    -1,   510,    -1,
      -1,    -1,   118,    -1,    -1,   389,   390,   391,   392,   393,
     394,   395,   396,   397,   398,   399,    -1,    96,    -1,    96,
     404,   100,    -1,   100,    -1,   420,    -1,   422,   423,   541,
      -1,   110,    -1,   110,    -1,   430,   431,   432,    -1,   118,
      -1,   118,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,    -1,   449,    -1,   568,    -1,    -1,    -1,
     455,    -1,    -1,   575,     3,    -1,    -1,     6,    -1,    -1,
      -1,    -1,    11,    12,    13,    14,    15,    16,    17,    -1,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,   483,
     484,   485,    -1,    -1,    -1,    -1,   618,    46,    47,    48,
      49,    50,    -1,    52,    -1,    -1,    55,   108,   109,   110,
     111,   112,   113,   114,   115,   116,    65,    66,    67,    38,
       3,    -1,    -1,     6,    -1,    -1,   648,    -1,    11,    12,
      13,    14,    15,    16,    17,   657,   541,    -1,    40,    -1,
      -1,    -1,    -1,   548,    -1,   550,    -1,    96,    -1,    -1,
      -1,   100,   109,   110,   111,   112,   113,   114,   115,   116,
     682,   110,    -1,    -1,   113,   114,    -1,   116,   117,   118,
      -1,    -1,    -1,    -1,    -1,   697,    -1,    -1,   700,   701,
      -1,    -1,    -1,    -1,   706,    -1,    -1,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,    -1,    -1,
      -1,    -1,    -1,   725,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,    -1,    -1,    -1,   740,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   751,
       1,    -1,     3,   627,   639,   640,   630,    -1,    -1,    -1,
     645,   763,   647,    -1,   649,    -1,    -1,    -1,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,   110,   111,   112,   113,
     114,   115,   116,    -1,    45,    46,    47,    48,    49,    50,
     111,   112,   113,   114,   115,   116,   680,    -1,    -1,   811,
      -1,    -1,   814,   815,    65,    66,    67,    -1,    -1,    -1,
      -1,    -1,   824,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   835,    -1,    -1,     1,   711,     3,     4,
      -1,   726,    -1,    -1,     9,    96,    -1,    -1,    99,   100,
      -1,    -1,    -1,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    -1,    40,    41,    -1,    -1,    44,
      -1,    46,    47,    48,    49,    50,    -1,    -1,    -1,    -1,
     764,    -1,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    -1,    72,    73,    74,
      -1,    76,    77,    78,    -1,    -1,    -1,    82,    -1,    84,
      85,    86,    87,    88,    89,    -1,    -1,    -1,    -1,    94,
      -1,    96,    -1,    -1,    99,   100,   101,    -1,     3,    -1,
      -1,     6,    -1,    -1,    -1,    -1,    11,    12,    13,    14,
      15,    16,    17,   118,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    47,    48,    49,    50,    -1,    52,    -1,    -1,
      55,    -1,    -1,    -1,    -1,     3,    -1,    -1,     6,    -1,
      65,    66,    67,    11,    12,    13,    14,    15,    16,    17,
      55,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    46,    47,
      48,    49,    50,    -1,    52,   110,    -1,    55,   113,   114,
      -1,   116,   117,   118,    -1,    -1,    -1,    65,    66,    67,
      -1,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      19,    20,    21,    22,    23,    24,    25,    26,    96,    28,
      -1,    30,   100,    -1,    33,    34,    35,    36,    -1,    -1,
      -1,    -1,   110,    -1,     3,   113,   114,     6,   116,   117,
     118,    -1,    11,    12,    13,    14,    15,    16,    17,    -1,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    46,    47,    48,
      49,    50,    -1,    52,    -1,    -1,    55,    -1,    -1,    -1,
      -1,     3,    -1,    -1,     6,    -1,    65,    66,    67,    11,
      12,    13,    14,    15,    16,    17,    55,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    96,    -1,    -1,
      -1,   100,    -1,    -1,    46,    47,    48,    49,    50,    -1,
      52,   110,    -1,    -1,   113,   114,    -1,   116,   117,   118,
      -1,    -1,    -1,    65,    66,    67,    -1,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,    -1,
      -1,    -1,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   110,    -1,
       3,   113,   114,     6,   116,   117,   118,    10,    11,    12,
      13,    14,    15,    16,    17,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    47,    48,    49,    50,    -1,    52,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,    -1,    -1,
       6,    -1,    65,    66,    67,    11,    12,    13,    14,    15,
      16,    17,    55,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,
      46,    47,    48,    49,    50,    -1,    52,   110,    -1,    -1,
     113,   114,    -1,   116,   117,   118,    -1,    -1,    -1,    65,
      66,    67,    -1,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    -1,    -1,    -1,   100,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   110,    -1,     3,   113,   114,     6,
     116,   117,   118,    -1,    11,    12,    13,    14,    15,    16,
      17,    -1,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    46,
      47,    48,    49,    50,    -1,    52,    -1,    -1,    -1,    -1,
      -1,    -1,     3,    -1,    -1,    -1,    -1,    -1,    65,    66,
      67,    -1,    -1,    -1,    -1,    -1,    55,    -1,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    -1,    -1,    96,
      -1,    -1,    -1,   100,    45,    46,    47,    48,    49,    50,
      -1,    -1,    -1,    54,    -1,    -1,   113,   114,    -1,   116,
     117,   118,    -1,    -1,    65,    66,    67,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    -1,    -1,    99,   100,
       3,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   110,
      -1,    -1,    -1,    -1,    -1,   116,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    45,    46,    47,    48,    49,    50,    -1,    -1,
      -1,    54,    -1,    -1,    -1,    -1,     3,    -1,    -1,    -1,
      -1,    -1,    65,    66,    67,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    -1,    96,    -1,    -1,    99,   100,    45,    46,
      47,    48,    49,    50,    -1,    -1,    -1,   110,     3,    -1,
      -1,    -1,    -1,   116,    -1,    -1,    -1,    -1,    65,    66,
      67,    -1,    -1,    -1,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      -1,    -1,    99,   100,    49,    50,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   110,    -1,    -1,    -1,    -1,    -1,   116,
      65,    66,    67,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    -1,    -1,    -1,   100,     0,     1,    -1,     3,
       4,    -1,    -1,     7,     8,     9,    -1,    -1,    -1,    -1,
      -1,   116,    -1,    -1,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    -1,    40,    41,    -1,    -1,
      -1,    -1,    46,    47,    48,    49,    50,    -1,    -1,    53,
      -1,    -1,    -1,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    -1,    -1,    -1,    -1,    72,    73,
      74,    -1,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    -1,    -1,    -1,
      94,     1,    96,     3,     4,    99,   100,     7,     8,     9,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    -1,
      40,    41,    -1,    -1,    44,    -1,    46,    47,    48,    49,
      50,    -1,    -1,    53,    -1,    -1,    -1,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    72,    73,    74,    -1,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    -1,    94,     1,    96,     3,     4,    99,
     100,     7,     8,     9,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    -1,    40,    41,    -1,    -1,    44,    -1,
      46,    47,    48,    49,    50,    -1,    -1,    53,    -1,    -1,
      -1,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    -1,    -1,    -1,    -1,    72,    73,    74,    -1,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    -1,    94,     1,
      96,     3,     4,    99,   100,     7,     8,     9,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    -1,    40,    41,
      -1,    -1,    44,    -1,    46,    47,    48,    49,    50,    -1,
      -1,    53,    -1,    -1,    -1,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    -1,    -1,    -1,    -1,
      72,    73,    74,    -1,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    -1,
      -1,    -1,    94,     1,    96,     3,     4,    99,   100,     7,
       8,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    -1,    40,    41,    -1,    -1,    -1,    -1,    46,    47,
      48,    49,    50,    -1,    -1,    53,    -1,    55,    -1,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      -1,    -1,    -1,    -1,    72,    73,    74,    -1,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,     1,    -1,     3,    -1,    94,    -1,    96,    -1,
      -1,    99,   100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,
      49,    50,    -1,    -1,    -1,    -1,    -1,     1,    -1,     3,
      -1,    -1,    -1,    -1,    -1,    -1,    65,    66,    67,    -1,
      -1,    -1,    -1,    -1,    -1,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    -1,    -1,    96,    -1,    -1,
      99,   100,    46,    47,    48,    49,    50,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     3,    -1,    -1,    -1,    -1,    -1,
      -1,    65,    66,    67,    -1,    -1,    -1,    -1,    -1,    -1,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      -1,    -1,    96,    -1,    -1,    -1,   100,    46,    47,    48,
      49,    50,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       3,    -1,    -1,    -1,    -1,    -1,    65,    66,    67,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    -1,    96,    -1,    -1,
      -1,   100,   101,    46,    47,    48,    49,    50,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,    -1,    -1,
       6,    -1,    65,    66,    67,    11,    12,    13,    14,    15,
      16,    17,    -1,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    96,    -1,    -1,    -1,   100,   101,    45,
      46,    47,    48,    49,    50,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     3,    -1,    -1,    -1,    -1,    65,
      66,    67,    11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      96,    -1,    -1,    99,   100,    -1,    45,    46,    47,    48,
      49,    50,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       3,    -1,    -1,    -1,    -1,    -1,    65,    66,    67,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    -1,    96,    -1,    -1,
      99,   100,    45,    46,    47,    48,    49,    50,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     3,    -1,    -1,    -1,    -1,
      -1,    -1,    65,    66,    67,    -1,    -1,    -1,    -1,    -1,
      -1,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      -1,    -1,    -1,    96,    -1,    -1,    99,   100,    46,    47,
      48,    49,    50,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       3,    -1,    -1,    -1,    -1,    -1,    -1,    65,    66,    67,
      -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    -1,    -1,    96,    -1,
      -1,    -1,   100,    46,    47,    48,    49,    50,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     3,    -1,    -1,    -1,    -1,
      -1,    -1,    65,    66,    67,    -1,    -1,    -1,    -1,    -1,
      -1,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    -1,    -1,    96,    -1,    -1,    -1,   100,    46,    47,
      48,    49,    50,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       3,    -1,    -1,    -1,    -1,    -1,    -1,    65,    66,    67,
      -1,    -1,    -1,    -1,    -1,    -1,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    -1,    -1,    96,    -1,
      -1,    -1,   100,    46,    47,    48,    49,    50,    -1,     3,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    65,    66,    67,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    -1,    49,    50,   100,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    65,    66,    67,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    -1,    -1,    -1,   100
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short yystos[] =
{
       0,   102,   103,   104,   122,   123,   263,     1,     3,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    45,    46,    47,
      48,    49,    50,    65,    66,    67,    96,    99,   100,   206,
     220,   221,   223,   224,   225,   226,   227,   243,   253,   255,
       1,   206,     1,    37,     0,     1,     4,     7,     8,     9,
      18,    40,    41,    53,    57,    58,    59,    60,    61,    62,
      63,    64,    72,    73,    74,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    94,
      99,   124,   125,   126,   128,   129,   130,   131,   132,   135,
     136,   138,   139,   140,   141,   142,   143,   144,   147,   148,
     149,   152,   154,   159,   160,   161,   162,   164,   167,   168,
     169,   170,   171,   175,   176,   180,   181,   191,   202,   263,
      90,   250,   263,   250,    45,   253,   120,    90,    40,   224,
     220,    37,    51,    54,    71,   110,   116,   118,   211,   212,
     214,   216,   217,   218,   219,   253,   263,   220,   226,   253,
      98,   120,   254,    40,    40,   203,   204,   206,   263,   101,
      37,     6,   258,    37,   260,   263,     1,     3,   222,   223,
      37,   260,    37,   146,   263,    37,    37,    37,    79,   253,
       3,    43,   253,    37,     4,    43,    37,    37,    40,    43,
       4,   258,    37,   158,   222,   156,   158,    37,    37,   258,
      37,    90,   243,   260,    37,   110,   214,   219,   253,    65,
     222,   243,     6,    11,    12,    13,    14,    15,    16,    17,
     206,   207,   208,   210,   235,   263,    45,   100,   255,   243,
      37,   110,   203,   217,   219,   253,    10,    43,   228,   229,
      37,    52,    55,   110,   113,   114,   116,   117,   118,   222,
     234,   235,   236,   258,   234,    37,   118,   215,   218,   253,
     219,   220,   253,   211,    37,    54,   211,    37,    54,   110,
     215,   218,   253,    97,   255,   100,   255,    38,    39,   205,
     263,     3,   251,   258,     6,    43,   251,   261,   251,    40,
      51,    37,   214,    38,   251,   253,     3,     3,   251,    11,
     153,   203,   203,   253,    40,    51,   183,    43,     3,   155,
     261,     3,   203,    43,   213,   214,   217,   263,    40,    39,
     157,   263,   251,   252,   263,   133,   134,   258,   203,   179,
     204,   253,   258,     3,   110,   219,   253,   261,    37,   251,
     110,   253,    97,     3,   230,   263,    37,   214,    43,   253,
      91,    39,   209,   263,   254,    91,   110,   219,   253,   216,
     253,    38,    38,   110,   216,   253,    97,    54,   234,   234,
      37,   234,   234,   234,   234,   234,   234,    37,    55,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     219,   253,   253,    37,    54,   219,   203,    55,   234,   203,
      55,   234,   215,   218,    97,   110,   215,   254,    40,   206,
      38,   163,    39,    51,    38,   228,   211,    38,    43,    38,
      51,    38,    39,   151,    39,    38,    38,    40,   253,   123,
     182,    38,    38,    38,    38,   156,   158,    38,    38,    39,
      43,    38,    91,    54,    97,    38,   219,   253,    40,    97,
      40,    43,   203,   253,    75,   166,   211,   220,   173,    40,
      71,   237,   238,   263,   210,   243,   253,    97,    38,    38,
      97,   216,   234,    38,   110,   116,   219,   222,   234,   234,
     234,   234,   234,   234,   234,   234,   234,   234,   234,   215,
     253,    38,    97,   203,    55,   234,    38,    55,    38,    55,
     110,   215,   218,   215,   205,     4,    43,   258,   123,   261,
     133,   235,   258,   262,    40,    40,   127,     4,   145,   258,
       4,    40,    43,    95,   150,   214,   258,   259,   251,   258,
     262,    38,   206,   214,    43,    40,    44,   123,    41,   202,
     156,    40,    43,    37,    44,   157,     3,    96,   100,   256,
      40,   261,   206,    40,   177,   137,   214,   258,    97,     3,
     231,   232,   263,    38,    37,    39,    40,    43,   165,    75,
     211,     1,    40,    61,    68,    69,    70,    73,   118,   128,
     129,   130,   131,   135,   140,   142,   144,   147,   149,   152,
     154,   159,   160,   161,   162,   175,   176,   180,   184,   187,
     188,   189,   190,   191,   192,   193,   198,   201,   202,   263,
     239,    43,   209,   253,    38,    55,   234,    38,   116,   220,
      38,   110,   212,    38,   215,    38,    55,   215,    44,    39,
      39,   184,    37,    75,   220,   245,   263,    51,    38,    39,
     151,   150,   214,   245,    44,   258,     3,   222,    40,    51,
     259,   203,    98,   120,   257,   120,    90,    38,    44,   164,
     171,   175,   176,   178,   188,   190,   202,   123,   245,    40,
      51,    39,    44,    37,    51,   245,   246,   203,   214,    37,
     186,    43,    71,    71,    71,   118,   255,    44,   184,   101,
     222,   243,   253,    73,   240,   241,   244,   263,   172,   234,
     234,    38,    38,    38,   261,   261,    44,   203,    37,    75,
     150,   258,   262,    40,   214,    38,   245,    40,    40,   214,
     158,    38,     3,     3,   100,     3,   100,   207,     4,    43,
     222,    55,    40,    10,   233,   234,   232,    40,   214,   203,
     228,    71,   247,   263,    38,   166,   203,   184,   185,   255,
      37,   214,   222,    37,    71,     3,    43,   253,    40,    39,
      68,    69,    70,   242,   253,   184,   234,    38,   203,    37,
     151,   245,    40,   214,   150,    40,    40,   257,   257,    91,
     165,    38,    40,   248,   249,   253,    40,    43,   211,   165,
      38,   184,    37,   203,   165,    37,   110,   219,   203,   234,
      43,   195,    71,   241,   244,    44,    40,    38,   203,    40,
     245,    40,    40,    43,    39,    37,   211,    44,   203,    38,
     203,    37,    37,    38,    40,   194,   197,   214,   263,   240,
     253,    40,   174,   214,    38,    40,   249,   184,    38,   199,
     245,    38,   203,   203,   246,   197,    40,    43,   165,   200,
     245,    40,    43,   200,    38,    38,    40,   196,    40,    43,
      51,   200,   200,    40,   228,    40
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1482 "parser.y"
    {
                   if (!classes) classes = NewHash();
		   Setattr(yyvsp[0].node,"classes",classes); 
		   Setattr(yyvsp[0].node,k_name,ModuleName);
		   
		   if ((!module_node) && ModuleName) {
		     module_node = new_node("module");
		     Setattr(module_node,k_name,ModuleName);
		   }
		   Setattr(yyvsp[0].node,"module",module_node);
		   check_extensions();
	           top = yyvsp[0].node;
               }
    break;

  case 3:
#line 1495 "parser.y"
    {
                 top = Copy(Getattr(yyvsp[-1].p,k_type));
		 Delete(yyvsp[-1].p);
               }
    break;

  case 4:
#line 1499 "parser.y"
    {
                 top = 0;
               }
    break;

  case 5:
#line 1502 "parser.y"
    {
                 top = yyvsp[-1].p;
               }
    break;

  case 6:
#line 1505 "parser.y"
    {
                 top = 0;
               }
    break;

  case 7:
#line 1508 "parser.y"
    {
                 top = yyvsp[-2].pl;
               }
    break;

  case 8:
#line 1511 "parser.y"
    {
                 top = 0;
               }
    break;

  case 9:
#line 1516 "parser.y"
    {  
                   /* add declaration to end of linked list (the declaration isn't always a single declaration, sometimes it is a linked list itself) */
                   appendChild(yyvsp[-1].node,yyvsp[0].node);
                   yyval.node = yyvsp[-1].node;
               }
    break;

  case 10:
#line 1521 "parser.y"
    {
                   yyval.node = new_node("top");
               }
    break;

  case 11:
#line 1526 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 12:
#line 1527 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 13:
#line 1528 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 14:
#line 1529 "parser.y"
    { yyval.node = 0; }
    break;

  case 15:
#line 1530 "parser.y"
    {
                  yyval.node = 0;
		  if (!Swig_error_count()) {
		    Swig_error(cparse_file, cparse_line,"Syntax error in input(1).\n");
		  }
               }
    break;

  case 16:
#line 1537 "parser.y"
    { 
                  if (yyval.node) {
   		      add_symbols(yyval.node);
                  }
                  yyval.node = yyvsp[0].node; 
	       }
    break;

  case 17:
#line 1553 "parser.y"
    {
                  yyval.node = 0;
                  skip_decl();
               }
    break;

  case 18:
#line 1563 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 19:
#line 1564 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 20:
#line 1565 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 21:
#line 1566 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 22:
#line 1567 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 23:
#line 1568 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 24:
#line 1569 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 25:
#line 1570 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 26:
#line 1571 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 27:
#line 1572 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 28:
#line 1573 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 29:
#line 1574 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 30:
#line 1575 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 31:
#line 1576 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 32:
#line 1577 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 33:
#line 1578 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 34:
#line 1579 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 35:
#line 1580 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 36:
#line 1581 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 37:
#line 1582 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 38:
#line 1583 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 39:
#line 1590 "parser.y"
    {
               Node *cls;
	       String *clsname;
	       cplus_mode = CPLUS_PUBLIC;
	       if (!classes) classes = NewHash();
	       if (!extendhash) extendhash = NewHash();
	       clsname = make_class_name(yyvsp[-1].str);
	       cls = Getattr(classes,clsname);
	       if (!cls) {
		 /* No previous definition. Create a new scope */
		 Node *am = Getattr(extendhash,clsname);
		 if (!am) {
		   Swig_symbol_newscope();
		   Swig_symbol_setscopename(yyvsp[-1].str);
		   prev_symtab = 0;
		 } else {
		   prev_symtab = Swig_symbol_setscope(Getattr(am,k_symtab));
		 }
		 current_class = 0;
	       } else {
		 /* Previous class definition.  Use its symbol table */
		 prev_symtab = Swig_symbol_setscope(Getattr(cls,k_symtab));
		 current_class = cls;
		 extendmode = 1;
	       }
	       Classprefix = NewString(yyvsp[-1].str);
	       Namespaceprefix= Swig_symbol_qualifiedscopename(0);
	       Delete(clsname);
	     }
    break;

  case 40:
#line 1618 "parser.y"
    {
               String *clsname;
	       extendmode = 0;
               yyval.node = new_node("extend");
	       Setattr(yyval.node,k_symtab,Swig_symbol_popscope());
	       if (prev_symtab) {
		 Swig_symbol_setscope(prev_symtab);
	       }
	       Namespaceprefix = Swig_symbol_qualifiedscopename(0);
               clsname = make_class_name(yyvsp[-4].str);
	       Setattr(yyval.node,k_name,clsname);

	       /* Mark members as extend */

	       Swig_tag_nodes(yyvsp[-1].node,"feature:extend",(char*) "1");
	       if (current_class) {
		 /* We add the extension to the previously defined class */
		 appendChild(yyval.node,yyvsp[-1].node);
		 appendChild(current_class,yyval.node);
	       } else {
		 /* We store the extensions in the extensions hash */
		 Node *am = Getattr(extendhash,clsname);
		 if (am) {
		   /* Append the members to the previous extend methods */
		   appendChild(am,yyvsp[-1].node);
		 } else {
		   appendChild(yyval.node,yyvsp[-1].node);
		   Setattr(extendhash,clsname,yyval.node);
		 }
	       }
	       current_class = 0;
	       Delete(Classprefix);
	       Delete(clsname);
	       Classprefix = 0;
	       prev_symtab = 0;
	       yyval.node = 0;

	     }
    break;

  case 41:
#line 1662 "parser.y"
    {
                    yyval.node = new_node("apply");
                    Setattr(yyval.node,k_pattern,Getattr(yyvsp[-3].p,k_pattern));
		    appendChild(yyval.node,yyvsp[-1].p);
               }
    break;

  case 42:
#line 1672 "parser.y"
    {
		 yyval.node = new_node("clear");
		 appendChild(yyval.node,yyvsp[-1].p);
               }
    break;

  case 43:
#line 1683 "parser.y"
    {
		   if ((yyvsp[-1].dtype.type != T_ERROR) && (yyvsp[-1].dtype.type != T_SYMBOL)) {
		     SwigType *type = NewSwigType(yyvsp[-1].dtype.type);
		     yyval.node = new_node("constant");
		     Setattr(yyval.node,k_name,yyvsp[-3].id);
		     Setattr(yyval.node,k_type,type);
		     Setattr(yyval.node,k_value,yyvsp[-1].dtype.val);
		     if (yyvsp[-1].dtype.rawval) Setattr(yyval.node,"rawval", yyvsp[-1].dtype.rawval);
		     Setattr(yyval.node,k_storage,"%constant");
		     SetFlag(yyval.node,"feature:immutable");
		     add_symbols(yyval.node);
		     Delete(type);
		   } else {
		     if (yyvsp[-1].dtype.type == T_ERROR) {
		       Swig_warning(WARN_PARSE_UNSUPPORTED_VALUE,cparse_file,cparse_line,"Unsupported constant value (ignored)\n");
		     }
		     yyval.node = 0;
		   }

	       }
    break;

  case 44:
#line 1704 "parser.y"
    {
		 if ((yyvsp[-1].dtype.type != T_ERROR) && (yyvsp[-1].dtype.type != T_SYMBOL)) {
		   SwigType_push(yyvsp[-3].type,yyvsp[-2].decl.type);
		   /* Sneaky callback function trick */
		   if (SwigType_isfunction(yyvsp[-3].type)) {
		     SwigType_add_pointer(yyvsp[-3].type);
		   }
		   yyval.node = new_node("constant");
		   Setattr(yyval.node,k_name,yyvsp[-2].decl.id);
		   Setattr(yyval.node,k_type,yyvsp[-3].type);
		   Setattr(yyval.node,k_value,yyvsp[-1].dtype.val);
		   if (yyvsp[-1].dtype.rawval) Setattr(yyval.node,"rawval", yyvsp[-1].dtype.rawval);
		   Setattr(yyval.node,k_storage,"%constant");
		   SetFlag(yyval.node,"feature:immutable");
		   add_symbols(yyval.node);
		 } else {
		     if (yyvsp[-1].dtype.type == T_ERROR) {
		       Swig_warning(WARN_PARSE_UNSUPPORTED_VALUE,cparse_file,cparse_line,"Unsupported constant value\n");
		     }
		   yyval.node = 0;
		 }
               }
    break;

  case 45:
#line 1726 "parser.y"
    {
		 Swig_warning(WARN_PARSE_BAD_VALUE,cparse_file,cparse_line,"Bad constant value (ignored).\n");
		 yyval.node = 0;
	       }
    break;

  case 46:
#line 1737 "parser.y"
    {
		 char temp[64];
		 Replace(yyvsp[0].str,"$file",cparse_file, DOH_REPLACE_ANY);
		 sprintf(temp,"%d", cparse_line);
		 Replace(yyvsp[0].str,"$line",temp,DOH_REPLACE_ANY);
		 Printf(stderr,"%s\n", yyvsp[0].str);
		 Delete(yyvsp[0].str);
                 yyval.node = 0;
	       }
    break;

  case 47:
#line 1746 "parser.y"
    {
		 char temp[64];
		 String *s = NewString(yyvsp[0].id);
		 Replace(s,"$file",cparse_file, DOH_REPLACE_ANY);
		 sprintf(temp,"%d", cparse_line);
		 Replace(s,"$line",temp,DOH_REPLACE_ANY);
		 Printf(stderr,"%s\n", s);
		 Delete(s);
                 yyval.node = 0;
               }
    break;

  case 48:
#line 1765 "parser.y"
    {
                    skip_balanced('{','}');
		    yyval.node = 0;
		    Swig_warning(WARN_DEPRECATED_EXCEPT,cparse_file, cparse_line, "%%except is deprecated.  Use %%exception instead.\n");
	       }
    break;

  case 49:
#line 1771 "parser.y"
    {
                    skip_balanced('{','}');
		    yyval.node = 0;
		    Swig_warning(WARN_DEPRECATED_EXCEPT,cparse_file, cparse_line, "%%except is deprecated.  Use %%exception instead.\n");
               }
    break;

  case 50:
#line 1777 "parser.y"
    {
		 yyval.node = 0;
		 Swig_warning(WARN_DEPRECATED_EXCEPT,cparse_file, cparse_line, "%%except is deprecated.  Use %%exception instead.\n");
               }
    break;

  case 51:
#line 1782 "parser.y"
    {
		 yyval.node = 0;
		 Swig_warning(WARN_DEPRECATED_EXCEPT,cparse_file, cparse_line, "%%except is deprecated.  Use %%exception instead.\n");
	       }
    break;

  case 52:
#line 1793 "parser.y"
    {		 
                 yyval.node = NewHash();
                 Setattr(yyval.node,k_value,yyvsp[-3].id);
		 Setattr(yyval.node,k_type,Getattr(yyvsp[-1].p,k_type));
               }
    break;

  case 53:
#line 1800 "parser.y"
    {
                 yyval.node = NewHash();
                 Setattr(yyval.node,k_value,yyvsp[0].id);
              }
    break;

  case 54:
#line 1804 "parser.y"
    {
                yyval.node = yyvsp[0].node;
              }
    break;

  case 55:
#line 1809 "parser.y"
    {
                   Hash *p = yyvsp[-2].node;
		   yyval.node = new_node("fragment");
		   Setattr(yyval.node,k_value,Getattr(yyvsp[-4].node,k_value));
		   Setattr(yyval.node,k_type,Getattr(yyvsp[-4].node,k_type));
		   Setattr(yyval.node,k_section,Getattr(p,k_name));
		   Setattr(yyval.node,k_kwargs,nextSibling(p));
		   Setattr(yyval.node,k_code,yyvsp[0].str);
                 }
    break;

  case 56:
#line 1818 "parser.y"
    {
		   Hash *p = yyvsp[-2].node;
		   String *code;
                   skip_balanced('{','}');
		   yyval.node = new_node("fragment");
		   Setattr(yyval.node,k_value,Getattr(yyvsp[-4].node,k_value));
		   Setattr(yyval.node,k_type,Getattr(yyvsp[-4].node,k_type));
		   Setattr(yyval.node,k_section,Getattr(p,k_name));
		   Setattr(yyval.node,k_kwargs,nextSibling(p));
		   Delitem(scanner_ccode,0);
		   Delitem(scanner_ccode,DOH_END);
		   code = Copy(scanner_ccode);
		   Setattr(yyval.node,k_code,code);
		   Delete(code);
                 }
    break;

  case 57:
#line 1833 "parser.y"
    {
		   yyval.node = new_node("fragment");
		   Setattr(yyval.node,k_value,Getattr(yyvsp[-2].node,k_value));
		   Setattr(yyval.node,k_type,Getattr(yyvsp[-2].node,k_type));
		   Setattr(yyval.node,"emitonly","1");
		 }
    break;

  case 58:
#line 1846 "parser.y"
    {
                     yyvsp[-3].loc.filename = Swig_copy_string(cparse_file);
		     yyvsp[-3].loc.line = cparse_line;
		     cparse_file = Swig_copy_string(yyvsp[-1].id);
		     cparse_line = 0;
               }
    break;

  case 59:
#line 1851 "parser.y"
    {
                     String *mname = 0;
                     yyval.node = yyvsp[-1].node;
		     cparse_file = yyvsp[-6].loc.filename;
		     cparse_line = yyvsp[-6].loc.line;
		     if (strcmp(yyvsp[-6].loc.type,"include") == 0) set_nodeType(yyval.node,"include");
		     if (strcmp(yyvsp[-6].loc.type,"import") == 0) {
		       mname = yyvsp[-5].node ? Getattr(yyvsp[-5].node,"module") : 0;
		       set_nodeType(yyval.node,"import");
		       if (import_mode) --import_mode;
		     }
		     
		     Setattr(yyval.node,k_name,yyvsp[-4].id);
		     /* Search for the module (if any) */
		     {
			 Node *n = firstChild(yyval.node);
			 while (n) {
			     if (Strcmp(nodeType(n),"module") == 0) {
			         if (mname) {
				   Setattr(n,k_name, mname);
				   mname = 0;
				 }
				 Setattr(yyval.node,"module",Getattr(n,k_name));
				 break;
			     }
			     n = nextSibling(n);
			 }
			 if (mname) {
			   /* There is no module node in the import
			      node, ie, you imported a .h file
			      directly.  We are forced then to create
			      a new import node with a module node.
			   */			      
			   Node *nint = new_node("import");
			   Node *mnode = new_node("module");
			   Setattr(mnode,k_name, mname);
			   appendChild(nint,mnode);
			   Delete(mnode);
			   appendChild(nint,firstChild(yyval.node));
			   yyval.node = nint;
			   Setattr(yyval.node,"module",mname);
			 }
		     }
		     Setattr(yyval.node,"options",yyvsp[-5].node);
               }
    break;

  case 60:
#line 1898 "parser.y"
    { yyval.loc.type = (char *) "include"; }
    break;

  case 61:
#line 1899 "parser.y"
    { yyval.loc.type = (char *) "import"; ++import_mode;}
    break;

  case 62:
#line 1906 "parser.y"
    {
                 String *cpps;
		 if (Namespaceprefix) {
		   Swig_error(cparse_file, cparse_start_line, "%%inline directive inside a namespace is disallowed.\n");

		   yyval.node = 0;
		 } else {
		   yyval.node = new_node("insert");
		   Setattr(yyval.node,k_code,yyvsp[0].str);
		   /* Need to run through the preprocessor */
		   Setline(yyvsp[0].str,cparse_start_line);
		   Setfile(yyvsp[0].str,cparse_file);
		   Seek(yyvsp[0].str,0,SEEK_SET);
		   cpps = Preprocessor_parse(yyvsp[0].str);
		   start_inline(Char(cpps), cparse_start_line);
		   Delete(yyvsp[0].str);
		   Delete(cpps);
		 }
		 
	       }
    break;

  case 63:
#line 1926 "parser.y"
    {
                 String *cpps;
		 int start_line = cparse_line;
		 skip_balanced('{','}');
		 if (Namespaceprefix) {
		   Swig_error(cparse_file, cparse_start_line, "%%inline directive inside a namespace is disallowed.\n");
		   
		   yyval.node = 0;
		 } else {
		   String *code;
                   yyval.node = new_node("insert");
		   Delitem(scanner_ccode,0);
		   Delitem(scanner_ccode,DOH_END);
		   code = Copy(scanner_ccode);
		   Setattr(yyval.node,k_code, code);
		   Delete(code);		   
		   cpps=Copy(scanner_ccode);
		   start_inline(Char(cpps), start_line);
		   Delete(cpps);
		 }
               }
    break;

  case 64:
#line 1957 "parser.y"
    {
                 yyval.node = new_node("insert");
		 Setattr(yyval.node,k_code,yyvsp[0].str);
	       }
    break;

  case 65:
#line 1961 "parser.y"
    {
		 String *code = NewStringEmpty();
		 yyval.node = new_node("insert");
		 Setattr(yyval.node,k_section,yyvsp[-2].id);
		 Setattr(yyval.node,k_code,code);
		 if (Swig_insert_file(yyvsp[0].id,code) < 0) {
		   Swig_error(cparse_file, cparse_line, "Couldn't find '%s'.\n", yyvsp[0].id);
		   yyval.node = 0;
		 } 
               }
    break;

  case 66:
#line 1971 "parser.y"
    {
		 yyval.node = new_node("insert");
		 Setattr(yyval.node,k_section,yyvsp[-2].id);
		 Setattr(yyval.node,k_code,yyvsp[0].str);
               }
    break;

  case 67:
#line 1976 "parser.y"
    {
		 String *code;
                 skip_balanced('{','}');
		 yyval.node = new_node("insert");
		 Setattr(yyval.node,k_section,yyvsp[-2].id);
		 Delitem(scanner_ccode,0);
		 Delitem(scanner_ccode,DOH_END);
		 code = Copy(scanner_ccode);
		 Setattr(yyval.node,k_code, code);
		 Delete(code);
	       }
    break;

  case 68:
#line 1994 "parser.y"
    {
                 yyval.node = new_node("module");
		 if (yyvsp[-1].node) {
		   Setattr(yyval.node,"options",yyvsp[-1].node);
		   if (Getattr(yyvsp[-1].node,"directors")) {
		     /* Wrapper_director_mode_set(1);*/
		   } 
		   if (Getattr(yyvsp[-1].node,"templatereduce")) {
		     template_reduce = 1;
		   }
		   if (Getattr(yyvsp[-1].node,"notemplatereduce")) {
		     template_reduce = 0;
		   }
		 }
		 if (!ModuleName) ModuleName = NewString(yyvsp[0].id);
		 if (!import_mode) {
		   /* first module included, we apply global
		      ModuleName, which can be modify by -module */
		   String *mname = Copy(ModuleName);
		   Setattr(yyval.node,k_name,mname);
		   Delete(mname);
		 } else { 
		   /* import mode, we just pass the idstring */
		   Setattr(yyval.node,k_name,yyvsp[0].id);   
		 }		 
		 if (!module_node) module_node = yyval.node;
	       }
    break;

  case 69:
#line 2028 "parser.y"
    {
                 Swig_warning(WARN_DEPRECATED_NAME,cparse_file,cparse_line, "%%name is deprecated.  Use %%rename instead.\n");
		 Delete(yyrename);
                 yyrename = NewString(yyvsp[-1].id);
		 yyval.node = 0;
               }
    break;

  case 70:
#line 2034 "parser.y"
    {
		 Swig_warning(WARN_DEPRECATED_NAME,cparse_file,cparse_line, "%%name is deprecated.  Use %%rename instead.\n");
		 yyval.node = 0;
		 Swig_error(cparse_file,cparse_line,"Missing argument to %%name directive.\n");
	       }
    break;

  case 71:
#line 2047 "parser.y"
    {
                 yyval.node = new_node("native");
		 Setattr(yyval.node,k_name,yyvsp[-4].id);
		 Setattr(yyval.node,"wrap:name",yyvsp[-1].id);
	         add_symbols(yyval.node);
	       }
    break;

  case 72:
#line 2053 "parser.y"
    {
		 if (!SwigType_isfunction(yyvsp[-1].decl.type)) {
		   Swig_error(cparse_file,cparse_line,"%%native declaration '%s' is not a function.\n", yyvsp[-1].decl.id);
		   yyval.node = 0;
		 } else {
		     Delete(SwigType_pop_function(yyvsp[-1].decl.type));
		     /* Need check for function here */
		     SwigType_push(yyvsp[-2].type,yyvsp[-1].decl.type);
		     yyval.node = new_node("native");
	             Setattr(yyval.node,k_name,yyvsp[-5].id);
		     Setattr(yyval.node,"wrap:name",yyvsp[-1].decl.id);
		     Setattr(yyval.node,k_type,yyvsp[-2].type);
		     Setattr(yyval.node,k_parms,yyvsp[-1].decl.parms);
		     Setattr(yyval.node,k_decl,yyvsp[-1].decl.type);
		 }
	         add_symbols(yyval.node);
	       }
    break;

  case 73:
#line 2079 "parser.y"
    {
                 yyval.node = new_node("pragma");
		 Setattr(yyval.node,"lang",yyvsp[-3].id);
		 Setattr(yyval.node,k_name,yyvsp[-2].id);
		 Setattr(yyval.node,k_value,yyvsp[0].str);
	       }
    break;

  case 74:
#line 2085 "parser.y"
    {
		yyval.node = new_node("pragma");
		Setattr(yyval.node,"lang",yyvsp[-1].id);
		Setattr(yyval.node,k_name,yyvsp[0].id);
	      }
    break;

  case 75:
#line 2092 "parser.y"
    { yyval.str = NewString(yyvsp[0].id); }
    break;

  case 76:
#line 2093 "parser.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 77:
#line 2096 "parser.y"
    { yyval.id = yyvsp[-1].id; }
    break;

  case 78:
#line 2097 "parser.y"
    { yyval.id = (char *) "swig"; }
    break;

  case 79:
#line 2105 "parser.y"
    {
                SwigType *t = yyvsp[-2].decl.type;
		Hash *kws = NewHash();
		String *fixname;
		fixname = feature_identifier_fix(yyvsp[-2].decl.id);
		Setattr(kws,k_name,yyvsp[-1].id);
		if (!Len(t)) t = 0;
		/* Special declarator check */
		if (t) {
		  if (SwigType_isfunction(t)) {
		    SwigType *decl = SwigType_pop_function(t);
		    if (SwigType_ispointer(t)) {
		      String *nname = NewStringf("*%s",fixname);
		      if (yyvsp[-3].ivalue) {
			Swig_name_rename_add(Namespaceprefix, nname,decl,kws,yyvsp[-2].decl.parms);
		      } else {
			Swig_name_namewarn_add(Namespaceprefix,nname,decl,kws);
		      }
		      Delete(nname);
		    } else {
		      if (yyvsp[-3].ivalue) {
			Swig_name_rename_add(Namespaceprefix,(fixname),decl,kws,yyvsp[-2].decl.parms);
		      } else {
			Swig_name_namewarn_add(Namespaceprefix,(fixname),decl,kws);
		      }
		    }
		    Delete(decl);
		  } else if (SwigType_ispointer(t)) {
		    String *nname = NewStringf("*%s",fixname);
		    if (yyvsp[-3].ivalue) {
		      Swig_name_rename_add(Namespaceprefix,(nname),0,kws,yyvsp[-2].decl.parms);
		    } else {
		      Swig_name_namewarn_add(Namespaceprefix,(nname),0,kws);
		    }
		    Delete(nname);
		  }
		} else {
		  if (yyvsp[-3].ivalue) {
		    Swig_name_rename_add(Namespaceprefix,(fixname),0,kws,yyvsp[-2].decl.parms);
		  } else {
		    Swig_name_namewarn_add(Namespaceprefix,(fixname),0,kws);
		  }
		}
                yyval.node = 0;
		scanner_clear_rename();
              }
    break;

  case 80:
#line 2151 "parser.y"
    {
		String *fixname;
		Hash *kws = yyvsp[-4].node;
		SwigType *t = yyvsp[-2].decl.type;
		fixname = feature_identifier_fix(yyvsp[-2].decl.id);
		if (!Len(t)) t = 0;
		/* Special declarator check */
		if (t) {
		  if (yyvsp[-1].dtype.qualifier) SwigType_push(t,yyvsp[-1].dtype.qualifier);
		  if (SwigType_isfunction(t)) {
		    SwigType *decl = SwigType_pop_function(t);
		    if (SwigType_ispointer(t)) {
		      String *nname = NewStringf("*%s",fixname);
		      if (yyvsp[-6].ivalue) {
			Swig_name_rename_add(Namespaceprefix, nname,decl,kws,yyvsp[-2].decl.parms);
		      } else {
			Swig_name_namewarn_add(Namespaceprefix,nname,decl,kws);
		      }
		      Delete(nname);
		    } else {
		      if (yyvsp[-6].ivalue) {
			Swig_name_rename_add(Namespaceprefix,(fixname),decl,kws,yyvsp[-2].decl.parms);
		      } else {
			Swig_name_namewarn_add(Namespaceprefix,(fixname),decl,kws);
		      }
		    }
		    Delete(decl);
		  } else if (SwigType_ispointer(t)) {
		    String *nname = NewStringf("*%s",fixname);
		    if (yyvsp[-6].ivalue) {
		      Swig_name_rename_add(Namespaceprefix,(nname),0,kws,yyvsp[-2].decl.parms);
		    } else {
		      Swig_name_namewarn_add(Namespaceprefix,(nname),0,kws);
		    }
		    Delete(nname);
		  }
		} else {
		  if (yyvsp[-6].ivalue) {
		    Swig_name_rename_add(Namespaceprefix,(fixname),0,kws,yyvsp[-2].decl.parms);
		  } else {
		    Swig_name_namewarn_add(Namespaceprefix,(fixname),0,kws);
		  }
		}
                yyval.node = 0;
		scanner_clear_rename();
              }
    break;

  case 81:
#line 2197 "parser.y"
    {
		if (yyvsp[-5].ivalue) {
		  Swig_name_rename_add(Namespaceprefix,yyvsp[-1].id,0,yyvsp[-3].node,0);
		} else {
		  Swig_name_namewarn_add(Namespaceprefix,yyvsp[-1].id,0,yyvsp[-3].node);
		}
		yyval.node = 0;
		scanner_clear_rename();
              }
    break;

  case 82:
#line 2208 "parser.y"
    {
		    yyval.ivalue = 1;
                }
    break;

  case 83:
#line 2211 "parser.y"
    {
                    yyval.ivalue = 0;
                }
    break;

  case 84:
#line 2238 "parser.y"
    {
                    String *val = yyvsp[0].str ? NewString(yyvsp[0].str) : NewString("1");
                    new_feature(yyvsp[-4].id, val, 0, yyvsp[-2].decl.id, yyvsp[-2].decl.type, yyvsp[-2].decl.parms, yyvsp[-1].dtype.qualifier);
                    yyval.node = 0;
                  }
    break;

  case 85:
#line 2243 "parser.y"
    {
                    String *val = Len(yyvsp[-4].id) ? NewString(yyvsp[-4].id) : 0;
                    new_feature(yyvsp[-6].id, val, 0, yyvsp[-2].decl.id, yyvsp[-2].decl.type, yyvsp[-2].decl.parms, yyvsp[-1].dtype.qualifier);
                    yyval.node = 0;
                  }
    break;

  case 86:
#line 2248 "parser.y"
    {
                    String *val = yyvsp[0].str ? NewString(yyvsp[0].str) : NewString("1");
                    new_feature(yyvsp[-5].id, val, yyvsp[-4].node, yyvsp[-2].decl.id, yyvsp[-2].decl.type, yyvsp[-2].decl.parms, yyvsp[-1].dtype.qualifier);
                    yyval.node = 0;
                  }
    break;

  case 87:
#line 2253 "parser.y"
    {
                    String *val = Len(yyvsp[-5].id) ? NewString(yyvsp[-5].id) : 0;
                    new_feature(yyvsp[-7].id, val, yyvsp[-4].node, yyvsp[-2].decl.id, yyvsp[-2].decl.type, yyvsp[-2].decl.parms, yyvsp[-1].dtype.qualifier);
                    yyval.node = 0;
                  }
    break;

  case 88:
#line 2260 "parser.y"
    {
                    String *val = yyvsp[0].str ? NewString(yyvsp[0].str) : NewString("1");
                    new_feature(yyvsp[-2].id, val, 0, 0, 0, 0, 0);
                    yyval.node = 0;
                  }
    break;

  case 89:
#line 2265 "parser.y"
    {
                    String *val = Len(yyvsp[-2].id) ? NewString(yyvsp[-2].id) : 0;
                    new_feature(yyvsp[-4].id, val, 0, 0, 0, 0, 0);
                    yyval.node = 0;
                  }
    break;

  case 90:
#line 2270 "parser.y"
    {
                    String *val = yyvsp[0].str ? NewString(yyvsp[0].str) : NewString("1");
                    new_feature(yyvsp[-3].id, val, yyvsp[-2].node, 0, 0, 0, 0);
                    yyval.node = 0;
                  }
    break;

  case 91:
#line 2275 "parser.y"
    {
                    String *val = Len(yyvsp[-3].id) ? NewString(yyvsp[-3].id) : 0;
                    new_feature(yyvsp[-5].id, val, yyvsp[-2].node, 0, 0, 0, 0);
                    yyval.node = 0;
                  }
    break;

  case 92:
#line 2282 "parser.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 93:
#line 2283 "parser.y"
    { yyval.str = 0; }
    break;

  case 94:
#line 2284 "parser.y"
    { yyval.str = yyvsp[-2].pl; }
    break;

  case 95:
#line 2287 "parser.y"
    {
		  yyval.node = NewHash();
		  Setattr(yyval.node,k_name,yyvsp[-2].id);
		  Setattr(yyval.node,k_value,yyvsp[0].id);
                }
    break;

  case 96:
#line 2292 "parser.y"
    {
		  yyval.node = NewHash();
		  Setattr(yyval.node,k_name,yyvsp[-3].id);
		  Setattr(yyval.node,k_value,yyvsp[-1].id);
                  set_nextSibling(yyval.node,yyvsp[0].node);
                }
    break;

  case 97:
#line 2302 "parser.y"
    {
                 Parm *val;
		 String *name;
		 SwigType *t;
		 if (Namespaceprefix) name = NewStringf("%s::%s", Namespaceprefix, yyvsp[-2].decl.id);
		 else name = NewString(yyvsp[-2].decl.id);
		 val = yyvsp[-4].pl;
		 if (yyvsp[-2].decl.parms) {
		   Setmeta(val,k_parms,yyvsp[-2].decl.parms);
		 }
		 t = yyvsp[-2].decl.type;
		 if (!Len(t)) t = 0;
		 if (t) {
		   if (yyvsp[-1].dtype.qualifier) SwigType_push(t,yyvsp[-1].dtype.qualifier);
		   if (SwigType_isfunction(t)) {
		     SwigType *decl = SwigType_pop_function(t);
		     if (SwigType_ispointer(t)) {
		       String *nname = NewStringf("*%s",name);
		       Swig_feature_set(Swig_cparse_features(), nname, decl, "feature:varargs", val, 0);
		       Delete(nname);
		     } else {
		       Swig_feature_set(Swig_cparse_features(), name, decl, "feature:varargs", val, 0);
		     }
		     Delete(decl);
		   } else if (SwigType_ispointer(t)) {
		     String *nname = NewStringf("*%s",name);
		     Swig_feature_set(Swig_cparse_features(),nname,0,"feature:varargs",val, 0);
		     Delete(nname);
		   }
		 } else {
		   Swig_feature_set(Swig_cparse_features(),name,0,"feature:varargs",val, 0);
		 }
		 Delete(name);
		 yyval.node = 0;
              }
    break;

  case 98:
#line 2338 "parser.y"
    { yyval.pl = yyvsp[0].pl; }
    break;

  case 99:
#line 2339 "parser.y"
    { 
		  int i;
		  int n;
		  Parm *p;
		  n = atoi(Char(yyvsp[-2].dtype.val));
		  if (n <= 0) {
		    Swig_error(cparse_file, cparse_line,"Argument count in %%varargs must be positive.\n");
		    yyval.pl = 0;
		  } else {
		    yyval.pl = Copy(yyvsp[0].p);
		    Setattr(yyval.pl,k_name,"VARARGS_SENTINEL");
		    for (i = 0; i < n; i++) {
		      p = Copy(yyvsp[0].p);
		      set_nextSibling(p,yyval.pl);
		      Delete(yyval.pl);
		      yyval.pl = p;
		    }
		  }
                }
    break;

  case 100:
#line 2369 "parser.y"
    {
		   yyval.node = 0;
		   if (yyvsp[-3].tmap.op) {
		     String *code = 0;
		     yyval.node = new_node("typemap");
		     Setattr(yyval.node,"method",yyvsp[-3].tmap.op);
		     if (yyvsp[-3].tmap.kwargs) {
		       Parm *kw = yyvsp[-3].tmap.kwargs;
		       /* check for 'noblock' option, which remove the block braces */
		       while (kw) {
			 String *name = Getattr(kw,k_name);
			 if (name && (Cmp(name,"noblock") == 0)) {
			   char *cstr = Char(yyvsp[0].str);
			   size_t len = Len(yyvsp[0].str);
			   if (len && cstr[0] == '{') {
			     --len; ++cstr; 
			     if (len && cstr[len - 1] == '}') { --len; }
			     /* we now remove the extra spaces */
			     while (len && isspace((int)cstr[0])) { --len; ++cstr; }
			     while (len && isspace((int)cstr[len - 1])) { --len; }
			     code = NewStringWithSize(cstr, len);
			     break;
			   }
			 }
			 kw = nextSibling(kw);
		       }
		       Setattr(yyval.node,k_kwargs, yyvsp[-3].tmap.kwargs);
		     }
		     code = code ? code : NewString(yyvsp[0].str);
		     Setattr(yyval.node,k_code, code);
		     Delete(code);
		     appendChild(yyval.node,yyvsp[-1].p);
		   }
	       }
    break;

  case 101:
#line 2403 "parser.y"
    {
		 yyval.node = 0;
		 if (yyvsp[-3].tmap.op) {
		   yyval.node = new_node("typemap");
		   Setattr(yyval.node,"method",yyvsp[-3].tmap.op);
		   appendChild(yyval.node,yyvsp[-1].p);
		 }
	       }
    break;

  case 102:
#line 2411 "parser.y"
    {
		   yyval.node = 0;
		   if (yyvsp[-5].tmap.op) {
		     yyval.node = new_node("typemapcopy");
		     Setattr(yyval.node,"method",yyvsp[-5].tmap.op);
		     Setattr(yyval.node,k_pattern, Getattr(yyvsp[-1].p,k_pattern));
		     appendChild(yyval.node,yyvsp[-3].p);
		   }
	       }
    break;

  case 103:
#line 2424 "parser.y"
    {
		 Hash *p;
		 String *name;
		 p = nextSibling(yyvsp[0].node);
		 if (p && (!Getattr(p,k_value))) {
 		   /* this is the deprecated two argument typemap form */
 		   Swig_warning(WARN_DEPRECATED_TYPEMAP_LANG,cparse_file, cparse_line,
				"Specifying the language name in %%typemap is deprecated - use #ifdef SWIG<LANG> instead.\n");
		   /* two argument typemap form */
		   name = Getattr(yyvsp[0].node,k_name);
		   if (!name || (Strcmp(name,typemap_lang))) {
		     yyval.tmap.op = 0;
		     yyval.tmap.kwargs = 0;
		   } else {
		     yyval.tmap.op = Getattr(p,k_name);
		     yyval.tmap.kwargs = nextSibling(p);
		   }
		 } else {
		   /* one-argument typemap-form */
		   yyval.tmap.op = Getattr(yyvsp[0].node,k_name);
		   yyval.tmap.kwargs = p;
		 }
                }
    break;

  case 104:
#line 2449 "parser.y"
    {
                 yyval.p = yyvsp[-1].p;
		 set_nextSibling(yyval.p,yyvsp[0].p);
		}
    break;

  case 105:
#line 2455 "parser.y"
    {
                 yyval.p = yyvsp[-1].p;
		 set_nextSibling(yyval.p,yyvsp[0].p);
                }
    break;

  case 106:
#line 2459 "parser.y"
    { yyval.p = 0;}
    break;

  case 107:
#line 2462 "parser.y"
    {
                  Parm *parm;
		  SwigType_push(yyvsp[-1].type,yyvsp[0].decl.type);
		  yyval.p = new_node("typemapitem");
		  parm = NewParm(yyvsp[-1].type,yyvsp[0].decl.id);
		  Setattr(yyval.p,k_pattern,parm);
		  Setattr(yyval.p,k_parms, yyvsp[0].decl.parms);
		  Delete(parm);
		  /*		  $$ = NewParm($1,$2.id);
				  Setattr($$,"parms",$2.parms); */
                }
    break;

  case 108:
#line 2473 "parser.y"
    {
                  yyval.p = new_node("typemapitem");
		  Setattr(yyval.p,k_pattern,yyvsp[-1].pl);
		  /*		  Setattr($$,"multitype",$2); */
               }
    break;

  case 109:
#line 2478 "parser.y"
    {
		 yyval.p = new_node("typemapitem");
		 Setattr(yyval.p,k_pattern, yyvsp[-4].pl);
		 /*                 Setattr($$,"multitype",$2); */
		 Setattr(yyval.p,k_parms,yyvsp[-1].pl);
               }
    break;

  case 110:
#line 2490 "parser.y"
    {
                   yyval.node = new_node("types");
		   Setattr(yyval.node,k_parms,yyvsp[-2].pl);
               }
    break;

  case 111:
#line 2500 "parser.y"
    {
                  Parm *p, *tp;
		  Node *n;
		  Node *tnode = 0;
		  Symtab *tscope = 0;
		  int     specialized = 0;
		  
		  yyval.node = 0;

		  tscope = Swig_symbol_current();          /* Get the current scope */

		  /* If the class name is qualified.  We need to create or lookup namespace entries */
		  if (!inclass) {
		    yyvsp[-4].str = resolve_node_scope(yyvsp[-4].str);
		  }

		  /*
		    we use the new namespace entry 'nscope' only to
		    emit the template node. The template parameters are
		    resolved in the current 'tscope'.
		    
		    this is closer to the C++ (typedef) behavior.
		  */
		  n = Swig_cparse_template_locate(yyvsp[-4].str,yyvsp[-2].p,tscope);

		  /* Patch the argument types to respect namespaces */
		  p = yyvsp[-2].p;
		  while (p) {
		    SwigType *value = Getattr(p,k_value);
		    if (!value) {
		      SwigType *ty = Getattr(p,k_type);
		      if (ty) {
			if (template_reduce) {
			  SwigType *rty = Swig_symbol_typedef_reduce(ty,tscope);
			  ty = Swig_symbol_type_qualify(rty,tscope);
			  Setattr(p,k_type,ty);
			  Delete(ty);
			  Delete(rty);
			} else {
			  ty = Swig_symbol_type_qualify(ty,tscope);
			  Setattr(p,k_type,ty);
			  Delete(ty);
			}
		      }
		    } else {
		      value = Swig_symbol_type_qualify(value,tscope);
		      Setattr(p,k_value,value);
		      Delete(value);
		    }
		    
		    p = nextSibling(p);
		  }

		  /* Look for the template */
		  {
                    Node *nn = n;
                    Node *linklistend = 0;
                    while (nn) {
                      Node *templnode = 0;
                      if (Strcmp(nodeType(nn),"template") == 0) {
                        int nnisclass = (Strcmp(Getattr(nn,k_templatetype),"class") == 0); /* if not a templated class it is a templated function */
                        Parm *tparms = Getattr(nn,k_templateparms);
                        if (!tparms) {
                          specialized = 1;
                        }
                        if (nnisclass && !specialized && ((ParmList_len(yyvsp[-2].p) > ParmList_len(tparms)))) {
                          Swig_error(cparse_file, cparse_line, "Too many template parameters. Maximum of %d.\n", ParmList_len(tparms));
                        } else if (nnisclass && !specialized && ((ParmList_len(yyvsp[-2].p) < ParmList_numrequired(tparms)))) {
                          Swig_error(cparse_file, cparse_line, "Not enough template parameters specified. %d required.\n", ParmList_numrequired(tparms));
                        } else if (!nnisclass && ((ParmList_len(yyvsp[-2].p) != ParmList_len(tparms)))) {
                          /* must be an overloaded templated method - ignore it as it is overloaded with a different number of template parameters */
                          nn = Getattr(nn,"sym:nextSibling"); /* repeat for overloaded templated functions */
                          continue;
                        } else {
			  String *tname = Copy(yyvsp[-4].str);
                          int  def_supplied = 0;
                          /* Expand the template */
			  Node *templ = Swig_symbol_clookup(yyvsp[-4].str,0);
			  Parm *targs = templ ? Getattr(templ,k_templateparms) : 0;

                          ParmList *temparms;
                          if (specialized) temparms = CopyParmList(yyvsp[-2].p);
                          else temparms = CopyParmList(tparms);

                          /* Create typedef's and arguments */
                          p = yyvsp[-2].p;
                          tp = temparms;
                          while (p) {
                            String *value = Getattr(p,k_value);
                            if (def_supplied) {
                              Setattr(p,"default","1");
                            }
                            if (value) {
                              Setattr(tp,k_value,value);
                            } else {
                              SwigType *ty = Getattr(p,k_type);
                              if (ty) {
                                Setattr(tp,k_type,ty);
                              }
                              Delattr(tp,k_value);
                            }
			    /* fix default arg values */
			    if (targs) {
			      Parm *pi = temparms;
			      Parm *ti = targs;
			      String *tv = Getattr(tp,k_value);
			      if (!tv) tv = Getattr(tp,k_type);
			      while(pi != tp) {
				String *name = Getattr(ti,k_name);
				String *value = Getattr(pi,k_value);
				if (!value) value = Getattr(pi,k_type);
				Replaceid(tv, name, value);
				pi = nextSibling(pi);
				ti = nextSibling(ti);
			      }
			    }
                            p = nextSibling(p);
                            tp = nextSibling(tp);
                            if (!p && tp) {
                              p = tp;
                              def_supplied = 1;
                            }
                          }

                          templnode = copy_node(nn);
                          /* We need to set the node name based on name used to instantiate */
                          Setattr(templnode,k_name,tname);
			  Delete(tname);
                          if (!specialized) {
                            Delattr(templnode,k_symtypename);
                          } else {
                            Setattr(templnode,k_symtypename,"1");
                          }
                          if (yyvsp[-6].id) {
			    /* 
			       Comment this out for 1.3.28. We need to
			       renable it later but first we need to
			       move %ignore from using %rename to use
			       %feature(ignore).
			  
			       String *symname = Swig_name_make(templnode,0,$3,0,0);
			    */
			    String *symname = yyvsp[-6].id;
                            Swig_cparse_template_expand(templnode,symname,temparms,tscope);
                            Setattr(templnode,k_symname,symname);
                          } else {
                            static int cnt = 0;
                            String *nname = NewStringf("__dummy_%d__", cnt++);
                            Swig_cparse_template_expand(templnode,nname,temparms,tscope);
                            Setattr(templnode,k_symname,nname);
			    Delete(nname);
                            Setattr(templnode,"feature:onlychildren",
                                    "typemap,typemapitem,typemapcopy,typedef,types,fragment");
                          }
                          Delattr(templnode,k_templatetype);
                          Setattr(templnode,k_template,nn);
                          tnode = templnode;
                          Setfile(templnode,cparse_file);
                          Setline(templnode,cparse_line);
                          Delete(temparms);
                          
                          add_symbols_copy(templnode);

                          if (Strcmp(nodeType(templnode),"class") == 0) {

                            /* Identify pure abstract methods */
                            Setattr(templnode,k_abstract, pure_abstract(firstChild(templnode)));
                            
                            /* Set up inheritance in symbol table */
                            {
                              Symtab  *csyms;
                              List *baselist = Getattr(templnode,k_baselist);
                              csyms = Swig_symbol_current();
                              Swig_symbol_setscope(Getattr(templnode,k_symtab));
                              if (baselist) {
                                List *bases = make_inherit_list(Getattr(templnode,k_name),baselist);
                                if (bases) {
                                  Iterator s;
                                  for (s = First(bases); s.item; s = Next(s)) {
                                    Symtab *st = Getattr(s.item,k_symtab);
                                    if (st) {
                                      Swig_symbol_inherit(st);
                                    }
                                  }
				  Delete(bases);
                                }
                              }
                              Swig_symbol_setscope(csyms);
                            }

                            /* Merge in addmethods for this class */
                            
                            /* !!! This may be broken.  We may have to  add the addmethods at the beginning of
                               the class */
                            
                            if (extendhash) {
                              String *stmp = 0;
                              String *clsname;
                              Node *am;
                              if (Namespaceprefix) {
                                clsname = stmp = NewStringf("%s::%s", Namespaceprefix, Getattr(templnode,k_name));
                              } else {
                                clsname = Getattr(templnode,k_name);
                              }
                              am = Getattr(extendhash,clsname);
                              if (am) {
                                Symtab *st = Swig_symbol_current();
                                Swig_symbol_setscope(Getattr(templnode,k_symtab));
                                /*			    Printf(stdout,"%s: %s %x %x\n", Getattr(templnode,k_name), clsname, Swig_symbol_current(), Getattr(templnode,"symtab")); */
                                merge_extensions(templnode,am);
                                Swig_symbol_setscope(st);
				append_previous_extension(templnode,am);
                                Delattr(extendhash,clsname);
                              }
			      if (stmp) Delete(stmp);
                            }
                            /* Add to classes hash */
                            if (!classes) classes = NewHash();

                            {
                              if (Namespaceprefix) {
                                String *temp = NewStringf("%s::%s", Namespaceprefix, Getattr(templnode,k_name));
                                Setattr(classes,temp,templnode);
				Delete(temp);
                              } else {
				String *qs = Swig_symbol_qualifiedscopename(templnode);
                                Setattr(classes, qs,templnode);
				Delete(qs);
                              }
                            }
                          }
                        }

                        /* all the overloaded templated functions are added into a linked list */
                        if (nscope_inner) {
                          /* non-global namespace */
                          if (templnode) {
                            appendChild(nscope_inner,templnode);
			    Delete(templnode);
                            if (nscope) yyval.node = nscope;
                          }
                        } else {
                          /* global namespace */
                          if (!linklistend) {
                            yyval.node = templnode;
                          } else {
                            set_nextSibling(linklistend,templnode);
			    Delete(templnode);
                          }
                          linklistend = templnode;
                        }
                      }
                      nn = Getattr(nn,"sym:nextSibling"); /* repeat for overloaded templated functions. If a templated class there will never be a sibling. */
                    }
		  }
   	          Swig_symbol_setscope(tscope);
		  Delete(Namespaceprefix);
		  Namespaceprefix = Swig_symbol_qualifiedscopename(0);
                }
    break;

  case 112:
#line 2766 "parser.y"
    {
		  Swig_warning(0,cparse_file, cparse_line,"%s\n", yyvsp[0].id);
		  yyval.node = 0;
               }
    break;

  case 113:
#line 2776 "parser.y"
    {
                    yyval.node = yyvsp[0].node; 
                    if (yyval.node) {
   		      add_symbols(yyval.node);
                      default_arguments(yyval.node);
   	            }
                }
    break;

  case 114:
#line 2783 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 115:
#line 2784 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 116:
#line 2788 "parser.y"
    {
		  if (Strcmp(yyvsp[-1].id,"C") == 0) {
		    cparse_externc = 1;
		  }
		}
    break;

  case 117:
#line 2792 "parser.y"
    {
		  cparse_externc = 0;
		  if (Strcmp(yyvsp[-4].id,"C") == 0) {
		    Node *n = firstChild(yyvsp[-1].node);
		    yyval.node = new_node("extern");
		    Setattr(yyval.node,k_name,yyvsp[-4].id);
		    appendChild(yyval.node,n);
		    while (n) {
		      SwigType *decl = Getattr(n,k_decl);
		      if (SwigType_isfunction(decl)) {
			Setattr(n,k_storage,"externc");
		      }
		      n = nextSibling(n);
		    }
		  } else {
		     Swig_warning(WARN_PARSE_UNDEFINED_EXTERN,cparse_file, cparse_line,"Unrecognized extern type \"%s\".\n", yyvsp[-4].id);
		    yyval.node = new_node("extern");
		    Setattr(yyval.node,k_name,yyvsp[-4].id);
		    appendChild(yyval.node,firstChild(yyvsp[-1].node));
		  }
                }
    break;

  case 118:
#line 2819 "parser.y"
    {
              yyval.node = new_node("cdecl");
	      if (yyvsp[-1].dtype.qualifier) SwigType_push(yyvsp[-2].decl.type,yyvsp[-1].dtype.qualifier);
	      Setattr(yyval.node,k_type,yyvsp[-3].type);
	      Setattr(yyval.node,k_storage,yyvsp[-4].id);
	      Setattr(yyval.node,k_name,yyvsp[-2].decl.id);
	      Setattr(yyval.node,k_decl,yyvsp[-2].decl.type);
	      Setattr(yyval.node,k_parms,yyvsp[-2].decl.parms);
	      Setattr(yyval.node,k_value,yyvsp[-1].dtype.val);
	      Setattr(yyval.node,k_throws,yyvsp[-1].dtype.throws);
	      Setattr(yyval.node,k_throw,yyvsp[-1].dtype.throwf);
	      if (!yyvsp[0].node) {
		if (Len(scanner_ccode)) {
		  String *code = Copy(scanner_ccode);
		  Setattr(yyval.node,k_code,code);
		  Delete(code);
		}
	      } else {
		Node *n = yyvsp[0].node;
		/* Inherit attributes */
		while (n) {
		  String *type = Copy(yyvsp[-3].type);
		  Setattr(n,k_type,type);
		  Setattr(n,k_storage,yyvsp[-4].id);
		  n = nextSibling(n);
		  Delete(type);
		}
	      }
	      if (yyvsp[-1].dtype.bitfield) {
		Setattr(yyval.node,"bitfield", yyvsp[-1].dtype.bitfield);
	      }

	      /* Look for "::" declarations (ignored) */
	      if (Strstr(yyvsp[-2].decl.id,"::")) {
                /* This is a special case. If the scope name of the declaration exactly
                   matches that of the declaration, then we will allow it. Otherwise, delete. */
                String *p = Swig_scopename_prefix(yyvsp[-2].decl.id);
		if (p) {
		  if ((Namespaceprefix && Strcmp(p,Namespaceprefix) == 0) ||
		      (inclass && Strcmp(p,Classprefix) == 0)) {
		    String *lstr = Swig_scopename_last(yyvsp[-2].decl.id);
		    Setattr(yyval.node,k_name,lstr);
		    Delete(lstr);
		    set_nextSibling(yyval.node,yyvsp[0].node);
		  } else {
		    Delete(yyval.node);
		    yyval.node = yyvsp[0].node;
		  }
		  Delete(p);
		} else {
		  Delete(yyval.node);
		  yyval.node = yyvsp[0].node;
		}
	      } else {
		set_nextSibling(yyval.node,yyvsp[0].node);
	      }
           }
    break;

  case 119:
#line 2880 "parser.y"
    { 
                   yyval.node = 0;
                   Clear(scanner_ccode); 
               }
    break;

  case 120:
#line 2884 "parser.y"
    {
		 yyval.node = new_node("cdecl");
		 if (yyvsp[-1].dtype.qualifier) SwigType_push(yyvsp[-2].decl.type,yyvsp[-1].dtype.qualifier);
		 Setattr(yyval.node,k_name,yyvsp[-2].decl.id);
		 Setattr(yyval.node,k_decl,yyvsp[-2].decl.type);
		 Setattr(yyval.node,k_parms,yyvsp[-2].decl.parms);
		 Setattr(yyval.node,k_value,yyvsp[-1].dtype.val);
		 Setattr(yyval.node,k_throws,yyvsp[-1].dtype.throws);
		 Setattr(yyval.node,k_throw,yyvsp[-1].dtype.throwf);
		 if (yyvsp[-1].dtype.bitfield) {
		   Setattr(yyval.node,"bitfield", yyvsp[-1].dtype.bitfield);
		 }
		 if (!yyvsp[0].node) {
		   if (Len(scanner_ccode)) {
		     String *code = Copy(scanner_ccode);
		     Setattr(yyval.node,k_code,code);
		     Delete(code);
		   }
		 } else {
		   set_nextSibling(yyval.node,yyvsp[0].node);
		 }
	       }
    break;

  case 121:
#line 2906 "parser.y"
    { 
                   skip_balanced('{','}');
                   yyval.node = 0;
               }
    break;

  case 122:
#line 2912 "parser.y"
    { 
                   yyval.dtype = yyvsp[0].dtype; 
                   yyval.dtype.qualifier = 0;
		   yyval.dtype.throws = 0;
		   yyval.dtype.throwf = 0;
              }
    break;

  case 123:
#line 2918 "parser.y"
    { 
                   yyval.dtype = yyvsp[0].dtype; 
		   yyval.dtype.qualifier = yyvsp[-1].str;
		   yyval.dtype.throws = 0;
		   yyval.dtype.throwf = 0;
	      }
    break;

  case 124:
#line 2924 "parser.y"
    { 
		   yyval.dtype = yyvsp[0].dtype; 
                   yyval.dtype.qualifier = 0;
		   yyval.dtype.throws = yyvsp[-2].pl;
		   yyval.dtype.throwf = NewString("1");
              }
    break;

  case 125:
#line 2930 "parser.y"
    { 
                   yyval.dtype = yyvsp[0].dtype; 
                   yyval.dtype.qualifier = yyvsp[-5].str;
		   yyval.dtype.throws = yyvsp[-2].pl;
		   yyval.dtype.throwf = NewString("1");
              }
    break;

  case 126:
#line 2943 "parser.y"
    {
		   SwigType *ty = 0;
		   yyval.node = new_node("enumforward");
		   ty = NewStringf("enum %s", yyvsp[-1].id);
		   Setattr(yyval.node,k_name,yyvsp[-1].id);
		   Setattr(yyval.node,k_type,ty);
		   Setattr(yyval.node,k_symweak, "1");
		   add_symbols(yyval.node);
	      }
    break;

  case 127:
#line 2958 "parser.y"
    {
		  SwigType *ty = 0;
                  yyval.node = new_node("enum");
		  ty = NewStringf("enum %s", yyvsp[-4].id);
		  Setattr(yyval.node,k_name,yyvsp[-4].id);
		  Setattr(yyval.node,k_type,ty);
		  appendChild(yyval.node,yyvsp[-2].node);
		  add_symbols(yyval.node);       /* Add to tag space */
		  add_symbols(yyvsp[-2].node);       /* Add enum values to id space */
               }
    break;

  case 128:
#line 2968 "parser.y"
    {
		 Node *n;
		 SwigType *ty = 0;
		 String   *unnamed = 0;
		 int       unnamedinstance = 0;

		 yyval.node = new_node("enum");
		 if (yyvsp[-5].id) {
		   Setattr(yyval.node,k_name,yyvsp[-5].id);
		   ty = NewStringf("enum %s", yyvsp[-5].id);
		 } else if (yyvsp[-1].decl.id) {
		   unnamed = make_unnamed();
		   ty = NewStringf("enum %s", unnamed);
		   Setattr(yyval.node,k_unnamed,unnamed);
                   /* name is not set for unnamed enum instances, e.g. enum { foo } Instance; */
		   if (yyvsp[-7].id && Cmp(yyvsp[-7].id,"typedef") == 0) {
		     Setattr(yyval.node,k_name,yyvsp[-1].decl.id);
                   } else {
                     unnamedinstance = 1;
                   }
		   Setattr(yyval.node,k_storage,yyvsp[-7].id);
		 }
		 if (yyvsp[-1].decl.id && Cmp(yyvsp[-7].id,"typedef") == 0) {
		   Setattr(yyval.node,"tdname",yyvsp[-1].decl.id);
                   Setattr(yyval.node,"allows_typedef","1");
                 }
		 appendChild(yyval.node,yyvsp[-3].node);
		 n = new_node("cdecl");
		 Setattr(n,k_type,ty);
		 Setattr(n,k_name,yyvsp[-1].decl.id);
		 Setattr(n,k_storage,yyvsp[-7].id);
		 Setattr(n,k_decl,yyvsp[-1].decl.type);
		 Setattr(n,k_parms,yyvsp[-1].decl.parms);
		 Setattr(n,k_unnamed,unnamed);

                 if (unnamedinstance) {
		   SwigType *cty = NewString("enum ");
		   Setattr(yyval.node,k_type,cty);
		   Setattr(yyval.node,"unnamedinstance","1");
		   Setattr(n,"unnamedinstance","1");
		   Delete(cty);
                 }
		 if (yyvsp[0].node) {
		   Node *p = yyvsp[0].node;
		   set_nextSibling(n,p);
		   while (p) {
		     SwigType *cty = Copy(ty);
		     Setattr(p,k_type,cty);
		     Setattr(p,k_unnamed,unnamed);
		     Setattr(p,k_storage,yyvsp[-7].id);
		     Delete(cty);
		     p = nextSibling(p);
		   }
		 } else {
		   if (Len(scanner_ccode)) {
		     String *code = Copy(scanner_ccode);
		     Setattr(n,k_code,code);
		     Delete(code);
		   }
		 }

                 /* Ensure that typedef enum ABC {foo} XYZ; uses XYZ for sym:name, like structs.
                  * Note that class_rename/yyrename are bit of a mess so used this simple approach to change the name. */
                 if (yyvsp[-1].decl.id && yyvsp[-5].id && Cmp(yyvsp[-7].id,"typedef") == 0) {
		   String *name = NewString(yyvsp[-1].decl.id);
                   Setattr(yyval.node, "parser:makename", name);
		   Delete(name);
                 }

		 add_symbols(yyval.node);       /* Add enum to tag space */
		 set_nextSibling(yyval.node,n);
		 Delete(n);
		 add_symbols(yyvsp[-3].node);       /* Add enum values to id space */
	         add_symbols(n);
		 Delete(unnamed);
	       }
    break;

  case 129:
#line 3046 "parser.y"
    {
                   /* This is a sick hack.  If the ctor_end has parameters,
                      and the parms paremeter only has 1 parameter, this
                      could be a declaration of the form:

                         type (id)(parms)

			 Otherwise it's an error. */
                    int err = 0;
                    yyval.node = 0;

		    if ((ParmList_len(yyvsp[-2].pl) == 1) && (!Swig_scopename_check(yyvsp[-4].type))) {
		      SwigType *ty = Getattr(yyvsp[-2].pl,k_type);
		      String *name = Getattr(yyvsp[-2].pl,k_name);
		      err = 1;
		      if (!name) {
			yyval.node = new_node("cdecl");
			Setattr(yyval.node,k_type,yyvsp[-4].type);
			Setattr(yyval.node,k_storage,yyvsp[-5].id);
			Setattr(yyval.node,k_name,ty);

			if (yyvsp[0].decl.have_parms) {
			  SwigType *decl = NewStringEmpty();
			  SwigType_add_function(decl,yyvsp[0].decl.parms);
			  Setattr(yyval.node,k_decl,decl);
			  Setattr(yyval.node,k_parms,yyvsp[0].decl.parms);
			  if (Len(scanner_ccode)) {
			    String *code = Copy(scanner_ccode);
			    Setattr(yyval.node,k_code,code);
			    Delete(code);
			  }
			}
			if (yyvsp[0].decl.defarg) {
			  Setattr(yyval.node,k_value,yyvsp[0].decl.defarg);
			}
			Setattr(yyval.node,k_throws,yyvsp[0].decl.throws);
			Setattr(yyval.node,k_throw,yyvsp[0].decl.throwf);
			err = 0;
		      }
		    }
		    if (err) {
		      if (!Swig_error_count()) {
			Swig_error(cparse_file,cparse_line,"Syntax error in input(2).\n");
		      }
		    }
                }
    break;

  case 130:
#line 3098 "parser.y"
    {  yyval.node = yyvsp[0].node; }
    break;

  case 131:
#line 3099 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 132:
#line 3100 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 133:
#line 3101 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 134:
#line 3102 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 135:
#line 3103 "parser.y"
    { yyval.node = 0; }
    break;

  case 136:
#line 3109 "parser.y"
    {
                   List *bases = 0;
		   Node *scope = 0;
		   yyval.node = new_node("class");
		   Setline(yyval.node,cparse_start_line);
		   Setattr(yyval.node,k_kind,yyvsp[-3].id);
		   if (yyvsp[-1].bases) {
		     Setattr(yyval.node,k_baselist, Getattr(yyvsp[-1].bases,"public"));
		     Setattr(yyval.node,"protectedbaselist", Getattr(yyvsp[-1].bases,"protected"));
		     Setattr(yyval.node,"privatebaselist", Getattr(yyvsp[-1].bases,"private"));
		   }
		   Setattr(yyval.node,"allows_typedef","1");

		   /* preserve the current scope */
		   prev_symtab = Swig_symbol_current();
		  
		   /* If the class name is qualified.  We need to create or lookup namespace/scope entries */
		   scope = resolve_node_scope(yyvsp[-2].str);
		   Setfile(scope,cparse_file);
		   Setline(scope,cparse_line);
		   yyvsp[-2].str = scope;
		   
		   /* support for old nested classes "pseudo" support, such as:

		         %rename(Ala__Ola) Ala::Ola;
			class Ala::Ola {
			public:
			    Ola() {}
		         };

		      this should dissapear with a proper implementation is added.
		   */
		   if (nscope_inner && Strcmp(nodeType(nscope_inner),"namespace") != 0) {
		     if (Namespaceprefix) {
		       String *name = NewStringf("%s::%s", Namespaceprefix, yyvsp[-2].str);		       
		       yyvsp[-2].str = name;
		       Namespaceprefix = 0;
		       nscope_inner = 0;
		     }
		   }
		   Setattr(yyval.node,k_name,yyvsp[-2].str);

		   Delete(class_rename);
                   class_rename = make_name(yyval.node,yyvsp[-2].str,0);
		   Classprefix = NewString(yyvsp[-2].str);
		   /* Deal with inheritance  */
		   if (yyvsp[-1].bases) {
		     bases = make_inherit_list(yyvsp[-2].str,Getattr(yyvsp[-1].bases,"public"));
		   }
		   if (SwigType_istemplate(yyvsp[-2].str)) {
		     String *fbase, *tbase, *prefix;
		     prefix = SwigType_templateprefix(yyvsp[-2].str);
		     if (Namespaceprefix) {
		       fbase = NewStringf("%s::%s", Namespaceprefix,yyvsp[-2].str);
		       tbase = NewStringf("%s::%s", Namespaceprefix, prefix);
		     } else {
		       fbase = Copy(yyvsp[-2].str);
		       tbase = Copy(prefix);
		     }
		     Swig_name_inherit(tbase,fbase);
		     Delete(fbase);
		     Delete(tbase);
		     Delete(prefix);
		   }
                   if (strcmp(yyvsp[-3].id,"class") == 0) {
		     cplus_mode = CPLUS_PRIVATE;
		   } else {
		     cplus_mode = CPLUS_PUBLIC;
		   }
		   Swig_symbol_newscope();
		   Swig_symbol_setscopename(yyvsp[-2].str);
		   if (bases) {
		     Iterator s;
		     for (s = First(bases); s.item; s = Next(s)) {
		       Symtab *st = Getattr(s.item,k_symtab);
		       if (st) {
			 Swig_symbol_inherit(st); 
		       }
		     }
		     Delete(bases);
		   }
		   Delete(Namespaceprefix);
		   Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		   cparse_start_line = cparse_line;

		   /* If there are active template parameters, we need to make sure they are
                      placed in the class symbol table so we can catch shadows */

		   if (template_parameters) {
		     Parm *tp = template_parameters;
		     while(tp) {
		       String *tpname = Copy(Getattr(tp,k_name));
		       Node *tn = new_node("templateparm");
		       Setattr(tn,k_name,tpname);
		       Swig_symbol_cadd(tpname,tn);
		       tp = nextSibling(tp);
		       Delete(tpname);
		     }
		   }
		   class_decl[class_level++] = yyval.node;
		   inclass = 1;
               }
    break;

  case 137:
#line 3210 "parser.y"
    {
		 Node *p;
		 SwigType *ty;
		 Symtab *cscope = prev_symtab;
		 Node *am = 0;
		 String *scpname = 0;
		 yyval.node = class_decl[--class_level];
		 inclass = 0;
		 
		 /* Check for pure-abstract class */
		 Setattr(yyval.node,k_abstract, pure_abstract(yyvsp[-2].node));
		 
		 /* This bit of code merges in a previously defined %extend directive (if any) */
		 
		 if (extendhash) {
		   String *clsname = Swig_symbol_qualifiedscopename(0);
		   am = Getattr(extendhash,clsname);
		   if (am) {
		     merge_extensions(yyval.node,am);
		     Delattr(extendhash,clsname);
		   }
		   Delete(clsname);
		 }
		 if (!classes) classes = NewHash();
		 scpname = Swig_symbol_qualifiedscopename(0);
		 Setattr(classes,scpname,yyval.node);
		 Delete(scpname);

		 appendChild(yyval.node,yyvsp[-2].node);
		 
		 if (am) append_previous_extension(yyval.node,am);

		 p = yyvsp[0].node;
		 if (p) {
		   set_nextSibling(yyval.node,p);
		 }
		 
		 if (cparse_cplusplus && !cparse_externc) {
		   ty = NewString(yyvsp[-6].str);
		 } else {
		   ty = NewStringf("%s %s", yyvsp[-7].id,yyvsp[-6].str);
		 }
		 while (p) {
		   Setattr(p,k_storage,yyvsp[-8].id);
		   Setattr(p,k_type,ty);
		   p = nextSibling(p);
		 }
		 /* Dump nested classes */
		 {
		   String *name = yyvsp[-6].str;
		   if (yyvsp[0].node) {
		     SwigType *decltype = Getattr(yyvsp[0].node,k_decl);
		     if (Cmp(yyvsp[-8].id,"typedef") == 0) {
		       if (!decltype || !Len(decltype)) {
			 String *cname;
			 name = Getattr(yyvsp[0].node,k_name);
			 cname = Copy(name);
			 Setattr(yyval.node,"tdname",cname);
			 Delete(cname);

			 /* Use typedef name as class name */
			 if (class_rename && (Strcmp(class_rename,yyvsp[-6].str) == 0)) {
			   Delete(class_rename);
			   class_rename = NewString(name);
			 }
			 if (!Getattr(classes,name)) {
			   Setattr(classes,name,yyval.node);
			 }
			 Setattr(yyval.node,k_decl,decltype);
		       }
		     }
		   }
		   appendChild(yyval.node,dump_nested(Char(name)));
		 }

		 if (cplus_mode != CPLUS_PUBLIC) {
		 /* we 'open' the class at the end, to allow %template
		    to add new members */
		   Node *pa = new_node("access");
		   Setattr(pa,k_kind,"public");
		   cplus_mode = CPLUS_PUBLIC;
		   appendChild(yyval.node,pa);
		   Delete(pa);
		 }

		 Setattr(yyval.node,k_symtab,Swig_symbol_popscope());

		 Classprefix = 0;
		 if (nscope_inner) {
		   /* this is tricky */
		   /* we add the declaration in the original namespace */
		   appendChild(nscope_inner,yyval.node);
		   Swig_symbol_setscope(Getattr(nscope_inner,k_symtab));
		   Delete(Namespaceprefix);
		   Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		   add_symbols(yyval.node);
		   if (nscope) yyval.node = nscope;
		   /* but the variable definition in the current scope */
		   Swig_symbol_setscope(cscope);
		   Delete(Namespaceprefix);
		   Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		   add_symbols(yyvsp[0].node);
		 } else {
		   Delete(yyrename);
		   yyrename = Copy(class_rename);
		   Delete(Namespaceprefix);
		   Namespaceprefix = Swig_symbol_qualifiedscopename(0);

		   add_symbols(yyval.node);
		   add_symbols(yyvsp[0].node);
		 }
		 Swig_symbol_setscope(cscope);
		 Delete(Namespaceprefix);
		 Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	       }
    break;

  case 138:
#line 3328 "parser.y"
    {
	       String *unnamed;
	       unnamed = make_unnamed();
	       yyval.node = new_node("class");
	       Setline(yyval.node,cparse_start_line);
	       Setattr(yyval.node,k_kind,yyvsp[-1].id);
	       Setattr(yyval.node,k_storage,yyvsp[-2].id);
	       Setattr(yyval.node,k_unnamed,unnamed);
	       Setattr(yyval.node,"allows_typedef","1");
	       Delete(class_rename);
	       class_rename = make_name(yyval.node,0,0);
	       if (strcmp(yyvsp[-1].id,"class") == 0) {
		 cplus_mode = CPLUS_PRIVATE;
	       } else {
		 cplus_mode = CPLUS_PUBLIC;
	       }
	       Swig_symbol_newscope();
	       cparse_start_line = cparse_line;
	       class_decl[class_level++] = yyval.node;
	       inclass = 1;
	       Classprefix = NewStringEmpty();
	       Delete(Namespaceprefix);
	       Namespaceprefix = Swig_symbol_qualifiedscopename(0);
             }
    break;

  case 139:
#line 3351 "parser.y"
    {
	       String *unnamed;
	       Node *n;
	       Classprefix = 0;
	       yyval.node = class_decl[--class_level];
	       inclass = 0;
	       unnamed = Getattr(yyval.node,k_unnamed);

	       /* Check for pure-abstract class */
	       Setattr(yyval.node,k_abstract, pure_abstract(yyvsp[-3].node));

	       n = new_node("cdecl");
	       Setattr(n,k_name,yyvsp[-1].decl.id);
	       Setattr(n,k_unnamed,unnamed);
	       Setattr(n,k_type,unnamed);
	       Setattr(n,k_decl,yyvsp[-1].decl.type);
	       Setattr(n,k_parms,yyvsp[-1].decl.parms);
	       Setattr(n,k_storage,yyvsp[-7].id);
	       if (yyvsp[0].node) {
		 Node *p = yyvsp[0].node;
		 set_nextSibling(n,p);
		 while (p) {
		   String *type = Copy(unnamed);
		   Setattr(p,k_unnamed,unnamed);
		   Setattr(p,k_type,type);
		   Delete(type);
		   Setattr(p,k_storage,yyvsp[-7].id);
		   p = nextSibling(p);
		 }
	       }
	       set_nextSibling(yyval.node,n);
	       Delete(n);
	       {
		 /* If a proper typedef name was given, we'll use it to set the scope name */
		 String *name = 0;
		 if (yyvsp[-7].id && (strcmp(yyvsp[-7].id,"typedef") == 0)) {
		   if (!Len(yyvsp[-1].decl.type)) {	
		     String *scpname = 0;
		     name = yyvsp[-1].decl.id;
		     Setattr(yyval.node,"tdname",name);
		     Setattr(yyval.node,k_name,name);
		     Swig_symbol_setscopename(name);

		     /* If a proper name given, we use that as the typedef, not unnamed */
		     Clear(unnamed);
		     Append(unnamed, name);
		     
		     n = nextSibling(n);
		     set_nextSibling(yyval.node,n);

		     /* Check for previous extensions */
		     if (extendhash) {
		       String *clsname = Swig_symbol_qualifiedscopename(0);
		       Node *am = Getattr(extendhash,clsname);
		       if (am) {
			 /* Merge the extension into the symbol table */
			 merge_extensions(yyval.node,am);
			 append_previous_extension(yyval.node,am);
			 Delattr(extendhash,clsname);
		       }
		       Delete(clsname);
		     }
		     if (!classes) classes = NewHash();
		     scpname = Swig_symbol_qualifiedscopename(0);
		     Setattr(classes,scpname,yyval.node);
		     Delete(scpname);
		   } else {
		     Swig_symbol_setscopename((char*)"<unnamed>");
		   }
		 }
		 appendChild(yyval.node,yyvsp[-3].node);
		 appendChild(yyval.node,dump_nested(Char(name)));
	       }
	       /* Pop the scope */
	       Setattr(yyval.node,k_symtab,Swig_symbol_popscope());
	       if (class_rename) {
		 Delete(yyrename);
		 yyrename = NewString(class_rename);
	       }
	       Delete(Namespaceprefix);
	       Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	       add_symbols(yyval.node);
	       add_symbols(n);
	       Delete(unnamed);
              }
    break;

  case 140:
#line 3438 "parser.y"
    { yyval.node = 0; }
    break;

  case 141:
#line 3439 "parser.y"
    {
                        yyval.node = new_node("cdecl");
                        Setattr(yyval.node,k_name,yyvsp[-1].decl.id);
                        Setattr(yyval.node,k_decl,yyvsp[-1].decl.type);
                        Setattr(yyval.node,k_parms,yyvsp[-1].decl.parms);
			set_nextSibling(yyval.node,yyvsp[0].node);
                    }
    break;

  case 142:
#line 3451 "parser.y"
    {
              if (yyvsp[-3].id && (Strcmp(yyvsp[-3].id,"friend") == 0)) {
		/* Ignore */
                yyval.node = 0; 
	      } else {
		yyval.node = new_node("classforward");
		Setfile(yyval.node,cparse_file);
		Setline(yyval.node,cparse_line);
		Setattr(yyval.node,k_kind,yyvsp[-2].id);
		Setattr(yyval.node,k_name,yyvsp[-1].str);
		Setattr(yyval.node,k_symweak, "1");
		add_symbols(yyval.node);
	      }
             }
    break;

  case 143:
#line 3471 "parser.y"
    { template_parameters = yyvsp[-1].tparms; }
    break;

  case 144:
#line 3471 "parser.y"
    {
		      String *tname = 0;
		      int     error = 0;

		      /* check if we get a namespace node with a class declaration, and retrieve the class */
		      Symtab *cscope = Swig_symbol_current();
		      Symtab *sti = 0;
		      Node *ntop = yyvsp[0].node;
		      Node *ni = ntop;
		      SwigType *ntype = ni ? nodeType(ni) : 0;
		      while (ni && Strcmp(ntype,"namespace") == 0) {
			sti = Getattr(ni,k_symtab);
			ni = firstChild(ni);
			ntype = nodeType(ni);
		      }
		      if (sti) {
			Swig_symbol_setscope(sti);
			Delete(Namespaceprefix);
			Namespaceprefix = Swig_symbol_qualifiedscopename(0);
			yyvsp[0].node = ni;
		      }

                      template_parameters = 0;
                      yyval.node = yyvsp[0].node;
		      if (yyval.node) tname = Getattr(yyval.node,k_name);
		      
		      /* Check if the class is a template specialization */
		      if ((yyval.node) && (Strstr(tname,"<")) && (!is_operator(tname))) {
			/* If a specialization.  Check if defined. */
			Node *tempn = 0;
			{
			  String *tbase = SwigType_templateprefix(tname);
			  tempn = Swig_symbol_clookup_local(tbase,0);
			  if (!tempn || (Strcmp(nodeType(tempn),"template") != 0)) {
			    SWIG_WARN_NODE_BEGIN(tempn);
			    Swig_warning(WARN_PARSE_TEMPLATE_SP_UNDEF, Getfile(yyval.node),Getline(yyval.node),"Specialization of non-template '%s'.\n", tbase);
			    SWIG_WARN_NODE_END(tempn);
			    tempn = 0;
			    error = 1;
			  }
			  Delete(tbase);
			}
			Setattr(yyval.node,"specialization","1");
			Setattr(yyval.node,k_templatetype,nodeType(yyval.node));
			set_nodeType(yyval.node,"template");
			/* Template partial specialization */
			if (tempn && (yyvsp[-3].tparms) && (yyvsp[0].node)) {
			  List   *tlist;
			  String *targs = SwigType_templateargs(tname);
			  tlist = SwigType_parmlist(targs);
			  /*			  Printf(stdout,"targs = '%s' %s\n", targs, tlist); */
			  if (!Getattr(yyval.node,k_symweak)) {
			    Setattr(yyval.node,k_symtypename,"1");
			  }
			  
			  if (Len(tlist) != ParmList_len(Getattr(tempn,k_templateparms))) {
			    Swig_error(Getfile(yyval.node),Getline(yyval.node),"Inconsistent argument count in template partial specialization. %d %d\n", Len(tlist), ParmList_len(Getattr(tempn,k_templateparms)));
			    
			  } else {

			  /* This code builds the argument list for the partial template
                             specialization.  This is a little hairy, but the idea is as
                             follows:

                             $3 contains a list of arguments supplied for the template.
                             For example template<class T>.

                             tlist is a list of the specialization arguments--which may be
                             different.  For example class<int,T>.

                             tp is a copy of the arguments in the original template definition.
     
                             The patching algorithm walks through the list of supplied
                             arguments ($3), finds the position in the specialization arguments
                             (tlist), and then patches the name in the argument list of the
                             original template.
			  */

			  {
			    String *pn;
			    Parm *p, *p1;
			    int i, nargs;
			    Parm *tp = CopyParmList(Getattr(tempn,k_templateparms));
			    nargs = Len(tlist);
			    p = yyvsp[-3].tparms;
			    while (p) {
			      for (i = 0; i < nargs; i++){
				pn = Getattr(p,k_name);
				if (Strcmp(pn,SwigType_base(Getitem(tlist,i))) == 0) {
				  int j;
				  Parm *p1 = tp;
				  for (j = 0; j < i; j++) {
				    p1 = nextSibling(p1);
				  }
				  Setattr(p1,k_name,pn);
				  Setattr(p1,k_partialarg,"1");
				}
			      }
			      p = nextSibling(p);
			    }
			    p1 = tp;
			    i = 0;
			    while (p1) {
			      if (!Getattr(p1,k_partialarg)) {
				Delattr(p1,k_name);
				Setattr(p1,k_type, Getitem(tlist,i));
			      } 
			      i++;
			      p1 = nextSibling(p1);
			    }
			    Setattr(yyval.node,k_templateparms,tp);
			    Delete(tp);
			  }
#if 0
			  /* Patch the parameter list */
			  if (tempn) {
			    Parm *p,*p1;
			    ParmList *tp = CopyParmList(Getattr(tempn,k_templateparms));
			    p = yyvsp[-3].tparms;
			    p1 = tp;
			    while (p && p1) {
			      String *pn = Getattr(p,k_name);
			      Printf(stdout,"pn = '%s'\n", pn);
			      if (pn) Setattr(p1,k_name,pn);
			      else Delattr(p1,k_name);
			      pn = Getattr(p,k_type);
			      if (pn) Setattr(p1,k_type,pn);
			      p = nextSibling(p);
			      p1 = nextSibling(p1);
			    }
			    Setattr(yyval.node,k_templateparms,tp);
			    Delete(tp);
			  } else {
			    Setattr(yyval.node,k_templateparms,yyvsp[-3].tparms);
			  }
#endif
			  Delattr(yyval.node,"specialization");
			  Setattr(yyval.node,"partialspecialization","1");
			  /* Create a specialized name for matching */
			  {
			    Parm *p = yyvsp[-3].tparms;
			    String *fname = NewString(Getattr(yyval.node,k_name));
			    String *ffname = 0;

			    char   tmp[32];
			    int    i, ilen;
			    while (p) {
			      String *n = Getattr(p,k_name);
			      if (!n) {
				p = nextSibling(p);
				continue;
			      }
			      ilen = Len(tlist);
			      for (i = 0; i < ilen; i++) {
				if (Strstr(Getitem(tlist,i),n)) {
				  sprintf(tmp,"$%d",i+1);
				  Replaceid(fname,n,tmp);
				}
			      }
			      p = nextSibling(p);
			    }
			    /* Patch argument names with typedef */
			    {
			      Iterator tt;
			      List *tparms = SwigType_parmlist(fname);
			      ffname = SwigType_templateprefix(fname);
			      Append(ffname,"<(");
			      for (tt = First(tparms); tt.item; ) {
				SwigType *rtt = Swig_symbol_typedef_reduce(tt.item,0);
				SwigType *ttr = Swig_symbol_type_qualify(rtt,0);
				Append(ffname,ttr);
				tt = Next(tt);
				if (tt.item) Putc(',',ffname);
				Delete(rtt);
				Delete(ttr);
			      }
			      Delete(tparms);
			      Append(ffname,")>");
			    }
			    {
			      String *partials = Getattr(tempn,k_partials);
			      if (!partials) {
				partials = NewList();
				Setattr(tempn,k_partials,partials);
				Delete(partials);
			      }
			      /*			      Printf(stdout,"partial: fname = '%s', '%s'\n", fname, Swig_symbol_typedef_reduce(fname,0)); */
			      Append(partials,ffname);
			    }
			    Setattr(yyval.node,k_partialargs,ffname);
			    Swig_symbol_cadd(ffname,yyval.node);
			  }
			  }
			  Delete(tlist);
			  Delete(targs);
			} else {
			  /* Need to resolve exact specialization name */
			  /* add default args from generic template */
			  String *ty = Swig_symbol_template_deftype(tname,0);
			  String *fname = Swig_symbol_type_qualify(ty,0);
			  Swig_symbol_cadd(fname,yyval.node);
			  Delete(ty);
			  Delete(fname);
			}
		      }  else if (yyval.node) {
			Setattr(yyval.node,k_templatetype,nodeType(yyvsp[0].node));
			set_nodeType(yyval.node,"template");
			Setattr(yyval.node,k_templateparms, yyvsp[-3].tparms);
			if (!Getattr(yyval.node,k_symweak)) {
			  Setattr(yyval.node,k_symtypename,"1");
			}
			add_symbols(yyval.node);
                        default_arguments(yyval.node);
			/* We also place a fully parameterized version in the symbol table */
			{
			  Parm *p;
			  String *fname = NewStringf("%s<(", Getattr(yyval.node,k_name));
			  p = yyvsp[-3].tparms;
			  while (p) {
			    String *n = Getattr(p,k_name);
			    if (!n) n = Getattr(p,k_type);
			    Append(fname,n);
			    p = nextSibling(p);
			    if (p) Putc(',',fname);
			  }
			  Append(fname,")>");
			  Swig_symbol_cadd(fname,yyval.node);
			}
		      }
		      yyval.node = ntop;
		      Swig_symbol_setscope(cscope);
		      Delete(Namespaceprefix);
		      Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		      if (error) yyval.node = 0;
                  }
    break;

  case 145:
#line 3706 "parser.y"
    {
		  Swig_warning(WARN_PARSE_EXPLICIT_TEMPLATE, cparse_file, cparse_line, "Explicit template instantiation ignored.\n");
                   yyval.node = 0; 
                }
    break;

  case 146:
#line 3712 "parser.y"
    {
		  yyval.node = yyvsp[0].node;
                }
    break;

  case 147:
#line 3715 "parser.y"
    {
                   yyval.node = yyvsp[0].node;
                }
    break;

  case 148:
#line 3718 "parser.y"
    {
                   yyval.node = yyvsp[0].node;
                }
    break;

  case 149:
#line 3721 "parser.y"
    {
		  yyval.node = 0;
                }
    break;

  case 150:
#line 3724 "parser.y"
    {
                  yyval.node = yyvsp[0].node;
                }
    break;

  case 151:
#line 3727 "parser.y"
    {
                  yyval.node = yyvsp[0].node;
                }
    break;

  case 152:
#line 3732 "parser.y"
    {
		   /* Rip out the parameter names */
		  Parm *p = yyvsp[0].pl;
		  yyval.tparms = yyvsp[0].pl;

		  while (p) {
		    String *name = Getattr(p,k_name);
		    if (!name) {
		      /* Hmmm. Maybe it's a 'class T' parameter */
		      char *type = Char(Getattr(p,k_type));
		      /* Template template parameter */
		      if (strncmp(type,"template<class> ",16) == 0) {
			type += 16;
		      }
		      if ((strncmp(type,"class ",6) == 0) || (strncmp(type,"typename ", 9) == 0)) {
			char *t = strchr(type,' ');
			Setattr(p,k_name, t+1);
		      } else {
			/*
			 Swig_error(cparse_file, cparse_line, "Missing template parameter name\n");
			 $$.rparms = 0;
			 $$.parms = 0;
			 break; */
		      }
		    }
		    p = nextSibling(p);
		  }
                 }
    break;

  case 153:
#line 3764 "parser.y"
    {
                  String *uname = Swig_symbol_type_qualify(yyvsp[-1].str,0);
		  String *name = Swig_scopename_last(yyvsp[-1].str);
                  yyval.node = new_node("using");
		  Setattr(yyval.node,k_uname,uname);
		  Setattr(yyval.node,k_name, name);
		  Delete(uname);
		  Delete(name);
		  add_symbols(yyval.node);
             }
    break;

  case 154:
#line 3774 "parser.y"
    {
	       Node *n = Swig_symbol_clookup(yyvsp[-1].str,0);
	       if (!n) {
		 Swig_error(cparse_file, cparse_line, "Nothing known about namespace '%s'\n", yyvsp[-1].str);
		 yyval.node = 0;
	       } else {

		 while (Strcmp(nodeType(n),"using") == 0) {
		   n = Getattr(n,"node");
		 }
		 if (n) {
		   if (Strcmp(nodeType(n),"namespace") == 0) {
		     yyval.node = new_node("using");
		     Setattr(yyval.node,"node",n);
		     Setattr(yyval.node,k_namespace, yyvsp[-1].str);
		     Swig_symbol_inherit(Getattr(n,k_symtab));
		   } else {
		     Swig_error(cparse_file, cparse_line, "'%s' is not a namespace.\n", yyvsp[-1].str);
		     yyval.node = 0;
		   }
		 } else {
		   yyval.node = 0;
		 }
	       }
             }
    break;

  case 155:
#line 3801 "parser.y"
    { 
                Hash *h;
                yyvsp[-2].node = Swig_symbol_current();
		h = Swig_symbol_clookup(yyvsp[-1].str,0);
		if (h && (Strcmp(nodeType(h),"namespace") == 0)) {
		  if (Getattr(h,k_alias)) {
		    h = Getattr(h,k_namespace);
		    Swig_warning(WARN_PARSE_NAMESPACE_ALIAS, cparse_file, cparse_line, "Namespace alias '%s' not allowed here. Assuming '%s'\n",
				 yyvsp[-1].str, Getattr(h,k_name));
		    yyvsp[-1].str = Getattr(h,k_name);
		  }
		  Swig_symbol_setscope(Getattr(h,k_symtab));
		} else {
		  Swig_symbol_newscope();
		  Swig_symbol_setscopename(yyvsp[-1].str);
		}
		Delete(Namespaceprefix);
		Namespaceprefix = Swig_symbol_qualifiedscopename(0);
             }
    break;

  case 156:
#line 3819 "parser.y"
    {
                Node *n = yyvsp[-1].node;
		set_nodeType(n,"namespace");
		Setattr(n,k_name,yyvsp[-4].str);
                Setattr(n,k_symtab, Swig_symbol_popscope());
		Swig_symbol_setscope(yyvsp[-5].node);
		yyval.node = n;
		Delete(Namespaceprefix);
		Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		add_symbols(yyval.node);
             }
    break;

  case 157:
#line 3830 "parser.y"
    {
	       Hash *h;
	       yyvsp[-1].node = Swig_symbol_current();
	       h = Swig_symbol_clookup((char *)"    ",0);
	       if (h && (Strcmp(nodeType(h),"namespace") == 0)) {
		 Swig_symbol_setscope(Getattr(h,k_symtab));
	       } else {
		 Swig_symbol_newscope();
		 /* we don't use "__unnamed__", but a long 'empty' name */
		 Swig_symbol_setscopename("    ");
	       }
	       Namespaceprefix = 0;
             }
    break;

  case 158:
#line 3842 "parser.y"
    {
	       yyval.node = yyvsp[-1].node;
	       set_nodeType(yyval.node,"namespace");
	       Setattr(yyval.node,k_unnamed,"1");
	       Setattr(yyval.node,k_symtab, Swig_symbol_popscope());
	       Swig_symbol_setscope(yyvsp[-4].node);
	       Delete(Namespaceprefix);
	       Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	       add_symbols(yyval.node);
             }
    break;

  case 159:
#line 3852 "parser.y"
    {
	       /* Namespace alias */
	       Node *n;
	       yyval.node = new_node("namespace");
	       Setattr(yyval.node,k_name,yyvsp[-3].id);
	       Setattr(yyval.node,k_alias,yyvsp[-1].str);
	       n = Swig_symbol_clookup(yyvsp[-1].str,0);
	       if (!n) {
		 Swig_error(cparse_file, cparse_line, "Unknown namespace '%s'\n", yyvsp[-1].str);
		 yyval.node = 0;
	       } else {
		 if (Strcmp(nodeType(n),"namespace") != 0) {
		   Swig_error(cparse_file, cparse_line, "'%s' is not a namespace\n",yyvsp[-1].str);
		   yyval.node = 0;
		 } else {
		   while (Getattr(n,k_alias)) {
		     n = Getattr(n,k_namespace);
		   }
		   Setattr(yyval.node,k_namespace,n);
		   add_symbols(yyval.node);
		   /* Set up a scope alias */
		   Swig_symbol_alias(yyvsp[-3].id,Getattr(n,k_symtab));
		 }
	       }
             }
    break;

  case 160:
#line 3879 "parser.y"
    {
                   yyval.node = yyvsp[-1].node;
                   /* Insert cpp_member (including any siblings) to the front of the cpp_members linked list */
		   if (yyval.node) {
		     Node *p = yyval.node;
		     Node *pp =0;
		     while (p) {
		       pp = p;
		       p = nextSibling(p);
		     }
		     set_nextSibling(pp,yyvsp[0].node);
		   } else {
		     yyval.node = yyvsp[0].node;
		   }
             }
    break;

  case 161:
#line 3894 "parser.y"
    { 
                  if (cplus_mode != CPLUS_PUBLIC) {
		     Swig_error(cparse_file,cparse_line,"%%extend can only be used in a public section\n");
		  }
             }
    break;

  case 162:
#line 3898 "parser.y"
    {
	       yyval.node = new_node("extend");
	       Swig_tag_nodes(yyvsp[-2].node,"feature:extend",(char*) "1");
	       appendChild(yyval.node,yyvsp[-2].node);
	       set_nextSibling(yyval.node,yyvsp[0].node);
	     }
    break;

  case 163:
#line 3904 "parser.y"
    { yyval.node = 0;}
    break;

  case 164:
#line 3905 "parser.y"
    {
	       int start_line = cparse_line;
	       skip_decl();
	       if (!Swig_error_count()) {
		 Swig_error(cparse_file,start_line,"Syntax error in input(3).\n");
	       }
	     }
    break;

  case 165:
#line 3911 "parser.y"
    { 
                yyval.node = yyvsp[0].node;
             }
    break;

  case 166:
#line 3922 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 167:
#line 3923 "parser.y"
    { 
                 yyval.node = yyvsp[0].node; 
		 if (extendmode) {
		   String *symname;
		   symname= make_name(yyval.node,Getattr(yyval.node,k_name), Getattr(yyval.node,k_decl));
		   if (Strcmp(symname,Getattr(yyval.node,k_name)) == 0) {
		     /* No renaming operation.  Set name to class name */
		     Delete(yyrename);
		     yyrename = NewString(Getattr(current_class,k_symname));
		   } else {
		     Delete(yyrename);
		     yyrename = symname;
		   }
		 }
		 add_symbols(yyval.node);
                 default_arguments(yyval.node);
             }
    break;

  case 168:
#line 3940 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 169:
#line 3941 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 170:
#line 3942 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 171:
#line 3943 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 172:
#line 3944 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 173:
#line 3945 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 174:
#line 3946 "parser.y"
    { yyval.node = 0; }
    break;

  case 175:
#line 3947 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 176:
#line 3948 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 177:
#line 3949 "parser.y"
    { yyval.node = 0; }
    break;

  case 178:
#line 3950 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 179:
#line 3951 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 180:
#line 3952 "parser.y"
    { yyval.node = 0; }
    break;

  case 181:
#line 3953 "parser.y"
    {yyval.node = yyvsp[0].node; }
    break;

  case 182:
#line 3954 "parser.y"
    {yyval.node = yyvsp[0].node; }
    break;

  case 183:
#line 3955 "parser.y"
    { yyval.node = 0; }
    break;

  case 184:
#line 3964 "parser.y"
    {
              if (Classprefix) {
		 SwigType *decl = NewStringEmpty();
		 yyval.node = new_node("constructor");
		 Setattr(yyval.node,k_storage,yyvsp[-5].id);
		 Setattr(yyval.node,k_name,yyvsp[-4].type);
		 Setattr(yyval.node,k_parms,yyvsp[-2].pl);
		 SwigType_add_function(decl,yyvsp[-2].pl);
		 Setattr(yyval.node,k_decl,decl);
		 Setattr(yyval.node,k_throws,yyvsp[0].decl.throws);
		 Setattr(yyval.node,k_throw,yyvsp[0].decl.throwf);
		 if (Len(scanner_ccode)) {
		   String *code = Copy(scanner_ccode);
		   Setattr(yyval.node,k_code,code);
		   Delete(code);
		 }
		 SetFlag(yyval.node,"feature:new");
	      } else {
		yyval.node = 0;
              }
              }
    break;

  case 185:
#line 3989 "parser.y"
    {
               String *name = NewStringf("%s",yyvsp[-4].str);
	       if (*(Char(name)) != '~') Insert(name,0,"~");
               yyval.node = new_node("destructor");
	       Setattr(yyval.node,k_name,name);
	       Delete(name);
	       if (Len(scanner_ccode)) {
		 String *code = Copy(scanner_ccode);
		 Setattr(yyval.node,k_code,code);
		 Delete(code);
	       }
	       {
		 String *decl = NewStringEmpty();
		 SwigType_add_function(decl,yyvsp[-2].pl);
		 Setattr(yyval.node,k_decl,decl);
		 Delete(decl);
	       }
	       Setattr(yyval.node,k_throws,yyvsp[0].dtype.throws);
	       Setattr(yyval.node,k_throw,yyvsp[0].dtype.throwf);
	       add_symbols(yyval.node);
	      }
    break;

  case 186:
#line 4013 "parser.y"
    {
		String *name;
		char *c;
		yyval.node = new_node("destructor");
	       /* Check for template names.  If the class is a template
		  and the constructor is missing the template part, we
		  add it */
	        if ((c = strstr(Char(Classprefix),"<"))) {
		  if (!Strstr(yyvsp[-4].str,"<")) {
		    yyvsp[-4].str = NewStringf("%s%s",yyvsp[-4].str,c);
		  }
		}
		Setattr(yyval.node,k_storage,"virtual");
	        name = NewStringf("%s",yyvsp[-4].str);
		if (*(Char(name)) != '~') Insert(name,0,"~");
		Setattr(yyval.node,k_name,name);
		Delete(name);
		Setattr(yyval.node,k_throws,yyvsp[0].dtype.throws);
		Setattr(yyval.node,k_throw,yyvsp[0].dtype.throwf);
		if (yyvsp[0].dtype.val) {
		  Setattr(yyval.node,k_value,"0");
		}
		if (Len(scanner_ccode)) {
		  String *code = Copy(scanner_ccode);
		  Setattr(yyval.node,k_code,code);
		  Delete(code);
		}
		{
		  String *decl = NewStringEmpty();
		  SwigType_add_function(decl,yyvsp[-2].pl);
		  Setattr(yyval.node,k_decl,decl);
		  Delete(decl);
		}

		add_symbols(yyval.node);
	      }
    break;

  case 187:
#line 4053 "parser.y"
    {
                 yyval.node = new_node("cdecl");
                 Setattr(yyval.node,k_type,yyvsp[-5].type);
		 Setattr(yyval.node,k_name,yyvsp[-6].str);

		 SwigType_add_function(yyvsp[-4].type,yyvsp[-2].pl);
		 if (yyvsp[0].dtype.qualifier) {
		   SwigType_push(yyvsp[-4].type,yyvsp[0].dtype.qualifier);
		 }
		 Setattr(yyval.node,k_decl,yyvsp[-4].type);
		 Setattr(yyval.node,k_parms,yyvsp[-2].pl);
		 Setattr(yyval.node,k_conversionoperator,"1");
		 add_symbols(yyval.node);
              }
    break;

  case 188:
#line 4067 "parser.y"
    {
		 SwigType *decl;
                 yyval.node = new_node("cdecl");
                 Setattr(yyval.node,k_type,yyvsp[-5].type);
		 Setattr(yyval.node,k_name,yyvsp[-6].str);
		 decl = NewStringEmpty();
		 SwigType_add_reference(decl);
		 SwigType_add_function(decl,yyvsp[-2].pl);
		 if (yyvsp[0].dtype.qualifier) {
		   SwigType_push(decl,yyvsp[0].dtype.qualifier);
		 }
		 Setattr(yyval.node,k_decl,decl);
		 Setattr(yyval.node,k_parms,yyvsp[-2].pl);
		 Setattr(yyval.node,k_conversionoperator,"1");
		 add_symbols(yyval.node);
	       }
    break;

  case 189:
#line 4084 "parser.y"
    {
		String *t = NewStringEmpty();
		yyval.node = new_node("cdecl");
		Setattr(yyval.node,k_type,yyvsp[-4].type);
		Setattr(yyval.node,k_name,yyvsp[-5].str);
		SwigType_add_function(t,yyvsp[-2].pl);
		if (yyvsp[0].dtype.qualifier) {
		  SwigType_push(t,yyvsp[0].dtype.qualifier);
		}
		Setattr(yyval.node,k_decl,t);
		Setattr(yyval.node,k_parms,yyvsp[-2].pl);
		Setattr(yyval.node,k_conversionoperator,"1");
		add_symbols(yyval.node);
              }
    break;

  case 190:
#line 4102 "parser.y"
    {
                 skip_balanced('{','}');
                 yyval.node = 0;
               }
    break;

  case 191:
#line 4109 "parser.y"
    { 
                yyval.node = new_node("access");
		Setattr(yyval.node,k_kind,"public");
                cplus_mode = CPLUS_PUBLIC;
              }
    break;

  case 192:
#line 4116 "parser.y"
    { 
                yyval.node = new_node("access");
                Setattr(yyval.node,k_kind,"private");
		cplus_mode = CPLUS_PRIVATE;
	      }
    break;

  case 193:
#line 4124 "parser.y"
    { 
		yyval.node = new_node("access");
		Setattr(yyval.node,k_kind,"protected");
		cplus_mode = CPLUS_PROTECTED;
	      }
    break;

  case 194:
#line 4147 "parser.y"
    { cparse_start_line = cparse_line; skip_balanced('{','}');
	      }
    break;

  case 195:
#line 4148 "parser.y"
    {
	        yyval.node = 0;
		if (cplus_mode == CPLUS_PUBLIC) {
		  if (yyvsp[-1].decl.id) {
		    if (strcmp(yyvsp[-5].id,"class") == 0) {
		      Swig_warning(WARN_PARSE_NESTED_CLASS, cparse_file, cparse_line, "Nested classes not currently supported (ignored).\n");
		      /* Generate some code for a new class */
		    } else {
		      Nested *n = (Nested *) malloc(sizeof(Nested));
		      n->code = NewStringEmpty();
		      Printv(n->code, "typedef ", yyvsp[-5].id, " ",
			     Char(scanner_ccode), " $classname_", yyvsp[-1].decl.id, ";\n", NIL);

		      n->name = Swig_copy_string(yyvsp[-1].decl.id);
		      n->line = cparse_start_line;
		      n->type = NewStringEmpty();
		      n->kind = yyvsp[-5].id;
		      n->unnamed = 0;
		      SwigType_push(n->type, yyvsp[-1].decl.type);
		      n->next = 0;
		      add_nested(n);
		    }
		  } else {
		    Swig_warning(WARN_PARSE_NESTED_CLASS, cparse_file, cparse_line, "Nested %s not currently supported (ignored).\n", yyvsp[-5].id);
		  }
		}
	      }
    break;

  case 196:
#line 4176 "parser.y"
    { cparse_start_line = cparse_line; skip_balanced('{','}');
              }
    break;

  case 197:
#line 4177 "parser.y"
    {
	        yyval.node = 0;
		if (cplus_mode == CPLUS_PUBLIC) {
		  if (strcmp(yyvsp[-4].id,"class") == 0) {
		    Swig_warning(WARN_PARSE_NESTED_CLASS,cparse_file, cparse_line,"Nested class not currently supported (ignored)\n");
		    /* Generate some code for a new class */
		  } else if (yyvsp[-1].decl.id) {
		    /* Generate some code for a new class */
		    Nested *n = (Nested *) malloc(sizeof(Nested));
		    n->code = NewStringEmpty();
		    Printv(n->code, "typedef ", yyvsp[-4].id, " " ,
			    Char(scanner_ccode), " $classname_", yyvsp[-1].decl.id, ";\n",NIL);
		    n->name = Swig_copy_string(yyvsp[-1].decl.id);
		    n->line = cparse_start_line;
		    n->type = NewStringEmpty();
		    n->kind = yyvsp[-4].id;
		    n->unnamed = 1;
		    SwigType_push(n->type,yyvsp[-1].decl.type);
		    n->next = 0;
		    add_nested(n);
		  } else {
		    Swig_warning(WARN_PARSE_NESTED_CLASS, cparse_file, cparse_line, "Nested %s not currently supported (ignored).\n", yyvsp[-4].id);
		  }
		}
	      }
    break;

  case 198:
#line 4207 "parser.y"
    { cparse_start_line = cparse_line; skip_balanced('{','}');
              }
    break;

  case 199:
#line 4208 "parser.y"
    {
	        yyval.node = 0;
		if (cplus_mode == CPLUS_PUBLIC) {
		  Swig_warning(WARN_PARSE_NESTED_CLASS,cparse_file, cparse_line,"Nested class not currently supported (ignored)\n");
		}
	      }
    break;

  case 200:
#line 4225 "parser.y"
    { yyval.decl = yyvsp[0].decl;}
    break;

  case 201:
#line 4226 "parser.y"
    { yyval.decl.id = 0; }
    break;

  case 202:
#line 4232 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 203:
#line 4235 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 204:
#line 4239 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 205:
#line 4242 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 206:
#line 4243 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 207:
#line 4244 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 208:
#line 4245 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 209:
#line 4246 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 210:
#line 4247 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 211:
#line 4248 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 212:
#line 4249 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 213:
#line 4252 "parser.y"
    {
	            Clear(scanner_ccode);
		    yyval.dtype.throws = yyvsp[-1].dtype.throws;
		    yyval.dtype.throwf = yyvsp[-1].dtype.throwf;
               }
    break;

  case 214:
#line 4257 "parser.y"
    { 
		    skip_balanced('{','}'); 
		    yyval.dtype.throws = yyvsp[-1].dtype.throws;
		    yyval.dtype.throwf = yyvsp[-1].dtype.throwf;
	       }
    break;

  case 215:
#line 4264 "parser.y"
    { 
                     Clear(scanner_ccode);
                     yyval.dtype.val = 0;
                     yyval.dtype.qualifier = yyvsp[-1].dtype.qualifier;
                     yyval.dtype.bitfield = 0;
                     yyval.dtype.throws = yyvsp[-1].dtype.throws;
                     yyval.dtype.throwf = yyvsp[-1].dtype.throwf;
                }
    break;

  case 216:
#line 4272 "parser.y"
    { 
                     Clear(scanner_ccode);
                     yyval.dtype.val = yyvsp[-1].dtype.val;
                     yyval.dtype.qualifier = yyvsp[-3].dtype.qualifier;
                     yyval.dtype.bitfield = 0;
                     yyval.dtype.throws = yyvsp[-3].dtype.throws; 
                     yyval.dtype.throwf = yyvsp[-3].dtype.throwf; 
               }
    break;

  case 217:
#line 4280 "parser.y"
    { 
                     skip_balanced('{','}');
                     yyval.dtype.val = 0;
                     yyval.dtype.qualifier = yyvsp[-1].dtype.qualifier;
                     yyval.dtype.bitfield = 0;
                     yyval.dtype.throws = yyvsp[-1].dtype.throws; 
                     yyval.dtype.throwf = yyvsp[-1].dtype.throwf; 
               }
    break;

  case 218:
#line 4291 "parser.y"
    { }
    break;

  case 219:
#line 4297 "parser.y"
    { yyval.id = "extern"; }
    break;

  case 220:
#line 4298 "parser.y"
    { 
                   if (strcmp(yyvsp[0].id,"C") == 0) {
		     yyval.id = "externc";
		   } else {
		     Swig_warning(WARN_PARSE_UNDEFINED_EXTERN,cparse_file, cparse_line,"Unrecognized extern type \"%s\".\n", yyvsp[0].id);
		     yyval.id = 0;
		   }
               }
    break;

  case 221:
#line 4306 "parser.y"
    { yyval.id = "static"; }
    break;

  case 222:
#line 4307 "parser.y"
    { yyval.id = "typedef"; }
    break;

  case 223:
#line 4308 "parser.y"
    { yyval.id = "virtual"; }
    break;

  case 224:
#line 4309 "parser.y"
    { yyval.id = "friend"; }
    break;

  case 225:
#line 4310 "parser.y"
    { yyval.id = "explicit"; }
    break;

  case 226:
#line 4311 "parser.y"
    { yyval.id = 0; }
    break;

  case 227:
#line 4318 "parser.y"
    {
                 Parm *p;
		 yyval.pl = yyvsp[0].pl;
		 p = yyvsp[0].pl;
                 while (p) {
		   Replace(Getattr(p,k_type),"typename ", "", DOH_REPLACE_ANY);
		   p = nextSibling(p);
                 }
               }
    break;

  case 228:
#line 4329 "parser.y"
    {
		  if (1) { 
		    set_nextSibling(yyvsp[-1].p,yyvsp[0].pl);
		    yyval.pl = yyvsp[-1].p;
		  } else {
		    yyval.pl = yyvsp[0].pl;
		  }
		}
    break;

  case 229:
#line 4337 "parser.y"
    { yyval.pl = 0; }
    break;

  case 230:
#line 4340 "parser.y"
    {
                 set_nextSibling(yyvsp[-1].p,yyvsp[0].pl);
		 yyval.pl = yyvsp[-1].p;
                }
    break;

  case 231:
#line 4344 "parser.y"
    { yyval.pl = 0; }
    break;

  case 232:
#line 4348 "parser.y"
    {
                   SwigType_push(yyvsp[-1].type,yyvsp[0].decl.type);
		   yyval.p = NewParm(yyvsp[-1].type,yyvsp[0].decl.id);
		   Setfile(yyval.p,cparse_file);
		   Setline(yyval.p,cparse_line);
		   if (yyvsp[0].decl.defarg) {
		     Setattr(yyval.p,k_value,yyvsp[0].decl.defarg);
		   }
		}
    break;

  case 233:
#line 4358 "parser.y"
    {
                  yyval.p = NewParm(NewStringf("template<class> %s %s", yyvsp[-1].id,yyvsp[0].str), 0);
		  Setfile(yyval.p,cparse_file);
		  Setline(yyval.p,cparse_line);
                }
    break;

  case 234:
#line 4363 "parser.y"
    {
		  SwigType *t = NewString("v(...)");
		  yyval.p = NewParm(t, 0);
		  Setfile(yyval.p,cparse_file);
		  Setline(yyval.p,cparse_line);
		}
    break;

  case 235:
#line 4371 "parser.y"
    {
                 Parm *p;
		 yyval.p = yyvsp[0].p;
		 p = yyvsp[0].p;
                 while (p) {
		   if (Getattr(p,k_type)) {
		     Replace(Getattr(p,k_type),"typename ", "", DOH_REPLACE_ANY);
		   }
		   p = nextSibling(p);
                 }
               }
    break;

  case 236:
#line 4384 "parser.y"
    {
		  if (1) { 
		    set_nextSibling(yyvsp[-1].p,yyvsp[0].p);
		    yyval.p = yyvsp[-1].p;
		  } else {
		    yyval.p = yyvsp[0].p;
		  }
		}
    break;

  case 237:
#line 4392 "parser.y"
    { yyval.p = 0; }
    break;

  case 238:
#line 4395 "parser.y"
    {
                 set_nextSibling(yyvsp[-1].p,yyvsp[0].p);
		 yyval.p = yyvsp[-1].p;
                }
    break;

  case 239:
#line 4399 "parser.y"
    { yyval.p = 0; }
    break;

  case 240:
#line 4403 "parser.y"
    {
		  yyval.p = yyvsp[0].p;
		  {
		    /* We need to make a possible adjustment for integer parameters. */
		    SwigType *type;
		    Node     *n = 0;

		    while (!n) {
		      type = Getattr(yyvsp[0].p,k_type);
		      n = Swig_symbol_clookup(type,0);     /* See if we can find a node that matches the typename */
		      if ((n) && (Strcmp(nodeType(n),"cdecl") == 0)) {
			SwigType *decl = Getattr(n,k_decl);
			if (!SwigType_isfunction(decl)) {
			  String *value = Getattr(n,k_value);
			  if (value) {
			    String *v = Copy(value);
			    Setattr(yyvsp[0].p,k_type,v);
			    Delete(v);
			    n = 0;
			  }
			}
		      } else {
			break;
		      }
		    }
		  }
		  
               }
    break;

  case 241:
#line 4431 "parser.y"
    {
                  yyval.p = NewParm(0,0);
                  Setfile(yyval.p,cparse_file);
		  Setline(yyval.p,cparse_line);
		  Setattr(yyval.p,k_value,yyvsp[0].dtype.val);
               }
    break;

  case 242:
#line 4437 "parser.y"
    {
		  String *v = NewString(yyvsp[0].id);
                  yyval.p = NewParm(0,0);
                  Setfile(yyval.p,cparse_file);
		  Setline(yyval.p,cparse_line);
		  Setattr(yyval.p,k_value,v);
		  Delete(v);
               }
    break;

  case 243:
#line 4447 "parser.y"
    { 
                  yyval.dtype = yyvsp[0].dtype; 
		  if (yyvsp[0].dtype.type == T_ERROR) {
		    Swig_warning(WARN_PARSE_BAD_DEFAULT,cparse_file, cparse_line, "Can't set default argument (ignored)\n");
		    yyval.dtype.val = 0;
		    yyval.dtype.rawval = 0;
		    yyval.dtype.bitfield = 0;
		    yyval.dtype.throws = 0;
		    yyval.dtype.throwf = 0;
		  }
               }
    break;

  case 244:
#line 4458 "parser.y"
    { 
		  yyval.dtype = yyvsp[-3].dtype;
		  if (yyvsp[-3].dtype.type == T_ERROR) {
		    Swig_warning(WARN_PARSE_BAD_DEFAULT,cparse_file, cparse_line, "Can't set default argument (ignored)\n");
		    yyval.dtype = yyvsp[-3].dtype;
		    yyval.dtype.val = 0;
		    yyval.dtype.rawval = 0;
		    yyval.dtype.bitfield = 0;
		    yyval.dtype.throws = 0;
		    yyval.dtype.throwf = 0;
		  } else {
		    yyval.dtype.val = NewStringf("%s[%s]",yyvsp[-3].dtype.val,yyvsp[-1].dtype.val); 
		  }		  
               }
    break;

  case 245:
#line 4472 "parser.y"
    {
		 skip_balanced('{','}');
		 yyval.dtype.val = 0;
		 yyval.dtype.rawval = 0;
                 yyval.dtype.type = T_INT;
		 yyval.dtype.bitfield = 0;
		 yyval.dtype.throws = 0;
		 yyval.dtype.throwf = 0;
	       }
    break;

  case 246:
#line 4481 "parser.y"
    { 
		 yyval.dtype.val = 0;
		 yyval.dtype.rawval = 0;
		 yyval.dtype.type = 0;
		 yyval.dtype.bitfield = yyvsp[0].dtype.val;
		 yyval.dtype.throws = 0;
		 yyval.dtype.throwf = 0;
	       }
    break;

  case 247:
#line 4489 "parser.y"
    {
                 yyval.dtype.val = 0;
                 yyval.dtype.rawval = 0;
                 yyval.dtype.type = T_INT;
		 yyval.dtype.bitfield = 0;
		 yyval.dtype.throws = 0;
		 yyval.dtype.throwf = 0;
               }
    break;

  case 248:
#line 4499 "parser.y"
    {
                 yyval.decl = yyvsp[-1].decl;
		 yyval.decl.defarg = yyvsp[0].dtype.rawval ? yyvsp[0].dtype.rawval : yyvsp[0].dtype.val;
            }
    break;

  case 249:
#line 4503 "parser.y"
    {
              yyval.decl = yyvsp[-1].decl;
	      yyval.decl.defarg = yyvsp[0].dtype.rawval ? yyvsp[0].dtype.rawval : yyvsp[0].dtype.val;
            }
    break;

  case 250:
#line 4507 "parser.y"
    {
   	      yyval.decl.type = 0;
              yyval.decl.id = 0;
	      yyval.decl.defarg = yyvsp[0].dtype.rawval ? yyvsp[0].dtype.rawval : yyvsp[0].dtype.val;
            }
    break;

  case 251:
#line 4514 "parser.y"
    {
                 yyval.decl = yyvsp[0].decl;
		 if (SwigType_isfunction(yyvsp[0].decl.type)) {
		   Delete(SwigType_pop_function(yyvsp[0].decl.type));
		 } else if (SwigType_isarray(yyvsp[0].decl.type)) {
		   SwigType *ta = SwigType_pop_arrays(yyvsp[0].decl.type);
		   if (SwigType_isfunction(yyvsp[0].decl.type)) {
		     Delete(SwigType_pop_function(yyvsp[0].decl.type));
		   } else {
		     yyval.decl.parms = 0;
		   }
		   SwigType_push(yyvsp[0].decl.type,ta);
		   Delete(ta);
		 } else {
		   yyval.decl.parms = 0;
		 }
            }
    break;

  case 252:
#line 4531 "parser.y"
    {
              yyval.decl = yyvsp[0].decl;
	      if (SwigType_isfunction(yyvsp[0].decl.type)) {
		Delete(SwigType_pop_function(yyvsp[0].decl.type));
	      } else if (SwigType_isarray(yyvsp[0].decl.type)) {
		SwigType *ta = SwigType_pop_arrays(yyvsp[0].decl.type);
		if (SwigType_isfunction(yyvsp[0].decl.type)) {
		  Delete(SwigType_pop_function(yyvsp[0].decl.type));
		} else {
		  yyval.decl.parms = 0;
		}
		SwigType_push(yyvsp[0].decl.type,ta);
		Delete(ta);
	      } else {
		yyval.decl.parms = 0;
	      }
            }
    break;

  case 253:
#line 4548 "parser.y"
    {
   	      yyval.decl.type = 0;
              yyval.decl.id = 0;
	      yyval.decl.parms = 0;
	      }
    break;

  case 254:
#line 4556 "parser.y"
    {
              yyval.decl = yyvsp[0].decl;
	      if (yyval.decl.type) {
		SwigType_push(yyvsp[-1].type,yyval.decl.type);
		Delete(yyval.decl.type);
	      }
	      yyval.decl.type = yyvsp[-1].type;
           }
    break;

  case 255:
#line 4564 "parser.y"
    {
              yyval.decl = yyvsp[0].decl;
	      SwigType_add_reference(yyvsp[-2].type);
              if (yyval.decl.type) {
		SwigType_push(yyvsp[-2].type,yyval.decl.type);
		Delete(yyval.decl.type);
	      }
	      yyval.decl.type = yyvsp[-2].type;
           }
    break;

  case 256:
#line 4573 "parser.y"
    {
              yyval.decl = yyvsp[0].decl;
	      if (!yyval.decl.type) yyval.decl.type = NewStringEmpty();
           }
    break;

  case 257:
#line 4577 "parser.y"
    { 
	     yyval.decl = yyvsp[0].decl;
	     yyval.decl.type = NewStringEmpty();
	     SwigType_add_reference(yyval.decl.type);
	     if (yyvsp[0].decl.type) {
	       SwigType_push(yyval.decl.type,yyvsp[0].decl.type);
	       Delete(yyvsp[0].decl.type);
	     }
           }
    break;

  case 258:
#line 4586 "parser.y"
    { 
	     SwigType *t = NewStringEmpty();

	     yyval.decl = yyvsp[0].decl;
	     SwigType_add_memberpointer(t,yyvsp[-2].str);
	     if (yyval.decl.type) {
	       SwigType_push(t,yyval.decl.type);
	       Delete(yyval.decl.type);
	     }
	     yyval.decl.type = t;
	     }
    break;

  case 259:
#line 4597 "parser.y"
    { 
	     SwigType *t = NewStringEmpty();
	     yyval.decl = yyvsp[0].decl;
	     SwigType_add_memberpointer(t,yyvsp[-2].str);
	     SwigType_push(yyvsp[-3].type,t);
	     if (yyval.decl.type) {
	       SwigType_push(yyvsp[-3].type,yyval.decl.type);
	       Delete(yyval.decl.type);
	     }
	     yyval.decl.type = yyvsp[-3].type;
	     Delete(t);
	   }
    break;

  case 260:
#line 4609 "parser.y"
    { 
	     yyval.decl = yyvsp[0].decl;
	     SwigType_add_memberpointer(yyvsp[-4].type,yyvsp[-3].str);
	     SwigType_add_reference(yyvsp[-4].type);
	     if (yyval.decl.type) {
	       SwigType_push(yyvsp[-4].type,yyval.decl.type);
	       Delete(yyval.decl.type);
	     }
	     yyval.decl.type = yyvsp[-4].type;
	   }
    break;

  case 261:
#line 4619 "parser.y"
    { 
	     SwigType *t = NewStringEmpty();
	     yyval.decl = yyvsp[0].decl;
	     SwigType_add_memberpointer(t,yyvsp[-3].str);
	     SwigType_add_reference(t);
	     if (yyval.decl.type) {
	       SwigType_push(t,yyval.decl.type);
	       Delete(yyval.decl.type);
	     } 
	     yyval.decl.type = t;
	   }
    break;

  case 262:
#line 4632 "parser.y"
    {
                /* Note: This is non-standard C.  Template declarator is allowed to follow an identifier */
                 yyval.decl.id = Char(yyvsp[0].str);
		 yyval.decl.type = 0;
		 yyval.decl.parms = 0;
		 yyval.decl.have_parms = 0;
                  }
    break;

  case 263:
#line 4639 "parser.y"
    {
                  yyval.decl.id = Char(NewStringf("~%s",yyvsp[0].str));
                  yyval.decl.type = 0;
                  yyval.decl.parms = 0;
                  yyval.decl.have_parms = 0;
                  }
    break;

  case 264:
#line 4647 "parser.y"
    {
                  yyval.decl.id = Char(yyvsp[-1].str);
                  yyval.decl.type = 0;
                  yyval.decl.parms = 0;
                  yyval.decl.have_parms = 0;
                  }
    break;

  case 265:
#line 4663 "parser.y"
    {
		    yyval.decl = yyvsp[-1].decl;
		    if (yyval.decl.type) {
		      SwigType_push(yyvsp[-2].type,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = yyvsp[-2].type;
                  }
    break;

  case 266:
#line 4671 "parser.y"
    {
		    SwigType *t;
		    yyval.decl = yyvsp[-1].decl;
		    t = NewStringEmpty();
		    SwigType_add_memberpointer(t,yyvsp[-3].str);
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
		    }
    break;

  case 267:
#line 4682 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-2].decl;
		    t = NewStringEmpty();
		    SwigType_add_array(t,(char*)"");
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 268:
#line 4693 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-3].decl;
		    t = NewStringEmpty();
		    SwigType_add_array(t,yyvsp[-1].dtype.val);
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 269:
#line 4704 "parser.y"
    {
		    SwigType *t;
                    yyval.decl = yyvsp[-3].decl;
		    t = NewStringEmpty();
		    SwigType_add_function(t,yyvsp[-1].pl);
		    if (!yyval.decl.have_parms) {
		      yyval.decl.parms = yyvsp[-1].pl;
		      yyval.decl.have_parms = 1;
		    }
		    if (!yyval.decl.type) {
		      yyval.decl.type = t;
		    } else {
		      SwigType_push(t, yyval.decl.type);
		      Delete(yyval.decl.type);
		      yyval.decl.type = t;
		    }
		  }
    break;

  case 270:
#line 4723 "parser.y"
    {
                /* Note: This is non-standard C.  Template declarator is allowed to follow an identifier */
                 yyval.decl.id = Char(yyvsp[0].str);
		 yyval.decl.type = 0;
		 yyval.decl.parms = 0;
		 yyval.decl.have_parms = 0;
                  }
    break;

  case 271:
#line 4731 "parser.y"
    {
                  yyval.decl.id = Char(NewStringf("~%s",yyvsp[0].str));
                  yyval.decl.type = 0;
                  yyval.decl.parms = 0;
                  yyval.decl.have_parms = 0;
                  }
    break;

  case 272:
#line 4748 "parser.y"
    {
		    yyval.decl = yyvsp[-1].decl;
		    if (yyval.decl.type) {
		      SwigType_push(yyvsp[-2].type,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = yyvsp[-2].type;
                  }
    break;

  case 273:
#line 4756 "parser.y"
    {
                    yyval.decl = yyvsp[-1].decl;
		    if (!yyval.decl.type) {
		      yyval.decl.type = NewStringEmpty();
		    }
		    SwigType_add_reference(yyval.decl.type);
                  }
    break;

  case 274:
#line 4763 "parser.y"
    {
		    SwigType *t;
		    yyval.decl = yyvsp[-1].decl;
		    t = NewStringEmpty();
		    SwigType_add_memberpointer(t,yyvsp[-3].str);
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
		    }
    break;

  case 275:
#line 4774 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-2].decl;
		    t = NewStringEmpty();
		    SwigType_add_array(t,(char*)"");
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 276:
#line 4785 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-3].decl;
		    t = NewStringEmpty();
		    SwigType_add_array(t,yyvsp[-1].dtype.val);
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 277:
#line 4796 "parser.y"
    {
		    SwigType *t;
                    yyval.decl = yyvsp[-3].decl;
		    t = NewStringEmpty();
		    SwigType_add_function(t,yyvsp[-1].pl);
		    if (!yyval.decl.have_parms) {
		      yyval.decl.parms = yyvsp[-1].pl;
		      yyval.decl.have_parms = 1;
		    }
		    if (!yyval.decl.type) {
		      yyval.decl.type = t;
		    } else {
		      SwigType_push(t, yyval.decl.type);
		      Delete(yyval.decl.type);
		      yyval.decl.type = t;
		    }
		  }
    break;

  case 278:
#line 4815 "parser.y"
    {
		    yyval.decl.type = yyvsp[0].type;
                    yyval.decl.id = 0;
		    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
                  }
    break;

  case 279:
#line 4821 "parser.y"
    { 
                     yyval.decl = yyvsp[0].decl;
                     SwigType_push(yyvsp[-1].type,yyvsp[0].decl.type);
		     yyval.decl.type = yyvsp[-1].type;
		     Delete(yyvsp[0].decl.type);
                  }
    break;

  case 280:
#line 4827 "parser.y"
    {
		    yyval.decl.type = yyvsp[-1].type;
		    SwigType_add_reference(yyval.decl.type);
		    yyval.decl.id = 0;
		    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
		  }
    break;

  case 281:
#line 4834 "parser.y"
    {
		    yyval.decl = yyvsp[0].decl;
		    SwigType_add_reference(yyvsp[-2].type);
		    if (yyval.decl.type) {
		      SwigType_push(yyvsp[-2].type,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = yyvsp[-2].type;
                  }
    break;

  case 282:
#line 4843 "parser.y"
    {
		    yyval.decl = yyvsp[0].decl;
                  }
    break;

  case 283:
#line 4846 "parser.y"
    {
		    yyval.decl = yyvsp[0].decl;
		    yyval.decl.type = NewStringEmpty();
		    SwigType_add_reference(yyval.decl.type);
		    if (yyvsp[0].decl.type) {
		      SwigType_push(yyval.decl.type,yyvsp[0].decl.type);
		      Delete(yyvsp[0].decl.type);
		    }
                  }
    break;

  case 284:
#line 4855 "parser.y"
    { 
                    yyval.decl.id = 0;
                    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
                    yyval.decl.type = NewStringEmpty();
		    SwigType_add_reference(yyval.decl.type);
                  }
    break;

  case 285:
#line 4862 "parser.y"
    { 
		    yyval.decl.type = NewStringEmpty();
                    SwigType_add_memberpointer(yyval.decl.type,yyvsp[-1].str);
                    yyval.decl.id = 0;
                    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
      	          }
    break;

  case 286:
#line 4869 "parser.y"
    { 
		    SwigType *t = NewStringEmpty();
                    yyval.decl.type = yyvsp[-2].type;
		    yyval.decl.id = 0;
		    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
		    SwigType_add_memberpointer(t,yyvsp[-1].str);
		    SwigType_push(yyval.decl.type,t);
		    Delete(t);
                  }
    break;

  case 287:
#line 4879 "parser.y"
    { 
		    yyval.decl = yyvsp[0].decl;
		    SwigType_add_memberpointer(yyvsp[-3].type,yyvsp[-2].str);
		    if (yyval.decl.type) {
		      SwigType_push(yyvsp[-3].type,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = yyvsp[-3].type;
                  }
    break;

  case 288:
#line 4890 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-2].decl;
		    t = NewStringEmpty();
		    SwigType_add_array(t,(char*)"");
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 289:
#line 4901 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-3].decl;
		    t = NewStringEmpty();
		    SwigType_add_array(t,yyvsp[-1].dtype.val);
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 290:
#line 4912 "parser.y"
    { 
		    yyval.decl.type = NewStringEmpty();
		    yyval.decl.id = 0;
		    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
		    SwigType_add_array(yyval.decl.type,(char*)"");
                  }
    break;

  case 291:
#line 4919 "parser.y"
    { 
		    yyval.decl.type = NewStringEmpty();
		    yyval.decl.id = 0;
		    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
		    SwigType_add_array(yyval.decl.type,yyvsp[-1].dtype.val);
		  }
    break;

  case 292:
#line 4926 "parser.y"
    {
                    yyval.decl = yyvsp[-1].decl;
		  }
    break;

  case 293:
#line 4929 "parser.y"
    {
		    SwigType *t;
                    yyval.decl = yyvsp[-3].decl;
		    t = NewStringEmpty();
                    SwigType_add_function(t,yyvsp[-1].pl);
		    if (!yyval.decl.type) {
		      yyval.decl.type = t;
		    } else {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		      yyval.decl.type = t;
		    }
		    if (!yyval.decl.have_parms) {
		      yyval.decl.parms = yyvsp[-1].pl;
		      yyval.decl.have_parms = 1;
		    }
		  }
    break;

  case 294:
#line 4946 "parser.y"
    {
                    yyval.decl.type = NewStringEmpty();
                    SwigType_add_function(yyval.decl.type,yyvsp[-1].pl);
		    yyval.decl.parms = yyvsp[-1].pl;
		    yyval.decl.have_parms = 1;
		    yyval.decl.id = 0;
                  }
    break;

  case 295:
#line 4956 "parser.y"
    { 
               yyval.type = NewStringEmpty();
               SwigType_add_pointer(yyval.type);
	       SwigType_push(yyval.type,yyvsp[-1].str);
	       SwigType_push(yyval.type,yyvsp[0].type);
	       Delete(yyvsp[0].type);
           }
    break;

  case 296:
#line 4963 "parser.y"
    {
	     yyval.type = NewStringEmpty();
	     SwigType_add_pointer(yyval.type);
	     SwigType_push(yyval.type,yyvsp[0].type);
	     Delete(yyvsp[0].type);
	     }
    break;

  case 297:
#line 4969 "parser.y"
    { 
	     	yyval.type = NewStringEmpty();	
		SwigType_add_pointer(yyval.type);
	        SwigType_push(yyval.type,yyvsp[0].str);
           }
    break;

  case 298:
#line 4974 "parser.y"
    {
	      yyval.type = NewStringEmpty();
	      SwigType_add_pointer(yyval.type);
           }
    break;

  case 299:
#line 4980 "parser.y"
    { 
	          yyval.str = NewStringEmpty();
	          if (yyvsp[0].id) SwigType_add_qualifier(yyval.str,yyvsp[0].id);
               }
    break;

  case 300:
#line 4984 "parser.y"
    { 
		  yyval.str = yyvsp[0].str; 
	          if (yyvsp[-1].id) SwigType_add_qualifier(yyval.str,yyvsp[-1].id);
               }
    break;

  case 301:
#line 4990 "parser.y"
    { yyval.id = "const"; }
    break;

  case 302:
#line 4991 "parser.y"
    { yyval.id = "volatile"; }
    break;

  case 303:
#line 4992 "parser.y"
    { yyval.id = 0; }
    break;

  case 304:
#line 4998 "parser.y"
    {
                   yyval.type = yyvsp[0].type;
                   Replace(yyval.type,"typename ","", DOH_REPLACE_ANY);
                }
    break;

  case 305:
#line 5004 "parser.y"
    {
                   yyval.type = yyvsp[0].type;
	           SwigType_push(yyval.type,yyvsp[-1].str);
               }
    break;

  case 306:
#line 5008 "parser.y"
    { yyval.type = yyvsp[0].type; }
    break;

  case 307:
#line 5011 "parser.y"
    { yyval.type = yyvsp[0].type;
                  /* Printf(stdout,"primitive = '%s'\n", $$);*/
                }
    break;

  case 308:
#line 5014 "parser.y"
    { yyval.type = yyvsp[0].type; }
    break;

  case 309:
#line 5015 "parser.y"
    { yyval.type = yyvsp[0].type; }
    break;

  case 310:
#line 5016 "parser.y"
    { yyval.type = NewStringf("%s%s",yyvsp[-1].type,yyvsp[0].id); }
    break;

  case 311:
#line 5017 "parser.y"
    { yyval.type = NewStringf("enum %s", yyvsp[0].str); }
    break;

  case 312:
#line 5018 "parser.y"
    { yyval.type = yyvsp[0].type; }
    break;

  case 313:
#line 5019 "parser.y"
    {
		  yyval.type = yyvsp[-1].type;
	          SwigType_push(yyval.type,yyvsp[0].str);
     	       }
    break;

  case 314:
#line 5024 "parser.y"
    {
		  yyval.type = yyvsp[0].str;
               }
    break;

  case 315:
#line 5027 "parser.y"
    { 
		 yyval.type = NewStringf("%s %s", yyvsp[-1].id, yyvsp[0].str);
               }
    break;

  case 316:
#line 5032 "parser.y"
    {
		 if (!yyvsp[0].ptype.type) yyvsp[0].ptype.type = NewString("int");
		 if (yyvsp[0].ptype.us) {
		   yyval.type = NewStringf("%s %s", yyvsp[0].ptype.us, yyvsp[0].ptype.type);
		   Delete(yyvsp[0].ptype.us);
                   Delete(yyvsp[0].ptype.type);
		 } else {
                   yyval.type = yyvsp[0].ptype.type;
		 }
		 if (Cmp(yyval.type,"signed int") == 0) {
		   Delete(yyval.type);
		   yyval.type = NewString("int");
                 } else if (Cmp(yyval.type,"signed long") == 0) {
		   Delete(yyval.type);
                   yyval.type = NewString("long");
                 } else if (Cmp(yyval.type,"signed short") == 0) {
		   Delete(yyval.type);
		   yyval.type = NewString("short");
		 } else if (Cmp(yyval.type,"signed long long") == 0) {
		   Delete(yyval.type);
		   yyval.type = NewString("long long");
		 }
               }
    break;

  case 317:
#line 5057 "parser.y"
    { 
                 yyval.ptype = yyvsp[0].ptype;
               }
    break;

  case 318:
#line 5060 "parser.y"
    {
                    if (yyvsp[-1].ptype.us && yyvsp[0].ptype.us) {
		      Swig_error(cparse_file, cparse_line, "Extra %s specifier.\n", yyvsp[0].ptype.us);
		    }
                    yyval.ptype = yyvsp[0].ptype;
                    if (yyvsp[-1].ptype.us) yyval.ptype.us = yyvsp[-1].ptype.us;
		    if (yyvsp[-1].ptype.type) {
		      if (!yyvsp[0].ptype.type) yyval.ptype.type = yyvsp[-1].ptype.type;
		      else {
			int err = 0;
			if ((Cmp(yyvsp[-1].ptype.type,"long") == 0)) {
			  if ((Cmp(yyvsp[0].ptype.type,"long") == 0) || (Strncmp(yyvsp[0].ptype.type,"double",6) == 0)) {
			    yyval.ptype.type = NewStringf("long %s", yyvsp[0].ptype.type);
			  } else if (Cmp(yyvsp[0].ptype.type,"int") == 0) {
			    yyval.ptype.type = yyvsp[-1].ptype.type;
			  } else {
			    err = 1;
			  }
			} else if ((Cmp(yyvsp[-1].ptype.type,"short")) == 0) {
			  if (Cmp(yyvsp[0].ptype.type,"int") == 0) {
			    yyval.ptype.type = yyvsp[-1].ptype.type;
			  } else {
			    err = 1;
			  }
			} else if (Cmp(yyvsp[-1].ptype.type,"int") == 0) {
			  yyval.ptype.type = yyvsp[0].ptype.type;
			} else if (Cmp(yyvsp[-1].ptype.type,"double") == 0) {
			  if (Cmp(yyvsp[0].ptype.type,"long") == 0) {
			    yyval.ptype.type = NewString("long double");
			  } else if (Cmp(yyvsp[0].ptype.type,"complex") == 0) {
			    yyval.ptype.type = NewString("double complex");
			  } else {
			    err = 1;
			  }
			} else if (Cmp(yyvsp[-1].ptype.type,"float") == 0) {
			  if (Cmp(yyvsp[0].ptype.type,"complex") == 0) {
			    yyval.ptype.type = NewString("float complex");
			  } else {
			    err = 1;
			  }
			} else if (Cmp(yyvsp[-1].ptype.type,"complex") == 0) {
			  yyval.ptype.type = NewStringf("%s complex", yyvsp[0].ptype.type);
			} else {
			  err = 1;
			}
			if (err) {
			  Swig_error(cparse_file, cparse_line, "Extra %s specifier.\n", yyvsp[-1].ptype.type);
			}
		      }
		    }
               }
    break;

  case 319:
#line 5114 "parser.y"
    { 
		    yyval.ptype.type = NewString("int");
                    yyval.ptype.us = 0;
               }
    break;

  case 320:
#line 5118 "parser.y"
    { 
                    yyval.ptype.type = NewString("short");
                    yyval.ptype.us = 0;
                }
    break;

  case 321:
#line 5122 "parser.y"
    { 
                    yyval.ptype.type = NewString("long");
                    yyval.ptype.us = 0;
                }
    break;

  case 322:
#line 5126 "parser.y"
    { 
                    yyval.ptype.type = NewString("char");
                    yyval.ptype.us = 0;
                }
    break;

  case 323:
#line 5130 "parser.y"
    { 
                    yyval.ptype.type = NewString("wchar_t");
                    yyval.ptype.us = 0;
                }
    break;

  case 324:
#line 5134 "parser.y"
    { 
                    yyval.ptype.type = NewString("float");
                    yyval.ptype.us = 0;
                }
    break;

  case 325:
#line 5138 "parser.y"
    { 
                    yyval.ptype.type = NewString("double");
                    yyval.ptype.us = 0;
                }
    break;

  case 326:
#line 5142 "parser.y"
    { 
                    yyval.ptype.us = NewString("signed");
                    yyval.ptype.type = 0;
                }
    break;

  case 327:
#line 5146 "parser.y"
    { 
                    yyval.ptype.us = NewString("unsigned");
                    yyval.ptype.type = 0;
                }
    break;

  case 328:
#line 5150 "parser.y"
    { 
                    yyval.ptype.type = NewString("complex");
                    yyval.ptype.us = 0;
                }
    break;

  case 329:
#line 5154 "parser.y"
    { 
                    yyval.ptype.type = NewString("__int8");
                    yyval.ptype.us = 0;
                }
    break;

  case 330:
#line 5158 "parser.y"
    { 
                    yyval.ptype.type = NewString("__int16");
                    yyval.ptype.us = 0;
                }
    break;

  case 331:
#line 5162 "parser.y"
    { 
                    yyval.ptype.type = NewString("__int32");
                    yyval.ptype.us = 0;
                }
    break;

  case 332:
#line 5166 "parser.y"
    { 
                    yyval.ptype.type = NewString("__int64");
                    yyval.ptype.us = 0;
                }
    break;

  case 333:
#line 5172 "parser.y"
    { /* scanner_check_typedef(); */ }
    break;

  case 334:
#line 5172 "parser.y"
    {
                   yyval.dtype = yyvsp[0].dtype;
		   if (yyval.dtype.type == T_STRING) {
		     yyval.dtype.rawval = NewStringf("\"%(escape)s\"",yyval.dtype.val);
		   } else {
		     yyval.dtype.rawval = 0;
		   }
		   yyval.dtype.bitfield = 0;
		   yyval.dtype.throws = 0;
		   yyval.dtype.throwf = 0;
		   scanner_ignore_typedef();
                }
    break;

  case 335:
#line 5193 "parser.y"
    {
                   yyval.dtype.val = NewString(yyvsp[0].str);
		   /*		   $$.rawval = NewStringf("\'%(escape)s\'",$$.val); */
		   /*		   Printf(stdout,"rawval = '%s'\n", $$.rawval); */
		   if (Len(yyval.dtype.val)) {
		     yyval.dtype.rawval = NewStringf("\'%(escape)s\'", yyval.dtype.val);
		   } else {
		     yyval.dtype.rawval = NewString("\'\\0'");
		   }
		   yyval.dtype.type = T_CHAR;
		   yyval.dtype.bitfield = 0;
		   yyval.dtype.throws = 0;
		   yyval.dtype.throwf = 0;
		 }
    break;

  case 336:
#line 5211 "parser.y"
    { yyval.id = yyvsp[0].id; }
    break;

  case 337:
#line 5212 "parser.y"
    { yyval.id = (char *) 0;}
    break;

  case 338:
#line 5215 "parser.y"
    { 

                  /* Ignore if there is a trailing comma in the enum list */
                  if (yyvsp[0].node) {
                    Node *leftSibling = Getattr(yyvsp[-2].node,"_last");
                    if (!leftSibling) {
                      leftSibling=yyvsp[-2].node;
                    }
                    set_nextSibling(leftSibling,yyvsp[0].node);
                    Setattr(yyvsp[-2].node,"_last",yyvsp[0].node);
                  }
		  yyval.node = yyvsp[-2].node;
               }
    break;

  case 339:
#line 5228 "parser.y"
    { 
                   yyval.node = yyvsp[0].node; 
                   if (yyvsp[0].node) {
                     Setattr(yyvsp[0].node,"_last",yyvsp[0].node);
                   }
               }
    break;

  case 340:
#line 5236 "parser.y"
    {
		   SwigType *type = NewSwigType(T_INT);
		   yyval.node = new_node("enumitem");
		   Setattr(yyval.node,k_name,yyvsp[0].id);
		   Setattr(yyval.node,k_type,type);
		   SetFlag(yyval.node,"feature:immutable");
		   Delete(type);
		 }
    break;

  case 341:
#line 5244 "parser.y"
    {
		   yyval.node = new_node("enumitem");
		   Setattr(yyval.node,k_name,yyvsp[-2].id);
		   Setattr(yyval.node,"enumvalue", yyvsp[0].dtype.val);
	           if (yyvsp[0].dtype.type == T_CHAR) {
		     SwigType *type = NewSwigType(T_CHAR);
		     Setattr(yyval.node,k_value,yyvsp[0].dtype.val);
		     Setattr(yyval.node,k_type,type);
		     Delete(type);
		   } else {
		     SwigType *type = NewSwigType(T_INT);
		     Setattr(yyval.node,k_value,yyvsp[-2].id);
		     Setattr(yyval.node,k_type,type);
		     Delete(type);
		   }
		   SetFlag(yyval.node,"feature:immutable");
                 }
    break;

  case 342:
#line 5261 "parser.y"
    { yyval.node = 0; }
    break;

  case 343:
#line 5264 "parser.y"
    {
                   yyval.dtype = yyvsp[0].dtype;
		   if ((yyval.dtype.type != T_INT) && (yyval.dtype.type != T_UINT) &&
		       (yyval.dtype.type != T_LONG) && (yyval.dtype.type != T_ULONG) &&
		       (yyval.dtype.type != T_SHORT) && (yyval.dtype.type != T_USHORT) &&
		       (yyval.dtype.type != T_SCHAR) && (yyval.dtype.type != T_UCHAR)) {
		     Swig_error(cparse_file,cparse_line,"Type error. Expecting an int\n");
		   }
                }
    break;

  case 344:
#line 5273 "parser.y"
    {
                   yyval.dtype.val  = NewString(yyvsp[0].str);
		   yyval.dtype.type = T_INT;
		 }
    break;

  case 345:
#line 5284 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 346:
#line 5285 "parser.y"
    { 
		    yyval.dtype.val = NewString(yyvsp[0].id); 
                    yyval.dtype.type = T_STRING; 
               }
    break;

  case 347:
#line 5289 "parser.y"
    {
  		  SwigType_push(yyvsp[-2].type,yyvsp[-1].decl.type);
		  yyval.dtype.val = NewStringf("sizeof(%s)",SwigType_str(yyvsp[-2].type,0));
		  yyval.dtype.type = T_INT;
               }
    break;

  case 348:
#line 5294 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 349:
#line 5295 "parser.y"
    {
		 Node *n;
		 yyval.dtype.val = yyvsp[0].type;
		 yyval.dtype.type = T_INT;
		 /* Check if value is in scope */
		 n = Swig_symbol_clookup(yyvsp[0].type,0);
		 if (n) {
                   /* A band-aid for enum values used in expressions. */
                   if (Strcmp(nodeType(n),"enumitem") == 0) {
                     String *q = Swig_symbol_qualified(n);
                     if (q) {
                       yyval.dtype.val = NewStringf("%s::%s", q, Getattr(n,k_name));
                       Delete(q);
                     }
                   }
		 }
               }
    break;

  case 350:
#line 5314 "parser.y"
    {
   	            yyval.dtype.val = NewStringf("(%s)",yyvsp[-1].dtype.val);
		    yyval.dtype.type = yyvsp[-1].dtype.type;
   	       }
    break;

  case 351:
#line 5321 "parser.y"
    {
                 yyval.dtype = yyvsp[0].dtype;
		 if (yyvsp[0].dtype.type != T_STRING) {
		   yyval.dtype.val = NewStringf("(%s) %s", SwigType_str(yyvsp[-2].dtype.val,0), yyvsp[0].dtype.val);
		 }
 	       }
    break;

  case 352:
#line 5327 "parser.y"
    {
                 yyval.dtype = yyvsp[0].dtype;
		 if (yyvsp[0].dtype.type != T_STRING) {
		   SwigType_push(yyvsp[-3].dtype.val,yyvsp[-2].type);
		   yyval.dtype.val = NewStringf("(%s) %s", SwigType_str(yyvsp[-3].dtype.val,0), yyvsp[0].dtype.val);
		 }
 	       }
    break;

  case 353:
#line 5334 "parser.y"
    {
                 yyval.dtype = yyvsp[0].dtype;
		 if (yyvsp[0].dtype.type != T_STRING) {
		   SwigType_add_reference(yyvsp[-3].dtype.val);
		   yyval.dtype.val = NewStringf("(%s) %s", SwigType_str(yyvsp[-3].dtype.val,0), yyvsp[0].dtype.val);
		 }
 	       }
    break;

  case 354:
#line 5341 "parser.y"
    {
                 yyval.dtype = yyvsp[0].dtype;
		 if (yyvsp[0].dtype.type != T_STRING) {
		   SwigType_push(yyvsp[-4].dtype.val,yyvsp[-3].type);
		   SwigType_add_reference(yyvsp[-4].dtype.val);
		   yyval.dtype.val = NewStringf("(%s) %s", SwigType_str(yyvsp[-4].dtype.val,0), yyvsp[0].dtype.val);
		 }
 	       }
    break;

  case 355:
#line 5349 "parser.y"
    {
		 yyval.dtype = yyvsp[0].dtype;
                 yyval.dtype.val = NewStringf("&%s",yyvsp[0].dtype.val);
	       }
    break;

  case 356:
#line 5353 "parser.y"
    {
		 yyval.dtype = yyvsp[0].dtype;
                 yyval.dtype.val = NewStringf("*%s",yyvsp[0].dtype.val);
	       }
    break;

  case 357:
#line 5359 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 358:
#line 5360 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 359:
#line 5361 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 360:
#line 5362 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 361:
#line 5363 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 362:
#line 5364 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 363:
#line 5365 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 364:
#line 5368 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s+%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 365:
#line 5372 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s-%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 366:
#line 5376 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s*%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 367:
#line 5380 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s/%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 368:
#line 5384 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s&%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 369:
#line 5388 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s|%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 370:
#line 5392 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s^%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 371:
#line 5396 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s<<%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 372:
#line 5400 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s>>%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 373:
#line 5404 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s&&%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = T_INT;
	       }
    break;

  case 374:
#line 5408 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s||%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = T_INT;
	       }
    break;

  case 375:
#line 5412 "parser.y"
    {
		 yyval.dtype.val = NewStringf("-%s",yyvsp[0].dtype.val);
		 yyval.dtype.type = yyvsp[0].dtype.type;
	       }
    break;

  case 376:
#line 5416 "parser.y"
    {
                 yyval.dtype.val = NewStringf("+%s",yyvsp[0].dtype.val);
		 yyval.dtype.type = yyvsp[0].dtype.type;
  	       }
    break;

  case 377:
#line 5420 "parser.y"
    {
		 yyval.dtype.val = NewStringf("~%s",yyvsp[0].dtype.val);
		 yyval.dtype.type = yyvsp[0].dtype.type;
	       }
    break;

  case 378:
#line 5424 "parser.y"
    {
                 yyval.dtype.val = NewStringf("!%s",yyvsp[0].dtype.val);
		 yyval.dtype.type = T_INT;
	       }
    break;

  case 379:
#line 5428 "parser.y"
    {
		 String *qty;
                 skip_balanced('(',')');
		 qty = Swig_symbol_type_qualify(yyvsp[-1].type,0);
		 if (SwigType_istemplate(qty)) {
		   String *nstr = SwigType_namestr(qty);
		   Delete(qty);
		   qty = nstr;
		 }
		 yyval.dtype.val = NewStringf("%s%s",qty,scanner_ccode);
		 Clear(scanner_ccode);
		 yyval.dtype.type = T_INT;
		 Delete(qty);
               }
    break;

  case 380:
#line 5444 "parser.y"
    {
		 yyval.bases = yyvsp[0].bases;
               }
    break;

  case 381:
#line 5449 "parser.y"
    { inherit_list = 1; }
    break;

  case 382:
#line 5449 "parser.y"
    { yyval.bases = yyvsp[0].bases; inherit_list = 0; }
    break;

  case 383:
#line 5450 "parser.y"
    { yyval.bases = 0; }
    break;

  case 384:
#line 5453 "parser.y"
    {
		   Hash *list = NewHash();
		   Node *base = yyvsp[0].node;
		   Node *name = Getattr(base,k_name);
		   List *lpublic = NewList();
		   List *lprotected = NewList();
		   List *lprivate = NewList();
		   Setattr(list,"public",lpublic);
		   Setattr(list,"protected",lprotected);
		   Setattr(list,"private",lprivate);
		   Delete(lpublic);
		   Delete(lprotected);
		   Delete(lprivate);
		   Append(Getattr(list,Getattr(base,k_access)),name);
	           yyval.bases = list;
               }
    break;

  case 385:
#line 5470 "parser.y"
    {
		   Hash *list = yyvsp[-2].bases;
		   Node *base = yyvsp[0].node;
		   Node *name = Getattr(base,k_name);
		   Append(Getattr(list,Getattr(base,k_access)),name);
                   yyval.bases = list;
               }
    break;

  case 386:
#line 5479 "parser.y"
    {
		 yyval.node = NewHash();
		 Setfile(yyval.node,cparse_file);
		 Setline(yyval.node,cparse_line);
		 Setattr(yyval.node,k_name,yyvsp[0].str);
                 if (last_cpptype && (Strcmp(last_cpptype,"struct") != 0)) {
		   Setattr(yyval.node,k_access,"private");
		   Swig_warning(WARN_PARSE_NO_ACCESS,cparse_file,cparse_line,
				"No access specifier given for base class %s (ignored).\n",yyvsp[0].str);
                 } else {
		   Setattr(yyval.node,k_access,"public");
		 }
               }
    break;

  case 387:
#line 5492 "parser.y"
    {
		 yyval.node = NewHash();
		 Setfile(yyval.node,cparse_file);
		 Setline(yyval.node,cparse_line);
		 Setattr(yyval.node,k_name,yyvsp[0].str);
		 Setattr(yyval.node,k_access,yyvsp[-2].id);
	         if (Strcmp(yyvsp[-2].id,"public") != 0) {
		   Swig_warning(WARN_PARSE_PRIVATE_INHERIT, cparse_file, 
				cparse_line,"%s inheritance ignored.\n", yyvsp[-2].id);
		 }
               }
    break;

  case 388:
#line 5505 "parser.y"
    { yyval.id = (char*)"public"; }
    break;

  case 389:
#line 5506 "parser.y"
    { yyval.id = (char*)"private"; }
    break;

  case 390:
#line 5507 "parser.y"
    { yyval.id = (char*)"protected"; }
    break;

  case 391:
#line 5511 "parser.y"
    { 
                   yyval.id = (char*)"class"; 
		   if (!inherit_list) last_cpptype = yyval.id;
               }
    break;

  case 392:
#line 5515 "parser.y"
    { 
                   yyval.id = (char*)"struct"; 
		   if (!inherit_list) last_cpptype = yyval.id;
               }
    break;

  case 393:
#line 5519 "parser.y"
    {
                   yyval.id = (char*)"union"; 
		   if (!inherit_list) last_cpptype = yyval.id;
               }
    break;

  case 394:
#line 5523 "parser.y"
    { 
                   yyval.id = (char *)"typename"; 
		   if (!inherit_list) last_cpptype = yyval.id;
               }
    break;

  case 397:
#line 5533 "parser.y"
    {
                    yyval.dtype.qualifier = yyvsp[0].str;
                    yyval.dtype.throws = 0;
                    yyval.dtype.throwf = 0;
               }
    break;

  case 398:
#line 5538 "parser.y"
    {
                    yyval.dtype.qualifier = 0;
                    yyval.dtype.throws = yyvsp[-1].pl;
                    yyval.dtype.throwf = NewString("1");
               }
    break;

  case 399:
#line 5543 "parser.y"
    {
                    yyval.dtype.qualifier = yyvsp[-4].str;
                    yyval.dtype.throws = yyvsp[-1].pl;
                    yyval.dtype.throwf = NewString("1");
               }
    break;

  case 400:
#line 5548 "parser.y"
    { 
                    yyval.dtype.qualifier = 0; 
                    yyval.dtype.throws = 0;
                    yyval.dtype.throwf = 0;
               }
    break;

  case 401:
#line 5555 "parser.y"
    { 
                    Clear(scanner_ccode); 
                    yyval.decl.have_parms = 0; 
                    yyval.decl.defarg = 0; 
		    yyval.decl.throws = yyvsp[-2].dtype.throws;
		    yyval.decl.throwf = yyvsp[-2].dtype.throwf;
               }
    break;

  case 402:
#line 5562 "parser.y"
    { 
                    skip_balanced('{','}'); 
                    yyval.decl.have_parms = 0; 
                    yyval.decl.defarg = 0; 
                    yyval.decl.throws = yyvsp[-2].dtype.throws;
                    yyval.decl.throwf = yyvsp[-2].dtype.throwf;
               }
    break;

  case 403:
#line 5569 "parser.y"
    { 
                    Clear(scanner_ccode); 
                    yyval.decl.parms = yyvsp[-2].pl; 
                    yyval.decl.have_parms = 1; 
                    yyval.decl.defarg = 0; 
		    yyval.decl.throws = 0;
		    yyval.decl.throwf = 0;
               }
    break;

  case 404:
#line 5577 "parser.y"
    {
                    skip_balanced('{','}'); 
                    yyval.decl.parms = yyvsp[-2].pl; 
                    yyval.decl.have_parms = 1; 
                    yyval.decl.defarg = 0; 
                    yyval.decl.throws = 0;
                    yyval.decl.throwf = 0;
               }
    break;

  case 405:
#line 5585 "parser.y"
    { 
                    yyval.decl.have_parms = 0; 
                    yyval.decl.defarg = yyvsp[-1].dtype.val; 
                    yyval.decl.throws = 0;
                    yyval.decl.throwf = 0;
               }
    break;

  case 410:
#line 5601 "parser.y"
    {
	            skip_balanced('(',')');
                    Clear(scanner_ccode);
            	}
    break;

  case 411:
#line 5607 "parser.y"
    { 
                     String *s = NewStringEmpty();
                     SwigType_add_template(s,yyvsp[-1].p);
                     yyval.id = Char(s);
		     scanner_last_id(1);
                 }
    break;

  case 412:
#line 5613 "parser.y"
    { yyval.id = (char*)"";  }
    break;

  case 413:
#line 5616 "parser.y"
    { yyval.id = yyvsp[0].id; }
    break;

  case 414:
#line 5617 "parser.y"
    { yyval.id = yyvsp[0].id; }
    break;

  case 415:
#line 5620 "parser.y"
    { yyval.id = yyvsp[0].id; }
    break;

  case 416:
#line 5621 "parser.y"
    { yyval.id = 0; }
    break;

  case 417:
#line 5624 "parser.y"
    { 
                  yyval.str = 0;
		  if (!yyval.str) yyval.str = NewStringf("%s%s", yyvsp[-1].str,yyvsp[0].str);
      	          Delete(yyvsp[0].str);
               }
    break;

  case 418:
#line 5629 "parser.y"
    { 
		 yyval.str = NewStringf("::%s%s",yyvsp[-1].str,yyvsp[0].str);
                 Delete(yyvsp[0].str);
               }
    break;

  case 419:
#line 5633 "parser.y"
    {
		 yyval.str = NewString(yyvsp[0].str);
   	       }
    break;

  case 420:
#line 5636 "parser.y"
    {
		 yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 421:
#line 5639 "parser.y"
    {
                 yyval.str = NewString(yyvsp[0].str);
	       }
    break;

  case 422:
#line 5642 "parser.y"
    {
                 yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 423:
#line 5647 "parser.y"
    {
                   yyval.str = NewStringf("::%s%s",yyvsp[-1].str,yyvsp[0].str);
		   Delete(yyvsp[0].str);
               }
    break;

  case 424:
#line 5651 "parser.y"
    {
                   yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 425:
#line 5654 "parser.y"
    {
                   yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 426:
#line 5661 "parser.y"
    {
		 yyval.str = NewStringf("::~%s",yyvsp[0].str);
               }
    break;

  case 427:
#line 5667 "parser.y"
    {
                  yyval.str = NewStringf("%s%s",yyvsp[-1].id,yyvsp[0].id);
		  /*		  if (Len($2)) {
		    scanner_last_id(1);
		    } */
              }
    break;

  case 428:
#line 5676 "parser.y"
    { 
                  yyval.str = 0;
		  if (!yyval.str) yyval.str = NewStringf("%s%s", yyvsp[-1].id,yyvsp[0].str);
      	          Delete(yyvsp[0].str);
               }
    break;

  case 429:
#line 5681 "parser.y"
    { 
		 yyval.str = NewStringf("::%s%s",yyvsp[-1].id,yyvsp[0].str);
                 Delete(yyvsp[0].str);
               }
    break;

  case 430:
#line 5685 "parser.y"
    {
		 yyval.str = NewString(yyvsp[0].id);
   	       }
    break;

  case 431:
#line 5688 "parser.y"
    {
		 yyval.str = NewStringf("::%s",yyvsp[0].id);
               }
    break;

  case 432:
#line 5691 "parser.y"
    {
                 yyval.str = NewString(yyvsp[0].str);
	       }
    break;

  case 433:
#line 5694 "parser.y"
    {
                 yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 434:
#line 5699 "parser.y"
    {
                   yyval.str = NewStringf("::%s%s",yyvsp[-1].id,yyvsp[0].str);
		   Delete(yyvsp[0].str);
               }
    break;

  case 435:
#line 5703 "parser.y"
    {
                   yyval.str = NewStringf("::%s",yyvsp[0].id);
               }
    break;

  case 436:
#line 5706 "parser.y"
    {
                   yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 437:
#line 5709 "parser.y"
    {
		 yyval.str = NewStringf("::~%s",yyvsp[0].id);
               }
    break;

  case 438:
#line 5715 "parser.y"
    { 
                   yyval.id = (char *) malloc(strlen(yyvsp[-1].id)+strlen(yyvsp[0].id)+1);
                   strcpy(yyval.id,yyvsp[-1].id);
                   strcat(yyval.id,yyvsp[0].id);
               }
    break;

  case 439:
#line 5720 "parser.y"
    { yyval.id = yyvsp[0].id;}
    break;

  case 440:
#line 5723 "parser.y"
    {
		 yyval.str = NewString(yyvsp[0].id);
               }
    break;

  case 441:
#line 5726 "parser.y"
    {
                  skip_balanced('{','}');
		  yyval.str = NewString(scanner_ccode);
               }
    break;

  case 442:
#line 5730 "parser.y"
    {
		 yyval.str = yyvsp[0].str;
              }
    break;

  case 443:
#line 5735 "parser.y"
    {
                  Hash *n;
                  yyval.node = NewHash();
                  n = yyvsp[-1].node;
                  while(n) {
                     String *name, *value;
                     name = Getattr(n,k_name);
                     value = Getattr(n,k_value);
		     if (!value) value = (String *) "1";
                     Setattr(yyval.node,name, value);
		     n = nextSibling(n);
		  }
               }
    break;

  case 444:
#line 5748 "parser.y"
    { yyval.node = 0; }
    break;

  case 445:
#line 5752 "parser.y"
    {
		 yyval.node = NewHash();
		 Setattr(yyval.node,k_name,yyvsp[-2].id);
		 Setattr(yyval.node,k_value,yyvsp[0].id);
               }
    break;

  case 446:
#line 5757 "parser.y"
    {
		 yyval.node = NewHash();
		 Setattr(yyval.node,k_name,yyvsp[-4].id);
		 Setattr(yyval.node,k_value,yyvsp[-2].id);
		 set_nextSibling(yyval.node,yyvsp[0].node);
               }
    break;

  case 447:
#line 5763 "parser.y"
    {
                 yyval.node = NewHash();
                 Setattr(yyval.node,k_name,yyvsp[0].id);
	       }
    break;

  case 448:
#line 5767 "parser.y"
    {
                 yyval.node = NewHash();
                 Setattr(yyval.node,k_name,yyvsp[-2].id);
                 set_nextSibling(yyval.node,yyvsp[0].node);
               }
    break;

  case 449:
#line 5772 "parser.y"
    {
                 yyval.node = yyvsp[0].node;
		 Setattr(yyval.node,k_name,yyvsp[-2].id);
               }
    break;

  case 450:
#line 5776 "parser.y"
    {
                 yyval.node = yyvsp[-2].node;
		 Setattr(yyval.node,k_name,yyvsp[-4].id);
		 set_nextSibling(yyval.node,yyvsp[0].node);
               }
    break;

  case 451:
#line 5783 "parser.y"
    {
		 yyval.id = yyvsp[0].id;
               }
    break;

  case 452:
#line 5786 "parser.y"
    {
                 yyval.id = Char(yyvsp[0].dtype.val);
               }
    break;


    }

/* Line 991 of yacc.c.  */
#line 9507 "y.tab.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab2;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:

  /* Suppress GCC warning that yyerrlab1 is unused when no action
     invokes YYERROR.  */
#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__) \
    && !defined __cplusplus
  __attribute__ ((__unused__))
#endif


  goto yyerrlab2;


/*---------------------------------------------------------------.
| yyerrlab2 -- pop states until the error token can be shifted.  |
`---------------------------------------------------------------*/
yyerrlab2:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 5793 "parser.y"


SwigType *Swig_cparse_type(String *s) {
   String *ns;
   ns = NewStringf("%s;",s);
   Seek(ns,0,SEEK_SET);
   scanner_file(ns);
   top = 0;
   scanner_next_token(PARSETYPE);
   yyparse();
   /*   Printf(stdout,"typeparse: '%s' ---> '%s'\n", s, top); */
   return top;
}


Parm *Swig_cparse_parm(String *s) {
   String *ns;
   ns = NewStringf("%s;",s);
   Seek(ns,0,SEEK_SET);
   scanner_file(ns);
   top = 0;
   scanner_next_token(PARSEPARM);
   yyparse();
   /*   Printf(stdout,"typeparse: '%s' ---> '%s'\n", s, top); */
   Delete(ns);
   return top;
}


ParmList *Swig_cparse_parms(String *s) {
   String *ns;
   char *cs = Char(s);
   if (cs && cs[0] != '(') {
     ns = NewStringf("(%s);",s);
   } else {
     ns = NewStringf("%s;",s);
   }   
   Seek(ns,0,SEEK_SET);
   scanner_file(ns);
   top = 0;
   scanner_next_token(PARSEPARMS);
   yyparse();
   /*   Printf(stdout,"typeparse: '%s' ---> '%s'\n", s, top); */
   return top;
}









