/*
 * Implementation of some test utility functions
 *
 * Copyright (C) 2003,2004,2005  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef INSTANTIATING_TEMPLATES
#include <string>

namespace Tagcoll {
	//template class TextFormat<std::string, std::string>;
}
#endif


#ifdef COMPILE_TESTSUITE

#include <tests/test-utils.h>
#include <tagcoll/StringParserInput.h>
#include <tagcoll/TextFormat.h>

namespace tut_tagcoll {

using namespace std;
using namespace Tagcoll;
using namespace tut;
	
void outputCollection(const std::string& str, Tagcoll::Consumer<string, string>& cons)
{
	StringParserInput input(str);
	Converter<string, string> a;
	TextFormat<string, string>::parse(a, a, input, cons);
}

void __tc_ensure_coll_equal(std::string f, int l, std::string s,
		const Tagcoll::Collection<string, string>& c1, const Tagcoll::Collection<string, string>& c2)
{
	PatchList<string, string> p;
	p.addPatch(c1, c2);
	if (!p.empty())
	{
		char buf[64];
		snprintf(buf, 63, "%d", l);
		buf[63] = 0;

		f += ":";
		f += buf;
		f += ": '";
		f += s;
		f += "': ";
		f += "collections differ.  Patch:\n";
		for (PatchList<string, string>::const_iterator i = p.begin();
				i != p.end(); i++)
		{
			f += i->first;
			f += ": ";
			bool first = true;
			for (OpSet<string>::const_iterator j = i->second.getAdded().begin();
					j != i->second.getAdded().end(); j++)
				if (first)
				{
					f += "+" + *j;
					first = false;
				} else {
					f += ", +" + *j;
				}
			for (OpSet<string>::const_iterator j = i->second.getRemoved().begin();
					j != i->second.getRemoved().end(); j++)
				if (first)
				{
					f += "-" + *j;
					first = false;
				} else {
					f += ", -" + *j;
				}
			f += "\n";
		}
		
		ensure(f.c_str(), false);
	}
}

}

#endif

// vim:set ts=4 sw=4:
