/*
 * Fast index for tag data, based on integer indexes
 *
 * Copyright (C) 2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <tests/test-utils.h>
#include <tagcoll/diskindex/int.h>

namespace tut {
using namespace tagcoll::tests;
using namespace tagcoll::diskindex;

static const char* fname = "tagcoll_intindex.tmp";

struct tagcoll_diskindex_int_shar {
	tagcoll_diskindex_int_shar() {
		MasterMMapIndexer master(fname);

		// Create the index
		IntIndexer indexer;
		indexer.map(4, 1);
		indexer.map(4, 2);
		indexer.map(2, 1);
		indexer.map(0, 5);
		indexer.map(0, 8);
		indexer.map(0, 1);
		indexer.map(0, 7);
		master.append(indexer);
		master.commit();
	}
	~tagcoll_diskindex_int_shar() {
		// Delete the test index
		unlink(fname);
	}
};
TESTGRP(tagcoll_diskindex_int);

template<> template<>
void to::test<1>()
{
	MasterMMap master(fname);

	// Read the index
	Int index(master, 0);

	// Check the number of mapped items
	ensure_equals(index.size(), 5u);

	// Check that the arrays have the right size
	ensure_equals(index.size(0), 4u);
	ensure_equals(index.size(1), 0u);
	ensure_equals(index.size(2), 1u);
	ensure_equals(index.size(3), 0u);
	ensure_equals(index.size(4), 2u);

	// Check that the arrays are sorted and contain the right data
	ensure_equals(index.data(0)[0], 1);
	ensure_equals(index.data(0)[1], 5);
	ensure_equals(index.data(0)[2], 7);
	ensure_equals(index.data(0)[3], 8);
	ensure_equals(index.data(2)[0], 1);
	ensure_equals(index.data(4)[0], 1);
	ensure_equals(index.data(4)[1], 2);
}

}

// vim:set ts=4 sw=4:
