.TH "TEXEXEC" "1" "December 2006" "texexec 6.2" "ConTeXt" 
.de URL
\\$2 \(laURL: \\$1 \(ra\\$3
..
.if \n[.g] .mso www.tmac
.de EX
.in +3
.nf
.ft CW
..
.de EE
.in -3
.ft R
.fi
..

.SH "NAME" 
texexec \- front end to the ConTeXt typesetting system

.SH "SYNOPSIS" 
\fBtexexec\fP [ \fIOPTION\fP ...  ] \fIFILE\fP [ ...  ]

.SH "DESCRIPTION" 
 
\fBtexexec\fP, a \fBruby\fP(1) script,
is the command-line front end to the ConTeXt typesetting
system, an extensive macro package
built on the \fBtex\fP(1) family of typesetting programs.
\fBtexexec\fP provides several facilties:
.IP \(bu
Process a ConTeXt source file,
performing as many runs as
necessary of \fBtex\fP(1), \fBtexutil\fP(1), and
MetaPost (\fBmpost\fP(1)).   Options control the output
format, the pages to process, paper size, and so forth.
.IP \(bu
Create new ConTeXt formats, useful during installation.
.IP \(bu
Post-process existing PDF files, including merging multiple
files, and extracting and rearranging pages within a file,
similar to the facilities provided for PostScript files by
\fBpsnup\fP(1) or for PDF files by \fBpdftk\fP(1).
.IP \(bu
Extract or strip documentation from ConTeXt source files
using \fBtexutil\fP(1).
.IP \(bu
Run MetaPost (\fBmpost\fP(1)) to generate figures from MetaPost source.
.IP \(bu
Produce proof sheets of figures used in a ConTeXt source file.
.IP
.SH "OPTIONS" 
 
All switches are specified in full here but can be abbreviated to the
shortest unique prefix.   Thus, \fB--env\fP works the same as
\fB--environment\fP.  With no options, \fBtexexec\fP assumes that
the file on the command line is a ConTeXt source file, i.e. a TeX file
in the ConTeXt dialect, and produces a PDF file using the source file.
 
.SS "General Options" 
 
.IP "\fB--alone\fP" 
Avoid calling other programs when possible.  For
example, \fB--alone\fP will prevent \fBtexexec\fP from
using \fBfmtutil\fP(1) to generate formats (this prevention can
be handy when tracing installation problems).
.IP "\fB--environments\fP\fI=\fP\fIfile[,file[,...]]\fP" 
Specify ConTeXt environment file(s), separated by commas, to use when
processing the source file.  This option is useful when converting
from non-ConTeXt file formats without environment or layout settings.
.IP "\fB--help\fP" 
Produce a summary of switches
and arguments.  A more detailed help is produced by including
\fB--all\fP.
.IP "\fB--interface=\fP\fIlanguage\fP" 
Specify the language
ConTeXt should use to communicate with you.
Options are
.IP 
.RS 
.IP "\fBen\fP" 
US English
.IP "\fBnl\fP" 
Dutch
.IP "\fBde\fP" 
German
.IP "\fBuk\fP" 
British English
.IP "\fBcz\fP" 
Czech
.IP "\fBit\fP" 
Italian
.RE 
.IP "\fB--keep\fP"
Preserve a few of the temporary files generated while processing by
appending \fI.keep\fP to their name.  For example, after
.EX
texexec --keep document.tex
.EE
you will find (besides \fIdocument.pdf\fP) \fIdocument.log.keep\fP
and \fIdocument.top.keep\fP.  The \fIdocument.top\fP file is where
\fBtexexec\fP wraps \fIdocument.tex\fP with the proper ConTeXt macro
commands to set the output format, etc.
.IP "\fB--once\fP" 
Process a file exactly once.  (By default,
\fBtexexec\fP processes the file as many times as
necessary to sort out all references, typeset
\fBMetaPost\fP code, and so forth.)
.IP "\fB--purge\fP"
Get rid of most temporary files generated while processing the source
file.  For example,
.EX
texexec --purge somefile.tex
.EE
will generate \fIsomefile.pdf\fP, cleaning up after itself and leaving
only one extra file, \fIsomefile.tuo\fP.    See also the \fB--purge\fP
option of 
.BR ctxtools (1)
.IP "\fB--purgeall\fP"
Get rid of all temporary files generated while processing the source
file, including the \fIfilename.tuo\fP file.  See also the \fB--purge
--all\fP option combination of
.BR ctxtools (1)
.IP "\fB--randomseed=\fP\fINNNN\fP"
Set the random seed.
.IP "\fB--result=\fP\fIFILENAME\fP" 
Allows you to change the
basename of the output file.  See
\fB--mode\fP for an example.
.IP "\fB--runs=\fP\fINUMBER\fP" 
Specify the number of runs to
perform on a file.  Overrides
\fBtexexec\fP's calculations.
.IP "\fB--separation\fP" 
Perform color separations.
.IP "\fB--silent\fP" 
Suppress a few diagnostic and progress messages.
.IP "\fB--timeout=\fP\fINNN\fP" 
Abort the run if a subprocess waits for more than \fINNN\fP seconds;
e.g. while waiting for user input when \fBtex\fP reports an undefined
control sequence.  Useful for automated testing scripts, to make sure
the runs finish.
.IP "\fB--usemodules=\fP\fImodule1[,module2,[...]]\fP
Use the comma-separated list of modules.  For example, to typeset
\fIdocument.tex\fP using the \fIbib\fP and \fIunits\fP modules:
.EX
texexec --usemodules=bib,units document.tex
.EE
.IP "\fB--verbose\fP" 
Output extra diagnostic information.
.IP "\fB--version\fP" 
Print the version number.
.IP 
 
.SS "Processing ConTeXt Source Files" 
 
Including specifying paper sizes, formats, and so forth.
 
.IP "\fB--arrange\fP" 
Perform page rearrangements, which are used to produce booklets.  This
option tells ConTeXt to the first \fIn\fP-1 runs without taking
account of arrangements, then on the last run to pay attention to
the arrangement commands in the source file.
.IP "\fB--batchmode\fP"
Process the file in batchmode, which means
to typeset the whole document even if there are errors.  More
imformation about \f(CWbatchmode\fP can be found in Donald
E. Knuth's \fITeXbook\fP.
.IP "\fB--nonstopmode\fP"
Process the file in nonstopmode, which means
to typeset the document and report errors, but not to stop at any
error.  It is similar to batchmode but more verbose.  More
imformation about \f(CWnonstopmode\fP can be found in Donald
E. Knuth's \fITeXbook\fP.
.IP "\fB--bodyfont=\fP\fIfont\fP" 
The name of a font to preload for use in
setting the body of the text (OBSOLETE).
.IP "\fB--centerpage\fP" 
Center the document on the page.
.IP "\fB--color\fP" 
Turn on color mode.  Color mode can also be set by
commands embedded in the document.  These commands
override the \fB--color\fP option.
.IP "\fB--convert=\fP\fIFORMAT\fP" 
Convert the input file to
ConTeXt format from \fIFORMAT\fP before
processing.  In most cases, this conversion will result
in a TeX file.  Currently supported input
\fIFORMAT\fPs are \fBxml\fP and
\fBsgml\fP.
.IP "\fB--dvipdfmx, --dvipdfm, --dpx, --dpm\fP" 
Use the TeX engine (e.g. \fBpdftex\fP or \fBpdfetex\fP)
to make a DVI file and \fBdvipdfmx\fP(1) to turn it
into PDF.
.IP "\fB--dvi, --ps, --dvips\fP" 
Use the TeX engine (e.g. \fBpdftex\fP or \fBpdfetex\fP)
to make a DVI file and \fBdvips\fP(1) to turn it
into PostScript.  It's counterintuitive that \fB--dvi\fP produces
a PostScript file in addition to the DVI file.  But that's because
\fB--dvi\fP is shorthand for \fB--dvips\fP; adding the \fB--nobackend\fP
option prevents \fBtexexec\fP's running \fBdvips\fP(1).  See also the 
\fB--engine\fP option.
.IP "\fB--fast\fP" 
Typeset the document(s) as fast as possible without
causing problems.
.IP "\fB--final\fP" 
Perform a final run without skipping anything.
This option is typically used with \fB--fast\fP.
.IP "\fB--language=\fP\fILANGUAGE\fP" 
Set the language for
hyphenation.  Can be specified in your source file.
Options are the same as those for \fB--interface\fP.
.IP "\fB--mode=\fP\fIMODELIST\fP, \fB--modes=\fP\fIMODELIST\fP" 
Allows you to change the mode used while typesetting the 
source file.  The \fIMODELIST\fP is a comma separated list of modes.
Modes are a conditional-compilation facility
like \f(CW#ifdef\fP in C.  So one source file can be used to produce
several typeset documents: one for A4 paper, one for
screen display in full color, one for letter paper, etc.  For
example:
.IP 
.EX 
\f(CWtexexec --pdf --mode=A4     --result=manual-a manual-t.tex\fP 
\f(CWtexexec --pdf --mode=letter --result=manual-l manual-t.tex\fP
\f(CWtexexec --pdf --mode=screen --result=manual-s manual-t.tex\fP
.EE 
.IP 
Here the \fB--mode\fP  tells ConTeXt which
mode directives to use when typesetting the source file.  The
\fB--result\fP option tells ConTeXt
where to put the output file.
.IP "\fB--modefile=\fP\fIfile\fP"
Load this file before most of the usual processing; usually used for
mode-related material.
.IP "\fB--noarrange\fP" 
Ignore arrangement commands in the source file.
.IP "\fB--nobackend\fP"
Do not run the backend, e.g. \fBdvips\fP(1) or \fBdvipdfmx\fP(1).  See
the \fB--dvips\fP or \fB--dvipdfmx\fP options.  Why would you give one
of those options to choose a backend, yet tell \fBtexexec\fP not to
run the backend?  Because each backend has its own syntax for
\f(CW\\special\fP calls.  Specifying the backend allows the ConTeXt
macros to use the correct syntax so that when you later run the
backend to produce PostScript or PDF, the specials will be interpreted
correctly.
.IP "\fB--pages=\fP\fIPAGENUMBERLIST\fP" 
Specify the pages or page
range to appear in the output file.
\fIPAGENUMBERLIST\fP may be the keyword \fBodd\fP
or \fBeven\fP; or one or more pages or page ranges separated by commas.
For example,
.EX
\f(CWtexexec --pages=1,7,8-11,14 somefile.tex\fP
.EE
.IP "\fB--paperformat=\fP\fIKEY\fP" 
For typesetting multiple pages on a
single piece of paper.  \fIKEY\fP has the form \fBa4a3\fP
(for printing A4 pages on A3 paper), \fBa5a4\fP
(for printing A5 pages on A4 paper), or in general \fBaMaN\fP.
The actual layout of the pages is specified with the
\fB--printformat\fP option.
.IP "\fB--pdf, --pdftex\fP" 
Use \fBpdftex\fP(1) to produce a pdf document (the default).
.IP "\fB--printformat=\fP\fIKEY\fP" 
Specify the layout of the final
output.  \fIKEY\fP can be \fBup\fP, resulting in 2
pages per sheet, double sided; or \fBdown\fP, resulting
in 2 rotated pages per sheet, double sided.  Use the
\fB--paperformat\fP option to specify the original page
and sheet size.
.IP "\fB--utfbom\fP"
Turn on UTF-8 encoding.
.IP "\fB--xetex, --xtx\fP" 
Use \fBxetex\fP(1) to produce a pdf document.
.IP 
 
.SS "Creating ConTeXt Format Files" 
 
.IP "\fB--make\fP" 
Generate a ConTeXt format file.  For example, to make
\fIcont-en.fmt\fP and have it placed in a default format directory:
.EX
texexec --make de
.EE
The most common invocation, which is used by scripts that install a new version
of ConTeXt (see \fBctxtools\fP(1)), uses \fB--all\fP
so that \fBtexexec\fP makes the usual formats:
.EX
texexec --make --all
.EE
.IP "\fB--local\fP"
When searching for TeX or MetaPost formats, look in the current directory
rather than in the location set by the kpse library.  See 
.BR kpathsea (1)
for more information on path searching.
.IP "\fB--check\fP"
Check and report information about the ConTeXt version, the
distribution, the TeX engine, and the language interfaces/formats.

.SS "Expert options"

You should know what you're doing if you use these options!
.IP "\fB--alpha"
Use the TEXMFALPHA environment variable to find and 
run an alpha release of ConTeXt.
.IP "\fB--beta"
Use the TEXMFBETA environment variable to find and
run a beta release of ConTeXt.
.IP "\fB--distribution\fP\fI=dist\fP" 
Usually one of \fBstandard\fP, \fBweb2c\fP, or \fBmiktex\fP.
\fBtexexec\fP should figure it out automatically, and you shouldn't
need to use this option.
.IP "\fB--engine\fP\fI=texengine\fP" 
Specify the program to do the hard work of typesetting.  Currently
either \fBpdftex\fP (the default), \fBxetex\fP, or \fBaleph\fP.
The \fBluatex\fP value is experimental.  The \fB--engine\fP
option is not usually needed.  Instead, let
\fBtexexec\fP figure out the setting based on other command-line
information.  See for example the \fB--xetex\fP or \fB--pdf\fP
switches.

.SS "Postprocess PDF Files" 
 
.IP "\fB--combination=\fP\fIROWS\fP\fB*\fP\fICOLS\fP" 
Specify the number of pages to show on a single page.  Use with
\fB--pdfcombine\fP.
.IP "\fB--pdfarrange\fP" 
For rearranging pages in PDF files.
.EX
\f(CWtexexec --pdfarrange --paperformat=a5a4 --printformat=up foo.pdf\fP
.EE 
This command creates an A5 booklet from a PDF file
\fIfoo.pdf\fP.  \fB--pdfarrange\fP is used in
conjunction with the following options.
.IP "\fB--pdfcopy\fP"
Copy and perhaps process pages from the pdf file.
The resulting file is \fItexexec.pdf\fP by default, but you can change
that using \fB--result\fP.  Use the \fB--scale\fP option to magnify or
demagnify the original pages and the \fB--pages\fP option to select
the pages to copy.  Here is an example using all these options:
.EX
texexec --pages=4-7 --pdfcopy --scale=750 --result=one images.pdf
.EE
It takes pages 4-7 from \fIimages.pdf\fP, scales them by 75%,
and copies them to \fIone.pdf\fP.
.IP "\fB--scale=\fP\fIinteger\fP"
If the integer is less than 10, then it is taken as an (integer)
magnification factor.  Otherwise, it is taken as a magnification
factor in TeX terms, i.e. with 1000 meaning full scale.
.IP "\fB--paperoffset=\fP\fIdimen\fP" 
Specify the space between the
edge of the pages and the beginning of the text block.
.IP "\fB--backspace=\fP\fIdimen\fP" 
Specify the inside (gutter) margins.
.IP "\fB--topspace=\fP\fIdimen\fP" 
Specify the top and bottom margin.
.IP "\fB--markings\fP" 
Add crop marks.
.IP "\fB--addempty=\fP\fIPAGES\fP" 
Add empty pages after the pages specified in \fIPAGES\fP.  (Useful
for, among other things, adding blank pages after a table of
contents.)
.IP "\fB--textwidth=\fP\fIWIDTH\fP" 
Set the width of
the original text.  Specifying this parameter with a
single-sided original will allow ConTeXt to adjust
the page layout for double-sided output, producing much
more attractive results.

With the \fB--pdfarrange\fP flag, specifying more
than one file will result in all of the files being
combined in the final result, allowing you to add title
pages, decorated part separators, and so forth.

You can also do more complex manipulations, such as
adding additional text to the page by setting up a
small file with layout definitions and a simple figure
insertion loop.
.IP "\fB--pdfcombine\fP" 
Combine multiple pages.  Requires the \fB--combination\fP option.
.IP "\fB--pdfselect\fP" 
Extract pages from a file.  Use in combination with the
\fB--selection\fP switch, as in
.EX
\f(CWtexexec --pdfselect --paperformat=S6
--selection=1,9,14 file-1\fP
.EE
which extracts pages 1, 9, and 14 from
\fIfile-1.pdf\fP, and places them in
\fItexexec.pdf\fP (the default output filename if
an output file isn't specified).

See \fB--pdfarrange\fP for other
options.
.IP "\fB--selection=\fP\fIPAGES\fP" 
Specify pages to be affected by
another option.  See \fB--pdfarrange\fP and
\fB--pdfselect\fP for examples.
 
.SS "XML handling"
.IP "\fB--filters=\fP\fIfilter1[,filter2[,...]]\fP
Specify XML filters to use.

.SS "Extract or Strip Out Documentation" 
 
.IP "\fB--listing\fP" 
Produce a typeset version of the source code in
\fIFILE\fP.  You can specify the format of the output
file.  For example, use
.EX 
\f(CWtexexec --ps --listing readme.now\fP
.EE 
to produce a PostScript file called
\fItexexec.ps\fP.

See also \fB--backspace\fP, \fB--topspace\fP, and \fB--result\fP.
.IP "\fB--module\fP" 
Create documentation for ConTeXt,
MetaPost (see \fBmpost\fP(1)), 
.BR perl (1),
and
.BR ruby (1)
modules.
Converts the documentation to ConTeXt format and
then typesets a documentated version of the source file.

Documentation lines in ConTeXt source files are
specified by beginning lines with these strings:

\f(CW%C\fP : Copyright information

\f(CW%D\fP : Documentation lines

\f(CW%I\fP : TeXEdit information lines (mostly in Dutch)

\f(CW%M\fP : Macro code needed to processs the documentation

\f(CW%S\fP : Suppressed lines

The same forms can be used for Perl or ruby scripts, except that the \f(CW%\fP
character (the TeX comment character) is replaced by \f(CW#\fP (the
Perl comment character).

See also the \fB--documentation\fP option to 
.BR ctxtools (1).
 
.SS "Process MetaPost Figures" 
 
.IP "\fB--mpsformats=\fP\fIname\fP" 
The name of a MetaPost format file, e.g. \fBmetafun\fP (the default).
.IP "\fB--mptex\fP" 
Strips out and typesets TeX code embedded in a
MetaPost file.
.IP "\fB--nomp\fP" 
Do not run \fBmpost\fP(1), even if needed.
.IP "\fB--nomprun\fP" 
Do not run \fBmpost\fP(1) on embedded
MetaPost code.
 
.SS "Producing Proof Sheets of Figures" 
 
Generate information and proof sheets of one or more (non-EPS)
graphics files.  For example,
.EX
texexec --figures *.png *.jpg
.EE 
scans the current directory for PNG and JPG files
and extracts useful information about their sizes and types.  By
default, this information is stored in 
.IR rlxtools.rli .
Then the given figures are made into a proof sheet (by default
\fItexexec.pdf\fP) according to the method specified by the
\fB--method\fP option. Note that newer versions of 
.BR pdftex (1)
do not support TIFF inclusion.
.IP "\fB--method=\fP\fIALTERNATIVE\fP"
Specify one of three options to produce the document containing the images
used in the source file:

\fBa\fP : A proof sheet with additional
information provided for each figure (the default)

\fBb\fP : A proof sheet with the graphics only

\fBc\fP : One figure per page, with the page
clipped to the bounding box of the
figure

See also \fB--paperoffset\fP,
which allows you to specify an offset to be added to
the page, as in 
.EX 
texexec --figures --method=c --paperoffset=.5cm *.pdf *.png *.jpg
.EE 
 
.SH "USAGE" 
 
Each ConTeXt user interface (language) has its own format.  The
following command generates two formats, one using the English
interface for typesetting in English, and one for Dutch:
.EX 
\f(CWtexexec --make en nl\fP
.EE 

By default, the language used for typesetting matches the
user-interface language (set with
\fB--interface\fP.  It is possible to use one
language for typesetting and another for messages by changing the
relevant settings in \fIcont-usr.tex\fP.  These languages can
also be changed on the command line with a command such as
.IP 
.RS 
\f(CWtexexec --make --language=pl,cz,sk en\fP
.RE 
.IP 
That command generates a ConTeXt format file with an English user
interface, and the main language set to Polish (\fBpl\fP).  Czech
and Slovak hyphenation patterns are also loaded
so that Czech and Slovak text included in a source file will be
typeset properly (\fBcz\fP and \fBsk\fP).
.IP o 
When the appropriate formats are present, a file can be typeset
by typing
.EX 
\f(CWtexexec test\fP
.EE 
.IP 
\fBtexexec\fP tries to determine what interface it should use to
typeset \fItest.tex\fP by looking for a line such as 
.IP 
.EX 
\f(CW% interface=en tex=pdftex output=pdftex\fP
.EE 
.IP 
at the top of the file (i.e., on the very first line).  This line is
equivalent to \fBTeX\fP's format line, ``&\fIFORMAT\fP'').
.IP 
By default, \fBtexexec\fP will produce a PDF file using \fBpdftex\fP(1).  The
\fB--dvips\fP flag tells \fBtexexec\fP to produce a PostScript
file instead.
.IP 
After an error-free run, \fBtexexec\fP will run \fBtexutil\fP(1) to
determine whether additional runs of \fBtex\fP(1) (or
\fBpdftex\fP(1)) or any utility programs (e.g., \fBbibtex\fP(1),
\fBmakeindex\fP(1)) are necessary.  You can suppress these
additional runs by specifying the \fB--once\fP or
\fB--runs\fP flags:
.IP 
.EX 
\f(CWtexexec --once test\fP 
\f(CWtexexec --runs=2 test\fP
.EE 
.IP 

.SH EXAMPLES
.TP
Produce PDF from ConTeXt source (the .tex extension is optional):
\f(CWtexexec file.tex\fP
.TP
Same as the above but without rerunning for crossreferences, etc.:
\f(CWtexexec --once file.tex\fP
.TP
Produce PostScript from ConTeXt source:
\f(CWtexexec --ps file.tex\fP
.TP
Produce file-a4.pdf using conditional compilation (modes):
\f(CWtexexec --mode=a4 --result=file-a4 file.tex\fP
.TP
Generate format (.fmt) files used by ConTeXt (used during installation):
\f(CWtexexec --make --all\fP


.SH "INITIALIZATION" 
.IP 
\fBtexexec\fP requires ruby.  On Unix and Unix-like systems, no special
steps have to be taken to get \fBtexexec\fP to work beyond installing
ruby and having the \fBruby\fP(1) binary in your path.

.SH "SEE ALSO" 
.PP
\fBbibtex\fP(1), \fBctxtools\fP(1), \fBdvipdfmx\fP(1), \fBdvips\fP(1),
\fBfmtutil\fP(1), \fBmakeindex\fP(1), \fBmpost\fP(1),
\fBmptopdf\fP(1), \fBpdftex\fP(1), \fBpdftk\fP(1), \fBruby\fP(1),
\fBpsnup\fP(1), \fBtex\fP(1), \fBtexfont\fP(1), \fBtexmfstart\fP(1),
\fBtexshow\fP(1),
\fBtexutil\fP(1), \fBxetex\fP(1).
.PP
The texexec manual 
.IR mtexexec.pdf ,
available from
.URL "http://www.pragma-ade.com/dir/general/manuals/" "PRAGMA ADE" .
.PP
Donald E. Knuth's \fIThe TeXbook\fP.
.PP
.URL "http://www.contextgarden.net" "ConTeXt wiki" .

.SH "AUTHOR" 
This manpage was written by Tobias Burnus
<burnus@gmx.de> and C.M. Connelly
<c@eskimo.com> and updated by Sanjoy Mahajan <sanjoy@mit.edu>.  
It is based on the
.I mtexexec.pdf
manual written by Hans Hagen <pragma@wxs.nl>.
