#!/bin/bash
# Ten skrypt przekodowuje pliki pomidzy iso8859-cp1250
# Mona rozpowszechnia na licencji GNU. 
#
# Ten plik moe si przyda do przekodowania 'Wprowadzenia'
# z ISO8859-2 na CP1250
USAGE="Przekodowanie plikw TeXowych pomidzy ISO-8859-2 a CP1250
Pliki winny mie oznaczenie strony kodowej w postaci 
odpowiedniego wpisu: translate-file=il2-pl lub translate-file=cp1250pl

Sposb wykorzystania: $0 pliki... "

if test $# = 0 ; then echo "$USAGE" ; fi

for i in $*;
do  perl -i.bak -e 'undef $/; $_ = <>;
      if (/translate-file=il2-pl/) { 
        print STDERR "Przekodowanie iso8859 -> cp1250\n";
        # zmienia tylko pierwsze wystpienie
        s/translate-file=il2-pl/translate-file=cp1250pl/ ;
        tr/ʳӦ󶼿/ʳӌ󜟿/ ;
        s/\n/\r\n/gm; # unix2dos
      }
      elsif (/translate-file=cp1250pl/) { 
        print STDERR "Przekodowanie cp1250 -> iso8859\n";
        # zmienia tylko pierwsze wystpienie
        s/translate-file=cp1250pl/translate-file=il2-pl/ ;
        tr/ʳӌ󜟿/ʳӦ󶼿/ ;
        s/\r//g; # dos2unix
      }
      else { print STDERR "Nieustalona strona kodowa *** nic nie robi\n"; }
      print "$_"; ' $i;
done
