#!/bin/sh
#
################################
# Utilisation: 
# Dcompacter l'archive rcupre sur CTAN, se placer  la racine
# (c.--d. dans le rpertoire o se trouve le fichier 'install-tabvar.sh')
# et lancer la commande install-tabvar.sh.
# Ce script installe l'extension `tabvar' dans votre rpertoire TEXMF
# personnel (cr au besoin) sur les systmes Unix  base tetex/TeXLive.
################################
# Configuration de base 
INSTDIR=`kpsewhich --expand-var='$TEXMFHOME'`
# Cas d'anciennes distributions :
if [ "x$INSTDIR" == "x" ]; then
   INSTDIR=`kpsewhich --expand-var='$HOMETEXMF'`
fi
if [ "x$INSTDIR" == "x" ]; then
   echo "chec : rpertoire TEXMF personnel non trouv"
   exit
fi
################################
# Rpertoires d'installation
DOCDIR=${INSTDIR}/doc/latex/tabvar
MPDIR=${INSTDIR}/metapost/tabvar
SOURCEDIR=${INSTDIR}/source/latex/tabvar
INPUTDIR=${INSTDIR}/tex/latex/tabvar
AFMDIR=${INSTDIR}/fonts/afm/public/tabvar
TFMDIR=${INSTDIR}/fonts/tfm/public/tabvar
PFBDIR=${INSTDIR}/fonts/tupe1/public/tabvar
# L'emplacement du fichier tabvar.map dpend des distributions... Tester 
# s'il existe un rpertoire `fonts/map' dans le rpertoire TEXMF principal.
TEXMFCNFMAIN=`kpsewhich --expand-var='$TEXMFMAIN'`
map=`grep 'TEXFONTMAPS' ${TEXMFCNFMAIN}/web2c/texmf.cnf | grep 'fonts/map//$'`
if [ "x$map" == "x" ]; then
   MAPDIR=${INSTDIR}/dvips/tabvar
else
   MAPDIR=${INSTDIR}/fonts/map/dvips/tabvar
fi
################################
# Crer les rpertoires ncessaires :
${TEXMFCNFMAIN}/web2c/mktexdir ${DOCDIR} ${MPDIR} ${SOURCEDIR} ${INPUTDIR} ${AFMDIR} ${TFMDIR} ${PFBDIR} ${MAPDIR}
# Ventiler les fichiers dans l'arborescence ainsi cre :
cp 00README install-tabvar.sh doc/* ${DOCDIR}
cp source/*.mp ${MPDIR}
cp source/*.dtx   source/*.ins ${SOURCEDIR}
cp inputs/* ${INPUTDIR}
cp font/tabvar.afm ${AFMDIR}
cp font/tabvar.tfm ${TFMDIR}
cp font/tabvar.pfb ${PFBDIR}
cp font/tabvar.map ${MAPDIR}
################################
# Mettre  jour les fichiers .map  l'aide du script updmap.
# S'il n'y a pas de fichier updmap.cfg dans l'arborescence perso,
# rechercher le fichier updmap actif et l'y recopier.
if [ ! -f $INSTDIR/web2c/updmap.cfg ]; then
   UPDMAPCFG=`kpsewhich --format='web2c files' updmap.cfg`
   ${TEXMFCNFMAIN}/web2c/mktexdir $INSTDIR/web2c/
   cp ${UPDMAPCFG} $INSTDIR/web2c/
fi
# Ajouter la ligne concernant tabvar dans updmap.cfg et regnrer
# les fichiers .map pour dvips, pdftex, etc.
updmap --enable Map=tabvar.map
