<!-- -*- Mode: nXML; tab-width: 2; indent-tabs-mode: nil; -*- -->
<!-- This Source Code Form is subject to the terms of the Mozilla Public
   - License, v. 2.0. If a copy of the MPL was not distributed with this
   - file, You can obtain one at http://mozilla.org/MPL/2.0/. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  
  <xsl:strip-space elements="*"/>

  <xsl:template match="charlist">
    <root><xsl:apply-templates select="character"/></root>
  </xsl:template>

  <xsl:template match="character">
    <xsl:if test="operator-dictionary">
      <xsl:for-each select="operator-dictionary">
        <entry>

          <xsl:attribute name="unicode">
            <xsl:value-of select="../@id"/>
          </xsl:attribute> 

          <xsl:attribute name="form">
            <xsl:value-of select="@form"/>
          </xsl:attribute> 

          <!-- begin operator-dictionary -->
          <xsl:if test="@lspace">
            <xsl:attribute name="lspace">
              <xsl:value-of select="@lspace"/>
            </xsl:attribute> 
          </xsl:if>
          <xsl:if test="@rspace">
            <xsl:attribute name="rspace">
            <xsl:value-of select="@rspace"/>
            </xsl:attribute> 
          </xsl:if>
          <xsl:if test="@*[.='true']">
            <xsl:attribute name="properties">
              <!-- largeop, movablelimits, stretchy, separator, fence,
                   symmetric -->
              <xsl:for-each select="@*[.='true']">
                <xsl:value-of select="name()"/>
                <xsl:text> </xsl:text>
              </xsl:for-each>
            </xsl:attribute> 
          </xsl:if>
          <!-- end operator-dictionary -->

          <xsl:attribute name="description">
            <xsl:value-of select="../description"/>
          </xsl:attribute> 

        </entry>
      </xsl:for-each>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
