/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

var dd       = opener.dd;
var console  = opener.console;
var getMsg   = opener.getMsg;
var dispatch = console.dispatch;
var windowId;
var containedViews = new Object();

function onLoad()
{
    var ary = document.location.search.match(/(?:\?|&)id=([^&]+)/);
    if (!ary)
    {
        dd ("No window id in url " + document.location);
        return;
    }
    
    windowId = ary[1];
    
    if (console.prefs["menubarInFloaters"])
        console.createMainMenu (window.document);

    if ("arguments" in window && 0 in window.arguments &&
        typeof window.arguments[0] == "function")
    {
        setTimeout(window.arguments[0], 500, window);
    }
}

function onClose()
{
    window.isClosing = true;
    return true;
}

function onUnload()
{
    console.viewManager.destroyWindow (windowId);
}

function onViewRemoved(view)
{
    delete containedViews[view.viewId];
    updateTitle();
}

function onViewAdded(view)
{
    containedViews[view.viewId] = view;
    updateTitle();
}

function updateTitle()
{
    var ary = new Array();
    
    for (v in containedViews)
        ary.push(containedViews[v].caption);

    var views = ary.join(opener.MSG_COMMASP);
    if (views == "")
        views = opener.MSG_VAL_NONE;
    
    document.title = getMsg(opener.MSN_FLOATER_TITLE, views);
}


