/*
 * Copyright 2013-2014 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Loïc Molinari <loic.molinari@canonical.com>
 */

class QSGTexture;

struct ShapeTextureData {
    const unsigned char* const data;
    int width;
    int height;
    int bytesPerPixel;
    float smallRadius;
    float mediumRadius;
    float gridUnit;
    float coordinate[6][16][2];
};

static const unsigned char shapeTextureHighData[256 * 128 * 4 + 1] =
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\1\0\0\377\31\0\0\3778\0\0\377"
    "T\0\0\377n\0\0\377\202\0\0\377\226\0\0\377\252\0\0\377\272\0\0\377\311\0"
    "\0\377\321\0\0\377\335\0\0\377\337\0\0\377\356\0\0\377\356\0\0\377\356\0"
    "\0\377\366\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\1\0\0\377\31\0\13\3778\0\30\377T\0$\377n\0/\377"
    "\202\0""8\377\226\0@\377\252\0H\377\272\0O\377\311\0U\377\321\0Y\377\335"
    "\0^\377\337\0^\377\356\0d\377\356\0d\377\356\0d\377\366\0g\377\377\0k\377"
    "\377\0k\377\377\0k\377\377\0k\377\377\0k\377\377\0k\377\377\0k\377\377\0"
    "k\377\377\0k\377\377\0k\377\377\0k\377\377\0k\377\377\0k\377\377\0k\377\377"
    "\0k\377\377\0k\377\377\0k\377\377\0k\377\377\0k\377\377\0k\377\377\0k\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\1\0\1\377\31\0\15\3778\0\35"
    "\377T\0,\377n\0""9\377\202\0D\377\226\0N\377\252\0Y\377\272\0a\377\311\0"
    "i\377\321\0m\377\335\0s\377\337\0t\377\356\0|\377\356\0|\377\356\0|\377\366"
    "\0\200\377\377\0\205\377\377\0\205\377\377\0\205\377\377\0\205\377\377\0"
    "\205\377\377\0\205\377\377\0\205\377\377\0\205\377\377\0\205\377\377\0\205"
    "\377\377\0\205\377\377\0\205\377\377\0\205\377\377\0\205\377\377\0\205\377"
    "\377\0\205\377\377\0\205\377\377\0\205\377\377\0\205\377\377\0\205\377\377"
    "\0\205\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\5\0\0\377\36\0\0\3772\0\0\377D\0\0\377U\0\0\377f\0\0\377"
    "f\0\0\377f\0\0\377u\0\0\377w\0\0\377w\0\0\377w\0\0\377w\0\0\377w\0\0\377"
    "w\0\0\377w\0\0\377w\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\5\0\2\377\36\0\15\3772\0\26\377D\0\35\377"
    "U\0%\377f\0,\377f\0,\377f\0,\377u\0""2\377w\0""3\377w\0""3\377w\0""3\377"
    "w\0""3\377w\0""3\377w\0""3\377w\0""3\377w\0""3\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\16\0\0\377A\0\0\377w\0\0\377"
    "\246\0\0\377\316\0\0\377\365\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\16\0\6\377A\0\34\377w\0""3\377\246"
    "\0F\377\316\0W\377\365\0g\377\377\0j\377\377\0j\377\377\0i\377\377\0h\377"
    "\377\0h\377\377\0g\377\377\0f\377\377\0f\377\377\0e\377\377\0e\377\377\0"
    "e\377\377\0d\377\377\0d\377\377\0d\377\377\0d\377\377\0c\377\377\0c\377\377"
    "\0c\377\377\0c\377\377\0c\377\377\0c\377\377\0c\377\377\0c\377\377\0c\377"
    "\377\0c\377\377\0c\377\377\0c\377\377\0c\377\377\0c\377\377\0c\377\377\0"
    "c\377\377\0c\377\377\0c\377\377\0c\377\377\0c\377\377\0c\377\377\0c\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\16\0\7\377"
    "A\0\"\377w\0>\377\246\0W\377\316\0k\377\365\0\200\377\377\0\205\377\377\0"
    "\205\377\377\0\205\377\377\0\205\377\377\0\205\377\377\0\205\377\377\0\205"
    "\377\377\0\205\377\377\0\205\377\377\0\205\377\377\0\205\377\377\0\205\377"
    "\377\0\205\377\377\0\205\377\377\0\205\377\377\0\205\377\377\0\205\377\377"
    "\0\205\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0"
    "\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204"
    "\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377"
    "\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\11\0\0\377>\0\0\377}\0\0\377\265\0\0\377\337\0\0\377\374\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\11\0\4\377>\0\33\377}\0""5\377\265\0M\377\337\0]\377\374\0h\377\377"
    "\0g\377\377\0e\377\377\0c\377\377\0a\377\377\0_\377\377\0^\377\377\0^\377"
    "\377\0]\377\377\0\\\377\377\0\\\377\377\0\\\377\377\0\\\377\377\0\\\377\377"
    "\0\\\377\377\0\\\377\377\0\\\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\3776\0\0"
    "\377\203\0\0\377\310\0\0\377\374\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\3776\0\27\377\203\0""8\377\310\0U\377\374\0j\377\377\0i\377\377\0h\377\377"
    "\0g\377\377\0e\377\377\0c\377\377\0b\377\377\0`\377\377\0^\377\377\0\\\377"
    "\377\0Z\377\377\0Y\377\377\0W\377\377\0V\377\377\0T\377\377\0S\377\377\0"
    "R\377\377\0Q\377\377\0P\377\377\0P\377\377\0O\377\377\0O\377\377\0N\377\377"
    "\0N\377\377\0N\377\377\0N\377\377\0N\377\377\0N\377\377\0N\377\377\0N\377"
    "\377\0N\377\377\0N\377\377\0N\377\377\0N\377\377\0N\377\377\0N\377\377\0"
    "N\377\377\0N\377\377\0N\377\377\0N\377\377\0N\377\377\0N\377\377\0N\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\3776\0\34\377\203\0D\377\310\0h\377\374\0"
    "\203\377\377\0\205\377\377\0\205\377\377\0\205\377\377\0\205\377\377\0\204"
    "\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377"
    "\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377"
    "\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0"
    "\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204"
    "\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377"
    "\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377"
    "\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0"
    "\204\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\3776\0\0\377\231\0\0\377\363\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\3776\0\27\377\231\0A\377\363\0d\377\377\0c\377\377\0[\377"
    "\377\0Q\377\377\0F\377\377\0=\377\377\0""7\377\377\0""3\377\377\0/\377\377"
    "\0+\377\377\0)\377\377\0(\377\377\0'\377\377\0%\377\377\0$\377\377\0$\377"
    "\377\0$\377\377\0$\377\377\0$\377\377\0$\377\377\0$\377\377\0$\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\30"
    "\0\0\377\177\0\0\377\334\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\30\0\12\377\177\0""6\377\334\0\\\377\377\0j\377\377\0h\377"
    "\377\0e\377\377\0b\377\377\0_\377\377\0\\\377\377\0X\377\377\0T\377\377\0"
    "P\377\377\0L\377\377\0I\377\377\0F\377\377\0C\377\377\0A\377\377\0>\377\377"
    "\0<\377\377\0:\377\377\0""8\377\377\0""6\377\377\0""5\377\377\0""4\377\377"
    "\0""3\377\377\0""3\377\377\0""2\377\377\0""1\377\377\0""1\377\377\0""0\377"
    "\377\0""0\377\377\0""0\377\377\0""0\377\377\0""0\377\377\0""0\377\377\0""0"
    "\377\377\0""0\377\377\0""0\377\377\0""0\377\377\0""0\377\377\0""0\377\377"
    "\0""0\377\377\0""0\377\377\0""0\377\377\0""0\377\377\0""0\377\377\0""0\377"
    "\377\0""0\377\377\0""0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\30\0\15\377\177\0B\377\334\0s\377\377\0\205"
    "\377\377\0\205\377\377\0\205\377\377\0\204\377\377\0\204\377\377\0\204\377"
    "\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\203\377\377"
    "\0\203\377\377\0\203\377\377\0\203\377\377\0\203\377\377\0\202\377\377\0"
    "\202\377\377\0\202\377\377\0\202\377\377\0\202\377\377\0\202\377\377\0\202"
    "\377\377\0\202\377\377\0\202\377\377\0\202\377\377\0\202\377\377\0\202\377"
    "\377\0\202\377\377\0\202\377\377\0\202\377\377\0\202\377\377\0\202\377\377"
    "\0\202\377\377\0\202\377\377\0\202\377\377\0\202\377\377\0\202\377\377\0"
    "\202\377\377\0\202\377\377\0\202\377\377\0\202\377\377\0\202\377\377\0\202"
    "\377\377\0\202\377\377\0\202\377\377\0\202\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\34\0\0\377\251\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\34\0\14\377\251\0G\377\377\0"
    "d\377\377\0V\377\377\0B\377\377\0""1\377\377\0#\377\377\0\26\377\377\0\12"
    "\377\377\0\3\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\36\0\0\377\233\0\0\377\370"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\36\0\15"
    "\377\233\0B\377\370\0g\377\377\0h\377\377\0d\377\377\0`\377\377\0[\377\377"
    "\0U\377\377\0O\377\377\0H\377\377\0C\377\377\0=\377\377\0""8\377\377\0""3"
    "\377\377\0/\377\377\0+\377\377\0(\377\377\0$\377\377\0\"\377\377\0\40\377"
    "\377\0\35\377\377\0\33\377\377\0\31\377\377\0\30\377\377\0\27\377\377\0\26"
    "\377\377\0\25\377\377\0\24\377\377\0\23\377\377\0\23\377\377\0\22\377\377"
    "\0\22\377\377\0\22\377\377\0\22\377\377\0\22\377\377\0\22\377\377\0\22\377"
    "\377\0\22\377\377\0\22\377\377\0\22\377\377\0\22\377\377\0\22\377\377\0\22"
    "\377\377\0\22\377\377\0\22\377\377\0\22\377\377\0\22\377\377\0\22\377\377"
    "\0\22\377\377\0\22\377\377\0\22\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\36\0\20\377\233\0Q\377\370\0\201\377\377\0\205\377\377"
    "\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0"
    "\203\377\377\0\203\377\377\0\202\377\377\0\202\377\377\0\202\377\377\0\201"
    "\377\377\0\201\377\377\0\201\377\377\0\200\377\377\0\200\377\377\0\177\377"
    "\377\0\177\377\377\0\177\377\377\0\177\377\377\0\177\377\377\0\177\377\377"
    "\0\177\377\377\0\177\377\377\0\177\377\377\0\177\377\377\0\177\377\377\0"
    "\177\377\377\0\177\377\377\0\177\377\377\0\177\377\377\0\177\377\377\0\177"
    "\377\377\0\177\377\377\0\177\377\377\0\177\377\377\0\177\377\377\0\177\377"
    "\377\0\177\377\377\0\177\377\377\0\177\377\377\0\177\377\377\0\177\377\377"
    "\0\177\377\377\0\177\377\377\0\177\377\377\0\177\377\377\0\177\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377>\0\0\377\357\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377>\0\33\377\357\1b\377"
    "\377\0T\377\377\0""8\377\377\0\34\377\377\0\11\377\377\0\1\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\5\0\0\377\177\0\0\377"
    "\366\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\5\0\2\377\177\0""6\377\366\0f\377\377\0g\377\377\0b\377\377\0[\377\377\0"
    "S\377\377\0K\377\377\0B\377\377\0:\377\377\0""2\377\377\0+\377\377\0$\377"
    "\377\0\36\377\377\0\31\377\377\0\25\377\377\0\21\377\377\0\16\377\377\0\14"
    "\377\377\0\13\377\377\0\11\377\377\0\7\377\377\0\6\377\377\0\5\377\377\0"
    "\4\377\377\0\4\377\377\0\3\377\377\0\2\377\377\0\2\377\377\0\1\377\377\0"
    "\1\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\5\0\3\377\177\0B\377\366\0\200\377\377\0\204\377\377\0"
    "\204\377\377\0\204\377\377\0\204\377\377\0\203\377\377\0\203\377\377\0\202"
    "\377\377\0\202\377\377\0\201\377\377\0\200\377\377\0\177\377\377\0\177\377"
    "\377\0\177\377\377\0~\377\377\0~\377\377\0}\377\377\0|\377\377\0|\377\377"
    "\0{\377\377\0{\377\377\0z\377\377\0z\377\377\0y\377\377\0y\377\377\0y\377"
    "\377\0y\377\377\0y\377\377\0y\377\377\0y\377\377\0y\377\377\0y\377\377\0"
    "y\377\377\0y\377\377\0y\377\377\0y\377\377\0y\377\377\0y\377\377\0y\377\377"
    "\0y\377\377\0y\377\377\0y\377\377\0y\377\377\0y\377\377\0y\377\377\0y\377"
    "\377\0y\377\377\0y\377\377\0y\377\377\0y\377\377\0y\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377E\0\0\377\366\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377E\0\35\377\366\1`\377\377\0E\377\377\0\35\377"
    "\377\0\6\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377$\0\0\377\316\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377$\0\17\377\316\0V\377\377"
    "\0g\377\377\0b\377\377\0Z\377\377\0O\377\377\0D\377\377\0""9\377\377\0.\377"
    "\377\0$\377\377\0\33\377\377\0\24\377\377\0\16\377\377\0\12\377\377\0\7\377"
    "\377\0\4\377\377\0\2\377\377\0\1\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377$\0\23\377"
    "\316\0k\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\203\377\377\0"
    "\203\377\377\0\202\377\377\0\201\377\377\0\200\377\377\0\177\377\377\0\177"
    "\377\377\0}\377\377\0|\377\377\0{\377\377\0y\377\377\0y\377\377\0x\377\377"
    "\0v\377\377\0u\377\377\0t\377\377\0s\377\377\0s\377\377\0q\377\377\0p\377"
    "\377\0p\377\377\0o\377\377\0n\377\377\0n\377\377\0m\377\377\0m\377\377\0"
    "m\377\377\0m\377\377\0m\377\377\0m\377\377\0m\377\377\0m\377\377\0m\377\377"
    "\0m\377\377\0m\377\377\0m\377\377\0m\377\377\0m\377\377\0m\377\377\0m\377"
    "\377\0m\377\377\0m\377\377\0m\377\377\0m\377\377\0m\377\377\0m\377\377\0"
    "m\377\377\0m\377\377\0m\377\0\0\0\377\0\0\0\377\0\0\0\377\34\0\0\377\360"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\34\0\14\377\360\2^\377\377\0>\377\377\0\21\377\377\0\1\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "A\0\0\377\355\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377A\0\34\377\355\0b\377\377\0d\377\377\0\\\377\377"
    "\0P\377\377\0B\377\377\0""4\377\377\0&\377\377\0\33\377\377\0\22\377\377"
    "\0\13\377\377\0\6\377\377\0\3\377\377\0\1\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377A\0\"\377\355\0{\377\377"
    "\0\204\377\377\0\204\377\377\0\203\377\377\0\202\377\377\0\201\377\377\0"
    "\200\377\377\0\177\377\377\0~\377\377\0|\377\377\0z\377\377\0y\377\377\0"
    "v\377\377\0s\377\377\0r\377\377\0p\377\377\0m\377\377\0l\377\377\0j\377\377"
    "\0h\377\377\0g\377\377\0e\377\377\0d\377\377\0c\377\377\0b\377\377\0a\377"
    "\377\0a\377\377\0`\377\377\0_\377\377\0^\377\377\0^\377\377\0]\377\377\0"
    "]\377\377\0]\377\377\0]\377\377\0\\\377\377\0\\\377\377\0\\\377\377\0\\\377"
    "\377\0\\\377\377\0\\\377\377\0\\\377\377\0\\\377\377\0\\\377\377\0\\\377"
    "\377\0\\\377\377\0\\\377\377\0\\\377\377\0\\\377\377\0\\\377\377\0\\\377"
    "\377\0\\\377\377\0\\\377\377\0\\\377\0\0\0\377\0\0\0\377\0\0\0\377\255\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\255\4I\377\377\0D\377\377\0\20\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377A\0\0\377\365\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377A\0\34\377\365\0d\377\377\0b\377\377\0V\377"
    "\377\0G\377\377\0""6\377\377\0%\377\377\0\27\377\377\0\15\377\377\0\7\377"
    "\377\0\3\377\377\0\1\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377A\0\"\377\365\0\177"
    "\377\377\0\204\377\377\0\203\377\377\0\202\377\377\0\201\377\377\0\177\377"
    "\377\0~\377\377\0|\377\377\0y\377\377\0w\377\377\0s\377\377\0p\377\377\0"
    "m\377\377\0j\377\377\0g\377\377\0c\377\377\0a\377\377\0^\377\377\0\\\377"
    "\377\0Z\377\377\0X\377\377\0W\377\377\0U\377\377\0S\377\377\0R\377\377\0"
    "Q\377\377\0P\377\377\0O\377\377\0N\377\377\0N\377\377\0M\377\377\0L\377\377"
    "\0L\377\377\0K\377\377\0K\377\377\0K\377\377\0K\377\377\0K\377\377\0K\377"
    "\377\0K\377\377\0K\377\377\0K\377\377\0K\377\377\0K\377\377\0K\377\377\0"
    "K\377\377\0K\377\377\0K\377\377\0K\377\377\0K\377\377\0K\377\377\0K\377\377"
    "\0K\377\377\0K\377\377\0K\377\0\0\0\377\0\0\0\3771\0\0\377\376\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\3771\0\25\377"
    "\376\0T\377\377\0\35\377\377\0\1\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377.\0\0\377\365\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377.\0\23\377\365\0d\377\377\0`\377\377\0R\377\377\0@\377\377"
    "\0,\377\377\0\32\377\377\0\16\377\377\0\6\377\377\0\2\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377.\0\30\377\365\0\177\377\377\0\204"
    "\377\377\0\203\377\377\0\202\377\377\0\177\377\377\0~\377\377\0{\377\377"
    "\0x\377\377\0t\377\377\0p\377\377\0l\377\377\0g\377\377\0b\377\377\0^\377"
    "\377\0Z\377\377\0W\377\377\0S\377\377\0P\377\377\0M\377\377\0K\377\377\0"
    "H\377\377\0F\377\377\0E\377\377\0C\377\377\0B\377\377\0@\377\377\0@\377\377"
    "\0?\377\377\0>\377\377\0=\377\377\0<\377\377\0;\377\377\0;\377\377\0;\377"
    "\377\0:\377\377\0:\377\377\0:\377\377\0:\377\377\0:\377\377\0:\377\377\0"
    ":\377\377\0:\377\377\0:\377\377\0:\377\377\0:\377\377\0:\377\377\0:\377\377"
    "\0:\377\377\0:\377\377\0:\377\377\0:\377\377\0:\377\377\0:\377\377\0:\377"
    "\377\0:\377\377\0:\377\0\0\0\377\0\0\0\377\233\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\233\10E\377"
    "\377\0""8\377\377\0\6\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\20\0\0\377\334\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\20\0\7\377\334\0Z\377\377\0_\377\377\0P\377\377\0<\377\377\0%\377"
    "\377\0\23\377\377\0\10\377\377\0\3\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\20\0\10\377\334\0r\377\377\0\204\377"
    "\377\0\202\377\377\0\200\377\377\0\177\377\377\0|\377\377\0x\377\377\0s\377"
    "\377\0m\377\377\0h\377\377\0b\377\377\0\\\377\377\0W\377\377\0Q\377\377\0"
    "M\377\377\0I\377\377\0E\377\377\0B\377\377\0?\377\377\0<\377\377\0:\377\377"
    "\0""8\377\377\0""6\377\377\0""5\377\377\0""4\377\377\0""2\377\377\0""2\377"
    "\377\0""1\377\377\0""0\377\377\0/\377\377\0/\377\377\0/\377\377\0/\377\377"
    "\0.\377\377\0.\377\377\0-\377\377\0-\377\377\0-\377\377\0-\377\377\0-\377"
    "\377\0-\377\377\0-\377\377\0-\377\377\0-\377\377\0-\377\377\0-\377\377\0"
    "-\377\377\0-\377\377\0-\377\377\0-\377\377\0-\377\377\0-\377\377\0-\377\377"
    "\0-\377\377\0-\377\377\0-\377\377\0-\377\0\0\0\377\5\0\0\377\357\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\5"
    "\0\2\377\357\4V\377\377\0\35\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\234"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\234\0@\377\377\0a\377\377\0Q\377\377\0;\377"
    "\377\0#\377\377\0\20\377\377\0\6\377\377\0\2\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\234\0Q\377\377"
    "\0\203\377\377\0\202\377\377\0\200\377\377\0~\377\377\0y\377\377\0t\377\377"
    "\0n\377\377\0h\377\377\0`\377\377\0Y\377\377\0Q\377\377\0K\377\377\0E\377"
    "\377\0@\377\377\0<\377\377\0""9\377\377\0""5\377\377\0""3\377\377\0""0\377"
    "\377\0/\377\377\0-\377\377\0,\377\377\0+\377\377\0*\377\377\0)\377\377\0"
    ")\377\377\0)\377\377\0(\377\377\0(\377\377\0(\377\377\0'\377\377\0'\377\377"
    "\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377>\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0"
    "\0\377>\2\34\377\377\0C\377\377\0\11\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377>\0\0\377"
    "\376\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377>\0\32\377\376\0c\377\377\0T\377\377\0>\377\377"
    "\0$\377\377\0\17\377\377\0\5\377\377\0\1\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377>\0\40\377\376"
    "\0\202\377\377\0\202\377\377\0\177\377\377\0|\377\377\0x\377\377\0r\377\377"
    "\0j\377\377\0b\377\377\0X\377\377\0P\377\377\0H\377\377\0A\377\377\0;\377"
    "\377\0""6\377\377\0""2\377\377\0/\377\377\0,\377\377\0*\377\377\0)\377\377"
    "\0(\377\377\0'\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377v\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\0\0\0\377v\16<\377\377\0""2\377\377\0\1\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\305\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\305\0O\377\377\0Z\377\377\0D\377\377"
    "\0)\377\377\0\22\377\377\0\5\377\377\0\1\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\305"
    "\0f\377\377\0\202\377\377\0\177\377\377\0|\377\377\0w\377\377\0p\377\377"
    "\0g\377\377\0\\\377\377\0R\377\377\0H\377\377\0@\377\377\0""9\377\377\0""3"
    "\377\377\0/\377\377\0,\377\377\0)\377\377\0(\377\377\0'\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0"
    "\0\0\377\251\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\0\0\0\377\251\21N\377\377\0$\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377F\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377F\0\35\377\377\0`\377\377\0M"
    "\377\377\0""2\377\377\0\27\377\377\0\7\377\377\0\1\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377F\0$\377\377\0\202\377\377\0\177\377\377\0|\377\377\0w\377\377"
    "\0o\377\377\0e\377\377\0Y\377\377\0M\377\377\0B\377\377\0""9\377\377\0""2"
    "\377\377\0.\377\377\0*\377\377\0)\377\377\0'\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\0\0\0\377\332\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\332\12Q\377\377\0\30\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\261\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\261"
    "\0F\377\377\0V\377\377\0>\377\377\0!\377\377\0\13\377\377\0\2\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\261\0Z\377\377\0\200\377\377\0}\377\377\0"
    "x\377\377\0o\377\377\0d\377\377\0W\377\377\0K\377\377\0?\377\377\0""5\377"
    "\377\0/\377\377\0+\377\377\0)\377\377\0'\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\4\0\0\377\373\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\4\0\2\377\373"
    "\1H\377\377\0\13\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\34\0\0\377\375\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\34\0\14\377\375\0^\377\377\0K\377\377\0/\377\377\0\23\377\377\0\4"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\34\0\16\377\375\0\200\377"
    "\377\0\177\377\377\0y\377\377\0q\377\377\0f\377\377\0X\377\377\0K\377\377"
    "\0=\377\377\0""4\377\377\0-\377\377\0)\377\377\0(\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\37\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\37\2\17\377\377\0=\377\377\0\3\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377q\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377q\0-\377\377\0W\377\377\0>\377\377\0!\377\377"
    "\0\12\377\377\0\1\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377q\0:\377\377"
    "\0\177\377\377\0{\377\377\0s\377\377\0i\377\377\0[\377\377\0L\377\377\0>"
    "\377\377\0""3\377\377\0,\377\377\0)\377\377\0'\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\3779\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\3779\12!\377\377\0""6\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\306\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\306\3O\377\377\0N\377\377\0""2"
    "\377\377\0\25\377\377\0\4\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\306\3g\377\377\0}\377\377\0w\377\377\0m\377\377\0`\377\377\0Q"
    "\377\377\0A\377\377\0""4\377\377\0-\377\377\0)\377\377\0'\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377O\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377O\20/\377\377\0""1\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0"
    "\0\377\0\0\0\377\22\0\0\377\375\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\22\0\7\377\375\0"
    "[\377\377\0E\377\377\0&\377\377\0\15\377\377\0\1\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\0\0\0\377\0\0\0\377\22\0\11\377\375\0~\377\377\0z\377\377\0r\377\377"
    "\0e\377\377\0W\377\377\0E\377\377\0""8\377\377\0.\377\377\0)\377\377\0'\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377_\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377_\25"
    ":\377\377\0-\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\0\0\0\377\0\0\0\377R\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0"
    "\377R\0\40\377\377\0V\377\377\0:\377\377\0\35\377\377\0\7\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377R\0)\377\377\0}\377\377\0v\377"
    "\377\0l\377\377\0]\377\377\0M\377\377\0=\377\377\0""1\377\377\0*\377\377"
    "\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377o\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377o\26?\377\377\0)\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\220\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\0\0\0\377\0\0\0\377\220\3:\377\377\0N\377\377\0""1\377\377\0\24\377"
    "\377\0\3\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\220"
    "\3K\377\377\0z\377\377\0r\377\377\0e\377\377\0V\377\377\0E\377\377\0""5\377"
    "\377\0,\377\377\0(\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\177\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\177\27E\377\377\0&\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377"
    "\0\0\0\377\307\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\307\7P\377\377\0G\377"
    "\377\0)\377\377\0\16\377\377\0\1\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\0\0\0\377\0\0\0\377\307\7i\377\377\0x\377\377\0m\377\377\0_\377\377\0N\377"
    "\377\0>\377\377\0""0\377\377\0)\377\377\0'\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\207\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\207"
    "\30H\377\377\0#\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\0\0\0\377\4\0\0\377\366\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\4"
    "\0\2\377\366\2Y\377\377\0@\377\377\0!\377\377\0\11\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\0\0\0\377\4\0\2\377\366\2z\377\377\0t\377"
    "\377\0h\377\377\0X\377\377\0G\377\377\0""8\377\377\0-\377\377\0(\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\222\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\222\30K\377\377\0\40\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377)\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\0\0\0\377)\0\20\377\377\0U\377\377\0""9\377\377\0\33"
    "\377\377\0\5\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377"
    ")\0\24\377\377\0z\377\377\0q\377\377\0c\377\377\0R\377\377\0A\377\377\0""3"
    "\377\377\0*\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\226\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\226\31L\377\377"
    "\0\36\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377R\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377R\1!\377\377\0"
    "O\377\377\0""3\377\377\0\25\377\377\0\3\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\0\0\0\377R\1*\377\377\0x\377\377\0m\377\377\0^\377\377"
    "\0M\377\377\0<\377\377\0/\377\377\0)\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\242\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\242\27N\377\377\0\34\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377z\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\0\0\0\377z\11""7\377\377\0K\377\377\0-\377\377\0\20\377\377\0\1\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377z\11E\377\377\0"
    "v\377\377\0i\377\377\0Y\377\377\0H\377\377\0""8\377\377\0,\377\377\0'\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\245\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\245\30N\377\377\0\32\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0"
    "\377\234\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\234\15G\377\377\0F\377"
    "\377\0(\377\377\0\15\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\0\0\0\377\234\15Y\377\377\0s\377\377\0f\377\377\0U\377\377\0"
    "D\377\377\0""4\377\377\0*\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\245\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\245\30N\377\377\0\31\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\275\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377\275\15P\377\377\0B\377\377\0#\377\377\0\12\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\275\15g\377"
    "\377\0p\377\377\0b\377\377\0Q\377\377\0@\377\377\0""1\377\377\0)\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\245\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\245\30N\377\377\0\31\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\0\0\0\377\332\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\332\11T\377\377\0"
    "=\377\377\0\37\377\377\0\7\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\0\0\0\377\332\11p\377\377\0m\377\377\0^\377\377\0M\377"
    "\377\0<\377\377\0/\377\377\0(\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\245\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\245\30N\377\377\0\31\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\366\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377\366\3U\377\377\0:\377\377\0\33\377\377\0\5\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\366\3v\377"
    "\377\0k\377\377\0\\\377\377\0J\377\377\0""9\377\377\0-\377\377\0'\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\245\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\245\30N\377\377\0\31\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\14\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\14\0\5\377\377\0R\377\377\0"
    """6\377\377\0\27\377\377\0\3\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\14\0\6\377\377\0u\377\377\0h\377\377\0X\377\377\0G\377"
    "\377\0""7\377\377\0+\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\245\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\245\30N\377\377\0\31\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377%\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377%\0\17\377\377\0O\377\377\0""3\377\377\0\24\377\377\0\2\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377%\0\22\377\377\0"
    "s\377\377\0g\377\377\0V\377\377\0E\377\377\0""4\377\377\0*\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\245\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\245\31N\377\377\0\27"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\3777\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\3777\4\31\377\377\0M\377\377"
    "\0/\377\377\0\22\377\377\0\1\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\3777\4\37\377\377\0r\377\377\0d\377\377\0S\377\377\0B\377"
    "\377\0""2\377\377\0)\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\245\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\245\30N\377\377\0\31\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377E\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377E\13%\377\377\0K\377\377\0-\377\377\0\20\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377E\13,\377\377\0p"
    "\377\377\0b\377\377\0Q\377\377\0@\377\377\0""1\377\377\0)\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\245\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\245\30N\377\377\0\31"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377T\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377T\17/\377\377\0I\377\377"
    "\0+\377\377\0\16\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377T\17""7\377\377\0o\377\377\0`\377\377\0O\377\377\0>\377"
    "\377\0/\377\377\0(\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\245\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\245\30N\377\377\0\31\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377b\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377b\21""6\377\377\0G\377\377\0)\377\377\0\15\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377b\21@\377\377\0m\377"
    "\377\0^\377\377\0M\377\377\0;\377\377\0/\377\377\0'\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\245\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\245\30N\377\377\0\31\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377q\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377q\23=\377\377\0E\377\377\0'\377\377"
    "\0\14\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377q\23H\377\377\0l\377\377\0\\\377\377\0K\377\377\0:\377\377\0-\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\245\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\245\30N\377\377\0\31\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\177\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\177\24B\377\377\0D\377\377\0%\377\377\0\13\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\177\24O\377\377\0k\377\377\0"
    "[\377\377\0J\377\377\0""9\377\377\0,\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\233\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\233\33N\377\377\0\31\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\216\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\216\25H\377\377\0B\377\377\0$"
    "\377\377\0\12\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\216\25W\377\377\0i\377\377\0Z\377\377\0H\377\377\0""8\377"
    "\377\0,\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\226\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\226\32L\377\377\0\33\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\226\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\226\25J\377\377\0A\377\377\0\"\377\377\0\11\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\226\25Z\377"
    "\377\0h\377\377\0X\377\377\0G\377\377\0""6\377\377\0+\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\212\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\212\34K\377"
    "\377\0\35\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\242\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\242\25N\377"
    "\377\0?\377\377\0!\377\377\0\10\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\242\25_\377\377\0h\377\377\0W\377\377\0"
    "E\377\377\0""5\377\377\0*\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\207\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\207\33J\377\377\0\37\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\245\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\245\26P\377\377\0>\377\377\0\37\377\377\0"
    "\7\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\245\26a\377\377\0g\377\377\0W\377\377\0E\377\377\0""5\377\377\0*\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377v\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "v\36H\377\377\0!\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\255\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\255"
    "\26R\377\377\0=\377\377\0\36\377\377\0\7\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\255\26d\377\377\0f\377\377\0"
    "V\377\377\0D\377\377\0""4\377\377\0)\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377f\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377f\35B\377\377\0$\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\264\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\264\24Q\377\377\0<\377\377\0\35\377\377"
    "\0\6\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\264\24e\377\377\0e\377\377\0U\377\377\0C\377\377\0""4\377\377\0"
    ")\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377V\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377V\34<\377\377\0(\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\270\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\270\24S\377\377\0;\377\377\0\35\377\377\0\6\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\270\24g\377\377\0d\377\377"
    "\0T\377\377\0B\377\377\0""3\377\377\0)\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377E\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377E\32""4\377\377\0+\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\303\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\303\21S\377\377\0:\377\377\0\34\377\377"
    "\0\5\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\303\21h\377\377\0d\377\377\0S\377\377\0B\377\377\0""2\377\377\0"
    ")\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377(\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377(\30(\377\377\0/\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\303\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\303\22S\377\377\0:\377\377\0\33\377\377\0\5\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\303\22i\377\377\0c\377\377"
    "\0R\377\377\0A\377\377\0""2\377\377\0)\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\12\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\12\17\23\377\377\0""5\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\322\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\322\16S\377\377\0""9\377\377\0"
    "\32\377\377\0\4\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\322\16k\377\377\0c\377\377\0Q\377\377\0@\377\377\0""2"
    "\377\377\0)\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0"
    "\377\352\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\0\4\4\377\352\11?\377\377\0\1\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\322\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\322\16S\377\377\0""8\377\377\0\31\377\377\0\4\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\322\16k\377"
    "\377\0b\377\377\0Q\377\377\0@\377\377\0""1\377\377\0)\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\275\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\275"
    "\31K\377\377\0\7\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\322\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\322\17S\377\377"
    "\0""7\377\377\0\31\377\377\0\4\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\322\17k\377\377\0b\377\377\0Q\377\377\0"
    "@\377\377\0""1\377\377\0(\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\0\0\0\377\213\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\0\0\0\377\213#N\377\377\0\22\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\322\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\322\17S\377\377\0""6\377\377\0\30\377\377\0\4\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\322\17k\377\377\0b\377\377\0Q\377\377\0?\377\377\0""0\377\377\0(\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377V\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0"
    "\0\377V&D\377\377\0\37\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\322\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\322\17S\377"
    "\377\0""6\377\377\0\30\377\377\0\3\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\322\17k\377\377\0a\377\377\0P\377\377"
    "\0?\377\377\0""0\377\377\0(\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\0\0\0\377\22\0\0\377\374\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\0\0\0\377\22!(\377\374\1,\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\322\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\322\17S\377\377\0""6\377\377\0\30\377\377\0\3\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\322"
    "\17k\377\377\0a\377\377\0P\377\377\0>\377\377\0/\377\377\0(\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\0\0\377\272\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0"
    "\7\7\377\272\34H\377\377\0\5\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\330\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\330\15S\377\377"
    "\0""6\377\377\0\27\377\377\0\3\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\330\15k\377\377\0a\377\377\0O\377\377\0"
    ">\377\377\0/\377\377\0(\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\0\0\0\377\0\0\0\377V\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377V3N\377\377\0\26\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\341\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\341\12R\377\377\0""6\377\377\0\27\377\377\0\3\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\12l\377"
    "\377\0`\377\377\0O\377\377\0>\377\377\0/\377\377\0(\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\0\0\377\3\0\0\377\323\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\3#$"
    "\377\323\22""9\377\377\0\3\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\12R\377\377\0""5\377\377\0"
    "\27\377\377\0\3\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\341\12l\377\377\0`\377\377\0O\377\377\0=\377\377\0/\377"
    "\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377<\0\0\377\374\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\0\0\0\377\0\0\0\377\0\1\1\377<CU\377\374\1\25\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\341\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\13"
    "S\377\377\0""5\377\377\0\26\377\377\0\3\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\13m\377\377\0`\377\377\0N"
    "\377\377\0=\377\377\0/\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377u\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\31\31\377u8"
    "S\377\377\0\12\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\341\13R\377\377\0""5\377\377\0\26\377\377\0\2\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341"
    "\13l\377\377\0`\377\377\0N\377\377\0=\377\377\0/\377\377\0'\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377t\0\0\377\374\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0""00\377t9P\377\374\1\13\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\341\13R\377\377\0""4\377\377\0\26\377\377"
    "\0\2\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\341\13l\377\377\0`\377\377\0N\377\377\0=\377\377\0/\377\377\0'\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377?\0\0\377\325\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0""00\377?N\\\377\325\21!\377\377\0\3"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\341\13R\377\377\0""4\377\377\0\26"
    "\377\377\0\2\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\341\13l\377\377\0_\377\377\0N\377\377\0=\377\377\0/\377"
    "\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\3\0\0\377T\0"
    "\0\377\265\0\0\377\374\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\32\32\377\3WX\377"
    "TFU\377\265\36.\377\374\1\7\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\13R\377\377\0""4\377\377\0"
    "\26\377\377\0\2\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\341\13l\377\377\0_\377\377\0N\377\377\0<\377\377\0/\377"
    "\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\26\0\0\377Y\0\0\377\222\0\0\377\300\0\0\377\343\0\0\377"
    "\375\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\1\1\377\0##"
    "\377\0KK\377\26_d\377YDS\377\222->\377\300\32(\377\343\14\23\377\375\1\3"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\341\13R\377\377\0""4\377\377\0\26\377\377\0"
    "\2\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\341\13l\377\377\0_\377\377\0N\377\377\0<\377\377\0/\377\377\0'\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\7\0\0\377$\0\0\377"
    "6\0\0\377F\0\0\377W\0\0\377f\0\0\377f\0\0\377f\0\0\377t\0\0\377w\0\0\377"
    "w\0\0\377w\0\0\377w\0\0\377w\0\0\377w\0\0\377w\0\0\377w\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\11\11\377\0%%\377\0<<\377\0OO\377\0]]\377\7eg\377$Z"
    "b\3776S^\377FLY\377WET\377f?O\377f?O\377f?O\377t9J\377w8I\377w8I\377w8I\377"
    "w8I\377w8I\377w8I\377w8I\377w8I\377\341\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\341\13R\377\377\0""4\377\377\0\26\377\377\0\2\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\13l\377\377"
    "\0_\377\377\0N\377\377\0<\377\377\0/\377\377\0'\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\3\3\377"
    "\0\17\17\377\0\26\26\377\0\35\35\377\0$$\377\0**\377\0**\377\0**\377\0""0"
    "0\377\0""11\377\0""11\377\0""11\377\0""11\377\0""11\377\0""11\377\0""11\377"
    "\0""11\377\341\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\13R\377\377"
    "\0""4\377\377\0\26\377\377\0\2\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\341\13k\377\377\0_\377\377\0M\377\377\0"
    "<\377\377\0/\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\5\0\3\377\36\0\20\3772\0\32\377D\0#\377U\0,\377f\0""5\377f\0""5"
    "\377f\0""5\377u\0=\377w\0>\377w\0>\377w\0>\377w\0>\377w\0>\377w\0>\377w\0"
    ">\377w\0>\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\341\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\341\13R\377\377\0""4\377\377\0\26\377\377\0"
    "\2\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\341\13k\377\377\0_\377\377\0M\377\377\0<\377\377\0/\377\377\0'\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\11\0\5\377>\0\40\377}\0A\377\265\0^\377\337\0t\377\374\0\203\377\377"
    "\0\205\377\377\0\205\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0"
    "\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204"
    "\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\341\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\341\13R\377\377\0""4\377\377\0\26\377\377\0\2\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\13"
    "k\377\377\0_\377\377\0M\377\377\0<\377\377\0/\377\377\0'\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\3776\0\34\377\231\0P\377\363\0"
    "\177\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\203"
    "\377\377\0\202\377\377\0\202\377\377\0\202\377\377\0\201\377\377\0\201\377"
    "\377\0\201\377\377\0\200\377\377\0\200\377\377\0\200\377\377\0\200\377\377"
    "\0\200\377\377\0\200\377\377\0\200\377\377\0\200\377\377\0\200\377\377\0"
    "\200\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\341\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\341\13R\377\377\0""4\377\377\0\26\377\377\0\2\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\341\13k\377\377\0_\377\377\0M\377\377\0<\377\377\0/\377\377\0'\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\34\0\17\377\251\0X\377\377\0\204\377\377\0"
    "\204\377\377\0\203\377\377\0\202\377\377\0\200\377\377\0\177\377\377\0~\377"
    "\377\0|\377\377\0z\377\377\0y\377\377\0x\377\377\0w\377\377\0v\377\377\0"
    "u\377\377\0u\377\377\0t\377\377\0t\377\377\0s\377\377\0s\377\377\0s\377\377"
    "\0s\377\377\0s\377\377\0s\377\377\0s\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\341\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\13R\377\377"
    "\0""4\377\377\0\26\377\377\0\2\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\341\13k\377\377\0_\377\377\0M\377\377\0"
    "<\377\377\0/\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377>\0\40\377\357\1}"
    "\377\377\0\204\377\377\0\202\377\377\0\177\377\377\0|\377\377\0y\377\377"
    "\0s\377\377\0n\377\377\0i\377\377\0d\377\377\0a\377\377\0^\377\377\0\\\377"
    "\377\0Z\377\377\0Y\377\377\0W\377\377\0W\377\377\0W\377\377\0V\377\377\0"
    "V\377\377\0V\377\377\0V\377\377\0V\377\377\0V\377\377\0V\377\377\0V\377\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\341\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\341\13R\377\377\0""4\377\377\0\26\377\377\0\2\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\13k\377"
    "\377\0_\377\377\0M\377\377\0<\377\377\0/\377\377\0'\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "E\0$\377\366\1\200\377\377\0\202\377\377\0\177\377\377\0y\377\377\0q\377"
    "\377\0h\377\377\0^\377\377\0V\377\377\0N\377\377\0G\377\377\0B\377\377\0"
    ">\377\377\0;\377\377\0:\377\377\0""8\377\377\0""7\377\377\0""6\377\377\0"
    """5\377\377\0""5\377\377\0""4\377\377\0""4\377\377\0""4\377\377\0""4\377"
    "\377\0""4\377\377\0""4\377\377\0""4\377\377\0""4\377\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\341\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341"
    "\13R\377\377\0""4\377\377\0\26\377\377\0\2\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\13k\377\377\0_\377\377\0"
    "M\377\377\0<\377\377\0/\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\0\0\0\377\0\0\0\377\0\0\0\377\34\0\17\377\360\2~\377\377"
    "\0\201\377\377\0{\377\377\0q\377\377\0b\377\377\0S\377\377\0F\377\377\0<"
    "\377\377\0""4\377\377\0/\377\377\0*\377\377\0(\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\331\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\331\16S\377\377\0""5\377\377\0\26\377\377\0\2\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\331"
    "\16k\377\377\0_\377\377\0M\377\377\0<\377\377\0/\377\377\0'\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\0\0\377\0\0\0\377\255"
    "\4^\377\377\0\200\377\377\0y\377\377\0i\377\377\0U\377\377\0A\377\377\0""4"
    "\377\377\0+\377\377\0(\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\322\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\322\20T\377\377\0""5\377\377\0"
    "\26\377\377\0\2\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\322\20j\377\377\0_\377\377\0M\377\377\0<\377\377\0/\377"
    "\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377"
    "\0\0\0\3771\0\31\377\376\0\200\377\377\0y\377\377\0g\377\377\0M\377\377\0"
    """7\377\377\0+\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\322\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\322\20"
    "T\377\377\0""5\377\377\0\27\377\377\0\3\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\322\20k\377\377\0_\377\377\0M"
    "\377\377\0<\377\377\0/\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\0\0\0\377\0\0\0\377\233\10W\377\377\0{\377\377\0i\377\377"
    "\0L\377\377\0""4\377\377\0)\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\322\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\322\17S\377\377\0""6\377\377\0\27\377\377\0\3\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\322\17"
    "j\377\377\0_\377\377\0N\377\377\0<\377\377\0/\377\377\0'\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\5\0\3\377\357\4{\377\377"
    "\0q\377\377\0U\377\377\0""6\377\377\0)\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\322\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\322\17S\377\377\0""6\377\377\0\27\377"
    "\377\0\3\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\322\17j\377\377\0_\377\377\0N\377\377\0<\377\377\0/\377\377"
    "\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377>\2"
    "\"\377\377\0y\377\377\0b\377\377\0A\377\377\0+\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\322\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\322\17S\377"
    "\377\0""6\377\377\0\30\377\377\0\3\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\322\17j\377\377\0_\377\377\0N\377\377"
    "\0<\377\377\0/\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\0\0\0\377v\16I\377\377\0r\377\377\0T\377\377\0""4\377\377\0'\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\322\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\322\17S\377\377\0""6\377\377\0\30\377\377\0\3\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\322\17j\377\377"
    "\0_\377\377\0N\377\377\0<\377\377\0/\377\377\0'\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\0\0\0\377\251\21c\377\377\0h\377\377\0F\377"
    "\377\0+\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\304\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\304\24T\377\377\0""6\377\377\0\30\377\377"
    "\0\4\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\304\24i\377\377\0`\377\377\0N\377\377\0=\377\377\0/\377\377\0'\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\332\12q\377"
    "\377\0_\377\377\0<\377\377\0(\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\303\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\303\24S\377\377\0"
    """7\377\377\0\31\377\377\0\4\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\303\24h\377\377\0`\377\377\0N\377\377\0"
    "=\377\377\0/\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\4\0\2\377\373\1s\377\377\0W\377\377\0""5\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\271\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\271\26S\377\377\0""8\377\377\0\31\377\377\0\4\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\271\26g\377\377"
    "\0`\377\377\0N\377\377\0=\377\377\0/\377\377\0'\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\37\2\21\377\377\0o\377\377\0O\377\377\0/\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\264\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\264\30S\377\377\0""9\377\377\0\32\377\377"
    "\0\4\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\264\30f\377\377\0`\377\377\0O\377\377\0=\377\377\0/\377\377\0'\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\3779\12&\377\377\0i\377\377"
    "\0H\377\377\0+\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\256\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\256\30R\377\377\0:\377\377"
    "\0\33\377\377\0\5\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\256\30d\377\377\0`\377\377\0O\377\377\0>\377\377\0/"
    "\377\377\0(\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377O\20""6"
    "\377\377\0e\377\377\0B\377\377\0(\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\245\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\245\32"
    "R\377\377\0:\377\377\0\34\377\377\0\5\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\245\32b\377\377\0a\377\377\0O\377"
    "\377\0>\377\377\0/\377\377\0(\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377_\25B\377\377\0a\377\377\0>\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\243\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\243\32R\377\377\0;\377\377\0\35\377\377\0\6\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\243\32b\377\377"
    "\0a\377\377\0P\377\377\0>\377\377\0/\377\377\0(\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377o\26K\377\377\0]\377\377\0;\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\226\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\226\34O\377\377\0<\377\377\0\35\377\377\0\6\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\226\34^\377\377\0a\377\377\0P\377\377\0?\377\377\0""0\377\377\0(\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\177\27S\377\377\0[\377"
    "\377\0""9\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\217\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\217\35N\377\377"
    "\0=\377\377\0\36\377\377\0\7\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\217\35\\\377\377\0b\377\377\0Q\377\377\0"
    "?\377\377\0""0\377\377\0(\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\207\30V\377\377\0Y\377\377\0""7\377\377\0&\377\377\0&\377\377\0&"
    "\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\200\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\200\37L\377\377\0>\377\377\0\37\377\377\0\7\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\200\37W\377"
    "\377\0b\377\377\0Q\377\377\0@\377\377\0""1\377\377\0(\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\222\30Z\377\377\0W\377\377\0""5\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0r\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377r!I\377\377\0?\377\377\0!\377\377\0\10"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377r!T\377\377\0b\377\377\0Q\377\377\0@\377\377\0""1\377\377\0)\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\226\31]\377\377\0U\377"
    "\377\0""4\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0c\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377c\40C\377\377\0A\377"
    "\377\0\"\377\377\0\11\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377c\40L\377\377\0c\377\377\0Q\377\377\0@\377\377\0"
    """2\377\377\0)\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\242"
    "\27`\377\377\0T\377\377\0""3\377\377\0&\377\377\0&\377\377\0&\377\377\0&"
    "\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0U\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "U\37=\377\377\0B\377\377\0$\377\377\0\12\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377U\37E\377\377\0c\377\377\0R\377"
    "\377\0A\377\377\0""2\377\377\0)\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\245\30b\377\377\0R\377\377\0""2\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0F\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377F\36""8\377\377\0D\377\377\0%\377\377\0\13\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377F\36=\377\377"
    "\0d\377\377\0S\377\377\0B\377\377\0""2\377\377\0)\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\245\30`\377\377\0Q\377\377\0""1\377\377\0&"
    "\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0""8\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\3778\33""0\377\377\0E\377\377\0'\377\377\0\14"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\3778\33""4\377\377\0d\377\377\0T\377\377\0B\377\377\0""3\377\377\0)\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\245\30`\377\377\0P\377"
    "\377\0""0\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0&\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377&\31'\377\377\0G\377"
    "\377\0(\377\377\0\15\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377&\31*\377\377\0e\377\377\0U\377\377\0C\377\377\0"
    """4\377\377\0)\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\245"
    "\30`\377\377\0P\377\377\0/\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\16\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\16\26"
    "\33\377\377\0I\377\377\0+\377\377\0\16\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\16\26\34\377\377\0f\377\377\0"
    "V\377\377\0D\377\377\0""4\377\377\0)\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\245\30`\377\377\0O\377\377\0/\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\367\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\0\20\20\377\367\3L\377\377\0-\377\377\0\20\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\20\20"
    "\377\367\3g\377\377\0W\377\377\0E\377\377\0""5\377\377\0*\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\245\30`\377\377\0O\377\377\0/\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\377\334\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\0\6\6\377\334\16P\377\377\0/\377"
    "\377\0\22\377\377\0\1\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\0\6\6\377\334\16h\377\377\0W\377\377\0E\377\377\0""5\377\377"
    "\0*\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\245\31`\377"
    "\377\0M\377\377\0/\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\377\277\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\277"
    "\32U\377\377\0""2\377\377\0\24\377\377\0\2\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\277\32h\377\377\0X\377\377\0G"
    "\377\377\0""6\377\377\0+\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\245\30_\377\377\0M\377\377\0/\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\237\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377\237\"U\377\377\0""6\377\377\0\27\377\377\0\3\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\237\"c\377"
    "\377\0Z\377\377\0H\377\377\0""8\377\377\0,\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\245\30_\377\377\0N\377\377\0/\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377|\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\0\0\0\377|)R\377\377\0:\377\377\0\33\377\377\0\5"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377"
    "|)]\377\377\0[\377\377\0J\377\377\0""9\377\377\0,\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\245\30`\377\377\0O\377\377\0/\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377U\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\0\0\0\377U+H\377\377\0=\377\377\0\37\377\377\0\7"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377"
    "U+O\377\377\0\\\377\377\0K\377\377\0:\377\377\0-\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\245\30`\377\377\0O\377\377\0/\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377,\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\0\0\0\377,*:\377\377\0A\377\377\0#\377\377\0\12"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377"
    ",*=\377\377\0^\377\377\0L\377\377\0;\377\377\0/\377\377\0'\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\245\30`\377\377\0O\377\377\0/\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\5\0\0"
    "\377\370\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\0\0\0\377\5\"$\377\370\3G\377\377\0(\377\377"
    "\0\14\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0"
    "\0\377\5\"$\377\370\3`\377\377\0N\377\377\0=\377\377\0/\377\377\0(\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\233\33^\377\377\0O\377\377\0/\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\377\0\0\0\377\312\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\22\22\377\312\26Q\377\377"
    "\0-\377\377\0\20\377\377\0\1\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377\0\22\22\377\312\26d\377\377\0Q\377\377\0?\377\377\0""1"
    "\377\377\0)\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\226\32[\377\377\0"
    "O\377\377\0/\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\377\0\0\0\377\224\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\2\2\377"
    "\224+Y\377\377\0""3\377\377\0\25\377\377\0\3\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\0\0\0\377\0\2\2\377\224+d\377\377\0S\377\377\0A"
    "\377\377\0""2\377\377\0)\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\212"
    "\34Y\377\377\0P\377\377\0""0\377\377\0&\377\377\0&\377\377\0&\377\377\0&"
    "\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377W\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0"
    "\0\377\0\0\0\377W7T\377\377\0""9\377\377\0\32\377\377\0\5\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377W7Z\377\377\0V\377"
    "\377\0D\377\377\0""4\377\377\0*\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\207\33V\377\377\0Q\377\377\0""0\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\25\0\0\377\376\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\0\0\0\377\0\0\0\377\25""8?\377\376\0?\377\377\0!\377\377\0\10\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\25""8A\377"
    "\376\0X\377\377\0F\377\377\0""6\377\377\0+\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377v\36R\377\377\0Q\377\377\0""1\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\313"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377\0\0\0\377\0$$\377\313\25N\377\377\0(\377\377\0\15\377"
    "\377\0\1\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0$$"
    "\377\313\25]\377\377\0J\377\377\0""9\377\377\0-\377\377\0'\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377f\35K\377\377\0S\377\377\0""2\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377"
    "w\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377\0\0\0\377\0\11\11\377w8\\\377\377\0""1\377\377\0\24\377"
    "\377\0\3\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\11"
    "\11\377w8d\377\377\0M\377\377\0<\377\377\0/\377\377\0(\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377V\34C\377\377\0T\377\377\0""3\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377!\0"
    "\0\377\375\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377!IT\377\375\1;\377\377\0\34\377\377\0"
    "\7\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "!IV\377\375\1Q\377\377\0@\377\377\0""1\377\377\0)\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377E\32""9\377\377\0V\377\377\0""4\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\270\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0""11\377\270\35N\377\377\0&\377\377\0\14"
    "\377\377\0\1\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    """11\377\270\35Z\377\377\0C\377\377\0""4\377\377\0*\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377(\30*\377\377\0W\377\377\0""6\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377M\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\16\16\377MIa\377\377\0""1\377\377\0\25\377"
    "\377\0\4\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\16\16"
    "\377MId\377\377\0H\377\377\0""8\377\377\0,\377\377\0'\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\12\17\24\377\377\0Z\377\377\0""8\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\1\0\0\377\315\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\1LL\377\315\25F\377\377\0\40\377\377"
    "\0\11\377\377\0\1\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\1LL\377\315\25R\377\377\0<\377\377\0/\377\377\0)\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0"
    "\4\4\377\352\11]\377\377\0:\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "F\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\40\40\377FL`\377\377\0-\377\377\0\22\377\377\0"
    "\4\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\40\40\377FL"
    "c\377\377\0A\377\377\0""3\377\377\0)\377\377\0'\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\275"
    "\31`\377\377\0<\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\247\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0TT\377\247$L\377\377\0\40\377\377\0\13\377\377"
    "\0\2\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0TT\377\247$R"
    "\377\377\0""7\377\377\0,\377\377\0(\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\213#Y\377\377"
    "\0@\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\25\0\0\377\343"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\35\35\377\25`f\377\343\14""8\377\377\0\26\377\377\0\7\377\377"
    "\0\1\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\35\35\377\25`f\377\343\14"
    "B\377\377\0""0\377\377\0)\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377V&I\377\377\0E\377\377\0"
    ")\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\3778\0\0\377\371\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0EE\3778Ra\377\371\2)\377\377\0\21\377\377\0\5\377\377\0\1\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0EE\3778Ra\377\371\2""6\377\377\0,\377\377"
    "\0(\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\0\0\0\377\22!)\377\374\1L\377\377\0.\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377N\0\0\377\371\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\11\11\377\0]]\377NI\\\377"
    "\371\2$\377\377\0\16\377\377\0\4\377\377\0\1\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\11\11\377\0]]\377NI[\377\371\2""1\377\377\0)\377\377\0'\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\7\7\377\272"
    "\34Y\377\377\0""3\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&"
    "\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377M\0\0\377\363\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\27\27\377\0gg\377MI[\377\363\5$\377\377"
    "\0\17\377\377\0\5\377\377\0\1\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\27\27\377\0gg\377"
    "MIZ\377\363\5""1\377\377\0)\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\0\0\0\377\0\0\0\377V3R\377\377\0:\377\377\0'\377\377\0&"
    "\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377/\0\0\377"
    "\332\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\40"
    "\40\377\0gg\377/Va\377\332\17.\377\377\0\22\377\377\0\7\377\377\0\3\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\40\40\377\0gg\377/V`\377\332\17""5\377\377\0)\377\377"
    "\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\0\0\377\3#$\377"
    "\323\22I\377\377\0)\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\12\0\0\377\217\0\0\377\373\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\40\40\377\0dd\377\12eg\377\217.F\377"
    "\373\2\33\377\377\0\14\377\377\0\5\377\377\0\2\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\40\40\377\0dd\377"
    "\12eg\377\217.G\377\373\2*\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0"
    "\377\0\0\0\377\0\1\1\377<CV\377\374\1""0\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    ")\0\0\377\254\0\0\377\375\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\23\23\377"
    "\0ZZ\377\0ii\377)X`\377\254\":\377\375\1\27\377\377\0\14\377\377\0\6\377"
    "\377\0\2\377\377\0\1\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\23\23\377\0ZZ\377\0ii\377)X_\377\254\">\377\375\1(\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\0\0\0\377\0\0\0\377\0\0\0\377\0\31\31\377u8T\377\377\0)\377\377\0&"
    "\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377$\0\0\377\220\0\0\377\352\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\4\4\377\0;;\377\0gg\377\0ii\377$Za\377\220.B\377\352\11\40\377"
    "\377\0\20\377\377\0\12\377\377\0\5\377\377\0\2\377\377\0\1\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\4\4\377\0;;\377\0gg\377\0ii\377$Z`\377\220.E\377\352\11"
    "-\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0""00\377t9P\377\374\1)\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\3\0\0\377F\0\0\377\223\0\0\377\330"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\21\21\377\0GG\377\0hh\377\0ii\377\3hi\377FLX\377\223,@\377\330\20"
    "%\377\377\0\22\377\377\0\15\377\377\0\11\377\377\0\6\377\377\0\4\377\377"
    "\0\2\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\21\21\377\0GG\377\0hh\377\0ii\377\3hh\377FLW\377\223,B\377\330\20"
    """0\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0""00\377?NZ\377\325\21""2\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\34\0\0\377R\0\0\377\210"
    "\0\0\377\267\0\0\377\337\0\0\377\376\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\17\17\377"
    "\0;;\377\0``\377\0ii\377\0ii\377\0ii\377\34]b\377RGT\377\2101C\377\267\36"
    """2\377\337\15!\377\376\0\23\377\377\0\20\377\377\0\15\377\377\0\13\377\377"
    "\0\11\377\377\0\10\377\377\0\6\377\377\0\5\377\377\0\4\377\377\0\3\377\377"
    "\0\2\377\377\0\1\377\377\0\1\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\17\17\377\0;;\377\0``"
    "\377\0ii\377\0ii\377\0ii\377\34]a\377RGT\377\2101E\377\267\36""9\377\337"
    "\15.\377\376\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\32\32\377\3WX\377TFT\377"
    "\265\36""9\377\374\1'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\11\0\0\377*\0\0\377I\0\0"
    "\377e\0\0\377\177\0\0\377\223\0\0\377\247\0\0\377\273\0\0\377\313\0\0\377"
    "\331\0\0\377\342\0\0\377\356\0\0\377\356\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\1\1\377\0\35\35\377\0==\377\0YY\377\0ii\377\0ii\377\0ii"
    "\377\0ii\377\0ii\377\11eg\377*X_\377IKW\377e?N\377\1775F\377\223,>\377\247"
    "$7\377\273\34""0\377\313\25)\377\331\20$\377\342\14\37\377\356\7\33\377\356"
    "\7\31\377\377\0\22\377\377\0\22\377\377\0\22\377\377\0\21\377\377\0\21\377"
    "\377\0\21\377\377\0\21\377\377\0\21\377\377\0\21\377\377\0\21\377\377\0\21"
    "\377\377\0\21\377\377\0\21\377\377\0\21\377\377\0\21\377\377\0\21\377\377"
    "\0\21\377\377\0\21\377\377\0\21\377\377\0\21\377\377\0\21\377\377\0\21\377"
    "\377\0\21\377\377\0\21\377\377\0\21\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\1\1\377"
    "\0\35\35\377\0==\377\0YY\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\11e"
    "f\377*X^\377IKV\377e?N\377\1775H\377\223,B\377\247$=\377\273\34""8\377\313"
    "\25""3\377\331\20""0\377\342\14.\377\356\7*\377\356\7*\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\1\1\377\0##\377\0KK\377\26_c\377"
    "YDR\377\222-C\377\300\32""7\377\343\14.\377\375\1'\377\377\0&\377\377\0&"
    "\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\21\0\0\377\21\0\0\377\21\0"
    "\0\377\21\0\0\377\21\0\0\377\21\0\0\377\21\0\0\377\21\0\0\377\21\0\0\377"
    "\21\0\0\377\21\0\0\377\21\0\0\377\21\0\0\377\21\0\0\377\21\0\0\377\21\0\0"
    "\377\21\0\0\377\21\0\0\377\21\0\0\377\21\0\0\377\21\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\14\14\377\0\"\"\377"
    "\0""88\377\0KK\377\0\\\\\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii"
    "\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii"
    "\377\0ii\377\0ii\377\21be\377\21be\377\21be\377\21be\377\21be\377\21be\377"
    "\21be\377\21be\377\21be\377\21be\377\21be\377\21be\377\21be\377\21be\377"
    "\21be\377\21be\377\21be\377\21be\377\21be\377\21be\377\21be\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\14\14\377\0\""
    "\"\377\0""88\377\0KK\377\0\\\\\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377"
    "\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377"
    "\0ii\377\0ii\377\0ii\377\21be\377\21be\377\21be\377\21be\377\21be\377\21"
    "be\377\21be\377\21be\377\21be\377\21be\377\21be\377\21be\377\21be\377\21"
    "be\377\21be\377\21be\377\21be\377\21be\377\21be\377\21be\377\21be\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\11\11\377\0%%\377\0<<\377\0OO\377\0]]\377\7ef"
    "\377$Z_\3776S[\377FLV\377WER\377f?N\377f?N\377f?N\377t9J\377w8J\377w8J\377"
    "w8J\377w8J\377w8J\377w8J\377w8J\377w8J\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\4\4\377\0\21\21\377\0\36\36\377"
    "\0**\377\0""44\377\0==\377\0EE\377\0MM\377\0TT\377\0YY\377\0]]\377\0bb\377"
    "\0bb\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377"
    "\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377"
    "\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\4\4\377\0\21\21\377\0\36\36\377\0**"
    "\377\0""44\377\0==\377\0EE\377\0MM\377\0TT\377\0YY\377\0]]\377\0bb\377\0"
    "bb\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0"
    "ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0"
    "ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0ii\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\3"
    "\3\377\0\17\17\377\0\26\26\377\0\35\35\377\0$$\377\0**\377\0**\377\0**\377"
    "\0""00\377\0""11\377\0""11\377\0""11\377\0""11\377\0""11\377\0""11\377\0"
    """11\377\0""11\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";

// Half a high texture pixel in texture coordinate space [0, 1].
const float hh = 1.0f / 512.0f;

// High resolution shape texture.
ShapeTextureData shapeTextureHigh __attribute__((aligned(16))) = {
    shapeTextureHighData, 256, 128, 4, 32.0f, 64.0f, 18.0f,
    {
        {  // Medium raw coords.
            { hh, 0.0f }, { 0.25f-hh, 0.0f }, { 0.25f-hh, 0.0f }, { hh, 0.0f },
            { hh, 0.5f }, { 0.25f-hh, 0.5f }, { 0.25f-hh, 0.5f }, { hh, 0.5f },
            { hh, 0.5f }, { 0.25f-hh, 0.5f }, { 0.25f-hh, 0.5f }, { hh, 0.5f },
            { hh, 1.0f }, { 0.25f-hh, 1.0f }, { 0.25f-hh, 1.0f }, { hh, 1.0f }
        }, {  // Medium idle coords.
            { 0.25f+hh, 0.0f }, { 0.5f-hh, 0.0f }, { 0.5f-hh, 0.0f }, { 0.25f+hh, 0.0f },
            { 0.25f+hh, 0.5f }, { 0.5f-hh, 0.5f }, { 0.5f-hh, 0.5f }, { 0.25f+hh, 0.5f },
            { 0.25f+hh, 0.5f }, { 0.5f-hh, 0.5f }, { 0.5f-hh, 0.5f }, { 0.25f+hh, 0.5f },
            { 0.25f+hh, 1.0f }, { 0.5f-hh, 1.0f }, { 0.5f-hh, 1.0f }, { 0.25f+hh, 1.0f }
        }, {  // Medium pressed coords.
            { 0.5f+hh, 0.0f }, { 0.75f-hh, 0.0f }, { 0.75f-hh, 0.0f }, { 0.5f+hh, 0.0f },
            { 0.5f+hh, 0.5f }, { 0.75f-hh, 0.5f }, { 0.75f-hh, 0.5f }, { 0.5f+hh, 0.5f },
            { 0.5f+hh, 0.5f }, { 0.75f-hh, 0.5f }, { 0.75f-hh, 0.5f }, { 0.5f+hh, 0.5f },
            { 0.5f+hh, 1.0f }, { 0.75f-hh, 1.0f }, { 0.75f-hh, 1.0f }, { 0.5f+hh, 1.0f }
        }, {  // Small raw coords.
            { 0.75f+hh, 0.0f+hh }, { 0.875f-hh, 0.0f+hh }, { 0.875f-hh, 0.0f+hh }, { 0.75f+hh, 0.0f+hh },
            { 0.75f+hh, 0.25f-hh }, { 0.875f-hh, 0.25f-hh }, { 0.875f-hh, 0.25f-hh }, { 0.75f+hh, 0.25f-hh },
            { 0.75f+hh, 0.25f+hh }, { 0.875f-hh, 0.25f+hh }, { 0.875f-hh, 0.25f+hh }, { 0.75f+hh, 0.25f+hh },
            { 0.75f+hh, 0.5f-hh }, { 0.875f-hh, 0.5f-hh }, { 0.875f-hh, 0.5f-hh }, { 0.75f+hh, 0.5f-hh }
        }, {  // Small idle coords.
            { 0.875f+hh, 0.0f+hh }, { 1.0f-hh, 0.0f+hh }, { 1.0f-hh, 0.0f+hh }, { 0.875f+hh, 0.0f+hh },
            { 0.875f+hh, 0.25f-hh }, { 1.0f-hh, 0.25f-hh }, { 1.0f-hh, 0.25f-hh }, { 0.875f+hh, 0.25f-hh },
            { 0.875f+hh, 0.25f+hh }, { 1.0f-hh, 0.25f+hh }, { 1.0f-hh, 0.25f+hh }, { 0.875f+hh, 0.25f+hh },
            { 0.875f+hh, 0.5f-hh }, { 1.0f-hh, 0.5f-hh }, { 1.0f-hh, 0.5f-hh }, { 0.875f+hh, 0.5f-hh }
        }, {  // Small pressed coords.
            { 0.75f+hh, 0.5f+hh }, { 0.875f-hh, 0.5f+hh }, { 0.875f-hh, 0.5f+hh }, { 0.75f+hh, 0.5f+hh },
            { 0.75f+hh, 0.75f-hh }, { 0.875f-hh, 0.75f-hh }, { 0.875f-hh, 0.75f-hh }, { 0.75f+hh, 0.75f-hh },
            { 0.75f+hh, 0.75f+hh }, { 0.875f-hh, 0.75f+hh }, { 0.875f-hh, 0.75f+hh }, { 0.75f+hh, 0.75f+hh },
            { 0.75f+hh, 1.0f-hh }, { 0.875f-hh, 1.0f-hh }, { 0.875f-hh, 1.0f-hh }, { 0.75f+hh, 1.0f-hh }
        }
    }
};

static const unsigned char shapeTextureLowData[128 * 64 * 4 + 1] =
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\3\0\0\377.\0\0\377]\0\0\377\203\0\0\377\242"
    "\0\0\377\273\0\0\377\317\0\0\377\340\0\0\377\353\0\0\377\362\0\0\377\366"
    "\0\0\377\374\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\3\0\1\377.\0\23\377]\0'\377\203\0""7\377\242\0C"
    "\377\273\0M\377\317\0U\377\340\0[\377\353\0`\377\362\0b\377\366\0d\377\374"
    "\0f\377\377\0g\377\377\0g\377\377\0g\377\377\0g\377\377\0g\377\377\0g\377"
    "\377\0g\377\377\0g\377\377\0g\377\377\0g\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\3"
    "\0\1\377.\0\30\377]\0""0\377\203\0D\377\242\0T\377\273\0a\377\317\0l\377"
    "\340\0u\377\353\0z\377\362\0~\377\366\0\200\377\374\0\203\377\377\0\204\377"
    "\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\377"
    "\0\204\377\377\0\204\377\377\0\204\377\377\0\204\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\21\0\0\377L\0\0\377x\0\0\377\223\0\0\377\245"
    "\0\0\377\262\0\0\377\266\0\0\377\273\0\0\377\273\0\0\377\273\0\0\377\273"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\21\0\7\377L\0"
    "\40\377x\0""1\377\223\0;\377\245\0A\377\262\0E\377\266\0F\377\273\0G\377"
    "\273\0G\377\273\0G\377\273\0G\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\6\0\0\377V\0\0\377\255\0\0\377\360\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\6\0\2\377V\0$\377\255\0H\377\360\0a\377"
    "\377\0c\377\377\0^\377\377\0X\377\377\0S\377\377\0N\377\377\0J\377\377\0"
    "G\377\377\0D\377\377\0B\377\377\0A\377\377\0?\377\377\0?\377\377\0?\377\377"
    "\0?\377\377\0?\377\377\0?\377\377\0?\377\377\0?\377\377\0?\377\377\0?\377"
    "\377\0?\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\6\0\3\377V\0-\377\255\0Z\377\360\0}\377\377\0\204\377\377\0\204"
    "\377\377\0\204\377\377\0\203\377\377\0\203\377\377\0\203\377\377\0\203\377"
    "\377\0\203\377\377\0\203\377\377\0\203\377\377\0\203\377\377\0\203\377\377"
    "\0\203\377\377\0\203\377\377\0\203\377\377\0\203\377\377\0\203\377\377\0"
    "\203\377\377\0\203\377\377\0\203\377\377\0\203\377\0\0\0\377\0\0\0\377\0"
    "\0\0\3771\0\0\377\263\0\0\377\374\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\3771\0\24\377\263\0D\377\374\0"
    "N\377\377\0""9\377\377\0$\377\377\0\32\377\377\0\26\377\377\0\24\377\377"
    "\0\23\377\377\0\22\377\377\0\22\377\377\0\22\377\377\0\22\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\1\0\0\377d\0\0\377\344\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\1\0\0\377d\0*\377\344\0\\"
    "\377\377\0^\377\377\0R\377\377\0D\377\377\0""6\377\377\0+\377\377\0\"\377"
    "\377\0\33\377\377\0\26\377\377\0\22\377\377\0\17\377\377\0\15\377\377\0\13"
    "\377\377\0\12\377\377\0\11\377\377\0\11\377\377\0\11\377\377\0\11\377\377"
    "\0\11\377\377\0\11\377\377\0\11\377\377\0\11\377\377\0\11\377\377\0\11\377"
    "\377\0\11\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\1\0\0\377"
    "d\0""4\377\344\0v\377\377\0\204\377\377\0\203\377\377\0\203\377\377\0\201"
    "\377\377\0\200\377\377\0\200\377\377\0\177\377\377\0~\377\377\0}\377\377"
    "\0|\377\377\0|\377\377\0|\377\377\0|\377\377\0|\377\377\0|\377\377\0|\377"
    "\377\0|\377\377\0|\377\377\0|\377\377\0|\377\377\0|\377\377\0|\377\377\0"
    "|\377\377\0|\377\0\0\0\377\0\0\0\377^\0\0\377\373\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0"
    "\377^\0&\377\373\0F\377\377\0\26\377\377\0\2\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\20\0\0\377"
    "\267\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\20\0\7\377\267\0J\377\377\0]\377\377\0G\377\377\0/\377\377\0\33\377"
    "\377\0\16\377\377\0\6\377\377\0\2\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\20\0\10\377\267\0_\377\377\0\203\377\377\0\202\377\377\0"
    "\201\377\377\0~\377\377\0|\377\377\0x\377\377\0u\377\377\0r\377\377\0o\377"
    "\377\0l\377\377\0j\377\377\0h\377\377\0g\377\377\0f\377\377\0e\377\377\0"
    "e\377\377\0d\377\377\0d\377\377\0d\377\377\0d\377\377\0d\377\377\0d\377\377"
    "\0d\377\377\0d\377\377\0d\377\377\0d\377\0\0\0\3772\0\0\377\373\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\3772\1\25\377\373\0<\377\377\0\4\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\13\0\0\377\312\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\13\0\4\377\312\0Q\377\377\0R\377\377\0""0\377\377\0"
    "\24\377\377\0\5\377\377\0\1\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\13\0\6\377\312\0i\377\377\0\203\377"
    "\377\0\200\377\377\0|\377\377\0v\377\377\0o\377\377\0g\377\377\0`\377\377"
    "\0Y\377\377\0T\377\377\0P\377\377\0M\377\377\0I\377\377\0H\377\377\0F\377"
    "\377\0D\377\377\0C\377\377\0B\377\377\0B\377\377\0B\377\377\0B\377\377\0"
    "B\377\377\0B\377\377\0B\377\377\0B\377\377\0B\377\377\0B\377\377\0B\377\0"
    "\0\0\377\262\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\262\2""9\377\377\0"
    "\11\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\241\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\241\0"
    "@\377\377\0N\377\377\0%\377\377\0\10\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\241\0S\377\377\0\202\377\377\0}\377\377\0u\377\377\0j\377\377"
    "\0]\377\377\0P\377\377\0F\377\377\0?\377\377\0""9\377\377\0""4\377\377\0"
    """1\377\377\0/\377\377\0-\377\377\0,\377\377\0+\377\377\0+\377\377\0*\377"
    "\377\0)\377\377\0)\377\377\0)\377\377\0)\377\377\0)\377\377\0)\377\377\0"
    ")\377\377\0)\377\377\0)\377\377\0)\377\377\0)\377\20\0\0\377\373\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\20\0\7\377\373\1/\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0"
    "\0\377\0\0\0\377@\0\0\377\376\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\0\0\0\377\0\0\0\377@\0\32\377\376\0U\377\377\0'\377\377\0\6"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377@\0!\377\376\0\201\377\377"
    "\0{\377\377\0p\377\377\0^\377\377\0L\377\377\0=\377\377\0""3\377\377\0,\377"
    "\377\0(\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377G\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377G\7\"\377\377\0\25"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\275\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\275"
    "\0F\377\377\0""7\377\377\0\12\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0"
    "\0\377\0\0\0\377\275\0`\377\377\0|\377\377\0n\377\377\0X\377\377\0@\377\377"
    "\0""1\377\377\0*\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377v\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377v\2&\377\377\0\10\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0"
    "\0\377#\0\0\377\376\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\0\0\0\377#\0\16\377\376\0O\377\377\0\33\377\377\0\1\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377#\0\22\377\376\0~\377\377\0q\377"
    "\377\0Y\377\377\0>\377\377\0-\377\377\0'\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\225\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\225\3(\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377u\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377u\0,\377"
    "\377\0:\377\377\0\11\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\0\0\0\377u\0;\377\377\0x\377\377\0b\377\377\0C\377\377\0.\377\377\0'\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\253\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\253\11""1\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377\270\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\0\0\0\377\270\0?\377\377\0'\377\377\0\2\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\270\0Z\377\377"
    "\0n\377\377\0Q\377\377\0""3\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\273\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\273\13""4\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\1\0\0\377\356\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\1\0\0\377\356\2L\377\377\0\30\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\1\0\0\377\356\2s\377\377\0c\377\377\0B\377\377"
    "\0+\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\305\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\305\14""5\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\36\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\36\0\14\377\377\0"
    "D\377\377\0\16\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\36\0\17\377\377\0t\377\377\0X\377\377\0""7\377\377\0(\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\315\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\315\14""5\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377E\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377E\5\37\377\377\0""9\377\377\0\7\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377E\5'\377\377"
    "\0n\377\377\0N\377\377\0""0\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\322\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\322\14""3\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377e\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377e\5)\377\377\0""0\377\377\0\4\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377e\5""5\377\377\0g\377\377\0F\377\377"
    "\0,\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\322\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\322"
    "\14""3\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\200\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\200"
    "\0+\377\377\0(\377\377\0\2\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\200\0<\377\377\0a\377\377\0@\377\377\0)\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\322\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\322\14""3\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\226\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\226\1""1\377\377\0"
    "\"\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\226\1E\377\377\0]\377\377\0;\377\377\0'\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\322\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\322\14""3\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\245\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\245\6:\377\377\0\35\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\245"
    "\6P\377\377\0X\377\377\0""7\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\322\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\322\14""3\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\264\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\264\11?\377\377\0\32\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\264\11X\377\377"
    "\0T\377\377\0""4\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\322\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\322\14""3\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\302"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\302\12D\377\377\0\27\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\302\12^\377\377\0Q\377\377\0"
    """2\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\313\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\313\15""3\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\315\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\315\12F\377\377\0\25\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\315\12b\377\377\0N\377\377\0""0\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\303\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\303"
    "\15""4\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\324\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\324"
    "\13G\377\377\0\22\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\324\13d\377\377\0M\377\377\0/\377\377\0&\377\377\0&"
    "\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\266\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\266\16""3\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\332\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\332\12F\377\377"
    "\0\21\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\332\12e\377\377\0K\377\377\0.\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\246\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\246\15""0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\341\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\10F\377\377\0\20\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341"
    "\10f\377\377\0J\377\377\0-\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\214\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\214\11'\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\350\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\350\7E\377\377\0\16\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\350\7f\377\377\0H"
    "\377\377\0-\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377i\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377i\11#\377\377\0\2\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\350\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\350\7D\377\377\0\16\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\350\7f\377\377\0H\377\377\0,\377\377\0&"
    "\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\3778\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\3778\22$\377\377"
    "\0\14\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\350\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\350\7D\377\377\0"
    "\15\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\350\7f\377\377\0G\377\377\0+\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\4\0\0"
    "\377\355\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\4\12\13\377\355\7\36\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\355\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\355\5D\377\377\0\15\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\355\5f\377"
    "\377\0F\377\377\0+\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\212\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\0\0\0\377\212\32""0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\360"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\360\5C\377\377\0\14\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\360\5f\377\377\0E\377\377\0"
    "+\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\0\0\0\377\17\0\0\377\333\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\0\0\0\377\17\27\33\377\333\16\34\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\360\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\360\5C\377\377\0\14\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\360\5f\377\377\0E\377\377\0+\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\0\0\0\377\0\0\0\377\35\0\0\377\303\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377"
    "\35&,\377\303\30\"\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\360\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\360\5C\377\377\0\14\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\360"
    "\5e\377\377\0E\377\377\0+\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377B\0\0\377\232\0\0\377\324\0\0\377\367\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\34\34\377B4<\377\232)/\377"
    "\324\21\31\377\367\3\5\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\360\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\360\5C\377\377\0\14\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\360\5e\377\377\0E\377\377\0+\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\1\0\0\377\26\0\0\377'\0\0\3773\0\0\3776\0\0\377;\0\0\377;\0\0\377"
    ";\0\0\377;\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\13"
    "\13\377\0\"\"\377\1""11\377\26""49\377'4;\37734<\37764<\377;4=\377;4=\377"
    ";4=\377;4=\377\360\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\360\5C\377\377\0\14\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\360\5e\377\377"
    "\0D\377\377\0+\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\21\0\11\377L\0'\377x\0>\377\223\0M\377\245\0U\377\262"
    "\0\\\377\266\0^\377\273\0a\377\273\0a\377\273\0a\377\273\0a\377\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\360\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\360"
    "\5C\377\377\0\14\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\360\5e\377\377\0D\377\377\0+\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\0\0\0\377\0\0\0\377\0\0\0\3771\0\31\377\263\0]\377\374\0\202\377\377"
    "\0\201\377\377\0\200\377\377\0}\377\377\0|\377\377\0{\377\377\0z\377\377"
    "\0y\377\377\0y\377\377\0y\377\377\0y\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\360\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\360\5C\377\377\0\14\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\360\5e\377\377\0D\377\377\0+\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0"
    "\0\0\377^\0""1\377\373\0\200\377\377\0z\377\377\0n\377\377\0a\377\377\0U"
    "\377\377\0N\377\377\0J\377\377\0G\377\377\0F\377\377\0E\377\377\0E\377\377"
    "\0E\377\377\0E\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\356\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\356\6C\377\377\0\14\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\356\6e\377\377\0D\377\377"
    "\0+\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\0\0\0\3772\1\33\377\373\0~\377\377\0j\377"
    "\377\0J\377\377\0""5\377\377\0+\377\377\0'\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\350\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\350"
    "\10D\377\377\0\14\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\350\10d\377\377\0D\377\377\0+\377\377\0&\377\377\0&"
    "\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\0\0\0\377\262\2Z\377\377\0e\377\377\0""8\377\377\0'\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\350\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\350\7D\377\377\0\15\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\350"
    "\7d\377\377\0E\377\377\0+\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\20\0\11\377\373\1"
    "q\377\377\0=\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\350\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\350\7D\377\377\0\15\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\350\7d\377\377\0E\377\377\0+\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377G\7+\377\377\0]\377\377\0+\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\341\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\341\12E\377"
    "\377\0\16\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\341\12d\377\377\0E\377\377\0+\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "v\2""9\377\377\0I\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&"
    "\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\332\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\332\13E\377\377\0\16\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\332\13c\377"
    "\377\0E\377\377\0+\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\225\3C\377\377\0<\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\324\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\324\14F\377\377\0\20\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\324\14a\377\377\0F\377\377\0+\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\253\11O\377\377\0""3\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\315\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\315\15F\377"
    "\377\0\21\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\315\15`\377\377\0G\377\377\0+\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\273\13U\377\377\0""0\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\303\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\303\17E\377\377\0\22\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\303\17]"
    "\377\377\0H\377\377\0,\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\305\14X\377\377\0.\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\264\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\264\20C\377\377\0\25\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\264\20Y\377\377\0H\377\377\0-\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\315\14Y\377\377\0,\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\246\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\246\17>\377\377"
    "\0\27\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\246\17R\377\377\0J\377\377\0-\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\322\14"
    "Y\377\377\0+\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\227\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\227\15""8\377\377\0\32\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\227\15I\377\377"
    "\0K\377\377\0.\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\322\14X\377\377\0*\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\201\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\201\12""0\377\377\0\35\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\201\12>\377\377\0M\377\377\0/\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\322\14W\377\377\0*\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0f\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377f\13*\377\377\0!\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "f\13""5\377\377\0N\377\377\0""0\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\322\14V\377"
    "\377\0*\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0F\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377F\22)\377\377\0(\377\377\0\2\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377F\22""0\377\377\0Q\377\377\0""2\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\322\14W\377\377\0*\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\40\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\40\25"
    "\40\377\377\0""0\377\377\0\4\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\40\25#\377\377\0T\377\377\0""4\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\322\14W\377\377\0*\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\1\0\0\377\360\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\1\15\15\377\360\6;\377\377\0"
    "\7\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\1\15\15"
    "\377\360\6X\377\377\0""7\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\313\15U\377\377\0"
    "*\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\377\272\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\0\0\0\377\272\30F\377\377\0\15\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\272\30Y\377\377\0:\377\377"
    "\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\303\15T\377\377\0+\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377w\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377w\34<\377\377"
    "\0\27\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0"
    "\0\377w\34F\377\377\0?\377\377\0)\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\266\16P\377\377\0+\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377"
    "&\0\0\377\376\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377&\".\377\376\0'\377\377\0\2\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\0\0\0\377&\"0\377\376\0F\377\377\0,\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\246\15I\377\377\0,\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\300\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\17\17\377\300\31A"
    "\377\377\0\11\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377"
    "\0\17\17\377\300\31R\377\377\0""0\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\214\11;\377\377\0.\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377"
    "\0\0\0\377E\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\0\0\0\377\0\0\0\377E3D\377\377\0\32\377\377\0\1\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377E3H\377\377\0""7\377\377\0'\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "i\11""0\377\377\0""0\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\247\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\34\34\377\247$B\377"
    "\377\0\12\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\34"
    "\34\377\247$L\377\377\0+\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\3778\22(\377\377\0""5\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0"
    "\377\16\0\0\377\317\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\16?C\377\317\23.\377\377\0\6\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\16?C\377\317\23;\377\377\0'\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\4\12\14\377\355\7"
    "A\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\23\0\0\377\276\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\5\5\377\23MR\377\276\32""0\377\377"
    "\0\7\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\5\5\377\23MR\377\276"
    "\32;\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\0\0\0\377\212\32>\377\377\0'\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\2\0\0\377"
    "l\0\0\377\351\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377"
    "\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\10\10\377"
    "\2MN\377l<J\377\351\10\30\377\377\0\5\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\10"
    "\10\377\2MN\377l<N\377\351\10,\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\0\0\0\377\17\27\34\377\333\16""4\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\11\0\0\377_\0\0\377\265\0\0\377\365\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0"
    "\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\1\1\377\0,,\377\11\\^\377_BM\377\265\36,\377\365\4\17\377\377\0"
    "\5\377\377\0\2\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\1\1\377\0,,\377\11\\^\377_BP\377\265\36""9\377\365\4(\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377"
    "\0&\377\0\0\0\377\0\0\0\377\35&,\377\303\30""6\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\7\0\0\3776\0\0\377e\0"
    "\0\377\214\0\0\377\253\0\0\377\304\0\0\377\330\0\0\377\350\0\0\377\363\0"
    "\0\377\372\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0\0\377\377\0"
    "\0\377\377\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\3\3\377\0''\377\0KK\377\7bc\3776RZ\377e?I\377\214/:\377"
    "\253\"/\377\304\30%\377\330\20\34\377\350\11\25\377\363\4\17\377\372\1\13"
    "\377\377\0\11\377\377\0\10\377\377\0\10\377\377\0\10\377\377\0\10\377\377"
    "\0\10\377\377\0\10\377\377\0\10\377\377\0\10\377\377\0\10\377\377\0\10\377"
    "\377\0\10\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\3\3\377\0''\377\0KK\377\7bc\3776RZ\377e?N\377\214/D\377\253"
    "\"<\377\304\30""5\377\330\20""0\377\350\11+\377\363\4)\377\372\1'\377\377"
    "\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\34\34\377B4>\377\232)@\377\324\21""1\377\367\3(\377\377\0&\377"
    "\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0&\377\377\0"
    "&\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\4\0\0\377\10\0\0\377"
    "\10\0\0\377\10\0\0\377\10\0\0\377\10\0\0\377\10\0\0\377\10\0\0\377\10\0\0"
    "\377\10\0\0\377\10\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\3\3\377\0\26\26"
    "\377\0))\377\0""99\377\0FF\377\0PP\377\0YY\377\0__\377\0dd\377\0gg\377\0"
    "ii\377\4gh\377\10eg\377\10eg\377\10eg\377\10eg\377\10eg\377\10eg\377\10e"
    "g\377\10eg\377\10eg\377\10eg\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377"
    "\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\3\3\377\0"
    "\26\26\377\0))\377\0""99\377\0FF\377\0PP\377\0YY\377\0__\377\0dd\377\0gg"
    "\377\0ii\377\4gh\377\10eg\377\10eg\377\10eg\377\10eg\377\10eg\377\10eg\377"
    "\10eg\377\10eg\377\10eg\377\10eg\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\13\13\377\0\"\"\377\1""11\377\26""47\377'4:\37734<\3776"
    "4<\377;4=\377;4=\377;4=\377;4=\377\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0";

// Half a low texture pixel in texture coordinate space [0, 1].
const float hl = 1.0f / 256.0f;

// Low resolution shape texture.
ShapeTextureData shapeTextureLow __attribute__((aligned(16))) = {
    shapeTextureLowData, 128, 64, 4, 16.0f, 32.0f, 9.0f,
    {
        {  // Medium raw coords.
            { hl, 0.0f }, { 0.25f-hl, 0.0f }, { 0.25f-hl, 0.0f }, { hl, 0.0f },
            { hl, 0.5f }, { 0.25f-hl, 0.5f }, { 0.25f-hl, 0.5f }, { hl, 0.5f },
            { hl, 0.5f }, { 0.25f-hl, 0.5f }, { 0.25f-hl, 0.5f }, { hl, 0.5f },
            { hl, 1.0f }, { 0.25f-hl, 1.0f }, { 0.25f-hl, 1.0f }, { hl, 1.0f }
        }, {  // Medium idle coords.
            { 0.25f+hl, 0.0f }, { 0.5f-hl, 0.0f }, { 0.5f-hl, 0.0f }, { 0.25f+hl, 0.0f },
            { 0.25f+hl, 0.5f }, { 0.5f-hl, 0.5f }, { 0.5f-hl, 0.5f }, { 0.25f+hl, 0.5f },
            { 0.25f+hl, 0.5f }, { 0.5f-hl, 0.5f }, { 0.5f-hl, 0.5f }, { 0.25f+hl, 0.5f },
            { 0.25f+hl, 1.0f }, { 0.5f-hl, 1.0f }, { 0.5f-hl, 1.0f }, { 0.25f+hl, 1.0f }
        }, {  // Medium pressed coords.
            { 0.5f+hl, 0.0f }, { 0.75f-hl, 0.0f }, { 0.75f-hl, 0.0f }, { 0.5f+hl, 0.0f },
            { 0.5f+hl, 0.5f }, { 0.75f-hl, 0.5f }, { 0.75f-hl, 0.5f }, { 0.5f+hl, 0.5f },
            { 0.5f+hl, 0.5f }, { 0.75f-hl, 0.5f }, { 0.75f-hl, 0.5f }, { 0.5f+hl, 0.5f },
            { 0.5f+hl, 1.0f }, { 0.75f-hl, 1.0f }, { 0.75f-hl, 1.0f }, { 0.5f+hl, 1.0f }
        }, {  // Small raw coords.
            { 0.75f+hl, 0.0f+hl }, { 0.875f-hl, 0.0f+hl }, { 0.875f-hl, 0.0f+hl }, { 0.75f+hl, 0.0f+hl },
            { 0.75f+hl, 0.25f-hl }, { 0.875f-hl, 0.25f-hl }, { 0.875f-hl, 0.25f-hl }, { 0.75f+hl, 0.25f-hl },
            { 0.75f+hl, 0.25f+hl }, { 0.875f-hl, 0.25f+hl }, { 0.875f-hl, 0.25f+hl }, { 0.75f+hl, 0.25f+hl },
            { 0.75f+hl, 0.5f-hl }, { 0.875f-hl, 0.5f-hl }, { 0.875f-hl, 0.5f-hl }, { 0.75f+hl, 0.5f-hl }
        }, {  // Small idle coords.
            { 0.875f+hl, 0.0f+hl }, { 1.0f-hl, 0.0f+hl }, { 1.0f-hl, 0.0f+hl }, { 0.875f+hl, 0.0f+hl },
            { 0.875f+hl, 0.25f-hl }, { 1.0f-hl, 0.25f-hl }, { 1.0f-hl, 0.25f-hl }, { 0.875f+hl, 0.25f-hl },
            { 0.875f+hl, 0.25f+hl }, { 1.0f-hl, 0.25f+hl }, { 1.0f-hl, 0.25f+hl }, { 0.875f+hl, 0.25f+hl },
            { 0.875f+hl, 0.5f-hl }, { 1.0f-hl, 0.5f-hl }, { 1.0f-hl, 0.5f-hl }, { 0.875f+hl, 0.5f-hl }
        }, {  // Small pressed coords.
            { 0.75f+hl, 0.5f+hl }, { 0.875f-hl, 0.5f+hl }, { 0.875f-hl, 0.5f+hl }, { 0.75f+hl, 0.5f+hl },
            { 0.75f+hl, 0.75f-hl }, { 0.875f-hl, 0.75f-hl }, { 0.875f-hl, 0.75f-hl }, { 0.75f+hl, 0.75f-hl },
            { 0.75f+hl, 0.75f+hl }, { 0.875f-hl, 0.75f+hl }, { 0.875f-hl, 0.75f+hl }, { 0.75f+hl, 0.75f+hl },
            { 0.75f+hl, 1.0f-hl }, { 0.875f-hl, 1.0f-hl }, { 0.875f-hl, 1.0f-hl }, { 0.75f+hl, 1.0f-hl }
        }
    }
};
