/*
 * Syncdaemon API
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __SYNCDAEMON_TRANSFER_INFO_H__
#define __SYNCDAEMON_TRANSFER_INFO_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define SYNCDAEMON_TYPE_TRANSFER_INFO                (syncdaemon_transfer_info_get_type ())
#define SYNCDAEMON_TRANSFER_INFO(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNCDAEMON_TYPE_TRANSFER_INFO, SyncdaemonTransferInfo))
#define SYNCDAEMON_IS_TRANSFER_INFO(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNCDAEMON_TYPE_TRANSFER_INFO))
#define SYNCDAEMON_TRANSFER_INFO_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), SYNCDAEMON_TYPE_TRANSFER_INFO, SyncdaemonTransferInfoClass))
#define SYNCDAEMON_IS_TRANSFER_INFO_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNCDAEMON_TYPE_TRANSFER_INFO))
#define SYNCDAEMON_TRANSFER_INFO_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNCDAEMON_TYPE_TRANSFER_INFO, SyncdaemonTransferInfoClass))

typedef struct _SyncdaemonTransferInfoPrivate SyncdaemonTransferInfoPrivate;

typedef struct {
	GObject parent;
	SyncdaemonTransferInfoPrivate *priv;
} SyncdaemonTransferInfo;

typedef struct {
	GObjectClass parent_class;
} SyncdaemonTransferInfoClass;

GType                   syncdaemon_transfer_info_get_type (void);

SyncdaemonTransferInfo *syncdaemon_transfer_info_new (const gchar *path);
SyncdaemonTransferInfo *syncdaemon_transfer_info_new_from_hash_table (GHashTable *hash);

const gchar *syncdaemon_transfer_info_get_path (SyncdaemonTransferInfo *tinfo);
void         syncdaemon_transfer_info_set_path (SyncdaemonTransferInfo *tinfo, const gchar *path);
const gchar *syncdaemon_transfer_info_get_share_id (SyncdaemonTransferInfo *tinfo);
void         syncdaemon_transfer_info_set_share_id (SyncdaemonTransferInfo *tinfo, const gchar *share_id);
const gchar *syncdaemon_transfer_info_get_node_id (SyncdaemonTransferInfo *tinfo);
void         syncdaemon_transfer_info_set_node_id (SyncdaemonTransferInfo *tinfo, const gchar *node_id);
glong        syncdaemon_transfer_info_get_bytes_transferred (SyncdaemonTransferInfo *tinfo);
void         syncdaemon_transfer_info_set_bytes_transferred (SyncdaemonTransferInfo *tinfo, glong bytes);
glong        syncdaemon_transfer_info_get_total_size (SyncdaemonTransferInfo *tinfo);
void         syncdaemon_transfer_info_set_total_size (SyncdaemonTransferInfo *tinfo, glong bytes);

G_END_DECLS

#endif
