"""Linux test code."""


def _setup_service_busname(testcase):
    # monkeypatch __del__ to avoid issues with gc
    import dbus
    dbus.service.BusName.__del__ = lambda _: None

setup_action_queue_test = _setup_service_busname

setup_main_test = _setup_service_busname

def get_main_params(testcase, params):
    """Return the parameters used to create the main object for tests."""
    from dbus.mainloop.glib import DBusGMainLoop
    # set glib_loop and return the common params
    params['glib_loop'] = DBusGMainLoop(set_as_default=True)
    return params


def platform_mangled_path(path):
    """Return the expected modified path according to the platform."""
    return path
