# -*- coding: utf-8 -*-
#
# Author: Manuel de la Pena<manuel@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Tests for the network manager."""
from mocker import MockerTestCase
from ubuntuone.platform.windows.network_manager import NetworkManager

class TestNetworkManager(MockerTestCase):
    """Test he Network Manager."""

    def setUp(self):
        super(TestNetworkManager, self).setUp()
        self.connection_info = self.mocker.mock()
        self.connection_no_info = self.mocker.mock()
        self.disconnected = self.mocker.mock()
        self.manager = NetworkManager(self.connection_no_info,
                                      self.connection_info, self.disconnected)

    def test_connection_made(self):
        """Ensure db is called."""
        self.connection_info()
        self.mocker.replay()
        self.manager.ConnectionMade()

    def test_connection_made_no_cb(self):
        """Ensure db is called."""
        self.manager.connected_cb_info = None
        self.mocker.replay()
        self.manager.ConnectionMade()

    def test_connection_made_no_info(self):
        """Ensure db is called."""
        self.connection_no_info()
        self.mocker.replay()
        self.manager.ConnectionMadeNoQOCInfo()

    def test_connection_made_no_info_no_cb(self):
        """Ensure db is called."""
        self.manager.connected_cb = None
        self.mocker.replay()
        self.manager.ConnectionMadeNoQOCInfo()

    def test_disconnection(self):
        """Ensure db is called."""
        self.disconnected()
        self.mocker.replay()
        self.manager.ConnectionLost()

    def test_disconnection_no_cb(self):
        """Ensure db is called."""
        self.manager.disconnected_cb = None
        self.mocker.replay()
        self.manager.ConnectionLost()
