/*
 * Syncdaemon API
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __SYNCDAEMON_SHARE_INFO_H__
#define __SYNCDAEMON_SHARE_INFO_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define SYNCDAEMON_TYPE_SHARE_INFO                (syncdaemon_share_info_get_type ())
#define SYNCDAEMON_SHARE_INFO(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNCDAEMON_TYPE_SHARE_INFO, SyncdaemonShareInfo))
#define SYNCDAEMON_IS_SHARE_INFO(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNCDAEMON_TYPE_SHARE_INFO))
#define SYNCDAEMON_SHARE_INFO_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), SYNCDAEMON_TYPE_SHARE_INFO, SyncdaemonShareInfoClass))
#define SYNCDAEMON_IS_SHARE_INFO_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNCDAEMON_TYPE_SHARE_INFO))
#define SYNCDAEMON_SHARE_INFO_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNCDAEMON_TYPE_SHARE_INFO, SyncdaemonShareInfoClass))

typedef struct _SyncdaemonShareInfoPrivate SyncdaemonShareInfoPrivate;

typedef struct {
	GObject parent;
	SyncdaemonShareInfoPrivate *priv;
} SyncdaemonShareInfo;

typedef struct {
	GObjectClass parent_class;
} SyncdaemonShareInfoClass;

typedef enum {
	SYNCDAEMON_SHARE_INFO_TYPE_UNKNOWN,
	SYNCDAEMON_SHARE_INFO_TYPE_SHARED,
	SYNCDAEMON_SHARE_INFO_TYPE_SHARE
} SyncdaemonShareInfoType;

GType                syncdaemon_share_info_get_type (void);
SyncdaemonShareInfo *syncdaemon_share_info_new (void);
SyncdaemonShareInfo *syncdaemon_share_info_new_from_hash_table (GHashTable *hash);

const gchar         *syncdaemon_share_info_get_name (SyncdaemonShareInfo *sinfo);
void                 syncdaemon_share_info_set_name (SyncdaemonShareInfo *sinfo, const gchar *name);
SyncdaemonShareInfoType syncdaemon_share_info_get_share_type (SyncdaemonShareInfo *sinfo);
void                 syncdaemon_share_info_set_share_type (SyncdaemonShareInfo *sinfo, SyncdaemonShareInfoType type);
const gchar         *syncdaemon_share_info_get_path (SyncdaemonShareInfo *sinfo);
void                 syncdaemon_share_info_set_path (SyncdaemonShareInfo *sinfo, const gchar *path);
const gchar         *syncdaemon_share_info_get_username (SyncdaemonShareInfo *sinfo);
void                 syncdaemon_share_info_set_username (SyncdaemonShareInfo *sinfo, const gchar *username);
const gchar         *syncdaemon_share_info_get_user_visible_name (SyncdaemonShareInfo *sinfo);
void                 syncdaemon_share_info_set_user_visible_name (SyncdaemonShareInfo *sinfo, const gchar *user_visible_name);
const gchar         *syncdaemon_share_info_get_node_id (SyncdaemonShareInfo *sinfo);
void                 syncdaemon_share_info_set_node_id (SyncdaemonShareInfo *sinfo, const gchar *node_id);
const gchar         *syncdaemon_share_info_get_volume_id (SyncdaemonShareInfo *sinfo);
void                 syncdaemon_share_info_set_volume_id (SyncdaemonShareInfo *sinfo, const gchar *volume_id);
gboolean             syncdaemon_share_info_get_accepted (SyncdaemonShareInfo *sinfo);
void                 syncdaemon_share_info_set_accepted (SyncdaemonShareInfo *sinfo, gboolean accepted);
gboolean             syncdaemon_share_info_get_allow_modifications (SyncdaemonShareInfo *sinfo);
void                 syncdaemon_share_info_set_allow_modifications (SyncdaemonShareInfo *sinfo, gboolean allow_modifications);

G_END_DECLS

#endif
