/*
 * Syncdaemon API
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2010-2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 *
 */

#ifndef __SYNCDAEMON_FOLDERS_INTERFACE_H__
#define __SYNCDAEMON_FOLDERS_INTERFACE_H__

#include "syncdaemon-daemon.h"
#include "syncdaemon-folder-info.h"
#include "syncdaemon-interface.h"

G_BEGIN_DECLS

#define SYNCDAEMON_TYPE_FOLDERS_INTERFACE                (syncdaemon_folders_interface_get_type ())
#define SYNCDAEMON_FOLDERS_INTERFACE(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNCDAEMON_TYPE_FOLDERS_INTERFACE, SyncdaemonFoldersInterface))
#define SYNCDAEMON_IS_FOLDERS_INTERFACE(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNCDAEMON_TYPE_FOLDERS_INTERFACE))
#define SYNCDAEMON_FOLDERS_INTERFACE_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), SYNCDAEMON_TYPE_FOLDERS_INTERFACE, SyncdaemonFoldersInterfaceClass))
#define SYNCDAEMON_IS_FOLDERS_INTERFACE_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNCDAEMON_TYPE_FOLDERS_INTERFACE))
#define SYNCDAEMON_FOLDERS_INTERFACE_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNCDAEMON_TYPE_FOLDERS_INTERFACE, SyncdaemonFoldersInterfaceClass))

typedef struct _SyncdaemonFoldersInterfacePrivate SyncdaemonFoldersInterfacePrivate;

typedef struct {
	SyncdaemonInterface parent;
	SyncdaemonFoldersInterfacePrivate *priv;
} SyncdaemonFoldersInterface;

typedef struct {
	SyncdaemonInterfaceClass parent_class;
} SyncdaemonFoldersInterfaceClass;

GType                       syncdaemon_folders_interface_get_type (void);

SyncdaemonFoldersInterface *syncdaemon_folders_interface_new (SyncdaemonDaemon *daemon);

void                        syncdaemon_folders_interface_create (SyncdaemonFoldersInterface *interface, const gchar *path);
void                        syncdaemon_folders_interface_delete (SyncdaemonFoldersInterface *interface, const gchar *folder_id);
GSList                     *syncdaemon_folders_interface_get_folders (SyncdaemonFoldersInterface *interface);
SyncdaemonFolderInfo       *syncdaemon_folders_interface_get_info (SyncdaemonFoldersInterface *interface, const gchar *path);
void                        syncdaemon_folders_interface_refresh_volumes (SyncdaemonFoldersInterface *interface);
void                        syncdaemon_folders_interface_subscribe (SyncdaemonFoldersInterface *interface, const gchar *folder_id);
void                        syncdaemon_folders_interface_unsubscribe (SyncdaemonFoldersInterface *interface, const gchar *folder_id);

G_END_DECLS

#endif
