# -*- coding: utf-8 -*-
#
# Copyright 2012 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""The UI for Share file widget."""

import os

from PyQt4 import QtGui, QtCore

from ubuntuone.platform import expand_user

from ubuntuone.controlpanel import cache
from ubuntuone.controlpanel.gui.qt.share_links_search import (
    get_system_icon_for_filename,
)
from ubuntuone.controlpanel.gui.qt.ui import share_file_ui
from ubuntuone.controlpanel.logger import setup_logging


logger = setup_logging('qt.share_file')


class ShareFileWidget(cache.Cache, QtGui.QWidget):
    """Widget with the detail information about the shared file."""

    linkDisabled = QtCore.pyqtSignal()

    def __init__(self, file_path='', *args, **kwargs):
        super(ShareFileWidget, self).__init__(*args, **kwargs)
        self.ui = share_file_ui.Ui_Form()
        self.ui.setupUi(self)
        full_path = expand_user(file_path.encode('utf-8'))
        self.file_path = full_path.decode('utf-8')

        self.ui.lbl_filename.setText(os.path.basename(file_path))
        self.ui.lbl_path.setText(file_path)
        icon = get_system_icon_for_filename(full_path)
        pixmap = icon.pixmap(24)
        self.ui.lbl_icon.setPixmap(pixmap)

        self.ui.btn_open.clicked.connect(self.open_file)
        self.ui.btn_disable.clicked.connect(self.disable_link)

    def open_file(self):
        """Open the specified file."""
        path = 'file://%s' % self.file_path
        QtGui.QDesktopServices.openUrl(QtCore.QUrl(path))

    def disable_link(self, val):
        """Change the access of the file to Not Public."""
        self.backend.change_public_access(self.file_path, False)
        self.linkDisabled.emit()
