# -*- coding: utf-8 -*-
#
# Copyright 2012 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Tabbed panel used to show the information optained via rest services."""

from PyQt4 import QtGui


class TabbedPanel(QtGui.QTabWidget):
    """Widget that shows tabs that use rest services to get the info."""

    def __init__(self, *args, **kwargs):
        super(TabbedPanel, self).__init__(*args, **kwargs)
        self._show_overlay = False

    def _get_show_overlay(self):
        """Get if the overlay is shown."""
        return self._show_overlay

    def _set_show_overlay(self, is_shown):
        """Set if the overlay is shown."""
        # we need to loop over the differet tabs and get their widgets, if the
        # widet does have an overlay, lets set the value
        for index in range(self.count()):
            widget = self.widget(index)
            show_overlay = getattr(widget, 'show_overlay', None)
            if show_overlay is not None:
                widget.show_overlay = is_shown

        self._show_overlay = is_shown

    show_overlay = property(fget=_get_show_overlay, fset=_set_show_overlay)
