# Author: Natalia B. Bidart <natalia.bidart@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Hook for Apport."""

# Invalid name "source_ubuntuone-control-panel"
# pylint: disable=C0103

import os

from apport.hookutils import attach_related_packages, attach_file_if_exists

from ubuntuone.platform.xdg_base_directory import ubuntuone_log_dir


def add_info(report):
    """Add info to the report."""
    log_file = os.path.join(ubuntuone_log_dir, "controlpanel.log")
    attach_file_if_exists(report, log_file, "UbuntuOneControlPanelLog")

    related_packages = [
        'python-ubuntuone-client',
        'python-ubuntuone-storageprotocol',
        'ubuntuone-client',
    ]
    attach_related_packages(report, related_packages)
