// -*- mode: js; js-indent-level: 4; indent-tabs-mode: nil -*-

var Cu = Components.utils;
var Ci = Components.interfaces;
var Cc = Components.classes;
var Cr = Components.results;
var Cm = Components.manager;

Cu.import("resource://gre/modules/XPCOMUtils.jsm");

Cu.import("resource://unity/unity-global-property-initializer.js");
Cu.import("resource://unity/chromeless.js");

const CONTRACT_ID = "@unity_webapps.org/urlpolicy";
const CLASS_ID = "{11111111-dad0-11c5-9da2-7ffe3a6343f8}";

URLPolicy = function () {}

URLPolicy.prototype = {
    classDescription:   "open unrelated uri in new window",
    classID:            Components.ID(CLASS_ID),
    contractID:         CONTRACT_ID,
    _xpcom_categories:  [{ category: "content-policy"}],
    QueryInterface:     XPCOMUtils.generateQI([Ci.nsIContentPolicy]),

   shouldLoad: function (contType, contLoc, reqOrig, ctx, typeGuess, extra) {
       if (!Chromeless._activated)
           return Ci.nsIContentPolicy.ACCEPT;

       if (contType !== 6)
           return Ci.nsIContentPolicy.ACCEPT;

       if (contLoc.scheme !== 'http' && contLoc.scheme !== 'https')
           return Ci.nsIContentPolicy.ACCEPT;

       if (!allowed_domains.length)
           return Ci.nsIContentPolicy.ACCEPT;

       for (var i = 0; i < allowed_domains.length; i++) {
           // FIXME
           if (allowed_domains[i] == contLoc.host)
               return Ci.nsIContentPolicy.ACCEPT;
       }
       try {
           if (ctx) {
               win = ctx.contentWindow;
               if (!win.history.length)
                   win.close();
           }
       } catch (x) {dump(x);}

       var file = Cc["@mozilla.org/file/local;1"]
           .createInstance(Ci.nsILocalFile);
       file.initWithPath("/bin/bash");
       var process = Cc["@mozilla.org/process/util;1"]
           .createInstance(Components.interfaces.nsIProcess);
       process.init(file);

       var args = ["-c", 'unset -v MOZ_APP_LAUNCHER  MOZ_CRASHREPORTER_DATA_DIRECTORY MOZ_LAUNCHED_CHILD MOZ_NO_REMOTE; firefox ' + contLoc.spec];
       process.run(false, args, args.length);

       return Ci.nsIContentPolicy.REJECT;
    },

    shouldProcess: function (contType, contLoc, reqOrig, ctx, mimeType, extra) {
       return Ci.nsIContentPolicy.ACCEPT;
    }
};

var NSGetFactory = XPCOMUtils.generateNSGetFactory([URLPolicy]);

var EXPORTED_SYMBOLS = ["NSGetFactory"];
