/* dash-box.c generated by valac 0.16.1, the Vala compiler
 * generated from dash-box.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2011,2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Michael Terry <michael.terry@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <cairo.h>


#define TYPE_DASH_BOX (dash_box_get_type ())
#define DASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DASH_BOX, DashBox))
#define DASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DASH_BOX, DashBoxClass))
#define IS_DASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DASH_BOX))
#define IS_DASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DASH_BOX))
#define DASH_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DASH_BOX, DashBoxClass))

typedef struct _DashBox DashBox;
typedef struct _DashBoxClass DashBoxClass;
typedef struct _DashBoxPrivate DashBoxPrivate;

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;

#define TYPE_FADABLE_BOX (fadable_box_get_type ())
#define FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE_BOX, FadableBox))
#define FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADABLE_BOX, FadableBoxClass))
#define IS_FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE_BOX))
#define IS_FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADABLE_BOX))
#define FADABLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADABLE_BOX, FadableBoxClass))

typedef struct _FadableBox FadableBox;
typedef struct _FadableBoxClass FadableBoxClass;

#define TYPE_GREETER_LIST (greeter_list_get_type ())
#define GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GREETER_LIST, GreeterList))
#define GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GREETER_LIST, GreeterListClass))
#define IS_GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GREETER_LIST))
#define IS_GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GREETER_LIST))
#define GREETER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GREETER_LIST, GreeterListClass))

typedef struct _GreeterList GreeterList;
typedef struct _GreeterListClass GreeterListClass;

#define TYPE_FADE_TRACKER (fade_tracker_get_type ())
#define FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADE_TRACKER, FadeTracker))
#define FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADE_TRACKER, FadeTrackerClass))
#define IS_FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADE_TRACKER))
#define IS_FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADE_TRACKER))
#define FADE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADE_TRACKER, FadeTrackerClass))

typedef struct _FadeTracker FadeTracker;
typedef struct _FadeTrackerClass FadeTrackerClass;

#define DASH_BOX_TYPE_MODE (dash_box_mode_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FADE_TRACKER_TYPE_MODE (fade_tracker_mode_get_type ())

#define TYPE_FADABLE (fadable_get_type ())
#define FADABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE, Fadable))
#define IS_FADABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE))
#define FADABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FADABLE, FadableIface))

typedef struct _Fadable Fadable;
typedef struct _FadableIface FadableIface;

#define TYPE_PROMPT_BOX (prompt_box_get_type ())
#define PROMPT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROMPT_BOX, PromptBox))
#define PROMPT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROMPT_BOX, PromptBoxClass))
#define IS_PROMPT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROMPT_BOX))
#define IS_PROMPT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROMPT_BOX))
#define PROMPT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROMPT_BOX, PromptBoxClass))

typedef struct _PromptBox PromptBox;
typedef struct _PromptBoxClass PromptBoxClass;

#define BACKGROUND_TYPE_DRAW_FLAGS (background_draw_flags_get_type ())

struct _DashBox {
	GtkBox parent_instance;
	DashBoxPrivate * priv;
};

struct _DashBoxClass {
	GtkBoxClass parent_class;
};

typedef enum  {
	DASH_BOX_MODE_NORMAL,
	DASH_BOX_MODE_PUSH_FADE_OUT,
	DASH_BOX_MODE_PUSH_FADE_IN,
	DASH_BOX_MODE_POP_FADE_OUT,
	DASH_BOX_MODE_POP_FADE_IN
} DashBoxMode;

struct _DashBoxPrivate {
	Background* _background;
	gboolean _has_base;
	gdouble _base_alpha;
	GreeterList* pushed;
	GtkWidget* orig;
	FadeTracker* orig_tracker;
	gint orig_height;
	DashBoxMode mode;
};

typedef enum  {
	FADE_TRACKER_MODE_FADE_IN,
	FADE_TRACKER_MODE_FADE_OUT
} FadeTrackerMode;

struct _FadableIface {
	GTypeInterface parent_iface;
	FadeTracker* (*get_fade_tracker) (Fadable* self);
	void (*set_fade_tracker) (Fadable* self, FadeTracker* value);
};

typedef enum  {
	BACKGROUND_DRAW_FLAGS_NONE,
	BACKGROUND_DRAW_FLAGS_GRID
} BackgroundDrawFlags;


static gpointer dash_box_parent_class = NULL;

GType dash_box_get_type (void) G_GNUC_CONST;
GType background_get_type (void) G_GNUC_CONST;
GType fadable_box_get_type (void) G_GNUC_CONST;
GType greeter_list_get_type (void) G_GNUC_CONST;
GType fade_tracker_get_type (void) G_GNUC_CONST;
static GType dash_box_mode_get_type (void) G_GNUC_UNUSED;
#define DASH_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DASH_BOX, DashBoxPrivate))
enum  {
	DASH_BOX_DUMMY_PROPERTY,
	DASH_BOX_BACKGROUND,
	DASH_BOX_HAS_BASE,
	DASH_BOX_BASE_ALPHA
};
DashBox* dash_box_new (Background* bg);
DashBox* dash_box_construct (GType object_type, Background* bg);
void dash_box_set_base (DashBox* self, GtkWidget* w);
static void dash_box_base_size_allocate_cb (DashBox* self);
static void _dash_box_base_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
FadeTracker* fade_tracker_new (GtkWidget* widget);
FadeTracker* fade_tracker_construct (GType object_type, GtkWidget* widget);
static void ___lambda17_ (DashBox* self);
gdouble fade_tracker_get_alpha (FadeTracker* self);
static void dash_box_set_base_alpha (DashBox* self, gdouble value);
static void ____lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void dash_box_fade_done_cb (DashBox* self);
static void _dash_box_fade_done_cb_fade_tracker_done (FadeTracker* _sender, gpointer self);
static void dash_box_set_has_base (DashBox* self, gboolean value);
void dash_box_push (DashBox* self, GreeterList* l);
static void _dash_box_fade_done_cb_fadable_box_fade_done (FadableBox* _sender, gpointer self);
GType fade_tracker_mode_get_type (void) G_GNUC_CONST;
void fade_tracker_reset (FadeTracker* self, FadeTrackerMode mode);
void dash_box_pop (DashBox* self);
GType fadable_get_type (void) G_GNUC_CONST;
void fadable_fade_out (Fadable* self);
void fadable_fade_in (Fadable* self);
static void dash_box_real_get_preferred_height (GtkWidget* base, gint* min, gint* nat);
#define grid_size 40
#define GREETER_LIST_DEFAULT_BOX_HEIGHT 3
#define GREETER_LIST_BORDER 4
GType prompt_box_get_type (void) G_GNUC_CONST;
PromptBox* greeter_list_get_selected_entry (GreeterList* self);
static void dash_box_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat);
#define GREETER_LIST_BOX_WIDTH 8
static gboolean dash_box_real_draw (GtkWidget* base, cairo_t* c);
Background* dash_box_get_background (DashBox* self);
GType background_draw_flags_get_type (void) G_GNUC_CONST;
void background_draw_full (Background* self, cairo_t* c, BackgroundDrawFlags flags);
gdouble dash_box_get_base_alpha (DashBox* self);
static void dash_box_cairo_rounded_rectangle (DashBox* self, cairo_t* c, gdouble x, gdouble y, gdouble width, gdouble height, gdouble radius);
static void dash_box_set_background (DashBox* self, Background* value);
gboolean dash_box_get_has_base (DashBox* self);
static GObject * dash_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dash_box_finalize (GObject* obj);
static void _vala_dash_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dash_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static GType dash_box_mode_get_type (void) {
	static volatile gsize dash_box_mode_type_id__volatile = 0;
	if (g_once_init_enter (&dash_box_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{DASH_BOX_MODE_NORMAL, "DASH_BOX_MODE_NORMAL", "normal"}, {DASH_BOX_MODE_PUSH_FADE_OUT, "DASH_BOX_MODE_PUSH_FADE_OUT", "push-fade-out"}, {DASH_BOX_MODE_PUSH_FADE_IN, "DASH_BOX_MODE_PUSH_FADE_IN", "push-fade-in"}, {DASH_BOX_MODE_POP_FADE_OUT, "DASH_BOX_MODE_POP_FADE_OUT", "pop-fade-out"}, {DASH_BOX_MODE_POP_FADE_IN, "DASH_BOX_MODE_POP_FADE_IN", "pop-fade-in"}, {0, NULL, NULL}};
		GType dash_box_mode_type_id;
		dash_box_mode_type_id = g_enum_register_static ("DashBoxMode", values);
		g_once_init_leave (&dash_box_mode_type_id__volatile, dash_box_mode_type_id);
	}
	return dash_box_mode_type_id__volatile;
}


DashBox* dash_box_construct (GType object_type, Background* bg) {
	DashBox * self = NULL;
	Background* _tmp0_;
	g_return_val_if_fail (bg != NULL, NULL);
	_tmp0_ = bg;
	self = (DashBox*) g_object_new (object_type, "background", _tmp0_, NULL);
	return self;
}


DashBox* dash_box_new (Background* bg) {
	return dash_box_construct (TYPE_DASH_BOX, bg);
}


static void _dash_box_base_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	dash_box_base_size_allocate_cb (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void ___lambda17_ (DashBox* self) {
	FadeTracker* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	_tmp0_ = self->priv->orig_tracker;
	_tmp1_ = fade_tracker_get_alpha (_tmp0_);
	_tmp2_ = _tmp1_;
	dash_box_set_base_alpha (self, _tmp2_);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void ____lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda17_ (self);
}


static void _dash_box_fade_done_cb_fade_tracker_done (FadeTracker* _sender, gpointer self) {
	dash_box_fade_done_cb (self);
}


void dash_box_set_base (DashBox* self, GtkWidget* w) {
	GreeterList* _tmp0_;
	DashBoxMode _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pushed;
	g_return_if_fail (_tmp0_ == NULL);
	_tmp1_ = self->priv->mode;
	g_return_if_fail (_tmp1_ == DASH_BOX_MODE_NORMAL);
	_tmp2_ = self->priv->orig;
	if (_tmp2_ != NULL) {
		GtkWidget* _tmp3_;
		guint _tmp4_ = 0U;
		_tmp3_ = self->priv->orig;
		g_signal_parse_name ("size-allocate", GTK_TYPE_WIDGET, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _dash_box_base_size_allocate_cb_gtk_widget_size_allocate, self);
	}
	_tmp5_ = w;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->orig);
	self->priv->orig = _tmp6_;
	_tmp7_ = self->priv->orig;
	if (_tmp7_ != NULL) {
		GtkWidget* _tmp8_;
		GtkWidget* _tmp9_;
		FadeTracker* _tmp10_;
		FadeTracker* _tmp11_;
		FadeTracker* _tmp12_;
		FadeTracker* _tmp13_;
		gdouble _tmp14_;
		gdouble _tmp15_;
		_tmp8_ = self->priv->orig;
		g_signal_connect_object (_tmp8_, "size-allocate", (GCallback) _dash_box_base_size_allocate_cb_gtk_widget_size_allocate, self, 0);
		_tmp9_ = self->priv->orig;
		_tmp10_ = fade_tracker_new (_tmp9_);
		_g_object_unref0 (self->priv->orig_tracker);
		self->priv->orig_tracker = _tmp10_;
		_tmp11_ = self->priv->orig_tracker;
		g_signal_connect_object ((GObject*) _tmp11_, "notify::alpha", (GCallback) ____lambda17__g_object_notify, self, 0);
		_tmp12_ = self->priv->orig_tracker;
		g_signal_connect_object (_tmp12_, "done", (GCallback) _dash_box_fade_done_cb_fade_tracker_done, self, 0);
		_tmp13_ = self->priv->orig_tracker;
		_tmp14_ = fade_tracker_get_alpha (_tmp13_);
		_tmp15_ = _tmp14_;
		dash_box_set_base_alpha (self, _tmp15_);
		dash_box_set_has_base (self, TRUE);
	} else {
		gint _tmp16_ = 0;
		self->priv->orig_height = -1;
		gtk_widget_get_preferred_height ((GtkWidget*) self, NULL, &_tmp16_);
		self->priv->orig_height = _tmp16_;
		_g_object_unref0 (self->priv->orig_tracker);
		self->priv->orig_tracker = NULL;
		dash_box_set_base_alpha (self, 1.0);
		dash_box_set_has_base (self, FALSE);
	}
	gtk_widget_queue_resize ((GtkWidget*) self);
}


static void _dash_box_fade_done_cb_fadable_box_fade_done (FadableBox* _sender, gpointer self) {
	dash_box_fade_done_cb (self);
}


void dash_box_push (DashBox* self, GreeterList* l) {
	GreeterList* _tmp0_;
	GtkWidget* _tmp1_;
	DashBoxMode _tmp2_;
	gint _tmp3_ = 0;
	GreeterList* _tmp4_;
	GreeterList* _tmp5_;
	GreeterList* _tmp6_;
	FadeTracker* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (l != NULL);
	_tmp0_ = self->priv->pushed;
	g_return_if_fail (_tmp0_ == NULL);
	_tmp1_ = self->priv->orig;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = self->priv->mode;
	g_return_if_fail (_tmp2_ == DASH_BOX_MODE_NORMAL);
	gtk_widget_get_preferred_height ((GtkWidget*) self, NULL, &_tmp3_);
	self->priv->orig_height = _tmp3_;
	_tmp4_ = l;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->pushed);
	self->priv->pushed = _tmp5_;
	_tmp6_ = self->priv->pushed;
	g_signal_connect_object ((FadableBox*) _tmp6_, "fade-done", (GCallback) _dash_box_fade_done_cb_fadable_box_fade_done, self, 0);
	self->priv->mode = DASH_BOX_MODE_PUSH_FADE_OUT;
	_tmp7_ = self->priv->orig_tracker;
	fade_tracker_reset (_tmp7_, FADE_TRACKER_MODE_FADE_OUT);
	gtk_widget_queue_resize ((GtkWidget*) self);
}


void dash_box_pop (DashBox* self) {
	GreeterList* _tmp0_;
	GtkWidget* _tmp1_;
	DashBoxMode _tmp2_;
	GreeterList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pushed;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->orig;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = self->priv->mode;
	g_return_if_fail (_tmp2_ == DASH_BOX_MODE_NORMAL);
	self->priv->mode = DASH_BOX_MODE_POP_FADE_OUT;
	_tmp3_ = self->priv->pushed;
	fadable_fade_out ((Fadable*) _tmp3_);
}


static void dash_box_fade_done_cb (DashBox* self) {
	DashBoxMode _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mode;
	switch (_tmp0_) {
		case DASH_BOX_MODE_PUSH_FADE_OUT:
		{
			GtkWidget* _tmp1_;
			GreeterList* _tmp2_;
			self->priv->mode = DASH_BOX_MODE_PUSH_FADE_IN;
			_tmp1_ = self->priv->orig;
			gtk_widget_hide (_tmp1_);
			_tmp2_ = self->priv->pushed;
			fadable_fade_in ((Fadable*) _tmp2_);
			break;
		}
		case DASH_BOX_MODE_PUSH_FADE_IN:
		{
			GreeterList* _tmp3_;
			self->priv->mode = DASH_BOX_MODE_NORMAL;
			_tmp3_ = self->priv->pushed;
			gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
			break;
		}
		case DASH_BOX_MODE_POP_FADE_OUT:
		{
			FadeTracker* _tmp4_;
			GtkWidget* _tmp5_;
			self->priv->mode = DASH_BOX_MODE_POP_FADE_IN;
			_tmp4_ = self->priv->orig_tracker;
			fade_tracker_reset (_tmp4_, FADE_TRACKER_MODE_FADE_IN);
			_tmp5_ = self->priv->orig;
			gtk_widget_show (_tmp5_);
			break;
		}
		case DASH_BOX_MODE_POP_FADE_IN:
		{
			GreeterList* _tmp6_;
			guint _tmp7_ = 0U;
			GreeterList* _tmp8_;
			GtkWidget* _tmp9_;
			self->priv->mode = DASH_BOX_MODE_NORMAL;
			_tmp6_ = self->priv->pushed;
			g_signal_parse_name ("fade-done", TYPE_FADABLE_BOX, &_tmp7_, NULL, FALSE);
			g_signal_handlers_disconnect_matched ((FadableBox*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _dash_box_fade_done_cb_fadable_box_fade_done, self);
			_tmp8_ = self->priv->pushed;
			gtk_widget_destroy ((GtkWidget*) _tmp8_);
			_g_object_unref0 (self->priv->pushed);
			self->priv->pushed = NULL;
			gtk_widget_queue_resize ((GtkWidget*) self);
			_tmp9_ = self->priv->orig;
			gtk_widget_grab_focus (_tmp9_);
			break;
		}
		default:
		break;
	}
}


static void dash_box_base_size_allocate_cb (DashBox* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_queue_resize ((GtkWidget*) self);
}


static void dash_box_real_get_preferred_height (GtkWidget* base, gint* min, gint* nat) {
	DashBox * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	GtkWidget* _tmp0_;
	self = (DashBox*) base;
	_tmp0_ = self->priv->orig;
	if (_tmp0_ == NULL) {
		gint _tmp1_;
		_tmp1_ = self->priv->orig_height;
		if (_tmp1_ >= 0) {
			gint _tmp2_;
			gint _tmp3_;
			_tmp2_ = self->priv->orig_height;
			_vala_min = _tmp2_;
			_tmp3_ = self->priv->orig_height;
			_vala_nat = _tmp3_;
		} else {
			_vala_min = (grid_size * GREETER_LIST_DEFAULT_BOX_HEIGHT) - (GREETER_LIST_BORDER * 2);
			_vala_nat = (grid_size * GREETER_LIST_DEFAULT_BOX_HEIGHT) - (GREETER_LIST_BORDER * 2);
		}
	} else {
		GreeterList* _tmp4_;
		_tmp4_ = self->priv->pushed;
		if (_tmp4_ == NULL) {
			GtkWidget* _tmp5_;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			_tmp5_ = self->priv->orig;
			gtk_widget_get_preferred_height (_tmp5_, &_tmp6_, &_tmp7_);
			_vala_min = _tmp6_;
			_vala_nat = _tmp7_;
		} else {
			GreeterList* _tmp8_;
			PromptBox* _tmp9_;
			PromptBox* _tmp10_;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_ = 0;
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_ = 0;
			_tmp8_ = self->priv->pushed;
			_tmp9_ = greeter_list_get_selected_entry (_tmp8_);
			_tmp10_ = _tmp9_;
			gtk_widget_get_preferred_height ((GtkWidget*) _tmp10_, &_tmp11_, &_tmp12_);
			_vala_min = _tmp11_;
			_vala_nat = _tmp12_;
			_tmp13_ = self->priv->orig_height;
			_tmp14_ = _vala_min;
			_tmp15_ = MAX (_tmp13_, _tmp14_);
			_vala_min = _tmp15_;
			_tmp16_ = self->priv->orig_height;
			_tmp17_ = _vala_nat;
			_tmp18_ = MAX (_tmp16_, _tmp17_);
			_vala_nat = _tmp18_;
		}
	}
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


static void dash_box_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat) {
	DashBox * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	self = (DashBox*) base;
	_vala_min = (grid_size * GREETER_LIST_BOX_WIDTH) - (GREETER_LIST_BORDER * 2);
	_vala_nat = (grid_size * GREETER_LIST_BOX_WIDTH) - (GREETER_LIST_BORDER * 2);
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


static gboolean dash_box_real_draw (GtkWidget* base, cairo_t* c) {
	DashBox * self;
	gboolean result = FALSE;
	Background* _tmp0_;
	gdouble box_r;
	gint box_y;
	gint box_w = 0;
	gint box_h = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	DashBoxMode _tmp13_;
	cairo_t* _tmp25_;
	cairo_t* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gdouble _tmp30_;
	cairo_t* _tmp31_;
	cairo_t* _tmp32_;
	cairo_t* _tmp33_;
	cairo_t* _tmp34_;
	cairo_t* _tmp35_;
	cairo_t* _tmp36_;
	cairo_t* _tmp37_;
	gboolean _tmp38_ = FALSE;
	self = (DashBox*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = self->priv->_background;
	if (_tmp0_ != NULL) {
		gint x = 0;
		gint y = 0;
		Background* _tmp1_;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		cairo_t* _tmp4_;
		cairo_t* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		Background* _tmp8_;
		cairo_t* _tmp9_;
		cairo_t* _tmp10_;
		_tmp1_ = self->priv->_background;
		gtk_widget_translate_coordinates ((GtkWidget*) _tmp1_, (GtkWidget*) self, 0, 0, &_tmp2_, &_tmp3_);
		x = _tmp2_;
		y = _tmp3_;
		_tmp4_ = c;
		cairo_save (_tmp4_);
		_tmp5_ = c;
		_tmp6_ = x;
		_tmp7_ = y;
		cairo_translate (_tmp5_, (gdouble) _tmp6_, (gdouble) _tmp7_);
		_tmp8_ = self->priv->_background;
		_tmp9_ = c;
		background_draw_full (_tmp8_, _tmp9_, BACKGROUND_DRAW_FLAGS_NONE);
		_tmp10_ = c;
		cairo_restore (_tmp10_);
	}
	box_r = 0.3 * grid_size;
	box_y = 0;
	gtk_widget_get_preferred_width ((GtkWidget*) self, NULL, &_tmp11_);
	box_w = _tmp11_;
	gtk_widget_get_preferred_height ((GtkWidget*) self, NULL, &_tmp12_);
	box_h = _tmp12_;
	_tmp13_ = self->priv->mode;
	if (_tmp13_ == DASH_BOX_MODE_PUSH_FADE_OUT) {
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gdouble _tmp17_;
		gint new_box_h;
		gint _tmp18_;
		_tmp14_ = box_h;
		_tmp15_ = box_h;
		_tmp16_ = self->priv->orig_height;
		_tmp17_ = self->priv->_base_alpha;
		new_box_h = _tmp14_ - ((gint) ((_tmp15_ - _tmp16_) * _tmp17_));
		_tmp18_ = new_box_h;
		box_h = _tmp18_;
	} else {
		DashBoxMode _tmp19_;
		_tmp19_ = self->priv->mode;
		if (_tmp19_ == DASH_BOX_MODE_POP_FADE_IN) {
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			gdouble _tmp23_;
			gint new_box_h;
			gint _tmp24_;
			_tmp20_ = box_h;
			_tmp21_ = box_h;
			_tmp22_ = self->priv->orig_height;
			_tmp23_ = self->priv->_base_alpha;
			new_box_h = _tmp20_ - ((gint) ((_tmp21_ - _tmp22_) * _tmp23_));
			_tmp24_ = new_box_h;
			box_h = _tmp24_;
		}
	}
	_tmp25_ = c;
	cairo_save (_tmp25_);
	_tmp26_ = c;
	_tmp27_ = box_y;
	_tmp28_ = box_w;
	_tmp29_ = box_h;
	_tmp30_ = box_r;
	dash_box_cairo_rounded_rectangle (self, _tmp26_, (gdouble) 0, (gdouble) _tmp27_, (gdouble) _tmp28_, (gdouble) _tmp29_, _tmp30_);
	_tmp31_ = c;
	cairo_set_source_rgba (_tmp31_, 0.1, 0.1, 0.1, 0.4);
	_tmp32_ = c;
	cairo_fill_preserve (_tmp32_);
	_tmp33_ = c;
	cairo_set_source_rgba (_tmp33_, 0.4, 0.4, 0.4, 0.4);
	_tmp34_ = c;
	cairo_set_line_width (_tmp34_, (gdouble) 1);
	_tmp35_ = c;
	cairo_stroke (_tmp35_);
	_tmp36_ = c;
	cairo_restore (_tmp36_);
	_tmp37_ = c;
	_tmp38_ = GTK_WIDGET_CLASS (dash_box_parent_class)->draw ((GtkWidget*) GTK_BOX (self), _tmp37_);
	result = _tmp38_;
	return result;
}


static void dash_box_cairo_rounded_rectangle (DashBox* self, cairo_t* c, gdouble x, gdouble y, gdouble width, gdouble height, gdouble radius) {
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble w;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble h;
	gdouble _tmp4_;
	gdouble kappa;
	cairo_t* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	cairo_t* _tmp9_;
	cairo_t* _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	cairo_t* _tmp15_;
	cairo_t* _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_;
	gdouble _tmp20_;
	cairo_t* _tmp21_;
	cairo_t* _tmp22_;
	gdouble _tmp23_;
	gdouble _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	cairo_t* _tmp27_;
	cairo_t* _tmp28_;
	gdouble _tmp29_;
	gdouble _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = width;
	_tmp1_ = radius;
	w = _tmp0_ - (_tmp1_ * 2);
	_tmp2_ = height;
	_tmp3_ = radius;
	h = _tmp2_ - (_tmp3_ * 2);
	_tmp4_ = radius;
	kappa = 0.5522847498 * _tmp4_;
	_tmp5_ = c;
	_tmp6_ = x;
	_tmp7_ = radius;
	_tmp8_ = y;
	cairo_move_to (_tmp5_, _tmp6_ + _tmp7_, _tmp8_);
	_tmp9_ = c;
	cairo_rel_line_to (_tmp9_, w, (gdouble) 0);
	_tmp10_ = c;
	_tmp11_ = radius;
	_tmp12_ = radius;
	_tmp13_ = radius;
	_tmp14_ = radius;
	cairo_rel_curve_to (_tmp10_, kappa, (gdouble) 0, _tmp11_, _tmp12_ - kappa, _tmp13_, _tmp14_);
	_tmp15_ = c;
	cairo_rel_line_to (_tmp15_, (gdouble) 0, h);
	_tmp16_ = c;
	_tmp17_ = radius;
	_tmp18_ = radius;
	_tmp19_ = radius;
	_tmp20_ = radius;
	cairo_rel_curve_to (_tmp16_, (gdouble) 0, kappa, kappa - _tmp17_, _tmp18_, -_tmp19_, _tmp20_);
	_tmp21_ = c;
	cairo_rel_line_to (_tmp21_, -w, (gdouble) 0);
	_tmp22_ = c;
	_tmp23_ = radius;
	_tmp24_ = radius;
	_tmp25_ = radius;
	_tmp26_ = radius;
	cairo_rel_curve_to (_tmp22_, -kappa, (gdouble) 0, -_tmp23_, kappa - _tmp24_, -_tmp25_, -_tmp26_);
	_tmp27_ = c;
	cairo_rel_line_to (_tmp27_, (gdouble) 0, -h);
	_tmp28_ = c;
	_tmp29_ = radius;
	_tmp30_ = radius;
	_tmp31_ = radius;
	_tmp32_ = radius;
	cairo_rel_curve_to (_tmp28_, (gdouble) 0, -kappa, _tmp29_ - kappa, -_tmp30_, _tmp31_, -_tmp32_);
}


Background* dash_box_get_background (DashBox* self) {
	Background* result;
	Background* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_background;
	result = _tmp0_;
	return result;
}


static void dash_box_set_background (DashBox* self, Background* value) {
	Background* _tmp0_;
	Background* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_background);
	self->priv->_background = _tmp1_;
	g_object_notify ((GObject *) self, "background");
}


gboolean dash_box_get_has_base (DashBox* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_base;
	result = _tmp0_;
	return result;
}


static void dash_box_set_has_base (DashBox* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_has_base = _tmp0_;
	g_object_notify ((GObject *) self, "has-base");
}


gdouble dash_box_get_base_alpha (DashBox* self) {
	gdouble result;
	gdouble _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_base_alpha;
	result = _tmp0_;
	return result;
}


static void dash_box_set_base_alpha (DashBox* self, gdouble value) {
	gdouble _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_base_alpha = _tmp0_;
	g_object_notify ((GObject *) self, "base-alpha");
}


static GObject * dash_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DashBox * self;
	parent_class = G_OBJECT_CLASS (dash_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DASH_BOX (obj);
	self->priv->mode = DASH_BOX_MODE_NORMAL;
	return obj;
}


static void dash_box_class_init (DashBoxClass * klass) {
	dash_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DashBoxPrivate));
	GTK_WIDGET_CLASS (klass)->get_preferred_height = dash_box_real_get_preferred_height;
	GTK_WIDGET_CLASS (klass)->get_preferred_width = dash_box_real_get_preferred_width;
	GTK_WIDGET_CLASS (klass)->draw = dash_box_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_dash_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dash_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = dash_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = dash_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DASH_BOX_BACKGROUND, g_param_spec_object ("background", "background", "background", TYPE_BACKGROUND, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DASH_BOX_HAS_BASE, g_param_spec_boolean ("has-base", "has-base", "has-base", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DASH_BOX_BASE_ALPHA, g_param_spec_double ("base-alpha", "base-alpha", "base-alpha", -G_MAXDOUBLE, G_MAXDOUBLE, 1.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void dash_box_instance_init (DashBox * self) {
	self->priv = DASH_BOX_GET_PRIVATE (self);
	self->priv->_background = NULL;
	self->priv->_has_base = FALSE;
	self->priv->_base_alpha = 1.0;
	self->priv->orig = NULL;
	self->priv->orig_height = -1;
}


static void dash_box_finalize (GObject* obj) {
	DashBox * self;
	self = DASH_BOX (obj);
	_g_object_unref0 (self->priv->_background);
	_g_object_unref0 (self->priv->pushed);
	_g_object_unref0 (self->priv->orig);
	_g_object_unref0 (self->priv->orig_tracker);
	G_OBJECT_CLASS (dash_box_parent_class)->finalize (obj);
}


GType dash_box_get_type (void) {
	static volatile gsize dash_box_type_id__volatile = 0;
	if (g_once_init_enter (&dash_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DashBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dash_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DashBox), 0, (GInstanceInitFunc) dash_box_instance_init, NULL };
		GType dash_box_type_id;
		dash_box_type_id = g_type_register_static (GTK_TYPE_BOX, "DashBox", &g_define_type_info, 0);
		g_once_init_leave (&dash_box_type_id__volatile, dash_box_type_id);
	}
	return dash_box_type_id__volatile;
}


static void _vala_dash_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DashBox * self;
	self = DASH_BOX (object);
	switch (property_id) {
		case DASH_BOX_BACKGROUND:
		g_value_set_object (value, dash_box_get_background (self));
		break;
		case DASH_BOX_HAS_BASE:
		g_value_set_boolean (value, dash_box_get_has_base (self));
		break;
		case DASH_BOX_BASE_ALPHA:
		g_value_set_double (value, dash_box_get_base_alpha (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dash_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DashBox * self;
	self = DASH_BOX (object);
	switch (property_id) {
		case DASH_BOX_BACKGROUND:
		dash_box_set_background (self, g_value_get_object (value));
		break;
		case DASH_BOX_HAS_BASE:
		dash_box_set_has_base (self, g_value_get_boolean (value));
		break;
		case DASH_BOX_BASE_ALPHA:
		dash_box_set_base_alpha (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



