/* prompt-box.c generated by valac 0.20.1, the Vala compiler
 * generated from prompt-box.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2011,2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Robert Ancell <robert.ancell@canonical.com>
 *          Michael Terry <michael.terry@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "config.h"
#include <atk/atk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define TYPE_FADABLE (fadable_get_type ())
#define FADABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE, Fadable))
#define IS_FADABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE))
#define FADABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FADABLE, FadableIface))

typedef struct _Fadable Fadable;
typedef struct _FadableIface FadableIface;

#define TYPE_FADE_TRACKER (fade_tracker_get_type ())
#define FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADE_TRACKER, FadeTracker))
#define FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADE_TRACKER, FadeTrackerClass))
#define IS_FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADE_TRACKER))
#define IS_FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADE_TRACKER))
#define FADE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADE_TRACKER, FadeTrackerClass))

typedef struct _FadeTracker FadeTracker;
typedef struct _FadeTrackerClass FadeTrackerClass;

#define TYPE_FADABLE_BOX (fadable_box_get_type ())
#define FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE_BOX, FadableBox))
#define FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADABLE_BOX, FadableBoxClass))
#define IS_FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE_BOX))
#define IS_FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADABLE_BOX))
#define FADABLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADABLE_BOX, FadableBoxClass))

typedef struct _FadableBox FadableBox;
typedef struct _FadableBoxClass FadableBoxClass;
typedef struct _FadableBoxPrivate FadableBoxPrivate;

#define TYPE_PROMPT_BOX (prompt_box_get_type ())
#define PROMPT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROMPT_BOX, PromptBox))
#define PROMPT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROMPT_BOX, PromptBoxClass))
#define IS_PROMPT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROMPT_BOX))
#define IS_PROMPT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROMPT_BOX))
#define PROMPT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROMPT_BOX, PromptBoxClass))

typedef struct _PromptBox PromptBox;
typedef struct _PromptBoxClass PromptBoxClass;
typedef struct _PromptBoxPrivate PromptBoxPrivate;

#define TYPE_FADING_LABEL (fading_label_get_type ())
#define FADING_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADING_LABEL, FadingLabel))
#define FADING_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADING_LABEL, FadingLabelClass))
#define IS_FADING_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADING_LABEL))
#define IS_FADING_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADING_LABEL))
#define FADING_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADING_LABEL, FadingLabelClass))

typedef struct _FadingLabel FadingLabel;
typedef struct _FadingLabelClass FadingLabelClass;

#define TYPE_FLAT_BUTTON (flat_button_get_type ())
#define FLAT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAT_BUTTON, FlatButton))
#define FLAT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FLAT_BUTTON, FlatButtonClass))
#define IS_FLAT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAT_BUTTON))
#define IS_FLAT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FLAT_BUTTON))
#define FLAT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FLAT_BUTTON, FlatButtonClass))

typedef struct _FlatButton FlatButton;
typedef struct _FlatButtonClass FlatButtonClass;

#define TYPE_ACTIVE_INDICATOR (active_indicator_get_type ())
#define ACTIVE_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACTIVE_INDICATOR, ActiveIndicator))
#define ACTIVE_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACTIVE_INDICATOR, ActiveIndicatorClass))
#define IS_ACTIVE_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACTIVE_INDICATOR))
#define IS_ACTIVE_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACTIVE_INDICATOR))
#define ACTIVE_INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACTIVE_INDICATOR, ActiveIndicatorClass))

typedef struct _ActiveIndicator ActiveIndicator;
typedef struct _ActiveIndicatorClass ActiveIndicatorClass;

#define TYPE_CACHED_IMAGE (cached_image_get_type ())
#define CACHED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CACHED_IMAGE, CachedImage))
#define CACHED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CACHED_IMAGE, CachedImageClass))
#define IS_CACHED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CACHED_IMAGE))
#define IS_CACHED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CACHED_IMAGE))
#define CACHED_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CACHED_IMAGE, CachedImageClass))

typedef struct _CachedImage CachedImage;
typedef struct _CachedImageClass CachedImageClass;

#define PROMPT_BOX_TYPE_PROMPT_VISIBILITY (prompt_box_prompt_visibility_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_DASH_ENTRY (dash_entry_get_type ())
#define DASH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DASH_ENTRY, DashEntry))
#define DASH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DASH_ENTRY, DashEntryClass))
#define IS_DASH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DASH_ENTRY))
#define IS_DASH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DASH_ENTRY))
#define DASH_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DASH_ENTRY, DashEntryClass))

typedef struct _DashEntry DashEntry;
typedef struct _DashEntryClass DashEntryClass;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

#define TYPE_DASH_BUTTON (dash_button_get_type ())
#define DASH_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DASH_BUTTON, DashButton))
#define DASH_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DASH_BUTTON, DashButtonClass))
#define IS_DASH_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DASH_BUTTON))
#define IS_DASH_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DASH_BUTTON))
#define DASH_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DASH_BUTTON, DashButtonClass))

typedef struct _DashButton DashButton;
typedef struct _DashButtonClass DashButtonClass;
typedef struct _Block4Data Block4Data;
typedef struct _ActiveIndicatorPrivate ActiveIndicatorPrivate;

struct _FadableIface {
	GTypeInterface parent_iface;
	FadeTracker* (*get_fade_tracker) (Fadable* self);
	void (*set_fade_tracker) (Fadable* self, FadeTracker* value);
};

struct _FadableBox {
	GtkEventBox parent_instance;
	FadableBoxPrivate * priv;
};

struct _FadableBoxClass {
	GtkEventBoxClass parent_class;
	void (*draw_full_alpha) (FadableBox* self, cairo_t* c);
};

struct _PromptBox {
	FadableBox parent_instance;
	PromptBoxPrivate * priv;
	GtkGrid* box_grid;
	GtkGrid* name_grid;
	FadingLabel* name_label;
	FlatButton* option_button;
	GtkWidget* small_box_widget;
	FadingLabel* small_name_label;
	gint start_row;
	gint last_row;
};

struct _PromptBoxClass {
	FadableBoxClass parent_class;
	GtkGrid* (*create_name_grid) (PromptBox* self);
	GtkGrid* (*create_small_name_grid) (PromptBox* self);
	void (*set_start_row) (PromptBox* self);
	void (*reset_last_row) (PromptBox* self);
	void (*add_static_prompts) (PromptBox* self);
};

typedef enum  {
	PROMPT_BOX_PROMPT_VISIBILITY_HIDDEN,
	PROMPT_BOX_PROMPT_VISIBILITY_FADING,
	PROMPT_BOX_PROMPT_VISIBILITY_SHOWN
} PromptBoxPromptVisibility;

struct _PromptBoxPrivate {
	gboolean _has_errors;
	gchar* _id;
	gdouble _position;
	GtkFixed* fixed;
	GtkWidget* zone;
	ActiveIndicator* active_indicator;
	CachedImage* option_image;
	CachedImage* message_image;
	ActiveIndicator* small_active_indicator;
	CachedImage* small_message_image;
	PromptBoxPromptVisibility prompt_visibility;
};

struct _Block2Data {
	int _ref_count_;
	PromptBox * self;
	GtkComboBoxText* combo;
};

struct _Block3Data {
	int _ref_count_;
	PromptBox * self;
	gchar** response;
	gint response_length1;
	gint _response_size_;
};

struct _Block4Data {
	int _ref_count_;
	PromptBox * self;
	gboolean done;
	GtkWidget* best;
};

struct _ActiveIndicator {
	GtkImage parent_instance;
	ActiveIndicatorPrivate * priv;
};

struct _ActiveIndicatorClass {
	GtkImageClass parent_class;
};

struct _ActiveIndicatorPrivate {
	gboolean _active;
};


static gpointer prompt_box_parent_class = NULL;
extern gchar* dash_entry_font;
static gpointer active_indicator_parent_class = NULL;

GType fade_tracker_get_type (void) G_GNUC_CONST;
GType fadable_get_type (void) G_GNUC_CONST;
GType fadable_box_get_type (void) G_GNUC_CONST;
GType prompt_box_get_type (void) G_GNUC_CONST;
GType fading_label_get_type (void) G_GNUC_CONST;
GType flat_button_get_type (void) G_GNUC_CONST;
GType active_indicator_get_type (void) G_GNUC_CONST;
GType cached_image_get_type (void) G_GNUC_CONST;
static GType prompt_box_prompt_visibility_get_type (void) G_GNUC_UNUSED;
#define PROMPT_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROMPT_BOX, PromptBoxPrivate))
enum  {
	PROMPT_BOX_DUMMY_PROPERTY,
	PROMPT_BOX_HAS_ERRORS,
	PROMPT_BOX_ID,
	PROMPT_BOX_LABEL,
	PROMPT_BOX_POSITION
};
#define PROMPT_BOX_COL_ACTIVE 0
#define PROMPT_BOX_COL_CONTENT 1
#define PROMPT_BOX_COL_SPACER 2
#define PROMPT_BOX_ROW_NAME 0
#define PROMPT_BOX_COL_NAME_LABEL 0
#define PROMPT_BOX_COL_NAME_MESSAGE 1
#define PROMPT_BOX_COL_NAME_OPTIONS 2
#define PROMPT_BOX_COL_ENTRIES_START 1
#define PROMPT_BOX_COL_ENTRIES_END 1
#define PROMPT_BOX_COL_ENTRIES_WIDTH 1
PromptBox* prompt_box_new (const gchar* id);
PromptBox* prompt_box_construct (GType object_type, const gchar* id);
GtkGrid* prompt_box_create_name_grid (PromptBox* self);
static GtkGrid* prompt_box_real_create_name_grid (PromptBox* self);
FadingLabel* fading_label_new (const gchar* text);
FadingLabel* fading_label_construct (GType object_type, const gchar* text);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
#define grid_size 40
CachedImage* cached_image_new (GdkPixbuf* pixbuf);
CachedImage* cached_image_construct (GType object_type, GdkPixbuf* pixbuf);
FlatButton* flat_button_new (void);
FlatButton* flat_button_construct (GType object_type);
#define ACTIVE_INDICATOR_WIDTH 8
static void prompt_box_option_button_clicked_cb (PromptBox* self, GtkButton* button);
static void _prompt_box_option_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
GtkGrid* prompt_box_create_small_name_grid (PromptBox* self);
static GtkGrid* prompt_box_real_create_small_name_grid (PromptBox* self);
void prompt_box_set_start_row (PromptBox* self);
static void prompt_box_real_set_start_row (PromptBox* self);
void prompt_box_reset_last_row (PromptBox* self);
static void prompt_box_real_reset_last_row (PromptBox* self);
static gint prompt_box_round_to_grid (PromptBox* self, gint size);
static void prompt_box_real_get_preferred_height (GtkWidget* base, gint* min, gint* nat);
#define GREETER_LIST_BORDER 4
void prompt_box_set_zone (PromptBox* self, GtkWidget* zone);
void prompt_box_set_options_image (PromptBox* self, GdkPixbuf* image);
void prompt_box_set_show_message_icon (PromptBox* self, gboolean show);
void prompt_box_set_is_active (PromptBox* self, gboolean active);
void active_indicator_set_active (ActiveIndicator* self, gboolean value);
void prompt_box_foreach_prompt_widget (PromptBox* self, GtkCallback cb, void* cb_target);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void prompt_box_clear (PromptBox* self);
static void __lambda7_ (PromptBox* self, GtkWidget* w);
static void ___lambda7__gtk_callback (GtkWidget* widget, gpointer self);
void prompt_box_set_has_errors (PromptBox* self, gboolean value);
void prompt_box_reset_messages (PromptBox* self);
static void __lambda8_ (PromptBox* self, GtkWidget* w);
static void ___lambda8__gtk_callback (GtkWidget* widget, gpointer self);
void prompt_box_reset_spinners (PromptBox* self);
static void __lambda9_ (PromptBox* self, GtkWidget* w);
GType dash_entry_get_type (void) G_GNUC_CONST;
void dash_entry_set_did_respond (DashEntry* self, gboolean value);
static void ___lambda9__gtk_callback (GtkWidget* widget, gpointer self);
void prompt_box_reset_state (PromptBox* self);
void prompt_box_add_static_prompts (PromptBox* self);
static void prompt_box_real_add_static_prompts (PromptBox* self);
static void prompt_box_update_prompt_visibility (PromptBox* self, GtkWidget* w);
void fadable_fade_in (Fadable* self);
void prompt_box_fade_in_prompts (PromptBox* self);
static void __lambda10_ (PromptBox* self, GtkWidget* w);
static void ___lambda10__gtk_callback (GtkWidget* widget, gpointer self);
void prompt_box_show_prompts (PromptBox* self);
static void __lambda11_ (PromptBox* self, GtkWidget* w);
static void ___lambda11__gtk_callback (GtkWidget* widget, gpointer self);
void prompt_box_attach_item (PromptBox* self, GtkWidget* w, gboolean add_style_class);
void unity_greeter_add_style_class (GtkWidget* widget);
void prompt_box_add_message (PromptBox* self, const gchar* text, gboolean is_error);
DashEntry* prompt_box_add_prompt (PromptBox* self, const gchar* text, const gchar* accessible_text, gboolean is_secret);
static void __lambda12_ (PromptBox* self, GtkWidget* w);
void dash_entry_set_can_respond (DashEntry* self, gboolean value);
static void ___lambda12__gtk_callback (GtkWidget* widget, gpointer self);
DashEntry* dash_entry_new (void);
DashEntry* dash_entry_construct (GType object_type);
void dash_entry_set_constant_placeholder_text (DashEntry* self, const gchar* value);
void prompt_box_entry_activate_cb (PromptBox* self);
static void _prompt_box_entry_activate_cb_dash_entry_respond (DashEntry* _sender, gpointer self);
GtkComboBox* prompt_box_add_combo (PromptBox* self, GPtrArray* texts, gboolean read_only);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda14_ (Block2Data* _data2_, const gchar* text);
static void ___lambda14__gfunc (gconstpointer data, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda13_ (Block3Data* _data3_, GtkWidget* w);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void ___lambda13__gtk_callback (GtkWidget* widget, gpointer self);
void prompt_box_add_button (PromptBox* self, const gchar* text, const gchar* accessible_text);
DashButton* dash_button_new (const gchar* text);
DashButton* dash_button_construct (GType object_type, const gchar* text);
GType dash_button_get_type (void) G_GNUC_CONST;
static void prompt_box_button_clicked_cb (PromptBox* self, GtkButton* button);
static void _prompt_box_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void prompt_box_real_grab_focus (GtkWidget* base);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda15_ (Block4Data* _data4_, GtkWidget* w);
static void ___lambda15__gtk_callback (GtkWidget* widget, gpointer self);
static void prompt_box_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
static void prompt_box_real_draw_full_alpha (FadableBox* base, cairo_t* c);
gboolean prompt_box_get_has_errors (PromptBox* self);
const gchar* prompt_box_get_id (PromptBox* self);
static void prompt_box_set_id (PromptBox* self, const gchar* value);
const gchar* prompt_box_get_label (PromptBox* self);
void prompt_box_set_label (PromptBox* self, const gchar* value);
gdouble prompt_box_get_position (PromptBox* self);
void prompt_box_set_position (PromptBox* self, gdouble value);
static void g_cclosure_user_marshal_VOID__BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * prompt_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
ActiveIndicator* active_indicator_new (void);
ActiveIndicator* active_indicator_construct (GType object_type);
#define ACTIVE_INDICATOR_HEIGHT 7
static gboolean _prompt_box___lambda16_ (PromptBox* self);
static gboolean __prompt_box___lambda16__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void prompt_box_finalize (GObject* obj);
static void _vala_prompt_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_prompt_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define ACTIVE_INDICATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ACTIVE_INDICATOR, ActiveIndicatorPrivate))
enum  {
	ACTIVE_INDICATOR_DUMMY_PROPERTY,
	ACTIVE_INDICATOR_ACTIVE
};
static void active_indicator_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat);
static void active_indicator_real_get_preferred_height (GtkWidget* base, gint* min, gint* nat);
static gboolean active_indicator_real_draw (GtkWidget* base, cairo_t* c);
gboolean active_indicator_get_active (ActiveIndicator* self);
static GObject * active_indicator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _active_indicator___lambda6_ (ActiveIndicator* self);
static void __active_indicator___lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void active_indicator_finalize (GObject* obj);
static void _vala_active_indicator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_active_indicator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GType prompt_box_prompt_visibility_get_type (void) {
	static volatile gsize prompt_box_prompt_visibility_type_id__volatile = 0;
	if (g_once_init_enter (&prompt_box_prompt_visibility_type_id__volatile)) {
		static const GEnumValue values[] = {{PROMPT_BOX_PROMPT_VISIBILITY_HIDDEN, "PROMPT_BOX_PROMPT_VISIBILITY_HIDDEN", "hidden"}, {PROMPT_BOX_PROMPT_VISIBILITY_FADING, "PROMPT_BOX_PROMPT_VISIBILITY_FADING", "fading"}, {PROMPT_BOX_PROMPT_VISIBILITY_SHOWN, "PROMPT_BOX_PROMPT_VISIBILITY_SHOWN", "shown"}, {0, NULL, NULL}};
		GType prompt_box_prompt_visibility_type_id;
		prompt_box_prompt_visibility_type_id = g_enum_register_static ("PromptBoxPromptVisibility", values);
		g_once_init_leave (&prompt_box_prompt_visibility_type_id__volatile, prompt_box_prompt_visibility_type_id);
	}
	return prompt_box_prompt_visibility_type_id__volatile;
}


PromptBox* prompt_box_construct (GType object_type, const gchar* id) {
	PromptBox * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = id;
	self = (PromptBox*) g_object_new (object_type, "id", _tmp0_, NULL);
	return self;
}


PromptBox* prompt_box_new (const gchar* id) {
	return prompt_box_construct (TYPE_PROMPT_BOX, id);
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
	g_boxed_free (pango_font_description_get_type (), self);
}


static void _prompt_box_option_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	prompt_box_option_button_clicked_cb (self, _sender);
}


static GtkGrid* prompt_box_real_create_name_grid (PromptBox* self) {
	GtkGrid* result = NULL;
	GtkGrid* _tmp0_;
	GtkGrid* name_grid;
	FadingLabel* _tmp1_;
	FadingLabel* _tmp2_;
	PangoFontDescription* _tmp3_ = NULL;
	PangoFontDescription* _tmp4_;
	FadingLabel* _tmp5_;
	GdkRGBA _tmp6_ = {0};
	FadingLabel* _tmp7_;
	FadingLabel* _tmp8_;
	FadingLabel* _tmp9_;
	FadingLabel* _tmp10_;
	FadingLabel* _tmp11_;
	FadingLabel* _tmp12_;
	FadingLabel* _tmp13_;
	FadingLabel* _tmp14_;
	CachedImage* _tmp15_;
	GtkAlignment* _tmp25_;
	GtkAlignment* align;
	CachedImage* _tmp26_;
	FlatButton* _tmp27_;
	FlatButton* _tmp28_;
	FlatButton* _tmp29_;
	FlatButton* _tmp30_;
	FlatButton* _tmp31_;
	GtkGrid* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	FlatButton* _tmp35_;
	FlatButton* _tmp36_;
	FlatButton* _tmp37_;
	AtkObject* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	FlatButton* _tmp40_;
	CachedImage* _tmp41_;
	CachedImage* _tmp42_;
	FlatButton* _tmp48_;
	CachedImage* _tmp49_;
	FlatButton* _tmp50_;
	GError * _inner_error_ = NULL;
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	name_grid = _tmp0_;
	gtk_grid_set_column_spacing (name_grid, 4);
	gtk_widget_set_hexpand ((GtkWidget*) name_grid, TRUE);
	_tmp1_ = fading_label_new ("");
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->name_label);
	self->name_label = _tmp1_;
	_tmp2_ = self->name_label;
	_tmp3_ = pango_font_description_from_string ("Ubuntu 13");
	_tmp4_ = _tmp3_;
	gtk_widget_override_font ((GtkWidget*) _tmp2_, _tmp4_);
	__vala_PangoFontDescription_free0 (_tmp4_);
	_tmp5_ = self->name_label;
	_tmp6_.red = (gdouble) 1.0f;
	_tmp6_.green = (gdouble) 1.0f;
	_tmp6_.blue = (gdouble) 1.0f;
	_tmp6_.alpha = (gdouble) 1.0f;
	gtk_widget_override_color ((GtkWidget*) _tmp5_, GTK_STATE_FLAG_NORMAL, &_tmp6_);
	_tmp7_ = self->name_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp7_, GTK_ALIGN_START);
	_tmp8_ = self->name_label;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp8_, TRUE);
	_tmp9_ = self->name_label;
	g_object_set ((GtkMisc*) _tmp9_, "yalign", 0.5f, NULL);
	_tmp10_ = self->name_label;
	g_object_set ((GtkMisc*) _tmp10_, "xalign", 0.0f, NULL);
	_tmp11_ = self->name_label;
	gtk_widget_set_margin_left ((GtkWidget*) _tmp11_, 2);
	_tmp12_ = self->name_label;
	gtk_widget_set_size_request ((GtkWidget*) _tmp12_, -1, grid_size);
	_tmp13_ = self->name_label;
	gtk_widget_show ((GtkWidget*) _tmp13_);
	_tmp14_ = self->name_label;
	gtk_grid_attach (name_grid, (GtkWidget*) _tmp14_, PROMPT_BOX_COL_NAME_LABEL, PROMPT_BOX_ROW_NAME, 1, 1);
	_tmp15_ = cached_image_new (NULL);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->message_image);
	self->priv->message_image = _tmp15_;
	{
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		GdkPixbuf* _tmp18_;
		GdkPixbuf* _tmp19_;
		GdkPixbuf* _tmp20_;
		CachedImage* _tmp21_;
		GdkPixbuf* _tmp22_;
		_tmp16_ = g_build_filename (PKGDATADIR, "message.png", NULL, NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = gdk_pixbuf_new_from_file (_tmp17_, &_inner_error_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		_tmp20_ = _tmp19_;
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		_tmp21_ = self->priv->message_image;
		_tmp22_ = _tmp20_;
		g_object_set ((GtkImage*) _tmp21_, "pixbuf", _tmp22_, NULL);
		_g_object_unref0 (_tmp22_);
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_debug ("prompt-box.vala:193: Error loading message image: %s", _tmp24_);
		_g_error_free0 (e);
	}
	__finally18:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (name_grid);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp25_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 0.0f, 0.0f);
	g_object_ref_sink (_tmp25_);
	align = _tmp25_;
	gtk_widget_set_valign ((GtkWidget*) align, GTK_ALIGN_START);
	gtk_widget_set_size_request ((GtkWidget*) align, -1, grid_size);
	_tmp26_ = self->priv->message_image;
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) _tmp26_);
	gtk_widget_show ((GtkWidget*) align);
	gtk_grid_attach (name_grid, (GtkWidget*) align, PROMPT_BOX_COL_NAME_MESSAGE, PROMPT_BOX_ROW_NAME, 1, 1);
	_tmp27_ = flat_button_new ();
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->option_button);
	self->option_button = _tmp27_;
	_tmp28_ = self->option_button;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp28_, TRUE);
	_tmp29_ = self->option_button;
	gtk_widget_set_halign ((GtkWidget*) _tmp29_, GTK_ALIGN_END);
	_tmp30_ = self->option_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp30_, GTK_ALIGN_START);
	_tmp31_ = self->option_button;
	_tmp32_ = self->box_grid;
	_tmp33_ = gtk_grid_get_column_spacing (_tmp32_);
	_tmp34_ = _tmp33_;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp31_, ACTIVE_INDICATOR_WIDTH + _tmp34_);
	_tmp35_ = self->option_button;
	gtk_button_set_focus_on_click ((GtkButton*) _tmp35_, FALSE);
	_tmp36_ = self->option_button;
	gtk_button_set_relief ((GtkButton*) _tmp36_, GTK_RELIEF_NONE);
	_tmp37_ = self->option_button;
	_tmp38_ = gtk_widget_get_accessible ((GtkWidget*) _tmp37_);
	_tmp39_ = _ ("Session Options");
	atk_object_set_name (_tmp38_, _tmp39_);
	_tmp40_ = self->option_button;
	g_signal_connect_object ((GtkButton*) _tmp40_, "clicked", (GCallback) _prompt_box_option_button_clicked_cb_gtk_button_clicked, self, 0);
	_tmp41_ = cached_image_new (NULL);
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->option_image);
	self->priv->option_image = _tmp41_;
	_tmp42_ = self->priv->option_image;
	gtk_widget_show ((GtkWidget*) _tmp42_);
	{
		GtkCssProvider* _tmp43_;
		GtkCssProvider* style;
		FlatButton* _tmp44_;
		GtkStyleContext* _tmp45_ = NULL;
		_tmp43_ = gtk_css_provider_new ();
		style = _tmp43_;
		gtk_css_provider_load_from_data (style, "* {padding: 2px;}", (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (style);
			goto __catch19_g_error;
		}
		_tmp44_ = self->option_button;
		_tmp45_ = gtk_widget_get_style_context ((GtkWidget*) _tmp44_);
		gtk_style_context_add_provider (_tmp45_, (GtkStyleProvider*) style, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_g_object_unref0 (style);
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GError* _tmp46_;
		const gchar* _tmp47_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp46_ = e;
		_tmp47_ = _tmp46_->message;
		g_debug ("prompt-box.vala:223: Internal error loading session chooser style: %s", _tmp47_);
		_g_error_free0 (e);
	}
	__finally19:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (align);
		_g_object_unref0 (name_grid);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp48_ = self->option_button;
	_tmp49_ = self->priv->option_image;
	gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = self->option_button;
	gtk_grid_attach (name_grid, (GtkWidget*) _tmp50_, PROMPT_BOX_COL_NAME_OPTIONS, PROMPT_BOX_ROW_NAME, 1, 1);
	gtk_widget_show ((GtkWidget*) name_grid);
	result = name_grid;
	_g_object_unref0 (align);
	return result;
}


GtkGrid* prompt_box_create_name_grid (PromptBox* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return PROMPT_BOX_GET_CLASS (self)->create_name_grid (self);
}


static GtkGrid* prompt_box_real_create_small_name_grid (PromptBox* self) {
	GtkGrid* result = NULL;
	GtkGrid* _tmp0_;
	GtkGrid* small_name_grid;
	FadingLabel* _tmp1_;
	FadingLabel* _tmp2_;
	PangoFontDescription* _tmp3_ = NULL;
	PangoFontDescription* _tmp4_;
	FadingLabel* _tmp5_;
	GdkRGBA _tmp6_ = {0};
	FadingLabel* _tmp7_;
	FadingLabel* _tmp8_;
	FadingLabel* _tmp9_;
	FadingLabel* _tmp10_;
	FadingLabel* _tmp11_;
	FadingLabel* _tmp12_;
	CachedImage* _tmp13_;
	CachedImage* _tmp14_;
	CachedImage* _tmp15_;
	GdkPixbuf* _tmp16_ = NULL;
	GdkPixbuf* _tmp17_;
	GdkPixbuf* _tmp18_;
	GtkAlignment* _tmp19_;
	GtkAlignment* align;
	CachedImage* _tmp20_;
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	small_name_grid = _tmp0_;
	gtk_grid_set_column_spacing (small_name_grid, 4);
	_tmp1_ = fading_label_new ("");
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->small_name_label);
	self->small_name_label = _tmp1_;
	_tmp2_ = self->small_name_label;
	_tmp3_ = pango_font_description_from_string ("Ubuntu 13");
	_tmp4_ = _tmp3_;
	gtk_widget_override_font ((GtkWidget*) _tmp2_, _tmp4_);
	__vala_PangoFontDescription_free0 (_tmp4_);
	_tmp5_ = self->small_name_label;
	_tmp6_.red = (gdouble) 1.0f;
	_tmp6_.green = (gdouble) 1.0f;
	_tmp6_.blue = (gdouble) 1.0f;
	_tmp6_.alpha = (gdouble) 1.0f;
	gtk_widget_override_color ((GtkWidget*) _tmp5_, GTK_STATE_FLAG_NORMAL, &_tmp6_);
	_tmp7_ = self->small_name_label;
	g_object_set ((GtkMisc*) _tmp7_, "yalign", 0.5f, NULL);
	_tmp8_ = self->small_name_label;
	g_object_set ((GtkMisc*) _tmp8_, "xalign", 0.0f, NULL);
	_tmp9_ = self->small_name_label;
	gtk_widget_set_margin_left ((GtkWidget*) _tmp9_, 2);
	_tmp10_ = self->small_name_label;
	gtk_widget_set_size_request ((GtkWidget*) _tmp10_, -1, grid_size);
	_tmp11_ = self->small_name_label;
	gtk_widget_show ((GtkWidget*) _tmp11_);
	_tmp12_ = self->small_name_label;
	gtk_grid_attach (small_name_grid, (GtkWidget*) _tmp12_, 1, 0, 1, 1);
	_tmp13_ = cached_image_new (NULL);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->small_message_image);
	self->priv->small_message_image = _tmp13_;
	_tmp14_ = self->priv->small_message_image;
	_tmp15_ = self->priv->message_image;
	g_object_get ((GtkImage*) _tmp15_, "pixbuf", &_tmp16_, NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_;
	g_object_set ((GtkImage*) _tmp14_, "pixbuf", _tmp18_, NULL);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 0.0f, 0.0f);
	g_object_ref_sink (_tmp19_);
	align = _tmp19_;
	gtk_widget_set_size_request ((GtkWidget*) align, -1, grid_size);
	_tmp20_ = self->priv->small_message_image;
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) _tmp20_);
	gtk_widget_show ((GtkWidget*) align);
	gtk_grid_attach (small_name_grid, (GtkWidget*) align, 2, 0, 1, 1);
	gtk_widget_show ((GtkWidget*) small_name_grid);
	result = small_name_grid;
	_g_object_unref0 (align);
	return result;
}


GtkGrid* prompt_box_create_small_name_grid (PromptBox* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return PROMPT_BOX_GET_CLASS (self)->create_small_name_grid (self);
}


static void prompt_box_real_set_start_row (PromptBox* self) {
	self->start_row = 0;
}


void prompt_box_set_start_row (PromptBox* self) {
	g_return_if_fail (self != NULL);
	PROMPT_BOX_GET_CLASS (self)->set_start_row (self);
}


static void prompt_box_real_reset_last_row (PromptBox* self) {
	gint _tmp0_;
	_tmp0_ = self->start_row;
	self->last_row = _tmp0_;
}


void prompt_box_reset_last_row (PromptBox* self) {
	g_return_if_fail (self != NULL);
	PROMPT_BOX_GET_CLASS (self)->reset_last_row (self);
}


static gint prompt_box_round_to_grid (PromptBox* self, gint size) {
	gint result = 0;
	gint _tmp0_;
	gint num_grids;
	gint _tmp1_;
	gint remainder;
	gint _tmp2_;
	gint _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = size;
	num_grids = _tmp0_ / grid_size;
	_tmp1_ = size;
	remainder = _tmp1_ % grid_size;
	_tmp2_ = remainder;
	if (_tmp2_ > 0) {
		gint _tmp3_;
		_tmp3_ = num_grids;
		num_grids = _tmp3_ + 1;
	}
	_tmp4_ = num_grids;
	_tmp5_ = MAX (_tmp4_, 3);
	num_grids = _tmp5_;
	_tmp6_ = num_grids;
	result = _tmp6_ * grid_size;
	return result;
}


static void prompt_box_real_get_preferred_height (GtkWidget* base, gint* min, gint* nat) {
	PromptBox * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gint _tmp5_ = 0;
	self = (PromptBox*) base;
	GTK_WIDGET_CLASS (prompt_box_parent_class)->get_preferred_height ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FADABLE_BOX, FadableBox), &_tmp0_, &_tmp1_);
	_vala_min = _tmp0_;
	_vala_nat = _tmp1_;
	_tmp2_ = _vala_min;
	_tmp3_ = prompt_box_round_to_grid (self, _tmp2_ + (GREETER_LIST_BORDER * 2));
	_vala_min = _tmp3_ - (GREETER_LIST_BORDER * 2);
	_tmp4_ = _vala_nat;
	_tmp5_ = prompt_box_round_to_grid (self, _tmp4_ + (GREETER_LIST_BORDER * 2));
	_vala_nat = _tmp5_ - (GREETER_LIST_BORDER * 2);
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void prompt_box_set_zone (PromptBox* self, GtkWidget* zone) {
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (zone != NULL);
	_tmp0_ = zone;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->zone);
	self->priv->zone = _tmp1_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


void prompt_box_set_options_image (PromptBox* self, GdkPixbuf* image) {
	FlatButton* _tmp0_;
	CachedImage* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->option_button;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->option_image;
	_tmp2_ = image;
	g_object_set ((GtkImage*) _tmp1_, "pixbuf", _tmp2_, NULL);
	_tmp3_ = image;
	if (_tmp3_ == NULL) {
		FlatButton* _tmp4_;
		_tmp4_ = self->option_button;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
	} else {
		FlatButton* _tmp5_;
		_tmp5_ = self->option_button;
		gtk_widget_show ((GtkWidget*) _tmp5_);
	}
}


static void prompt_box_option_button_clicked_cb (PromptBox* self, GtkButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	g_signal_emit_by_name (self, "show-options");
}


void prompt_box_set_show_message_icon (PromptBox* self, gboolean show) {
	CachedImage* _tmp0_;
	gboolean _tmp1_;
	CachedImage* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->message_image;
	_tmp1_ = show;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, _tmp1_);
	_tmp2_ = self->priv->small_message_image;
	_tmp3_ = show;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, _tmp3_);
}


void prompt_box_set_is_active (PromptBox* self, gboolean active) {
	ActiveIndicator* _tmp0_;
	gboolean _tmp1_;
	ActiveIndicator* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->active_indicator;
	_tmp1_ = active;
	active_indicator_set_active (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->small_active_indicator;
	_tmp3_ = active;
	active_indicator_set_active (_tmp2_, _tmp3_);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void prompt_box_foreach_prompt_widget (PromptBox* self, GtkCallback cb, void* cb_target) {
	GList* prompt_widgets;
	gint _tmp0_;
	gint i;
	GList* _tmp11_;
	g_return_if_fail (self != NULL);
	prompt_widgets = NULL;
	_tmp0_ = self->start_row;
	i = _tmp0_ + 1;
	while (TRUE) {
		gint _tmp1_;
		gint _tmp2_;
		GtkGrid* _tmp3_;
		gint _tmp4_;
		GtkWidget* _tmp5_ = NULL;
		GtkWidget* _tmp6_;
		GtkWidget* c;
		GtkWidget* _tmp7_;
		gint _tmp10_;
		_tmp1_ = i;
		_tmp2_ = self->last_row;
		if (!(_tmp1_ <= _tmp2_)) {
			break;
		}
		_tmp3_ = self->box_grid;
		_tmp4_ = i;
		_tmp5_ = gtk_grid_get_child_at (_tmp3_, PROMPT_BOX_COL_ENTRIES_START, _tmp4_);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		c = _tmp6_;
		_tmp7_ = c;
		if (_tmp7_ != NULL) {
			GtkWidget* _tmp8_;
			GtkWidget* _tmp9_;
			_tmp8_ = c;
			_tmp9_ = _g_object_ref0 (_tmp8_);
			prompt_widgets = g_list_append (prompt_widgets, _tmp9_);
		}
		_tmp10_ = i;
		i = _tmp10_ + 1;
		_g_object_unref0 (c);
	}
	_tmp11_ = prompt_widgets;
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp11_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp12_;
			GtkWidget* w = NULL;
			_tmp12_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp12_;
			{
				GtkCallback _tmp13_;
				void* _tmp13__target;
				GtkWidget* _tmp14_;
				_tmp13_ = cb;
				_tmp13__target = cb_target;
				_tmp14_ = w;
				_tmp13_ (_tmp14_, _tmp13__target);
				_g_object_unref0 (w);
			}
		}
	}
	__g_list_free__g_object_unref0_0 (prompt_widgets);
}


static void __lambda7_ (PromptBox* self, GtkWidget* w) {
	GtkWidget* _tmp0_;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	gtk_widget_destroy (_tmp0_);
}


static void ___lambda7__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda7_ (self, widget);
}


void prompt_box_clear (PromptBox* self) {
	g_return_if_fail (self != NULL);
	self->priv->prompt_visibility = PROMPT_BOX_PROMPT_VISIBILITY_HIDDEN;
	prompt_box_foreach_prompt_widget (self, ___lambda7__gtk_callback, self);
	prompt_box_reset_last_row (self);
	prompt_box_set_has_errors (self, FALSE);
}


static void __lambda8_ (PromptBox* self, GtkWidget* w) {
	GtkWidget* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	gboolean is_error;
	gboolean _tmp2_;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "prompt-box-is-error");
	is_error = (gboolean) ((gintptr) _tmp1_);
	_tmp2_ = is_error;
	if (_tmp2_) {
		GtkWidget* _tmp3_;
		_tmp3_ = w;
		gtk_widget_destroy (_tmp3_);
	}
}


static void ___lambda8__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda8_ (self, widget);
}


void prompt_box_reset_messages (PromptBox* self) {
	g_return_if_fail (self != NULL);
	prompt_box_set_has_errors (self, FALSE);
	prompt_box_foreach_prompt_widget (self, ___lambda8__gtk_callback, self);
}


static void __lambda9_ (PromptBox* self, GtkWidget* w) {
	GtkWidget* _tmp0_;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_DASH_ENTRY)) {
		GtkWidget* _tmp1_;
		DashEntry* _tmp2_;
		DashEntry* e;
		DashEntry* _tmp3_;
		_tmp1_ = w;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TYPE_DASH_ENTRY) ? ((DashEntry*) _tmp1_) : NULL);
		e = _tmp2_;
		_tmp3_ = e;
		dash_entry_set_did_respond (_tmp3_, FALSE);
		_g_object_unref0 (e);
	}
}


static void ___lambda9__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda9_ (self, widget);
}


void prompt_box_reset_spinners (PromptBox* self) {
	g_return_if_fail (self != NULL);
	prompt_box_foreach_prompt_widget (self, ___lambda9__gtk_callback, self);
}


void prompt_box_reset_state (PromptBox* self) {
	g_return_if_fail (self != NULL);
	prompt_box_reset_messages (self);
	prompt_box_reset_spinners (self);
}


static void prompt_box_real_add_static_prompts (PromptBox* self) {
}


void prompt_box_add_static_prompts (PromptBox* self) {
	g_return_if_fail (self != NULL);
	PROMPT_BOX_GET_CLASS (self)->add_static_prompts (self);
}


static void prompt_box_update_prompt_visibility (PromptBox* self, GtkWidget* w) {
	PromptBoxPromptVisibility _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->prompt_visibility;
	switch (_tmp0_) {
		case PROMPT_BOX_PROMPT_VISIBILITY_HIDDEN:
		{
			GtkWidget* _tmp1_;
			_tmp1_ = w;
			gtk_widget_hide (_tmp1_);
			break;
		}
		case PROMPT_BOX_PROMPT_VISIBILITY_FADING:
		{
			GtkWidget* _tmp2_;
			Fadable* _tmp3_;
			Fadable* f;
			GtkWidget* _tmp4_;
			Fadable* _tmp5_;
			_tmp2_ = w;
			_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_FADABLE) ? ((Fadable*) _tmp2_) : NULL);
			f = _tmp3_;
			_tmp4_ = w;
			gtk_widget_set_sensitive (_tmp4_, TRUE);
			_tmp5_ = f;
			if (_tmp5_ != NULL) {
				Fadable* _tmp6_;
				_tmp6_ = f;
				fadable_fade_in (_tmp6_);
			} else {
				GtkWidget* _tmp7_;
				_tmp7_ = w;
				gtk_widget_show (_tmp7_);
			}
			_g_object_unref0 (f);
			break;
		}
		case PROMPT_BOX_PROMPT_VISIBILITY_SHOWN:
		{
			GtkWidget* _tmp8_;
			GtkWidget* _tmp9_;
			_tmp8_ = w;
			gtk_widget_show (_tmp8_);
			_tmp9_ = w;
			gtk_widget_set_sensitive (_tmp9_, TRUE);
			break;
		}
		default:
		break;
	}
}


static void __lambda10_ (PromptBox* self, GtkWidget* w) {
	GtkWidget* _tmp0_;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	prompt_box_update_prompt_visibility (self, _tmp0_);
}


static void ___lambda10__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda10_ (self, widget);
}


void prompt_box_fade_in_prompts (PromptBox* self) {
	g_return_if_fail (self != NULL);
	self->priv->prompt_visibility = PROMPT_BOX_PROMPT_VISIBILITY_FADING;
	gtk_widget_show ((GtkWidget*) self);
	prompt_box_foreach_prompt_widget (self, ___lambda10__gtk_callback, self);
}


static void __lambda11_ (PromptBox* self, GtkWidget* w) {
	GtkWidget* _tmp0_;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	prompt_box_update_prompt_visibility (self, _tmp0_);
}


static void ___lambda11__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda11_ (self, widget);
}


void prompt_box_show_prompts (PromptBox* self) {
	g_return_if_fail (self != NULL);
	self->priv->prompt_visibility = PROMPT_BOX_PROMPT_VISIBILITY_SHOWN;
	gtk_widget_show ((GtkWidget*) self);
	prompt_box_foreach_prompt_widget (self, ___lambda11__gtk_callback, self);
}


void prompt_box_attach_item (PromptBox* self, GtkWidget* w, gboolean add_style_class) {
	GtkWidget* _tmp0_;
	PromptBox* _tmp1_;
	gboolean _tmp2_;
	gint _tmp4_;
	GtkGrid* _tmp5_;
	GtkWidget* _tmp6_;
	gint _tmp7_;
	GtkWidget* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	_tmp1_ = _g_object_ref0 (self);
	g_object_set_data_full ((GObject*) _tmp0_, "prompt-box-widget", _tmp1_, g_object_unref);
	_tmp2_ = add_style_class;
	if (_tmp2_) {
		GtkWidget* _tmp3_;
		_tmp3_ = w;
		unity_greeter_add_style_class (_tmp3_);
	}
	_tmp4_ = self->last_row;
	self->last_row = _tmp4_ + 1;
	_tmp5_ = self->box_grid;
	_tmp6_ = w;
	_tmp7_ = self->last_row;
	gtk_grid_attach (_tmp5_, _tmp6_, PROMPT_BOX_COL_ENTRIES_START, _tmp7_, PROMPT_BOX_COL_ENTRIES_WIDTH, 1);
	_tmp8_ = w;
	prompt_box_update_prompt_visibility (self, _tmp8_);
	gtk_widget_queue_resize ((GtkWidget*) self);
}


void prompt_box_add_message (PromptBox* self, const gchar* text, gboolean is_error) {
	const gchar* _tmp0_;
	FadingLabel* _tmp1_;
	FadingLabel* label;
	FadingLabel* _tmp2_;
	PangoFontDescription* _tmp3_ = NULL;
	PangoFontDescription* _tmp4_;
	GdkRGBA _tmp5_ = {0};
	GdkRGBA color;
	gboolean _tmp6_;
	FadingLabel* _tmp7_;
	GdkRGBA _tmp8_;
	FadingLabel* _tmp9_;
	FadingLabel* _tmp10_;
	gboolean _tmp11_;
	FadingLabel* _tmp12_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	_tmp1_ = fading_label_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	label = _tmp1_;
	_tmp2_ = label;
	_tmp3_ = pango_font_description_from_string ("Ubuntu 10");
	_tmp4_ = _tmp3_;
	gtk_widget_override_font ((GtkWidget*) _tmp2_, _tmp4_);
	__vala_PangoFontDescription_free0 (_tmp4_);
	_tmp5_.red = (gdouble) 1.0f;
	_tmp5_.green = (gdouble) 1.0f;
	_tmp5_.blue = (gdouble) 1.0f;
	_tmp5_.alpha = (gdouble) 1.0f;
	color = _tmp5_;
	_tmp6_ = is_error;
	if (_tmp6_) {
		gdk_rgba_parse (&color, "#df382c");
	}
	_tmp7_ = label;
	_tmp8_ = color;
	gtk_widget_override_color ((GtkWidget*) _tmp7_, GTK_STATE_FLAG_NORMAL, &_tmp8_);
	_tmp9_ = label;
	g_object_set ((GtkMisc*) _tmp9_, "xalign", 0.0f, NULL);
	_tmp10_ = label;
	_tmp11_ = is_error;
	g_object_set_data_full ((GObject*) _tmp10_, "prompt-box-is-error", (gpointer) ((gintptr) _tmp11_), NULL);
	_tmp12_ = label;
	prompt_box_attach_item (self, (GtkWidget*) _tmp12_, TRUE);
	_tmp13_ = is_error;
	if (_tmp13_) {
		prompt_box_set_has_errors (self, TRUE);
	}
	_g_object_unref0 (label);
}


static void __lambda12_ (PromptBox* self, GtkWidget* w) {
	GtkWidget* _tmp0_;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_DASH_ENTRY)) {
		GtkWidget* _tmp1_;
		DashEntry* _tmp2_;
		DashEntry* e;
		DashEntry* _tmp3_;
		_tmp1_ = w;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TYPE_DASH_ENTRY) ? ((DashEntry*) _tmp1_) : NULL);
		e = _tmp2_;
		_tmp3_ = e;
		if (_tmp3_ != NULL) {
			DashEntry* _tmp4_;
			_tmp4_ = e;
			dash_entry_set_can_respond (_tmp4_, FALSE);
		}
		_g_object_unref0 (e);
	}
}


static void ___lambda12__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda12_ (self, widget);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


static void _prompt_box_entry_activate_cb_dash_entry_respond (DashEntry* _sender, gpointer self) {
	prompt_box_entry_activate_cb (self);
}


DashEntry* prompt_box_add_prompt (PromptBox* self, const gchar* text, const gchar* accessible_text, gboolean is_secret) {
	DashEntry* result = NULL;
	DashEntry* _tmp0_;
	DashEntry* entry;
	DashEntry* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	DashEntry* _tmp23_;
	AtkObject* _tmp24_ = NULL;
	AtkObject* _tmp25_;
	AtkObject* accessible;
	const gchar* _tmp26_;
	gboolean _tmp31_;
	DashEntry* _tmp34_;
	DashEntry* _tmp35_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	prompt_box_foreach_prompt_widget (self, ___lambda12__gtk_callback, self);
	_tmp0_ = dash_entry_new ();
	g_object_ref_sink (_tmp0_);
	entry = _tmp0_;
	_tmp1_ = entry;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
	_tmp2_ = text;
	_tmp3_ = string_contains (_tmp2_, "\n");
	if (_tmp3_) {
		const gchar* _tmp4_;
		DashEntry* _tmp5_;
		_tmp4_ = text;
		prompt_box_add_message (self, _tmp4_, FALSE);
		_tmp5_ = entry;
		dash_entry_set_constant_placeholder_text (_tmp5_, "");
	} else {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* placeholder;
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp13_;
		DashEntry* _tmp21_;
		const gchar* _tmp22_;
		_tmp6_ = text;
		_tmp7_ = g_strdup (_tmp6_);
		placeholder = _tmp7_;
		_tmp9_ = placeholder;
		_tmp10_ = g_str_has_suffix (_tmp9_, ":");
		if (_tmp10_) {
			_tmp8_ = TRUE;
		} else {
			const gchar* _tmp11_;
			gboolean _tmp12_ = FALSE;
			_tmp11_ = placeholder;
			_tmp12_ = g_str_has_suffix (_tmp11_, "：");
			_tmp8_ = _tmp12_;
		}
		_tmp13_ = _tmp8_;
		if (_tmp13_) {
			const gchar* _tmp14_;
			gint _tmp15_ = 0;
			gint len;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gint _tmp18_;
			gint _tmp19_ = 0;
			gchar* _tmp20_ = NULL;
			_tmp14_ = placeholder;
			_tmp15_ = g_utf8_strlen (_tmp14_, (gssize) (-1));
			len = _tmp15_;
			_tmp16_ = placeholder;
			_tmp17_ = placeholder;
			_tmp18_ = len;
			_tmp19_ = string_index_of_nth_char (_tmp17_, (glong) (_tmp18_ - 1));
			_tmp20_ = string_substring (_tmp16_, (glong) 0, (glong) _tmp19_);
			_g_free0 (placeholder);
			placeholder = _tmp20_;
		}
		_tmp21_ = entry;
		_tmp22_ = placeholder;
		dash_entry_set_constant_placeholder_text (_tmp21_, _tmp22_);
		_g_free0 (placeholder);
	}
	_tmp23_ = entry;
	_tmp24_ = gtk_widget_get_accessible ((GtkWidget*) _tmp23_);
	_tmp25_ = _g_object_ref0 (_tmp24_);
	accessible = _tmp25_;
	_tmp26_ = accessible_text;
	if (_tmp26_ != NULL) {
		AtkObject* _tmp27_;
		const gchar* _tmp28_;
		_tmp27_ = accessible;
		_tmp28_ = accessible_text;
		atk_object_set_name (_tmp27_, _tmp28_);
	} else {
		AtkObject* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = accessible;
		_tmp30_ = text;
		atk_object_set_name (_tmp29_, _tmp30_);
	}
	_tmp31_ = is_secret;
	if (_tmp31_) {
		DashEntry* _tmp32_;
		DashEntry* _tmp33_;
		_tmp32_ = entry;
		gtk_entry_set_visibility ((GtkEntry*) _tmp32_, FALSE);
		_tmp33_ = entry;
		g_object_set ((GtkEntry*) _tmp33_, "caps-lock-warning", TRUE, NULL);
	}
	_tmp34_ = entry;
	g_signal_connect_object (_tmp34_, "respond", (GCallback) _prompt_box_entry_activate_cb_dash_entry_respond, self, 0);
	_tmp35_ = entry;
	prompt_box_attach_item (self, (GtkWidget*) _tmp35_, TRUE);
	result = entry;
	_g_object_unref0 (accessible);
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		PromptBox * self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->combo);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda14_ (Block2Data* _data2_, const gchar* text) {
	PromptBox * self;
	GtkComboBoxText* _tmp0_;
	const gchar* _tmp1_;
	self = _data2_->self;
	g_return_if_fail (text != NULL);
	_tmp0_ = _data2_->combo;
	_tmp1_ = text;
	gtk_combo_box_text_append_text (_tmp0_, _tmp1_);
}


static void ___lambda14__gfunc (gconstpointer data, gpointer self) {
	__lambda14_ (self, data);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


GtkComboBox* prompt_box_add_combo (PromptBox* self, GPtrArray* texts, gboolean read_only) {
	GtkComboBox* result = NULL;
	Block2Data* _data2_;
	gboolean _tmp0_;
	GtkComboBoxText* _tmp3_;
	GtkStyleContext* _tmp4_ = NULL;
	GtkComboBoxText* _tmp5_;
	GtkWidget* _tmp6_ = NULL;
	GtkStyleContext* _tmp7_ = NULL;
	GtkComboBoxText* _tmp8_;
	GtkWidget* _tmp9_ = NULL;
	const gchar* _tmp10_;
	PangoFontDescription* _tmp11_ = NULL;
	PangoFontDescription* _tmp12_;
	GtkComboBoxText* _tmp13_;
	GPtrArray* _tmp14_;
	GPtrArray* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GtkComboBoxText* _tmp19_;
	GtkComboBox* _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (texts != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = read_only;
	if (_tmp0_) {
		GtkComboBoxText* _tmp1_;
		_tmp1_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (_data2_->combo);
		_data2_->combo = _tmp1_;
	} else {
		GtkComboBoxText* _tmp2_;
		_tmp2_ = (GtkComboBoxText*) gtk_combo_box_text_new_with_entry ();
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (_data2_->combo);
		_data2_->combo = _tmp2_;
	}
	_tmp3_ = _data2_->combo;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_add_class (_tmp4_, "lightdm-combo");
	_tmp5_ = _data2_->combo;
	_tmp6_ = gtk_bin_get_child ((GtkBin*) _tmp5_);
	_tmp7_ = gtk_widget_get_style_context (_tmp6_);
	gtk_style_context_add_class (_tmp7_, "lightdm-combo");
	_tmp8_ = _data2_->combo;
	_tmp9_ = gtk_bin_get_child ((GtkBin*) _tmp8_);
	_tmp10_ = dash_entry_font;
	_tmp11_ = pango_font_description_from_string (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_widget_override_font (_tmp9_, _tmp12_);
	__vala_PangoFontDescription_free0 (_tmp12_);
	_tmp13_ = _data2_->combo;
	prompt_box_attach_item (self, (GtkWidget*) _tmp13_, FALSE);
	_tmp14_ = texts;
	g_ptr_array_foreach (_tmp14_, ___lambda14__gfunc, _data2_);
	_tmp15_ = texts;
	_tmp16_ = g_ptr_array_get_length (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ > 0) {
		GtkComboBoxText* _tmp18_;
		_tmp18_ = _data2_->combo;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp18_, 0);
	}
	_tmp19_ = _data2_->combo;
	_tmp20_ = _g_object_ref0 ((GtkComboBox*) _tmp19_);
	result = _tmp20_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		PromptBox * self;
		self = _data3_->self;
		_data3_->response = (_vala_array_free (_data3_->response, _data3_->response_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void __lambda13_ (Block3Data* _data3_, GtkWidget* w) {
	PromptBox * self;
	GtkWidget* _tmp0_;
	self = _data3_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_ENTRY)) {
		GtkWidget* _tmp1_;
		GtkEntry* _tmp2_;
		GtkEntry* e;
		GtkEntry* _tmp3_;
		_tmp1_ = w;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp1_) : NULL);
		e = _tmp2_;
		_tmp3_ = e;
		if (_tmp3_ != NULL) {
			GtkEntry* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp4_ = e;
			_tmp5_ = gtk_entry_get_text (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strdup (_tmp6_);
			_vala_array_add1 (&_data3_->response, &_data3_->response_length1, &_data3_->_response_size_, _tmp7_);
		}
		_g_object_unref0 (e);
	}
}


static void ___lambda13__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda13_ (self, widget);
}


void prompt_box_entry_activate_cb (PromptBox* self) {
	Block3Data* _data3_;
	gchar** _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data3_->response = _tmp0_;
	_data3_->response_length1 = 0;
	_data3_->_response_size_ = _data3_->response_length1;
	prompt_box_foreach_prompt_widget (self, ___lambda13__gtk_callback, _data3_);
	g_signal_emit_by_name (self, "respond", _data3_->response, _data3_->response_length1);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void _prompt_box_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	prompt_box_button_clicked_cb (self, _sender);
}


void prompt_box_add_button (PromptBox* self, const gchar* text, const gchar* accessible_text) {
	const gchar* _tmp0_;
	DashButton* _tmp1_;
	DashButton* button;
	AtkObject* _tmp2_ = NULL;
	AtkObject* _tmp3_;
	AtkObject* accessible;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	_tmp1_ = dash_button_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	button = _tmp1_;
	_tmp2_ = gtk_widget_get_accessible ((GtkWidget*) button);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	accessible = _tmp3_;
	_tmp4_ = accessible_text;
	atk_object_set_name (accessible, _tmp4_);
	g_signal_connect_object ((GtkButton*) button, "clicked", (GCallback) _prompt_box_button_clicked_cb_gtk_button_clicked, self, 0);
	prompt_box_attach_item (self, (GtkWidget*) button, TRUE);
	_g_object_unref0 (accessible);
	_g_object_unref0 (button);
}


static void prompt_box_button_clicked_cb (PromptBox* self, GtkButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	g_signal_emit_by_name (self, "login");
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		PromptBox * self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->best);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void __lambda15_ (Block4Data* _data4_, GtkWidget* w) {
	PromptBox * self;
	gboolean _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* e;
	GtkWidget* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* b;
	GtkWidget* _tmp7_;
	GtkComboBox* _tmp8_;
	GtkComboBox* c;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GtkEntry* _tmp12_;
	gboolean _tmp16_;
	gboolean _tmp18_;
	gboolean _tmp20_;
	self = _data4_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = _data4_->done;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = w;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data4_->best);
	_data4_->best = _tmp2_;
	_tmp3_ = w;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp3_) : NULL);
	e = _tmp4_;
	_tmp5_ = w;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp5_) : NULL);
	b = _tmp6_;
	_tmp7_ = w;
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GTK_TYPE_COMBO_BOX) ? ((GtkComboBox*) _tmp7_) : NULL);
	c = _tmp8_;
	_tmp12_ = e;
	if (_tmp12_ != NULL) {
		GtkEntry* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = e;
		_tmp14_ = gtk_entry_get_text (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp11_ = g_strcmp0 (_tmp15_, "") == 0;
	} else {
		_tmp11_ = FALSE;
	}
	_tmp16_ = _tmp11_;
	if (_tmp16_) {
		_tmp10_ = TRUE;
	} else {
		GtkButton* _tmp17_;
		_tmp17_ = b;
		_tmp10_ = _tmp17_ != NULL;
	}
	_tmp18_ = _tmp10_;
	if (_tmp18_) {
		_tmp9_ = TRUE;
	} else {
		GtkComboBox* _tmp19_;
		_tmp19_ = c;
		_tmp9_ = _tmp19_ != NULL;
	}
	_tmp20_ = _tmp9_;
	if (_tmp20_) {
		_data4_->done = TRUE;
	}
	_g_object_unref0 (c);
	_g_object_unref0 (b);
	_g_object_unref0 (e);
}


static void ___lambda15__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda15_ (self, widget);
}


static void prompt_box_real_grab_focus (GtkWidget* base) {
	PromptBox * self;
	Block4Data* _data4_;
	GtkWidget* _tmp0_;
	self = (PromptBox*) base;
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->done = FALSE;
	_data4_->best = NULL;
	prompt_box_foreach_prompt_widget (self, ___lambda15__gtk_callback, _data4_);
	_tmp0_ = _data4_->best;
	if (_tmp0_ != NULL) {
		GtkWidget* _tmp1_;
		_tmp1_ = _data4_->best;
		gtk_widget_grab_focus (_tmp1_);
	}
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static void prompt_box_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	PromptBox * self;
	GtkAllocation _tmp0_;
	GtkGrid* _tmp1_;
	GtkAllocation _tmp2_;
	gint small_height = 0;
	GtkWidget* _tmp3_;
	gint _tmp4_ = 0;
	GtkWidget* _tmp5_;
	GtkAllocation _tmp6_;
	self = (PromptBox*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (prompt_box_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FADABLE_BOX, FadableBox), &_tmp0_);
	_tmp1_ = self->box_grid;
	_tmp2_ = *allocation;
	gtk_widget_size_allocate ((GtkWidget*) _tmp1_, &_tmp2_);
	_tmp3_ = self->small_box_widget;
	gtk_widget_get_preferred_height (_tmp3_, NULL, &_tmp4_);
	small_height = _tmp4_;
	(*allocation).height = small_height;
	_tmp5_ = self->small_box_widget;
	_tmp6_ = *allocation;
	gtk_widget_size_allocate (_tmp5_, &_tmp6_);
}


static void prompt_box_real_draw_full_alpha (FadableBox* base, cairo_t* c) {
	PromptBox * self;
	gint x = 0;
	gint y = 0;
	GtkWidget* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkAllocation alloc = {0};
	GtkAllocation zone_alloc = {0};
	GtkAllocation _tmp3_ = {0};
	GtkWidget* _tmp4_;
	GtkAllocation _tmp5_ = {0};
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GtkAllocation _tmp10_;
	gint _tmp11_;
	GtkAllocation _tmp12_;
	gint _tmp13_;
	cairo_t* _tmp14_;
	GtkFixed* _tmp15_;
	GtkGrid* _tmp16_;
	cairo_t* _tmp17_;
	cairo_t* _tmp18_;
	cairo_t* _tmp19_;
	gint _tmp20_;
	cairo_t* _tmp34_;
	GtkFixed* _tmp35_;
	GtkWidget* _tmp36_;
	cairo_t* _tmp37_;
	cairo_t* _tmp38_;
	self = (PromptBox*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->zone;
	gtk_widget_translate_coordinates (_tmp0_, (GtkWidget*) self, 0, 0, &_tmp1_, &_tmp2_);
	x = _tmp1_;
	y = _tmp2_;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp3_);
	alloc = _tmp3_;
	_tmp4_ = self->priv->zone;
	gtk_widget_get_allocation (_tmp4_, &_tmp5_);
	zone_alloc = _tmp5_;
	_tmp6_ = c;
	cairo_save (_tmp6_);
	_tmp7_ = c;
	_tmp8_ = x;
	_tmp9_ = y;
	_tmp10_ = zone_alloc;
	_tmp11_ = _tmp10_.width;
	_tmp12_ = zone_alloc;
	_tmp13_ = _tmp12_.height;
	cairo_rectangle (_tmp7_, (gdouble) _tmp8_, (gdouble) _tmp9_, (gdouble) _tmp11_, (gdouble) _tmp13_);
	_tmp14_ = c;
	cairo_clip (_tmp14_);
	_tmp15_ = self->priv->fixed;
	_tmp16_ = self->box_grid;
	_tmp17_ = c;
	gtk_container_propagate_draw ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_, _tmp17_);
	_tmp18_ = c;
	cairo_restore (_tmp18_);
	_tmp19_ = c;
	cairo_save (_tmp19_);
	_tmp20_ = y;
	if (_tmp20_ > 0) {
		cairo_t* _tmp21_;
		gint _tmp22_;
		GtkAllocation _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		_tmp21_ = c;
		_tmp22_ = x;
		_tmp23_ = zone_alloc;
		_tmp24_ = _tmp23_.width;
		_tmp25_ = y;
		cairo_rectangle (_tmp21_, (gdouble) _tmp22_, (gdouble) 0, (gdouble) _tmp24_, (gdouble) _tmp25_);
	} else {
		cairo_t* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		GtkAllocation _tmp29_;
		gint _tmp30_;
		GtkAllocation _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		_tmp26_ = c;
		_tmp27_ = x;
		_tmp28_ = y;
		_tmp29_ = zone_alloc;
		_tmp30_ = _tmp29_.height;
		_tmp31_ = zone_alloc;
		_tmp32_ = _tmp31_.width;
		_tmp33_ = y;
		cairo_rectangle (_tmp26_, (gdouble) _tmp27_, (gdouble) (_tmp28_ + _tmp30_), (gdouble) _tmp32_, (gdouble) (-_tmp33_));
	}
	_tmp34_ = c;
	cairo_clip (_tmp34_);
	_tmp35_ = self->priv->fixed;
	_tmp36_ = self->small_box_widget;
	_tmp37_ = c;
	gtk_container_propagate_draw ((GtkContainer*) _tmp35_, _tmp36_, _tmp37_);
	_tmp38_ = c;
	cairo_restore (_tmp38_);
}


gboolean prompt_box_get_has_errors (PromptBox* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_errors;
	result = _tmp0_;
	return result;
}


void prompt_box_set_has_errors (PromptBox* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_has_errors = _tmp0_;
	g_object_notify ((GObject *) self, "has-errors");
}


const gchar* prompt_box_get_id (PromptBox* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void prompt_box_set_id (PromptBox* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp1_;
	g_object_notify ((GObject *) self, "id");
}


const gchar* prompt_box_get_label (PromptBox* self) {
	const gchar* result;
	FadingLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name_label;
	_tmp1_ = gtk_label_get_label ((GtkLabel*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void prompt_box_set_label (PromptBox* self, const gchar* value) {
	FadingLabel* _tmp0_;
	const gchar* _tmp1_;
	FadingLabel* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->name_label;
	_tmp1_ = value;
	gtk_label_set_label ((GtkLabel*) _tmp0_, _tmp1_);
	_tmp2_ = self->small_name_label;
	_tmp3_ = value;
	gtk_label_set_label ((GtkLabel*) _tmp2_, _tmp3_);
	g_object_notify ((GObject *) self, "label");
}


gdouble prompt_box_get_position (PromptBox* self) {
	gdouble result;
	gdouble _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_position;
	result = _tmp0_;
	return result;
}


void prompt_box_set_position (PromptBox* self, gdouble value) {
	gdouble _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_position = _tmp0_;
	g_object_notify ((GObject *) self, "position");
}


static void g_cclosure_user_marshal_VOID__BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static gboolean _prompt_box___lambda16_ (PromptBox* self) {
	gboolean result = FALSE;
	g_signal_emit_by_name (self, "name-clicked");
	result = TRUE;
	return result;
}


static gboolean __prompt_box___lambda16__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _prompt_box___lambda16_ (self);
	return result;
}


static GObject * prompt_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	PromptBox * self;
	GtkFixed* _tmp0_;
	GtkFixed* _tmp1_;
	GtkFixed* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	ActiveIndicator* _tmp9_;
	ActiveIndicator* _tmp10_;
	ActiveIndicator* _tmp11_;
	ActiveIndicator* _tmp12_;
	GtkGrid* _tmp13_;
	ActiveIndicator* _tmp14_;
	gint _tmp15_;
	ActiveIndicator* _tmp16_;
	ActiveIndicator* dummy_indicator;
	ActiveIndicator* _tmp17_;
	GtkGrid* _tmp18_;
	ActiveIndicator* _tmp19_;
	gint _tmp20_;
	GtkGrid* _tmp21_;
	GtkGrid* _tmp22_ = NULL;
	GtkGrid* _tmp23_;
	GtkGrid* _tmp24_;
	gint _tmp25_;
	GtkGrid* _tmp26_;
	GtkGrid* small_box_grid;
	GtkGrid* _tmp27_;
	GtkGrid* _tmp28_;
	GtkGrid* _tmp29_;
	GtkGrid* _tmp30_;
	ActiveIndicator* _tmp31_;
	ActiveIndicator* _tmp32_;
	ActiveIndicator* _tmp33_;
	ActiveIndicator* _tmp34_;
	GtkGrid* _tmp35_;
	ActiveIndicator* _tmp36_;
	GtkGrid* _tmp37_ = NULL;
	GtkGrid* small_name_grid;
	GtkGrid* _tmp38_;
	GtkGrid* _tmp39_;
	ActiveIndicator* _tmp40_;
	ActiveIndicator* small_dummy_indicator;
	ActiveIndicator* _tmp41_;
	GtkGrid* _tmp42_;
	ActiveIndicator* _tmp43_;
	GtkEventBox* _tmp44_;
	GtkEventBox* small_box_eventbox;
	GtkEventBox* _tmp45_;
	GtkEventBox* _tmp46_;
	GtkEventBox* _tmp47_;
	GtkGrid* _tmp48_;
	GtkEventBox* _tmp49_;
	GtkEventBox* _tmp50_;
	GtkWidget* _tmp51_;
	GtkFixed* _tmp52_;
	GtkWidget* _tmp53_;
	GtkFixed* _tmp54_;
	GtkGrid* _tmp55_;
	parent_class = G_OBJECT_CLASS (prompt_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROMPT_BOX, PromptBox);
	prompt_box_set_start_row (self);
	prompt_box_reset_last_row (self);
	g_object_set ((GtkWidget*) self, "expand", TRUE, NULL);
	_tmp0_ = (GtkFixed*) gtk_fixed_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->fixed);
	self->priv->fixed = _tmp0_;
	_tmp1_ = self->priv->fixed;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->fixed;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->box_grid);
	self->box_grid = _tmp3_;
	_tmp4_ = self->box_grid;
	gtk_grid_set_column_spacing (_tmp4_, 4);
	_tmp5_ = self->box_grid;
	gtk_grid_set_row_spacing (_tmp5_, 3);
	_tmp6_ = self->box_grid;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp6_, GREETER_LIST_BORDER);
	_tmp7_ = self->box_grid;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp7_, 6);
	_tmp8_ = self->box_grid;
	g_object_set ((GtkWidget*) _tmp8_, "expand", TRUE, NULL);
	_tmp9_ = active_indicator_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->active_indicator);
	self->priv->active_indicator = _tmp9_;
	_tmp10_ = self->priv->active_indicator;
	gtk_widget_set_valign ((GtkWidget*) _tmp10_, GTK_ALIGN_START);
	_tmp11_ = self->priv->active_indicator;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp11_, (grid_size - ACTIVE_INDICATOR_HEIGHT) / 2);
	_tmp12_ = self->priv->active_indicator;
	gtk_widget_show ((GtkWidget*) _tmp12_);
	_tmp13_ = self->box_grid;
	_tmp14_ = self->priv->active_indicator;
	_tmp15_ = self->last_row;
	gtk_grid_attach (_tmp13_, (GtkWidget*) _tmp14_, PROMPT_BOX_COL_ACTIVE, _tmp15_, 1, 1);
	_tmp16_ = active_indicator_new ();
	g_object_ref_sink (_tmp16_);
	dummy_indicator = _tmp16_;
	_tmp17_ = dummy_indicator;
	gtk_widget_show ((GtkWidget*) _tmp17_);
	_tmp18_ = self->box_grid;
	_tmp19_ = dummy_indicator;
	_tmp20_ = self->last_row;
	gtk_grid_attach (_tmp18_, (GtkWidget*) _tmp19_, PROMPT_BOX_COL_SPACER, _tmp20_, 1, 1);
	_tmp21_ = self->box_grid;
	gtk_widget_show ((GtkWidget*) _tmp21_);
	_tmp22_ = prompt_box_create_name_grid (self);
	_g_object_unref0 (self->name_grid);
	self->name_grid = _tmp22_;
	_tmp23_ = self->box_grid;
	_tmp24_ = self->name_grid;
	_tmp25_ = self->last_row;
	gtk_grid_attach (_tmp23_, (GtkWidget*) _tmp24_, PROMPT_BOX_COL_CONTENT, _tmp25_, 1, 1);
	_tmp26_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp26_);
	small_box_grid = _tmp26_;
	_tmp27_ = small_box_grid;
	gtk_grid_set_column_spacing (_tmp27_, 4);
	_tmp28_ = small_box_grid;
	gtk_grid_set_row_spacing (_tmp28_, 6);
	_tmp29_ = small_box_grid;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp29_, TRUE);
	_tmp30_ = small_box_grid;
	gtk_widget_show ((GtkWidget*) _tmp30_);
	_tmp31_ = active_indicator_new ();
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->small_active_indicator);
	self->priv->small_active_indicator = _tmp31_;
	_tmp32_ = self->priv->small_active_indicator;
	gtk_widget_set_valign ((GtkWidget*) _tmp32_, GTK_ALIGN_START);
	_tmp33_ = self->priv->small_active_indicator;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp33_, (grid_size - ACTIVE_INDICATOR_HEIGHT) / 2);
	_tmp34_ = self->priv->small_active_indicator;
	gtk_widget_show ((GtkWidget*) _tmp34_);
	_tmp35_ = small_box_grid;
	_tmp36_ = self->priv->small_active_indicator;
	gtk_grid_attach (_tmp35_, (GtkWidget*) _tmp36_, 0, 0, 1, 1);
	_tmp37_ = prompt_box_create_small_name_grid (self);
	small_name_grid = _tmp37_;
	_tmp38_ = small_box_grid;
	_tmp39_ = small_name_grid;
	gtk_grid_attach (_tmp38_, (GtkWidget*) _tmp39_, 1, 0, 1, 1);
	_tmp40_ = active_indicator_new ();
	g_object_ref_sink (_tmp40_);
	small_dummy_indicator = _tmp40_;
	_tmp41_ = small_dummy_indicator;
	gtk_widget_show ((GtkWidget*) _tmp41_);
	_tmp42_ = small_box_grid;
	_tmp43_ = small_dummy_indicator;
	gtk_grid_attach (_tmp42_, (GtkWidget*) _tmp43_, 3, 0, 1, 1);
	_tmp44_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp44_);
	small_box_eventbox = _tmp44_;
	_tmp45_ = small_box_eventbox;
	gtk_event_box_set_visible_window (_tmp45_, FALSE);
	_tmp46_ = small_box_eventbox;
	g_signal_connect_object ((GtkWidget*) _tmp46_, "button-release-event", (GCallback) __prompt_box___lambda16__gtk_widget_button_release_event, self, 0);
	_tmp47_ = small_box_eventbox;
	_tmp48_ = small_box_grid;
	gtk_container_add ((GtkContainer*) _tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = small_box_eventbox;
	gtk_widget_show ((GtkWidget*) _tmp49_);
	_tmp50_ = small_box_eventbox;
	_tmp51_ = _g_object_ref0 ((GtkWidget*) _tmp50_);
	_g_object_unref0 (self->small_box_widget);
	self->small_box_widget = _tmp51_;
	_tmp52_ = self->priv->fixed;
	_tmp53_ = self->small_box_widget;
	gtk_container_add ((GtkContainer*) _tmp52_, _tmp53_);
	_tmp54_ = self->priv->fixed;
	_tmp55_ = self->box_grid;
	gtk_container_add ((GtkContainer*) _tmp54_, (GtkWidget*) _tmp55_);
	_g_object_unref0 (small_box_eventbox);
	_g_object_unref0 (small_dummy_indicator);
	_g_object_unref0 (small_name_grid);
	_g_object_unref0 (small_box_grid);
	_g_object_unref0 (dummy_indicator);
	return obj;
}


static void prompt_box_class_init (PromptBoxClass * klass) {
	prompt_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PromptBoxPrivate));
	PROMPT_BOX_CLASS (klass)->create_name_grid = prompt_box_real_create_name_grid;
	PROMPT_BOX_CLASS (klass)->create_small_name_grid = prompt_box_real_create_small_name_grid;
	PROMPT_BOX_CLASS (klass)->set_start_row = prompt_box_real_set_start_row;
	PROMPT_BOX_CLASS (klass)->reset_last_row = prompt_box_real_reset_last_row;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = prompt_box_real_get_preferred_height;
	PROMPT_BOX_CLASS (klass)->add_static_prompts = prompt_box_real_add_static_prompts;
	GTK_WIDGET_CLASS (klass)->grab_focus = prompt_box_real_grab_focus;
	GTK_WIDGET_CLASS (klass)->size_allocate = prompt_box_real_size_allocate;
	FADABLE_BOX_CLASS (klass)->draw_full_alpha = prompt_box_real_draw_full_alpha;
	G_OBJECT_CLASS (klass)->get_property = _vala_prompt_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_prompt_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = prompt_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = prompt_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROMPT_BOX_HAS_ERRORS, g_param_spec_boolean ("has-errors", "has-errors", "has-errors", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROMPT_BOX_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROMPT_BOX_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PROMPT_BOX_POSITION, g_param_spec_double ("position", "position", "position", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("respond", TYPE_PROMPT_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_INT, G_TYPE_NONE, 2, G_TYPE_STRV, G_TYPE_INT);
	g_signal_new ("login", TYPE_PROMPT_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("show_options", TYPE_PROMPT_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("name_clicked", TYPE_PROMPT_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void prompt_box_instance_init (PromptBox * self) {
	self->priv = PROMPT_BOX_GET_PRIVATE (self);
	self->priv->_has_errors = FALSE;
	self->priv->_position = (gdouble) 0;
	self->priv->prompt_visibility = PROMPT_BOX_PROMPT_VISIBILITY_HIDDEN;
}


static void prompt_box_finalize (GObject* obj) {
	PromptBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROMPT_BOX, PromptBox);
	_g_free0 (self->priv->_id);
	_g_object_unref0 (self->priv->fixed);
	_g_object_unref0 (self->priv->zone);
	_g_object_unref0 (self->box_grid);
	_g_object_unref0 (self->name_grid);
	_g_object_unref0 (self->priv->active_indicator);
	_g_object_unref0 (self->name_label);
	_g_object_unref0 (self->option_button);
	_g_object_unref0 (self->priv->option_image);
	_g_object_unref0 (self->priv->message_image);
	_g_object_unref0 (self->small_box_widget);
	_g_object_unref0 (self->priv->small_active_indicator);
	_g_object_unref0 (self->small_name_label);
	_g_object_unref0 (self->priv->small_message_image);
	G_OBJECT_CLASS (prompt_box_parent_class)->finalize (obj);
}


GType prompt_box_get_type (void) {
	static volatile gsize prompt_box_type_id__volatile = 0;
	if (g_once_init_enter (&prompt_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PromptBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prompt_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PromptBox), 0, (GInstanceInitFunc) prompt_box_instance_init, NULL };
		GType prompt_box_type_id;
		prompt_box_type_id = g_type_register_static (TYPE_FADABLE_BOX, "PromptBox", &g_define_type_info, 0);
		g_once_init_leave (&prompt_box_type_id__volatile, prompt_box_type_id);
	}
	return prompt_box_type_id__volatile;
}


static void _vala_prompt_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PromptBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PROMPT_BOX, PromptBox);
	switch (property_id) {
		case PROMPT_BOX_HAS_ERRORS:
		g_value_set_boolean (value, prompt_box_get_has_errors (self));
		break;
		case PROMPT_BOX_ID:
		g_value_set_string (value, prompt_box_get_id (self));
		break;
		case PROMPT_BOX_LABEL:
		g_value_set_string (value, prompt_box_get_label (self));
		break;
		case PROMPT_BOX_POSITION:
		g_value_set_double (value, prompt_box_get_position (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_prompt_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PromptBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PROMPT_BOX, PromptBox);
	switch (property_id) {
		case PROMPT_BOX_HAS_ERRORS:
		prompt_box_set_has_errors (self, g_value_get_boolean (value));
		break;
		case PROMPT_BOX_ID:
		prompt_box_set_id (self, g_value_get_string (value));
		break;
		case PROMPT_BOX_LABEL:
		prompt_box_set_label (self, g_value_get_string (value));
		break;
		case PROMPT_BOX_POSITION:
		prompt_box_set_position (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void active_indicator_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat) {
	ActiveIndicator * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	self = (ActiveIndicator*) base;
	_vala_min = ACTIVE_INDICATOR_WIDTH;
	_vala_nat = _vala_min;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


static void active_indicator_real_get_preferred_height (GtkWidget* base, gint* min, gint* nat) {
	ActiveIndicator * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	self = (ActiveIndicator*) base;
	_vala_min = ACTIVE_INDICATOR_HEIGHT;
	_vala_nat = _vala_min;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


static gboolean active_indicator_real_draw (GtkWidget* base, cairo_t* c) {
	ActiveIndicator * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	cairo_t* _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = (ActiveIndicator*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = self->priv->_active;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = c;
	_tmp2_ = GTK_WIDGET_CLASS (active_indicator_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_IMAGE, GtkImage), _tmp1_);
	result = _tmp2_;
	return result;
}


ActiveIndicator* active_indicator_construct (GType object_type) {
	ActiveIndicator * self = NULL;
	self = (ActiveIndicator*) g_object_new (object_type, NULL);
	return self;
}


ActiveIndicator* active_indicator_new (void) {
	return active_indicator_construct (TYPE_ACTIVE_INDICATOR);
}


gboolean active_indicator_get_active (ActiveIndicator* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_active;
	result = _tmp0_;
	return result;
}


void active_indicator_set_active (ActiveIndicator* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_active = _tmp0_;
	g_object_notify ((GObject *) self, "active");
}


static void _active_indicator___lambda6_ (ActiveIndicator* self) {
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void __active_indicator___lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_active_indicator___lambda6_ (self);
}


static GObject * active_indicator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ActiveIndicator * self;
	gchar* _tmp0_ = NULL;
	gchar* filename;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (active_indicator_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ACTIVE_INDICATOR, ActiveIndicator);
	_tmp0_ = g_build_filename (PKGDATADIR, "active.png", NULL);
	filename = _tmp0_;
	{
		const gchar* _tmp1_;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp1_ = filename;
		_tmp2_ = gdk_pixbuf_new_from_file (_tmp1_, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch20_g_error;
		}
		_tmp4_ = _tmp3_;
		g_object_set ((GtkImage*) self, "pixbuf", _tmp4_, NULL);
		_g_object_unref0 (_tmp4_);
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_debug ("prompt-box.vala:639: Could not load active image: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally20:
	if (_inner_error_ != NULL) {
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	g_signal_connect_object ((GObject*) self, "notify::active", (GCallback) __active_indicator___lambda6__g_object_notify, self, 0);
	g_object_set ((GtkMisc*) self, "xalign", 0.0f, NULL);
	_g_free0 (filename);
	return obj;
}


static void active_indicator_class_init (ActiveIndicatorClass * klass) {
	active_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ActiveIndicatorPrivate));
	GTK_WIDGET_CLASS (klass)->get_preferred_width = active_indicator_real_get_preferred_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = active_indicator_real_get_preferred_height;
	GTK_WIDGET_CLASS (klass)->draw = active_indicator_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_active_indicator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_active_indicator_set_property;
	G_OBJECT_CLASS (klass)->constructor = active_indicator_constructor;
	G_OBJECT_CLASS (klass)->finalize = active_indicator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACTIVE_INDICATOR_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void active_indicator_instance_init (ActiveIndicator * self) {
	self->priv = ACTIVE_INDICATOR_GET_PRIVATE (self);
}


static void active_indicator_finalize (GObject* obj) {
	ActiveIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ACTIVE_INDICATOR, ActiveIndicator);
	G_OBJECT_CLASS (active_indicator_parent_class)->finalize (obj);
}


GType active_indicator_get_type (void) {
	static volatile gsize active_indicator_type_id__volatile = 0;
	if (g_once_init_enter (&active_indicator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ActiveIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) active_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ActiveIndicator), 0, (GInstanceInitFunc) active_indicator_instance_init, NULL };
		GType active_indicator_type_id;
		active_indicator_type_id = g_type_register_static (GTK_TYPE_IMAGE, "ActiveIndicator", &g_define_type_info, 0);
		g_once_init_leave (&active_indicator_type_id__volatile, active_indicator_type_id);
	}
	return active_indicator_type_id__volatile;
}


static void _vala_active_indicator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ActiveIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ACTIVE_INDICATOR, ActiveIndicator);
	switch (property_id) {
		case ACTIVE_INDICATOR_ACTIVE:
		g_value_set_boolean (value, active_indicator_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_active_indicator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ActiveIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ACTIVE_INDICATOR, ActiveIndicator);
	switch (property_id) {
		case ACTIVE_INDICATOR_ACTIVE:
		active_indicator_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



