/* remote-login-service.c generated by valac 0.20.1, the Vala compiler
 * generated from remote-login-service.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TYPE_REMOTE_SERVER_FIELD (remote_server_field_get_type ())
typedef struct _RemoteServerField RemoteServerField;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_REMOTE_SERVER_APPLICATION (remote_server_application_get_type ())
typedef struct _RemoteServerApplication RemoteServerApplication;

#define TYPE_REMOTE_SERVER (remote_server_get_type ())
typedef struct _RemoteServer RemoteServer;

#define TYPE_REMOTE_LOGIN_SERVICE (remote_login_service_get_type ())
#define REMOTE_LOGIN_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REMOTE_LOGIN_SERVICE, RemoteLoginService))
#define IS_REMOTE_LOGIN_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REMOTE_LOGIN_SERVICE))
#define REMOTE_LOGIN_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_REMOTE_LOGIN_SERVICE, RemoteLoginServiceIface))

typedef struct _RemoteLoginService RemoteLoginService;
typedef struct _RemoteLoginServiceIface RemoteLoginServiceIface;

#define TYPE_REMOTE_LOGIN_SERVICE_PROXY (remote_login_service_proxy_get_type ())
typedef GDBusProxy RemoteLoginServiceProxy;
typedef GDBusProxyClass RemoteLoginServiceProxyClass;

struct _RemoteServerField {
	gchar* type;
	gboolean required;
	GVariant* default_value;
	GHashTable* properties;
};

struct _RemoteServerApplication {
	gchar* application_id;
	gint pin_position;
};

struct _RemoteServer {
	gchar* type;
	gchar* name;
	gchar* url;
	gboolean last_used_server;
	RemoteServerField* fields;
	gint fields_length1;
	RemoteServerApplication* applications;
	gint applications_length1;
};

struct _RemoteLoginServiceIface {
	GTypeInterface parent_iface;
	void (*get_servers) (RemoteLoginService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_servers_finish) (RemoteLoginService* self, GAsyncResult* _res_, RemoteServer** serverList, int* serverList_length1, GError** error);
	void (*get_servers_for_login) (RemoteLoginService* self, const gchar* url, const gchar* emailAddress, const gchar* password, gboolean allowCache, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_servers_for_login_finish) (RemoteLoginService* self, GAsyncResult* _res_, gboolean* loginSuccess, gchar** dataType, RemoteServer** serverList, int* serverList_length1, GError** error);
	void (*get_cached_domains_for_server) (RemoteLoginService* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_cached_domains_for_server_finish) (RemoteLoginService* self, GAsyncResult* _res_, gchar*** domains, int* domains_length1, GError** error);
	void (*set_last_used_server) (RemoteLoginService* self, const gchar* uccsUrl, const gchar* serverUrl, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_last_used_server_finish) (RemoteLoginService* self, GAsyncResult* _res_, GError** error);
};



GType remote_server_field_get_type (void) G_GNUC_CONST;
RemoteServerField* remote_server_field_dup (const RemoteServerField* self);
void remote_server_field_free (RemoteServerField* self);
void remote_server_field_copy (const RemoteServerField* self, RemoteServerField* dest);
void remote_server_field_destroy (RemoteServerField* self);
GType remote_server_application_get_type (void) G_GNUC_CONST;
RemoteServerApplication* remote_server_application_dup (const RemoteServerApplication* self);
void remote_server_application_free (RemoteServerApplication* self);
void remote_server_application_copy (const RemoteServerApplication* self, RemoteServerApplication* dest);
void remote_server_application_destroy (RemoteServerApplication* self);
GType remote_server_get_type (void) G_GNUC_CONST;
RemoteServer* remote_server_dup (const RemoteServer* self);
void remote_server_free (RemoteServer* self);
void remote_server_copy (const RemoteServer* self, RemoteServer* dest);
void remote_server_destroy (RemoteServer* self);
static void _vala_RemoteServerField_array_free (RemoteServerField* array, gint array_length);
static void _vala_RemoteServerApplication_array_free (RemoteServerApplication* array, gint array_length);
static RemoteServerField* _vala_array_dup4 (RemoteServerField* self, int length);
static RemoteServerApplication* _vala_array_dup5 (RemoteServerApplication* self, int length);
GType remote_login_service_proxy_get_type (void) G_GNUC_CONST;
guint remote_login_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType remote_login_service_get_type (void) G_GNUC_CONST;
void remote_login_service_get_servers (RemoteLoginService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void remote_login_service_get_servers_finish (RemoteLoginService* self, GAsyncResult* _res_, RemoteServer** serverList, int* serverList_length1, GError** error);
void remote_login_service_get_servers_for_login (RemoteLoginService* self, const gchar* url, const gchar* emailAddress, const gchar* password, gboolean allowCache, GAsyncReadyCallback _callback_, gpointer _user_data_);
void remote_login_service_get_servers_for_login_finish (RemoteLoginService* self, GAsyncResult* _res_, gboolean* loginSuccess, gchar** dataType, RemoteServer** serverList, int* serverList_length1, GError** error);
void remote_login_service_get_cached_domains_for_server (RemoteLoginService* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_);
void remote_login_service_get_cached_domains_for_server_finish (RemoteLoginService* self, GAsyncResult* _res_, gchar*** domains, int* domains_length1, GError** error);
void remote_login_service_set_last_used_server (RemoteLoginService* self, const gchar* uccsUrl, const gchar* serverUrl, GAsyncReadyCallback _callback_, gpointer _user_data_);
void remote_login_service_set_last_used_server_finish (RemoteLoginService* self, GAsyncResult* _res_, GError** error);
static void g_cclosure_user_marshal_VOID__POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void remote_login_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _vala_RemoteServer_array_free (RemoteServer* array, gint array_length);
static void _dbus_handle_remote_login_service_servers_updated (RemoteLoginService* self, GVariant* parameters);
static void _dbus_handle_remote_login_service_login_servers_updated (RemoteLoginService* self, GVariant* parameters);
static void _dbus_handle_remote_login_service_login_changed (RemoteLoginService* self, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void remote_login_service_proxy_get_servers_async (RemoteLoginService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void remote_login_service_proxy_get_servers_finish (RemoteLoginService* self, GAsyncResult* _res_, RemoteServer** serverList, int* serverList_length1, GError** error);
static void remote_login_service_proxy_get_servers_for_login_async (RemoteLoginService* self, const gchar* url, const gchar* emailAddress, const gchar* password, gboolean allowCache, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void remote_login_service_proxy_get_servers_for_login_finish (RemoteLoginService* self, GAsyncResult* _res_, gboolean* loginSuccess, gchar** dataType, RemoteServer** serverList, int* serverList_length1, GError** error);
static void remote_login_service_proxy_get_cached_domains_for_server_async (RemoteLoginService* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void remote_login_service_proxy_get_cached_domains_for_server_finish (RemoteLoginService* self, GAsyncResult* _res_, gchar*** domains, int* domains_length1, GError** error);
static void remote_login_service_proxy_set_last_used_server_async (RemoteLoginService* self, const gchar* uccsUrl, const gchar* serverUrl, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void remote_login_service_proxy_set_last_used_server_finish (RemoteLoginService* self, GAsyncResult* _res_, GError** error);
static void remote_login_service_proxy_remote_login_service_interface_init (RemoteLoginServiceIface* iface);
static void _dbus_remote_login_service_get_servers (RemoteLoginService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_remote_login_service_get_servers_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_remote_login_service_get_servers_for_login (RemoteLoginService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_remote_login_service_get_servers_for_login_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_remote_login_service_get_cached_domains_for_server (RemoteLoginService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_remote_login_service_get_cached_domains_for_server_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_remote_login_service_set_last_used_server (RemoteLoginService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_remote_login_service_set_last_used_server_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void remote_login_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* remote_login_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean remote_login_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_remote_login_service_servers_updated (GObject* _sender, RemoteServer* serverList, int serverList_length1, gpointer* _data);
static void _dbus_remote_login_service_login_servers_updated (GObject* _sender, const gchar* url, const gchar* emailAddress, const gchar* dataType, RemoteServer* serverList, int serverList_length1, gpointer* _data);
static void _dbus_remote_login_service_login_changed (GObject* _sender, const gchar* url, const gchar* emailAddress, gpointer* _data);
static void _remote_login_service_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_servers_serverList = {-1, "serverList", "a(sssba(sbva{sv})a(si))"};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_get_servers_in[] = {NULL};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_get_servers_out[] = {&_remote_login_service_dbus_arg_info_get_servers_serverList, NULL};
static const GDBusMethodInfo _remote_login_service_dbus_method_info_get_servers = {-1, "GetServers", (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_get_servers_in), (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_get_servers_out)};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_servers_for_login_url = {-1, "url", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_servers_for_login_emailAddress = {-1, "emailAddress", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_servers_for_login_password = {-1, "password", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_servers_for_login_allowCache = {-1, "allowCache", "b"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_servers_for_login_loginSuccess = {-1, "loginSuccess", "b"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_servers_for_login_dataType = {-1, "dataType", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_servers_for_login_serverList = {-1, "serverList", "a(sssba(sbva{sv})a(si))"};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_get_servers_for_login_in[] = {&_remote_login_service_dbus_arg_info_get_servers_for_login_url, &_remote_login_service_dbus_arg_info_get_servers_for_login_emailAddress, &_remote_login_service_dbus_arg_info_get_servers_for_login_password, &_remote_login_service_dbus_arg_info_get_servers_for_login_allowCache, NULL};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_get_servers_for_login_out[] = {&_remote_login_service_dbus_arg_info_get_servers_for_login_loginSuccess, &_remote_login_service_dbus_arg_info_get_servers_for_login_dataType, &_remote_login_service_dbus_arg_info_get_servers_for_login_serverList, NULL};
static const GDBusMethodInfo _remote_login_service_dbus_method_info_get_servers_for_login = {-1, "GetServersForLogin", (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_get_servers_for_login_in), (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_get_servers_for_login_out)};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_cached_domains_for_server_url = {-1, "url", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_get_cached_domains_for_server_domains = {-1, "domains", "as"};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_get_cached_domains_for_server_in[] = {&_remote_login_service_dbus_arg_info_get_cached_domains_for_server_url, NULL};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_get_cached_domains_for_server_out[] = {&_remote_login_service_dbus_arg_info_get_cached_domains_for_server_domains, NULL};
static const GDBusMethodInfo _remote_login_service_dbus_method_info_get_cached_domains_for_server = {-1, "GetCachedDomainsForServer", (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_get_cached_domains_for_server_in), (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_get_cached_domains_for_server_out)};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_set_last_used_server_uccsUrl = {-1, "uccsUrl", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_set_last_used_server_serverUrl = {-1, "serverUrl", "s"};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_set_last_used_server_in[] = {&_remote_login_service_dbus_arg_info_set_last_used_server_uccsUrl, &_remote_login_service_dbus_arg_info_set_last_used_server_serverUrl, NULL};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_set_last_used_server_out[] = {NULL};
static const GDBusMethodInfo _remote_login_service_dbus_method_info_set_last_used_server = {-1, "SetLastUsedServer", (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_set_last_used_server_in), (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_set_last_used_server_out)};
static const GDBusMethodInfo * const _remote_login_service_dbus_method_info[] = {&_remote_login_service_dbus_method_info_get_servers, &_remote_login_service_dbus_method_info_get_servers_for_login, &_remote_login_service_dbus_method_info_get_cached_domains_for_server, &_remote_login_service_dbus_method_info_set_last_used_server, NULL};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_servers_updated_serverList = {-1, "serverList", "a(sssba(sbva{sv})a(si))"};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_servers_updated[] = {&_remote_login_service_dbus_arg_info_servers_updated_serverList, NULL};
static const GDBusSignalInfo _remote_login_service_dbus_signal_info_servers_updated = {-1, "ServersUpdated", (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_servers_updated)};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_login_servers_updated_url = {-1, "url", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_login_servers_updated_emailAddress = {-1, "emailAddress", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_login_servers_updated_dataType = {-1, "dataType", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_login_servers_updated_serverList = {-1, "serverList", "a(sssba(sbva{sv})a(si))"};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_login_servers_updated[] = {&_remote_login_service_dbus_arg_info_login_servers_updated_url, &_remote_login_service_dbus_arg_info_login_servers_updated_emailAddress, &_remote_login_service_dbus_arg_info_login_servers_updated_dataType, &_remote_login_service_dbus_arg_info_login_servers_updated_serverList, NULL};
static const GDBusSignalInfo _remote_login_service_dbus_signal_info_login_servers_updated = {-1, "LoginServersUpdated", (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_login_servers_updated)};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_login_changed_url = {-1, "url", "s"};
static const GDBusArgInfo _remote_login_service_dbus_arg_info_login_changed_emailAddress = {-1, "emailAddress", "s"};
static const GDBusArgInfo * const _remote_login_service_dbus_arg_info_login_changed[] = {&_remote_login_service_dbus_arg_info_login_changed_url, &_remote_login_service_dbus_arg_info_login_changed_emailAddress, NULL};
static const GDBusSignalInfo _remote_login_service_dbus_signal_info_login_changed = {-1, "LoginChanged", (GDBusArgInfo **) (&_remote_login_service_dbus_arg_info_login_changed)};
static const GDBusSignalInfo * const _remote_login_service_dbus_signal_info[] = {&_remote_login_service_dbus_signal_info_servers_updated, &_remote_login_service_dbus_signal_info_login_servers_updated, &_remote_login_service_dbus_signal_info_login_changed, NULL};
static const GDBusPropertyInfo * const _remote_login_service_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _remote_login_service_dbus_interface_info = {-1, "com.canonical.RemoteLogin", (GDBusMethodInfo **) (&_remote_login_service_dbus_method_info), (GDBusSignalInfo **) (&_remote_login_service_dbus_signal_info), (GDBusPropertyInfo **) (&_remote_login_service_dbus_property_info)};
static const GDBusInterfaceVTable _remote_login_service_dbus_interface_vtable = {remote_login_service_dbus_interface_method_call, remote_login_service_dbus_interface_get_property, remote_login_service_dbus_interface_set_property};

static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void remote_server_field_copy (const RemoteServerField* self, RemoteServerField* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	_tmp0_ = (*self).type;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).type);
	(*dest).type = _tmp1_;
	_tmp2_ = (*self).required;
	(*dest).required = _tmp2_;
	_tmp3_ = (*self).default_value;
	_tmp4_ = _g_variant_ref0 (_tmp3_);
	_g_variant_unref0 ((*dest).default_value);
	(*dest).default_value = _tmp4_;
	_tmp5_ = (*self).properties;
	_tmp6_ = _g_hash_table_ref0 (_tmp5_);
	_g_hash_table_unref0 ((*dest).properties);
	(*dest).properties = _tmp6_;
}


void remote_server_field_destroy (RemoteServerField* self) {
	_g_free0 ((*self).type);
	_g_variant_unref0 ((*self).default_value);
	_g_hash_table_unref0 ((*self).properties);
}


RemoteServerField* remote_server_field_dup (const RemoteServerField* self) {
	RemoteServerField* dup;
	dup = g_new0 (RemoteServerField, 1);
	remote_server_field_copy (self, dup);
	return dup;
}


void remote_server_field_free (RemoteServerField* self) {
	remote_server_field_destroy (self);
	g_free (self);
}


GType remote_server_field_get_type (void) {
	static volatile gsize remote_server_field_type_id__volatile = 0;
	if (g_once_init_enter (&remote_server_field_type_id__volatile)) {
		GType remote_server_field_type_id;
		remote_server_field_type_id = g_boxed_type_register_static ("RemoteServerField", (GBoxedCopyFunc) remote_server_field_dup, (GBoxedFreeFunc) remote_server_field_free);
		g_once_init_leave (&remote_server_field_type_id__volatile, remote_server_field_type_id);
	}
	return remote_server_field_type_id__volatile;
}


void remote_server_application_copy (const RemoteServerApplication* self, RemoteServerApplication* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	_tmp0_ = (*self).application_id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).application_id);
	(*dest).application_id = _tmp1_;
	_tmp2_ = (*self).pin_position;
	(*dest).pin_position = _tmp2_;
}


void remote_server_application_destroy (RemoteServerApplication* self) {
	_g_free0 ((*self).application_id);
}


RemoteServerApplication* remote_server_application_dup (const RemoteServerApplication* self) {
	RemoteServerApplication* dup;
	dup = g_new0 (RemoteServerApplication, 1);
	remote_server_application_copy (self, dup);
	return dup;
}


void remote_server_application_free (RemoteServerApplication* self) {
	remote_server_application_destroy (self);
	g_free (self);
}


GType remote_server_application_get_type (void) {
	static volatile gsize remote_server_application_type_id__volatile = 0;
	if (g_once_init_enter (&remote_server_application_type_id__volatile)) {
		GType remote_server_application_type_id;
		remote_server_application_type_id = g_boxed_type_register_static ("RemoteServerApplication", (GBoxedCopyFunc) remote_server_application_dup, (GBoxedFreeFunc) remote_server_application_free);
		g_once_init_leave (&remote_server_application_type_id__volatile, remote_server_application_type_id);
	}
	return remote_server_application_type_id__volatile;
}


static void _vala_RemoteServerField_array_free (RemoteServerField* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			remote_server_field_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _vala_RemoteServerApplication_array_free (RemoteServerApplication* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			remote_server_application_destroy (&array[i]);
		}
	}
	g_free (array);
}


static RemoteServerField* _vala_array_dup4 (RemoteServerField* self, int length) {
	RemoteServerField* result;
	int i;
	result = g_new0 (RemoteServerField, length);
	for (i = 0; i < length; i++) {
		RemoteServerField _tmp0_ = {0};
		remote_server_field_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static RemoteServerApplication* _vala_array_dup5 (RemoteServerApplication* self, int length) {
	RemoteServerApplication* result;
	int i;
	result = g_new0 (RemoteServerApplication, length);
	for (i = 0; i < length; i++) {
		RemoteServerApplication _tmp0_ = {0};
		remote_server_application_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


void remote_server_copy (const RemoteServer* self, RemoteServer* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	RemoteServerField* _tmp7_;
	gint _tmp7__length1;
	RemoteServerField* _tmp8_;
	gint _tmp8__length1;
	RemoteServerApplication* _tmp9_;
	gint _tmp9__length1;
	RemoteServerApplication* _tmp10_;
	gint _tmp10__length1;
	_tmp0_ = (*self).type;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).type);
	(*dest).type = _tmp1_;
	_tmp2_ = (*self).name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp3_;
	_tmp4_ = (*self).url;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).url);
	(*dest).url = _tmp5_;
	_tmp6_ = (*self).last_used_server;
	(*dest).last_used_server = _tmp6_;
	_tmp7_ = (*self).fields;
	_tmp7__length1 = (*self).fields_length1;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup4 (_tmp7_, _tmp7__length1) : ((gpointer) _tmp7_);
	_tmp8__length1 = _tmp7__length1;
	(*dest).fields = (_vala_RemoteServerField_array_free ((*dest).fields, (*dest).fields_length1), NULL);
	(*dest).fields = _tmp8_;
	(*dest).fields_length1 = _tmp8__length1;
	_tmp9_ = (*self).applications;
	_tmp9__length1 = (*self).applications_length1;
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup5 (_tmp9_, _tmp9__length1) : ((gpointer) _tmp9_);
	_tmp10__length1 = _tmp9__length1;
	(*dest).applications = (_vala_RemoteServerApplication_array_free ((*dest).applications, (*dest).applications_length1), NULL);
	(*dest).applications = _tmp10_;
	(*dest).applications_length1 = _tmp10__length1;
}


void remote_server_destroy (RemoteServer* self) {
	_g_free0 ((*self).type);
	_g_free0 ((*self).name);
	_g_free0 ((*self).url);
	(*self).fields = (_vala_RemoteServerField_array_free ((*self).fields, (*self).fields_length1), NULL);
	(*self).applications = (_vala_RemoteServerApplication_array_free ((*self).applications, (*self).applications_length1), NULL);
}


RemoteServer* remote_server_dup (const RemoteServer* self) {
	RemoteServer* dup;
	dup = g_new0 (RemoteServer, 1);
	remote_server_copy (self, dup);
	return dup;
}


void remote_server_free (RemoteServer* self) {
	remote_server_destroy (self);
	g_free (self);
}


GType remote_server_get_type (void) {
	static volatile gsize remote_server_type_id__volatile = 0;
	if (g_once_init_enter (&remote_server_type_id__volatile)) {
		GType remote_server_type_id;
		remote_server_type_id = g_boxed_type_register_static ("RemoteServer", (GBoxedCopyFunc) remote_server_dup, (GBoxedFreeFunc) remote_server_free);
		g_once_init_leave (&remote_server_type_id__volatile, remote_server_type_id);
	}
	return remote_server_type_id__volatile;
}


void remote_login_service_get_servers (RemoteLoginService* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	REMOTE_LOGIN_SERVICE_GET_INTERFACE (self)->get_servers (self, _callback_, _user_data_);
}


void remote_login_service_get_servers_finish (RemoteLoginService* self, GAsyncResult* _res_, RemoteServer** serverList, int* serverList_length1, GError** error) {
	REMOTE_LOGIN_SERVICE_GET_INTERFACE (self)->get_servers_finish (self, _res_, serverList, serverList_length1, error);
}


void remote_login_service_get_servers_for_login (RemoteLoginService* self, const gchar* url, const gchar* emailAddress, const gchar* password, gboolean allowCache, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	REMOTE_LOGIN_SERVICE_GET_INTERFACE (self)->get_servers_for_login (self, url, emailAddress, password, allowCache, _callback_, _user_data_);
}


void remote_login_service_get_servers_for_login_finish (RemoteLoginService* self, GAsyncResult* _res_, gboolean* loginSuccess, gchar** dataType, RemoteServer** serverList, int* serverList_length1, GError** error) {
	REMOTE_LOGIN_SERVICE_GET_INTERFACE (self)->get_servers_for_login_finish (self, _res_, loginSuccess, dataType, serverList, serverList_length1, error);
}


void remote_login_service_get_cached_domains_for_server (RemoteLoginService* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	REMOTE_LOGIN_SERVICE_GET_INTERFACE (self)->get_cached_domains_for_server (self, url, _callback_, _user_data_);
}


void remote_login_service_get_cached_domains_for_server_finish (RemoteLoginService* self, GAsyncResult* _res_, gchar*** domains, int* domains_length1, GError** error) {
	REMOTE_LOGIN_SERVICE_GET_INTERFACE (self)->get_cached_domains_for_server_finish (self, _res_, domains, domains_length1, error);
}


void remote_login_service_set_last_used_server (RemoteLoginService* self, const gchar* uccsUrl, const gchar* serverUrl, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	REMOTE_LOGIN_SERVICE_GET_INTERFACE (self)->set_last_used_server (self, uccsUrl, serverUrl, _callback_, _user_data_);
}


void remote_login_service_set_last_used_server_finish (RemoteLoginService* self, GAsyncResult* _res_, GError** error) {
	REMOTE_LOGIN_SERVICE_GET_INTERFACE (self)->set_last_used_server_finish (self, _res_, error);
}


static void g_cclosure_user_marshal_VOID__POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING_POINTER_INT) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer arg_4, gint arg_5, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING_POINTER_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING_POINTER_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_pointer (param_values + 4), g_value_get_int (param_values + 5), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void remote_login_service_base_init (RemoteLoginServiceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("servers_updated", TYPE_REMOTE_LOGIN_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT, G_TYPE_NONE, 2, G_TYPE_POINTER, G_TYPE_INT);
		g_signal_new ("login_servers_updated", TYPE_REMOTE_LOGIN_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_POINTER_INT, G_TYPE_NONE, 5, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_POINTER, G_TYPE_INT);
		g_signal_new ("login_changed", TYPE_REMOTE_LOGIN_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	}
}


GType remote_login_service_get_type (void) {
	static volatile gsize remote_login_service_type_id__volatile = 0;
	if (g_once_init_enter (&remote_login_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RemoteLoginServiceIface), (GBaseInitFunc) remote_login_service_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType remote_login_service_type_id;
		remote_login_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "RemoteLoginService", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (remote_login_service_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (remote_login_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) remote_login_service_proxy_get_type);
		g_type_set_qdata (remote_login_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.canonical.RemoteLogin");
		g_type_set_qdata (remote_login_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) remote_login_service_register_object);
		g_once_init_leave (&remote_login_service_type_id__volatile, remote_login_service_type_id);
	}
	return remote_login_service_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (RemoteLoginServiceProxy, remote_login_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_REMOTE_LOGIN_SERVICE, remote_login_service_proxy_remote_login_service_interface_init) )
static void remote_login_service_proxy_class_init (RemoteLoginServiceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = remote_login_service_proxy_g_signal;
}


static void _vala_RemoteServer_array_free (RemoteServer* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			remote_server_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _dbus_handle_remote_login_service_servers_updated (RemoteLoginService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	RemoteServer* serverList = NULL;
	int serverList_length1;
	GVariant* _tmp1_;
	RemoteServer* _tmp2_;
	int _tmp2__length;
	int _tmp2__size;
	int _tmp2__length1;
	GVariantIter _tmp3_;
	GVariant* _tmp4_;
	g_variant_iter_init (&_arguments_iter, parameters);
	serverList_length1 = 0;
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp2_ = g_new (RemoteServer, 5);
	_tmp2__length = 0;
	_tmp2__size = 4;
	_tmp2__length1 = 0;
	g_variant_iter_init (&_tmp3_, _tmp1_);
	for (; (_tmp4_ = g_variant_iter_next_value (&_tmp3_)) != NULL; _tmp2__length1++) {
		RemoteServer _tmp5_;
		GVariantIter _tmp6_;
		GVariant* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		GVariant* _tmp11_;
		RemoteServerField* _tmp12_;
		int _tmp12__length;
		int _tmp12__size;
		int _tmp12__length1;
		GVariantIter _tmp13_;
		GVariant* _tmp14_;
		GVariant* _tmp25_;
		RemoteServerApplication* _tmp26_;
		int _tmp26__length;
		int _tmp26__size;
		int _tmp26__length1;
		GVariantIter _tmp27_;
		GVariant* _tmp28_;
		if (_tmp2__size == _tmp2__length) {
			_tmp2__size = 2 * _tmp2__size;
			_tmp2_ = g_renew (RemoteServer, _tmp2_, _tmp2__size + 1);
		}
		g_variant_iter_init (&_tmp6_, _tmp4_);
		_tmp7_ = g_variant_iter_next_value (&_tmp6_);
		_tmp5_.type = g_variant_dup_string (_tmp7_, NULL);
		g_variant_unref (_tmp7_);
		_tmp8_ = g_variant_iter_next_value (&_tmp6_);
		_tmp5_.name = g_variant_dup_string (_tmp8_, NULL);
		g_variant_unref (_tmp8_);
		_tmp9_ = g_variant_iter_next_value (&_tmp6_);
		_tmp5_.url = g_variant_dup_string (_tmp9_, NULL);
		g_variant_unref (_tmp9_);
		_tmp10_ = g_variant_iter_next_value (&_tmp6_);
		_tmp5_.last_used_server = g_variant_get_boolean (_tmp10_);
		g_variant_unref (_tmp10_);
		_tmp11_ = g_variant_iter_next_value (&_tmp6_);
		_tmp12_ = g_new (RemoteServerField, 5);
		_tmp12__length = 0;
		_tmp12__size = 4;
		_tmp12__length1 = 0;
		g_variant_iter_init (&_tmp13_, _tmp11_);
		for (; (_tmp14_ = g_variant_iter_next_value (&_tmp13_)) != NULL; _tmp12__length1++) {
			RemoteServerField _tmp15_;
			GVariantIter _tmp16_;
			GVariant* _tmp17_;
			GVariant* _tmp18_;
			GVariant* _tmp19_;
			GVariant* _tmp20_;
			GHashTable* _tmp21_;
			GVariantIter _tmp22_;
			GVariant* _tmp23_;
			GVariant* _tmp24_;
			if (_tmp12__size == _tmp12__length) {
				_tmp12__size = 2 * _tmp12__size;
				_tmp12_ = g_renew (RemoteServerField, _tmp12_, _tmp12__size + 1);
			}
			g_variant_iter_init (&_tmp16_, _tmp14_);
			_tmp17_ = g_variant_iter_next_value (&_tmp16_);
			_tmp15_.type = g_variant_dup_string (_tmp17_, NULL);
			g_variant_unref (_tmp17_);
			_tmp18_ = g_variant_iter_next_value (&_tmp16_);
			_tmp15_.required = g_variant_get_boolean (_tmp18_);
			g_variant_unref (_tmp18_);
			_tmp19_ = g_variant_iter_next_value (&_tmp16_);
			_tmp15_.default_value = g_variant_get_variant (_tmp19_);
			g_variant_unref (_tmp19_);
			_tmp20_ = g_variant_iter_next_value (&_tmp16_);
			_tmp21_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
			g_variant_iter_init (&_tmp22_, _tmp20_);
			while (g_variant_iter_loop (&_tmp22_, "{?*}", &_tmp23_, &_tmp24_)) {
				g_hash_table_insert (_tmp21_, g_variant_dup_string (_tmp23_, NULL), g_variant_get_variant (_tmp24_));
			}
			_tmp15_.properties = _tmp21_;
			g_variant_unref (_tmp20_);
			_tmp12_[_tmp12__length++] = _tmp15_;
			g_variant_unref (_tmp14_);
		}
		_tmp5_.fields_length1 = _tmp12__length1;
		_tmp5_.fields = _tmp12_;
		g_variant_unref (_tmp11_);
		_tmp25_ = g_variant_iter_next_value (&_tmp6_);
		_tmp26_ = g_new (RemoteServerApplication, 5);
		_tmp26__length = 0;
		_tmp26__size = 4;
		_tmp26__length1 = 0;
		g_variant_iter_init (&_tmp27_, _tmp25_);
		for (; (_tmp28_ = g_variant_iter_next_value (&_tmp27_)) != NULL; _tmp26__length1++) {
			RemoteServerApplication _tmp29_;
			GVariantIter _tmp30_;
			GVariant* _tmp31_;
			GVariant* _tmp32_;
			if (_tmp26__size == _tmp26__length) {
				_tmp26__size = 2 * _tmp26__size;
				_tmp26_ = g_renew (RemoteServerApplication, _tmp26_, _tmp26__size + 1);
			}
			g_variant_iter_init (&_tmp30_, _tmp28_);
			_tmp31_ = g_variant_iter_next_value (&_tmp30_);
			_tmp29_.application_id = g_variant_dup_string (_tmp31_, NULL);
			g_variant_unref (_tmp31_);
			_tmp32_ = g_variant_iter_next_value (&_tmp30_);
			_tmp29_.pin_position = g_variant_get_int32 (_tmp32_);
			g_variant_unref (_tmp32_);
			_tmp26_[_tmp26__length++] = _tmp29_;
			g_variant_unref (_tmp28_);
		}
		_tmp5_.applications_length1 = _tmp26__length1;
		_tmp5_.applications = _tmp26_;
		g_variant_unref (_tmp25_);
		_tmp2_[_tmp2__length++] = _tmp5_;
		g_variant_unref (_tmp4_);
	}
	serverList_length1 = _tmp2__length1;
	serverList = _tmp2_;
	g_variant_unref (_tmp1_);
	g_signal_emit_by_name (self, "servers-updated", serverList, serverList_length1);
	serverList = (_vala_RemoteServer_array_free (serverList, serverList_length1), NULL);
}


static void _dbus_handle_remote_login_service_login_servers_updated (RemoteLoginService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* url = NULL;
	GVariant* _tmp33_;
	gchar* emailAddress = NULL;
	GVariant* _tmp34_;
	gchar* dataType = NULL;
	GVariant* _tmp35_;
	RemoteServer* serverList = NULL;
	int serverList_length1;
	GVariant* _tmp36_;
	RemoteServer* _tmp37_;
	int _tmp37__length;
	int _tmp37__size;
	int _tmp37__length1;
	GVariantIter _tmp38_;
	GVariant* _tmp39_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp33_ = g_variant_iter_next_value (&_arguments_iter);
	url = g_variant_dup_string (_tmp33_, NULL);
	g_variant_unref (_tmp33_);
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	emailAddress = g_variant_dup_string (_tmp34_, NULL);
	g_variant_unref (_tmp34_);
	_tmp35_ = g_variant_iter_next_value (&_arguments_iter);
	dataType = g_variant_dup_string (_tmp35_, NULL);
	g_variant_unref (_tmp35_);
	serverList_length1 = 0;
	_tmp36_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp37_ = g_new (RemoteServer, 5);
	_tmp37__length = 0;
	_tmp37__size = 4;
	_tmp37__length1 = 0;
	g_variant_iter_init (&_tmp38_, _tmp36_);
	for (; (_tmp39_ = g_variant_iter_next_value (&_tmp38_)) != NULL; _tmp37__length1++) {
		RemoteServer _tmp40_;
		GVariantIter _tmp41_;
		GVariant* _tmp42_;
		GVariant* _tmp43_;
		GVariant* _tmp44_;
		GVariant* _tmp45_;
		GVariant* _tmp46_;
		RemoteServerField* _tmp47_;
		int _tmp47__length;
		int _tmp47__size;
		int _tmp47__length1;
		GVariantIter _tmp48_;
		GVariant* _tmp49_;
		GVariant* _tmp60_;
		RemoteServerApplication* _tmp61_;
		int _tmp61__length;
		int _tmp61__size;
		int _tmp61__length1;
		GVariantIter _tmp62_;
		GVariant* _tmp63_;
		if (_tmp37__size == _tmp37__length) {
			_tmp37__size = 2 * _tmp37__size;
			_tmp37_ = g_renew (RemoteServer, _tmp37_, _tmp37__size + 1);
		}
		g_variant_iter_init (&_tmp41_, _tmp39_);
		_tmp42_ = g_variant_iter_next_value (&_tmp41_);
		_tmp40_.type = g_variant_dup_string (_tmp42_, NULL);
		g_variant_unref (_tmp42_);
		_tmp43_ = g_variant_iter_next_value (&_tmp41_);
		_tmp40_.name = g_variant_dup_string (_tmp43_, NULL);
		g_variant_unref (_tmp43_);
		_tmp44_ = g_variant_iter_next_value (&_tmp41_);
		_tmp40_.url = g_variant_dup_string (_tmp44_, NULL);
		g_variant_unref (_tmp44_);
		_tmp45_ = g_variant_iter_next_value (&_tmp41_);
		_tmp40_.last_used_server = g_variant_get_boolean (_tmp45_);
		g_variant_unref (_tmp45_);
		_tmp46_ = g_variant_iter_next_value (&_tmp41_);
		_tmp47_ = g_new (RemoteServerField, 5);
		_tmp47__length = 0;
		_tmp47__size = 4;
		_tmp47__length1 = 0;
		g_variant_iter_init (&_tmp48_, _tmp46_);
		for (; (_tmp49_ = g_variant_iter_next_value (&_tmp48_)) != NULL; _tmp47__length1++) {
			RemoteServerField _tmp50_;
			GVariantIter _tmp51_;
			GVariant* _tmp52_;
			GVariant* _tmp53_;
			GVariant* _tmp54_;
			GVariant* _tmp55_;
			GHashTable* _tmp56_;
			GVariantIter _tmp57_;
			GVariant* _tmp58_;
			GVariant* _tmp59_;
			if (_tmp47__size == _tmp47__length) {
				_tmp47__size = 2 * _tmp47__size;
				_tmp47_ = g_renew (RemoteServerField, _tmp47_, _tmp47__size + 1);
			}
			g_variant_iter_init (&_tmp51_, _tmp49_);
			_tmp52_ = g_variant_iter_next_value (&_tmp51_);
			_tmp50_.type = g_variant_dup_string (_tmp52_, NULL);
			g_variant_unref (_tmp52_);
			_tmp53_ = g_variant_iter_next_value (&_tmp51_);
			_tmp50_.required = g_variant_get_boolean (_tmp53_);
			g_variant_unref (_tmp53_);
			_tmp54_ = g_variant_iter_next_value (&_tmp51_);
			_tmp50_.default_value = g_variant_get_variant (_tmp54_);
			g_variant_unref (_tmp54_);
			_tmp55_ = g_variant_iter_next_value (&_tmp51_);
			_tmp56_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
			g_variant_iter_init (&_tmp57_, _tmp55_);
			while (g_variant_iter_loop (&_tmp57_, "{?*}", &_tmp58_, &_tmp59_)) {
				g_hash_table_insert (_tmp56_, g_variant_dup_string (_tmp58_, NULL), g_variant_get_variant (_tmp59_));
			}
			_tmp50_.properties = _tmp56_;
			g_variant_unref (_tmp55_);
			_tmp47_[_tmp47__length++] = _tmp50_;
			g_variant_unref (_tmp49_);
		}
		_tmp40_.fields_length1 = _tmp47__length1;
		_tmp40_.fields = _tmp47_;
		g_variant_unref (_tmp46_);
		_tmp60_ = g_variant_iter_next_value (&_tmp41_);
		_tmp61_ = g_new (RemoteServerApplication, 5);
		_tmp61__length = 0;
		_tmp61__size = 4;
		_tmp61__length1 = 0;
		g_variant_iter_init (&_tmp62_, _tmp60_);
		for (; (_tmp63_ = g_variant_iter_next_value (&_tmp62_)) != NULL; _tmp61__length1++) {
			RemoteServerApplication _tmp64_;
			GVariantIter _tmp65_;
			GVariant* _tmp66_;
			GVariant* _tmp67_;
			if (_tmp61__size == _tmp61__length) {
				_tmp61__size = 2 * _tmp61__size;
				_tmp61_ = g_renew (RemoteServerApplication, _tmp61_, _tmp61__size + 1);
			}
			g_variant_iter_init (&_tmp65_, _tmp63_);
			_tmp66_ = g_variant_iter_next_value (&_tmp65_);
			_tmp64_.application_id = g_variant_dup_string (_tmp66_, NULL);
			g_variant_unref (_tmp66_);
			_tmp67_ = g_variant_iter_next_value (&_tmp65_);
			_tmp64_.pin_position = g_variant_get_int32 (_tmp67_);
			g_variant_unref (_tmp67_);
			_tmp61_[_tmp61__length++] = _tmp64_;
			g_variant_unref (_tmp63_);
		}
		_tmp40_.applications_length1 = _tmp61__length1;
		_tmp40_.applications = _tmp61_;
		g_variant_unref (_tmp60_);
		_tmp37_[_tmp37__length++] = _tmp40_;
		g_variant_unref (_tmp39_);
	}
	serverList_length1 = _tmp37__length1;
	serverList = _tmp37_;
	g_variant_unref (_tmp36_);
	g_signal_emit_by_name (self, "login-servers-updated", url, emailAddress, dataType, serverList, serverList_length1);
	_g_free0 (url);
	_g_free0 (emailAddress);
	_g_free0 (dataType);
	serverList = (_vala_RemoteServer_array_free (serverList, serverList_length1), NULL);
}


static void _dbus_handle_remote_login_service_login_changed (RemoteLoginService* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* url = NULL;
	GVariant* _tmp68_;
	gchar* emailAddress = NULL;
	GVariant* _tmp69_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp68_ = g_variant_iter_next_value (&_arguments_iter);
	url = g_variant_dup_string (_tmp68_, NULL);
	g_variant_unref (_tmp68_);
	_tmp69_ = g_variant_iter_next_value (&_arguments_iter);
	emailAddress = g_variant_dup_string (_tmp69_, NULL);
	g_variant_unref (_tmp69_);
	g_signal_emit_by_name (self, "login-changed", url, emailAddress);
	_g_free0 (url);
	_g_free0 (emailAddress);
}


static void remote_login_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "ServersUpdated") == 0) {
		_dbus_handle_remote_login_service_servers_updated ((RemoteLoginService*) proxy, parameters);
	} else if (strcmp (signal_name, "LoginServersUpdated") == 0) {
		_dbus_handle_remote_login_service_login_servers_updated ((RemoteLoginService*) proxy, parameters);
	} else if (strcmp (signal_name, "LoginChanged") == 0) {
		_dbus_handle_remote_login_service_login_changed ((RemoteLoginService*) proxy, parameters);
	}
}


static void remote_login_service_proxy_init (RemoteLoginServiceProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void remote_login_service_proxy_get_servers_async (RemoteLoginService* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.RemoteLogin", "GetServers");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void remote_login_service_proxy_get_servers_finish (RemoteLoginService* self, GAsyncResult* _res_, RemoteServer** serverList, int* serverList_length1, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	RemoteServer* _vala_serverList;
	int _vala_serverList_length1;
	GVariant* _tmp70_;
	RemoteServer* _tmp71_;
	int _tmp71__length;
	int _tmp71__size;
	int _tmp71__length1;
	GVariantIter _tmp72_;
	GVariant* _tmp73_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_vala_serverList_length1 = 0;
	_tmp70_ = g_variant_iter_next_value (&_reply_iter);
	_tmp71_ = g_new (RemoteServer, 5);
	_tmp71__length = 0;
	_tmp71__size = 4;
	_tmp71__length1 = 0;
	g_variant_iter_init (&_tmp72_, _tmp70_);
	for (; (_tmp73_ = g_variant_iter_next_value (&_tmp72_)) != NULL; _tmp71__length1++) {
		RemoteServer _tmp74_;
		GVariantIter _tmp75_;
		GVariant* _tmp76_;
		GVariant* _tmp77_;
		GVariant* _tmp78_;
		GVariant* _tmp79_;
		GVariant* _tmp80_;
		RemoteServerField* _tmp81_;
		int _tmp81__length;
		int _tmp81__size;
		int _tmp81__length1;
		GVariantIter _tmp82_;
		GVariant* _tmp83_;
		GVariant* _tmp94_;
		RemoteServerApplication* _tmp95_;
		int _tmp95__length;
		int _tmp95__size;
		int _tmp95__length1;
		GVariantIter _tmp96_;
		GVariant* _tmp97_;
		if (_tmp71__size == _tmp71__length) {
			_tmp71__size = 2 * _tmp71__size;
			_tmp71_ = g_renew (RemoteServer, _tmp71_, _tmp71__size + 1);
		}
		g_variant_iter_init (&_tmp75_, _tmp73_);
		_tmp76_ = g_variant_iter_next_value (&_tmp75_);
		_tmp74_.type = g_variant_dup_string (_tmp76_, NULL);
		g_variant_unref (_tmp76_);
		_tmp77_ = g_variant_iter_next_value (&_tmp75_);
		_tmp74_.name = g_variant_dup_string (_tmp77_, NULL);
		g_variant_unref (_tmp77_);
		_tmp78_ = g_variant_iter_next_value (&_tmp75_);
		_tmp74_.url = g_variant_dup_string (_tmp78_, NULL);
		g_variant_unref (_tmp78_);
		_tmp79_ = g_variant_iter_next_value (&_tmp75_);
		_tmp74_.last_used_server = g_variant_get_boolean (_tmp79_);
		g_variant_unref (_tmp79_);
		_tmp80_ = g_variant_iter_next_value (&_tmp75_);
		_tmp81_ = g_new (RemoteServerField, 5);
		_tmp81__length = 0;
		_tmp81__size = 4;
		_tmp81__length1 = 0;
		g_variant_iter_init (&_tmp82_, _tmp80_);
		for (; (_tmp83_ = g_variant_iter_next_value (&_tmp82_)) != NULL; _tmp81__length1++) {
			RemoteServerField _tmp84_;
			GVariantIter _tmp85_;
			GVariant* _tmp86_;
			GVariant* _tmp87_;
			GVariant* _tmp88_;
			GVariant* _tmp89_;
			GHashTable* _tmp90_;
			GVariantIter _tmp91_;
			GVariant* _tmp92_;
			GVariant* _tmp93_;
			if (_tmp81__size == _tmp81__length) {
				_tmp81__size = 2 * _tmp81__size;
				_tmp81_ = g_renew (RemoteServerField, _tmp81_, _tmp81__size + 1);
			}
			g_variant_iter_init (&_tmp85_, _tmp83_);
			_tmp86_ = g_variant_iter_next_value (&_tmp85_);
			_tmp84_.type = g_variant_dup_string (_tmp86_, NULL);
			g_variant_unref (_tmp86_);
			_tmp87_ = g_variant_iter_next_value (&_tmp85_);
			_tmp84_.required = g_variant_get_boolean (_tmp87_);
			g_variant_unref (_tmp87_);
			_tmp88_ = g_variant_iter_next_value (&_tmp85_);
			_tmp84_.default_value = g_variant_get_variant (_tmp88_);
			g_variant_unref (_tmp88_);
			_tmp89_ = g_variant_iter_next_value (&_tmp85_);
			_tmp90_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
			g_variant_iter_init (&_tmp91_, _tmp89_);
			while (g_variant_iter_loop (&_tmp91_, "{?*}", &_tmp92_, &_tmp93_)) {
				g_hash_table_insert (_tmp90_, g_variant_dup_string (_tmp92_, NULL), g_variant_get_variant (_tmp93_));
			}
			_tmp84_.properties = _tmp90_;
			g_variant_unref (_tmp89_);
			_tmp81_[_tmp81__length++] = _tmp84_;
			g_variant_unref (_tmp83_);
		}
		_tmp74_.fields_length1 = _tmp81__length1;
		_tmp74_.fields = _tmp81_;
		g_variant_unref (_tmp80_);
		_tmp94_ = g_variant_iter_next_value (&_tmp75_);
		_tmp95_ = g_new (RemoteServerApplication, 5);
		_tmp95__length = 0;
		_tmp95__size = 4;
		_tmp95__length1 = 0;
		g_variant_iter_init (&_tmp96_, _tmp94_);
		for (; (_tmp97_ = g_variant_iter_next_value (&_tmp96_)) != NULL; _tmp95__length1++) {
			RemoteServerApplication _tmp98_;
			GVariantIter _tmp99_;
			GVariant* _tmp100_;
			GVariant* _tmp101_;
			if (_tmp95__size == _tmp95__length) {
				_tmp95__size = 2 * _tmp95__size;
				_tmp95_ = g_renew (RemoteServerApplication, _tmp95_, _tmp95__size + 1);
			}
			g_variant_iter_init (&_tmp99_, _tmp97_);
			_tmp100_ = g_variant_iter_next_value (&_tmp99_);
			_tmp98_.application_id = g_variant_dup_string (_tmp100_, NULL);
			g_variant_unref (_tmp100_);
			_tmp101_ = g_variant_iter_next_value (&_tmp99_);
			_tmp98_.pin_position = g_variant_get_int32 (_tmp101_);
			g_variant_unref (_tmp101_);
			_tmp95_[_tmp95__length++] = _tmp98_;
			g_variant_unref (_tmp97_);
		}
		_tmp74_.applications_length1 = _tmp95__length1;
		_tmp74_.applications = _tmp95_;
		g_variant_unref (_tmp94_);
		_tmp71_[_tmp71__length++] = _tmp74_;
		g_variant_unref (_tmp73_);
	}
	_vala_serverList_length1 = _tmp71__length1;
	_vala_serverList = _tmp71_;
	g_variant_unref (_tmp70_);
	*serverList = _vala_serverList;
	*serverList_length1 = _vala_serverList_length1;
	g_object_unref (_reply_message);
}


static void remote_login_service_proxy_get_servers_for_login_async (RemoteLoginService* self, const gchar* url, const gchar* emailAddress, const gchar* password, gboolean allowCache, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.RemoteLogin", "GetServersForLogin");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (url));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (emailAddress));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (password));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (allowCache));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void remote_login_service_proxy_get_servers_for_login_finish (RemoteLoginService* self, GAsyncResult* _res_, gboolean* loginSuccess, gchar** dataType, RemoteServer** serverList, int* serverList_length1, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _vala_loginSuccess;
	GVariant* _tmp102_;
	gchar* _vala_dataType;
	GVariant* _tmp103_;
	RemoteServer* _vala_serverList;
	int _vala_serverList_length1;
	GVariant* _tmp104_;
	RemoteServer* _tmp105_;
	int _tmp105__length;
	int _tmp105__size;
	int _tmp105__length1;
	GVariantIter _tmp106_;
	GVariant* _tmp107_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp102_ = g_variant_iter_next_value (&_reply_iter);
	_vala_loginSuccess = g_variant_get_boolean (_tmp102_);
	g_variant_unref (_tmp102_);
	*loginSuccess = _vala_loginSuccess;
	_tmp103_ = g_variant_iter_next_value (&_reply_iter);
	_vala_dataType = g_variant_dup_string (_tmp103_, NULL);
	g_variant_unref (_tmp103_);
	*dataType = _vala_dataType;
	_vala_serverList_length1 = 0;
	_tmp104_ = g_variant_iter_next_value (&_reply_iter);
	_tmp105_ = g_new (RemoteServer, 5);
	_tmp105__length = 0;
	_tmp105__size = 4;
	_tmp105__length1 = 0;
	g_variant_iter_init (&_tmp106_, _tmp104_);
	for (; (_tmp107_ = g_variant_iter_next_value (&_tmp106_)) != NULL; _tmp105__length1++) {
		RemoteServer _tmp108_;
		GVariantIter _tmp109_;
		GVariant* _tmp110_;
		GVariant* _tmp111_;
		GVariant* _tmp112_;
		GVariant* _tmp113_;
		GVariant* _tmp114_;
		RemoteServerField* _tmp115_;
		int _tmp115__length;
		int _tmp115__size;
		int _tmp115__length1;
		GVariantIter _tmp116_;
		GVariant* _tmp117_;
		GVariant* _tmp128_;
		RemoteServerApplication* _tmp129_;
		int _tmp129__length;
		int _tmp129__size;
		int _tmp129__length1;
		GVariantIter _tmp130_;
		GVariant* _tmp131_;
		if (_tmp105__size == _tmp105__length) {
			_tmp105__size = 2 * _tmp105__size;
			_tmp105_ = g_renew (RemoteServer, _tmp105_, _tmp105__size + 1);
		}
		g_variant_iter_init (&_tmp109_, _tmp107_);
		_tmp110_ = g_variant_iter_next_value (&_tmp109_);
		_tmp108_.type = g_variant_dup_string (_tmp110_, NULL);
		g_variant_unref (_tmp110_);
		_tmp111_ = g_variant_iter_next_value (&_tmp109_);
		_tmp108_.name = g_variant_dup_string (_tmp111_, NULL);
		g_variant_unref (_tmp111_);
		_tmp112_ = g_variant_iter_next_value (&_tmp109_);
		_tmp108_.url = g_variant_dup_string (_tmp112_, NULL);
		g_variant_unref (_tmp112_);
		_tmp113_ = g_variant_iter_next_value (&_tmp109_);
		_tmp108_.last_used_server = g_variant_get_boolean (_tmp113_);
		g_variant_unref (_tmp113_);
		_tmp114_ = g_variant_iter_next_value (&_tmp109_);
		_tmp115_ = g_new (RemoteServerField, 5);
		_tmp115__length = 0;
		_tmp115__size = 4;
		_tmp115__length1 = 0;
		g_variant_iter_init (&_tmp116_, _tmp114_);
		for (; (_tmp117_ = g_variant_iter_next_value (&_tmp116_)) != NULL; _tmp115__length1++) {
			RemoteServerField _tmp118_;
			GVariantIter _tmp119_;
			GVariant* _tmp120_;
			GVariant* _tmp121_;
			GVariant* _tmp122_;
			GVariant* _tmp123_;
			GHashTable* _tmp124_;
			GVariantIter _tmp125_;
			GVariant* _tmp126_;
			GVariant* _tmp127_;
			if (_tmp115__size == _tmp115__length) {
				_tmp115__size = 2 * _tmp115__size;
				_tmp115_ = g_renew (RemoteServerField, _tmp115_, _tmp115__size + 1);
			}
			g_variant_iter_init (&_tmp119_, _tmp117_);
			_tmp120_ = g_variant_iter_next_value (&_tmp119_);
			_tmp118_.type = g_variant_dup_string (_tmp120_, NULL);
			g_variant_unref (_tmp120_);
			_tmp121_ = g_variant_iter_next_value (&_tmp119_);
			_tmp118_.required = g_variant_get_boolean (_tmp121_);
			g_variant_unref (_tmp121_);
			_tmp122_ = g_variant_iter_next_value (&_tmp119_);
			_tmp118_.default_value = g_variant_get_variant (_tmp122_);
			g_variant_unref (_tmp122_);
			_tmp123_ = g_variant_iter_next_value (&_tmp119_);
			_tmp124_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
			g_variant_iter_init (&_tmp125_, _tmp123_);
			while (g_variant_iter_loop (&_tmp125_, "{?*}", &_tmp126_, &_tmp127_)) {
				g_hash_table_insert (_tmp124_, g_variant_dup_string (_tmp126_, NULL), g_variant_get_variant (_tmp127_));
			}
			_tmp118_.properties = _tmp124_;
			g_variant_unref (_tmp123_);
			_tmp115_[_tmp115__length++] = _tmp118_;
			g_variant_unref (_tmp117_);
		}
		_tmp108_.fields_length1 = _tmp115__length1;
		_tmp108_.fields = _tmp115_;
		g_variant_unref (_tmp114_);
		_tmp128_ = g_variant_iter_next_value (&_tmp109_);
		_tmp129_ = g_new (RemoteServerApplication, 5);
		_tmp129__length = 0;
		_tmp129__size = 4;
		_tmp129__length1 = 0;
		g_variant_iter_init (&_tmp130_, _tmp128_);
		for (; (_tmp131_ = g_variant_iter_next_value (&_tmp130_)) != NULL; _tmp129__length1++) {
			RemoteServerApplication _tmp132_;
			GVariantIter _tmp133_;
			GVariant* _tmp134_;
			GVariant* _tmp135_;
			if (_tmp129__size == _tmp129__length) {
				_tmp129__size = 2 * _tmp129__size;
				_tmp129_ = g_renew (RemoteServerApplication, _tmp129_, _tmp129__size + 1);
			}
			g_variant_iter_init (&_tmp133_, _tmp131_);
			_tmp134_ = g_variant_iter_next_value (&_tmp133_);
			_tmp132_.application_id = g_variant_dup_string (_tmp134_, NULL);
			g_variant_unref (_tmp134_);
			_tmp135_ = g_variant_iter_next_value (&_tmp133_);
			_tmp132_.pin_position = g_variant_get_int32 (_tmp135_);
			g_variant_unref (_tmp135_);
			_tmp129_[_tmp129__length++] = _tmp132_;
			g_variant_unref (_tmp131_);
		}
		_tmp108_.applications_length1 = _tmp129__length1;
		_tmp108_.applications = _tmp129_;
		g_variant_unref (_tmp128_);
		_tmp105_[_tmp105__length++] = _tmp108_;
		g_variant_unref (_tmp107_);
	}
	_vala_serverList_length1 = _tmp105__length1;
	_vala_serverList = _tmp105_;
	g_variant_unref (_tmp104_);
	*serverList = _vala_serverList;
	*serverList_length1 = _vala_serverList_length1;
	g_object_unref (_reply_message);
}


static void remote_login_service_proxy_get_cached_domains_for_server_async (RemoteLoginService* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.RemoteLogin", "GetCachedDomainsForServer");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (url));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void remote_login_service_proxy_get_cached_domains_for_server_finish (RemoteLoginService* self, GAsyncResult* _res_, gchar*** domains, int* domains_length1, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _vala_domains;
	int _vala_domains_length1;
	GVariant* _tmp136_;
	gchar** _tmp137_;
	int _tmp137__length;
	int _tmp137__size;
	int _tmp137__length1;
	GVariantIter _tmp138_;
	GVariant* _tmp139_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_vala_domains_length1 = 0;
	_tmp136_ = g_variant_iter_next_value (&_reply_iter);
	_tmp137_ = g_new (gchar*, 5);
	_tmp137__length = 0;
	_tmp137__size = 4;
	_tmp137__length1 = 0;
	g_variant_iter_init (&_tmp138_, _tmp136_);
	for (; (_tmp139_ = g_variant_iter_next_value (&_tmp138_)) != NULL; _tmp137__length1++) {
		if (_tmp137__size == _tmp137__length) {
			_tmp137__size = 2 * _tmp137__size;
			_tmp137_ = g_renew (gchar*, _tmp137_, _tmp137__size + 1);
		}
		_tmp137_[_tmp137__length++] = g_variant_dup_string (_tmp139_, NULL);
		g_variant_unref (_tmp139_);
	}
	_vala_domains_length1 = _tmp137__length1;
	_tmp137_[_tmp137__length] = NULL;
	_vala_domains = _tmp137_;
	g_variant_unref (_tmp136_);
	*domains = _vala_domains;
	*domains_length1 = _vala_domains_length1;
	g_object_unref (_reply_message);
}


static void remote_login_service_proxy_set_last_used_server_async (RemoteLoginService* self, const gchar* uccsUrl, const gchar* serverUrl, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.RemoteLogin", "SetLastUsedServer");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uccsUrl));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (serverUrl));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void remote_login_service_proxy_set_last_used_server_finish (RemoteLoginService* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void remote_login_service_proxy_remote_login_service_interface_init (RemoteLoginServiceIface* iface) {
	iface->get_servers = remote_login_service_proxy_get_servers_async;
	iface->get_servers_finish = remote_login_service_proxy_get_servers_finish;
	iface->get_servers_for_login = remote_login_service_proxy_get_servers_for_login_async;
	iface->get_servers_for_login_finish = remote_login_service_proxy_get_servers_for_login_finish;
	iface->get_cached_domains_for_server = remote_login_service_proxy_get_cached_domains_for_server_async;
	iface->get_cached_domains_for_server_finish = remote_login_service_proxy_get_cached_domains_for_server_finish;
	iface->set_last_used_server = remote_login_service_proxy_set_last_used_server_async;
	iface->set_last_used_server_finish = remote_login_service_proxy_set_last_used_server_finish;
}


static void _dbus_remote_login_service_get_servers (RemoteLoginService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	remote_login_service_get_servers (self, (GAsyncReadyCallback) _dbus_remote_login_service_get_servers_ready, invocation);
}


static void _dbus_remote_login_service_get_servers_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	RemoteServer* serverList = NULL;
	int serverList_length1 = 0;
	RemoteServer* _tmp140_;
	GVariantBuilder _tmp141_;
	int _tmp142_;
	invocation = _user_data_;
	remote_login_service_get_servers_finish ((RemoteLoginService*) source_object, _res_, &serverList, &serverList_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp140_ = serverList;
	g_variant_builder_init (&_tmp141_, G_VARIANT_TYPE ("a(sssba(sbva{sv})a(si))"));
	for (_tmp142_ = 0; _tmp142_ < serverList_length1; _tmp142_++) {
		GVariantBuilder _tmp143_;
		RemoteServerField* _tmp144_;
		GVariantBuilder _tmp145_;
		int _tmp146_;
		RemoteServerApplication* _tmp152_;
		GVariantBuilder _tmp153_;
		int _tmp154_;
		g_variant_builder_init (&_tmp143_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp143_, g_variant_new_string ((*_tmp140_).type));
		g_variant_builder_add_value (&_tmp143_, g_variant_new_string ((*_tmp140_).name));
		g_variant_builder_add_value (&_tmp143_, g_variant_new_string ((*_tmp140_).url));
		g_variant_builder_add_value (&_tmp143_, g_variant_new_boolean ((*_tmp140_).last_used_server));
		_tmp144_ = (*_tmp140_).fields;
		g_variant_builder_init (&_tmp145_, G_VARIANT_TYPE ("a(sbva{sv})"));
		for (_tmp146_ = 0; _tmp146_ < (*_tmp140_).fields_length1; _tmp146_++) {
			GVariantBuilder _tmp147_;
			GVariantBuilder _tmp148_;
			GHashTableIter _tmp149_;
			gpointer _tmp150_;
			gpointer _tmp151_;
			g_variant_builder_init (&_tmp147_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp147_, g_variant_new_string ((*_tmp144_).type));
			g_variant_builder_add_value (&_tmp147_, g_variant_new_boolean ((*_tmp144_).required));
			g_variant_builder_add_value (&_tmp147_, g_variant_new_variant ((*_tmp144_).default_value));
			g_hash_table_iter_init (&_tmp149_, (*_tmp144_).properties);
			g_variant_builder_init (&_tmp148_, G_VARIANT_TYPE ("a{sv}"));
			while (g_hash_table_iter_next (&_tmp149_, &_tmp150_, &_tmp151_)) {
				gchar* _key;
				GVariant* _value;
				_key = (gchar*) _tmp150_;
				_value = (GVariant*) _tmp151_;
				g_variant_builder_add (&_tmp148_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
			}
			g_variant_builder_add_value (&_tmp147_, g_variant_builder_end (&_tmp148_));
			g_variant_builder_add_value (&_tmp145_, g_variant_builder_end (&_tmp147_));
			_tmp144_++;
		}
		g_variant_builder_add_value (&_tmp143_, g_variant_builder_end (&_tmp145_));
		_tmp152_ = (*_tmp140_).applications;
		g_variant_builder_init (&_tmp153_, G_VARIANT_TYPE ("a(si)"));
		for (_tmp154_ = 0; _tmp154_ < (*_tmp140_).applications_length1; _tmp154_++) {
			GVariantBuilder _tmp155_;
			g_variant_builder_init (&_tmp155_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp155_, g_variant_new_string ((*_tmp152_).application_id));
			g_variant_builder_add_value (&_tmp155_, g_variant_new_int32 ((*_tmp152_).pin_position));
			g_variant_builder_add_value (&_tmp153_, g_variant_builder_end (&_tmp155_));
			_tmp152_++;
		}
		g_variant_builder_add_value (&_tmp143_, g_variant_builder_end (&_tmp153_));
		g_variant_builder_add_value (&_tmp141_, g_variant_builder_end (&_tmp143_));
		_tmp140_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp141_));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	serverList = (_vala_RemoteServer_array_free (serverList, serverList_length1), NULL);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_remote_login_service_get_servers_for_login (RemoteLoginService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* url = NULL;
	GVariant* _tmp156_;
	gchar* emailAddress = NULL;
	GVariant* _tmp157_;
	gchar* password = NULL;
	GVariant* _tmp158_;
	gboolean allowCache = FALSE;
	GVariant* _tmp159_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp156_ = g_variant_iter_next_value (&_arguments_iter);
	url = g_variant_dup_string (_tmp156_, NULL);
	g_variant_unref (_tmp156_);
	_tmp157_ = g_variant_iter_next_value (&_arguments_iter);
	emailAddress = g_variant_dup_string (_tmp157_, NULL);
	g_variant_unref (_tmp157_);
	_tmp158_ = g_variant_iter_next_value (&_arguments_iter);
	password = g_variant_dup_string (_tmp158_, NULL);
	g_variant_unref (_tmp158_);
	_tmp159_ = g_variant_iter_next_value (&_arguments_iter);
	allowCache = g_variant_get_boolean (_tmp159_);
	g_variant_unref (_tmp159_);
	remote_login_service_get_servers_for_login (self, url, emailAddress, password, allowCache, (GAsyncReadyCallback) _dbus_remote_login_service_get_servers_for_login_ready, invocation);
	_g_free0 (url);
	_g_free0 (emailAddress);
	_g_free0 (password);
}


static void _dbus_remote_login_service_get_servers_for_login_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean loginSuccess = FALSE;
	gchar* dataType = NULL;
	RemoteServer* serverList = NULL;
	int serverList_length1 = 0;
	RemoteServer* _tmp160_;
	GVariantBuilder _tmp161_;
	int _tmp162_;
	invocation = _user_data_;
	remote_login_service_get_servers_for_login_finish ((RemoteLoginService*) source_object, _res_, &loginSuccess, &dataType, &serverList, &serverList_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (loginSuccess));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (dataType));
	_tmp160_ = serverList;
	g_variant_builder_init (&_tmp161_, G_VARIANT_TYPE ("a(sssba(sbva{sv})a(si))"));
	for (_tmp162_ = 0; _tmp162_ < serverList_length1; _tmp162_++) {
		GVariantBuilder _tmp163_;
		RemoteServerField* _tmp164_;
		GVariantBuilder _tmp165_;
		int _tmp166_;
		RemoteServerApplication* _tmp172_;
		GVariantBuilder _tmp173_;
		int _tmp174_;
		g_variant_builder_init (&_tmp163_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp163_, g_variant_new_string ((*_tmp160_).type));
		g_variant_builder_add_value (&_tmp163_, g_variant_new_string ((*_tmp160_).name));
		g_variant_builder_add_value (&_tmp163_, g_variant_new_string ((*_tmp160_).url));
		g_variant_builder_add_value (&_tmp163_, g_variant_new_boolean ((*_tmp160_).last_used_server));
		_tmp164_ = (*_tmp160_).fields;
		g_variant_builder_init (&_tmp165_, G_VARIANT_TYPE ("a(sbva{sv})"));
		for (_tmp166_ = 0; _tmp166_ < (*_tmp160_).fields_length1; _tmp166_++) {
			GVariantBuilder _tmp167_;
			GVariantBuilder _tmp168_;
			GHashTableIter _tmp169_;
			gpointer _tmp170_;
			gpointer _tmp171_;
			g_variant_builder_init (&_tmp167_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp167_, g_variant_new_string ((*_tmp164_).type));
			g_variant_builder_add_value (&_tmp167_, g_variant_new_boolean ((*_tmp164_).required));
			g_variant_builder_add_value (&_tmp167_, g_variant_new_variant ((*_tmp164_).default_value));
			g_hash_table_iter_init (&_tmp169_, (*_tmp164_).properties);
			g_variant_builder_init (&_tmp168_, G_VARIANT_TYPE ("a{sv}"));
			while (g_hash_table_iter_next (&_tmp169_, &_tmp170_, &_tmp171_)) {
				gchar* _key;
				GVariant* _value;
				_key = (gchar*) _tmp170_;
				_value = (GVariant*) _tmp171_;
				g_variant_builder_add (&_tmp168_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
			}
			g_variant_builder_add_value (&_tmp167_, g_variant_builder_end (&_tmp168_));
			g_variant_builder_add_value (&_tmp165_, g_variant_builder_end (&_tmp167_));
			_tmp164_++;
		}
		g_variant_builder_add_value (&_tmp163_, g_variant_builder_end (&_tmp165_));
		_tmp172_ = (*_tmp160_).applications;
		g_variant_builder_init (&_tmp173_, G_VARIANT_TYPE ("a(si)"));
		for (_tmp174_ = 0; _tmp174_ < (*_tmp160_).applications_length1; _tmp174_++) {
			GVariantBuilder _tmp175_;
			g_variant_builder_init (&_tmp175_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp175_, g_variant_new_string ((*_tmp172_).application_id));
			g_variant_builder_add_value (&_tmp175_, g_variant_new_int32 ((*_tmp172_).pin_position));
			g_variant_builder_add_value (&_tmp173_, g_variant_builder_end (&_tmp175_));
			_tmp172_++;
		}
		g_variant_builder_add_value (&_tmp163_, g_variant_builder_end (&_tmp173_));
		g_variant_builder_add_value (&_tmp161_, g_variant_builder_end (&_tmp163_));
		_tmp160_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp161_));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (dataType);
	serverList = (_vala_RemoteServer_array_free (serverList, serverList_length1), NULL);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_remote_login_service_get_cached_domains_for_server (RemoteLoginService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* url = NULL;
	GVariant* _tmp176_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp176_ = g_variant_iter_next_value (&_arguments_iter);
	url = g_variant_dup_string (_tmp176_, NULL);
	g_variant_unref (_tmp176_);
	remote_login_service_get_cached_domains_for_server (self, url, (GAsyncReadyCallback) _dbus_remote_login_service_get_cached_domains_for_server_ready, invocation);
	_g_free0 (url);
}


static void _dbus_remote_login_service_get_cached_domains_for_server_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** domains = NULL;
	int domains_length1 = 0;
	gchar** _tmp177_;
	GVariantBuilder _tmp178_;
	int _tmp179_;
	invocation = _user_data_;
	remote_login_service_get_cached_domains_for_server_finish ((RemoteLoginService*) source_object, _res_, &domains, &domains_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp177_ = domains;
	g_variant_builder_init (&_tmp178_, G_VARIANT_TYPE ("as"));
	for (_tmp179_ = 0; _tmp179_ < domains_length1; _tmp179_++) {
		g_variant_builder_add_value (&_tmp178_, g_variant_new_string (*_tmp177_));
		_tmp177_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp178_));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_remote_login_service_set_last_used_server (RemoteLoginService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* uccsUrl = NULL;
	GVariant* _tmp180_;
	gchar* serverUrl = NULL;
	GVariant* _tmp181_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp180_ = g_variant_iter_next_value (&_arguments_iter);
	uccsUrl = g_variant_dup_string (_tmp180_, NULL);
	g_variant_unref (_tmp180_);
	_tmp181_ = g_variant_iter_next_value (&_arguments_iter);
	serverUrl = g_variant_dup_string (_tmp181_, NULL);
	g_variant_unref (_tmp181_);
	remote_login_service_set_last_used_server (self, uccsUrl, serverUrl, (GAsyncReadyCallback) _dbus_remote_login_service_set_last_used_server_ready, invocation);
	_g_free0 (uccsUrl);
	_g_free0 (serverUrl);
}


static void _dbus_remote_login_service_set_last_used_server_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	remote_login_service_set_last_used_server_finish ((RemoteLoginService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void remote_login_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetServers") == 0) {
		_dbus_remote_login_service_get_servers (object, parameters, invocation);
	} else if (strcmp (method_name, "GetServersForLogin") == 0) {
		_dbus_remote_login_service_get_servers_for_login (object, parameters, invocation);
	} else if (strcmp (method_name, "GetCachedDomainsForServer") == 0) {
		_dbus_remote_login_service_get_cached_domains_for_server (object, parameters, invocation);
	} else if (strcmp (method_name, "SetLastUsedServer") == 0) {
		_dbus_remote_login_service_set_last_used_server (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* remote_login_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean remote_login_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_remote_login_service_servers_updated (GObject* _sender, RemoteServer* serverList, int serverList_length1, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	RemoteServer* _tmp182_;
	GVariantBuilder _tmp183_;
	int _tmp184_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp182_ = serverList;
	g_variant_builder_init (&_tmp183_, G_VARIANT_TYPE ("a(sssba(sbva{sv})a(si))"));
	for (_tmp184_ = 0; _tmp184_ < serverList_length1; _tmp184_++) {
		GVariantBuilder _tmp185_;
		RemoteServerField* _tmp186_;
		GVariantBuilder _tmp187_;
		int _tmp188_;
		RemoteServerApplication* _tmp194_;
		GVariantBuilder _tmp195_;
		int _tmp196_;
		g_variant_builder_init (&_tmp185_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp185_, g_variant_new_string ((*_tmp182_).type));
		g_variant_builder_add_value (&_tmp185_, g_variant_new_string ((*_tmp182_).name));
		g_variant_builder_add_value (&_tmp185_, g_variant_new_string ((*_tmp182_).url));
		g_variant_builder_add_value (&_tmp185_, g_variant_new_boolean ((*_tmp182_).last_used_server));
		_tmp186_ = (*_tmp182_).fields;
		g_variant_builder_init (&_tmp187_, G_VARIANT_TYPE ("a(sbva{sv})"));
		for (_tmp188_ = 0; _tmp188_ < (*_tmp182_).fields_length1; _tmp188_++) {
			GVariantBuilder _tmp189_;
			GVariantBuilder _tmp190_;
			GHashTableIter _tmp191_;
			gpointer _tmp192_;
			gpointer _tmp193_;
			g_variant_builder_init (&_tmp189_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp189_, g_variant_new_string ((*_tmp186_).type));
			g_variant_builder_add_value (&_tmp189_, g_variant_new_boolean ((*_tmp186_).required));
			g_variant_builder_add_value (&_tmp189_, g_variant_new_variant ((*_tmp186_).default_value));
			g_hash_table_iter_init (&_tmp191_, (*_tmp186_).properties);
			g_variant_builder_init (&_tmp190_, G_VARIANT_TYPE ("a{sv}"));
			while (g_hash_table_iter_next (&_tmp191_, &_tmp192_, &_tmp193_)) {
				gchar* _key;
				GVariant* _value;
				_key = (gchar*) _tmp192_;
				_value = (GVariant*) _tmp193_;
				g_variant_builder_add (&_tmp190_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
			}
			g_variant_builder_add_value (&_tmp189_, g_variant_builder_end (&_tmp190_));
			g_variant_builder_add_value (&_tmp187_, g_variant_builder_end (&_tmp189_));
			_tmp186_++;
		}
		g_variant_builder_add_value (&_tmp185_, g_variant_builder_end (&_tmp187_));
		_tmp194_ = (*_tmp182_).applications;
		g_variant_builder_init (&_tmp195_, G_VARIANT_TYPE ("a(si)"));
		for (_tmp196_ = 0; _tmp196_ < (*_tmp182_).applications_length1; _tmp196_++) {
			GVariantBuilder _tmp197_;
			g_variant_builder_init (&_tmp197_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp197_, g_variant_new_string ((*_tmp194_).application_id));
			g_variant_builder_add_value (&_tmp197_, g_variant_new_int32 ((*_tmp194_).pin_position));
			g_variant_builder_add_value (&_tmp195_, g_variant_builder_end (&_tmp197_));
			_tmp194_++;
		}
		g_variant_builder_add_value (&_tmp185_, g_variant_builder_end (&_tmp195_));
		g_variant_builder_add_value (&_tmp183_, g_variant_builder_end (&_tmp185_));
		_tmp182_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp183_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.RemoteLogin", "ServersUpdated", _arguments, NULL);
}


static void _dbus_remote_login_service_login_servers_updated (GObject* _sender, const gchar* url, const gchar* emailAddress, const gchar* dataType, RemoteServer* serverList, int serverList_length1, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	RemoteServer* _tmp198_;
	GVariantBuilder _tmp199_;
	int _tmp200_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (url));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (emailAddress));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (dataType));
	_tmp198_ = serverList;
	g_variant_builder_init (&_tmp199_, G_VARIANT_TYPE ("a(sssba(sbva{sv})a(si))"));
	for (_tmp200_ = 0; _tmp200_ < serverList_length1; _tmp200_++) {
		GVariantBuilder _tmp201_;
		RemoteServerField* _tmp202_;
		GVariantBuilder _tmp203_;
		int _tmp204_;
		RemoteServerApplication* _tmp210_;
		GVariantBuilder _tmp211_;
		int _tmp212_;
		g_variant_builder_init (&_tmp201_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp201_, g_variant_new_string ((*_tmp198_).type));
		g_variant_builder_add_value (&_tmp201_, g_variant_new_string ((*_tmp198_).name));
		g_variant_builder_add_value (&_tmp201_, g_variant_new_string ((*_tmp198_).url));
		g_variant_builder_add_value (&_tmp201_, g_variant_new_boolean ((*_tmp198_).last_used_server));
		_tmp202_ = (*_tmp198_).fields;
		g_variant_builder_init (&_tmp203_, G_VARIANT_TYPE ("a(sbva{sv})"));
		for (_tmp204_ = 0; _tmp204_ < (*_tmp198_).fields_length1; _tmp204_++) {
			GVariantBuilder _tmp205_;
			GVariantBuilder _tmp206_;
			GHashTableIter _tmp207_;
			gpointer _tmp208_;
			gpointer _tmp209_;
			g_variant_builder_init (&_tmp205_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp205_, g_variant_new_string ((*_tmp202_).type));
			g_variant_builder_add_value (&_tmp205_, g_variant_new_boolean ((*_tmp202_).required));
			g_variant_builder_add_value (&_tmp205_, g_variant_new_variant ((*_tmp202_).default_value));
			g_hash_table_iter_init (&_tmp207_, (*_tmp202_).properties);
			g_variant_builder_init (&_tmp206_, G_VARIANT_TYPE ("a{sv}"));
			while (g_hash_table_iter_next (&_tmp207_, &_tmp208_, &_tmp209_)) {
				gchar* _key;
				GVariant* _value;
				_key = (gchar*) _tmp208_;
				_value = (GVariant*) _tmp209_;
				g_variant_builder_add (&_tmp206_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
			}
			g_variant_builder_add_value (&_tmp205_, g_variant_builder_end (&_tmp206_));
			g_variant_builder_add_value (&_tmp203_, g_variant_builder_end (&_tmp205_));
			_tmp202_++;
		}
		g_variant_builder_add_value (&_tmp201_, g_variant_builder_end (&_tmp203_));
		_tmp210_ = (*_tmp198_).applications;
		g_variant_builder_init (&_tmp211_, G_VARIANT_TYPE ("a(si)"));
		for (_tmp212_ = 0; _tmp212_ < (*_tmp198_).applications_length1; _tmp212_++) {
			GVariantBuilder _tmp213_;
			g_variant_builder_init (&_tmp213_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp213_, g_variant_new_string ((*_tmp210_).application_id));
			g_variant_builder_add_value (&_tmp213_, g_variant_new_int32 ((*_tmp210_).pin_position));
			g_variant_builder_add_value (&_tmp211_, g_variant_builder_end (&_tmp213_));
			_tmp210_++;
		}
		g_variant_builder_add_value (&_tmp201_, g_variant_builder_end (&_tmp211_));
		g_variant_builder_add_value (&_tmp199_, g_variant_builder_end (&_tmp201_));
		_tmp198_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp199_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.RemoteLogin", "LoginServersUpdated", _arguments, NULL);
}


static void _dbus_remote_login_service_login_changed (GObject* _sender, const gchar* url, const gchar* emailAddress, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (url));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (emailAddress));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.RemoteLogin", "LoginChanged", _arguments, NULL);
}


guint remote_login_service_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_remote_login_service_dbus_interface_info), &_remote_login_service_dbus_interface_vtable, data, _remote_login_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "servers-updated", (GCallback) _dbus_remote_login_service_servers_updated, data);
	g_signal_connect (object, "login-servers-updated", (GCallback) _dbus_remote_login_service_login_servers_updated, data);
	g_signal_connect (object, "login-changed", (GCallback) _dbus_remote_login_service_login_changed, data);
	return result;
}


static void _remote_login_service_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_remote_login_service_servers_updated, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_remote_login_service_login_servers_updated, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_remote_login_service_login_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



