/* folder.c generated by valac 0.14.2, the Vala compiler
 * generated from folder.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>


#define UNITY_FILES_LENS_TYPE_BOOKMARKS (unity_files_lens_bookmarks_get_type ())
#define UNITY_FILES_LENS_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_FILES_LENS_TYPE_BOOKMARKS, UnityFilesLensBookmarks))
#define UNITY_FILES_LENS_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_FILES_LENS_TYPE_BOOKMARKS, UnityFilesLensBookmarksClass))
#define UNITY_FILES_LENS_IS_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_FILES_LENS_TYPE_BOOKMARKS))
#define UNITY_FILES_LENS_IS_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_FILES_LENS_TYPE_BOOKMARKS))
#define UNITY_FILES_LENS_BOOKMARKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_FILES_LENS_TYPE_BOOKMARKS, UnityFilesLensBookmarksClass))

typedef struct _UnityFilesLensBookmarks UnityFilesLensBookmarks;
typedef struct _UnityFilesLensBookmarksClass UnityFilesLensBookmarksClass;
typedef struct _UnityFilesLensBookmarksPrivate UnityFilesLensBookmarksPrivate;

#define UNITY_FILES_LENS_TYPE_BOOKMARK (unity_files_lens_bookmark_get_type ())
#define UNITY_FILES_LENS_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_FILES_LENS_TYPE_BOOKMARK, UnityFilesLensBookmark))
#define UNITY_FILES_LENS_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_FILES_LENS_TYPE_BOOKMARK, UnityFilesLensBookmarkClass))
#define UNITY_FILES_LENS_IS_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_FILES_LENS_TYPE_BOOKMARK))
#define UNITY_FILES_LENS_IS_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_FILES_LENS_TYPE_BOOKMARK))
#define UNITY_FILES_LENS_BOOKMARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_FILES_LENS_TYPE_BOOKMARK, UnityFilesLensBookmarkClass))

typedef struct _UnityFilesLensBookmark UnityFilesLensBookmark;
typedef struct _UnityFilesLensBookmarkClass UnityFilesLensBookmarkClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _UnityFilesLensBookmarkPrivate UnityFilesLensBookmarkPrivate;

struct _UnityFilesLensBookmarks {
	GObject parent_instance;
	UnityFilesLensBookmarksPrivate * priv;
};

struct _UnityFilesLensBookmarksClass {
	GObjectClass parent_class;
};

struct _UnityFilesLensBookmarksPrivate {
	GList* bookmarks;
	gchar* bookmarks_file;
	GFileMonitor* monitor;
};

struct _UnityFilesLensBookmark {
	GObject parent_instance;
	UnityFilesLensBookmarkPrivate * priv;
};

struct _UnityFilesLensBookmarkClass {
	GObjectClass parent_class;
};

struct _UnityFilesLensBookmarkPrivate {
	gchar* _uri;
	gchar* _icon;
	gchar* _mimetype;
	gchar* _display_name;
	gchar* _dnd_uri;
	GList* index_terms;
};


static gpointer unity_files_lens_bookmarks_parent_class = NULL;
static gpointer unity_files_lens_bookmark_parent_class = NULL;

GType unity_files_lens_bookmarks_get_type (void) G_GNUC_CONST;
GType unity_files_lens_bookmark_get_type (void) G_GNUC_CONST;
#define UNITY_FILES_LENS_BOOKMARKS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_FILES_LENS_TYPE_BOOKMARKS, UnityFilesLensBookmarksPrivate))
enum  {
	UNITY_FILES_LENS_BOOKMARKS_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
UnityFilesLensBookmarks* unity_files_lens_bookmarks_new (void);
UnityFilesLensBookmarks* unity_files_lens_bookmarks_construct (GType object_type);
static void unity_files_lens_bookmarks_update (UnityFilesLensBookmarks* self);
static void ___lambda1_ (UnityFilesLensBookmarks* self, GFileMonitor* mon, GFile* file, GFile* other_file, GFileMonitorEvent event_type);
static void ____lambda1__g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
UnityFilesLensBookmark* unity_files_lens_bookmark_new (const gchar* uri, const gchar* mimetype, const gchar* display_name);
UnityFilesLensBookmark* unity_files_lens_bookmark_construct (GType object_type, const gchar* uri, const gchar* mimetype, const gchar* display_name);
static GList* unity_files_lens_bookmarks_filter_bookmarks (UnityFilesLensBookmarks* self, GList* bm_list);
const gchar* unity_files_lens_bookmark_get_uri (UnityFilesLensBookmark* self);
GList* unity_files_lens_bookmarks_list (UnityFilesLensBookmarks* self);
GList* unity_files_lens_bookmarks_prefix_search (UnityFilesLensBookmarks* self, const gchar* search);
gchar* unity_files_lens_utils_normalize_string (const gchar* input);
GList* unity_files_lens_bookmark_get_index_terms (UnityFilesLensBookmark* self);
gboolean unity_files_lens_bookmarks_launch_if_bookmark (UnityFilesLensBookmarks* self, const gchar* uri, GError** error);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void unity_files_lens_bookmarks_finalize (GObject* obj);
#define UNITY_FILES_LENS_BOOKMARK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_FILES_LENS_TYPE_BOOKMARK, UnityFilesLensBookmarkPrivate))
enum  {
	UNITY_FILES_LENS_BOOKMARK_DUMMY_PROPERTY,
	UNITY_FILES_LENS_BOOKMARK_URI,
	UNITY_FILES_LENS_BOOKMARK_ICON,
	UNITY_FILES_LENS_BOOKMARK_MIMETYPE,
	UNITY_FILES_LENS_BOOKMARK_DISPLAY_NAME,
	UNITY_FILES_LENS_BOOKMARK_DND_URI
};
gchar* unity_files_lens_utils_get_icon_for_uri (const gchar* uri, const gchar* mimetype);
void unity_files_lens_bookmark_set_uri (UnityFilesLensBookmark* self, const gchar* value);
const gchar* unity_files_lens_bookmark_get_icon (UnityFilesLensBookmark* self);
void unity_files_lens_bookmark_set_icon (UnityFilesLensBookmark* self, const gchar* value);
const gchar* unity_files_lens_bookmark_get_mimetype (UnityFilesLensBookmark* self);
void unity_files_lens_bookmark_set_mimetype (UnityFilesLensBookmark* self, const gchar* value);
const gchar* unity_files_lens_bookmark_get_display_name (UnityFilesLensBookmark* self);
void unity_files_lens_bookmark_set_display_name (UnityFilesLensBookmark* self, const gchar* value);
const gchar* unity_files_lens_bookmark_get_dnd_uri (UnityFilesLensBookmark* self);
void unity_files_lens_bookmark_set_dnd_uri (UnityFilesLensBookmark* self, const gchar* value);
static void unity_files_lens_bookmark_finalize (GObject* obj);
static void _vala_unity_files_lens_bookmark_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_files_lens_bookmark_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void ___lambda1_ (UnityFilesLensBookmarks* self, GFileMonitor* mon, GFile* file, GFile* other_file, GFileMonitorEvent event_type) {
	g_return_if_fail (mon != NULL);
	g_return_if_fail (file != NULL);
	g_debug ("folder.vala:41: Bookmarks changed. Updating.");
	unity_files_lens_bookmarks_update (self);
	g_signal_emit_by_name (self, "changed");
}


static void ____lambda1__g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	___lambda1_ (self, _sender, file, other_file, event_type);
}


UnityFilesLensBookmarks* unity_files_lens_bookmarks_construct (GType object_type) {
	UnityFilesLensBookmarks * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	self = (UnityFilesLensBookmarks*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat (_tmp1_, "/.gtk-bookmarks", NULL);
	_g_free0 (self->priv->bookmarks_file);
	self->priv->bookmarks_file = _tmp2_;
	unity_files_lens_bookmarks_update (self);
	{
		const gchar* _tmp3_;
		GFile* _tmp4_ = NULL;
		GFile* _tmp5_;
		GFileMonitor* _tmp6_ = NULL;
		GFileMonitor* _tmp7_;
		GFileMonitor* _tmp8_;
		GFileMonitor* _tmp9_;
		GFileMonitor* _tmp10_;
		GFileMonitor* _tmp11_;
		_tmp3_ = self->priv->bookmarks_file;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_monitor (_tmp5_, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (self->priv->monitor);
		self->priv->monitor = _tmp9_;
		_tmp10_ = self->priv->monitor;
		g_file_monitor_set_rate_limit (_tmp10_, 2000);
		_tmp11_ = self->priv->monitor;
		g_signal_connect_object (_tmp11_, "changed", (GCallback) ____lambda1__g_file_monitor_changed, self, 0);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = self->priv->bookmarks_file;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("folder.vala:46: Failed to install file monitor on %s. Bookmarks monito" \
"ring disabled: %s", _tmp12_, _tmp14_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


UnityFilesLensBookmarks* unity_files_lens_bookmarks_new (void) {
	return unity_files_lens_bookmarks_construct (UNITY_FILES_LENS_TYPE_BOOKMARKS);
}


static void unity_files_lens_bookmarks_update (UnityFilesLensBookmarks* self) {
	gchar* contents = NULL;
	gchar* desktop_uri = NULL;
	gboolean has_desktop_in_favourites;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* desktop_file;
	GFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_ = NULL;
	gchar** favorites;
	gint favorites_length1;
	gint _favorites_size_;
	gchar* _tmp11_;
	gchar* mimetype;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gboolean _tmp41_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	__g_list_free__g_object_unref0_0 (self->priv->bookmarks);
	self->priv->bookmarks = NULL;
	has_desktop_in_favourites = FALSE;
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_DESKTOP);
	_tmp1_ = g_file_new_for_path (_tmp0_);
	desktop_file = _tmp1_;
	_tmp2_ = desktop_file;
	_tmp3_ = g_file_get_uri (_tmp2_);
	_g_free0 (desktop_uri);
	desktop_uri = _tmp3_;
	{
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp4_ = self->priv->bookmarks_file;
		g_file_get_contents (_tmp4_, &_tmp5_, NULL, &_inner_error_);
		_g_free0 (contents);
		contents = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch6_g_file_error;
			}
			_g_object_unref0 (desktop_file);
			_g_free0 (desktop_uri);
			_g_free0 (contents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally6;
	__catch6_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("folder.vala:65: Failed to read favorites: %s", _tmp7_);
		_g_error_free0 (e);
		_g_object_unref0 (desktop_file);
		_g_free0 (desktop_uri);
		_g_free0 (contents);
		return;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (desktop_file);
		_g_free0 (desktop_uri);
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = contents;
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "\n", 0);
	favorites = _tmp10_;
	favorites_length1 = _vala_array_length (_tmp9_);
	_favorites_size_ = favorites_length1;
	_tmp11_ = g_strdup ("inode/directory");
	mimetype = _tmp11_;
	_tmp12_ = favorites;
	_tmp12__length1 = favorites_length1;
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp12_;
		uri_collection_length1 = _tmp12__length1;
		for (uri_it = 0; uri_it < _tmp12__length1; uri_it = uri_it + 1) {
			gchar* _tmp13_;
			gchar* uri = NULL;
			_tmp13_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp13_;
			{
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				gchar** _tmp18_;
				gchar** _tmp19_ = NULL;
				gchar** parts;
				gint parts_length1;
				gint _parts_size_;
				gchar* display_name = NULL;
				gchar** _tmp20_;
				gint _tmp20__length1;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				UnityFilesLensBookmark* _tmp38_;
				UnityFilesLensBookmark* bookmark;
				UnityFilesLensBookmark* _tmp39_;
				UnityFilesLensBookmark* _tmp40_;
				_tmp14_ = uri;
				if (g_strcmp0 (_tmp14_, "") == 0) {
					_g_free0 (uri);
					continue;
				}
				_tmp15_ = uri;
				_tmp16_ = desktop_uri;
				if (g_strcmp0 (_tmp15_, _tmp16_) == 0) {
					has_desktop_in_favourites = TRUE;
				}
				_tmp17_ = uri;
				_tmp19_ = _tmp18_ = g_strsplit (_tmp17_, " ", 2);
				parts = _tmp19_;
				parts_length1 = _vala_array_length (_tmp18_);
				_parts_size_ = parts_length1;
				_tmp20_ = parts;
				_tmp20__length1 = parts_length1;
				if (_tmp20__length1 == 1) {
					const gchar* _tmp21_;
					gchar* _tmp22_ = NULL;
					const gchar* _tmp23_;
					gchar* _tmp24_ = NULL;
					_tmp21_ = uri;
					_tmp22_ = g_uri_unescape_string (_tmp21_, NULL);
					_g_free0 (display_name);
					display_name = _tmp22_;
					_tmp23_ = display_name;
					_tmp24_ = g_filename_display_basename (_tmp23_);
					_g_free0 (display_name);
					display_name = _tmp24_;
				} else {
					gchar** _tmp25_;
					gint _tmp25__length1;
					_tmp25_ = parts;
					_tmp25__length1 = parts_length1;
					if (_tmp25__length1 == 2) {
						gchar** _tmp26_;
						gint _tmp26__length1;
						const gchar* _tmp27_;
						gchar* _tmp28_;
						gchar** _tmp29_;
						gint _tmp29__length1;
						const gchar* _tmp30_;
						gchar* _tmp31_;
						_tmp26_ = parts;
						_tmp26__length1 = parts_length1;
						_tmp27_ = _tmp26_[0];
						_tmp28_ = g_strdup (_tmp27_);
						_g_free0 (uri);
						uri = _tmp28_;
						_tmp29_ = parts;
						_tmp29__length1 = parts_length1;
						_tmp30_ = _tmp29_[1];
						_tmp31_ = g_strdup (_tmp30_);
						_g_free0 (display_name);
						display_name = _tmp31_;
					} else {
						const gchar* _tmp32_;
						const gchar* _tmp33_;
						gchar* _tmp34_;
						_tmp32_ = uri;
						g_warning ("folder.vala:94: Internal error computing display name for favorite '%s" \
"'", _tmp32_);
						_tmp33_ = uri;
						_tmp34_ = g_strdup (_tmp33_);
						_g_free0 (display_name);
						display_name = _tmp34_;
					}
				}
				_tmp35_ = uri;
				_tmp36_ = mimetype;
				_tmp37_ = display_name;
				_tmp38_ = unity_files_lens_bookmark_new (_tmp35_, _tmp36_, _tmp37_);
				bookmark = _tmp38_;
				_tmp39_ = bookmark;
				_tmp40_ = _g_object_ref0 (_tmp39_);
				self->priv->bookmarks = g_list_append (self->priv->bookmarks, _tmp40_);
				_g_object_unref0 (bookmark);
				_g_free0 (display_name);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (uri);
			}
		}
	}
	_tmp41_ = has_desktop_in_favourites;
	if (!_tmp41_) {
		GFile* _tmp42_;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_;
		gchar* desktop_display_name;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		UnityFilesLensBookmark* _tmp50_;
		UnityFilesLensBookmark* desktop_bookmark;
		UnityFilesLensBookmark* _tmp51_;
		UnityFilesLensBookmark* _tmp52_;
		_tmp42_ = desktop_file;
		_tmp43_ = g_file_get_parse_name (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_path_get_basename (_tmp44_);
		_tmp46_ = _tmp45_;
		_g_free0 (_tmp44_);
		desktop_display_name = _tmp46_;
		_tmp47_ = desktop_uri;
		_tmp48_ = mimetype;
		_tmp49_ = desktop_display_name;
		_tmp50_ = unity_files_lens_bookmark_new (_tmp47_, _tmp48_, _tmp49_);
		desktop_bookmark = _tmp50_;
		_tmp51_ = desktop_bookmark;
		_tmp52_ = _g_object_ref0 (_tmp51_);
		self->priv->bookmarks = g_list_append (self->priv->bookmarks, _tmp52_);
		_g_object_unref0 (desktop_bookmark);
		_g_free0 (desktop_display_name);
	}
	_g_free0 (mimetype);
	favorites = (_vala_array_free (favorites, favorites_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (desktop_file);
	_g_free0 (desktop_uri);
	_g_free0 (contents);
}


static GList* unity_files_lens_bookmarks_filter_bookmarks (UnityFilesLensBookmarks* self, GList* bm_list) {
	GList* result = NULL;
	GList* _result_;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = bm_list;
	{
		GList* bookmark_collection = NULL;
		GList* bookmark_it = NULL;
		bookmark_collection = _tmp0_;
		for (bookmark_it = bookmark_collection; bookmark_it != NULL; bookmark_it = bookmark_it->next) {
			UnityFilesLensBookmark* _tmp1_;
			UnityFilesLensBookmark* bookmark = NULL;
			_tmp1_ = _g_object_ref0 ((UnityFilesLensBookmark*) bookmark_it->data);
			bookmark = _tmp1_;
			{
				UnityFilesLensBookmark* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				GFile* _tmp5_ = NULL;
				GFile* f;
				gboolean _tmp6_ = FALSE;
				GFile* _tmp7_;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp11_;
				UnityFilesLensBookmark* _tmp12_;
				UnityFilesLensBookmark* _tmp13_;
				_tmp2_ = bookmark;
				_tmp3_ = unity_files_lens_bookmark_get_uri (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_file_new_for_uri (_tmp4_);
				f = _tmp5_;
				_tmp7_ = f;
				_tmp8_ = g_file_is_native (_tmp7_);
				if (_tmp8_) {
					GFile* _tmp9_;
					gboolean _tmp10_ = FALSE;
					_tmp9_ = f;
					_tmp10_ = g_file_query_exists (_tmp9_, NULL);
					_tmp6_ = !_tmp10_;
				} else {
					_tmp6_ = FALSE;
				}
				_tmp11_ = _tmp6_;
				if (_tmp11_) {
					_g_object_unref0 (f);
					_g_object_unref0 (bookmark);
					continue;
				}
				_tmp12_ = bookmark;
				_tmp13_ = _g_object_ref0 (_tmp12_);
				_result_ = g_list_prepend (_result_, _tmp13_);
				_g_object_unref0 (f);
				_g_object_unref0 (bookmark);
			}
		}
	}
	_result_ = g_list_reverse (_result_);
	result = _result_;
	return result;
}


GList* unity_files_lens_bookmarks_list (UnityFilesLensBookmarks* self) {
	GList* result = NULL;
	GList* _tmp0_;
	GList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->bookmarks;
	_tmp1_ = unity_files_lens_bookmarks_filter_bookmarks (self, _tmp0_);
	result = _tmp1_;
	return result;
}


GList* unity_files_lens_bookmarks_prefix_search (UnityFilesLensBookmarks* self, const gchar* search) {
	GList* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* prefix;
	GList* matches;
	GList* _tmp2_;
	GList* _tmp12_;
	GList* _tmp13_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (search != NULL, NULL);
	_tmp0_ = search;
	_tmp1_ = unity_files_lens_utils_normalize_string (_tmp0_);
	prefix = _tmp1_;
	matches = NULL;
	_tmp2_ = self->priv->bookmarks;
	{
		GList* bookmark_collection = NULL;
		GList* bookmark_it = NULL;
		bookmark_collection = _tmp2_;
		for (bookmark_it = bookmark_collection; bookmark_it != NULL; bookmark_it = bookmark_it->next) {
			UnityFilesLensBookmark* _tmp3_;
			UnityFilesLensBookmark* bookmark = NULL;
			_tmp3_ = _g_object_ref0 ((UnityFilesLensBookmark*) bookmark_it->data);
			bookmark = _tmp3_;
			{
				UnityFilesLensBookmark* _tmp4_;
				GList* _tmp5_ = NULL;
				_tmp4_ = bookmark;
				_tmp5_ = unity_files_lens_bookmark_get_index_terms (_tmp4_);
				{
					GList* term_collection = NULL;
					GList* term_it = NULL;
					term_collection = _tmp5_;
					for (term_it = term_collection; term_it != NULL; term_it = term_it->next) {
						gchar* _tmp6_;
						gchar* term = NULL;
						_tmp6_ = g_strdup ((const gchar*) term_it->data);
						term = _tmp6_;
						{
							const gchar* _tmp7_;
							const gchar* _tmp8_;
							gboolean _tmp9_ = FALSE;
							_tmp7_ = term;
							_tmp8_ = prefix;
							_tmp9_ = g_str_has_prefix (_tmp7_, _tmp8_);
							if (_tmp9_) {
								UnityFilesLensBookmark* _tmp10_;
								UnityFilesLensBookmark* _tmp11_;
								_tmp10_ = bookmark;
								_tmp11_ = _g_object_ref0 (_tmp10_);
								matches = g_list_append (matches, _tmp11_);
								_g_free0 (term);
								break;
							}
							_g_free0 (term);
						}
					}
				}
				_g_object_unref0 (bookmark);
			}
		}
	}
	_tmp12_ = matches;
	_tmp13_ = unity_files_lens_bookmarks_filter_bookmarks (self, _tmp12_);
	result = _tmp13_;
	__g_list_free__g_object_unref0_0 (matches);
	_g_free0 (prefix);
	return result;
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	glong _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = offset;
	result = (const gchar*) (((gchar*) self) + _tmp0_);
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


gboolean unity_files_lens_bookmarks_launch_if_bookmark (UnityFilesLensBookmarks* self, const gchar* uri, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GAppInfo* _tmp2_ = NULL;
	GAppInfo* _tmp3_;
	GAppInfo* launcher;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	GAppInfo* _tmp6_;
	GList* uris;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GAppInfo* _tmp12_;
	GList* _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = uri;
	_tmp1_ = g_str_has_prefix (_tmp0_, "bookmark:");
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = g_app_info_get_default_for_type ("inode/directory", TRUE);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	launcher = _tmp3_;
	_tmp4_ = uri;
	_tmp5_ = string_offset (_tmp4_, (glong) 9);
	uri = _tmp5_;
	_tmp6_ = launcher;
	if (_tmp6_ == NULL) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GError* _tmp9_;
		_tmp7_ = uri;
		g_warning ("folder.vala:197: No default handler for inode/directory. Unable to ope" \
"n bookmark '%s'", _tmp7_);
		_tmp8_ = uri;
		_tmp9_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "No default handler for inode/directory. Unable to open bookmark '%s'", _tmp8_);
		_inner_error_ = _tmp9_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (launcher);
		return FALSE;
	}
	uris = NULL;
	_tmp10_ = uri;
	_tmp11_ = g_strdup (_tmp10_);
	uris = g_list_append (uris, _tmp11_);
	_tmp12_ = launcher;
	_tmp13_ = uris;
	g_app_info_launch_uris (_tmp12_, _tmp13_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		__g_list_free__g_free0_0 (uris);
		_g_object_unref0 (launcher);
		return FALSE;
	}
	result = TRUE;
	__g_list_free__g_free0_0 (uris);
	_g_object_unref0 (launcher);
	return result;
}


static void unity_files_lens_bookmarks_class_init (UnityFilesLensBookmarksClass * klass) {
	unity_files_lens_bookmarks_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityFilesLensBookmarksPrivate));
	G_OBJECT_CLASS (klass)->finalize = unity_files_lens_bookmarks_finalize;
	g_signal_new ("changed", UNITY_FILES_LENS_TYPE_BOOKMARKS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void unity_files_lens_bookmarks_instance_init (UnityFilesLensBookmarks * self) {
	self->priv = UNITY_FILES_LENS_BOOKMARKS_GET_PRIVATE (self);
}


static void unity_files_lens_bookmarks_finalize (GObject* obj) {
	UnityFilesLensBookmarks * self;
	self = UNITY_FILES_LENS_BOOKMARKS (obj);
	__g_list_free__g_object_unref0_0 (self->priv->bookmarks);
	_g_free0 (self->priv->bookmarks_file);
	_g_object_unref0 (self->priv->monitor);
	G_OBJECT_CLASS (unity_files_lens_bookmarks_parent_class)->finalize (obj);
}


GType unity_files_lens_bookmarks_get_type (void) {
	static volatile gsize unity_files_lens_bookmarks_type_id__volatile = 0;
	if (g_once_init_enter (&unity_files_lens_bookmarks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityFilesLensBookmarksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_files_lens_bookmarks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityFilesLensBookmarks), 0, (GInstanceInitFunc) unity_files_lens_bookmarks_instance_init, NULL };
		GType unity_files_lens_bookmarks_type_id;
		unity_files_lens_bookmarks_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityFilesLensBookmarks", &g_define_type_info, 0);
		g_once_init_leave (&unity_files_lens_bookmarks_type_id__volatile, unity_files_lens_bookmarks_type_id);
	}
	return unity_files_lens_bookmarks_type_id__volatile;
}


UnityFilesLensBookmark* unity_files_lens_bookmark_construct (GType object_type, const gchar* uri, const gchar* mimetype, const gchar* display_name) {
	UnityFilesLensBookmark * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (mimetype != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = uri;
	_tmp1_ = g_strconcat ("bookmark:", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = uri;
	_tmp4_ = mimetype;
	_tmp5_ = unity_files_lens_utils_get_icon_for_uri (_tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = mimetype;
	_tmp8_ = display_name;
	_tmp9_ = uri;
	self = (UnityFilesLensBookmark*) g_object_new (object_type, "uri", _tmp2_, "icon", _tmp6_, "mimetype", _tmp7_, "display-name", _tmp8_, "dnd-uri", _tmp9_, NULL);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp2_);
	__g_list_free__g_free0_0 (self->priv->index_terms);
	self->priv->index_terms = NULL;
	_tmp10_ = uri;
	_tmp11_ = g_path_get_basename (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = unity_files_lens_utils_normalize_string (_tmp12_);
	self->priv->index_terms = g_list_append (self->priv->index_terms, _tmp13_);
	_g_free0 (_tmp12_);
	_tmp14_ = display_name;
	_tmp15_ = unity_files_lens_utils_normalize_string (_tmp14_);
	self->priv->index_terms = g_list_append (self->priv->index_terms, _tmp15_);
	return self;
}


UnityFilesLensBookmark* unity_files_lens_bookmark_new (const gchar* uri, const gchar* mimetype, const gchar* display_name) {
	return unity_files_lens_bookmark_construct (UNITY_FILES_LENS_TYPE_BOOKMARK, uri, mimetype, display_name);
}


GList* unity_files_lens_bookmark_get_index_terms (UnityFilesLensBookmark* self) {
	GList* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->index_terms;
	result = _tmp0_;
	return result;
}


const gchar* unity_files_lens_bookmark_get_uri (UnityFilesLensBookmark* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}


void unity_files_lens_bookmark_set_uri (UnityFilesLensBookmark* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp1_;
	g_object_notify ((GObject *) self, "uri");
}


const gchar* unity_files_lens_bookmark_get_icon (UnityFilesLensBookmark* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}


void unity_files_lens_bookmark_set_icon (UnityFilesLensBookmark* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_icon);
	self->priv->_icon = _tmp1_;
	g_object_notify ((GObject *) self, "icon");
}


const gchar* unity_files_lens_bookmark_get_mimetype (UnityFilesLensBookmark* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mimetype;
	result = _tmp0_;
	return result;
}


void unity_files_lens_bookmark_set_mimetype (UnityFilesLensBookmark* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_mimetype);
	self->priv->_mimetype = _tmp1_;
	g_object_notify ((GObject *) self, "mimetype");
}


const gchar* unity_files_lens_bookmark_get_display_name (UnityFilesLensBookmark* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}


void unity_files_lens_bookmark_set_display_name (UnityFilesLensBookmark* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp1_;
	g_object_notify ((GObject *) self, "display-name");
}


const gchar* unity_files_lens_bookmark_get_dnd_uri (UnityFilesLensBookmark* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dnd_uri;
	result = _tmp0_;
	return result;
}


void unity_files_lens_bookmark_set_dnd_uri (UnityFilesLensBookmark* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_dnd_uri);
	self->priv->_dnd_uri = _tmp1_;
	g_object_notify ((GObject *) self, "dnd-uri");
}


static void unity_files_lens_bookmark_class_init (UnityFilesLensBookmarkClass * klass) {
	unity_files_lens_bookmark_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityFilesLensBookmarkPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_files_lens_bookmark_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_files_lens_bookmark_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_files_lens_bookmark_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_BOOKMARK_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_BOOKMARK_ICON, g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_BOOKMARK_MIMETYPE, g_param_spec_string ("mimetype", "mimetype", "mimetype", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_BOOKMARK_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_BOOKMARK_DND_URI, g_param_spec_string ("dnd-uri", "dnd-uri", "dnd-uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void unity_files_lens_bookmark_instance_init (UnityFilesLensBookmark * self) {
	self->priv = UNITY_FILES_LENS_BOOKMARK_GET_PRIVATE (self);
}


static void unity_files_lens_bookmark_finalize (GObject* obj) {
	UnityFilesLensBookmark * self;
	self = UNITY_FILES_LENS_BOOKMARK (obj);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_icon);
	_g_free0 (self->priv->_mimetype);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_dnd_uri);
	__g_list_free__g_free0_0 (self->priv->index_terms);
	G_OBJECT_CLASS (unity_files_lens_bookmark_parent_class)->finalize (obj);
}


GType unity_files_lens_bookmark_get_type (void) {
	static volatile gsize unity_files_lens_bookmark_type_id__volatile = 0;
	if (g_once_init_enter (&unity_files_lens_bookmark_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityFilesLensBookmarkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_files_lens_bookmark_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityFilesLensBookmark), 0, (GInstanceInitFunc) unity_files_lens_bookmark_instance_init, NULL };
		GType unity_files_lens_bookmark_type_id;
		unity_files_lens_bookmark_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityFilesLensBookmark", &g_define_type_info, 0);
		g_once_init_leave (&unity_files_lens_bookmark_type_id__volatile, unity_files_lens_bookmark_type_id);
	}
	return unity_files_lens_bookmark_type_id__volatile;
}


static void _vala_unity_files_lens_bookmark_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityFilesLensBookmark * self;
	self = UNITY_FILES_LENS_BOOKMARK (object);
	switch (property_id) {
		case UNITY_FILES_LENS_BOOKMARK_URI:
		g_value_set_string (value, unity_files_lens_bookmark_get_uri (self));
		break;
		case UNITY_FILES_LENS_BOOKMARK_ICON:
		g_value_set_string (value, unity_files_lens_bookmark_get_icon (self));
		break;
		case UNITY_FILES_LENS_BOOKMARK_MIMETYPE:
		g_value_set_string (value, unity_files_lens_bookmark_get_mimetype (self));
		break;
		case UNITY_FILES_LENS_BOOKMARK_DISPLAY_NAME:
		g_value_set_string (value, unity_files_lens_bookmark_get_display_name (self));
		break;
		case UNITY_FILES_LENS_BOOKMARK_DND_URI:
		g_value_set_string (value, unity_files_lens_bookmark_get_dnd_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_files_lens_bookmark_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityFilesLensBookmark * self;
	self = UNITY_FILES_LENS_BOOKMARK (object);
	switch (property_id) {
		case UNITY_FILES_LENS_BOOKMARK_URI:
		unity_files_lens_bookmark_set_uri (self, g_value_get_string (value));
		break;
		case UNITY_FILES_LENS_BOOKMARK_ICON:
		unity_files_lens_bookmark_set_icon (self, g_value_get_string (value));
		break;
		case UNITY_FILES_LENS_BOOKMARK_MIMETYPE:
		unity_files_lens_bookmark_set_mimetype (self, g_value_get_string (value));
		break;
		case UNITY_FILES_LENS_BOOKMARK_DISPLAY_NAME:
		unity_files_lens_bookmark_set_display_name (self, g_value_get_string (value));
		break;
		case UNITY_FILES_LENS_BOOKMARK_DND_URI:
		unity_files_lens_bookmark_set_dnd_uri (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



