/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */
using Dee;
using Config;
using Gee;

namespace Unity.ShoppingLens {
  
  const string ICON_PATH = Config.DATADIR + "/icons/unity-icon-theme/places/svg/";
  
  public class Daemon : GLib.Object
  {
    private Unity.Lens lens;
     
    construct
    {
      lens = new Unity.Lens("/com/canonical/unity/lens/shopping", "shopping");
      lens.search_in_global = true;
      lens.search_hint = _("Search products");
      lens.sources_display_name = _("Sources");
      lens.visible = false;
      
      populate_categories ();
      populate_filters ();

      var shopping_scope = new ShoppingScope ();
      lens.add_local_scope (shopping_scope);

      try {
        lens.export ();
      } catch (GLib.IOError e) {
        stdout.printf ("error %s\n", e.message);
      }
    }

    private void populate_filters ()
    {
      var filters = new GLib.List<Unity.Filter> ();

      /* TODO */

      /* A filter */
      {
      }

      /* Another filter */
      {
      }

      lens.filters = filters;
    }

    // FIXME: icons!
    private void populate_categories ()
    {
      /* Offsets of categories must match up with the Category enum */
      
      Unity.Category cat;
      var categories = new GLib.List<Unity.Category> ();
      var icon_dir = File.new_for_path (ICON_PATH);

      cat = new Unity.Category (_("More suggestions"),
                                new FileIcon (icon_dir.get_child ("group-treat-yourself.svg")),
                                Unity.CategoryRenderer.FLOW);
      categories.append (cat);

      cat = new Unity.Category (_("For purchase"),
                                new FileIcon (icon_dir.get_child ("group-songs.svg")),
                                Unity.CategoryRenderer.FLOW);
      categories.append (cat);

      lens.categories = categories;
    }
  }
} /* namespace */

