/* unity-package-search.vapi hand crafted by Mikkel Kamstrup Erlandsen */

[CCode (cprefix = "Unity", lower_case_cprefix = "unity_", cheader_filename = "unity-package-search.h")]
namespace Unity {

  [CCode (cprefix = "UnityPackage", lower_case_cprefix = "unity_package_")]
  namespace Package {
    
    [Compact]
    [CCode (free_function = "unity_package_searcher_free", cheader_filename = "unity-package-search.h")]
    public class Searcher {
      [CCode (cname = "unity_package_searcher_new")]
      public Searcher ();
      [CCode (cname = "unity_package_searcher_new_for_menu")]
      public Searcher.for_menu(GMenu.Tree menu);
      public SearchResult search (string search_string);
      
    }
    
    [Compact]
    [CCode (free_function = "unity_package_search_result_free", cheader_filename = "unity-package-search.h")]
    public class SearchResult {
      public GLib.SList<unowned PackageInfo> results;
      public int num_hits;
      
    }
    
    [Compact]
    [CCode (cname = "UnityPackageInfo", cheader_filename = "unity-package-search.h")]
    public class PackageInfo {
      public string package_name;
	    public string application_name;
	    public string desktop_file;
	    public string icon;
    }
  }
}
