/* scroller-view.c generated by valac 0.10.0, the Vala compiler
 * generated from scroller-view.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Gordon Allott <gord.allott@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <clutk/clutk.h>
#include <clutter/clutter.h>
#include <unity.h>
#include <gee.h>
#include <string.h>
#include <cairo.h>
#include <stdlib.h>
#include <pango/pangocairo.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cogl/cogl.h>
#include <gobject/gvaluecollector.h>


#define UNITY_LAUNCHER_TYPE_SCROLLER_PHASE (unity_launcher_scroller_phase_get_type ())

#define UNITY_LAUNCHER_TYPE_SCROLLER_VIEW_TYPE (unity_launcher_scroller_view_type_get_type ())

#define UNITY_LAUNCHER_TYPE_CHILD_TRANSITION (unity_launcher_child_transition_get_type ())
#define UNITY_LAUNCHER_CHILD_TRANSITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_CHILD_TRANSITION, UnityLauncherChildTransition))
#define UNITY_LAUNCHER_CHILD_TRANSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_CHILD_TRANSITION, UnityLauncherChildTransitionClass))
#define UNITY_LAUNCHER_IS_CHILD_TRANSITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_CHILD_TRANSITION))
#define UNITY_LAUNCHER_IS_CHILD_TRANSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_CHILD_TRANSITION))
#define UNITY_LAUNCHER_CHILD_TRANSITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_CHILD_TRANSITION, UnityLauncherChildTransitionClass))

typedef struct _UnityLauncherChildTransition UnityLauncherChildTransition;
typedef struct _UnityLauncherChildTransitionClass UnityLauncherChildTransitionClass;
typedef struct _UnityLauncherChildTransitionPrivate UnityLauncherChildTransitionPrivate;
typedef struct _UnityLauncherParamSpecChildTransition UnityLauncherParamSpecChildTransition;

#define UNITY_LAUNCHER_TYPE_SCROLLER_VIEW (unity_launcher_scroller_view_get_type ())
#define UNITY_LAUNCHER_SCROLLER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_VIEW, UnityLauncherScrollerView))
#define UNITY_LAUNCHER_SCROLLER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_VIEW, UnityLauncherScrollerViewClass))
#define UNITY_LAUNCHER_IS_SCROLLER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_VIEW))
#define UNITY_LAUNCHER_IS_SCROLLER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_VIEW))
#define UNITY_LAUNCHER_SCROLLER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_VIEW, UnityLauncherScrollerViewClass))

typedef struct _UnityLauncherScrollerView UnityLauncherScrollerView;
typedef struct _UnityLauncherScrollerViewClass UnityLauncherScrollerViewClass;
typedef struct _UnityLauncherScrollerViewPrivate UnityLauncherScrollerViewPrivate;

#define UNITY_LAUNCHER_TYPE_SCROLLER_MODEL (unity_launcher_scroller_model_get_type ())
#define UNITY_LAUNCHER_SCROLLER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_MODEL, UnityLauncherScrollerModel))
#define UNITY_LAUNCHER_SCROLLER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_MODEL, UnityLauncherScrollerModelClass))
#define UNITY_LAUNCHER_IS_SCROLLER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_MODEL))
#define UNITY_LAUNCHER_IS_SCROLLER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_MODEL))
#define UNITY_LAUNCHER_SCROLLER_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_MODEL, UnityLauncherScrollerModelClass))

typedef struct _UnityLauncherScrollerModel UnityLauncherScrollerModel;
typedef struct _UnityLauncherScrollerModelClass UnityLauncherScrollerModelClass;

#define UNITY_LAUNCHER_TYPE_SCROLLER_CHILD (unity_launcher_scroller_child_get_type ())
#define UNITY_LAUNCHER_SCROLLER_CHILD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChild))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChildClass))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD))
#define UNITY_LAUNCHER_SCROLLER_CHILD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChildClass))

typedef struct _UnityLauncherScrollerChild UnityLauncherScrollerChild;
typedef struct _UnityLauncherScrollerChildClass UnityLauncherScrollerChildClass;

#define UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER (unity_launcher_quicklist_controller_get_type ())
#define UNITY_LAUNCHER_QUICKLIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, UnityLauncherQuicklistController))
#define UNITY_LAUNCHER_QUICKLIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, UnityLauncherQuicklistControllerClass))
#define UNITY_LAUNCHER_IS_QUICKLIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER))
#define UNITY_LAUNCHER_IS_QUICKLIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER))
#define UNITY_LAUNCHER_QUICKLIST_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, UnityLauncherQuicklistControllerClass))

typedef struct _UnityLauncherQuicklistController UnityLauncherQuicklistController;
typedef struct _UnityLauncherQuicklistControllerClass UnityLauncherQuicklistControllerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UNITY_LAUNCHER_SCROLLER_MODEL_TYPE_ITERATOR (unity_launcher_scroller_model_iterator_get_type ())
#define UNITY_LAUNCHER_SCROLLER_MODEL_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_SCROLLER_MODEL_TYPE_ITERATOR, UnityLauncherScrollerModelIterator))
#define UNITY_LAUNCHER_SCROLLER_MODEL_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_SCROLLER_MODEL_TYPE_ITERATOR, UnityLauncherScrollerModelIteratorClass))
#define UNITY_LAUNCHER_SCROLLER_MODEL_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_SCROLLER_MODEL_TYPE_ITERATOR))
#define UNITY_LAUNCHER_SCROLLER_MODEL_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_SCROLLER_MODEL_TYPE_ITERATOR))
#define UNITY_LAUNCHER_SCROLLER_MODEL_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_SCROLLER_MODEL_TYPE_ITERATOR, UnityLauncherScrollerModelIteratorClass))

typedef struct _UnityLauncherScrollerModelIterator UnityLauncherScrollerModelIterator;
typedef struct _UnityLauncherScrollerModelIteratorClass UnityLauncherScrollerModelIteratorClass;
#define _unity_launcher_scroller_model_iterator_unref0(var) ((var == NULL) ? NULL : (var = (unity_launcher_scroller_model_iterator_unref (var), NULL)))

#define UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER (unity_launcher_scroller_child_controller_get_type ())
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildController))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildControllerClass))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildControllerClass))

typedef struct _UnityLauncherScrollerChildController UnityLauncherScrollerChildController;
typedef struct _UnityLauncherScrollerChildControllerClass UnityLauncherScrollerChildControllerClass;
#define __g_slist_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_free (var), NULL)))
typedef struct _UnityLauncherScrollerChildPrivate UnityLauncherScrollerChildPrivate;

#define UNITY_LAUNCHER_TYPE_PIN_TYPE (unity_launcher_pin_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _Block13Data Block13Data;

#define TYPE_MENU_MANAGER (menu_manager_get_type ())
#define MENU_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENU_MANAGER, MenuManager))
#define MENU_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENU_MANAGER, MenuManagerClass))
#define IS_MENU_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENU_MANAGER))
#define IS_MENU_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENU_MANAGER))
#define MENU_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENU_MANAGER, MenuManagerClass))

typedef struct _MenuManager MenuManager;
typedef struct _MenuManagerClass MenuManagerClass;

#define UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER_STATE (unity_launcher_quicklist_controller_state_get_type ())

#define UNITY_TESTING_TYPE_OBJECT_REGISTRY (unity_testing_object_registry_get_type ())
#define UNITY_TESTING_OBJECT_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TESTING_TYPE_OBJECT_REGISTRY, UnityTestingObjectRegistry))
#define UNITY_TESTING_OBJECT_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TESTING_TYPE_OBJECT_REGISTRY, UnityTestingObjectRegistryClass))
#define UNITY_TESTING_IS_OBJECT_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TESTING_TYPE_OBJECT_REGISTRY))
#define UNITY_TESTING_IS_OBJECT_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TESTING_TYPE_OBJECT_REGISTRY))
#define UNITY_TESTING_OBJECT_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TESTING_TYPE_OBJECT_REGISTRY, UnityTestingObjectRegistryClass))

typedef struct _UnityTestingObjectRegistry UnityTestingObjectRegistry;
typedef struct _UnityTestingObjectRegistryClass UnityTestingObjectRegistryClass;
#define _unity_testing_object_registry_unref0(var) ((var == NULL) ? NULL : (var = (unity_testing_object_registry_unref (var), NULL)))

typedef enum  {
	UNITY_LAUNCHER_SCROLLER_PHASE_PANNING,
	UNITY_LAUNCHER_SCROLLER_PHASE_SETTLING,
	UNITY_LAUNCHER_SCROLLER_PHASE_REORDERING,
	UNITY_LAUNCHER_SCROLLER_PHASE_FLUNG,
	UNITY_LAUNCHER_SCROLLER_PHASE_BOUNCE,
	UNITY_LAUNCHER_SCROLLER_PHASE_NONE
} UnityLauncherScrollerPhase;

typedef enum  {
	UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_EXPANDED,
	UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_CONTRACTED
} UnityLauncherScrollerViewType;

struct _UnityLauncherChildTransition {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityLauncherChildTransitionPrivate * priv;
	float position;
	float rotation;
};

struct _UnityLauncherChildTransitionClass {
	GTypeClass parent_class;
	void (*finalize) (UnityLauncherChildTransition *self);
};

struct _UnityLauncherParamSpecChildTransition {
	GParamSpec parent_instance;
};

struct _UnityLauncherScrollerView {
	CtkActor parent_instance;
	UnityLauncherScrollerViewPrivate * priv;
	gint spacing;
	gint drag_sensitivity;
	float friction;
	gboolean is_animating;
	ClutterTimeline* fling_timeline;
	ClutterTimeline* autoscroll_timeline;
};

struct _UnityLauncherScrollerViewClass {
	CtkActorClass parent_class;
};

struct _UnityLauncherScrollerViewPrivate {
	gboolean disable_child_events;
	UnityLauncherScrollerModel* _model;
	CtkEffectCache* _cache;
	gboolean _drag_indicator_active;
	gboolean _drag_indicator_space;
	gint _drag_indicator_index;
	float _drag_indicator_opacity;
	float drag_indicator_position;
	UnityThemeImage* bgtex;
	UnityThemeImage* top_shadow;
	gboolean button_down;
	float total_child_height;
	UnityLauncherScrollerPhase current_phase;
	guint last_motion_event_time;
	UnityLauncherScrollerViewType view_type;
	gboolean do_logic_pick;
	float last_known_pointer_x;
	gboolean can_scroll;
	float last_known_x;
	float last_known_y;
	gboolean is_scrolling;
	float scroll_position;
	float settle_position;
	gboolean _is_autoscrolling;
	gboolean autoscroll_anim_active;
	gint autoscroll_direction;
	float previous_y_position;
	guint previous_y_time;
	guint stored_delta;
	float scroll_speed;
	float contract_icon_degrees;
	float contract_icon_partial_degrees;
	gint focused_launcher;
	GeeArrayList* draw_ftb;
	GeeArrayList* draw_btf;
	GeeArrayList* keyboard_indicators;
	GeeArrayList* child_refs;
	ClutterActor* last_picked_actor;
	float last_scroll_position;
	guint autoscroll_stored_delta;
	guint queue_contract_launcher;
	UnityLauncherQuicklistController* attached_menu;
	float autoscroll_mouse_pos_cache;
	guint fling_timeout_source;
};

typedef enum  {
	UNITY_LAUNCHER_PIN_TYPE_UNPINNED,
	UNITY_LAUNCHER_PIN_TYPE_PINNED,
	UNITY_LAUNCHER_PIN_TYPE_ALWAYS,
	UNITY_LAUNCHER_PIN_TYPE_NEVER
} UnityLauncherPinType;

struct _UnityLauncherScrollerChild {
	CtkActor parent_instance;
	UnityLauncherScrollerChildPrivate * priv;
	UnityLauncherPinType pin_type;
	gboolean do_not_render;
	UnityLauncherScrollerChildController* controller;
	float grabbed_push;
	UnityUnityIcon* processed_icon;
};

struct _UnityLauncherScrollerChildClass {
	CtkActorClass parent_class;
};

struct _Block13Data {
	int _ref_count_;
	UnityLauncherScrollerView * self;
	UnityLauncherScrollerChild* child;
};

typedef enum  {
	UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_LABEL,
	UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_MENU,
	UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_CLOSED
} UnityLauncherQuicklistControllerState;


static gpointer unity_launcher_child_transition_parent_class = NULL;
extern gboolean unity_launcher_disable_quicklists;
static gpointer unity_launcher_scroller_view_parent_class = NULL;

GType unity_launcher_scroller_phase_get_type (void) G_GNUC_CONST;
GType unity_launcher_scroller_view_type_get_type (void) G_GNUC_CONST;
gpointer unity_launcher_child_transition_ref (gpointer instance);
void unity_launcher_child_transition_unref (gpointer instance);
GParamSpec* unity_launcher_param_spec_child_transition (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_launcher_value_set_child_transition (GValue* value, gpointer v_object);
void unity_launcher_value_take_child_transition (GValue* value, gpointer v_object);
gpointer unity_launcher_value_get_child_transition (const GValue* value);
GType unity_launcher_child_transition_get_type (void) G_GNUC_CONST;
enum  {
	UNITY_LAUNCHER_CHILD_TRANSITION_DUMMY_PROPERTY
};
UnityLauncherChildTransition* unity_launcher_child_transition_new (void);
UnityLauncherChildTransition* unity_launcher_child_transition_construct (GType object_type);
static void unity_launcher_child_transition_finalize (UnityLauncherChildTransition* obj);
GType unity_launcher_scroller_view_get_type (void) G_GNUC_CONST;
GType unity_launcher_scroller_model_get_type (void) G_GNUC_CONST;
GType unity_launcher_scroller_child_get_type (void) G_GNUC_CONST;
GType unity_launcher_quicklist_controller_get_type (void) G_GNUC_CONST;
#define UNITY_LAUNCHER_SCROLLER_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_LAUNCHER_TYPE_SCROLLER_VIEW, UnityLauncherScrollerViewPrivate))
enum  {
	UNITY_LAUNCHER_SCROLLER_VIEW_DUMMY_PROPERTY,
	UNITY_LAUNCHER_SCROLLER_VIEW_MODEL,
	UNITY_LAUNCHER_SCROLLER_VIEW_CACHE,
	UNITY_LAUNCHER_SCROLLER_VIEW_DRAG_INDICATOR_ACTIVE,
	UNITY_LAUNCHER_SCROLLER_VIEW_DRAG_INDICATOR_SPACE,
	UNITY_LAUNCHER_SCROLLER_VIEW_DRAG_INDICATOR_INDEX,
	UNITY_LAUNCHER_SCROLLER_VIEW_DRAG_INDICATOR_OPACITY,
	UNITY_LAUNCHER_SCROLLER_VIEW_IS_AUTOSCROLLING
};
UnityLauncherScrollerView* unity_launcher_scroller_view_new (UnityLauncherScrollerModel* _model, CtkEffectCache* _cache);
UnityLauncherScrollerView* unity_launcher_scroller_view_construct (GType object_type, UnityLauncherScrollerModel* _model, CtkEffectCache* _cache);
static ClutterActor* unity_launcher_scroller_view_handle_event (UnityLauncherScrollerView* self, ClutterEvent* event, gboolean assume_on_launcher);
UnityLauncherScrollerModel* unity_launcher_scroller_view_get_model (UnityLauncherScrollerView* self);
gpointer unity_launcher_scroller_model_iterator_ref (gpointer instance);
void unity_launcher_scroller_model_iterator_unref (gpointer instance);
GParamSpec* unity_launcher_scroller_model_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_launcher_scroller_model_value_set_iterator (GValue* value, gpointer v_object);
void unity_launcher_scroller_model_value_take_iterator (GValue* value, gpointer v_object);
gpointer unity_launcher_scroller_model_value_get_iterator (const GValue* value);
GType unity_launcher_scroller_model_iterator_get_type (void) G_GNUC_CONST;
UnityLauncherScrollerModelIterator* unity_launcher_scroller_model_iterator (UnityLauncherScrollerModel* self);
gboolean unity_launcher_scroller_model_iterator_next (UnityLauncherScrollerModelIterator* self);
UnityLauncherScrollerChild* unity_launcher_scroller_model_iterator_get (UnityLauncherScrollerModelIterator* self);
static gboolean unity_launcher_scroller_view_passthrough_motion_event (UnityLauncherScrollerView* self, ClutterEvent* event);
static gboolean unity_launcher_scroller_view_on_enter_event (UnityLauncherScrollerView* self, ClutterEvent* event);
static gboolean _unity_launcher_scroller_view_on_enter_event_clutter_actor_enter_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean unity_launcher_scroller_view_on_leave_event (UnityLauncherScrollerView* self, ClutterEvent* event);
static gboolean _unity_launcher_scroller_view_on_leave_event_clutter_actor_leave_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean unity_launcher_scroller_view_on_motion_event (UnityLauncherScrollerView* self, ClutterEvent* event);
static gboolean _unity_launcher_scroller_view_on_motion_event_clutter_actor_motion_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean _unity_launcher_scroller_view_passthrough_motion_event_clutter_actor_motion_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean unity_launcher_scroller_view_passthrough_button_press_event (UnityLauncherScrollerView* self, ClutterEvent* event);
static gboolean _unity_launcher_scroller_view_passthrough_button_press_event_clutter_actor_button_press_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean unity_launcher_scroller_view_passthrough_button_release_event (UnityLauncherScrollerView* self, ClutterEvent* event);
static gboolean _unity_launcher_scroller_view_passthrough_button_release_event_clutter_actor_button_release_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static void unity_launcher_scroller_view_on_drag_indicator_space_change (UnityLauncherScrollerView* self);
gboolean unity_launcher_scroller_view_get_drag_indicator_active (UnityLauncherScrollerView* self);
gboolean unity_launcher_scroller_view_get_drag_indicator_space (UnityLauncherScrollerView* self);
static void unity_launcher_scroller_view_order_children (UnityLauncherScrollerView* self, gboolean immediate);
static void unity_launcher_scroller_view_on_drag_indicator_active_change (UnityLauncherScrollerView* self);
static void unity_launcher_scroller_view_on_drag_indicator_index_change (UnityLauncherScrollerView* self);
void unity_launcher_scroller_view_enable_keyboard_selection_mode (UnityLauncherScrollerView* self, gboolean choice);
gint unity_launcher_scroller_model_get_size (UnityLauncherScrollerModel* self);
gboolean unity_launcher_scroller_child_get_active (UnityLauncherScrollerChild* self);
gint unity_launcher_scroller_model_index_of (UnityLauncherScrollerModel* self, UnityLauncherScrollerChild* child);
static void unity_launcher_scroller_view_contract_launcher (UnityLauncherScrollerView* self);
static void unity_launcher_scroller_view_move_scroll_position (UnityLauncherScrollerView* self, float pixels, gboolean check_bounds, float limit);
static void unity_launcher_scroller_view_expand_launcher (UnityLauncherScrollerView* self, float absolute_y);
gint unity_launcher_scroller_view_get_model_index_at_y_pos_no_anim (UnityLauncherScrollerView* self, float y, gboolean return_minus_if_fail);
float unity_launcher_scroller_child_get_position (UnityLauncherScrollerChild* self);
static float* _float_dup (float* self);
void unity_launcher_scroller_child_set_position (UnityLauncherScrollerChild* self, float value);
gint unity_launcher_scroller_view_get_model_index_at_y_pos (UnityLauncherScrollerView* self, float y, gboolean return_minus_if_fail);
GType unity_launcher_scroller_child_controller_get_type (void) G_GNUC_CONST;
UnityLauncherScrollerChild* unity_launcher_scroller_child_controller_get_child (UnityLauncherScrollerChildController* self);
static void _g_slist_free_g_free (GSList* self);
static gint unity_launcher_scroller_view_get_model_index_at_y_pos_pick (UnityLauncherScrollerView* self, float y, gboolean return_minus_if_fail);
static gint unity_launcher_scroller_view_get_model_index_at_y_pos_logic (UnityLauncherScrollerView* self, float y, gboolean return_minus_if_fail);
UnityLauncherScrollerChild* unity_launcher_scroller_model_get (UnityLauncherScrollerModel* self, gint i);
GType unity_launcher_pin_type_get_type (void) G_GNUC_CONST;
static void unity_launcher_scroller_view_draw_keyboard_indicator_cairo (UnityLauncherScrollerView* self, cairo_t* cr, const char* text);
static void unity_launcher_scroller_view_load_textures (UnityLauncherScrollerView* self);
static float unity_launcher_scroller_view_calculate_scroll_position (UnityLauncherScrollerView* self, gboolean check_bounds, float limit);
static float unity_launcher_scroller_view_get_total_children_height (UnityLauncherScrollerView* self);
static float unity_launcher_scroller_view_get_available_height (UnityLauncherScrollerView* self);
static void unity_launcher_scroller_view_disable_animations_on_children (UnityLauncherScrollerView* self, ClutterEvent* event);
void unity_launcher_scroller_view_set_is_autoscrolling (UnityLauncherScrollerView* self, gboolean value);
static void unity_launcher_scroller_view_model_child_added (UnityLauncherScrollerView* self, UnityLauncherScrollerChild* child);
static void _vala_array_add2 (float** array, int* length, int* size, float value);
float unity_launcher_scroller_child_get_rotation (UnityLauncherScrollerChild* self);
static void _vala_array_add3 (float** array, int* length, int* size, float value);
static void unity_launcher_scroller_view_change_child_position_rotation (UnityLauncherScrollerView* self, UnityLauncherScrollerChild* child, float position, float rotation, gboolean immediate);
static void _lambda83_ (UnityLauncherScrollerView* self);
static void __lambda83__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_launcher_scroller_view_model_child_removed (UnityLauncherScrollerView* self, UnityLauncherScrollerChild* child);
#define UNITY_LAUNCHER_SHORT_DELAY ((guint) 400)
static void _lambda84_ (Block13Data* _data13_);
static void __lambda84__clutter_animation_completed (ClutterAnimation* _sender, gpointer self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (Block13Data* _data13_);
static void unity_launcher_scroller_view_model_order_changed (UnityLauncherScrollerView* self);
static void unity_launcher_scroller_view_on_autoscroll_frame (UnityLauncherScrollerView* self, ClutterTimeline* timeline, gint msecs);
static void unity_launcher_scroller_view_on_auto_scrolling_state_change (UnityLauncherScrollerView* self);
gboolean unity_launcher_scroller_view_get_is_autoscrolling (UnityLauncherScrollerView* self);
static gboolean unity_launcher_scroller_view_on_button_press_event (UnityLauncherScrollerView* self, ClutterEvent* event);
static gboolean unity_launcher_scroller_view_on_button_release_event (UnityLauncherScrollerView* self, ClutterEvent* event);
static gboolean _unity_launcher_scroller_view_on_button_release_event_clutter_actor_button_release_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static float unity_launcher_scroller_view_get_aligned_settle_position (UnityLauncherScrollerView* self);
GType menu_manager_get_type (void) G_GNUC_CONST;
MenuManager* menu_manager_get_default (void);
void menu_manager_popdown_current_menu (MenuManager* self);
static void unity_launcher_scroller_view_on_menu_close (UnityLauncherScrollerView* self);
static void _unity_launcher_scroller_view_on_menu_close_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean unity_launcher_scroller_view_on_queue_contract_launcher (UnityLauncherScrollerView* self);
static gboolean unity_launcher_scroller_view_do_queue_contract_launcher (UnityLauncherScrollerView* self);
static gboolean _unity_launcher_scroller_view_on_queue_contract_launcher_gsource_func (gpointer self);
GType unity_launcher_quicklist_controller_state_get_type (void) G_GNUC_CONST;
UnityLauncherQuicklistControllerState unity_launcher_quicklist_controller_get_state (UnityLauncherQuicklistController* self);
UnityLauncherQuicklistController* unity_launcher_quicklist_controller_get_current_menu (void);
static gboolean unity_launcher_scroller_view_on_autoscroll_motion_check (UnityLauncherScrollerView* self, float y);
static void unity_launcher_scroller_view_on_drag_motion_event (UnityLauncherScrollerView* self, UnityDragModel* model, float x, float y);
static gboolean unity_launcher_scroller_view_on_scroll_event (UnityLauncherScrollerView* self, ClutterEvent* event);
static void unity_launcher_scroller_view_on_scroller_frame (UnityLauncherScrollerView* self, ClutterTimeline* timeline, gint msecs);
static void unity_launcher_scroller_view_do_anim_settle (UnityLauncherScrollerView* self, ClutterTimeline* timeline, gint msecs);
static void unity_launcher_scroller_view_do_anim_fling (UnityLauncherScrollerView* self, ClutterTimeline* timeline, gint msecs);
static void unity_launcher_scroller_view_do_anim_bounce (UnityLauncherScrollerView* self, ClutterTimeline* timeline, gint msecs);
CtkEffectCache* unity_launcher_scroller_view_get_cache (UnityLauncherScrollerView* self);
static gboolean _lambda85_ (UnityLauncherScrollerView* self);
static gboolean __lambda85__gsource_func (gpointer self);
static void unity_launcher_scroller_view_real_get_preferred_width (ClutterActor* base, float for_height, float* minimum_width, float* natural_width);
static void unity_launcher_scroller_view_real_get_preferred_height (ClutterActor* base, float for_width, float* minimum_height, float* natural_height);
static void unity_launcher_scroller_view_order_children_expanded (UnityLauncherScrollerView* self, gboolean immediate);
static void unity_launcher_scroller_view_order_children_contracted (UnityLauncherScrollerView* self, gboolean immediate);
void unity_launcher_scroller_child_force_rotation_jump (UnityLauncherScrollerChild* self, float degrees);
void unity_launcher_scroller_child_set_rotation (UnityLauncherScrollerChild* self, float value);
gint unity_launcher_scroller_view_get_drag_indicator_index (UnityLauncherScrollerView* self);
static void unity_launcher_scroller_view_real_allocate (ClutterActor* base, const ClutterActorBox* box, ClutterAllocationFlags flags);
static void unity_launcher_scroller_view_real_pick (ClutterActor* base, const ClutterColor* color);
static void unity_launcher_scroller_view_real_paint (ClutterActor* base);
float unity_launcher_scroller_view_get_drag_indicator_opacity (UnityLauncherScrollerView* self);
static void unity_launcher_scroller_view_real_map (ClutterActor* base);
static void unity_launcher_scroller_view_real_unmap (ClutterActor* base);
static void unity_launcher_scroller_view_set_model (UnityLauncherScrollerView* self, UnityLauncherScrollerModel* value);
static void unity_launcher_scroller_view_set_cache (UnityLauncherScrollerView* self, CtkEffectCache* value);
void unity_launcher_scroller_view_set_drag_indicator_active (UnityLauncherScrollerView* self, gboolean value);
void unity_launcher_scroller_view_set_drag_indicator_space (UnityLauncherScrollerView* self, gboolean value);
void unity_launcher_scroller_view_set_drag_indicator_index (UnityLauncherScrollerView* self, gint value);
void unity_launcher_scroller_view_set_drag_indicator_opacity (UnityLauncherScrollerView* self, float value);
gpointer unity_testing_object_registry_ref (gpointer instance);
void unity_testing_object_registry_unref (gpointer instance);
GParamSpec* unity_testing_param_spec_object_registry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_testing_value_set_object_registry (GValue* value, gpointer v_object);
void unity_testing_value_take_object_registry (GValue* value, gpointer v_object);
gpointer unity_testing_value_get_object_registry (const GValue* value);
GType unity_testing_object_registry_get_type (void) G_GNUC_CONST;
UnityTestingObjectRegistry* unity_testing_object_registry_get_default (void);
void unity_testing_object_registry_register (UnityTestingObjectRegistry* self, const char* name, GObject* object);
static void _unity_launcher_scroller_view_on_drag_indicator_active_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _unity_launcher_scroller_view_on_drag_indicator_index_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _unity_launcher_scroller_view_on_drag_indicator_space_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _unity_launcher_scroller_view_model_child_added_unity_launcher_scroller_model_child_added (UnityLauncherScrollerModel* _sender, UnityLauncherScrollerChild* child, gpointer self);
static void _unity_launcher_scroller_view_model_child_removed_unity_launcher_scroller_model_child_removed (UnityLauncherScrollerModel* _sender, UnityLauncherScrollerChild* child, gpointer self);
static void _unity_launcher_scroller_view_model_order_changed_unity_launcher_scroller_model_order_changed (UnityLauncherScrollerModel* _sender, gpointer self);
static gboolean _unity_launcher_scroller_view_on_button_press_event_clutter_actor_button_press_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean _unity_launcher_scroller_view_on_scroll_event_clutter_actor_scroll_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static void _unity_launcher_scroller_view_on_auto_scrolling_state_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _unity_launcher_scroller_view_on_drag_motion_event_unity_drag_controller_drag_motion (UnityDragController* _sender, UnityDragModel* model, float x, float y, gpointer self);
static void _unity_launcher_scroller_view_on_scroller_frame_clutter_timeline_new_frame (ClutterTimeline* _sender, gint msecs, gpointer self);
static void _lambda86_ (UnityLauncherScrollerView* self);
static void __lambda86__clutter_timeline_started (ClutterTimeline* _sender, gpointer self);
static void _lambda87_ (UnityLauncherScrollerView* self);
static gboolean _lambda88_ (UnityLauncherScrollerView* self);
static gboolean __lambda88__gsource_func (gpointer self);
static void __lambda87__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static void _unity_launcher_scroller_view_on_autoscroll_frame_clutter_timeline_new_frame (ClutterTimeline* _sender, gint msecs, gpointer self);
static void _lambda89_ (UnityLauncherScrollerView* self);
static void __lambda89__clutter_timeline_started (ClutterTimeline* _sender, gpointer self);
static void _lambda90_ (UnityLauncherScrollerView* self);
static gboolean _lambda91_ (UnityLauncherScrollerView* self);
static gboolean __lambda91__gsource_func (gpointer self);
static void __lambda90__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static void _lambda92_ (UnityLauncherScrollerView* self);
static void __lambda92__unity_drag_controller_drag_start (UnityDragController* _sender, UnityDragModel* model, gpointer self);
static void _lambda93_ (UnityDragModel* drag_model, float x, float y, UnityLauncherScrollerView* self);
static gboolean _lambda94_ (UnityLauncherScrollerView* self);
static gboolean __lambda94__gsource_func (gpointer self);
static void __lambda93__unity_drag_controller_drag_drop (UnityDragController* _sender, UnityDragModel* model, float x, float y, gpointer self);
static void _lambda95_ (UnityDragModel* model, float x, float y, UnityLauncherScrollerView* self);
static void __lambda95__unity_drag_controller_drag_motion (UnityDragController* _sender, UnityDragModel* model, float x, float y, gpointer self);
static gboolean _lambda96_ (UnityLauncherScrollerView* self);
static gboolean __lambda96__gsource_func (gpointer self);
static GObject * unity_launcher_scroller_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_launcher_scroller_view_finalize (GObject* obj);
static void unity_launcher_scroller_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_launcher_scroller_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



GType unity_launcher_scroller_phase_get_type (void) {
	static volatile gsize unity_launcher_scroller_phase_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_scroller_phase_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_LAUNCHER_SCROLLER_PHASE_PANNING, "UNITY_LAUNCHER_SCROLLER_PHASE_PANNING", "panning"}, {UNITY_LAUNCHER_SCROLLER_PHASE_SETTLING, "UNITY_LAUNCHER_SCROLLER_PHASE_SETTLING", "settling"}, {UNITY_LAUNCHER_SCROLLER_PHASE_REORDERING, "UNITY_LAUNCHER_SCROLLER_PHASE_REORDERING", "reordering"}, {UNITY_LAUNCHER_SCROLLER_PHASE_FLUNG, "UNITY_LAUNCHER_SCROLLER_PHASE_FLUNG", "flung"}, {UNITY_LAUNCHER_SCROLLER_PHASE_BOUNCE, "UNITY_LAUNCHER_SCROLLER_PHASE_BOUNCE", "bounce"}, {UNITY_LAUNCHER_SCROLLER_PHASE_NONE, "UNITY_LAUNCHER_SCROLLER_PHASE_NONE", "none"}, {0, NULL, NULL}};
		GType unity_launcher_scroller_phase_type_id;
		unity_launcher_scroller_phase_type_id = g_enum_register_static ("UnityLauncherScrollerPhase", values);
		g_once_init_leave (&unity_launcher_scroller_phase_type_id__volatile, unity_launcher_scroller_phase_type_id);
	}
	return unity_launcher_scroller_phase_type_id__volatile;
}


GType unity_launcher_scroller_view_type_get_type (void) {
	static volatile gsize unity_launcher_scroller_view_type_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_scroller_view_type_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_EXPANDED, "UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_EXPANDED", "expanded"}, {UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_CONTRACTED, "UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_CONTRACTED", "contracted"}, {0, NULL, NULL}};
		GType unity_launcher_scroller_view_type_type_id;
		unity_launcher_scroller_view_type_type_id = g_enum_register_static ("UnityLauncherScrollerViewType", values);
		g_once_init_leave (&unity_launcher_scroller_view_type_type_id__volatile, unity_launcher_scroller_view_type_type_id);
	}
	return unity_launcher_scroller_view_type_type_id__volatile;
}


UnityLauncherChildTransition* unity_launcher_child_transition_construct (GType object_type) {
	UnityLauncherChildTransition* self;
	self = (UnityLauncherChildTransition*) g_type_create_instance (object_type);
	return self;
}


UnityLauncherChildTransition* unity_launcher_child_transition_new (void) {
	return unity_launcher_child_transition_construct (UNITY_LAUNCHER_TYPE_CHILD_TRANSITION);
}


static void unity_launcher_value_child_transition_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void unity_launcher_value_child_transition_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_launcher_child_transition_unref (value->data[0].v_pointer);
	}
}


static void unity_launcher_value_child_transition_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_launcher_child_transition_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer unity_launcher_value_child_transition_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* unity_launcher_value_child_transition_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityLauncherChildTransition* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_launcher_child_transition_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* unity_launcher_value_child_transition_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityLauncherChildTransition** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_launcher_child_transition_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* unity_launcher_param_spec_child_transition (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UnityLauncherParamSpecChildTransition* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UNITY_LAUNCHER_TYPE_CHILD_TRANSITION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer unity_launcher_value_get_child_transition (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_LAUNCHER_TYPE_CHILD_TRANSITION), NULL);
	return value->data[0].v_pointer;
}


void unity_launcher_value_set_child_transition (GValue* value, gpointer v_object) {
	UnityLauncherChildTransition* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_LAUNCHER_TYPE_CHILD_TRANSITION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_LAUNCHER_TYPE_CHILD_TRANSITION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_launcher_child_transition_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_launcher_child_transition_unref (old);
	}
}


void unity_launcher_value_take_child_transition (GValue* value, gpointer v_object) {
	UnityLauncherChildTransition* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_LAUNCHER_TYPE_CHILD_TRANSITION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_LAUNCHER_TYPE_CHILD_TRANSITION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_launcher_child_transition_unref (old);
	}
}


static void unity_launcher_child_transition_class_init (UnityLauncherChildTransitionClass * klass) {
	unity_launcher_child_transition_parent_class = g_type_class_peek_parent (klass);
	UNITY_LAUNCHER_CHILD_TRANSITION_CLASS (klass)->finalize = unity_launcher_child_transition_finalize;
}


static void unity_launcher_child_transition_instance_init (UnityLauncherChildTransition * self) {
	self->ref_count = 1;
}


static void unity_launcher_child_transition_finalize (UnityLauncherChildTransition* obj) {
	UnityLauncherChildTransition * self;
	self = UNITY_LAUNCHER_CHILD_TRANSITION (obj);
}


GType unity_launcher_child_transition_get_type (void) {
	static volatile gsize unity_launcher_child_transition_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_child_transition_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { unity_launcher_value_child_transition_init, unity_launcher_value_child_transition_free_value, unity_launcher_value_child_transition_copy_value, unity_launcher_value_child_transition_peek_pointer, "p", unity_launcher_value_child_transition_collect_value, "p", unity_launcher_value_child_transition_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityLauncherChildTransitionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_launcher_child_transition_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLauncherChildTransition), 0, (GInstanceInitFunc) unity_launcher_child_transition_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_launcher_child_transition_type_id;
		unity_launcher_child_transition_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityLauncherChildTransition", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_launcher_child_transition_type_id__volatile, unity_launcher_child_transition_type_id);
	}
	return unity_launcher_child_transition_type_id__volatile;
}


gpointer unity_launcher_child_transition_ref (gpointer instance) {
	UnityLauncherChildTransition* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_launcher_child_transition_unref (gpointer instance) {
	UnityLauncherChildTransition* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_LAUNCHER_CHILD_TRANSITION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


UnityLauncherScrollerView* unity_launcher_scroller_view_construct (GType object_type, UnityLauncherScrollerModel* _model, CtkEffectCache* _cache) {
	UnityLauncherScrollerView * self;
	g_return_val_if_fail (_model != NULL, NULL);
	g_return_val_if_fail (_cache != NULL, NULL);
	self = (UnityLauncherScrollerView*) g_object_new (object_type, "model", _model, "cache", _cache, NULL);
	return self;
}


UnityLauncherScrollerView* unity_launcher_scroller_view_new (UnityLauncherScrollerModel* _model, CtkEffectCache* _cache) {
	return unity_launcher_scroller_view_construct (UNITY_LAUNCHER_TYPE_SCROLLER_VIEW, _model, _cache);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static ClutterActor* unity_launcher_scroller_view_handle_event (UnityLauncherScrollerView* self, ClutterEvent* event, gboolean assume_on_launcher) {
	ClutterActor* result = NULL;
	float x = 0.0F;
	float y = 0.0F;
	ClutterActor* _tmp1_;
	ClutterActor* picked_actor;
	ClutterActor* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->disable_child_events) {
		result = NULL;
		return result;
	}
	if (CLUTTER_IS_ACTOR (self->priv->last_picked_actor) == FALSE) {
		ClutterActor* _tmp0_;
		self->priv->last_picked_actor = (_tmp0_ = NULL, _g_object_unref0 (self->priv->last_picked_actor), _tmp0_);
	}
	{
		UnityLauncherScrollerModelIterator* _actor_it;
		_actor_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			ClutterActor* actor;
			if (!unity_launcher_scroller_model_iterator_next (_actor_it)) {
				break;
			}
			actor = (ClutterActor*) unity_launcher_scroller_model_iterator_get (_actor_it);
			clutter_actor_set_reactive (actor, TRUE);
			_g_object_unref0 (actor);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_actor_it);
	}
	clutter_event_get_coords (event, &x, &y);
	self->priv->last_known_x = x;
	self->priv->last_known_y = y;
	if (assume_on_launcher) {
		x = (float) 25;
	}
	picked_actor = _g_object_ref0 (clutter_stage_get_actor_at_pos ((_tmp1_ = clutter_actor_get_stage ((ClutterActor*) self), CLUTTER_IS_STAGE (_tmp1_) ? ((ClutterStage*) _tmp1_) : NULL), CLUTTER_PICK_REACTIVE, (gint) x, (gint) y));
	{
		UnityLauncherScrollerModelIterator* _actor_it;
		_actor_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			ClutterActor* actor;
			if (!unity_launcher_scroller_model_iterator_next (_actor_it)) {
				break;
			}
			actor = (ClutterActor*) unity_launcher_scroller_model_iterator_get (_actor_it);
			clutter_actor_set_reactive (actor, FALSE);
			_g_object_unref0 (actor);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_actor_it);
	}
	if (CLUTTER_IS_ACTOR (picked_actor)) {
		if (self->priv->last_picked_actor != picked_actor) {
			ClutterEvent _tmp2_ = {0};
			ClutterEvent crossing_event;
			ClutterActor* _tmp3_;
			crossing_event = (_tmp2_.type = 0, _tmp2_);
			crossing_event.type = CLUTTER_LEAVE;
			crossing_event.crossing.x = x;
			crossing_event.crossing.y = y;
			crossing_event.crossing.stage = (_tmp3_ = clutter_actor_get_stage ((ClutterActor*) self), CLUTTER_IS_STAGE (_tmp3_) ? ((ClutterStage*) _tmp3_) : NULL);
			crossing_event.crossing.flags = CLUTTER_EVENT_FLAG_SYNTHETIC;
			if (CLUTTER_IS_ACTOR (self->priv->last_picked_actor)) {
				clutter_actor_event (self->priv->last_picked_actor, &crossing_event, FALSE);
			}
			crossing_event.type = CLUTTER_ENTER;
			clutter_actor_event (picked_actor, &crossing_event, FALSE);
		}
	} else {
		if (CLUTTER_IS_ACTOR (self->priv->last_picked_actor)) {
			ClutterEvent _tmp4_ = {0};
			ClutterEvent crossing_event;
			ClutterActor* _tmp5_;
			crossing_event = (_tmp4_.type = 0, _tmp4_);
			crossing_event.type = CLUTTER_LEAVE;
			crossing_event.crossing.x = x;
			crossing_event.crossing.y = y;
			crossing_event.crossing.stage = (_tmp5_ = clutter_actor_get_stage ((ClutterActor*) self), CLUTTER_IS_STAGE (_tmp5_) ? ((ClutterStage*) _tmp5_) : NULL);
			crossing_event.crossing.flags = CLUTTER_EVENT_FLAG_SYNTHETIC;
			clutter_actor_event (self->priv->last_picked_actor, &crossing_event, FALSE);
		}
	}
	self->priv->last_picked_actor = (_tmp6_ = _g_object_ref0 (picked_actor), _g_object_unref0 (self->priv->last_picked_actor), _tmp6_);
	result = picked_actor;
	return result;
}


static gboolean _unity_launcher_scroller_view_on_enter_event_clutter_actor_enter_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_launcher_scroller_view_on_enter_event (self, event);
	return result;
}


static gboolean _unity_launcher_scroller_view_on_leave_event_clutter_actor_leave_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_launcher_scroller_view_on_leave_event (self, event);
	return result;
}


static gboolean _unity_launcher_scroller_view_on_motion_event_clutter_actor_motion_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_launcher_scroller_view_on_motion_event (self, event);
	return result;
}


static gboolean _unity_launcher_scroller_view_passthrough_motion_event_clutter_actor_motion_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_launcher_scroller_view_passthrough_motion_event (self, event);
	return result;
}


static gboolean unity_launcher_scroller_view_passthrough_motion_event (UnityLauncherScrollerView* self, ClutterEvent* event) {
	gboolean result = FALSE;
	UnityDragController* drag_controller;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	ClutterActor* picked_actor;
	g_return_val_if_fail (self != NULL, FALSE);
	drag_controller = _g_object_ref0 (unity_drag_controller_get_default ());
	if (unity_drag_controller_get_is_dragging (drag_controller)) {
		result = FALSE;
		_g_object_unref0 (drag_controller);
		return result;
	}
	g_signal_parse_name ("enter-event", CLUTTER_TYPE_ACTOR, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((ClutterActor*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _unity_launcher_scroller_view_on_enter_event_clutter_actor_enter_event, self);
	g_signal_parse_name ("leave-event", CLUTTER_TYPE_ACTOR, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((ClutterActor*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _unity_launcher_scroller_view_on_leave_event_clutter_actor_leave_event, self);
	g_signal_parse_name ("motion-event", CLUTTER_TYPE_ACTOR, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((ClutterActor*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _unity_launcher_scroller_view_on_motion_event_clutter_actor_motion_event, self);
	g_signal_parse_name ("motion-event", CLUTTER_TYPE_ACTOR, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((ClutterActor*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _unity_launcher_scroller_view_passthrough_motion_event_clutter_actor_motion_event, self);
	if (self->priv->is_scrolling) {
		guint _tmp4_;
		g_signal_parse_name ("motion-event", CLUTTER_TYPE_ACTOR, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (clutter_actor_get_stage ((ClutterActor*) self), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _unity_launcher_scroller_view_on_motion_event_clutter_actor_motion_event, self);
	}
	picked_actor = unity_launcher_scroller_view_handle_event (self, event, self->priv->is_scrolling);
	if (CLUTTER_IS_ACTOR (picked_actor)) {
		clutter_actor_event (picked_actor, event, FALSE);
	}
	g_signal_connect_object ((ClutterActor*) self, "enter-event", (GCallback) _unity_launcher_scroller_view_on_enter_event_clutter_actor_enter_event, self, 0);
	g_signal_connect_object ((ClutterActor*) self, "leave-event", (GCallback) _unity_launcher_scroller_view_on_leave_event_clutter_actor_leave_event, self, 0);
	g_signal_connect_object ((ClutterActor*) self, "motion-event", (GCallback) _unity_launcher_scroller_view_on_motion_event_clutter_actor_motion_event, self, 0);
	g_signal_connect_object ((ClutterActor*) self, "motion-event", (GCallback) _unity_launcher_scroller_view_passthrough_motion_event_clutter_actor_motion_event, self, 0);
	if (self->priv->is_scrolling) {
		g_signal_connect_object (clutter_actor_get_stage ((ClutterActor*) self), "motion-event", (GCallback) _unity_launcher_scroller_view_on_motion_event_clutter_actor_motion_event, self, 0);
	}
	result = FALSE;
	_g_object_unref0 (picked_actor);
	_g_object_unref0 (drag_controller);
	return result;
}


static gboolean _unity_launcher_scroller_view_passthrough_button_press_event_clutter_actor_button_press_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_launcher_scroller_view_passthrough_button_press_event (self, event);
	return result;
}


static gboolean unity_launcher_scroller_view_passthrough_button_press_event (UnityLauncherScrollerView* self, ClutterEvent* event) {
	gboolean result = FALSE;
	UnityDragController* drag_controller;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	ClutterActor* picked_actor;
	g_return_val_if_fail (self != NULL, FALSE);
	drag_controller = _g_object_ref0 (unity_drag_controller_get_default ());
	if (unity_drag_controller_get_is_dragging (drag_controller)) {
		result = FALSE;
		_g_object_unref0 (drag_controller);
		return result;
	}
	g_signal_parse_name ("enter-event", CLUTTER_TYPE_ACTOR, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((ClutterActor*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _unity_launcher_scroller_view_on_enter_event_clutter_actor_enter_event, self);
	g_signal_parse_name ("leave-event", CLUTTER_TYPE_ACTOR, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((ClutterActor*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _unity_launcher_scroller_view_on_leave_event_clutter_actor_leave_event, self);
	g_signal_parse_name ("button-press-event", CLUTTER_TYPE_ACTOR, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((ClutterActor*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _unity_launcher_scroller_view_passthrough_button_press_event_clutter_actor_button_press_event, self);
	picked_actor = unity_launcher_scroller_view_handle_event (self, event, self->priv->is_scrolling);
	if (CLUTTER_IS_ACTOR (picked_actor)) {
		clutter_actor_event (picked_actor, event, FALSE);
	}
	g_signal_connect_object ((ClutterActor*) self, "enter-event", (GCallback) _unity_launcher_scroller_view_on_enter_event_clutter_actor_enter_event, self, 0);
	g_signal_connect_object ((ClutterActor*) self, "leave-event", (GCallback) _unity_launcher_scroller_view_on_leave_event_clutter_actor_leave_event, self, 0);
	g_signal_connect_object ((ClutterActor*) self, "button-press-event", (GCallback) _unity_launcher_scroller_view_passthrough_button_press_event_clutter_actor_button_press_event, self, 0);
	result = FALSE;
	_g_object_unref0 (picked_actor);
	_g_object_unref0 (drag_controller);
	return result;
}


static gboolean _unity_launcher_scroller_view_passthrough_button_release_event_clutter_actor_button_release_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_launcher_scroller_view_passthrough_button_release_event (self, event);
	return result;
}


static gboolean unity_launcher_scroller_view_passthrough_button_release_event (UnityLauncherScrollerView* self, ClutterEvent* event) {
	gboolean result = FALSE;
	UnityDragController* drag_controller;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	ClutterActor* picked_actor;
	g_return_val_if_fail (self != NULL, FALSE);
	drag_controller = _g_object_ref0 (unity_drag_controller_get_default ());
	if (unity_drag_controller_get_is_dragging (drag_controller)) {
		result = FALSE;
		_g_object_unref0 (drag_controller);
		return result;
	}
	g_signal_parse_name ("enter-event", CLUTTER_TYPE_ACTOR, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((ClutterActor*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _unity_launcher_scroller_view_on_enter_event_clutter_actor_enter_event, self);
	g_signal_parse_name ("leave-event", CLUTTER_TYPE_ACTOR, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((ClutterActor*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _unity_launcher_scroller_view_on_leave_event_clutter_actor_leave_event, self);
	g_signal_parse_name ("button-release-event", CLUTTER_TYPE_ACTOR, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((ClutterActor*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _unity_launcher_scroller_view_passthrough_button_release_event_clutter_actor_button_release_event, self);
	picked_actor = unity_launcher_scroller_view_handle_event (self, event, self->priv->is_scrolling);
	if (CLUTTER_IS_ACTOR (picked_actor)) {
		clutter_actor_event (picked_actor, event, FALSE);
	}
	g_signal_connect_object ((ClutterActor*) self, "enter-event", (GCallback) _unity_launcher_scroller_view_on_enter_event_clutter_actor_enter_event, self, 0);
	g_signal_connect_object ((ClutterActor*) self, "leave-event", (GCallback) _unity_launcher_scroller_view_on_leave_event_clutter_actor_leave_event, self, 0);
	g_signal_connect_object ((ClutterActor*) self, "button-release-event", (GCallback) _unity_launcher_scroller_view_passthrough_button_release_event_clutter_actor_button_release_event, self, 0);
	result = FALSE;
	_g_object_unref0 (picked_actor);
	_g_object_unref0 (drag_controller);
	return result;
}


static void unity_launcher_scroller_view_on_drag_indicator_space_change (UnityLauncherScrollerView* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_drag_indicator_active) {
		if (self->priv->_drag_indicator_space) {
			clutter_actor_animate ((ClutterActor*) self, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 150, "drag-indicator-opacity", 0.0f, NULL);
			unity_launcher_scroller_view_order_children (self, FALSE);
			return;
		} else {
			clutter_actor_animate ((ClutterActor*) self, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 150, "drag-indicator-opacity", 1.0f, NULL);
			unity_launcher_scroller_view_order_children (self, FALSE);
		}
	} else {
		clutter_actor_animate ((ClutterActor*) self, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 150, "drag-indicator-opacity", 1.0f, NULL);
		unity_launcher_scroller_view_order_children (self, FALSE);
	}
}


static void unity_launcher_scroller_view_on_drag_indicator_active_change (UnityLauncherScrollerView* self) {
	g_return_if_fail (self != NULL);
	unity_launcher_scroller_view_on_drag_indicator_space_change (self);
}


static void unity_launcher_scroller_view_on_drag_indicator_index_change (UnityLauncherScrollerView* self) {
	g_return_if_fail (self != NULL);
	unity_launcher_scroller_view_order_children (self, FALSE);
	clutter_actor_queue_relayout ((ClutterActor*) self);
}


void unity_launcher_scroller_view_enable_keyboard_selection_mode (UnityLauncherScrollerView* self, gboolean choice) {
	gint _tmp0_ = 0;
	guint8 new_opacity;
	gint index;
	g_return_if_fail (self != NULL);
	if (choice) {
		self->priv->last_scroll_position = self->priv->scroll_position;
	}
	if (choice) {
		_tmp0_ = 0xff;
	} else {
		_tmp0_ = 0x00;
	}
	new_opacity = (guint8) _tmp0_;
	index = 1;
	{
		GeeIterator* _kb_ind_it;
		_kb_ind_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->keyboard_indicators);
		while (TRUE) {
			ClutterCairoTexture* kb_ind;
			if (!gee_iterator_next (_kb_ind_it)) {
				break;
			}
			kb_ind = (ClutterCairoTexture*) gee_iterator_get (_kb_ind_it);
			clutter_actor_animate ((ClutterActor*) kb_ind, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 150, "opacity", new_opacity, NULL);
			if (unity_launcher_scroller_model_get_size (self->priv->_model) <= index) {
				new_opacity = (guint8) 0x00;
			}
			index++;
			_g_object_unref0 (kb_ind);
		}
		_g_object_unref0 (_kb_ind_it);
	}
	if (!choice) {
		gboolean _tmp1_ = FALSE;
		if (self->priv->view_type != UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_CONTRACTED) {
			_tmp1_ = self->priv->last_known_pointer_x >= clutter_actor_get_width ((ClutterActor*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			{
				UnityLauncherScrollerModelIterator* _child_it;
				_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
				while (TRUE) {
					UnityLauncherScrollerChild* child;
					if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
						break;
					}
					child = unity_launcher_scroller_model_iterator_get (_child_it);
					if (unity_launcher_scroller_child_get_active (child)) {
						self->priv->focused_launcher = unity_launcher_scroller_model_index_of (self->priv->_model, child);
						_g_object_unref0 (child);
						break;
					}
					_g_object_unref0 (child);
				}
				_unity_launcher_scroller_model_iterator_unref0 (_child_it);
			}
			unity_launcher_scroller_view_contract_launcher (self);
		} else {
			if (self->priv->last_known_pointer_x < clutter_actor_get_width ((ClutterActor*) self)) {
				unity_launcher_scroller_view_move_scroll_position (self, self->priv->last_scroll_position - self->priv->scroll_position, FALSE, 160.0f);
			}
		}
	} else {
		unity_launcher_scroller_view_expand_launcher (self, (float) 0);
	}
}


static float* _float_dup (float* self) {
	float* dup;
	dup = g_new0 (float, 1);
	memcpy (dup, self, sizeof (float));
	return dup;
}


static gpointer __float_dup0 (gpointer self) {
	return self ? _float_dup (self) : NULL;
}


static void _g_slist_free_g_free (GSList* self) {
	g_slist_foreach (self, (GFunc) g_free, NULL);
	g_slist_free (self);
}


gint unity_launcher_scroller_view_get_model_index_at_y_pos_no_anim (UnityLauncherScrollerView* self, float y, gboolean return_minus_if_fail) {
	gint result = 0;
	GSList* positions;
	gint value;
	GSList* list;
	UnityDragModel* _tmp1_;
	UnityLauncherScrollerChildController* _tmp2_;
	UnityLauncherScrollerChild* _tmp3_;
	UnityLauncherScrollerChild* child;
	g_return_val_if_fail (self != NULL, 0);
	positions = NULL;
	{
		UnityLauncherScrollerModelIterator* _child_it;
		_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* child;
			float _tmp0_;
			GValue value = {0};
			ClutterAnimation* anim;
			if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
				break;
			}
			child = unity_launcher_scroller_model_iterator_get (_child_it);
			positions = g_slist_append (positions, __float_dup0 ((_tmp0_ = unity_launcher_scroller_child_get_position (child), &_tmp0_)));
			g_value_init (&value, G_TYPE_FLOAT);
			anim = _g_object_ref0 (clutter_actor_get_animation ((ClutterActor*) child));
			if (CLUTTER_IS_ANIMATION (anim)) {
				ClutterInterval* interval;
				interval = _g_object_ref0 (clutter_animation_get_interval (anim, "position"));
				if (CLUTTER_IS_INTERVAL (interval)) {
					clutter_interval_get_final_value (interval, &value);
					unity_launcher_scroller_child_set_position (child, g_value_get_float (&value));
				}
				_g_object_unref0 (interval);
			}
			_g_object_unref0 (anim);
			G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
			_g_object_unref0 (child);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_child_it);
	}
	value = unity_launcher_scroller_view_get_model_index_at_y_pos (self, y, return_minus_if_fail);
	list = positions;
	{
		UnityLauncherScrollerModelIterator* _child_it;
		_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* child;
			if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
				break;
			}
			child = unity_launcher_scroller_model_iterator_get (_child_it);
			unity_launcher_scroller_child_set_position (child, (float) (*((float*) list->data)));
			list = list->next;
			_g_object_unref0 (child);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_child_it);
	}
	child = (_tmp3_ = _g_object_ref0 (unity_launcher_scroller_child_controller_get_child (_tmp2_ = (_tmp1_ = unity_drag_controller_get_drag_model (unity_drag_controller_get_default ()), UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER (_tmp1_) ? ((UnityLauncherScrollerChildController*) _tmp1_) : NULL))), _g_object_unref0 (_tmp2_), _tmp3_);
	result = value;
	_g_object_unref0 (child);
	__g_slist_free_g_free0 (positions);
	return result;
}


gint unity_launcher_scroller_view_get_model_index_at_y_pos (UnityLauncherScrollerView* self, float y, gboolean return_minus_if_fail) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	if (!self->priv->do_logic_pick) {
		result = unity_launcher_scroller_view_get_model_index_at_y_pos_pick (self, y, return_minus_if_fail);
		return result;
	} else {
		result = unity_launcher_scroller_view_get_model_index_at_y_pos_logic (self, y, return_minus_if_fail);
		return result;
	}
}


static gint unity_launcher_scroller_view_get_model_index_at_y_pos_logic (UnityLauncherScrollerView* self, float y, gboolean return_minus_if_fail) {
	gint result = 0;
	gint _tmp2_ = 0;
	CtkPadding _tmp3_ = {0};
	UnityLauncherScrollerChild* _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	{
		UnityLauncherScrollerModelIterator* _child_it;
		_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* child;
			CtkPadding _tmp0_ = {0};
			if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
				break;
			}
			child = unity_launcher_scroller_model_iterator_get (_child_it);
			if (((unity_launcher_scroller_child_get_position (child) + (ctk_actor_get_padding ((CtkActor*) self, &_tmp0_), _tmp0_.top)) + clutter_actor_get_height ((ClutterActor*) child)) > y) {
				UnityLauncherScrollerChild* _tmp1_;
				result = unity_launcher_scroller_model_index_of (self->priv->_model, (_tmp1_ = child, UNITY_LAUNCHER_IS_SCROLLER_CHILD (_tmp1_) ? ((UnityLauncherScrollerChild*) _tmp1_) : NULL));
				_g_object_unref0 (child);
				_unity_launcher_scroller_model_iterator_unref0 (_child_it);
				return result;
			}
			_g_object_unref0 (child);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_child_it);
	}
	if (return_minus_if_fail) {
		result = -1;
		return result;
	}
	if ((_tmp5_ = y < (((ctk_actor_get_padding ((CtkActor*) self, &_tmp3_), _tmp3_.top) + clutter_actor_get_height ((ClutterActor*) (_tmp4_ = unity_launcher_scroller_model_get (self->priv->_model, 0)))) + self->spacing), _g_object_unref0 (_tmp4_), _tmp5_)) {
		_tmp2_ = 0;
	} else {
		_tmp2_ = unity_launcher_scroller_model_get_size (self->priv->_model) - 1;
	}
	result = _tmp2_;
	return result;
}


static gint unity_launcher_scroller_view_get_model_index_at_y_pos_pick (UnityLauncherScrollerView* self, float y, gboolean return_minus_if_fail) {
	gint result = 0;
	gint iy;
	ClutterActor* _tmp0_;
	ClutterActor* picked_actor;
	gint ret_val;
	g_return_val_if_fail (self != NULL, 0);
	iy = (gint) y;
	{
		UnityLauncherScrollerModelIterator* _actor_it;
		_actor_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* actor;
			if (!unity_launcher_scroller_model_iterator_next (_actor_it)) {
				break;
			}
			actor = unity_launcher_scroller_model_iterator_get (_actor_it);
			if (!actor->do_not_render) {
				clutter_actor_set_reactive ((ClutterActor*) actor, TRUE);
			}
			_g_object_unref0 (actor);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_actor_it);
	}
	picked_actor = _g_object_ref0 (clutter_stage_get_actor_at_pos ((_tmp0_ = clutter_actor_get_stage ((ClutterActor*) self), CLUTTER_IS_STAGE (_tmp0_) ? ((ClutterStage*) _tmp0_) : NULL), CLUTTER_PICK_REACTIVE, 25, iy));
	ret_val = -200;
	if (UNITY_LAUNCHER_IS_SCROLLER_CHILD (picked_actor) == FALSE) {
		ClutterActor* _tmp1_;
		ClutterActor* _tmp2_;
		picked_actor = (_tmp2_ = _g_object_ref0 (clutter_stage_get_actor_at_pos ((_tmp1_ = clutter_actor_get_stage ((ClutterActor*) self), CLUTTER_IS_STAGE (_tmp1_) ? ((ClutterStage*) _tmp1_) : NULL), CLUTTER_PICK_REACTIVE, 25, iy - 24)), _g_object_unref0 (picked_actor), _tmp2_);
		if (UNITY_LAUNCHER_IS_SCROLLER_CHILD (picked_actor) == FALSE) {
			ClutterActor* _tmp3_;
			ClutterActor* _tmp4_;
			picked_actor = (_tmp4_ = _g_object_ref0 (clutter_stage_get_actor_at_pos ((_tmp3_ = clutter_actor_get_stage ((ClutterActor*) self), CLUTTER_IS_STAGE (_tmp3_) ? ((ClutterStage*) _tmp3_) : NULL), CLUTTER_PICK_REACTIVE, 25, iy + 24)), _g_object_unref0 (picked_actor), _tmp4_);
			if (UNITY_LAUNCHER_IS_SCROLLER_CHILD (picked_actor) == FALSE) {
				gint _tmp5_ = 0;
				CtkPadding _tmp6_ = {0};
				UnityLauncherScrollerChild* _tmp7_;
				gboolean _tmp8_;
				if (return_minus_if_fail) {
					ret_val = -1;
				}
				if ((_tmp8_ = y < (((ctk_actor_get_padding ((CtkActor*) self, &_tmp6_), _tmp6_.top) + clutter_actor_get_height ((ClutterActor*) (_tmp7_ = unity_launcher_scroller_model_get (self->priv->_model, 0)))) + self->spacing), _g_object_unref0 (_tmp7_), _tmp8_)) {
					_tmp5_ = 0;
				} else {
					_tmp5_ = unity_launcher_scroller_model_get_size (self->priv->_model) - 1;
				}
				ret_val = _tmp5_;
			}
		}
	}
	if (ret_val < (-1)) {
		ClutterActor* _tmp9_;
		ret_val = unity_launcher_scroller_model_index_of (self->priv->_model, (_tmp9_ = picked_actor, UNITY_LAUNCHER_IS_SCROLLER_CHILD (_tmp9_) ? ((UnityLauncherScrollerChild*) _tmp9_) : NULL));
	}
	{
		UnityLauncherScrollerModelIterator* _actor_it;
		_actor_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			ClutterActor* actor;
			if (!unity_launcher_scroller_model_iterator_next (_actor_it)) {
				break;
			}
			actor = (ClutterActor*) unity_launcher_scroller_model_iterator_get (_actor_it);
			clutter_actor_set_reactive (actor, FALSE);
			_g_object_unref0 (actor);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_actor_it);
	}
	result = ret_val;
	_g_object_unref0 (picked_actor);
	return result;
}


static void unity_launcher_scroller_view_draw_keyboard_indicator_cairo (UnityLauncherScrollerView* self, cairo_t* cr, const char* text) {
	double x;
	double y;
	double w;
	double h;
	double r;
	PangoLayout* layout;
	GtkSettings* settings;
	char* _tmp0_ = NULL;
	char* _tmp1_;
	PangoFontDescription* _tmp2_;
	PangoFontDescription* desc;
	PangoContext* pango_context;
	GdkScreen* screen;
	gint _tmp3_;
	gint text_width = 0;
	gint text_height = 0;
	PangoRectangle log_rect = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (text != NULL);
	x = (double) 0;
	y = (double) 0;
	w = (double) 10;
	h = (double) 10;
	r = ctk_em_to_pixel ((double) 0.7f);
	layout = pango_cairo_create_layout (cr);
	settings = _g_object_ref0 (gtk_settings_get_default ());
	desc = (_tmp2_ = pango_font_description_from_string (_tmp1_ = (g_object_get (settings, "gtk-font-name", &_tmp0_, NULL), _tmp0_)), _g_free0 (_tmp1_), _tmp2_);
	pango_font_description_set_weight (desc, PANGO_WEIGHT_NORMAL);
	pango_layout_set_font_description (layout, desc);
	pango_layout_set_text (layout, text, -1);
	pango_context = _g_object_ref0 (pango_layout_get_context (layout));
	screen = _g_object_ref0 (gdk_screen_get_default ());
	pango_cairo_context_set_font_options (pango_context, gdk_screen_get_font_options (screen));
	pango_cairo_context_set_resolution (pango_context, (double) (((float) (g_object_get (settings, "gtk-xft-dpi", &_tmp3_, NULL), _tmp3_)) / ((float) PANGO_SCALE)));
	pango_layout_context_changed (layout);
	pango_layout_get_extents (layout, NULL, &log_rect);
	text_width = log_rect.width / PANGO_SCALE;
	text_height = log_rect.height / PANGO_SCALE;
	w = w + ((double) text_width);
	h = h + ((double) text_height);
	cairo_set_source_rgba (cr, 0.07, 0.07, 0.07, 0.8);
	cairo_move_to (cr, x + r, y);
	cairo_line_to (cr, (x + w) - r, y);
	cairo_curve_to (cr, x + w, y, x + w, y, x + w, y + r);
	cairo_line_to (cr, x + w, (y + h) - r);
	cairo_curve_to (cr, x + w, y + h, x + w, y + h, (x + w) - r, y + h);
	cairo_line_to (cr, x + r, y + h);
	cairo_curve_to (cr, x, y + h, x, y + h, x, (y + h) - r);
	cairo_line_to (cr, x, y + r);
	cairo_curve_to (cr, x, y, x, y, x + r, y);
	cairo_fill (cr);
	cairo_set_source_rgba (cr, (double) 1, (double) 1, (double) 1, (double) 1);
	cairo_move_to (cr, x + ((w - text_width) * 0.5), y + ((h - text_height) * 0.5));
	pango_cairo_show_layout (cr, layout);
	_g_object_unref0 (screen);
	_g_object_unref0 (pango_context);
	_pango_font_description_free0 (desc);
	_g_object_unref0 (settings);
	_g_object_unref0 (layout);
}


static void unity_launcher_scroller_view_load_textures (UnityLauncherScrollerView* self) {
	UnityThemeImage* _tmp0_;
	UnityThemeImage* _tmp1_;
	ClutterColor _tmp2_ = {0};
	ClutterColor color;
	gint index;
	gint key_indicator_w = 0;
	gint key_indicator_h = 0;
	GtkSettings* settings;
	char* _tmp3_ = NULL;
	char* _tmp4_;
	g_return_if_fail (self != NULL);
	self->priv->bgtex = (_tmp0_ = g_object_ref_sink (unity_theme_image_new ("launcher_background_middle")), _g_object_unref0 (self->priv->bgtex), _tmp0_);
	clutter_texture_set_repeat ((ClutterTexture*) self->priv->bgtex, TRUE, TRUE);
	clutter_actor_set_parent ((ClutterActor*) self->priv->bgtex, (ClutterActor*) self);
	self->priv->top_shadow = (_tmp1_ = g_object_ref_sink (unity_theme_image_new ("overflow_top")), _g_object_unref0 (self->priv->top_shadow), _tmp1_);
	clutter_texture_set_repeat ((ClutterTexture*) self->priv->top_shadow, TRUE, FALSE);
	clutter_actor_set_parent ((ClutterActor*) self->priv->top_shadow, (ClutterActor*) self);
	color = (memset (&_tmp2_, 0, sizeof (ClutterColor)), _tmp2_.red = (guint8) 0xff, _tmp2_.green = (guint8) 0xff, _tmp2_.blue = (guint8) 0xff, _tmp2_.alpha = (guint8) 0xff, _tmp2_);
	index = 1;
	settings = _g_object_ref0 (gtk_settings_get_default ());
	unity_quicklist_rendering_get_text_extents (_tmp4_ = (g_object_get (settings, "gtk-font-name", &_tmp3_, NULL), _tmp3_), "2", &key_indicator_w, &key_indicator_h);
	_g_free0 (_tmp4_);
	key_indicator_w = key_indicator_w + 10;
	key_indicator_h = key_indicator_h + 10;
	{
		gboolean _tmp5_;
		_tmp5_ = TRUE;
		while (TRUE) {
			ClutterCairoTexture* keyboard_indicator;
			if (!_tmp5_) {
				index++;
			}
			_tmp5_ = FALSE;
			if (!(index <= 10)) {
				break;
			}
			keyboard_indicator = g_object_ref_sink ((ClutterCairoTexture*) clutter_cairo_texture_new ((guint) key_indicator_w, (guint) key_indicator_h));
			clutter_actor_set_parent ((ClutterActor*) keyboard_indicator, (ClutterActor*) self);
			clutter_actor_set_opacity ((ClutterActor*) keyboard_indicator, (guint8) 0x00);
			clutter_cairo_texture_set_surface_size (keyboard_indicator, (guint) key_indicator_w, (guint) key_indicator_h);
			clutter_actor_set_size ((ClutterActor*) keyboard_indicator, (float) key_indicator_w, (float) key_indicator_h);
			clutter_cairo_texture_clear (keyboard_indicator);
			{
				cairo_t* cr;
				char* ind_str;
				cr = clutter_cairo_texture_create (keyboard_indicator);
				ind_str = g_strdup_printf ("%i", index);
				if (index == 10) {
					char* _tmp6_;
					ind_str = (_tmp6_ = g_strdup ("0"), _g_free0 (ind_str), _tmp6_);
				}
				unity_launcher_scroller_view_draw_keyboard_indicator_cairo (self, cr, ind_str);
				_g_free0 (ind_str);
				_cairo_destroy0 (cr);
			}
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->keyboard_indicators, keyboard_indicator);
			_g_object_unref0 (keyboard_indicator);
		}
	}
	_g_object_unref0 (settings);
}


static float unity_launcher_scroller_view_calculate_scroll_position (UnityLauncherScrollerView* self, gboolean check_bounds, float limit) {
	float result = 0.0F;
	float new_scroll_position;
	g_return_val_if_fail (self != NULL, 0.0F);
	new_scroll_position = self->priv->scroll_position;
	if (check_bounds) {
		new_scroll_position = fminf (new_scroll_position, (float) 0);
		new_scroll_position = fmaxf (new_scroll_position, -(unity_launcher_scroller_view_get_total_children_height (self) - unity_launcher_scroller_view_get_available_height (self)));
	} else {
		if (new_scroll_position > 0) {
			new_scroll_position = limit * (1 - powf ((limit - 1) / limit, new_scroll_position));
		} else {
			gboolean _tmp0_ = FALSE;
			if (unity_launcher_scroller_view_get_total_children_height (self) < unity_launcher_scroller_view_get_available_height (self)) {
				_tmp0_ = new_scroll_position < 0;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				new_scroll_position = -new_scroll_position;
				new_scroll_position = limit * (1 - powf ((limit - 1) / limit, new_scroll_position));
				new_scroll_position = -new_scroll_position;
			} else {
				gboolean _tmp1_ = FALSE;
				if (unity_launcher_scroller_view_get_total_children_height (self) >= unity_launcher_scroller_view_get_available_height (self)) {
					_tmp1_ = new_scroll_position < (-(unity_launcher_scroller_view_get_total_children_height (self) - unity_launcher_scroller_view_get_available_height (self)));
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					float diff;
					diff = new_scroll_position + (unity_launcher_scroller_view_get_total_children_height (self) - unity_launcher_scroller_view_get_available_height (self));
					new_scroll_position = limit * (1 - powf ((limit - 1) / limit, fabsf (diff)));
					new_scroll_position = (-(unity_launcher_scroller_view_get_total_children_height (self) - unity_launcher_scroller_view_get_available_height (self))) - new_scroll_position;
				}
			}
		}
	}
	result = new_scroll_position;
	return result;
}


static void unity_launcher_scroller_view_move_scroll_position (UnityLauncherScrollerView* self, float pixels, gboolean check_bounds, float limit) {
	float old_scroll_position;
	g_return_if_fail (self != NULL);
	self->priv->scroll_position = self->priv->scroll_position + pixels;
	old_scroll_position = self->priv->scroll_position;
	self->priv->scroll_position = unity_launcher_scroller_view_calculate_scroll_position (self, check_bounds, limit);
	unity_launcher_scroller_view_order_children (self, TRUE);
	clutter_actor_queue_relayout ((ClutterActor*) self);
	self->priv->scroll_position = old_scroll_position;
}


static void unity_launcher_scroller_view_disable_animations_on_children (UnityLauncherScrollerView* self, ClutterEvent* event) {
	g_return_if_fail (self != NULL);
}


static void unity_launcher_scroller_view_expand_launcher (UnityLauncherScrollerView* self, float absolute_y) {
	g_return_if_fail (self != NULL);
	if (self->priv->view_type == UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_EXPANDED) {
		return;
	}
	self->priv->view_type = UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_EXPANDED;
	if (unity_launcher_scroller_view_get_total_children_height (self) > unity_launcher_scroller_view_get_available_height (self)) {
		gint index;
		UnityLauncherScrollerChild* _tmp0_;
		float _tmp1_;
		float contracted_position;
		float old_scroll_position;
		UnityLauncherScrollerChild* _tmp2_;
		float _tmp3_;
		float new_scroll_position;
		self->priv->do_logic_pick = FALSE;
		index = unity_launcher_scroller_view_get_model_index_at_y_pos (self, absolute_y, FALSE);
		contracted_position = (_tmp1_ = unity_launcher_scroller_child_get_position (_tmp0_ = unity_launcher_scroller_model_get (self->priv->_model, index)), _g_object_unref0 (_tmp0_), _tmp1_);
		old_scroll_position = self->priv->scroll_position;
		self->priv->scroll_position = (float) 0;
		unity_launcher_scroller_view_order_children (self, TRUE);
		new_scroll_position = (_tmp3_ = -(unity_launcher_scroller_child_get_position (_tmp2_ = unity_launcher_scroller_model_get (self->priv->_model, index)) - contracted_position), _g_object_unref0 (_tmp2_), _tmp3_);
		self->priv->view_type = UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_CONTRACTED;
		self->priv->scroll_position = old_scroll_position;
		unity_launcher_scroller_view_order_children (self, TRUE);
		self->priv->view_type = UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_EXPANDED;
		self->priv->scroll_position = new_scroll_position;
		unity_launcher_scroller_view_order_children (self, FALSE);
		clutter_actor_queue_relayout ((ClutterActor*) self);
		self->priv->do_logic_pick = TRUE;
	}
}


static void unity_launcher_scroller_view_contract_launcher (UnityLauncherScrollerView* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->view_type == UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_CONTRACTED) {
		return;
	}
	{
		UnityLauncherScrollerModelIterator* _child_it;
		_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* child;
			if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
				break;
			}
			child = unity_launcher_scroller_model_iterator_get (_child_it);
			if (unity_launcher_scroller_child_get_active (child)) {
				self->priv->focused_launcher = unity_launcher_scroller_model_index_of (self->priv->_model, child);
			}
			_g_object_unref0 (child);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_child_it);
	}
	self->priv->view_type = UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_CONTRACTED;
	unity_launcher_scroller_view_order_children (self, FALSE);
	clutter_actor_queue_relayout ((ClutterActor*) self);
	unity_launcher_scroller_view_set_is_autoscrolling (self, FALSE);
}


static void _vala_array_add2 (float** array, int* length, int* size, float value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (float, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add3 (float** array, int* length, int* size, float value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (float, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _lambda83_ (UnityLauncherScrollerView* self) {
	clutter_actor_queue_relayout ((ClutterActor*) self);
}


static void __lambda83__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda83_ (self);
}


static void unity_launcher_scroller_view_model_child_added (UnityLauncherScrollerView* self, UnityLauncherScrollerChild* child) {
	gint prev_positions_length1;
	gint _prev_positions_size_;
	float* _tmp1_;
	float* _tmp0_ = NULL;
	float* prev_positions;
	gint prev_rotations_length1;
	gint _prev_rotations_size_;
	float* _tmp3_;
	float* _tmp2_ = NULL;
	float* prev_rotations;
	gint index;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	clutter_actor_unparent ((ClutterActor*) child);
	clutter_actor_set_parent ((ClutterActor*) child, (ClutterActor*) self);
	prev_positions = (_tmp1_ = (_tmp0_ = g_new0 (float, 0), _tmp0_), prev_positions_length1 = 0, _prev_positions_size_ = prev_positions_length1, _tmp1_);
	prev_rotations = (_tmp3_ = (_tmp2_ = g_new0 (float, 0), _tmp2_), prev_rotations_length1 = 0, _prev_rotations_size_ = prev_rotations_length1, _tmp3_);
	{
		UnityLauncherScrollerModelIterator* _modelchild_it;
		_modelchild_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* modelchild;
			if (!unity_launcher_scroller_model_iterator_next (_modelchild_it)) {
				break;
			}
			modelchild = unity_launcher_scroller_model_iterator_get (_modelchild_it);
			_vala_array_add2 (&prev_positions, &prev_positions_length1, &_prev_positions_size_, unity_launcher_scroller_child_get_position (modelchild));
			_vala_array_add3 (&prev_rotations, &prev_rotations_length1, &_prev_rotations_size_, unity_launcher_scroller_child_get_rotation (modelchild));
			_g_object_unref0 (modelchild);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_modelchild_it);
	}
	unity_launcher_scroller_view_order_children (self, TRUE);
	index = 0;
	{
		UnityLauncherScrollerModelIterator* _modelchild_it;
		_modelchild_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* modelchild;
			if (!unity_launcher_scroller_model_iterator_next (_modelchild_it)) {
				break;
			}
			modelchild = unity_launcher_scroller_model_iterator_get (_modelchild_it);
			if (child != modelchild) {
				unity_launcher_scroller_view_change_child_position_rotation (self, modelchild, prev_positions[index], prev_rotations[index], TRUE);
			}
			index++;
			_g_object_unref0 (modelchild);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_modelchild_it);
	}
	unity_launcher_scroller_view_order_children (self, FALSE);
	clutter_actor_queue_relayout ((ClutterActor*) self);
	g_signal_connect_object ((GObject*) child, "notify::position", (GCallback) __lambda83__g_object_notify, self, 0);
	clutter_actor_set_reactive ((ClutterActor*) child, FALSE);
	prev_rotations = (g_free (prev_rotations), NULL);
	prev_positions = (g_free (prev_positions), NULL);
}


static void _lambda84_ (Block13Data* _data13_) {
	UnityLauncherScrollerView * self;
	self = _data13_->self;
	clutter_actor_unparent ((ClutterActor*) _data13_->child);
	gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->child_refs, _data13_->child);
	unity_launcher_scroller_view_order_children (self, FALSE);
	clutter_actor_queue_relayout ((ClutterActor*) self);
}


static void __lambda84__clutter_animation_completed (ClutterAnimation* _sender, gpointer self) {
	_lambda84_ (self);
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (Block13Data* _data13_) {
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		_g_object_unref0 (_data13_->self);
		_g_object_unref0 (_data13_->child);
		g_slice_free (Block13Data, _data13_);
	}
}


static void unity_launcher_scroller_view_model_child_removed (UnityLauncherScrollerView* self, UnityLauncherScrollerChild* child) {
	Block13Data* _data13_;
	UnityDragController* drag_controller;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_data13_->child = _g_object_ref0 (child);
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->draw_btf, _data13_->child)) {
		gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->draw_btf, _data13_->child);
	}
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->draw_ftb, _data13_->child)) {
		gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->draw_ftb, _data13_->child);
	}
	drag_controller = _g_object_ref0 (unity_drag_controller_get_default ());
	if (unity_drag_controller_get_is_dragging (drag_controller)) {
		unity_launcher_scroller_view_order_children (self, FALSE);
		clutter_actor_queue_relayout ((ClutterActor*) self);
	} else {
		ClutterAnimation* anim;
		ClutterAnimation* icon_scale_anim;
		gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->child_refs, _data13_->child);
		anim = _g_object_ref0 (clutter_actor_animate ((ClutterActor*) _data13_->child, (gulong) CLUTTER_EASE_OUT_QUAD, UNITY_LAUNCHER_SHORT_DELAY, "opacity", 0, NULL));
		icon_scale_anim = _g_object_ref0 (clutter_actor_animate ((ClutterActor*) _data13_->child->processed_icon, (gulong) CLUTTER_EASE_OUT_QUAD, UNITY_LAUNCHER_SHORT_DELAY, "scale-x", 0.0, "scale-y", 0.0, NULL));
		g_signal_connect_data (anim, "completed", (GCallback) __lambda84__clutter_animation_completed, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
		_g_object_unref0 (icon_scale_anim);
		_g_object_unref0 (anim);
	}
	_g_object_unref0 (drag_controller);
	block13_data_unref (_data13_);
}


static void unity_launcher_scroller_view_model_order_changed (UnityLauncherScrollerView* self) {
	g_return_if_fail (self != NULL);
	unity_launcher_scroller_view_order_children (self, FALSE);
	clutter_actor_queue_relayout ((ClutterActor*) self);
}


static void unity_launcher_scroller_view_on_autoscroll_frame (UnityLauncherScrollerView* self, ClutterTimeline* timeline, gint msecs) {
	guint delta;
	ClutterEvent _tmp0_ = {0};
	ClutterEvent motion_event;
	ClutterActor* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeline != NULL);
	delta = clutter_timeline_get_delta (timeline);
	delta = delta + self->priv->autoscroll_stored_delta;
	if (delta <= 16) {
		self->priv->autoscroll_stored_delta = delta;
		return;
	}
	while (TRUE) {
		float speed;
		if (!(delta > 33)) {
			break;
		}
		delta = delta - ((guint) 33);
		speed = 0.0f;
		if (self->priv->autoscroll_mouse_pos_cache < 0) {
			speed = fabsf ((-12) - self->priv->autoscroll_mouse_pos_cache);
		} else {
			speed = 12.0f - fabsf (self->priv->autoscroll_mouse_pos_cache);
		}
		speed = speed / 12.0f;
		speed = speed * ((float) 30);
		speed = speed * ((float) self->priv->autoscroll_direction);
		unity_launcher_scroller_view_move_scroll_position (self, speed, TRUE, 160.0f);
	}
	motion_event = (_tmp0_.type = 0, _tmp0_);
	motion_event.type = CLUTTER_MOTION;
	motion_event.motion.x = self->priv->last_known_x;
	motion_event.motion.y = self->priv->last_known_y;
	motion_event.motion.stage = (_tmp1_ = clutter_actor_get_stage ((ClutterActor*) self), CLUTTER_IS_STAGE (_tmp1_) ? ((ClutterStage*) _tmp1_) : NULL);
	motion_event.motion.flags = CLUTTER_EVENT_FLAG_SYNTHETIC;
	unity_launcher_scroller_view_passthrough_motion_event (self, &motion_event);
	self->priv->autoscroll_stored_delta = delta;
}


static void unity_launcher_scroller_view_on_auto_scrolling_state_change (UnityLauncherScrollerView* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (clutter_timeline_is_playing (self->autoscroll_timeline) == FALSE) {
		_tmp0_ = self->priv->_is_autoscrolling;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		clutter_timeline_start (self->autoscroll_timeline);
	} else {
		gboolean _tmp1_ = FALSE;
		if (clutter_timeline_is_playing (self->autoscroll_timeline)) {
			_tmp1_ = self->priv->_is_autoscrolling == FALSE;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			clutter_timeline_stop (self->autoscroll_timeline);
		}
	}
}


static gboolean _unity_launcher_scroller_view_on_button_release_event_clutter_actor_button_release_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_launcher_scroller_view_on_button_release_event (self, event);
	return result;
}


static gboolean unity_launcher_scroller_view_on_button_press_event (UnityLauncherScrollerView* self, ClutterEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*event).button.button != 1) {
		result = FALSE;
		return result;
	}
	if (self->priv->is_scrolling) {
		unity_launcher_scroller_view_passthrough_button_press_event (self, event);
	}
	self->priv->button_down = TRUE;
	if (unity_launcher_scroller_view_get_model_index_at_y_pos (self, (*event).button.y, TRUE) < 0) {
		self->priv->can_scroll = FALSE;
	} else {
		self->priv->can_scroll = TRUE;
	}
	self->priv->previous_y_position = (*event).button.y;
	self->priv->previous_y_time = (guint) (*event).button.time;
	g_signal_connect_object (clutter_actor_get_stage ((ClutterActor*) self), "button-release-event", (GCallback) _unity_launcher_scroller_view_on_button_release_event_clutter_actor_button_release_event, self, 0);
	result = FALSE;
	return result;
}


static gboolean unity_launcher_scroller_view_on_button_release_event (UnityLauncherScrollerView* self, ClutterEvent* event) {
	gboolean result = FALSE;
	guint _tmp0_;
	MenuManager* manager;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*event).button.button != 1) {
		result = FALSE;
		return result;
	}
	self->priv->button_down = FALSE;
	g_signal_parse_name ("button-release-event", CLUTTER_TYPE_ACTOR, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (clutter_actor_get_stage ((ClutterActor*) self), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _unity_launcher_scroller_view_on_button_release_event_clutter_actor_button_release_event, self);
	unity_shell_remove_fullscreen_request (unity_global_shell, (GObject*) self);
	clutter_ungrab_pointer ();
	if (self->priv->is_scrolling) {
		guint _tmp1_;
		gboolean _tmp2_ = FALSE;
		{
			UnityLauncherScrollerModelIterator* _child_it;
			_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
			while (TRUE) {
				UnityLauncherScrollerChild* child;
				if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
					break;
				}
				child = unity_launcher_scroller_model_iterator_get (_child_it);
				child->grabbed_push = (float) 0;
				_g_object_unref0 (child);
			}
			_unity_launcher_scroller_model_iterator_unref0 (_child_it);
		}
		self->priv->is_scrolling = FALSE;
		unity_launcher_disable_quicklists = FALSE;
		clutter_ungrab_pointer ();
		g_signal_parse_name ("motion-event", CLUTTER_TYPE_ACTOR, &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (clutter_actor_get_stage ((ClutterActor*) self), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _unity_launcher_scroller_view_on_motion_event_clutter_actor_motion_event, self);
		if (self->priv->scroll_position > 0) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = self->priv->scroll_position < (-(unity_launcher_scroller_view_get_total_children_height (self) - unity_launcher_scroller_view_get_available_height (self)));
		}
		if (_tmp2_) {
			self->priv->current_phase = UNITY_LAUNCHER_SCROLLER_PHASE_SETTLING;
			self->priv->settle_position = unity_launcher_scroller_view_get_aligned_settle_position (self);
		} else {
			self->priv->current_phase = UNITY_LAUNCHER_SCROLLER_PHASE_FLUNG;
		}
		self->priv->disable_child_events = TRUE;
		clutter_timeline_start (self->fling_timeline);
	}
	manager = menu_manager_get_default ();
	menu_manager_popdown_current_menu (manager);
	result = FALSE;
	_g_object_unref0 (manager);
	return result;
}


static void _unity_launcher_scroller_view_on_menu_close_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_scroller_view_on_menu_close (self);
}


static gboolean unity_launcher_scroller_view_on_enter_event (UnityLauncherScrollerView* self, ClutterEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->queue_contract_launcher != 0) {
		g_source_remove (self->priv->queue_contract_launcher);
		self->priv->queue_contract_launcher = (guint) 0;
	}
	if (UNITY_LAUNCHER_IS_QUICKLIST_CONTROLLER (self->priv->attached_menu)) {
		guint _tmp0_;
		GQuark _tmp1_;
		UnityLauncherQuicklistController* _tmp2_;
		g_signal_parse_name ("notify::status", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) self->priv->attached_menu, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _unity_launcher_scroller_view_on_menu_close_g_object_notify, self);
		self->priv->attached_menu = (_tmp2_ = NULL, _g_object_unref0 (self->priv->attached_menu), _tmp2_);
	}
	unity_launcher_scroller_view_expand_launcher (self, (*event).crossing.y);
	result = FALSE;
	return result;
}


static gboolean unity_launcher_scroller_view_on_queue_contract_launcher (UnityLauncherScrollerView* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->queue_contract_launcher != 0) {
		self->priv->current_phase = UNITY_LAUNCHER_SCROLLER_PHASE_NONE;
		unity_launcher_scroller_view_contract_launcher (self);
	}
	self->priv->queue_contract_launcher = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean _unity_launcher_scroller_view_on_queue_contract_launcher_gsource_func (gpointer self) {
	gboolean result;
	result = unity_launcher_scroller_view_on_queue_contract_launcher (self);
	return result;
}


static gboolean unity_launcher_scroller_view_do_queue_contract_launcher (UnityLauncherScrollerView* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->queue_contract_launcher = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _unity_launcher_scroller_view_on_queue_contract_launcher_gsource_func, g_object_ref (self), g_object_unref);
	result = FALSE;
	return result;
}


static void unity_launcher_scroller_view_on_menu_close (UnityLauncherScrollerView* self) {
	g_return_if_fail (self != NULL);
	if (UNITY_LAUNCHER_IS_QUICKLIST_CONTROLLER (self->priv->attached_menu)) {
		if (unity_launcher_quicklist_controller_get_state (self->priv->attached_menu) != UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_MENU) {
			guint _tmp0_;
			GQuark _tmp1_;
			UnityLauncherQuicklistController* _tmp2_;
			if (self->priv->last_known_pointer_x > clutter_actor_get_width ((ClutterActor*) self)) {
				unity_launcher_scroller_view_do_queue_contract_launcher (self);
			}
			g_signal_parse_name ("notify::status", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
			g_signal_handlers_disconnect_matched ((GObject*) self->priv->attached_menu, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _unity_launcher_scroller_view_on_menu_close_g_object_notify, self);
			self->priv->attached_menu = (_tmp2_ = NULL, _g_object_unref0 (self->priv->attached_menu), _tmp2_);
		}
	}
}


static gboolean unity_launcher_scroller_view_on_leave_event (UnityLauncherScrollerView* self, ClutterEvent* event) {
	gboolean result = FALSE;
	UnityDragController* drag_controller;
	UnityLauncherQuicklistController* menu;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->last_known_pointer_x = (float) 200;
	drag_controller = _g_object_ref0 (unity_drag_controller_get_default ());
	if (unity_drag_controller_get_is_dragging (drag_controller)) {
		result = FALSE;
		_g_object_unref0 (drag_controller);
		return result;
	}
	if (self->priv->is_scrolling) {
		result = FALSE;
		_g_object_unref0 (drag_controller);
		return result;
	}
	menu = _g_object_ref0 (unity_launcher_quicklist_controller_get_current_menu ());
	if (UNITY_LAUNCHER_IS_QUICKLIST_CONTROLLER (menu)) {
		if (unity_launcher_quicklist_controller_get_state (menu) == UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_MENU) {
			UnityLauncherQuicklistController* _tmp0_;
			self->priv->attached_menu = (_tmp0_ = _g_object_ref0 (menu), _g_object_unref0 (self->priv->attached_menu), _tmp0_);
			g_signal_connect_object ((GObject*) self->priv->attached_menu, "notify::state", (GCallback) _unity_launcher_scroller_view_on_menu_close_g_object_notify, self, 0);
			result = FALSE;
			_g_object_unref0 (menu);
			_g_object_unref0 (drag_controller);
			return result;
		}
	}
	unity_launcher_scroller_view_do_queue_contract_launcher (self);
	if (CLUTTER_IS_ACTOR (self->priv->last_picked_actor)) {
		_tmp1_ = self->priv->last_picked_actor != CLUTTER_ACTOR (self);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ClutterActor* _tmp2_;
		clutter_actor_event (self->priv->last_picked_actor, event, FALSE);
		self->priv->last_picked_actor = (_tmp2_ = NULL, _g_object_unref0 (self->priv->last_picked_actor), _tmp2_);
	}
	result = FALSE;
	_g_object_unref0 (menu);
	_g_object_unref0 (drag_controller);
	return result;
}


static gboolean unity_launcher_scroller_view_on_autoscroll_motion_check (UnityLauncherScrollerView* self, float y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (unity_launcher_scroller_view_get_total_children_height (self) < unity_launcher_scroller_view_get_available_height (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->is_scrolling;
	}
	if (_tmp0_) {
		unity_launcher_scroller_view_set_is_autoscrolling (self, FALSE);
	} else {
		float pos_x = 0.0F;
		float pos_y = 0.0F;
		float transformed_y;
		gboolean _tmp1_ = FALSE;
		clutter_actor_get_transformed_position ((ClutterActor*) self, &pos_x, &pos_y);
		transformed_y = y - pos_y;
		self->priv->autoscroll_mouse_pos_cache = transformed_y;
		if (transformed_y > (clutter_actor_get_height ((ClutterActor*) self) / 2)) {
			self->priv->autoscroll_direction = -1;
			self->priv->autoscroll_mouse_pos_cache = self->priv->autoscroll_mouse_pos_cache - clutter_actor_get_height ((ClutterActor*) self);
		} else {
			self->priv->autoscroll_direction = 1;
		}
		if (transformed_y < 12) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = transformed_y > (clutter_actor_get_height ((ClutterActor*) self) - 12);
		}
		if (_tmp1_) {
			unity_launcher_scroller_view_set_is_autoscrolling (self, TRUE);
		} else {
			unity_launcher_scroller_view_set_is_autoscrolling (self, FALSE);
		}
	}
	result = FALSE;
	return result;
}


static void unity_launcher_scroller_view_on_drag_motion_event (UnityLauncherScrollerView* self, UnityDragModel* model, float x, float y) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	unity_launcher_scroller_view_on_autoscroll_motion_check (self, y);
}


static gboolean unity_launcher_scroller_view_on_motion_event (UnityLauncherScrollerView* self, ClutterEvent* event) {
	gboolean result = FALSE;
	UnityDragController* drag_controller;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	unity_launcher_scroller_view_on_autoscroll_motion_check (self, (*event).motion.y);
	drag_controller = _g_object_ref0 (unity_drag_controller_get_default ());
	if (unity_drag_controller_get_is_dragging (drag_controller)) {
		result = FALSE;
		_g_object_unref0 (drag_controller);
		return result;
	}
	self->priv->last_motion_event_time = (guint) (*event).motion.time;
	if (self->priv->button_down) {
		_tmp2_ = self->priv->is_scrolling == FALSE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = self->priv->view_type != UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_CONTRACTED;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->can_scroll;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->is_scrolling = TRUE;
		unity_launcher_disable_quicklists = TRUE;
		unity_shell_add_fullscreen_request (unity_global_shell, (GObject*) self);
		clutter_grab_pointer ((ClutterActor*) self);
		g_signal_connect_object (clutter_actor_get_stage ((ClutterActor*) self), "motion-event", (GCallback) _unity_launcher_scroller_view_on_motion_event_clutter_actor_motion_event, self, 0);
	}
	if (self->priv->is_scrolling) {
		float pixel_diff;
		guint time_diff;
		unity_launcher_scroller_view_passthrough_motion_event (self, event);
		pixel_diff = (*event).motion.y - self->priv->previous_y_position;
		time_diff = (guint) ((*event).motion.time - self->priv->previous_y_time);
		self->priv->scroll_speed = pixel_diff / (time_diff / 1000.0f);
		self->priv->previous_y_position = (*event).motion.y;
		self->priv->previous_y_time = (guint) (*event).motion.time;
		unity_launcher_scroller_view_move_scroll_position (self, pixel_diff, FALSE, 160.0f);
		result = TRUE;
		_g_object_unref0 (drag_controller);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (drag_controller);
	return result;
}


static gboolean unity_launcher_scroller_view_on_scroll_event (UnityLauncherScrollerView* self, ClutterEvent* event) {
	gboolean result = FALSE;
	float modifier;
	g_return_val_if_fail (self != NULL, FALSE);
	modifier = 0.0f;
	if ((*event).scroll.direction == CLUTTER_SCROLL_UP) {
		modifier = 1.0f;
	} else {
		if ((*event).scroll.direction == CLUTTER_SCROLL_DOWN) {
			modifier = -1.0f;
		}
	}
	if (modifier != 0.0f) {
		float speed;
		speed = ((48 + self->spacing) * 3) * 6.0f;
		self->priv->scroll_speed = self->priv->scroll_speed + (speed * modifier);
		self->priv->current_phase = UNITY_LAUNCHER_SCROLLER_PHASE_FLUNG;
		clutter_timeline_start (self->fling_timeline);
	}
	result = FALSE;
	return result;
}


static void unity_launcher_scroller_view_on_scroller_frame (UnityLauncherScrollerView* self, ClutterTimeline* timeline, gint msecs) {
	guint delta;
	ClutterEvent _tmp1_ = {0};
	ClutterEvent motion_event;
	ClutterActor* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeline != NULL);
	delta = clutter_timeline_get_delta (timeline);
	delta = delta + self->priv->stored_delta;
	if (delta <= 16) {
		self->priv->stored_delta = delta;
		return;
	}
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (!(delta > 16)) {
			break;
		}
		self->is_animating = TRUE;
		delta = delta - ((guint) 16);
		if (self->priv->fling_timeout_source != 0) {
			_tmp0_ = self->priv->current_phase != UNITY_LAUNCHER_SCROLLER_PHASE_NONE;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			g_source_remove (self->priv->fling_timeout_source);
		}
		switch (self->priv->current_phase) {
			case UNITY_LAUNCHER_SCROLLER_PHASE_SETTLING:
			{
				unity_launcher_scroller_view_do_anim_settle (self, timeline, msecs);
				break;
			}
			case UNITY_LAUNCHER_SCROLLER_PHASE_FLUNG:
			{
				unity_launcher_scroller_view_do_anim_fling (self, timeline, msecs);
				break;
			}
			case UNITY_LAUNCHER_SCROLLER_PHASE_BOUNCE:
			{
				unity_launcher_scroller_view_do_anim_bounce (self, timeline, msecs);
				break;
			}
			case UNITY_LAUNCHER_SCROLLER_PHASE_NONE:
			{
				{
					clutter_timeline_stop (timeline);
					self->priv->scroll_speed = 0.0f;
					self->is_animating = FALSE;
					self->priv->disable_child_events = FALSE;
				}
				break;
			}
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	if (self->priv->current_phase == UNITY_LAUNCHER_SCROLLER_PHASE_NONE) {
		ctk_effect_cache_update_texture_cache (self->priv->_cache);
	} else {
		ctk_effect_cache_invalidate_texture_cache (self->priv->_cache);
	}
	motion_event = (_tmp1_.type = 0, _tmp1_);
	motion_event.type = CLUTTER_MOTION;
	motion_event.motion.x = self->priv->last_known_x;
	motion_event.motion.y = self->priv->last_known_y;
	motion_event.motion.stage = (_tmp2_ = clutter_actor_get_stage ((ClutterActor*) self), CLUTTER_IS_STAGE (_tmp2_) ? ((ClutterStage*) _tmp2_) : NULL);
	motion_event.motion.flags = CLUTTER_EVENT_FLAG_SYNTHETIC;
	unity_launcher_scroller_view_passthrough_motion_event (self, &motion_event);
	self->priv->stored_delta = delta;
}


static void unity_launcher_scroller_view_do_anim_settle (UnityLauncherScrollerView* self, ClutterTimeline* timeline, gint msecs) {
	float distance;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeline != NULL);
	distance = self->priv->settle_position - self->priv->scroll_position;
	unity_launcher_scroller_view_move_scroll_position (self, distance * 0.2f, FALSE, 60.0f);
	if (fabs ((double) distance) < 1) {
		unity_launcher_scroller_view_move_scroll_position (self, distance, FALSE, 160.0f);
		self->priv->current_phase = UNITY_LAUNCHER_SCROLLER_PHASE_NONE;
	}
}


static gboolean _lambda85_ (UnityLauncherScrollerView* self) {
	gboolean result = FALSE;
	self->priv->current_phase = UNITY_LAUNCHER_SCROLLER_PHASE_SETTLING;
	self->priv->settle_position = unity_launcher_scroller_view_get_aligned_settle_position (self);
	clutter_timeline_start (self->fling_timeline);
	result = FALSE;
	return result;
}


static gboolean __lambda85__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda85_ (self);
	return result;
}


static void unity_launcher_scroller_view_do_anim_fling (UnityLauncherScrollerView* self, ClutterTimeline* timeline, gint msecs) {
	float scroll_move_amount;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeline != NULL);
	self->priv->scroll_speed = self->priv->scroll_speed * self->friction;
	scroll_move_amount = self->priv->scroll_speed / 60.0f;
	unity_launcher_scroller_view_move_scroll_position (self, scroll_move_amount, FALSE, 60.0f);
	if (fabsf (scroll_move_amount) < 1.0) {
		self->priv->current_phase = UNITY_LAUNCHER_SCROLLER_PHASE_NONE;
		self->priv->fling_timeout_source = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, __lambda85__gsource_func, g_object_ref (self), g_object_unref);
	}
}


static void unity_launcher_scroller_view_do_anim_bounce (UnityLauncherScrollerView* self, ClutterTimeline* timeline, gint msecs) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeline != NULL);
	self->priv->scroll_speed = self->priv->scroll_speed * 0.5f;
	unity_launcher_scroller_view_move_scroll_position (self, self->priv->scroll_speed / 60.0f, FALSE, 160.0f);
	self->priv->settle_position = -unity_launcher_scroller_view_get_aligned_settle_position (self);
	self->priv->current_phase = UNITY_LAUNCHER_SCROLLER_PHASE_SETTLING;
}


static float unity_launcher_scroller_view_get_aligned_settle_position (UnityLauncherScrollerView* self) {
	float result = 0.0F;
	float final_position;
	CtkPadding _tmp0_ = {0};
	CtkPadding _tmp1_ = {0};
	g_return_val_if_fail (self != NULL, 0.0F);
	final_position = self->priv->scroll_position;
	if (self->priv->total_child_height < ((clutter_actor_get_height ((ClutterActor*) self) - (ctk_actor_get_padding ((CtkActor*) self, &_tmp0_), _tmp0_.top)) - (ctk_actor_get_padding ((CtkActor*) self, &_tmp1_), _tmp1_.bottom))) {
		final_position = (float) 0;
	} else {
		if (self->priv->scroll_position > 0) {
			final_position = (float) 0;
		} else {
			if (unity_launcher_scroller_view_get_total_children_height (self) < unity_launcher_scroller_view_get_available_height (self)) {
				final_position = (float) 0;
			} else {
				CtkPadding _tmp2_ = {0};
				CtkPadding _tmp3_ = {0};
				if ((-self->priv->scroll_position) > (((self->priv->total_child_height - clutter_actor_get_height ((ClutterActor*) self)) - (ctk_actor_get_padding ((CtkActor*) self, &_tmp2_), _tmp2_.top)) - (ctk_actor_get_padding ((CtkActor*) self, &_tmp3_), _tmp3_.bottom))) {
					final_position = -(unity_launcher_scroller_view_get_total_children_height (self) - unity_launcher_scroller_view_get_available_height (self));
				}
			}
		}
	}
	result = final_position;
	return result;
}


static void unity_launcher_scroller_view_real_get_preferred_width (ClutterActor* base, float for_height, float* minimum_width, float* natural_width) {
	UnityLauncherScrollerView * self;
	float pmin_width;
	float pnat_width;
	CtkPadding _tmp0_ = {0};
	CtkPadding _tmp1_ = {0};
	CtkPadding _tmp2_ = {0};
	CtkPadding _tmp3_ = {0};
	self = (UnityLauncherScrollerView*) base;
	*minimum_width = (float) 0;
	*natural_width = (float) 0;
	pmin_width = 0.0f;
	pnat_width = 0.0f;
	{
		UnityLauncherScrollerModelIterator* _child_it;
		_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* child;
			float cmin_width;
			float cnat_width;
			if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
				break;
			}
			child = unity_launcher_scroller_model_iterator_get (_child_it);
			cmin_width = 0.0f;
			cnat_width = 0.0f;
			clutter_actor_get_preferred_width ((ClutterActor*) child, for_height, &cmin_width, &cnat_width);
			pmin_width = MAX (pmin_width, cmin_width);
			pnat_width = MAX (pnat_width, cnat_width);
			_g_object_unref0 (child);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_child_it);
	}
	pmin_width = pmin_width + ((ctk_actor_get_padding ((CtkActor*) self, &_tmp0_), _tmp0_.left) + (ctk_actor_get_padding ((CtkActor*) self, &_tmp1_), _tmp1_.right));
	pnat_width = pnat_width + ((ctk_actor_get_padding ((CtkActor*) self, &_tmp2_), _tmp2_.left) + (ctk_actor_get_padding ((CtkActor*) self, &_tmp3_), _tmp3_.right));
	*minimum_width = pmin_width;
	*natural_width = pnat_width;
}


static void unity_launcher_scroller_view_real_get_preferred_height (ClutterActor* base, float for_width, float* minimum_height, float* natural_height) {
	UnityLauncherScrollerView * self;
	float cnat_height;
	float cmin_height;
	CtkPadding _tmp0_ = {0};
	CtkPadding _tmp1_ = {0};
	CtkPadding _tmp2_ = {0};
	CtkPadding _tmp3_ = {0};
	self = (UnityLauncherScrollerView*) base;
	*minimum_height = 0.0f;
	*natural_height = 0.0f;
	cnat_height = 0.0f;
	cmin_height = 0.0f;
	self->priv->total_child_height = 0.0f;
	{
		UnityLauncherScrollerModelIterator* _child_it;
		_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* child;
			if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
				break;
			}
			child = unity_launcher_scroller_model_iterator_get (_child_it);
			cnat_height = 0.0f;
			cmin_height = 0.0f;
			clutter_actor_get_preferred_height ((ClutterActor*) child, for_width, &cmin_height, &cnat_height);
			self->priv->total_child_height = self->priv->total_child_height + (cnat_height + self->spacing);
			_g_object_unref0 (child);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_child_it);
	}
	*minimum_height = (self->priv->total_child_height + (ctk_actor_get_padding ((CtkActor*) self, &_tmp0_), _tmp0_.top)) + (ctk_actor_get_padding ((CtkActor*) self, &_tmp1_), _tmp1_.bottom);
	*natural_height = (self->priv->total_child_height + (ctk_actor_get_padding ((CtkActor*) self, &_tmp2_), _tmp2_.top)) + (ctk_actor_get_padding ((CtkActor*) self, &_tmp3_), _tmp3_.bottom);
	return;
}


static void unity_launcher_scroller_view_order_children (UnityLauncherScrollerView* self, gboolean immediate) {
	g_return_if_fail (self != NULL);
	if (unity_launcher_scroller_view_get_total_children_height (self) < unity_launcher_scroller_view_get_available_height (self)) {
		unity_launcher_scroller_view_order_children_expanded (self, immediate);
	} else {
		switch (self->priv->view_type) {
			case UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_CONTRACTED:
			{
				unity_launcher_scroller_view_order_children_contracted (self, immediate);
				break;
			}
			case UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_EXPANDED:
			{
				unity_launcher_scroller_view_order_children_expanded (self, immediate);
				break;
			}
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	clutter_actor_queue_relayout ((ClutterActor*) self);
}


static void unity_launcher_scroller_view_change_child_position_rotation (UnityLauncherScrollerView* self, UnityLauncherScrollerChild* child, float position, float rotation, gboolean immediate) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	if (immediate) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = unity_shell_get_is_starting (unity_global_shell);
	}
	if (_tmp0_) {
		unity_launcher_scroller_child_set_position (child, position);
		unity_launcher_scroller_child_force_rotation_jump (child, rotation);
	} else {
		gboolean do_new_position;
		do_new_position = TRUE;
		if (CLUTTER_IS_ANIMATION (clutter_actor_get_animation ((ClutterActor*) child))) {
			GValue value = {0};
			ClutterInterval* interval;
			g_value_init (&value, G_TYPE_FLOAT);
			interval = _g_object_ref0 (clutter_animation_get_interval (clutter_actor_get_animation ((ClutterActor*) child), "position"));
			if (CLUTTER_IS_INTERVAL (interval)) {
				clutter_interval_get_final_value (interval, &value);
			}
			if (g_value_get_float (&value) != position) {
				float current_pos;
				current_pos = unity_launcher_scroller_child_get_position (child);
				clutter_animation_completed (clutter_actor_get_animation ((ClutterActor*) child));
				unity_launcher_scroller_child_set_position (child, current_pos);
			} else {
				do_new_position = FALSE;
			}
			_g_object_unref0 (interval);
			G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
		}
		unity_launcher_scroller_child_set_rotation (child, rotation);
		if (do_new_position) {
			if (self->priv->view_type == UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_CONTRACTED) {
				clutter_actor_animate ((ClutterActor*) child, (gulong) CLUTTER_EASE_IN_OUT_QUAD, (guint) 300, "position", position, NULL);
			} else {
				clutter_actor_animate ((ClutterActor*) child, (gulong) CLUTTER_EASE_OUT_QUINT, (guint) 300, "position", position, NULL);
			}
		}
	}
}


static void unity_launcher_scroller_view_order_children_expanded (UnityLauncherScrollerView* self, gboolean immediate) {
	float h;
	float min_height = 0.0F;
	float nat_height = 0.0F;
	gint index;
	g_return_if_fail (self != NULL);
	h = 0.0f;
	if (!GEE_IS_ARRAY_LIST (self->priv->draw_ftb)) {
		GeeArrayList* _tmp0_;
		self->priv->draw_ftb = (_tmp0_ = gee_array_list_new (UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->draw_ftb), _tmp0_);
	}
	if (!GEE_IS_ARRAY_LIST (self->priv->draw_ftb)) {
		GeeArrayList* _tmp1_;
		self->priv->draw_btf = (_tmp1_ = gee_array_list_new (UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->draw_btf), _tmp1_);
	}
	index = 0;
	{
		UnityLauncherScrollerModelIterator* _child_it;
		_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* child;
			gboolean _tmp2_ = FALSE;
			if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
				break;
			}
			child = unity_launcher_scroller_model_iterator_get (_child_it);
			if (index == self->priv->_drag_indicator_index) {
				_tmp2_ = self->priv->_drag_indicator_active;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				if (self->priv->_drag_indicator_space) {
					clutter_actor_get_preferred_height ((ClutterActor*) child, clutter_actor_get_width ((ClutterActor*) self), &min_height, &nat_height);
					h = h + (nat_height + self->spacing);
				} else {
					h = h + ((float) (2 + self->spacing));
				}
			} else {
				clutter_actor_get_preferred_height ((ClutterActor*) child, clutter_actor_get_width ((ClutterActor*) self), &min_height, &nat_height);
				unity_launcher_scroller_view_change_child_position_rotation (self, child, h + self->priv->scroll_position, 0.0f, immediate);
				h = h + (nat_height + self->spacing);
			}
			index = index + 1;
			_g_object_unref0 (child);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_child_it);
	}
}


static void unity_launcher_scroller_view_order_children_contracted (UnityLauncherScrollerView* self, gboolean immediate) {
	float h;
	float min_height = 0.0F;
	float nat_height = 0.0F;
	gint num_launchers;
	float total_child_height;
	gint actual_model_size;
	gint num_children_handled;
	gint index_start_flat = 0;
	gint index_end_flat;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	g_return_if_fail (self != NULL);
	h = 0.0f;
	num_launchers = 0;
	total_child_height = unity_launcher_scroller_view_get_total_children_height (self);
	actual_model_size = unity_launcher_scroller_model_get_size (self->priv->_model);
	{
		UnityLauncherScrollerModelIterator* _child_it;
		_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* child;
			if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
				break;
			}
			child = unity_launcher_scroller_model_iterator_get (_child_it);
			if (child->do_not_render) {
				actual_model_size = actual_model_size - 1;
			}
			_g_object_unref0 (child);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_child_it);
	}
	if (total_child_height > unity_launcher_scroller_view_get_available_height (self)) {
		num_launchers = (gint) floorf ((unity_launcher_scroller_view_get_available_height (self) - (self->spacing * 2)) / (48.0f + self->spacing));
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				float flat_space;
				float contracted_space;
				if (!_tmp0_) {
					num_launchers--;
				}
				_tmp0_ = FALSE;
				if (!(num_launchers >= 1)) {
					break;
				}
				flat_space = num_launchers * (48.0f + self->spacing);
				contracted_space = 0.0f;
				contracted_space = (float) ((actual_model_size - num_launchers) * (8 + self->spacing));
				if (((flat_space + self->spacing) + contracted_space) < (unity_launcher_scroller_view_get_available_height (self) - (self->spacing * 2))) {
					break;
				}
			}
		}
		num_launchers = MAX (num_launchers, 1);
	} else {
		num_launchers = actual_model_size;
	}
	num_children_handled = 0;
	index_end_flat = 0;
	if (self->priv->focused_launcher < (actual_model_size - (num_launchers - (num_launchers / 2)))) {
		index_start_flat = MAX (0, self->priv->focused_launcher - (num_launchers / 2));
		index_end_flat = index_start_flat + num_launchers;
	} else {
		index_end_flat = actual_model_size;
		index_start_flat = index_end_flat - num_launchers;
	}
	self->priv->draw_ftb = (_tmp1_ = gee_array_list_new (UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->draw_ftb), _tmp1_);
	self->priv->draw_btf = (_tmp2_ = gee_array_list_new (UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->draw_btf), _tmp2_);
	{
		gint index;
		index = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				UnityLauncherScrollerChild* child;
				gboolean _tmp4_ = FALSE;
				if (!_tmp3_) {
					index++;
				}
				_tmp3_ = FALSE;
				if (!(index < unity_launcher_scroller_model_get_size (self->priv->_model))) {
					break;
				}
				child = unity_launcher_scroller_model_get (self->priv->_model, index);
				clutter_actor_get_preferred_height ((ClutterActor*) child, clutter_actor_get_width ((ClutterActor*) self), &min_height, &nat_height);
				if (index >= index_start_flat) {
					_tmp4_ = index < index_end_flat;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					unity_launcher_scroller_view_change_child_position_rotation (self, child, h, 0.0f, immediate);
					h = h + ((float) (48 + self->spacing));
					num_children_handled++;
					if (index == index_start_flat) {
						gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->draw_ftb, child);
					} else {
						gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->draw_btf, child);
					}
				} else {
					float rotation;
					float position;
					if (index == index_end_flat) {
						h = h - ((nat_height * 0.3333f) - self->spacing);
					}
					rotation = 0.0f;
					position = 0.0f;
					if (num_children_handled < index_start_flat) {
						if (num_children_handled == (index_start_flat - 1)) {
							rotation = -self->priv->contract_icon_partial_degrees;
							h = h + ((float) self->spacing);
						} else {
							rotation = -self->priv->contract_icon_degrees;
						}
						position = h;
						gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->draw_ftb, child);
					} else {
						position = h;
						if (index == index_end_flat) {
							rotation = self->priv->contract_icon_partial_degrees;
							h = h + ((float) self->spacing);
						} else {
							rotation = self->priv->contract_icon_degrees;
						}
						gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->draw_btf, child);
					}
					unity_launcher_scroller_view_change_child_position_rotation (self, child, position, rotation, immediate);
					h = h + ((float) (8 + self->spacing));
					num_children_handled++;
					if ((index + 1) == index_start_flat) {
						h = h + ((float) 30);
					}
				}
				_g_object_unref0 (child);
			}
		}
	}
}


static float unity_launcher_scroller_view_get_total_children_height (UnityLauncherScrollerView* self) {
	float result = 0.0F;
	float h;
	float min_height = 0.0F;
	float nat_height = 0.0F;
	g_return_val_if_fail (self != NULL, 0.0F);
	h = 0.0f;
	{
		UnityLauncherScrollerModelIterator* _child_it;
		_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* child;
			if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
				break;
			}
			child = unity_launcher_scroller_model_iterator_get (_child_it);
			if (child->do_not_render) {
				_g_object_unref0 (child);
				continue;
			}
			clutter_actor_get_preferred_height ((ClutterActor*) child, clutter_actor_get_width ((ClutterActor*) self), &min_height, &nat_height);
			h = h + (nat_height + self->spacing);
			_g_object_unref0 (child);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_child_it);
	}
	result = h;
	return result;
}


static float unity_launcher_scroller_view_get_available_height (UnityLauncherScrollerView* self) {
	float result = 0.0F;
	ClutterActorBox box = {0};
	CtkPadding _tmp0_ = {0};
	CtkPadding _tmp1_ = {0};
	g_return_val_if_fail (self != NULL, 0.0F);
	ctk_actor_get_stored_allocation ((CtkActor*) self, &box);
	result = (clutter_actor_box_get_height (&box) - (ctk_actor_get_padding ((CtkActor*) self, &_tmp0_), _tmp0_.top)) - (ctk_actor_get_padding ((CtkActor*) self, &_tmp1_), _tmp1_.bottom);
	return result;
}


static void unity_launcher_scroller_view_real_allocate (ClutterActor* base, const ClutterActorBox* box, ClutterAllocationFlags flags) {
	UnityLauncherScrollerView * self;
	ClutterActorBox child_box = {0};
	ClutterActorBox temp_child_box = {0};
	CtkPadding _tmp0_ = {0};
	float current_width;
	CtkPadding _tmp1_ = {0};
	float available_height;
	CtkPadding _tmp2_ = {0};
	float available_width;
	gint index;
	gint bg_height = 0;
	gint bg_width = 0;
	float bg_offset;
	self = (UnityLauncherScrollerView*) base;
	CLUTTER_ACTOR_CLASS (unity_launcher_scroller_view_parent_class)->allocate ((ClutterActor*) CTK_ACTOR (self), box, flags);
	memset (&child_box, 0, sizeof (ClutterActorBox));
	memset (&temp_child_box, 0, sizeof (ClutterActorBox));
	current_width = (ctk_actor_get_padding ((CtkActor*) self, &_tmp0_), _tmp0_.left);
	available_height = clutter_actor_box_get_height (box) - (ctk_actor_get_padding ((CtkActor*) self, &_tmp1_), _tmp1_.bottom);
	available_width = clutter_actor_box_get_width (box) - (ctk_actor_get_padding ((CtkActor*) self, &_tmp2_), _tmp2_.right);
	self->priv->total_child_height = 0.0f;
	index = 0;
	if (self->priv->_drag_indicator_active) {
		UnityLauncherScrollerChild* _tmp3_;
		CtkPadding _tmp4_ = {0};
		self->priv->drag_indicator_position = unity_launcher_scroller_child_get_position (_tmp3_ = unity_launcher_scroller_model_get (self->priv->_model, self->priv->_drag_indicator_index)) + (ctk_actor_get_padding ((CtkActor*) self, &_tmp4_), _tmp4_.top);
		_g_object_unref0 (_tmp3_);
	}
	{
		UnityLauncherScrollerModelIterator* _child_it;
		_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* child;
			float child_height = 0.0F;
			float child_width = 0.0F;
			float natural = 0.0F;
			float min = 0.0F;
			CtkPadding _tmp5_ = {0};
			gboolean _tmp6_ = FALSE;
			if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
				break;
			}
			child = unity_launcher_scroller_model_iterator_get (_child_it);
			clutter_actor_get_preferred_width ((ClutterActor*) child, available_height, &min, &natural);
			child_width = fmaxf (min, fminf (natural, available_width));
			clutter_actor_get_preferred_height ((ClutterActor*) child, child_width, &min, &natural);
			child_height = fmaxf (min, fminf (natural, available_height));
			child_box.x1 = current_width;
			child_box.x2 = child_box.x1 + child_width;
			child_box.y1 = unity_launcher_scroller_child_get_position (child) + (ctk_actor_get_padding ((CtkActor*) self, &_tmp5_), _tmp5_.top);
			child_box.y2 = child_box.y1 + child_height;
			if (!child->do_not_render) {
				;
			}
			clutter_actor_allocate ((ClutterActor*) child, &child_box, flags);
			self->priv->total_child_height = self->priv->total_child_height + (child_height + self->spacing);
			if (index >= 0) {
				_tmp6_ = index <= 9;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				ClutterCairoTexture* keyboard_indicator;
				ClutterCairoTexture* _tmp7_;
				keyboard_indicator = NULL;
				keyboard_indicator = (_tmp7_ = (ClutterCairoTexture*) gee_abstract_list_get ((GeeAbstractList*) self->priv->keyboard_indicators, (gint) index), _g_object_unref0 (keyboard_indicator), _tmp7_);
				if (CLUTTER_IS_ACTOR (keyboard_indicator)) {
					guint surface_width = 0U;
					guint surface_height = 0U;
					CtkPadding _tmp8_ = {0};
					CtkPadding _tmp9_ = {0};
					clutter_cairo_texture_get_surface_size (keyboard_indicator, &surface_width, &surface_height);
					child_box.x1 = ((clutter_actor_box_get_width (box) - (ctk_actor_get_padding ((CtkActor*) self, &_tmp8_), _tmp8_.right)) - surface_width) - 6;
					child_box.x2 = child_box.x1 + clutter_actor_get_width ((ClutterActor*) keyboard_indicator);
					child_box.y1 = (unity_launcher_scroller_child_get_position (child) + (ctk_actor_get_padding ((CtkActor*) self, &_tmp9_), _tmp9_.top)) + ((clutter_actor_box_get_height (&child_box) * 0.5f) - (surface_height * 0.5f));
					child_box.y2 = child_box.y1 + clutter_actor_get_height ((ClutterActor*) keyboard_indicator);
					clutter_actor_allocate ((ClutterActor*) keyboard_indicator, &child_box, flags);
				}
				index = index + 1;
				_g_object_unref0 (keyboard_indicator);
			}
			_g_object_unref0 (child);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_child_it);
	}
	child_box.x1 = (float) 0;
	child_box.x2 = clutter_actor_box_get_width (box);
	clutter_texture_get_base_size ((ClutterTexture*) self->priv->bgtex, &bg_width, &bg_height);
	bg_offset = fmodf (self->priv->scroll_position + 1000000, (float) bg_height);
	child_box.y1 = bg_offset - (bg_height - 1);
	child_box.y2 = (bg_offset + (bg_height - 1)) + clutter_actor_box_get_height (box);
	clutter_actor_allocate ((ClutterActor*) self->priv->bgtex, &child_box, flags);
	clutter_texture_get_base_size ((ClutterTexture*) self->priv->top_shadow, &bg_width, &bg_height);
	child_box.y1 = (float) (-1);
	child_box.y2 = (float) (bg_height - 1);
	clutter_actor_allocate ((ClutterActor*) self->priv->top_shadow, &child_box, flags);
}


static void unity_launcher_scroller_view_real_pick (ClutterActor* base, const ClutterColor* color) {
	UnityLauncherScrollerView * self;
	self = (UnityLauncherScrollerView*) base;
	CLUTTER_ACTOR_CLASS (unity_launcher_scroller_view_parent_class)->pick ((ClutterActor*) CTK_ACTOR (self), color);
	{
		UnityLauncherScrollerModelIterator* _child_it;
		_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* child;
			gboolean _tmp0_ = FALSE;
			gboolean _tmp1_ = FALSE;
			if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
				break;
			}
			child = unity_launcher_scroller_model_iterator_get (_child_it);
			if (UNITY_LAUNCHER_IS_SCROLLER_CHILD (child)) {
				_tmp1_ = clutter_actor_get_opacity ((ClutterActor*) child) > 0;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				_tmp0_ = !child->do_not_render;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				UnityLauncherScrollerChild* _tmp2_;
				clutter_actor_paint ((ClutterActor*) (_tmp2_ = child, UNITY_LAUNCHER_IS_SCROLLER_CHILD (_tmp2_) ? ((UnityLauncherScrollerChild*) _tmp2_) : NULL));
			}
			_g_object_unref0 (child);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_child_it);
	}
	{
		GeeIterator* _child_it;
		_child_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->child_refs);
		while (TRUE) {
			UnityLauncherScrollerChild* child;
			if (!gee_iterator_next (_child_it)) {
				break;
			}
			child = (UnityLauncherScrollerChild*) gee_iterator_get (_child_it);
			if (child->do_not_render) {
				_g_object_unref0 (child);
				continue;
			}
			clutter_actor_paint ((ClutterActor*) child);
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
}


static void unity_launcher_scroller_view_real_paint (ClutterActor* base) {
	UnityLauncherScrollerView * self;
	self = (UnityLauncherScrollerView*) base;
	clutter_actor_paint ((ClutterActor*) self->priv->bgtex);
	if (self->priv->_drag_indicator_active) {
		cogl_set_source_color4f (1.0f, 1.0f, 1.0f, self->priv->_drag_indicator_opacity);
		cogl_rectangle ((float) 0, self->priv->drag_indicator_position, clutter_actor_get_width ((ClutterActor*) self), self->priv->drag_indicator_position + 2);
	}
	{
		gint index;
		index = gee_collection_get_size ((GeeCollection*) self->priv->draw_btf) - 1;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				UnityLauncherScrollerChild* child;
				gboolean _tmp1_ = FALSE;
				gboolean _tmp2_ = FALSE;
				if (!_tmp0_) {
					index--;
				}
				_tmp0_ = FALSE;
				if (!(index >= 0)) {
					break;
				}
				child = (UnityLauncherScrollerChild*) gee_abstract_list_get ((GeeAbstractList*) self->priv->draw_btf, index);
				if (UNITY_LAUNCHER_IS_SCROLLER_CHILD (child)) {
					_tmp2_ = clutter_actor_get_opacity ((ClutterActor*) child) > 0;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					_tmp1_ = !child->do_not_render;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					UnityLauncherScrollerChild* _tmp3_;
					clutter_actor_paint ((ClutterActor*) (_tmp3_ = child, UNITY_LAUNCHER_IS_SCROLLER_CHILD (_tmp3_) ? ((UnityLauncherScrollerChild*) _tmp3_) : NULL));
				}
				_g_object_unref0 (child);
			}
		}
	}
	{
		GeeIterator* _child_it;
		_child_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->draw_ftb);
		while (TRUE) {
			UnityLauncherScrollerChild* child;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			if (!gee_iterator_next (_child_it)) {
				break;
			}
			child = (UnityLauncherScrollerChild*) gee_iterator_get (_child_it);
			if (UNITY_LAUNCHER_IS_SCROLLER_CHILD (child)) {
				_tmp5_ = clutter_actor_get_opacity ((ClutterActor*) child) > 0;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				_tmp4_ = !child->do_not_render;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				UnityLauncherScrollerChild* _tmp6_;
				clutter_actor_paint ((ClutterActor*) (_tmp6_ = child, UNITY_LAUNCHER_IS_SCROLLER_CHILD (_tmp6_) ? ((UnityLauncherScrollerChild*) _tmp6_) : NULL));
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	{
		UnityLauncherScrollerModelIterator* _child_it;
		_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* child;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
				break;
			}
			child = unity_launcher_scroller_model_iterator_get (_child_it);
			if (gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->draw_ftb, child)) {
				_tmp7_ = TRUE;
			} else {
				_tmp7_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->draw_btf, child);
			}
			if (_tmp7_) {
				_g_object_unref0 (child);
				continue;
			}
			if (UNITY_LAUNCHER_IS_SCROLLER_CHILD (child)) {
				_tmp8_ = clutter_actor_get_opacity ((ClutterActor*) child) > 0;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				UnityLauncherScrollerChild* _tmp9_;
				clutter_actor_paint ((ClutterActor*) (_tmp9_ = child, UNITY_LAUNCHER_IS_SCROLLER_CHILD (_tmp9_) ? ((UnityLauncherScrollerChild*) _tmp9_) : NULL));
			}
			_g_object_unref0 (child);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_child_it);
	}
	{
		GeeIterator* _child_it;
		_child_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->child_refs);
		while (TRUE) {
			UnityLauncherScrollerChild* child;
			if (!gee_iterator_next (_child_it)) {
				break;
			}
			child = (UnityLauncherScrollerChild*) gee_iterator_get (_child_it);
			if (child->do_not_render) {
				_g_object_unref0 (child);
				continue;
			}
			clutter_actor_paint ((ClutterActor*) child);
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	{
		GeeIterator* _kb_ind_it;
		_kb_ind_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->keyboard_indicators);
		while (TRUE) {
			ClutterCairoTexture* kb_ind;
			if (!gee_iterator_next (_kb_ind_it)) {
				break;
			}
			kb_ind = (ClutterCairoTexture*) gee_iterator_get (_kb_ind_it);
			clutter_actor_paint ((ClutterActor*) kb_ind);
			_g_object_unref0 (kb_ind);
		}
		_g_object_unref0 (_kb_ind_it);
	}
	clutter_actor_paint ((ClutterActor*) self->priv->top_shadow);
}


static void unity_launcher_scroller_view_real_map (ClutterActor* base) {
	UnityLauncherScrollerView * self;
	self = (UnityLauncherScrollerView*) base;
	CLUTTER_ACTOR_CLASS (unity_launcher_scroller_view_parent_class)->map ((ClutterActor*) CTK_ACTOR (self));
	clutter_actor_map ((ClutterActor*) self->priv->bgtex);
	clutter_actor_map ((ClutterActor*) self->priv->top_shadow);
	{
		GeeIterator* _kb_ind_it;
		_kb_ind_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->keyboard_indicators);
		while (TRUE) {
			ClutterCairoTexture* kb_ind;
			if (!gee_iterator_next (_kb_ind_it)) {
				break;
			}
			kb_ind = (ClutterCairoTexture*) gee_iterator_get (_kb_ind_it);
			clutter_actor_map ((ClutterActor*) kb_ind);
			_g_object_unref0 (kb_ind);
		}
		_g_object_unref0 (_kb_ind_it);
	}
	{
		UnityLauncherScrollerModelIterator* _child_it;
		_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* child;
			if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
				break;
			}
			child = unity_launcher_scroller_model_iterator_get (_child_it);
			clutter_actor_map ((ClutterActor*) child);
			_g_object_unref0 (child);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_child_it);
	}
}


static void unity_launcher_scroller_view_real_unmap (ClutterActor* base) {
	UnityLauncherScrollerView * self;
	self = (UnityLauncherScrollerView*) base;
	CLUTTER_ACTOR_CLASS (unity_launcher_scroller_view_parent_class)->unmap ((ClutterActor*) CTK_ACTOR (self));
	clutter_actor_map ((ClutterActor*) self->priv->bgtex);
	clutter_actor_map ((ClutterActor*) self->priv->top_shadow);
	{
		GeeIterator* _kb_ind_it;
		_kb_ind_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->keyboard_indicators);
		while (TRUE) {
			ClutterCairoTexture* kb_ind;
			if (!gee_iterator_next (_kb_ind_it)) {
				break;
			}
			kb_ind = (ClutterCairoTexture*) gee_iterator_get (_kb_ind_it);
			clutter_actor_paint ((ClutterActor*) kb_ind);
			_g_object_unref0 (kb_ind);
		}
		_g_object_unref0 (_kb_ind_it);
	}
	{
		UnityLauncherScrollerModelIterator* _child_it;
		_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* child;
			if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
				break;
			}
			child = unity_launcher_scroller_model_iterator_get (_child_it);
			clutter_actor_unmap ((ClutterActor*) child);
			_g_object_unref0 (child);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_child_it);
	}
}


UnityLauncherScrollerModel* unity_launcher_scroller_view_get_model (UnityLauncherScrollerView* self) {
	UnityLauncherScrollerModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_model;
	return result;
}


static void unity_launcher_scroller_view_set_model (UnityLauncherScrollerView* self, UnityLauncherScrollerModel* value) {
	UnityLauncherScrollerModel* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_model = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_model), _tmp0_);
	g_object_notify ((GObject *) self, "model");
}


CtkEffectCache* unity_launcher_scroller_view_get_cache (UnityLauncherScrollerView* self) {
	CtkEffectCache* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_cache;
	return result;
}


static void unity_launcher_scroller_view_set_cache (UnityLauncherScrollerView* self, CtkEffectCache* value) {
	CtkEffectCache* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_cache = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_cache), _tmp0_);
	g_object_notify ((GObject *) self, "cache");
}


gboolean unity_launcher_scroller_view_get_drag_indicator_active (UnityLauncherScrollerView* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_drag_indicator_active;
	return result;
}


void unity_launcher_scroller_view_set_drag_indicator_active (UnityLauncherScrollerView* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_drag_indicator_active = value;
	g_object_notify ((GObject *) self, "drag-indicator-active");
}


gboolean unity_launcher_scroller_view_get_drag_indicator_space (UnityLauncherScrollerView* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_drag_indicator_space;
	return result;
}


void unity_launcher_scroller_view_set_drag_indicator_space (UnityLauncherScrollerView* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_drag_indicator_space = value;
	g_object_notify ((GObject *) self, "drag-indicator-space");
}


gint unity_launcher_scroller_view_get_drag_indicator_index (UnityLauncherScrollerView* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_drag_indicator_index;
	return result;
}


void unity_launcher_scroller_view_set_drag_indicator_index (UnityLauncherScrollerView* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_drag_indicator_index = value;
	g_object_notify ((GObject *) self, "drag-indicator-index");
}


float unity_launcher_scroller_view_get_drag_indicator_opacity (UnityLauncherScrollerView* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_drag_indicator_opacity;
	return result;
}


void unity_launcher_scroller_view_set_drag_indicator_opacity (UnityLauncherScrollerView* self, float value) {
	g_return_if_fail (self != NULL);
	self->priv->_drag_indicator_opacity = value;
	g_object_notify ((GObject *) self, "drag-indicator-opacity");
}


gboolean unity_launcher_scroller_view_get_is_autoscrolling (UnityLauncherScrollerView* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_autoscrolling;
	return result;
}


void unity_launcher_scroller_view_set_is_autoscrolling (UnityLauncherScrollerView* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_autoscrolling = value;
	g_object_notify ((GObject *) self, "is-autoscrolling");
}


static void _unity_launcher_scroller_view_on_drag_indicator_active_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_scroller_view_on_drag_indicator_active_change (self);
}


static void _unity_launcher_scroller_view_on_drag_indicator_index_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_scroller_view_on_drag_indicator_index_change (self);
}


static void _unity_launcher_scroller_view_on_drag_indicator_space_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_scroller_view_on_drag_indicator_space_change (self);
}


static void _unity_launcher_scroller_view_model_child_added_unity_launcher_scroller_model_child_added (UnityLauncherScrollerModel* _sender, UnityLauncherScrollerChild* child, gpointer self) {
	unity_launcher_scroller_view_model_child_added (self, child);
}


static void _unity_launcher_scroller_view_model_child_removed_unity_launcher_scroller_model_child_removed (UnityLauncherScrollerModel* _sender, UnityLauncherScrollerChild* child, gpointer self) {
	unity_launcher_scroller_view_model_child_removed (self, child);
}


static void _unity_launcher_scroller_view_model_order_changed_unity_launcher_scroller_model_order_changed (UnityLauncherScrollerModel* _sender, gpointer self) {
	unity_launcher_scroller_view_model_order_changed (self);
}


static gboolean _unity_launcher_scroller_view_on_button_press_event_clutter_actor_button_press_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_launcher_scroller_view_on_button_press_event (self, event);
	return result;
}


static gboolean _unity_launcher_scroller_view_on_scroll_event_clutter_actor_scroll_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_launcher_scroller_view_on_scroll_event (self, event);
	return result;
}


static void _unity_launcher_scroller_view_on_auto_scrolling_state_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_scroller_view_on_auto_scrolling_state_change (self);
}


static void _unity_launcher_scroller_view_on_drag_motion_event_unity_drag_controller_drag_motion (UnityDragController* _sender, UnityDragModel* model, float x, float y, gpointer self) {
	unity_launcher_scroller_view_on_drag_motion_event (self, model, x, y);
}


static void _unity_launcher_scroller_view_on_scroller_frame_clutter_timeline_new_frame (ClutterTimeline* _sender, gint msecs, gpointer self) {
	unity_launcher_scroller_view_on_scroller_frame (self, _sender, msecs);
}


static void _lambda86_ (UnityLauncherScrollerView* self) {
	ctk_effect_cache_invalidate_texture_cache (self->priv->_cache);
}


static void __lambda86__clutter_timeline_started (ClutterTimeline* _sender, gpointer self) {
	_lambda86_ (self);
}


static gboolean _lambda88_ (UnityLauncherScrollerView* self) {
	gboolean result = FALSE;
	ctk_effect_cache_update_texture_cache (self->priv->_cache);
	result = FALSE;
	return result;
}


static gboolean __lambda88__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda88_ (self);
	return result;
}


static void _lambda87_ (UnityLauncherScrollerView* self) {
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 0, __lambda88__gsource_func, g_object_ref (self), g_object_unref);
}


static void __lambda87__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
	_lambda87_ (self);
}


static void _unity_launcher_scroller_view_on_autoscroll_frame_clutter_timeline_new_frame (ClutterTimeline* _sender, gint msecs, gpointer self) {
	unity_launcher_scroller_view_on_autoscroll_frame (self, _sender, msecs);
}


static void _lambda89_ (UnityLauncherScrollerView* self) {
	ctk_effect_cache_invalidate_texture_cache (self->priv->_cache);
}


static void __lambda89__clutter_timeline_started (ClutterTimeline* _sender, gpointer self) {
	_lambda89_ (self);
}


static gboolean _lambda91_ (UnityLauncherScrollerView* self) {
	gboolean result = FALSE;
	ctk_effect_cache_update_texture_cache (self->priv->_cache);
	result = FALSE;
	return result;
}


static gboolean __lambda91__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda91_ (self);
	return result;
}


static void _lambda90_ (UnityLauncherScrollerView* self) {
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 0, __lambda91__gsource_func, g_object_ref (self), g_object_unref);
}


static void __lambda90__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
	_lambda90_ (self);
}


static void _lambda92_ (UnityLauncherScrollerView* self) {
	guint _tmp0_;
	unity_shell_remove_fullscreen_request (unity_global_shell, (GObject*) self);
	self->priv->is_scrolling = FALSE;
	self->priv->button_down = FALSE;
	unity_launcher_disable_quicklists = TRUE;
	clutter_ungrab_pointer ();
	g_signal_parse_name ("motion-event", CLUTTER_TYPE_ACTOR, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (clutter_actor_get_stage ((ClutterActor*) self), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _unity_launcher_scroller_view_on_motion_event_clutter_actor_motion_event, self);
	self->priv->current_phase = UNITY_LAUNCHER_SCROLLER_PHASE_FLUNG;
	clutter_timeline_start (self->fling_timeline);
	clutter_actor_animate ((ClutterActor*) self, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 150, "drag-indicator-opacity", 1.0f, NULL);
}


static void __lambda92__unity_drag_controller_drag_start (UnityDragController* _sender, UnityDragModel* model, gpointer self) {
	_lambda92_ (self);
}


static gboolean _lambda94_ (UnityLauncherScrollerView* self) {
	gboolean result = FALSE;
	unity_launcher_scroller_view_order_children (self, FALSE);
}


static gboolean __lambda94__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda94_ (self);
	return result;
}


static void _lambda93_ (UnityDragModel* drag_model, float x, float y, UnityLauncherScrollerView* self) {
	g_return_if_fail (drag_model != NULL);
	unity_launcher_disable_quicklists = FALSE;
	{
		UnityLauncherScrollerModelIterator* _child_it;
		_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			ClutterActor* child;
			if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
				break;
			}
			child = (ClutterActor*) unity_launcher_scroller_model_iterator_get (_child_it);
			clutter_actor_set_reactive (child, FALSE);
			_g_object_unref0 (child);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_child_it);
	}
	if (x > clutter_actor_get_width ((ClutterActor*) self)) {
		unity_launcher_scroller_view_contract_launcher (self);
	} else {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda94__gsource_func, g_object_ref (self), g_object_unref);
	}
	clutter_actor_animate ((ClutterActor*) self, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 150, "drag-indicator-opacity", 0.0f, NULL);
}


static void __lambda93__unity_drag_controller_drag_drop (UnityDragController* _sender, UnityDragModel* model, float x, float y, gpointer self) {
	_lambda93_ (model, x, y, self);
}


static void _lambda95_ (UnityDragModel* model, float x, float y, UnityLauncherScrollerView* self) {
	g_return_if_fail (model != NULL);
	self->priv->last_known_pointer_x = x;
	if (x > (200 + clutter_actor_get_width ((ClutterActor*) self))) {
		unity_launcher_scroller_view_contract_launcher (self);
	} else {
		unity_launcher_scroller_view_expand_launcher (self, y);
	}
}


static void __lambda95__unity_drag_controller_drag_motion (UnityDragController* _sender, UnityDragModel* model, float x, float y, gpointer self) {
	_lambda95_ (model, x, y, self);
}


static gboolean _lambda96_ (UnityLauncherScrollerView* self) {
	gboolean result = FALSE;
	unity_launcher_scroller_view_order_children (self, TRUE);
	clutter_actor_queue_relayout ((ClutterActor*) self);
}


static gboolean __lambda96__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda96_ (self);
	return result;
}


static GObject * unity_launcher_scroller_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityLauncherScrollerView * self;
	parent_class = G_OBJECT_CLASS (unity_launcher_scroller_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_LAUNCHER_SCROLLER_VIEW (obj);
	{
		UnityTestingObjectRegistry* _tmp0_;
		CtkPadding _tmp1_ = {0};
		CtkPadding mypadding;
		GeeArrayList* _tmp2_;
		ClutterColor _tmp3_ = {0};
		ClutterColor color;
		ClutterTimeline* _tmp4_;
		ClutterTimeline* _tmp5_;
		UnityDragController* drag_controller;
		GeeArrayList* _tmp6_;
		g_signal_connect_object ((ClutterActor*) self, "motion-event", (GCallback) _unity_launcher_scroller_view_passthrough_motion_event_clutter_actor_motion_event, self, 0);
		g_signal_connect_object ((ClutterActor*) self, "button-press-event", (GCallback) _unity_launcher_scroller_view_passthrough_button_press_event_clutter_actor_button_press_event, self, 0);
		g_signal_connect_object ((ClutterActor*) self, "button-release-event", (GCallback) _unity_launcher_scroller_view_passthrough_button_release_event_clutter_actor_button_release_event, self, 0);
		unity_testing_object_registry_register (_tmp0_ = unity_testing_object_registry_get_default (), "LauncherScrollerView", (GObject*) self);
		_unity_testing_object_registry_unref0 (_tmp0_);
		mypadding = (ctk_actor_get_padding ((CtkActor*) self, &_tmp1_), _tmp1_);
		mypadding.left = 0.0f;
		mypadding.right = 0.0f;
		mypadding.top = 10.0f;
		mypadding.bottom = 5.0f;
		ctk_actor_set_padding ((CtkActor*) self, &mypadding);
		self->priv->keyboard_indicators = (_tmp2_ = gee_array_list_new (CLUTTER_TYPE_CAIRO_TEXTURE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->keyboard_indicators), _tmp2_);
		unity_launcher_scroller_view_load_textures (self);
		color = (memset (&_tmp3_, 0, sizeof (ClutterColor)), _tmp3_.red = (guint8) 0xff, _tmp3_.green = (guint8) 0xff, _tmp3_.blue = (guint8) 0xff, _tmp3_.alpha = (guint8) 0xff, _tmp3_);
		g_signal_connect_object ((GObject*) self, "notify::drag-indicator-active", (GCallback) _unity_launcher_scroller_view_on_drag_indicator_active_change_g_object_notify, self, 0);
		g_signal_connect_object ((GObject*) self, "notify::drag-indicator-index", (GCallback) _unity_launcher_scroller_view_on_drag_indicator_index_change_g_object_notify, self, 0);
		g_signal_connect_object ((GObject*) self, "notify::drag-indicator-space", (GCallback) _unity_launcher_scroller_view_on_drag_indicator_space_change_g_object_notify, self, 0);
		g_signal_connect_object (self->priv->_model, "child-added", (GCallback) _unity_launcher_scroller_view_model_child_added_unity_launcher_scroller_model_child_added, self, 0);
		g_signal_connect_object (self->priv->_model, "child-removed", (GCallback) _unity_launcher_scroller_view_model_child_removed_unity_launcher_scroller_model_child_removed, self, 0);
		g_signal_connect_object (self->priv->_model, "order-changed", (GCallback) _unity_launcher_scroller_view_model_order_changed_unity_launcher_scroller_model_order_changed, self, 0);
		{
			UnityLauncherScrollerModelIterator* _child_it;
			_child_it = unity_launcher_scroller_model_iterator (self->priv->_model);
			while (TRUE) {
				UnityLauncherScrollerChild* child;
				if (!unity_launcher_scroller_model_iterator_next (_child_it)) {
					break;
				}
				child = unity_launcher_scroller_model_iterator_get (_child_it);
				unity_launcher_scroller_view_model_child_added (self, child);
				_g_object_unref0 (child);
			}
			_unity_launcher_scroller_model_iterator_unref0 (_child_it);
		}
		g_signal_connect_object ((ClutterActor*) self, "button-press-event", (GCallback) _unity_launcher_scroller_view_on_button_press_event_clutter_actor_button_press_event, self, 0);
		g_signal_connect_object ((ClutterActor*) self, "button-release-event", (GCallback) _unity_launcher_scroller_view_on_button_release_event_clutter_actor_button_release_event, self, 0);
		g_signal_connect_object ((ClutterActor*) self, "motion-event", (GCallback) _unity_launcher_scroller_view_on_motion_event_clutter_actor_motion_event, self, 0);
		g_signal_connect_object ((ClutterActor*) self, "enter-event", (GCallback) _unity_launcher_scroller_view_on_enter_event_clutter_actor_enter_event, self, 0);
		g_signal_connect_object ((ClutterActor*) self, "scroll-event", (GCallback) _unity_launcher_scroller_view_on_scroll_event_clutter_actor_scroll_event, self, 0);
		g_signal_connect_object ((ClutterActor*) self, "leave-event", (GCallback) _unity_launcher_scroller_view_on_leave_event_clutter_actor_leave_event, self, 0);
		g_signal_connect_object ((GObject*) self, "notify::is-autoscrolling", (GCallback) _unity_launcher_scroller_view_on_auto_scrolling_state_change_g_object_notify, self, 0);
		g_signal_connect_object (unity_drag_controller_get_default (), "drag-motion", (GCallback) _unity_launcher_scroller_view_on_drag_motion_event_unity_drag_controller_drag_motion, self, 0);
		self->fling_timeline = (_tmp4_ = clutter_timeline_new ((guint) 1000), _g_object_unref0 (self->fling_timeline), _tmp4_);
		clutter_timeline_set_loop (self->fling_timeline, TRUE);
		g_signal_connect_object (self->fling_timeline, "new-frame", (GCallback) _unity_launcher_scroller_view_on_scroller_frame_clutter_timeline_new_frame, self, 0);
		g_signal_connect_object (self->fling_timeline, "started", (GCallback) __lambda86__clutter_timeline_started, self, 0);
		g_signal_connect_object (self->fling_timeline, "completed", (GCallback) __lambda87__clutter_timeline_completed, self, 0);
		self->autoscroll_timeline = (_tmp5_ = clutter_timeline_new ((guint) 1000), _g_object_unref0 (self->autoscroll_timeline), _tmp5_);
		clutter_timeline_set_loop (self->autoscroll_timeline, TRUE);
		g_signal_connect_object (self->autoscroll_timeline, "new-frame", (GCallback) _unity_launcher_scroller_view_on_autoscroll_frame_clutter_timeline_new_frame, self, 0);
		g_signal_connect_object (self->autoscroll_timeline, "started", (GCallback) __lambda89__clutter_timeline_started, self, 0);
		g_signal_connect_object (self->autoscroll_timeline, "completed", (GCallback) __lambda90__clutter_timeline_completed, self, 0);
		drag_controller = _g_object_ref0 (unity_drag_controller_get_default ());
		g_signal_connect_object (drag_controller, "drag-start", (GCallback) __lambda92__unity_drag_controller_drag_start, self, 0);
		g_signal_connect_object (drag_controller, "drag-drop", (GCallback) __lambda93__unity_drag_controller_drag_drop, self, 0);
		g_signal_connect_object (drag_controller, "drag-motion", (GCallback) __lambda95__unity_drag_controller_drag_motion, self, 0);
		clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
		self->priv->child_refs = (_tmp6_ = gee_array_list_new (UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->child_refs), _tmp6_);
		unity_launcher_scroller_view_order_children (self, TRUE);
		clutter_actor_queue_relayout ((ClutterActor*) self);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda96__gsource_func, g_object_ref (self), g_object_unref);
		unity_launcher_scroller_view_set_drag_indicator_space (self, FALSE);
		_g_object_unref0 (drag_controller);
	}
	return obj;
}


static void unity_launcher_scroller_view_class_init (UnityLauncherScrollerViewClass * klass) {
	unity_launcher_scroller_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityLauncherScrollerViewPrivate));
	CLUTTER_ACTOR_CLASS (klass)->get_preferred_width = unity_launcher_scroller_view_real_get_preferred_width;
	CLUTTER_ACTOR_CLASS (klass)->get_preferred_height = unity_launcher_scroller_view_real_get_preferred_height;
	CLUTTER_ACTOR_CLASS (klass)->allocate = unity_launcher_scroller_view_real_allocate;
	CLUTTER_ACTOR_CLASS (klass)->pick = unity_launcher_scroller_view_real_pick;
	CLUTTER_ACTOR_CLASS (klass)->paint = unity_launcher_scroller_view_real_paint;
	CLUTTER_ACTOR_CLASS (klass)->map = unity_launcher_scroller_view_real_map;
	CLUTTER_ACTOR_CLASS (klass)->unmap = unity_launcher_scroller_view_real_unmap;
	G_OBJECT_CLASS (klass)->get_property = unity_launcher_scroller_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_launcher_scroller_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_launcher_scroller_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_launcher_scroller_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_VIEW_MODEL, g_param_spec_object ("model", "model", "model", UNITY_LAUNCHER_TYPE_SCROLLER_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_VIEW_CACHE, g_param_spec_object ("cache", "cache", "cache", CTK_TYPE_EFFECT_CACHE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_VIEW_DRAG_INDICATOR_ACTIVE, g_param_spec_boolean ("drag-indicator-active", "drag-indicator-active", "drag-indicator-active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_VIEW_DRAG_INDICATOR_SPACE, g_param_spec_boolean ("drag-indicator-space", "drag-indicator-space", "drag-indicator-space", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_VIEW_DRAG_INDICATOR_INDEX, g_param_spec_int ("drag-indicator-index", "drag-indicator-index", "drag-indicator-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_VIEW_DRAG_INDICATOR_OPACITY, g_param_spec_float ("drag-indicator-opacity", "drag-indicator-opacity", "drag-indicator-opacity", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_VIEW_IS_AUTOSCROLLING, g_param_spec_boolean ("is-autoscrolling", "is-autoscrolling", "is-autoscrolling", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_launcher_scroller_view_instance_init (UnityLauncherScrollerView * self) {
	self->priv = UNITY_LAUNCHER_SCROLLER_VIEW_GET_PRIVATE (self);
	self->priv->disable_child_events = FALSE;
	self->priv->drag_indicator_position = 0.0f;
	self->spacing = 6;
	self->drag_sensitivity = 7;
	self->friction = 0.9f;
	self->is_animating = FALSE;
	self->priv->button_down = FALSE;
	self->priv->total_child_height = 0.0f;
	self->priv->current_phase = UNITY_LAUNCHER_SCROLLER_PHASE_SETTLING;
	self->priv->last_motion_event_time = (guint) 0;
	self->priv->view_type = UNITY_LAUNCHER_SCROLLER_VIEW_TYPE_CONTRACTED;
	self->priv->do_logic_pick = TRUE;
	self->priv->last_known_pointer_x = 0.0f;
	self->priv->can_scroll = FALSE;
	self->priv->last_known_x = (float) 0;
	self->priv->last_known_y = (float) 0;
	self->priv->scroll_position = 0.0f;
	self->priv->settle_position = 0.0f;
	self->priv->autoscroll_anim_active = FALSE;
	self->priv->autoscroll_direction = 0;
	self->priv->previous_y_position = 0.0f;
	self->priv->previous_y_time = (guint) 0;
	self->priv->stored_delta = (guint) 0;
	self->priv->scroll_speed = 0.0f;
	self->priv->contract_icon_degrees = 70.0f;
	self->priv->contract_icon_partial_degrees = 30.0f;
	self->priv->focused_launcher = 0;
	self->priv->last_picked_actor = NULL;
	self->priv->last_scroll_position = 0.0f;
	self->priv->autoscroll_stored_delta = (guint) 0;
	self->priv->queue_contract_launcher = (guint) 0;
	self->priv->attached_menu = NULL;
	self->priv->autoscroll_mouse_pos_cache = 0.0f;
	self->priv->fling_timeout_source = (guint) 0;
}


static void unity_launcher_scroller_view_finalize (GObject* obj) {
	UnityLauncherScrollerView * self;
	self = UNITY_LAUNCHER_SCROLLER_VIEW (obj);
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->_cache);
	_g_object_unref0 (self->priv->bgtex);
	_g_object_unref0 (self->priv->top_shadow);
	_g_object_unref0 (self->fling_timeline);
	_g_object_unref0 (self->autoscroll_timeline);
	_g_object_unref0 (self->priv->draw_ftb);
	_g_object_unref0 (self->priv->draw_btf);
	_g_object_unref0 (self->priv->keyboard_indicators);
	_g_object_unref0 (self->priv->child_refs);
	_g_object_unref0 (self->priv->last_picked_actor);
	_g_object_unref0 (self->priv->attached_menu);
	G_OBJECT_CLASS (unity_launcher_scroller_view_parent_class)->finalize (obj);
}


GType unity_launcher_scroller_view_get_type (void) {
	static volatile gsize unity_launcher_scroller_view_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_scroller_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityLauncherScrollerViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_launcher_scroller_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLauncherScrollerView), 0, (GInstanceInitFunc) unity_launcher_scroller_view_instance_init, NULL };
		GType unity_launcher_scroller_view_type_id;
		unity_launcher_scroller_view_type_id = g_type_register_static (CTK_TYPE_ACTOR, "UnityLauncherScrollerView", &g_define_type_info, 0);
		g_once_init_leave (&unity_launcher_scroller_view_type_id__volatile, unity_launcher_scroller_view_type_id);
	}
	return unity_launcher_scroller_view_type_id__volatile;
}


static void unity_launcher_scroller_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityLauncherScrollerView * self;
	self = UNITY_LAUNCHER_SCROLLER_VIEW (object);
	switch (property_id) {
		case UNITY_LAUNCHER_SCROLLER_VIEW_MODEL:
		g_value_set_object (value, unity_launcher_scroller_view_get_model (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_VIEW_CACHE:
		g_value_set_object (value, unity_launcher_scroller_view_get_cache (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_VIEW_DRAG_INDICATOR_ACTIVE:
		g_value_set_boolean (value, unity_launcher_scroller_view_get_drag_indicator_active (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_VIEW_DRAG_INDICATOR_SPACE:
		g_value_set_boolean (value, unity_launcher_scroller_view_get_drag_indicator_space (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_VIEW_DRAG_INDICATOR_INDEX:
		g_value_set_int (value, unity_launcher_scroller_view_get_drag_indicator_index (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_VIEW_DRAG_INDICATOR_OPACITY:
		g_value_set_float (value, unity_launcher_scroller_view_get_drag_indicator_opacity (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_VIEW_IS_AUTOSCROLLING:
		g_value_set_boolean (value, unity_launcher_scroller_view_get_is_autoscrolling (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_launcher_scroller_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityLauncherScrollerView * self;
	self = UNITY_LAUNCHER_SCROLLER_VIEW (object);
	switch (property_id) {
		case UNITY_LAUNCHER_SCROLLER_VIEW_MODEL:
		unity_launcher_scroller_view_set_model (self, g_value_get_object (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_VIEW_CACHE:
		unity_launcher_scroller_view_set_cache (self, g_value_get_object (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_VIEW_DRAG_INDICATOR_ACTIVE:
		unity_launcher_scroller_view_set_drag_indicator_active (self, g_value_get_boolean (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_VIEW_DRAG_INDICATOR_SPACE:
		unity_launcher_scroller_view_set_drag_indicator_space (self, g_value_get_boolean (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_VIEW_DRAG_INDICATOR_INDEX:
		unity_launcher_scroller_view_set_drag_indicator_index (self, g_value_get_int (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_VIEW_DRAG_INDICATOR_OPACITY:
		unity_launcher_scroller_view_set_drag_indicator_opacity (self, g_value_get_float (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_VIEW_IS_AUTOSCROLLING:
		unity_launcher_scroller_view_set_is_autoscrolling (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




