#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <glade/glade.h>
#include <libnotify/notify.h>

#include "update-notifier.h"
#include "update.h"


#define GDM_SIGNAL "/usr/bin/gdm-signal"

static GladeXML *xml;

static gint
show_notification (TrayApplet *ta)
{
	NotifyNotification *n;
	int                 x, y;

	// only show once the icon is realy availabe
	if(!GTK_WIDGET_REALIZED(ta->tray_icon))
	   return TRUE;

	/* Get the location of the icon.  If there's no location, come back
	 * in a few seconds. */
	gdk_window_get_origin (GTK_WIDGET(ta->tray_icon)->window, &x, &y);
	if ((x <= 0) || (y <= 0))
		return TRUE;

	/* Check whether the icon is still visible, may have gone away */
	if (!GTK_WIDGET_VISIBLE (ta->tray_icon))
		return FALSE;

	/* Create and show the notification */
	n = notify_notification_new (_("System restart required"),
				     _("To complete the update of your system, "
				       "restart your system.\n\n"
				       "Click on the notification icon to "
				       "restart your system."),
				     GTK_STOCK_DIALOG_WARNING,
				     GTK_WIDGET(ta->tray_icon));
	notify_notification_set_timeout (n, 60000);
	notify_notification_show (n, NULL);
	g_object_set_data (G_OBJECT(ta->tray_icon), "notification", n);

	return FALSE;
}

gboolean
reboot_check (TrayApplet *ta)
{
	struct stat statbuf;

	/* If the file doesn't exist, we don't need to reboot */
	if (stat (REBOOT_FILE, &statbuf)) {
		NotifyNotification *n;

		gtk_widget_hide (GTK_WIDGET(ta->tray_icon));
		gtk_widget_unrealize (GTK_WIDGET(ta->tray_icon));

		/* Hide any notification popup */
		n = g_object_get_data (G_OBJECT(ta->tray_icon), "notification");
		if (n)
			notify_notification_close (n, NULL);
		g_object_set_data (G_OBJECT(ta->tray_icon), "notification", NULL);

		return TRUE;
	}

	/* Skip the rest if the icon is already visible */
	if (GTK_WIDGET_VISIBLE(GTK_WIDGET(ta->tray_icon)))
		return TRUE;

	gtk_tooltips_set_tip (GTK_TOOLTIPS(ta->tooltip),
			      GTK_WIDGET (ta->eventbox),
			      _("System restart required"),
			      _("Click on the notification icon to "
				"restart your computer"));

	gtk_widget_show (GTK_WIDGET(ta->tray_icon));

	/* Check whether the user doesn't like notifications */
	if (gconf_client_get_bool ((GConfClient*) ta->user_data,
				   GCONF_KEY_NO_UPDATE_NOTIFICATIONS, NULL))
		return TRUE;

	/* Show the notification, after a delay so it doesn't look ugly
	 * if we've just logged in */
	g_timeout_add(5000, (GSourceFunc)(show_notification), ta);

	return TRUE;
}

static void
request_reboot (void)
{
	GnomeClient *client;
	char *cmd[] = { GDM_SIGNAL, "--reboot", NULL };

	client = gnome_master_client ();
	g_return_if_fail (client != NULL);

	/* Tell gdm to reboot once we exit the session */
	g_spawn_sync (NULL, cmd, NULL, G_SPAWN_STDOUT_TO_DEV_NULL,
		      NULL, NULL, NULL, NULL, NULL, NULL);

	/* Tell gnome-session to save and exit the session without asking
	 * the user. */
	gnome_client_request_save (client,
				   GNOME_SAVE_GLOBAL,
				   TRUE,
				   GNOME_INTERACT_NONE,
				   FALSE,
				   TRUE);
}

static gboolean
button_release_cb (GtkWidget *widget,
		   GdkEventButton *event,
		   TrayApplet *ta)
{
	if ((event->button == 1) && (event->type == GDK_BUTTON_RELEASE)) {
		GtkWidget *dia;

		dia = glade_xml_get_widget (xml, "dialog_reboot");
		if (gtk_dialog_run (GTK_DIALOG(dia)) == GTK_RESPONSE_OK)
			request_reboot ();

		gtk_widget_hide (dia);
	}

	return TRUE;
}


void
reboot_tray_icon_init (TrayApplet *ta)
{
	GtkWidget *widget;
	GtkImage *image;

	xml = glade_xml_new (GLADEDIR"reboot-dialog.glade", NULL, NULL);

	widget = glade_xml_get_widget (xml, "image");
	GtkIconTheme* icon_theme = gtk_icon_theme_get_default();
	GdkPixbuf *pixbuf = gtk_icon_theme_load_icon (icon_theme, "un-reboot",
						      48, 0,NULL);
	gtk_image_set_from_pixbuf(GTK_IMAGE(widget), pixbuf);
	ta->user_data = gconf_client_get_default();

        g_signal_connect (G_OBJECT(ta->tray_icon),
			  "button-release-event",
			  G_CALLBACK (button_release_cb),
			  ta);

	/* Check for updates for the first time */
	reboot_check (ta);
}
