/* l_lx_elf86.h -- created from l_lx_elf86.bin, 5285 (0x14a5) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2005 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2005 Laszlo Molnar
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define LINUX_I386ELF_LOADER_ADLER32 0xe35db8a7
#define LINUX_I386ELF_LOADER_CRC32   0x6f1175f8

unsigned char linux_i386elf_loader[5285] = {
232,  0,  0,  0,  0, 96,106, 63,139,116, 36, 40,139,124, 36, 48,   /* 0x   0 */
131,205,255,235,  0,164,235,  0,138,  6, 70,136,  7, 71,  1,219,   /* 0x  10 */
117,  7,139, 30,131,238,252, 17,219,114,  0, 49,192, 64,138,  7,   /* 0x  20 */
114,  0,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252,   /* 0x  30 */
 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,115,   /* 0x  40 */
  0,  1,219,115,  0,117,  9,139, 30,131,238,252, 17,219,115,  0,   /* 0x  50 */
 49,201,131,232,  3,114, 13,193,224,  8,138,  6, 70,131,240,255,   /* 0x  60 */
116,  0,137,197,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x  70 */
201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,117,  0,   /* 0x  80 */
 65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,   /* 0x  90 */
117,  7,139, 30,131,238,252, 17,219,115,  0,  1,219,115,  0,117,   /* 0x  a0 */
  9,139, 30,131,238,252, 17,219,115,  0, 65, 65,131,193,  2,129,   /* 0x  b0 */
253,  0,243,255,255,131,209,  1, 86,141, 52, 47,243,164, 94,233,   /* 0x  c0 */
  0,  0,  0,  0,141, 20, 47,131,253,252,138,  4, 15,118,  0,138,   /* 0x  d0 */
  2, 66,136,  7, 71, 73,117,247,233,  0,  0,  0,  0,139,  2,131,   /* 0x  e0 */
194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,  0,   /* 0x  f0 */
  0,  0,  0,235,  0,164,235,  0,138,  6, 70,136,  7, 71,  1,219,   /* 0x 100 */
117,  7,139, 30,131,238,252, 17,219,114,  0, 49,192, 64,138,  7,   /* 0x 110 */
114,  0,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252,   /* 0x 120 */
 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,114,   /* 0x 130 */
  0,  1,219,115, 11,117,  0,139, 30,131,238,252, 17,219,114,  0,   /* 0x 140 */
 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,235,  0,   /* 0x 150 */
 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,131,240,255,   /* 0x 160 */
116,  0,209,248,137,197,235, 11,  1,219,117,  7,139, 30,131,238,   /* 0x 170 */
252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 180 */
 17,201,117,  0, 65,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 190 */
 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115,  0,  1,   /* 0x 1a0 */
219,115,  0,117,  9,139, 30,131,238,252, 17,219,115,  0, 65, 65,   /* 0x 1b0 */
131,193,  2,129,253,  0,251,255,255,131,209,  1, 86,141, 52, 47,   /* 0x 1c0 */
243,164, 94,233,  0,  0,  0,  0,141, 20, 47,131,253,252,138,  4,   /* 0x 1d0 */
 15,118,  0,138,  2, 66,136,  7, 71, 73,117,247,233,  0,  0,  0,   /* 0x 1e0 */
  0,139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,   /* 0x 1f0 */
  1,207,233,  0,  0,  0,  0,235,  0,164,235,  0,138,  6, 70,136,   /* 0x 200 */
  7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  0, 49,   /* 0x 210 */
192, 64,138,  7,114,  0,184,  1,  0,  0,  0,  1,219,117,  7,139,   /* 0x 220 */
 30,131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,   /* 0x 230 */
252, 17,219,114,  0,  1,219,115, 11,117,  0,139, 30,131,238,252,   /* 0x 240 */
 17,219,114,  0, 72,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 250 */
 17,192,235,  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x 260 */
201,235,  0, 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,   /* 0x 270 */
131,240,255,116,  0,209,248,137,197,235, 11,  1,219,117,  7,139,   /* 0x 280 */
 30,131,238,252, 17,219,114,204, 65,  1,219,117,  7,139, 30,131,   /* 0x 290 */
238,252, 17,219,114,190,  1,219,117,  7,139, 30,131,238,252, 17,   /* 0x 2a0 */
219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115,  0,   /* 0x 2b0 */
  1,219,115,  0,117,  9,139, 30,131,238,252, 17,219,115,  0, 65,   /* 0x 2c0 */
 65,131,193,  2,129,253,  0,251,255,255,131,209,  2, 86,141, 52,   /* 0x 2d0 */
 47,243,164, 94,233,  0,  0,  0,  0,141, 20, 47,131,253,252,138,   /* 0x 2e0 */
  4, 15,118,  0,138,  2, 66,136,  7, 71, 73,117,247,233,  0,  0,   /* 0x 2f0 */
  0,  0,139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,   /* 0x 300 */
241,  1,207,233,  0,  0,  0,  0,185, 84, 69, 88, 76,138,  7, 71,   /* 0x 310 */
 44,232, 60,  1,119,247,128, 63, 63,117,  0,139,  7,138, 95,  4,   /* 0x 320 */
102,193,232,  8,134,196,193,192, 16,134,196, 41,248,128,235,232,   /* 0x 330 */
137,  7,131,199,  5,136,216,226,  0,185, 84, 69, 88, 76,176,232,   /* 0x 340 */
176,233,242,174,117,  0,128, 63, 63,117,  0,139,  7,102,193,232,   /* 0x 350 */
  8,134,196,193,192, 16,134,196, 41,248,171,235,  0,139, 84, 36,   /* 0x 360 */
 40,  3, 84, 36, 44, 57,214,116,  1, 72, 43,124, 36, 48,139, 84,   /* 0x 370 */
 36, 52,137, 58, 90,137, 68, 36, 28, 97,195,235,  0, 90, 88, 89,   /* 0x 380 */
151, 96, 49,219,187, 78, 77, 82, 85,106, 15, 88,138,100, 36, 32,   /* 0x 390 */
106, 15, 91,138,124, 36, 32,138, 84, 36, 32,233,  0,  0,  0,  0,   /* 0x 3a0 */
 15,183, 47, 43,110, 12, 41,221,117,  0,131,237,  1,115,  0,136,   /* 0x 3b0 */
 95,255, 73,136,  7, 71,139,  7,156,102,193,232,  8,193,192, 16,   /* 0x 3c0 */
134,196,157,115,  0,176,  0, 15,200,115,  0,209,232,115,  0,254,   /* 0x 3d0 */
203, 75, 35, 30,125,  2,  3, 30,137,  4,156,235,  0,141, 20, 24,   /* 0x 3e0 */
 15,182,210, 35, 22, 59, 22,114,  2, 43, 22,139,  4,148,254,203,   /* 0x 3f0 */
 75, 35, 30,125,  2,  3, 30,139, 44,156,133,237,117,  0, 80,139,   /* 0x 400 */
 70,  4,254,200, 72, 35,  6,125,  2,  3,  6, 49,237,137, 70,  4,   /* 0x 410 */
135,108,132,  4, 88,137, 44,148,137,  4,156, 41,248,131,233,  4,   /* 0x 420 */
  3, 70, 16,  1,240,137,  7,131,199,  4,235,  0,235,  0, 80,176,   /* 0x 430 */
233,176,232, 80,106,  0, 83,137,230, 94,137,218,178,233,178,232,   /* 0x 440 */
 67,106,  0,254,203, 75,117,  0, 15,183,  7,131,199,  1, 60,128,   /* 0x 450 */
114,  4, 60,143,118,  0, 41,208, 43, 70,  8,131,232,  2,116,  0,   /* 0x 460 */
131,232,  1,114,  0,115,  0,122,  0,123,  0,248,235,  0,131,233,   /* 0x 470 */
  1,127,  0,137,231,185,  4,  1,  0,  0,139, 14,131,193,  5,139,   /* 0x 480 */
 14,131,193,  4, 49,192,243,171,137,252, 86, 97,151, 81, 80, 82,   /* 0x 490 */
195,137,254,235,  0,138,  7,131,199,  1, 60,128,114, 10, 60,143,   /* 0x 4a0 */
119,  6,128,127,254, 15,116,  0, 44,232, 60,  1,119,  0, 56, 23,   /* 0x 4b0 */
117,  0,139,  7,102,193,232,  8,193,192, 16,134,196, 41,248,  1,   /* 0x 4c0 */
240,137,  7,131,199,  4,131,233,  4,138,  7,131,199,  1,226,  0,   /* 0x 4d0 */
131,233,  1,127,  0, 97,195, 94,141, 69,247, 43,  0,137,194,  3,   /* 0x 4e0 */
 64, 72, 80, 49,201, 81,106, 50,181, 16,106,  7, 81, 80,137,227,   /* 0x 4f0 */
106, 90, 88,205,128,146,147,252,173, 80, 84, 82,173, 80,173, 86,   /* 0x 500 */
255,213,131,196, 40,195, 93,232,203,255,255,255, 76, 69, 88, 69,   /* 0x 510 */
 67, 48, 48, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  0,  0,   /* 0x 520 */
  0, 76, 69, 88, 69, 67, 48, 50, 48,  0, 47,  0,  0,  0, 76, 69,   /* 0x 530 */
 88, 69, 67, 48, 48, 57,  0,  5,  0,  0,  0, 76, 69, 88, 69, 67,   /* 0x 540 */
 48, 49, 48,  0,  5,  0,  0,  0, 78, 50, 66, 83, 77, 65, 49, 48,   /* 0x 550 */
  0, 19,  0,  0,  0,  0,  0,  0,  0, 21,  0,  0,  0, 78, 50, 66,   /* 0x 560 */
 68, 69, 67, 49, 48,  0,  4,  0,  0,  0, 78, 50, 66, 70, 65, 83,   /* 0x 570 */
 49, 48,  0, 22,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0, 78,   /* 0x 580 */
 50, 66, 68, 69, 67, 49, 48,  0,  4,  0,  0,  0, 78, 50, 66, 70,   /* 0x 590 */
 65, 83, 49, 49,  0, 24,  0,  0,  0, 78, 50, 66, 68, 69, 67, 49,   /* 0x 5a0 */
 48,  0, 30,  0,  0,  0, 78, 50, 66, 83, 77, 65, 50, 48,  0, 41,   /* 0x 5b0 */
  0,  0,  0,  0,  0,  0,  0, 43,  0,  0,  0, 78, 50, 66, 83, 77,   /* 0x 5c0 */
 65, 49, 48,  0,  2,  0,  0,  0, 78, 50, 66, 70, 65, 83, 50, 48,   /* 0x 5d0 */
  0, 46,  0,  0,  0,  0,  0,  0,  0, 50,  0,  0,  0, 78, 50, 66,   /* 0x 5e0 */
 70, 65, 83, 49, 49,  0,  0,  0,  0,  0, 78, 50, 66, 68, 69, 67,   /* 0x 5f0 */
 50, 48,  0, 55,  0,  0,  0, 78, 50, 66, 83, 77, 65, 51, 48,  0,   /* 0x 600 */
 68,  0,  0,  0,  0,  0,  0,  0, 81,  0,  0,  0, 78, 50, 66, 68,   /* 0x 610 */
 69, 67, 50, 48,  0,  0,  0,  0,  0, 78, 50, 66, 70, 65, 83, 51,   /* 0x 620 */
 48,  0, 81,  0,  0,  0,  0,  0,  0,  0, 85,  0,  0,  0, 78, 50,   /* 0x 630 */
 66, 68, 69, 67, 50, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0, 96,   /* 0x 640 */
  0,  0,  0, 78, 50, 66, 68, 69, 67, 50, 48,  0,  0,  0,  0,  0,   /* 0x 650 */
 78, 50, 66, 68, 69, 67, 51, 48,  0, 96,  0,  0,  0,  0,  0,  0,   /* 0x 660 */
  0,114,  0,  0,  0, 78, 50, 66, 68, 69, 67, 54, 48,  0,  0,  0,   /* 0x 670 */
  0,  0,  0,  0,  0,  0,144,  0,  0,  0, 78, 50, 66, 68, 69, 67,   /* 0x 680 */
 53, 48,  0,  0,  0,  0,  0, 78, 50, 66, 83, 77, 65, 52, 48,  0,   /* 0x 690 */
158,  0,  0,  0,  0,  0,  0,  0,171,  0,  0,  0, 78, 50, 66, 68,   /* 0x 6a0 */
 69, 67, 51, 48,  0, 49,  0,  0,  0, 78, 50, 66, 70, 65, 83, 52,   /* 0x 6b0 */
 48,  0,171,  0,  0,  0,  0,  0,  0,  0,175,  0,  0,  0, 78, 50,   /* 0x 6c0 */
 66, 68, 69, 67, 51, 48,  0, 49,  0,  0,  0,  0,  0,  0,  0,186,   /* 0x 6d0 */
  0,  0,  0, 78, 50, 66, 68, 69, 67, 51, 48,  0, 49,  0,  0,  0,   /* 0x 6e0 */
 78, 50, 66, 68, 85, 77, 77, 49,  0,186,  0,  0,  0, 78, 50, 66,   /* 0x 6f0 */
 83, 77, 65, 53, 48,  0,186,  0,  0,  0, 78, 50, 66, 70, 65, 83,   /* 0x 700 */
 53, 48,  0,188,  0,  0,  0, 78, 50, 66, 68, 69, 67, 53, 48,  0,   /* 0x 710 */
191,  0,  0,  0, 78, 50, 66, 83, 77, 65, 54, 48,  0,200,  0,  0,   /* 0x 720 */
  0,  0,  0,  0,  0,212,  0,  0,  0, 78, 50, 66, 68, 69, 67, 49,   /* 0x 730 */
 48,  0,  0,  0,  0,  0, 78, 50, 66, 70, 65, 83, 54, 48,  0,212,   /* 0x 740 */
  0,  0,  0,  0,  0,  0,  0,223,  0,  0,  0, 78, 50, 66, 70, 65,   /* 0x 750 */
 83, 54, 49,  0,  0,  0,  0,  0,  0,  0,  0,  0,237,  0,  0,  0,   /* 0x 760 */
 78, 50, 66, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 66,   /* 0x 770 */
 70, 65, 83, 54, 49,  0,237,  0,  0,  0,  0,  0,  0,  0,  3,  1,   /* 0x 780 */
  0,  0, 78, 50, 66, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78,   /* 0x 790 */
 50, 66, 68, 69, 67, 54, 48,  0,  3,  1,  0,  0, 78, 82, 86, 50,   /* 0x 7a0 */
 66, 69, 78, 68,  0,  3,  1,  0,  0, 78, 50, 68, 83, 77, 65, 49,   /* 0x 7b0 */
 48,  0,  3,  1,  0,  0,  0,  0,  0,  0,  5,  1,  0,  0, 78, 50,   /* 0x 7c0 */
 68, 68, 69, 67, 49, 48,  0,  4,  0,  0,  0, 78, 50, 68, 70, 65,   /* 0x 7d0 */
 83, 49, 48,  0,  6,  1,  0,  0,  0,  0,  0,  0,  8,  1,  0,  0,   /* 0x 7e0 */
 78, 50, 68, 68, 69, 67, 49, 48,  0,  4,  0,  0,  0, 78, 50, 68,   /* 0x 7f0 */
 70, 65, 83, 49, 49,  0,  8,  1,  0,  0, 78, 50, 68, 68, 69, 67,   /* 0x 800 */
 49, 48,  0, 14,  1,  0,  0, 78, 50, 68, 83, 77, 65, 50, 48,  0,   /* 0x 810 */
 25,  1,  0,  0,  0,  0,  0,  0, 27,  1,  0,  0, 78, 50, 68, 83,   /* 0x 820 */
 77, 65, 49, 48,  0,  2,  0,  0,  0, 78, 50, 68, 70, 65, 83, 50,   /* 0x 830 */
 48,  0, 30,  1,  0,  0,  0,  0,  0,  0, 34,  1,  0,  0, 78, 50,   /* 0x 840 */
 68, 70, 65, 83, 49, 49,  0,  0,  0,  0,  0, 78, 50, 68, 68, 69,   /* 0x 850 */
 67, 50, 48,  0, 39,  1,  0,  0, 78, 50, 68, 83, 77, 65, 51, 48,   /* 0x 860 */
  0, 52,  1,  0,  0,  0,  0,  0,  0, 65,  1,  0,  0, 78, 50, 68,   /* 0x 870 */
 68, 69, 67, 51, 48,  0, 16,  0,  0,  0, 78, 50, 68, 70, 65, 83,   /* 0x 880 */
 51, 48,  0, 65,  1,  0,  0,  0,  0,  0,  0, 71,  1,  0,  0, 78,   /* 0x 890 */
 50, 68, 68, 69, 67, 51, 48,  0, 16,  0,  0,  0,  0,  0,  0,  0,   /* 0x 8a0 */
 80,  1,  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0, 16,  0,  0,   /* 0x 8b0 */
  0, 78, 50, 68, 68, 69, 67, 51, 48,  0, 80,  1,  0,  0,  0,  0,   /* 0x 8c0 */
  0,  0, 96,  1,  0,  0, 78, 50, 68, 68, 69, 67, 50, 48,  0,  0,   /* 0x 8d0 */
  0,  0,  0,  0,  0,  0,  0,114,  1,  0,  0, 78, 50, 68, 68, 69,   /* 0x 8e0 */
 67, 54, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,148,  1,  0,  0,   /* 0x 8f0 */
 78, 50, 68, 68, 69, 67, 53, 48,  0,  0,  0,  0,  0, 78, 50, 68,   /* 0x 900 */
 83, 77, 65, 52, 48,  0,162,  1,  0,  0,  0,  0,  0,  0,175,  1,   /* 0x 910 */
  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0, 69,  0,  0,  0, 78,   /* 0x 920 */
 50, 68, 70, 65, 83, 52, 48,  0,175,  1,  0,  0,  0,  0,  0,  0,   /* 0x 930 */
179,  1,  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0, 69,  0,  0,   /* 0x 940 */
  0,  0,  0,  0,  0,190,  1,  0,  0, 78, 50, 68, 68, 69, 67, 51,   /* 0x 950 */
 48,  0, 69,  0,  0,  0, 78, 50, 68, 68, 85, 77, 77, 49,  0,190,   /* 0x 960 */
  1,  0,  0, 78, 50, 68, 83, 77, 65, 53, 48,  0,190,  1,  0,  0,   /* 0x 970 */
 78, 50, 68, 70, 65, 83, 53, 48,  0,192,  1,  0,  0, 78, 50, 68,   /* 0x 980 */
 68, 69, 67, 53, 48,  0,195,  1,  0,  0, 78, 50, 68, 83, 77, 65,   /* 0x 990 */
 54, 48,  0,204,  1,  0,  0,  0,  0,  0,  0,216,  1,  0,  0, 78,   /* 0x 9a0 */
 50, 68, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 68, 70,   /* 0x 9b0 */
 65, 83, 54, 48,  0,216,  1,  0,  0,  0,  0,  0,  0,227,  1,  0,   /* 0x 9c0 */
  0, 78, 50, 68, 70, 65, 83, 54, 49,  0,  0,  0,  0,  0,  0,  0,   /* 0x 9d0 */
  0,  0,241,  1,  0,  0, 78, 50, 68, 68, 69, 67, 49, 48,  0,  0,   /* 0x 9e0 */
  0,  0,  0, 78, 50, 68, 70, 65, 83, 54, 49,  0,241,  1,  0,  0,   /* 0x 9f0 */
  0,  0,  0,  0,  7,  2,  0,  0, 78, 50, 68, 68, 69, 67, 49, 48,   /* 0x a00 */
  0,  0,  0,  0,  0, 78, 50, 68, 68, 69, 67, 54, 48,  0,  7,  2,   /* 0x a10 */
  0,  0, 78, 82, 86, 50, 68, 69, 78, 68,  0,  7,  2,  0,  0, 78,   /* 0x a20 */
 50, 69, 83, 77, 65, 49, 48,  0,  7,  2,  0,  0,  0,  0,  0,  0,   /* 0x a30 */
  9,  2,  0,  0, 78, 50, 69, 68, 69, 67, 49, 48,  0,  4,  0,  0,   /* 0x a40 */
  0, 78, 50, 69, 70, 65, 83, 49, 48,  0, 10,  2,  0,  0,  0,  0,   /* 0x a50 */
  0,  0, 12,  2,  0,  0, 78, 50, 69, 68, 69, 67, 49, 48,  0,  4,   /* 0x a60 */
  0,  0,  0, 78, 50, 69, 70, 65, 83, 49, 49,  0, 12,  2,  0,  0,   /* 0x a70 */
 78, 50, 69, 68, 69, 67, 49, 48,  0, 18,  2,  0,  0, 78, 50, 69,   /* 0x a80 */
 83, 77, 65, 50, 48,  0, 29,  2,  0,  0,  0,  0,  0,  0, 31,  2,   /* 0x a90 */
  0,  0, 78, 50, 69, 83, 77, 65, 49, 48,  0,  2,  0,  0,  0, 78,   /* 0x aa0 */
 50, 69, 70, 65, 83, 50, 48,  0, 34,  2,  0,  0,  0,  0,  0,  0,   /* 0x ab0 */
 38,  2,  0,  0, 78, 50, 69, 70, 65, 83, 49, 49,  0,  0,  0,  0,   /* 0x ac0 */
  0, 78, 50, 69, 68, 69, 67, 50, 48,  0, 43,  2,  0,  0, 78, 50,   /* 0x ad0 */
 69, 83, 77, 65, 51, 48,  0, 56,  2,  0,  0,  0,  0,  0,  0, 69,   /* 0x ae0 */
  2,  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,  0, 31,  0,  0,  0,   /* 0x af0 */
 78, 50, 69, 70, 65, 83, 51, 48,  0, 69,  2,  0,  0,  0,  0,  0,   /* 0x b00 */
  0, 75,  2,  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,  0, 31,  0,   /* 0x b10 */
  0,  0,  0,  0,  0,  0, 84,  2,  0,  0, 78, 50, 69, 68, 69, 67,   /* 0x b20 */
 51, 48,  0, 31,  0,  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,  0,   /* 0x b30 */
 84,  2,  0,  0,  0,  0,  0,  0,100,  2,  0,  0, 78, 50, 69, 68,   /* 0x b40 */
 69, 67, 50, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,115,  2,  0,   /* 0x b50 */
  0, 78, 50, 69, 68, 69, 67, 53, 48,  0,  0,  0,  0,  0,  0,  0,   /* 0x b60 */
  0,  0,133,  2,  0,  0, 78, 50, 69, 68, 69, 67, 54, 48,  0,  0,   /* 0x b70 */
  0,  0,  0, 78, 50, 69, 83, 77, 65, 52, 48,  0,179,  2,  0,  0,   /* 0x b80 */
  0,  0,  0,  0,192,  2,  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,   /* 0x b90 */
  0, 82,  0,  0,  0, 78, 50, 69, 70, 65, 83, 52, 48,  0,192,  2,   /* 0x ba0 */
  0,  0,  0,  0,  0,  0,196,  2,  0,  0, 78, 50, 69, 68, 69, 67,   /* 0x bb0 */
 51, 48,  0, 82,  0,  0,  0,  0,  0,  0,  0,207,  2,  0,  0, 78,   /* 0x bc0 */
 50, 69, 68, 69, 67, 51, 48,  0, 82,  0,  0,  0, 78, 50, 69, 68,   /* 0x bd0 */
 85, 77, 77, 49,  0,207,  2,  0,  0, 78, 50, 69, 83, 77, 65, 53,   /* 0x be0 */
 48,  0,207,  2,  0,  0, 78, 50, 69, 70, 65, 83, 53, 48,  0,209,   /* 0x bf0 */
  2,  0,  0, 78, 50, 69, 68, 69, 67, 53, 48,  0,212,  2,  0,  0,   /* 0x c00 */
 78, 50, 69, 83, 77, 65, 54, 48,  0,221,  2,  0,  0,  0,  0,  0,   /* 0x c10 */
  0,233,  2,  0,  0, 78, 50, 69, 68, 69, 67, 49, 48,  0,  0,  0,   /* 0x c20 */
  0,  0, 78, 50, 69, 70, 65, 83, 54, 48,  0,233,  2,  0,  0,  0,   /* 0x c30 */
  0,  0,  0,244,  2,  0,  0, 78, 50, 69, 70, 65, 83, 54, 49,  0,   /* 0x c40 */
  0,  0,  0,  0,  0,  0,  0,  0,  2,  3,  0,  0, 78, 50, 69, 68,   /* 0x c50 */
 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 69, 70, 65, 83, 54,   /* 0x c60 */
 49,  0,  2,  3,  0,  0,  0,  0,  0,  0, 24,  3,  0,  0, 78, 50,   /* 0x c70 */
 69, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 69, 68, 69,   /* 0x c80 */
 67, 54, 48,  0, 24,  3,  0,  0, 78, 82, 86, 50, 69, 69, 78, 68,   /* 0x c90 */
  0, 24,  3,  0,  0, 67, 65, 76, 76, 84, 82, 48, 48,  0, 24,  3,   /* 0x ca0 */
  0,  0, 67, 84, 67, 76, 69, 86, 69, 49,  0, 38,  3,  0,  0,  0,   /* 0x cb0 */
  0,  0,  0, 43,  3,  0,  0, 67, 65, 76, 76, 84, 82, 48, 48,  0,   /* 0x cc0 */
  5,  0,  0,  0, 67, 65, 76, 76, 84, 82, 48, 49,  0, 43,  3,  0,   /* 0x cd0 */
  0, 67, 84, 68, 85, 77, 77, 89, 49,  0, 48,  3,  0,  0, 67, 84,   /* 0x ce0 */
 66, 83, 72, 82, 48, 49,  0, 48,  3,  0,  0, 67, 84, 66, 82, 79,   /* 0x cf0 */
 82, 48, 49,  0, 52,  3,  0,  0, 67, 84, 66, 83, 87, 65, 48, 49,   /* 0x d00 */
  0, 54,  3,  0,  0, 67, 65, 76, 76, 84, 82, 48, 50,  0, 59,  3,   /* 0x d10 */
  0,  0,  0,  0,  0,  0, 73,  3,  0,  0, 67, 65, 76, 76, 84, 82,   /* 0x d20 */
 48, 48,  0, 10,  0,  0,  0, 67, 65, 76, 76, 84, 82, 49, 48,  0,   /* 0x d30 */
 73,  3,  0,  0, 67, 65, 76, 76, 84, 82, 69, 56,  0, 78,  3,  0,   /* 0x d40 */
  0, 67, 65, 76, 76, 84, 82, 69, 57,  0, 80,  3,  0,  0, 67, 65,   /* 0x d50 */
 76, 76, 84, 82, 49, 49,  0, 82,  3,  0,  0,  0,  0,  0,  0, 86,   /* 0x d60 */
  3,  0,  0, 67, 65, 76, 76, 84, 82, 49, 51,  0,  5,  0,  0,  0,   /* 0x d70 */
 67, 84, 67, 76, 69, 86, 69, 50,  0, 86,  3,  0,  0,  0,  0,  0,   /* 0x d80 */
  0, 91,  3,  0,  0, 67, 65, 76, 76, 84, 82, 49, 49,  0,  0,  0,   /* 0x d90 */
  0,  0, 67, 65, 76, 76, 84, 82, 49, 50,  0, 91,  3,  0,  0, 67,   /* 0x da0 */
 84, 68, 85, 77, 77, 89, 50,  0, 93,  3,  0,  0, 67, 84, 66, 83,   /* 0x db0 */
 72, 82, 49, 49,  0, 93,  3,  0,  0, 67, 84, 66, 82, 79, 82, 49,   /* 0x dc0 */
 49,  0, 97,  3,  0,  0, 67, 84, 66, 83, 87, 65, 49, 49,  0, 99,   /* 0x dd0 */
  3,  0,  0, 67, 65, 76, 76, 84, 82, 49, 51,  0,104,  3,  0,  0,   /* 0x de0 */
  0,  0,  0,  0,109,  3,  0,  0, 67, 65, 76, 76, 84, 82, 49, 48,   /* 0x df0 */
  0,  5,  0,  0,  0, 67, 84, 84, 72, 69, 69, 78, 68,  0,109,  3,   /* 0x e00 */
  0,  0, 76, 69, 88, 69, 67, 48, 49, 53,  0,109,  3,  0,  0, 76,   /* 0x e10 */
 88, 85, 78, 70, 48, 48, 48,  0,139,  3,  0,  0,  0,  0,  0,  0,   /* 0x e20 */
141,  3,  0,  0, 76, 88, 85, 78, 70, 48, 49, 48,  0,  5,  0,  0,   /* 0x e30 */
  0, 76, 88, 85, 78, 70, 48, 48, 50,  0,141,  3,  0,  0, 77, 82,   /* 0x e40 */
 85, 66, 89, 84, 69, 48,  0,146,  3,  0,  0, 76, 88, 77, 82, 85,   /* 0x e50 */
 48, 48, 53,  0,148,  3,  0,  0, 76, 88, 77, 82, 85, 48, 48, 54,   /* 0x e60 */
  0,153,  3,  0,  0, 76, 88, 77, 82, 85, 48, 48, 55,  0,160,  3,   /* 0x e70 */
  0,  0, 76, 88, 85, 78, 70, 48, 48, 56,  0,167,  3,  0,  0, 76,   /* 0x e80 */
 88, 85, 78, 70, 48, 49, 48,  0,171,  3,  0,  0,  0,  0,  0,  0,   /* 0x e90 */
176,  3,  0,  0, 76, 88, 85, 78, 70, 48, 52, 50,  0,  0,  0,  0,   /* 0x ea0 */
  0, 76, 88, 74, 67, 67, 48, 49, 48,  0,176,  3,  0,  0, 76, 88,   /* 0x eb0 */
 77, 82, 85, 48, 52, 53,  0,179,  3,  0,  0, 76, 88, 77, 82, 85,   /* 0x ec0 */
 48, 52, 54,  0,182,  3,  0,  0, 76, 88, 74, 67, 67, 48, 50, 48,   /* 0x ed0 */
  0,184,  3,  0,  0,  0,  0,  0,  0,186,  3,  0,  0, 76, 88, 85,   /* 0x ee0 */
 78, 70, 48, 51, 52,  0,  0,  0,  0,  0, 76, 88, 74, 67, 67, 48,   /* 0x ef0 */
 50, 49,  0,186,  3,  0,  0,  0,  0,  0,  0,191,  3,  0,  0, 76,   /* 0x f00 */
 88, 85, 78, 70, 48, 51, 52,  0,  0,  0,  0,  0, 76, 88, 74, 67,   /* 0x f10 */
 67, 48, 50, 51,  0,191,  3,  0,  0, 76, 88, 85, 78, 70, 48, 51,   /* 0x f20 */
 55,  0,198,  3,  0,  0, 76, 88, 85, 78, 70, 51, 56, 54,  0,200,   /* 0x f30 */
  3,  0,  0, 76, 88, 85, 78, 70, 51, 56, 55,  0,201,  3,  0,  0,   /* 0x f40 */
 76, 88, 85, 78, 70, 51, 56, 56,  0,210,  3,  0,  0,  0,  0,  0,   /* 0x f50 */
  0,213,  3,  0,  0, 76, 88, 85, 78, 70, 48, 52, 48,  0,  0,  0,   /* 0x f60 */
  0,  0, 76, 88, 85, 78, 70, 52, 56, 54,  0,213,  3,  0,  0, 76,   /* 0x f70 */
 88, 85, 78, 70, 52, 56, 55,  0,217,  3,  0,  0,  0,  0,  0,  0,   /* 0x f80 */
219,  3,  0,  0, 76, 88, 85, 78, 70, 48, 52, 48,  0,  0,  0,  0,   /* 0x f90 */
  0, 76, 88, 77, 82, 85, 48, 54, 53,  0,219,  3,  0,  0,  0,  0,   /* 0x fa0 */
  0,  0,223,  3,  0,  0, 76, 88, 77, 82, 85, 48, 55, 48,  0,  5,   /* 0x fb0 */
  0,  0,  0, 77, 82, 85, 66, 89, 84, 69, 51,  0,223,  3,  0,  0,   /* 0x fc0 */
 77, 82, 85, 65, 82, 66, 51, 48,  0,225,  3,  0,  0, 77, 82, 85,   /* 0x fd0 */
 66, 73, 84, 83, 51,  0,226,  3,  0,  0, 77, 82, 85, 65, 82, 66,   /* 0x fe0 */
 52, 48,  0,228,  3,  0,  0, 76, 88, 77, 82, 85, 48, 55, 48,  0,   /* 0x ff0 */
232,  3,  0,  0,  0,  0,  0,  0,237,  3,  0,  0, 76, 88, 85, 78,   /* 0x1000 */
 70, 48, 52, 48,  0,  0,  0,  0,  0, 77, 82, 85, 66, 89, 84, 69,   /* 0x1010 */
 52,  0,240,  3,  0,  0, 77, 82, 85, 66, 73, 84, 83, 52,  0,243,   /* 0x1020 */
  3,  0,  0, 77, 82, 85, 65, 82, 66, 53, 48,  0,245,  3,  0,  0,   /* 0x1030 */
 76, 88, 77, 82, 85, 48, 56, 48,  0,251,  3,  0,  0, 77, 82, 85,   /* 0x1040 */
 66, 89, 84, 69, 53,  0,254,  3,  0,  0, 77, 82, 85, 65, 82, 66,   /* 0x1050 */
 54, 48,  0,  0,  4,  0,  0, 77, 82, 85, 66, 73, 84, 83, 53,  0,   /* 0x1060 */
  1,  4,  0,  0, 77, 82, 85, 65, 82, 66, 55, 48,  0,  3,  4,  0,   /* 0x1070 */
  0, 76, 88, 77, 82, 85, 48, 57, 48,  0,  7,  4,  0,  0,  0,  0,   /* 0x1080 */
  0,  0, 14,  4,  0,  0, 76, 88, 77, 82, 85, 49, 48, 48,  0, 10,   /* 0x1090 */
  0,  0,  0, 77, 82, 85, 66, 89, 84, 69, 54,  0, 18,  4,  0,  0,   /* 0x10a0 */
 77, 82, 85, 65, 82, 66, 56, 48,  0, 20,  4,  0,  0, 77, 82, 85,   /* 0x10b0 */
 66, 73, 84, 83, 54,  0, 21,  4,  0,  0, 77, 82, 85, 65, 82, 66,   /* 0x10c0 */
 57, 48,  0, 23,  4,  0,  0, 76, 88, 77, 82, 85, 49, 48, 48,  0,   /* 0x10d0 */
 27,  4,  0,  0, 76, 88, 85, 78, 70, 48, 52, 48,  0, 43,  4,  0,   /* 0x10e0 */
  0, 76, 88, 77, 82, 85, 49, 49, 48,  0, 48,  4,  0,  0, 76, 88,   /* 0x10f0 */
 77, 82, 85, 49, 49, 49,  0, 51,  4,  0,  0, 76, 88, 85, 78, 70,   /* 0x1100 */
 48, 52, 49,  0, 53,  4,  0,  0,  0,  0,  0,  0, 60,  4,  0,  0,   /* 0x1110 */
 76, 88, 85, 78, 70, 48, 51, 52,  0,  0,  0,  0,  0, 76, 88, 85,   /* 0x1120 */
 78, 70, 48, 52, 50,  0, 60,  4,  0,  0, 76, 69, 88, 69, 67, 48,   /* 0x1130 */
 49, 54,  0, 60,  4,  0,  0,  0,  0,  0,  0, 62,  4,  0,  0, 76,   /* 0x1140 */
 88, 85, 78, 70, 48, 52, 50,  0,  0,  0,  0,  0, 76, 88, 77, 82,   /* 0x1150 */
 85, 48, 49, 48,  0, 62,  4,  0,  0, 76, 88, 74, 77, 80, 65, 48,   /* 0x1160 */
 48,  0, 63,  4,  0,  0, 76, 88, 67, 65, 76, 76, 66, 48,  0, 65,   /* 0x1170 */
  4,  0,  0, 76, 88, 85, 78, 70, 48, 50, 49,  0, 67,  4,  0,  0,   /* 0x1180 */
 76, 88, 77, 82, 85, 48, 50, 50,  0, 73,  4,  0,  0, 76, 88, 74,   /* 0x1190 */
 77, 80, 65, 48, 49,  0, 76,  4,  0,  0, 76, 88, 67, 65, 76, 76,   /* 0x11a0 */
 66, 49,  0, 78,  4,  0,  0, 77, 82, 85, 66, 73, 84, 83, 49,  0,   /* 0x11b0 */
 80,  4,  0,  0, 76, 88, 77, 82, 85, 48, 51, 48,  0, 81,  4,  0,   /* 0x11c0 */
  0, 77, 82, 85, 66, 89, 84, 69, 49,  0, 83,  4,  0,  0, 77, 82,   /* 0x11d0 */
 85, 65, 82, 66, 49, 48,  0, 85,  4,  0,  0, 76, 88, 77, 82, 85,   /* 0x11e0 */
 48, 52, 48,  0, 86,  4,  0,  0,  0,  0,  0,  0, 88,  4,  0,  0,   /* 0x11f0 */
 76, 88, 77, 82, 85, 48, 51, 48,  0,  0,  0,  0,  0, 76, 88, 85,   /* 0x1200 */
 78, 70, 48, 51, 48,  0, 88,  4,  0,  0, 76, 88, 74, 67, 67, 48,   /* 0x1210 */
 48, 48,  0, 94,  4,  0,  0,  0,  0,  0,  0,102,  4,  0,  0, 76,   /* 0x1220 */
 88, 74, 67, 67, 48, 49, 48,  0,  0,  0,  0,  0, 76, 88, 67, 74,   /* 0x1230 */
 48, 77, 82, 85,  0,102,  4,  0,  0, 76, 88, 67, 74, 49, 77, 82,   /* 0x1240 */
 85,  0,104,  4,  0,  0, 76, 88, 67, 65, 76, 74, 77, 80,  0,107,   /* 0x1250 */
  4,  0,  0, 76, 88, 67, 65, 76, 76, 48, 48,  0,110,  4,  0,  0,   /* 0x1260 */
  0,  0,  0,  0,112,  4,  0,  0, 76, 88, 85, 78, 70, 48, 51, 55,   /* 0x1270 */
  0,  0,  0,  0,  0, 76, 88, 67, 65, 76, 76, 48, 49,  0,112,  4,   /* 0x1280 */
  0,  0, 76, 88, 67, 74, 50, 77, 82, 85,  0,115,  4,  0,  0,  0,   /* 0x1290 */
  0,  0,  0,117,  4,  0,  0, 76, 88, 85, 78, 70, 48, 51, 55,  0,   /* 0x12a0 */
  0,  0,  0,  0, 76, 88, 67, 74, 52, 77, 82, 85,  0,117,  4,  0,   /* 0x12b0 */
  0,  0,  0,  0,  0,119,  4,  0,  0, 76, 88, 85, 78, 70, 48, 51,   /* 0x12c0 */
 52,  0,  0,  0,  0,  0, 76, 88, 67, 74, 54, 77, 82, 85,  0,119,   /* 0x12d0 */
  4,  0,  0,  0,  0,  0,  0,121,  4,  0,  0, 76, 88, 67, 74, 56,   /* 0x12e0 */
 77, 82, 85,  0,  1,  0,  0,  0, 76, 88, 67, 74, 55, 77, 82, 85,   /* 0x12f0 */
  0,121,  4,  0,  0,  0,  0,  0,  0,123,  4,  0,  0, 76, 88, 67,   /* 0x1300 */
 74, 56, 77, 82, 85,  0,  1,  0,  0,  0, 76, 88, 67, 74, 56, 77,   /* 0x1310 */
 82, 85,  0,123,  4,  0,  0,  0,  0,  0,  0,126,  4,  0,  0, 76,   /* 0x1320 */
 88, 85, 78, 70, 48, 51, 55,  0,  0,  0,  0,  0, 76, 88, 85, 78,   /* 0x1330 */
 70, 48, 51, 52,  0,126,  4,  0,  0,  0,  0,  0,  0,131,  4,  0,   /* 0x1340 */
  0, 76, 88, 85, 78, 70, 48, 51, 48,  0,  0,  0,  0,  0, 76, 88,   /* 0x1350 */
 77, 82, 85, 48, 53, 53,  0,131,  4,  0,  0, 77, 82, 85, 66, 89,   /* 0x1360 */
 84, 69, 50,  0,133,  4,  0,  0, 77, 82, 85, 66, 73, 84, 83, 50,   /* 0x1370 */
  0,138,  4,  0,  0, 77, 82, 85, 65, 82, 66, 50, 48,  0,143,  4,   /* 0x1380 */
  0,  0, 76, 88, 77, 82, 85, 48, 53, 55,  0,148,  4,  0,  0, 76,   /* 0x1390 */
 88, 77, 82, 85, 48, 53, 56,  0,154,  4,  0,  0, 76, 88, 85, 78,   /* 0x13a0 */
 70, 48, 51, 53,  0,155,  4,  0,  0, 67, 75, 76, 76, 84, 82, 48,   /* 0x13b0 */
 48,  0,161,  4,  0,  0,  0,  0,  0,  0,165,  4,  0,  0, 67, 75,   /* 0x13c0 */
 76, 76, 84, 82, 50, 48,  0, 30,  0,  0,  0, 67, 75, 76, 76, 84,   /* 0x13d0 */
 82, 49, 48,  0,170,  4,  0,  0,  0,  0,  0,  0,184,  4,  0,  0,   /* 0x13e0 */
 67, 75, 76, 76, 84, 82, 50, 48,  0,  6,  0,  0,  0, 67, 75, 76,   /* 0x13f0 */
 76, 84, 82, 50, 48,  0,184,  4,  0,  0,  0,  0,  0,  0,190,  4,   /* 0x1400 */
  0,  0, 67, 75, 76, 76, 84, 82, 52, 48,  0,  0,  0,  0,  0,  0,   /* 0x1410 */
  0,  0,  0,194,  4,  0,  0, 67, 75, 76, 76, 84, 82, 52, 48,  0,   /* 0x1420 */
  0,  0,  0,  0, 67, 75, 76, 76, 84, 82, 51, 48,  0,217,  4,  0,   /* 0x1430 */
  0,  0,  0,  0,  0,224,  4,  0,  0, 67, 75, 76, 76, 84, 82, 49,   /* 0x1440 */
 48,  0, 14,  0,  0,  0, 67, 75, 76, 76, 84, 82, 52, 48,  0,224,   /* 0x1450 */
  4,  0,  0,  0,  0,  0,  0,229,  4,  0,  0, 67, 75, 76, 76, 84,   /* 0x1460 */
 82, 48, 48,  0,  4,  0,  0,  0, 76, 69, 88, 69, 67, 48, 49, 55,   /* 0x1470 */
  0,229,  4,  0,  0, 76, 69, 88, 69, 67, 48, 50, 48,  0,231,  4,   /* 0x1480 */
  0,  0, 88, 84, 72, 69, 69, 78, 68, 88,  0, 28,  5,  0,  0,255,   /* 0x1490 */
255,255,255, 28,  5                                                /* 0x14a0 */
};
