/* l_lx_pti86.h -- created from l_lx_pti86.bin, 6542 (0x198e) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2006 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2006 Laszlo Molnar
   Copyright (C) 2000-2006 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define LINUX_I386PTI_LOADER_SIZE    6542
#define LINUX_I386PTI_LOADER_ADLER32 0xe080d1eb
#define LINUX_I386PTI_LOADER_CRC32   0xa507af83

unsigned char linux_i386pti_loader[6542] = {
232, 28,  0,  0,  0,131,248, 70,185,209,  5,  0,  0,116, 15,131,   /* 0x   0 */
248, 73,185,209,  5,  0,  0,116,  5,185, 32,  0,  0,  0,137,200,   /* 0x  10 */
195,232,  0,  0,  0,  0,131,248,  2,185, 83,  0,  0,  0,116,238,   /* 0x  20 */
131,248,  5,185, 83,  0,  0,  0,116,228,131,248,  8,185, 83,  0,   /* 0x  30 */
  0,  0,116,218,131,248, 11,185, 83,  0,  0,  0,116,208,233,198,   /* 0x  40 */
255,255,255, 96,131,205,255,139,116, 36, 36,139,124, 36, 44,235,   /* 0x  50 */
  0,164,235,  0,138,  6, 70,136,  7, 71,  1,219,117,  7,139, 30,   /* 0x  60 */
131,238,252, 17,219,114,  0, 49,192, 64,138,  7,114,  0,184,  1,   /* 0x  70 */
  0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,   /* 0x  80 */
  1,219,117,  7,139, 30,131,238,252, 17,219,115,  0,  1,219,115,   /* 0x  90 */
  0,117,  9,139, 30,131,238,252, 17,219,115,  0, 49,201,131,232,   /* 0x  a0 */
  3,114, 13,193,224,  8,138,  6, 70,131,240,255,116,  0,137,197,   /* 0x  b0 */
  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,   /* 0x  c0 */
  7,139, 30,131,238,252, 17,219, 17,201,117,  0, 65,  1,219,117,   /* 0x  d0 */
  7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,   /* 0x  e0 */
131,238,252, 17,219,115,  0,  1,219,115,  0,117,  9,139, 30,131,   /* 0x  f0 */
238,252, 17,219,115,  0, 65, 65,131,193,  2,129,253,  0,243,255,   /* 0x 100 */
255,131,209,  1, 86,141, 52, 47,243,164, 94,233,  0,  0,  0,  0,   /* 0x 110 */
141, 20, 47,131,253,252,138,  4, 15,118,  0,138,  2, 66,136,  7,   /* 0x 120 */
 71, 73,117,247,233,  0,  0,  0,  0,139,  2,131,194,  4,137,  7,   /* 0x 130 */
131,199,  4,131,233,  4,119,241,  1,207,233,  0,  0,  0,  0,235,   /* 0x 140 */
  0,164,235,  0,138,  6, 70,136,  7, 71,  1,219,117,  7,139, 30,   /* 0x 150 */
131,238,252, 17,219,114,  0, 49,192, 64,138,  7,114,  0,184,  1,   /* 0x 160 */
  0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,   /* 0x 170 */
  1,219,117,  7,139, 30,131,238,252, 17,219,114,  0,  1,219,115,   /* 0x 180 */
 11,117,  0,139, 30,131,238,252, 17,219,114,  0, 72,  1,219,117,   /* 0x 190 */
  7,139, 30,131,238,252, 17,219, 17,192,235,  0, 49,201,131,232,   /* 0x 1a0 */
  3,114, 17,193,224,  8,138,  6, 70,131,240,255,116,  0,209,248,   /* 0x 1b0 */
137,197,235, 11,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x 1c0 */
201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,117,  0,   /* 0x 1d0 */
 65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,   /* 0x 1e0 */
117,  7,139, 30,131,238,252, 17,219,115,  0,  1,219,115,  0,117,   /* 0x 1f0 */
  9,139, 30,131,238,252, 17,219,115,  0, 65, 65,131,193,  2,129,   /* 0x 200 */
253,  0,251,255,255,131,209,  1, 86,141, 52, 47,243,164, 94,233,   /* 0x 210 */
  0,  0,  0,  0,141, 20, 47,131,253,252,138,  4, 15,118,  0,138,   /* 0x 220 */
  2, 66,136,  7, 71, 73,117,247,233,  0,  0,  0,  0,139,  2,131,   /* 0x 230 */
194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,  0,   /* 0x 240 */
  0,  0,  0,235,  0,164,235,  0,138,  6, 70,136,  7, 71,  1,219,   /* 0x 250 */
117,  7,139, 30,131,238,252, 17,219,114,  0, 49,192, 64,138,  7,   /* 0x 260 */
114,  0,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252,   /* 0x 270 */
 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,114,   /* 0x 280 */
  0,  1,219,115, 11,117,  0,139, 30,131,238,252, 17,219,114,  0,   /* 0x 290 */
 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,235,  0,   /* 0x 2a0 */
  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,235,  0, 49,   /* 0x 2b0 */
201,131,232,  3,114, 17,193,224,  8,138,  6, 70,131,240,255,116,   /* 0x 2c0 */
  0,209,248,137,197,235, 11,  1,219,117,  7,139, 30,131,238,252,   /* 0x 2d0 */
 17,219,114,204, 65,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 2e0 */
114,190,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,   /* 0x 2f0 */
219,117,  7,139, 30,131,238,252, 17,219,115,  0,  1,219,115,  0,   /* 0x 300 */
117,  9,139, 30,131,238,252, 17,219,115,  0, 65, 65,131,193,  2,   /* 0x 310 */
129,253,  0,251,255,255,131,209,  2, 86,141, 52, 47,243,164, 94,   /* 0x 320 */
233,  0,  0,  0,  0,141, 20, 47,131,253,252,138,  4, 15,118,  0,   /* 0x 330 */
138,  2, 66,136,  7, 71, 73,117,247,233,  0,  0,  0,  0,139,  2,   /* 0x 340 */
131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,   /* 0x 350 */
  0,  0,  0,  0,255,210,  1,219,117,  2,255,210,144,232,  0,  0,   /* 0x 360 */
  0,  0,  1,219,116,  0,195,139, 30,131,238,252, 17,219,195, 41,   /* 0x 370 */
201, 17,201,114,  0, 17,201,114,  0, 17,201, 17,192, 72, 17,192,   /* 0x 380 */
131,233,  1,115,  0,141, 72, 15, 61,240,255,  0,  0,114,  0,141,   /* 0x 390 */
  4, 14, 80,233,  0,  0,  0,  0, 17,201, 17,201,131,193, 13,235,   /* 0x 3a0 */
  0,133,201,116,  0, 65,131,193,  8,235,  0, 41,201, 90, 41,219,   /* 0x 3b0 */
141, 65,  1,115,  0,114,  0,114,  0,114,  0,131,193,  2,114,  0,   /* 0x 3c0 */
 65,114,  5,233,  0,  0,  0,  0, 17,201,209,233,115,  1,164,209,   /* 0x 3d0 */
233,115,  2,102,165,243,165,141, 65,  1,235,  3,164,164,164, 17,   /* 0x 3e0 */
192,115,  0,131,232,  3,114, 11,193,224,  8,172,131,240,255,116,   /* 0x 3f0 */
  0,137,197, 17,201, 17,201,117,  0, 65, 17,201,115,  0,131,193,   /* 0x 400 */
  2,129,253,  0,243,255,255,131,209,  1, 86,141, 52, 47,131,253,   /* 0x 410 */
252,119, 19,209,233,115,  1,164,209,233,115,  2,102,165,243,165,   /* 0x 420 */
 94,233,  0,  0,  0,  0,131,253,255,117,  5,172,243,170,235,240,   /* 0x 430 */
243,164,235,236,233,  0,  0,  0,  0,139, 84, 36, 36,  3, 84, 36,   /* 0x 440 */
 40, 57,214,116,  1, 72, 43,124, 36, 44,139, 84, 36, 48,137, 58,   /* 0x 450 */
137, 68, 36, 28, 97,195,185, 84, 69, 88, 76,138,  7, 71, 44,232,   /* 0x 460 */
 60,  1,119,247,128, 63, 63,117,  0,139,  7,138, 95,  4,102,193,   /* 0x 470 */
232,  8,134,196,193,192, 16,134,196, 41,248,128,235,232,137,  7,   /* 0x 480 */
131,199,  5,136,216,226,  0,185, 84, 69, 88, 76,176,232,176,233,   /* 0x 490 */
242,174,117,  0,128, 63, 63,117,  0,139,  7,102,193,232,  8,134,   /* 0x 4a0 */
196,193,192, 16,134,196, 41,248,171,235,  0,235,  0, 90, 88, 89,   /* 0x 4b0 */
151, 96, 49,219,187, 78, 77, 82, 85,106, 15, 88,138,100, 36, 32,   /* 0x 4c0 */
106, 15, 91,138,124, 36, 32,138, 84, 36, 32,233,  0,  0,  0,  0,   /* 0x 4d0 */
 15,183, 47, 43,110, 12, 41,221,117,  0,131,237,  1,115,  0,136,   /* 0x 4e0 */
 95,255, 73,136,  7, 71,139,  7,156,102,193,232,  8,193,192, 16,   /* 0x 4f0 */
134,196,157,115,  0,176,  0, 15,200,115,  0,209,232,115,  0,254,   /* 0x 500 */
203, 75, 35, 30,125,  2,  3, 30,137,  4,156,235,  0,141, 20, 24,   /* 0x 510 */
 15,182,210, 35, 22, 59, 22,114,  2, 43, 22,139,  4,148,254,203,   /* 0x 520 */
 75, 35, 30,125,  2,  3, 30,139, 44,156,133,237,117,  0, 80,139,   /* 0x 530 */
 70,  4,254,200, 72, 35,  6,125,  2,  3,  6, 49,237,137, 70,  4,   /* 0x 540 */
135,108,132,  4, 88,137, 44,148,137,  4,156, 41,248,131,233,  4,   /* 0x 550 */
  3, 70, 16,  1,240,137,  7,131,199,  4,235,  0,235,  0, 80,176,   /* 0x 560 */
233,176,232, 80,106,  0, 83,137,230, 94,137,218,178,233,178,232,   /* 0x 570 */
 67,106,  0,254,203, 75,117,  0, 15,183,  7,131,199,  1, 60,128,   /* 0x 580 */
114,  4, 60,143,118,  0, 41,208, 43, 70,  8,131,232,  2,116,  0,   /* 0x 590 */
131,232,  1,114,  0,115,  0,122,  0,123,  0,248,235,  0,131,233,   /* 0x 5a0 */
  1,127,  0,137,231,185,  4,  1,  0,  0,139, 14,131,193,  5,139,   /* 0x 5b0 */
 14,131,193,  4, 49,192,243,171,137,252, 86, 97,151, 81, 80, 82,   /* 0x 5c0 */
195, 96,139,124, 36, 36,139, 76, 36, 40,139, 84, 36, 44,137,254,   /* 0x 5d0 */
235,  0,138,  7,131,199,  1, 60,128,114, 10, 60,143,119,  6,128,   /* 0x 5e0 */
127,254, 15,116,  0, 44,232, 60,  1,119,  0, 56, 23,117,  0,139,   /* 0x 5f0 */
  7,102,193,232,  8,193,192, 16,134,196, 41,248,  1,240,137,  7,   /* 0x 600 */
131,199,  4,131,233,  4,138,  7,131,199,  1,226,  0,131,233,  1,   /* 0x 610 */
127,  0, 97,195, 76, 88, 80, 84, 73, 48, 48, 48,  0,  0,  0,  0,   /* 0x 620 */
  0,  0,  0,  0,  0, 38,  0,  0,  0, 76, 88, 80, 84, 73, 50, 48,   /* 0x 630 */
 48,  0,  0,  0,  0,  0, 76, 88, 80, 84, 73, 48, 52, 48,  0, 83,   /* 0x 640 */
  0,  0,  0, 76, 88, 80, 84, 73, 48, 52, 49,  0, 83,  0,  0,  0,   /* 0x 650 */
 76, 88, 80, 84, 73, 48, 52, 50,  0, 83,  0,  0,  0, 76, 88, 80,   /* 0x 660 */
 84, 73, 48, 52, 51,  0, 83,  0,  0,  0, 76, 88, 80, 84, 73, 48,   /* 0x 670 */
 53, 48,  0, 83,  0,  0,  0, 78, 50, 66, 83, 77, 65, 49, 48,  0,   /* 0x 680 */
 95,  0,  0,  0,  0,  0,  0,  0, 97,  0,  0,  0, 78, 50, 66, 68,   /* 0x 690 */
 69, 67, 49, 48,  0,  4,  0,  0,  0, 78, 50, 66, 70, 65, 83, 49,   /* 0x 6a0 */
 48,  0, 98,  0,  0,  0,  0,  0,  0,  0,100,  0,  0,  0, 78, 50,   /* 0x 6b0 */
 66, 68, 69, 67, 49, 48,  0,  4,  0,  0,  0, 78, 50, 66, 70, 65,   /* 0x 6c0 */
 83, 49, 49,  0,100,  0,  0,  0, 78, 50, 66, 68, 69, 67, 49, 48,   /* 0x 6d0 */
  0,106,  0,  0,  0, 78, 50, 66, 83, 77, 65, 50, 48,  0,117,  0,   /* 0x 6e0 */
  0,  0,  0,  0,  0,  0,119,  0,  0,  0, 78, 50, 66, 83, 77, 65,   /* 0x 6f0 */
 49, 48,  0,  2,  0,  0,  0, 78, 50, 66, 70, 65, 83, 50, 48,  0,   /* 0x 700 */
122,  0,  0,  0,  0,  0,  0,  0,126,  0,  0,  0, 78, 50, 66, 70,   /* 0x 710 */
 65, 83, 49, 49,  0,  0,  0,  0,  0, 78, 50, 66, 68, 69, 67, 50,   /* 0x 720 */
 48,  0,131,  0,  0,  0, 78, 50, 66, 83, 77, 65, 51, 48,  0,144,   /* 0x 730 */
  0,  0,  0,  0,  0,  0,  0,157,  0,  0,  0, 78, 50, 66, 68, 69,   /* 0x 740 */
 67, 50, 48,  0,  0,  0,  0,  0, 78, 50, 66, 70, 65, 83, 51, 48,   /* 0x 750 */
  0,157,  0,  0,  0,  0,  0,  0,  0,161,  0,  0,  0, 78, 50, 66,   /* 0x 760 */
 68, 69, 67, 50, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,172,  0,   /* 0x 770 */
  0,  0, 78, 50, 66, 68, 69, 67, 50, 48,  0,  0,  0,  0,  0, 78,   /* 0x 780 */
 50, 66, 68, 69, 67, 51, 48,  0,172,  0,  0,  0,  0,  0,  0,  0,   /* 0x 790 */
190,  0,  0,  0, 78, 50, 66, 68, 69, 67, 54, 48,  0,  0,  0,  0,   /* 0x 7a0 */
  0,  0,  0,  0,  0,220,  0,  0,  0, 78, 50, 66, 68, 69, 67, 53,   /* 0x 7b0 */
 48,  0,  0,  0,  0,  0, 78, 50, 66, 83, 77, 65, 52, 48,  0,234,   /* 0x 7c0 */
  0,  0,  0,  0,  0,  0,  0,247,  0,  0,  0, 78, 50, 66, 68, 69,   /* 0x 7d0 */
 67, 51, 48,  0, 49,  0,  0,  0, 78, 50, 66, 70, 65, 83, 52, 48,   /* 0x 7e0 */
  0,247,  0,  0,  0,  0,  0,  0,  0,251,  0,  0,  0, 78, 50, 66,   /* 0x 7f0 */
 68, 69, 67, 51, 48,  0, 49,  0,  0,  0,  0,  0,  0,  0,  6,  1,   /* 0x 800 */
  0,  0, 78, 50, 66, 68, 69, 67, 51, 48,  0, 49,  0,  0,  0, 78,   /* 0x 810 */
 50, 66, 68, 85, 77, 77, 49,  0,  6,  1,  0,  0, 78, 50, 66, 83,   /* 0x 820 */
 77, 65, 53, 48,  0,  6,  1,  0,  0, 78, 50, 66, 70, 65, 83, 53,   /* 0x 830 */
 48,  0,  8,  1,  0,  0, 78, 50, 66, 68, 69, 67, 53, 48,  0, 11,   /* 0x 840 */
  1,  0,  0, 78, 50, 66, 83, 77, 65, 54, 48,  0, 20,  1,  0,  0,   /* 0x 850 */
  0,  0,  0,  0, 32,  1,  0,  0, 78, 50, 66, 68, 69, 67, 49, 48,   /* 0x 860 */
  0,  0,  0,  0,  0, 78, 50, 66, 70, 65, 83, 54, 48,  0, 32,  1,   /* 0x 870 */
  0,  0,  0,  0,  0,  0, 43,  1,  0,  0, 78, 50, 66, 70, 65, 83,   /* 0x 880 */
 54, 49,  0,  0,  0,  0,  0,  0,  0,  0,  0, 57,  1,  0,  0, 78,   /* 0x 890 */
 50, 66, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 66, 70,   /* 0x 8a0 */
 65, 83, 54, 49,  0, 57,  1,  0,  0,  0,  0,  0,  0, 79,  1,  0,   /* 0x 8b0 */
  0, 78, 50, 66, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50,   /* 0x 8c0 */
 66, 68, 69, 67, 54, 48,  0, 79,  1,  0,  0, 78, 82, 86, 50, 66,   /* 0x 8d0 */
 69, 78, 68,  0, 79,  1,  0,  0, 78, 50, 68, 83, 77, 65, 49, 48,   /* 0x 8e0 */
  0, 79,  1,  0,  0,  0,  0,  0,  0, 81,  1,  0,  0, 78, 50, 68,   /* 0x 8f0 */
 68, 69, 67, 49, 48,  0,  4,  0,  0,  0, 78, 50, 68, 70, 65, 83,   /* 0x 900 */
 49, 48,  0, 82,  1,  0,  0,  0,  0,  0,  0, 84,  1,  0,  0, 78,   /* 0x 910 */
 50, 68, 68, 69, 67, 49, 48,  0,  4,  0,  0,  0, 78, 50, 68, 70,   /* 0x 920 */
 65, 83, 49, 49,  0, 84,  1,  0,  0, 78, 50, 68, 68, 69, 67, 49,   /* 0x 930 */
 48,  0, 90,  1,  0,  0, 78, 50, 68, 83, 77, 65, 50, 48,  0,101,   /* 0x 940 */
  1,  0,  0,  0,  0,  0,  0,103,  1,  0,  0, 78, 50, 68, 83, 77,   /* 0x 950 */
 65, 49, 48,  0,  2,  0,  0,  0, 78, 50, 68, 70, 65, 83, 50, 48,   /* 0x 960 */
  0,106,  1,  0,  0,  0,  0,  0,  0,110,  1,  0,  0, 78, 50, 68,   /* 0x 970 */
 70, 65, 83, 49, 49,  0,  0,  0,  0,  0, 78, 50, 68, 68, 69, 67,   /* 0x 980 */
 50, 48,  0,115,  1,  0,  0, 78, 50, 68, 83, 77, 65, 51, 48,  0,   /* 0x 990 */
128,  1,  0,  0,  0,  0,  0,  0,141,  1,  0,  0, 78, 50, 68, 68,   /* 0x 9a0 */
 69, 67, 51, 48,  0, 16,  0,  0,  0, 78, 50, 68, 70, 65, 83, 51,   /* 0x 9b0 */
 48,  0,141,  1,  0,  0,  0,  0,  0,  0,147,  1,  0,  0, 78, 50,   /* 0x 9c0 */
 68, 68, 69, 67, 51, 48,  0, 16,  0,  0,  0,  0,  0,  0,  0,156,   /* 0x 9d0 */
  1,  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0, 16,  0,  0,  0,   /* 0x 9e0 */
 78, 50, 68, 68, 69, 67, 51, 48,  0,156,  1,  0,  0,  0,  0,  0,   /* 0x 9f0 */
  0,172,  1,  0,  0, 78, 50, 68, 68, 69, 67, 50, 48,  0,  0,  0,   /* 0x a00 */
  0,  0,  0,  0,  0,  0,190,  1,  0,  0, 78, 50, 68, 68, 69, 67,   /* 0x a10 */
 54, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,224,  1,  0,  0, 78,   /* 0x a20 */
 50, 68, 68, 69, 67, 53, 48,  0,  0,  0,  0,  0, 78, 50, 68, 83,   /* 0x a30 */
 77, 65, 52, 48,  0,238,  1,  0,  0,  0,  0,  0,  0,251,  1,  0,   /* 0x a40 */
  0, 78, 50, 68, 68, 69, 67, 51, 48,  0, 69,  0,  0,  0, 78, 50,   /* 0x a50 */
 68, 70, 65, 83, 52, 48,  0,251,  1,  0,  0,  0,  0,  0,  0,255,   /* 0x a60 */
  1,  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0, 69,  0,  0,  0,   /* 0x a70 */
  0,  0,  0,  0, 10,  2,  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,   /* 0x a80 */
  0, 69,  0,  0,  0, 78, 50, 68, 68, 85, 77, 77, 49,  0, 10,  2,   /* 0x a90 */
  0,  0, 78, 50, 68, 83, 77, 65, 53, 48,  0, 10,  2,  0,  0, 78,   /* 0x aa0 */
 50, 68, 70, 65, 83, 53, 48,  0, 12,  2,  0,  0, 78, 50, 68, 68,   /* 0x ab0 */
 69, 67, 53, 48,  0, 15,  2,  0,  0, 78, 50, 68, 83, 77, 65, 54,   /* 0x ac0 */
 48,  0, 24,  2,  0,  0,  0,  0,  0,  0, 36,  2,  0,  0, 78, 50,   /* 0x ad0 */
 68, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 68, 70, 65,   /* 0x ae0 */
 83, 54, 48,  0, 36,  2,  0,  0,  0,  0,  0,  0, 47,  2,  0,  0,   /* 0x af0 */
 78, 50, 68, 70, 65, 83, 54, 49,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x b00 */
  0, 61,  2,  0,  0, 78, 50, 68, 68, 69, 67, 49, 48,  0,  0,  0,   /* 0x b10 */
  0,  0, 78, 50, 68, 70, 65, 83, 54, 49,  0, 61,  2,  0,  0,  0,   /* 0x b20 */
  0,  0,  0, 83,  2,  0,  0, 78, 50, 68, 68, 69, 67, 49, 48,  0,   /* 0x b30 */
  0,  0,  0,  0, 78, 50, 68, 68, 69, 67, 54, 48,  0, 83,  2,  0,   /* 0x b40 */
  0, 78, 82, 86, 50, 68, 69, 78, 68,  0, 83,  2,  0,  0, 78, 50,   /* 0x b50 */
 69, 83, 77, 65, 49, 48,  0, 83,  2,  0,  0,  0,  0,  0,  0, 85,   /* 0x b60 */
  2,  0,  0, 78, 50, 69, 68, 69, 67, 49, 48,  0,  4,  0,  0,  0,   /* 0x b70 */
 78, 50, 69, 70, 65, 83, 49, 48,  0, 86,  2,  0,  0,  0,  0,  0,   /* 0x b80 */
  0, 88,  2,  0,  0, 78, 50, 69, 68, 69, 67, 49, 48,  0,  4,  0,   /* 0x b90 */
  0,  0, 78, 50, 69, 70, 65, 83, 49, 49,  0, 88,  2,  0,  0, 78,   /* 0x ba0 */
 50, 69, 68, 69, 67, 49, 48,  0, 94,  2,  0,  0, 78, 50, 69, 83,   /* 0x bb0 */
 77, 65, 50, 48,  0,105,  2,  0,  0,  0,  0,  0,  0,107,  2,  0,   /* 0x bc0 */
  0, 78, 50, 69, 83, 77, 65, 49, 48,  0,  2,  0,  0,  0, 78, 50,   /* 0x bd0 */
 69, 70, 65, 83, 50, 48,  0,110,  2,  0,  0,  0,  0,  0,  0,114,   /* 0x be0 */
  2,  0,  0, 78, 50, 69, 70, 65, 83, 49, 49,  0,  0,  0,  0,  0,   /* 0x bf0 */
 78, 50, 69, 68, 69, 67, 50, 48,  0,119,  2,  0,  0, 78, 50, 69,   /* 0x c00 */
 83, 77, 65, 51, 48,  0,132,  2,  0,  0,  0,  0,  0,  0,145,  2,   /* 0x c10 */
  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,  0, 31,  0,  0,  0, 78,   /* 0x c20 */
 50, 69, 70, 65, 83, 51, 48,  0,145,  2,  0,  0,  0,  0,  0,  0,   /* 0x c30 */
151,  2,  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,  0, 31,  0,  0,   /* 0x c40 */
  0,  0,  0,  0,  0,160,  2,  0,  0, 78, 50, 69, 68, 69, 67, 51,   /* 0x c50 */
 48,  0, 31,  0,  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,  0,160,   /* 0x c60 */
  2,  0,  0,  0,  0,  0,  0,176,  2,  0,  0, 78, 50, 69, 68, 69,   /* 0x c70 */
 67, 50, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,191,  2,  0,  0,   /* 0x c80 */
 78, 50, 69, 68, 69, 67, 53, 48,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x c90 */
  0,209,  2,  0,  0, 78, 50, 69, 68, 69, 67, 54, 48,  0,  0,  0,   /* 0x ca0 */
  0,  0, 78, 50, 69, 83, 77, 65, 52, 48,  0,255,  2,  0,  0,  0,   /* 0x cb0 */
  0,  0,  0, 12,  3,  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,  0,   /* 0x cc0 */
 82,  0,  0,  0, 78, 50, 69, 70, 65, 83, 52, 48,  0, 12,  3,  0,   /* 0x cd0 */
  0,  0,  0,  0,  0, 16,  3,  0,  0, 78, 50, 69, 68, 69, 67, 51,   /* 0x ce0 */
 48,  0, 82,  0,  0,  0,  0,  0,  0,  0, 27,  3,  0,  0, 78, 50,   /* 0x cf0 */
 69, 68, 69, 67, 51, 48,  0, 82,  0,  0,  0, 78, 50, 69, 68, 85,   /* 0x d00 */
 77, 77, 49,  0, 27,  3,  0,  0, 78, 50, 69, 83, 77, 65, 53, 48,   /* 0x d10 */
  0, 27,  3,  0,  0, 78, 50, 69, 70, 65, 83, 53, 48,  0, 29,  3,   /* 0x d20 */
  0,  0, 78, 50, 69, 68, 69, 67, 53, 48,  0, 32,  3,  0,  0, 78,   /* 0x d30 */
 50, 69, 83, 77, 65, 54, 48,  0, 41,  3,  0,  0,  0,  0,  0,  0,   /* 0x d40 */
 53,  3,  0,  0, 78, 50, 69, 68, 69, 67, 49, 48,  0,  0,  0,  0,   /* 0x d50 */
  0, 78, 50, 69, 70, 65, 83, 54, 48,  0, 53,  3,  0,  0,  0,  0,   /* 0x d60 */
  0,  0, 64,  3,  0,  0, 78, 50, 69, 70, 65, 83, 54, 49,  0,  0,   /* 0x d70 */
  0,  0,  0,  0,  0,  0,  0, 78,  3,  0,  0, 78, 50, 69, 68, 69,   /* 0x d80 */
 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 69, 70, 65, 83, 54, 49,   /* 0x d90 */
  0, 78,  3,  0,  0,  0,  0,  0,  0,100,  3,  0,  0, 78, 50, 69,   /* 0x da0 */
 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 69, 68, 69, 67,   /* 0x db0 */
 54, 48,  0,100,  3,  0,  0, 78, 82, 86, 50, 69, 69, 78, 68,  0,   /* 0x dc0 */
100,  3,  0,  0, 67, 76, 49, 83, 77, 65, 49, 66,  0,100,  3,  0,   /* 0x dd0 */
  0, 67, 76, 49, 70, 65, 83, 49, 66,  0,102,  3,  0,  0, 67, 76,   /* 0x de0 */
 49, 71, 69, 84, 49, 66,  0,108,  3,  0,  0, 67, 76, 49, 69, 78,   /* 0x df0 */
 84, 69, 82,  0,108,  3,  0,  0,  0,  0,  0,  0,114,  3,  0,  0,   /* 0x e00 */
 67, 76, 49, 83, 84, 65, 82, 84,  0,  0,  0,  0,  0, 67, 76, 49,   /* 0x e10 */
 83, 77, 65, 49, 48,  0,114,  3,  0,  0,  0,  0,  0,  0,118,  3,   /* 0x e20 */
  0,  0, 67, 76, 49, 82, 76, 79, 65, 68,  0,  0,  0,  0,  0, 67,   /* 0x e30 */
 76, 49, 82, 76, 79, 65, 68,  0,119,  3,  0,  0, 67, 76, 49, 87,   /* 0x e40 */
 73, 68, 48, 49,  0,127,  3,  0,  0, 67, 76, 49, 87, 73, 68, 48,   /* 0x e50 */
 50,  0,129,  3,  0,  0, 67, 76, 49, 87, 73, 68, 48, 51,  0,131,   /* 0x e60 */
  3,  0,  0,  0,  0,  0,  0,133,  3,  0,  0, 67, 76, 49, 87, 73,   /* 0x e70 */
 68, 49, 48,  0, 12,  0,  0,  0, 67, 76, 49, 87, 73, 68, 48, 52,   /* 0x e80 */
  0,133,  3,  0,  0, 67, 76, 49, 87, 73, 68, 48, 53,  0,135,  3,   /* 0x e90 */
  0,  0,  0,  0,  0,  0,137,  3,  0,  0, 67, 76, 49, 87, 73, 68,   /* 0x ea0 */
 49, 48,  0,  7,  0,  0,  0, 67, 76, 49, 87, 73, 68, 48, 54,  0,   /* 0x eb0 */
137,  3,  0,  0, 67, 76, 49, 87, 73, 68, 48, 55,  0,139,  3,  0,   /* 0x ec0 */
  0, 67, 76, 49, 87, 73, 68, 48, 56,  0,142,  3,  0,  0,  0,  0,   /* 0x ed0 */
  0,  0,149,  3,  0,  0, 67, 76, 49, 87, 73, 68, 48, 54,  0,  2,   /* 0x ee0 */
  0,  0,  0,  0,  0,  0,  0,159,  3,  0,  0, 67, 76, 49, 87, 73,   /* 0x ef0 */
 68, 49, 48,  0, 15,  0,  0,  0,  0,  0,  0,  0,168,  3,  0,  0,   /* 0x f00 */
 67, 76, 49, 67, 79, 80, 89, 48,  0, 18,  0,  0,  0, 67, 76, 49,   /* 0x f10 */
 87, 73, 68, 48, 57,  0,168,  3,  0,  0, 67, 76, 49, 87, 73, 68,   /* 0x f20 */
 49, 48,  0,170,  3,  0,  0,  0,  0,  0,  0,177,  3,  0,  0, 67,   /* 0x f30 */
 76, 49, 84, 79, 80, 48, 55,  0,  2,  0,  0,  0,  0,  0,  0,  0,   /* 0x f40 */
181,  3,  0,  0, 67, 76, 49, 87, 73, 68, 48, 56,  0, 26,  0,  0,   /* 0x f50 */
  0,  0,  0,  0,  0,187,  3,  0,  0, 67, 76, 49, 84, 79, 80, 48,   /* 0x f60 */
 55,  0,  2,  0,  0,  0, 67, 76, 49, 83, 84, 65, 82, 84,  0,187,   /* 0x f70 */
  3,  0,  0, 67, 76, 49, 84, 79, 80, 48, 48,  0,192,  3,  0,  0,   /* 0x f80 */
 67, 76, 49, 84, 79, 80, 48, 49,  0,195,  3,  0,  0,  0,  0,  0,   /* 0x f90 */
  0,197,  3,  0,  0, 67, 76, 49, 84, 79, 80, 48, 55,  0, 23,  0,   /* 0x fa0 */
  0,  0, 67, 76, 49, 84, 79, 80, 48, 50,  0,197,  3,  0,  0,  0,   /* 0x fb0 */
  0,  0,  0,199,  3,  0,  0, 67, 76, 49, 84, 79, 80, 48, 55,  0,   /* 0x fc0 */
 22,  0,  0,  0, 67, 76, 49, 84, 79, 80, 48, 51,  0,199,  3,  0,   /* 0x fd0 */
  0,  0,  0,  0,  0,201,  3,  0,  0, 67, 76, 49, 84, 79, 80, 48,   /* 0x fe0 */
 55,  0, 21,  0,  0,  0, 67, 76, 49, 84, 79, 80, 48, 52,  0,201,   /* 0x ff0 */
  3,  0,  0,  0,  0,  0,  0,203,  3,  0,  0, 67, 76, 49, 84, 79,   /* 0x1000 */
 80, 48, 55,  0, 20,  0,  0,  0, 67, 76, 49, 84, 79, 80, 48, 53,   /* 0x1010 */
  0,206,  3,  0,  0,  0,  0,  0,  0,208,  3,  0,  0, 67, 76, 49,   /* 0x1020 */
 84, 79, 80, 48, 54,  0,  7,  0,  0,  0, 67, 76, 49, 84, 79, 80,   /* 0x1030 */
 48, 54,  0,209,  3,  0,  0,  0,  0,  0,  0,216,  3,  0,  0, 67,   /* 0x1040 */
 76, 49, 87, 73, 68, 48, 49,  0,  0,  0,  0,  0, 67, 76, 49, 84,   /* 0x1050 */
 79, 80, 48, 55,  0,216,  3,  0,  0, 67, 76, 49, 79, 70, 70, 48,   /* 0x1060 */
 49,  0,239,  3,  0,  0, 67, 76, 49, 79, 70, 70, 48, 50,  0,241,   /* 0x1070 */
  3,  0,  0,  0,  0,  0,  0,243,  3,  0,  0, 67, 76, 49, 84, 79,   /* 0x1080 */
 80, 48, 55,  0, 23,  0,  0,  0,  0,  0,  0,  0,  1,  4,  0,  0,   /* 0x1090 */
 67, 76, 49, 67, 79, 80, 89, 48,  0, 51,  0,  0,  0, 67, 76, 49,   /* 0x10a0 */
 79, 70, 70, 48, 51,  0,  3,  4,  0,  0, 67, 76, 49, 79, 70, 70,   /* 0x10b0 */
 48, 52,  0,  5,  4,  0,  0,  0,  0,  0,  0,  9,  4,  0,  0, 67,   /* 0x10c0 */
 76, 49, 67, 79, 80, 89, 48,  0,  0,  0,  0,  0, 67, 76, 49, 76,   /* 0x10d0 */
 69, 78, 48, 48,  0,  9,  4,  0,  0, 67, 76, 49, 76, 69, 78, 48,   /* 0x10e0 */
 49,  0, 10,  4,  0,  0, 67, 76, 49, 76, 69, 78, 48, 50,  0, 12,   /* 0x10f0 */
  4,  0,  0,  0,  0,  0,  0, 14,  4,  0,  0, 67, 76, 49, 76, 69,   /* 0x1100 */
 78, 48, 48,  0,  1,  0,  0,  0, 67, 76, 49, 67, 79, 80, 89, 48,   /* 0x1110 */
  0, 17,  4,  0,  0,  0,  0,  0,  0, 54,  4,  0,  0, 67, 76, 49,   /* 0x1120 */
 84, 79, 80, 48, 48,  0,  0,  0,  0,  0, 67, 76, 49, 69, 78, 68,   /* 0x1130 */
  0, 68,  4,  0,  0, 76, 88, 80, 84, 73, 48, 57, 48,  0, 68,  4,   /* 0x1140 */
  0,  0,  0,  0,  0,  0, 73,  4,  0,  0, 76, 88, 80, 84, 73, 48,   /* 0x1150 */
 57, 49,  0,  0,  0,  0,  0, 76, 88, 80, 84, 73, 48, 57, 49,  0,   /* 0x1160 */
 73,  4,  0,  0, 67, 65, 76, 76, 84, 82, 48, 48,  0,102,  4,  0,   /* 0x1170 */
  0, 67, 84, 67, 76, 69, 86, 69, 49,  0,116,  4,  0,  0,  0,  0,   /* 0x1180 */
  0,  0,121,  4,  0,  0, 67, 65, 76, 76, 84, 82, 48, 48,  0,  5,   /* 0x1190 */
  0,  0,  0, 67, 65, 76, 76, 84, 82, 48, 49,  0,121,  4,  0,  0,   /* 0x11a0 */
 67, 84, 68, 85, 77, 77, 89, 49,  0,126,  4,  0,  0, 67, 84, 66,   /* 0x11b0 */
 83, 72, 82, 48, 49,  0,126,  4,  0,  0, 67, 84, 66, 82, 79, 82,   /* 0x11c0 */
 48, 49,  0,130,  4,  0,  0, 67, 84, 66, 83, 87, 65, 48, 49,  0,   /* 0x11d0 */
132,  4,  0,  0, 67, 65, 76, 76, 84, 82, 48, 50,  0,137,  4,  0,   /* 0x11e0 */
  0,  0,  0,  0,  0,151,  4,  0,  0, 67, 65, 76, 76, 84, 82, 48,   /* 0x11f0 */
 48,  0, 10,  0,  0,  0, 67, 65, 76, 76, 84, 82, 49, 48,  0,151,   /* 0x1200 */
  4,  0,  0, 67, 65, 76, 76, 84, 82, 69, 56,  0,156,  4,  0,  0,   /* 0x1210 */
 67, 65, 76, 76, 84, 82, 69, 57,  0,158,  4,  0,  0, 67, 65, 76,   /* 0x1220 */
 76, 84, 82, 49, 49,  0,160,  4,  0,  0,  0,  0,  0,  0,164,  4,   /* 0x1230 */
  0,  0, 67, 65, 76, 76, 84, 82, 49, 51,  0,  5,  0,  0,  0, 67,   /* 0x1240 */
 84, 67, 76, 69, 86, 69, 50,  0,164,  4,  0,  0,  0,  0,  0,  0,   /* 0x1250 */
169,  4,  0,  0, 67, 65, 76, 76, 84, 82, 49, 49,  0,  0,  0,  0,   /* 0x1260 */
  0, 67, 65, 76, 76, 84, 82, 49, 50,  0,169,  4,  0,  0, 67, 84,   /* 0x1270 */
 68, 85, 77, 77, 89, 50,  0,171,  4,  0,  0, 67, 84, 66, 83, 72,   /* 0x1280 */
 82, 49, 49,  0,171,  4,  0,  0, 67, 84, 66, 82, 79, 82, 49, 49,   /* 0x1290 */
  0,175,  4,  0,  0, 67, 84, 66, 83, 87, 65, 49, 49,  0,177,  4,   /* 0x12a0 */
  0,  0, 67, 65, 76, 76, 84, 82, 49, 51,  0,182,  4,  0,  0,  0,   /* 0x12b0 */
  0,  0,  0,187,  4,  0,  0, 67, 65, 76, 76, 84, 82, 49, 48,  0,   /* 0x12c0 */
  5,  0,  0,  0, 67, 84, 84, 72, 69, 69, 78, 68,  0,187,  4,  0,   /* 0x12d0 */
  0, 76, 88, 85, 78, 70, 48, 48, 48,  0,187,  4,  0,  0,  0,  0,   /* 0x12e0 */
  0,  0,189,  4,  0,  0, 76, 88, 85, 78, 70, 48, 49, 48,  0,  5,   /* 0x12f0 */
  0,  0,  0, 76, 88, 85, 78, 70, 48, 48, 50,  0,189,  4,  0,  0,   /* 0x1300 */
 77, 82, 85, 66, 89, 84, 69, 48,  0,194,  4,  0,  0, 76, 88, 77,   /* 0x1310 */
 82, 85, 48, 48, 53,  0,196,  4,  0,  0, 76, 88, 77, 82, 85, 48,   /* 0x1320 */
 48, 54,  0,201,  4,  0,  0, 76, 88, 77, 82, 85, 48, 48, 55,  0,   /* 0x1330 */
208,  4,  0,  0, 76, 88, 85, 78, 70, 48, 48, 56,  0,215,  4,  0,   /* 0x1340 */
  0, 76, 88, 85, 78, 70, 48, 49, 48,  0,219,  4,  0,  0,  0,  0,   /* 0x1350 */
  0,  0,224,  4,  0,  0, 76, 88, 85, 78, 70, 48, 52, 50,  0,  0,   /* 0x1360 */
  0,  0,  0, 76, 88, 74, 67, 67, 48, 49, 48,  0,224,  4,  0,  0,   /* 0x1370 */
 76, 88, 77, 82, 85, 48, 52, 53,  0,227,  4,  0,  0, 76, 88, 77,   /* 0x1380 */
 82, 85, 48, 52, 54,  0,230,  4,  0,  0, 76, 88, 74, 67, 67, 48,   /* 0x1390 */
 50, 48,  0,232,  4,  0,  0,  0,  0,  0,  0,234,  4,  0,  0, 76,   /* 0x13a0 */
 88, 85, 78, 70, 48, 51, 52,  0,  0,  0,  0,  0, 76, 88, 74, 67,   /* 0x13b0 */
 67, 48, 50, 49,  0,234,  4,  0,  0,  0,  0,  0,  0,239,  4,  0,   /* 0x13c0 */
  0, 76, 88, 85, 78, 70, 48, 51, 52,  0,  0,  0,  0,  0, 76, 88,   /* 0x13d0 */
 74, 67, 67, 48, 50, 51,  0,239,  4,  0,  0, 76, 88, 85, 78, 70,   /* 0x13e0 */
 48, 51, 55,  0,246,  4,  0,  0, 76, 88, 85, 78, 70, 51, 56, 54,   /* 0x13f0 */
  0,248,  4,  0,  0, 76, 88, 85, 78, 70, 51, 56, 55,  0,249,  4,   /* 0x1400 */
  0,  0, 76, 88, 85, 78, 70, 51, 56, 56,  0,  2,  5,  0,  0,  0,   /* 0x1410 */
  0,  0,  0,  5,  5,  0,  0, 76, 88, 85, 78, 70, 48, 52, 48,  0,   /* 0x1420 */
  0,  0,  0,  0, 76, 88, 85, 78, 70, 52, 56, 54,  0,  5,  5,  0,   /* 0x1430 */
  0, 76, 88, 85, 78, 70, 52, 56, 55,  0,  9,  5,  0,  0,  0,  0,   /* 0x1440 */
  0,  0, 11,  5,  0,  0, 76, 88, 85, 78, 70, 48, 52, 48,  0,  0,   /* 0x1450 */
  0,  0,  0, 76, 88, 77, 82, 85, 48, 54, 53,  0, 11,  5,  0,  0,   /* 0x1460 */
  0,  0,  0,  0, 15,  5,  0,  0, 76, 88, 77, 82, 85, 48, 55, 48,   /* 0x1470 */
  0,  5,  0,  0,  0, 77, 82, 85, 66, 89, 84, 69, 51,  0, 15,  5,   /* 0x1480 */
  0,  0, 77, 82, 85, 65, 82, 66, 51, 48,  0, 17,  5,  0,  0, 77,   /* 0x1490 */
 82, 85, 66, 73, 84, 83, 51,  0, 18,  5,  0,  0, 77, 82, 85, 65,   /* 0x14a0 */
 82, 66, 52, 48,  0, 20,  5,  0,  0, 76, 88, 77, 82, 85, 48, 55,   /* 0x14b0 */
 48,  0, 24,  5,  0,  0,  0,  0,  0,  0, 29,  5,  0,  0, 76, 88,   /* 0x14c0 */
 85, 78, 70, 48, 52, 48,  0,  0,  0,  0,  0, 77, 82, 85, 66, 89,   /* 0x14d0 */
 84, 69, 52,  0, 32,  5,  0,  0, 77, 82, 85, 66, 73, 84, 83, 52,   /* 0x14e0 */
  0, 35,  5,  0,  0, 77, 82, 85, 65, 82, 66, 53, 48,  0, 37,  5,   /* 0x14f0 */
  0,  0, 76, 88, 77, 82, 85, 48, 56, 48,  0, 43,  5,  0,  0, 77,   /* 0x1500 */
 82, 85, 66, 89, 84, 69, 53,  0, 46,  5,  0,  0, 77, 82, 85, 65,   /* 0x1510 */
 82, 66, 54, 48,  0, 48,  5,  0,  0, 77, 82, 85, 66, 73, 84, 83,   /* 0x1520 */
 53,  0, 49,  5,  0,  0, 77, 82, 85, 65, 82, 66, 55, 48,  0, 51,   /* 0x1530 */
  5,  0,  0, 76, 88, 77, 82, 85, 48, 57, 48,  0, 55,  5,  0,  0,   /* 0x1540 */
  0,  0,  0,  0, 62,  5,  0,  0, 76, 88, 77, 82, 85, 49, 48, 48,   /* 0x1550 */
  0, 10,  0,  0,  0, 77, 82, 85, 66, 89, 84, 69, 54,  0, 66,  5,   /* 0x1560 */
  0,  0, 77, 82, 85, 65, 82, 66, 56, 48,  0, 68,  5,  0,  0, 77,   /* 0x1570 */
 82, 85, 66, 73, 84, 83, 54,  0, 69,  5,  0,  0, 77, 82, 85, 65,   /* 0x1580 */
 82, 66, 57, 48,  0, 71,  5,  0,  0, 76, 88, 77, 82, 85, 49, 48,   /* 0x1590 */
 48,  0, 75,  5,  0,  0, 76, 88, 85, 78, 70, 48, 52, 48,  0, 91,   /* 0x15a0 */
  5,  0,  0, 76, 88, 77, 82, 85, 49, 49, 48,  0, 96,  5,  0,  0,   /* 0x15b0 */
 76, 88, 77, 82, 85, 49, 49, 49,  0, 99,  5,  0,  0, 76, 88, 85,   /* 0x15c0 */
 78, 70, 48, 52, 49,  0,101,  5,  0,  0,  0,  0,  0,  0,108,  5,   /* 0x15d0 */
  0,  0, 76, 88, 85, 78, 70, 48, 51, 52,  0,  0,  0,  0,  0, 76,   /* 0x15e0 */
 88, 85, 78, 70, 48, 52, 50,  0,108,  5,  0,  0, 76, 69, 88, 69,   /* 0x15f0 */
 67, 48, 49, 54,  0,108,  5,  0,  0,  0,  0,  0,  0,110,  5,  0,   /* 0x1600 */
  0, 76, 88, 85, 78, 70, 48, 52, 50,  0,  0,  0,  0,  0, 76, 88,   /* 0x1610 */
 77, 82, 85, 48, 49, 48,  0,110,  5,  0,  0, 76, 88, 74, 77, 80,   /* 0x1620 */
 65, 48, 48,  0,111,  5,  0,  0, 76, 88, 67, 65, 76, 76, 66, 48,   /* 0x1630 */
  0,113,  5,  0,  0, 76, 88, 85, 78, 70, 48, 50, 49,  0,115,  5,   /* 0x1640 */
  0,  0, 76, 88, 77, 82, 85, 48, 50, 50,  0,121,  5,  0,  0, 76,   /* 0x1650 */
 88, 74, 77, 80, 65, 48, 49,  0,124,  5,  0,  0, 76, 88, 67, 65,   /* 0x1660 */
 76, 76, 66, 49,  0,126,  5,  0,  0, 77, 82, 85, 66, 73, 84, 83,   /* 0x1670 */
 49,  0,128,  5,  0,  0, 76, 88, 77, 82, 85, 48, 51, 48,  0,129,   /* 0x1680 */
  5,  0,  0, 77, 82, 85, 66, 89, 84, 69, 49,  0,131,  5,  0,  0,   /* 0x1690 */
 77, 82, 85, 65, 82, 66, 49, 48,  0,133,  5,  0,  0, 76, 88, 77,   /* 0x16a0 */
 82, 85, 48, 52, 48,  0,134,  5,  0,  0,  0,  0,  0,  0,136,  5,   /* 0x16b0 */
  0,  0, 76, 88, 77, 82, 85, 48, 51, 48,  0,  0,  0,  0,  0, 76,   /* 0x16c0 */
 88, 85, 78, 70, 48, 51, 48,  0,136,  5,  0,  0, 76, 88, 74, 67,   /* 0x16d0 */
 67, 48, 48, 48,  0,142,  5,  0,  0,  0,  0,  0,  0,150,  5,  0,   /* 0x16e0 */
  0, 76, 88, 74, 67, 67, 48, 49, 48,  0,  0,  0,  0,  0, 76, 88,   /* 0x16f0 */
 67, 74, 48, 77, 82, 85,  0,150,  5,  0,  0, 76, 88, 67, 74, 49,   /* 0x1700 */
 77, 82, 85,  0,152,  5,  0,  0, 76, 88, 67, 65, 76, 74, 77, 80,   /* 0x1710 */
  0,155,  5,  0,  0, 76, 88, 67, 65, 76, 76, 48, 48,  0,158,  5,   /* 0x1720 */
  0,  0,  0,  0,  0,  0,160,  5,  0,  0, 76, 88, 85, 78, 70, 48,   /* 0x1730 */
 51, 55,  0,  0,  0,  0,  0, 76, 88, 67, 65, 76, 76, 48, 49,  0,   /* 0x1740 */
160,  5,  0,  0, 76, 88, 67, 74, 50, 77, 82, 85,  0,163,  5,  0,   /* 0x1750 */
  0,  0,  0,  0,  0,165,  5,  0,  0, 76, 88, 85, 78, 70, 48, 51,   /* 0x1760 */
 55,  0,  0,  0,  0,  0, 76, 88, 67, 74, 52, 77, 82, 85,  0,165,   /* 0x1770 */
  5,  0,  0,  0,  0,  0,  0,167,  5,  0,  0, 76, 88, 85, 78, 70,   /* 0x1780 */
 48, 51, 52,  0,  0,  0,  0,  0, 76, 88, 67, 74, 54, 77, 82, 85,   /* 0x1790 */
  0,167,  5,  0,  0,  0,  0,  0,  0,169,  5,  0,  0, 76, 88, 67,   /* 0x17a0 */
 74, 56, 77, 82, 85,  0,  1,  0,  0,  0, 76, 88, 67, 74, 55, 77,   /* 0x17b0 */
 82, 85,  0,169,  5,  0,  0,  0,  0,  0,  0,171,  5,  0,  0, 76,   /* 0x17c0 */
 88, 67, 74, 56, 77, 82, 85,  0,  1,  0,  0,  0, 76, 88, 67, 74,   /* 0x17d0 */
 56, 77, 82, 85,  0,171,  5,  0,  0,  0,  0,  0,  0,174,  5,  0,   /* 0x17e0 */
  0, 76, 88, 85, 78, 70, 48, 51, 55,  0,  0,  0,  0,  0, 76, 88,   /* 0x17f0 */
 85, 78, 70, 48, 51, 52,  0,174,  5,  0,  0,  0,  0,  0,  0,179,   /* 0x1800 */
  5,  0,  0, 76, 88, 85, 78, 70, 48, 51, 48,  0,  0,  0,  0,  0,   /* 0x1810 */
 76, 88, 77, 82, 85, 48, 53, 53,  0,179,  5,  0,  0, 77, 82, 85,   /* 0x1820 */
 66, 89, 84, 69, 50,  0,181,  5,  0,  0, 77, 82, 85, 66, 73, 84,   /* 0x1830 */
 83, 50,  0,186,  5,  0,  0, 77, 82, 85, 65, 82, 66, 50, 48,  0,   /* 0x1840 */
191,  5,  0,  0, 76, 88, 77, 82, 85, 48, 53, 55,  0,196,  5,  0,   /* 0x1850 */
  0, 76, 88, 77, 82, 85, 48, 53, 56,  0,202,  5,  0,  0, 76, 88,   /* 0x1860 */
 85, 78, 70, 48, 51, 53,  0,203,  5,  0,  0, 76, 88, 80, 84, 73,   /* 0x1870 */
 49, 52, 48,  0,209,  5,  0,  0, 76, 88, 80, 84, 73, 49, 52, 49,   /* 0x1880 */
  0,209,  5,  0,  0, 76, 88, 80, 84, 73, 49, 53, 48,  0,209,  5,   /* 0x1890 */
  0,  0, 67, 75, 76, 76, 84, 82, 48, 48,  0,222,  5,  0,  0,  0,   /* 0x18a0 */
  0,  0,  0,226,  5,  0,  0, 67, 75, 76, 76, 84, 82, 50, 48,  0,   /* 0x18b0 */
 30,  0,  0,  0, 67, 75, 76, 76, 84, 82, 49, 48,  0,231,  5,  0,   /* 0x18c0 */
  0,  0,  0,  0,  0,245,  5,  0,  0, 67, 75, 76, 76, 84, 82, 50,   /* 0x18d0 */
 48,  0,  6,  0,  0,  0, 67, 75, 76, 76, 84, 82, 50, 48,  0,245,   /* 0x18e0 */
  5,  0,  0,  0,  0,  0,  0,251,  5,  0,  0, 67, 75, 76, 76, 84,   /* 0x18f0 */
 82, 52, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,255,  5,  0,  0,   /* 0x1900 */
 67, 75, 76, 76, 84, 82, 52, 48,  0,  0,  0,  0,  0, 67, 75, 76,   /* 0x1910 */
 76, 84, 82, 51, 48,  0, 22,  6,  0,  0,  0,  0,  0,  0, 29,  6,   /* 0x1920 */
  0,  0, 67, 75, 76, 76, 84, 82, 49, 48,  0, 14,  0,  0,  0, 67,   /* 0x1930 */
 75, 76, 76, 84, 82, 52, 48,  0, 29,  6,  0,  0,  0,  0,  0,  0,   /* 0x1940 */
 34,  6,  0,  0, 67, 75, 76, 76, 84, 82, 48, 48,  0,  4,  0,  0,   /* 0x1950 */
  0, 76, 88, 80, 84, 73, 49, 54, 48,  0, 34,  6,  0,  0, 76, 88,   /* 0x1960 */
 80, 84, 73, 50, 48, 48,  0, 36,  6,  0,  0, 88, 84, 72, 69, 69,   /* 0x1970 */
 78, 68, 88,  0, 36,  6,  0,  0,255,255,255,255, 36,  6            /* 0x1980 */
};
