/*****************************************************************************
 *
 * utouch-frame - Touch Frame Library
 *
 * Copyright (C) 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef UTOUCH_FRAME_TEST_EVENTS_H_
#define UTOUCH_FRAME_TEST_EVENTS_H_

#include <map>
#include <vector>

#include "utouch/frame.h"

namespace utouch {
namespace frame {
namespace testing {

union Value {
  UFTouchState state;
  float floating;
  int boolean;
};

typedef std::pair<UFTouchProperty, Value> Property;
typedef std::map<UFTouchProperty, Value> Properties;
typedef std::pair<UFAxisType, float> AxisValue;
typedef std::map<UFAxisType, float> AxisValues;
typedef std::pair<Properties, AxisValues> Touch;
typedef std::vector<Touch> Touches;
typedef std::vector<Touches> Events;

const Value NewValue(UFTouchState state);
const Value NewValue(float floating);
const Value NewValue(int boolean);

bool IsEqual(const Touch& a, const Touch& b);

} // namespace testing
} // namespace frame
} // namespace utouch

#endif // UTOUCH_FRAME_TEST_EVENTS_H_
