/**
 * @file backend/xcb/geis_gestures.h
 * @brief internal GEIS XCB back end class
 *
 * Copyright 2011 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */
#ifndef GEIS_XCB_GRAIL_GESTURES_H_
#define GEIS_XCB_GRAIL_GESTURES_H_

GeisStatus geis_xcb_backend_add_drag_attrs(GeisGestureClass gesture_class);

GeisStatus geis_xcb_backend_add_pinch_attrs(GeisGestureClass gesture_class);

GeisStatus geis_xcb_backend_add_rotate_attrs(GeisGestureClass gesture_class);

GeisStatus geis_xcb_backend_add_tap_attrs(GeisGestureClass gesture_class);

GeisInteger geis_xcb_backend_primitive_class(GeisInteger grail_gesture_type);

GeisSize geis_xcb_backend_map_grail_attrs(GeisInteger grail_type,
                                          GeisSize    num_properties,
                                          float      *properties,
                                          GeisFrame   frame);

/**
 * Initializes the XCB gesture bitmask.
 *
 * @param[in]  sub_flags The subscription flags.
 * @param[out] mask_len  The number of 32-bit flags in the bitmask.
 * @param[out] mask      The bitmask.
 *
 * Marks all gesture bits as set in the mask, depending on the settings of the
 * subscription flags.
 */
void geis_xcb_backend_gesture_bitmask_init(GeisSubscriptionFlags  sub_flags,
                                           uint32_t              *mask_len,
                                           uint32_t              *mask);

/**
 * Clears the XCB gesture bits for gestures not matching a class.
 *
 * @param[in] class_name The name of the gestire class.
 * @param[in] mask_len   The number of 32-bit flags in the bitmask.
 * @param[in] mask       The bitmask.
 *
 * The XCB gesture botmask bits for any gestired not belonging to the named
 * class are cleared.
 */
void geis_xcb_backend_gesture_bitmask_filter_class(GeisString  class_name,
                                                   uint32_t   *mask_len,
                                                   uint32_t   *mask);

/**
 * Clears the XCB gesture bits for gestures with touches not in a range.
 *
 * @param[in] min_touches The minimum number of touches to allow.
 * @param[in] max_touches The maximum number of touches to allow.
 * @param[in] mask_len    The number of 32-bit flags in the bitmask.
 * @param[in] mask        The bitmask.
 *
 * The (min, max) pair represents an open interval.  The XCB gesture bitmask bits
 * for any gesture with touches outside of that interval are cleared.
 */
void geis_xcb_backend_gesture_bitmask_filter_touches(GeisSize  min_touches,
                                                     GeisSize  max_touches,
                                                     uint32_t *mask_len,
                                                     uint32_t *mask);

#endif /* GEIS_XCB_GRAIL_GESTURES_H_ */
