/*****************************************************************************
 *
 * grail - Gesture Recognition And Instantiation Library
 *
 * Copyright (C) 2010-2012 Canonical Ltd.
 *
 * This library is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef GRAIL_RECOGNIZER_H
#define GRAIL_RECOGNIZER_H

#include "grail-gestures.h"

struct gesture_recognizer {
	struct move_model move;
	struct combo_model touch;
	struct combo_model drag;
	struct combo_model pinch;
	struct combo_model rotate;
	struct combo_model wintouch;
	struct combo_model windrag;
	struct combo_model winpinch;
	struct combo_model winrotate;
	struct tapping_model tapping;
};

int gru_init(struct grail *ge);
void gru_recognize(struct grail *ge, const struct utouch_frame *frame);
void gru_destroy(struct grail *ge);

#endif
