/*****************************************************************************
 *
 * grail - Gesture Recognition And Instantiation Library
 *
 * Copyright (C) 2010-2012 Canonical Ltd.
 *
 * This library is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef GRAIL_BUFFER_H
#define GRAIL_BUFFER_H

#include <grail.h>

#define DIM_GRAIL_EVENTS 512

struct grailbuf {
	int head;
	int tail;
	struct grail_event buffer[DIM_GRAIL_EVENTS];
};

static inline void grailbuf_clear(struct grailbuf *buf)
{
	buf->head = buf->tail = 0;
}

static inline int grailbuf_empty(const struct grailbuf *buf)
{
	return buf->head == buf->tail;
}

static inline void grailbuf_put(struct grailbuf *buf,
				const struct grail_event *ev)
{
	buf->buffer[buf->head++] = *ev;
	buf->head &= DIM_GRAIL_EVENTS - 1;
}

static inline void grailbuf_get(struct grailbuf *buf,
				struct grail_event *ev)
{
	*ev = buf->buffer[buf->tail++];
	buf->tail &= DIM_GRAIL_EVENTS - 1;
}

#endif
