/*****************************************************************************
 *
 * utouch-grail - Multitouch Gesture Recognition Library
 *
 * Copyright (C) 2011-2012 Canonical Ltd.
 *
 * This library is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef UTOUCH_GRAIL_HANDLE_H_
#define UTOUCH_GRAIL_HANDLE_H_

#include <list>
#include <map>
#include <memory>

#include <utouch/frame.h>
#include <X11/X.h>

#include "utouch/grail.h"
#include "v3/forward.h"

struct UGHandle_ {};

namespace utouch {
namespace grail {

class UGHandle : public UGHandle_ {
 public:
  explicit UGHandle(UFHandle frame_handle);
  ~UGHandle();

  int event_fd() const { return event_fd_; }
  Recognizer *CreateRecognizerForSubscription(UGSubscription* subscription);
  UGStatus ActivateSubscription(UGSubscription* subscription);
  void DeactivateSubscription(UGSubscription* subscription);
  unsigned int NewGestureID(Recognizer* recognizer);
  void ProcessFrameEvent(UFEvent event);
  void UpdateTime(uint64_t time);
  uint64_t NextTimeout() const;
  void EnqueueEvent(utouch::grail::UGEvent*);
  void RemoveGestureFromEventQueue(unsigned int id);
  UGStatus GetEvent(::UGEvent* event);
  UGStatus AcceptGesture(unsigned int id);
  UGStatus RejectGesture(unsigned int id);

  UGHandle(const UGHandle&) = delete;
  UGHandle& operator=(const UGHandle&) = delete;

 private:
  typedef std::unique_ptr<Recognizer> UniqueRecognizer;

  const UFHandle frame_handle_;
  int event_fd_;
  unsigned int next_id_;
  std::map<UFDevice, std::map<UFWindowId, UniqueRecognizer>> recognizers_;
  std::map<unsigned int, Recognizer*> gestures_;
  std::list<utouch::grail::UGEvent*> event_queue_;
};

} // namespace grail
} // namespace utouch
#endif // UTOUCH_GRAIL_HANDLE_H_
