<?php
/**
 * @package Ubuntu_Unity_Integration
 * @version 1.0
 */
/*
Plugin Name: Ubuntu Unity Integration
Plugin URI: http://launchpad.net/webapps
Author: Maxim Ermilov
Version: 1.2
License: GPL2
*/

add_action('wp_ajax_get_count_comments', 'get_count_comments_callback');
add_action('wp_ajax_get_lastcomment', 'get_lastcomment_callback');

function get_lastcomment_callback() {
  global $wpdb;

  $x = new WP_Ajax_Response();
  $r = $wpdb->get_results("SELECT comment_content, comment_author_email FROM $wpdb->comments ORDER BY comment_date_gmt DESC LIMIT 1;");
  $x->add(array(
                'what' => 'last_comment',
                'data' => json_encode($r[0])
                ));
  $x->send();

  die();
}

function get_count_comments_callback() {
  $x = new WP_Ajax_Response();
  $x->add(array(
                'what' => 'count-comments',
                'data' => json_encode(wp_count_comments())
                ));
  $x->send();

  die();
}

add_action('admin_head', 'unity_integration_javascript');

function unity_integration_javascript() {
?>

  <script type="text/javascript">
    if (external && external.getUnityObject) {
      var Unity = external.getUnityObject(1);

      function messagingIndicatorSetup() {
        function composeNewPost() {
          var url = '<?php echo get_bloginfo('siteurl');?>';
          if (url[url.length - 1] != '/')
            url = url + '/';
          window.location.assign(url + 'wp-admin/post-new.php');
        }
        Unity.Launcher.addAction("New Post",
                                 composeNewPost);

        var parser=new DOMParser();
        setInterval(function checkCount() {
          jQuery.post(ajaxurl, { action: 'get_count_comments' }, function(doc) {
            var counts = JSON.parse(doc.evaluate('//count-comments/response_data',
                                                 doc, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue.textContent);

            Unity.MessagingIndicator.showIndicator("comments awaiting moderation",
                                                   { count: counts.moderated.toString() });
	  });
        }, 5000);

        setInterval(function() {
          jQuery.post(ajaxurl, { action: 'get_lastcomment' }, function(doc) {
            var message = JSON.parse(doc.evaluate('//last_comment/response_data',
                                                  doc, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue.textContent);
            if (message) {
              var id = message.comment_author_email + message.comment_content;
              if (localStorage.getItem(id))
                return;

              localStorage.setItem(id, true);

              Unity.Notification.showNotification(message.comment_author_email, message.comment_content, null);
            }
	  });
        }, 5000);
      }

      Unity.init({ name: '<?php $blog_title = get_bloginfo(); if (!$blog_title) $blog_title = "Wordpress"; echo $blog_title;?>',
                   iconUrl: 'http://s.wp.com/wp-content/themes/h4/i/logo-v-rgb.png?m=1308937829g',
                   homepage: '<?php echo get_bloginfo('siteurl');?>',
                   onInit: messagingIndicatorSetup });
    }
  </script>
<?php
}

?>