function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._login = browser.getLogin();
        this._password = browser.getPassword();
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function (uri) {
        if (!this._login) {
            this._browser.skipTest();
        }
        if (this._state === 0) {
            this._browser.injectScript(makeAuthorizer('Email', 'Passwd', this._login, this._password));
        } else if (uri.match(/^https?:\/\/mail.google.com/)) {
            setTimeout(this._browser.finish.bind(this._browser), 20000);
        }
        this._state++;
    },

    validateCallLog: function (log, out) {
        assertEquals('Unity.init', log[0].func, 'Unity.init');
        assertEquals('GMail', log[0].args[0].name, 'GMail');
        assertEquals('Unity.Launcher.addAction', log[2].func, 'Unity.Launcher.addAction');
        assertEquals('Unity.MessagingIndicator.addAction', log[1].func, 'Unity.MessagingIndicator.addAction');
        assertEquals('Unity.MessagingIndicator.clearIndicators', log[3].func, 'Unity.MessagingIndicator.clearIndicators');
        assertFalse('log.length', log.length < 20);

        var found = false, i;
        for (i = 0; i < out.length; i++) {
            if (out[i] === 'PASS SELF TEST') {
                found = true;
            }
        }
        assertTrue('PASS SELF TEST', found);
    },

    scriptName: 'GMail/GMail.user.js'
};
