/* Generated by re2c 0.13.5 on Mon Dec 20 18:44:30 2010 */
/*
 * Copyright (C) 2009 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// Generate js file as follows:
//
// re2c -isc WebCore/inspector/front-end/SourceCSSTokenizer.re2js \
// | sed 's|^yy\([^:]*\)*\:|case \1:|' \
// | sed 's|[*]cursor[+][+]|this._charAt(cursor++)|' \
// | sed 's|[[*][+][+]cursor|this._charAt(++cursor)|' \
// | sed 's|[*]cursor|this._charAt(cursor)|' \
// | sed 's|yych = \*\([^;]*\)|yych = this._charAt\1|' \
// | sed 's|{ gotoCase = \([^; continue; };]*\)|{ gotoCase = \1; continue; }|' \
// | sed 's|unsigned\ int|var|' \
// | sed 's|var\ yych|case 1: case 1: var yych|'

WebInspector.SourceCSSTokenizer = function()
{
    WebInspector.SourceTokenizer.call(this);

    this._propertyKeywords = WebInspector.cssNameCompletions.keySet();

    this._valueKeywords = [
        "above", "absolute", "activeborder", "activecaption", "afar", "after-white-space", "ahead", "alias", "all", "all-scroll",
        "alternate", "always","amharic", "amharic-abegede", "antialiased", "appworkspace", "aqua", "arabic-indic", "armenian", "asterisks",
        "auto", "avoid", "background", "backwards", "baseline", "below", "bidi-override", "binary", "bengali", "black", "blink",
        "block", "block-axis", "blue", "bold", "bolder", "border", "border-box", "both", "bottom", "break-all", "break-word", "button",
        "button-bevel", "buttonface", "buttonhighlight", "buttonshadow", "buttontext", "cambodian", "capitalize", "caps-lock-indicator",
        "caption", "captiontext", "caret", "cell", "center", "checkbox", "circle", "cjk-earthly-branch", "cjk-heavenly-stem", "cjk-ideographic",
        "clear", "clip", "close-quote", "col-resize", "collapse", "compact", "condensed", "contain", "content", "content-box", "context-menu",
        "continuous", "copy", "cover", "crop", "cross", "crosshair", "currentcolor", "cursive", "dashed", "decimal", "decimal-leading-zero", "default",
        "default-button", "destination-atop", "destination-in", "destination-out", "destination-over", "devanagari", "disc", "discard", "document",
        "dot-dash", "dot-dot-dash", "dotted", "double", "down", "e-resize", "ease", "ease-in", "ease-in-out", "ease-out", "element",
        "ellipsis", "embed", "end", "ethiopic", "ethiopic-abegede", "ethiopic-abegede-am-et", "ethiopic-abegede-gez",
        "ethiopic-abegede-ti-er", "ethiopic-abegede-ti-et", "ethiopic-halehame-aa-er", "ethiopic-halehame-aa-et",
        "ethiopic-halehame-am-et", "ethiopic-halehame-gez", "ethiopic-halehame-om-et", "ethiopic-halehame-sid-et",
        "ethiopic-halehame-so-et", "ethiopic-halehame-ti-er", "ethiopic-halehame-ti-et", "ethiopic-halehame-tig", "ew-resize", "expanded",
        "extra-condensed", "extra-expanded", "fantasy", "fast", "fill", "fixed", "flat", "footnotes", "forwards", "from", "fuchsia", "geometricPrecision",
        "georgian", "gray", "graytext", "green", "grey", "groove", "gujarati", "gurmukhi", "hand", "hangul", "hangul-consonant", "hebrew", "help",
        "hidden", "hide", "higher", "highlight", "highlighttext", "hiragana", "hiragana-iroha", "horizontal", "hsl", "hsla", "icon", "ignore",
        "inactiveborder", "inactivecaption", "inactivecaptiontext", "infinite", "infobackground", "infotext", "inherit", "initial", "inline",
        "inline-axis", "inline-block", "inline-table", "inset", "inside", "intrinsic", "invert", "italic", "justify", "kannada", "katakana",
        "katakana-iroha", "khmer", "landscape", "lao", "large", "larger", "left", "level", "lighter", "lime", "line-through", "linear", "lines",
        "list-button", "list-item", "listbox", "listitem", "local", "logical", "loud", "lower", "lower-alpha", "lower-armenian", "lower-greek",
        "lower-hexadecimal", "lower-latin", "lower-norwegian", "lower-roman", "lowercase", "ltr", "malayalam", "maroon", "match", "media-controls-background",
        "media-current-time-display", "media-fullscreen-button", "media-mute-button", "media-play-button", "media-return-to-realtime-button",
        "media-rewind-button", "media-seek-back-button", "media-seek-forward-button", "media-slider", "media-sliderthumb", "media-time-remaining-display",
        "media-volume-slider", "media-volume-slider-container", "media-volume-sliderthumb", "medium", "menu", "menulist", "menulist-button",
        "menulist-text", "menulist-textfield", "menutext", "message-box", "middle", "min-intrinsic", "mix", "mongolian", "monospace", "move", "multiple",
        "myanmar", "n-resize", "narrower", "navy", "ne-resize", "nesw-resize", "no-close-quote", "no-drop", "no-open-quote", "no-repeat", "none",
        "normal", "not-allowed", "nowrap", "ns-resize", "nw-resize", "nwse-resize", "oblique", "octal", "olive", "open-quote", "optimizeLegibility",
        "optimizeSpeed", "orange", "oriya", "oromo", "outset", "outside", "overlay", "overline", "padding", "padding-box", "painted", "paused",
        "persian", "plus-darker", "plus-lighter", "pointer", "portrait", "pre", "pre-line", "pre-wrap", "preserve-3d", "progress", "purple",
        "push-button", "radio", "read-only", "read-write", "read-write-plaintext-only", "red", "relative", "repeat", "repeat-x",
        "repeat-y", "reset", "reverse", "rgb", "rgba", "ridge", "right", "round", "row-resize", "rtl", "run-in", "running", "s-resize", "sans-serif",
        "scroll", "scrollbar", "se-resize", "searchfield", "searchfield-cancel-button", "searchfield-decoration", "searchfield-results-button",
        "searchfield-results-decoration", "semi-condensed", "semi-expanded", "separate", "serif", "show", "sidama", "silver", "single",
        "skip-white-space", "slide", "slider-horizontal", "slider-vertical", "sliderthumb-horizontal", "sliderthumb-vertical", "slow",
        "small", "small-caps", "small-caption", "smaller", "solid", "somali", "source-atop", "source-in", "source-out", "source-over",
        "space", "square", "square-button", "start", "static", "status-bar", "stretch", "stroke", "sub", "subpixel-antialiased", "super",
        "sw-resize", "table", "table-caption", "table-cell", "table-column", "table-column-group", "table-footer-group", "table-header-group",
        "table-row", "table-row-group", "teal", "telugu", "text", "text-bottom", "text-top", "textarea", "textfield", "thai", "thick", "thin",
        "threeddarkshadow", "threedface", "threedhighlight", "threedlightshadow", "threedshadow", "tibetan", "tigre", "tigrinya-er", "tigrinya-er-abegede",
        "tigrinya-et", "tigrinya-et-abegede", "to", "top", "transparent", "ultra-condensed", "ultra-expanded", "underline", "up", "upper-alpha", "upper-armenian",
        "upper-greek", "upper-hexadecimal", "upper-latin", "upper-norwegian", "upper-roman", "uppercase", "urdu", "url", "vertical", "vertical-text", "visible",
        "visibleFill", "visiblePainted", "visibleStroke", "visual", "w-resize", "wait", "wave", "white", "wider", "window", "windowframe", "windowtext",
        "x-large", "x-small", "xor", "xx-large", "xx-small", "yellow", "-wap-marquee", "-webkit-activelink", "-webkit-auto", "-webkit-baseline-middle",
        "-webkit-body", "-webkit-box", "-webkit-center", "-webkit-control", "-webkit-focus-ring-color", "-webkit-grab", "-webkit-grabbing",
        "-webkit-gradient", "-webkit-inline-box", "-webkit-left", "-webkit-link", "-webkit-marquee", "-webkit-mini-control", "-webkit-nowrap", "-webkit-right",
        "-webkit-small-control", "-webkit-text", "-webkit-xxx-large", "-webkit-zoom-in", "-webkit-zoom-out",
    ].keySet();

    this._mediaTypes = ["all", "aural", "braille", "embossed", "handheld", "import", "print", "projection", "screen", "tty", "tv"].keySet();

    this._lexConditions = {
        INITIAL: 0,
        COMMENT: 1,
        DSTRING: 2,
        SSTRING: 3
    };

    this._parseConditions = {
        INITIAL: 0,
        PROPERTY: 1,
        PROPERTY_VALUE: 2,
        AT_RULE: 3
    };

    this.case_INITIAL = 1000;
    this.case_COMMENT = 1002;
    this.case_DSTRING = 1003;
    this.case_SSTRING = 1004;

    this.initialCondition = { lexCondition: this._lexConditions.INITIAL, parseCondition: this._parseConditions.INITIAL }
}

WebInspector.SourceCSSTokenizer.prototype = {
    _stringToken: function(cursor, stringEnds)
    {
        if (this._isPropertyValue())
            this.tokenType = "css-string";
        else
            this.tokenType = null;
        return cursor;
    },

    _isPropertyValue: function()
    {
        return this._condition.parseCondition === this._parseConditions.PROPERTY_VALUE || this._condition.parseCondition === this._parseConditions.AT_RULE;
    },

    nextToken: function(cursor)
    {
        var cursorOnEnter = cursor;
        var gotoCase = 1;
        while (1) {
            switch (gotoCase)
            // Following comment is replaced with generated state machine.
            
        {
            case 1: var yych;
            var yyaccept = 0;
            if (this.getLexCondition() < 2) {
                if (this.getLexCondition() < 1) {
                    { gotoCase = this.case_INITIAL; continue; };
                } else {
                    { gotoCase = this.case_COMMENT; continue; };
                }
            } else {
                if (this.getLexCondition() < 3) {
                    { gotoCase = this.case_DSTRING; continue; };
                } else {
                    { gotoCase = this.case_SSTRING; continue; };
                }
            }
/* *********************************** */
case this.case_COMMENT:

            yych = this._charAt(cursor);
            if (yych <= '\f') {
                if (yych == '\n') { gotoCase = 4; continue; };
                { gotoCase = 3; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 4; continue; };
                if (yych == '*') { gotoCase = 6; continue; };
                { gotoCase = 3; continue; };
            }
case 2:
            { this.tokenType = "css-comment"; return cursor; }
case 3:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            { gotoCase = 12; continue; };
case 4:
            ++cursor;
            { this.tokenType = null; return cursor; }
case 6:
            yyaccept = 1;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych == '*') { gotoCase = 9; continue; };
            if (yych != '/') { gotoCase = 11; continue; };
case 7:
            ++cursor;
            this.setLexCondition(this._lexConditions.INITIAL);
            { this.tokenType = "css-comment"; return cursor; }
case 9:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '*') { gotoCase = 9; continue; };
            if (yych == '/') { gotoCase = 7; continue; };
case 11:
            yyaccept = 0;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
case 12:
            if (yych <= '\f') {
                if (yych == '\n') { gotoCase = 2; continue; };
                { gotoCase = 11; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 2; continue; };
                if (yych == '*') { gotoCase = 9; continue; };
                { gotoCase = 11; continue; };
            }
/* *********************************** */
case this.case_DSTRING:
            yych = this._charAt(cursor);
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 17; continue; };
                if (yych <= '\f') { gotoCase = 16; continue; };
                { gotoCase = 17; continue; };
            } else {
                if (yych <= '"') {
                    if (yych <= '!') { gotoCase = 16; continue; };
                    { gotoCase = 19; continue; };
                } else {
                    if (yych == '\\') { gotoCase = 21; continue; };
                    { gotoCase = 16; continue; };
                }
            }
case 15:
            { return this._stringToken(cursor); }
case 16:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            { gotoCase = 23; continue; };
case 17:
            ++cursor;
case 18:
            { this.tokenType = null; return cursor; }
case 19:
            ++cursor;
case 20:
            this.setLexCondition(this._lexConditions.INITIAL);
            { return this._stringToken(cursor, true); }
case 21:
            yych = this._charAt(++cursor);
            if (yych <= 'e') {
                if (yych <= '\'') {
                    if (yych == '"') { gotoCase = 22; continue; };
                    if (yych <= '&') { gotoCase = 18; continue; };
                } else {
                    if (yych <= '\\') {
                        if (yych <= '[') { gotoCase = 18; continue; };
                    } else {
                        if (yych != 'b') { gotoCase = 18; continue; };
                    }
                }
            } else {
                if (yych <= 'r') {
                    if (yych <= 'm') {
                        if (yych >= 'g') { gotoCase = 18; continue; };
                    } else {
                        if (yych <= 'n') { gotoCase = 22; continue; };
                        if (yych <= 'q') { gotoCase = 18; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych <= 's') { gotoCase = 18; continue; };
                    } else {
                        if (yych != 'v') { gotoCase = 18; continue; };
                    }
                }
            }
case 22:
            yyaccept = 0;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
case 23:
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 15; continue; };
                if (yych <= '\f') { gotoCase = 22; continue; };
                { gotoCase = 15; continue; };
            } else {
                if (yych <= '"') {
                    if (yych <= '!') { gotoCase = 22; continue; };
                    { gotoCase = 26; continue; };
                } else {
                    if (yych != '\\') { gotoCase = 22; continue; };
                }
            }
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'e') {
                if (yych <= '\'') {
                    if (yych == '"') { gotoCase = 22; continue; };
                    if (yych >= '\'') { gotoCase = 22; continue; };
                } else {
                    if (yych <= '\\') {
                        if (yych >= '\\') { gotoCase = 22; continue; };
                    } else {
                        if (yych == 'b') { gotoCase = 22; continue; };
                    }
                }
            } else {
                if (yych <= 'r') {
                    if (yych <= 'm') {
                        if (yych <= 'f') { gotoCase = 22; continue; };
                    } else {
                        if (yych <= 'n') { gotoCase = 22; continue; };
                        if (yych >= 'r') { gotoCase = 22; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych >= 't') { gotoCase = 22; continue; };
                    } else {
                        if (yych == 'v') { gotoCase = 22; continue; };
                    }
                }
            }
            cursor = YYMARKER;
            { gotoCase = 15; continue; };
case 26:
            ++cursor;
            yych = this._charAt(cursor);
            { gotoCase = 20; continue; };
/* *********************************** */
case this.case_INITIAL:
            yych = this._charAt(cursor);
            if (yych <= ';') {
                if (yych <= '\'') {
                    if (yych <= '"') {
                        if (yych <= ' ') { gotoCase = 29; continue; };
                        if (yych <= '!') { gotoCase = 31; continue; };
                        { gotoCase = 33; continue; };
                    } else {
                        if (yych == '$') { gotoCase = 31; continue; };
                        if (yych >= '\'') { gotoCase = 34; continue; };
                    }
                } else {
                    if (yych <= '.') {
                        if (yych <= ',') { gotoCase = 29; continue; };
                        if (yych <= '-') { gotoCase = 35; continue; };
                        { gotoCase = 36; continue; };
                    } else {
                        if (yych <= '/') { gotoCase = 37; continue; };
                        if (yych <= '9') { gotoCase = 38; continue; };
                        if (yych <= ':') { gotoCase = 40; continue; };
                        { gotoCase = 42; continue; };
                    }
                }
            } else {
                if (yych <= '^') {
                    if (yych <= '?') {
                        if (yych == '=') { gotoCase = 31; continue; };
                    } else {
                        if (yych == '\\') { gotoCase = 29; continue; };
                        if (yych <= ']') { gotoCase = 31; continue; };
                    }
                } else {
                    if (yych <= 'z') {
                        if (yych != '`') { gotoCase = 31; continue; };
                    } else {
                        if (yych <= '{') { gotoCase = 44; continue; };
                        if (yych == '}') { gotoCase = 46; continue; };
                    }
                }
            }
case 29:
            ++cursor;
case 30:
            { this.tokenType = null; return cursor; }
case 31:
            ++cursor;
            yych = this._charAt(cursor);
            { gotoCase = 49; continue; };
case 32:
            {
                    var token = this._line.substring(cursorOnEnter, cursor);
                    if (this._condition.parseCondition === this._parseConditions.INITIAL) {
                        if (token === "@import" || token === "@media") {
                            this.tokenType = "css-at-rule";
                            this._condition.parseCondition = this._parseConditions.AT_RULE;
                        } else if (token.indexOf("@") === 0)
                            this.tokenType = "css-at-rule";
                        else
                            this.tokenType = "css-selector";
                    }
                    else if (this._condition.parseCondition === this._parseConditions.AT_RULE && token in this._mediaTypes)
                        this.tokenType = "css-keyword";
                    else if (this._condition.parseCondition === this._parseConditions.PROPERTY && token in this._propertyKeywords)
                        this.tokenType = "css-property";
                    else if (this._isPropertyValue() && token in this._valueKeywords)
                        this.tokenType = "css-keyword";
                    else if (token === "!important")
                        this.tokenType = "css-important";
                    else
                        this.tokenType = null;
                    return cursor;
                }
case 33:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych <= '-') {
                if (yych <= '!') {
                    if (yych <= '\f') {
                        if (yych == '\n') { gotoCase = 32; continue; };
                        { gotoCase = 124; continue; };
                    } else {
                        if (yych <= '\r') { gotoCase = 32; continue; };
                        if (yych <= ' ') { gotoCase = 124; continue; };
                        { gotoCase = 122; continue; };
                    }
                } else {
                    if (yych <= '$') {
                        if (yych <= '"') { gotoCase = 114; continue; };
                        if (yych <= '#') { gotoCase = 124; continue; };
                        { gotoCase = 122; continue; };
                    } else {
                        if (yych == '\'') { gotoCase = 122; continue; };
                        if (yych <= ',') { gotoCase = 124; continue; };
                        { gotoCase = 122; continue; };
                    }
                }
            } else {
                if (yych <= '[') {
                    if (yych <= '<') {
                        if (yych <= '.') { gotoCase = 124; continue; };
                        if (yych <= '9') { gotoCase = 122; continue; };
                        { gotoCase = 124; continue; };
                    } else {
                        if (yych <= '=') { gotoCase = 122; continue; };
                        if (yych <= '?') { gotoCase = 124; continue; };
                        { gotoCase = 122; continue; };
                    }
                } else {
                    if (yych <= '^') {
                        if (yych <= '\\') { gotoCase = 126; continue; };
                        if (yych <= ']') { gotoCase = 122; continue; };
                        { gotoCase = 124; continue; };
                    } else {
                        if (yych == '`') { gotoCase = 124; continue; };
                        if (yych <= 'z') { gotoCase = 122; continue; };
                        { gotoCase = 124; continue; };
                    }
                }
            }
case 34:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych <= '-') {
                if (yych <= '"') {
                    if (yych <= '\f') {
                        if (yych == '\n') { gotoCase = 32; continue; };
                        { gotoCase = 116; continue; };
                    } else {
                        if (yych <= '\r') { gotoCase = 32; continue; };
                        if (yych <= ' ') { gotoCase = 116; continue; };
                        { gotoCase = 112; continue; };
                    }
                } else {
                    if (yych <= '&') {
                        if (yych == '$') { gotoCase = 112; continue; };
                        { gotoCase = 116; continue; };
                    } else {
                        if (yych <= '\'') { gotoCase = 114; continue; };
                        if (yych <= ',') { gotoCase = 116; continue; };
                        { gotoCase = 112; continue; };
                    }
                }
            } else {
                if (yych <= '[') {
                    if (yych <= '<') {
                        if (yych <= '.') { gotoCase = 116; continue; };
                        if (yych <= '9') { gotoCase = 112; continue; };
                        { gotoCase = 116; continue; };
                    } else {
                        if (yych <= '=') { gotoCase = 112; continue; };
                        if (yych <= '?') { gotoCase = 116; continue; };
                        { gotoCase = 112; continue; };
                    }
                } else {
                    if (yych <= '^') {
                        if (yych <= '\\') { gotoCase = 118; continue; };
                        if (yych <= ']') { gotoCase = 112; continue; };
                        { gotoCase = 116; continue; };
                    } else {
                        if (yych == '`') { gotoCase = 116; continue; };
                        if (yych <= 'z') { gotoCase = 112; continue; };
                        { gotoCase = 116; continue; };
                    }
                }
            }
case 35:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych == '.') { gotoCase = 65; continue; };
            if (yych <= '/') { gotoCase = 49; continue; };
            if (yych <= '9') { gotoCase = 50; continue; };
            { gotoCase = 49; continue; };
case 36:
            yych = this._charAt(++cursor);
            if (yych <= '/') { gotoCase = 30; continue; };
            if (yych <= '9') { gotoCase = 68; continue; };
            { gotoCase = 30; continue; };
case 37:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych == '*') { gotoCase = 104; continue; };
            { gotoCase = 49; continue; };
case 38:
            yyaccept = 1;
            yych = this._charAt(YYMARKER = ++cursor);
            switch (yych) {
            case '!':
            case '"':
            case '$':
            case '\'':
            case '-':
            case '/':
            case '=':
            case '@':
            case 'A':
            case 'B':
            case 'C':
            case 'D':
            case 'E':
            case 'F':
            case 'G':
            case 'I':
            case 'J':
            case 'K':
            case 'L':
            case 'M':
            case 'N':
            case 'O':
            case 'P':
            case 'Q':
            case 'R':
            case 'S':
            case 'T':
            case 'U':
            case 'V':
            case 'W':
            case 'X':
            case 'Y':
            case 'Z':
            case '[':
            case ']':
            case 'a':
            case 'b':
            case 'f':
            case 'h':
            case 'j':
            case 'l':
            case 'n':
            case 'o':
            case 'q':
            case 'u':
            case 'v':
            case 'w':
            case 'x':
            case 'y':
            case 'z':    { gotoCase = 48; continue; };
            case '%':    { gotoCase = 67; continue; };
            case '.':    { gotoCase = 65; continue; };
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':    { gotoCase = 50; continue; };
            case 'H':    { gotoCase = 52; continue; };
            case '_':    { gotoCase = 53; continue; };
            case 'c':    { gotoCase = 54; continue; };
            case 'd':    { gotoCase = 55; continue; };
            case 'e':    { gotoCase = 56; continue; };
            case 'g':    { gotoCase = 57; continue; };
            case 'i':    { gotoCase = 58; continue; };
            case 'k':    { gotoCase = 59; continue; };
            case 'm':    { gotoCase = 60; continue; };
            case 'p':    { gotoCase = 61; continue; };
            case 'r':    { gotoCase = 62; continue; };
            case 's':    { gotoCase = 63; continue; };
            case 't':    { gotoCase = 64; continue; };
            default:    { gotoCase = 39; continue; };
            }
case 39:
            {
                    if (this._isPropertyValue())
                        this.tokenType = "css-number";
                    else
                        this.tokenType = null;
                    return cursor;
                }
case 40:
            ++cursor;
            {
                    this.tokenType = null;
                    if (this._condition.parseCondition === this._parseConditions.PROPERTY)
                        this._condition.parseCondition = this._parseConditions.PROPERTY_VALUE;
                    return cursor;
                }
case 42:
            ++cursor;
            {
                    this.tokenType = null;
                    if (this._condition.parseCondition === this._parseConditions.AT_RULE)
                        this._condition.parseCondition = this._parseConditions.INITIAL;
                    else
                        this._condition.parseCondition = this._parseConditions.PROPERTY;
                    return cursor;
                }
case 44:
            ++cursor;
            {
                    this.tokenType = null;
                    if (this._condition.parseCondition === this._parseConditions.AT_RULE)
                        this._condition.parseCondition = this._parseConditions.INITIAL;
                    else
                        this._condition.parseCondition = this._parseConditions.PROPERTY;
                    return cursor;
                }
case 46:
            ++cursor;
            {
                    this.tokenType = null;
                    this._condition.parseCondition = this._parseConditions.INITIAL;
                    return cursor;
                }
case 48:
            ++cursor;
            yych = this._charAt(cursor);
case 49:
            if (yych <= '9') {
                if (yych <= '&') {
                    if (yych <= '"') {
                        if (yych <= ' ') { gotoCase = 32; continue; };
                        { gotoCase = 48; continue; };
                    } else {
                        if (yych == '$') { gotoCase = 48; continue; };
                        { gotoCase = 32; continue; };
                    }
                } else {
                    if (yych <= ',') {
                        if (yych <= '\'') { gotoCase = 48; continue; };
                        { gotoCase = 32; continue; };
                    } else {
                        if (yych == '.') { gotoCase = 32; continue; };
                        { gotoCase = 48; continue; };
                    }
                }
            } else {
                if (yych <= '\\') {
                    if (yych <= '=') {
                        if (yych <= '<') { gotoCase = 32; continue; };
                        { gotoCase = 48; continue; };
                    } else {
                        if (yych <= '?') { gotoCase = 32; continue; };
                        if (yych <= '[') { gotoCase = 48; continue; };
                        { gotoCase = 32; continue; };
                    }
                } else {
                    if (yych <= '_') {
                        if (yych == '^') { gotoCase = 32; continue; };
                        { gotoCase = 48; continue; };
                    } else {
                        if (yych <= '`') { gotoCase = 32; continue; };
                        if (yych <= 'z') { gotoCase = 48; continue; };
                        { gotoCase = 32; continue; };
                    }
                }
            }
case 50:
            yyaccept = 1;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            switch (yych) {
            case '!':
            case '"':
            case '$':
            case '\'':
            case '-':
            case '/':
            case '=':
            case '@':
            case 'A':
            case 'B':
            case 'C':
            case 'D':
            case 'E':
            case 'F':
            case 'G':
            case 'I':
            case 'J':
            case 'K':
            case 'L':
            case 'M':
            case 'N':
            case 'O':
            case 'P':
            case 'Q':
            case 'R':
            case 'S':
            case 'T':
            case 'U':
            case 'V':
            case 'W':
            case 'X':
            case 'Y':
            case 'Z':
            case '[':
            case ']':
            case 'a':
            case 'b':
            case 'f':
            case 'h':
            case 'j':
            case 'l':
            case 'n':
            case 'o':
            case 'q':
            case 'u':
            case 'v':
            case 'w':
            case 'x':
            case 'y':
            case 'z':    { gotoCase = 48; continue; };
            case '%':    { gotoCase = 67; continue; };
            case '.':    { gotoCase = 65; continue; };
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':    { gotoCase = 50; continue; };
            case 'H':    { gotoCase = 52; continue; };
            case '_':    { gotoCase = 53; continue; };
            case 'c':    { gotoCase = 54; continue; };
            case 'd':    { gotoCase = 55; continue; };
            case 'e':    { gotoCase = 56; continue; };
            case 'g':    { gotoCase = 57; continue; };
            case 'i':    { gotoCase = 58; continue; };
            case 'k':    { gotoCase = 59; continue; };
            case 'm':    { gotoCase = 60; continue; };
            case 'p':    { gotoCase = 61; continue; };
            case 'r':    { gotoCase = 62; continue; };
            case 's':    { gotoCase = 63; continue; };
            case 't':    { gotoCase = 64; continue; };
            default:    { gotoCase = 39; continue; };
            }
case 52:
            yych = this._charAt(++cursor);
            if (yych == 'z') { gotoCase = 63; continue; };
            { gotoCase = 49; continue; };
case 53:
            yych = this._charAt(++cursor);
            if (yych == '_') { gotoCase = 101; continue; };
            { gotoCase = 49; continue; };
case 54:
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 63; continue; };
            { gotoCase = 49; continue; };
case 55:
            yych = this._charAt(++cursor);
            if (yych == 'e') { gotoCase = 100; continue; };
            { gotoCase = 49; continue; };
case 56:
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 63; continue; };
            if (yych == 'x') { gotoCase = 63; continue; };
            { gotoCase = 49; continue; };
case 57:
            yych = this._charAt(++cursor);
            if (yych == 'r') { gotoCase = 98; continue; };
            { gotoCase = 49; continue; };
case 58:
            yych = this._charAt(++cursor);
            if (yych == 'n') { gotoCase = 63; continue; };
            { gotoCase = 49; continue; };
case 59:
            yych = this._charAt(++cursor);
            if (yych == 'H') { gotoCase = 97; continue; };
            { gotoCase = 49; continue; };
case 60:
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 63; continue; };
            if (yych == 's') { gotoCase = 63; continue; };
            { gotoCase = 49; continue; };
case 61:
            yych = this._charAt(++cursor);
            if (yych <= 's') {
                if (yych == 'c') { gotoCase = 63; continue; };
                { gotoCase = 49; continue; };
            } else {
                if (yych <= 't') { gotoCase = 63; continue; };
                if (yych == 'x') { gotoCase = 63; continue; };
                { gotoCase = 49; continue; };
            }
case 62:
            yych = this._charAt(++cursor);
            if (yych == 'a') { gotoCase = 95; continue; };
            if (yych == 'e') { gotoCase = 96; continue; };
            { gotoCase = 49; continue; };
case 63:
            yych = this._charAt(++cursor);
            if (yych <= '9') {
                if (yych <= '&') {
                    if (yych <= '"') {
                        if (yych <= ' ') { gotoCase = 39; continue; };
                        { gotoCase = 48; continue; };
                    } else {
                        if (yych == '$') { gotoCase = 48; continue; };
                        { gotoCase = 39; continue; };
                    }
                } else {
                    if (yych <= ',') {
                        if (yych <= '\'') { gotoCase = 48; continue; };
                        { gotoCase = 39; continue; };
                    } else {
                        if (yych == '.') { gotoCase = 39; continue; };
                        { gotoCase = 48; continue; };
                    }
                }
            } else {
                if (yych <= '\\') {
                    if (yych <= '=') {
                        if (yych <= '<') { gotoCase = 39; continue; };
                        { gotoCase = 48; continue; };
                    } else {
                        if (yych <= '?') { gotoCase = 39; continue; };
                        if (yych <= '[') { gotoCase = 48; continue; };
                        { gotoCase = 39; continue; };
                    }
                } else {
                    if (yych <= '_') {
                        if (yych == '^') { gotoCase = 39; continue; };
                        { gotoCase = 48; continue; };
                    } else {
                        if (yych <= '`') { gotoCase = 39; continue; };
                        if (yych <= 'z') { gotoCase = 48; continue; };
                        { gotoCase = 39; continue; };
                    }
                }
            }
case 64:
            yych = this._charAt(++cursor);
            if (yych == 'u') { gotoCase = 93; continue; };
            { gotoCase = 49; continue; };
case 65:
            yych = this._charAt(++cursor);
            if (yych <= '/') { gotoCase = 66; continue; };
            if (yych <= '9') { gotoCase = 68; continue; };
case 66:
            cursor = YYMARKER;
            if (yyaccept <= 0) {
                { gotoCase = 32; continue; };
            } else {
                { gotoCase = 39; continue; };
            }
case 67:
            yych = this._charAt(++cursor);
            { gotoCase = 39; continue; };
case 68:
            yyaccept = 1;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'f') {
                if (yych <= 'H') {
                    if (yych <= '/') {
                        if (yych == '%') { gotoCase = 67; continue; };
                        { gotoCase = 39; continue; };
                    } else {
                        if (yych <= '9') { gotoCase = 68; continue; };
                        if (yych <= 'G') { gotoCase = 39; continue; };
                        { gotoCase = 80; continue; };
                    }
                } else {
                    if (yych <= 'b') {
                        if (yych == '_') { gotoCase = 72; continue; };
                        { gotoCase = 39; continue; };
                    } else {
                        if (yych <= 'c') { gotoCase = 74; continue; };
                        if (yych <= 'd') { gotoCase = 77; continue; };
                        if (yych >= 'f') { gotoCase = 39; continue; };
                    }
                }
            } else {
                if (yych <= 'm') {
                    if (yych <= 'i') {
                        if (yych <= 'g') { gotoCase = 78; continue; };
                        if (yych <= 'h') { gotoCase = 39; continue; };
                        { gotoCase = 76; continue; };
                    } else {
                        if (yych == 'k') { gotoCase = 81; continue; };
                        if (yych <= 'l') { gotoCase = 39; continue; };
                        { gotoCase = 75; continue; };
                    }
                } else {
                    if (yych <= 'q') {
                        if (yych == 'p') { gotoCase = 73; continue; };
                        { gotoCase = 39; continue; };
                    } else {
                        if (yych <= 'r') { gotoCase = 71; continue; };
                        if (yych <= 's') { gotoCase = 67; continue; };
                        if (yych <= 't') { gotoCase = 79; continue; };
                        { gotoCase = 39; continue; };
                    }
                }
            }
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 67; continue; };
            if (yych == 'x') { gotoCase = 67; continue; };
            { gotoCase = 66; continue; };
case 71:
            yych = this._charAt(++cursor);
            if (yych == 'a') { gotoCase = 91; continue; };
            if (yych == 'e') { gotoCase = 92; continue; };
            { gotoCase = 66; continue; };
case 72:
            yych = this._charAt(++cursor);
            if (yych == '_') { gotoCase = 88; continue; };
            { gotoCase = 66; continue; };
case 73:
            yych = this._charAt(++cursor);
            if (yych <= 's') {
                if (yych == 'c') { gotoCase = 67; continue; };
                { gotoCase = 66; continue; };
            } else {
                if (yych <= 't') { gotoCase = 67; continue; };
                if (yych == 'x') { gotoCase = 67; continue; };
                { gotoCase = 66; continue; };
            }
case 74:
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 67; continue; };
            { gotoCase = 66; continue; };
case 75:
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 67; continue; };
            if (yych == 's') { gotoCase = 67; continue; };
            { gotoCase = 66; continue; };
case 76:
            yych = this._charAt(++cursor);
            if (yych == 'n') { gotoCase = 67; continue; };
            { gotoCase = 66; continue; };
case 77:
            yych = this._charAt(++cursor);
            if (yych == 'e') { gotoCase = 87; continue; };
            { gotoCase = 66; continue; };
case 78:
            yych = this._charAt(++cursor);
            if (yych == 'r') { gotoCase = 85; continue; };
            { gotoCase = 66; continue; };
case 79:
            yych = this._charAt(++cursor);
            if (yych == 'u') { gotoCase = 83; continue; };
            { gotoCase = 66; continue; };
case 80:
            yych = this._charAt(++cursor);
            if (yych == 'z') { gotoCase = 67; continue; };
            { gotoCase = 66; continue; };
case 81:
            yych = this._charAt(++cursor);
            if (yych != 'H') { gotoCase = 66; continue; };
            yych = this._charAt(++cursor);
            if (yych == 'z') { gotoCase = 67; continue; };
            { gotoCase = 66; continue; };
case 83:
            yych = this._charAt(++cursor);
            if (yych != 'r') { gotoCase = 66; continue; };
            yych = this._charAt(++cursor);
            if (yych == 'n') { gotoCase = 67; continue; };
            { gotoCase = 66; continue; };
case 85:
            yych = this._charAt(++cursor);
            if (yych != 'a') { gotoCase = 66; continue; };
            yych = this._charAt(++cursor);
            if (yych == 'd') { gotoCase = 67; continue; };
            { gotoCase = 66; continue; };
case 87:
            yych = this._charAt(++cursor);
            if (yych == 'g') { gotoCase = 67; continue; };
            { gotoCase = 66; continue; };
case 88:
            yych = this._charAt(++cursor);
            if (yych != 'q') { gotoCase = 66; continue; };
            yych = this._charAt(++cursor);
            if (yych != 'e') { gotoCase = 66; continue; };
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 67; continue; };
            { gotoCase = 66; continue; };
case 91:
            yych = this._charAt(++cursor);
            if (yych == 'd') { gotoCase = 67; continue; };
            { gotoCase = 66; continue; };
case 92:
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 67; continue; };
            { gotoCase = 66; continue; };
case 93:
            yych = this._charAt(++cursor);
            if (yych != 'r') { gotoCase = 49; continue; };
            yych = this._charAt(++cursor);
            if (yych == 'n') { gotoCase = 63; continue; };
            { gotoCase = 49; continue; };
case 95:
            yych = this._charAt(++cursor);
            if (yych == 'd') { gotoCase = 63; continue; };
            { gotoCase = 49; continue; };
case 96:
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 63; continue; };
            { gotoCase = 49; continue; };
case 97:
            yych = this._charAt(++cursor);
            if (yych == 'z') { gotoCase = 63; continue; };
            { gotoCase = 49; continue; };
case 98:
            yych = this._charAt(++cursor);
            if (yych != 'a') { gotoCase = 49; continue; };
            yych = this._charAt(++cursor);
            if (yych == 'd') { gotoCase = 63; continue; };
            { gotoCase = 49; continue; };
case 100:
            yych = this._charAt(++cursor);
            if (yych == 'g') { gotoCase = 63; continue; };
            { gotoCase = 49; continue; };
case 101:
            yych = this._charAt(++cursor);
            if (yych != 'q') { gotoCase = 49; continue; };
            yych = this._charAt(++cursor);
            if (yych != 'e') { gotoCase = 49; continue; };
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 63; continue; };
            { gotoCase = 49; continue; };
case 104:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '\f') {
                if (yych == '\n') { gotoCase = 108; continue; };
                { gotoCase = 104; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 108; continue; };
                if (yych != '*') { gotoCase = 104; continue; };
            }
case 106:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '*') { gotoCase = 106; continue; };
            if (yych == '/') { gotoCase = 110; continue; };
            { gotoCase = 104; continue; };
case 108:
            ++cursor;
            this.setLexCondition(this._lexConditions.COMMENT);
            { this.tokenType = "css-comment"; return cursor; }
case 110:
            ++cursor;
            { this.tokenType = "css-comment"; return cursor; }
case 112:
            yyaccept = 0;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '-') {
                if (yych <= '"') {
                    if (yych <= '\f') {
                        if (yych == '\n') { gotoCase = 32; continue; };
                        { gotoCase = 116; continue; };
                    } else {
                        if (yych <= '\r') { gotoCase = 32; continue; };
                        if (yych <= ' ') { gotoCase = 116; continue; };
                        { gotoCase = 112; continue; };
                    }
                } else {
                    if (yych <= '&') {
                        if (yych == '$') { gotoCase = 112; continue; };
                        { gotoCase = 116; continue; };
                    } else {
                        if (yych <= '\'') { gotoCase = 114; continue; };
                        if (yych <= ',') { gotoCase = 116; continue; };
                        { gotoCase = 112; continue; };
                    }
                }
            } else {
                if (yych <= '[') {
                    if (yych <= '<') {
                        if (yych <= '.') { gotoCase = 116; continue; };
                        if (yych <= '9') { gotoCase = 112; continue; };
                        { gotoCase = 116; continue; };
                    } else {
                        if (yych <= '=') { gotoCase = 112; continue; };
                        if (yych <= '?') { gotoCase = 116; continue; };
                        { gotoCase = 112; continue; };
                    }
                } else {
                    if (yych <= '^') {
                        if (yych <= '\\') { gotoCase = 118; continue; };
                        if (yych <= ']') { gotoCase = 112; continue; };
                        { gotoCase = 116; continue; };
                    } else {
                        if (yych == '`') { gotoCase = 116; continue; };
                        if (yych <= 'z') { gotoCase = 112; continue; };
                        { gotoCase = 116; continue; };
                    }
                }
            }
case 114:
            ++cursor;
            if ((yych = this._charAt(cursor)) <= '9') {
                if (yych <= '&') {
                    if (yych <= '"') {
                        if (yych >= '!') { gotoCase = 48; continue; };
                    } else {
                        if (yych == '$') { gotoCase = 48; continue; };
                    }
                } else {
                    if (yych <= ',') {
                        if (yych <= '\'') { gotoCase = 48; continue; };
                    } else {
                        if (yych != '.') { gotoCase = 48; continue; };
                    }
                }
            } else {
                if (yych <= '\\') {
                    if (yych <= '=') {
                        if (yych >= '=') { gotoCase = 48; continue; };
                    } else {
                        if (yych <= '?') { gotoCase = 115; continue; };
                        if (yych <= '[') { gotoCase = 48; continue; };
                    }
                } else {
                    if (yych <= '_') {
                        if (yych != '^') { gotoCase = 48; continue; };
                    } else {
                        if (yych <= '`') { gotoCase = 115; continue; };
                        if (yych <= 'z') { gotoCase = 48; continue; };
                    }
                }
            }
case 115:
            { return this._stringToken(cursor, true); }
case 116:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 66; continue; };
                if (yych <= '\f') { gotoCase = 116; continue; };
                { gotoCase = 66; continue; };
            } else {
                if (yych <= '\'') {
                    if (yych <= '&') { gotoCase = 116; continue; };
                    { gotoCase = 121; continue; };
                } else {
                    if (yych != '\\') { gotoCase = 116; continue; };
                }
            }
case 118:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'a') {
                if (yych <= '!') {
                    if (yych <= '\n') {
                        if (yych <= '\t') { gotoCase = 66; continue; };
                    } else {
                        if (yych != '\r') { gotoCase = 66; continue; };
                    }
                } else {
                    if (yych <= '\'') {
                        if (yych <= '"') { gotoCase = 116; continue; };
                        if (yych <= '&') { gotoCase = 66; continue; };
                        { gotoCase = 116; continue; };
                    } else {
                        if (yych == '\\') { gotoCase = 116; continue; };
                        { gotoCase = 66; continue; };
                    }
                }
            } else {
                if (yych <= 'q') {
                    if (yych <= 'f') {
                        if (yych <= 'b') { gotoCase = 116; continue; };
                        if (yych <= 'e') { gotoCase = 66; continue; };
                        { gotoCase = 116; continue; };
                    } else {
                        if (yych == 'n') { gotoCase = 116; continue; };
                        { gotoCase = 66; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych == 's') { gotoCase = 66; continue; };
                        { gotoCase = 116; continue; };
                    } else {
                        if (yych == 'v') { gotoCase = 116; continue; };
                        { gotoCase = 66; continue; };
                    }
                }
            }
            ++cursor;
            this.setLexCondition(this._lexConditions.SSTRING);
            { return this._stringToken(cursor); }
case 121:
            yych = this._charAt(++cursor);
            { gotoCase = 115; continue; };
case 122:
            yyaccept = 0;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '-') {
                if (yych <= '!') {
                    if (yych <= '\f') {
                        if (yych == '\n') { gotoCase = 32; continue; };
                    } else {
                        if (yych <= '\r') { gotoCase = 32; continue; };
                        if (yych >= '!') { gotoCase = 122; continue; };
                    }
                } else {
                    if (yych <= '$') {
                        if (yych <= '"') { gotoCase = 114; continue; };
                        if (yych >= '$') { gotoCase = 122; continue; };
                    } else {
                        if (yych == '\'') { gotoCase = 122; continue; };
                        if (yych >= '-') { gotoCase = 122; continue; };
                    }
                }
            } else {
                if (yych <= '[') {
                    if (yych <= '<') {
                        if (yych <= '.') { gotoCase = 124; continue; };
                        if (yych <= '9') { gotoCase = 122; continue; };
                    } else {
                        if (yych <= '=') { gotoCase = 122; continue; };
                        if (yych >= '@') { gotoCase = 122; continue; };
                    }
                } else {
                    if (yych <= '^') {
                        if (yych <= '\\') { gotoCase = 126; continue; };
                        if (yych <= ']') { gotoCase = 122; continue; };
                    } else {
                        if (yych == '`') { gotoCase = 124; continue; };
                        if (yych <= 'z') { gotoCase = 122; continue; };
                    }
                }
            }
case 124:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 66; continue; };
                if (yych <= '\f') { gotoCase = 124; continue; };
                { gotoCase = 66; continue; };
            } else {
                if (yych <= '"') {
                    if (yych <= '!') { gotoCase = 124; continue; };
                    { gotoCase = 121; continue; };
                } else {
                    if (yych != '\\') { gotoCase = 124; continue; };
                }
            }
case 126:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'a') {
                if (yych <= '!') {
                    if (yych <= '\n') {
                        if (yych <= '\t') { gotoCase = 66; continue; };
                    } else {
                        if (yych != '\r') { gotoCase = 66; continue; };
                    }
                } else {
                    if (yych <= '\'') {
                        if (yych <= '"') { gotoCase = 124; continue; };
                        if (yych <= '&') { gotoCase = 66; continue; };
                        { gotoCase = 124; continue; };
                    } else {
                        if (yych == '\\') { gotoCase = 124; continue; };
                        { gotoCase = 66; continue; };
                    }
                }
            } else {
                if (yych <= 'q') {
                    if (yych <= 'f') {
                        if (yych <= 'b') { gotoCase = 124; continue; };
                        if (yych <= 'e') { gotoCase = 66; continue; };
                        { gotoCase = 124; continue; };
                    } else {
                        if (yych == 'n') { gotoCase = 124; continue; };
                        { gotoCase = 66; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych == 's') { gotoCase = 66; continue; };
                        { gotoCase = 124; continue; };
                    } else {
                        if (yych == 'v') { gotoCase = 124; continue; };
                        { gotoCase = 66; continue; };
                    }
                }
            }
            ++cursor;
            this.setLexCondition(this._lexConditions.DSTRING);
            { return this._stringToken(cursor); }
/* *********************************** */
case this.case_SSTRING:
            yych = this._charAt(cursor);
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 133; continue; };
                if (yych <= '\f') { gotoCase = 132; continue; };
                { gotoCase = 133; continue; };
            } else {
                if (yych <= '\'') {
                    if (yych <= '&') { gotoCase = 132; continue; };
                    { gotoCase = 135; continue; };
                } else {
                    if (yych == '\\') { gotoCase = 137; continue; };
                    { gotoCase = 132; continue; };
                }
            }
case 131:
            { return this._stringToken(cursor); }
case 132:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            { gotoCase = 139; continue; };
case 133:
            ++cursor;
case 134:
            { this.tokenType = null; return cursor; }
case 135:
            ++cursor;
case 136:
            this.setLexCondition(this._lexConditions.INITIAL);
            { return this._stringToken(cursor, true); }
case 137:
            yych = this._charAt(++cursor);
            if (yych <= 'e') {
                if (yych <= '\'') {
                    if (yych == '"') { gotoCase = 138; continue; };
                    if (yych <= '&') { gotoCase = 134; continue; };
                } else {
                    if (yych <= '\\') {
                        if (yych <= '[') { gotoCase = 134; continue; };
                    } else {
                        if (yych != 'b') { gotoCase = 134; continue; };
                    }
                }
            } else {
                if (yych <= 'r') {
                    if (yych <= 'm') {
                        if (yych >= 'g') { gotoCase = 134; continue; };
                    } else {
                        if (yych <= 'n') { gotoCase = 138; continue; };
                        if (yych <= 'q') { gotoCase = 134; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych <= 's') { gotoCase = 134; continue; };
                    } else {
                        if (yych != 'v') { gotoCase = 134; continue; };
                    }
                }
            }
case 138:
            yyaccept = 0;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
case 139:
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 131; continue; };
                if (yych <= '\f') { gotoCase = 138; continue; };
                { gotoCase = 131; continue; };
            } else {
                if (yych <= '\'') {
                    if (yych <= '&') { gotoCase = 138; continue; };
                    { gotoCase = 142; continue; };
                } else {
                    if (yych != '\\') { gotoCase = 138; continue; };
                }
            }
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'e') {
                if (yych <= '\'') {
                    if (yych == '"') { gotoCase = 138; continue; };
                    if (yych >= '\'') { gotoCase = 138; continue; };
                } else {
                    if (yych <= '\\') {
                        if (yych >= '\\') { gotoCase = 138; continue; };
                    } else {
                        if (yych == 'b') { gotoCase = 138; continue; };
                    }
                }
            } else {
                if (yych <= 'r') {
                    if (yych <= 'm') {
                        if (yych <= 'f') { gotoCase = 138; continue; };
                    } else {
                        if (yych <= 'n') { gotoCase = 138; continue; };
                        if (yych >= 'r') { gotoCase = 138; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych >= 't') { gotoCase = 138; continue; };
                    } else {
                        if (yych == 'v') { gotoCase = 138; continue; };
                    }
                }
            }
            cursor = YYMARKER;
            { gotoCase = 131; continue; };
case 142:
            ++cursor;
            yych = this._charAt(cursor);
            { gotoCase = 136; continue; };
        }

        }
    }
}

WebInspector.SourceCSSTokenizer.prototype.__proto__ = WebInspector.SourceTokenizer.prototype;
