/***************************************************************************
 *   Copyright (C) 2005 by Pawel Nawrocki                                  *
 *   pnawrocki@interia.pl                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "watools.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <dirent.h>

char* WATools::ifname = 0;
int WATools::iw_socket = -1;

char* WATools::ap( const char* _ifname ) ///returns current AP (for the specified interface). Request SIOCGIWAP
{
        if (_ifname==0)
                _ifname = ifname;
        static char buffer[64];
        if (iw_socket<0)
                iw_socket = iw_sockets_open(); //get kernel socket
        if (iw_socket<0)
                return 0;

        struct iwreq req;
        if( iw_get_ext(iw_socket, _ifname, SIOCGIWAP, &req) < 0 ) // try to get ap address.
                return 0; // no ap address

        iw_ether_ntop((const struct ether_addr *)req.u.ap_addr.sa_data, buffer);
        return buffer;
}

int WATools::quality( const char* _ifname ) ///returns active link quality in range 0-100 (for the specified interface)
{
        if (_ifname==0)
                _ifname = ifname;
        static unsigned int std_qual = 0;
        unsigned int has_range;
        iw_range range;
        iw_statistics stats;

        if (iw_socket<0)
                iw_socket = iw_sockets_open();//get kernel socket
        if (iw_socket<0)
                return 0;

        if ( iw_get_range_info(iw_socket, _ifname, &range) < 0 )
                has_range = 0;
        else
                has_range = 1;

        iw_get_stats(iw_socket, _ifname, &stats, &range, has_range);

        std_qual = (100*stats.qual.qual)/50; //calculate normalized quality (0-100). 50 is the best noise/signal difference
        if (std_qual > 100) std_qual = 100;

        return std_qual;
}

int WATools::txpower( const char* _ifname ) ///returns current txpower in mW (for the specified interface). Request SIOCGIWTXPOW
{
        if (_ifname==0)
                _ifname = ifname;
        if (iw_socket<0)
                iw_socket = iw_sockets_open();//get kernel socket
        if (iw_socket<0)
                return 0;

        /// @todo Should the following struct be static?
        struct iwreq req;
        if( iw_get_ext(iw_socket, _ifname, SIOCGIWTXPOW, &req) < 0 ) // try to get txpower.
                return 0; // no txpower
        else {
                if (req.u.txpower.disabled)
                        return -1;
                else
                        return req.u.txpower.value;
        }
}

bool WATools::isWireless( const char* _ifname ) /// returns TRUE if the specified interface supports Wireless Extensions
{
        if (iw_socket<0)
                iw_socket = iw_sockets_open();//get kernel socket
        if (iw_socket<0)
                return 0;

        /// @todo Should the following struct be static?
        struct iwreq req;
        if( iw_get_ext(iw_socket, _ifname, SIOCGIWNAME, &req) < 0 ) // try to get wireless name.
                return false; // no wireless name -> no wireless extensions
        else
                return true;
}

void WATools::cleanup()
{
	if (!iw_socket<0)
		iw_sockets_close(iw_socket);
}
