#!/usr/bin/perl -w

# menuverify - A simple tool for checking the translation of Gtk+
# menus for errors.

# Copyright (C) 2001  Haavard Kvaalen <havardk@xmms.org>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Bugs: This tool currently only checks top level sub menu names to
# check if the translations match.

my ($input, $linenr);
my ($msgid, $msgstr);
my ($fuzzy);
my ($key);
my (%translation, %lines);

if (!$ARGV[0]) {
    print("menuverify: No files to check.\n");
    print("usage: menuverify files ...\n");
    exit;
}

foreach $input (@ARGV) {
    unless (open(FILEH, $input)) {
	print("Unable to open " . $input . "\n");
	next;
    }
    $linenr = 0;
    $fuzzy = 0;
    $key = 0;

    while(<FILEH>) {
	$linenr++;
	if (/^\#, fuzzy/) {
	    # We don't want to complain about fuzzy translations.
	    $fuzzy = 1;
	}
	
	if ((/^msgid\s+\"\// &&  not $fuzzy)) {
	    $msgid = $_;
	    if ($msgid =~ /\"(\/[^\/]+?)\/.*\"/) {
		$key = $1;
	    }
    
	    if (defined($msgstr = <FILEH>))
	    {
		$linenr++;
		if ($msgstr =~ /^msgstr\s+\"[^\/\"]/) {
		    # The msgstr got no leading slash
		    print($input . ":" . $linenr . ": Error: No leading slash:\n" .
			  $msgid . $msgstr);
		} elsif ($key && $msgstr !~ /^msgstr\s+\"\"/) {
		    unless ($msgstr =~ /\"(\/[^\/]+?)\/.*\"/) {
			print($input . ":" . $linenr . ": Error: Not enough slashes:\n" .
			      $msgid . $msgstr);
		    } elsif (!defined($translation{$key})) {
			$translation{$key} = $1;
			$lines{$key} = $linenr;
		    } elsif ($translation{$key} ne $1) {
			print($input . ":" . $linenr . 
			      ": Error: Inconsistent translation of submenu.\n" . 
			      $input . ":" . $linenr . 
			      ": Translation      : " . $1 . "\n" .
			      $input . ":" . $lines{$key} . 
			      ": First translation: " . $translation{$key} . 
			      "\n" . $msgid . $msgstr);
		    }
		}
	    }
	    $fuzzy = 0;
	    $key = "";
	}
    }
    %translation = ();
}
