/* sql.c generated by valac 0.14.2, the Vala compiler
 * generated from sql.vala, do not modify */

/* sql.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *             By Seif Lotfy <seif@lotfy.com>
 * Copyright © 2011 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>


#define ZEITGEIST_SQ_LITE_TYPE_EVENT_VIEW_ROWS (zeitgeist_sq_lite_event_view_rows_get_type ())

#define ZEITGEIST_SQ_LITE_TYPE_DATABASE (zeitgeist_sq_lite_database_get_type ())
#define ZEITGEIST_SQ_LITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabase))
#define ZEITGEIST_SQ_LITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabaseClass))
#define ZEITGEIST_SQ_LITE_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE))
#define ZEITGEIST_SQ_LITE_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE))
#define ZEITGEIST_SQ_LITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabaseClass))

typedef struct _ZeitgeistSQLiteDatabase ZeitgeistSQLiteDatabase;
typedef struct _ZeitgeistSQLiteDatabaseClass ZeitgeistSQLiteDatabaseClass;
typedef struct _ZeitgeistSQLiteDatabasePrivate ZeitgeistSQLiteDatabasePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define ZEITGEIST_TYPE_TIME_RANGE (zeitgeist_time_range_get_type ())
#define ZEITGEIST_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRange))
#define ZEITGEIST_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))
#define ZEITGEIST_IS_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_IS_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_TIME_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))

typedef struct _ZeitgeistTimeRange ZeitgeistTimeRange;
typedef struct _ZeitgeistTimeRangeClass ZeitgeistTimeRangeClass;
typedef struct _Block2Data Block2Data;

typedef enum  {
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_TIMESTAMP,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_INTERPRETATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_MANIFESTATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_INTERPRETATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MANIFESTATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MIMETYPE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_STATE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ORIGIN,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID_CURRENT
} ZeitgeistSQLiteEventViewRows;

typedef void (*ZeitgeistSQLiteDeletionCallback) (const gchar* table, gint64 rowid, void* user_data);
struct _ZeitgeistSQLiteDatabase {
	GObject parent_instance;
	ZeitgeistSQLiteDatabasePrivate * priv;
	sqlite3_stmt* event_insertion_stmt;
	sqlite3_stmt* id_retrieval_stmt;
	sqlite3_stmt* move_handling_stmt;
	sqlite3_stmt* payload_insertion_stmt;
	sqlite3* database;
};

struct _ZeitgeistSQLiteDatabaseClass {
	GObjectClass parent_class;
};

struct _ZeitgeistSQLiteDatabasePrivate {
	ZeitgeistSQLiteDeletionCallback deletion_callback;
	gpointer deletion_callback_target;
	GDestroyNotify deletion_callback_target_destroy_notify;
	gboolean is_read_only;
};

typedef enum  {
	ZEITGEIST_ENGINE_ERROR_BACKUP_FAILED,
	ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT,
	ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR,
	ZEITGEIST_ENGINE_ERROR_DATABASE_RETIRE_FAILED,
	ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE,
	ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT,
	ZEITGEIST_ENGINE_ERROR_INVALID_KEY,
	ZEITGEIST_ENGINE_ERROR_INVALID_SIGNATURE,
	ZEITGEIST_ENGINE_ERROR_TOO_MANY_RESULTS
} ZeitgeistEngineError;
#define ZEITGEIST_ENGINE_ERROR zeitgeist_engine_error_quark ()
struct _Block1Data {
	int _ref_count_;
	ZeitgeistSQLiteDatabase * self;
	gint last_id;
};

struct _Block2Data {
	int _ref_count_;
	ZeitgeistSQLiteDatabase * self;
	ZeitgeistTimeRange* time_range;
};


static gpointer zeitgeist_sq_lite_database_parent_class = NULL;

GType zeitgeist_sq_lite_event_view_rows_get_type (void) G_GNUC_CONST;
GType zeitgeist_sq_lite_database_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_SQ_LITE_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabasePrivate))
enum  {
	ZEITGEIST_SQ_LITE_DATABASE_DUMMY_PROPERTY
};
#define ZEITGEIST_SQ_LITE_DATABASE_DEFAULT_OPEN_FLAGS (SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE)
GQuark zeitgeist_engine_error_quark (void);
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_new (GError** error);
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_construct (GType object_type, GError** error);
static void zeitgeist_sq_lite_database_open_database (ZeitgeistSQLiteDatabase* self, gboolean retry, GError** error);
static void zeitgeist_sq_lite_database_prepare_read_queries (ZeitgeistSQLiteDatabase* self, GError** error);
static void zeitgeist_sq_lite_database_prepare_modification_queries (ZeitgeistSQLiteDatabase* self, GError** error);
void zeitgeist_sq_lite_database_update_callback (ZeitgeistSQLiteDatabase* self, int action, const gchar* dbname, const gchar* table, gint64 rowid);
static void _zeitgeist_sq_lite_database_update_callback_sqlite_update_callback (gpointer self, int action, const gchar* dbname, const gchar* table, gint64 rowid);
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_new_read_only (GError** error);
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_construct_read_only (GType object_type, GError** error);
const gchar* zeitgeist_utils_get_database_file_path (void);
gint zeitgeist_sq_lite_database_schema_get_schema_version (sqlite3* database, GError** error);
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA_VERSION 6
void zeitgeist_sq_lite_database_schema_ensure_schema (sqlite3* database, GError** error);
void zeitgeist_utils_retire_database (GError** error);
guint32 zeitgeist_sq_lite_database_get_last_id (ZeitgeistSQLiteDatabase* self, GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gint __lambda1_ (Block1Data* _data1_, gint n_columns, gchar** values, int values_length1, gchar** column_names, int column_names_length1);
static gint ___lambda1__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names);
void zeitgeist_sq_lite_database_assert_query_success (ZeitgeistSQLiteDatabase* self, gint rc, const gchar* msg, gint success_code, GError** error);
void zeitgeist_sq_lite_database_set_deletion_callback (ZeitgeistSQLiteDatabase* self, ZeitgeistSQLiteDeletionCallback callback, void* callback_target, GDestroyNotify callback_target_destroy_notify);
gchar* zeitgeist_sq_lite_database_get_sql_string_from_event_ids (ZeitgeistSQLiteDatabase* self, guint32* event_ids, int event_ids_length1);
GType zeitgeist_time_range_get_type (void) G_GNUC_CONST;
ZeitgeistTimeRange* zeitgeist_sq_lite_database_get_time_range_for_event_ids (ZeitgeistSQLiteDatabase* self, guint32* event_ids, int event_ids_length1, GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gint __lambda2_ (Block2Data* _data2_, gint n_columns, gchar** values, int values_length1, gchar** column_names, int column_names_length1);
ZeitgeistTimeRange* zeitgeist_time_range_new (gint64 start_msec, gint64 end_msec);
ZeitgeistTimeRange* zeitgeist_time_range_construct (GType object_type, gint64 start_msec, gint64 end_msec);
static gint ___lambda2__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names);
void zeitgeist_sq_lite_database_insert_or_ignore_into_table (ZeitgeistSQLiteDatabase* self, const gchar* table_name, GPtrArray* values, GError** error);
void zeitgeist_sq_lite_database_begin_transaction (ZeitgeistSQLiteDatabase* self, GError** error);
void zeitgeist_sq_lite_database_end_transaction (ZeitgeistSQLiteDatabase* self, GError** error);
void zeitgeist_sq_lite_database_abort_transaction (ZeitgeistSQLiteDatabase* self, GError** error);
void zeitgeist_sq_lite_database_close (ZeitgeistSQLiteDatabase* self);
void zeitgeist_sq_lite_database_assert_not_corrupt (ZeitgeistSQLiteDatabase* self, gint rc, GError** error);
void zeitgeist_sq_lite_database_schema_set_corruption_flag (sqlite3* database, GError** error);
static void zeitgeist_sq_lite_database_finalize (GObject* obj);


GType zeitgeist_sq_lite_event_view_rows_get_type (void) {
	static volatile gsize zeitgeist_sq_lite_event_view_rows_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_sq_lite_event_view_rows_type_id__volatile)) {
		static const GEnumValue values[] = {{ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID", "id"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_TIMESTAMP, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_TIMESTAMP", "timestamp"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_INTERPRETATION, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_INTERPRETATION", "interpretation"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_MANIFESTATION, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_MANIFESTATION", "manifestation"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR", "actor"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD", "payload"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_URI, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_URI", "subject-uri"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID", "subject-id"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_INTERPRETATION, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_INTERPRETATION", "subject-interpretation"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MANIFESTATION, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MANIFESTATION", "subject-manifestation"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN", "subject-origin"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN_URI, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN_URI", "subject-origin-uri"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MIMETYPE, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MIMETYPE", "subject-mimetype"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT", "subject-text"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE", "subject-storage"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_STATE, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_STATE", "subject-storage-state"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ORIGIN, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ORIGIN", "origin"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN_URI, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN_URI", "event-origin-uri"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_URI, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_URI", "subject-current-uri"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID_CURRENT, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID_CURRENT", "subject-id-current"}, {0, NULL, NULL}};
		GType zeitgeist_sq_lite_event_view_rows_type_id;
		zeitgeist_sq_lite_event_view_rows_type_id = g_enum_register_static ("ZeitgeistSQLiteEventViewRows", values);
		g_once_init_leave (&zeitgeist_sq_lite_event_view_rows_type_id__volatile, zeitgeist_sq_lite_event_view_rows_type_id);
	}
	return zeitgeist_sq_lite_event_view_rows_type_id__volatile;
}


static void _zeitgeist_sq_lite_database_update_callback_sqlite_update_callback (gpointer self, int action, const gchar* dbname, const gchar* table, gint64 rowid) {
	zeitgeist_sq_lite_database_update_callback (self, action, dbname, table, rowid);
}


ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_construct (GType object_type, GError** error) {
	ZeitgeistSQLiteDatabase * self = NULL;
	sqlite3* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistSQLiteDatabase*) g_object_new (object_type, NULL);
	zeitgeist_sq_lite_database_open_database (self, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	zeitgeist_sq_lite_database_prepare_read_queries (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	zeitgeist_sq_lite_database_prepare_modification_queries (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = self->database;
	sqlite3_update_hook (_tmp0_, _zeitgeist_sq_lite_database_update_callback_sqlite_update_callback, self);
	return self;
}


ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_new (GError** error) {
	return zeitgeist_sq_lite_database_construct (ZEITGEIST_SQ_LITE_TYPE_DATABASE, error);
}


ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_construct_read_only (GType object_type, GError** error) {
	ZeitgeistSQLiteDatabase * self = NULL;
	sqlite3* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistSQLiteDatabase*) g_object_new (object_type, NULL);
	self->priv->is_read_only = TRUE;
	zeitgeist_sq_lite_database_open_database (self, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	zeitgeist_sq_lite_database_prepare_read_queries (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = self->database;
	sqlite3_update_hook (_tmp0_, _zeitgeist_sq_lite_database_update_callback_sqlite_update_callback, self);
	return self;
}


ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_new_read_only (GError** error) {
	return zeitgeist_sq_lite_database_construct_read_only (ZEITGEIST_SQ_LITE_TYPE_DATABASE, error);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void zeitgeist_sq_lite_database_open_database (ZeitgeistSQLiteDatabase* self, gboolean retry, GError** error) {
	gint _tmp0_ = 0;
	gboolean _tmp1_;
	gint _tmp2_;
	gint flags;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_;
	sqlite3* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint rc;
	gint _tmp7_;
	gint _tmp22_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->is_read_only;
	if (_tmp1_) {
		_tmp0_ = SQLITE_OPEN_READONLY;
	} else {
		_tmp0_ = ZEITGEIST_SQ_LITE_DATABASE_DEFAULT_OPEN_FLAGS;
	}
	_tmp2_ = _tmp0_;
	flags = _tmp2_;
	_tmp3_ = zeitgeist_utils_get_database_file_path ();
	_tmp4_ = flags;
	_tmp6_ = sqlite3_open_v2 (_tmp3_, &_tmp5_, _tmp4_, NULL);
	_sqlite3_close0 (self->database);
	self->database = _tmp5_;
	rc = _tmp6_;
	_tmp7_ = rc;
	if (_tmp7_ == SQLITE_OK) {
		{
			gboolean _tmp8_;
			_tmp8_ = self->priv->is_read_only;
			if (_tmp8_) {
				sqlite3* _tmp9_;
				gint _tmp10_ = 0;
				gint ver;
				gint _tmp11_;
				_tmp9_ = self->database;
				_tmp10_ = zeitgeist_sq_lite_database_schema_get_schema_version (_tmp9_, &_inner_error_);
				ver = _tmp10_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						goto __catch5_zeitgeist_engine_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp11_ = ver;
				if (_tmp11_ < ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA_VERSION) {
					GError* _tmp12_;
					_tmp12_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN, "Unable to open database: old schema version");
					_inner_error_ = _tmp12_;
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						goto __catch5_zeitgeist_engine_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			} else {
				sqlite3* _tmp13_;
				_tmp13_ = self->database;
				zeitgeist_sq_lite_database_schema_ensure_schema (_tmp13_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						goto __catch5_zeitgeist_engine_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		goto __finally5;
		__catch5_zeitgeist_engine_error:
		{
			GError* err = NULL;
			gboolean _tmp14_ = FALSE;
			GError* _tmp15_;
			gboolean _tmp17_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp15_ = err;
			if (g_error_matches (_tmp15_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT)) {
				gboolean _tmp16_;
				_tmp16_ = retry;
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			_tmp17_ = _tmp14_;
			if (_tmp17_) {
				rc = SQLITE_CORRUPT;
			} else {
				GError* _tmp18_;
				_tmp18_ = err;
				if (g_error_matches (_tmp18_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN)) {
					rc = SQLITE_CANTOPEN;
				} else {
					GError* _tmp19_;
					_tmp19_ = err;
					if (g_error_matches (_tmp19_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY)) {
						rc = SQLITE_BUSY;
					} else {
						GError* _tmp20_;
						GError* _tmp21_;
						_tmp20_ = err;
						_tmp21_ = _g_error_copy0 (_tmp20_);
						_inner_error_ = _tmp21_;
						_g_error_free0 (err);
						goto __finally5;
					}
				}
			}
			_g_error_free0 (err);
		}
		__finally5:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tmp22_ = rc;
	if (_tmp22_ != SQLITE_OK) {
		gboolean _tmp23_ = FALSE;
		gint _tmp24_;
		gboolean _tmp26_;
		_tmp24_ = rc;
		if (_tmp24_ == SQLITE_CORRUPT) {
			gboolean _tmp25_;
			_tmp25_ = retry;
			_tmp23_ = _tmp25_;
		} else {
			_tmp23_ = FALSE;
		}
		_tmp26_ = _tmp23_;
		if (_tmp26_) {
			g_warning ("sql.vala:145: %s", "It looks like your database is corrupt. " "It will be renamed and a new one will be created.");
			zeitgeist_utils_retire_database (&_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			zeitgeist_sq_lite_database_open_database (self, FALSE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		} else {
			gboolean _tmp27_ = FALSE;
			gint _tmp28_;
			gboolean _tmp30_;
			_tmp28_ = rc;
			if (_tmp28_ == SQLITE_PERM) {
				_tmp27_ = TRUE;
			} else {
				gint _tmp29_;
				_tmp29_ = rc;
				_tmp27_ = _tmp29_ == SQLITE_CANTOPEN;
			}
			_tmp30_ = _tmp27_;
			if (_tmp30_) {
				sqlite3* _tmp31_;
				const gchar* _tmp32_ = NULL;
				GError* _tmp33_;
				_tmp31_ = self->database;
				_tmp32_ = sqlite3_errmsg (_tmp31_);
				_tmp33_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN, _tmp32_);
				_inner_error_ = _tmp33_;
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			} else {
				gint _tmp34_;
				_tmp34_ = rc;
				if (_tmp34_ == SQLITE_BUSY) {
					sqlite3* _tmp35_;
					const gchar* _tmp36_ = NULL;
					GError* _tmp37_;
					_tmp35_ = self->database;
					_tmp36_ = sqlite3_errmsg (_tmp35_);
					_tmp37_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY, _tmp36_);
					_inner_error_ = _tmp37_;
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				} else {
					gint _tmp38_;
					sqlite3* _tmp39_;
					const gchar* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
					gchar* message;
					const gchar* _tmp42_;
					GError* _tmp43_;
					_tmp38_ = rc;
					_tmp39_ = self->database;
					_tmp40_ = sqlite3_errmsg (_tmp39_);
					_tmp41_ = g_strdup_printf ("Can't open database: %d, %s", _tmp38_, _tmp40_);
					message = _tmp41_;
					_tmp42_ = message;
					_tmp43_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, _tmp42_);
					_inner_error_ = _tmp43_;
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (message);
						return;
					} else {
						_g_free0 (message);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_free0 (message);
				}
			}
		}
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	const gchar* _tmp0_;
	sqlite3_callback _tmp1_;
	void* _tmp1__target;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint ec;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
	sqlite_errmsg = _tmp2_;
	ec = _tmp3_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = sqlite_errmsg;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp5_;
	}
	_tmp6_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp6_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}


static gint __lambda1_ (Block1Data* _data1_, gint n_columns, gchar** values, int values_length1, gchar** column_names, int column_names_length1) {
	ZeitgeistSQLiteDatabase * self;
	gint result = 0;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	self = _data1_->self;
	_tmp0_ = values;
	_tmp0__length1 = values_length1;
	_tmp1_ = _tmp0_[0];
	if (_tmp1_ == NULL) {
		_data1_->last_id = 0;
	} else {
		gchar** _tmp2_;
		gint _tmp2__length1;
		const gchar* _tmp3_;
		gint _tmp4_ = 0;
		_tmp2_ = values;
		_tmp2__length1 = values_length1;
		_tmp3_ = _tmp2_[0];
		_tmp4_ = atoi (_tmp3_);
		_data1_->last_id = _tmp4_;
	}
	result = 0;
	return result;
}


static gint ___lambda1__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names) {
	gint result;
	result = __lambda1_ (self, n_columns, values, -1, column_names, -1);
	return result;
}


guint32 zeitgeist_sq_lite_database_get_last_id (ZeitgeistSQLiteDatabase* self, GError** error) {
	guint32 result = 0U;
	Block1Data* _data1_;
	sqlite3* _tmp0_;
	gint _tmp1_ = 0;
	gint rc;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->last_id = -1;
	_tmp0_ = self->database;
	_tmp1_ = _sqlite3_exec (_tmp0_, "SELECT MAX(id) FROM event", ___lambda1__sqlite3_callback, _data1_, NULL);
	rc = _tmp1_;
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:182: Can't query database", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return 0U;
		} else {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	}
	g_assert (_data1_->last_id != (-1));
	result = (guint32) _data1_->last_id;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


void zeitgeist_sq_lite_database_set_deletion_callback (ZeitgeistSQLiteDatabase* self, ZeitgeistSQLiteDeletionCallback callback, void* callback_target, GDestroyNotify callback_target_destroy_notify) {
	ZeitgeistSQLiteDeletionCallback _tmp0_;
	void* _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	g_return_if_fail (self != NULL);
	_tmp0_ = callback;
	_tmp0__target = callback_target;
	_tmp0__target_destroy_notify = callback_target_destroy_notify;
	callback_target_destroy_notify = NULL;
	(self->priv->deletion_callback_target_destroy_notify == NULL) ? NULL : (self->priv->deletion_callback_target_destroy_notify (self->priv->deletion_callback_target), NULL);
	self->priv->deletion_callback = NULL;
	self->priv->deletion_callback_target = NULL;
	self->priv->deletion_callback_target_destroy_notify = NULL;
	self->priv->deletion_callback = _tmp0_;
	self->priv->deletion_callback_target = _tmp0__target;
	self->priv->deletion_callback_target_destroy_notify = _tmp0__target_destroy_notify;
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
}


/**
         * Join all given event_ids into a comma-separated string suitable
         * for use in a SQL query like "WHERE id IN (...)".
         */
gchar* zeitgeist_sq_lite_database_get_sql_string_from_event_ids (ZeitgeistSQLiteDatabase* self, guint32* event_ids, int event_ids_length1) {
	gchar* result = NULL;
	guint32* _tmp0_;
	gint _tmp0__length1;
	GString* _tmp1_;
	GString* sql_condition;
	GString* _tmp2_;
	guint32* _tmp3_;
	gint _tmp3__length1;
	guint32 _tmp4_;
	GString* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = event_ids;
	_tmp0__length1 = event_ids_length1;
	g_return_val_if_fail (_tmp0__length1 > 0, NULL);
	_tmp1_ = g_string_new ("");
	sql_condition = _tmp1_;
	_tmp2_ = sql_condition;
	_tmp3_ = event_ids;
	_tmp3__length1 = event_ids_length1;
	_tmp4_ = _tmp3_[0];
	g_string_append_printf (_tmp2_, "%u", (guint) _tmp4_);
	{
		gint i;
		i = 1;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				gint _tmp8_;
				guint32* _tmp9_;
				gint _tmp9__length1;
				GString* _tmp10_;
				guint32* _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				guint32 _tmp13_;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = event_ids;
				_tmp9__length1 = event_ids_length1;
				if (!(_tmp8_ < _tmp9__length1)) {
					break;
				}
				_tmp10_ = sql_condition;
				_tmp11_ = event_ids;
				_tmp11__length1 = event_ids_length1;
				_tmp12_ = i;
				_tmp13_ = _tmp11_[_tmp12_];
				g_string_append_printf (_tmp10_, ", %u", (guint) _tmp13_);
			}
		}
	}
	_tmp14_ = sql_condition;
	_tmp15_ = _tmp14_->str;
	_tmp16_ = g_strdup (_tmp15_);
	result = _tmp16_;
	_g_string_free0 (sql_condition);
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->time_range);
		g_slice_free (Block2Data, _data2_);
	}
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gint __lambda2_ (Block2Data* _data2_, gint n_columns, gchar** values, int values_length1, gchar** column_names, int column_names_length1) {
	ZeitgeistSQLiteDatabase * self;
	gint result = 0;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	self = _data2_->self;
	_tmp0_ = values;
	_tmp0__length1 = values_length1;
	_tmp1_ = _tmp0_[0];
	if (_tmp1_ != NULL) {
		gchar** _tmp2_;
		gint _tmp2__length1;
		const gchar* _tmp3_;
		gint64 _tmp4_ = 0LL;
		gint64 start;
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gint64 _tmp7_ = 0LL;
		gint64 end;
		gint64 _tmp8_;
		gint64 _tmp9_;
		ZeitgeistTimeRange* _tmp10_;
		_tmp2_ = values;
		_tmp2__length1 = values_length1;
		_tmp3_ = _tmp2_[0];
		_tmp4_ = int64_parse (_tmp3_);
		start = _tmp4_;
		_tmp5_ = values;
		_tmp5__length1 = values_length1;
		_tmp6_ = _tmp5_[1];
		_tmp7_ = int64_parse (_tmp6_);
		end = _tmp7_;
		_tmp8_ = start;
		_tmp9_ = end;
		_tmp10_ = zeitgeist_time_range_new (_tmp8_, _tmp9_);
		_g_object_unref0 (_data2_->time_range);
		_data2_->time_range = _tmp10_;
	}
	result = 0;
	return result;
}


static gint ___lambda2__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names) {
	gint result;
	result = __lambda2_ (self, n_columns, values, -1, column_names, -1);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ZeitgeistTimeRange* zeitgeist_sq_lite_database_get_time_range_for_event_ids (ZeitgeistSQLiteDatabase* self, guint32* event_ids, int event_ids_length1, GError** error) {
	ZeitgeistTimeRange* result = NULL;
	Block2Data* _data2_;
	guint32* _tmp0_;
	gint _tmp0__length1;
	guint32* _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* sql;
	sqlite3* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_ = 0;
	gint rc;
	gint _tmp9_;
	ZeitgeistTimeRange* _tmp10_;
	ZeitgeistTimeRange* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = event_ids;
	_tmp0__length1 = event_ids_length1;
	if (_tmp0__length1 == 0) {
		result = NULL;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	_tmp1_ = event_ids;
	_tmp1__length1 = event_ids_length1;
	_tmp2_ = zeitgeist_sq_lite_database_get_sql_string_from_event_ids (self, _tmp1_, _tmp1__length1);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("\n" \
"                SELECT MIN(timestamp), MAX(timestamp)\n" \
"                FROM event\n" \
"                WHERE id IN (%s)\n" \
"                ", _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	sql = _tmp5_;
	_data2_->time_range = NULL;
	_tmp6_ = self->database;
	_tmp7_ = sql;
	_tmp8_ = _sqlite3_exec (_tmp6_, _tmp7_, ___lambda2__sqlite3_callback, _data2_, NULL);
	rc = _tmp8_;
	_tmp9_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (self, _tmp9_, "sql.vala:231: SQL Error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return NULL;
		} else {
			_g_free0 (sql);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp10_ = _data2_->time_range;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	result = _tmp11_;
	_g_free0 (sql);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


void zeitgeist_sq_lite_database_insert_or_ignore_into_table (ZeitgeistSQLiteDatabase* self, const gchar* table_name, GPtrArray* values, GError** error) {
	gint rc = 0;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GString* _tmp3_;
	GString* sql;
	GString* _tmp4_;
	GString* _tmp5_;
	const gchar* _tmp6_;
	GString* _tmp7_;
	sqlite3_stmt* stmt = NULL;
	sqlite3* _tmp16_;
	GString* _tmp17_;
	const gchar* _tmp18_;
	sqlite3_stmt* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_;
	sqlite3_stmt* _tmp36_;
	gint _tmp37_ = 0;
	gint _tmp38_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (table_name != NULL);
	g_return_if_fail (values != NULL);
	_tmp0_ = values;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	g_assert (_tmp2_ > 0);
	_tmp3_ = g_string_new ("");
	sql = _tmp3_;
	_tmp4_ = sql;
	g_string_append (_tmp4_, "INSERT OR IGNORE INTO ");
	_tmp5_ = sql;
	_tmp6_ = table_name;
	g_string_append (_tmp5_, _tmp6_);
	_tmp7_ = sql;
	g_string_append (_tmp7_, " (value) SELECT ?");
	{
		gint i;
		i = 1;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_;
				gint _tmp11_;
				GPtrArray* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				GString* _tmp15_;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = values;
				_tmp13_ = g_ptr_array_get_length (_tmp12_);
				_tmp14_ = _tmp13_;
				if (!(_tmp11_ < _tmp14_)) {
					break;
				}
				_tmp15_ = sql;
				g_string_append (_tmp15_, " UNION SELECT ?");
			}
		}
	}
	_tmp16_ = self->database;
	_tmp17_ = sql;
	_tmp18_ = _tmp17_->str;
	_tmp20_ = sqlite3_prepare_v2 (_tmp16_, _tmp18_, -1, &_tmp19_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp19_;
	rc = _tmp20_;
	_tmp21_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (self, _tmp21_, "sql.vala:251: SQL error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_sqlite3_finalize0 (stmt);
			_g_string_free0 (sql);
			return;
		} else {
			_sqlite3_finalize0 (stmt);
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp22_;
			_tmp22_ = TRUE;
			while (TRUE) {
				gboolean _tmp23_;
				gint _tmp25_;
				GPtrArray* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				sqlite3_stmt* _tmp29_;
				gint _tmp30_;
				GPtrArray* _tmp31_;
				gint _tmp32_;
				gconstpointer _tmp33_ = NULL;
				gchar* _tmp34_;
				GDestroyNotify _tmp35_;
				_tmp23_ = _tmp22_;
				if (!_tmp23_) {
					gint _tmp24_;
					_tmp24_ = i;
					i = _tmp24_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp25_ = i;
				_tmp26_ = values;
				_tmp27_ = g_ptr_array_get_length (_tmp26_);
				_tmp28_ = _tmp27_;
				if (!(_tmp25_ < _tmp28_)) {
					break;
				}
				_tmp29_ = stmt;
				_tmp30_ = i;
				_tmp31_ = values;
				_tmp32_ = i;
				_tmp33_ = g_ptr_array_index (_tmp31_, (guint) _tmp32_);
				_tmp34_ = g_strdup ((const gchar*) _tmp33_);
				_tmp35_ = g_free;
				sqlite3_bind_text (_tmp29_, _tmp30_ + 1, _tmp34_, -1, _tmp35_);
			}
		}
	}
	_tmp36_ = stmt;
	_tmp37_ = sqlite3_step (_tmp36_);
	rc = _tmp37_;
	_tmp38_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (self, _tmp38_, "SQL error", SQLITE_DONE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_sqlite3_finalize0 (stmt);
			_g_string_free0 (sql);
			return;
		} else {
			_sqlite3_finalize0 (stmt);
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_sqlite3_finalize0 (stmt);
	_g_string_free0 (sql);
}


void zeitgeist_sq_lite_database_begin_transaction (ZeitgeistSQLiteDatabase* self, GError** error) {
	sqlite3* _tmp0_;
	gint _tmp1_ = 0;
	gint rc;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->database;
	_tmp1_ = _sqlite3_exec (_tmp0_, "BEGIN", NULL, NULL, NULL);
	rc = _tmp1_;
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:263: Can't start transaction", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void zeitgeist_sq_lite_database_end_transaction (ZeitgeistSQLiteDatabase* self, GError** error) {
	sqlite3* _tmp0_;
	gint _tmp1_ = 0;
	gint rc;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->database;
	_tmp1_ = _sqlite3_exec (_tmp0_, "COMMIT", NULL, NULL, NULL);
	rc = _tmp1_;
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:269: Can't commit transaction", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void zeitgeist_sq_lite_database_abort_transaction (ZeitgeistSQLiteDatabase* self, GError** error) {
	sqlite3* _tmp0_;
	gint _tmp1_ = 0;
	gint rc;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->database;
	_tmp1_ = _sqlite3_exec (_tmp0_, "ROLLBACK", NULL, NULL, NULL);
	rc = _tmp1_;
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:275: Can't rollback transaction", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void zeitgeist_sq_lite_database_close (ZeitgeistSQLiteDatabase* self) {
	g_return_if_fail (self != NULL);
	_sqlite3_close0 (self->database);
	self->database = NULL;
}


/**
         * Ensure `rc' is SQLITE_OK. If it isn't, print an error message
         * and throw an error.
         *
         * @param rc error code returned by a SQLite call
         * @param msg message to print if `rc' indicates an error
         * @throws EngineError
         */
void zeitgeist_sq_lite_database_assert_query_success (ZeitgeistSQLiteDatabase* self, gint rc, const gchar* msg, gint success_code, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = rc;
	_tmp1_ = success_code;
	_tmp2_ = G_UNLIKELY (_tmp0_ != _tmp1_);
	if (_tmp2_) {
		const gchar* _tmp3_;
		gint _tmp4_;
		sqlite3* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* error_message;
		const gchar* _tmp8_;
		gint _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
		_tmp3_ = msg;
		_tmp4_ = rc;
		_tmp5_ = self->database;
		_tmp6_ = sqlite3_errmsg (_tmp5_);
		_tmp7_ = g_strdup_printf ("%s: %d, %s", _tmp3_, _tmp4_, _tmp6_);
		error_message = _tmp7_;
		_tmp8_ = error_message;
		g_warning ("sql.vala:324: %s\n", _tmp8_);
		_tmp9_ = rc;
		zeitgeist_sq_lite_database_assert_not_corrupt (self, _tmp9_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (error_message);
				return;
			} else {
				_g_free0 (error_message);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp10_ = error_message;
		_tmp11_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, _tmp10_);
		_inner_error_ = _tmp11_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (error_message);
			return;
		} else {
			_g_free0 (error_message);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (error_message);
	}
}


/**
         * Ensure `rc' isn't SQLITE_CORRUPT. If it is, schedule a database
         * retire and Zeitgeist restart so a new database can be created,
         * unless in read-only mode, in which case EngineError.DATABASE_ERROR
         * will be thrown.
         *
         * This function should be called whenever assert_query_success isn't
         * used.
         *
         * @param rc error code returned by a SQLite call
         */
void zeitgeist_sq_lite_database_assert_not_corrupt (ZeitgeistSQLiteDatabase* self, gint rc, GError** error) {
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = rc;
	_tmp1_ = G_UNLIKELY (_tmp0_ == SQLITE_CORRUPT);
	if (_tmp1_) {
		sqlite3* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gboolean _tmp6_;
		sqlite3* _tmp8_;
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_;
		_tmp2_ = self->database;
		_tmp3_ = sqlite3_errmsg (_tmp2_);
		_tmp4_ = g_strdup_printf ("It looks like your database is corrupt: %s", _tmp3_);
		_tmp5_ = _tmp4_;
		g_warning ("sql.vala:346: %s", _tmp5_);
		_g_free0 (_tmp5_);
		_tmp6_ = self->priv->is_read_only;
		if (!_tmp6_) {
			sqlite3* _tmp7_;
			_tmp7_ = self->database;
			zeitgeist_sq_lite_database_schema_set_corruption_flag (_tmp7_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		_tmp8_ = self->database;
		_tmp9_ = sqlite3_errmsg (_tmp8_);
		_tmp10_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT, _tmp9_);
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void zeitgeist_sq_lite_database_prepare_read_queries (ZeitgeistSQLiteDatabase* self, GError** error) {
	gint rc = 0;
	gchar* sql = NULL;
	gchar* _tmp0_;
	sqlite3* _tmp1_;
	sqlite3_stmt* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("\n" \
"                SELECT id FROM event\n" \
"                WHERE timestamp=? AND interpretation=? AND\n" \
"                    manifestation=? AND actor=?\n" \
"                ");
	_g_free0 (sql);
	sql = _tmp0_;
	_tmp1_ = self->database;
	_tmp3_ = sqlite3_prepare_v2 (_tmp1_, sql, -1, &_tmp2_, NULL);
	_sqlite3_finalize0 (self->id_retrieval_stmt);
	self->id_retrieval_stmt = _tmp2_;
	rc = _tmp3_;
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:371: Event ID retrieval query error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (sql);
}


static void zeitgeist_sq_lite_database_prepare_modification_queries (ZeitgeistSQLiteDatabase* self, GError** error) {
	gint rc = 0;
	gchar* sql = NULL;
	gchar* _tmp0_;
	sqlite3* _tmp1_;
	const gchar* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_;
	gchar* _tmp6_;
	sqlite3* _tmp7_;
	const gchar* _tmp8_;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_;
	gchar* _tmp12_;
	sqlite3* _tmp13_;
	const gchar* _tmp14_;
	sqlite3_stmt* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("\n" \
"                INSERT INTO event (\n" \
"                    id, timestamp, interpretation, manifestation, acto" \
"r,\n" \
"                    origin, payload, subj_id, subj_id_current,\n" \
"                    subj_interpretation, subj_manifestation, subj_orig" \
"in,\n" \
"                    subj_mimetype, subj_text, subj_storage\n" \
"                ) VALUES (\n" \
"                    ?, ?, ?, ?, ?,\n" \
"                    (SELECT id FROM uri WHERE value=?),\n" \
"                    ?,\n" \
"                    (SELECT id FROM uri WHERE value=?),\n" \
"                    (SELECT id FROM uri WHERE value=?),\n" \
"                    ?, ?,\n" \
"                    (SELECT id FROM uri WHERE value=?),\n" \
"                    ?,\n" \
"                    (SELECT id FROM text WHERE value=?),\n" \
"                    (SELECT id FROM storage WHERE value=?)\n" \
"                )");
	_g_free0 (sql);
	sql = _tmp0_;
	_tmp1_ = self->database;
	_tmp2_ = sql;
	_tmp4_ = sqlite3_prepare_v2 (_tmp1_, _tmp2_, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (self->event_insertion_stmt);
	self->event_insertion_stmt = _tmp3_;
	rc = _tmp4_;
	_tmp5_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (self, _tmp5_, "sql.vala:400: Insertion query error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp6_ = g_strdup ("\n" \
"            UPDATE event\n" \
"                SET subj_id_current=(SELECT id FROM uri WHERE value=?)" \
"\n" \
"                    WHERE subj_id_current=(SELECT id FROM uri WHERE va" \
"lue=?)\n" \
"                    AND interpretation!=? AND timestamp<?\n" \
"            ");
	_g_free0 (sql);
	sql = _tmp6_;
	_tmp7_ = self->database;
	_tmp8_ = sql;
	_tmp10_ = sqlite3_prepare_v2 (_tmp7_, _tmp8_, -1, &_tmp9_, NULL);
	_sqlite3_finalize0 (self->move_handling_stmt);
	self->move_handling_stmt = _tmp9_;
	rc = _tmp10_;
	_tmp11_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (self, _tmp11_, "sql.vala:410: Move handling error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp12_ = g_strdup ("\n" \
"                INSERT INTO payload (value) VALUES (?)\n" \
"            ");
	_g_free0 (sql);
	sql = _tmp12_;
	_tmp13_ = self->database;
	_tmp14_ = sql;
	_tmp16_ = sqlite3_prepare_v2 (_tmp13_, _tmp14_, -1, &_tmp15_, NULL);
	_sqlite3_finalize0 (self->payload_insertion_stmt);
	self->payload_insertion_stmt = _tmp15_;
	rc = _tmp16_;
	_tmp17_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (self, _tmp17_, "sql.vala:417: Payload insertion query error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (sql);
}


void zeitgeist_sq_lite_database_update_callback (ZeitgeistSQLiteDatabase* self, int action, const gchar* dbname, const gchar* table, gint64 rowid) {
	int _tmp0_;
	ZeitgeistSQLiteDeletionCallback _tmp1_;
	void* _tmp1__target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbname != NULL);
	g_return_if_fail (table != NULL);
	_tmp0_ = action;
	if (_tmp0_ != SQLITE_DELETE) {
		return;
	}
	_tmp1_ = self->priv->deletion_callback;
	_tmp1__target = self->priv->deletion_callback_target;
	if (_tmp1_ != NULL) {
		ZeitgeistSQLiteDeletionCallback _tmp2_;
		void* _tmp2__target;
		const gchar* _tmp3_;
		gint64 _tmp4_;
		_tmp2_ = self->priv->deletion_callback;
		_tmp2__target = self->priv->deletion_callback_target;
		_tmp3_ = table;
		_tmp4_ = rowid;
		_tmp2_ (_tmp3_, _tmp4_, _tmp2__target);
	}
}


static void zeitgeist_sq_lite_database_class_init (ZeitgeistSQLiteDatabaseClass * klass) {
	zeitgeist_sq_lite_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistSQLiteDatabasePrivate));
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_sq_lite_database_finalize;
}


static void zeitgeist_sq_lite_database_instance_init (ZeitgeistSQLiteDatabase * self) {
	self->priv = ZEITGEIST_SQ_LITE_DATABASE_GET_PRIVATE (self);
	self->priv->deletion_callback = NULL;
	self->priv->is_read_only = FALSE;
}


static void zeitgeist_sq_lite_database_finalize (GObject* obj) {
	ZeitgeistSQLiteDatabase * self;
	self = ZEITGEIST_SQ_LITE_DATABASE (obj);
	_sqlite3_finalize0 (self->event_insertion_stmt);
	_sqlite3_finalize0 (self->id_retrieval_stmt);
	_sqlite3_finalize0 (self->move_handling_stmt);
	_sqlite3_finalize0 (self->payload_insertion_stmt);
	_sqlite3_close0 (self->database);
	(self->priv->deletion_callback_target_destroy_notify == NULL) ? NULL : (self->priv->deletion_callback_target_destroy_notify (self->priv->deletion_callback_target), NULL);
	self->priv->deletion_callback = NULL;
	self->priv->deletion_callback_target = NULL;
	self->priv->deletion_callback_target_destroy_notify = NULL;
	G_OBJECT_CLASS (zeitgeist_sq_lite_database_parent_class)->finalize (obj);
}


GType zeitgeist_sq_lite_database_get_type (void) {
	static volatile gsize zeitgeist_sq_lite_database_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_sq_lite_database_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistSQLiteDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_sq_lite_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistSQLiteDatabase), 0, (GInstanceInitFunc) zeitgeist_sq_lite_database_instance_init, NULL };
		GType zeitgeist_sq_lite_database_type_id;
		zeitgeist_sq_lite_database_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistSQLiteDatabase", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_sq_lite_database_type_id__volatile, zeitgeist_sq_lite_database_type_id);
	}
	return zeitgeist_sq_lite_database_type_id__volatile;
}



