/* utils.c generated by valac 0.16.0, the Vala compiler
 * generated from utils.vala, do not modify */

/* utils.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Seif Lotfy <seif@lotfy.com>
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2011 Manish Sinha <manishsinha@ubuntu.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	ZEITGEIST_ENGINE_ERROR_BACKUP_FAILED,
	ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT,
	ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR,
	ZEITGEIST_ENGINE_ERROR_DATABASE_RETIRE_FAILED,
	ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE,
	ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT,
	ZEITGEIST_ENGINE_ERROR_INVALID_KEY,
	ZEITGEIST_ENGINE_ERROR_INVALID_SIGNATURE,
	ZEITGEIST_ENGINE_ERROR_TOO_MANY_RESULTS
} ZeitgeistEngineError;
#define ZEITGEIST_ENGINE_ERROR zeitgeist_engine_error_quark ()

extern gchar* zeitgeist_utils_DATA_PATH;
gchar* zeitgeist_utils_DATA_PATH = NULL;
extern gchar* zeitgeist_utils_DATABASE_FILE_PATH;
gchar* zeitgeist_utils_DATABASE_FILE_PATH = NULL;
extern gchar* zeitgeist_utils_DATABASE_FILE_BACKUP_PATH;
gchar* zeitgeist_utils_DATABASE_FILE_BACKUP_PATH = NULL;
extern gchar* zeitgeist_utils_LOCAL_EXTENSIONS_PATH;
gchar* zeitgeist_utils_LOCAL_EXTENSIONS_PATH = NULL;

#define ZEITGEIST_UTILS_DATA_FOLDER "zeitgeist"
#define ZEITGEIST_UTILS_DATABASE_BASENAME "activity.sqlite"
#define ZEITGEIST_UTILS_USER_EXTENSION_PATH ""
#define ZEITGEIST_UTILS_DBUS_INTERFACE ""
#define ZEITGEIST_UTILS_SIG_EVENT "asaasay"
#define ZEITGEIST_UTILS_MAX_DBUS_RESULT_SIZE ((gsize) ((4 * 1024) * 1024))
#define ZEITGEIST_UTILS_CACHE_SIZE ((guint) 0)
const gchar* zeitgeist_utils_get_data_path (void);
gchar* zeitgeist_utils_get_default_data_path (void);
const gchar* zeitgeist_utils_get_database_file_path (void);
const gchar* zeitgeist_utils_get_database_file_backup_path (void);
gchar* zeitgeist_utils_get_database_file_retire_name (void);
const gchar* zeitgeist_utils_get_local_extensions_path (void);
gboolean zeitgeist_utils_using_in_memory_database (void);
void zeitgeist_utils_backup_database (GError** error);
GQuark zeitgeist_engine_error_quark (void);
void zeitgeist_utils_retire_database (GError** error);
gboolean zeitgeist_utils_parse_negation (gchar** val);
gboolean zeitgeist_utils_parse_noexpand (gchar** val);
gboolean zeitgeist_utils_parse_wildcard (gchar** val);
gboolean zeitgeist_utils_is_empty_string (const gchar* s);


const gchar* zeitgeist_utils_get_data_path (void) {
	const gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	_tmp0_ = zeitgeist_utils_DATA_PATH;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = zeitgeist_utils_DATA_PATH;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = g_getenv ("ZEITGEIST_DATA_PATH");
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		gchar* _tmp6_ = NULL;
		_tmp6_ = zeitgeist_utils_get_default_data_path ();
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp6_;
	}
	_tmp7_ = _tmp4_;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (zeitgeist_utils_DATA_PATH);
	zeitgeist_utils_DATA_PATH = _tmp8_;
	_tmp9_ = zeitgeist_utils_DATA_PATH;
	_tmp10_ = g_file_test (_tmp9_, G_FILE_TEST_IS_DIR);
	if (!_tmp10_) {
		const gchar* _tmp11_;
		_tmp11_ = zeitgeist_utils_DATA_PATH;
		g_mkdir_with_parents (_tmp11_, 0755);
	}
	_tmp12_ = zeitgeist_utils_DATA_PATH;
	g_debug ("utils.vala:59: DATA_PATH = %s", _tmp12_);
	_tmp13_ = zeitgeist_utils_DATA_PATH;
	result = _tmp13_;
	_g_free0 (_tmp4_);
	return result;
}


gchar* zeitgeist_utils_get_default_data_path (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, ZEITGEIST_UTILS_DATA_FOLDER, NULL);
	result = _tmp1_;
	return result;
}


const gchar* zeitgeist_utils_get_database_file_path (void) {
	const gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	_tmp0_ = zeitgeist_utils_DATABASE_FILE_PATH;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = zeitgeist_utils_DATABASE_FILE_PATH;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = g_getenv ("ZEITGEIST_DATABASE_PATH");
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp6_ = zeitgeist_utils_get_data_path ();
		_tmp7_ = g_build_filename (_tmp6_, ZEITGEIST_UTILS_DATABASE_BASENAME, NULL);
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp7_;
	}
	_tmp8_ = _tmp4_;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (zeitgeist_utils_DATABASE_FILE_PATH);
	zeitgeist_utils_DATABASE_FILE_PATH = _tmp9_;
	_tmp10_ = zeitgeist_utils_DATABASE_FILE_PATH;
	g_debug ("utils.vala:78: DATABASE_FILE_PATH = %s", _tmp10_);
	_tmp11_ = zeitgeist_utils_DATABASE_FILE_PATH;
	result = _tmp11_;
	_g_free0 (_tmp4_);
	return result;
}


const gchar* zeitgeist_utils_get_database_file_backup_path (void) {
	const gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	_tmp0_ = zeitgeist_utils_DATABASE_FILE_BACKUP_PATH;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = zeitgeist_utils_DATABASE_FILE_BACKUP_PATH;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = g_getenv ("ZEITGEIST_DATABASE_BACKUP_PATH");
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp6_ = zeitgeist_utils_get_data_path ();
		_tmp7_ = g_build_filename (_tmp6_, ZEITGEIST_UTILS_DATABASE_BASENAME ".bck", NULL);
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp7_;
	}
	_tmp8_ = _tmp4_;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (zeitgeist_utils_DATABASE_FILE_BACKUP_PATH);
	zeitgeist_utils_DATABASE_FILE_BACKUP_PATH = _tmp9_;
	_tmp10_ = zeitgeist_utils_DATABASE_FILE_BACKUP_PATH;
	g_debug ("utils.vala:93: DATABASE_FILE_BACKUP_PATH = %s", _tmp10_);
	_tmp11_ = zeitgeist_utils_DATABASE_FILE_BACKUP_PATH;
	result = _tmp11_;
	_g_free0 (_tmp4_);
	return result;
}


gchar* zeitgeist_utils_get_database_file_retire_name (void) {
	gchar* result = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = g_date_time_new_now_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_format (_tmp1_, "%Y%m%d-%H%M%S");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf (".%s.bck", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (ZEITGEIST_UTILS_DATABASE_BASENAME, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_date_time_unref0 (_tmp1_);
	result = _tmp7_;
	return result;
}


const gchar* zeitgeist_utils_get_local_extensions_path (void) {
	const gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	_tmp0_ = zeitgeist_utils_LOCAL_EXTENSIONS_PATH;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = zeitgeist_utils_LOCAL_EXTENSIONS_PATH;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = zeitgeist_utils_get_data_path ();
	_tmp3_ = g_build_filename (_tmp2_, "extensions", NULL);
	_g_free0 (zeitgeist_utils_LOCAL_EXTENSIONS_PATH);
	zeitgeist_utils_LOCAL_EXTENSIONS_PATH = _tmp3_;
	_tmp4_ = zeitgeist_utils_LOCAL_EXTENSIONS_PATH;
	g_debug ("utils.vala:111: LOCAL_EXTENSIONS_PATH = %s", _tmp4_);
	_tmp5_ = zeitgeist_utils_LOCAL_EXTENSIONS_PATH;
	result = _tmp5_;
	return result;
}


gboolean zeitgeist_utils_using_in_memory_database (void) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = zeitgeist_utils_get_database_file_path ();
	result = g_strcmp0 (_tmp0_, ":memory:") == 0;
	return result;
}


void zeitgeist_utils_backup_database (GError** error) {
	GFile* original = NULL;
	GFile* destination = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = zeitgeist_utils_get_database_file_path ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_g_object_unref0 (original);
	original = _tmp1_;
	_tmp2_ = zeitgeist_utils_get_database_file_backup_path ();
	_tmp3_ = g_file_new_for_path (_tmp2_);
	_g_object_unref0 (destination);
	destination = _tmp3_;
	_tmp4_ = zeitgeist_utils_get_database_file_backup_path ();
	g_message ("utils.vala:128: Backing up database to \"%s\" for schema upgrade...", _tmp4_);
	g_file_copy (original, destination, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (destination);
		_g_object_unref0 (original);
		return;
	}
	_g_object_unref0 (destination);
	_g_object_unref0 (original);
}


void zeitgeist_utils_retire_database (GError** error) {
	GError * _inner_error_ = NULL;
	{
		const gchar* _tmp0_ = NULL;
		GFile* _tmp1_ = NULL;
		GFile* dbfile;
		GFile* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_;
		_tmp0_ = zeitgeist_utils_get_database_file_path ();
		_tmp1_ = g_file_new_for_path (_tmp0_);
		dbfile = _tmp1_;
		_tmp2_ = dbfile;
		_tmp3_ = zeitgeist_utils_get_database_file_retire_name ();
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_set_display_name (_tmp2_, _tmp4_, NULL, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp6_);
		_g_free0 (_tmp4_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dbfile);
			goto __catch19_g_error;
		}
		_g_object_unref0 (dbfile);
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* message;
		const gchar* _tmp10_;
		GError* _tmp11_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = g_strdup_printf ("Could not rename database: %s", _tmp8_);
		message = _tmp9_;
		_tmp10_ = message;
		_tmp11_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_RETIRE_FAILED, _tmp10_);
		_inner_error_ = _tmp11_;
		_g_free0 (message);
		_g_error_free0 (err);
		goto __finally19;
	}
	__finally19:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
         * Check if the value starts with the negation operator. If it does,
         * remove the operator from the value and return true. Otherwise,
         * return false.
         */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


gboolean zeitgeist_utils_parse_negation (gchar** val) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (*val != NULL, FALSE);
	_tmp0_ = *val;
	_tmp1_ = g_str_has_prefix (_tmp0_, "!");
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *val;
	_tmp3_ = string_substring (_tmp2_, (glong) 1, (glong) (-1));
	_g_free0 (*val);
	*val = _tmp3_;
	result = TRUE;
	return result;
}


/**
         * Check if the value starts with the noexpand operator. If it does,
         * remove the operator from the value and return true. Otherwise,
         * return false.
         *
         * Check for the negation operator before calling this function.
         */
gboolean zeitgeist_utils_parse_noexpand (gchar** val) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (*val != NULL, FALSE);
	_tmp0_ = *val;
	_tmp1_ = g_str_has_prefix (_tmp0_, "+");
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *val;
	_tmp3_ = string_substring (_tmp2_, (glong) 1, (glong) (-1));
	_g_free0 (*val);
	*val = _tmp3_;
	result = TRUE;
	return result;
}


/**
         * Check if the value ends with the wildcard character. If it does,
         * remove the wildcard character from the value and return true.
         * Otherwise, return false.
         */
static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


gboolean zeitgeist_utils_parse_wildcard (gchar** val) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* val_data;
	gint val_data_length1;
	gint _val_data_size_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8 _tmp7_;
	g_return_val_if_fail (*val != NULL, FALSE);
	_tmp0_ = *val;
	_tmp1_ = g_str_has_suffix (_tmp0_, "*");
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *val;
	_tmp3_ = string_get_data (_tmp2_, &_tmp3__length1);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	val_data = _tmp4_;
	val_data_length1 = _tmp4__length1;
	_val_data_size_ = val_data_length1;
	_tmp5_ = val_data;
	_tmp5__length1 = val_data_length1;
	_tmp6_ = val_data;
	_tmp6__length1 = val_data_length1;
	_tmp5_[_tmp6__length1 - 1] = (guint8) '\0';
	_tmp7_ = _tmp5_[_tmp6__length1 - 1];
	result = TRUE;
	return result;
}


/**
         * Return true if a string is empty (null or containing just a null
         * byte).
         */
gboolean zeitgeist_utils_is_empty_string (const gchar* s) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	_tmp1_ = s;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = s;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
	}
	_tmp3_ = _tmp0_;
	result = _tmp3_;
	return result;
}



